// AUTOGENERATED FROM index-euc-kr.txt, ORIGINAL COMMENT FOLLOWS:
//
// Any copyright is dedicated to the Public Domain.
// https://creativecommons.org/publicdomain/zero/1.0/
//
// For details on index index-euc-kr.txt see the Encoding Standard
// https://encoding.spec.whatwg.org/
//
// Identifier: 1d97134cbf187263585bc8f593ca4196654ed4c7a673f5672eaad4f5d9fdc4ba
// Date: 2016-01-20

#[allow(dead_code)] const X: u16 = 0xffff;

fn premap_forward(code: u16) -> u16 {
    let r = code / 190;
    let c = code % 190;
    if c >= 96 {
        let dr = match r {
            0...43 => 0,
            44...46 => return X,
            47...71 => 3,
            72 => return X,
            73...124 => 4,
            _ => return X,
        };
        (r - dr) * (190 - 96) + (c - 96)
    } else {
        let dc = match c {
            0...25 => 0,
            26...31 => return X,
            32...57 => 6,
            58...63 => return X,
            _ => 12,
        };
        (125 - 4) * (190 - 96) + r * (96 - 12) + (c - dc)
    }
}

#[cfg(feature = "no-optimized-legacy-encoding")]
fn premap_backward(code: u16) -> u16 {
    if code < (125 - 4) * (190 - 96) {
        let r = code / (190 - 96);
        let c = code % (190 - 96);
        let dr = match r {
            0...43 => 0,
            44...68 => 3,
            _ => 4,
        };
        (r + dr) * 190 + (c + 96)
    } else if code < X {
        let code = code - (125 - 4) * (190 - 96);
        let r = code / (96 - 12);
        let c = code % (96 - 12);
        let dc = match c {
            0...25 => 0,
            26...51 => 6,
            _ => 12,
        };
        r * 190 + (c + dc)
    } else {
        X
    }
}

const FORWARD_TABLE: &'static [u16] = &[
    44158, 44159, 44162, 44167, 44168, 44173, 44174, 44175, 44177, 44178,
    44179, 44181, 44182, 44183, 44184, 44185, 44186, 44187, 44190, 44194,
    44195, 44196, 44197, 44198, 44199, 44203, 44205, 44206, 44209, 44210,
    44211, 44212, 44213, 44214, 44215, 44218, 44222, 44223, 44224, 44226,
    44227, 44229, 44230, 44231, 44233, 44234, 44235, 44237, 44238, 44239,
    44240, 44241, 44242, 44243, 44244, 44246, 44248, 44249, 44250, 44251,
    44252, 44253, 44254, 44255, 44258, 44259, 44261, 44262, 44265, 44267,
    44269, 44270, 44274, 44276, 44279, 44280, 44281, 44282, 44283, 44286,
    44287, 44289, 44290, 44291, 44293, 44295, 44296, 44297, 44298, 44299,
    44302, 44304, 44306, 44307, 44426, 44427, 44429, 44430, 44431, 44433,
    44434, 44435, 44436, 44437, 44438, 44439, 44440, 44441, 44442, 44443,
    44446, 44447, 44448, 44449, 44450, 44451, 44453, 44454, 44455, 44456,
    44457, 44458, 44459, 44460, 44461, 44462, 44463, 44464, 44465, 44466,
    44467, 44468, 44469, 44470, 44472, 44473, 44474, 44475, 44476, 44477,
    44478, 44479, 44482, 44483, 44485, 44486, 44487, 44489, 44490, 44491,
    44492, 44493, 44494, 44495, 44498, 44500, 44501, 44502, 44503, 44504,
    44505, 44506, 44507, 44509, 44510, 44511, 44513, 44514, 44515, 44517,
    44518, 44519, 44520, 44521, 44522, 44523, 44524, 44525, 44526, 44527,
    44528, 44529, 44530, 44531, 44532, 44533, 44534, 44535, 44659, 44660,
    44661, 44662, 44663, 44666, 44670, 44671, 44672, 44673, 44674, 44675,
    44678, 44679, 44680, 44681, 44682, 44683, 44685, 44686, 44687, 44688,
    44689, 44690, 44691, 44692, 44693, 44694, 44695, 44696, 44697, 44698,
    44699, 44700, 44701, 44702, 44703, 44704, 44705, 44706, 44707, 44708,
    44709, 44710, 44711, 44712, 44713, 44714, 44715, 44716, 44717, 44718,
    44719, 44720, 44721, 44722, 44723, 44724, 44725, 44726, 44727, 44728,
    44729, 44730, 44731, 44735, 44737, 44738, 44739, 44741, 44742, 44743,
    44744, 44745, 44746, 44747, 44750, 44754, 44755, 44756, 44757, 44758,
    44759, 44762, 44763, 44765, 44766, 44767, 44768, 44769, 44770, 44771,
    44772, 44773, 44882, 44883, 44884, 44885, 44886, 44887, 44888, 44889,
    44890, 44891, 44894, 44895, 44896, 44897, 44898, 44899, 44902, 44903,
    44904, 44905, 44906, 44907, 44908, 44909, 44910, 44911, 44912, 44913,
    44914, 44915, 44916, 44917, 44918, 44919, 44920, 44922, 44923, 44924,
    44925, 44926, 44927, 44929, 44930, 44931, 44933, 44934, 44935, 44937,
    44938, 44939, 44940, 44941, 44942, 44943, 44946, 44947, 44948, 44950,
    44951, 44952, 44953, 44954, 44955, 44957, 44958, 44959, 44960, 44961,
    44962, 44963, 44964, 44965, 44966, 44967, 44968, 44969, 44970, 44971,
    44972, 44973, 44974, 44975, 44976, 44977, 44978, 44979, 44980, 44981,
    44982, 44983, 44986, 44987, 44989, 44990, 45099, 45100, 45101, 45102,
    45103, 45104, 45105, 45106, 45107, 45108, 45109, 45110, 45111, 45112,
    45113, 45114, 45115, 45116, 45117, 45118, 45119, 45120, 45121, 45122,
    45123, 45126, 45127, 45129, 45131, 45133, 45135, 45136, 45137, 45138,
    45142, 45144, 45146, 45147, 45148, 45150, 45151, 45152, 45153, 45154,
    45155, 45156, 45157, 45158, 45159, 45160, 45161, 45162, 45163, 45164,
    45165, 45166, 45167, 45168, 45169, 45170, 45171, 45172, 45173, 45174,
    45175, 45176, 45177, 45178, 45179, 45182, 45183, 45185, 45186, 45187,
    45189, 45190, 45191, 45192, 45193, 45194, 45195, 45198, 45200, 45202,
    45203, 45204, 45205, 45206, 45207, 45211, 45213, 45214, 45219, 45220,
    45338, 45342, 45343, 45344, 45345, 45346, 45350, 45351, 45353, 45354,
    45355, 45357, 45358, 45359, 45360, 45361, 45362, 45363, 45366, 45370,
    45371, 45372, 45373, 45374, 45375, 45378, 45379, 45381, 45382, 45383,
    45385, 45386, 45387, 45388, 45389, 45390, 45391, 45394, 45395, 45398,
    45399, 45401, 45402, 45403, 45405, 45406, 45407, 45409, 45410, 45411,
    45412, 45413, 45414, 45415, 45416, 45417, 45418, 45419, 45420, 45421,
    45422, 45423, 45424, 45425, 45426, 45427, 45428, 45429, 45430, 45431,
    45434, 45435, 45437, 45438, 45439, 45441, 45443, 45444, 45445, 45446,
    45447, 45450, 45452, 45454, 45455, 45456, 45457, 45461, 45462, 45463,
    45465, 45466, 45467, 45469, 45568, 45569, 45570, 45571, 45574, 45575,
    45577, 45578, 45581, 45582, 45583, 45584, 45585, 45586, 45587, 45590,
    45592, 45594, 45595, 45596, 45597, 45598, 45599, 45601, 45602, 45603,
    45604, 45605, 45606, 45607, 45608, 45609, 45610, 45611, 45612, 45613,
    45614, 45615, 45616, 45617, 45618, 45619, 45621, 45622, 45623, 45624,
    45625, 45626, 45627, 45629, 45630, 45631, 45632, 45633, 45634, 45635,
    45636, 45637, 45638, 45639, 45640, 45641, 45642, 45643, 45644, 45645,
    45646, 45647, 45648, 45649, 45650, 45651, 45652, 45653, 45654, 45655,
    45657, 45658, 45659, 45661, 45662, 45663, 45665, 45666, 45667, 45668,
    45669, 45670, 45671, 45674, 45675, 45676, 45677, 45678, 45793, 45795,
    45799, 45801, 45802, 45808, 45809, 45810, 45814, 45820, 45821, 45822,
    45826, 45827, 45829, 45830, 45831, 45833, 45834, 45835, 45836, 45837,
    45838, 45839, 45842, 45846, 45847, 45848, 45849, 45850, 45851, 45853,
    45854, 45855, 45856, 45857, 45858, 45859, 45860, 45861, 45862, 45863,
    45864, 45865, 45866, 45867, 45868, 45869, 45870, 45871, 45872, 45873,
    45874, 45875, 45876, 45877, 45878, 45879, 45880, 45881, 45882, 45883,
    45884, 45885, 45886, 45887, 45888, 45889, 45890, 45891, 45892, 45893,
    45894, 45895, 45896, 45897, 45898, 45899, 45900, 45901, 45902, 45903,
    45904, 45905, 45906, 45907, 45911, 45913, 45914, 45917, 45920, 45921,
    45922, 45923, 46040, 46042, 46044, 46046, 46047, 46049, 46050, 46051,
    46053, 46054, 46055, 46057, 46058, 46059, 46060, 46061, 46062, 46063,
    46064, 46065, 46066, 46067, 46068, 46069, 46070, 46071, 46072, 46073,
    46074, 46075, 46077, 46078, 46079, 46080, 46081, 46082, 46083, 46084,
    46085, 46086, 46087, 46088, 46089, 46090, 46091, 46092, 46093, 46094,
    46095, 46097, 46098, 46099, 46100, 46101, 46102, 46103, 46105, 46106,
    46107, 46109, 46110, 46111, 46113, 46114, 46115, 46116, 46117, 46118,
    46119, 46122, 46124, 46125, 46126, 46127, 46128, 46129, 46130, 46131,
    46133, 46134, 46135, 46136, 46137, 46138, 46139, 46140, 46141, 46142,
    46143, 46144, 46145, 46146, 46147, 46148, 46246, 46247, 46249, 46250,
    46251, 46253, 46254, 46255, 46256, 46257, 46258, 46259, 46260, 46262,
    46264, 46266, 46267, 46268, 46269, 46270, 46271, 46273, 46274, 46275,
    46277, 46278, 46279, 46281, 46282, 46283, 46284, 46285, 46286, 46287,
    46289, 46290, 46291, 46292, 46294, 46295, 46296, 46297, 46298, 46299,
    46302, 46303, 46305, 46306, 46309, 46311, 46312, 46313, 46314, 46315,
    46318, 46320, 46322, 46323, 46324, 46325, 46326, 46327, 46329, 46330,
    46331, 46332, 46333, 46334, 46335, 46336, 46337, 46338, 46339, 46340,
    46341, 46342, 46343, 46344, 46345, 46346, 46347, 46348, 46349, 46350,
    46351, 46352, 46353, 46354, 46355, 46358, 46359, 46361, 46362, 46365,
    46475, 46476, 46477, 46478, 46479, 46480, 46481, 46482, 46483, 46484,
    46485, 46486, 46487, 46488, 46489, 46490, 46491, 46492, 46493, 46494,
    46495, 46498, 46499, 46501, 46502, 46503, 46505, 46508, 46509, 46510,
    46511, 46514, 46518, 46519, 46520, 46521, 46522, 46526, 46527, 46529,
    46530, 46531, 46533, 46534, 46535, 46536, 46537, 46538, 46539, 46542,
    46546, 46547, 46548, 46549, 46550, 46551, 46553, 46554, 46555, 46556,
    46557, 46558, 46559, 46560, 46561, 46562, 46563, 46564, 46565, 46566,
    46567, 46568, 46569, 46570, 46571, 46573, 46574, 46575, 46576, 46577,
    46578, 46579, 46580, 46581, 46582, 46583, 46584, 46585, 46586, 46587,
    46588, 46589, 46590, 46591, 46684, 46685, 46686, 46687, 46688, 46689,
    46690, 46691, 46693, 46694, 46695, 46697, 46698, 46699, 46700, 46701,
    46702, 46703, 46704, 46705, 46706, 46707, 46708, 46709, 46710, 46711,
    46712, 46713, 46714, 46715, 46716, 46717, 46718, 46719, 46720, 46721,
    46722, 46723, 46724, 46725, 46726, 46727, 46728, 46729, 46730, 46731,
    46732, 46733, 46734, 46735, 46736, 46737, 46738, 46739, 46740, 46741,
    46742, 46743, 46744, 46745, 46746, 46747, 46750, 46751, 46753, 46754,
    46755, 46757, 46758, 46759, 46760, 46761, 46762, 46765, 46766, 46767,
    46768, 46770, 46771, 46772, 46773, 46774, 46775, 46776, 46777, 46778,
    46779, 46780, 46781, 46782, 46783, 46784, 46785, 46786, 46878, 46879,
    46880, 46881, 46882, 46883, 46884, 46885, 46886, 46887, 46890, 46891,
    46893, 46894, 46897, 46898, 46899, 46900, 46901, 46902, 46903, 46906,
    46908, 46909, 46910, 46911, 46912, 46913, 46914, 46915, 46917, 46918,
    46919, 46921, 46922, 46923, 46925, 46926, 46927, 46928, 46929, 46930,
    46931, 46934, 46935, 46936, 46937, 46938, 46939, 46940, 46941, 46942,
    46943, 46945, 46946, 46947, 46949, 46950, 46951, 46953, 46954, 46955,
    46956, 46957, 46958, 46959, 46962, 46964, 46966, 46967, 46968, 46969,
    46970, 46971, 46974, 46975, 46977, 46978, 46979, 46981, 46982, 46983,
    46984, 46985, 46986, 46987, 46990, 46995, 46996, 46997, 47002, 47003,
    47005, 47006, 47114, 47115, 47117, 47118, 47119, 47121, 47122, 47123,
    47124, 47125, 47126, 47127, 47130, 47132, 47134, 47135, 47136, 47137,
    47138, 47139, 47142, 47143, 47145, 47146, 47147, 47149, 47150, 47151,
    47152, 47153, 47154, 47155, 47158, 47162, 47163, 47164, 47165, 47166,
    47167, 47169, 47170, 47171, 47173, 47174, 47175, 47176, 47177, 47178,
    47179, 47180, 47181, 47182, 47183, 47184, 47186, 47188, 47189, 47190,
    47191, 47192, 47193, 47194, 47195, 47198, 47199, 47201, 47202, 47203,
    47205, 47206, 47207, 47208, 47209, 47210, 47211, 47214, 47216, 47218,
    47219, 47220, 47221, 47222, 47223, 47225, 47226, 47227, 47229, 47230,
    47231, 47232, 47233, 47234, 47235, 47236, 47338, 47339, 47341, 47342,
    47343, 47345, 47346, 47347, 47348, 47349, 47350, 47351, 47354, 47356,
    47358, 47359, 47360, 47361, 47362, 47363, 47365, 47366, 47367, 47368,
    47369, 47370, 47371, 47372, 47373, 47374, 47375, 47376, 47377, 47378,
    47379, 47380, 47381, 47382, 47383, 47385, 47386, 47387, 47388, 47389,
    47390, 47391, 47393, 47394, 47395, 47396, 47397, 47398, 47399, 47400,
    47401, 47402, 47403, 47404, 47405, 47406, 47407, 47408, 47409, 47410,
    47411, 47412, 47413, 47414, 47415, 47416, 47417, 47418, 47419, 47422,
    47423, 47425, 47426, 47427, 47429, 47430, 47431, 47432, 47433, 47434,
    47435, 47437, 47438, 47440, 47442, 47443, 47444, 47445, 47446, 47447,
    47559, 47562, 47563, 47565, 47571, 47572, 47573, 47574, 47575, 47578,
    47580, 47583, 47584, 47586, 47590, 47591, 47593, 47594, 47595, 47597,
    47598, 47599, 47600, 47601, 47602, 47603, 47606, 47611, 47612, 47613,
    47614, 47615, 47618, 47619, 47620, 47621, 47622, 47623, 47625, 47626,
    47627, 47628, 47629, 47630, 47631, 47632, 47633, 47634, 47635, 47636,
    47638, 47639, 47640, 47641, 47642, 47643, 47644, 47645, 47646, 47647,
    47648, 47649, 47650, 47651, 47652, 47653, 47654, 47655, 47656, 47657,
    47658, 47659, 47660, 47661, 47662, 47663, 47664, 47665, 47666, 47667,
    47668, 47669, 47670, 47671, 47674, 47675, 47677, 47678, 47679, 47681,
    47683, 47684, 47685, 47686, 47804, 47806, 47807, 47808, 47809, 47810,
    47811, 47813, 47814, 47815, 47817, 47818, 47819, 47820, 47821, 47822,
    47823, 47824, 47825, 47826, 47827, 47828, 47829, 47830, 47831, 47834,
    47835, 47836, 47837, 47838, 47839, 47840, 47841, 47842, 47843, 47844,
    47845, 47846, 47847, 47848, 47849, 47850, 47851, 47852, 47853, 47854,
    47855, 47856, 47857, 47858, 47859, 47860, 47861, 47862, 47863, 47864,
    47865, 47866, 47867, 47869, 47870, 47871, 47873, 47874, 47875, 47877,
    47878, 47879, 47880, 47881, 47882, 47883, 47884, 47886, 47888, 47890,
    47891, 47892, 47893, 47894, 47895, 47897, 47898, 47899, 47901, 47902,
    47903, 47905, 47906, 47907, 47908, 47909, 47910, 47911, 48021, 48022,
    48023, 48024, 48025, 48026, 48027, 48028, 48029, 48030, 48031, 48032,
    48033, 48034, 48035, 48037, 48038, 48039, 48041, 48042, 48043, 48045,
    48046, 48047, 48048, 48049, 48050, 48051, 48053, 48054, 48056, 48057,
    48058, 48059, 48060, 48061, 48062, 48063, 48065, 48066, 48067, 48069,
    48070, 48071, 48073, 48074, 48075, 48076, 48077, 48078, 48079, 48081,
    48082, 48084, 48085, 48086, 48087, 48088, 48089, 48090, 48091, 48092,
    48093, 48094, 48095, 48096, 48097, 48098, 48099, 48100, 48101, 48102,
    48103, 48104, 48105, 48106, 48107, 48108, 48109, 48110, 48111, 48112,
    48113, 48114, 48115, 48116, 48117, 48118, 48119, 48122, 48123, 48125,
    48126, 48129, 48251, 48252, 48253, 48254, 48255, 48256, 48257, 48258,
    48259, 48262, 48263, 48265, 48266, 48269, 48271, 48272, 48273, 48274,
    48275, 48278, 48280, 48283, 48284, 48285, 48286, 48287, 48290, 48291,
    48293, 48294, 48297, 48298, 48299, 48300, 48301, 48302, 48303, 48306,
    48310, 48311, 48312, 48313, 48314, 48315, 48318, 48319, 48321, 48322,
    48323, 48325, 48326, 48327, 48328, 48329, 48330, 48331, 48332, 48334,
    48338, 48339, 48340, 48342, 48343, 48345, 48346, 48347, 48349, 48350,
    48351, 48352, 48353, 48354, 48355, 48356, 48357, 48358, 48359, 48360,
    48361, 48362, 48363, 48364, 48365, 48366, 48367, 48368, 48369, 48370,
    48371, 48375, 48377, 48378, 48379, 48381, 48481, 48482, 48483, 48485,
    48486, 48487, 48489, 48490, 48491, 48492, 48493, 48494, 48495, 48496,
    48497, 48498, 48499, 48500, 48501, 48502, 48503, 48504, 48505, 48506,
    48507, 48508, 48509, 48510, 48511, 48514, 48515, 48517, 48518, 48523,
    48524, 48525, 48526, 48527, 48530, 48532, 48534, 48535, 48536, 48539,
    48541, 48542, 48543, 48544, 48545, 48546, 48547, 48549, 48550, 48551,
    48552, 48553, 48554, 48555, 48556, 48557, 48558, 48559, 48561, 48562,
    48563, 48564, 48565, 48566, 48567, 48569, 48570, 48571, 48572, 48573,
    48574, 48575, 48576, 48577, 48578, 48579, 48580, 48581, 48582, 48583,
    48584, 48585, 48586, 48587, 48588, 48589, 48590, 48591, 48592, 48593,
    48696, 48697, 48698, 48699, 48700, 48701, 48702, 48703, 48704, 48705,
    48706, 48707, 48710, 48711, 48713, 48714, 48715, 48717, 48719, 48720,
    48721, 48722, 48723, 48726, 48728, 48732, 48733, 48734, 48735, 48738,
    48739, 48741, 48742, 48743, 48745, 48747, 48748, 48749, 48750, 48751,
    48754, 48758, 48759, 48760, 48761, 48762, 48766, 48767, 48769, 48770,
    48771, 48773, 48774, 48775, 48776, 48777, 48778, 48779, 48782, 48786,
    48787, 48788, 48789, 48790, 48791, 48794, 48795, 48796, 48797, 48798,
    48799, 48800, 48801, 48802, 48803, 48804, 48805, 48806, 48807, 48809,
    48810, 48811, 48812, 48813, 48814, 48815, 48816, 48817, 48818, 48819,
    48820, 48821, 48822, 48823, 48926, 48927, 48928, 48929, 48930, 48931,
    48932, 48933, 48934, 48935, 48936, 48937, 48938, 48939, 48940, 48941,
    48942, 48943, 48944, 48945, 48946, 48947, 48948, 48949, 48950, 48951,
    48952, 48953, 48954, 48955, 48956, 48957, 48958, 48959, 48962, 48963,
    48965, 48966, 48967, 48969, 48970, 48971, 48972, 48973, 48974, 48975,
    48978, 48979, 48980, 48982, 48983, 48984, 48985, 48986, 48987, 48988,
    48989, 48990, 48991, 48992, 48993, 48994, 48995, 48996, 48997, 48998,
    48999, 49000, 49001, 49002, 49003, 49004, 49005, 49006, 49007, 49008,
    49009, 49010, 49011, 49012, 49013, 49014, 49015, 49016, 49017, 49018,
    49019, 49020, 49021, 49022, 49023, 49024, 49025, 49026, 49120, 49122,
    49123, 49124, 49125, 49126, 49127, 49128, 49129, 49130, 49131, 49132,
    49133, 49134, 49135, 49136, 49137, 49138, 49139, 49140, 49141, 49142,
    49143, 49144, 49145, 49146, 49147, 49148, 49149, 49150, 49151, 49152,
    49153, 49154, 49155, 49156, 49157, 49158, 49159, 49160, 49161, 49162,
    49163, 49164, 49165, 49166, 49167, 49168, 49169, 49170, 49171, 49172,
    49173, 49174, 49175, 49176, 49177, 49178, 49179, 49180, 49181, 49182,
    49183, 49184, 49185, 49186, 49187, 49188, 49189, 49190, 49191, 49192,
    49193, 49194, 49195, 49196, 49197, 49198, 49199, 49200, 49201, 49202,
    49203, 49204, 49205, 49206, 49207, 49208, 49209, 49210, 49211, 49213,
    49214, 49215, 49310, 49311, 49314, 49316, 49318, 49319, 49320, 49321,
    49322, 49323, 49326, 49329, 49330, 49335, 49336, 49337, 49338, 49339,
    49342, 49346, 49347, 49348, 49350, 49351, 49354, 49355, 49357, 49358,
    49359, 49361, 49362, 49363, 49364, 49365, 49366, 49367, 49370, 49374,
    49375, 49376, 49377, 49378, 49379, 49382, 49383, 49385, 49386, 49387,
    49389, 49390, 49391, 49392, 49393, 49394, 49395, 49398, 49400, 49402,
    49403, 49404, 49405, 49406, 49407, 49409, 49410, 49411, 49413, 49414,
    49415, 49417, 49418, 49419, 49420, 49421, 49422, 49423, 49425, 49426,
    49427, 49428, 49430, 49431, 49432, 49433, 49434, 49435, 49441, 49442,
    49445, 49448, 49449, 49450, 49451, 49454, 49578, 49579, 49581, 49582,
    49583, 49585, 49586, 49587, 49588, 49589, 49590, 49591, 49592, 49593,
    49594, 49595, 49596, 49598, 49599, 49600, 49601, 49602, 49603, 49605,
    49606, 49607, 49609, 49610, 49611, 49613, 49614, 49615, 49616, 49617,
    49618, 49619, 49621, 49622, 49625, 49626, 49627, 49628, 49629, 49630,
    49631, 49633, 49634, 49635, 49637, 49638, 49639, 49641, 49642, 49643,
    49644, 49645, 49646, 49647, 49650, 49652, 49653, 49654, 49655, 49656,
    49657, 49658, 49659, 49662, 49663, 49665, 49666, 49667, 49669, 49670,
    49671, 49672, 49673, 49674, 49675, 49678, 49680, 49682, 49683, 49684,
    49685, 49686, 49687, 49690, 49691, 49693, 49694, 49697, 49698, 49699,
    49810, 49811, 49812, 49813, 49814, 49815, 49817, 49818, 49820, 49822,
    49823, 49824, 49825, 49826, 49827, 49830, 49831, 49833, 49834, 49835,
    49838, 49839, 49840, 49841, 49842, 49843, 49846, 49848, 49850, 49851,
    49852, 49853, 49854, 49855, 49856, 49857, 49858, 49859, 49860, 49861,
    49862, 49863, 49864, 49865, 49866, 49867, 49868, 49869, 49870, 49871,
    49872, 49873, 49874, 49875, 49876, 49877, 49878, 49879, 49880, 49881,
    49882, 49883, 49886, 49887, 49889, 49890, 49893, 49894, 49895, 49896,
    49897, 49898, 49902, 49904, 49906, 49907, 49908, 49909, 49911, 49914,
    49917, 49918, 49919, 49921, 49922, 49923, 49924, 49925, 49926, 49927,
    49930, 49931, 49934, 49935, 50035, 50036, 50037, 50038, 50039, 50042,
    50043, 50046, 50047, 50048, 50049, 50050, 50051, 50053, 50054, 50055,
    50057, 50058, 50059, 50061, 50062, 50063, 50064, 50065, 50066, 50067,
    50068, 50069, 50070, 50071, 50072, 50073, 50074, 50075, 50076, 50077,
    50078, 50079, 50080, 50081, 50082, 50083, 50084, 50085, 50086, 50087,
    50088, 50089, 50090, 50091, 50092, 50093, 50094, 50095, 50096, 50097,
    50098, 50099, 50100, 50101, 50102, 50103, 50104, 50105, 50106, 50107,
    50108, 50109, 50110, 50111, 50113, 50114, 50115, 50116, 50117, 50118,
    50119, 50120, 50121, 50122, 50123, 50124, 50125, 50126, 50127, 50128,
    50129, 50130, 50131, 50132, 50133, 50134, 50135, 50138, 50241, 50242,
    50243, 50244, 50245, 50246, 50247, 50249, 50250, 50251, 50252, 50253,
    50254, 50255, 50256, 50257, 50258, 50259, 50260, 50261, 50262, 50263,
    50264, 50265, 50266, 50267, 50268, 50269, 50270, 50271, 50272, 50273,
    50274, 50275, 50278, 50279, 50281, 50282, 50283, 50285, 50286, 50287,
    50288, 50289, 50290, 50291, 50294, 50295, 50296, 50298, 50299, 50300,
    50301, 50302, 50303, 50305, 50306, 50307, 50308, 50309, 50310, 50311,
    50312, 50313, 50314, 50315, 50316, 50317, 50318, 50319, 50320, 50321,
    50322, 50323, 50325, 50326, 50327, 50328, 50329, 50330, 50331, 50333,
    50334, 50335, 50336, 50337, 50338, 50339, 50340, 50341, 50342, 50343,
    50344, 50345, 50441, 50442, 50443, 50445, 50446, 50447, 50449, 50450,
    50451, 50453, 50454, 50455, 50456, 50457, 50458, 50459, 50461, 50462,
    50463, 50464, 50465, 50466, 50467, 50468, 50469, 50470, 50471, 50474,
    50475, 50477, 50478, 50479, 50481, 50482, 50483, 50484, 50485, 50486,
    50487, 50490, 50492, 50494, 50495, 50496, 50497, 50498, 50499, 50502,
    50503, 50507, 50511, 50512, 50513, 50514, 50518, 50522, 50523, 50524,
    50527, 50530, 50531, 50533, 50534, 50535, 50537, 50538, 50539, 50540,
    50541, 50542, 50543, 50546, 50550, 50551, 50552, 50553, 50554, 50555,
    50558, 50559, 50561, 50562, 50563, 50565, 50566, 50568, 50569, 50570,
    50571, 50574, 50576, 50578, 50579, 50580, 50719, 50720, 50721, 50722,
    50723, 50726, 50727, 50729, 50730, 50731, 50735, 50737, 50738, 50742,
    50744, 50746, 50748, 50749, 50750, 50751, 50754, 50755, 50757, 50758,
    50759, 50761, 50762, 50763, 50764, 50765, 50766, 50767, 50770, 50774,
    50775, 50776, 50777, 50778, 50779, 50782, 50783, 50785, 50786, 50787,
    50788, 50789, 50790, 50791, 50792, 50793, 50794, 50795, 50797, 50798,
    50800, 50802, 50803, 50804, 50805, 50806, 50807, 50810, 50811, 50813,
    50814, 50815, 50817, 50818, 50819, 50820, 50821, 50822, 50823, 50826,
    50828, 50830, 50831, 50832, 50833, 50834, 50835, 50838, 50839, 50841,
    50842, 50843, 50845, 50846, 50847, 50848, 50849, 50850, 50851, 50854,
    50974, 50975, 50978, 50979, 50981, 50982, 50983, 50985, 50986, 50987,
    50988, 50989, 50990, 50991, 50994, 50996, 50998, 51000, 51001, 51002,
    51003, 51006, 51007, 51009, 51010, 51011, 51013, 51014, 51015, 51016,
    51017, 51019, 51022, 51024, 51033, 51034, 51035, 51037, 51038, 51039,
    51041, 51042, 51043, 51044, 51045, 51046, 51047, 51049, 51050, 51052,
    51053, 51054, 51055, 51056, 51057, 51058, 51059, 51062, 51063, 51065,
    51066, 51067, 51071, 51072, 51073, 51074, 51078, 51083, 51084, 51085,
    51087, 51090, 51091, 51093, 51097, 51099, 51100, 51101, 51102, 51103,
    51106, 51111, 51112, 51113, 51114, 51115, 51118, 51119, 51121, 51122,
    51123, 51125, 51126, 51127, 51241, 51242, 51243, 51246, 51248, 51250,
    51251, 51252, 51253, 51254, 51255, 51257, 51258, 51259, 51261, 51262,
    51263, 51265, 51266, 51267, 51268, 51269, 51270, 51271, 51274, 51275,
    51278, 51279, 51280, 51281, 51282, 51283, 51285, 51286, 51287, 51288,
    51289, 51290, 51291, 51292, 51293, 51294, 51295, 51296, 51297, 51298,
    51299, 51300, 51301, 51302, 51303, 51304, 51305, 51306, 51307, 51308,
    51309, 51310, 51311, 51314, 51315, 51317, 51318, 51319, 51321, 51323,
    51324, 51325, 51326, 51327, 51330, 51332, 51336, 51337, 51338, 51342,
    51343, 51344, 51345, 51346, 51347, 51349, 51350, 51351, 51352, 51353,
    51354, 51355, 51356, 51358, 51360, 51362, 51363, 51364, 12288, 12289,
    12290, 183, 8229, 8230, 168, 12291, 173, 8213, 8741, 65340, 8764, 8216,
    8217, 8220, 8221, 12308, 12309, 12296, 12297, 12298, 12299, 12300, 12301,
    12302, 12303, 12304, 12305, 177, 215, 247, 8800, 8804, 8805, 8734, 8756,
    176, 8242, 8243, 8451, 8491, 65504, 65505, 65509, 9794, 9792, 8736, 8869,
    8978, 8706, 8711, 8801, 8786, 167, 8251, 9734, 9733, 9675, 9679, 9678,
    9671, 9670, 9633, 9632, 9651, 9650, 9661, 9660, 8594, 8592, 8593, 8595,
    8596, 12307, 8810, 8811, 8730, 8765, 8733, 8757, 8747, 8748, 8712, 8715,
    8838, 8839, 8834, 8835, 8746, 8745, 8743, 8744, 65506, 8658, 8660, 8704,
    8707, 180, 65374, 711, 728, 733, 730, 729, 184, 731, 161, 191, 720, 8750,
    8721, 8719, 164, 8457, 8240, 9665, 9664, 9655, 9654, 9828, 9824, 9825,
    9829, 9831, 9827, 8857, 9672, 9635, 9680, 9681, 9618, 9636, 9637, 9640,
    9639, 9638, 9641, 9832, 9743, 9742, 9756, 9758, 182, 8224, 8225, 8597,
    8599, 8601, 8598, 8600, 9837, 9833, 9834, 9836, 12927, 12828, 8470, 13255,
    8482, 13250, 13272, 8481, 8364, 174, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 65281, 65282, 65283, 65284, 65285, 65286,
    65287, 65288, 65289, 65290, 65291, 65292, 65293, 65294, 65295, 65296,
    65297, 65298, 65299, 65300, 65301, 65302, 65303, 65304, 65305, 65306,
    65307, 65308, 65309, 65310, 65311, 65312, 65313, 65314, 65315, 65316,
    65317, 65318, 65319, 65320, 65321, 65322, 65323, 65324, 65325, 65326,
    65327, 65328, 65329, 65330, 65331, 65332, 65333, 65334, 65335, 65336,
    65337, 65338, 65339, 65510, 65341, 65342, 65343, 65344, 65345, 65346,
    65347, 65348, 65349, 65350, 65351, 65352, 65353, 65354, 65355, 65356,
    65357, 65358, 65359, 65360, 65361, 65362, 65363, 65364, 65365, 65366,
    65367, 65368, 65369, 65370, 65371, 65372, 65373, 65507, 12593, 12594,
    12595, 12596, 12597, 12598, 12599, 12600, 12601, 12602, 12603, 12604,
    12605, 12606, 12607, 12608, 12609, 12610, 12611, 12612, 12613, 12614,
    12615, 12616, 12617, 12618, 12619, 12620, 12621, 12622, 12623, 12624,
    12625, 12626, 12627, 12628, 12629, 12630, 12631, 12632, 12633, 12634,
    12635, 12636, 12637, 12638, 12639, 12640, 12641, 12642, 12643, 12644,
    12645, 12646, 12647, 12648, 12649, 12650, 12651, 12652, 12653, 12654,
    12655, 12656, 12657, 12658, 12659, 12660, 12661, 12662, 12663, 12664,
    12665, 12666, 12667, 12668, 12669, 12670, 12671, 12672, 12673, 12674,
    12675, 12676, 12677, 12678, 12679, 12680, 12681, 12682, 12683, 12684,
    12685, 12686, 8560, 8561, 8562, 8563, 8564, 8565, 8566, 8567, 8568, 8569,
    X, X, X, X, X, 8544, 8545, 8546, 8547, 8548, 8549, 8550, 8551, 8552, 8553,
    X, X, X, X, X, X, X, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923,
    924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, X, X, X,
    X, X, X, X, X, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956,
    957, 958, 959, 960, 961, 963, 964, 965, 966, 967, 968, 969, X, X, X, X, X,
    X, 9472, 9474, 9484, 9488, 9496, 9492, 9500, 9516, 9508, 9524, 9532, 9473,
    9475, 9487, 9491, 9499, 9495, 9507, 9523, 9515, 9531, 9547, 9504, 9519,
    9512, 9527, 9535, 9501, 9520, 9509, 9528, 9538, 9490, 9489, 9498, 9497,
    9494, 9493, 9486, 9485, 9502, 9503, 9505, 9506, 9510, 9511, 9513, 9514,
    9517, 9518, 9521, 9522, 9525, 9526, 9529, 9530, 9533, 9534, 9536, 9537,
    9539, 9540, 9541, 9542, 9543, 9544, 9545, 9546, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 13205, 13206, 13207,
    8467, 13208, 13252, 13219, 13220, 13221, 13222, 13209, 13210, 13211, 13212,
    13213, 13214, 13215, 13216, 13217, 13218, 13258, 13197, 13198, 13199,
    13263, 13192, 13193, 13256, 13223, 13224, 13232, 13233, 13234, 13235,
    13236, 13237, 13238, 13239, 13240, 13241, 13184, 13185, 13186, 13187,
    13188, 13242, 13243, 13244, 13245, 13246, 13247, 13200, 13201, 13202,
    13203, 13204, 8486, 13248, 13249, 13194, 13195, 13196, 13270, 13253, 13229,
    13230, 13231, 13275, 13225, 13226, 13227, 13228, 13277, 13264, 13267,
    13251, 13257, 13276, 13254, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    198, 208, 170, 294, X, 306, X, 319, 321, 216, 338, 186, 222, 358, 330, X,
    12896, 12897, 12898, 12899, 12900, 12901, 12902, 12903, 12904, 12905,
    12906, 12907, 12908, 12909, 12910, 12911, 12912, 12913, 12914, 12915,
    12916, 12917, 12918, 12919, 12920, 12921, 12922, 12923, 9424, 9425, 9426,
    9427, 9428, 9429, 9430, 9431, 9432, 9433, 9434, 9435, 9436, 9437, 9438,
    9439, 9440, 9441, 9442, 9443, 9444, 9445, 9446, 9447, 9448, 9449, 9312,
    9313, 9314, 9315, 9316, 9317, 9318, 9319, 9320, 9321, 9322, 9323, 9324,
    9325, 9326, 189, 8531, 8532, 188, 190, 8539, 8540, 8541, 8542, 230, 273,
    240, 295, 305, 307, 312, 320, 322, 248, 339, 223, 254, 359, 331, 329,
    12800, 12801, 12802, 12803, 12804, 12805, 12806, 12807, 12808, 12809,
    12810, 12811, 12812, 12813, 12814, 12815, 12816, 12817, 12818, 12819,
    12820, 12821, 12822, 12823, 12824, 12825, 12826, 12827, 9372, 9373, 9374,
    9375, 9376, 9377, 9378, 9379, 9380, 9381, 9382, 9383, 9384, 9385, 9386,
    9387, 9388, 9389, 9390, 9391, 9392, 9393, 9394, 9395, 9396, 9397, 9332,
    9333, 9334, 9335, 9336, 9337, 9338, 9339, 9340, 9341, 9342, 9343, 9344,
    9345, 9346, 185, 178, 179, 8308, 8319, 8321, 8322, 8323, 8324, 12353,
    12354, 12355, 12356, 12357, 12358, 12359, 12360, 12361, 12362, 12363,
    12364, 12365, 12366, 12367, 12368, 12369, 12370, 12371, 12372, 12373,
    12374, 12375, 12376, 12377, 12378, 12379, 12380, 12381, 12382, 12383,
    12384, 12385, 12386, 12387, 12388, 12389, 12390, 12391, 12392, 12393,
    12394, 12395, 12396, 12397, 12398, 12399, 12400, 12401, 12402, 12403,
    12404, 12405, 12406, 12407, 12408, 12409, 12410, 12411, 12412, 12413,
    12414, 12415, 12416, 12417, 12418, 12419, 12420, 12421, 12422, 12423,
    12424, 12425, 12426, 12427, 12428, 12429, 12430, 12431, 12432, 12433,
    12434, 12435, X, X, X, X, X, X, X, X, X, X, X, 12449, 12450, 12451, 12452,
    12453, 12454, 12455, 12456, 12457, 12458, 12459, 12460, 12461, 12462,
    12463, 12464, 12465, 12466, 12467, 12468, 12469, 12470, 12471, 12472,
    12473, 12474, 12475, 12476, 12477, 12478, 12479, 12480, 12481, 12482,
    12483, 12484, 12485, 12486, 12487, 12488, 12489, 12490, 12491, 12492,
    12493, 12494, 12495, 12496, 12497, 12498, 12499, 12500, 12501, 12502,
    12503, 12504, 12505, 12506, 12507, 12508, 12509, 12510, 12511, 12512,
    12513, 12514, 12515, 12516, 12517, 12518, 12519, 12520, 12521, 12522,
    12523, 12524, 12525, 12526, 12527, 12528, 12529, 12530, 12531, 12532,
    12533, 12534, X, X, X, X, X, X, X, X, 1040, 1041, 1042, 1043, 1044, 1045,
    1025, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056,
    1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068,
    1069, 1070, 1071, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 1072, 1073,
    1074, 1075, 1076, 1077, 1105, 1078, 1079, 1080, 1081, 1082, 1083, 1084,
    1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096,
    1097, 1098, 1099, 1100, 1101, 1102, 1103, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 44032, 44033, 44036, 44039, 44040, 44041, 44042, 44048, 44049, 44050,
    44051, 44052, 44053, 44054, 44055, 44057, 44058, 44059, 44060, 44061,
    44064, 44068, 44076, 44077, 44079, 44080, 44081, 44088, 44089, 44092,
    44096, 44107, 44109, 44116, 44120, 44124, 44144, 44145, 44148, 44151,
    44152, 44154, 44160, 44161, 44163, 44164, 44165, 44166, 44169, 44170,
    44171, 44172, 44176, 44180, 44188, 44189, 44191, 44192, 44193, 44200,
    44201, 44202, 44204, 44207, 44208, 44216, 44217, 44219, 44220, 44221,
    44225, 44228, 44232, 44236, 44245, 44247, 44256, 44257, 44260, 44263,
    44264, 44266, 44268, 44271, 44272, 44273, 44275, 44277, 44278, 44284,
    44285, 44288, 44292, 44294, 44300, 44301, 44303, 44305, 44312, 44316,
    44320, 44329, 44332, 44333, 44340, 44341, 44344, 44348, 44356, 44357,
    44359, 44361, 44368, 44372, 44376, 44385, 44387, 44396, 44397, 44400,
    44403, 44404, 44405, 44406, 44411, 44412, 44413, 44415, 44417, 44418,
    44424, 44425, 44428, 44432, 44444, 44445, 44452, 44471, 44480, 44481,
    44484, 44488, 44496, 44497, 44499, 44508, 44512, 44516, 44536, 44537,
    44540, 44543, 44544, 44545, 44552, 44553, 44555, 44557, 44564, 44592,
    44593, 44596, 44599, 44600, 44602, 44608, 44609, 44611, 44613, 44614,
    44618, 44620, 44621, 44622, 44624, 44628, 44630, 44636, 44637, 44639,
    44640, 44641, 44645, 44648, 44649, 44652, 44656, 44664, 44665, 44667,
    44668, 44669, 44676, 44677, 44684, 44732, 44733, 44734, 44736, 44740,
    44748, 44749, 44751, 44752, 44753, 44760, 44761, 44764, 44776, 44779,
    44781, 44788, 44792, 44796, 44807, 44808, 44813, 44816, 44844, 44845,
    44848, 44850, 44852, 44860, 44861, 44863, 44865, 44866, 44867, 44872,
    44873, 44880, 44892, 44893, 44900, 44901, 44921, 44928, 44932, 44936,
    44944, 44945, 44949, 44956, 44984, 44985, 44988, 44992, 44999, 45000,
    45001, 45003, 45005, 45006, 45012, 45020, 45032, 45033, 45040, 45041,
    45044, 45048, 45056, 45057, 45060, 45068, 45072, 45076, 45084, 45085,
    45096, 45124, 45125, 45128, 45130, 45132, 45134, 45139, 45140, 45141,
    45143, 45145, 45149, 45180, 45181, 45184, 45188, 45196, 45197, 45199,
    45201, 45208, 45209, 45210, 45212, 45215, 45216, 45217, 45218, 45224,
    45225, 45227, 45228, 45229, 45230, 45231, 45233, 45235, 45236, 45237,
    45240, 45244, 45252, 45253, 45255, 45256, 45257, 45264, 45265, 45268,
    45272, 45280, 45285, 45320, 45321, 45323, 45324, 45328, 45330, 45331,
    45336, 45337, 45339, 45340, 45341, 45347, 45348, 45349, 45352, 45356,
    45364, 45365, 45367, 45368, 45369, 45376, 45377, 45380, 45384, 45392,
    45393, 45396, 45397, 45400, 45404, 45408, 45432, 45433, 45436, 45440,
    45442, 45448, 45449, 45451, 45453, 45458, 45459, 45460, 45464, 45468,
    45480, 45516, 45520, 45524, 45532, 45533, 45535, 45544, 45545, 45548,
    45552, 45561, 45563, 45565, 45572, 45573, 45576, 45579, 45580, 45588,
    45589, 45591, 45593, 45600, 45620, 45628, 45656, 45660, 45664, 45672,
    45673, 45684, 45685, 45692, 45700, 45701, 45705, 45712, 45713, 45716,
    45720, 45721, 45722, 45728, 45729, 45731, 45733, 45734, 45738, 45740,
    45744, 45748, 45768, 45769, 45772, 45776, 45778, 45784, 45785, 45787,
    45789, 45794, 45796, 45797, 45798, 45800, 45803, 45804, 45805, 45806,
    45807, 45811, 45812, 45813, 45815, 45816, 45817, 45818, 45819, 45823,
    45824, 45825, 45828, 45832, 45840, 45841, 45843, 45844, 45845, 45852,
    45908, 45909, 45910, 45912, 45915, 45916, 45918, 45919, 45924, 45925,
    45927, 45929, 45931, 45934, 45936, 45937, 45940, 45944, 45952, 45953,
    45955, 45956, 45957, 45964, 45968, 45972, 45984, 45985, 45992, 45996,
    46020, 46021, 46024, 46027, 46028, 46030, 46032, 46036, 46037, 46039,
    46041, 46043, 46045, 46048, 46052, 46056, 46076, 46096, 46104, 46108,
    46112, 46120, 46121, 46123, 46132, 46160, 46161, 46164, 46168, 46176,
    46177, 46179, 46181, 46188, 46208, 46216, 46237, 46244, 46248, 46252,
    46261, 46263, 46265, 46272, 46276, 46280, 46288, 46293, 46300, 46301,
    46304, 46307, 46308, 46310, 46316, 46317, 46319, 46321, 46328, 46356,
    46357, 46360, 46363, 46364, 46372, 46373, 46375, 46376, 46377, 46378,
    46384, 46385, 46388, 46392, 46400, 46401, 46403, 46404, 46405, 46411,
    46412, 46413, 46416, 46420, 46428, 46429, 46431, 46432, 46433, 46496,
    46497, 46500, 46504, 46506, 46507, 46512, 46513, 46515, 46516, 46517,
    46523, 46524, 46525, 46528, 46532, 46540, 46541, 46543, 46544, 46545,
    46552, 46572, 46608, 46609, 46612, 46616, 46629, 46636, 46644, 46664,
    46692, 46696, 46748, 46749, 46752, 46756, 46763, 46764, 46769, 46804,
    46832, 46836, 46840, 46848, 46849, 46853, 46888, 46889, 46892, 46895,
    46896, 46904, 46905, 46907, 46916, 46920, 46924, 46932, 46933, 46944,
    46948, 46952, 46960, 46961, 46963, 46965, 46972, 46973, 46976, 46980,
    46988, 46989, 46991, 46992, 46993, 46994, 46998, 46999, 47000, 47001,
    47004, 47008, 47016, 47017, 47019, 47020, 47021, 47028, 47029, 47032,
    47047, 47049, 47084, 47085, 47088, 47092, 47100, 47101, 47103, 47104,
    47105, 47111, 47112, 47113, 47116, 47120, 47128, 47129, 47131, 47133,
    47140, 47141, 47144, 47148, 47156, 47157, 47159, 47160, 47161, 47168,
    47172, 47185, 47187, 47196, 47197, 47200, 47204, 47212, 47213, 47215,
    47217, 47224, 47228, 47245, 47272, 47280, 47284, 47288, 47296, 47297,
    47299, 47301, 47308, 47312, 47316, 47325, 47327, 47329, 47336, 47337,
    47340, 47344, 47352, 47353, 47355, 47357, 47364, 47384, 47392, 47420,
    47421, 47424, 47428, 47436, 47439, 47441, 47448, 47449, 47452, 47456,
    47464, 47465, 47467, 47469, 47476, 47477, 47480, 47484, 47492, 47493,
    47495, 47497, 47498, 47501, 47502, 47532, 47533, 47536, 47540, 47548,
    47549, 47551, 47553, 47560, 47561, 47564, 47566, 47567, 47568, 47569,
    47570, 47576, 47577, 47579, 47581, 47582, 47585, 47587, 47588, 47589,
    47592, 47596, 47604, 47605, 47607, 47608, 47609, 47610, 47616, 47617,
    47624, 47637, 47672, 47673, 47676, 47680, 47682, 47688, 47689, 47691,
    47693, 47694, 47699, 47700, 47701, 47704, 47708, 47716, 47717, 47719,
    47720, 47721, 47728, 47729, 47732, 47736, 47747, 47748, 47749, 47751,
    47756, 47784, 47785, 47787, 47788, 47792, 47794, 47800, 47801, 47803,
    47805, 47812, 47816, 47832, 47833, 47868, 47872, 47876, 47885, 47887,
    47889, 47896, 47900, 47904, 47913, 47915, 47924, 47925, 47926, 47928,
    47931, 47932, 47933, 47934, 47940, 47941, 47943, 47945, 47949, 47951,
    47952, 47956, 47960, 47969, 47971, 47980, 48008, 48012, 48016, 48036,
    48040, 48044, 48052, 48055, 48064, 48068, 48072, 48080, 48083, 48120,
    48121, 48124, 48127, 48128, 48130, 48136, 48137, 48139, 48140, 48141,
    48143, 48145, 48148, 48149, 48150, 48151, 48152, 48155, 48156, 48157,
    48158, 48159, 48164, 48165, 48167, 48169, 48173, 48176, 48177, 48180,
    48184, 48192, 48193, 48195, 48196, 48197, 48201, 48204, 48205, 48208,
    48221, 48260, 48261, 48264, 48267, 48268, 48270, 48276, 48277, 48279,
    48281, 48282, 48288, 48289, 48292, 48295, 48296, 48304, 48305, 48307,
    48308, 48309, 48316, 48317, 48320, 48324, 48333, 48335, 48336, 48337,
    48341, 48344, 48348, 48372, 48373, 48374, 48376, 48380, 48388, 48389,
    48391, 48393, 48400, 48404, 48420, 48428, 48448, 48456, 48457, 48460,
    48464, 48472, 48473, 48484, 48488, 48512, 48513, 48516, 48519, 48520,
    48521, 48522, 48528, 48529, 48531, 48533, 48537, 48538, 48540, 48548,
    48560, 48568, 48596, 48597, 48600, 48604, 48617, 48624, 48628, 48632,
    48640, 48643, 48645, 48652, 48653, 48656, 48660, 48668, 48669, 48671,
    48708, 48709, 48712, 48716, 48718, 48724, 48725, 48727, 48729, 48730,
    48731, 48736, 48737, 48740, 48744, 48746, 48752, 48753, 48755, 48756,
    48757, 48763, 48764, 48765, 48768, 48772, 48780, 48781, 48783, 48784,
    48785, 48792, 48793, 48808, 48848, 48849, 48852, 48855, 48856, 48864,
    48867, 48868, 48869, 48876, 48897, 48904, 48905, 48920, 48921, 48923,
    48924, 48925, 48960, 48961, 48964, 48968, 48976, 48977, 48981, 49044,
    49072, 49093, 49100, 49101, 49104, 49108, 49116, 49119, 49121, 49212,
    49233, 49240, 49244, 49248, 49256, 49257, 49296, 49297, 49300, 49304,
    49312, 49313, 49315, 49317, 49324, 49325, 49327, 49328, 49331, 49332,
    49333, 49334, 49340, 49341, 49343, 49344, 49345, 49349, 49352, 49353,
    49356, 49360, 49368, 49369, 49371, 49372, 49373, 49380, 49381, 49384,
    49388, 49396, 49397, 49399, 49401, 49408, 49412, 49416, 49424, 49429,
    49436, 49437, 49438, 49439, 49440, 49443, 49444, 49446, 49447, 49452,
    49453, 49455, 49456, 49457, 49462, 49464, 49465, 49468, 49472, 49480,
    49481, 49483, 49484, 49485, 49492, 49493, 49496, 49500, 49508, 49509,
    49511, 49512, 49513, 49520, 49524, 49528, 49541, 49548, 49549, 49550,
    49552, 49556, 49558, 49564, 49565, 49567, 49569, 49573, 49576, 49577,
    49580, 49584, 49597, 49604, 49608, 49612, 49620, 49623, 49624, 49632,
    49636, 49640, 49648, 49649, 49651, 49660, 49661, 49664, 49668, 49676,
    49677, 49679, 49681, 49688, 49689, 49692, 49695, 49696, 49704, 49705,
    49707, 49709, 49711, 49713, 49714, 49716, 49736, 49744, 49745, 49748,
    49752, 49760, 49765, 49772, 49773, 49776, 49780, 49788, 49789, 49791,
    49793, 49800, 49801, 49808, 49816, 49819, 49821, 49828, 49829, 49832,
    49836, 49837, 49844, 49845, 49847, 49849, 49884, 49885, 49888, 49891,
    49892, 49899, 49900, 49901, 49903, 49905, 49910, 49912, 49913, 49915,
    49916, 49920, 49928, 49929, 49932, 49933, 49939, 49940, 49941, 49944,
    49948, 49956, 49957, 49960, 49961, 49989, 50024, 50025, 50028, 50032,
    50034, 50040, 50041, 50044, 50045, 50052, 50056, 50060, 50112, 50136,
    50137, 50140, 50143, 50144, 50146, 50152, 50153, 50157, 50164, 50165,
    50168, 50184, 50192, 50212, 50220, 50224, 50228, 50236, 50237, 50248,
    50276, 50277, 50280, 50284, 50292, 50293, 50297, 50304, 50324, 50332,
    50360, 50364, 50409, 50416, 50417, 50420, 50424, 50426, 50431, 50432,
    50433, 50444, 50448, 50452, 50460, 50472, 50473, 50476, 50480, 50488,
    50489, 50491, 50493, 50500, 50501, 50504, 50505, 50506, 50508, 50509,
    50510, 50515, 50516, 50517, 50519, 50520, 50521, 50525, 50526, 50528,
    50529, 50532, 50536, 50544, 50545, 50547, 50548, 50549, 50556, 50557,
    50560, 50564, 50567, 50572, 50573, 50575, 50577, 50581, 50583, 50584,
    50588, 50592, 50601, 50612, 50613, 50616, 50617, 50619, 50620, 50621,
    50622, 50628, 50629, 50630, 50631, 50632, 50633, 50634, 50636, 50638,
    50640, 50641, 50644, 50648, 50656, 50657, 50659, 50661, 50668, 50669,
    50670, 50672, 50676, 50678, 50679, 50684, 50685, 50686, 50687, 50688,
    50689, 50693, 50694, 50695, 50696, 50700, 50704, 50712, 50713, 50715,
    50716, 50724, 50725, 50728, 50732, 50733, 50734, 50736, 50739, 50740,
    50741, 50743, 50745, 50747, 50752, 50753, 50756, 50760, 50768, 50769,
    50771, 50772, 50773, 50780, 50781, 50784, 50796, 50799, 50801, 50808,
    50809, 50812, 50816, 50824, 50825, 50827, 50829, 50836, 50837, 50840,
    50844, 50852, 50853, 50855, 50857, 50864, 50865, 50868, 50872, 50873,
    50874, 50880, 50881, 50883, 50885, 50892, 50893, 50896, 50900, 50908,
    50909, 50912, 50913, 50920, 50921, 50924, 50928, 50936, 50937, 50941,
    50948, 50949, 50952, 50956, 50964, 50965, 50967, 50969, 50976, 50977,
    50980, 50984, 50992, 50993, 50995, 50997, 50999, 51004, 51005, 51008,
    51012, 51018, 51020, 51021, 51023, 51025, 51026, 51027, 51028, 51029,
    51030, 51031, 51032, 51036, 51040, 51048, 51051, 51060, 51061, 51064,
    51068, 51069, 51070, 51075, 51076, 51077, 51079, 51080, 51081, 51082,
    51086, 51088, 51089, 51092, 51094, 51095, 51096, 51098, 51104, 51105,
    51107, 51108, 51109, 51110, 51116, 51117, 51120, 51124, 51132, 51133,
    51135, 51136, 51137, 51144, 51145, 51148, 51150, 51152, 51160, 51165,
    51172, 51176, 51180, 51200, 51201, 51204, 51208, 51210, 51216, 51217,
    51219, 51221, 51222, 51228, 51229, 51232, 51236, 51244, 51245, 51247,
    51249, 51256, 51260, 51264, 51272, 51273, 51276, 51277, 51284, 51312,
    51313, 51316, 51320, 51322, 51328, 51329, 51331, 51333, 51334, 51335,
    51339, 51340, 51341, 51348, 51357, 51359, 51361, 51368, 51388, 51389,
    51396, 51400, 51404, 51412, 51413, 51415, 51417, 51424, 51425, 51428,
    51445, 51452, 51453, 51456, 51460, 51461, 51462, 51468, 51469, 51471,
    51473, 51480, 51500, 51508, 51536, 51537, 51540, 51544, 51552, 51553,
    51555, 51564, 51568, 51572, 51580, 51592, 51593, 51596, 51600, 51608,
    51609, 51611, 51613, 51648, 51649, 51652, 51655, 51656, 51658, 51664,
    51665, 51667, 51669, 51670, 51673, 51674, 51676, 51677, 51680, 51682,
    51684, 51687, 51692, 51693, 51695, 51696, 51697, 51704, 51705, 51708,
    51712, 51720, 51721, 51723, 51724, 51725, 51732, 51736, 51753, 51788,
    51789, 51792, 51796, 51804, 51805, 51807, 51808, 51809, 51816, 51837,
    51844, 51864, 51900, 51901, 51904, 51908, 51916, 51917, 51919, 51921,
    51923, 51928, 51929, 51936, 51948, 51956, 51976, 51984, 51988, 51992,
    52000, 52001, 52033, 52040, 52041, 52044, 52048, 52056, 52057, 52061,
    52068, 52088, 52089, 52124, 52152, 52180, 52196, 52199, 52201, 52236,
    52237, 52240, 52244, 52252, 52253, 52257, 52258, 52263, 52264, 52265,
    52268, 52270, 52272, 52280, 52281, 52283, 52284, 52285, 52286, 52292,
    52293, 52296, 52300, 52308, 52309, 52311, 52312, 52313, 52320, 52324,
    52326, 52328, 52336, 52341, 52376, 52377, 52380, 52384, 52392, 52393,
    52395, 52396, 52397, 52404, 52405, 52408, 52412, 52420, 52421, 52423,
    52425, 52432, 52436, 52452, 52460, 52464, 52481, 52488, 52489, 52492,
    52496, 52504, 52505, 52507, 52509, 52516, 52520, 52524, 52537, 52572,
    52576, 52580, 52588, 52589, 52591, 52593, 52600, 52616, 52628, 52629,
    52632, 52636, 52644, 52645, 52647, 52649, 52656, 52676, 52684, 52688,
    52712, 52716, 52720, 52728, 52729, 52731, 52733, 52740, 52744, 52748,
    52756, 52761, 52768, 52769, 52772, 52776, 52784, 52785, 52787, 52789,
    52824, 52825, 52828, 52831, 52832, 52833, 52840, 52841, 52843, 52845,
    52852, 52853, 52856, 52860, 52868, 52869, 52871, 52873, 52880, 52881,
    52884, 52888, 52896, 52897, 52899, 52900, 52901, 52908, 52909, 52929,
    52964, 52965, 52968, 52971, 52972, 52980, 52981, 52983, 52984, 52985,
    52992, 52993, 52996, 53000, 53008, 53009, 53011, 53013, 53020, 53024,
    53028, 53036, 53037, 53039, 53040, 53041, 53048, 53076, 53077, 53080,
    53084, 53092, 53093, 53095, 53097, 53104, 53105, 53108, 53112, 53120,
    53125, 53132, 53153, 53160, 53168, 53188, 53216, 53217, 53220, 53224,
    53232, 53233, 53235, 53237, 53244, 53248, 53252, 53265, 53272, 53293,
    53300, 53301, 53304, 53308, 53316, 53317, 53319, 53321, 53328, 53332,
    53336, 53344, 53356, 53357, 53360, 53364, 53372, 53373, 53377, 53412,
    53413, 53416, 53420, 53428, 53429, 53431, 53433, 53440, 53441, 53444,
    53448, 53449, 53456, 53457, 53459, 53460, 53461, 53468, 53469, 53472,
    53476, 53484, 53485, 53487, 53488, 53489, 53496, 53517, 53552, 53553,
    53556, 53560, 53562, 53568, 53569, 53571, 53572, 53573, 53580, 53581,
    53584, 53588, 53596, 53597, 53599, 53601, 53608, 53612, 53628, 53636,
    53640, 53664, 53665, 53668, 53672, 53680, 53681, 53683, 53685, 53690,
    53692, 53696, 53720, 53748, 53752, 53767, 53769, 53776, 53804, 53805,
    53808, 53812, 53820, 53821, 53823, 53825, 53832, 53852, 53860, 53888,
    53889, 53892, 53896, 53904, 53905, 53909, 53916, 53920, 53924, 53932,
    53937, 53944, 53945, 53948, 53951, 53952, 53954, 53960, 53961, 53963,
    53972, 53976, 53980, 53988, 53989, 54000, 54001, 54004, 54008, 54016,
    54017, 54019, 54021, 54028, 54029, 54030, 54032, 54036, 54038, 54044,
    54045, 54047, 54048, 54049, 54053, 54056, 54057, 54060, 54064, 54072,
    54073, 54075, 54076, 54077, 54084, 54085, 54140, 54141, 54144, 54148,
    54156, 54157, 54159, 54160, 54161, 54168, 54169, 54172, 54176, 54184,
    54185, 54187, 54189, 54196, 54200, 54204, 54212, 54213, 54216, 54217,
    54224, 54232, 54241, 54243, 54252, 54253, 54256, 54260, 54268, 54269,
    54271, 54273, 54280, 54301, 54336, 54340, 54364, 54368, 54372, 54381,
    54383, 54392, 54393, 54396, 54399, 54400, 54402, 54408, 54409, 54411,
    54413, 54420, 54441, 54476, 54480, 54484, 54492, 54495, 54504, 54508,
    54512, 54520, 54523, 54525, 54532, 54536, 54540, 54548, 54549, 54551,
    54588, 54589, 54592, 54596, 54604, 54605, 54607, 54609, 54616, 54617,
    54620, 54624, 54629, 54632, 54633, 54635, 54637, 54644, 54645, 54648,
    54652, 54660, 54661, 54663, 54664, 54665, 54672, 54693, 54728, 54729,
    54732, 54736, 54738, 54744, 54745, 54747, 54749, 54756, 54757, 54760,
    54764, 54772, 54773, 54775, 54777, 54784, 54785, 54788, 54792, 54800,
    54801, 54803, 54804, 54805, 54812, 54816, 54820, 54829, 54840, 54841,
    54844, 54848, 54853, 54856, 54857, 54859, 54861, 54865, 54868, 54869,
    54872, 54876, 54887, 54889, 54896, 54897, 54900, 54915, 54917, 54924,
    54925, 54928, 54932, 54941, 54943, 54945, 54952, 54956, 54960, 54969,
    54971, 54980, 54981, 54984, 54988, 54993, 54996, 54999, 55001, 55008,
    55012, 55016, 55024, 55029, 55036, 55037, 55040, 55044, 55057, 55064,
    55065, 55068, 55072, 55080, 55081, 55083, 55085, 55092, 55093, 55096,
    55100, 55108, 55111, 55113, 55120, 55121, 55124, 55126, 55127, 55128,
    55129, 55136, 55137, 55139, 55141, 55145, 55148, 55152, 55156, 55164,
    55165, 55169, 55176, 55177, 55180, 55184, 55192, 55193, 55195, 55197,
    20285, 20339, 20551, 20729, 21152, 21487, 21621, 21733, 22025, 23233,
    23478, 26247, 26550, 26551, 26607, 27468, 29634, 30146, 31292, 33499,
    33540, 34903, 34952, 35382, 36040, 36303, 36603, 36838, 39381, 21051,
    21364, 21508, 24682, 24932, 27580, 29647, 33050, 35258, 35282, 38307,
    20355, 21002, 22718, 22904, 23014, 24178, 24185, 25031, 25536, 26438,
    26604, 26751, 28567, 30286, 30475, 30965, 31240, 31487, 31777, 32925,
    33390, 33393, 35563, 38291, 20075, 21917, 26359, 28212, 30883, 31469,
    33883, 35088, 34638, 38824, 21208, 22350, 22570, 23884, 24863, 25022,
    25121, 25954, 26577, 27204, 28187, 29976, 30131, 30435, 30640, 32058,
    37039, 37969, 37970, 40853, 21283, 23724, 30002, 32987, 37440, 38296,
    21083, 22536, 23004, 23713, 23831, 24247, 24378, 24394, 24951, 27743,
    30074, 30086, 31968, 32115, 32177, 32652, 33108, 33313, 34193, 35137,
    35611, 37628, 38477, 40007, 20171, 20215, 20491, 20977, 22607, 24887,
    24894, 24936, 25913, 27114, 28433, 30117, 30342, 30422, 31623, 33445,
    33995, 63744, 37799, 38283, 21888, 23458, 22353, 63745, 31923, 32697,
    37301, 20520, 21435, 23621, 24040, 25298, 25454, 25818, 25831, 28192,
    28844, 31067, 36317, 36382, 63746, 36989, 37445, 37624, 20094, 20214,
    20581, 24062, 24314, 24838, 26967, 33137, 34388, 36423, 37749, 39467,
    20062, 20625, 26480, 26688, 20745, 21133, 21138, 27298, 30652, 37392,
    40660, 21163, 24623, 36850, 20552, 25001, 25581, 25802, 26684, 27268,
    28608, 33160, 35233, 38548, 22533, 29309, 29356, 29956, 32121, 32365,
    32937, 35211, 35700, 36963, 40273, 25225, 27770, 28500, 32080, 32570,
    35363, 20860, 24906, 31645, 35609, 37463, 37772, 20140, 20435, 20510,
    20670, 20742, 21185, 21197, 21375, 22384, 22659, 24218, 24465, 24950,
    25004, 25806, 25964, 26223, 26299, 26356, 26775, 28039, 28805, 28913,
    29855, 29861, 29898, 30169, 30828, 30956, 31455, 31478, 32069, 32147,
    32789, 32831, 33051, 33686, 35686, 36629, 36885, 37857, 38915, 38968,
    39514, 39912, 20418, 21843, 22586, 22865, 23395, 23622, 24760, 25106,
    26690, 26800, 26856, 28330, 30028, 30328, 30926, 31293, 31995, 32363,
    32380, 35336, 35489, 35903, 38542, 40388, 21476, 21481, 21578, 21617,
    22266, 22993, 23396, 23611, 24235, 25335, 25911, 25925, 25970, 26272,
    26543, 27073, 27837, 30204, 30352, 30590, 31295, 32660, 32771, 32929,
    33167, 33510, 33533, 33776, 34241, 34865, 34996, 35493, 63747, 36764,
    37678, 38599, 39015, 39640, 40723, 21741, 26011, 26354, 26767, 31296,
    35895, 40288, 22256, 22372, 23825, 26118, 26801, 26829, 28414, 29736,
    34974, 39908, 27752, 63748, 39592, 20379, 20844, 20849, 21151, 23380,
    24037, 24656, 24685, 25329, 25511, 25915, 29657, 31354, 34467, 36002,
    38799, 20018, 23521, 25096, 26524, 29916, 31185, 33747, 35463, 35506,
    36328, 36942, 37707, 38982, 24275, 27112, 34303, 37101, 63749, 20896,
    23448, 23532, 24931, 26874, 27454, 28748, 29743, 29912, 31649, 32592,
    33733, 35264, 36011, 38364, 39208, 21038, 24669, 25324, 36866, 20362,
    20809, 21281, 22745, 24291, 26336, 27960, 28826, 29378, 29654, 31568,
    33009, 37979, 21350, 25499, 32619, 20054, 20608, 22602, 22750, 24618,
    24871, 25296, 27088, 39745, 23439, 32024, 32945, 36703, 20132, 20689,
    21676, 21932, 23308, 23968, 24039, 25898, 25934, 26657, 27211, 29409,
    30350, 30703, 32094, 32761, 33184, 34126, 34527, 36611, 36686, 37066,
    39171, 39509, 39851, 19992, 20037, 20061, 20167, 20465, 20855, 21246,
    21312, 21475, 21477, 21646, 22036, 22389, 22434, 23495, 23943, 24272,
    25084, 25304, 25937, 26552, 26601, 27083, 27472, 27590, 27628, 27714,
    28317, 28792, 29399, 29590, 29699, 30655, 30697, 31350, 32127, 32777,
    33276, 33285, 33290, 33503, 34914, 35635, 36092, 36544, 36881, 37041,
    37476, 37558, 39378, 39493, 40169, 40407, 40860, 22283, 23616, 33738,
    38816, 38827, 40628, 21531, 31384, 32676, 35033, 36557, 37089, 22528,
    23624, 25496, 31391, 23470, 24339, 31353, 31406, 33422, 36524, 20518,
    21048, 21240, 21367, 22280, 25331, 25458, 27402, 28099, 30519, 21413,
    29527, 34152, 36470, 38357, 26426, 27331, 28528, 35437, 36556, 39243,
    63750, 26231, 27512, 36020, 39740, 63751, 21483, 22317, 22862, 25542,
    27131, 29674, 30789, 31418, 31429, 31998, 33909, 35215, 36211, 36917,
    38312, 21243, 22343, 30023, 31584, 33740, 37406, 63752, 27224, 20811,
    21067, 21127, 25119, 26840, 26997, 38553, 20677, 21156, 21220, 25027,
    26020, 26681, 27135, 29822, 31563, 33465, 33771, 35250, 35641, 36817,
    39241, 63753, 20170, 22935, 25810, 26129, 27278, 29748, 31105, 31165,
    33449, 34942, 34943, 35167, 63754, 37670, 20235, 21450, 24613, 25201,
    27762, 32026, 32102, 20120, 20834, 30684, 32943, 20225, 20238, 20854,
    20864, 21980, 22120, 22331, 22522, 22524, 22804, 22855, 22931, 23492,
    23696, 23822, 24049, 24190, 24524, 25216, 26071, 26083, 26398, 26399,
    26462, 26827, 26820, 27231, 27450, 27683, 27773, 27778, 28103, 29592,
    29734, 29738, 29826, 29859, 30072, 30079, 30849, 30959, 31041, 31047,
    31048, 31098, 31637, 32000, 32186, 32648, 32774, 32813, 32908, 35352,
    35663, 35912, 36215, 37665, 37668, 39138, 39249, 39438, 39439, 39525,
    40594, 32202, 20342, 21513, 25326, 26708, 37329, 21931, 20794, 63755,
    63756, 23068, 25062, 63757, 25295, 25343, 63758, 63759, 63760, 63761,
    63762, 63763, 37027, 63764, 63765, 63766, 63767, 63768, 35582, 63769,
    63770, 63771, 63772, 26262, 63773, 29014, 63774, 63775, 38627, 63776,
    25423, 25466, 21335, 63777, 26511, 26976, 28275, 63778, 30007, 63779,
    63780, 63781, 32013, 63782, 63783, 34930, 22218, 23064, 63784, 63785,
    63786, 63787, 63788, 20035, 63789, 20839, 22856, 26608, 32784, 63790,
    22899, 24180, 25754, 31178, 24565, 24684, 25288, 25467, 23527, 23511,
    21162, 63791, 22900, 24361, 24594, 63792, 63793, 63794, 29785, 63795,
    63796, 63797, 63798, 63799, 63800, 39377, 63801, 63802, 63803, 63804,
    63805, 63806, 63807, 63808, 63809, 63810, 63811, 28611, 63812, 63813,
    33215, 36786, 24817, 63814, 63815, 33126, 63816, 63817, 23615, 63818,
    63819, 63820, 63821, 63822, 63823, 63824, 63825, 23273, 35365, 26491,
    32016, 63826, 63827, 63828, 63829, 63830, 63831, 33021, 63832, 63833,
    23612, 27877, 21311, 28346, 22810, 33590, 20025, 20150, 20294, 21934,
    22296, 22727, 24406, 26039, 26086, 27264, 27573, 28237, 30701, 31471,
    31774, 32222, 34507, 34962, 37170, 37723, 25787, 28606, 29562, 30136,
    36948, 21846, 22349, 25018, 25812, 26311, 28129, 28251, 28525, 28601,
    30192, 32835, 33213, 34113, 35203, 35527, 35674, 37663, 27795, 30035,
    31572, 36367, 36957, 21776, 22530, 22616, 24162, 25095, 25758, 26848,
    30070, 31958, 34739, 40680, 20195, 22408, 22382, 22823, 23565, 23729,
    24118, 24453, 25140, 25825, 29619, 33274, 34955, 36024, 38538, 40667,
    23429, 24503, 24755, 20498, 20992, 21040, 22294, 22581, 22615, 23566,
    23648, 23798, 23947, 24230, 24466, 24764, 25361, 25481, 25623, 26691,
    26873, 27330, 28120, 28193, 28372, 28644, 29182, 30428, 30585, 31153,
    31291, 33796, 35241, 36077, 36339, 36424, 36867, 36884, 36947, 37117,
    37709, 38518, 38876, 27602, 28678, 29272, 29346, 29544, 30563, 31167,
    31716, 32411, 35712, 22697, 24775, 25958, 26109, 26302, 27788, 28958,
    29129, 35930, 38931, 20077, 31361, 20189, 20908, 20941, 21205, 21516,
    24999, 26481, 26704, 26847, 27934, 28540, 30140, 30643, 31461, 33012,
    33891, 37509, 20828, 26007, 26460, 26515, 30168, 31431, 33651, 63834,
    35910, 36887, 38957, 23663, 33216, 33434, 36929, 36975, 37389, 24471,
    23965, 27225, 29128, 30331, 31561, 34276, 35588, 37159, 39472, 21895,
    25078, 63835, 30313, 32645, 34367, 34746, 35064, 37007, 63836, 27931,
    28889, 29662, 32097, 33853, 63837, 37226, 39409, 63838, 20098, 21365,
    27396, 27410, 28734, 29211, 34349, 40478, 21068, 36771, 23888, 25829,
    25900, 27414, 28651, 31811, 32412, 34253, 35172, 35261, 25289, 33240,
    34847, 24266, 26391, 28010, 29436, 29701, 29807, 34690, 37086, 20358,
    23821, 24480, 33802, 20919, 25504, 30053, 20142, 20486, 20841, 20937,
    26753, 27153, 31918, 31921, 31975, 33391, 35538, 36635, 37327, 20406,
    20791, 21237, 21570, 24300, 24942, 25150, 26053, 27354, 28670, 31018,
    34268, 34851, 38317, 39522, 39530, 40599, 40654, 21147, 26310, 27511,
    28701, 31019, 36706, 38722, 24976, 25088, 25891, 28451, 29001, 29833,
    32244, 32879, 34030, 36646, 36899, 37706, 20925, 21015, 21155, 27916,
    28872, 35010, 24265, 25986, 27566, 28610, 31806, 29557, 20196, 20278,
    22265, 63839, 23738, 23994, 24604, 29618, 31533, 32666, 32718, 32838,
    36894, 37428, 38646, 38728, 38936, 40801, 20363, 28583, 31150, 37300,
    38583, 21214, 63840, 25736, 25796, 27347, 28510, 28696, 29200, 30439,
    32769, 34310, 34396, 36335, 36613, 38706, 39791, 40442, 40565, 30860,
    31103, 32160, 33737, 37636, 40575, 40595, 35542, 22751, 24324, 26407,
    28711, 29903, 31840, 32894, 20769, 28712, 29282, 30922, 36034, 36058,
    36084, 38647, 20102, 20698, 23534, 24278, 26009, 29134, 30274, 30637,
    32842, 34044, 36988, 39719, 40845, 22744, 23105, 23650, 27155, 28122,
    28431, 30267, 32047, 32311, 34078, 35128, 37860, 38475, 21129, 26066,
    26611, 27060, 27969, 28316, 28687, 29705, 29792, 30041, 30244, 30827,
    35628, 39006, 20845, 25134, 38520, 20374, 20523, 23833, 28138, 32184,
    36650, 24459, 24900, 26647, 63841, 38534, 21202, 32907, 20956, 20940,
    26974, 31260, 32190, 33777, 38517, 20442, 21033, 21400, 21519, 21774,
    23653, 24743, 26446, 26792, 28012, 29313, 29432, 29702, 29827, 63842,
    30178, 31852, 32633, 32696, 33673, 35023, 35041, 37324, 37328, 38626,
    39881, 21533, 28542, 29136, 29848, 34298, 36522, 38563, 40023, 40607,
    26519, 28107, 29747, 33256, 38678, 30764, 31435, 31520, 31890, 25705,
    29802, 30194, 30908, 30952, 39340, 39764, 40635, 23518, 24149, 28448,
    33180, 33707, 37000, 19975, 21325, 23081, 24018, 24398, 24930, 25405,
    26217, 26364, 28415, 28459, 28771, 30622, 33836, 34067, 34875, 36627,
    39237, 39995, 21788, 25273, 26411, 27819, 33545, 35178, 38778, 20129,
    22916, 24536, 24537, 26395, 32178, 32596, 33426, 33579, 33725, 36638,
    37017, 22475, 22969, 23186, 23504, 26151, 26522, 26757, 27599, 29028,
    32629, 36023, 36067, 36993, 39749, 33032, 35978, 38476, 39488, 40613,
    23391, 27667, 29467, 30450, 30431, 33804, 20906, 35219, 20813, 20885,
    21193, 26825, 27796, 30468, 30496, 32191, 32236, 38754, 40629, 28357,
    34065, 20901, 21517, 21629, 26126, 26269, 26919, 28319, 30399, 30609,
    33559, 33986, 34719, 37225, 37528, 40180, 34946, 20398, 20882, 21215,
    22982, 24125, 24917, 25720, 25721, 26286, 26576, 27169, 27597, 27611,
    29279, 29281, 29761, 30520, 30683, 32791, 33468, 33541, 35584, 35624,
    35980, 26408, 27792, 29287, 30446, 30566, 31302, 40361, 27519, 27794,
    22818, 26406, 33945, 21359, 22675, 22937, 24287, 25551, 26164, 26483,
    28218, 29483, 31447, 33495, 37672, 21209, 24043, 25006, 25035, 25098,
    25287, 25771, 26080, 26969, 27494, 27595, 28961, 29687, 30045, 32326,
    33310, 33538, 34154, 35491, 36031, 38695, 40289, 22696, 40664, 20497,
    21006, 21563, 21839, 25991, 27766, 32010, 32011, 32862, 34442, 38272,
    38639, 21247, 27797, 29289, 21619, 23194, 23614, 23883, 24396, 24494,
    26410, 26806, 26979, 28220, 28228, 30473, 31859, 32654, 34183, 35598,
    36855, 38753, 40692, 23735, 24758, 24845, 25003, 25935, 26107, 26108,
    27665, 27887, 29599, 29641, 32225, 38292, 23494, 34588, 35600, 21085,
    21338, 25293, 25615, 25778, 26420, 27192, 27850, 29632, 29854, 31636,
    31893, 32283, 33162, 33334, 34180, 36843, 38649, 39361, 20276, 21322,
    21453, 21467, 25292, 25644, 25856, 26001, 27075, 27886, 28504, 29677,
    30036, 30242, 30436, 30460, 30928, 30971, 31020, 32070, 33324, 34784,
    36820, 38930, 39151, 21187, 25300, 25765, 28196, 28497, 30332, 36299,
    37297, 37474, 39662, 39747, 20515, 20621, 22346, 22952, 23592, 24135,
    24439, 25151, 25918, 26041, 26049, 26121, 26507, 27036, 28354, 30917,
    32033, 32938, 33152, 33323, 33459, 33953, 34444, 35370, 35607, 37030,
    38450, 40848, 20493, 20467, 63843, 22521, 24472, 25308, 25490, 26479,
    28227, 28953, 30403, 32972, 32986, 35060, 35061, 35097, 36064, 36649,
    37197, 38506, 20271, 20336, 24091, 26575, 26658, 30333, 30334, 39748,
    24161, 27146, 29033, 29140, 30058, 63844, 32321, 34115, 34281, 39132,
    20240, 31567, 32624, 38309, 20961, 24070, 26805, 27710, 27726, 27867,
    29359, 31684, 33539, 27861, 29754, 20731, 21128, 22721, 25816, 27287,
    29863, 30294, 30887, 34327, 38370, 38713, 63845, 21342, 24321, 35722,
    36776, 36783, 37002, 21029, 30629, 40009, 40712, 19993, 20482, 20853,
    23643, 24183, 26142, 26170, 26564, 26821, 28851, 29953, 30149, 31177,
    31453, 36647, 39200, 39432, 20445, 22561, 22577, 23542, 26222, 27493,
    27921, 28282, 28541, 29668, 29995, 33769, 35036, 35091, 35676, 36628,
    20239, 20693, 21264, 21340, 23443, 24489, 26381, 31119, 33145, 33583,
    34068, 35079, 35206, 36665, 36667, 39333, 39954, 26412, 20086, 20472,
    22857, 23553, 23791, 23792, 25447, 26834, 28925, 29090, 29739, 32299,
    34028, 34562, 36898, 37586, 40179, 19981, 20184, 20463, 20613, 21078,
    21103, 21542, 21648, 22496, 22827, 23142, 23386, 23413, 23500, 24220,
    63846, 25206, 25975, 26023, 28014, 28325, 29238, 31526, 31807, 32566,
    33104, 33105, 33178, 33344, 33433, 33705, 35331, 36000, 36070, 36091,
    36212, 36282, 37096, 37340, 38428, 38468, 39385, 40167, 21271, 20998,
    21545, 22132, 22707, 22868, 22894, 24575, 24996, 25198, 26128, 27774,
    28954, 30406, 31881, 31966, 32027, 33452, 36033, 38640, 63847, 20315,
    24343, 24447, 25282, 23849, 26379, 26842, 30844, 32323, 40300, 19989,
    20633, 21269, 21290, 21329, 22915, 23138, 24199, 24754, 24970, 25161,
    25209, 26000, 26503, 27047, 27604, 27606, 27607, 27608, 27832, 63848,
    29749, 30202, 30738, 30865, 31189, 31192, 31875, 32203, 32737, 32933,
    33086, 33218, 33778, 34586, 35048, 35513, 35692, 36027, 37145, 38750,
    39131, 40763, 22188, 23338, 24428, 25996, 27315, 27567, 27996, 28657,
    28693, 29277, 29613, 36007, 36051, 38971, 24977, 27703, 32856, 39425,
    20045, 20107, 20123, 20181, 20282, 20284, 20351, 20447, 20735, 21490,
    21496, 21766, 21987, 22235, 22763, 22882, 23057, 23531, 23546, 23556,
    24051, 24107, 24473, 24605, 25448, 26012, 26031, 26614, 26619, 26797,
    27515, 27801, 27863, 28195, 28681, 29509, 30722, 31038, 31040, 31072,
    31169, 31721, 32023, 32114, 32902, 33293, 33678, 34001, 34503, 35039,
    35408, 35422, 35613, 36060, 36198, 36781, 37034, 39164, 39391, 40605,
    21066, 63849, 26388, 63850, 20632, 21034, 23665, 25955, 27733, 29642,
    29987, 30109, 31639, 33948, 37240, 38704, 20087, 25746, 27578, 29022,
    34217, 19977, 63851, 26441, 26862, 28183, 33439, 34072, 34923, 25591,
    28545, 37394, 39087, 19978, 20663, 20687, 20767, 21830, 21930, 22039,
    23360, 23577, 23776, 24120, 24202, 24224, 24258, 24819, 26705, 27233,
    28248, 29245, 29248, 29376, 30456, 31077, 31665, 32724, 35059, 35316,
    35443, 35937, 36062, 38684, 22622, 29885, 36093, 21959, 63852, 31329,
    32034, 33394, 29298, 29983, 29989, 63853, 31513, 22661, 22779, 23996,
    24207, 24246, 24464, 24661, 25234, 25471, 25933, 26257, 26329, 26360,
    26646, 26866, 29312, 29790, 31598, 32110, 32214, 32626, 32997, 33298,
    34223, 35199, 35475, 36893, 37604, 40653, 40736, 22805, 22893, 24109,
    24796, 26132, 26227, 26512, 27728, 28101, 28511, 30707, 30889, 33990,
    37323, 37675, 20185, 20682, 20808, 21892, 23307, 23459, 25159, 25982,
    26059, 28210, 29053, 29697, 29764, 29831, 29887, 30316, 31146, 32218,
    32341, 32680, 33146, 33203, 33337, 34330, 34796, 35445, 36323, 36984,
    37521, 37925, 39245, 39854, 21352, 23633, 26964, 27844, 27945, 28203,
    33292, 34203, 35131, 35373, 35498, 38634, 40807, 21089, 26297, 27570,
    32406, 34814, 36109, 38275, 38493, 25885, 28041, 29166, 63854, 22478,
    22995, 23468, 24615, 24826, 25104, 26143, 26207, 29481, 29689, 30427,
    30465, 31596, 32854, 32882, 33125, 35488, 37266, 19990, 21218, 27506,
    27927, 31237, 31545, 32048, 63855, 36016, 21484, 22063, 22609, 23477,
    23567, 23569, 24034, 25152, 25475, 25620, 26157, 26803, 27836, 28040,
    28335, 28703, 28836, 29138, 29990, 30095, 30094, 30233, 31505, 31712,
    31787, 32032, 32057, 34092, 34157, 34311, 35380, 36877, 36961, 37045,
    37559, 38902, 39479, 20439, 23660, 26463, 28049, 31903, 32396, 35606,
    36118, 36895, 23403, 24061, 25613, 33984, 36956, 39137, 29575, 23435,
    24730, 26494, 28126, 35359, 35494, 36865, 38924, 21047, 63856, 28753,
    30862, 37782, 34928, 37335, 20462, 21463, 22013, 22234, 22402, 22781,
    23234, 23432, 23723, 23744, 24101, 24833, 25101, 25163, 25480, 25628,
    25910, 25976, 27193, 27530, 27700, 27929, 28465, 29159, 29417, 29560,
    29703, 29874, 30246, 30561, 31168, 31319, 31466, 31929, 32143, 32172,
    32353, 32670, 33065, 33585, 33936, 34010, 34282, 34966, 35504, 35728,
    36664, 36930, 36995, 37228, 37526, 37561, 38539, 38567, 38568, 38614,
    38656, 38920, 39318, 39635, 39706, 21460, 22654, 22809, 23408, 23487,
    28113, 28506, 29087, 29729, 29881, 32901, 33789, 24033, 24455, 24490,
    24642, 26092, 26642, 26991, 27219, 27529, 27957, 28147, 29667, 30462,
    30636, 31565, 32020, 33059, 33308, 33600, 34036, 34147, 35426, 35524,
    37255, 37662, 38918, 39348, 25100, 34899, 36848, 37477, 23815, 23847,
    23913, 29791, 33181, 34664, 28629, 25342, 32722, 35126, 35186, 19998,
    20056, 20711, 21213, 21319, 25215, 26119, 32361, 34821, 38494, 20365,
    21273, 22070, 22987, 23204, 23608, 23630, 23629, 24066, 24337, 24643,
    26045, 26159, 26178, 26558, 26612, 29468, 30690, 31034, 32709, 33940,
    33997, 35222, 35430, 35433, 35553, 35925, 35962, 22516, 23508, 24335,
    24687, 25325, 26893, 27542, 28252, 29060, 31698, 34645, 35672, 36606,
    39135, 39166, 20280, 20353, 20449, 21627, 23072, 23480, 24892, 26032,
    26216, 29180, 30003, 31070, 32051, 33102, 33251, 33688, 34218, 34254,
    34563, 35338, 36523, 36763, 63857, 36805, 22833, 23460, 23526, 24713,
    23529, 23563, 24515, 27777, 63858, 28145, 28683, 29978, 33455, 35574,
    20160, 21313, 63859, 38617, 27663, 20126, 20420, 20818, 21854, 23077,
    23784, 25105, 29273, 33469, 33706, 34558, 34905, 35357, 38463, 38597,
    39187, 40201, 40285, 22538, 23731, 23997, 24132, 24801, 24853, 25569,
    27138, 28197, 37122, 37716, 38990, 39952, 40823, 23433, 23736, 25353,
    26191, 26696, 30524, 38593, 38797, 38996, 39839, 26017, 35585, 36555,
    38332, 21813, 23721, 24022, 24245, 26263, 30284, 33780, 38343, 22739,
    25276, 29390, 40232, 20208, 22830, 24591, 26171, 27523, 31207, 40230,
    21395, 21696, 22467, 23830, 24859, 26326, 28079, 30861, 33406, 38552,
    38724, 21380, 25212, 25494, 28082, 32266, 33099, 38989, 27387, 32588,
    40367, 40474, 20063, 20539, 20918, 22812, 24825, 25590, 26928, 29242,
    32822, 63860, 37326, 24369, 63861, 63862, 32004, 33509, 33903, 33979,
    34277, 36493, 63863, 20335, 63864, 63865, 22756, 23363, 24665, 25562,
    25880, 25965, 26264, 63866, 26954, 27171, 27915, 28673, 29036, 30162,
    30221, 31155, 31344, 63867, 32650, 63868, 35140, 63869, 35731, 37312,
    38525, 63870, 39178, 22276, 24481, 26044, 28417, 30208, 31142, 35486,
    39341, 39770, 40812, 20740, 25014, 25233, 27277, 33222, 20547, 22576,
    24422, 28937, 35328, 35578, 23420, 34326, 20474, 20796, 22196, 22852,
    25513, 28153, 23978, 26989, 20870, 20104, 20313, 63871, 63872, 63873,
    22914, 63874, 63875, 27487, 27741, 63876, 29877, 30998, 63877, 33287,
    33349, 33593, 36671, 36701, 63878, 39192, 63879, 63880, 63881, 20134,
    63882, 22495, 24441, 26131, 63883, 63884, 30123, 32377, 35695, 63885,
    36870, 39515, 22181, 22567, 23032, 23071, 23476, 63886, 24310, 63887,
    63888, 25424, 25403, 63889, 26941, 27783, 27839, 28046, 28051, 28149,
    28436, 63890, 28895, 28982, 29017, 63891, 29123, 29141, 63892, 30799,
    30831, 63893, 31605, 32227, 63894, 32303, 63895, 34893, 36575, 63896,
    63897, 63898, 37467, 63899, 40182, 63900, 63901, 63902, 24709, 28037,
    63903, 29105, 63904, 63905, 38321, 21421, 63906, 63907, 63908, 26579,
    63909, 28814, 28976, 29744, 33398, 33490, 63910, 38331, 39653, 40573,
    26308, 63911, 29121, 33865, 63912, 63913, 22603, 63914, 63915, 23992,
    24433, 63916, 26144, 26254, 27001, 27054, 27704, 27891, 28214, 28481,
    28634, 28699, 28719, 29008, 29151, 29552, 63917, 29787, 63918, 29908,
    30408, 31310, 32403, 63919, 63920, 33521, 35424, 36814, 63921, 37704,
    63922, 38681, 63923, 63924, 20034, 20522, 63925, 21000, 21473, 26355,
    27757, 28618, 29450, 30591, 31330, 33454, 34269, 34306, 63926, 35028,
    35427, 35709, 35947, 63927, 37555, 63928, 38675, 38928, 20116, 20237,
    20425, 20658, 21320, 21566, 21555, 21978, 22626, 22714, 22887, 23067,
    23524, 24735, 63929, 25034, 25942, 26111, 26212, 26791, 27738, 28595,
    28879, 29100, 29522, 31613, 34568, 35492, 39986, 40711, 23627, 27779,
    29508, 29577, 37434, 28331, 29797, 30239, 31337, 32277, 34314, 20800,
    22725, 25793, 29934, 29973, 30320, 32705, 37013, 38605, 39252, 28198,
    29926, 31401, 31402, 33253, 34521, 34680, 35355, 23113, 23436, 23451,
    26785, 26880, 28003, 29609, 29715, 29740, 30871, 32233, 32747, 33048,
    33109, 33694, 35916, 38446, 38929, 26352, 24448, 26106, 26505, 27754,
    29579, 20525, 23043, 27498, 30702, 22806, 23916, 24013, 29477, 30031,
    63930, 63931, 20709, 20985, 22575, 22829, 22934, 23002, 23525, 63932,
    63933, 23970, 25303, 25622, 25747, 25854, 63934, 26332, 63935, 27208,
    63936, 29183, 29796, 63937, 31368, 31407, 32327, 32350, 32768, 33136,
    63938, 34799, 35201, 35616, 36953, 63939, 36992, 39250, 24958, 27442,
    28020, 32287, 35109, 36785, 20433, 20653, 20887, 21191, 22471, 22665,
    23481, 24248, 24898, 27029, 28044, 28263, 28342, 29076, 29794, 29992,
    29996, 32883, 33592, 33993, 36362, 37780, 37854, 63940, 20110, 20305,
    20598, 20778, 21448, 21451, 21491, 23431, 23507, 23588, 24858, 24962,
    26100, 29275, 29591, 29760, 30402, 31056, 31121, 31161, 32006, 32701,
    33419, 34261, 34398, 36802, 36935, 37109, 37354, 38533, 38632, 38633,
    21206, 24423, 26093, 26161, 26671, 29020, 31286, 37057, 38922, 20113,
    63941, 27218, 27550, 28560, 29065, 32792, 33464, 34131, 36939, 38549,
    38642, 38907, 34074, 39729, 20112, 29066, 38596, 20803, 21407, 21729,
    22291, 22290, 22435, 23195, 23236, 23491, 24616, 24895, 25588, 27781,
    27961, 28274, 28304, 29232, 29503, 29783, 33489, 34945, 36677, 36960,
    63942, 38498, 39000, 40219, 26376, 36234, 37470, 20301, 20553, 20702,
    21361, 22285, 22996, 23041, 23561, 24944, 26256, 28205, 29234, 29771,
    32239, 32963, 33806, 33894, 34111, 34655, 34907, 35096, 35586, 36949,
    38859, 39759, 20083, 20369, 20754, 20842, 63943, 21807, 21929, 23418,
    23461, 24188, 24189, 24254, 24736, 24799, 24840, 24841, 25540, 25912,
    26377, 63944, 26580, 26586, 63945, 26977, 26978, 27833, 27943, 63946,
    28216, 63947, 28641, 29494, 29495, 63948, 29788, 30001, 63949, 30290,
    63950, 63951, 32173, 33278, 33848, 35029, 35480, 35547, 35565, 36400,
    36418, 36938, 36926, 36986, 37193, 37321, 37742, 63952, 63953, 22537,
    63954, 27603, 32905, 32946, 63955, 63956, 20801, 22891, 23609, 63957,
    63958, 28516, 29607, 32996, 36103, 63959, 37399, 38287, 63960, 63961,
    63962, 63963, 32895, 25102, 28700, 32104, 34701, 63964, 22432, 24681,
    24903, 27575, 35518, 37504, 38577, 20057, 21535, 28139, 34093, 38512,
    38899, 39150, 25558, 27875, 37009, 20957, 25033, 33210, 40441, 20381,
    20506, 20736, 23452, 24847, 25087, 25836, 26885, 27589, 30097, 30691,
    32681, 33380, 34191, 34811, 34915, 35516, 35696, 37291, 20108, 20197,
    20234, 63965, 63966, 22839, 23016, 63967, 24050, 24347, 24411, 24609,
    63968, 63969, 63970, 63971, 29246, 29669, 63972, 30064, 30157, 63973,
    31227, 63974, 32780, 32819, 32900, 33505, 33617, 63975, 63976, 36029,
    36019, 36999, 63977, 63978, 39156, 39180, 63979, 63980, 28727, 30410,
    32714, 32716, 32764, 35610, 20154, 20161, 20995, 21360, 63981, 21693,
    22240, 23035, 23493, 24341, 24525, 28270, 63982, 63983, 32106, 33589,
    63984, 34451, 35469, 63985, 38765, 38775, 63986, 63987, 19968, 20314,
    20350, 22777, 26085, 28322, 36920, 37808, 39353, 20219, 22764, 22922,
    23001, 24641, 63988, 63989, 31252, 63990, 33615, 36035, 20837, 21316,
    63991, 63992, 63993, 20173, 21097, 23381, 33471, 20180, 21050, 21672,
    22985, 23039, 23376, 23383, 23388, 24675, 24904, 28363, 28825, 29038,
    29574, 29943, 30133, 30913, 32043, 32773, 33258, 33576, 34071, 34249,
    35566, 36039, 38604, 20316, 21242, 22204, 26027, 26152, 28796, 28856,
    29237, 32189, 33421, 37196, 38592, 40306, 23409, 26855, 27544, 28538,
    30430, 23697, 26283, 28507, 31668, 31786, 34870, 38620, 19976, 20183,
    21280, 22580, 22715, 22767, 22892, 23559, 24115, 24196, 24373, 25484,
    26290, 26454, 27167, 27299, 27404, 28479, 29254, 63994, 29520, 29835,
    31456, 31911, 33144, 33247, 33255, 33674, 33900, 34083, 34196, 34255,
    35037, 36115, 37292, 38263, 38556, 20877, 21705, 22312, 23472, 25165,
    26448, 26685, 26771, 28221, 28371, 28797, 32289, 35009, 36001, 36617,
    40779, 40782, 29229, 31631, 35533, 37658, 20295, 20302, 20786, 21632,
    22992, 24213, 25269, 26485, 26990, 27159, 27822, 28186, 29401, 29482,
    30141, 31672, 32053, 33511, 33785, 33879, 34295, 35419, 36015, 36487,
    36889, 37048, 38606, 40799, 21219, 21514, 23265, 23490, 25688, 25973,
    28404, 29380, 63995, 30340, 31309, 31515, 31821, 32318, 32735, 33659,
    35627, 36042, 36196, 36321, 36447, 36842, 36857, 36969, 37841, 20291,
    20346, 20659, 20840, 20856, 21069, 21098, 22625, 22652, 22880, 23560,
    23637, 24283, 24731, 25136, 26643, 27583, 27656, 28593, 29006, 29728,
    30000, 30008, 30033, 30322, 31564, 31627, 31661, 31686, 32399, 35438,
    36670, 36681, 37439, 37523, 37666, 37931, 38651, 39002, 39019, 39198,
    20999, 25130, 25240, 27993, 30308, 31434, 31680, 32118, 21344, 23742,
    24215, 28472, 28857, 31896, 38673, 39822, 40670, 25509, 25722, 34678,
    19969, 20117, 20141, 20572, 20597, 21576, 22979, 23450, 24128, 24237,
    24311, 24449, 24773, 25402, 25919, 25972, 26060, 26230, 26232, 26622,
    26984, 27273, 27491, 27712, 28096, 28136, 28191, 28254, 28702, 28833,
    29582, 29693, 30010, 30555, 30855, 31118, 31243, 31357, 31934, 32142,
    33351, 35330, 35562, 35998, 37165, 37194, 37336, 37478, 37580, 37664,
    38662, 38742, 38748, 38914, 40718, 21046, 21137, 21884, 22564, 24093,
    24351, 24716, 25552, 26799, 28639, 31085, 31532, 33229, 34234, 35069,
    35576, 36420, 37261, 38500, 38555, 38717, 38988, 40778, 20430, 20806,
    20939, 21161, 22066, 24340, 24427, 25514, 25805, 26089, 26177, 26362,
    26361, 26397, 26781, 26839, 27133, 28437, 28526, 29031, 29157, 29226,
    29866, 30522, 31062, 31066, 31199, 31264, 31381, 31895, 31967, 32068,
    32368, 32903, 34299, 34468, 35412, 35519, 36249, 36481, 36896, 36973,
    37347, 38459, 38613, 40165, 26063, 31751, 36275, 37827, 23384, 23562,
    21330, 25305, 29469, 20519, 23447, 24478, 24752, 24939, 26837, 28121,
    29742, 31278, 32066, 32156, 32305, 33131, 36394, 36405, 37758, 37912,
    20304, 22352, 24038, 24231, 25387, 32618, 20027, 20303, 20367, 20570,
    23005, 32964, 21610, 21608, 22014, 22863, 23449, 24030, 24282, 26205,
    26417, 26609, 26666, 27880, 27954, 28234, 28557, 28855, 29664, 30087,
    31820, 32002, 32044, 32162, 33311, 34523, 35387, 35461, 36208, 36490,
    36659, 36913, 37198, 37202, 37956, 39376, 31481, 31909, 20426, 20737,
    20934, 22472, 23535, 23803, 26201, 27197, 27994, 28310, 28652, 28940,
    30063, 31459, 34850, 36897, 36981, 38603, 39423, 33537, 20013, 20210,
    34886, 37325, 21373, 27355, 26987, 27713, 33914, 22686, 24974, 26366,
    25327, 28893, 29969, 30151, 32338, 33976, 35657, 36104, 20043, 21482,
    21675, 22320, 22336, 24535, 25345, 25351, 25711, 25903, 26088, 26234,
    26525, 26547, 27490, 27744, 27802, 28460, 30693, 30757, 31049, 31063,
    32025, 32930, 33026, 33267, 33437, 33463, 34584, 35468, 63996, 36100,
    36286, 36978, 30452, 31257, 31287, 32340, 32887, 21767, 21972, 22645,
    25391, 25634, 26185, 26187, 26733, 27035, 27524, 27941, 28337, 29645,
    29800, 29857, 30043, 30137, 30433, 30494, 30603, 31206, 32265, 32285,
    33275, 34095, 34967, 35386, 36049, 36587, 36784, 36914, 37805, 38499,
    38515, 38663, 20356, 21489, 23018, 23241, 24089, 26702, 29894, 30142,
    31209, 31378, 33187, 34541, 36074, 36300, 36845, 26015, 26389, 63997,
    22519, 28503, 32221, 36655, 37878, 38598, 24501, 25074, 28548, 19988,
    20376, 20511, 21449, 21983, 23919, 24046, 27425, 27492, 30923, 31642,
    63998, 36425, 36554, 36974, 25417, 25662, 30528, 31364, 37679, 38015,
    40810, 25776, 28591, 29158, 29864, 29914, 31428, 31762, 32386, 31922,
    32408, 35738, 36106, 38013, 39184, 39244, 21049, 23519, 25830, 26413,
    32046, 20717, 21443, 22649, 24920, 24921, 25082, 26028, 31449, 35730,
    35734, 20489, 20513, 21109, 21809, 23100, 24288, 24432, 24884, 25950,
    26124, 26166, 26274, 27085, 28356, 28466, 29462, 30241, 31379, 33081,
    33369, 33750, 33980, 20661, 22512, 23488, 23528, 24425, 25505, 30758,
    32181, 33756, 34081, 37319, 37365, 20874, 26613, 31574, 36012, 20932,
    22971, 24765, 34389, 20508, 63999, 21076, 23610, 24957, 25114, 25299,
    25842, 26021, 28364, 30240, 33034, 36448, 38495, 38587, 20191, 21315,
    21912, 22825, 24029, 25797, 27849, 28154, 29588, 31359, 33307, 34214,
    36068, 36368, 36983, 37351, 38369, 38433, 38854, 20984, 21746, 21894,
    24505, 25764, 28552, 32180, 36639, 36685, 37941, 20681, 23574, 27838,
    28155, 29979, 30651, 31805, 31844, 35449, 35522, 22558, 22974, 24086,
    25463, 29266, 30090, 30571, 35548, 36028, 36626, 24307, 26228, 28152,
    32893, 33729, 35531, 38737, 39894, 64000, 21059, 26367, 28053, 28399,
    32224, 35558, 36910, 36958, 39636, 21021, 21119, 21736, 24980, 25220,
    25307, 26786, 26898, 26970, 27189, 28818, 28966, 30813, 30977, 30990,
    31186, 31245, 32918, 33400, 33493, 33609, 34121, 35970, 36229, 37218,
    37259, 37294, 20419, 22225, 29165, 30679, 34560, 35320, 23544, 24534,
    26449, 37032, 21474, 22618, 23541, 24740, 24961, 25696, 32317, 32880,
    34085, 37507, 25774, 20652, 23828, 26368, 22684, 25277, 25512, 26894,
    27000, 27166, 28267, 30394, 31179, 33467, 33833, 35535, 36264, 36861,
    37138, 37195, 37276, 37648, 37656, 37786, 38619, 39478, 39949, 19985,
    30044, 31069, 31482, 31569, 31689, 32302, 33988, 36441, 36468, 36600,
    36880, 26149, 26943, 29763, 20986, 26414, 40668, 20805, 24544, 27798,
    34802, 34909, 34935, 24756, 33205, 33795, 36101, 21462, 21561, 22068,
    23094, 23601, 28810, 32736, 32858, 33030, 33261, 36259, 37257, 39519,
    40434, 20596, 20164, 21408, 24827, 28204, 23652, 20360, 20516, 21988,
    23769, 24159, 24677, 26772, 27835, 28100, 29118, 30164, 30196, 30305,
    31258, 31305, 32199, 32251, 32622, 33268, 34473, 36636, 38601, 39347,
    40786, 21063, 21189, 39149, 35242, 19971, 26578, 28422, 20405, 23522,
    26517, 27784, 28024, 29723, 30759, 37341, 37756, 34756, 31204, 31281,
    24555, 20182, 21668, 21822, 22702, 22949, 24816, 25171, 25302, 26422,
    26965, 33333, 38464, 39345, 39389, 20524, 21331, 21828, 22396, 64001,
    25176, 64002, 25826, 26219, 26589, 28609, 28655, 29730, 29752, 35351,
    37944, 21585, 22022, 22374, 24392, 24986, 27470, 28760, 28845, 32187,
    35477, 22890, 33067, 25506, 30472, 32829, 36010, 22612, 25645, 27067,
    23445, 24081, 28271, 64003, 34153, 20812, 21488, 22826, 24608, 24907,
    27526, 27760, 27888, 31518, 32974, 33492, 36294, 37040, 39089, 64004,
    25799, 28580, 25745, 25860, 20814, 21520, 22303, 35342, 24927, 26742,
    64005, 30171, 31570, 32113, 36890, 22534, 27084, 33151, 35114, 36864,
    38969, 20600, 22871, 22956, 25237, 36879, 39722, 24925, 29305, 38358,
    22369, 23110, 24052, 25226, 25773, 25850, 26487, 27874, 27966, 29228,
    29750, 30772, 32631, 33453, 36315, 38935, 21028, 22338, 26495, 29256,
    29923, 36009, 36774, 37393, 38442, 20843, 21485, 25420, 20329, 21764,
    24726, 25943, 27803, 28031, 29260, 29437, 31255, 35207, 35997, 24429,
    28558, 28921, 33192, 24846, 20415, 20559, 25153, 29255, 31687, 32232,
    32745, 36941, 38829, 39449, 36022, 22378, 24179, 26544, 33805, 35413,
    21536, 23318, 24163, 24290, 24330, 25987, 32954, 34109, 38281, 38491,
    20296, 21253, 21261, 21263, 21638, 21754, 22275, 24067, 24598, 25243,
    25265, 25429, 64006, 27873, 28006, 30129, 30770, 32990, 33071, 33502,
    33889, 33970, 34957, 35090, 36875, 37610, 39165, 39825, 24133, 26292,
    26333, 28689, 29190, 64007, 20469, 21117, 24426, 24915, 26451, 27161,
    28418, 29922, 31080, 34920, 35961, 39111, 39108, 39491, 21697, 31263,
    26963, 35575, 35914, 39080, 39342, 24444, 25259, 30130, 30382, 34987,
    36991, 38466, 21305, 24380, 24517, 27852, 29644, 30050, 30091, 31558,
    33534, 39325, 20047, 36924, 19979, 20309, 21414, 22799, 24264, 26160,
    27827, 29781, 33655, 34662, 36032, 36944, 38686, 39957, 22737, 23416,
    34384, 35604, 40372, 23506, 24680, 24717, 26097, 27735, 28450, 28579,
    28698, 32597, 32752, 38289, 38290, 38480, 38867, 21106, 36676, 20989,
    21547, 21688, 21859, 21898, 27323, 28085, 32216, 33382, 37532, 38519,
    40569, 21512, 21704, 30418, 34532, 38308, 38356, 38492, 20130, 20233,
    23022, 23270, 24055, 24658, 25239, 26477, 26689, 27782, 28207, 32568,
    32923, 33322, 64008, 64009, 38917, 20133, 20565, 21683, 22419, 22874,
    23401, 23475, 25032, 26999, 28023, 28707, 34809, 35299, 35442, 35559,
    36994, 39405, 39608, 21182, 26680, 20502, 24184, 26447, 33607, 34892,
    20139, 21521, 22190, 29670, 37141, 38911, 39177, 39255, 39321, 22099,
    22687, 34395, 35377, 25010, 27382, 29563, 36562, 27463, 38570, 39511,
    22869, 29184, 36203, 38761, 20436, 23796, 24358, 25080, 26203, 27883,
    28843, 29572, 29625, 29694, 30505, 30541, 32067, 32098, 32291, 33335,
    34898, 64010, 36066, 37449, 39023, 23377, 31348, 34880, 38913, 23244,
    20448, 21332, 22846, 23805, 25406, 28025, 29433, 33029, 33031, 33698,
    37583, 38960, 20136, 20804, 21009, 22411, 24418, 27842, 28366, 28677,
    28752, 28847, 29074, 29673, 29801, 33610, 34722, 34913, 36872, 37026,
    37795, 39336, 20846, 24407, 24800, 24935, 26291, 34137, 36426, 37295,
    38795, 20046, 20114, 21628, 22741, 22778, 22909, 23733, 24359, 25142,
    25160, 26122, 26215, 27627, 28009, 28111, 28246, 28408, 28564, 28640,
    28649, 28765, 29392, 29733, 29786, 29920, 30355, 31068, 31946, 32286,
    32993, 33446, 33899, 33983, 34382, 34399, 34676, 35703, 35946, 37804,
    38912, 39013, 24785, 25110, 37239, 23130, 26127, 28151, 28222, 29759,
    39746, 24573, 24794, 31503, 21700, 24344, 27742, 27859, 27946, 28888,
    32005, 34425, 35340, 40251, 21270, 21644, 23301, 27194, 28779, 30069,
    31117, 31166, 33457, 33775, 35441, 35649, 36008, 38772, 64011, 25844,
    25899, 30906, 30907, 31339, 20024, 21914, 22864, 23462, 24187, 24739,
    25563, 27489, 26213, 26707, 28185, 29029, 29872, 32008, 36996, 39529,
    39973, 27963, 28369, 29502, 35905, 38346, 20976, 24140, 24488, 24653,
    24822, 24880, 24908, 26179, 26180, 27045, 27841, 28255, 28361, 28514,
    29004, 29852, 30343, 31681, 31783, 33618, 34647, 36945, 38541, 40643,
    21295, 22238, 24315, 24458, 24674, 24724, 25079, 26214, 26371, 27292,
    28142, 28590, 28784, 29546, 32362, 33214, 33588, 34516, 35496, 36036,
    21123, 29554, 23446, 27243, 37892, 21742, 22150, 23389, 25928, 25989,
    26313, 26783, 28045, 28102, 29243, 32948, 37237, 39501, 20399, 20505,
    21402, 21518, 21564, 21897, 21957, 24127, 24460, 26429, 29030, 29661,
    36869, 21211, 21235, 22628, 22734, 28932, 29071, 29179, 34224, 35347,
    26248, 34216, 21927, 26244, 29002, 33841, 21321, 21913, 27585, 24409,
    24509, 25582, 26249, 28999, 35569, 36637, 40638, 20241, 25658, 28875,
    30054, 34407, 24676, 35662, 40440, 20807, 20982, 21256, 27958, 33016,
    40657, 26133, 27427, 28824, 30165, 21507, 23673, 32007, 35350, 27424,
    27453, 27462, 21560, 24688, 27965, 32725, 33288, 20694, 20958, 21916,
    22123, 22221, 23020, 23305, 24076, 24985, 24984, 25137, 26206, 26342,
    29081, 29113, 29114, 29351, 31143, 31232, 32690, 35440, 44034, 44035,
    44037, 44038, 44043, 44044, 44045, 44046, 44047, 44056, 44062, 44063,
    44065, 44066, 44067, 44069, 44070, 44071, 44072, 44073, 44074, 44075,
    44078, 44082, 44083, 44084, 44085, 44086, 44087, 44090, 44091, 44093,
    44094, 44095, 44097, 44098, 44099, 44100, 44101, 44102, 44103, 44104,
    44105, 44106, 44108, 44110, 44111, 44112, 44113, 44114, 44115, 44117,
    44118, 44119, 44121, 44122, 44123, 44125, 44126, 44127, 44128, 44129,
    44130, 44131, 44132, 44133, 44134, 44135, 44136, 44137, 44138, 44139,
    44140, 44141, 44142, 44143, 44146, 44147, 44149, 44150, 44153, 44155,
    44156, 44157, 44308, 44309, 44310, 44311, 44313, 44314, 44315, 44317,
    44318, 44319, 44321, 44322, 44323, 44324, 44325, 44326, 44327, 44328,
    44330, 44331, 44334, 44335, 44336, 44337, 44338, 44339, 44342, 44343,
    44345, 44346, 44347, 44349, 44350, 44351, 44352, 44353, 44354, 44355,
    44358, 44360, 44362, 44363, 44364, 44365, 44366, 44367, 44369, 44370,
    44371, 44373, 44374, 44375, 44377, 44378, 44379, 44380, 44381, 44382,
    44383, 44384, 44386, 44388, 44389, 44390, 44391, 44392, 44393, 44394,
    44395, 44398, 44399, 44401, 44402, 44407, 44408, 44409, 44410, 44414,
    44416, 44419, 44420, 44421, 44422, 44423, 44538, 44539, 44541, 44542,
    44546, 44547, 44548, 44549, 44550, 44551, 44554, 44556, 44558, 44559,
    44560, 44561, 44562, 44563, 44565, 44566, 44567, 44568, 44569, 44570,
    44571, 44572, 44573, 44574, 44575, 44576, 44577, 44578, 44579, 44580,
    44581, 44582, 44583, 44584, 44585, 44586, 44587, 44588, 44589, 44590,
    44591, 44594, 44595, 44597, 44598, 44601, 44603, 44604, 44605, 44606,
    44607, 44610, 44612, 44615, 44616, 44617, 44619, 44623, 44625, 44626,
    44627, 44629, 44631, 44632, 44633, 44634, 44635, 44638, 44642, 44643,
    44644, 44646, 44647, 44650, 44651, 44653, 44654, 44655, 44657, 44658,
    44774, 44775, 44777, 44778, 44780, 44782, 44783, 44784, 44785, 44786,
    44787, 44789, 44790, 44791, 44793, 44794, 44795, 44797, 44798, 44799,
    44800, 44801, 44802, 44803, 44804, 44805, 44806, 44809, 44810, 44811,
    44812, 44814, 44815, 44817, 44818, 44819, 44820, 44821, 44822, 44823,
    44824, 44825, 44826, 44827, 44828, 44829, 44830, 44831, 44832, 44833,
    44834, 44835, 44836, 44837, 44838, 44839, 44840, 44841, 44842, 44843,
    44846, 44847, 44849, 44851, 44853, 44854, 44855, 44856, 44857, 44858,
    44859, 44862, 44864, 44868, 44869, 44870, 44871, 44874, 44875, 44876,
    44877, 44878, 44879, 44881, 44991, 44993, 44994, 44995, 44996, 44997,
    44998, 45002, 45004, 45007, 45008, 45009, 45010, 45011, 45013, 45014,
    45015, 45016, 45017, 45018, 45019, 45021, 45022, 45023, 45024, 45025,
    45026, 45027, 45028, 45029, 45030, 45031, 45034, 45035, 45036, 45037,
    45038, 45039, 45042, 45043, 45045, 45046, 45047, 45049, 45050, 45051,
    45052, 45053, 45054, 45055, 45058, 45059, 45061, 45062, 45063, 45064,
    45065, 45066, 45067, 45069, 45070, 45071, 45073, 45074, 45075, 45077,
    45078, 45079, 45080, 45081, 45082, 45083, 45086, 45087, 45088, 45089,
    45090, 45091, 45092, 45093, 45094, 45095, 45097, 45098, 45221, 45222,
    45223, 45226, 45232, 45234, 45238, 45239, 45241, 45242, 45243, 45245,
    45246, 45247, 45248, 45249, 45250, 45251, 45254, 45258, 45259, 45260,
    45261, 45262, 45263, 45266, 45267, 45269, 45270, 45271, 45273, 45274,
    45275, 45276, 45277, 45278, 45279, 45281, 45282, 45283, 45284, 45286,
    45287, 45288, 45289, 45290, 45291, 45292, 45293, 45294, 45295, 45296,
    45297, 45298, 45299, 45300, 45301, 45302, 45303, 45304, 45305, 45306,
    45307, 45308, 45309, 45310, 45311, 45312, 45313, 45314, 45315, 45316,
    45317, 45318, 45319, 45322, 45325, 45326, 45327, 45329, 45332, 45333,
    45334, 45335, 45470, 45471, 45472, 45473, 45474, 45475, 45476, 45477,
    45478, 45479, 45481, 45482, 45483, 45484, 45485, 45486, 45487, 45488,
    45489, 45490, 45491, 45492, 45493, 45494, 45495, 45496, 45497, 45498,
    45499, 45500, 45501, 45502, 45503, 45504, 45505, 45506, 45507, 45508,
    45509, 45510, 45511, 45512, 45513, 45514, 45515, 45517, 45518, 45519,
    45521, 45522, 45523, 45525, 45526, 45527, 45528, 45529, 45530, 45531,
    45534, 45536, 45537, 45538, 45539, 45540, 45541, 45542, 45543, 45546,
    45547, 45549, 45550, 45551, 45553, 45554, 45555, 45556, 45557, 45558,
    45559, 45560, 45562, 45564, 45566, 45567, 45679, 45680, 45681, 45682,
    45683, 45686, 45687, 45688, 45689, 45690, 45691, 45693, 45694, 45695,
    45696, 45697, 45698, 45699, 45702, 45703, 45704, 45706, 45707, 45708,
    45709, 45710, 45711, 45714, 45715, 45717, 45718, 45719, 45723, 45724,
    45725, 45726, 45727, 45730, 45732, 45735, 45736, 45737, 45739, 45741,
    45742, 45743, 45745, 45746, 45747, 45749, 45750, 45751, 45752, 45753,
    45754, 45755, 45756, 45757, 45758, 45759, 45760, 45761, 45762, 45763,
    45764, 45765, 45766, 45767, 45770, 45771, 45773, 45774, 45775, 45777,
    45779, 45780, 45781, 45782, 45783, 45786, 45788, 45790, 45791, 45792,
    45926, 45928, 45930, 45932, 45933, 45935, 45938, 45939, 45941, 45942,
    45943, 45945, 45946, 45947, 45948, 45949, 45950, 45951, 45954, 45958,
    45959, 45960, 45961, 45962, 45963, 45965, 45966, 45967, 45969, 45970,
    45971, 45973, 45974, 45975, 45976, 45977, 45978, 45979, 45980, 45981,
    45982, 45983, 45986, 45987, 45988, 45989, 45990, 45991, 45993, 45994,
    45995, 45997, 45998, 45999, 46000, 46001, 46002, 46003, 46004, 46005,
    46006, 46007, 46008, 46009, 46010, 46011, 46012, 46013, 46014, 46015,
    46016, 46017, 46018, 46019, 46022, 46023, 46025, 46026, 46029, 46031,
    46033, 46034, 46035, 46038, 46149, 46150, 46151, 46152, 46153, 46154,
    46155, 46156, 46157, 46158, 46159, 46162, 46163, 46165, 46166, 46167,
    46169, 46170, 46171, 46172, 46173, 46174, 46175, 46178, 46180, 46182,
    46183, 46184, 46185, 46186, 46187, 46189, 46190, 46191, 46192, 46193,
    46194, 46195, 46196, 46197, 46198, 46199, 46200, 46201, 46202, 46203,
    46204, 46205, 46206, 46207, 46209, 46210, 46211, 46212, 46213, 46214,
    46215, 46217, 46218, 46219, 46220, 46221, 46222, 46223, 46224, 46225,
    46226, 46227, 46228, 46229, 46230, 46231, 46232, 46233, 46234, 46235,
    46236, 46238, 46239, 46240, 46241, 46242, 46243, 46245, 46366, 46367,
    46368, 46369, 46370, 46371, 46374, 46379, 46380, 46381, 46382, 46383,
    46386, 46387, 46389, 46390, 46391, 46393, 46394, 46395, 46396, 46397,
    46398, 46399, 46402, 46406, 46407, 46408, 46409, 46410, 46414, 46415,
    46417, 46418, 46419, 46421, 46422, 46423, 46424, 46425, 46426, 46427,
    46430, 46434, 46435, 46436, 46437, 46438, 46439, 46440, 46441, 46442,
    46443, 46444, 46445, 46446, 46447, 46448, 46449, 46450, 46451, 46452,
    46453, 46454, 46455, 46456, 46457, 46458, 46459, 46460, 46461, 46462,
    46463, 46464, 46465, 46466, 46467, 46468, 46469, 46470, 46471, 46472,
    46473, 46474, 46592, 46593, 46594, 46595, 46596, 46597, 46598, 46599,
    46600, 46601, 46602, 46603, 46604, 46605, 46606, 46607, 46610, 46611,
    46613, 46614, 46615, 46617, 46618, 46619, 46620, 46621, 46622, 46623,
    46624, 46625, 46626, 46627, 46628, 46630, 46631, 46632, 46633, 46634,
    46635, 46637, 46638, 46639, 46640, 46641, 46642, 46643, 46645, 46646,
    46647, 46648, 46649, 46650, 46651, 46652, 46653, 46654, 46655, 46656,
    46657, 46658, 46659, 46660, 46661, 46662, 46663, 46665, 46666, 46667,
    46668, 46669, 46670, 46671, 46672, 46673, 46674, 46675, 46676, 46677,
    46678, 46679, 46680, 46681, 46682, 46683, 46787, 46788, 46789, 46790,
    46791, 46792, 46793, 46794, 46795, 46796, 46797, 46798, 46799, 46800,
    46801, 46802, 46803, 46805, 46806, 46807, 46808, 46809, 46810, 46811,
    46812, 46813, 46814, 46815, 46816, 46817, 46818, 46819, 46820, 46821,
    46822, 46823, 46824, 46825, 46826, 46827, 46828, 46829, 46830, 46831,
    46833, 46834, 46835, 46837, 46838, 46839, 46841, 46842, 46843, 46844,
    46845, 46846, 46847, 46850, 46851, 46852, 46854, 46855, 46856, 46857,
    46858, 46859, 46860, 46861, 46862, 46863, 46864, 46865, 46866, 46867,
    46868, 46869, 46870, 46871, 46872, 46873, 46874, 46875, 46876, 46877,
    47007, 47009, 47010, 47011, 47012, 47013, 47014, 47015, 47018, 47022,
    47023, 47024, 47025, 47026, 47027, 47030, 47031, 47033, 47034, 47035,
    47036, 47037, 47038, 47039, 47040, 47041, 47042, 47043, 47044, 47045,
    47046, 47048, 47050, 47051, 47052, 47053, 47054, 47055, 47056, 47057,
    47058, 47059, 47060, 47061, 47062, 47063, 47064, 47065, 47066, 47067,
    47068, 47069, 47070, 47071, 47072, 47073, 47074, 47075, 47076, 47077,
    47078, 47079, 47080, 47081, 47082, 47083, 47086, 47087, 47089, 47090,
    47091, 47093, 47094, 47095, 47096, 47097, 47098, 47099, 47102, 47106,
    47107, 47108, 47109, 47110, 47237, 47238, 47239, 47240, 47241, 47242,
    47243, 47244, 47246, 47247, 47248, 47249, 47250, 47251, 47252, 47253,
    47254, 47255, 47256, 47257, 47258, 47259, 47260, 47261, 47262, 47263,
    47264, 47265, 47266, 47267, 47268, 47269, 47270, 47271, 47273, 47274,
    47275, 47276, 47277, 47278, 47279, 47281, 47282, 47283, 47285, 47286,
    47287, 47289, 47290, 47291, 47292, 47293, 47294, 47295, 47298, 47300,
    47302, 47303, 47304, 47305, 47306, 47307, 47309, 47310, 47311, 47313,
    47314, 47315, 47317, 47318, 47319, 47320, 47321, 47322, 47323, 47324,
    47326, 47328, 47330, 47331, 47332, 47333, 47334, 47335, 47450, 47451,
    47453, 47454, 47455, 47457, 47458, 47459, 47460, 47461, 47462, 47463,
    47466, 47468, 47470, 47471, 47472, 47473, 47474, 47475, 47478, 47479,
    47481, 47482, 47483, 47485, 47486, 47487, 47488, 47489, 47490, 47491,
    47494, 47496, 47499, 47500, 47503, 47504, 47505, 47506, 47507, 47508,
    47509, 47510, 47511, 47512, 47513, 47514, 47515, 47516, 47517, 47518,
    47519, 47520, 47521, 47522, 47523, 47524, 47525, 47526, 47527, 47528,
    47529, 47530, 47531, 47534, 47535, 47537, 47538, 47539, 47541, 47542,
    47543, 47544, 47545, 47546, 47547, 47550, 47552, 47554, 47555, 47556,
    47557, 47558, 47687, 47690, 47692, 47695, 47696, 47697, 47698, 47702,
    47703, 47705, 47706, 47707, 47709, 47710, 47711, 47712, 47713, 47714,
    47715, 47718, 47722, 47723, 47724, 47725, 47726, 47727, 47730, 47731,
    47733, 47734, 47735, 47737, 47738, 47739, 47740, 47741, 47742, 47743,
    47744, 47745, 47746, 47750, 47752, 47753, 47754, 47755, 47757, 47758,
    47759, 47760, 47761, 47762, 47763, 47764, 47765, 47766, 47767, 47768,
    47769, 47770, 47771, 47772, 47773, 47774, 47775, 47776, 47777, 47778,
    47779, 47780, 47781, 47782, 47783, 47786, 47789, 47790, 47791, 47793,
    47795, 47796, 47797, 47798, 47799, 47802, 47912, 47914, 47916, 47917,
    47918, 47919, 47920, 47921, 47922, 47923, 47927, 47929, 47930, 47935,
    47936, 47937, 47938, 47939, 47942, 47944, 47946, 47947, 47948, 47950,
    47953, 47954, 47955, 47957, 47958, 47959, 47961, 47962, 47963, 47964,
    47965, 47966, 47967, 47968, 47970, 47972, 47973, 47974, 47975, 47976,
    47977, 47978, 47979, 47981, 47982, 47983, 47984, 47985, 47986, 47987,
    47988, 47989, 47990, 47991, 47992, 47993, 47994, 47995, 47996, 47997,
    47998, 47999, 48000, 48001, 48002, 48003, 48004, 48005, 48006, 48007,
    48009, 48010, 48011, 48013, 48014, 48015, 48017, 48018, 48019, 48020,
    48131, 48132, 48133, 48134, 48135, 48138, 48142, 48144, 48146, 48147,
    48153, 48154, 48160, 48161, 48162, 48163, 48166, 48168, 48170, 48171,
    48172, 48174, 48175, 48178, 48179, 48181, 48182, 48183, 48185, 48186,
    48187, 48188, 48189, 48190, 48191, 48194, 48198, 48199, 48200, 48202,
    48203, 48206, 48207, 48209, 48210, 48211, 48212, 48213, 48214, 48215,
    48216, 48217, 48218, 48219, 48220, 48222, 48223, 48224, 48225, 48226,
    48227, 48228, 48229, 48230, 48231, 48232, 48233, 48234, 48235, 48236,
    48237, 48238, 48239, 48240, 48241, 48242, 48243, 48244, 48245, 48246,
    48247, 48248, 48249, 48250, 48382, 48383, 48384, 48385, 48386, 48387,
    48390, 48392, 48394, 48395, 48396, 48397, 48398, 48399, 48401, 48402,
    48403, 48405, 48406, 48407, 48408, 48409, 48410, 48411, 48412, 48413,
    48414, 48415, 48416, 48417, 48418, 48419, 48421, 48422, 48423, 48424,
    48425, 48426, 48427, 48429, 48430, 48431, 48432, 48433, 48434, 48435,
    48436, 48437, 48438, 48439, 48440, 48441, 48442, 48443, 48444, 48445,
    48446, 48447, 48449, 48450, 48451, 48452, 48453, 48454, 48455, 48458,
    48459, 48461, 48462, 48463, 48465, 48466, 48467, 48468, 48469, 48470,
    48471, 48474, 48475, 48476, 48477, 48478, 48479, 48480, 48594, 48595,
    48598, 48599, 48601, 48602, 48603, 48605, 48606, 48607, 48608, 48609,
    48610, 48611, 48612, 48613, 48614, 48615, 48616, 48618, 48619, 48620,
    48621, 48622, 48623, 48625, 48626, 48627, 48629, 48630, 48631, 48633,
    48634, 48635, 48636, 48637, 48638, 48639, 48641, 48642, 48644, 48646,
    48647, 48648, 48649, 48650, 48651, 48654, 48655, 48657, 48658, 48659,
    48661, 48662, 48663, 48664, 48665, 48666, 48667, 48670, 48672, 48673,
    48674, 48675, 48676, 48677, 48678, 48679, 48680, 48681, 48682, 48683,
    48684, 48685, 48686, 48687, 48688, 48689, 48690, 48691, 48692, 48693,
    48694, 48695, 48824, 48825, 48826, 48827, 48828, 48829, 48830, 48831,
    48832, 48833, 48834, 48835, 48836, 48837, 48838, 48839, 48840, 48841,
    48842, 48843, 48844, 48845, 48846, 48847, 48850, 48851, 48853, 48854,
    48857, 48858, 48859, 48860, 48861, 48862, 48863, 48865, 48866, 48870,
    48871, 48872, 48873, 48874, 48875, 48877, 48878, 48879, 48880, 48881,
    48882, 48883, 48884, 48885, 48886, 48887, 48888, 48889, 48890, 48891,
    48892, 48893, 48894, 48895, 48896, 48898, 48899, 48900, 48901, 48902,
    48903, 48906, 48907, 48908, 48909, 48910, 48911, 48912, 48913, 48914,
    48915, 48916, 48917, 48918, 48919, 48922, 49027, 49028, 49029, 49030,
    49031, 49032, 49033, 49034, 49035, 49036, 49037, 49038, 49039, 49040,
    49041, 49042, 49043, 49045, 49046, 49047, 49048, 49049, 49050, 49051,
    49052, 49053, 49054, 49055, 49056, 49057, 49058, 49059, 49060, 49061,
    49062, 49063, 49064, 49065, 49066, 49067, 49068, 49069, 49070, 49071,
    49073, 49074, 49075, 49076, 49077, 49078, 49079, 49080, 49081, 49082,
    49083, 49084, 49085, 49086, 49087, 49088, 49089, 49090, 49091, 49092,
    49094, 49095, 49096, 49097, 49098, 49099, 49102, 49103, 49105, 49106,
    49107, 49109, 49110, 49111, 49112, 49113, 49114, 49115, 49117, 49118,
    49216, 49217, 49218, 49219, 49220, 49221, 49222, 49223, 49224, 49225,
    49226, 49227, 49228, 49229, 49230, 49231, 49232, 49234, 49235, 49236,
    49237, 49238, 49239, 49241, 49242, 49243, 49245, 49246, 49247, 49249,
    49250, 49251, 49252, 49253, 49254, 49255, 49258, 49259, 49260, 49261,
    49262, 49263, 49264, 49265, 49266, 49267, 49268, 49269, 49270, 49271,
    49272, 49273, 49274, 49275, 49276, 49277, 49278, 49279, 49280, 49281,
    49282, 49283, 49284, 49285, 49286, 49287, 49288, 49289, 49290, 49291,
    49292, 49293, 49294, 49295, 49298, 49299, 49301, 49302, 49303, 49305,
    49306, 49307, 49308, 49309, 49458, 49459, 49460, 49461, 49463, 49466,
    49467, 49469, 49470, 49471, 49473, 49474, 49475, 49476, 49477, 49478,
    49479, 49482, 49486, 49487, 49488, 49489, 49490, 49491, 49494, 49495,
    49497, 49498, 49499, 49501, 49502, 49503, 49504, 49505, 49506, 49507,
    49510, 49514, 49515, 49516, 49517, 49518, 49519, 49521, 49522, 49523,
    49525, 49526, 49527, 49529, 49530, 49531, 49532, 49533, 49534, 49535,
    49536, 49537, 49538, 49539, 49540, 49542, 49543, 49544, 49545, 49546,
    49547, 49551, 49553, 49554, 49555, 49557, 49559, 49560, 49561, 49562,
    49563, 49566, 49568, 49570, 49571, 49572, 49574, 49575, 49700, 49701,
    49702, 49703, 49706, 49708, 49710, 49712, 49715, 49717, 49718, 49719,
    49720, 49721, 49722, 49723, 49724, 49725, 49726, 49727, 49728, 49729,
    49730, 49731, 49732, 49733, 49734, 49735, 49737, 49738, 49739, 49740,
    49741, 49742, 49743, 49746, 49747, 49749, 49750, 49751, 49753, 49754,
    49755, 49756, 49757, 49758, 49759, 49761, 49762, 49763, 49764, 49766,
    49767, 49768, 49769, 49770, 49771, 49774, 49775, 49777, 49778, 49779,
    49781, 49782, 49783, 49784, 49785, 49786, 49787, 49790, 49792, 49794,
    49795, 49796, 49797, 49798, 49799, 49802, 49803, 49804, 49805, 49806,
    49807, 49809, 49936, 49937, 49938, 49942, 49943, 49945, 49946, 49947,
    49949, 49950, 49951, 49952, 49953, 49954, 49955, 49958, 49959, 49962,
    49963, 49964, 49965, 49966, 49967, 49968, 49969, 49970, 49971, 49972,
    49973, 49974, 49975, 49976, 49977, 49978, 49979, 49980, 49981, 49982,
    49983, 49984, 49985, 49986, 49987, 49988, 49990, 49991, 49992, 49993,
    49994, 49995, 49996, 49997, 49998, 49999, 50000, 50001, 50002, 50003,
    50004, 50005, 50006, 50007, 50008, 50009, 50010, 50011, 50012, 50013,
    50014, 50015, 50016, 50017, 50018, 50019, 50020, 50021, 50022, 50023,
    50026, 50027, 50029, 50030, 50031, 50033, 50139, 50141, 50142, 50145,
    50147, 50148, 50149, 50150, 50151, 50154, 50155, 50156, 50158, 50159,
    50160, 50161, 50162, 50163, 50166, 50167, 50169, 50170, 50171, 50172,
    50173, 50174, 50175, 50176, 50177, 50178, 50179, 50180, 50181, 50182,
    50183, 50185, 50186, 50187, 50188, 50189, 50190, 50191, 50193, 50194,
    50195, 50196, 50197, 50198, 50199, 50200, 50201, 50202, 50203, 50204,
    50205, 50206, 50207, 50208, 50209, 50210, 50211, 50213, 50214, 50215,
    50216, 50217, 50218, 50219, 50221, 50222, 50223, 50225, 50226, 50227,
    50229, 50230, 50231, 50232, 50233, 50234, 50235, 50238, 50239, 50240,
    50346, 50347, 50348, 50349, 50350, 50351, 50352, 50353, 50354, 50355,
    50356, 50357, 50358, 50359, 50361, 50362, 50363, 50365, 50366, 50367,
    50368, 50369, 50370, 50371, 50372, 50373, 50374, 50375, 50376, 50377,
    50378, 50379, 50380, 50381, 50382, 50383, 50384, 50385, 50386, 50387,
    50388, 50389, 50390, 50391, 50392, 50393, 50394, 50395, 50396, 50397,
    50398, 50399, 50400, 50401, 50402, 50403, 50404, 50405, 50406, 50407,
    50408, 50410, 50411, 50412, 50413, 50414, 50415, 50418, 50419, 50421,
    50422, 50423, 50425, 50427, 50428, 50429, 50430, 50434, 50435, 50436,
    50437, 50438, 50439, 50440, 50582, 50585, 50586, 50587, 50589, 50590,
    50591, 50593, 50594, 50595, 50596, 50597, 50598, 50599, 50600, 50602,
    50603, 50604, 50605, 50606, 50607, 50608, 50609, 50610, 50611, 50614,
    50615, 50618, 50623, 50624, 50625, 50626, 50627, 50635, 50637, 50639,
    50642, 50643, 50645, 50646, 50647, 50649, 50650, 50651, 50652, 50653,
    50654, 50655, 50658, 50660, 50662, 50663, 50664, 50665, 50666, 50667,
    50671, 50673, 50674, 50675, 50677, 50680, 50681, 50682, 50683, 50690,
    50691, 50692, 50697, 50698, 50699, 50701, 50702, 50703, 50705, 50706,
    50707, 50708, 50709, 50710, 50711, 50714, 50717, 50718, 50856, 50858,
    50859, 50860, 50861, 50862, 50863, 50866, 50867, 50869, 50870, 50871,
    50875, 50876, 50877, 50878, 50879, 50882, 50884, 50886, 50887, 50888,
    50889, 50890, 50891, 50894, 50895, 50897, 50898, 50899, 50901, 50902,
    50903, 50904, 50905, 50906, 50907, 50910, 50911, 50914, 50915, 50916,
    50917, 50918, 50919, 50922, 50923, 50925, 50926, 50927, 50929, 50930,
    50931, 50932, 50933, 50934, 50935, 50938, 50939, 50940, 50942, 50943,
    50944, 50945, 50946, 50947, 50950, 50951, 50953, 50954, 50955, 50957,
    50958, 50959, 50960, 50961, 50962, 50963, 50966, 50968, 50970, 50971,
    50972, 50973, 51128, 51129, 51130, 51131, 51134, 51138, 51139, 51140,
    51141, 51142, 51143, 51146, 51147, 51149, 51151, 51153, 51154, 51155,
    51156, 51157, 51158, 51159, 51161, 51162, 51163, 51164, 51166, 51167,
    51168, 51169, 51170, 51171, 51173, 51174, 51175, 51177, 51178, 51179,
    51181, 51182, 51183, 51184, 51185, 51186, 51187, 51188, 51189, 51190,
    51191, 51192, 51193, 51194, 51195, 51196, 51197, 51198, 51199, 51202,
    51203, 51205, 51206, 51207, 51209, 51211, 51212, 51213, 51214, 51215,
    51218, 51220, 51223, 51224, 51225, 51226, 51227, 51230, 51231, 51233,
    51234, 51235, 51237, 51238, 51239, 51240, 51365, 51366, 51367, 51369,
    51370, 51371, 51372, 51373, 51374, 51375, 51376, 51377, 51378, 51379,
    51380, 51381, 51382, 51383, 51384, 51385, 51386, 51387, 51390, 51391,
    51392, 51393, 51394, 51395, 51397, 51398, 51399, 51401, 51402, 51403,
    51405, 51406, 51407, 51408, 51409, 51410, 51411, 51414, 51416, 51418,
    51419, 51420, 51421, 51422, 51423, 51426, 51427, 51429, 51430, 51431,
    51432, 51433, 51434, 51435, 51436, 51437, 51438, 51439, 51440, 51441,
    51442, 51443, 51444, 51446, 51447, 51448, 51449, 51450, 51451, 51454,
    51455, 51457, 51458, 51459, 51463, 51464, 51465, 51466, 51467, 51470,
    51472, 51474, 51475, 51476, 51477, 51478, 51479, 51481, 51482, 51483,
    51484, 51485, 51486, 51487, 51488, 51489, 51490, 51491, 51492, 51493,
    51494, 51495, 51496, 51497, 51498, 51499, 51501, 51502, 51503, 51504,
    51505, 51506, 51507, 51509, 51510, 51511, 51512, 51513, 51514, 51515,
    51516, 51517, 51518, 51519, 51520, 51521, 51522, 51523, 51524, 51525,
    51526, 51527, 51528, 51529, 51530, 51531, 51532, 51533, 51534, 51535,
    51538, 51539, 51541, 51542, 51543, 51545, 51546, 51547, 51548, 51549,
    51550, 51551, 51554, 51556, 51557, 51558, 51559, 51560, 51561, 51562,
    51563, 51565, 51566, 51567, 51569, 51570, 51571, 51573, 51574, 51575,
    51576, 51577, 51578, 51579, 51581, 51582, 51583, 51584, 51585, 51586,
    51587, 51588, 51589, 51590, 51591, 51594, 51595, 51597, 51598, 51599,
    51601, 51602, 51603, 51604, 51605, 51606, 51607, 51610, 51612, 51614,
    51615, 51616, 51617, 51618, 51619, 51620, 51621, 51622, 51623, 51624,
    51625, 51626, 51627, 51628, 51629, 51630, 51631, 51632, 51633, 51634,
    51635, 51636, 51637, 51638, 51639, 51640, 51641, 51642, 51643, 51644,
    51645, 51646, 51647, 51650, 51651, 51653, 51654, 51657, 51659, 51660,
    51661, 51662, 51663, 51666, 51668, 51671, 51672, 51675, 51678, 51679,
    51681, 51683, 51685, 51686, 51688, 51689, 51690, 51691, 51694, 51698,
    51699, 51700, 51701, 51702, 51703, 51706, 51707, 51709, 51710, 51711,
    51713, 51714, 51715, 51716, 51717, 51718, 51719, 51722, 51726, 51727,
    51728, 51729, 51730, 51731, 51733, 51734, 51735, 51737, 51738, 51739,
    51740, 51741, 51742, 51743, 51744, 51745, 51746, 51747, 51748, 51749,
    51750, 51751, 51752, 51754, 51755, 51756, 51757, 51758, 51759, 51760,
    51761, 51762, 51763, 51764, 51765, 51766, 51767, 51768, 51769, 51770,
    51771, 51772, 51773, 51774, 51775, 51776, 51777, 51778, 51779, 51780,
    51781, 51782, 51783, 51784, 51785, 51786, 51787, 51790, 51791, 51793,
    51794, 51795, 51797, 51798, 51799, 51800, 51801, 51802, 51803, 51806,
    51810, 51811, 51812, 51813, 51814, 51815, 51817, 51818, 51819, 51820,
    51821, 51822, 51823, 51824, 51825, 51826, 51827, 51828, 51829, 51830,
    51831, 51832, 51833, 51834, 51835, 51836, 51838, 51839, 51840, 51841,
    51842, 51843, 51845, 51846, 51847, 51848, 51849, 51850, 51851, 51852,
    51853, 51854, 51855, 51856, 51857, 51858, 51859, 51860, 51861, 51862,
    51863, 51865, 51866, 51867, 51868, 51869, 51870, 51871, 51872, 51873,
    51874, 51875, 51876, 51877, 51878, 51879, 51880, 51881, 51882, 51883,
    51884, 51885, 51886, 51887, 51888, 51889, 51890, 51891, 51892, 51893,
    51894, 51895, 51896, 51897, 51898, 51899, 51902, 51903, 51905, 51906,
    51907, 51909, 51910, 51911, 51912, 51913, 51914, 51915, 51918, 51920,
    51922, 51924, 51925, 51926, 51927, 51930, 51931, 51932, 51933, 51934,
    51935, 51937, 51938, 51939, 51940, 51941, 51942, 51943, 51944, 51945,
    51946, 51947, 51949, 51950, 51951, 51952, 51953, 51954, 51955, 51957,
    51958, 51959, 51960, 51961, 51962, 51963, 51964, 51965, 51966, 51967,
    51968, 51969, 51970, 51971, 51972, 51973, 51974, 51975, 51977, 51978,
    51979, 51980, 51981, 51982, 51983, 51985, 51986, 51987, 51989, 51990,
    51991, 51993, 51994, 51995, 51996, 51997, 51998, 51999, 52002, 52003,
    52004, 52005, 52006, 52007, 52008, 52009, 52010, 52011, 52012, 52013,
    52014, 52015, 52016, 52017, 52018, 52019, 52020, 52021, 52022, 52023,
    52024, 52025, 52026, 52027, 52028, 52029, 52030, 52031, 52032, 52034,
    52035, 52036, 52037, 52038, 52039, 52042, 52043, 52045, 52046, 52047,
    52049, 52050, 52051, 52052, 52053, 52054, 52055, 52058, 52059, 52060,
    52062, 52063, 52064, 52065, 52066, 52067, 52069, 52070, 52071, 52072,
    52073, 52074, 52075, 52076, 52077, 52078, 52079, 52080, 52081, 52082,
    52083, 52084, 52085, 52086, 52087, 52090, 52091, 52092, 52093, 52094,
    52095, 52096, 52097, 52098, 52099, 52100, 52101, 52102, 52103, 52104,
    52105, 52106, 52107, 52108, 52109, 52110, 52111, 52112, 52113, 52114,
    52115, 52116, 52117, 52118, 52119, 52120, 52121, 52122, 52123, 52125,
    52126, 52127, 52128, 52129, 52130, 52131, 52132, 52133, 52134, 52135,
    52136, 52137, 52138, 52139, 52140, 52141, 52142, 52143, 52144, 52145,
    52146, 52147, 52148, 52149, 52150, 52151, 52153, 52154, 52155, 52156,
    52157, 52158, 52159, 52160, 52161, 52162, 52163, 52164, 52165, 52166,
    52167, 52168, 52169, 52170, 52171, 52172, 52173, 52174, 52175, 52176,
    52177, 52178, 52179, 52181, 52182, 52183, 52184, 52185, 52186, 52187,
    52188, 52189, 52190, 52191, 52192, 52193, 52194, 52195, 52197, 52198,
    52200, 52202, 52203, 52204, 52205, 52206, 52207, 52208, 52209, 52210,
    52211, 52212, 52213, 52214, 52215, 52216, 52217, 52218, 52219, 52220,
    52221, 52222, 52223, 52224, 52225, 52226, 52227, 52228, 52229, 52230,
    52231, 52232, 52233, 52234, 52235, 52238, 52239, 52241, 52242, 52243,
    52245, 52246, 52247, 52248, 52249, 52250, 52251, 52254, 52255, 52256,
    52259, 52260, 52261, 52262, 52266, 52267, 52269, 52271, 52273, 52274,
    52275, 52276, 52277, 52278, 52279, 52282, 52287, 52288, 52289, 52290,
    52291, 52294, 52295, 52297, 52298, 52299, 52301, 52302, 52303, 52304,
    52305, 52306, 52307, 52310, 52314, 52315, 52316, 52317, 52318, 52319,
    52321, 52322, 52323, 52325, 52327, 52329, 52330, 52331, 52332, 52333,
    52334, 52335, 52337, 52338, 52339, 52340, 52342, 52343, 52344, 52345,
    52346, 52347, 52348, 52349, 52350, 52351, 52352, 52353, 52354, 52355,
    52356, 52357, 52358, 52359, 52360, 52361, 52362, 52363, 52364, 52365,
    52366, 52367, 52368, 52369, 52370, 52371, 52372, 52373, 52374, 52375,
    52378, 52379, 52381, 52382, 52383, 52385, 52386, 52387, 52388, 52389,
    52390, 52391, 52394, 52398, 52399, 52400, 52401, 52402, 52403, 52406,
    52407, 52409, 52410, 52411, 52413, 52414, 52415, 52416, 52417, 52418,
    52419, 52422, 52424, 52426, 52427, 52428, 52429, 52430, 52431, 52433,
    52434, 52435, 52437, 52438, 52439, 52440, 52441, 52442, 52443, 52444,
    52445, 52446, 52447, 52448, 52449, 52450, 52451, 52453, 52454, 52455,
    52456, 52457, 52458, 52459, 52461, 52462, 52463, 52465, 52466, 52467,
    52468, 52469, 52470, 52471, 52472, 52473, 52474, 52475, 52476, 52477,
    52478, 52479, 52480, 52482, 52483, 52484, 52485, 52486, 52487, 52490,
    52491, 52493, 52494, 52495, 52497, 52498, 52499, 52500, 52501, 52502,
    52503, 52506, 52508, 52510, 52511, 52512, 52513, 52514, 52515, 52517,
    52518, 52519, 52521, 52522, 52523, 52525, 52526, 52527, 52528, 52529,
    52530, 52531, 52532, 52533, 52534, 52535, 52536, 52538, 52539, 52540,
    52541, 52542, 52543, 52544, 52545, 52546, 52547, 52548, 52549, 52550,
    52551, 52552, 52553, 52554, 52555, 52556, 52557, 52558, 52559, 52560,
    52561, 52562, 52563, 52564, 52565, 52566, 52567, 52568, 52569, 52570,
    52571, 52573, 52574, 52575, 52577, 52578, 52579, 52581, 52582, 52583,
    52584, 52585, 52586, 52587, 52590, 52592, 52594, 52595, 52596, 52597,
    52598, 52599, 52601, 52602, 52603, 52604, 52605, 52606, 52607, 52608,
    52609, 52610, 52611, 52612, 52613, 52614, 52615, 52617, 52618, 52619,
    52620, 52621, 52622, 52623, 52624, 52625, 52626, 52627, 52630, 52631,
    52633, 52634, 52635, 52637, 52638, 52639, 52640, 52641, 52642, 52643,
    52646, 52648, 52650, 52651, 52652, 52653, 52654, 52655, 52657, 52658,
    52659, 52660, 52661, 52662, 52663, 52664, 52665, 52666, 52667, 52668,
    52669, 52670, 52671, 52672, 52673, 52674, 52675, 52677, 52678, 52679,
    52680, 52681, 52682, 52683, 52685, 52686, 52687, 52689, 52690, 52691,
    52692, 52693, 52694, 52695, 52696, 52697, 52698, 52699, 52700, 52701,
    52702, 52703, 52704, 52705, 52706, 52707, 52708, 52709, 52710, 52711,
    52713, 52714, 52715, 52717, 52718, 52719, 52721, 52722, 52723, 52724,
    52725, 52726, 52727, 52730, 52732, 52734, 52735, 52736, 52737, 52738,
    52739, 52741, 52742, 52743, 52745, 52746, 52747, 52749, 52750, 52751,
    52752, 52753, 52754, 52755, 52757, 52758, 52759, 52760, 52762, 52763,
    52764, 52765, 52766, 52767, 52770, 52771, 52773, 52774, 52775, 52777,
    52778, 52779, 52780, 52781, 52782, 52783, 52786, 52788, 52790, 52791,
    52792, 52793, 52794, 52795, 52796, 52797, 52798, 52799, 52800, 52801,
    52802, 52803, 52804, 52805, 52806, 52807, 52808, 52809, 52810, 52811,
    52812, 52813, 52814, 52815, 52816, 52817, 52818, 52819, 52820, 52821,
    52822, 52823, 52826, 52827, 52829, 52830, 52834, 52835, 52836, 52837,
    52838, 52839, 52842, 52844, 52846, 52847, 52848, 52849, 52850, 52851,
    52854, 52855, 52857, 52858, 52859, 52861, 52862, 52863, 52864, 52865,
    52866, 52867, 52870, 52872, 52874, 52875, 52876, 52877, 52878, 52879,
    52882, 52883, 52885, 52886, 52887, 52889, 52890, 52891, 52892, 52893,
    52894, 52895, 52898, 52902, 52903, 52904, 52905, 52906, 52907, 52910,
    52911, 52912, 52913, 52914, 52915, 52916, 52917, 52918, 52919, 52920,
    52921, 52922, 52923, 52924, 52925, 52926, 52927, 52928, 52930, 52931,
    52932, 52933, 52934, 52935, 52936, 52937, 52938, 52939, 52940, 52941,
    52942, 52943, 52944, 52945, 52946, 52947, 52948, 52949, 52950, 52951,
    52952, 52953, 52954, 52955, 52956, 52957, 52958, 52959, 52960, 52961,
    52962, 52963, 52966, 52967, 52969, 52970, 52973, 52974, 52975, 52976,
    52977, 52978, 52979, 52982, 52986, 52987, 52988, 52989, 52990, 52991,
    52994, 52995, 52997, 52998, 52999, 53001, 53002, 53003, 53004, 53005,
    53006, 53007, 53010, 53012, 53014, 53015, 53016, 53017, 53018, 53019,
    53021, 53022, 53023, 53025, 53026, 53027, 53029, 53030, 53031, 53032,
    53033, 53034, 53035, 53038, 53042, 53043, 53044, 53045, 53046, 53047,
    53049, 53050, 53051, 53052, 53053, 53054, 53055, 53056, 53057, 53058,
    53059, 53060, 53061, 53062, 53063, 53064, 53065, 53066, 53067, 53068,
    53069, 53070, 53071, 53072, 53073, 53074, 53075, 53078, 53079, 53081,
    53082, 53083, 53085, 53086, 53087, 53088, 53089, 53090, 53091, 53094,
    53096, 53098, 53099, 53100, 53101, 53102, 53103, 53106, 53107, 53109,
    53110, 53111, 53113, 53114, 53115, 53116, 53117, 53118, 53119, 53121,
    53122, 53123, 53124, 53126, 53127, 53128, 53129, 53130, 53131, 53133,
    53134, 53135, 53136, 53137, 53138, 53139, 53140, 53141, 53142, 53143,
    53144, 53145, 53146, 53147, 53148, 53149, 53150, 53151, 53152, 53154,
    53155, 53156, 53157, 53158, 53159, 53161, 53162, 53163, 53164, 53165,
    53166, 53167, 53169, 53170, 53171, 53172, 53173, 53174, 53175, 53176,
    53177, 53178, 53179, 53180, 53181, 53182, 53183, 53184, 53185, 53186,
    53187, 53189, 53190, 53191, 53192, 53193, 53194, 53195, 53196, 53197,
    53198, 53199, 53200, 53201, 53202, 53203, 53204, 53205, 53206, 53207,
    53208, 53209, 53210, 53211, 53212, 53213, 53214, 53215, 53218, 53219,
    53221, 53222, 53223, 53225, 53226, 53227, 53228, 53229, 53230, 53231,
    53234, 53236, 53238, 53239, 53240, 53241, 53242, 53243, 53245, 53246,
    53247, 53249, 53250, 53251, 53253, 53254, 53255, 53256, 53257, 53258,
    53259, 53260, 53261, 53262, 53263, 53264, 53266, 53267, 53268, 53269,
    53270, 53271, 53273, 53274, 53275, 53276, 53277, 53278, 53279, 53280,
    53281, 53282, 53283, 53284, 53285, 53286, 53287, 53288, 53289, 53290,
    53291, 53292, 53294, 53295, 53296, 53297, 53298, 53299, 53302, 53303,
    53305, 53306, 53307, 53309, 53310, 53311, 53312, 53313, 53314, 53315,
    53318, 53320, 53322, 53323, 53324, 53325, 53326, 53327, 53329, 53330,
    53331, 53333, 53334, 53335, 53337, 53338, 53339, 53340, 53341, 53342,
    53343, 53345, 53346, 53347, 53348, 53349, 53350, 53351, 53352, 53353,
    53354, 53355, 53358, 53359, 53361, 53362, 53363, 53365, 53366, 53367,
    53368, 53369, 53370, 53371, 53374, 53375, 53376, 53378, 53379, 53380,
    53381, 53382, 53383, 53384, 53385, 53386, 53387, 53388, 53389, 53390,
    53391, 53392, 53393, 53394, 53395, 53396, 53397, 53398, 53399, 53400,
    53401, 53402, 53403, 53404, 53405, 53406, 53407, 53408, 53409, 53410,
    53411, 53414, 53415, 53417, 53418, 53419, 53421, 53422, 53423, 53424,
    53425, 53426, 53427, 53430, 53432, 53434, 53435, 53436, 53437, 53438,
    53439, 53442, 53443, 53445, 53446, 53447, 53450, 53451, 53452, 53453,
    53454, 53455, 53458, 53462, 53463, 53464, 53465, 53466, 53467, 53470,
    53471, 53473, 53474, 53475, 53477, 53478, 53479, 53480, 53481, 53482,
    53483, 53486, 53490, 53491, 53492, 53493, 53494, 53495, 53497, 53498,
    53499, 53500, 53501, 53502, 53503, 53504, 53505, 53506, 53507, 53508,
    53509, 53510, 53511, 53512, 53513, 53514, 53515, 53516, 53518, 53519,
    53520, 53521, 53522, 53523, 53524, 53525, 53526, 53527, 53528, 53529,
    53530, 53531, 53532, 53533, 53534, 53535, 53536, 53537, 53538, 53539,
    53540, 53541, 53542, 53543, 53544, 53545, 53546, 53547, 53548, 53549,
    53550, 53551, 53554, 53555, 53557, 53558, 53559, 53561, 53563, 53564,
    53565, 53566, 53567, 53570, 53574, 53575, 53576, 53577, 53578, 53579,
    53582, 53583, 53585, 53586, 53587, 53589, 53590, 53591, 53592, 53593,
    53594, 53595, 53598, 53600, 53602, 53603, 53604, 53605, 53606, 53607,
    53609, 53610, 53611, 53613, 53614, 53615, 53616, 53617, 53618, 53619,
    53620, 53621, 53622, 53623, 53624, 53625, 53626, 53627, 53629, 53630,
    53631, 53632, 53633, 53634, 53635, 53637, 53638, 53639, 53641, 53642,
    53643, 53644, 53645, 53646, 53647, 53648, 53649, 53650, 53651, 53652,
    53653, 53654, 53655, 53656, 53657, 53658, 53659, 53660, 53661, 53662,
    53663, 53666, 53667, 53669, 53670, 53671, 53673, 53674, 53675, 53676,
    53677, 53678, 53679, 53682, 53684, 53686, 53687, 53688, 53689, 53691,
    53693, 53694, 53695, 53697, 53698, 53699, 53700, 53701, 53702, 53703,
    53704, 53705, 53706, 53707, 53708, 53709, 53710, 53711, 53712, 53713,
    53714, 53715, 53716, 53717, 53718, 53719, 53721, 53722, 53723, 53724,
    53725, 53726, 53727, 53728, 53729, 53730, 53731, 53732, 53733, 53734,
    53735, 53736, 53737, 53738, 53739, 53740, 53741, 53742, 53743, 53744,
    53745, 53746, 53747, 53749, 53750, 53751, 53753, 53754, 53755, 53756,
    53757, 53758, 53759, 53760, 53761, 53762, 53763, 53764, 53765, 53766,
    53768, 53770, 53771, 53772, 53773, 53774, 53775, 53777, 53778, 53779,
    53780, 53781, 53782, 53783, 53784, 53785, 53786, 53787, 53788, 53789,
    53790, 53791, 53792, 53793, 53794, 53795, 53796, 53797, 53798, 53799,
    53800, 53801, 53802, 53803, 53806, 53807, 53809, 53810, 53811, 53813,
    53814, 53815, 53816, 53817, 53818, 53819, 53822, 53824, 53826, 53827,
    53828, 53829, 53830, 53831, 53833, 53834, 53835, 53836, 53837, 53838,
    53839, 53840, 53841, 53842, 53843, 53844, 53845, 53846, 53847, 53848,
    53849, 53850, 53851, 53853, 53854, 53855, 53856, 53857, 53858, 53859,
    53861, 53862, 53863, 53864, 53865, 53866, 53867, 53868, 53869, 53870,
    53871, 53872, 53873, 53874, 53875, 53876, 53877, 53878, 53879, 53880,
    53881, 53882, 53883, 53884, 53885, 53886, 53887, 53890, 53891, 53893,
    53894, 53895, 53897, 53898, 53899, 53900, 53901, 53902, 53903, 53906,
    53907, 53908, 53910, 53911, 53912, 53913, 53914, 53915, 53917, 53918,
    53919, 53921, 53922, 53923, 53925, 53926, 53927, 53928, 53929, 53930,
    53931, 53933, 53934, 53935, 53936, 53938, 53939, 53940, 53941, 53942,
    53943, 53946, 53947, 53949, 53950, 53953, 53955, 53956, 53957, 53958,
    53959, 53962, 53964, 53965, 53966, 53967, 53968, 53969, 53970, 53971,
    53973, 53974, 53975, 53977, 53978, 53979, 53981, 53982, 53983, 53984,
    53985, 53986, 53987, 53990, 53991, 53992, 53993, 53994, 53995, 53996,
    53997, 53998, 53999, 54002, 54003, 54005, 54006, 54007, 54009, 54010,
    54011, 54012, 54013, 54014, 54015, 54018, 54020, 54022, 54023, 54024,
    54025, 54026, 54027, 54031, 54033, 54034, 54035, 54037, 54039, 54040,
    54041, 54042, 54043, 54046, 54050, 54051, 54052, 54054, 54055, 54058,
    54059, 54061, 54062, 54063, 54065, 54066, 54067, 54068, 54069, 54070,
    54071, 54074, 54078, 54079, 54080, 54081, 54082, 54083, 54086, 54087,
    54088, 54089, 54090, 54091, 54092, 54093, 54094, 54095, 54096, 54097,
    54098, 54099, 54100, 54101, 54102, 54103, 54104, 54105, 54106, 54107,
    54108, 54109, 54110, 54111, 54112, 54113, 54114, 54115, 54116, 54117,
    54118, 54119, 54120, 54121, 54122, 54123, 54124, 54125, 54126, 54127,
    54128, 54129, 54130, 54131, 54132, 54133, 54134, 54135, 54136, 54137,
    54138, 54139, 54142, 54143, 54145, 54146, 54147, 54149, 54150, 54151,
    54152, 54153, 54154, 54155, 54158, 54162, 54163, 54164, 54165, 54166,
    54167, 54170, 54171, 54173, 54174, 54175, 54177, 54178, 54179, 54180,
    54181, 54182, 54183, 54186, 54188, 54190, 54191, 54192, 54193, 54194,
    54195, 54197, 54198, 54199, 54201, 54202, 54203, 54205, 54206, 54207,
    54208, 54209, 54210, 54211, 54214, 54215, 54218, 54219, 54220, 54221,
    54222, 54223, 54225, 54226, 54227, 54228, 54229, 54230, 54231, 54233,
    54234, 54235, 54236, 54237, 54238, 54239, 54240, 54242, 54244, 54245,
    54246, 54247, 54248, 54249, 54250, 54251, 54254, 54255, 54257, 54258,
    54259, 54261, 54262, 54263, 54264, 54265, 54266, 54267, 54270, 54272,
    54274, 54275, 54276, 54277, 54278, 54279, 54281, 54282, 54283, 54284,
    54285, 54286, 54287, 54288, 54289, 54290, 54291, 54292, 54293, 54294,
    54295, 54296, 54297, 54298, 54299, 54300, 54302, 54303, 54304, 54305,
    54306, 54307, 54308, 54309, 54310, 54311, 54312, 54313, 54314, 54315,
    54316, 54317, 54318, 54319, 54320, 54321, 54322, 54323, 54324, 54325,
    54326, 54327, 54328, 54329, 54330, 54331, 54332, 54333, 54334, 54335,
    54337, 54338, 54339, 54341, 54342, 54343, 54344, 54345, 54346, 54347,
    54348, 54349, 54350, 54351, 54352, 54353, 54354, 54355, 54356, 54357,
    54358, 54359, 54360, 54361, 54362, 54363, 54365, 54366, 54367, 54369,
    54370, 54371, 54373, 54374, 54375, 54376, 54377, 54378, 54379, 54380,
    54382, 54384, 54385, 54386, 54387, 54388, 54389, 54390, 54391, 54394,
    54395, 54397, 54398, 54401, 54403, 54404, 54405, 54406, 54407, 54410,
    54412, 54414, 54415, 54416, 54417, 54418, 54419, 54421, 54422, 54423,
    54424, 54425, 54426, 54427, 54428, 54429, 54430, 54431, 54432, 54433,
    54434, 54435, 54436, 54437, 54438, 54439, 54440, 54442, 54443, 54444,
    54445, 54446, 54447, 54448, 54449, 54450, 54451, 54452, 54453, 54454,
    54455, 54456, 54457, 54458, 54459, 54460, 54461, 54462, 54463, 54464,
    54465, 54466, 54467, 54468, 54469, 54470, 54471, 54472, 54473, 54474,
    54475, 54477, 54478, 54479, 54481, 54482, 54483, 54485, 54486, 54487,
    54488, 54489, 54490, 54491, 54493, 54494, 54496, 54497, 54498, 54499,
    54500, 54501, 54502, 54503, 54505, 54506, 54507, 54509, 54510, 54511,
    54513, 54514, 54515, 54516, 54517, 54518, 54519, 54521, 54522, 54524,
    54526, 54527, 54528, 54529, 54530, 54531, 54533, 54534, 54535, 54537,
    54538, 54539, 54541, 54542, 54543, 54544, 54545, 54546, 54547, 54550,
    54552, 54553, 54554, 54555, 54556, 54557, 54558, 54559, 54560, 54561,
    54562, 54563, 54564, 54565, 54566, 54567, 54568, 54569, 54570, 54571,
    54572, 54573, 54574, 54575, 54576, 54577, 54578, 54579, 54580, 54581,
    54582, 54583, 54584, 54585, 54586, 54587, 54590, 54591, 54593, 54594,
    54595, 54597, 54598, 54599, 54600, 54601, 54602, 54603, 54606, 54608,
    54610, 54611, 54612, 54613, 54614, 54615, 54618, 54619, 54621, 54622,
    54623, 54625, 54626, 54627, 54628, 54630, 54631, 54634, 54636, 54638,
    54639, 54640, 54641, 54642, 54643, 54646, 54647, 54649, 54650, 54651,
    54653, 54654, 54655, 54656, 54657, 54658, 54659, 54662, 54666, 54667,
    54668, 54669, 54670, 54671, 54673, 54674, 54675, 54676, 54677, 54678,
    54679, 54680, 54681, 54682, 54683, 54684, 54685, 54686, 54687, 54688,
    54689, 54690, 54691, 54692, 54694, 54695, 54696, 54697, 54698, 54699,
    54700, 54701, 54702, 54703, 54704, 54705, 54706, 54707, 54708, 54709,
    54710, 54711, 54712, 54713, 54714, 54715, 54716, 54717, 54718, 54719,
    54720, 54721, 54722, 54723, 54724, 54725, 54726, 54727, 54730, 54731,
    54733, 54734, 54735, 54737, 54739, 54740, 54741, 54742, 54743, 54746,
    54748, 54750, 54751, 54752, 54753, 54754, 54755, 54758, 54759, 54761,
    54762, 54763, 54765, 54766, 54767, 54768, 54769, 54770, 54771, 54774,
    54776, 54778, 54779, 54780, 54781, 54782, 54783, 54786, 54787, 54789,
    54790, 54791, 54793, 54794, 54795, 54796, 54797, 54798, 54799, 54802,
    54806, 54807, 54808, 54809, 54810, 54811, 54813, 54814, 54815, 54817,
    54818, 54819, 54821, 54822, 54823, 54824, 54825, 54826, 54827, 54828,
    54830, 54831, 54832, 54833, 54834, 54835, 54836, 54837, 54838, 54839,
    54842, 54843, 54845, 54846, 54847, 54849, 54850, 54851, 54852, 54854,
    54855, 54858, 54860, 54862, 54863, 54864, 54866, 54867, 54870, 54871,
    54873, 54874, 54875, 54877, 54878, 54879, 54880, 54881, 54882, 54883,
    54884, 54885, 54886, 54888, 54890, 54891, 54892, 54893, 54894, 54895,
    54898, 54899, 54901, 54902, 54903, 54904, 54905, 54906, 54907, 54908,
    54909, 54910, 54911, 54912, 54913, 54914, 54916, 54918, 54919, 54920,
    54921, 54922, 54923, 54926, 54927, 54929, 54930, 54931, 54933, 54934,
    54935, 54936, 54937, 54938, 54939, 54940, 54942, 54944, 54946, 54947,
    54948, 54949, 54950, 54951, 54953, 54954, 54955, 54957, 54958, 54959,
    54961, 54962, 54963, 54964, 54965, 54966, 54967, 54968, 54970, 54972,
    54973, 54974, 54975, 54976, 54977, 54978, 54979, 54982, 54983, 54985,
    54986, 54987, 54989, 54990, 54991, 54992, 54994, 54995, 54997, 54998,
    55000, 55002, 55003, 55004, 55005, 55006, 55007, 55009, 55010, 55011,
    55013, 55014, 55015, 55017, 55018, 55019, 55020, 55021, 55022, 55023,
    55025, 55026, 55027, 55028, 55030, 55031, 55032, 55033, 55034, 55035,
    55038, 55039, 55041, 55042, 55043, 55045, 55046, 55047, 55048, 55049,
    55050, 55051, 55052, 55053, 55054, 55055, 55056, 55058, 55059, 55060,
    55061, 55062, 55063, 55066, 55067, 55069, 55070, 55071, 55073, 55074,
    55075, 55076, 55077, 55078, 55079, 55082, 55084, 55086, 55087, 55088,
    55089, 55090, 55091, 55094, 55095, 55097, 55098, 55099, 55101, 55102,
    55103, 55104, 55105, 55106, 55107, 55109, 55110, 55112, 55114, 55115,
    55116, 55117, 55118, 55119, 55122, 55123, 55125, 55130, 55131, 55132,
    55133, 55134, 55135, 55138, 55140, 55142, 55143, 55144, 55146, 55147,
    55149, 55150, 55151, 55153, 55154, 55155, 55157, 55158, 55159, 55160,
    55161, 55162, 55163, 55166, 55167, 55168, 55170, 55171, 55172, 55173,
    55174, 55175, 55178, 55179, 55181, 55182, 55183, 55185, 55186, 55187,
    55188, 55189, 55190, 55191, 55194, 55196, 55198, 55199, 55200, 55201,
    55202, 55203,
]; // 17188 entries

/// Returns the index code point for pointer `code` in this index.
#[inline]
pub fn forward(code: u16) -> u32 {
    let code = premap_forward(code);
    let code = code as usize;
    if code < 17188 {
        FORWARD_TABLE[code] as u32
    } else {
        X as u32
    }
}

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_LOWER: &'static [u16] = &[
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 6635, 6636, 6637, 6638,
    6639, 6640, 6641, 6642, 6643, 6644, 6645, 6646, 6647, 6648, 6371, X, 20051,
    X, X, X, X, X, X, X, X, X, X, 15106, X, X, X, 16521, X, X, X, 18567, 18568,
    X, 23132, X, X, X, X, X, 17449, X, X, 23291, X, X, X, 16634, 19158, 22902,
    X, 21032, X, 19546, X, X, 16528, X, X, 19521, X, X, 18015, X, 22934, X,
    14057, 14058, X, X, X, X, X, X, X, X, 14771, X, X, X, X, 23473, X, X,
    20495, X, X, 16668, X, X, X, X, X, 14811, X, 23133, X, X, 14428, 19315, X,
    X, X, 22339, 16698, X, X, 22799, X, 14959, X, X, X, X, X, X, X, 23659, X,
    X, 7700, 7511, 7701, X, X, X, X, 7702, X, X, X, X, X, X, 7513, X, 14372, X,
    X, X, X, X, X, X, X, X, X, X, 18934, X, X, 7000, 7001, 7002, 7003, 7004,
    7005, 7006, 7007, 7008, 7009, 7010, 7011, 7012, 7013, 7014, X, 16283, X, X,
    X, X, X, 18214, X, X, 21782, X, 19160, X, X, X, 20304, X, X, 18385, X, X,
    X, X, 20049, X, X, X, 23119, 17967, X, 16303, X, X, X, X, X, X, 17389, X,
    X, X, 21209, X, X, 19672, X, X, X, X, X, X, X, X, 16661, X, X, X, X, 22940,
    X, X, X, X, X, X, X, X, X, X, X, 15490, X, X, 23733, X, X, 17645, X, X, X,
    17479, X, X, X, X, X, X, X, X, X, 16682, X, 21948, X, X, 22006, X, 17455,
    X, X, 17815, X, X, 20681, 20891, 20092, 21263, 18807, X, 15738, 15759,
    18354, 15723, X, X, X, X, X, X, X, X, X, X, X, 16662, X, X, X, 18982, X, X,
    X, X, 16491, X, 23662, X, X, X, X, 20056, 21380, 19901, X, X, X, 22923, X,
    X, X, 19184, 20499, 17629, 20649, X, X, X, 20110, X, X, 17452, 17968, X, X,
    X, X, X, X, 14230, X, 15179, X, X, X, X, X, X, X, 22977, 20430, 15168, X,
    19549, 15180, 17434, 8091, 8092, 8093, 8094, 8095, 8096, 8097, 8098, 8099,
    8100, 8101, 8102, 8103, 8104, 8105, 8106, 7760, 7761, 7762, 7763, 7764,
    7765, X, X, X, X, X, X, X, X, X, X, 21051, 19326, X, 16649, 23168, X,
    22762, X, X, X, 20834, X, X, X, 16663, X, X, 18972, 22181, X, X, 16261,
    22747, X, 23555, X, 16909, X, X, X, X, 17781, X, X, X, 18358, X, X, X, X,
    18528, 15767, X, X, 20685, X, X, X, 22789, X, 16838, X, X, 21806, 21807, X,
    X, X, 22583, X, 22564, 21837, X, 20859, 20063, 15191, 20482, 17048, 14923,
    X, X, X, X, 17578, X, X, X, 14394, X, 18029, X, X, X, 19881, X, X, X, X, X,
    X, X, 14961, X, X, X, X, X, X, X, X, 21379, X, X, X, X, X, X, X, 16893, X,
    18236, X, X, X, 21069, 23147, X, 21462, X, X, X, 19689, X, X, 14051, X,
    18909, 21999, X, X, X, 18025, 20694, X, 19668, X, X, X, X, 14996, X, X, X,
    X, X, X, X, X, 16839, 16840, 21036, X, X, X, X, X, 18428, X, X, X, X, X,
    17817, X, 18157, X, X, 16648, 14742, 13999, X, X, 23295, 14193, X, X,
    21271, X, X, 16126, X, 19111, X, X, X, 20684, X, X, X, X, 14168, X, 22911,
    X, X, X, 17438, X, 22536, 23548, 21268, 14740, 21396, 21045, 19705, 20316,
    X, X, X, 18984, X, X, X, 19880, 21431, X, X, 16681, X, X, 18227, X, 20888,
    19556, X, 23675, X, X, X, X, X, X, X, X, X, X, X, 14542, X, X, 15117, X,
    16115, 21791, 14210, X, X, X, X, X, 18547, X, X, X, X, 21076, X, 16064,
    23151, X, X, X, 15174, X, 20289, X, 20488, X, X, X, 18047, X, 14176, 16674,
    X, 21991, 21842, X, X, 16473, X, 15322, 22525, X, 20657, 16486, 16715,
    16320, X, X, X, 22002, X, X, X, X, X, X, X, 16505, X, X, X, 14417, X, X, X,
    X, X, X, X, X, 21277, X, X, X, 19512, X, X, 18218, X, 21792, X, X, 15897,
    16086, X, X, X, 15711, X, X, 16277, X, X, X, 16338, X, X, X, X, X, 15114,
    X, X, X, X, X, X, X, X, X, 19343, 20447, X, X, X, X, 23369, 15730, X,
    15312, X, 14172, X, X, X, X, 15313, 21408, X, X, 18598, 17427, 20445,
    23117, X, X, 23283, 15113, X, X, 17081, X, X, 15892, X, X, X, X, 23745, X,
    X, X, X, 14364, X, X, 17278, 23538, X, X, X, X, X, X, X, 14937, X, X, X,
    20654, 20817, X, X, 20503, X, X, 17585, X, X, X, X, 14537, 19679, X, X, X,
    18364, 15383, 20133, 20134, 17024, X, X, X, X, 21058, X, X, 21454, X,
    19181, 20836, 18593, 16888, X, X, 15199, X, 20502, 15684, X, 21574, 21221,
    X, X, 18591, 19934, X, X, 18043, X, X, X, X, X, X, 15866, 14743, X, X, X,
    X, X, 18966, 18033, 14167, 19883, X, X, X, X, X, 20121, X, 22537, X, X, X,
    X, 22007, X, X, 21642, X, 17252, X, 21193, X, X, 19884, X, 16476, X, X,
    20294, 20632, X, 14380, 22545, 23508, X, X, X, 22015, X, X, 19322, 21048,
    X, X, 14234, 23528, X, X, X, X, 18739, X, X, X, X, X, X, X, X, X, X, X,
    18998, X, X, 18791, X, 23468, X, 17222, X, X, X, 21591, 19948, 15147, X,
    22189, 16852, 18925, X, 20622, 17220, X, X, X, X, X, X, X, 14359, X, 17064,
    X, X, X, X, 14574, 22333, 17668, X, X, X, X, X, X, X, 22732, X, 19714, X,
    X, X, X, 14580, X, X, X, X, X, X, X, X, X, X, X, 23300, X, 18956, X, 14624,
    14966, X, X, X, X, X, X, X, 14039, X, X, 14967, X, 22734, X, X, 22340, X,
    X, X, X, X, 23706, 20312, 16305, X, X, X, X, X, 16699, X, X, X, X, X, X, X,
    X, X, X, 18574, X, X, X, X, X, 23496, X, X, X, X, X, X, X, X, X, X, 16520,
    18798, 14984, X, X, X, 14378, X, 15562, X, X, X, X, 17225, X, X, 18211, X,
    X, 22004, X, 18609, X, X, 15715, X, X, X, 22020, X, 20826, X, 22191, 17597,
    20820, 14623, X, X, X, X, 17789, 23472, 22607, 22532, 14752, 21946, X, X,
    20850, 21418, X, X, 15120, 17600, X, X, 15330, X, X, X, X, X, X, X, X,
    19715, X, 14002, 14420, X, X, X, X, 19539, 20249, X, X, X, 14972, X, X,
    17430, 20706, X, 17845, 16854, 18960, 20106, X, 15952, X, X, X, X, X, X, X,
    X, X, 17031, X, 14181, X, X, 19144, X, X, X, X, X, X, X, X, X, X, X, 17776,
    17267, X, X, 18776, 23175, X, X, X, X, X, X, X, 14427, 22576, X, 17791, X,
    X, X, X, 16635, X, X, X, X, X, 19159, X, X, X, X, X, 16306, X, X, X, 22968,
    X, X, X, 19479, X, 16312, 17229, X, X, X, X, 14059, X, X, X, X, X, X,
    14962, X, X, X, 14810, X, X, X, X, X, 23120, 19150, X, 20465, X, X, X,
    14005, 22973, 17271, X, X, 15122, X, X, X, X, 16134, X, X, 16513, 15376, X,
    X, X, X, 19930, 19931, 18213, X, X, X, X, 17012, 18570, X, X, X, X, X,
    21088, 21637, X, X, X, X, X, X, X, X, 20643, X, X, 16677, X, X, X, 17443,
    15940, X, 17767, X, X, X, 19165, X, X, X, X, X, X, 21201, X, X, 23748, X,
    X, X, X, X, 16507, 14211, X, X, X, 19921, X, X, 21789, X, X, X, X, X, X, X,
    X, X, X, X, 15690, X, 18008, X, X, 20670, X, X, X, 20843, X, X, X, X, X, X,
    X, 14924, X, X, X, 15762, X, X, X, X, 19177, X, X, 15189, 15500, 17454, X,
    X, X, X, 15110, 21395, 20477, 20088, X, X, 13996, 16071, X, 14988, X, X, X,
    X, X, 21452, X, 14392, 17268, 23699, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 16833, 23660, 6777, 6778, 6779, 6780, 6781, 6782, 6783, 6784, 6785,
    6786, 6787, 6788, 6789, 6790, 6791, 6792, 7154, 7176, 7177, 7144, 7135,
    7178, 7179, 7151, 7156, 7180, 7181, 7146, 7136, 7182, 7183, 7152, 6387, X,
    6214, 6215, X, X, X, X, X, X, X, 6231, X, X, X, X, 6212, 6256, X, X, X, X,
    X, X, 6188, 6254, X, X, X, 23525, X, X, X, X, X, X, X, X, X, 18153, 16138,
    X, 22403, X, 22369, 18613, X, X, X, X, 20506, X, X, X, X, X, X, 14422, X,
    X, X, X, X, 17772, X, X, 19312, 22932, 17626, 16326, 20517, 23545, X, X,
    20647, 13990, X, 20873, X, X, X, X, X, 19927, X, X, X, X, X, X, X, 15885,
    X, X, 21423, X, X, X, X, X, X, X, X, X, X, X, X, X, 15944, X, X, 17467, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 21795, X, 21781, 22953, X, X, X, X, X,
    X, X, X, X, X, 22751, 22975, 18222, 18734, 21964, 17627, X, 20048, X, X, X,
    16280, 16329, X, 17068, X, 21014, X, X, X, X, 22798, X, X, 22797, X, X, X,
    X, X, X, X, X, 18774, X, 15716, X, 17432, X, X, X, 16707, X, X, 18757, X,
    X, X, X, X, X, X, X, X, 21832, X, X, X, X, X, X, 21644, X, X, X, 14410, X,
    X, X, X, 16319, 23322, X, X, X, X, X, X, 14938, X, 20840, X, X, X, X, X, X,
    22163, 21569, 16671, 16672, X, X, X, X, X, X, 23552, X, X, X, X, X, X, X,
    X, X, 20501, 23305, 18030, X, 18423, X, X, 16646, X, X, X, 18965, X, X, X,
    X, X, X, 21970, 21397, X, 15739, X, 18936, X, 23307, X, 17035, 18950, X,
    16270, X, X, X, 21027, X, 17958, X, X, X, X, X, X, X, 23718, X, X, X, X, X,
    X, 7519, 7709, X, X, X, X, X, X, X, X, X, 20258, 21083, 22195, 20659,
    17248, 21422, X, 21421, 21633, X, X, 15121, X, X, 20504, X, X, X, 22921, X,
    20256, X, 21630, X, 17790, X, X, X, X, X, X, 16327, X, 17849, X, 18014, X,
    14360, X, X, X, X, X, X, X, 15878, 22374, X, X, X, X, X, 18773, X, 23522,
    X, X, X, X, X, X, X, 20103, 19170, X, 21079, 17596, X, X, X, X, 14545, X,
    18797, X, 23362, X, 22563, X, 14578, X, X, X, X, X, X, X, 20645, X, X, X,
    16087, 18795, 20705, 17091, X, X, X, X, X, X, X, X, X, X, X, 18194, X, X,
    19863, 19516, X, 18608, 19540, X, X, 18758, X, X, 18759, X, X, X, 15003,
    21007, X, 23287, 14950, 20328, X, X, X, X, 22795, X, X, 17980, X, X, X, X,
    16279, X, X, X, X, X, 19678, X, X, X, X, 21010, 21087, 15331, 21012, X,
    15332, X, 15167, X, 16880, X, X, 18169, X, X, 14584, 21780, 22402, X,
    22909, X, 17605, X, X, X, X, X, X, 16451, 16697, 14184, X, X, 16145, X,
    18992, X, X, X, 16281, X, X, X, X, X, X, X, 14994, 16849, X, 21235, X,
    18954, X, X, X, 17962, X, 18026, 18368, X, 19891, X, X, 17428, 19892, X, X,
    X, 16654, X, X, X, X, X, X, X, 23368, X, X, X, X, 16689, 23491, 23670,
    21231, X, 17260, X, X, 19136, X, 20635, X, 16892, X, X, X, X, 22140, X, X,
    X, X, X, X, X, X, X, 21021, 21436, X, 17784, X, X, X, 15303, X, X, X, X, X,
    X, X, X, X, X, X, X, 14384, X, X, X, 15880, X, X, X, X, X, X, X, X, X, X,
    X, X, 15112, X, 21228, X, 15144, 17618, 15157, X, 19307, 18159, 23713, X,
    X, X, X, X, X, X, X, 17406, 18233, 20122, X, X, 23485, 22169, X, X, 16495,
    X, X, X, X, X, X, X, X, 21968, 23689, 23481, X, 23731, 14031, X, X, 19188,
    17644, 16670, X, X, X, X, X, 20509, X, X, X, X, X, 19738, X, 18727, X, X,
    X, X, X, 21803, X, X, 19551, 20883, X, 21835, X, 17986, X, X, X, X, X, X,
    14388, X, 16905, 15753, X, X, X, 23109, X, X, 23661, 20314, X, 21951, X,
    14387, 21763, 7712, 7713, 7714, 7715, 7716, 7717, 7718, 7719, 7720, 7721,
    7722, 7723, 7724, 7725, 7726, 7727, 6389, 6388, X, X, X, X, 6238, 6237,
    6399, X, X, 6234, X, X, 6236, 6235, 6951, 6952, 6953, 6954, 6955, 6956,
    6957, 6958, 6959, 6960, X, X, X, X, X, X, X, 17445, X, X, X, X, X, X, X, X,
    16633, X, X, X, 14413, X, X, 15315, 19155, X, X, X, X, X, X, X, X, X, X, X,
    X, 19138, X, X, 13983, X, X, 17412, X, 21463, X, X, X, X, X, 20448, X, X,
    22915, X, X, 16107, 23702, X, X, X, 17262, X, X, X, X, 21440, 17059, X,
    13982, X, X, X, X, X, X, 17045, 17961, X, 22914, 21615, X, 14001, 16517, X,
    18367, X, 17261, 19341, X, X, X, X, X, X, X, X, X, 19504, 14358, 22415,
    16263, 15541, X, X, X, X, X, X, 19531, X, X, X, X, X, 23511, X, 17653, X,
    X, X, X, X, X, 19495, X, 18001, X, X, X, X, X, X, X, X, X, 23549, X, X, X,
    X, 15300, 17409, X, X, X, 16711, X, 15299, X, 14601, X, X, 18217, X, X,
    15686, X, 20295, X, X, 17970, X, 14000, X, X, 20897, 19721, X, 14591,
    19529, 14403, X, X, 14032, 18041, 21224, 21223, X, 16651, X, 21459, 22025,
    20093, X, X, X, X, X, 14397, 14170, X, X, X, X, X, 21955, 19870, X, 20511,
    18590, 18745, X, X, X, X, X, X, X, X, X, 23505, X, X, 21607, X, X, X, X, X,
    X, X, X, X, 17075, 22534, X, X, 16453, X, X, X, X, 15198, X, X, X, X, X, X,
    X, X, 19318, X, X, 20481, X, X, X, 20627, 22343, X, X, X, X, 14995, 22924,
    X, X, X, X, X, X, 19369, X, X, 21216, X, 22329, X, 18737, X, X, X, X, X, X,
    X, X, X, 22910, X, X, X, X, X, 15576, 18912, 20475, X, X, 22342, X, X,
    14816, X, X, 15154, 14186, X, 20619, X, X, 6403, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 15946, X, X, 23276, X, X, X, 19168, 19933, X, 21839, 22788,
    21218, 17780, 22721, X, X, 21759, X, X, X, 15956, 23532, 23141, X, 21808,
    X, 14926, X, X, 20318, 16684, X, 22941, 19908, 18764, X, X, 15513, X, X, X,
    X, X, X, 16637, 21799, 17476, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    17250, 8107, 8108, 8109, 8110, 8111, 8112, 8113, 8114, 8115, 8116, 8117,
    8118, 8119, 8120, 8121, 8122, 7550, 7551, 7552, 7553, 7554, 7555, 7556,
    7557, 7558, 7559, 7560, 7561, 7562, 7563, 7564, 7565, 8283, 8284, 8285,
    8286, 8287, 8288, 8289, 8290, 8291, 8292, 8293, 8294, 8295, 8296, 8297,
    8298, 6213, 6205, 7782, 7783, 6370, X, 6415, 6179, 6377, 7781, 7517, X,
    7594, 7591, 7595, 6380, X, 14783, 23350, 17201, 17257, 16694, X, X, X, X,
    X, X, X, X, X, 20109, 18947, X, 17450, X, X, 22935, X, X, X, X, X, X, X, X,
    X, X, 21376, X, X, X, X, X, 21846, X, X, X, X, X, X, X, X, X, X, 17010, X,
    17224, X, X, X, 20491, X, X, X, X, X, X, X, X, X, X, X, X, 17019, 14043, X,
    X, X, 17612, X, X, X, X, X, X, 19557, 20678, X, X, 14008, X, 17812, X, X,
    X, X, X, X, 15491, X, X, 19559, 15349, X, X, 19319, 22542, 21639, 17805,
    19906, X, X, X, X, 17806, X, X, X, X, X, X, X, X, 23106, X, X, X, X, X, X,
    X, 14200, X, X, X, 21003, X, X, X, 20825, 19140, X, X, X, 23160, X, 14943,
    X, X, 14981, 14621, X, X, 21075, X, 21975, 17086, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 18988, 15501, 21401, X, 16454, 18750, 21848, 17823, X,
    X, X, X, 17824, X, X, 21057, X, 16112, X, X, X, 16687, X, X, X, X, X, X, X,
    X, X, 14592, 22171, X, X, X, X, X, X, X, X, 16629, X, X, X, X, X, 21572,
    21818, X, 22745, 14763, X, X, X, X, X, X, X, X, 16125, X, X, X, 14434,
    14556, X, X, X, X, 23094, X, 18396, X, X, X, X, 19124, X, X, X, X, X, X,
    17810, 20508, X, X, 20679, 14916, 18913, X, 21967, 20519, X, X, 18729,
    19552, 23688, 17071, X, X, 16644, X, X, 21986, X, X, X, X, X, X, X, 22757,
    X, X, X, X, X, 6224, X, X, X, X, X, X, X, X, X, X, 17779, X, X, X, X, X,
    23666, X, 18019, X, X, X, X, X, X, X, X, X, 16863, X, X, X, X, X, 19098,
    9026, 9027, 0, 1, 9028, 2, 3, 9029, 9030, 9031, 9032, 4, 5, 6, 7, 8, 9051,
    9052, 23, 24, 25, 32, 33, 34, 9053, 9054, 35, 36, 9055, 37, 38, 39, 72, 73,
    74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 9078, 104, 105,
    106, 9079, 107, 108, 109, 110, 111, 112, 113, 9080, 9081, 114, 9082, 134,
    9096, 135, 136, 9097, 137, 138, 139, 9098, 140, 141, 142, 9099, 143, 144,
    145, 9110, 9111, 168, 9112, 169, 9113, 9114, 170, 171, 172, 173, 174, 9115,
    9116, 175, 176, 9222, 200, 201, 202, 203, 204, 205, 206, 207, 9223, 208,
    209, 9224, 9225, 210, 211, 9234, 242, 243, 244, 9235, 245, 246, 247, 9236,
    254, 255, 256, 257, 258, 259, 260, 280, 9250, 9251, 281, 282, 283, 284,
    285, 9252, 9253, 286, 287, 9254, 288, 289, 290, 319, 320, 321, 322, 323,
    324, 325, 9259, 326, 327, 328, 329, 330, 331, 332, 333, 9268, 358, 359,
    360, 9269, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 394, 395,
    396, 397, 9280, 398, 399, 400, 401, 402, 403, 404, 405, 412, 413, 414,
    9287, 9288, 447, 9289, 448, 9290, 9291, 449, 450, 451, 9292, 452, 9293,
    9294, 9295, 453, 9308, 474, 475, 476, 477, 478, 479, 480, 9309, 9406, 481,
    9407, 9408, 9409, 482, 483, 513, 514, 515, 516, 517, 518, 519, 520, 521,
    522, 523, 524, 525, 526, 527, 528, 9421, 9422, 553, 554, 555, 556, 557,
    558, 9423, 9424, 559, 560, 9425, 561, 562, 563, 590, 591, 592, 593, 594,
    595, 602, 9432, 9433, 603, 604, 605, 606, 9434, 607, 608, 9438, 644, 9439,
    645, 9440, 646, 647, 648, 649, 650, 651, 652, 9441, 9442, 653, 9443, 678,
    679, 680, 681, 9452, 9453, 682, 683, 684, 685, 686, 687, 688, 689, 690,
    691, 9458, 9459, 720, 721, 722, 9460, 723, 724, 725, 726, 727, 728, 9461,
    729, 730, 731, 9465, 761, 762, 763, 764, 765, 766, 9466, 9467, 9468, 767,
    9469, 768, 9470, 9471, 769, 9476, 9477, 804, 805, 9478, 806, 807, 808,
    9479, 809, 810, 811, 812, 813, 814, 815, 846, 847, 848, 849, 850, 851, 852,
    853, 9488, 854, 855, 856, 857, 858, 859, 860, 887, 888, 889, 9495, 9496,
    9497, 890, 9498, 891, 9499, 892, 893, 894, 9596, 895, 896, 9599, 927, 928,
    929, 9600, 930, 931, 932, 933, 934, 935, 936, 9601, 9602, 937, 9603, 954,
    9620, 955, 9621, 9622, 9623, 956, 957, 9624, 958, 959, 960, 9625, 961, 962,
    963, 9635, 993, 994, 995, 996, 9636, 997, 998, 999, 1000, 1001, 1002, 1003,
    1004, 1005, 1006, 9641, 1041, 9642, 9643, 1042, 1043, 1044, 1045, 9644,
    9645, 1046, 9646, 9647, 9648, 1047, 1048, 9659, 9660, 1071, 1072, 9661,
    1073, 1074, 1075, 9662, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1108,
    1109, 1110, 1111, 1112, 1113, 1114, 1115, 9670, 9671, 1116, 1117, 9672,
    1118, 1119, 1120, 1142, 1143, 1144, 1145, 1146, 1147, 1148, 1149, 9684,
    1150, 1151, 1152, 1153, 1154, 1155, 1156, 9686, 1194, 1195, 1196, 9687,
    1197, 1204, 1205, 1206, 1207, 1208, 1209, 9688, 9689, 1210, 9786, 1236,
    1237, 1238, 1239, 9794, 9795, 1240, 1241, 9796, 1242, 1243, 9797, 9798,
    1244, 1245, 1246, 1274, 1275, 1276, 1277, 9804, 1278, 1279, 1280, 1281,
    1282, 1283, 1284, 9805, 1285, 1286, 1287, 9808, 1318, 1319, 1320, 1321,
    1322, 1323, 1324, 9809, 9810, 1325, 1326, 1327, 1328, 1329, 1330, 9817,
    9818, 1363, 1364, 9819, 1365, 1366, 1367, 9820, 9821, 9822, 1368, 1369,
    1370, 1371, 1372, 1402, 1403, 1404, 1405, 1406, 1407, 1408, 1409, 9832,
    9833, 1410, 1411, 9834, 1412, 1413, 1414, 1431, 1432, 1433, 9851, 9852,
    9853, 1434, 9854, 9855, 9856, 9857, 9858, 1435, 1436, 1437, 9859, 1460,
    1461, 1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1471, 1472,
    1473, 1474, 1475, 1508, 1509, 1510, 1511, 9870, 9871, 9872, 1512, 9873,
    1513, 1514, 9874, 9875, 1515, 9876, 9877, 9984, 9985, 1538, 9986, 9987,
    9988, 1539, 1540, 1541, 1542, 1543, 1544, 9989, 1545, 1552, 1553, 1586,
    1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1595, 1596, 1597, 1598,
    1599, 1600, 1601, 10009, 1621, 1622, 1623, 10010, 1624, 1625, 1626, 10011,
    1627, 1628, 1629, 1630, 1631, 1632, 1633, 10013, 1665, 1666, 1667, 1668,
    1669, 1670, 1671, 10014, 1672, 1673, 1674, 10015, 1675, 1676, 1677, 1705,
    1706, 1707, 1708, 1709, 1710, 1711, 1712, 1713, 1714, 1715, 1716, 1717,
    1718, 1719, 1720, 1750, 1751, 1752, 1753, 1754, 1755, 1756, 1757, 1758,
    1759, 1760, 1761, 1762, 1763, 1764, 1765, 1801, 1802, 1803, 1804, 10033,
    1805, 1806, 1807, 10034, 1808, 1809, 1810, 10035, 1811, 1812, 1813, 10042,
    1840, 1841, 1842, 1843, 10043, 1844, 1845, 1846, 1847, 1848, 1849, 10044,
    10045, 1850, 1851, 1875, 1876, 1877, 1878, 1879, 1880, 1881, 1882, 1883,
    1884, 1885, 1886, 1887, 1888, 1889, 1890, 10066, 10067, 1912, 1913, 10068,
    1914, 1915, 1916, 10069, 1917, 1918, 1919, 1920, 1921, 1922, 1923, 10179,
    10180, 1949, 1950, 1951, 1952, 1953, 1954, 1955, 1956, 1957, 1964, 1965,
    1966, 1967, 1968, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009,
    2010, 2011, 2012, 2013, 2014, 2015, 2016, 10195, 2035, 2036, 2037, 10196,
    2038, 2039, 2040, 2041, 2042, 2043, 2044, 10197, 10198, 2045, 10199, 2074,
    2075, 2076, 2077, 2078, 2079, 2080, 2081, 2082, 2083, 2084, 2085, 2086,
    2087, 2088, 2089, 2124, 2125, 2126, 2127, 2128, 10208, 2129, 2130, 2131,
    2132, 2133, 2134, 10209, 2135, 2136, 2137, 2174, 2175, 2176, 2177, 2178,
    2179, 2180, 2181, 2182, 2183, 2184, 2185, 2186, 2187, 2188, 2189, 2220,
    2221, 2222, 2223, 2224, 2225, 2226, 2227, 2228, 2229, 2230, 2231, 2232,
    2233, 2234, 2235, 2262, 10220, 2263, 2264, 2265, 2266, 2267, 2268, 2269,
    2270, 2271, 2272, 2273, 2274, 2275, 2276, 2314, 2315, 2316, 2317, 2318,
    2319, 2320, 2321, 2322, 2323, 2324, 2325, 2326, 2327, 2328, 2329, 2362,
    2363, 2364, 2365, 2366, 2367, 2368, 2369, 2370, 2371, 2372, 2373, 2374,
    2375, 2376, 2377, 2402, 2403, 2404, 2405, 10236, 2406, 2407, 2408, 10237,
    2409, 2410, 2411, 10238, 2412, 2413, 2414, 10244, 10245, 2442, 10246, 2443,
    10247, 2444, 2445, 2446, 2447, 2448, 2449, 10248, 10249, 2450, 2451, 10359,
    2471, 2472, 2473, 2474, 2475, 2476, 2477, 10360, 10361, 2478, 10362, 10363,
    10364, 2479, 2480, 2514, 2515, 2516, 2517, 2518, 2519, 2520, 2521, 2522,
    2523, 2524, 2525, 2526, 2527, 2534, 2535, 10377, 10378, 2561, 2562, 2563,
    2564, 2565, 10379, 10380, 10381, 2566, 2567, 10382, 2568, 2569, 2570, 2594,
    2595, 2596, 2597, 10392, 10393, 2598, 10394, 10395, 10396, 2599, 2600,
    2601, 2602, 2603, 2604, 10403, 2631, 2632, 2633, 10404, 2634, 2635, 2636,
    2637, 2638, 2639, 2640, 10405, 10406, 2641, 10407, 2670, 2671, 2672, 2673,
    2674, 2675, 2676, 2677, 2678, 2679, 2680, 2681, 2682, 2683, 2684, 2685,
    10416, 10417, 2726, 10418, 2727, 10419, 2728, 2729, 2730, 2731, 2732, 2733,
    10420, 2734, 2735, 2736, 10429, 2761, 2762, 2763, 2764, 2765, 2766, 2767,
    10430, 10431, 2768, 10432, 2769, 10433, 2770, 2771, 10436, 2802, 2803,
    2804, 2805, 2806, 2807, 2808, 2809, 2810, 2811, 2812, 2813, 2814, 2815,
    2816, 2843, 10443, 2844, 2845, 2846, 2847, 2848, 2849, 10444, 10445, 2850,
    2851, 10446, 2852, 2853, 2854, 2884, 2885, 2886, 2887, 10552, 10553, 2888,
    10554, 2889, 10555, 10556, 2890, 2891, 10557, 10558, 2892, 10561, 2929,
    2930, 2931, 10562, 2932, 2933, 2934, 2935, 2936, 2937, 2938, 10563, 10564,
    2939, 10565, 2958, 10580, 2959, 10581, 10582, 10583, 2960, 2961, 10584,
    2962, 2963, 2964, 10585, 2965, 2966, 2967, 2991, 2992, 2993, 2994, 2995,
    10595, 2996, 2997, 2998, 2999, 3000, 3001, 3002, 3003, 3004, 3005, 10599,
    3035, 10600, 3036, 3037, 3038, 3039, 3040, 10601, 10602, 3041, 10603, 3042,
    10604, 10605, 3043, 10616, 10617, 3072, 3073, 10618, 3074, 3075, 3076,
    10619, 3077, 3078, 3079, 3080, 3081, 3082, 3083, 3117, 3118, 3119, 3120,
    3121, 3122, 3123, 3124, 10625, 10626, 3125, 10627, 10628, 3126, 3127, 3128,
    3153, 3154, 3155, 3156, 3157, 3158, 3159, 3160, 10637, 10638, 3161, 3162,
    3163, 3164, 3165, 3166, 10736, 3198, 3199, 3200, 10737, 3201, 3202, 3203,
    3204, 3205, 3206, 3207, 3208, 10738, 3209, 10739, 3236, 3237, 3238, 3239,
    10746, 10747, 10748, 3240, 10749, 3241, 3242, 10750, 10751, 10752, 10753,
    3243, 3273, 10763, 3274, 10764, 3275, 3276, 3277, 3278, 3279, 3280, 3281,
    3282, 10765, 3283, 3284, 3285, 10768, 3322, 3323, 3324, 3325, 3326, 3327,
    3328, 3329, 3330, 3331, 3332, 3333, 3334, 3335, 3336, 10774, 3364, 3365,
    3366, 10775, 3367, 3368, 3369, 10776, 3370, 3371, 3372, 3373, 3374, 3375,
    3376, 3407, 3408, 3409, 3410, 3411, 3412, 3413, 3414, 10779, 10780, 3415,
    3416, 10781, 3417, 3418, 10782, 3432, 3433, 3434, 3435, 10802, 10803, 3436,
    10804, 3437, 10805, 3438, 3439, 3440, 10806, 3441, 3442, 10819, 3469, 3470,
    3471, 3472, 3473, 3474, 3475, 3476, 3477, 3484, 3485, 3486, 10820, 3487,
    3488, 3521, 3522, 3523, 3524, 10821, 10822, 3525, 3526, 10823, 3527, 3528,
    10824, 10825, 3529, 10826, 3530, 10933, 10934, 3553, 10935, 10936, 10937,
    3554, 3555, 3556, 3557, 3558, 3559, 10938, 10939, 3560, 3561, 3585, 3586,
    3587, 3588, 3589, 3590, 3591, 3592, 3593, 3594, 3595, 3596, 3597, 3598,
    3599, 3600, 10958, 3624, 3625, 3626, 10959, 3627, 3628, 3629, 3630, 3631,
    3632, 3633, 3634, 3635, 3642, 3643, 10962, 3680, 3681, 3682, 3683, 3684,
    3685, 3686, 10963, 10964, 3687, 3688, 10965, 3689, 3690, 3691, 3719, 3720,
    3721, 3722, 3723, 3724, 3725, 3726, 3727, 3728, 3729, 3730, 3731, 3732,
    3733, 3734, 3753, 3754, 3755, 3756, 10985, 3757, 3758, 3759, 3760, 3761,
    3762, 3763, 3764, 3765, 3766, 3767, 3798, 3799, 3800, 3801, 10988, 10989,
    3802, 3803, 10990, 3804, 3805, 3806, 10991, 3807, 3808, 3809, 10996, 3844,
    3845, 10997, 3846, 10998, 3847, 3848, 3849, 3850, 3851, 3852, 10999, 11000,
    3853, 3854, 3888, 3889, 3890, 3891, 3892, 3893, 3894, 3895, 3896, 3897,
    3898, 3899, 3900, 3901, 3902, 3903, 11017, 11018, 3925, 3926, 11019, 3927,
    3928, 3929, 11116, 3930, 11117, 3931, 3932, 3933, 3934, 3935, 11131, 11132,
    3955, 3956, 3957, 3958, 3959, 3960, 11133, 11134, 3961, 3962, 3963, 3964,
    3965, 3966, 3998, 3999, 4000, 4001, 4002, 4003, 4004, 4005, 4006, 4007,
    4008, 4009, 4010, 4011, 4012, 4013, 4042, 4043, 4044, 4045, 4046, 4047,
    4054, 4055, 4056, 4057, 4058, 4059, 4060, 4061, 4062, 4063, 4088, 4089,
    4090, 4091, 4092, 4093, 4094, 4095, 4096, 4097, 4098, 4099, 4100, 4101,
    4102, 4103, 11158, 11159, 4132, 4133, 4134, 11160, 4135, 4136, 4137, 4138,
    4139, 4140, 4141, 4142, 4143, 4144, 4177, 4178, 4179, 4180, 4181, 4182,
    4183, 4184, 4185, 4186, 4187, 4188, 4189, 4190, 4191, 4192, 11162, 4230,
    4231, 4232, 4233, 4234, 4235, 4236, 4237, 4244, 4245, 4246, 4247, 4248,
    4249, 4250, 4276, 11170, 4277, 4278, 4279, 4280, 4281, 4282, 4283, 4284,
    4285, 4286, 4287, 4288, 4289, 4290, 4323, 4324, 4325, 4326, 4327, 4328,
    4329, 4330, 4331, 4332, 4333, 4334, 4335, 4336, 4337, 4338, 4370, 4371,
    4372, 4373, 4374, 4375, 4376, 4377, 4378, 4379, 4380, 4381, 4382, 4383,
    4384, 4385, 4418, 4419, 4420, 4421, 4422, 4423, 4424, 4425, 4426, 4427,
    4434, 4435, 4436, 4437, 4438, 4439, 11182, 11183, 4468, 11184, 4469, 11185,
    4470, 4471, 4472, 4473, 4474, 4475, 11186, 11187, 4476, 11188, 11203, 4495,
    4496, 4497, 4498, 4499, 4500, 4501, 11204, 11205, 4502, 11206, 11207,
    11208, 4503, 4504, 11313, 4529, 4530, 4531, 11314, 4532, 4533, 4534, 11315,
    4535, 4536, 4537, 4538, 4539, 4540, 4541, 11330, 11331, 4560, 4561, 4562,
    4563, 11332, 4564, 11333, 11334, 4565, 4566, 11335, 4567, 4568, 4569, 4598,
    4599, 4600, 4601, 11346, 11347, 4602, 11348, 11349, 11350, 4603, 4604,
    4605, 4606, 4607, 4608, 11358, 4640, 4641, 4642, 11359, 4643, 11360, 4644,
    4645, 4646, 4647, 4648, 11361, 11362, 4649, 11363, 4675, 4676, 4677, 4678,
    11371, 4679, 4680, 4681, 11372, 4682, 4683, 4684, 11373, 4685, 4686, 4687,
    11380, 11381, 4714, 11382, 4715, 4716, 4717, 4718, 4719, 4720, 4721, 4722,
    11383, 11384, 4723, 4724, 11395, 4747, 4748, 4749, 4750, 4751, 4752, 4753,
    11396, 11397, 4754, 11398, 4755, 11399, 4756, 11496, 11501, 11502, 4791,
    4792, 11503, 4793, 4794, 4795, 11504, 4796, 4797, 4798, 4799, 4800, 4801,
    4802, 4832, 11514, 4833, 4834, 4835, 4836, 4837, 4838, 11515, 11516, 4839,
    4840, 4841, 4842, 4843, 4844, 4868, 4869, 4870, 4871, 11526, 11527, 4872,
    11528, 4873, 11529, 4874, 4875, 4876, 4877, 4878, 4879, 11532, 4910, 4911,
    11533, 11534, 4912, 4913, 4914, 4915, 4916, 4917, 11535, 11536, 11537,
    4918, 11538, 4940, 4941, 4942, 11550, 11551, 11552, 4943, 4944, 11553,
    4945, 4946, 4947, 11554, 4948, 4949, 4950, 4985, 4986, 4987, 4988, 4989,
    11559, 4990, 4991, 4992, 4993, 4994, 4995, 4996, 4997, 5004, 5005, 11563,
    5035, 11564, 5036, 5037, 5038, 5039, 5040, 11565, 11566, 5041, 5042, 11567,
    11568, 5043, 5044, 5074, 5075, 5076, 5077, 5078, 5079, 5080, 5081, 5082,
    5083, 5084, 5085, 5086, 5087, 5088, 5089, 5121, 5122, 5123, 5124, 5125,
    5126, 5127, 5128, 11573, 11574, 5129, 5130, 11575, 5131, 5132, 11576, 5163,
    5164, 5165, 5166, 5167, 5168, 5169, 5170, 11585, 5171, 5172, 5173, 5174,
    5175, 5176, 5177, 11589, 5213, 5214, 5215, 11686, 5216, 5217, 5218, 5219,
    5220, 5221, 5222, 11687, 11688, 5223, 5224, 5256, 5257, 5258, 5259, 11690,
    11691, 5260, 5261, 11692, 5262, 5263, 5264, 11693, 5265, 5266, 5267, 5296,
    5297, 5298, 5299, 11698, 5300, 5301, 5302, 5303, 5304, 5305, 5306, 11699,
    5307, 5308, 5309, 5340, 5341, 5342, 5343, 5344, 5345, 5352, 5353, 5354,
    5355, 5356, 5357, 5358, 5359, 5360, 5361, 11703, 11704, 5399, 5400, 11705,
    5401, 5402, 5403, 11706, 5404, 11707, 5405, 5406, 5407, 5408, 11708, 5435,
    5436, 5437, 5438, 5439, 5440, 5441, 5442, 11715, 11716, 5443, 5444, 11717,
    5445, 5446, 5447, 5467, 5468, 5469, 11731, 11732, 11733, 5470, 11734,
    11735, 11736, 5471, 5472, 5473, 11737, 11738, 5474, 11750, 5496, 5497,
    5498, 11751, 5499, 5500, 11752, 5501, 5502, 5503, 5504, 11753, 11754, 5505,
    11755, 5531, 5532, 5533, 5534, 11763, 11764, 5535, 5542, 11765, 11766,
    5543, 11767, 11768, 11769, 11770, 5544, 11880, 11881, 5564, 11882, 5565,
    11883, 5566, 5567, 5574, 5575, 5576, 5577, 11884, 11885, 11886, 5578,
    11902, 5596, 5597, 5598, 5599, 5600, 5601, 5602, 11903, 11904, 5603, 11905,
    11906, 5604, 5605, 5606, 11920, 11921, 5626, 5627, 11922, 5628, 5629, 5630,
    11923, 5631, 5632, 5633, 5634, 5635, 5636, 5637, 5660, 11934, 5661, 5662,
    5663, 5664, 5665, 5666, 11935, 11936, 5667, 5668, 11937, 5669, 5670, 5671,
    5695, 5696, 5697, 5698, 11947, 11948, 5699, 11949, 5700, 11950, 5701, 5702,
    5703, 5704, 5705, 5706, 11963, 5733, 5734, 5735, 11964, 5736, 5737, 5738,
    5739, 5740, 5741, 5742, 11965, 11966, 5743, 5744, 5774, 5775, 5776, 5777,
    12072, 12073, 5778, 5779, 12074, 5780, 5781, 5782, 12075, 5783, 5784, 5785,
    12084, 12085, 5810, 12086, 5811, 12087, 5812, 12088, 5813, 5814, 5815,
    5816, 12089, 12090, 5817, 5818, 12106, 5836, 5837, 5838, 5839, 5840, 5841,
    5842, 12107, 5843, 5844, 12108, 5845, 5846, 5847, 5848, 12123, 12124, 5867,
    5868, 12125, 5869, 12126, 12127, 12128, 5870, 12129, 5871, 5872, 5873,
    5874, 5875, 12143, 12144, 5895, 5896, 5897, 5898, 5899, 5900, 12145, 12146,
    5901, 5902, 12147, 5903, 12148, 5904, 5937, 5938, 5939, 5940, 5941, 5942,
    5943, 5944, 5945, 5946, 5947, 5954, 5955, 5956, 5957, 5958, 12263, 5979,
    5980, 5981, 12264, 5982, 5983, 5984, 5985, 5986, 5987, 5988, 12265, 12266,
    5989, 12267, 6014, 6015, 6016, 6017, 12276, 6018, 6019, 6020, 6021, 6022,
    6023, 6024, 6025, 6026, 6027, 6028, 12282, 12283, 6056, 12284, 6057, 12285,
    12286, 12287, 6058, 6059, 6060, 12288, 12289, 12290, 6061, 6062, 6090,
    6091, 6092, 6093, 6094, 6095, 6096, 6097, 6098, 6099, 6100, 6101, 12296,
    12297, 6102, 6103, 12305, 12306, 6135, 6136, 12307, 6137, 6144, 6145, 6146,
    6147, 6148, 6149, 6150, 6151, 6152, 6153, 6270, 12318, 6271, 6272, 6273,
    6274, 6275, 6276, 12319, 6277, 6278, 6279, 6280, 6281, 6282, 6283, 6320,
    6321, 6322, 6323, 6324, 6325, 6326, 6327, 6334, 6335, 6336, 6337, 6338,
    6339, 6340, 6341, 12330, 6460, 6461, 6462, 12331, 6463, 6464, 6465, 6466,
    6467, 6468, 6469, 12332, 6470, 6471, 6472, 6503, 6504, 6505, 6506, 6507,
    6508, 6509, 6510, 6511, 6512, 6513, 6514, 6515, 6516, 6517, 6524, 12347,
    12348, 6551, 12349, 6552, 12446, 12447, 6553, 6554, 12448, 12449, 6555,
    12450, 12451, 6650, 6651, 12464, 6672, 6673, 6674, 6675, 6682, 6683, 6684,
    12465, 12466, 6685, 12467, 12468, 12469, 6686, 6687, 6723, 6724, 6725,
    6726, 6727, 6728, 6729, 6730, 6731, 6732, 6733, 6734, 6735, 6736, 6737,
    6738, 12480, 12481, 6858, 6859, 6860, 6861, 6862, 6863, 12482, 6864, 6865,
    6872, 6873, 6874, 6875, 6876, 6913, 6914, 6915, 6916, 6917, 6918, 6919,
    6920, 12485, 6921, 6922, 6923, 6924, 6925, 6926, 6927, 12488, 7052, 7053,
    7054, 12489, 7055, 7062, 7063, 7064, 7065, 7066, 7067, 12490, 12491, 7068,
    12492, 7101, 7102, 7103, 7104, 12499, 7105, 7106, 7107, 7108, 7109, 7110,
    7111, 7112, 7113, 7114, 7115, 12504, 12505, 7238, 7239, 7240, 7241, 7242,
    7243, 7244, 7245, 7252, 7253, 7254, 7255, 7256, 7257, 12510, 7292, 7293,
    7294, 7295, 7296, 7297, 7298, 12511, 12512, 7299, 7300, 7301, 12513, 7302,
    7303, 7427, 7428, 7429, 7430, 7431, 7432, 7433, 7434, 7435, 7442, 7443,
    7444, 7445, 7446, 7447, 7448, 7486, 7487, 7488, 7489, 7490, 7491, 7492,
    7493, 12518, 7494, 7495, 7496, 7497, 7498, 7499, 7500, 7632, 7633, 7634,
    7635, 12520, 7636, 7637, 12521, 7638, 12522, 7639, 7640, 7641, 7642, 7643,
    7644, 12525, 7681, 7682, 7683, 12526, 7684, 7685, 7686, 7687, 7688, 7689,
    7690, 12527, 12528, 7691, 7692, 7805, 7806, 7807, 7808, 12639, 12640, 7809,
    7810, 12641, 7811, 7812, 7813, 12642, 7814, 7815, 7822, 12652, 7846, 7847,
    7854, 7855, 12653, 7856, 7857, 7858, 7859, 7860, 7861, 7862, 7863, 7864,
    7865, 12657, 7989, 7990, 7991, 7992, 7993, 7994, 7995, 12658, 12659, 7996,
    12660, 12661, 12662, 7997, 7998, 12671, 8029, 8030, 8031, 12672, 8032,
    8033, 8034, 8035, 8036, 8037, 8044, 8045, 8046, 8047, 8048, 8172, 12676,
    8173, 8174, 8175, 8176, 8177, 8178, 12677, 12678, 8179, 8180, 12679, 8181,
    8182, 8183, 8214, 8215, 8216, 8217, 8218, 8219, 8220, 8221, 8222, 12688,
    8223, 8224, 8225, 8226, 8227, 8234, 12690, 8360, 8361, 8362, 12691, 8363,
    8364, 8365, 8366, 8367, 8368, 8369, 12692, 12693, 8370, 12694, 8406, 8407,
    8408, 8409, 12698, 12699, 8410, 8411, 12700, 8412, 8413, 8414, 12701, 8415,
    8416, 8417, 8451, 8452, 8453, 8454, 12707, 8455, 8550, 8551, 8552, 8553,
    8554, 8555, 12708, 8556, 8557, 8558, 12712, 8594, 8595, 8596, 8597, 8598,
    8599, 8600, 12713, 12714, 8601, 12715, 8602, 12716, 8603, 8604, 12722,
    12723, 8638, 8639, 12724, 8640, 8641, 8642, 12725, 8643, 8644, 8645, 8740,
    8741, 8742, 8743, 8778, 8779, 8780, 8781, 8782, 8783, 8784, 8785, 12826,
    12827, 8786, 8787, 12828, 8788, 8789, 12829, 8818, 8819, 8820, 8821, 12840,
    12841, 8822, 12842, 8823, 12843, 8824, 8825, 8826, 8827, 8828, 8829, 8945,
    8946, 8947, 8948, 8949, 8950, 8951, 8952, 8953, 8954, 8955, 8962, 8963,
    8964, 8965, 8966, 9004, 9005, 9006, 9007, 12856, 12857, 9008, 9009, 12858,
    9010, 9011, 12859, 12860, 9012, 9013, 9014, 12870, 12871, 9132, 12872,
    9133, 12873, 9134, 9135, 9136, 9137, 9138, 9139, 12874, 9140, 9141, 9142,
    9173, 9174, 9175, 9176, 9177, 9184, 9185, 9186, 9187, 9188, 9189, 9190,
    9191, 9192, 9193, 9194, 12891, 12892, 9313, 9314, 12893, 9315, 9316, 9317,
    12894, 9318, 9319, 9320, 9321, 9322, 9323, 9324, 9360, 12898, 9361, 9362,
    9363, 9364, 9365, 9366, 12899, 9367, 9374, 9375, 9376, 9377, 9378, 9379,
    9504, 9505, 9506, 9507, 9508, 9509, 9510, 9511, 9512, 9513, 9514, 9515,
    9516, 9517, 9518, 9519, 12911, 9549, 9550, 9551, 12912, 9552, 9553, 9554,
    9555, 9556, 9557, 9564, 9565, 9566, 9567, 9568, 9692, 9693, 9694, 9695,
    12916, 12917, 9696, 9697, 12918, 9698, 9699, 9700, 12919, 9701, 9702, 9703,
    13023, 9735, 9736, 9737, 9738, 9739, 9740, 9741, 9742, 9743, 9744, 9745,
    13024, 13025, 9746, 9747, 9781, 9782, 9783, 9784, 9785, 9880, 9881, 9882,
    9883, 9884, 9885, 9886, 9887, 9888, 9889, 9890, 13039, 13040, 9921, 9922,
    13041, 9923, 9924, 9925, 13042, 13043, 9926, 9927, 9928, 9929, 9930, 9931,
    13056, 13057, 9958, 9959, 9960, 9961, 9962, 9963, 13058, 9964, 9965, 9966,
    9967, 9968, 9969, 9970, 10102, 10103, 10104, 10105, 10106, 10107, 10108,
    10109, 10110, 10111, 10112, 10113, 10114, 10115, 10116, 10117, 13072,
    10144, 10145, 10146, 13073, 10147, 10148, 10149, 10150, 10151, 10152,
    10153, 13074, 13075, 10154, 13076, 10277, 10278, 10279, 10280, 13081,
    10281, 10282, 10283, 13082, 10284, 10285, 10292, 10293, 10294, 10295,
    10296, 13087, 13088, 10331, 13089, 10332, 13090, 10333, 10334, 10335,
    10336, 13091, 10337, 13092, 10338, 10339, 10340, 10465, 10466, 10467,
    10468, 10469, 10470, 10471, 10472, 10473, 10474, 10475, 10482, 10483,
    10484, 10485, 10486, 13099, 10521, 10522, 10523, 10524, 10525, 10526,
    10527, 10528, 10529, 10530, 10531, 10532, 10533, 10534, 10535, 10655,
    13107, 10656, 10657, 10658, 10659, 10660, 10661, 13108, 10662, 10663,
    10664, 10665, 10672, 10673, 10674, 10711, 10712, 10713, 10714, 10715,
    10716, 10717, 10718, 10719, 10720, 10721, 10722, 10723, 10724, 10725,
    10726, 13215, 10845, 10846, 10847, 13216, 10848, 10849, 10850, 10851,
    10852, 10853, 10854, 13217, 10855, 10862, 10863, 10886, 10887, 10894,
    10895, 13228, 10896, 10897, 10898, 13229, 10899, 10900, 10901, 13230,
    10902, 10903, 10904, 13237, 13238, 11025, 13239, 11026, 13240, 11027,
    11028, 11029, 11030, 11031, 11032, 13241, 13242, 13243, 11033, 13256,
    11060, 11061, 11062, 11063, 11064, 11065, 11066, 13257, 13258, 11067,
    13259, 13260, 13261, 11068, 11069, 11106, 11107, 11108, 11109, 11110,
    11111, 11112, 11113, 11114, 11115, 11210, 11211, 11212, 11213, 11214,
    11215, 13271, 13272, 11247, 11248, 11249, 11250, 11251, 11252, 13273,
    13274, 11253, 11254, 13275, 11255, 11256, 11257, 11288, 11289, 11290,
    11291, 13284, 13285, 11292, 11293, 13286, 13287, 11294, 11295, 11296,
    11297, 11298, 11299, 13294, 11420, 11421, 11422, 13295, 11423, 11424,
    11425, 11432, 11433, 11434, 11435, 13296, 13297, 11436, 13298, 11472,
    11473, 11474, 11475, 11476, 11477, 11478, 11479, 11480, 11481, 11482,
    11483, 11484, 11485, 11486, 11487, 11612, 11613, 11614, 11615, 11622,
    11623, 11624, 11625, 11626, 11627, 11628, 11629, 13400, 11630, 11631,
    11632, 13409, 11663, 13410, 11664, 11665, 11666, 11667, 11668, 13411,
    13412, 11669, 13413, 11670, 13414, 11671, 11672, 11797, 11798, 11799,
    11800, 11801, 11802, 11803, 11804, 11805, 11812, 11813, 11814, 11815,
    11816, 11817, 11818, 11852, 11853, 11854, 11855, 11856, 11857, 11858,
    11859, 13422, 11860, 11861, 11862, 13423, 11863, 11864, 11865, 11985,
    11986, 11987, 11988, 13431, 13432, 11989, 13433, 11990, 11991, 11992,
    11993, 11994, 11995, 12002, 12003, 13436, 12040, 12041, 12042, 13437,
    12043, 12044, 12045, 12046, 12047, 12048, 12049, 13438, 13439, 12050,
    13440, 12167, 12168, 12169, 12170, 13451, 13452, 12171, 12172, 13453,
    12173, 12174, 12175, 13454, 12176, 12177, 12178, 12211, 12212, 12213,
    12214, 12215, 13461, 12216, 12217, 12224, 12225, 12226, 12227, 12228,
    12229, 12230, 12231, 13465, 12355, 13466, 12356, 12357, 12358, 12359,
    12360, 13467, 13468, 12361, 13469, 12362, 13470, 12363, 12364, 13479,
    13480, 12395, 12396, 13481, 12397, 12398, 12399, 13482, 12400, 12401,
    12402, 12403, 12404, 12405, 12406, 12436, 12437, 12438, 12439, 12440,
    12441, 12442, 12443, 13588, 13589, 12444, 12445, 13590, 12540, 12541,
    12542, 12564, 12565, 12572, 12573, 12574, 12575, 12576, 13602, 12577,
    13603, 12578, 12579, 12580, 12581, 12582, 12583, 13611, 12615, 12616,
    12617, 13612, 12618, 12619, 12620, 12621, 12622, 12623, 12624, 12625,
    13613, 12626, 13614, 12747, 12748, 12749, 12750, 13621, 13622, 12751,
    12752, 13623, 12753, 12754, 12755, 13624, 12762, 12763, 12764, 13632,
    12796, 12797, 12798, 12799, 13633, 12800, 12801, 12802, 12803, 12804,
    12805, 13634, 13635, 12806, 12807, 13642, 12928, 12929, 12930, 12931,
    12932, 12933, 12934, 13643, 13644, 12935, 13645, 12936, 13646, 12937,
    12938, 13654, 13655, 12970, 12971, 13656, 12972, 13657, 13658, 13659,
    13660, 12973, 12974, 12975, 12976, 12977, 12984, 13007, 13671, 13008,
    13009, 13010, 13011, 13012, 13013, 13672, 13673, 13014, 13015, 13674,
    13110, 13111, 13112, 13124, 13125, 13126, 13127, X, X, X, X, X, X, X, X, X,
    X, X, X, 19134, 16257, X, X, X, 18979, 21612, X, 22546, X, X, 18595, 18533,
    X, X, X, X, X, 18940, X, X, X, X, 19910, 18986, X, X, X, 14044, 18578,
    20662, X, X, X, 17577, X, X, 22937, X, 20117, X, 19172, X, X, X, 23092, X,
    X, X, X, X, X, X, X, X, X, X, X, 6413, X, 6414, X, 6746, 6747, 6748, 6749,
    6750, 6751, 6752, 6753, 6754, 6755, 6756, 6757, 6758, 6759, 6760, 7129,
    7159, 7158, 7140, 7131, 7163, 7162, 7142, 7130, 7161, 7160, 7141, 7132,
    7153, 7166, 7167, 8331, 8332, 8333, 8334, 8335, 8336, 8337, 8338, 8339,
    8340, 8341, 8342, 8343, 8344, 8345, 8346, 7698, X, X, X, X, X, X, 6207,
    7705, X, X, X, X, X, 7708, X, 7786, 7787, 7788, 7789, X, X, X, X, X, X, X,
    X, X, X, X, 23679, 18787, X, 15872, 19757, 23319, 20236, X, X, 15871, X, X,
    X, X, 23320, X, 16084, 21438, X, X, 22416, 22547, X, 15172, X, X, X, 17006,
    X, X, X, 14374, X, X, 15304, 17619, X, 17424, X, X, X, X, X, 18344, X,
    18535, X, 16061, X, X, 15920, X, 18390, X, 19332, X, 22026, X, X, X, X, X,
    X, X, X, X, X, 22187, X, X, X, X, 16824, 19915, 16848, X, 22217, 18182, X,
    X, X, X, X, X, 20097, X, X, X, X, 19509, X, X, X, 14747, X, 21787, X,
    14629, X, X, X, 23099, X, X, X, 16318, 16323, X, X, X, X, X, X, 19502,
    21062, X, X, 14993, 22355, 18163, 23559, 15306, X, X, X, 16525, X, X, X,
    23315, 14245, 22984, 14438, 15769, X, X, X, X, 18953, X, X, X, X, X, 21643,
    X, 19706, 22039, X, X, X, X, 19567, 16497, X, X, X, X, 17825, X, 21197,
    17076, X, X, X, 22559, X, X, X, X, X, X, X, X, X, X, X, 19922, X, 20658,
    14983, X, 19515, X, X, X, X, X, X, X, X, X, X, X, 14576, 22918, X, 21447,
    16897, 17280, 13986, 16853, X, X, X, 16666, X, X, X, X, X, X, 14173, 21409,
    X, X, 22010, 22916, X, X, 18370, 18369, 20997, 18583, 22417, X, X, 23323,
    15308, X, 14603, X, 15309, 17462, 19711, X, 21274, 14746, 23135, X, X, X,
    X, X, 22784, X, X, X, X, X, X, X, X, X, 18371, X, X, X, X, X, 19681, 19377,
    X, X, 16526, 15159, 17660, 22596, X, 22418, X, 17282, X, X, X, X, 23349,
    16296, X, X, X, X, X, X, X, X, X, X, 16075, X, X, X, X, 18771, X, X, X, X,
    19946, 20053, X, X, X, X, 23678, 15002, X, X, X, X, X, X, X, X, X, 20665,
    X, 15921, 17426, 16516, X, 19499, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    21077, 18548, 18373, X, X, X, 15896, X, X, X, X, 17837, X, X, X, X, X, X,
    18769, X, 20664, X, X, X, X, X, 19944, X, 18809, 15305, 19675, X, 20067,
    22985, 19329, 22381, X, X, X, 15904, X, X, X, 17782, X, X, X, X, X, X, X,
    22962, X, X, X, X, 16455, X, X, X, X, X, X, 22535, X, X, X, X, 17858,
    21654, X, 16094, X, X, X, 16673, X, 21225, 15296, 15297, 16146, 17792, X,
    X, 22036, X, X, X, 23738, 23737, 22521, X, X, X, X, X, 23366, X, X, X,
    23735, X, 18174, 14792, X, X, X, 22758, 19151, X, X, X, 14989, X, X, 14963,
    X, 20089, X, X, 16683, X, X, X, X, X, X, X, 17017, 20061, X, X, X, X,
    19176, X, X, X, X, X, X, X, 20651, X, X, X, 23717, 13997, X, X, X, 22969,
    15341, 20857, X, 15915, 16818, 23663, 16492, 23164, 18780, X, X, X, X, X,
    X, X, X, X, X, X, X, 18418, 17471, 6825, 6826, 6827, 6828, 6829, 6830,
    6831, 6832, 6833, 6834, 6835, 6836, 6837, 6838, 6839, X, 22203, X, X,
    21761, 17639, 18341, X, 14813, 17401, X, X, X, X, 18725, X, 16669, 22976,
    X, 14788, 23089, 19303, X, 23176, X, X, 23114, 14385, 21040, 16108, X,
    19876, X, 14386, 23138, X, X, 18387, X, X, 16489, X, X, 17418, X, 17803,
    6809, 6810, 6811, 6812, 6813, 6814, 6815, 6816, 6817, 6818, 6819, 6820,
    6821, 6822, 6823, 6824, 6240, 6239, X, 6400, 6404, 6405, 6408, 6407, 6406,
    6409, X, X, X, X, X, X, X, 20709, X, X, X, X, X, X, X, X, 16091, X, X, X,
    X, X, X, 20699, 19860, 16298, X, 14572, X, 20641, 15324, X, X, 14945, X, X,
    20452, X, X, X, 18191, X, 22228, X, X, X, X, 20311, X, X, 15712, 23541,
    15544, 22950, X, X, X, X, X, X, X, X, 14803, X, X, 20472, X, X, X, 18603,
    X, X, X, X, X, 18552, X, 22528, X, X, X, 22770, 14749, X, X, X, 16675,
    22949, X, X, X, X, X, X, X, X, X, X, 15319, X, X, X, X, 16308, 21961,
    21829, 17083, X, 16462, X, 18542, X, X, X, X, X, X, X, X, X, 15874, X, X,
    X, X, 14569, 19533, 23492, X, 18541, X, X, 19290, X, X, X, 18584, X, X, X,
    18017, X, 18184, 18005, X, 14767, X, 20863, X, X, X, X, X, X, X, X, X,
    18973, X, 18181, X, 14940, X, 16097, 16501, 18540, X, 16459, X, X, X, X, X,
    X, 14599, 18731, X, 17213, 23311, X, 21822, X, 16820, 23346, 23725, X, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 18977, 23482, 14433, X, X, 17613,
    23134, X, 22578, X, X, 23093, X, X, X, X, X, 15138, X, X, X, 21995, 18171,
    X, X, X, X, 17987, 7522, 7523, 7524, 7525, 7526, 7527, 7528, 7529, 7530,
    7531, 7532, 7533, 7534, 7535, 7536, 7537, 6401, 6402, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 16304, 14595, 16902, X, X, X, X, X, X, X, X, X, X,
    17638, X, X, X, 22954, X, X, X, X, X, X, X, X, 15888, X, X, X, 23290, X, X,
    X, 14204, X, X, X, X, 23339, 21634, X, X, 20079, 21635, 21207, X, X, X, X,
    X, 17249, X, X, X, X, X, 16660, X, X, X, 15152, X, 15005, 21797, 18200, X,
    X, 22370, X, X, X, X, X, X, X, X, X, X, X, X, 20855, 9046, 12, 13, 14,
    9047, 15, 16, 17, 18, 19, 20, 21, 9048, 9049, 22, 9050, 53, 54, 55, 56,
    9059, 57, 64, 65, 9060, 66, 67, 68, 9061, 69, 70, 71, 9068, 9069, 98, 9070,
    9071, 9072, 9073, 99, 100, 9074, 9075, 9076, 9077, 101, 102, 103, 9090,
    124, 125, 126, 127, 128, 129, 130, 9091, 9092, 131, 9093, 9094, 9095, 132,
    133, 9102, 9103, 160, 161, 9104, 162, 163, 9105, 9106, 164, 9107, 165,
    9108, 166, 167, 9109, 187, 9219, 188, 189, 190, 191, 192, 193, 9220, 194,
    195, 196, 9221, 197, 198, 199, 230, 231, 232, 233, 9230, 9231, 234, 9232,
    235, 9233, 236, 237, 238, 239, 240, 241, 9241, 273, 274, 9242, 9243, 9244,
    9245, 275, 276, 277, 278, 9246, 9247, 9248, 279, 9249, 304, 305, 306, 307,
    9258, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 9264, 9265,
    346, 9266, 347, 348, 349, 350, 351, 352, 353, 354, 9267, 355, 356, 357,
    9274, 9275, 384, 385, 386, 387, 388, 389, 9276, 9277, 390, 9278, 391, 9279,
    392, 393, 9281, 9282, 431, 432, 9283, 433, 434, 9284, 9285, 435, 9286, 436,
    437, 444, 445, 446, 9302, 9303, 464, 465, 466, 9304, 467, 468, 9305, 9306,
    469, 470, 9307, 471, 472, 473, 497, 498, 499, 500, 501, 502, 503, 504, 505,
    506, 507, 508, 509, 510, 511, 512, 9416, 542, 543, 544, 9417, 545, 546,
    547, 548, 549, 550, 551, 9418, 9419, 552, 9420, 577, 578, 579, 580, 9429,
    581, 582, 583, 9430, 584, 585, 586, 9431, 587, 588, 589, 624, 625, 626,
    627, 634, 635, 636, 637, 638, 639, 640, 641, 9436, 9437, 642, 643, 9449,
    665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 9450, 9451, 676,
    677, 9455, 707, 708, 709, 9456, 710, 711, 712, 9457, 713, 714, 715, 716,
    717, 718, 719, 748, 749, 750, 751, 752, 753, 754, 755, 9462, 9463, 756,
    757, 9464, 758, 759, 760, 784, 785, 792, 793, 794, 795, 796, 797, 9474,
    9475, 798, 799, 800, 801, 802, 803, 9484, 834, 835, 836, 9485, 837, 838,
    839, 840, 841, 842, 843, 9486, 9487, 844, 845, 877, 878, 879, 880, 9489,
    9490, 881, 882, 9491, 883, 9492, 884, 9493, 885, 9494, 886, 913, 914, 915,
    916, 917, 918, 919, 920, 921, 922, 923, 924, 9597, 9598, 925, 926, 9610,
    9611, 9612, 948, 949, 950, 951, 952, 9613, 9614, 953, 9615, 9616, 9617,
    9618, 9619, 9631, 9632, 975, 982, 9633, 983, 984, 985, 9634, 986, 987, 988,
    989, 990, 991, 992, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 9637,
    9638, 1037, 9639, 9640, 1038, 1039, 1040, 1060, 1061, 1062, 1063, 9654,
    9655, 1064, 9656, 9657, 9658, 1065, 1066, 1067, 1068, 1069, 1070, 9669,
    1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104,
    1105, 1106, 1107, 1131, 1132, 9679, 9680, 9681, 1133, 1134, 1135, 9682,
    1136, 1137, 1138, 9683, 1139, 1140, 1141, 1179, 1180, 1181, 1182, 1183,
    1184, 1185, 1186, 1187, 1188, 1189, 1190, 9685, 1191, 1192, 1193, 9790,
    1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 9791, 1232, 9792, 1233,
    9793, 1234, 1235, 9803, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266,
    1267, 1268, 1269, 1270, 1271, 1272, 1273, 1304, 1305, 1306, 1307, 1308,
    1309, 1310, 1311, 9806, 1312, 1313, 1314, 9807, 1315, 1316, 1317, 1344,
    1345, 1346, 1347, 9814, 9815, 1348, 1349, 1350, 9816, 1351, 1352, 1353,
    1354, 1355, 1362, 9830, 1382, 1383, 1384, 9831, 1385, 1386, 1387, 1394,
    1395, 1396, 1397, 1398, 1399, 1400, 1401, 1425, 1426, 9841, 1427, 9842,
    9843, 9844, 1428, 9845, 1429, 1430, 9846, 9847, 9848, 9849, 9850, 9864,
    9865, 1450, 9866, 9867, 9868, 1451, 1452, 1453, 1454, 1455, 1456, 9869,
    1457, 1458, 1459, 1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500,
    1501, 1502, 1503, 1504, 1505, 1506, 1507, 9980, 9981, 1526, 1527, 9982,
    1528, 1529, 1530, 9983, 1531, 1532, 1533, 1534, 1535, 1536, 1537, 9992,
    9993, 1568, 1569, 1570, 1571, 1572, 1573, 9994, 1574, 1575, 1576, 9995,
    1577, 1584, 1585, 10002, 1612, 1613, 1614, 10003, 10004, 1615, 10005, 1616,
    10006, 1617, 10007, 1618, 10008, 1619, 1620, 1649, 1650, 1651, 1652, 1653,
    1654, 1655, 1656, 1657, 1658, 1659, 1660, 1661, 1662, 1663, 1664, 1690,
    1691, 1692, 1693, 10020, 1694, 1695, 1696, 1697, 1698, 1699, 1700, 1701,
    1702, 1703, 1704, 10025, 10026, 1733, 10027, 1734, 10028, 1735, 1742, 1743,
    1744, 1745, 1746, 10029, 1747, 1748, 1749, 1786, 1787, 1788, 1789, 1790,
    1791, 1792, 1793, 1794, 1795, 1796, 1797, 1798, 10032, 1799, 1800, 10039,
    1827, 1828, 1829, 10040, 1830, 1831, 1832, 10041, 1833, 1834, 1835, 1836,
    1837, 1838, 1839, 1861, 10053, 1862, 1863, 1864, 1865, 1866, 1867, 10054,
    1868, 1869, 1870, 1871, 1872, 1873, 1874, 1902, 1903, 1904, 1905, 10060,
    10061, 1906, 10062, 10063, 10064, 10065, 1907, 1908, 1909, 1910, 1911,
    10174, 1938, 1939, 1940, 10175, 1941, 1942, 1943, 1944, 1945, 1946, 1947,
    10176, 10177, 1948, 10178, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992,
    1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 10187, 10188, 2027, 10189,
    10190, 10191, 2028, 2029, 2030, 2031, 2032, 10192, 10193, 10194, 2033,
    2034, 2059, 2060, 2061, 2062, 2063, 2064, 2065, 2066, 2067, 2068, 2069,
    2070, 10203, 2071, 2072, 2073, 10204, 10205, 2106, 2107, 10206, 2108, 2109,
    2110, 10207, 2111, 2112, 2113, 2114, 2115, 2122, 2123, 2159, 2160, 2161,
    2162, 2163, 2164, 2165, 2166, 10211, 2167, 2168, 2169, 2170, 2171, 2172,
    2173, 2204, 2205, 2206, 2207, 2208, 2209, 2210, 2211, 2212, 2213, 2214,
    2215, 2216, 2217, 2218, 2219, 10216, 2250, 2251, 2252, 10217, 2253, 2254,
    2255, 2256, 2257, 2258, 10218, 10219, 2259, 2260, 2261, 2293, 2294, 2295,
    2296, 10221, 2297, 2298, 2299, 2300, 2301, 2302, 2303, 2304, 2305, 2312,
    2313, 10225, 10226, 2349, 2350, 2351, 10227, 2352, 2353, 2354, 2355, 2356,
    2357, 2358, 2359, 2360, 2361, 10232, 2390, 2391, 2392, 2393, 2394, 2395,
    2396, 10233, 10234, 2397, 10235, 2398, 2399, 2400, 2401, 10241, 2429, 2430,
    2431, 10242, 2432, 2433, 2434, 10243, 2435, 2436, 2437, 2438, 2439, 2440,
    2441, 10255, 10256, 10257, 2463, 2464, 2465, 10258, 10259, 10356, 10357,
    2466, 2467, 10358, 2468, 2469, 2470, 2494, 2495, 2502, 2503, 2504, 2505,
    2506, 10368, 2507, 10369, 2508, 2509, 2510, 2511, 2512, 2513, 10372, 2550,
    2551, 2552, 10373, 2553, 2554, 2555, 2556, 2557, 2558, 2559, 10374, 10375,
    2560, 10376, 2582, 2583, 2584, 2585, 10388, 10389, 2586, 2587, 10390, 2588,
    2589, 2590, 10391, 2591, 2592, 2593, 2619, 10399, 2620, 10400, 2621, 2622,
    2623, 2624, 2625, 2626, 2627, 2628, 10401, 10402, 2629, 2630, 2655, 2656,
    2657, 2658, 2659, 2660, 2661, 2662, 2663, 2664, 2665, 2666, 2667, 10411,
    2668, 2669, 10413, 2707, 2708, 2709, 10414, 2710, 2711, 2712, 10415, 2713,
    2714, 2715, 2716, 2717, 2724, 2725, 2749, 10425, 2750, 2751, 2752, 2753,
    2754, 2755, 10426, 10427, 2756, 2757, 10428, 2758, 2759, 2760, 2787, 2788,
    2789, 2790, 2791, 2792, 2793, 2794, 10435, 2795, 2796, 2797, 2798, 2799,
    2800, 2801, 10439, 2831, 2832, 2833, 10440, 2834, 2835, 2836, 2837, 2838,
    2839, 2840, 10441, 2841, 2842, 10442, 2866, 2867, 2868, 2869, 10548, 10549,
    2870, 2871, 10550, 2872, 2873, 2874, 10551, 2875, 2882, 2883, 2915, 2916,
    2917, 2918, 2919, 2920, 2921, 2922, 2923, 2924, 2925, 2926, 10559, 10560,
    2927, 2928, 10572, 10573, 10574, 2950, 2951, 2952, 2953, 2954, 10575,
    10576, 2955, 10577, 2956, 10578, 10579, 2957, 10592, 10593, 2978, 2979,
    2980, 2981, 2982, 2983, 10594, 2984, 2985, 2986, 2987, 2988, 2989, 2990,
    3022, 3023, 3024, 3025, 3026, 3027, 3028, 3029, 10596, 10597, 3030, 3031,
    10598, 3032, 3033, 3034, 3055, 3056, 3057, 3058, 10611, 10612, 3059, 10613,
    10614, 10615, 3060, 3061, 3062, 3063, 3064, 3065, 3095, 3096, 3097, 3104,
    3105, 3106, 3107, 3108, 3109, 3110, 3111, 3112, 3113, 3114, 3115, 3116,
    3139, 3140, 3141, 3142, 10635, 3143, 3144, 3145, 10636, 3146, 3147, 3148,
    3149, 3150, 3151, 3152, 3183, 3184, 3185, 3186, 3187, 3188, 3189, 3190,
    3191, 3192, 3193, 3194, 10639, 3195, 3196, 3197, 10743, 3223, 3224, 3225,
    3226, 3227, 3228, 3229, 3230, 10744, 3231, 10745, 3232, 3233, 3234, 3235,
    10760, 3254, 3255, 3262, 10761, 3263, 3264, 3265, 10762, 3266, 3267, 3268,
    3269, 3270, 3271, 3272, 3308, 3309, 3310, 3311, 3312, 3313, 3314, 3315,
    10766, 3316, 3317, 3318, 10767, 3319, 3320, 3321, 3350, 3351, 3352, 3353,
    10772, 3354, 3355, 10773, 3356, 3357, 3358, 3359, 3360, 3361, 3362, 3363,
    3391, 3392, 3393, 3394, 3395, 3396, 3397, 3398, 3399, 3400, 3401, 3402,
    3403, 3404, 3405, 3406, 3427, 10791, 3428, 3429, 10792, 10793, 10794,
    10795, 10796, 3430, 3431, 10797, 10798, 10799, 10800, 10801, 10811, 10812,
    3461, 10813, 10814, 10815, 3462, 3463, 3464, 10816, 3465, 3466, 10817,
    10818, 3467, 3468, 3505, 3506, 3507, 3508, 3509, 3510, 3511, 3512, 3513,
    3514, 3515, 3516, 3517, 3518, 3519, 3520, 10928, 10929, 3542, 3543, 10930,
    3544, 3545, 10931, 10932, 3546, 3547, 3548, 3549, 3550, 3551, 3552, 10944,
    10945, 3574, 3575, 3576, 10946, 3577, 3578, 10947, 3579, 3580, 3581, 10948,
    3582, 3583, 3584, 3612, 3613, 3614, 3615, 10954, 10955, 3616, 10956, 3617,
    10957, 3618, 3619, 3620, 3621, 3622, 3623, 3658, 3659, 3660, 3661, 3662,
    3663, 3664, 3665, 3666, 3667, 3674, 3675, 3676, 3677, 3678, 3679, 3705,
    3706, 3707, 3708, 10969, 3709, 3710, 3711, 10970, 3712, 3713, 3714, 3715,
    3716, 3717, 3718, 10978, 10979, 3744, 10980, 3745, 10981, 3746, 3747, 3748,
    10982, 10983, 3749, 10984, 3750, 3751, 3752, 3782, 3783, 3784, 3785, 3786,
    3787, 3788, 3789, 3790, 3791, 3792, 3793, 3794, 3795, 3796, 3797, 10993,
    3825, 3832, 3833, 10994, 3834, 3835, 3836, 10995, 3837, 3838, 3839, 3840,
    3841, 3842, 3843, 3872, 3873, 3874, 3875, 3876, 3877, 3878, 3879, 3880,
    3881, 3882, 3883, 3884, 3885, 3886, 3887, 3915, 3916, 3917, 3918, 11011,
    11012, 3919, 11013, 3920, 11014, 11015, 11016, 3921, 3922, 3923, 3924,
    11126, 3944, 3945, 3946, 11127, 3947, 3948, 3949, 3950, 3951, 3952, 3953,
    11128, 11129, 3954, 11130, 3982, 3983, 3984, 3985, 3986, 3987, 3988, 3989,
    3990, 3991, 3992, 3993, 3994, 3995, 3996, 3997, 11141, 4031, 4032, 11142,
    11143, 11144, 4033, 4034, 4035, 4036, 4037, 4038, 11145, 4039, 4040, 4041,
    4077, 4078, 4079, 4080, 4081, 4082, 4083, 4084, 11149, 11150, 4085, 11151,
    11152, 11153, 4086, 4087, 11154, 11155, 4120, 4121, 11156, 4122, 4123,
    4124, 11157, 4125, 4126, 4127, 4128, 4129, 4130, 4131, 4161, 4162, 4163,
    4164, 4165, 4166, 4167, 4168, 4169, 4170, 4171, 4172, 4173, 4174, 4175,
    4176, 4214, 4215, 4216, 4217, 4218, 4219, 4220, 4221, 4222, 4223, 4224,
    4225, 4226, 4227, 4228, 4229, 11166, 4264, 4265, 4266, 11167, 4267, 4268,
    4269, 4270, 4271, 4272, 4273, 11168, 4274, 4275, 11169, 4307, 4308, 4309,
    4310, 4311, 4312, 4313, 4314, 4315, 4316, 4317, 4318, 4319, 4320, 4321,
    4322, 4355, 4356, 4357, 4358, 4359, 4360, 4361, 4362, 4363, 4364, 4365,
    4366, 11171, 4367, 4368, 4369, 11175, 4405, 4406, 4407, 4408, 4409, 4410,
    4411, 11176, 11177, 4412, 4413, 4414, 4415, 4416, 4417, 11178, 11179, 4456,
    4457, 11180, 4458, 4459, 4460, 11181, 4461, 4462, 4463, 4464, 4465, 4466,
    4467, 11197, 11198, 4485, 4486, 4487, 11199, 4488, 4489, 11200, 11201,
    4490, 4491, 11202, 4492, 4493, 4494, 4517, 4518, 4519, 4520, 11309, 11310,
    4521, 11311, 4522, 11312, 4523, 4524, 4525, 4526, 4527, 4528, 11322, 4552,
    4553, 11323, 11324, 4554, 11325, 11326, 4555, 4556, 4557, 4558, 11327,
    11328, 4559, 11329, 4580, 4581, 4582, 4583, 11342, 11343, 4584, 4585,
    11344, 4592, 4593, 4594, 11345, 4595, 4596, 4597, 4628, 4629, 4630, 4631,
    4632, 11354, 4633, 4634, 4635, 4636, 4637, 4638, 11355, 11356, 11357, 4639,
    11369, 4661, 4662, 4663, 4664, 4665, 4666, 4667, 4668, 4669, 4670, 4671,
    4672, 11370, 4673, 4674, 11377, 4701, 4702, 4703, 11378, 4704, 4705, 4706,
    11379, 4707, 4708, 4709, 4710, 4711, 4712, 4713, 4736, 11390, 4737, 4738,
    4739, 4740, 4741, 4742, 11391, 11392, 4743, 4744, 11393, 4745, 4746, 11394,
    4770, 4771, 4772, 4773, 4774, 4775, 4782, 4783, 11500, 4784, 4785, 4786,
    4787, 4788, 4789, 4790, 11509, 4821, 4822, 4823, 11510, 4824, 4825, 4826,
    4827, 4828, 4829, 4830, 11511, 11512, 4831, 11513, 4857, 4858, 4859, 4860,
    11521, 11522, 4861, 4862, 11523, 4863, 4864, 4865, 11524, 11525, 4866,
    4867, 4896, 4897, 4898, 4899, 4900, 4901, 4902, 4903, 4904, 4905, 4906,
    4907, 11530, 11531, 4908, 4909, 11545, 4929, 4930, 4931, 4932, 4933, 4934,
    4935, 11546, 11547, 4936, 4937, 11548, 11549, 4938, 4939, 4963, 4964, 4965,
    4972, 4973, 4974, 4975, 4976, 4977, 4978, 4979, 4980, 4981, 4982, 4983,
    4984, 5022, 5023, 5024, 5025, 5026, 5027, 5028, 5029, 11560, 11561, 5030,
    5031, 11562, 5032, 5033, 5034, 5058, 5059, 5060, 5061, 5062, 5063, 5064,
    5065, 5066, 5067, 5068, 5069, 5070, 5071, 5072, 5073, 11572, 5106, 5107,
    5108, 5109, 5110, 5111, 5112, 5113, 5114, 5115, 5116, 5117, 5118, 5119,
    5120, 5144, 5145, 5146, 5147, 11582, 11583, 5148, 5149, 11584, 5150, 5151,
    5152, 5153, 5154, 5155, 5162, 5199, 5200, 5201, 5202, 11587, 5203, 5204,
    5205, 5206, 5207, 5208, 5209, 11588, 5210, 5211, 5212, 5240, 5241, 5242,
    5243, 5244, 5245, 5246, 5247, 5248, 5249, 5250, 5251, 5252, 5253, 5254,
    5255, 11697, 5281, 5282, 5283, 5284, 5285, 5286, 5287, 5288, 5289, 5290,
    5291, 5292, 5293, 5294, 5295, 5326, 5327, 5328, 5329, 5330, 5331, 5332,
    5333, 11700, 5334, 5335, 5336, 11701, 5337, 5338, 5339, 5384, 5385, 5386,
    5387, 5388, 5389, 5390, 5391, 5392, 11702, 5393, 5394, 5395, 5396, 5397,
    5398, 11712, 5422, 5423, 5424, 11713, 5425, 5426, 5427, 5428, 5429, 5430,
    5431, 11714, 5432, 5433, 5434, 5459, 5460, 5461, 5462, 11723, 11724, 5463,
    5464, 11725, 11726, 11727, 5465, 11728, 11729, 11730, 5466, 11743, 11744,
    5487, 11745, 11746, 11747, 5488, 5489, 5490, 5491, 5492, 5493, 11748,
    11749, 5494, 5495, 11761, 5517, 5518, 5519, 5520, 5521, 5522, 5523, 5524,
    11762, 5525, 5526, 5527, 5528, 5529, 5530, 11876, 11877, 5552, 5553, 11878,
    5554, 5555, 5556, 11879, 5557, 5558, 5559, 5560, 5561, 5562, 5563, 11895,
    11896, 5587, 5588, 5589, 11897, 11898, 11899, 11900, 5590, 5591, 5592,
    11901, 5593, 5594, 5595, 11913, 5617, 5618, 11914, 11915, 11916, 5619,
    11917, 5620, 11918, 5621, 11919, 5622, 5623, 5624, 5625, 11931, 5647, 5648,
    5649, 5650, 5651, 5652, 5653, 5654, 5655, 5656, 5657, 11932, 5658, 5659,
    11933, 5683, 5684, 5685, 5686, 11943, 11944, 5687, 5688, 11945, 5689, 5690,
    5691, 11946, 5692, 5693, 5694, 11957, 11958, 5717, 11959, 5718, 11960,
    5719, 5720, 5721, 5722, 5723, 5724, 11961, 11962, 5725, 5732, 12068, 5756,
    5757, 5764, 5765, 5766, 5767, 5768, 12069, 12070, 5769, 5770, 5771, 12071,
    5772, 5773, 12080, 12081, 5798, 5799, 12082, 5800, 5801, 5802, 12083, 5803,
    5804, 5805, 5806, 5807, 5808, 5809, 5829, 12097, 12098, 12099, 12100,
    12101, 12102, 12103, 12104, 5830, 5831, 5832, 12105, 5833, 5834, 5835,
    5859, 5860, 5861, 12115, 12116, 12117, 5862, 12118, 12119, 12120, 12121,
    5863, 5864, 5865, 12122, 5866, 12138, 5884, 5885, 5886, 12139, 5887, 5888,
    5889, 5890, 5891, 5892, 5893, 12140, 12141, 5894, 12142, 5924, 5925, 5926,
    5927, 12152, 5928, 5929, 5930, 12153, 5931, 5932, 5933, 12154, 5934, 5935,
    5936, 12256, 12257, 5970, 12258, 5971, 12259, 12260, 5972, 5973, 5974,
    5975, 5976, 12261, 12262, 5977, 5978, 12271, 6003, 6004, 6005, 6006, 6007,
    6008, 6009, 12272, 12273, 6010, 6011, 12274, 12275, 6012, 6013, 12277,
    12278, 6045, 6046, 12279, 6047, 6048, 6049, 12280, 6050, 12281, 6051, 6052,
    6053, 6054, 6055, 6076, 12294, 6077, 6078, 6079, 6080, 6081, 6082, 12295,
    6083, 6084, 6085, 6086, 6087, 6088, 6089, 6123, 6124, 6125, 6126, 12301,
    12302, 6127, 12303, 6128, 12304, 6129, 6130, 6131, 6132, 6133, 6134, 12311,
    6167, 6168, 6169, 12312, 12313, 12314, 6170, 6171, 6172, 6173, 6174, 12315,
    12316, 6175, 12317, 6305, 6306, 6307, 6308, 12321, 6309, 6310, 6311, 6312,
    6313, 6314, 6315, 6316, 6317, 6318, 6319, 12326, 12327, 6354, 12328, 6355,
    6356, 6357, 6358, 6359, 6360, 6361, 6362, 12329, 6363, 6364, 6365, 12336,
    6492, 6493, 6494, 6495, 6496, 6497, 6498, 12337, 12338, 6499, 12339, 6500,
    12340, 6501, 6502, 12341, 12342, 6541, 6542, 12343, 6543, 6544, 12344,
    12345, 6545, 12346, 6546, 6547, 6548, 6549, 6550, 12459, 12460, 6661, 6662,
    6663, 6664, 6665, 6666, 12461, 12462, 6667, 6668, 12463, 6669, 6670, 6671,
    6702, 6703, 6704, 6705, 6706, 6707, 6714, 6715, 6716, 12472, 6717, 6718,
    6719, 6720, 6721, 6722, 12475, 6847, 6848, 6849, 12476, 6850, 6851, 6852,
    6853, 6854, 6855, 6856, 12477, 12478, 6857, 12479, 6892, 6893, 6894, 6895,
    12484, 6896, 6897, 6904, 6905, 6906, 6907, 6908, 6909, 6910, 6911, 6912,
    7038, 7039, 7040, 7041, 7042, 7043, 7044, 7045, 7046, 7047, 7048, 7049,
    12486, 12487, 7050, 7051, 12497, 7081, 7082, 7083, 7084, 7085, 7086, 7087,
    7094, 7095, 7096, 7097, 12498, 7098, 7099, 7100, 12501, 7225, 7226, 7227,
    12502, 7228, 7229, 7230, 12503, 7231, 7232, 7233, 7234, 7235, 7236, 7237,
    7274, 12506, 7275, 7276, 7277, 7284, 7285, 7286, 12507, 12508, 7287, 7288,
    12509, 7289, 7290, 7291, 7413, 7414, 7415, 7416, 7417, 7418, 7419, 7420,
    12515, 12516, 7421, 7422, 7423, 7424, 7425, 7426, 7464, 7465, 7466, 7467,
    7474, 7475, 7476, 7477, 7478, 7479, 7480, 7481, 7482, 7483, 7484, 7485,
    7611, 7612, 7613, 7614, 12519, 7615, 7616, 7617, 7618, 7619, 7620, 7621,
    7622, 7623, 7624, 7625, 7667, 7668, 7669, 7670, 7671, 7672, 7673, 7674,
    7675, 7676, 7677, 7678, 12523, 12524, 7679, 7680, 12536, 7796, 7797, 7798,
    7799, 7800, 7801, 7802, 12537, 12538, 7803, 12539, 12636, 12637, 12638,
    7804, 12648, 7834, 7835, 7836, 12649, 7837, 12650, 7838, 12651, 7839, 7840,
    7841, 7842, 7843, 7844, 7845, 7882, 7883, 7884, 7885, 7980, 7981, 7982,
    7983, 12654, 12655, 7984, 7985, 12656, 7986, 7987, 7988, 8017, 8018, 8019,
    8020, 12667, 12668, 8021, 12669, 8022, 12670, 8023, 8024, 8025, 8026, 8027,
    8028, 12675, 8063, 8064, 8065, 8066, 8067, 8068, 8069, 8070, 8071, 8072,
    8073, 8074, 8075, 8170, 8171, 8195, 8202, 8203, 8204, 12685, 8205, 8206,
    8207, 12686, 8208, 8209, 8210, 12687, 8211, 8212, 8213, 8251, 8252, 8253,
    8254, 8255, 8256, 8257, 8258, 8259, 8260, 8261, 8262, 12689, 8263, 8264,
    8265, 8385, 8392, 8393, 8394, 8395, 8396, 8397, 8398, 12697, 8399, 8400,
    8401, 8402, 8403, 8404, 8405, 12706, 8436, 8437, 8438, 8439, 8440, 8441,
    8442, 8443, 8444, 8445, 8446, 8447, 8448, 8449, 8450, 8574, 8575, 8582,
    8583, 8584, 8585, 8586, 8587, 12710, 8588, 8589, 8590, 12711, 8591, 8592,
    8593, 8624, 8625, 8626, 8627, 12720, 8628, 8629, 8630, 8631, 12721, 8632,
    8633, 8634, 8635, 8636, 8637, 8756, 8757, 8758, 8759, 8760, 8761, 8762,
    8763, 8764, 8765, 8772, 8773, 8774, 8775, 8776, 8777, 8806, 8807, 8808,
    8809, 12836, 12837, 8810, 8811, 12838, 8812, 8813, 8814, 12839, 8815, 8816,
    8817, 12848, 12849, 8936, 12850, 12851, 12852, 8937, 8938, 8939, 8940,
    8941, 8942, 12853, 12854, 8943, 8944, 8982, 8983, 8984, 8985, 8986, 8987,
    8994, 8995, 8996, 8997, 8998, 8999, 9000, 9001, 9002, 9003, 12866, 12867,
    9120, 9121, 12868, 9122, 9123, 9124, 12869, 9125, 9126, 9127, 9128, 9129,
    9130, 9131, 12880, 12881, 9160, 9161, 9162, 9163, 9164, 9165, 12882, 9166,
    9167, 9168, 9169, 9170, 9171, 9172, 9207, 9208, 9209, 9210, 12887, 12888,
    9211, 12889, 9212, 12890, 9213, 9214, 9215, 9310, 9311, 9312, 9344, 9345,
    9346, 9347, 9348, 9349, 9350, 9351, 9352, 9353, 9354, 9355, 9356, 9357,
    9358, 9359, 9395, 9396, 9397, 9398, 12901, 9399, 9400, 9401, 9402, 9403,
    9404, 9405, 9500, 9501, 9502, 9503, 12906, 12907, 9538, 12908, 9539, 12909,
    9540, 9541, 9542, 9543, 9544, 9545, 12910, 9546, 9547, 9548, 9583, 9584,
    9585, 9586, 9587, 9588, 9589, 9590, 9591, 9592, 9593, 9594, 9595, 12915,
    9690, 9691, 13020, 9722, 9723, 9724, 13021, 9725, 9726, 9727, 13022, 9728,
    9729, 9730, 9731, 9732, 9733, 9734, 9766, 13030, 9767, 9768, 9769, 9770,
    9771, 9772, 9773, 9774, 9775, 9776, 9777, 9778, 9779, 9780, 9903, 9904,
    9905, 9912, 13035, 13036, 9913, 13037, 9914, 13038, 9915, 9916, 9917, 9918,
    9919, 9920, 13051, 9947, 9948, 9949, 13052, 9950, 9951, 9952, 9953, 9954,
    9955, 9956, 13053, 13054, 9957, 13055, 10080, 10081, 10082, 10083, 10084,
    10085, 10086, 10087, 10088, 10089, 10090, 10091, 10092, 10093, 10094,
    10095, 13065, 13066, 10135, 13067, 13068, 13069, 10136, 10137, 10138,
    10139, 10140, 10141, 13070, 13071, 10142, 10143, 10262, 10263, 10264,
    10265, 10266, 10267, 10268, 10269, 10270, 10271, 10272, 10273, 13080,
    10274, 10275, 10276, 13083, 13084, 10313, 10314, 13085, 10315, 10316,
    10317, 13086, 10324, 10325, 10326, 10327, 10328, 10329, 10330, 10450,
    10451, 10452, 10453, 10454, 10455, 10456, 10457, 13094, 10458, 10459,
    10460, 10461, 10462, 10463, 10464, 10501, 10502, 10503, 10504, 10505,
    10506, 10507, 13097, 10514, 13098, 10515, 10516, 10517, 10518, 10519,
    10520, 13102, 10644, 10645, 10646, 13103, 10647, 10648, 10649, 10650,
    10651, 10652, 10653, 13104, 13105, 10654, 13106, 10690, 10691, 10692,
    10693, 13206, 10694, 10695, 10696, 10697, 10704, 10705, 10706, 10707,
    10708, 10709, 10710, 13211, 13212, 10833, 10834, 10835, 13213, 10836,
    10837, 10838, 10839, 10840, 10841, 13214, 10842, 10843, 10844, 13223,
    10875, 13224, 10876, 10877, 10878, 10879, 10880, 13225, 13226, 10881,
    13227, 10882, 10883, 10884, 10885, 13233, 13234, 10919, 10920, 13235,
    10921, 10922, 10923, 13236, 10924, 10925, 11020, 11021, 11022, 11023,
    11024, 13250, 13251, 11044, 11045, 11052, 13252, 11053, 11054, 13253,
    13254, 11055, 11056, 13255, 11057, 11058, 11059, 11090, 11091, 11092,
    11093, 11094, 11095, 11096, 11097, 11098, 11099, 11100, 11101, 11102,
    11103, 11104, 11105, 13266, 11230, 11231, 11232, 13267, 11233, 11234,
    11235, 11242, 11243, 11244, 11245, 13268, 13269, 11246, 13270, 11275,
    11276, 11277, 11278, 13281, 11279, 11280, 11281, 13282, 11282, 11283,
    11284, 13283, 11285, 11286, 11287, 11408, 13290, 11409, 13291, 11410,
    11411, 11412, 11413, 11414, 11415, 11416, 11417, 13292, 13293, 11418,
    11419, 11451, 11452, 11453, 11454, 11455, 11456, 11457, 11464, 11465,
    11466, 11467, 11468, 11469, 13397, 11470, 11471, 13398, 11598, 11599,
    11600, 13399, 11601, 11602, 11603, 11604, 11605, 11606, 11607, 11608,
    11609, 11610, 11611, 11645, 11646, 11647, 11654, 11655, 11656, 11657,
    11658, 13405, 13406, 11659, 11660, 13407, 11661, 11662, 13408, 11782,
    11783, 11784, 11785, 11786, 11787, 11788, 11789, 11790, 13416, 11791,
    11792, 11793, 11794, 11795, 11796, 13418, 11834, 11835, 11836, 13419,
    11837, 11844, 11845, 11846, 11847, 11848, 11849, 13420, 11850, 11851,
    13421, 11972, 11973, 11974, 11975, 13428, 11976, 11977, 11978, 13429,
    11979, 11980, 11981, 13430, 11982, 11983, 11984, 12020, 12021, 12022,
    12023, 12024, 12025, 12026, 12027, 12034, 12035, 12036, 12037, 13434,
    13435, 12038, 12039, 13445, 12063, 12064, 12065, 12160, 13446, 12161,
    12162, 13447, 13448, 12163, 13449, 12164, 13450, 12165, 12166, 13460,
    12196, 12197, 12198, 12199, 12200, 12201, 12202, 12203, 12204, 12205,
    12206, 12207, 12208, 12209, 12210, 12248, 12249, 12250, 12251, 12252,
    12253, 12254, 12255, 13462, 13463, 12350, 12351, 13464, 12352, 12353,
    12354, 12383, 12384, 12385, 12386, 13475, 13476, 12387, 13477, 12388,
    13478, 12389, 12390, 12391, 12392, 12393, 12394, 13489, 12423, 12424,
    12425, 13586, 12426, 12427, 12428, 12429, 12430, 12431, 12432, 12433,
    13587, 12434, 12435, 12553, 13597, 12554, 12555, 13598, 13599, 12556,
    12557, 13600, 12558, 12559, 12560, 13601, 12561, 12562, 12563, 12597,
    12604, 12605, 13607, 12606, 13608, 12607, 12608, 12609, 12610, 12611,
    12612, 13609, 13610, 12613, 12614, 13618, 12734, 12735, 12736, 12737,
    12738, 12739, 12740, 12741, 13619, 12742, 13620, 12743, 12744, 12745,
    12746, 13629, 12777, 12778, 12779, 13630, 12780, 12781, 12782, 13631,
    12783, 12784, 12785, 12786, 12787, 12794, 12795, 12822, 13638, 12823,
    12824, 12825, 12920, 12921, 12922, 13639, 13640, 12923, 12924, 13641,
    12925, 12926, 12927, 12957, 12958, 12959, 12960, 13651, 12961, 12962,
    13652, 12963, 13653, 12964, 12965, 12966, 12967, 12968, 12969, 13667,
    12995, 12996, 12997, 13668, 12998, 12999, 13000, 13001, 13002, 13003,
    13004, 13669, 13670, 13005, 13006, 14203, 14209, 14226, 14582, 14607,
    14738, 15006, 15107, 15129, 15153, 15166, 15347, 15348, 15351, 15354,
    15355, 15377, 15381, 15385, 15387, 15388, 15389, 15487, 15488, 15492,
    15493, 15494, 15495, 15496, 15498, 15503, 15515, 15537, 15538, 15539,
    15540, 15542, 15543, 15547, 15548, 15550, 15551, 15553, 15554, 15555,
    15556, 15557, 15558, 16290, 16478, 16503, 17232, 17263, 17390, 17580,
    17628, 17659, 17857, 17859, 17974, 18020, 18027, 18226, 18348, 19186,
    19187, 19189, 19286, 19289, 19292, 19298, 19300, 19301, 19302, 19304,
    19308, 19309, 19313, 19321, 19323, 19366, 19367, 19370, 19371, 19372,
    19374, 19476, 19481, 19484, 19485, 19487, 19488, 19491, 19506, 19508,
    19513, 19756, 19759, 19862, 19867, 19899, 19942, 20078, 20114, 20129,
    20132, 20137, 20139, 20239, 20242, 20244, 20245, 20440, 20441, 20442,
    20443, 20446, 20449, 20451, 20457, 20458, 20462, 20463, 20466, 20467,
    20478, 20486, 20487, 22023, 22409, 22411, 22539, 22555, 22566, 22764,
    22785, 23086, 23087, 23155, 23474, X, X, X, X, 6216, X, X, X, X, X, 6386,
    X, X, X, X, X, X, X, 17844, X, X, X, 15692, X, X, X, X, 22212, X, 14998, X,
    X, X, X, X, X, X, X, X, 17429, X, 15148, X, X, X, 23469, 18605, X, X, X, X,
    X, X, 23112, X, 22149, 23285, X, X, X, X, 20516, 17593, X, X, X, X, 19294,
    X, 21078, X, X, X, X, X, X, X, X, 23359, 16062, X, X, X, 21461, X, 19336,
    16639, X, 22946, 16149, X, X, X, X, X, X, X, 16653, 21581, X, X, X, 22928,
    X, X, X, X, 17658, 20135, X, 22354, 18362, 14566, 21997, 19330, 18161, X,
    X, 15931, X, 22380, X, 16524, X, X, 16686, X, 14628, 21576, X, X, 15867,
    15001, X, X, X, X, X, X, X, X, X, X, X, X, 19097, X, X, X, 20099, 21391, X,
    X, X, X, X, X, X, 17241, X, 22550, X, 14770, X, X, 15925, X, X, X, 23711,
    X, X, X, X, 15571, X, X, 21464, X, 21601, 18188, X, X, X, X, X, X, X, X,
    19859, X, 21278, X, X, X, X, X, 16447, X, X, X, X, X, 22172, 20869, X,
    17264, X, 17637, X, X, 16895, 19858, X, X, X, X, X, X, X, X, 16258, X, X,
    23701, X, X, X, 19666, 20070, X, X, X, X, X, 21437, X, X, X, X, X, 16457,
    14936, X, 16823, 19106, X, X, X, X, X, X, X, X, X, X, X, X, 19328, X,
    22216, 18785, X, X, X, X, X, X, 15683, X, 17211, X, X, 19153, 18746, X, X,
    17459, X, X, 21272, X, 21227, 15135, X, 17635, X, X, X, X, 15919, 17651,
    17077, X, X, X, X, X, 15929, X, 16334, X, 14590, 17821, X, X, 21653, 16103,
    19152, X, X, X, X, X, X, 23504, 17439, 18589, X, X, X, 17021, X, 18744, X,
    14980, 21217, 20483, X, 17630, 23355, X, X, 20437, X, X, X, 21194, 21836,
    X, X, X, 18763, X, X, 21656, X, 17233, 15186, X, 15187, X, X, X, 23091, X,
    X, X, X, 22959, X, X, X, X, 20479, X, X, 16866, X, X, X, X, 15737, X,
    21969, 22543, 17478, X, 19741, 18976, X, 13975, 18424, X, 20062, X, X, X,
    X, 21641, X, X, 23163, X, X, X, 23123, X, X, X, X, X, X, X, X, X, X, X, X,
    7740, 7741, 7742, 7743, 7015, 7016, X, 7017, 7018, 7019, 7020, 7021, 7022,
    7023, X, X, X, X, X, X, X, 23703, X, X, X, X, X, X, X, X, 16518, X, X, X,
    23517, X, 17060, 14408, 18044, 16499, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 23334, X, 17843, X, X, X, X, X, X, X, X, 18555, X, X, X, X, X, 19683,
    X, X, X, X, X, 17063, X, 21625, 23329, 19873, 15321, X, 21411, X, 19114,
    23360, 19920, 23719, 23493, X, 17007, 17008, X, 15486, X, X, 22768, X,
    22597, X, X, X, X, X, X, X, X, X, X, X, 18799, 14583, X, X, X, 18150, X,
    22526, X, X, 20250, X, X, X, X, X, 19157, X, 20075, 16832, X, X, X, X, X,
    13988, X, X, 15746, X, 22774, X, X, 18724, X, X, X, X, X, X, X, X, X, X, X,
    X, 18149, 19865, X, X, X, X, X, X, X, 16855, X, X, 20872, 16464, X, X, X,
    18010, 17243, 17244, X, X, 16058, X, X, X, X, 21203, X, X, 15149, X, X, X,
    X, X, X, X, 14003, X, X, 16089, X, X, 14004, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 16678, X, X, 18147, X, X, X, X, X, X, X, X, 21976, 18604, X,
    16896, 21414, 15502, X, X, X, X, 14418, X, 16851, 19947, X, X, X, X, X, X,
    X, 14780, X, X, X, X, X, X, X, X, 20809, X, X, X, X, 15109, X, X, 14207,
    18175, 18803, 20118, 23483, X, X, X, X, X, 18229, X, 14979, X, 22331, X, X,
    X, X, X, X, 18740, 20272, 21954, 14557, 15574, X, 17018, 15552, 14206, X,
    X, X, 18173, X, 21987, 15955, X, 23665, 22961, X, X, X, X, X, 6233, 6232,
    X, X, X, X, X, X, X, 6412, 6411, 6936, 6937, 6938, 6939, 6940, 6941, 6942,
    6943, 6944, 6945, X, X, X, X, X, X, X, 14594, X, X, X, X, X, X, X, 14547,
    17246, X, 23156, 16692, 21978, X, 17598, X, X, X, 21650, X, X, 15879, X, X,
    23130, X, X, X, X, X, X, X, X, X, X, X, X, 19352, 18616, X, 14351, X, X, X,
    X, 17032, X, 20878, X, X, X, 22193, X, X, 22194, X, X, 23118, X, X, X,
    17774, X, X, X, X, X, X, 19173, 17387, X, X, 18193, X, X, X, X, X, 22401,
    17065, 23153, X, 18192, X, X, X, X, X, X, 14768, X, X, 14620, X, X, X,
    23671, 16063, X, 17411, X, X, 14365, X, X, X, X, X, X, X, X, X, X, X,
    21631, X, X, X, X, 21424, X, X, X, X, X, X, X, X, X, X, X, 17777, X, X, X,
    X, 17034, X, X, X, X, X, X, X, X, X, X, X, 23345, X, X, X, X, X, 22753, X,
    X, 23709, X, X, X, X, 22754, X, 22755, 20498, 21038, X, 22375, X, X, X,
    16643, 20674, 17973, 17985, 22922, X, 17469, X, X, 6229, X, X, X, X, X, X,
    X, X, X, X, X, X, X, X, 21033, X, 17033, 16717, X, X, X, X, X, X, 23137, X,
    X, X, 20494, X, X, 20661, X, X, X, X, X, X, X, X, X, X, X, X, X, 23105, X,
    X, 7697, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 16828, 17846, X, X,
    X, 21248, 22741, X, X, X, X, X, 20849, X, X, 17847, X, 14579, X, X, X, X,
    20672, X, X, X, X, 16658, X, X, X, X, 22956, 20076, X, X, X, 21009, X, X,
    X, 21993, 14808, X, 23471, X, X, X, X, X, X, X, 21466, X, X, X, X, 23705,
    15328, 18349, X, X, 20460, 15009, X, 22736, 16691, 15747, X, X, 17773,
    22013, 20459, X, 16900, 21979, X, X, X, X, X, X, X, X, X, X, X, X, X,
    14225, X, 18760, X, X, X, X, 22029, 23103, X, X, 21080, 14028, X, 20252,
    20646, X, 20819, 16259, X, X, X, X, X, X, X, X, X, X, X, X, 16509, 18558,
    X, 14729, X, X, X, X, X, X, 17771, X, X, 20329, X, 20296, 21249, 18559, X,
    21811, 19146, X, X, 21812, X, X, X, 21793, X, X, X, X, X, 21417, X, 14728,
    X, X, X, X, 21593, 20492, X, X, 16118, X, X, X, 16314, X, X, X, X, 20251,
    22012, X, X, X, 15732, X, X, X, X, X, X, 16057, X, X, X, X, X, 14201,
    23331, X, X, 15162, X, X, 17625, 22599, 19535, 18910, 19861, 14237, X, X,
    X, X, X, X, 20698, 17442, 18190, X, X, X, X, 22573, 17270, X, 18049, X, X,
    16690, X, 22598, X, 16506, X, X, X, X, X, X, 21828, X, X, X, X, 16702,
    18751, 21266, X, X, 22009, X, X, X, X, X, 15891, 18924, X, 19913, X, 17787,
    X, 16846, 23280, 18413, X, X, X, X, X, X, 22523, X, X, X, X, 23321, X, X,
    20069, 15384, X, X, X, X, X, X, 17425, X, X, X, X, X, 15136, X, 23097,
    22184, 19494, X, X, X, X, X, X, 22743, X, X, X, X, X, X, X, X, X, 22350, X,
    X, X, X, X, X, 14775, X, 18726, 20299, X, X, X, 14815, 14242, 19100, 7949,
    7950, 7951, 7952, 7953, 7954, 7955, 7956, 7957, 7958, 7959, 7960, 7961,
    7962, 7963, 7964, 7778, 7779, 7780, X, X, X, X, X, X, X, X, X, X, X, X, X,
    18420, 21394, X, 21816, X, X, X, 18963, X, X, X, X, X, X, X, X, 22393, X,
    22517, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 22005, X, 17285, X, X, X,
    19686, X, 15681, X, X, X, X, X, X, 23676, X, 16440, X, X, X, X, 22587, X,
    X, 19703, X, X, X, X, X, X, 7506, X, X, X, X, X, X, X, X, X, X, 19099, X,
    X, X, 16077, X, 18401, 15333, X, X, X, X, X, X, X, X, X, X, 22373, 20305,
    17094, 21796, X, X, 18932, X, X, X, X, 19299, X, X, X, X, X, 21017, X,
    20298, X, X, X, X, X, 16288, X, X, X, 21965, X, X, X, X, 18957, X, X, X,
    20080, X, 21015, X, X, X, 16465, X, 21982, 17388, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 15938, X, X, 15338, 16313, X, X, X, 16137, X, X, X, X, X,
    17855, X, 16523, 9033, 9034, 9035, 9036, 9037, 9038, 9039, 9040, 9, 9041,
    9042, 9043, 9044, 9045, 10, 11, 9056, 40, 41, 42, 43, 44, 45, 46, 47, 48,
    49, 9057, 50, 9058, 51, 52, 9062, 9063, 88, 89, 9064, 90, 91, 9065, 9066,
    92, 9067, 93, 94, 95, 96, 97, 9083, 9084, 115, 116, 117, 118, 119, 120,
    9085, 9086, 9087, 121, 9088, 122, 123, 9089, 146, 147, 148, 149, 150, 9100,
    151, 9101, 152, 153, 154, 155, 156, 157, 158, 159, 9117, 177, 178, 179,
    9118, 180, 9119, 181, 182, 183, 184, 185, 9216, 9217, 186, 9218, 212, 213,
    214, 215, 9226, 9227, 222, 223, 9228, 224, 225, 226, 9229, 227, 228, 229,
    261, 9237, 262, 9238, 263, 264, 265, 266, 267, 268, 269, 270, 9239, 9240,
    271, 272, 9255, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301,
    9256, 9257, 302, 303, 9260, 9261, 334, 335, 9262, 336, 337, 338, 9263, 339,
    340, 341, 342, 343, 344, 345, 372, 373, 374, 375, 376, 377, 378, 379, 9270,
    9271, 380, 381, 9272, 382, 383, 9273, 415, 416, 417, 418, 419, 420, 421,
    422, 423, 424, 425, 426, 427, 428, 429, 430, 9296, 454, 455, 456, 9297,
    457, 9298, 458, 459, 460, 461, 462, 9299, 9300, 463, 9301, 484, 485, 486,
    487, 9410, 9411, 488, 489, 490, 491, 492, 493, 9412, 494, 495, 496, 529,
    530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 9413, 9414, 9415,
    541, 564, 565, 566, 567, 568, 569, 570, 571, 9426, 572, 573, 9427, 574,
    9428, 575, 576, 9435, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618,
    619, 620, 621, 622, 623, 654, 9444, 9445, 9446, 655, 656, 657, 658, 9447,
    9448, 659, 660, 661, 662, 663, 664, 692, 693, 694, 695, 696, 697, 698, 699,
    700, 9454, 701, 702, 703, 704, 705, 706, 732, 733, 734, 735, 736, 737, 738,
    739, 740, 741, 742, 743, 744, 745, 746, 747, 770, 771, 772, 773, 9472, 774,
    775, 776, 777, 778, 779, 780, 9473, 781, 782, 783, 9480, 9481, 816, 817,
    9482, 824, 825, 826, 827, 828, 829, 830, 9483, 831, 832, 833, 861, 862,
    863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 874, 875, 876, 897,
    898, 899, 900, 901, 902, 903, 904, 905, 906, 907, 908, 909, 910, 911, 912,
    938, 9604, 939, 940, 941, 942, 943, 944, 9605, 9606, 9607, 945, 9608, 946,
    947, 9609, 964, 965, 966, 967, 9626, 9627, 968, 9628, 9629, 9630, 969, 970,
    971, 972, 973, 974, 1007, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021,
    1022, 1023, 1024, 1025, 1026, 1027, 1028, 1049, 1050, 1051, 9649, 9650,
    9651, 1052, 1053, 9652, 1054, 1055, 1056, 9653, 1057, 1058, 1059, 9663,
    9664, 1083, 1084, 9665, 9666, 1085, 1086, 9667, 1087, 1088, 1089, 9668,
    1090, 1091, 1092, 9673, 1121, 9674, 1122, 1123, 1124, 1125, 1126, 9675,
    9676, 1127, 9677, 1128, 9678, 1129, 1130, 1157, 1158, 1159, 1160, 1161,
    1162, 1163, 1164, 1165, 1172, 1173, 1174, 1175, 1176, 1177, 1178, 1211,
    1212, 1213, 1214, 1215, 1216, 1217, 1218, 9787, 9788, 1219, 1220, 9789,
    1221, 1222, 1223, 1247, 1248, 1249, 1250, 9799, 9800, 1251, 9801, 1252,
    9802, 1253, 1254, 1255, 1256, 1257, 1258, 1288, 1289, 1290, 1291, 1292,
    1293, 1294, 1295, 1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1331,
    1332, 1333, 1334, 9811, 9812, 1335, 1336, 1337, 1338, 1339, 1340, 9813,
    1341, 1342, 1343, 9823, 9824, 1373, 9825, 1374, 9826, 9827, 1375, 1376,
    1377, 9828, 1378, 9829, 1379, 1380, 1381, 9835, 1415, 9836, 1416, 1417,
    1418, 1419, 1420, 9837, 9838, 1421, 9839, 1422, 9840, 1423, 1424, 9860,
    9861, 1438, 1439, 9862, 1440, 1441, 1442, 9863, 1443, 1444, 1445, 1446,
    1447, 1448, 1449, 1476, 1477, 1478, 1479, 1480, 1481, 1482, 1483, 1484,
    1485, 1486, 1487, 1488, 1489, 1490, 1491, 1516, 1517, 1518, 1519, 9878,
    9879, 1520, 9976, 1521, 9977, 1522, 9978, 1523, 1524, 9979, 1525, 9990,
    1554, 1555, 1556, 9991, 1557, 1558, 1559, 1560, 1561, 1562, 1563, 1564,
    1565, 1566, 1567, 1602, 1603, 1604, 1605, 9996, 9997, 1606, 1607, 9998,
    1608, 1609, 9999, 10000, 1610, 10001, 1611, 1634, 1635, 1636, 1637, 1638,
    1639, 1640, 1641, 1642, 1643, 1644, 1645, 10012, 1646, 1647, 1648, 10016,
    1678, 1679, 1680, 1681, 1682, 1683, 1684, 10017, 10018, 1685, 10019, 1686,
    1687, 1688, 1689, 10021, 10022, 1721, 1722, 10023, 1723, 1724, 1725, 10024,
    1726, 1727, 1728, 1729, 1730, 1731, 1732, 10030, 1766, 1767, 1774, 1775,
    1776, 1777, 1778, 10031, 1779, 1780, 1781, 1782, 1783, 1784, 1785, 1814,
    1815, 1816, 1817, 1818, 10036, 1819, 10037, 1820, 10038, 1821, 1822, 1823,
    1824, 1825, 1826, 10046, 1852, 1853, 10047, 10048, 1854, 10049, 1855, 1856,
    1857, 1858, 1859, 10050, 10051, 1860, 10052, 1891, 1892, 1893, 1894, 10055,
    10056, 1895, 1896, 10057, 1897, 1898, 10058, 10059, 1899, 1900, 1901,
    10166, 10167, 1924, 10168, 10169, 10170, 1925, 1932, 1933, 1934, 1935,
    10171, 10172, 10173, 1936, 1937, 1969, 1970, 1971, 1972, 1973, 1974, 1975,
    1976, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 10181, 10182, 2017,
    2018, 10183, 2019, 2020, 2021, 10184, 2022, 10185, 10186, 2023, 2024, 2025,
    2026, 10200, 10201, 2046, 2047, 2048, 2049, 2050, 2051, 10202, 2052, 2053,
    2054, 2055, 2056, 2057, 2058, 2090, 2091, 2092, 2093, 2094, 2095, 2096,
    2097, 2098, 2099, 2100, 2101, 2102, 2103, 2104, 2105, 2138, 2139, 2140,
    2141, 10210, 2142, 2143, 2144, 2145, 2146, 2147, 2154, 2155, 2156, 2157,
    2158, 2190, 2191, 2192, 2193, 10212, 2194, 2195, 2196, 10213, 2197, 2198,
    2199, 2200, 2201, 2202, 2203, 2236, 2237, 2238, 2239, 2240, 2241, 2242,
    2243, 2244, 2245, 2246, 2247, 10214, 10215, 2248, 2249, 2277, 2278, 2279,
    2280, 2281, 2282, 2283, 2284, 2285, 2286, 2287, 2288, 2289, 2290, 2291,
    2292, 10222, 2330, 2331, 2332, 10223, 2333, 2334, 2335, 10224, 2336, 2337,
    2344, 2345, 2346, 2347, 2348, 2378, 2379, 2380, 2381, 2382, 2383, 2384,
    2385, 10228, 10229, 2386, 2387, 10230, 2388, 2389, 10231, 2415, 2416, 2417,
    2418, 10239, 10240, 2419, 2420, 2421, 2422, 2423, 2424, 2425, 2426, 2427,
    2428, 10250, 2452, 2453, 2454, 10251, 2455, 2456, 2457, 2458, 2459, 2460,
    2461, 10252, 10253, 2462, 10254, 2481, 2482, 2483, 2484, 10365, 10366,
    2485, 2486, 10367, 2487, 2488, 2489, 2490, 2491, 2492, 2493, 2536, 2537,
    2538, 2539, 2540, 2541, 2542, 2543, 2544, 2545, 2546, 2547, 10370, 10371,
    2548, 2549, 10383, 2571, 2572, 2573, 2574, 2575, 2576, 2577, 10384, 10385,
    2578, 10386, 2579, 10387, 2580, 2581, 10397, 2605, 2606, 2607, 10398, 2608,
    2609, 2610, 2611, 2612, 2613, 2614, 2615, 2616, 2617, 2618, 2642, 10408,
    2643, 2644, 2645, 2646, 2647, 2648, 10409, 2649, 2650, 2651, 10410, 2652,
    2653, 2654, 2692, 2693, 2694, 2695, 2696, 2697, 2698, 2699, 10412, 2700,
    2701, 2702, 2703, 2704, 2705, 2706, 10421, 2737, 2738, 2739, 10422, 2740,
    2741, 2742, 2743, 2744, 2745, 2746, 2747, 10423, 2748, 10424, 2772, 2773,
    2774, 2775, 10434, 2776, 2777, 2778, 2779, 2780, 2781, 2782, 2783, 2784,
    2785, 2786, 2817, 2818, 2819, 2820, 2821, 2822, 2823, 2824, 2825, 2826,
    2827, 2828, 10437, 10438, 2829, 2830, 10447, 2855, 2856, 2857, 2858, 2859,
    2860, 2861, 10448, 10449, 2862, 10546, 2863, 10547, 2864, 2865, 2893, 2894,
    2895, 2896, 2897, 2898, 2899, 2900, 2901, 2902, 2903, 2904, 2905, 2906,
    2907, 2914, 2940, 10566, 2941, 2942, 2943, 2944, 2945, 2946, 10567, 10568,
    2947, 2948, 10569, 2949, 10570, 10571, 2968, 2969, 2970, 2971, 10586,
    10587, 2972, 10588, 10589, 10590, 10591, 2973, 2974, 2975, 2976, 2977,
    3006, 3007, 3008, 3009, 3010, 3011, 3012, 3013, 3014, 3015, 3016, 3017,
    3018, 3019, 3020, 3021, 3044, 3045, 3046, 10606, 10607, 10608, 3047, 3048,
    10609, 3049, 3050, 3051, 10610, 3052, 3053, 3054, 3084, 3085, 3086, 10620,
    10621, 10622, 3087, 10623, 3088, 3089, 3090, 3091, 10624, 3092, 3093, 3094,
    10629, 3129, 10630, 3130, 3131, 3132, 3133, 3134, 10631, 10632, 3135,
    10633, 3136, 10634, 3137, 3138, 3167, 3168, 3169, 3170, 3171, 3172, 3173,
    3174, 3175, 3176, 3177, 3178, 3179, 3180, 3181, 3182, 3210, 10740, 3211,
    3212, 3213, 3214, 3215, 3216, 10741, 3217, 3218, 3219, 10742, 3220, 3221,
    3222, 3244, 3245, 3246, 3247, 10754, 10755, 3248, 10756, 3249, 10757, 3250,
    3251, 3252, 10758, 3253, 10759, 3286, 3287, 3294, 3295, 3296, 3297, 3298,
    3299, 3300, 3301, 3302, 3303, 3304, 3305, 3306, 3307, 3337, 3338, 3339,
    3340, 10769, 3341, 3342, 3343, 10770, 3344, 3345, 3346, 10771, 3347, 3348,
    3349, 10777, 3377, 3378, 10778, 3379, 3380, 3381, 3382, 3383, 3384, 3385,
    3386, 3387, 3388, 3389, 3390, 10783, 3419, 10784, 3420, 3421, 3422, 3423,
    3424, 10785, 10786, 3425, 10787, 10788, 10789, 3426, 10790, 10807, 10808,
    3443, 3444, 10809, 3445, 3452, 3453, 10810, 3454, 3455, 3456, 3457, 3458,
    3459, 3460, 3489, 3490, 3491, 3492, 3493, 3494, 3495, 3496, 3497, 3498,
    3499, 3500, 3501, 3502, 3503, 3504, 3531, 3532, 3533, 3534, 10827, 10828,
    3535, 10829, 3536, 10926, 10927, 3537, 3538, 3539, 3540, 3541, 10940, 3562,
    3563, 3564, 10941, 3565, 3566, 3567, 3568, 3569, 3570, 3571, 3572, 10942,
    3573, 10943, 3601, 3602, 3603, 3604, 10949, 10950, 10951, 3605, 10952,
    3606, 3607, 3608, 10953, 3609, 3610, 3611, 3644, 3645, 3646, 3647, 10960,
    3648, 3649, 3650, 3651, 3652, 3653, 3654, 10961, 3655, 3656, 3657, 10966,
    3692, 3693, 3694, 3695, 3696, 3697, 3698, 10967, 10968, 3699, 3700, 3701,
    3702, 3703, 3704, 10971, 10972, 3735, 3736, 10973, 3737, 3738, 10974,
    10975, 10976, 10977, 3739, 3740, 3741, 3742, 3743, 10986, 3768, 3769, 3770,
    3771, 3772, 3773, 3774, 10987, 3775, 3776, 3777, 3778, 3779, 3780, 3781,
    3810, 3811, 3812, 3813, 3814, 3815, 3816, 3817, 3818, 10992, 3819, 3820,
    3821, 3822, 3823, 3824, 11001, 3855, 3856, 3857, 11002, 3864, 3865, 3866,
    3867, 3868, 3869, 3870, 11003, 11004, 3871, 11005, 3904, 3905, 3906, 3907,
    11006, 11007, 3908, 3909, 11008, 3910, 3911, 3912, 11009, 3913, 11010,
    3914, 11118, 11119, 3936, 11120, 11121, 11122, 3937, 3938, 3939, 3940,
    3941, 11123, 11124, 11125, 3942, 3943, 3967, 3968, 3969, 3970, 3971, 3972,
    3973, 3974, 11135, 3975, 3976, 3977, 3978, 3979, 3980, 3981, 11136, 11137,
    4014, 4015, 11138, 4022, 4023, 11139, 11140, 4024, 4025, 4026, 4027, 4028,
    4029, 4030, 4064, 11146, 4065, 4066, 4067, 4068, 4069, 4070, 11147, 11148,
    4071, 4072, 4073, 4074, 4075, 4076, 4104, 4105, 4106, 4107, 4108, 4109,
    4110, 4111, 4112, 4113, 4114, 4115, 4116, 4117, 4118, 4119, 4145, 4146,
    4147, 4148, 4149, 4150, 4151, 4152, 4153, 4154, 4155, 4156, 4157, 4158,
    4159, 4160, 4193, 4194, 4195, 4196, 11161, 4197, 4198, 4199, 4200, 4201,
    4202, 4203, 4204, 4205, 4212, 4213, 4251, 4252, 4253, 4254, 4255, 11163,
    4256, 4257, 4258, 4259, 4260, 4261, 11164, 11165, 4262, 4263, 4291, 4292,
    4293, 4294, 4295, 4296, 4297, 4298, 4299, 4300, 4301, 4302, 4303, 4304,
    4305, 4306, 4339, 4340, 4341, 4342, 4343, 4344, 4345, 4346, 4347, 4348,
    4349, 4350, 4351, 4352, 4353, 4354, 4386, 11172, 4387, 4388, 4389, 4390,
    4391, 4392, 11173, 4393, 4394, 4395, 11174, 4402, 4403, 4404, 4440, 4441,
    4442, 4443, 4444, 4445, 4446, 4447, 4448, 4449, 4450, 4451, 4452, 4453,
    4454, 4455, 11189, 4477, 4478, 11190, 11191, 11192, 11193, 4479, 4480,
    4481, 4482, 4483, 11194, 11195, 4484, 11196, 4505, 4506, 4507, 4508, 11209,
    11306, 4509, 4510, 11307, 4511, 4512, 4513, 11308, 4514, 4515, 4516, 11316,
    4542, 4543, 4544, 4545, 11317, 4546, 4547, 4548, 4549, 4550, 4551, 11318,
    11319, 11320, 11321, 11336, 4570, 4571, 4572, 4573, 4574, 4575, 4576,
    11337, 11338, 4577, 11339, 11340, 11341, 4578, 4579, 11351, 4609, 4610,
    4611, 11352, 4612, 4613, 4614, 11353, 4615, 4616, 4617, 4624, 4625, 4626,
    4627, 4650, 11364, 4651, 4652, 4653, 11365, 4654, 4655, 11366, 11367, 4656,
    4657, 11368, 4658, 4659, 4660, 4688, 4689, 4690, 4691, 11374, 4692, 4693,
    11375, 11376, 4694, 4695, 4696, 4697, 4698, 4699, 4700, 11385, 4725, 4726,
    4727, 11386, 4728, 4729, 4730, 4731, 4732, 4733, 4734, 11387, 11388, 4735,
    11389, 4757, 11497, 11498, 4758, 11499, 4759, 4760, 4761, 4762, 4763, 4764,
    4765, 4766, 4767, 4768, 4769, 11505, 4803, 4804, 4805, 4806, 11506, 4807,
    4814, 4815, 4816, 4817, 4818, 11507, 11508, 4819, 4820, 11517, 4845, 4846,
    4847, 4848, 4849, 4850, 4851, 11518, 4852, 4853, 11519, 4854, 11520, 4855,
    4856, 4880, 4881, 4882, 4883, 4884, 4885, 4886, 4887, 4888, 4889, 4890,
    4891, 4892, 4893, 4894, 4895, 4919, 11539, 4920, 4921, 4922, 4923, 11540,
    4924, 11541, 11542, 4925, 11543, 11544, 4926, 4927, 4928, 4951, 4952, 4953,
    4954, 11555, 11556, 4955, 4956, 11557, 11558, 4957, 4958, 4959, 4960, 4961,
    4962, 5006, 5007, 5008, 5009, 5010, 5011, 5012, 5013, 5014, 5015, 5016,
    5017, 5018, 5019, 5020, 5021, 5045, 5046, 5047, 5048, 11569, 5049, 5050,
    5051, 11570, 5052, 5053, 5054, 11571, 5055, 5056, 5057, 5090, 5091, 5092,
    5093, 5094, 5095, 5096, 5097, 5098, 5099, 5100, 5101, 5102, 5103, 5104,
    5105, 11577, 5133, 11578, 5134, 5135, 5136, 5137, 5138, 11579, 11580, 5139,
    5140, 5141, 11581, 5142, 5143, 11586, 5178, 5179, 5180, 5181, 5182, 5183,
    5184, 5185, 5186, 5187, 5194, 5195, 5196, 5197, 5198, 5225, 5226, 5227,
    5228, 5229, 5230, 5231, 5232, 11689, 5233, 5234, 5235, 5236, 5237, 5238,
    5239, 5268, 5269, 5270, 5271, 11694, 11695, 5272, 5273, 5274, 11696, 5275,
    5276, 5277, 5278, 5279, 5280, 5310, 5311, 5312, 5313, 5314, 5315, 5316,
    5317, 5318, 5319, 5320, 5321, 5322, 5323, 5324, 5325, 5362, 5363, 5364,
    5365, 5366, 5367, 5368, 5369, 5370, 5371, 5372, 5373, 5374, 5375, 5376,
    5377, 11709, 11710, 5409, 5410, 5411, 5412, 5413, 5414, 5415, 5416, 5417,
    5418, 11711, 5419, 5420, 5421, 11718, 5448, 5449, 5450, 5451, 5452, 5453,
    5454, 11719, 11720, 5455, 11721, 5456, 11722, 5457, 5458, 11739, 11740,
    5475, 5476, 11741, 5477, 5478, 5479, 11742, 5480, 5481, 5482, 5483, 5484,
    5485, 5486, 5506, 11756, 5507, 5508, 5509, 11757, 5510, 11758, 11759, 5511,
    5512, 5513, 11760, 5514, 5515, 5516, 5545, 5546, 5547, 5548, 11771, 11772,
    11773, 11774, 11775, 11776, 11777, 5549, 11778, 5550, 11779, 5551, 11887,
    5579, 5580, 5581, 11888, 5582, 11889, 11890, 5583, 5584, 5585, 5586, 11891,
    11892, 11893, 11894, 5607, 5608, 5609, 5610, 11907, 11908, 5611, 5612,
    11909, 5613, 5614, 5615, 11910, 11911, 11912, 5616, 11924, 11925, 5638,
    11926, 11927, 11928, 5639, 5640, 5641, 5642, 5643, 5644, 11929, 11930,
    5645, 5646, 11938, 5672, 5673, 5674, 5675, 5676, 5677, 5678, 11939, 11940,
    5679, 11941, 5680, 11942, 5681, 5682, 11951, 11952, 5707, 5708, 11953,
    5709, 5710, 5711, 11954, 11955, 11956, 5712, 5713, 5714, 5715, 5716, 11967,
    11968, 5745, 5746, 5747, 5748, 5749, 5750, 11969, 12066, 5751, 5752, 12067,
    5753, 5754, 5755, 5786, 5787, 5788, 5789, 12076, 12077, 5790, 12078, 5791,
    12079, 5792, 5793, 5794, 5795, 5796, 5797, 12091, 5819, 5820, 5821, 12092,
    5822, 5823, 5824, 5825, 5826, 12093, 5827, 12094, 12095, 5828, 12096, 5849,
    5850, 5851, 5852, 12109, 12110, 5853, 5854, 12111, 5855, 5856, 5857, 12112,
    12113, 12114, 5858, 12130, 12131, 5876, 12132, 12133, 12134, 12135, 5877,
    5878, 5879, 5880, 5881, 12136, 12137, 5882, 5883, 12149, 5905, 5906, 5907,
    5908, 5909, 5910, 5911, 12150, 5912, 5913, 5914, 5915, 12151, 5922, 5923,
    12155, 12156, 5959, 5960, 12157, 5961, 5962, 5963, 12158, 5964, 12159,
    5965, 5966, 5967, 5968, 5969, 5990, 12268, 5991, 5992, 5993, 5994, 5995,
    5996, 12269, 5997, 5998, 5999, 12270, 6000, 6001, 6002, 6029, 6030, 6031,
    6032, 6033, 6034, 6035, 6036, 6037, 6038, 6039, 6040, 6041, 6042, 6043,
    6044, 6063, 6064, 6065, 6066, 12291, 6067, 6068, 6069, 6070, 6071, 6072,
    6073, 6074, 12292, 6075, 12293, 6104, 6105, 6112, 6113, 12298, 6114, 6115,
    6116, 12299, 6117, 6118, 6119, 12300, 6120, 6121, 6122, 6154, 6155, 6156,
    6157, 6158, 12308, 6159, 6160, 6161, 6162, 6163, 6164, 12309, 12310, 6165,
    6166, 6284, 6285, 6286, 6287, 6288, 6289, 6290, 6291, 6292, 6293, 6294,
    6295, 12320, 6302, 6303, 6304, 12322, 12323, 6342, 6343, 12324, 6344, 6345,
    6346, 12325, 6347, 6348, 6349, 6350, 6351, 6352, 6353, 6473, 6474, 6475,
    6476, 6477, 6478, 6479, 6480, 12333, 12334, 6481, 6482, 12335, 6483, 6484,
    6485, 6525, 6526, 6527, 6528, 6529, 6530, 6531, 6532, 6533, 6534, 6535,
    6536, 6537, 6538, 6539, 6540, 12452, 6652, 12453, 6653, 12454, 6654, 6655,
    12455, 6656, 6657, 6658, 6659, 12456, 12457, 6660, 12458, 6688, 6689, 6690,
    6691, 12470, 6692, 6693, 6694, 12471, 6695, 6696, 6697, 6698, 6699, 6700,
    6701, 6739, 6740, 6741, 6742, 6743, 6744, 6745, 6840, 6841, 6842, 6843,
    6844, 12473, 12474, 6845, 6846, 6877, 6878, 6879, 6880, 6881, 6882, 6883,
    6884, 6885, 6886, 6887, 6888, 6889, 12483, 6890, 6891, 6928, 6929, 6930,
    6931, 6932, 6933, 6934, 6935, 7030, 7031, 7032, 7033, 7034, 7035, 7036,
    7037, 7069, 12493, 7070, 12494, 7071, 7072, 7073, 7074, 12495, 12496, 7075,
    7076, 7077, 7078, 7079, 7080, 7116, 7117, 7118, 7119, 7120, 7121, 7122,
    7123, 12500, 7124, 7125, 7220, 7221, 7222, 7223, 7224, 7258, 7259, 7260,
    7261, 7262, 7263, 7264, 7265, 7266, 7267, 7268, 7269, 7270, 7271, 7272,
    7273, 7304, 7305, 7306, 7307, 12514, 7308, 7309, 7310, 7311, 7312, 7313,
    7314, 7315, 7410, 7411, 7412, 7449, 7450, 7451, 7452, 7453, 7454, 7455,
    7456, 7457, 7458, 7459, 7460, 12517, 7461, 7462, 7463, 7501, 7502, 7503,
    7504, 7505, 7600, 7601, 7602, 7603, 7604, 7605, 7606, 7607, 7608, 7609,
    7610, 7645, 7646, 7647, 7648, 7649, 7650, 7651, 7652, 7653, 7654, 7655,
    7656, 7657, 7664, 7665, 7666, 7693, 12529, 12530, 7694, 7695, 7790, 7791,
    12531, 12532, 12533, 7792, 7793, 12534, 7794, 12535, 7795, 7823, 7824,
    7825, 7826, 12643, 12644, 7827, 12645, 12646, 12647, 7828, 7829, 7830,
    7831, 7832, 7833, 7866, 7867, 7868, 7869, 7870, 7871, 7872, 7873, 7874,
    7875, 7876, 7877, 7878, 7879, 7880, 7881, 7999, 8000, 8001, 8002, 12663,
    12664, 8003, 8004, 12665, 8005, 8012, 8013, 12666, 8014, 8015, 8016, 8049,
    8050, 8051, 8052, 12673, 8053, 8054, 8055, 8056, 8057, 8058, 8059, 12674,
    8060, 8061, 8062, 12680, 8184, 8185, 8186, 8187, 8188, 8189, 8190, 12681,
    12682, 8191, 12683, 8192, 12684, 8193, 8194, 8235, 8236, 8237, 8238, 8239,
    8240, 8241, 8242, 8243, 8244, 8245, 8246, 8247, 8248, 8249, 8250, 8371,
    12695, 8372, 8373, 8374, 8375, 8376, 8377, 12696, 8378, 8379, 8380, 8381,
    8382, 8383, 8384, 8424, 8425, 8426, 8427, 12702, 12703, 8428, 12704, 8429,
    12705, 8430, 8431, 8432, 8433, 8434, 8435, 12709, 8559, 8560, 8561, 8562,
    8563, 8564, 8565, 8566, 8567, 8568, 8569, 8570, 8571, 8572, 8573, 8605,
    8606, 8607, 8614, 12717, 8615, 8616, 8617, 12718, 8618, 8619, 8620, 12719,
    8621, 8622, 8623, 12726, 12727, 8744, 12728, 8745, 12729, 8746, 8747, 8748,
    8749, 8750, 8751, 8752, 8753, 8754, 8755, 12830, 12831, 8790, 8791, 8792,
    8793, 8794, 8795, 12832, 12833, 8796, 12834, 8797, 12835, 8804, 8805,
    12844, 12845, 8830, 8831, 12846, 8832, 8833, 8834, 12847, 8835, 8930, 8931,
    8932, 8933, 8934, 8935, 8967, 12855, 8968, 8969, 8970, 8971, 8972, 8973,
    8974, 8975, 8976, 8977, 8978, 8979, 8980, 8981, 9015, 9016, 9017, 9018,
    12861, 12862, 9019, 12863, 12864, 12865, 9020, 9021, 9022, 9023, 9024,
    9025, 12875, 9143, 9144, 9145, 12876, 9152, 9153, 9154, 9155, 9156, 9157,
    9158, 12877, 12878, 9159, 12879, 9195, 9196, 9197, 9198, 12883, 12884,
    9199, 9200, 12885, 9201, 9202, 9203, 12886, 9204, 9205, 9206, 12895, 9325,
    9326, 9327, 9328, 12896, 9329, 9330, 9331, 9332, 9333, 9334, 12897, 9335,
    9342, 9343, 12900, 9380, 9381, 9382, 9383, 9384, 9385, 9386, 9387, 9388,
    9389, 9390, 9391, 9392, 9393, 9394, 12902, 12903, 9520, 9521, 12904, 9522,
    9523, 9524, 12905, 9525, 9532, 9533, 9534, 9535, 9536, 9537, 9569, 12913,
    9570, 9571, 9572, 9573, 9574, 9575, 12914, 9576, 9577, 9578, 9579, 9580,
    9581, 9582, 9704, 9705, 9706, 9707, 13016, 13017, 9708, 13018, 9709, 13019,
    9710, 9711, 9712, 9713, 9714, 9715, 13026, 9754, 9755, 9756, 13027, 9757,
    9758, 9759, 9760, 9761, 9762, 9763, 13028, 13029, 9764, 9765, 9891, 9892,
    9893, 9894, 13031, 13032, 9895, 9896, 13033, 9897, 9898, 9899, 13034, 9900,
    9901, 9902, 13044, 13045, 9932, 13046, 13047, 13048, 9933, 9934, 9935,
    9936, 9937, 9944, 13049, 13050, 9945, 9946, 9971, 9972, 9973, 9974, 9975,
    10070, 10071, 10072, 10073, 10074, 10075, 10076, 10077, 13059, 10078,
    10079, 13060, 13061, 10118, 10119, 13062, 10120, 10121, 10122, 13063,
    10123, 13064, 10124, 10125, 10126, 10127, 10134, 10155, 13077, 10156,
    10157, 10158, 10159, 10160, 10161, 13078, 10162, 10163, 10164, 13079,
    10165, 10260, 10261, 10297, 10298, 10299, 10300, 10301, 10302, 10303,
    10304, 10305, 10306, 10307, 10308, 10309, 10310, 10311, 10312, 13093,
    10341, 10342, 10343, 10344, 10345, 10346, 10347, 10348, 10349, 10350,
    10351, 10352, 10353, 10354, 10355, 10487, 10488, 10489, 10490, 13095,
    10491, 10492, 10493, 13096, 10494, 10495, 10496, 10497, 10498, 10499,
    10500, 10536, 10537, 10538, 10539, 10540, 10541, 10542, 10543, 10544,
    10545, 10640, 10641, 13100, 13101, 10642, 10643, 10675, 10676, 10677,
    10678, 10679, 10680, 10681, 10682, 10683, 10684, 10685, 10686, 13109,
    10687, 10688, 10689, 13207, 13208, 10727, 10728, 13209, 10729, 10730,
    10731, 13210, 10732, 10733, 10734, 10735, 10830, 10831, 10832, 10864,
    13218, 10865, 10866, 10867, 10868, 10869, 10870, 13219, 13220, 10871,
    10872, 13221, 10873, 10874, 13222, 10905, 10906, 10907, 10908, 13231,
    13232, 10909, 10910, 10911, 10912, 10913, 10914, 10915, 10916, 10917,
    10918, 13244, 11034, 11035, 11036, 13245, 11037, 13246, 11038, 11039,
    11040, 11041, 11042, 13247, 13248, 11043, 13249, 11070, 11071, 11072,
    11073, 13262, 13263, 11074, 11075, 11076, 11077, 11084, 11085, 11086,
    11087, 11088, 11089, 11216, 11217, 11218, 11219, 11220, 11221, 11222,
    11223, 11224, 11225, 11226, 11227, 13264, 13265, 11228, 11229, 13276,
    11258, 11259, 11260, 11261, 11262, 11263, 11264, 13277, 13278, 11265,
    13279, 11266, 13280, 11267, 11274, 13288, 11300, 11301, 11302, 11303,
    11304, 11305, 11400, 13289, 11401, 11402, 11403, 11404, 11405, 11406,
    11407, 11437, 13299, 11438, 11439, 11440, 11441, 11442, 11443, 13396,
    11444, 11445, 11446, 11447, 11448, 11449, 11450, 11488, 11489, 11490,
    11491, 11492, 11493, 11494, 11495, 11590, 11591, 11592, 11593, 11594,
    11595, 11596, 11597, 13401, 11633, 11634, 11635, 13402, 11636, 11637,
    11638, 11639, 11640, 11641, 11642, 11643, 13403, 11644, 13404, 11673,
    11674, 11675, 11676, 13415, 11677, 11678, 11679, 11680, 11681, 11682,
    11683, 11684, 11685, 11780, 11781, 11819, 11820, 11821, 11822, 11823,
    11824, 11825, 11826, 11827, 11828, 11829, 11830, 13417, 11831, 11832,
    11833, 13424, 11866, 11867, 11868, 11869, 11870, 11871, 11872, 13425,
    11873, 11874, 13426, 11875, 13427, 11970, 11971, 12004, 12005, 12006,
    12007, 12008, 12009, 12010, 12011, 12012, 12013, 12014, 12015, 12016,
    12017, 12018, 12019, 12051, 13441, 12052, 12053, 12054, 12055, 12056,
    12057, 13442, 13443, 12058, 12059, 13444, 12060, 12061, 12062, 12179,
    12180, 12181, 12182, 13455, 13456, 12183, 13457, 13458, 13459, 12184,
    12185, 12192, 12193, 12194, 12195, 12232, 12233, 12234, 12235, 12236,
    12237, 12238, 12239, 12240, 12241, 12242, 12243, 12244, 12245, 12246,
    12247, 12365, 12366, 12367, 12368, 13471, 13472, 12369, 12370, 13473,
    12371, 12372, 12373, 13474, 12374, 12375, 12382, 13483, 13484, 12407,
    13485, 13486, 13487, 12414, 12415, 12416, 12417, 12418, 12419, 13488,
    12420, 12421, 12422, 13591, 12543, 12544, 12545, 12546, 13592, 12547,
    12548, 13593, 13594, 12549, 13595, 12550, 13596, 12551, 12552, 13604,
    13605, 12584, 12585, 13606, 12586, 12587, 12588, 12589, 12590, 12591,
    12592, 12593, 12594, 12595, 12596, 12627, 13615, 12628, 12629, 12630,
    12631, 12632, 12633, 13616, 12634, 12635, 12730, 13617, 12731, 12732,
    12733, 12765, 13625, 12766, 12767, 13626, 12768, 12769, 13627, 12770,
    13628, 12771, 12772, 12773, 12774, 12775, 12776, 13636, 12808, 12809,
    12810, 13637, 12811, 12812, 12813, 12814, 12815, 12816, 12817, 12818,
    12819, 12820, 12821, 12939, 12940, 12941, 12942, 13647, 13648, 12943,
    12944, 13649, 12945, 12952, 12953, 13650, 12954, 12955, 12956, 13661,
    13662, 12985, 13663, 12986, 13664, 12987, 12988, 12989, 13665, 12990,
    12991, 13666, 12992, 12993, 12994, 13675, 13113, 13114, 13115, 13116,
    13117, 13118, 13119, 13676, 13677, 13120, 13678, 13121, 13679, 13122,
    13123, 15356, 15357, 15358, 15359, 15361, 15362, 15363, 15364, 15365,
    15367, 15368, 15369, 15370, 15372, 15374, 15375, 15519, 15520, 15521,
    15523, 15524, 15525, 15526, 15527, 15528, 15530, 15531, 15532, 15533,
    15534, 15535, 15536, 15559, 15560, 15565, 15566, 15567, 15568, 15569,
    15570, 15572, 15573, 15935, 15957, 16060, 16066, 16069, 16269, 18412,
    18800, 18906, 18914, 19109, 19112, 19113, 19120, 19122, 19123, 19131,
    19141, 19143, 19145, 19149, 19185, 19324, 19327, 19335, 19339, 19342,
    19345, 19348, 19350, 19353, 19354, 19355, 19357, 19359, 19360, 19361,
    19364, 19514, 19518, 19520, 19522, 19523, 19526, 19538, 19543, 19545,
    19562, 19736, 19737, 19745, 19746, 19752, 19754, 20261, 20262, 20264,
    20268, 20269, 20273, 20274, 20279, 20282, 20283, 20284, 20285, 20291,
    20431, 20432, 20435, 20490, 20493, 20496, 20497, 20512, 20513, 20515,
    20616, 20617, 20618, 20693, 20864, 21594, 21655, 21772, 21952, 6571, 6572,
    6573, 6574, 6575, 6576, 6577, 6578, 6579, 6580, 6581, 6582, 6583, 6584,
    6585, 6586, 6603, 6604, 6605, 6606, 6607, 6608, 6609, 6610, 6611, 6612,
    6613, 6614, 6187, 6616, 6617, 6618, 6218, 6219, 6269, 6649, X, 6220, 6615,
    X, X, X, X, X, X, X, X, X, 21250, X, X, X, X, X, X, 22146, X, X, X, X,
    22988, X, 14025, X, X, 21276, 23150, 21243, 14416, 17089, X, X, X, X, X, X,
    X, X, X, 21831, X, X, X, X, 17766, X, 14027, 18023, X, X, X, 19378, X,
    22147, X, X, X, X, X, 18990, X, 20455, X, X, X, 19115, 14575, 20845, X, X,
    X, X, X, X, X, X, 16500, 23170, X, X, 16096, 22717, X, X, 17461, X, X, X,
    X, X, X, X, X, X, 19667, X, X, X, 17238, 17026, X, X, X, X, X, 21405, X, X,
    15687, X, X, 18179, X, 14033, X, 19498, X, 20138, X, 16876, X, 17025,
    20815, 23348, X, 19154, 22792, X, X, X, 22377, X, X, X, X, X, X, X, X,
    16444, 23721, 21768, X, 23714, X, X, X, X, X, X, X, X, X, X, X, X, 17464,
    X, 16250, X, 23687, X, X, X, X, X, X, 20248, X, X, X, X, 16065, X, X,
    23173, X, X, X, X, X, X, 17595, 18926, 16641, X, X, X, X, 16328, X, X, X,
    X, X, X, 17599, 14952, 18018, X, X, 22014, 16659, 17433, 14423, X, X, X, X,
    X, 16119, 22367, 23697, 16679, 21992, 22575, 18409, 14758, 15882, X, 23672,
    19314, X, 23288, X, X, 22776, X, 18381, X, 22581, 19868, 16693, 23104,
    18562, 23494, X, X, 20461, 16642, X, 17396, X, X, X, X, 16059, 14347,
    22609, 17983, X, X, X, X, 20280, X, X, X, X, X, X, 15128, X, 15942, 18561,
    X, X, X, X, 19926, X, X, 20255, 20046, X, 22733, 14731, X, 20875, X, 18196,
    X, X, X, X, 14730, X, X, X, X, X, X, 16301, 21963, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 23353, 21239, X, X, X, X, X, X, X, X, X, X, X, X, X,
    21275, X, 18021, 19534, X, X, X, X, X, X, 19682, X, 23479, X, X, X, X,
    17066, X, X, 17030, X, X, X, X, X, X, X, 20326, 22938, X, X, X, 14238,
    21950, X, X, X, X, X, 23125, 16300, X, 19924, 23335, 14037, X, 22775,
    17431, X, X, X, X, 20105, 17245, X, X, X, X, X, X, 18048, X, 22964, X,
    18187, X, X, 21658, 15691, X, 20818, X, 23152, X, X, X, X, X, X, X, 17463,
    X, X, 22209, 19349, 15564, X, X, X, 18602, X, X, 17838, 14785, 21586,
    15173, 17624, X, X, X, X, 22972, X, X, X, X, X, X, X, X, 21649, X, X,
    22224, X, X, X, X, X, X, 23100, X, 20327, X, X, 18219, X, 15713, X, 17265,
    X, X, X, X, X, 22150, X, X, X, X, 14805, X, 17223, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 14038, X, 21844, X, 20703, X, 22174, X, X, X, X, X, X,
    18377, 20302, X, 21627, 18399, X, 16827, X, 22210, X, 18167, X, X, 19895,
    X, 14202, X, 18756, X, X, 22773, X, X, X, X, X, 21465, X, X, 19117, 21834,
    X, X, 23333, 18554, X, X, X, 18755, X, X, X, X, 16868, X, X, 17965, X, X,
    X, 19949, X, X, X, X, X, 23297, X, X, X, X, X, X, 14415, X, X, 21426,
    22206, X, X, X, X, 14023, 23747, X, X, X, X, 18345, X, X, 14022, X, X,
    21074, X, 22145, X, X, 19916, 17240, X, X, 17621, X, 19510, X, 20469, X, X,
    X, X, X, 21232, 21785, 18537, X, X, X, X, X, 22158, 18225, X, 19365, X, X,
    X, X, X, X, X, 23743, 23744, X, X, X, 22356, X, 19482, X, 19340, X, X, X,
    X, 15948, 15906, X, X, X, X, 16335, X, 16847, 16324, X, X, X, X, 16859, X,
    17015, X, X, X, X, X, X, 15682, 23293, X, 23691, X, 20438, X, X, X, X,
    19909, X, X, X, 17206, X, X, X, X, X, X, X, X, 15733, X, X, X, X, X, X, X,
    20847, X, X, X, 14036, X, X, X, X, 21595, 22326, X, 20278, 21467, X, 21794,
    X, X, 18220, X, X, 16144, X, X, X, X, X, X, X, X, X, X, X, X, X, 22749, X,
    20102, 23680, X, X, X, X, X, X, X, X, X, 21202, X, X, X, X, X, 15959, X, X,
    15323, X, 19142, X, 14177, X, 17029, X, 19691, X, X, X, 18754, X, X, X, X,
    20470, X, 20471, X, 16276, X, 14786, 20267, X, 23657, X, X, X, X, X, 22748,
    X, X, X, X, X, 14021, X, X, X, X, X, 17087, X, X, X, X, 20454, 18585,
    17840, 21245, X, 20266, X, 16481, 15326, X, X, X, 18792, X, 19699, X,
    20700, 16527, X, 20642, X, X, 22336, X, X, 18722, X, 18009, 23727, X, X, X,
    X, X, X, X, X, X, 20870, 18347, X, X, 18790, X, 20844, X, X, X, 18376,
    14055, X, X, X, X, X, 14197, X, X, X, X, X, 19310, X, X, X, X, 22388, X,
    21623, 18980, X, 21646, X, X, X, X, X, X, 22565, X, X, X, X, X, X, X, X,
    14017, 21196, X, X, X, X, X, 20306, X, X, X, 19127, 23486, X, X, X, X,
    19566, 23488, 23533, 23312, 18786, 16650, X, 22413, X, X, 17422, 14401,
    23507, X, X, X, 21820, X, X, 14191, X, X, X, X, 18784, X, 14192, 20065,
    20810, X, X, 23095, 19320, 18353, 13976, X, 18783, 19882, X, X, X, X, X,
    18579, 20831, X, X, X, X, X, 22756, X, X, X, X, X, 23365, X, 14919, X,
    14390, X, 17095, X, 22372, X, 19879, X, 16710, X, X, X, 14391, X, X, 16124,
    X, X, X, X, X, 21043, X, 14552, X, X, X, X, X, X, 18981, X, 18974, X, X, X,
    X, X, X, X, 16826, X, X, X, X, X, X, X, X, 15893, X, 23539, X, X, X, X, X,
    19363, X, 14405, 18363, 18224, X, X, 19886, 23558, 19331, X, 18907, X,
    18597, X, 19333, X, 23347, 22017, 19179, 21973, 21998, X, X, X, X, 23677,
    X, X, X, X, 19169, X, X, 21439, X, X, X, 19708, X, X, 22766, X, X, 23314,
    16095, X, 16498, X, 17584, X, 15706, X, X, X, X, X, X, 21063, X, 16472,
    20301, X, X, 23536, X, 23498, X, 20816, 15870, X, X, X, X, X, X, X, X, X,
    X, X, 22600, X, 14224, X, X, 19925, X, X, 18801, X, X, X, X, X, X, X, X,
    19517, X, 23500, X, X, X, X, 15936, X, 15329, X, 22900, X, 19718, X, X, X,
    23101, X, X, X, X, X, X, X, X, X, X, X, X, 21384, X, X, X, 21606, 16080, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 22925, 21026, X, X, X, X, X,
    14772, X, 18202, X, X, X, X, X, X, 16869, 18975, X, 21449, X, X, X, 14231,
    14187, X, X, X, 20507, X, X, X, X, 21947, X, 21430, X, X, 16111, X, 21214,
    16483, 15913, X, X, 18919, X, X, X, X, X, X, X, X, X, 15928, X, X, X,
    19166, X, X, X, 13968, 14352, 20086, X, X, X, X, X, 22727, 7728, 7729,
    7730, 7731, 7732, 7733, 7734, 7735, 7736, 7737, 7738, 7739, 6428, X, X, X,
    7592, 7593, X, X, X, X, X, X, 7596, 7597, 7598, 7599, X, 6434, 6431, X, X,
    X, 7372, X, X, X, X, 6217, X, X, X, X, 7766, 7767, 7768, 7769, 7770, 7771,
    7772, 7773, 7774, 7775, 7776, 7777, 6983, 6984, X, 6985, 6986, 6987, 6988,
    6989, 6990, 6991, X, X, X, X, X, X, X, 20848, X, X, 16519, 21246, X, X, X,
    14736, 23161, X, X, X, X, X, 21450, X, X, X, X, X, 23113, 19351, X, X,
    23154, 18615, X, X, X, 13987, X, 18928, X, 20104, X, 22225, X, X, 15693, X,
    X, X, 18557, 21628, X, X, X, X, X, X, 14604, X, 14180, X, X, 20704, X, X,
    X, X, X, X, 18209, X, X, X, X, 20874, X, 17850, X, X, X, X, 23136, X, X, X,
    X, 23550, X, X, X, X, X, X, X, X, X, X, X, 23363, X, X, X, X, 14968, 16718,
    X, X, X, X, X, 16636, X, X, 23698, X, 15334, 19869, X, 19694, X, X, 23121,
    X, X, X, X, X, X, X, X, 22213, X, X, 13992, X, X, 18775, X, 23696, X, X, X,
    X, 18911, 22899, 21204, X, 19171, X, X, X, 15366, X, 16510, X, X, X, X, X,
    X, 17770, X, X, X, X, X, X, X, 17977, X, 23490, 20839, 14050, X, X, X,
    21064, 15918, 18000, X, 23489, 15343, X, X, X, X, X, X, X, X, X, X, X,
    22907, X, X, X, X, 18152, X, X, X, X, X, 22777, X, X, X, X, X, 19929,
    16479, X, X, X, 15748, 18566, X, 23524, 14548, X, 20880, X, X, X, X, X, X,
    X, X, X, X, X, X, 19898, X, 17198, X, X, 16287, 14212, X, X, X, X, X, X, X,
    X, X, X, 17592, X, 16640, 18718, X, X, 21790, X, X, X, X, X, X, X, X, X,
    18392, X, X, 21006, 18375, 17218, 18022, X, X, X, X, X, X, X, X, 20640,
    21412, X, 21802, 16446, 14769, 22207, 22568, X, 15720, X, 21849, X, X, X,
    X, X, X, X, X, X, 21624, 18997, X, X, X, X, X, 17398, X, X, X, X, X, X,
    18600, 16337, X, X, 16504, X, X, X, X, X, X, X, X, X, X, X, X, X, 22983, X,
    17237, 20895, 23739, X, X, 15742, X, 23309, X, X, X, X, X, X, X, 16127,
    17209, 15760, X, 16441, X, 22346, 16494, X, X, X, X, X, X, 18388, X, X,
    15939, 20480, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 20115, 20315,
    21429, X, X, 19161, X, 14389, X, X, 14246, X, X, X, X, X, X, X, 16901, X,
    X, X, X, X, X, X, X, 21592, X, 17769, X, 17049, X, X, X, 14622, 21247, X,
    X, X, X, 22366, X, X, X, X, X, X, 15731, X, X, X, X, X, X, X, 17623, 21242,
    15126, X, X, X, X, X, X, X, X, X, X, X, 18239, X, 18046, X, 18372, X, X, X,
    X, X, X, X, 18028, X, 20867, X, X, 22549, X, 14748, X, X, X, X, X, X, X, X,
    X, X, X, 21004, X, X, 17832, X, X, X, X, X, X, X, X, X, X, X, X, X, 21610,
    X, X, 18343, X, X, X, X, 16141, 15008, X, X, 17826, X, X, X, 16864, 14563,
    X, 21824, X, X, X, X, X, X, X, X, 20668, X, X, 16841, X, 22944, X, X,
    19912, X, X, X, X, X, 19723, 17040, 17041, 15902, X, 19565, 14615, X,
    22981, X, X, 18035, X, X, X, 19126, X, X, X, 14756, X, X, 15156, X, 15704,
    X, X, X, 17286, X, 14219, X, X, X, X, X, 16638, X, X, X, X, X, X, X, X, X,
    22351, 21381, 14208, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 17617, X,
    19163, 18036, X, X, 22580, X, 22982, 21020, X, X, 22761, X, X, X, X, 20066,
    X, 19105, 17981, X, X, X, X, X, X, X, X, 16903, 15899, X, X, X, X, 22394,
    X, 20091, X, 19728, X, X, X, X, X, X, X, X, X, X, X, X, 16482, 20309,
    23730, X, 16322, X, X, X, X, X, X, X, X, 19903, X, X, X, X, X, X, 22022, X,
    X, X, X, X, X, X, X, X, 23361, X, X, X, X, X, X, 22917, X, X, 15950, X,
    15146, 21002, 18601, X, 17269, 14593, X, X, X, X, X, 16862, X, X, 22361, X,
    X, X, 20866, 19511, X, 15910, X, X, 21779, X, X, X, 19856, X, X, X, X, X,
    X, X, 18619, X, 17633, X, X, X, X, X, X, 19102, 16105, X, X, X, X, X,
    16254, X, X, 20830, X, X, X, X, 16122, X, X, 15346, X, 19175, X, X, X,
    20881, X, X, 15678, 20828, 22752, X, X, X, X, 20085, 20829, 21387, 8123,
    8124, 8125, 8126, 8127, 8128, 8129, 8130, 8131, 8132, 8133, 8134, 8135,
    8136, 8137, 8138, 7566, 7567, 7568, 7569, 7570, 7571, 7572, 7573, 7574,
    7575, X, X, X, X, X, X, X, 14383, X, X, X, 19356, X, X, 20084, X, 20308, X,
    X, X, 19692, X, X, X, 16680, X, X, X, X, X, X, 21977, X, 23683, 17972,
    18794, X, X, X, X, 18148, 22160, X, 17465, 18796, X, X, X, X, 19670, X, X,
    X, X, X, X, X, 17652, X, 19724, X, 17214, X, X, X, 15382, 15197, X, X, X,
    22037, X, X, X, X, 14373, 22589, X, X, X, X, X, 15750, X, 19907, 18425,
    18949, X, 18403, 19704, X, X, 14784, 22742, X, X, X, X, X, 17475, X, X,
    17610, X, 22958, X, X, X, X, 22711, X, 17807, 21603, X, X, X, X, X, X,
    16493, X, 19528, 22166, 14917, 14550, 14918, X, X, X, 14551, 21469, 15108,
    18350, 22708, X, 13971, 17251, X, X, 13967, X, X, 15340, X, X, X, 20882, X,
    X, X, 20500, 17802, 8155, 8156, 8157, 8158, 8159, 8160, 8161, X, X, X, X,
    X, X, X, X, X, 13969, X, 17283, X, X, X, 17804, 7538, 7539, 7540, 7541,
    7542, 7543, 7544, 7545, 7546, 7547, 7548, 7549, X, X, X, 6427, 6222, X,
    6221, X, X, X, X, X, X, X, X, X, X, X, X, X, 19733, X, X, 23530, 20631,
    23704, 22352, X, X, 22942, 20293, 13998, X, 15509, 14616, X, 18766, 20832,
    14555, X, 18228, 20090, X, X, X, X, 20510, 19743, X, 14164, 21390, X, X,
    18743, 22759, X, X, 17273, X, X, X, X, X, 23736, X, X, X, 15504, 15516, X,
    X, X, 14009, X, X, X, X, 23306, X, X, 14011, 22738, 15505, X, X, 17405,
    23110, 14012, X, 23484, 20119, 20120, 15195, X, 15194, 20436, 17816, 22588,
    X, X, 22980, X, X, X, X, X, 18397, 14233, X, 18587, 18356, X, X, 14614,
    21382, 14794, 14216, X, X, 16882, X, X, 21767, X, 14598, X, X, 22178, X,
    18985, 14166, X, 16471, X, X, X, X, X, X, 15677, X, X, X, 20474, X, X, X,
    X, X, X, 14733, X, X, X, X, X, 21210, 18999, 18946, X, 19368, X, X, X, X,
    X, X, X, X, X, 19477, 18962, X, X, X, 14807, X, 16302, X, X, X, 20821, X,
    X, X, X, X, X, 14421, X, 18793, X, X, X, X, X, 19717, X, 20456, 23521, X,
    X, X, X, X, X, X, X, X, X, X, X, X, 22001, 16264, 17588, 20696, X, X,
    21441, X, 15924, X, X, X, X, 18546, X, X, 14035, X, 15689, 18544, 17836, X,
    X, X, X, X, X, X, 17413, 15507, 22188, X, X, X, X, 20325, X, 22965, X, X,
    X, X, X, X, X, 14026, 16117, 22173, X, 18337, 19893, X, X, X, 21602, X, X,
    X, X, X, 22018, 16321, 20286, 22028, 17046, X, 19347, X, X, X, X, 22731,
    19713, X, X, 16716, X, X, 20098, 14174, X, X, X, X, X, X, 16116, X, X, X,
    X, X, X, X, X, 20898, X, X, X, X, X, X, 18916, 20812, 22164, X, 22790, X,
    X, 20687, X, X, X, X, X, 15930, X, 15298, 18389, 18232, 18923, 14437, X, X,
    X, 23343, X, X, X, 21956, X, X, X, X, 15134, 14964, X, X, X, X, 14215,
    14435, X, 14976, X, X, 19674, X, 18742, 18741, X, 18203, X, X, X, 20892, X,
    X, X, X, X, 17404, X, X, X, X, 15188, 18155, 19731, X, X, 18577, 15578, X,
    19103, X, X, X, 14431, X, X, 15701, X, X, X, X, X, X, X, 18920, X, 14553,
    X, 17016, X, 13972, X, X, X, X, X, 18781, 23303, 16819, X, X, 18422, X, X,
    X, X, X, 15735, X, X, 23179, X, X, X, X, 14920, X, X, 17991, X, X, X, X, X,
    X, X, X, 21393, X, 21392, X, X, X, X, X, 6185, X, X, 6189, 6190, X, X,
    6191, 6192, X, X, X, 17468, 16831, X, 19358, X, X, X, X, X, X, X, X, X,
    22796, 18762, X, X, X, X, X, 18761, X, X, X, X, 15907, X, X, X, X, X,
    22152, X, X, X, X, 20083, X, X, X, X, X, 23658, X, 23344, 17966, X, X, X,
    X, X, X, X, 20276, X, 19709, X, X, X, 17788, X, X, 18024, X, X, X, X, X, X,
    22584, X, X, X, 14363, X, X, 23282, X, 19889, X, X, X, X, 23742, X, X, X,
    X, X, 18582, 19945, X, X, X, 23318, X, X, 14018, X, X, X, X, X, X, X, X,
    20860, X, X, X, X, X, X, X, 23684, X, 20116, 17990, 15345, 14791, X, 15679,
    X, 20057, X, X, X, 13973, X, X, 22035, X, X, X, X, 14589, 23551, X, 17643,
    21264, 22406, 23165, X, X, 15380, X, X, 17052, X, 17437, X, 17391, X,
    18215, X, X, X, X, X, X, X, 20620, 20887, X, X, X, X, 17474, 7367, 7368,
    7369, 7370, 7371, 7316, 7317, 7318, 7320, 7326, 7327, 7328, 7329, 7330,
    7331, 7332, 6176, 6177, 6178, 6183, X, X, X, X, 6195, 6196, 6197, 6198,
    6199, 6200, 6201, 6202, 6246, 6247, 6245, 6248, 6249, 6418, 6421, 6419,
    6422, 6420, X, X, X, X, X, X, X, 15953, X, X, X, X, X, 21082, X, X, 22153,
    X, X, X, X, X, X, 16829, 16067, X, 18563, X, X, X, 14951, X, X, X, X, X,
    15150, X, X, X, X, X, X, 18336, X, 17794, X, 22334, X, X, X, 17009, X,
    23330, X, X, 20277, 18146, X, X, X, X, X, X, X, X, X, X, 15115, X, X, X, X,
    X, 19734, X, X, X, 18235, 20841, 16877, X, X, X, X, 19676, 17831, X, X, X,
    X, X, X, X, X, X, X, 18753, X, X, X, 17833, X, 15875, X, 19139, X, X, X, X,
    X, 19919, X, X, X, 15161, 23467, 15895, 19690, X, 21001, X, X, X, X, X,
    14539, X, X, 15949, 17196, 17255, 17256, X, 21620, X, 14053, 17084, X, X,
    16297, X, X, X, X, X, X, 16860, X, 16825, X, X, X, X, X, X, X, X, X, X, X,
    X, 16655, X, 20639, X, X, X, 17217, X, X, X, X, 16325, 21770, X, X, 14540,
    X, 15160, X, X, X, X, X, X, X, X, X, X, X, 23466, 21073, 17441, 14568, X,
    X, 23326, X, X, X, X, X, X, X, X, X, X, X, X, 14030, X, 15909, X, X, 6225,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 21448, X, X, 6263, 6264, X, X, 6261,
    6262, X, X, X, X, X, X, X, X, X, 16514, X, X, X, X, X, X, 16251, 17415, X,
    17247, 16474, X, X, X, X, 21659, 22214, 14954, X, X, 15883, 14424, X,
    15937, X, 20852, 22570, X, X, 18151, 16278, 18395, 22553, 14955, X, X, X,
    18383, X, X, 20853, X, X, X, X, X, X, X, 23695, X, 16246, 23686, X, 23516,
    X, 20996, X, 21067, X, X, 18366, X, X, X, X, X, X, 23144, 14222, 22524, X,
    23281, 14221, 15869, X, 17829, 17098, 18943, 19695, X, X, X, X, 18207,
    22345, 20095, X, 22986, 14439, 14600, X, 18361, X, 17274, 17023, X, X, X,
    X, X, X, X, X, X, 21434, X, 23142, X, 21399, 23740, 18234, 22396, 15546, X,
    17999, X, X, 23506, X, X, 19104, 18231, 22344, X, X, X, X, 23531, X, 22712,
    X, X, X, 18404, 20894, X, X, X, 19561, 18782, X, X, X, X, 18921, X, X, X,
    16645, X, X, X, X, X, X, X, 18948, X, X, X, X, X, X, X, X, 22901, X, X, X,
    X, X, X, 17984, 23340, 23162, 21187, 14426, X, 23088, 18612, X, 18571, X,
    19940, X, 18410, X, X, X, 21261, X, X, X, X, X, X, X, X, X, X, X, X, 23313,
    14934, X, X, X, 22898, 18204, 22400, X, 14236, X, 16889, 22137, X, X, X,
    16484, X, 16843, X, 19133, X, X, X, X, X, X, X, X, X, X, X, X, 14745, X, X,
    X, 23357, X, 17281, X, 17828, X, X, X, 17277, X, X, X, X, 20862, X, X, X,
    23317, X, X, X, X, X, 14602, 16652, 15685, X, X, X, 14357, X, X, X, X,
    21059, X, X, X, 19164, 15158, X, 23487, 21578, 21060, 21769, 17423, 16890,
    X, X, X, 19729, X, X, X, X, X, 21050, X, 15900, X, X, X, X, X, X, X, X,
    15184, X, X, 23732, X, X, X, X, 22407, X, 17989, X, X, X, X, X, X, X, X,
    16908, 19685, 20270, X, 20055, 23177, 22221, 21213, 23707, 18172, 14760, X,
    15131, 22541, 16708, 22560, X, 14243, X, X, X, X, X, X, 17956, 17640, X, X,
    X, X, X, X, X, 18970, X, X, 23501, X, X, X, X, X, 23341, X, 14586, X, X, X,
    21016, X, X, X, 23158, 19547, 19720, 17093, 15908, X, X, X, 22601, 16282,
    X, X, X, X, X, X, X, 22159, X, X, X, 16850, 15177, X, X, X, 18165, X, X, X,
    X, X, X, X, X, X, X, X, X, 19101, X, X, X, X, 22602, 17397, X, X, X, 16490,
    17957, X, X, X, 14755, X, 17272, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    23107, X, 23178, X, X, X, X, X, 16255, X, X, X, X, X, 22033, X, X, 16834,
    X, X, 16709, X, 19878, X, X, X, X, X, X, X, X, X, 18933, X, X, X, X, X, X,
    21984, X, X, X, X, 20108, X, X, X, X, 20464, X, X, X, X, X, X, X, 17853,
    22778, 18777, X, 21983, X, X, X, X, X, X, X, X, 22706, X, X, X, 19719, X,
    18198, X, 21011, X, X, 18564, X, 16830, X, X, X, 22966, X, X, X, 22337, X,
    X, X, X, 22192, X, X, X, X, X, X, X, 20468, X, X, X, X, X, X, 16074, X,
    17785, X, X, X, X, X, X, X, X, X, X, X, X, 16130, X, 20899, X, 19569, X, X,
    X, X, X, 15709, X, X, X, X, 15697, X, 17982, X, X, 21760, X, X, X, 21990,
    X, X, X, X, 21406, 22722, X, 17099, X, X, 14375, X, X, 21657, 17080, X,
    18581, 20669, X, X, 16294, 18164, 21061, 21455, 14935, X, X, X, X, X, X, X,
    X, X, X, X, 17276, X, 22765, 22593, 20307, X, 15575, X, X, 21403, X, X,
    23143, X, X, 17079, 17043, 22739, X, X, 21577, X, X, 13978, 13979, 14929,
    X, X, X, X, X, 18749, X, 14797, 17254, X, X, X, X, X, X, X, 21402, X, X, X,
    X, 19936, 14014, X, X, X, 20126, X, 15111, X, X, X, X, X, X, X, X, 16873,
    17997, X, X, X, X, X, 15763, 21383, X, X, X, 14558, X, 21047, X, X, 23127,
    X, X, X, 19162, X, X, X, 15703, X, X, X, 14045, X, 22170, 19911, X, X, X,
    X, X, X, X, 17648, X, X, X, 21458, X, 23342, X, X, X, X, X, X, X, X, 23352,
    X, 18158, X, X, 20123, 17992, X, X, 19125, X, X, X, X, X, X, X, X, X, X, X,
    X, 21191, X, X, X, 21804, X, X, X, X, 19904, 21764, 15169, 19905, X, 17072,
    X, X, 20059, 20058, X, X, 15756, X, 15680, X, X, X, X, X, X, 22562, 23502,
    14189, X, X, X, X, 23708, X, 21985, 19739, 22218, X, X, 22957, X, X, 15176,
    X, X, 20518, X, 15499, 20884, 16110, 20113, 22707, 14610, 16466, 23292, X,
    14789, X, X, X, 17435, 23729, X, X, X, 16331, X, X, X, 20087, X, 21814, X,
    17202, 22348, X, 14985, 21267, 14213, X, 19525, 16470, 22405, 19727, X, X,
    16070, X, X, X, 16330, X, 19183, X, X, 17797, 20428, X, 19900, X, 18779, X,
    14006, 21638, X, 16101, X, 22347, X, 14759, 16284, X, 18735, X, 21388,
    6761, 6762, 6763, 6764, 6765, 6766, 6767, 6768, 6769, 6770, 6771, 6772,
    6773, 6774, 6775, 6776, 7148, 7168, 7169, 7143, 7134, 7155, 7170, 7171,
    7150, 7172, 7173, 7145, 7133, 7174, 7175, 7149, 6416, 6417, X, X, X, 6180,
    6181, X, X, X, X, X, X, X, X, X, 6398, X, X, X, X, X, X, X, 18610, X,
    22338, X, 22154, X, 21206, X, X, 18340, X, X, X, X, X, X, X, X, X, 22196,
    X, X, X, 20707, X, X, 18394, X, X, X, X, X, X, X, X, X, 16508, 20701, X, X,
    X, 17842, X, 18553, X, X, 23542, 20489, 15579, X, 19894, 19295, X, X, X, X,
    X, X, 19291, X, X, X, X, X, X, X, X, X, 18346, X, X, X, X, X, X, 23128, X,
    X, X, X, 19096, X, X, X, X, 16072, X, X, X, X, X, 14992, X, 20690, X, X, X,
    20814, 22353, X, X, 14404, X, X, X, X, X, 21226, X, 23557, 21783, X, 17055,
    X, X, X, X, X, X, X, X, 15696, X, X, X, X, 23685, X, X, 13977, 23682,
    23694, X, X, X, X, 19493, X, 17212, X, X, X, 16128, X, X, X, X, X, 18178,
    21054, X, X, 21258, 22544, 20439, X, X, X, 15170, X, 18230, 20064, X,
    14779, X, X, X, X, 14350, 20890, X, 17811, X, X, X, X, 19558, X, X, 22527,
    20271, 20680, 18156, 17614, X, 14626, 22379, X, 19560, 19744, 18804, 15512,
    21838, 18806, X, 17813, 14741, X, 16332, 21432, 18983, 22896, X, X, 23354,
    X, X, X, 22970, 20808, X, X, X, X, X, X, X, 14185, X, 17399, X, X, X, X, X,
    X, 13993, X, X, X, 20877, 17067, X, 21652, X, X, 18944, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 22720, 21081, X, 19864, X, 15714, X, X, 17446, 22719,
    X, X, X, 14369, X, X, X, 15119, 20426, X, X, X, 14370, X, X, 23337, X, X,
    X, X, X, 19541, X, X, 20254, X, 21205, X, X, 14239, 15881, 21773, 23298, X,
    X, X, X, X, 14240, X, X, X, X, X, X, 22386, X, 21378, X, 14974, X, X, X, X,
    X, X, 17602, X, X, X, X, 14737, X, X, 15694, X, X, X, X, X, X, X, X, X, X,
    X, X, X, 19297, X, 14787, 22933, 23523, X, 15884, 15700, 20107, X, X, X,
    19866, X, X, 18400, 15722, 22031, X, 21251, X, X, X, X, X, 20851, X, X,
    21419, X, X, 19119, X, X, 21597, X, X, 21444, X, 21980, 18197, X, 20257, X,
    16436, 14227, X, 22908, 16512, 15344, X, X, X, X, X, 18417, 21084, X, X, X,
    17603, 22385, X, X, 17199, X, 14956, 18617, 21085, X, X, X, X, X, X, X, X,
    X, 22190, X, X, 16656, X, X, X, 14727, X, X, 21833, X, X, X, X, X, 21843,
    X, X, X, 22229, 15877, X, X, X, X, X, 16104, X, 16705, 22740, 20100, X,
    22019, X, X, X, 14750, X, X, X, 16310, 14965, X, 15127, X, X, X, 15934, X,
    X, X, 22930, X, X, X, 20871, X, X, X, X, 18011, X, X, X, 22161, X, X, X, X,
    X, X, X, 19887, X, X, X, 22186, X, X, 20485, 22538, 19707, X, X, X, X,
    20320, X, X, X, X, X, X, X, 18768, 22183, X, 16113, X, 16442, X, X, X,
    20837, X, 22791, X, X, X, X, 22185, 20688, 19492, X, X, X, X, 22215, X,
    16685, 20653, X, X, X, X, 18360, X, 18747, 21270, X, 17647, 15752, 22227,
    X, 17036, X, 14436, X, X, X, 15765, 21949, X, X, 14047, 17959, X, X, 15901,
    X, X, X, X, X, 14400, 19129, X, X, 18592, 20896, X, X, 18042, 16477, X, X,
    X, X, X, X, X, X, 19489, X, 16271, X, 18031, 18937, X, X, 15518, X, X, X,
    22760, X, X, X, X, X, 16272, 17819, X, X, 17236, X, X, X, 18995, X, 14977,
    X, X, 14773, X, X, X, X, 21989, 17097, X, X, X, X, X, 16887, X, 22590,
    22176, X, 22558, 17969, 19750, X, X, X, X, X, X, 15506, X, X, X, 15728, X,
    18941, X, X, X, X, X, X, X, X, X, X, X, 14354, 23693, X, 21570, X, X, X, X,
    X, 21571, X, 18951, X, X, X, X, X, X, 14010, X, 20434, X, 21640, X, 23734,
    X, 22978, X, 18355, X, X, X, X, 21996, X, X, 17993, X, X, X, X, X, X, 7509,
    7699, X, X, X, X, X, X, X, X, X, 22211, X, X, X, X, X, 20876, 21632, 19875,
    15545, X, X, X, X, X, X, X, X, X, X, X, X, X, 16076, X, X, 23286, X, X, X,
    X, X, X, X, X, X, X, X, X, X, 15325, X, X, 16628, X, X, 17062, X, 21241,
    21031, X, X, X, X, X, X, 18391, 16627, X, X, X, X, X, 17587, X, X, X, X, X,
    21200, 16274, X, X, 22971, X, X, X, 14199, X, X, X, X, 18237, 15873, X,
    20666, 16704, 16460, X, 19890, X, 19758, 19680, X, X, 21616, 23284, 16630,
    X, X, X, X, 16098, 18004, X, X, X, X, X, 20692, 22729, 22605, X, X, X,
    22716, X, X, X, 22947, 22557, X, X, 16285, X, X, X, X, X, X, 23537, 21784,
    18162, X, X, X, X, 17960, X, 22945, X, X, 19568, X, X, 19288, 23356, 14171,
    14244, 15917, X, 16875, X, 20835, X, 22592, X, X, X, 15563, X, X, 18405,
    22604, 18357, 22728, X, X, X, X, X, 18176, 23310, 17649, X, 18527, X,
    20811, X, X, 14562, X, 21053, 20861, X, 17582, 18531, X, X, X, X, X, 18177,
    X, 14928, X, X, X, X, 19564, 22713, X, X, X, X, X, X, 21821, X, 18959, X,
    X, 15142, 21959, X, 17583, X, X, X, 20652, 21809, X, X, 17822, 22222, X, X,
    X, X, X, X, X, X, X, X, 22390, X, X, X, X, 20683, X, X, 17646, X, X, 17996,
    X, X, X, X, 18032, 14393, X, X, X, X, 14921, X, X, X, X, X, X, 22408, X, X,
    X, 19554, X, X, X, X, 23724, 22328, X, 16907, 23664, X, 19553, X, 21190,
    14248, X, X, X, X, X, X, X, X, 16139, X, X, X, 14612, 7346, 7347, 7348,
    7349, 7350, 7351, 7352, 7353, 7354, 7355, 7361, 7362, 7363, 7364, 7365,
    7366, 7901, 7902, 7903, 7904, 7905, 7906, 7907, 7908, 7909, 7910, 7911,
    7912, 7913, 7914, 7915, 7916, 6223, X, X, X, X, 6186, X, 6267, 6268, 6266,
    6265, 6257, 6258, X, 6382, X, 6383, X, X, X, X, X, X, X, X, 6253, X, X,
    6255, 6211, X, 7886, 7887, 7888, 7889, 7890, 7891, 7892, 7893, 7894, 7895,
    7896, 7897, 7898, 7899, 7900, 6368, X, 6226, 6369, X, X, X, 6227, 6259, X,
    X, 6260, X, X, X, 6384, 7703, 7514, 7704, X, X, X, X, X, X, 7711, 7520,
    7710, X, X, X, X, 7784, X, X, X, X, X, X, X, X, X, X, 7785, 6381, X, X, X,
    X, X, X, X, 6373, 6376, 6375, 6378, X, 6374, X, X, X, 18573, 22032, X, X,
    X, 14587, X, X, X, X, X, X, X, 21259, X, X, X, X, X, X, X, X, 14735, X,
    14195, X, X, X, X, X, 15508, X, X, X, X, X, X, X, 23351, X, 17615, 19167,
    17420, X, X, 20677, 15757, X, X, X, X, 14432, X, X, X, X, X, 14232, X, X,
    X, X, X, X, X, X, X, X, 21233, X, 22595, 20824, X, X, 22139, X, X, X, X, X,
    23715, 20634, 14766, X, X, X, X, X, 22138, X, X, 17057, 18532, 23367, X, X,
    21435, X, X, 21404, X, X, 18596, 23710, X, 14765, 20068, X, 23497, X,
    23726, 22594, X, 18580, X, X, X, X, X, X, 15868, 21273, 16443, X, X, X,
    18406, X, 21614, X, X, X, X, 19888, X, X, X, 15577, X, X, X, X, X, 19885,
    X, X, X, X, X, 21611, 17215, X, X, X, 16148, X, X, X, X, X, X, 14795,
    23476, 16082, X, X, 21573, 21819, 19490, X, X, X, X, X, 17208, X, 19306, X,
    X, 22903, X, X, 17631, 14975, X, 15724, X, X, 14362, 22571, X, 14163,
    20263, 18935, X, X, X, X, X, 23090, X, X, X, X, 21389, X, 21041, X, X, X,
    15734, 16266, 20429, X, X, X, X, X, X, X, X, X, X, 19132, X, X, X, X, X,
    21758, X, 15751, X, 21988, X, X, X, 23692, X, X, 17632, X, X, X, X, 16886,
    15510, 16090, X, X, 17074, 17053, X, 15352, 18427, X, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 19305, 15754, X, X, 20476, X, X, 17609, 21018, 19527,
    X, 14007, X, X, X, 16906, X, 14611, X, X, X, 17403, 15181, 14818, 20885, X,
    X, X, 14379, X, X, X, 22024, X, X, X, 22371, X, X, 17856, 15132, 16078,
    20886, X, X, 22955, X, X, 21815, X, X, X, X, X, X, X, 22787, X, 22034,
    7333, 7334, 7335, 7322, 7323, 7324, 7325, 7344, 7345, 7384, 7385, 7386,
    7387, 7380, 7381, 7382, 6203, 6204, X, 6250, 6193, 6194, X, X, X, X, X, X,
    X, X, X, X, 23700, X, X, X, 21777, X, 15766, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 22906, X, 18543, X, 15894, X, X, 16861, X, X, X, X, 22011, X,
    X, X, X, 14571, X, X, X, X, X, 16275, X, X, X, 18551, X, 14573, 21587, X,
    X, 17669, X, X, X, 14368, 17219, X, X, X, X, 15178, 21244, X, X, X, X, X,
    X, X, X, 19311, X, X, 14544, X, X, X, 20453, X, X, 19108, X, X, X, X, X, X,
    22531, X, 14419, 14376, X, X, X, X, X, X, X, X, X, X, X, X, X, 14802, X,
    22569, 17839, 14175, X, X, 21025, X, X, 14366, X, X, X, X, X, 14944, 21024,
    23519, X, X, 17279, X, 21005, 22730, X, 22208, X, X, X, X, X, X, 23723,
    23131, X, X, X, X, 13981, X, 22522, X, 17042, X, 16701, X, X, X, X, X, X,
    X, X, X, X, X, X, 21086, X, X, 23174, 20505, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 16249, 16309, X, 21413, X, X, X, X, X, X, X, X, X, 18549,
    20246, X, X, 21647, 21830, X, 21240, X, X, 14970, X, X, X, X, X, X, 14978,
    17834, 15316, X, X, X, X, X, 15317, 15318, 21584, X, X, X, X, X, X, 14015,
    X, X, 17975, X, X, X, X, 16496, 23111, 16147, X, X, X, X, X, X, 15727,
    14627, X, 16885, X, 18614, 18526, 20287, X, 14046, X, X, X, X, X, X, X, X,
    21019, X, X, X, 16467, X, 15171, X, X, X, X, 17581, X, X, 17650, X, X,
    18994, X, X, 18730, 15192, 20667, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    16262, 17783, 14764, X, X, X, X, X, 23741, X, X, X, X, X, X, X, X, X,
    21776, X, X, 22709, X, X, 15378, 14793, X, 19747, X, X, X, X, X, X, X,
    19180, X, X, X, X, X, 21605, X, X, X, 21805, X, X, 20889, X, 18576, X,
    18802, X, X, X, X, X, 20433, X, X, X, X, X, X, 23166, X, 20858, X, X, X, X,
    22979, X, X, 15561, X, X, X, X, X, X, 7696, X, X, X, X, X, X, X, X, X, X,
    21211, 20822, X, X, 20823, X, 17795, X, X, X, X, X, X, 17417, X, X, X, X,
    X, 15335, 15336, 21425, 15529, 14958, X, X, 13994, X, X, X, 17606, X, X, X,
    22404, X, 17854, 17416, X, X, X, X, X, X, X, 14754, X, X, X, X, X, X, X,
    18545, X, X, X, X, X, X, X, X, 23108, 15143, X, X, 14356, 20813, X, X,
    19871, X, X, X, X, X, X, X, 15302, X, X, 23722, 14744, X, 23690, X, X, X,
    20321, 14933, X, X, X, X, 16891, X, 16844, X, 16688, 22179, X, X, 23534, X,
    X, X, X, 20082, 20128, X, 17634, X, 17440, X, X, 19943, 18594, X, X, X, X,
    15130, 15947, X, X, X, X, X, 15301, 22927, 19935, X, X, 16874, X, 21823, X,
    X, X, 17407, 18978, X, X, X, X, 19480, X, 16140, 15705, X, 23556, X, X, X,
    X, X, X, 22330, X, X, X, X, X, 21817, X, X, X, 17808, 22349, X, X, X, X, X,
    X, X, X, X, X, X, 16463, 14412, X, X, 19344, 15710, X, 16631, X, 22358, X,
    X, X, X, X, 17661, X, 14567, X, X, X, 17410, X, X, X, 21407, 20655, 21030,
    X, X, X, X, X, X, 23140, 23308, X, 15517, X, X, X, X, X, X, 22518, X, X,
    13974, X, X, X, X, X, X, X, 16522, X, X, X, X, X, X, X, X, 19519, X, 16253,
    14732, X, 15886, X, X, 17228, X, X, X, X, X, X, X, X, 21255, X, X, X,
    18930, 20660, 18955, X, X, 20054, 18931, 21757, 14585, X, 22368, X, 21445,
    20648, 19693, 20854, X, 14425, X, X, 16450, X, X, X, X, X, X, X, X, X, X,
    X, 20081, X, X, X, X, 14549, X, X, X, X, X, X, X, X, X, X, X, 14777, 19486,
    X, X, X, 14190, 13970, X, X, 16256, 15139, X, X, X, X, 21215, 15514, 14349,
    X, X, X, X, 18993, X, X, X, X, X, X, X, X, X, X, X, 21622, X, X, X, X,
    14971, X, X, X, 18189, 20324, X, X, X, X, X, X, 20237, 20238, X, X, X, X,
    X, X, 23499, 20072, 19376, X, X, X, X, X, 19337, X, X, X, X, X, X, X, X, X,
    17239, 17620, X, X, X, 15905, X, 22783, X, X, X, 17786, X, X, 16295, X,
    22948, 19501, 20288, 16142, 21066, 18365, 22548, X, X, 19497, X, X, X, X,
    X, X, X, X, X, X, X, X, 17604, X, X, X, 16079, X, X, 22608, X, 17394, X, X,
    X, X, 17851, X, 17395, 20077, 18382, X, 14371, X, X, X, X, X, 20879, X, X,
    X, 21253, 21775, 15943, 19147, X, X, X, X, X, X, 21845, X, 20259, X, 18168,
    16511, 21451, 19110, 16120, 22197, X, X, X, X, X, X, X, 22198, X, 20827, X,
    X, X, 18611, 15717, 17011, X, X, 18221, X, X, X, X, X, 22750, X, 14205, X,
    X, X, 20281, 20303, X, X, 21636, X, 16488, 15887, 22967, 16468, X, X, X, X,
    19148, X, X, 16135, X, X, 15337, X, X, X, 23495, 16136, X, X, X, X, X,
    19478, X, X, X, X, X, X, X, X, 17200, X, 22021, X, X, X, X, 21089, X, X, X,
    X, X, 21186, X, 17775, X, 22951, 22952, 14029, 17047, X, X, X, 14161, X, X,
    X, X, X, X, X, 15125, X, X, X, X, 14538, X, X, 19735, 19505, X, 23547, X,
    X, 16265, X, X, 18539, X, 15698, 23129, X, X, X, X, 23145, X, 20636, 18402,
    X, 19677, X, 19726, X, X, 21068, X, 21617, X, 15311, X, 14409, X, 17288,
    21786, X, 21234, X, X, X, X, X, 18720, X, X, X, X, 19500, X, X, X, X,
    21198, 21579, X, X, X, X, X, X, X, 14606, X, 19725, X, X, 19530, X, X,
    18996, X, X, 22963, X, X, X, X, X, X, X, X, X, X, 23477, 23478, 16632, X,
    X, X, 17028, X, X, X, X, X, X, X, X, X, X, X, X, 14214, X, X, X, X, 18575,
    X, 22327, 18419, X, X, X, 17073, X, X, X, X, 22392, X, X, X, 20625, X, X,
    21566, 14790, X, X, X, 23674, X, 16123, X, X, 14987, X, 20650, 15123, X, X,
    14819, 17013, 7389, X, X, 7390, X, X, 7378, X, 6433, X, X, 7383, 7393,
    7388, X, X, 6366, X, 6367, X, X, X, X, X, X, X, X, X, X, X, 16445, X, X, X,
    X, 21788, 15116, X, 15933, X, X, 21023, 16626, X, X, X, X, 15951, 19118, X,
    X, X, 17266, 18556, X, X, X, X, X, 18338, 15549, X, X, X, X, 21279, X, X,
    X, X, 16088, X, X, X, X, X, 16667, X, X, X, X, X, 19923, X, X, X, X, X, X,
    16132, 19536, X, X, 16099, X, X, X, X, X, X, X, X, X, X, 20290, X, X,
    21442, 16133, X, X, X, X, X, X, X, X, X, X, X, X, 22904, X, X, X, X, 18359,
    X, 19749, 15768, X, X, X, X, 18529, X, X, X, 15141, X, X, X, 14013, 23096,
    20310, 19563, 16884, X, X, X, X, 17616, X, X, 15916, X, 14353, X, 17038,
    14398, X, 16883, X, 18429, X, X, X, X, 14235, X, 20124, 20125, X, X, X,
    17037, 22725, 20317, 20628, 23159, X, X, 14613, 20621, X, 20629, 21262, X,
    17576, X, 20630, 23553, X, 16700, 22561, 23115, X, X, X, X, X, X, X, X, X,
    14969, X, 16515, X, 20300, 14776, X, X, X, X, 17472, X, X, X, X, X, X, X,
    17203, X, X, 14430, 22156, 18918, X, X, X, X, 19550, 21428, X, X, X, 21212,
    X, 14817, X, 17231, X, 22786, X, X, 17453, X, 19174, X, X, X, X, X, X,
    18572, X, X, 23122, X, X, X, 22919, X, X, 6379, X, X, 6385, X, X, 6230,
    6182, X, 7508, X, X, 6184, 6436, X, 8320, X, X, X, X, X, X, X, X, X, X, X,
    X, X, X, X, 15165, 17050, X, X, X, 22939, X, 18393, 17226, X, 14382, 20473,
    14182, X, 17848, X, X, 22151, X, X, X, X, X, X, X, 16696, X, 16856, X, X,
    X, 23681, X, X, 23720, 22419, 15327, X, X, 19702, X, 18929, X, 18407,
    15898, X, X, X, X, X, X, X, X, X, 17393, X, X, X, X, X, 19874, X, X, X, X,
    22574, X, X, X, X, X, 15118, X, X, X, X, 21456, X, X, X, X, X, 21427, X,
    20697, X, X, X, X, X, X, 16114, X, 14024, X, X, X, X, X, 23520, X, X,
    20671, 18374, X, X, X, X, 23543, X, X, X, X, 19700, X, 21415, X, X, X,
    14806, 14751, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 22027, 14782, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, 14564, 14781, X, 14217, 21957,
    17096, X, 22398, 19748, 14927, 21265, X, 22038, 17235, X, X, X, 18808, X,
    22912, X, X, X, X, X, X, 15196, 20484, X, X, 14991, X, X, X, X, 22008, X,
    X, 15379, 15511, X, X, X, 18037, 21046, X, X, X, 18938, 22780, X, 17207, X,
    X, X, X, 23503, X, X, X, 15190, X, X, 19742, 15155, X, 16871, X, X, X, X,
    X, X, X, 19673, 17400, X, X, X, X, X, 21188, X, 16068, X, X, X, X, X, X, X,
    X, X, X, X, X, X, 21446, 15954, X, X, X, X, X, 22201, 18386, X, X, X, X, X,
    X, X, X, 14229, X, X, X, 14183, X, X, X, 21260, X, X, X, X, X, X, 17601, X,
    X, X, 21596, X, 23126, X, X, 18380, X, 13989, X, X, X, 21629, 21416, X, X,
    X, X, 18945, X, X, X, X, X, X, 15695, X, X, X, X, 22974, 14999, 22585, X,
    X, X, X, X, 14753, X, X, X, 21420, X, X, X, X, 18560, 17447, X, 17448, X,
    X, 21008, 19296, 21252, 21443, 17466, 16252, X, X, X, X, X, X, X, X, X, X,
    22030, X, 18013, X, X, X, X, X, X, X, X, 23338, 19542, X, X, X, X, 19897,
    X, 18415, X, X, X, 22199, X, X, X, X, X, 21256, 18569, X, X, 18915, X,
    22200, 20673, X, X, X, 19544, X, X, 14957, 18384, X, 18565, X, X, X, X, X,
    X, 18723, X, 16449, X, X, 18210, X, X, X, X, 16311, X, X, X, X, X, X, X, X,
    X, X, X, 14812, X, X, 18201, X, 22554, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 16100, X, 15151, X, X, 17092, X, X, X, X, X, X, X, X, X, X, X, 14241,
    X, X, X, X, 14605, X, X, X, 14429, X, X, X, X, X, X, X, 22362, X, X, 15339,
    17667, X, X, X, X, 23336, X, 21037, X, 19701, X, X, X, X, X, X, X, 17287,
    X, X, X, X, 23535, X, X, X, 18160, 22016, X, 21055, 15007, 21056, X, 21575,
    X, X, X, X, X, 20833, X, 21028, X, X, 14395, X, 17579, X, X, X, 21044, X,
    X, 16836, X, X, 20626, X, 18738, X, X, X, X, 17611, X, X, X, X, X, X, X, X,
    X, X, X, 20450, X, X, X, X, 18606, X, X, X, X, X, X, X, 16339, X, X, X,
    18607, X, X, X, X, 14997, 22540, 16898, X, X, 18378, X, X, 19537, X, X, X,
    16299, 18379, X, X, 19684, X, X, X, X, X, 14947, X, 19293, 23728, X, 14948,
    X, 18208, 17841, X, X, 21588, X, X, 23171, 22335, 23172, 16695, X, 21962,
    X, X, X, X, X, 19346, X, X, X, X, X, X, X, 19669, X, X, 16703, X, 21598, X,
    X, X, 18006, X, X, X, 17085, X, 18599, X, 15314, X, X, X, X, X, 21072, X,
    X, X, X, 16307, 18989, 18414, X, 22142, X, X, X, X, X, X, X, X, X, X, X, X,
    22143, X, 19918, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 18927, X, 16816,
    X, 16657, 17444, X, X, 20644, 17979, X, 20050, X, X, X, 16448, X, 22772, X,
    15926, X, X, 20101, X, X, X, X, 23332, 20702, X, X, 19116, 14577, 16487,
    17768, X, 18969, X, X, X, X, 20846, X, X, X, 18586, X, X, 16676, X, X, X,
    X, X, X, 17594, 15941, X, X, 21590, X, 17978, 17590, 17591, X, X, 14178,
    19716, X, X, X, X, X, X, X, X, X, X, 23328, X, X, X, X, X, 22929, X, 20073,
    X, 15522, 23324, 19507, 20240, X, 18045, 18717, 20071, X, 20096, X, X,
    20656, 17586, X, X, X, 19107, 23656, X, 18003, 20444, X, 14799, X, X, X, X,
    X, X, X, 18538, X, X, X, X, X, X, 15350, X, X, X, X, X, X, X, X, X, 18716,
    X, X, 19732, X, X, 21766, 21567, X, X, X, X, X, X, X, X, X, X, 15185, X, X,
    X, X, 21604, X, X, X, X, X, 19555, X, 15183, X, X, 21765, 15182, X, X, X,
    X, X, 19182, X, X, X, 21847, X, X, 20807, X, X, 20112, X, X, X, X, X, X, X,
    X, X, X, X, X, 17988, 7356, 7357, 7358, 7359, 7360, X, X, X, 7341, 7342,
    7375, 7376, 7377, 7337, 7338, 7339, 6393, 6394, X, 6397, 6392, 6395, X,
    6396, 6410, 6424, 6425, X, 6426, 6423, X, X, 7516, 7706, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 22202, X, X, 6968, 6969, 6970, 6971, 6972, 6973, 6974,
    6975, 6976, 6977, 6978, 6979, 6980, 6981, 6982, X, 23712, X, X, 14348, X,
    X, X, 16904, X, X, 15749, 22220, X, 21034, X, 17069, X, X, X, X, X, X, X,
    X, X, X, X, X, X, X, 20260, X, 19939, X, X, X, X, X, X, X, X, 14809, X, X,
    X, X, X, 18199, X, X, X, X, X, 21013, X, X, X, X, 14361, 20047, X, X,
    18991, 15137, X, 21208, 20806, X, X, X, 21254, X, X, X, 21981, X, X, 19928,
    X, X, X, X, X, 21994, X, X, 22516, X, X, X, X, X, X, X, 20637, X, X, X, X,
    X, X, X, X, 16291, X, X, X, X, X, X, X, 18618, X, X, X, X, X, 16102, 15193,
    X, 14165, X, X, X, X, X, X, X, 18964, X, 18426, 14157, X, X, X, 16870, X,
    X, X, X, X, X, X, X, 22180, X, 21457, 23124, 17436, X, X, X, X, 17641,
    23364, 17608, X, 18736, X, X, X, X, X, X, X, 16437, X, X, 22582, X, X, X,
    X, X, 21257, X, 17607, X, 14960, X, X, X, X, X, X, 21756, X, X, X, X, X, X,
    X, X, X, 19483, X, X, X, X, X, X, 19156, 23746, X, X, 18186, X, X, X,
    16286, X, 22389, X, X, X, X, 19938, 21600, X, X, X, 15876, 13984, 14541, X,
    14570, 21778, X, X, X, X, X, X, X, X, X, X, X, X, 23149, X, X, 19137, X,
    22357, 23716, X, X, 15932, 14411, X, 22567, X, X, X, X, 20514, X, X, 22718,
    X, 21599, 22360, X, 16485, X, X, 22897, 14054, X, X, 15923, X, X, X, X, X,
    X, X, 22000, 14346, X, X, 14941, 23325, X, 22793, 22606, X, X, 19696, X, X,
    X, X, X, X, X, 19688, X, 20322, X, X, X, X, X, X, X, X, X, X, X, 17963, X,
    X, 15310, 16502, X, X, X, 18183, X, 16247, X, 20695, X, X, X, X, 20865, X,
    14198, 23518, X, X, X, X, X, X, 14800, X, 18238, X, X, 16713, X, X, X,
    22530, 17027, X, 14020, X, X, X, X, 17061, 15320, X, 17964, X, X, 21771, X,
    X, 14381, X, X, 18752, 20323, X, 21582, X, X, X, 14942, X, X, X, 15688,
    19730, 14801, 20998, 20241, 14158, 18788, X, X, X, 15386, 20999, X, 21070,
    X, X, X, X, X, 14406, X, X, X, X, 22332, X, X, X, 19375, X, 19135, X, X, X,
    23279, 15890, X, X, 17830, X, 18908, X, X, X, 16458, 16858, X, 16865,
    15718, 16712, 17014, 22223, X, X, 17827, 21580, 22714, X, X, X, X, 19872,
    X, X, 23098, 22382, 23169, X, X, X, X, X, 22715, 16842, 14048, 22376,
    19373, 20130, X, X, X, X, X, 20131, X, X, 22414, X, X, 16073, X, X, X,
    16083, X, X, X, X, X, X, X, X, X, 14930, X, X, 14016, X, X, 13980, 16106,
    21840, 22529, X, X, 21035, X, 14618, 22182, 19178, 21219, X, X, X, X, X,
    22168, 17421, X, 22162, X, 17814, X, X, X, X, X, 19316, X, X, X, X, X, X,
    17778, X, 23116, X, 22157, X, X, X, X, X, X, X, X, 18421, 17809, X, X,
    23527, X, 22586, X, X, 14597, X, 22519, X, X, X, 22737, X, X, X, 15736, X,
    18352, X, X, 22533, X, X, 15758, 15725, X, 22167, X, X, X, 18016, X, 22936,
    X, 18971, X, 23304, X, X, 16439, 14762, X, X, X, X, 14778, 16315, 20676,
    14761, X, 14156, X, X, X, X, X, X, 17642, X, X, X, X, 23526, 20052, 19941,
    23302, X, 19548, 21039, X, X, 15175, X, X, 17798, X, X, 18917, X, 20111, X,
    X, X, X, 16469, X, 21762, X, X, 14609, X, 20313, X, X, 14625, X, X, X, X,
    X, 23480, 15676, X, 21386, X, X, X, X, 22341, 21042, 19902, X, 22577, X, X,
    X, X, X, X, X, X, 14608, X, X, X, X, X, X, X, 16878, X, 21810, X, X, X,
    17414, X, 14414, 17835, X, X, X, X, 18007, X, X, 22794, X, X, X, X, 21199,
    X, X, 20243, X, X, X, 17289, X, X, X, X, X, X, X, X, X, 19697, 19698, X, X,
    X, 14982, 19857, 19917, X, X, X, X, X, 21236, 21585, X, X, 21237, 14223,
    23327, 22205, 18789, X, 14726, 22144, X, X, 17664, X, X, 17665, X, X, X, X,
    X, X, 21238, 16714, X, X, X, X, X, X, X, X, 23148, X, X, X, X, X, X, 18987,
    X, X, 18040, X, X, 19753, 22782, X, X, 18942, X, X, X, X, X, X, X, 17259,
    X, X, X, X, X, 19362, X, X, X, 18805, X, X, 21195, 22943, X, X, 21958, X,
    23475, X, X, X, X, X, 22591, X, X, X, 19751, X, 19687, X, X, 16292, 21971,
    X, 22556, X, X, 14355, X, X, 21220, 14399, X, 15743, 22412, X, X, 16081,
    21800, 14220, X, X, X, X, 20319, X, X, X, 22397, X, X, X, X, 22410, X, X,
    X, X, X, X, X, 6372, X, X, X, X, X, X, X, X, X, 22735, X, X, X, X, X, X,
    22552, X, X, X, X, 17197, 21651, X, X, 13991, 20253, X, X, X, X, 21377, X,
    X, X, X, X, X, X, X, X, X, 17242, 14159, X, X, 22769, X, 14179, X, X, X, X,
    X, X, X, X, 22989, 17221, 17090, X, X, X, 21589, 22365, X, X, X, X, X,
    15745, 21626, 14946, X, 20247, X, 20074, 19379, X, 22551, 22148, X, 16879,
    X, X, X, 13985, X, X, 22771, 14949, 14804, X, X, 21648, X, X, X, X, 22724,
    X, X, X, X, X, X, X, 17458, 17820, X, X, X, X, X, 14218, X, 14617, X,
    14990, X, X, X, 14559, X, X, X, X, X, X, 18721, 15353, 17457, X, X, X,
    23139, X, 15761, X, X, X, X, 21433, X, 23167, X, X, 17998, X, X, X, X, X,
    22926, 16260, 16093, X, X, X, X, X, 22395, X, X, 17205, X, X, X, 22579, X,
    X, X, 22960, X, X, X, X, X, X, X, X, X, X, X, X, 6435, X, X, X, 7319, X, X,
    6429, X, X, X, X, X, X, X, X, X, 22710, X, X, X, X, X, 19121, 8139, 8140,
    8141, 8142, 8143, 8144, 8145, 8146, 8147, 8148, 8149, 8150, 8151, 8152,
    8153, 8154, 7126, 7137, 7127, 7138, X, X, X, X, X, X, X, X, 7128, 7165,
    7164, 7139, 8314, 8315, 8316, 8317, 8318, 8319, 8321, 8322, 8323, 8324,
    8325, 8326, 8327, 8328, 8329, 8330, 7507, X, X, X, X, X, X, 6206, 7515, X,
    X, X, X, X, 7518, 7707, X, 22779, X, X, X, X, X, X, X, X, X, X, X, X, X,
    18958, 18154, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 16056, 18416, X,
    15489, X, X, X, X, 22226, X, X, X, X, X, X, 15163, 15164, 18339, 14546, X,
    16899, 19671, 14581, 18408, X, 23544, X, 18212, X, X, X, X, X, 18733, X, X,
    X, X, X, X, X, X, X, X, 21385, 14774, X, X, 22364, X, 18550, X, X, X, X, X,
    X, X, 18732, 23540, 14543, X, 14367, X, X, 18772, X, X, X, X, X, X, X, X,
    X, X, X, X, X, 22141, X, X, 16336, X, X, X, X, X, X, X, X, X, 18968, X,
    14019, X, 22767, 22905, 14052, X, 20638, X, X, 15699, 21619, X, X, 15922,
    20842, 21645, X, 22359, X, X, 21022, X, X, X, X, 15958, X, X, 18185, X, X,
    X, 19710, X, X, X, X, X, X, X, 22383, X, X, X, X, 21974, X, 14939, 19914,
    15307, X, X, X, X, X, X, 17044, 19503, X, X, X, X, X, 15373, X, X, 19338,
    X, X, 19937, X, 17971, X, 14407, X, X, X, X, X, X, X, 22723, X, X, X,
    17460, X, X, 17216, X, 21826, 16719, X, X, X, 23514, X, 20633, 21960, X,
    23278, X, 14196, X, X, 19334, 21229, X, X, X, X, X, X, X, X, X, X, 16131,
    16143, 17088, X, X, X, 17666, X, X, X, X, X, 17622, X, X, X, X, X, X,
    23316, X, 18002, X, X, 15707, 18770, X, 21065, 23513, 15729, X, X, X, X, X,
    X, 20663, 14536, X, X, X, X, X, 17976, X, 14565, X, 17078, X, X, X, X, X,
    X, X, 14931, 22572, 21825, X, X, 15889, 20265, 17654, X, 17655, 17656,
    17657, X, X, 16845, X, X, X, X, 18534, X, X, 17793, 19496, X, X, X, X, X,
    17275, X, 23512, 23277, X, 18205, X, X, X, X, 21972, 17058, X, 22913, X, X,
    X, 16293, X, X, X, X, X, X, 16129, 21453, X, X, X, X, 14049, X, X, X,
    19755, X, X, 14798, X, X, X, X, 17408, X, X, X, X, X, X, X, X, X, X, 17253,
    19325, X, X, X, X, 22763, X, X, X, X, X, X, X, X, X, X, 19532, X, X, X, X,
    X, 21613, X, 20136, X, 18206, 23358, X, X, X, X, X, 14561, X, X, 23554, X,
    X, X, X, 18038, 14796, 17039, 18034, 14396, 15764, X, X, X, X, 15945,
    17234, 17818, X, X, X, X, 21269, X, 17392, X, X, 16316, X, X, X, X, X,
    22746, X, X, X, X, 18765, 17477, X, X, X, X, X, X, X, X, X, X, X, X, X, X,
    X, 18351, 14739, X, X, X, X, 16817, X, X, X, X, 16706, X, 15912, X, X, X,
    23546, X, X, X, 15133, 17284, 16452, X, X, X, 14247, X, X, 18342, 20856,
    15140, X, X, X, X, X, X, X, X, X, X, X, 21071, X, X, X, X, 16248, X, X, X,
    X, X, X, 22363, X, X, X, X, 22387, X, X, X, X, X, X, X, X, X, X, X, 20427,
    20708, X, 22155, 23299, 20297, X, X, 22175, X, 15927, X, X, X, X, X, X, X,
    X, X, X, 19896, X, X, X, X, 15721, 14953, X, X, X, X, X, X, X, X, X, 21774,
    18961, 15004, 14973, X, X, 23289, 15360, X, X, 17227, X, 22165, X, 17852,
    X, X, X, X, 14056, 14160, X, X, X, X, 14228, X, X, X, 23157, X, X, X, X, X,
    X, 22931, X, 18719, X, X, X, X, X, X, X, 16822, X, X, X, X, X, X, X, X,
    22520, X, 14169, X, 17020, X, 16647, X, 17258, 15726, 22744, X, X, X, X, X,
    X, X, X, X, X, X, X, 14757, 18767, 15342, 21460, 17994, X, X, X, X, X, X,
    X, 18922, X, X, X, X, X, X, 17456, 14596, X, X, X, X, X, X, X, X, 16268,
    14554, X, X, X, X, X, 22378, 16121, X, X, X, X, X, X, X, X, 22726, 6793,
    6794, 6795, 6796, 6797, 6798, 6799, 6800, 6801, 6802, 6803, 6804, 6805,
    6806, 6807, 6808, 7184, 7185, 7157, 7186, 7187, 7188, 7189, 7190, 7191,
    7192, 7193, 7147, X, X, X, X, 17070, X, 16267, X, 18778, X, 17800, X,
    17801, 13966, X, X, 6242, 6241, X, X, 6391, 6390, X, X, X, X, 6244, 6243,
    X, X, X, 14588, X, X, X, X, X, X, X, X, X, X, X, X, 16665, X, X, 20838, X,
    16456, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 21621, X, 17663, X, X, X,
    X, X, 19712, X, X, X, X, X, X, X, X, 19128, X, X, X, X, 18223, X, X, 20686,
    23296, 22781, X, X, X, X, 18216, X, 14402, X, X, 15903, X, 21222, 18748,
    23509, 23510, X, X, X, X, 21608, X, 21609, X, X, X, 18952, 23294, 18939, X,
    X, X, X, X, X, X, X, X, X, X, X, X, X, 15145, X, 21000, X, 15719, 17082, X,
    X, X, X, 16461, X, 21618, 22204, 16894, X, X, 16273, 15744, X, X, X, X, X,
    23146, X, X, X, X, X, X, 18530, 14560, 20127, 14194, X, 14619, X, X, 17210,
    21052, 19722, 21049, X, X, X, 15741, X, 18588, X, X, 23529, 16475, 23668,
    X, X, X, 20682, X, X, 15740, X, 17995, X, X, X, X, 16837, X, 23667, 21568,
    X, 22603, X, X, X, X, 15124, X, X, 17204, X, X, 15702, 14041, X, 17419, X,
    X, 21192, X, X, 19317, X, X, 14042, X, X, X, X, 19740, 15755, X, X, X, X,
    X, 21189, 18411, 14986, 21798, 20624, 13995, X, X, X, X, 21953, X, 17473,
    X, X, X, X, 14162, X, 17051, X, X, 16480, X, X, 15914, 19932, X, 14040,
    16881, X, 23673, X, 18728, 16289, 16835, 7373, 7374, 6432, 7391, 7321,
    7379, 7394, 6430, 7343, 7392, 7336, X, X, X, X, 7340, 7917, 7918, 7919,
    7920, 7921, 7922, 7923, 7924, 7925, 7926, 7927, 7928, 7929, 7930, 7931,
    7932, 6208, 6228, X, X, 6209, 6210, X, X, X, X, 6251, 6252, X, X, X, X,
    20623, 17799, 22391, 20675, 17470, 18170, X, X, X, 15911, X, 21966, 7965,
    7966, 7967, 7968, X, X, X, X, X, X, X, X, X, X, X, X, X, 16438, X, X, 8272,
    X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, 16092, 23749, 23470, 23102,
    18012, X, 18195, X, X, X, 22003, X, X, X, X, X, X, 17589, X, 22987, X,
    14377, X, X, X, X, X, 21583, 21841, 22384, X, X, X, X, 16529, X, X, X,
    14034, X, X, X, 17386, X, 18166, X, X, X, X, X, X, 16867, 16317, 16857, X,
    17022, 16664, 17451, 21801, 22219, X, 21400, X, X, 17056, X, 22399, X, X,
    X, 15000, X, X, 23669, X, X, 14249, 20689, X, X, X, X, X, X, X, X, X, X, X,
    X, 17636, X, X, X, 16085, X, X, X, X, X, X, X, X, 21410, 20868, X, X,
    17662, X, X, X, X, X, X, X, X, X, X, X, X, X, 18180, X, X, 23515, X, 20275,
    X, X, X, X, X, X, X, X, 15708, 21230, X, 18536, 21827, X, X, X, X, X,
    21029, X, X, X, X, X, X, 20691, 14932, X, X, X, X, X, X, X, X, X, X, X, X,
    X, X, 19287, 20094, 18039, X, X, X, X, 15371, 18967, 19130, X, X, X, X,
    16821, X, X, 22136, X, X, X, X, X, X, X, X, X, X, X, X, X, 18398, X, 17054,
    14925, X, X, 14734, X, X, 16333, X, X, X, 21398, 20893, X, X, X, 16872,
    20292, X, 14922, 20060, X, X, X, X, X, X, X, X, X, X, X, X, 22177, 19877,
    X, X, 17402, X, X, X, 16109, X, X, 21813, X, 14188, X, 17230, X, X, 19524,
    15497, X, 14814, X, X, X, X, X, 21468, X, 17796, 23301, 22920, 7933, 7934,
    7935, 7936, 7937, 7938, 7939, 7940, 7941, 7942, 7943, 7944, 7945, 7946,
    7947, 7948, 7576, 7577, 7578, 7579, 7580, 7581, 7582, 7583, 7584, 7585,
    7586, 7587, 7588, 7589, 7590, X, 8076, 8077, 8078, 8079, 8080, 8081, 8082,
    8083, 8084, 8085, 8086, 8087, 8088, 8089, 8090, 7744, 7745, 7746, 7747,
    7748, 7749, 7750, 7751, 7752, 7753, 7754, 7755, 7756, 7757, 7758, 7759,
    8266, 8267, 8268, 8269, 8270, 8271, 8273, 8274, 8275, 8276, 8277, 8278,
    8279, 8280, 8281, 8282, X, 6556, 6557, 6558, 6559, 6560, 6561, 6562, 6563,
    6564, 6565, 6566, 6567, 6568, 6569, 6570, 6587, 6588, 6589, 6590, 6591,
    6592, 6593, 6594, 6595, 6596, 6597, 6598, 6599, 6600, 6601, 6602, 6619,
    6620, 6621, 6622, 6623, 6624, 6625, 6626, 6627, 6628, 6629, 6630, 6631,
    6632, 6633, 6634,
]; // 27784 entries

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_UPPER: &'static [u16] = &[
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24154, 2634, 13061, 26267, 23137, 6825, 0,
    12627, 21943, 139, 22350, 25118, 1748, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 26002, 22378, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    25137, 18359, 170, 12062, 0, 0, 0, 27374, 27720, 2618, 26251, 6809, 24169,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19816, 21218, 1457,
    0, 0, 0, 22362, 6840, 0, 26183, 0, 0, 0, 0, 0, 11650, 26196, 18331, 0, 0,
    18316, 2194, 12380, 0, 20033, 0, 0, 0, 23903, 0, 0, 22334, 22303, 22288,
    1469, 0, 12577, 27327, 0, 20273, 21225, 2931, 0, 0, 0, 0, 0, 0, 20256, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27673, 18343,
    12986, 12046, 27704, 388, 0, 2602, 19171, 0, 26235, 6793, 21202, 1441,
    27006, 0, 0, 0, 0, 2506, 7444, 27032, 2178, 7698, 0, 0, 12364, 6762, 0, 0,
    19372, 0, 25104, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 20017, 22740, 0, 0, 22318, 22272, 27311, 27657,
    12970, 27355, 27688, 372, 2586, 19155, 26219, 19333, 0, 0, 0, 6777, 21186,
    1425, 26990, 7428, 7367, 0, 0, 0, 0, 0, 0, 0, 2162, 18303, 0, 0, 0, 0,
    7682, 19356, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25088, 20001,
    22724, 22256, 27295, 23889, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 12563, 7382, 20259, 25787, 27641, 12954, 20242, 341, 21155, 25758,
    7397, 19501, 2492, 27339, 22602, 18248, 356, 1407, 2570, 27018, 19139, 328,
    26203, 19317, 21170, 25773, 1409, 26974, 24113, 7412, 7351, 24128, 27627,
    2146, 21141, 20696, 18287, 22589, 22447, 25799, 24099, 20632, 27613, 2131,
    7666, 21126, 2117, 19340, 18757, 25072, 19034, 19126, 20617, 18274, 21111,
    22681, 25058, 20754, 26756, 19112, 18260, 19019, 20723, 21097, 22666,
    20740, 20708, 27253, 22694, 27265, 19985, 22708, 26769, 22240, 23474,
    20725, 18024, 27279, 26783, 23873, 12547, 25302, 25742, 2476, 2906, 19970,
    18232, 1391, 23486, 312, 2455, 23836, 21067, 23848, 19301, 2751, 7335,
    24083, 19274, 22225, 18038, 13019, 19805, 19771, 18009, 2569, 23860, 12000,
    21442, 0, 19955, 2920, 19286, 299, 18741, 13004, 20601, 19756, 26179,
    21054, 12353, 2092, 19940, 0, 2948, 25042, 23318, 12989, 23372, 19797,
    26740, 2469, 0, 12042, 20589, 24732, 1687, 0, 25666, 7322, 247, 25681,
    18740, 26963, 7296, 21081, 12308, 25030, 27222, 18963, 25696, 22212, 19785,
    6758, 27609, 0, 610, 22650, 26739, 11987, 22578, 13021, 27237, 22436,
    23458, 25711, 625, 23097, 478, 25286, 19000, 2720, 13036, 25726, 2890,
    1694, 18216, 19743, 12014, 23112, 1375, 7655, 21411, 19432, 2106, 24396,
    26166, 268, 24720, 19405, 21918, 2439, 19015, 2735, 20430, 23305, 13051,
    12536, 261, 0, 0, 7310, 928, 0, 12029, 0, 23127, 0, 7283, 12937, 2937, 0,
    21050, 24067, 2878, 6745, 19258, 597, 12322, 17993, 465, 2553, 21426,
    25655, 283, 21933, 17730, 12337, 19716, 19731, 18724, 1738, 0, 23045,
    25273, 1723, 22649, 12944, 26947, 26141, 25258, 19491, 19102, 0, 2707,
    18215, 25014, 0, 1363, 2509, 23086, 21823, 19375, 1708, 19476, 19461,
    19419, 889, 555, 27206, 24383, 18947, 26927, 19446, 22196, 24707, 20990,
    874, 26155, 27593, 2865, 916, 26723, 11971, 23362, 584, 26912, 17718, 2523,
    22562, 27193, 26708, 11956, 22619, 24353, 1677, 22184, 22420, 7639, 21837,
    21395, 0, 2403, 18922, 19389, 7638, 25936, 20414, 2084, 21787, 20581,
    21034, 27136, 20402, 24051, 6729, 12300, 17977, 903, 449, 569, 2388, 21019,
    7272, 24036, 21004, 24024, 0, 25007, 2537, 22999, 19700, 23014, 18708,
    22124, 25993, 18965, 23029, 19247, 18980, 23999, 409, 22633, 24340, 26931,
    26125, 21908, 22761, 18199, 394, 23070, 26664, 26110, 24367, 436, 21851,
    25644, 0, 20974, 17949, 21893, 18992, 27577, 24011, 2417, 22746, 0, 19931,
    2849, 544, 25249, 21878, 21863, 21352, 25965, 18936, 25980, 25950, 7017,
    27091, 22546, 27177, 26692, 22153, 21801, 22138, 423, 11940, 22168, 11910,
    21379, 2431, 849, 18906, 7622, 2068, 21771, 23283, 27120, 20386, 17961,
    24696, 21364, 27560, 18891, 27105, 23295, 25911, 23063, 2372, 23253, 7256,
    27436, 27451, 22983, 19684, 18692, 22108, 19231, 11764, 24324, 20943,
    26648, 25607, 25628, 2818, 0, 21815, 20958, 23208, 6986, 18547, 18861,
    17933, 2833, 21336, 7001, 20379, 2342, 11924, 26555, 863, 21740, 27574,
    26904, 11894, 22608, 20495, 833, 12927, 0, 22533, 2315, 7244, 26570, 24323,
    22409, 2052, 25925, 21755, 20510, 22478, 26636, 23267, 2330, 0, 20555,
    24683, 27465, 7232, 11778, 26624, 0, 21311, 21323, 25621, 17210, 23222,
    22891, 27544, 20570, 18875, 6718, 7204, 23047, 2356, 23237, 26584, 20482,
    0, 19668, 22906, 2030, 26596, 20912, 22092, 23798, 6877, 7219, 25579,
    27051, 11748, 26611, 20527, 20927, 23567, 6705, 6892, 26681, 22492, 27066,
    2017, 18117, 25591, 18077, 6907, 2802, 23812, 6970, 22507, 18132, 18092, 0,
    18531, 20363, 17179, 17165, 26539, 21724, 12916, 0, 11878, 817, 22522,
    26495, 18147, 24307, 20539, 17194, 26510, 11735, 27528, 7176, 20896, 27513,
    7161, 20881, 19923, 22076, 20866, 2304, 23782, 6861, 20851, 25563, 23551,
    6954, 20836, 20514, 12902, 1983, 803, 25548, 22467, 20347, 23352, 11862,
    11719, 0, 26481, 18104, 23536, 2010, 23529, 20332, 26466, 1995, 27499,
    7145, 19907, 17152, 17678, 17693, 2288, 17663, 6845, 7094, 7133, 22453,
    24982, 22063, 12886, 17708, 19893, 12096, 0, 787, 0, 7597, 1667, 24997,
    17138, 26670, 12872, 20112, 23513, 20124, 536, 18066, 23744, 23756, 26450,
    19879, 27167, 2272, 12481, 773, 505, 7612, 26438, 7078, 7117, 6929, 24966,
    22047, 27138, 25468, 12080, 23771, 7581, 1651, 6941, 25439, 25241, 12496,
    520, 1970, 25537, 23728, 27153, 2256, 757, 7062, 25454, 17911, 26410, 2242,
    25395, 18689, 23339, 2228, 7101, 7558, 23908, 26395, 25847, 26425, 20161,
    25480, 20237, 22763, 6913, 17652, 22031, 20176, 24826, 25495, 27068, 25901,
    1957, 25381, 26788, 22778, 7565, 23491, 20191, 18675, 25423, 0, 20678,
    25521, 20691, 18858, 27496, 27413, 12154, 741, 26381, 23323, 27469, 24841,
    27083, 27426, 23818, 20206, 2801, 2212, 17845, 24856, 21294, 26516, 20130,
    22973, 25870, 25833, 7542, 20221, 24871, 25350, 20145, 19600, 25885, 17923,
    24737, 17638, 25407, 17380, 25365, 19078, 23200, 17395, 2785, 19093, 22957,
    25854, 20101, 23920, 25817, 19584, 17622, 17364, 18829, 22017, 21301,
    19062, 18657, 18814, 24812, 2769, 25507, 18844, 1354, 22881, 26378, 7194,
    0, 22401, 1339, 24278, 19568, 27482, 0, 691, 23831, 26529, 22001, 24263,
    645, 24955, 18798, 19660, 630, 12140, 17480, 18641, 17900, 17093, 22850,
    660, 22865, 7178, 704, 22943, 675, 24662, 17449, 19644, 26800, 18664,
    12124, 17464, 11839, 11854, 11824, 26364, 22821, 18625, 717, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 27402, 11782, 7536, 26349, 12862, 17804, 22790, 23503, 1325,
    17819, 17884, 980, 7507, 7478, 12291, 21987, 22834, 730, 20080, 22927,
    19628, 17857, 17079, 22805, 17834, 11795, 26042, 20095, 11810, 24801, 1128,
    7520, 17100, 933, 24949, 23943, 12846, 964, 18611, 26101, 7491, 1311, 7462,
    17870, 26070, 24787, 12275, 26057, 12471, 11711, 1641, 19612, 17115, 7022,
    24933, 12830, 948, 0, 26085, 17130, 7037, 7052, 18058, 1295, 21284, 11695,
    19565, 0, 21703, 21269, 19550, 17243, 12261, 21690, 21662, 11679, 24919,
    21675, 0, 21649, 17229, 25340, 17748, 24903, 24252, 0, 17599, 17536, 17583,
    17569, 12113, 17214, 24749, 0, 24888, 17553, 17777, 17521, 17612, 24762, 0,
    17407, 18428, 19206, 17793, 1843, 23966, 23932, 18369, 24776, 12460, 21970,
    26300, 12098, 17423, 12072, 19052, 2689, 2702, 18788, 0, 11660, 24290,
    17492, 24873, 19222, 18775, 0, 0, 17538, 1812, 26895, 24674, 23980, 12629,
    21984, 12819, 26812, 0, 1859, 17506, 26343, 27376, 23994, 12660, 18385,
    18399, 1890, 26316, 12187, 18413, 18552, 992, 12749, 1140, 18522, 12230,
    2204, 17439, 24241, 24587, 1171, 24171, 23955, 12201, 21494, 1634, 1801,
    12244, 24306, 12258, 18194, 21715, 1828, 24214, 1074, 24473, 0, 12645,
    1875, 27392, 12792, 12172, 26332, 12765, 1088, 12806, 12734, 18507, 1156,
    24187, 12217, 20070, 12687, 1621, 1508, 21510, 24230, 12781, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 12390, 18181, 19848, 24541, 19837, 24201, 21479, 1104, 12703,
    1524, 1786, 12406, 17255, 17760, 21262, 0, 0, 0, 0, 18440, 1120, 19859,
    17069, 20827, 24458, 26020, 18152, 17347, 2047, 26839, 12719, 2672, 26036,
    21524, 21951, 17363, 11672, 21598, 0, 1061, 0, 26855, 12420, 12501, 18492,
    19540, 17269, 20291, 24510, 12672, 21567, 17774, 0, 0, 12159, 23584, 21967,
    18166, 24636, 21462, 12436, 17285, 20307, 24526, 1771, 17332, 21583, 23600,
    21612, 17301, 19196, 26869, 20323, 25185, 24621, 21550, 1535, 21476, 12450,
    20043, 21564, 1756, 1549, 20057, 19870, 21235, 21249, 26817, 18605, 23616,
    21628, 25221, 2683, 1552, 17317, 0, 1902, 26885, 19181, 21642, 0, 26833,
    20814, 0, 24577, 22910, 1566, 18564, 24445, 24599, 23632, 1918, 0, 23390,
    24485, 25170, 21535, 2034, 24553, 7742, 22926, 20477, 18590, 23435, 25333,
    18452, 496, 25196, 25232, 12513, 85, 0, 1569, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 7454, 23648, 23719, 1257, 19527, 20642, 24497, 13141, 0, 0,
    23571, 20799, 23404, 1934, 1585, 7756, 23664, 18575, 25208, 44, 13114,
    23420, 24564, 1271, 1601, 1287, 70, 18767, 215, 1948, 23704, 12595, 97,
    997, 0, 1013, 0, 20772, 7729, 0, 199, 20464, 20669, 13144, 1192, 19512,
    13126, 20653, 0, 0, 0, 20448, 24619, 1613, 1176, 13083, 20784, 1244, 13099,
    23191, 0, 7767, 18484, 0, 0, 0, 24139, 55, 1498, 25168, 23175, 12612,
    24421, 23159, 26010, 24641, 24437, 124, 108, 23678, 0, 0, 0, 25808, 2760,
    0, 22392, 23689, 0, 0, 1044, 25312, 31, 2650, 1204, 7700, 0, 12580, 26283,
    24604, 0, 20281, 19045, 24653, 0, 25122, 2666, 1055, 229, 21452, 23382, 0,
    0, 0, 0, 0, 0, 0, 0, 25323, 19830, 20762, 23440, 18049, 18457, 0, 155,
    7716, 12609, 0, 0, 2956, 241, 23452, 488, 0, 1027, 0, 13068, 0, 0, 0, 0, 0,
    1215, 0, 13158, 1038, 18469, 1483, 25153, 17739, 12530, 24406, 27046,
    26299, 12518, 23144, 7781, 186, 20440, 27359, 1231, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2972, 13174, 7797, 2988,
    13190, 7813, 3004, 13206, 7829, 3020, 13222, 7845, 3036, 13238, 7861, 3052,
    13254, 7877, 3068, 13270, 7893, 3084, 13286, 7909, 3100, 13302, 7925, 3116,
    13318, 7941, 3132, 13334, 7957, 3148, 13350, 7973, 3164, 13366, 7989, 3180,
    13382, 8005, 3196, 13398, 8021, 3212, 13414, 8037, 3228, 13430, 8053, 3244,
    13446, 8069, 3260, 13462, 8085, 3276, 13478, 8101, 3292, 13494, 8117, 3308,
    13510, 8133, 3324, 13526, 8149, 3340, 13542, 8165, 3356, 13558, 8181, 3372,
    13574, 8197, 3388, 13590, 8213, 3404, 13606, 8229, 3420, 13622, 8245, 3436,
    13638, 8261, 3452, 13654, 8277, 3468, 13670, 8293, 3484, 13686, 8309, 3500,
    13702, 8325, 3516, 13718, 8341, 3532, 13734, 8357, 3548, 13750, 8373, 3564,
    13766, 8389, 3580, 13782, 8405, 3596, 13798, 8421, 3612, 13814, 8437, 3628,
    13830, 8453, 3644, 13846, 8469, 3660, 13862, 8485, 3676, 13878, 8501, 3692,
    13894, 8517, 3708, 13910, 8533, 3724, 13926, 8549, 3740, 13942, 8565, 3756,
    13958, 8581, 3772, 13974, 8597, 3788, 13990, 8613, 3804, 14006, 8629, 3820,
    14022, 8645, 3836, 14038, 8661, 3852, 14054, 8677, 3868, 14070, 8693, 3884,
    14086, 8709, 3900, 14102, 8725, 3916, 14118, 8741, 3932, 14134, 8757, 3948,
    14150, 8773, 3964, 14166, 8789, 3980, 14182, 8805, 3996, 14198, 8821, 4012,
    14214, 8837, 4028, 14230, 8853, 4044, 14246, 8869, 4060, 14262, 8885, 4076,
    14278, 8901, 4092, 14294, 8917, 4108, 14310, 8933, 4124, 14326, 8949, 4140,
    14342, 8965, 4156, 14358, 8981, 4172, 14374, 8997, 4188, 14390, 9013, 4204,
    14406, 9029, 4220, 14422, 9045, 4236, 14438, 9061, 4252, 14454, 9077, 4268,
    14470, 9093, 4284, 14486, 9109, 4300, 14502, 9125, 4316, 14518, 9141, 4332,
    14534, 9157, 4348, 14550, 9173, 4364, 14566, 9189, 4380, 14582, 9205, 4396,
    14598, 9221, 4412, 14614, 9237, 4428, 14630, 9253, 4444, 14646, 9269, 4460,
    14662, 9285, 4476, 14678, 9301, 4492, 14694, 9317, 4508, 14710, 9333, 4524,
    14726, 9349, 4540, 14742, 9365, 4556, 14758, 9381, 4572, 14774, 9397, 4588,
    14790, 9413, 4604, 14806, 9429, 4620, 14822, 9445, 4636, 14838, 9461, 4652,
    14854, 9477, 4668, 14870, 9493, 4684, 14886, 9509, 4700, 14902, 9525, 4716,
    14918, 9541, 4732, 14934, 9557, 4748, 14950, 9573, 4764, 14966, 9589, 4780,
    14982, 9605, 4796, 14998, 9621, 4812, 15014, 9637, 4828, 15030, 9653, 4844,
    15046, 9669, 4860, 15062, 9685, 4876, 15078, 9701, 4892, 15094, 9717, 4908,
    15110, 9733, 4924, 15126, 9749, 4940, 15142, 9765, 4956, 15158, 9781, 4972,
    15174, 9797, 4988, 15190, 9813, 5004, 15206, 9829, 5020, 15222, 9845, 5036,
    15238, 9861, 5052, 15254, 9877, 5068, 15270, 9893, 5084, 15286, 9909, 5100,
    15302, 9925, 5116, 15318, 9941, 5132, 15334, 9957, 5148, 15350, 9973, 5164,
    15366, 9989, 5180, 15382, 10005, 5196, 15398, 10021, 5212, 15414, 10037,
    5228, 15430, 10053, 5244, 15446, 10069, 5260, 15462, 10085, 5276, 15478,
    10101, 5292, 15494, 10117, 5308, 15510, 10133, 5324, 15526, 10149, 5340,
    15542, 10165, 5356, 15558, 10181, 5372, 15574, 10197, 5388, 15590, 10213,
    5404, 15606, 10229, 5420, 15622, 10245, 5436, 15638, 10261, 5452, 15654,
    10277, 5468, 15670, 10293, 5484, 15686, 10309, 5500, 15702, 10325, 5516,
    15718, 10341, 5532, 15734, 10357, 5548, 15750, 10373, 5564, 15766, 10389,
    5580, 15782, 10405, 5596, 15798, 10421, 5612, 15814, 10437, 5628, 15830,
    10453, 5644, 15846, 10469, 5660, 15862, 10485, 5676, 15878, 10501, 5692,
    15894, 10517, 5708, 15910, 10533, 5724, 15926, 10549, 5740, 15942, 10565,
    5756, 15958, 10581, 5772, 15974, 10597, 5788, 15990, 10613, 5804, 16006,
    10629, 5820, 16022, 10645, 5836, 16038, 10661, 5852, 16054, 10677, 5868,
    16070, 10693, 5884, 16086, 10709, 5900, 16102, 10725, 5916, 16118, 10741,
    5932, 16134, 10757, 5948, 16150, 10773, 5964, 16166, 10789, 5980, 16182,
    10805, 5996, 16198, 10821, 6012, 16214, 10837, 6028, 16230, 10853, 6044,
    16246, 10869, 6060, 16262, 10885, 6076, 16278, 10901, 6092, 16294, 10917,
    6108, 16310, 10933, 6124, 16326, 10949, 6140, 16342, 10965, 6156, 16358,
    10981, 6172, 16374, 10997, 6188, 16390, 11013, 6204, 16406, 11029, 6220,
    16422, 11045, 6236, 16438, 11061, 6252, 16454, 11077, 6268, 16470, 11093,
    6284, 16486, 11109, 6300, 16502, 11125, 6316, 16518, 11141, 6332, 16534,
    11157, 6348, 16550, 11173, 6364, 16566, 11189, 6380, 16582, 11205, 6396,
    16598, 11221, 6412, 16614, 11237, 6428, 16630, 11253, 6444, 16646, 11269,
    6460, 16662, 11285, 6476, 16678, 11301, 6492, 16694, 11317, 6508, 16710,
    11333, 6524, 16726, 11349, 6540, 16742, 11365, 6556, 16758, 11381, 6572,
    16774, 11397, 6588, 16790, 11413, 6604, 16806, 11429, 6620, 16822, 11445,
    6636, 16838, 11461, 6652, 16854, 11477, 6668, 16870, 11493, 6684, 16886,
    6700, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11509, 16902, 11525, 16918, 11541, 16934,
    11557, 16950, 11573, 16966, 11589, 16982, 11605, 16998, 11621, 17014,
    11637, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 27736, 17030, 27752, 17046, 27768, 16, 0, 0, 0, 0, 0, 0,
    0, 0, 17062,
]; // 4095 entries

#[cfg(feature = "no-optimized-legacy-encoding")]
const BACKWARD_SEARCH_LOWER: &'static [(u16, u16)] = &[
    (3011, 3173), (3666, 3848), (3108, 3472), (4042, 4123), (3012, 3172),
    (3384, 3409), (3575, 3854), (3018, 3135), (3066, 3146), (3478, 3845),
    (3053, 3163), (3008, 3083), (3290, 3384), (3854, 4034), (3163, 3170),
    (3572, 3804), (6486, 6488), (39294, 20355), (39318, 20075), (6610, 6612),
    (6654, 6667), (6713, 6715), (39526, 20418), (6841, 6858), (6895, 6925),
    (6949, 6954), (7098, 7125), (39956, 20342), (40017, 20035), (7332, 7335),
    (40158, 20195), (7469, 7472), (40302, 20098), (7565, 7586), (7634, 7653),
    (40466, 20102), (7741, 7762), (40587, 19975), (40613, 20129),
    (40681, 20398), (40822, 20276), (8119, 8157), (8193, 8264), (8325, 8336),
    (8396, 8404), (8472, 8490), (41346, 20185), (41421, 19990), (41467, 20439),
    (41498, 20462), (8845, 8856), (8898, 8901), (8936, 8943), (41767, 20208),
    (41796, 20063), (41817, 20335), (9102, 9113), (41903, 20134),
    (42028, 20034), (9284, 9287), (42188, 20433), (9444, 9446), (9485, 9501),
    (42301, 20301), (9558, 9560), (9651, 9687), (9730, 9732), (9754, 9784),
    (42577, 20316), (9834, 9836), (9892, 9894), (9945, 9947), (10006, 10009),
    (42852, 20430), (10156, 10165), (42972, 20426), (10224, 10245),
    (43086, 20356), (10345, 10347), (43222, 20191), (43316, 20419),
    (43363, 19985), (10638, 10644), (10671, 10688), (10814, 10831),
    (43624, 20296), (43658, 20469), (10928, 10932), (10984, 11002),
    (43794, 20139), (43818, 20436), (11076, 11089), (11117, 11119),
    (43968, 20024), (44052, 20399), (44091, 20241), (6488, 6490), (6612, 6614),
    (6637, 6681), (6707, 6718), (6842, 6844), (6875, 6926), (39722, 20855),
    (39793, 20518), (7075, 7083), (7120, 7127), (39962, 20794), (40019, 20839),
    (40177, 20498), (7472, 7489), (7569, 7587), (40390, 20925), (7690, 7700),
    (7738, 7756), (7882, 7915), (40753, 20497), (8090, 8092), (40886, 20493),
    (8160, 8196), (40995, 20693), (41032, 20613), (41104, 20633),
    (41172, 20735), (41228, 20632), (8490, 8493), (8579, 8581), (41615, 20711),
    (41711, 20818), (9029, 9031), (9089, 9111), (42029, 20522), (42055, 20658),
    (42093, 20800), (9367, 9380), (9421, 9423), (9446, 9448), (42271, 20803),
    (9534, 9536), (9560, 9562), (42390, 20801), (9661, 9668), (42542, 20837),
    (9871, 9895), (9947, 9950), (10009, 10011), (10085, 10087), (42907, 20519),
    (42933, 20570), (10205, 10207), (43115, 20511), (10387, 10440),
    (10473, 10484), (43337, 20652), (10610, 10614), (10637, 10645),
    (43469, 20524), (10741, 10778), (10811, 10832), (43733, 20989),
    (11002, 11022), (11089, 11109), (43990, 20976), (44053, 20505),
    (11331, 11355), (6490, 6492), (6515, 6528), (6560, 6587), (39406, 21435),
    (6671, 6678), (6718, 6721), (6782, 6784), (39612, 21151), (6891, 6909),
    (6955, 6959), (7026, 7085), (39881, 21450), (39996, 21335), (40034, 21162),
    (40096, 21311), (7410, 7412), (40242, 21205), (7535, 7543), (7587, 7625),
    (40425, 21214), (40492, 21129), (7752, 7764), (40588, 21325),
    (40654, 21193), (40683, 21215), (7949, 7962), (7986, 7998), (8035, 8058),
    (40847, 21187), (8172, 8190), (8228, 8230), (8265, 8267), (8304, 8306),
    (8337, 8340), (8405, 8407), (8456, 8462), (8610, 8624), (8654, 8663),
    (8723, 8732), (41559, 21460), (8848, 8857), (41705, 21313), (9006, 9018),
    (41969, 21421), (9263, 9265), (42056, 21320), (42191, 21191), (9448, 9451),
    (42244, 21206), (42272, 21407), (42304, 21361), (9732, 9734), (9775, 9785),
    (42578, 21242), (42604, 21280), (42688, 21219), (9950, 9952), (9986, 9995),
    (10061, 10063), (42855, 21161), (42904, 21330), (10228, 10246),
    (43087, 21489), (43116, 21449), (10382, 10400), (10441, 10456),
    (10512, 10523), (43326, 21474), (10623, 10640), (10667, 10669),
    (43470, 21331), (43510, 21488), (10802, 10813), (10857, 10860),
    (43659, 21117), (10918, 10933), (43731, 21106), (43787, 21182),
    (11077, 11091), (43948, 21270), (11246, 11313), (44101, 21256),
    (6492, 6518), (39319, 21917), (39398, 21888), (6759, 6786), (39589, 21741),
    (6926, 6928), (39727, 21646), (39777, 21531), (39895, 21980), (7189, 7194),
    (7335, 7380), (40243, 21516), (40283, 21895), (40356, 21570), (7764, 7788),
    (40606, 21788), (7898, 7900), (7987, 8001), (8267, 8269), (41074, 21545),
    (8407, 8409), (8493, 8524), (41349, 21892), (41500, 22013), (41669, 21627),
    (41712, 21854), (8987, 9008), (9289, 9292), (42273, 21729), (9563, 9565),
    (42420, 21535), (42503, 21693), (42553, 21672), (9872, 9922),
    (42779, 21576), (42831, 21884), (10168, 10171), (43014, 21675),
    (10283, 10285), (43117, 21983), (43168, 21809), (10456, 10476),
    (43291, 21736), (10624, 10646), (10688, 10718), (43529, 21520),
    (43583, 21764), (10846, 10862), (43672, 21697), (10966, 11028),
    (43887, 21628), (11170, 11202), (11271, 11356), (39262, 22025),
    (39329, 22350), (39400, 22353), (39489, 22384), (39554, 22266),
    (6828, 6830), (6960, 6963), (7003, 7069), (7128, 7132), (40010, 22218),
    (7336, 7413), (40404, 22265), (40625, 22475), (8092, 8122), (41037, 22496),
    (41075, 22132), (8378, 8410), (41263, 22039), (8635, 8664), (8733, 8735),
    (8857, 8884), (41776, 22467), (9079, 9149), (42192, 22471), (9506, 9538),
    (42412, 22432), (42504, 22240), (42579, 22204), (42641, 22312),
    (42856, 22066), (42925, 22352), (42975, 22472), (10247, 10249),
    (43104, 22519), (43188, 22512), (43317, 22225), (43393, 22068),
    (10704, 10720), (10762, 10804), (10841, 10863), (11004, 11036),
    (43859, 22411), (11247, 11273), (11356, 11358), (6528, 6531), (6562, 6615),
    (39458, 22533), (39490, 22659), (6760, 6788), (6898, 6915), (39783, 22528),
    (39822, 22862), (39867, 22935), (7132, 7135), (7252, 7269), (7330, 7338),
    (7380, 7415), (40227, 22697), (7683, 7712), (7846, 7859), (40684, 22982),
    (7946, 7952), (40751, 22696), (40861, 22952), (40941, 22721), (8211, 8213),
    (8246, 8271), (8308, 8311), (41108, 22915), (8410, 8412), (8520, 8535),
    (8563, 8565), (8636, 8665), (41503, 22781), (8792, 8794), (41626, 22987),
    (41690, 22833), (41727, 22538), (8995, 9001), (9031, 9053), (9095, 9117),
    (9149, 9151), (41990, 22603), (9292, 9295), (42094, 22725), (9371, 9384),
    (42193, 22665), (42306, 22996), (9615, 9624), (9689, 9691), (9737, 9788),
    (9837, 9841), (42664, 22992), (9952, 9955), (42780, 22979), (42832, 22564),
    (10166, 10172), (43001, 22686), (43053, 22645), (43088, 23018),
    (43157, 22649), (10436, 10458), (10493, 10495), (10559, 10573),
    (10690, 10692), (10727, 10744), (10771, 10780), (10933, 10945),
    (10986, 11006), (11036, 11047), (43846, 22846), (11120, 11123),
    (43970, 22864), (11299, 11301), (44126, 23020), (6495, 6497),
    (39399, 23458), (6762, 6789), (6845, 6878), (6920, 6929), (39731, 23495),
    (39787, 23470), (39903, 23492), (39965, 23068), (7243, 7266),
    (40081, 23273), (40174, 23429), (7700, 7713), (7813, 7822), (7859, 7877),
    (40769, 23194), (40800, 23494), (8213, 8231), (8271, 8275), (41109, 23138),
    (41147, 23338), (8412, 8415), (41264, 23360), (8582, 8584), (41405, 23468),
    (41433, 23477), (8708, 8738), (8794, 8796), (8859, 8946), (41741, 23433),
    (41821, 23363), (41868, 23420), (9151, 9153), (9295, 9297), (9343, 9385),
    (9426, 9453), (9509, 9512), (9539, 9567), (42436, 23452), (42506, 23493),
    (9781, 9791), (42590, 23409), (42642, 23472), (9922, 9924), (42781, 23450),
    (10134, 10141), (42940, 23449), (42976, 23535), (43089, 23241),
    (10383, 10423), (10554, 10561), (43394, 23094), (43443, 23522),
    (43504, 23445), (43555, 23110), (43615, 23318), (10945, 10950),
    (10987, 11008), (11071, 11076), (11161, 11204), (11268, 11274),
    (44127, 23305), (6563, 6591), (6639, 6658), (6763, 6790), (6830, 6847),
    (6929, 6931), (39732, 23943), (7004, 7017), (7136, 7139), (7304, 7327),
    (7394, 7419), (7499, 7507), (7544, 7567), (7638, 7640), (40481, 23650),
    (7743, 7767), (40590, 24018), (40730, 24043), (8002, 8020), (40862, 23592),
    (40964, 23643), (8247, 8250), (41097, 23849), (8415, 8417), (41230, 23665),
    (8497, 8499), (41303, 23996), (41379, 23633), (8666, 8669), (8700, 8710),
    (8738, 8740), (41571, 24033), (8834, 8863), (8927, 9010), (41876, 23978),
    (41993, 23992), (42082, 23627), (9372, 9388), (42221, 23588),
    (42308, 23561), (42392, 23609), (42460, 24050), (9827, 9842), (9955, 9957),
    (42763, 23742), (10135, 10174), (42977, 23803), (10350, 10352),
    (10442, 10485), (43338, 23828), (10627, 10647), (43556, 24052),
    (43756, 24055), (11051, 11080), (43891, 23733), (44110, 23673),
    (6531, 6533), (6591, 6594), (39426, 24314), (6723, 6725), (39558, 24235),
    (39638, 24275), (39667, 24291), (39733, 24272), (39788, 24339),
    (7139, 7141), (7257, 7270), (40106, 24406), (7382, 7421), (40273, 24471),
    (7557, 7568), (40357, 24300), (40396, 24265), (7684, 7702), (40515, 24459),
    (7814, 7824), (7847, 7849), (40685, 24125), (40720, 24287), (8004, 8006),
    (8095, 8097), (8122, 8162), (8184, 8198), (40999, 24489), (41043, 24220),
    (8311, 8343), (41148, 24428), (8417, 8419), (8499, 8503), (8536, 8539),
    (41333, 24109), (41508, 24101), (8804, 8806), (8863, 8865), (41653, 24335),
    (41696, 24515), (41730, 24132), (41758, 24245), (41807, 24369),
    (9080, 9097), (9138, 9155), (41994, 24433), (42130, 24448), (42195, 24248),
    (42245, 24423), (9567, 9570), (9693, 9695), (9739, 9741), (9842, 9845),
    (42665, 24213), (42725, 24283), (9996, 10018), (10065, 10067),
    (10089, 10091), (10141, 10175), (43017, 24535), (10322, 10343),
    (10402, 10424), (10476, 10504), (43323, 24534), (43382, 24544),
    (43415, 24159), (43454, 24555), (10720, 10738), (10825, 10864),
    (10884, 10935), (43790, 24184), (43820, 24358), (11092, 11125),
    (11167, 11172), (11204, 11225), (11248, 11250), (11291, 11293),
    (11315, 11317), (44128, 24076), (6518, 6534), (6564, 6566), (6594, 6618),
    (6659, 6682), (6708, 6727), (39532, 24760), (6847, 6849), (6878, 6893),
    (6915, 6917), (39734, 25084), (39853, 25027), (39882, 24613),
    (39966, 25062), (7261, 7271), (40066, 24817), (40127, 25018), (7408, 7422),
    (7460, 7477), (40284, 25078), (7590, 7611), (40408, 24604), (7748, 7768),
    (40592, 24930), (40686, 24917), (7963, 7965), (8020, 8023), (41080, 24996),
    (8343, 8345), (41160, 24977), (41187, 24605), (41271, 24819),
    (41307, 24661), (41334, 24796), (8638, 8640), (41484, 24730),
    (41509, 24833), (41574, 24642), (8865, 8926), (8963, 8965), (9001, 9011),
    (41800, 24825), (41822, 24665), (41858, 25014), (41962, 24709),
    (9297, 9300), (9414, 9429), (9454, 9456), (9512, 9514), (42309, 24944),
    (9570, 9574), (9645, 9671), (42463, 24609), (42535, 24641), (9791, 9793),
    (42726, 24731), (42786, 24773), (42835, 24716), (10142, 10144),
    (43002, 24974), (43111, 25074), (10390, 10405), (10437, 10444),
    (43292, 24980), (10561, 10563), (10619, 10649), (43460, 24816),
    (43489, 24986), (10744, 10784), (10816, 10830), (43632, 24598),
    (43661, 24915), (10950, 10952), (10989, 11009), (11039, 11054),
    (11110, 11112), (11158, 11169), (11205, 11229), (11250, 11253),
    (11328, 11363), (39302, 25536), (39334, 25121), (6641, 6643), (6682, 6702),
    (39533, 25106), (39559, 25335), (6849, 6860), (6893, 6918), (39735, 25304),
    (7017, 7032), (39823, 25542), (39846, 25119), (39883, 25201),
    (39909, 25216), (7190, 7202), (7226, 7228), (7262, 7264), (7383, 7399),
    (7422, 7424), (7554, 7612), (40507, 25134), (7825, 7840), (7953, 7967),
    (8037, 8098), (8123, 8125), (41018, 25447), (41045, 25206), (8313, 8347),
    (41188, 25448), (41253, 25591), (8540, 8542), (41352, 25159),
    (41408, 25104), (8669, 8671), (8742, 8745), (8830, 8851), (41655, 25325),
    (8947, 8997), (9018, 9034), (41823, 25562), (9091, 9107), (9157, 9159),
    (42156, 25303), (42282, 25588), (42342, 25540), (9639, 9659),
    (42613, 25484), (42643, 25165), (42666, 25269), (42727, 25136),
    (9987, 10020), (42836, 25552), (42859, 25514), (42905, 25305),
    (42928, 25387), (10236, 10252), (43054, 25391), (43128, 25417),
    (10424, 10446), (43264, 25463), (10525, 10527), (10573, 10575),
    (10693, 10707), (43497, 25506), (10780, 10790), (10813, 10833),
    (10865, 10868), (43680, 25259), (43758, 25239), (43848, 25406),
    (11125, 11127), (43927, 25110), (43974, 25563), (44085, 25582),
    (44131, 25137), (39335, 25954), (6618, 6645), (39451, 25802), (6727, 6729),
    (6792, 6795), (39590, 26011), (39619, 25915), (6931, 6933), (39736, 25937),
    (7086, 7101), (7142, 7144), (40026, 25754), (7339, 7425), (7461, 7463),
    (40257, 26007), (7545, 7547), (7592, 7630), (7659, 7661), (7702, 7726),
    (40573, 25705), (7919, 7921), (7967, 7990), (8023, 8101), (40942, 25816),
    (8278, 8280), (41115, 26000), (41149, 25996), (8421, 8423), (8463, 8474),
    (41310, 25933), (8585, 8587), (41399, 25885), (41439, 25620),
    (41478, 25613), (8745, 8748), (41575, 26092), (41634, 26045),
    (41673, 26032), (41751, 26017), (9056, 9082), (9300, 9302), (42095, 25793),
    (42131, 26106), (9389, 9392), (9456, 9479), (42343, 25912), (42439, 25836),
    (42526, 26085), (42580, 26027), (9924, 9926), (10004, 10023),
    (10092, 10094), (42898, 26063), (10252, 10255), (43055, 25634),
    (43101, 26015), (10361, 10406), (10446, 10478), (10563, 10569),
    (43476, 25826), (10734, 10760), (10790, 10792), (43585, 25943),
    (43619, 25987), (43720, 26097), (11195, 11197), (11274, 11276),
    (44092, 25658), (6497, 6501), (6535, 6569), (39436, 26480), (6729, 6732),
    (6795, 6797), (6823, 6832), (39628, 26524), (39668, 26336), (6969, 6971),
    (7040, 7048), (39869, 26129), (7144, 7147), (7219, 7231), (40021, 26608),
    (40083, 26491), (40129, 26311), (7463, 7492), (40326, 26391),
    (40372, 26310), (40453, 26407), (40494, 26611), (40536, 26446),
    (40564, 26519), (7826, 7863), (7900, 7902), (7921, 7956), (40774, 26410),
    (40808, 26420), (8101, 8103), (8125, 8142), (8198, 8215), (8232, 8244),
    (8314, 8331), (41116, 26503), (8423, 8425), (41226, 26388), (41247, 26441),
    (8543, 8546), (8567, 8570), (8624, 8643), (41440, 26157), (8701, 8718),
    (8851, 8871), (41674, 26216), (8976, 9012), (41826, 26264), (41907, 26131),
    (9205, 9230), (42033, 26355), (42070, 26212), (9361, 9365), (42161, 26332),
    (42247, 26161), (9530, 9543), (9576, 9580), (9813, 9829), (9846, 9848),
    (42644, 26448), (42667, 26485), (10023, 10026), (10094, 10098),
    (10175, 10178), (42978, 26201), (43003, 26366), (10255, 10258),
    (10288, 10290), (43102, 26389), (43153, 26413), (10406, 10409),
    (43200, 26613), (10504, 10514), (10556, 10572), (10607, 10612),
    (10672, 10677), (10695, 10711), (10792, 10805), (43611, 26544),
    (10885, 10895), (43703, 26160), (43759, 26477), (43791, 26447),
    (43822, 26203), (11112, 11129), (43930, 26127), (43976, 26213),
    (11229, 11231), (11253, 11255), (44044, 26313), (11293, 11319),
    (44105, 26133), (11364, 11366), (39305, 26751), (39387, 27114),
    (6660, 6685), (39500, 26775), (6766, 6834), (6871, 6880), (6918, 6934),
    (39739, 27083), (7056, 7089), (7147, 7149), (39959, 26708), (39999, 26976),
    (40153, 26848), (7425, 7427), (7478, 7480), (40344, 26753), (7727, 7770),
    (7863, 7903), (40737, 26969), (8007, 8009), (40830, 27075), (40871, 27036),
    (8142, 8163), (40969, 26821), (41019, 26834), (8331, 8350), (41193, 26797),
    (8480, 8505), (8546, 8548), (41380, 26964), (41441, 26803), (8808, 8810),
    (41656, 26893), (41745, 26696), (9034, 9061), (41877, 26989),
    (41928, 26941), (9230, 9232), (42071, 26791), (9346, 9348), (42197, 27029),
    (42248, 26671), (9581, 9583), (42440, 26885), (42591, 26855), (9877, 9901),
    (42728, 26643), (42794, 26984), (10069, 10101), (42912, 26837),
    (42946, 26666), (42998, 26987), (10290, 10324), (43177, 27085),
    (10527, 10530), (10575, 10577), (43376, 26943), (43417, 26772),
    (43464, 26965), (10735, 10773), (43674, 26963), (10992, 11021),
    (11209, 11232), (44045, 26783), (6501, 6521), (39337, 27204), (6673, 6686),
    (39648, 27454), (39702, 27211), (6972, 6975), (7032, 7103), (7149, 7151),
    (7341, 7343), (7427, 7450), (40275, 27225), (7536, 7548), (7577, 7631),
    (40429, 27347), (40482, 27155), (40632, 27599), (7923, 7972),
    (40809, 27192), (40915, 27146), (40943, 27287), (40983, 27493),
    (8350, 8354), (8382, 8384), (41194, 27515), (41242, 27578), (41273, 27233),
    (41393, 27570), (41423, 27506), (8748, 8750), (8810, 8812), (41657, 27542),
    (41734, 27138), (9003, 9025), (41829, 27171), (9092, 9120), (9369, 9416),
    (9487, 9489), (42385, 27603), (9647, 9674), (9824, 9851), (42669, 27159),
    (42729, 27583), (10027, 10029), (10211, 10230), (43026, 27490),
    (43060, 27524), (10352, 10354), (43298, 27189), (43345, 27166),
    (10722, 10747), (43663, 27161), (43738, 27323), (11040, 11044),
    (43897, 27627), (11183, 11208), (11255, 11270), (11314, 11348),
    (39363, 27743), (39470, 27770), (39501, 28039), (39566, 27837),
    (39606, 27752), (39669, 27960), (39743, 27714), (39801, 28099),
    (39884, 27762), (7151, 7155), (40095, 27877), (7362, 7375), (40196, 28120),
    (7464, 7481), (40293, 27931), (40327, 28010), (40393, 27916), (7715, 7745),
    (40538, 28012), (40565, 28107), (40609, 27819), (7877, 7889), (7938, 7946),
    (7990, 7999), (8026, 8064), (8163, 8170), (40984, 27921), (41048, 28014),
    (41083, 27774), (41122, 27832), (8384, 8394), (8427, 8429), (41232, 27733),
    (8570, 8572), (8613, 8633), (8656, 8676), (8702, 8719), (8750, 8752),
    (8796, 8814), (8929, 8941), (9012, 9021), (41830, 27915), (9107, 9121),
    (9161, 9166), (41963, 28037), (9232, 9234), (42034, 27757), (9304, 9316),
    (9348, 9366), (9416, 9431), (9515, 9517), (9583, 9585), (9653, 9660),
    (42670, 27822), (42730, 27656), (42757, 27993), (10029, 10032),
    (42913, 28121), (10179, 10181), (10212, 10232), (10259, 10261),
    (43061, 27941), (10460, 10462), (10485, 10515), (43383, 27798),
    (10650, 10652), (10677, 10679), (10747, 10749), (10793, 10795),
    (10818, 10820), (10869, 10871), (10921, 11011), (43823, 27883),
    (11081, 11094), (11130, 11132), (11163, 11175), (11217, 11233),
    (44024, 28142), (11278, 11280), (11334, 11351), (6538, 6571),
    (39388, 28433), (39413, 28192), (6686, 6704), (39537, 28330),
    (39602, 28414), (39744, 28317), (39810, 28528), (40000, 28275),
    (40061, 28611), (7329, 7366), (7429, 7432), (40249, 28540), (40316, 28651),
    (7594, 7663), (7716, 7730), (40556, 28542), (7815, 7830), (7895, 7904),
    (40724, 28218), (8009, 8011), (8064, 8127), (8217, 8219), (41049, 28325),
    (41153, 28657), (41197, 28195), (8481, 8507), (8572, 8588), (41383, 28203),
    (41444, 28335), (41520, 28465), (41565, 28506), (41608, 28629),
    (41658, 28252), (41735, 28197), (41850, 28417), (41934, 28436),
    (9234, 9237), (42035, 28618), (9305, 9336), (9431, 9433), (42257, 28560),
    (9517, 9519), (42311, 28205), (9586, 9589), (42395, 28516), (9741, 9760),
    (42561, 28363), (9825, 9852), (9879, 9927), (42731, 28593), (42765, 28472),
    (10032, 10034), (42838, 28639), (10101, 10103), (10181, 10183),
    (10213, 10215), (43029, 28460), (43062, 28337), (10337, 10345),
    (43136, 28591), (10410, 10412), (43216, 28364), (43246, 28552),
    (43283, 28399), (43346, 28267), (43409, 28204), (43441, 28422),
    (10711, 10713), (10738, 10758), (43594, 28558), (43664, 28418),
    (10954, 10956), (43762, 28207), (43862, 28366), (11132, 11137),
    (43932, 28222), (11210, 11258), (39414, 28844), (6734, 6736), (6881, 6903),
    (39745, 28792), (39989, 29014), (7432, 7467), (7508, 7539), (7606, 7627),
    (7663, 7704), (40498, 28687), (40557, 29136), (40598, 28771),
    (40633, 29028), (40740, 28961), (8127, 8150), (40970, 28851), (8252, 8254),
    (41084, 28954), (41154, 28693), (41198, 28681), (41243, 29022),
    (41356, 29053), (41401, 29166), (8677, 8680), (41493, 28753),
    (41521, 29159), (41566, 29087), (8891, 8933), (9063, 9065), (41865, 28937),
    (9168, 9241), (9306, 9308), (42165, 29183), (42201, 29076), (9481, 9502),
    (42408, 28700), (42492, 28727), (9794, 9816), (42649, 28797),
    (42732, 29006), (42766, 28857), (10034, 10036), (10103, 10105),
    (42951, 28855), (10215, 10238), (43137, 29158), (10531, 10551),
    (10628, 10653), (10723, 10725), (43595, 28921), (43655, 28689),
    (43724, 28698), (43779, 28707), (43824, 28843), (11095, 11099),
    (43905, 28765), (11175, 11185), (11211, 11259), (11294, 11340),
    (11366, 11369), (6502, 6522), (6691, 6693), (39620, 29657), (6903, 6905),
    (39703, 29409), (6978, 6980), (7036, 7058), (39923, 29592), (40122, 29562),
    (40168, 29619), (7451, 7454), (7527, 7561), (7633, 7665), (40460, 29282),
    (7771, 7773), (40646, 29467), (7926, 7974), (40767, 29289), (8028, 8066),
    (40934, 29359), (40987, 29668), (41050, 29238), (8387, 8389),
    (41199, 29509), (41233, 29642), (8507, 8549), (8643, 8645), (41482, 29575),
    (8754, 8756), (41582, 29667), (41639, 29468), (41716, 29273),
    (41765, 29390), (41803, 29242), (42009, 29552), (42036, 29450),
    (9308, 9318), (9349, 9375), (9457, 9459), (9519, 9521), (42312, 29234),
    (9589, 9591), (42396, 29607), (9700, 9702), (9796, 9817), (9852, 9855),
    (9888, 9928), (10036, 10038), (42873, 29226), (42906, 29469),
    (42952, 29664), (43063, 29645), (43180, 29462), (43230, 29588),
    (43265, 29266), (10784, 10834), (43656, 29190), (43690, 29644),
    (11029, 11100), (43906, 29392), (43987, 29502), (11259, 11296),
    (44137, 29351), (39271, 30146), (6571, 6598), (39389, 30117),
    (39461, 29956), (6736, 6740), (39538, 30028), (39567, 30204),
    (39603, 29736), (6861, 6884), (39748, 29699), (7069, 7104), (7156, 7162),
    (40002, 30007), (40042, 29785), (7355, 7387), (7482, 7493), (7561, 7572),
    (40383, 29833), (40455, 29903), (7731, 7734), (7773, 7808), (40696, 29761),
    (40742, 30045), (8044, 8067), (8150, 8177), (8203, 8221), (41022, 29739),
    (8356, 8358), (8466, 8468), (8521, 8550), (8589, 8593), (8680, 8683),
    (8756, 8758), (8799, 8801), (41605, 29791), (41676, 30003), (41701, 29978),
    (41833, 30162), (9122, 9143), (41977, 29744), (9243, 9246), (9320, 9352),
    (9375, 9399), (9434, 9437), (42227, 29760), (42289, 29783), (42313, 29771),
    (9592, 9594), (42442, 30097), (9703, 9705), (9797, 9799), (42623, 29835),
    (42674, 30141), (9965, 9969), (42806, 30010), (42874, 29866),
    (42914, 29742), (42953, 30087), (10216, 10240), (10296, 10300),
    (10324, 10326), (10370, 10372), (10487, 10499), (10596, 10610),
    (10653, 10655), (43447, 29723), (10713, 10715), (43535, 30171),
    (10796, 10807), (43639, 30129), (10897, 10938), (43868, 29801),
    (11139, 11142), (11165, 11186), (43980, 29872), (44005, 29852),
    (11326, 11341), (6539, 6575), (6622, 6624), (39442, 30652), (6771, 6802),
    (6936, 6938), (6981, 6983), (39802, 30519), (39889, 30684), (40112, 30701),
    (7433, 7519), (40433, 30439), (7704, 7735), (40599, 30622), (7879, 7942),
    (40779, 30473), (8067, 8085), (8128, 8191), (41085, 30406), (41278, 30456),
    (8573, 8594), (8645, 8647), (41451, 30233), (8758, 8760), (8815, 8817),
    (41640, 30690), (8978, 8993), (9066, 9084), (9246, 9270), (9321, 9331),
    (42138, 30702), (42228, 30402), (42363, 30290), (42443, 30691),
    (42493, 30410), (42594, 30430), (42697, 30340), (9969, 9991),
    (42807, 30555), (42875, 30522), (10262, 10303), (43130, 30528),
    (43181, 30241), (43217, 30240), (10488, 10500), (10551, 10580),
    (43423, 30305), (43498, 30472), (43682, 30382), (43747, 30418),
    (11060, 11062), (43910, 30355), (44006, 30343), (6541, 6555),
    (39415, 31067), (6740, 6773), (39630, 31185), (39826, 30789), (7104, 7106),
    (7162, 7168), (40027, 31178), (7435, 7456), (7595, 7608), (7654, 7694),
    (40503, 30827), (7801, 7810), (8070, 8106), (8178, 8234), (8332, 8362),
    (8432, 8437), (41279, 31077), (8574, 8595), (8726, 8761), (41641, 31034),
    (41677, 31070), (9004, 9014), (9067, 9085), (41891, 30998), (9175, 9177),
    (42120, 30871), (9461, 9464), (42474, 31227), (42567, 30913),
    (10040, 10072), (10108, 10111), (10263, 10266), (10303, 10355),
    (43193, 30758), (10533, 10537), (10580, 10598), (10680, 10685),
    (43565, 30772), (10872, 10899), (43911, 31068), (11186, 11199),
    (44138, 31143), (39272, 31292), (6542, 6556), (39392, 31623),
    (39477, 31645), (6742, 6744), (39541, 31293), (6802, 6826), (39621, 31354),
    (6884, 6906), (39751, 31350), (7010, 7023), (7059, 7091), (39936, 31637),
    (40113, 31471), (40144, 31572), (7436, 7511), (40410, 31533),
    (40525, 31260), (7802, 7804), (7942, 7959), (40813, 31636), (8157, 8168),
    (40974, 31453), (41051, 31526), (41205, 31721), (41236, 31639),
    (8512, 8551), (8647, 8659), (8684, 8686), (8761, 8763), (41585, 31565),
    (41660, 31698), (41836, 31344), (41946, 31605), (9247, 9271), (9309, 9339),
    (9400, 9402), (42250, 31286), (42538, 31252), (42598, 31668),
    (42624, 31456), (9889, 9908), (9930, 9932), (9970, 9993), (10042, 10044),
    (42840, 31532), (10111, 10113), (42915, 31278), (10202, 10218),
    (10279, 10281), (43095, 31378), (10355, 10434), (43231, 31359),
    (43305, 31245), (10598, 10601), (10656, 10658), (43453, 31281),
    (10749, 10769), (10822, 10835), (10905, 10926), (43840, 31348),
    (43937, 31503), (43967, 31339), (44007, 31681), (44139, 31232),
    (39312, 31777), (6575, 6601), (39402, 31923), (6694, 6705), (6744, 6746),
    (39542, 31995), (6921, 6939), (39752, 32127), (39829, 31998), (7117, 7119),
    (7169, 7188), (40006, 32013), (40084, 32016), (7346, 7348), (40155, 31958),
    (7528, 7550), (7578, 7581), (7616, 7633), (7677, 7689), (7718, 7805),
    (40618, 32178), (7891, 7893), (7991, 8047), (40841, 32070), (40874, 32033),
    (41052, 31807), (8318, 8321), (8362, 8364), (8438, 8440), (8526, 8553),
    (41363, 32218), (41427, 32048), (8686, 8704), (8763, 8766), (41586, 32020),
    (41678, 32051), (41810, 32004), (41947, 32227), (42121, 32233),
    (42232, 32006), (42314, 32239), (42366, 32173), (42409, 32104),
    (42512, 32106), (9800, 9858), (9908, 9933), (9993, 10000), (10044, 10046),
    (10113, 10150), (10186, 10204), (43034, 32025), (43106, 32221),
    (10373, 10387), (43194, 32181), (10479, 10517), (10658, 10660),
    (43493, 32187), (43537, 32113), (43603, 32232), (43740, 32216),
    (11062, 11064), (43912, 31946), (43944, 32005), (43981, 32008),
    (44008, 31783), (44111, 32007), (6601, 6636), (6695, 6706), (6775, 6804),
    (6885, 6940), (39779, 32676), (39939, 32648), (40225, 32411), (7519, 7551),
    (7643, 7645), (40487, 32311), (7778, 7780), (7851, 7867), (40743, 32326),
    (8013, 8048), (8152, 8159), (8255, 8286), (8333, 8365), (41281, 32724),
    (41321, 32626), (8596, 8627), (41472, 32396), (8766, 8768), (8842, 8875),
    (9021, 9026), (41838, 32650), (41911, 32377), (41949, 32303),
    (42016, 32403), (9323, 9355), (9402, 9418), (42233, 32701), (42444, 32681),
    (9726, 9729), (42650, 32289), (9933, 9935), (42742, 32399), (42884, 32368),
    (10150, 10162), (43008, 32338), (10281, 10306), (10374, 10377),
    (43332, 32317), (10601, 10661), (43566, 32631), (43604, 32745),
    (10957, 10959), (43763, 32568), (43832, 32291), (43913, 32286),
    (44028, 32362), (11351, 11373), (6522, 6546), (6583, 6603), (39429, 33137),
    (6687, 6697), (6746, 6749), (6804, 6807), (6906, 6941), (6985, 6987),
    (39890, 32943), (7172, 7175), (40022, 32784), (7296, 7324), (7367, 7369),
    (40169, 33274), (7485, 7501), (40323, 33240), (40385, 32879), (7645, 7707),
    (40521, 32907), (7799, 7817), (40639, 33032), (40699, 32791),
    (40761, 32862), (40816, 33162), (8107, 8131), (41002, 33145), (8286, 8289),
    (8365, 8368), (41162, 32856), (41208, 32902), (41322, 32997), (8598, 8600),
    (8648, 8651), (41536, 33065), (8801, 8839), (8911, 8913), (9022, 9037),
    (41861, 33222), (9339, 9357), (9404, 9406), (42205, 32883), (42259, 32792),
    (42315, 32963), (9599, 9639), (42431, 33210), (9708, 9711), (9801, 9803),
    (9858, 9861), (42841, 33229), (42885, 32903), (10151, 10168),
    (10267, 10283), (10306, 10329), (43183, 33081), (43218, 33034),
    (43274, 32893), (43306, 32918), (43333, 32880), (10620, 10633),
    (43429, 33268), (10728, 10774), (43596, 33192), (10852, 10875),
    (43764, 32923), (11083, 11085), (43914, 32993), (11261, 11282),
    (44103, 33016), (6505, 6507), (6546, 6548), (6603, 6626), (39517, 33686),
    (6807, 6810), (6863, 6887), (6987, 7024), (7071, 7107), (40099, 33590),
    (7494, 7502), (40349, 33391), (40446, 33737), (7759, 7781), (7817, 7855),
    (40674, 33559), (7932, 7934), (7959, 7978), (40817, 33334), (40842, 33324),
    (8109, 8111), (40936, 33539), (8221, 8236), (8289, 8292), (41089, 33452),
    (41136, 33778), (8441, 8443), (41250, 33439), (41295, 33394),
    (41323, 33298), (8600, 8617), (41537, 33585), (8802, 8822), (8913, 8951),
    (8993, 9015), (41811, 33509), (9125, 9128), (9210, 9212), (9251, 9272),
    (42125, 33694), (42206, 33592), (42234, 33419), (42260, 33464),
    (42290, 33489), (42445, 33380), (9711, 9713), (42513, 33589), (9772, 9819),
    (42629, 33674), (9909, 9911), (42703, 33659), (42814, 33351),
    (42958, 33311), (42991, 33537), (10270, 10272), (10416, 10428),
    (43232, 33307), (43275, 33729), (10539, 10542), (43349, 33467),
    (43465, 33333), (43519, 33492), (43567, 33453), (43643, 33502),
    (10926, 10939), (10973, 10998), (43792, 33607), (11065, 11102),
    (43915, 33446), (11188, 11190), (11241, 11263), (44120, 33288),
    (39324, 33883), (6604, 6627), (39578, 34241), (39640, 34303),
    (39709, 34126), (7037, 7063), (40137, 34113), (40205, 33796), (7486, 7569),
    (7596, 7619), (7707, 7721), (40559, 34298), (7832, 7834), (7881, 7908),
    (40716, 33945), (40746, 34154), (40782, 34183), (40818, 34180),
    (40879, 33953), (8153, 8155), (8236, 8257), (8443, 8484), (8556, 8576),
    (41385, 34203), (8689, 8712), (8770, 8773), (8822, 8824), (8875, 8877),
    (8914, 8916), (9044, 9047), (41987, 33865), (42040, 34269), (42207, 33993),
    (9467, 9499), (9548, 9551), (42368, 33848), (9654, 9679), (9804, 9806),
    (9862, 9866), (9911, 9913), (42842, 34234), (42886, 34299), (10232, 10242),
    (43075, 34095), (10418, 10429), (43233, 34214), (10542, 10622),
    (43508, 34153), (10844, 10878), (43881, 34137), (11148, 11150),
    (11304, 11312), (39326, 34638), (39430, 34388), (39622, 34467),
    (39710, 34527), (40116, 34507), (40156, 34739), (7520, 7564), (7667, 7669),
    (40676, 34719), (7994, 8034), (8075, 8113), (40947, 34327), (41025, 34562),
    (41137, 34586), (41212, 34503), (8601, 8628), (41459, 34311),
    (41607, 34664), (8893, 8952), (41869, 34326), (9273, 9342), (42175, 34799),
    (42236, 34398), (42319, 34655), (9642, 9680), (42515, 34451),
    (42773, 34678), (42887, 34468), (42959, 34523), (43040, 34584),
    (43097, 34541), (43206, 34389), (43320, 34560), (43384, 34802),
    (10662, 10684), (10939, 11038), (43870, 34722), (11150, 11178),
    (11242, 11264), (44095, 34407), (6507, 6525), (39325, 35088),
    (39373, 35137), (6688, 6698), (6811, 6837), (39655, 35264), (6990, 7013),
    (7063, 7110), (40009, 34930), (7349, 7371), (40170, 34955), (40206, 35241),
    (7522, 7557), (7597, 7628), (40489, 35128), (7781, 7783), (7834, 7844),
    (7883, 7913), (8131, 8134), (8222, 8239), (41138, 35048), (41213, 35039),
    (8484, 8516), (41325, 35199), (41386, 35131), (41496, 34928),
    (41541, 34966), (8831, 8878), (41720, 34905), (41840, 35140),
    (41951, 34893), (42043, 35028), (9408, 9419), (9523, 9554), (42369, 35029),
    (42448, 34915), (42600, 34870), (9866, 9884), (42843, 35069),
    (10218, 10227), (43076, 34967), (43321, 35320), (10617, 10619),
    (43438, 35242), (43542, 35114), (43591, 35207), (10878, 10916),
    (11013, 11026), (11066, 11104), (39277, 35382), (39316, 35563),
    (39374, 35611), (6698, 6711), (6750, 6779), (39581, 35493), (6864, 6866),
    (39759, 35635), (39811, 35437), (39862, 35641), (7175, 7177),
    (39982, 35582), (40082, 35365), (7371, 7373), (40226, 35712),
    (40280, 35588), (40350, 35538), (40450, 35542), (40504, 35628),
    (7934, 7936), (40747, 35491), (8015, 8035), (8113, 8115), (40953, 35722),
    (40992, 35676), (41060, 35331), (8371, 8373), (8446, 8449), (41284, 35443),
    (41326, 35475), (8603, 8621), (41419, 35488), (8692, 8721), (8774, 8776),
    (8824, 8826), (8878, 8954), (41752, 35585), (9074, 9100), (41912, 35695),
    (9252, 9278), (42079, 35492), (42110, 35355), (42177, 35616),
    (42322, 35586), (9602, 9605), (42416, 35518), (9681, 9683), (9729, 9749),
    (42574, 35566), (9890, 9937), (42743, 35438), (10047, 10077),
    (10120, 10122), (10192, 10194), (43010, 35657), (43041, 35468),
    (43077, 35386), (10377, 10397), (10491, 10518), (43351, 35535),
    (10715, 10727), (43531, 35342), (43613, 35413), (43675, 35575),
    (43715, 35604), (11014, 11039), (11153, 11192), (44032, 35496),
    (11305, 11345), (44141, 35440), (6510, 6512), (39416, 36317),
    (39547, 35903), (6826, 6889), (39760, 36092), (7049, 7065), (7177, 7179),
    (40171, 36024), (7439, 7497), (7669, 7697), (7867, 7873), (40704, 35980),
    (40748, 36031), (40853, 36299), (40902, 36064), (8293, 8323), (8373, 8391),
    (8449, 8451), (8517, 8523), (8604, 8629), (41429, 36016), (41474, 36118),
    (8881, 8883), (42046, 35947), (42126, 35916), (42299, 36234),
    (42398, 36103), (9715, 9717), (42541, 36035), (42575, 36039), (9867, 9940),
    (42817, 35998), (10122, 10133), (42962, 36208), (10243, 10277),
    (10310, 10332), (43146, 36106), (43202, 36012), (43234, 36068),
    (43269, 36028), (10543, 10545), (43352, 36264), (10622, 10634),
    (10732, 10753), (10800, 10841), (10900, 10909), (43708, 36032),
    (11048, 11069), (43922, 35946), (11192, 11221), (44033, 36036),
    (6512, 6514), (6649, 6680), (39519, 36629), (39583, 36764), (6923, 6945),
    (6993, 7045), (39863, 36817), (40065, 36786), (40145, 36367),
    (40209, 36424), (40311, 36771), (7583, 7620), (40438, 36613),
    (40514, 36650), (40560, 36522), (7835, 7856), (40784, 36855), (8051, 8077),
    (40903, 36649), (8186, 8241), (41219, 36781), (41544, 36664),
    (41600, 36848), (8895, 8922), (41753, 36555), (41815, 36493), (9128, 9130),
    (41952, 36575), (42021, 36814), (9419, 9470), (42292, 36677), (9605, 9607),
    (42653, 36617), (9915, 9943), (9976, 9978), (42845, 36420), (10123, 10154),
    (10195, 10197), (10311, 10359), (10451, 10503), (10585, 10606),
    (43431, 36636), (43576, 36774), (43732, 36676), (43810, 36562),
    (43882, 36426), (44089, 36637), (39344, 37039), (6636, 6652),
    (39467, 36963), (39520, 36885), (6867, 6895), (39713, 37066), (6994, 7015),
    (39833, 36917), (7192, 7209), (7350, 7379), (7442, 7446), (7497, 7532),
    (7564, 7585), (40388, 36899), (7646, 7656), (40476, 36988), (7783, 7785),
    (40586, 37000), (7856, 7870), (40677, 37225), (40854, 37297), (8115, 8137),
    (40956, 37002), (41026, 36898), (8298, 8300), (41142, 37145), (8452, 8471),
    (8559, 8577), (41373, 36984), (41420, 37266), (8693, 8730), (8777, 8780),
    (41594, 37255), (41736, 37122), (41806, 37326), (41843, 37312),
    (41914, 36870), (42100, 37013), (9410, 9413), (9470, 9495), (42293, 36960),
    (42323, 36949), (9607, 9612), (9660, 9684), (42485, 36999), (42528, 36920),
    (42587, 37196), (42636, 37292), (9916, 9918), (42711, 36969),
    (10050, 10053), (42846, 37261), (10124, 10127), (10197, 10228),
    (43045, 36978), (43081, 36914), (43127, 36974), (10429, 10431),
    (10468, 10470), (10518, 10520), (10545, 10558), (10586, 10607),
    (43402, 37257), (43449, 37341), (10753, 10782), (43605, 36941),
    (43648, 36875), (10916, 10942), (11016, 11031), (11104, 11116),
    (43928, 37239), (43982, 36996), (44011, 36945), (11282, 11297),
    (6584, 6676), (6711, 6713), (39521, 37857), (39584, 37678), (39636, 37707),
    (6996, 6998), (39840, 37406), (39879, 37670), (7179, 7181), (7351, 7374),
    (40214, 37709), (7487, 7505), (7621, 7680), (40490, 37860), (40678, 37528),
    (40728, 37672), (40855, 37474), (41027, 37586), (41255, 37394),
    (8560, 8607), (8696, 8728), (8780, 8782), (8827, 8834), (41737, 37716),
    (41956, 37467), (9255, 9281), (42086, 37434), (9441, 9443), (42300, 37470),
    (9612, 9650), (42529, 37808), (42659, 37658), (9944, 9981), (10053, 10056),
    (10133, 10155), (10314, 10365), (10567, 10592), (43450, 37756),
    (43577, 37393), (43649, 37610), (43742, 37532), (11069, 11107),
    (43923, 37804), (6525, 6630), (6889, 6908), (7039, 7067), (40366, 38317),
    (7995, 8032), (8159, 8181), (8607, 8630), (8986, 8995), (9200, 9214),
    (42401, 38287), (42637, 38263), (42749, 37931), (10155, 10201),
    (10365, 10380), (10470, 10483), (10716, 10786), (43622, 38281),
    (10959, 10983), (11221, 11271), (39327, 38824), (39376, 38477),
    (39457, 38548), (39548, 38542), (39585, 38599), (39624, 38799),
    (7006, 7008), (39849, 38553), (39992, 38627), (40172, 38538), (7447, 7449),
    (40377, 38722), (7648, 7672), (40465, 38647), (7723, 7801), (40612, 38778),
    (7873, 7894), (7981, 8018), (40820, 38649), (8116, 8138), (40949, 38713),
    (8300, 8324), (41143, 38750), (41239, 38704), (41287, 38684), (8621, 8631),
    (41465, 38902), (8782, 8787), (41622, 38494), (8939, 8981), (9015, 9017),
    (41844, 38525), (9257, 9283), (42101, 38605), (42127, 38446), (9473, 9503),
    (42295, 38498), (42324, 38859), (9650, 9657), (9750, 9752), (9808, 9834),
    (42638, 38556), (42686, 38606), (9982, 10001), (10056, 10082),
    (10127, 10129), (42989, 38603), (10315, 10342), (10452, 10473),
    (43277, 38737), (43360, 38619), (43432, 38601), (43466, 38464),
    (43578, 38442), (10838, 10856), (43685, 38466), (10942, 10984),
    (11031, 11050), (43884, 38795), (43961, 38772), (44012, 38541),
    (39282, 39381), (6754, 6756), (39586, 39015), (6869, 6891), (39714, 39171),
    (39766, 39378), (39813, 39243), (39864, 39241), (7181, 7183),
    (40049, 39377), (7468, 7533), (40418, 38936), (40505, 39006), (7810, 7837),
    (8053, 8079), (40923, 39132), (8208, 8242), (41070, 39385), (8376, 8392),
    (8453, 8455), (41256, 39087), (41376, 39245), (8713, 8723), (8787, 8789),
    (8828, 8830), (8896, 8898), (8956, 8982), (41791, 38989), (9078, 9087),
    (41899, 39192), (42051, 38928), (9334, 9361), (42181, 39250),
    (42252, 38922), (42296, 39000), (42425, 39150), (9720, 9722),
    (42530, 39353), (9983, 9986), (10059, 10083), (10201, 10223),
    (10380, 10382), (10665, 10701), (10754, 10802), (10882, 10928),
    (11000, 11035), (11070, 11108), (11156, 11158), (39433, 39467),
    (6756, 6758), (6819, 6841), (6919, 7051), (7183, 7186), (40282, 39472),
    (7599, 7601), (7672, 7710), (7786, 7812), (7870, 7875), (8088, 8146),
    (40977, 39432), (41163, 39425), (41377, 39854), (41466, 39479),
    (8789, 8791), (41750, 39839), (41855, 39770), (41915, 39515),
    (41982, 39653), (42267, 39729), (42325, 39759), (42769, 39822),
    (10510, 10521), (10593, 10636), (43550, 39722), (10839, 10904),
    (11018, 11046), (11166, 11216), (44051, 39501), (39377, 40007),
    (39468, 40273), (6781, 6828), (7000, 7002), (40441, 40442), (7794, 7838),
    (7911, 7983), (8191, 8335), (8957, 9027), (41958, 40182), (42080, 39986),
    (42297, 40219), (42432, 40441), (42589, 40306), (42897, 40165),
    (10594, 10637), (10943, 10949), (11179, 11217), (44098, 40440),
    (39347, 40853), (39444, 40660), (39588, 40723), (7002, 7009),
    (39954, 40594), (7389, 7406), (7541, 7711), (7795, 7813), (7875, 7895),
    (7984, 8019), (40885, 40848), (40960, 40712), (41145, 40763),
    (41223, 40605), (8561, 8563), (41390, 40807), (8972, 9028), (41856, 40812),
    (41983, 40573), (42081, 40711), (9886, 9920), (10002, 10084),
    (43134, 40810), (10612, 10667), (43744, 40569), (44013, 40643),
    (11322, 11337), (0, 188), (4136, 4288), (11374, 11546), (188, 376),
    (4288, 4398), (11546, 11760), (376, 564), (4398, 4520), (11760, 11962),
    (564, 785), (4520, 4643), (11962, 12130), (785, 1034), (4643, 4738),
    (12130, 12298), (1034, 1222), (4738, 4815), (12298, 12545), (1222, 1442),
    (4815, 4934), (12545, 12718), (1442, 1691), (4934, 5029), (12718, 12886),
    (1691, 1880), (5029, 5146), (12886, 13092), (1880, 2099), (5146, 5225),
    (13092, 13306), (2099, 2325), (5225, 5343), (13306, 13474), (2325, 2538),
    (5343, 5447), (13474, 13669), (2538, 2726), (5447, 5565), (13669, 13875),
    (2726, 2914), (5565, 5729), (13875, 14035), (2914, 3008), (5729, 5846),
    (14035, 14336), (5846, 5905), (14336, 14789), (5905, 6003), (14789, 15203),
    (6003, 6101), (15203, 15617), (6101, 6191), (15617, 16039), (6191, 6297),
    (16039, 16445), (6297, 6381), (16445, 16873), (6381, 6486), (16873, 17188),
    (6627, 6634), (39418, 63746), (39582, 63747), (39607, 63748),
    (39642, 63749), (7046, 7052), (39841, 63752), (39865, 63753),
    (39878, 63754), (7195, 7256), (7267, 7326), (40263, 63834), (7517, 7534),
    (40405, 63839), (40426, 63840), (40518, 63841), (40543, 63842),
    (40888, 63843), (40919, 63844), (40950, 63845), (41044, 63846),
    (41092, 63847), (41123, 63848), (8457, 8460), (41246, 63851), (8524, 8532),
    (41402, 63854), (41428, 63855), (41492, 63856), (8920, 8939), (9037, 9078),
    (9113, 9228), (9242, 9263), (9274, 9282), (42066, 63929), (9376, 9412),
    (42211, 63940), (42254, 63941), (42294, 63942), (42330, 63943),
    (9577, 9598), (9613, 9644), (9687, 9724), (9734, 9754), (9768, 9779),
    (42621, 63994), (42696, 63995), (43042, 63996), (43103, 63997),
    (43124, 63998), (43208, 63999), (43279, 64000), (10705, 11195),
    (3019, 3290),
]; // 2561 entries

#[cfg(feature = "no-optimized-legacy-encoding")]
const BACKWARD_SEARCH_UPPER: &'static [u16] = &[
    0, 2, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 7, 8, 10, 11, 11, 11,
    11, 11, 14, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 96,
    164, 246, 299, 343, 414, 476, 531, 610, 689, 764, 832, 923, 987, 1044,
    1124, 1202, 1262, 1325, 1402, 1454, 1497, 1562, 1628, 1679, 1747, 1818,
    1870, 1910, 1959, 2029, 2080, 2127, 2201, 2244, 2263, 2324, 2372, 2402,
    2421, 2448, 2448, 2448, 2448, 2448, 2448, 2448, 2451, 2454, 2457, 2460,
    2463, 2466, 2469, 2472, 2475, 2478, 2481, 2484, 2487, 2490, 2493, 2495,
    2497, 2499, 2501, 2503, 2505, 2507, 2507, 2507, 2507, 2507, 2507, 2507,
    2507, 2507, 2507, 2507, 2507, 2507, 2507, 2507, 2507, 2507, 2558, 2560,
    2560, 2561,
]; // 129 entries

/// Returns the index pointer for code point `code` in this index.
#[inline]
#[cfg(not(feature = "no-optimized-legacy-encoding"))]
pub fn backward(code: u32) -> u16 {
    let offset = (code >> 4) as usize;
    let offset = if offset < 4095 {BACKWARD_TABLE_UPPER[offset] as usize} else {0};
    // BACKWARD_TABLE_LOWER stores the actual (pre-mapped) value
    // so we don't have to call premap_backward here.
    BACKWARD_TABLE_LOWER[offset + ((code & 15) as usize)]
}

/// Returns the index pointer for code point `code` in this index.
#[cfg(feature = "no-optimized-legacy-encoding")]
pub fn backward(code: u32) -> u16 {
    // avoid mistaking a placeholder for the actual value
    if code == X as u32 { return 0xffff; }
    let codelo = (code & 0xffff) as u16;
    let offset = (code >> 9) as usize;
    let (start, end) = if offset < 128 {
        (BACKWARD_SEARCH_UPPER[offset], BACKWARD_SEARCH_UPPER[offset+1])
    } else {
        (0, 0)
    };
    for &(s, e) in &BACKWARD_SEARCH_LOWER[(start as usize)..(end as usize)] {
        if s >= 0x8000 {
            if e == codelo {
                return premap_backward(s & 0x7fff);
            }
        } else {
            for i in s..e {
                if FORWARD_TABLE[i as usize] == codelo {
                    return premap_backward(i);
                }
            }
        }
    }
    X
}

#[cfg(test)]
multi_byte_tests! {
    dups = []
}
