% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_values.R
\name{generate_halton_faure_single}
\alias{generate_halton_faure_single}
\title{Generate Halton Value (Faure Initialized)}
\usage{
generate_halton_faure_single(i, dim)
}
\arguments{
\item{i}{The element of the sequence to extract.}

\item{dim}{The dimension of the sequence to extract.}
}
\value{
A single numeric value representing the `i`th element in the `dim` dimension.
}
\description{
Generate a single value from a seeded Halton set, initialized with a Faure sequence.

Note: This is much slower than generating the entire set ahead of time.
}
\examples{
#Generate a 3D sample:
point3d = c(generate_halton_faure_single(10, dim = 1),
           generate_halton_faure_single(10, dim = 2),
           generate_halton_faure_single(10, dim = 3))
point3d
}
