% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log1pexp.R
\name{log1pexp}
\alias{log1pexp}
\title{Calculating log(1+exp(x)) accurately}
\usage{
log1pexp(x)
}
\arguments{
\item{x}{a numeric vector.}
}
\value{
A numeric vector where the i-th entry is equal to \code{log(1+exp(x[i]))}, but computed more stably.
}
\description{
Calculates \code{log(1+exp(x))} in a numerically stable fashion.
}
\details{
We follow the recipe of Machler (2012), that is formula (10) page 7.
}
\examples{
set.seed(141)
library(qgam); 
x <- rnorm(100, 0, 100)
log1pexp(x) - log1p(exp(x))
}
\references{
Machler, M. (2012). Accurately computing log(1-exp(-|a|)). 
            URL: \url{https://cran.r-project.org/package=Rmpfr/vignettes/log1mexp-note.pdf}.
}
\author{
Matteo Fasiolo <matteo.fasiolo@gmail.com>.
}
