# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, Optional, TypeVar

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._indexes_operations import build_create_or_update_request, build_get_latest_request, build_get_next_version_request, build_get_request, build_list_latest_request, build_list_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class IndexesOperations:
    """IndexesOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.machinelearningservices.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def list_latest(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        top: Optional[int] = None,
        skip: Optional[int] = 0,
        maxpagesize: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.PagedIndex"]:
        """List the latest version of each index. Latest is defined by most recent created by date.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param top: The number of result items to return.
        :type top: int
        :param skip: The number of result items to skip.
        :type skip: int
        :param maxpagesize: The maximum number of result items per page.
        :type maxpagesize: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PagedIndex or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.machinelearningservices.models.PagedIndex]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PagedIndex"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_latest_request(
                    workspace_name=workspace_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    template_url=self.list_latest.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_latest_request(
                    workspace_name=workspace_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PagedIndex", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_latest.metadata = {'url': "/workspaces/{workspaceName}/indexes"}  # type: ignore

    @distributed_trace_async
    async def get_latest(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        **kwargs: Any
    ) -> "_models.Index":
        """Get latest version of the Index. Latest is defined by most recent created by date.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Index"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_get_latest_request(
            workspace_name=workspace_name,
            name=name,
            api_version=api_version,
            template_url=self.get_latest.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Index', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_latest.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}"}  # type: ignore


    @distributed_trace_async
    async def get_next_version(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        **kwargs: Any
    ) -> "_models.VersionInfo":
        """Get next Index version as defined by the server. The server keeps track of all versions that
        are string-representations of integers. If one exists, the nextVersion will be a string
        representation of the highest integer value + 1. Otherwise, the nextVersion will default to
        '1'.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: VersionInfo, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.VersionInfo
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.VersionInfo"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_get_next_version_request(
            workspace_name=workspace_name,
            name=name,
            api_version=api_version,
            template_url=self.get_next_version.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('VersionInfo', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_next_version.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}:getNextVersion"}  # type: ignore


    @distributed_trace
    def list(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        list_view_type: str = "ActiveOnly",
        order_by: Optional[str] = None,
        tags: Optional[str] = None,
        top: Optional[int] = None,
        skip: Optional[int] = 0,
        maxpagesize: Optional[int] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.PagedIndex"]:
        """List the versions of an Index given the name.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :param list_view_type: View type for including/excluding (for example) archived entities.
        :type list_view_type: str
        :param order_by: Ordering of list: Please choose orderby value from ['createdAt',
         'lastModifiedAt'].
        :type order_by: str
        :param tags: Comma-separated list of tag names (and optionally values). Example:
         tag1,tag2=value2.
        :type tags: str
        :param top: The number of result items to return.
        :type top: int
        :param skip: The number of result items to skip.
        :type skip: int
        :param maxpagesize: The maximum number of result items per page.
        :type maxpagesize: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PagedIndex or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.machinelearningservices.models.PagedIndex]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PagedIndex"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_request(
                    workspace_name=workspace_name,
                    name=name,
                    api_version=api_version,
                    list_view_type=list_view_type,
                    order_by=order_by,
                    tags=tags,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_request(
                    workspace_name=workspace_name,
                    name=name,
                    api_version=api_version,
                    list_view_type=list_view_type,
                    order_by=order_by,
                    tags=tags,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PagedIndex", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}/versions"}  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        version: str,
        **kwargs: Any
    ) -> "_models.Index":
        """Get a specific version of an Index.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :param version: Version of the index.
        :type version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Index"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_get_request(
            workspace_name=workspace_name,
            name=name,
            version=version,
            api_version=api_version,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('Index', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}/versions/{version}"}  # type: ignore


    @distributed_trace_async
    async def create_or_update(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        workspace_name: str,
        name: str,
        version: str,
        body: "_models.Index",
        **kwargs: Any
    ) -> "_models.Index":
        """Creates or updates a IndexVersion.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param workspace_name: The name of the AzureML workspace or AI project.
        :type workspace_name: str
        :param name: Name of the index.
        :type name: str
        :param version: Version of the index.
        :type version: str
        :param body: Properties of an Index Version.
        :type body: ~azure.mgmt.machinelearningservices.models.Index
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Index, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.Index
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.Index"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'Index')

        request = build_create_or_update_request(
            workspace_name=workspace_name,
            name=name,
            version=version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.create_or_update.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize('Index', pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize('Index', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update.metadata = {'url': "/workspaces/{workspaceName}/indexes/{name}/versions/{version}"}  # type: ignore

