from unittest import TestCase

from pcs.lib import resource_agent as ra


class OcfVersionToOcfUnified(TestCase):
    def test_ocf_1_0_minimal(self):
        metadata_in = ra.types.ResourceAgentMetadataOcf1_0(
            ra.ResourceAgentName("standard", "provider", "type"),
            shortdesc=None,
            longdesc=None,
            parameters=[],
            actions=[],
        )
        metadata_out = ra.ResourceAgentMetadata(
            ra.ResourceAgentName("standard", "provider", "type"),
            agent_exists=True,
            ocf_version=ra.const.OCF_1_0,
            shortdesc=None,
            longdesc=None,
            parameters=[],
            actions=[],
        )
        self.assertEqual(
            ra.ocf_transform.ocf_version_to_ocf_unified(metadata_in),
            metadata_out,
        )

    def test_ocf_1_1_minimal(self):
        metadata_in = ra.types.ResourceAgentMetadataOcf1_1(
            ra.ResourceAgentName("standard", "provider", "type"),
            shortdesc=None,
            longdesc=None,
            parameters=[],
            actions=[],
        )
        metadata_out = ra.ResourceAgentMetadata(
            ra.ResourceAgentName("standard", "provider", "type"),
            agent_exists=True,
            ocf_version=ra.const.OCF_1_1,
            shortdesc=None,
            longdesc=None,
            parameters=[],
            actions=[],
        )
        self.assertEqual(
            ra.ocf_transform.ocf_version_to_ocf_unified(metadata_in),
            metadata_out,
        )

    def test_ocf_1_0(self):
        metadata_in = ra.types.ResourceAgentMetadataOcf1_0(
            ra.ResourceAgentName("standard", "provider", "type"),
            shortdesc="agent shortdesc",
            longdesc="agent longdesc",
            parameters=[
                ra.types.ResourceAgentParameterOcf1_0(
                    name="param_1",
                    shortdesc=None,
                    longdesc=None,
                    type="string",
                    default=None,
                    enum_values=None,
                    required=None,
                    deprecated=None,
                    obsoletes=None,
                    unique=None,
                ),
                ra.types.ResourceAgentParameterOcf1_0(
                    name="param_2",
                    shortdesc="param_2 shortdesc",
                    longdesc="param_2 longdesc",
                    type="select",
                    default="a",
                    enum_values=["a", "b", "c"],
                    required="0",
                    deprecated="1",
                    obsoletes=None,
                    unique="0",
                ),
                ra.types.ResourceAgentParameterOcf1_0(
                    name="param_3",
                    shortdesc="param_3 shortdesc",
                    longdesc="param_3 longdesc",
                    type="integer",
                    default="123",
                    enum_values=None,
                    required="1",
                    deprecated="0",
                    obsoletes="param_2",
                    unique="1",
                ),
                ra.types.ResourceAgentParameterOcf1_0(
                    name="param_4",
                    shortdesc="param_4 shortdesc",
                    longdesc="param_4 longdesc",
                    type="string",
                    default=None,
                    enum_values=None,
                    required="0",
                    deprecated="0",
                    obsoletes="param_5",
                    unique="0",
                ),
                ra.types.ResourceAgentParameterOcf1_0(
                    name="param_5",
                    shortdesc="param_5 shortdesc",
                    longdesc="param_5 longdesc",
                    type="string",
                    default=None,
                    enum_values=None,
                    required="1",
                    deprecated="1",
                    obsoletes="param_4",
                    unique="1",
                ),
                ra.types.ResourceAgentParameterOcf1_0(
                    name="param_6",
                    shortdesc=None,
                    longdesc=None,
                    type="string",
                    default=None,
                    enum_values=None,
                    required=None,
                    deprecated=None,
                    obsoletes="param_2",
                    unique=None,
                ),
            ],
            actions=[
                ra.types.ResourceAgentActionOcf1_0(
                    name="action_1",
                    timeout=None,
                    interval=None,
                    role=None,
                    start_delay=None,
                    depth=None,
                    automatic=None,
                    on_target=None,
                ),
                ra.types.ResourceAgentActionOcf1_0(
                    name="action_2",
                    timeout="12",
                    interval="23",
                    role="role",
                    start_delay="34",
                    depth="45",
                    automatic="0",
                    on_target="1",
                ),
                ra.types.ResourceAgentActionOcf1_0(
                    name="action_3",
                    timeout="0",
                    interval="0",
                    role="role",
                    start_delay="0",
                    depth="0",
                    automatic="1",
                    on_target="0",
                ),
            ],
        )
        metadata_out = ra.ResourceAgentMetadata(
            ra.ResourceAgentName("standard", "provider", "type"),
            agent_exists=True,
            ocf_version=ra.const.OCF_1_0,
            shortdesc="agent shortdesc",
            longdesc="agent longdesc",
            parameters=[
                ra.ResourceAgentParameter(
                    name="param_1",
                    shortdesc=None,
                    longdesc=None,
                    type="string",
                    default=None,
                    enum_values=None,
                    required=False,
                    advanced=False,
                    deprecated=False,
                    deprecated_by=[],
                    deprecated_desc=None,
                    unique_group=None,
                    reloadable=False,
                ),
                ra.ResourceAgentParameter(
                    name="param_2",
                    shortdesc="param_2 shortdesc",
                    longdesc="param_2 longdesc",
                    type="select",
                    default="a",
                    enum_values=["a", "b", "c"],
                    required=False,
                    advanced=False,
                    deprecated=True,
                    deprecated_by=["param_3", "param_6"],
                    deprecated_desc=None,
                    unique_group=None,
                    reloadable=False,
                ),
                ra.ResourceAgentParameter(
                    name="param_3",
                    shortdesc="param_3 shortdesc",
                    longdesc="param_3 longdesc",
                    type="integer",
                    default="123",
                    enum_values=None,
                    required=True,
                    advanced=False,
                    deprecated=False,
                    deprecated_by=[],
                    deprecated_desc=None,
                    unique_group="_pcs_unique_group_param_3",
                    reloadable=True,
                ),
                ra.ResourceAgentParameter(
                    name="param_4",
                    shortdesc="param_4 shortdesc",
                    longdesc="param_4 longdesc",
                    type="string",
                    default=None,
                    enum_values=None,
                    required=False,
                    advanced=False,
                    deprecated=False,
                    deprecated_by=["param_5"],
                    deprecated_desc=None,
                    unique_group=None,
                    reloadable=False,
                ),
                ra.ResourceAgentParameter(
                    name="param_5",
                    shortdesc="param_5 shortdesc",
                    longdesc="param_5 longdesc",
                    type="string",
                    default=None,
                    enum_values=None,
                    required=True,
                    advanced=False,
                    deprecated=True,
                    deprecated_by=["param_4"],
                    deprecated_desc=None,
                    unique_group="_pcs_unique_group_param_5",
                    reloadable=True,
                ),
                ra.ResourceAgentParameter(
                    name="param_6",
                    shortdesc=None,
                    longdesc=None,
                    type="string",
                    default=None,
                    enum_values=None,
                    required=False,
                    advanced=False,
                    deprecated=False,
                    deprecated_by=[],
                    deprecated_desc=None,
                    unique_group=None,
                    reloadable=False,
                ),
            ],
            actions=[
                ra.ResourceAgentAction(
                    name="action_1",
                    timeout=None,
                    interval=None,
                    role=None,
                    start_delay=None,
                    depth=None,
                    automatic=False,
                    on_target=False,
                ),
                ra.ResourceAgentAction(
                    name="action_2",
                    timeout="12",
                    interval="23",
                    role="role",
                    start_delay="34",
                    depth="45",
                    automatic=False,
                    on_target=True,
                ),
                ra.ResourceAgentAction(
                    name="action_3",
                    timeout="0",
                    interval="0",
                    role="role",
                    start_delay="0",
                    depth="0",
                    automatic=True,
                    on_target=False,
                ),
            ],
        )
        self.assertEqual(
            ra.ocf_transform.ocf_version_to_ocf_unified(metadata_in),
            metadata_out,
        )

    def test_ocf_1_1(self):
        metadata_in = ra.types.ResourceAgentMetadataOcf1_1(
            ra.ResourceAgentName("standard", "provider", "type"),
            shortdesc="agent shortdesc",
            longdesc="agent longdesc",
            parameters=[
                ra.types.ResourceAgentParameterOcf1_1(
                    name="param_1",
                    shortdesc=None,
                    longdesc=None,
                    type="string",
                    default=None,
                    enum_values=None,
                    required=None,
                    advanced=None,
                    deprecated=False,
                    deprecated_by=None,
                    deprecated_desc=None,
                    unique_group=None,
                    reloadable=None,
                ),
                ra.types.ResourceAgentParameterOcf1_1(
                    name="param_2",
                    shortdesc="param_2 shortdesc",
                    longdesc="param_2 longdesc",
                    type="select",
                    default="a",
                    enum_values=["a", "b", "c"],
                    required="0",
                    advanced="1",
                    deprecated=True,
                    deprecated_by=None,
                    deprecated_desc=None,
                    unique_group=None,
                    reloadable="1",
                ),
                ra.types.ResourceAgentParameterOcf1_1(
                    name="param_3",
                    shortdesc="param_3 shortdesc",
                    longdesc="param_3 longdesc",
                    type="integer",
                    default="123",
                    enum_values=None,
                    required="1",
                    advanced="0",
                    deprecated=True,
                    deprecated_by=["param_1"],
                    deprecated_desc="explanation of deprecation",
                    unique_group="ug1",
                    reloadable="0",
                ),
            ],
            actions=[
                ra.types.ResourceAgentActionOcf1_1(
                    name="action_1",
                    timeout=None,
                    interval=None,
                    role=None,
                    start_delay=None,
                    depth=None,
                    automatic=None,
                    on_target=None,
                ),
                ra.types.ResourceAgentActionOcf1_1(
                    name="action_2",
                    timeout="12",
                    interval="23",
                    role="role",
                    start_delay="34",
                    depth="45",
                    automatic="0",
                    on_target="1",
                ),
                ra.types.ResourceAgentActionOcf1_1(
                    name="action_3",
                    timeout="0",
                    interval="0",
                    role="role",
                    start_delay="0",
                    depth="0",
                    automatic="1",
                    on_target="0",
                ),
            ],
        )
        metadata_out = ra.ResourceAgentMetadata(
            ra.ResourceAgentName("standard", "provider", "type"),
            agent_exists=True,
            ocf_version=ra.const.OCF_1_1,
            shortdesc="agent shortdesc",
            longdesc="agent longdesc",
            parameters=[
                ra.ResourceAgentParameter(
                    name="param_1",
                    shortdesc=None,
                    longdesc=None,
                    type="string",
                    default=None,
                    enum_values=None,
                    required=False,
                    advanced=False,
                    deprecated=False,
                    deprecated_by=None,
                    deprecated_desc=None,
                    unique_group=None,
                    reloadable=False,
                ),
                ra.ResourceAgentParameter(
                    name="param_2",
                    shortdesc="param_2 shortdesc",
                    longdesc="param_2 longdesc",
                    type="select",
                    default="a",
                    enum_values=["a", "b", "c"],
                    required=False,
                    advanced=True,
                    deprecated=True,
                    deprecated_by=None,
                    deprecated_desc=None,
                    unique_group=None,
                    reloadable=True,
                ),
                ra.ResourceAgentParameter(
                    name="param_3",
                    shortdesc="param_3 shortdesc",
                    longdesc="param_3 longdesc",
                    type="integer",
                    default="123",
                    enum_values=None,
                    required=True,
                    advanced=False,
                    deprecated=True,
                    deprecated_by=["param_1"],
                    deprecated_desc="explanation of deprecation",
                    unique_group="ug1",
                    reloadable=False,
                ),
            ],
            actions=[
                ra.ResourceAgentAction(
                    name="action_1",
                    timeout=None,
                    interval=None,
                    role=None,
                    start_delay=None,
                    depth=None,
                    automatic=False,
                    on_target=False,
                ),
                ra.ResourceAgentAction(
                    name="action_2",
                    timeout="12",
                    interval="23",
                    role="role",
                    start_delay="34",
                    depth="45",
                    automatic=False,
                    on_target=True,
                ),
                ra.ResourceAgentAction(
                    name="action_3",
                    timeout="0",
                    interval="0",
                    role="role",
                    start_delay="0",
                    depth="0",
                    automatic=True,
                    on_target=False,
                ),
            ],
        )
        self.assertEqual(
            ra.ocf_transform.ocf_version_to_ocf_unified(metadata_in),
            metadata_out,
        )
