/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToNWChemEcpInput
extends AbstractBasisSetXmlToText {
    protected boolean specifics = true;

    public BasisXmlToNWChemEcpInput() {
    }

    public BasisXmlToNWChemEcpInput(boolean includeSpecifics) {
        this.specifics = includeSpecifics;
    }

    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readECP(data, elementList);
    }

    @Override
    protected void addHeaderECP(StringBuffer output, Element root) {
        output.append("ECP\n");
    }

    @Override
    protected void addFooterECP(StringBuffer output) {
        output.append("END\n");
    }

    @Override
    protected void addElementDescriptionECP(StringBuffer output, Element potentials, String element) {
        String nelec = potentials.getAttributeValue("numElectronsReplaced");
        output.append(element + " nelec " + nelec + "\n");
        this.mGlobalShellCounter = 0;
    }

    @Override
    protected void readCmlMatrixECP(StringBuffer output, Matrix matrix, String element, String shell, String potentialType) throws FormatException {
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        if (this.mGlobalShellCounter == 0 && this.specifics) {
            output.append(element + " ul\n");
        } else {
            output.append(element + " " + shell.toUpperCase() + "\n");
        }
        ++this.mGlobalShellCounter;
        try {
            for (int i = 0; i < rows; ++i) {
                output.append(matrix.getValue(i, 0));
                for (int j = 1; j < columns; ++j) {
                    String value = this.formattedValue(matrix.getValue(i, j));
                    output.append(value);
                }
                output.append("\n");
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
    }
}

