---
stage: Data Stores
group: Tenant Scale
description: Project visibility, search, badges, layout.
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Organize work with projects

Create projects to host your codebase in GitLab.
You can also use projects to:

- Track issues
- Plan work
- Collaborate on code
- Use CI/CD tools to continuously build, test, and deploy your app

Projects can be available [publicly, internally, or privately](../public_access.md).
GitLab does not limit the number of private projects you can create.

| | | |
|--|--|--|
| [**Getting started**](../../user/get_started/get_started_projects.md)<br>Overview of how features fit together. | [**Create a project**](index.md)<br>New project, project templates. | [**Manage projects**](working_with_projects.md)<br>Settings, configuration, project activity, project deletion.  |
| [**Project visibility**](../public_access.md)<br>Public, private, internal. | [**Project settings**](working_with_projects.md)<br>Project features, analytics, project permissions. | [**Description templates**](../../user/project/description_templates.md)<br>Issue templates, merge request templates, instance and group templates. |
| [**Project access tokens**](../project/settings/project_access_tokens.md)<br>Authentication, create, revoke, token expiration. | [**Deploy keys**](../../user/project/deploy_keys/index.md)<br>Public SSH keys, repository access, bot users, read-only access.  | [**Deploy tokens**](../../user/project/deploy_tokens/index.md)<br>Repository cloning, token creation, container registry. |
| [**Share projects**](../project/members/share_project_with_groups.md)<br>Member roles, invitations, group access. | [**Reserved project and group names**](../../user/reserved_names.md)<br>Naming conventions, restrictions, reserved names. | [**Search**](../../user/search/index.md)<br>Basic, advanced, exact, search scope, commit SHA search. |
| [**Badges**](../../user/project/badges.md)<br>Pipeline status, group, project, custom badges. | [**Project topics**](../../user/project/project_topics.md)<br>Project organization, subscribe, view.  | [**Code intelligence**](../../user/project/code_intelligence.md)<br>Type signatures, symbol documentation, go-to definition. |
| [**Import and migrate**](../../user/project/import/index.md)<br>Repository migration, third-party repositories, user contribution mapping. | [**System notes**](../../user/project/system_notes.md)<br>Event history, activity log, comments history. | [**Transfer a project to another namespace**](../../user/project/import/index.md)<br>Namespace transfer, subscription transfer. |
| [**Use a project as a Go package**](../../user/project/use_project_as_go_package.md)<br>Go modules, import calls. | [**Tutorial: Build a protected workflow for your project**](../../tutorials/protected_workflow/index.md)<br>Security, approval rules, branch protection. | [**Troubleshooting**](../../user/project/troubleshooting.md)<br>Problem solving, common issues, debugging, error resolution. |
