/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTFormalParameters;
import net.sourceforge.pmd.ast.ASTImplementsList;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.SimpleNode;

public class OverrideBothEqualsAndHashcode
extends AbstractRule {
    private boolean implementsComparable = false;
    private boolean containsEquals = false;
    private boolean containsHashCode = false;
    private SimpleNode nodeFound = null;

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        super.visit(node, data);
        if (!this.implementsComparable && this.containsEquals ^ this.containsHashCode) {
            if (this.nodeFound == null) {
                this.nodeFound = node;
            }
            this.addViolation(data, this.nodeFound);
        }
        this.containsHashCode = false;
        this.containsEquals = false;
        this.implementsComparable = false;
        this.nodeFound = null;
        return data;
    }

    public Object visit(ASTImplementsList node, Object data) {
        for (int ix = 0; ix < node.jjtGetNumChildren(); ++ix) {
            ASTClassOrInterfaceType cit;
            Class clazz;
            if (!node.jjtGetChild(ix).getClass().equals(ASTClassOrInterfaceType.class) || (clazz = (cit = (ASTClassOrInterfaceType)node.jjtGetChild(ix)).getType()) == null && !((SimpleNode)node.jjtGetChild(ix)).hasImageEqualTo("Comparable")) continue;
            this.implementsComparable = true;
            return data;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclarator node, Object data) {
        if (this.implementsComparable) {
            return data;
        }
        int iFormalParams = 0;
        String paramName = null;
        for (int ix = 0; ix < node.jjtGetNumChildren(); ++ix) {
            SimpleNode sn = (SimpleNode)node.jjtGetChild(ix);
            if (!sn.getClass().equals(ASTFormalParameters.class)) continue;
            List<ASTFormalParameter> allParams = ((ASTFormalParameters)sn).findChildrenOfType(ASTFormalParameter.class);
            for (ASTFormalParameter formalParam : allParams) {
                ++iFormalParams;
                ASTClassOrInterfaceType param = formalParam.getFirstChildOfType(ASTClassOrInterfaceType.class);
                if (param == null) continue;
                paramName = param.getImage();
            }
        }
        if (iFormalParams == 0 && node.hasImageEqualTo("hashCode")) {
            this.containsHashCode = true;
            this.nodeFound = node;
        } else if (iFormalParams == 1 && node.hasImageEqualTo("equals") && ("Object".equals(paramName) || "java.lang.Object".equals(paramName))) {
            this.containsEquals = true;
            this.nodeFound = node;
        }
        return super.visit(node, data);
    }
}

