/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import net.sourceforge.pmd.properties.AbstractScalarProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatProperty
extends AbstractScalarProperty {
    public FloatProperty(String theName, String theDescription, float theDefault, float theUIOrder) {
        super(theName, theDescription, new Float(theDefault), theUIOrder);
    }

    public FloatProperty(String theName, String theDescription, float[] defaultValues, float theUIOrder, int theMaxValues) {
        this(theName, theDescription, FloatProperty.asFloats(defaultValues), theUIOrder, theMaxValues);
    }

    public FloatProperty(String theName, String theDescription, Float[] defaultValues, float theUIOrder, int theMaxValues) {
        super(theName, theDescription, defaultValues, theUIOrder);
        this.maxValueCount(theMaxValues);
    }

    public Class<Float> type() {
        return Float.class;
    }

    private static final Float[] asFloats(float[] floats) {
        Float[] Floats = new Float[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            Floats[i] = new Float(floats[i]);
        }
        return Floats;
    }

    @Override
    protected Object createFrom(String value) {
        return Float.valueOf(value);
    }

    @Override
    protected Object[] arrayFor(int size) {
        return new Float[size];
    }
}

