#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _


class vmenu_search_command:
    """Base class for VMenu search commands"""

    def __init__(self, search_char):
        self.search_char = search_char.lower()

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("search for a menu entry")

    def run(self):
        text = self.env["runtime"]["VmenuManager"].search_entry(
            self.search_char
        )
        if text != "":
            self.env["runtime"]["OutputManager"].present_text(
                text, interrupt=True
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                _("not found"), sound_icon="ErrorScreen", interrupt=True
            )

    def set_callback(self, callback):
        pass
