/* $Id$
 *
 * Tracing related functionality.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TRACE_H_INCLUDED
#define __TRACE_H_INCLUDED

#include "fauhdli_private.h"
#include "signals.h"
#include <stdio.h>
#include <stdbool.h>

struct trace_t {
	/* pointer to output file */
	FILE *output;
	/** set of traced signals (uses internal tracing structure) */
	struct slist *traced_sigs;
	/** next ident code to be handed out. */
	char ident_code;
	/** header already written? */
	bool header_written;
};

/** create a trace instance.
 *  @param trace_file output file name
 *  @param callbacks that must have a log callback registered.
 *  @return trace instance.
 */
extern
struct trace_t *
trace_create(
	const char *trace_file, 
	const struct glue_vhdl_cb *callbacks
);

/** destroy the trace instance.
 *  @param s trace instance.
 */
extern void
trace_destroy(struct trace_t *s, const struct glue_vhdl_cb *callbacks);

/** add a signal to the set of traced signals.
 *  @param s trace instance.
 *  @param sigptr pointer to signal instance to trace.
 *  @param name name of the signal
 *  @param type basic type of the signal.
 *  @param display_bits override display bits with this. (-1 means do not
 *  	   override)
 *  @param display_type vhdl base type, which can override values being
 *         presented.
 *  @param callbacks callbacks that must have a log callback registered.
 *  @param array_size number of array elements
 */
extern void
trace_add_signal(
	struct trace_t *s,
	const union fauhdli_value *sigptr,
	const char *name, 
	enum type_kind type,
	int display_bits,
	const char *display_type,
	const struct glue_vhdl_cb *callbacks,
	int array_size
);

/** Tell the tracer to advance the simulation time.
 *  @param s trace instance.
 *  @param sim_time new value of the simulation time.
 */
extern void
trace_time_advance(struct trace_t *s, universal_integer sim_time);

#endif /* __TRACE_H_INCLUDED */
