# frozen_string_literal: true

describe Facts::Macosx::Virtual do
  subject(:fact) { Facts::Macosx::Virtual.new }

  describe '#call_the_resolver' do
    before do
      allow(Facter::Resolvers::Macosx::SystemProfiler).to receive(:resolve)
        .with(:model_identifier)
        .and_return('MacBookPro11,4')

      allow(Facter::Resolvers::Macosx::SystemProfiler).to receive(:resolve)
        .with(:boot_rom_version)
        .and_return('1037.60.58.0.0 (iBridge: 17.16.12551.0.0,0)')

      allow(Facter::Resolvers::Macosx::SystemProfiler).to receive(:resolve)
        .with(:subsystem_vendor_id)
        .and_return('0x123')
    end

    context 'when on physical machine' do
      it 'returns resolved fact with true value' do
        expect(fact.call_the_resolver)
          .to be_an_instance_of(Facter::ResolvedFact)
          .and have_attributes(name: 'virtual', value: 'physical')

        fact.call_the_resolver
      end
    end

    context 'when on virtual machine' do
      context 'with hypervisor vmware' do
        before do
          allow(Facter::Resolvers::Macosx::SystemProfiler)
            .to receive(:resolve)
            .with(:model_identifier)
            .and_return('VMware')
        end

        it 'returns resolved fact with true value' do
          expect(fact.call_the_resolver)
            .to be_an_instance_of(Facter::ResolvedFact)
            .and have_attributes(name: 'virtual', value: 'vmware')
        end
      end

      context 'when hypervisor VirtualBox' do
        before do
          allow(Facter::Resolvers::Macosx::SystemProfiler)
            .to receive(:resolve)
            .with(:boot_rom_version)
            .and_return('VirtualBox')
        end

        it 'returns resolved fact with true value' do
          expect(fact.call_the_resolver)
            .to be_an_instance_of(Facter::ResolvedFact)
            .and have_attributes(name: 'virtual', value: 'virtualbox')
        end
      end

      context 'when hypervisor Parallels' do
        before do
          allow(Facter::Resolvers::Macosx::SystemProfiler)
            .to receive(:resolve)
            .with(:subsystem_vendor_id)
            .and_return('0x1ab8')
        end

        it 'returns resolved fact with true value' do
          expect(fact.call_the_resolver)
            .to be_an_instance_of(Facter::ResolvedFact)
            .and have_attributes(name: 'virtual', value: 'parallels')
        end
      end
    end
  end
end
