/* -*-Mode: C;-*-
 * Module:      gausslats.h - Definitions of Gaussian latitudes.
 *
 * Copyright:	1994, Regents of the University of California
 *		This software may not be distributed to others without
 *		permission of the author.
 *
 * Author:      Bob Drach, Lawrence Livermore National Laboratory
 *              drach@llnl.gov
 *
 * Version:     $Id$
 *
 * Revision History:
 *
 * $Log: gaussLats.h,v $
 * Revision 1.2  1994/10/25  00:59:13  drach
 * - Added R40 grid
 *
 * Revision 1.1  1994/08/12  21:45:48  drach
 * Entered into CVS
 *
 *
 */



#define T21_LEN 32
#define R15_LEN 40
#define T32_LEN 48
#define R21_LEN 56
#define T42_LEN 64
#define R31_LEN 80
#define T63_LEN 96
#define R40_LEN 102
#define T106_LEN 160

static double t21Lats[T21_LEN+2] = { 90.0,
 0.85760587120445E+02, 0.80268779072251E+02, 0.74744540368636E+02, 0.69212976169371E+02,
 0.63678635561097E+02, 0.58142954049203E+02, 0.52606526034345E+02, 0.47069642059688E+02,
 0.41532461246656E+02, 0.35995078411272E+02, 0.30457553961152E+02, 0.24919928629948E+02,
 0.19382231346434E+02, 0.13844483734385E+02, 0.83067028565188E+01, 0.27689030077360E+01,
-0.27689030077360E+01,-0.83067028565188E+01,-0.13844483734385E+02,-0.19382231346434E+02,
-0.24919928629948E+02,-0.30457553961152E+02,-0.35995078411272E+02,-0.41532461246656E+02,
-0.47069642059688E+02,-0.52606526034345E+02,-0.58142954049203E+02,-0.63678635561097E+02,
-0.69212976169371E+02,-0.74744540368636E+02,-0.80268779072251E+02,-0.85760587120445E+02,
 -90.0};

static double r15Lats[R15_LEN+2] = { 90.0,
 0.86597954212835E+02, 0.82190885554948E+02, 0.77757791251976E+02, 0.73318817296172E+02,
 0.68877613808930E+02, 0.64435332287914E+02, 0.59992449212443E+02, 0.55549197158977E+02,
 0.51105703159234E+02, 0.46662042537064E+02, 0.42218262871435E+02, 0.37774395783429E+02,
 0.33330463202456E+02, 0.28886480912748E+02, 0.24442460668163E+02, 0.19998411511672E+02,
 0.15554340633426E+02, 0.11110253951903E+02, 0.66661565251761E+01, 0.22220528574090E+01,
-0.22220528574090E+01,-0.66661565251761E+01,-0.11110253951903E+02,-0.15554340633426E+02,
-0.19998411511672E+02,-0.24442460668163E+02,-0.28886480912748E+02,-0.33330463202456E+02,
-0.37774395783429E+02,-0.42218262871435E+02,-0.46662042537064E+02,-0.51105703159234E+02,
-0.55549197158977E+02,-0.59992449212443E+02,-0.64435332287914E+02,-0.68877613808930E+02,
-0.73318817296172E+02,-0.77757791251976E+02,-0.82190885554948E+02,-0.86597954212835E+02,
 -90.0};

static double t32Lats[T32_LEN+2] = { 90.0,
 0.87159094555866E+02, 0.83478936669319E+02, 0.79777045654826E+02, 0.76070244462545E+02,
 0.72361581029344E+02, 0.68652016789517E+02, 0.64941949488758E+02, 0.61231573188077E+02,
 0.57520993797970E+02, 0.53810274031941E+02, 0.50099453412987E+02, 0.46388558111605E+02,
 0.42677606172605E+02, 0.38966610469454E+02, 0.35255580461368E+02, 0.31544523284022E+02,
 0.27833444451993E+02, 0.24122348326088E+02, 0.20411238433568E+02, 0.16700117693843E+02,
 0.12988988582088E+02, 0.92778532515079E+01, 0.55667136279136E+01, 0.18555714859933E+01,
-0.18555714859933E+01,-0.55667136279136E+01,-0.92778532515079E+01,-0.12988988582088E+02,
-0.16700117693843E+02,-0.20411238433568E+02,-0.24122348326088E+02,-0.27833444451993E+02,
-0.31544523284022E+02,-0.35255580461368E+02,-0.38966610469454E+02,-0.42677606172605E+02,
-0.46388558111605E+02,-0.50099453412987E+02,-0.53810274031941E+02,-0.57520993797970E+02,
-0.61231573188077E+02,-0.64941949488758E+02,-0.68652016789517E+02,-0.72361581029344E+02,
-0.76070244462545E+02,-0.79777045654826E+02,-0.83478936669319E+02,-0.87159094555866E+02,
 -90.0};

static double r21Lats[R21_LEN+2] = { 90.0,
 0.87561335285568E+02, 0.84402246942727E+02, 0.81224502565854E+02, 0.78042543117275E+02,
 0.74858984933994E+02, 0.71674653274293E+02, 0.68489889517576E+02, 0.65304860195126E+02,
 0.62119656165245E+02, 0.58934331201119E+02, 0.55748919163754E+02, 0.52563442446061E+02,
 0.49377916458473E+02, 0.46192352163669E+02, 0.43006757583317E+02, 0.39821138732503E+02,
 0.36635500220498E+02, 0.33449845649242E+02, 0.30264177884999E+02, 0.27078499248141E+02,
 0.23892811648733E+02, 0.20707116685476E+02, 0.17521415719380E+02, 0.14335709929790E+02,
 0.11150000357943E+02, 0.79642879416817E+01, 0.47785735439230E+01, 0.15928579768305E+01,
-0.15928579768305E+01,-0.47785735439230E+01,-0.79642879416817E+01,-0.11150000357943E+02,
-0.14335709929790E+02,-0.17521415719380E+02,-0.20707116685476E+02,-0.23892811648733E+02,
-0.27078499248141E+02,-0.30264177884999E+02,-0.33449845649242E+02,-0.36635500220498E+02,
-0.39821138732503E+02,-0.43006757583317E+02,-0.46192352163669E+02,-0.49377916458473E+02,
-0.52563442446061E+02,-0.55748919163754E+02,-0.58934331201119E+02,-0.62119656165245E+02,
-0.65304860195126E+02,-0.68489889517576E+02,-0.71674653274293E+02,-0.74858984933994E+02,
-0.78042543117275E+02,-0.81224502565854E+02,-0.84402246942727E+02,-0.87561335285568E+02,
 -90.0};

static double t42Lats[T42_LEN+2] = { 90.0,
 0.87863798839235E+02, 0.85096526988318E+02, 0.82312912947887E+02, 0.79525606572659E+02,
 0.76736899680368E+02, 0.73947515153990E+02, 0.71157752011587E+02, 0.68367756108313E+02,
 0.65577607010828E+02, 0.62787351798963E+02, 0.59997020108491E+02, 0.57206631527643E+02,
 0.54416199526086E+02, 0.51625733674938E+02, 0.48835240966250E+02, 0.46044726631102E+02,
 0.43254194665351E+02, 0.40463648178115E+02, 0.37673089629045E+02, 0.34882520993773E+02,
 0.32091943881744E+02, 0.29301359621763E+02, 0.26510769325211E+02, 0.23720173933535E+02,
 0.20929574254490E+02, 0.18138970990239E+02, 0.15348364759492E+02, 0.12557756115231E+02,
 0.97671455591956E+01, 0.69765335539487E+01, 0.41859205331892E+01, 0.13953069108195E+01,
-0.13953069108195E+01,-0.41859205331892E+01,-0.69765335539487E+01,-0.97671455591956E+01,
-0.12557756115231E+02,-0.15348364759492E+02,-0.18138970990239E+02,-0.20929574254490E+02,
-0.23720173933535E+02,-0.26510769325211E+02,-0.29301359621763E+02,-0.32091943881744E+02,
-0.34882520993773E+02,-0.37673089629045E+02,-0.40463648178115E+02,-0.43254194665351E+02,
-0.46044726631102E+02,-0.48835240966250E+02,-0.51625733674938E+02,-0.54416199526086E+02,
-0.57206631527643E+02,-0.59997020108491E+02,-0.62787351798963E+02,-0.65577607010828E+02,
-0.68367756108313E+02,-0.71157752011587E+02,-0.73947515153990E+02,-0.76736899680368E+02,
-0.79525606572659E+02,-0.82312912947887E+02,-0.85096526988318E+02,-0.87863798839235E+02,
 -90.0};

static double r31Lats[R31_LEN+2] = { 90.0,
 0.88288379267616E+02, 0.86071116222004E+02, 0.83840759055046E+02, 0.81607443388288E+02,
 0.79373005516595E+02, 0.77138024633268E+02, 0.74902740311571E+02, 0.72667269403298E+02,
 0.70431675646397E+02, 0.68195996748286E+02, 0.65960256438704E+02, 0.63724470396021E+02,
 0.61488649395195E+02, 0.59252801086411E+02, 0.57016931052170E+02, 0.54781043462613E+02,
 0.52545141496602E+02, 0.50309227620722E+02, 0.48073303779176E+02, 0.45837371526077E+02,
 0.43601432119569E+02, 0.41365486590024E+02, 0.39129535790308E+02, 0.36893580433377E+02,
 0.34657621120798E+02, 0.32421658364662E+02, 0.30185692604616E+02, 0.27949724221253E+02,
 0.25713753546746E+02, 0.23477780873385E+02, 0.21241806460492E+02, 0.19005830540092E+02,
 0.16769853321590E+02, 0.14533874995695E+02, 0.12297895737733E+02, 0.10061915710489E+02,
 0.78259350666721E+01, 0.55899539511030E+01, 0.33539725026723E+01, 0.11179908561455E+01,
-0.11179908561455E+01,-0.33539725026723E+01,-0.55899539511030E+01,-0.78259350666721E+01,
-0.10061915710489E+02,-0.12297895737733E+02,-0.14533874995695E+02,-0.16769853321590E+02,
-0.19005830540092E+02,-0.21241806460492E+02,-0.23477780873385E+02,-0.25713753546746E+02,
-0.27949724221253E+02,-0.30185692604616E+02,-0.32421658364662E+02,-0.34657621120798E+02,
-0.36893580433377E+02,-0.39129535790308E+02,-0.41365486590024E+02,-0.43601432119569E+02,
-0.45837371526077E+02,-0.48073303779176E+02,-0.50309227620722E+02,-0.52545141496602E+02,
-0.54781043462613E+02,-0.57016931052170E+02,-0.59252801086411E+02,-0.61488649395195E+02,
-0.63724470396021E+02,-0.65960256438704E+02,-0.68195996748286E+02,-0.70431675646397E+02,
-0.72667269403298E+02,-0.74902740311571E+02,-0.77138024633268E+02,-0.79373005516595E+02,
-0.81607443388288E+02,-0.83840759055046E+02,-0.86071116222004E+02,-0.88288379267616E+02,
 -90.0};

static double t63Lats[T63_LEN+2] = { 90.0,
 0.88572168514010E+02, 0.86722530954669E+02, 0.84861970292044E+02, 0.82998941642838E+02,
 0.81134976837678E+02, 0.79270559034861E+02, 0.77405888082079E+02, 0.75541061452879E+02,
 0.73676132313210E+02, 0.71811132114274E+02, 0.69946080646983E+02, 0.68080990985652E+02,
 0.66215872113999E+02, 0.64350730408872E+02, 0.62485570522036E+02, 0.60620395926826E+02,
 0.58755209269380E+02, 0.56890012601357E+02, 0.55024807538312E+02, 0.53159595370020E+02,
 0.51294377138951E+02, 0.49429153697123E+02, 0.47563925747979E+02, 0.45698693877702E+02,
 0.43833458578951E+02, 0.41968220269075E+02, 0.40102979304249E+02, 0.38237735990564E+02,
 0.36372490592812E+02, 0.34507243341501E+02, 0.32641994438518E+02, 0.30776744061723E+02,
 0.28911492368718E+02, 0.27046239499945E+02, 0.25180985581271E+02, 0.23315730726141E+02,
 0.21450475037398E+02, 0.19585218608822E+02, 0.17719961526447E+02, 0.15854703869695E+02,
 0.13989445712357E+02, 0.12124187123456E+02, 0.10258928168006E+02, 0.83936689076924E+01,
 0.65284094014800E+01, 0.46631497061779E+01, 0.27978898769568E+01, 0.93262996783805E+00,
-0.93262996783805E+00,-0.27978898769568E+01,-0.46631497061779E+01,-0.65284094014800E+01,
-0.83936689076924E+01,-0.10258928168006E+02,-0.12124187123456E+02,-0.13989445712357E+02,
-0.15854703869695E+02,-0.17719961526447E+02,-0.19585218608822E+02,-0.21450475037398E+02,
-0.23315730726141E+02,-0.25180985581271E+02,-0.27046239499945E+02,-0.28911492368718E+02,
-0.30776744061723E+02,-0.32641994438518E+02,-0.34507243341501E+02,-0.36372490592812E+02,
-0.38237735990564E+02,-0.40102979304249E+02,-0.41968220269075E+02,-0.43833458578951E+02,
-0.45698693877702E+02,-0.47563925747979E+02,-0.49429153697123E+02,-0.51294377138951E+02,
-0.53159595370020E+02,-0.55024807538312E+02,-0.56890012601357E+02,-0.58755209269380E+02,
-0.60620395926826E+02,-0.62485570522036E+02,-0.64350730408872E+02,-0.66215872113999E+02,
-0.68080990985652E+02,-0.69946080646983E+02,-0.71811132114274E+02,-0.73676132313210E+02,
-0.75541061452879E+02,-0.77405888082079E+02,-0.79270559034861E+02,-0.81134976837678E+02,
-0.82998941642838E+02,-0.84861970292044E+02,-0.86722530954669E+02,-0.88572168514010E+02,
 -90.0};

static double r40Lats[R40_LEN+2] = { 90.0,
 0.88655748210102E+02, 0.86914381231598E+02, 0.85162730544504E+02, 0.83408756335181E+02,
 0.81653900766134E+02, 0.79898618712720E+02, 0.78143098323582E+02, 0.76387431365792E+02,
 0.74631667892398E+02, 0.72875837512789E+02, 0.71119958858586E+02, 0.69364044237958E+02,
 0.67608102107902E+02, 0.65852138471109E+02, 0.64096157706139E+02, 0.62340163082069E+02,
 0.60584157089161E+02, 0.58828141657961E+02, 0.57072118308388E+02, 0.55316088253607E+02,
 0.53560052473900E+02, 0.51804011770183E+02, 0.50047966803437E+02, 0.48291918124176E+02,
 0.46535866194786E+02, 0.44779811406672E+02, 0.43023754093555E+02, 0.41267694541909E+02,
 0.39511632999215E+02, 0.37755569680566E+02, 0.35999504773979E+02, 0.34243438444712E+02,
 0.32487370838797E+02, 0.30731302085950E+02, 0.28975232301977E+02, 0.27219161590792E+02,
 0.25463090046107E+02, 0.23707017752859E+02, 0.21950944788430E+02, 0.20194871223677E+02,
 0.18438797123838E+02, 0.16682722549301E+02, 0.14926647556282E+02, 0.13170572197421E+02,
 0.11414496522311E+02, 0.96584205779655E+01, 0.79023444092484E+01, 0.61462680592605E+01,
 0.43901915696985E+01, 0.26341149811898E+01, 0.87803833361026E+00,-0.87803833361026E+00,
-0.26341149811898E+01,-0.43901915696985E+01,-0.61462680592605E+01,-0.79023444092484E+01,
-0.96584205779655E+01,-0.11414496522311E+02,-0.13170572197421E+02,-0.14926647556282E+02,
-0.16682722549301E+02,-0.18438797123838E+02,-0.20194871223677E+02,-0.21950944788430E+02,
-0.23707017752859E+02,-0.25463090046107E+02,-0.27219161590792E+02,-0.28975232301977E+02,
-0.30731302085950E+02,-0.32487370838797E+02,-0.34243438444712E+02,-0.35999504773979E+02,
-0.37755569680566E+02,-0.39511632999215E+02,-0.41267694541909E+02,-0.43023754093555E+02,
-0.44779811406672E+02,-0.46535866194786E+02,-0.48291918124176E+02,-0.50047966803437E+02,
-0.51804011770183E+02,-0.53560052473900E+02,-0.55316088253607E+02,-0.57072118308388E+02,
-0.58828141657961E+02,-0.60584157089161E+02,-0.62340163082069E+02,-0.64096157706139E+02,
-0.65852138471109E+02,-0.67608102107902E+02,-0.69364044237958E+02,-0.71119958858586E+02,
-0.72875837512789E+02,-0.74631667892398E+02,-0.76387431365792E+02,-0.78143098323582E+02,
-0.79898618712720E+02,-0.81653900766134E+02,-0.83408756335181E+02,-0.85162730544504E+02,
-0.86914381231598E+02,-0.88655748210102E+02,
 -90.0};

static double t106Lats[T106_LEN+2] = { 90.0,
 0.89141519426470E+02, 0.88029428867955E+02, 0.86910770814124E+02, 0.85790628883637E+02,
 0.84669924084448E+02, 0.83548946912543E+02, 0.82427817524009E+02, 0.81306594522669E+02,
 0.80185309872478E+02, 0.79063982481409E+02, 0.77942624246673E+02, 0.76821243027101E+02,
 0.75699844222012E+02, 0.74578431663296E+02, 0.73457008145583E+02, 0.72335575754909E+02,
 0.71214136079887E+02, 0.70092690351624E+02, 0.68971239538936E+02, 0.67849784414670E+02,
 0.66728325602882E+02, 0.65606863613010E+02, 0.64485398865043E+02, 0.63363931708340E+02,
 0.62242462435891E+02, 0.61120991295252E+02, 0.59999518497041E+02, 0.58878044221583E+02,
 0.57756568624184E+02, 0.56635091839330E+02, 0.55513613984077E+02, 0.54392135160792E+02,
 0.53270655459398E+02, 0.52149174959221E+02, 0.51027693730508E+02, 0.49906211835711E+02,
 0.48784729330535E+02, 0.47663246264842E+02, 0.46541762683406E+02, 0.45420278626548E+02,
 0.44298794130694E+02, 0.43177309228835E+02, 0.42055823950935E+02, 0.40934338324279E+02,
 0.39812852373771E+02, 0.38691366122202E+02, 0.37569879590472E+02, 0.36448392797794E+02,
 0.35326905761872E+02, 0.34205418499049E+02, 0.33083931024446E+02, 0.31962443352088E+02,
 0.30840955495002E+02, 0.29719467465319E+02, 0.28597979274356E+02, 0.27476490932696E+02,
 0.26355002450250E+02, 0.25233513836324E+02, 0.24112025099671E+02, 0.22990536248541E+02,
 0.21869047290730E+02, 0.20747558233616E+02, 0.19626069084199E+02, 0.18504579849136E+02,
 0.17383090534771E+02, 0.16261601147162E+02, 0.15140111692111E+02, 0.14018622175186E+02,
 0.12897132601745E+02, 0.11775642976956E+02, 0.10654153305818E+02, 0.95326635931757E+01,
 0.84111738437432E+01, 0.72896840621151E+01, 0.61681942527845E+01, 0.50467044201572E+01,
 0.39252145685665E+01, 0.28037247022868E+01, 0.16822348255471E+01, 0.56074494254426E+00,
-0.56074494254426E+00,-0.16822348255471E+01,-0.28037247022868E+01,-0.39252145685665E+01,
-0.50467044201572E+01,-0.61681942527845E+01,-0.72896840621151E+01,-0.84111738437432E+01,
-0.95326635931757E+01,-0.10654153305818E+02,-0.11775642976956E+02,-0.12897132601745E+02,
-0.14018622175186E+02,-0.15140111692111E+02,-0.16261601147162E+02,-0.17383090534771E+02,
-0.18504579849136E+02,-0.19626069084199E+02,-0.20747558233616E+02,-0.21869047290730E+02,
-0.22990536248541E+02,-0.24112025099671E+02,-0.25233513836324E+02,-0.26355002450250E+02,
-0.27476490932696E+02,-0.28597979274356E+02,-0.29719467465319E+02,-0.30840955495002E+02,
-0.31962443352088E+02,-0.33083931024446E+02,-0.34205418499049E+02,-0.35326905761872E+02,
-0.36448392797794E+02,-0.37569879590472E+02,-0.38691366122202E+02,-0.39812852373771E+02,
-0.40934338324279E+02,-0.42055823950935E+02,-0.43177309228835E+02,-0.44298794130694E+02,
-0.45420278626548E+02,-0.46541762683406E+02,-0.47663246264842E+02,-0.48784729330535E+02,
-0.49906211835711E+02,-0.51027693730508E+02,-0.52149174959221E+02,-0.53270655459398E+02,
-0.54392135160792E+02,-0.55513613984077E+02,-0.56635091839330E+02,-0.57756568624184E+02,
-0.58878044221583E+02,-0.59999518497041E+02,-0.61120991295252E+02,-0.62242462435891E+02,
-0.63363931708340E+02,-0.64485398865043E+02,-0.65606863613010E+02,-0.66728325602882E+02,
-0.67849784414670E+02,-0.68971239538936E+02,-0.70092690351624E+02,-0.71214136079887E+02,
-0.72335575754909E+02,-0.73457008145583E+02,-0.74578431663296E+02,-0.75699844222012E+02,
-0.76821243027101E+02,-0.77942624246673E+02,-0.79063982481409E+02,-0.80185309872478E+02,
-0.81306594522669E+02,-0.82427817524009E+02,-0.83548946912543E+02,-0.84669924084448E+02,
-0.85790628883637E+02,-0.86910770814124E+02,-0.88029428867955E+02,-0.89141519426470E+02,
 -90.0};
