from __future__ import absolute_import, division, print_function
# CNS 1.1 spacegroup.lib symbols
sgtbx_lookup_symbol_as_cns_symbol = {
"P1": "P1",
"P-1": "P-1",
"P121": "P2",
"P1211": "P2(1)",
"C121": "C2",
"P1m1": "PM",
"P1c1": "PC",
"C1m1": "CM",
"C1c1": "CC",
"P12/m1": "P2/M",
"P121/m1": "P2(1)/M",
"C12/m1": "C2/M",
"P12/c1": "P2/C",
"P121/c1": "P2(1)/C",
"C12/c1": "C2/C",
"P222": "P222",
"P2221": "P222(1)",
"P21212": "P2(1)2(1)2",
"P212121": "P2(1)2(1)2(1)",
"C2221": "C222(1)",
"C222": "C222",
"F222": "F222",
"I222": "I222",
"I212121": "I2(1)2(1)2(1)",
"Pmm2": "PMM2",
"Pmc21": "PMC2(1)",
"Pcc2": "PCC2",
"Pma2": "PMA2",
"Pca21": "PCA2(1)",
"Pnc2": "PNC2",
"Pmn21": "PMN2(1)",
"Pba2": "PBA2",
"Pna21": "PNA2(1)",
"Pnn2": "PNN2",
"Cmm2": "CMM2",
"Cmc21": "CMC2(1)",
"Ccc2": "CCC2",
"Amm2": "AMM2",
"Abm2": "ABM2",
"Ama2": "AMA2",
"Aba2": "ABA2",
"Fmm2": "FMM2",
"Fdd2": "FDD2",
"Imm2": "IMM2",
"Iba2": "IBA2",
"Ima2": "IMA2",
"Pmmm": "PMMM",
"Pnnn:2": "PNNN",
"Pccm": "PCCM",
"Pban:2": "PBAN",
"Pmma": "PMMA",
"Pnna": "PNNA",
"Pmna": "PMNA",
"Pcca": "PCCA",
"Pbam": "PBAM",
"Pccn": "PCCN",
"Pbcm": "PBCM",
"Pnnm": "PNNM",
"Pmmn:2": "PMMN",
"Pbcn": "PBCN",
"Pbca": "PBCA",
"Pnma": "PNMA",
"Cmcm": "CMCM",
"Cmca": "CMCA",
"Cmmm": "CMMM",
"Ammm": "AMMM",
"Cccm": "CCCM",
"Cmma": "CMMA",
"Ccca:2": "CCCA",
"Fmmm": "FMMM",
"Fddd:2": "FDDD",
"Immm": "IMMM",
"Ibam": "IBAM",
"Ibca": "IBCA",
"Imma": "IMMA",
"P4": "P4",
"P41": "P4(1)",
"P42": "P4(2)",
"P43": "P4(3)",
"I4": "I4",
"I41": "I4(1)",
"P-4": "P-4",
"I-4": "I-4",
"P4/m": "P4/M",
"P42/m": "P4(2)/M",
"P4/n:2": "P4/N",
"P42/n:2": "P4(2)/N",
"I4/m": "I4/M",
"I41/a:2": "I4(1)/A",
"P422": "P422",
"P4212": "P42(1)2",
"P4122": "P4(1)22",
"P41212": "P4(1)2(1)2",
"P4222": "P4(2)22",
"P42212": "P4(2)2(1)2",
"P4322": "P4(3)22",
"P43212": "P4(3)2(1)2",
"I422": "I422",
"I4122": "I4(1)22",
"P4mm": "P4MM",
"P4bm": "P4BM",
"P42cm": "P4(2)CM",
"P42nm": "P4(2)NM",
"P4cc": "P4CC",
"P4nc": "P4NC",
"P42mc": "P4(2)MC",
"P42bc": "P4(2)BC",
"I4mm": "I4MM",
"I4cm": "I4CM",
"I41md": "I4(1)MD",
"I41cd": "I4(1)CD",
"P-42m": "P-42M",
"P-42c": "P-42C",
"P-421m": "P-42(1)M",
"P-421c": "P-42(1)C",
"P-4m2": "P-4M2",
"P-4c2": "P-4C2",
"P-4b2": "P-4B2",
"P-4n2": "P-4N2",
"I-4m2": "I-4M2",
"I-4c2": "I-4C2",
"I-42m": "I-42M",
"I-42d": "I-42D",
"P4/mmm": "P4/MMM",
"P4/mcc": "P4/MCC",
"P4/nbm:2": "P4/NBM",
"P4/nnc:2": "P4/NNC",
"P4/mbm": "P4/MBM",
"P4/mnc": "P4/MNC",
"P4/nmm:2": "P4/NMM",
"P4/ncc:2": "P4/NCC",
"P42/mmc": "P4(2)/MMC",
"P42/mcm": "P4(2)/MCM",
"P42/nbc:2": "P4(2)/NBC",
"P42/nnm:2": "P4(2)/NNM",
"P42/mbc": "P4(2)/MBC",
"P42/mnm": "P4(2)/MNM",
"P42/nmc:2": "P4(2)/NMC",
"P42/ncm:2": "P4(2)/NCM",
"I4/mmm": "I4/MMM",
"I4/mcm": "I4/MCM",
"I41/amd:2": "I4(1)/AMD",
"I41/acd:2": "I4(1)/ACD",
"P3": "P3",
"P31": "P3(1)",
"P32": "P3(2)",
"R3:H": "R3",
"R3:R": "R3R",
"P-3": "P-3",
"R-3:H": "R-3",
"R-3:R": "R-3R",
"P312": "P312",
"P321": "P321",
"P3112": "P3(1)12",
"P3121": "P3(1)21",
"P3212": "P3(2)12",
"P3221": "P3(2)21",
"R32:H": "R32",
"R32:R": "R32R",
"P3m1": "P3M1",
"P31m": "P31M",
"P3c1": "P3C1",
"P31c": "P31C",
"R3m:H": "R3M",
"R3m:R": "R3MR",
"R3c:H": "R3C",
"R3c:R": "R3CR",
"P-31m": "P-31M",
"P-31c": "P-31C",
"P-3m1": "P-3M1",
"P-3c1": "P-3C1",
"R-3m:H": "R-3M",
"R-3m:R": "R-3MR",
"R-3c:H": "R-3C",
"R-3c:R": "R-3CR",
"P6": "P6",
"P61": "P6(1)",
"P65": "P6(5)",
"P62": "P6(2)",
"P64": "P6(4)",
"P63": "P6(3)",
"P-6": "P-6",
"P6/m": "P6/M",
"P63/m": "P6(3)/M",
"P622": "P622",
"P6122": "P6(1)22",
"P6522": "P6(5)22",
"P6222": "P6(2)22",
"P6422": "P6(4)22",
"P6322": "P6(3)22",
"P6mm": "P6MM",
"P6cc": "P6CC",
"P63cm": "P6(3)CM",
"P63mc": "P6(3)MC",
"P-6m2": "P-6M2",
"P-6c2": "P-6C2",
"P-62m": "P-62M",
"P-62c": "P-62C",
"P6/mmm": "P6/MMM",
"P6/mcc": "P6/MCC",
"P63/mcm": "P6(3)/MCM",
"P63/mmc": "P6(3)/MMC",
"P23": "P23",
"F23": "F23",
"I23": "I23",
"P213": "P2(1)3",
"I213": "I2(1)3",
"Pm-3": "PM-3",
"Pn-3:2": "PN-3",
"Fm-3": "FM-3",
"Fd-3:2": "FD-3",
"Im-3": "IM-3",
"Pa-3": "PA-3",
"Ia-3": "IA-3",
"P432": "P432",
"P4232": "P4(2)32",
"F432": "F432",
"F4132": "F4(1)32",
"I432": "I432",
"P4332": "P4(3)32",
"P4132": "P4(1)32",
"I4132": "I4(1)32",
"P-43m": "P-43M",
"F-43m": "F-43M",
"I-43m": "I-43M",
"P-43n": "P-43N",
"F-43c": "F-43C",
"I-43d": "I-43D",
"Pm-3m": "PM-3M",
"Pn-3n:2": "PN-3N",
"Pm-3n": "PM-3N",
"Pn-3m:2": "PN-3M",
"Fm-3m": "FM-3M",
"Fm-3c": "FM-3C",
"Fd-3m:2": "FD-3M",
"Fd-3c:2": "FD-3C",
"Im-3m": "IM-3M",
"Ia-3d": "IA-3D"
}

def cns_format(space_group_info):
  return sgtbx_lookup_symbol_as_cns_symbol.get(
    str(space_group_info).replace(" ",""))

def _regression_test():
  from cctbx import sgtbx
  for symbol in sgtbx_lookup_symbol_as_cns_symbol.values():
    cns_symbol = cns_format(sgtbx.space_group_info(symbol))
    assert cns_symbol == symbol, (cns_symbol, symbol)
  print("OK")

if (__name__ == "__main__"):
  _regression_test()
