/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_Resizable({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.util.Observable","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><strong>Ext.Resizable</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/Resizable.html#Ext-Resizable' target='_blank'>Resizable.js</a></div></pre><div class='doc-contents'><p>Applies drag handles to an element to make it resizable. The drag handles are inserted into the element\nand positioned absolute. Some elements, such as a textarea or image, don't support this. To overcome that, you can wrap\nthe textarea in a div and set 'resizeChild' to true (or to the id of the element), <b>or</b> set wrap:true in your config and\nthe element will be wrapped for you automatically.</p>\n\n\n<p>Here is the list of valid resize handles:</p>\n\n\n<pre>Value   Description\n------  -------------------\n 'n'     north\n 's'     south\n 'e'     east\n 'w'     west\n 'nw'    northwest\n 'sw'    southwest\n 'se'    southeast\n 'ne'    northeast\n 'all'   all\n</pre>\n\n\n<p>Here's an example showing the creation of a typical Resizable:</p>\n\n\n<pre><code>var resizer = new <a href=\"#!/api/Ext.Resizable\" rel=\"Ext.Resizable\" class=\"docClass\">Ext.Resizable</a>('element-id', {\n    handles: 'all',\n    minWidth: 200,\n    minHeight: 100,\n    maxWidth: 500,\n    maxHeight: 400,\n    pinned: true\n});\nresizer.on('resize', myHandler);\n</code></pre>\n\n\n<p>To hide a particular handle, set its display to none in CSS, or through script:<br>\nresizer.east.setDisplayed(false);</p>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-adjustments' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-adjustments' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-adjustments' class='name expandable'>adjustments</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>String 'auto' or an array [width, height] with values to be added to the\nresize operation's new size (defaults to [0,...</div><div class='long'><p>String 'auto' or an array [width, height] with values to be <b>added</b> to the\nresize operation's new size (defaults to <tt>[0, 0]</tt>)</p>\n<p>Defaults to: <code>[0, 0]</code></p></div></div></div><div id='cfg-animate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-animate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-animate' class='name expandable'>animate</a><span> : Boolean</span></div><div class='description'><div class='short'>True to animate the resize (not compatible with dynamic sizing, defaults to false) ...</div><div class='long'><p>True to animate the resize (not compatible with dynamic sizing, defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-constrainTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-constrainTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-constrainTo' class='name not-expandable'>constrainTo</a><span> : Mixed</span></div><div class='description'><div class='short'><p>Constrain the resize to a particular element</p>\n</div><div class='long'><p>Constrain the resize to a particular element</p>\n</div></div></div><div id='cfg-disableTrackOver' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-disableTrackOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-disableTrackOver' class='name expandable'>disableTrackOver</a><span> : Boolean</span></div><div class='description'><div class='short'>True to disable mouse tracking. ...</div><div class='long'><p>True to disable mouse tracking. This is only applied at config time. (defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-draggable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-draggable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-draggable' class='name expandable'>draggable</a><span> : Boolean</span></div><div class='description'><div class='short'>Convenience to initialize drag drop (defaults to false) ...</div><div class='long'><p>Convenience to initialize drag drop (defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-duration' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-duration' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-duration' class='name expandable'>duration</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Animation duration if animate = true (defaults to 0.35) ...</div><div class='long'><p>Animation duration if animate = true (defaults to 0.35)</p>\n<p>Defaults to: <code>0.35</code></p></div></div></div><div id='cfg-dynamic' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-dynamic' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-dynamic' class='name expandable'>dynamic</a><span> : Boolean</span></div><div class='description'><div class='short'>True to resize the element while dragging instead of using a proxy (defaults to false) ...</div><div class='long'><p>True to resize the element while dragging instead of using a proxy (defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-easing' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-easing' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-easing' class='name expandable'>easing</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Animation easing if animate = true (defaults to 'easingOutStrong') ...</div><div class='long'><p>Animation easing if animate = true (defaults to <tt>'easingOutStrong'</tt>)</p>\n<p>Defaults to: <code>'easeOutStrong'</code></p></div></div></div><div id='cfg-enabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-enabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-enabled' class='name expandable'>enabled</a><span> : Boolean</span></div><div class='description'><div class='short'>False to disable resizing (defaults to true) ...</div><div class='long'><p>False to disable resizing (defaults to true)</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-handleCls' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-handleCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-handleCls' class='name expandable'>handleCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A css class to add to each handle. ...</div><div class='long'><p>A css class to add to each handle. Defaults to <tt>''</tt>.</p>\n</div></div></div><div id='cfg-handles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-handles' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-handles' class='name expandable'>handles</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>String consisting of the resize handles to display (defaults to undefined). ...</div><div class='long'><p>String consisting of the resize handles to display (defaults to undefined).\nSpecify either <tt>'all'</tt> or any of <tt>'n s e w ne nw se sw'</tt>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-height' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-height' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-height' class='name not-expandable'>height</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The height of the element in pixels (defaults to null)</p>\n</div><div class='long'><p>The height of the element in pixels (defaults to null)</p>\n</div></div></div><div id='cfg-heightIncrement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-heightIncrement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-heightIncrement' class='name expandable'>heightIncrement</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The increment to snap the height resize in pixels\n(only applies if dynamic==true). ...</div><div class='long'><p>The increment to snap the height resize in pixels\n(only applies if <code><a href=\"#!/api/Ext.Resizable-cfg-dynamic\" rel=\"Ext.Resizable-cfg-dynamic\" class=\"docClass\">dynamic</a>==true</code>). Defaults to <tt>0</tt>.</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-maxHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-maxHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-maxHeight' class='name expandable'>maxHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum height for the element (defaults to 10000) ...</div><div class='long'><p>The maximum height for the element (defaults to 10000)</p>\n<p>Defaults to: <code>10000</code></p></div></div></div><div id='cfg-maxWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-maxWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-maxWidth' class='name expandable'>maxWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum width for the element (defaults to 10000) ...</div><div class='long'><p>The maximum width for the element (defaults to 10000)</p>\n<p>Defaults to: <code>10000</code></p></div></div></div><div id='cfg-minHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-minHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-minHeight' class='name expandable'>minHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum height for the element (defaults to 5) ...</div><div class='long'><p>The minimum height for the element (defaults to 5)</p>\n<p>Defaults to: <code>5</code></p></div></div></div><div id='cfg-minWidth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-minWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-minWidth' class='name expandable'>minWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum width for the element (defaults to 5) ...</div><div class='long'><p>The minimum width for the element (defaults to 5)</p>\n<p>Defaults to: <code>5</code></p></div></div></div><div id='cfg-minX' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-minX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-minX' class='name expandable'>minX</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum x for the element (defaults to 0) ...</div><div class='long'><p>The minimum x for the element (defaults to 0)</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='cfg-minY' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-minY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-minY' class='name expandable'>minY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum x for the element (defaults to 0) ...</div><div class='long'><p>The minimum x for the element (defaults to 0)</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='cfg-multiDirectional' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-multiDirectional' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-multiDirectional' class='name expandable'>multiDirectional</a><span> : Boolean</span></div><div class='description'><div class='short'>Deprecated. ...</div><div class='long'><p><b>Deprecated</b>.  Deprecated style of adding multi-direction resize handles.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-pinned' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-pinned' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-pinned' class='name expandable'>pinned</a><span> : Boolean</span></div><div class='description'><div class='short'>True to ensure that the resize handles are always visible, false to display them only when the\nuser mouses over the r...</div><div class='long'><p>True to ensure that the resize handles are always visible, false to display them only when the\nuser mouses over the resizable borders. This is only applied at config time. (defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-preserveRatio' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-preserveRatio' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-preserveRatio' class='name expandable'>preserveRatio</a><span> : Boolean</span></div><div class='description'><div class='short'>True to preserve the original ratio between height\nand width during resize (defaults to false) ...</div><div class='long'><p>True to preserve the original ratio between height\nand width during resize (defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-resizeChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-resizeChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-resizeChild' class='name expandable'>resizeChild</a><span> : Boolean/String/Element</span></div><div class='description'><div class='short'>True to resize the first child, or id/element to resize (defaults to false) ...</div><div class='long'><p>True to resize the first child, or id/element to resize (defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-resizeRegion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-resizeRegion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-resizeRegion' class='name not-expandable'>resizeRegion</a><span> : Ext.lib.Region</span></div><div class='description'><div class='short'><p>Constrain the resize to a particular region</p>\n</div><div class='long'><p>Constrain the resize to a particular region</p>\n</div></div></div><div id='cfg-transparent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-transparent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-transparent' class='name expandable'>transparent</a><span> : Boolean</span></div><div class='description'><div class='short'>True for transparent handles. ...</div><div class='long'><p>True for transparent handles. This is only applied at config time. (defaults to false)</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-width' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-width' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-width' class='name not-expandable'>width</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The width of the element in pixels (defaults to null)</p>\n</div><div class='long'><p>The width of the element in pixels (defaults to null)</p>\n</div></div></div><div id='cfg-widthIncrement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-widthIncrement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-widthIncrement' class='name expandable'>widthIncrement</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The increment to snap the width resize in pixels\n(only applies if dynamic==true). ...</div><div class='long'><p>The increment to snap the width resize in pixels\n(only applies if <code><a href=\"#!/api/Ext.Resizable-cfg-dynamic\" rel=\"Ext.Resizable-cfg-dynamic\" class=\"docClass\">dynamic</a>==true</code>). Defaults to <tt>0</tt>.</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='cfg-wrap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-cfg-wrap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-cfg-wrap' class='name expandable'>wrap</a><span> : Boolean</span></div><div class='description'><div class='short'>True to wrap an element with a div if needed (required for textareas and images, defaults to false)\nin favor of the h...</div><div class='long'><p>True to wrap an element with a div if needed (required for textareas and images, defaults to false)\nin favor of the handles config option (defaults to false)</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-enabled' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-property-enabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-property-enabled' class='name expandable'>enabled</a><span> : Boolean</span></div><div class='description'><div class='short'>Writable. ...</div><div class='long'><p>Writable. False if resizing is disabled.</p>\n</div></div></div><div id='property-proxy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-property-proxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-property-proxy' class='name expandable'>proxy</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The proxy Element that is resized in place of the real Element during the resize operation. ...</div><div class='long'><p>The proxy Element that is resized in place of the real Element during the resize operation.\nThis may be queried using <a href=\"#!/api/Ext.Element-method-getBox\" rel=\"Ext.Element-method-getBox\" class=\"docClass\">Ext.Element.getBox</a> to provide the new area to resize to.\nRead only.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.Resizable-method-constructor' class='name expandable'>Ext.Resizable</a>( <span class='pre'>el, config</span> ) : <a href=\"#!/api/Ext.Resizable\" rel=\"Ext.Resizable\" class=\"docClass\">Ext.Resizable</a></div><div class='description'><div class='short'>Create a new resizable component ...</div><div class='long'><p>Create a new resizable component</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The id or element to resize</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>configuration options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Resizable\" rel=\"Ext.Resizable\" class=\"docClass\">Ext.Resizable</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-constrain' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-constrain' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-constrain' class='name expandable'>constrain</a>( <span class='pre'>v, diff, m, mx</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>v</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>diff</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>m</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>mx</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-destroy' class='name expandable'>destroy</a>( <span class='pre'>[removeEl]</span> )</div><div class='description'><div class='short'>Destroys this resizable. ...</div><div class='long'><p>Destroys this resizable. If the element was wrapped and\nremoveEl is not true then the element remains.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>removeEl</span> : Boolean (optional)<div class='sub-desc'><p>true to remove the element from the DOM</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-getEl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-getEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the element this component is bound to. ...</div><div class='long'><p>Returns the element this component is bound to.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getResizeChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-getResizeChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-getResizeChild' class='name expandable'>getResizeChild</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the resizeChild element (or null). ...</div><div class='long'><p>Returns the resizeChild element (or null).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-handleOut' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-handleOut' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-handleOut' class='name expandable'>handleOut</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-handleOver' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-handleOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-handleOver' class='name expandable'>handleOver</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-onMouseDown' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-onMouseDown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-onMouseDown' class='name expandable'>onMouseDown</a>( <span class='pre'>handle, e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handle</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMouseMove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-onMouseMove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-onMouseMove' class='name expandable'>onMouseMove</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onMouseUp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-onMouseUp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-onMouseUp' class='name expandable'>onMouseUp</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-resizeElement' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-resizeElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-resizeElement' class='name expandable'>resizeElement</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Performs resizing of the associated Element. ...</div><div class='long'><p>Performs resizing of the associated Element. This method is called internally by this\nclass, and should not be called by user code.</p>\n\n\n<p>If a Resizable is being used to resize an Element which encapsulates a more complex UI\ncomponent such as a Panel, this method may be overridden by specifying an implementation\nas a config option to provide appropriate behaviour at the end of the resize operation on\nmouseup, for example resizing the Panel, and relaying the Panel's content.</p>\n\n\n<p>The new area to be resized to is available by examining the state of the <a href=\"#!/api/Ext.Resizable-property-proxy\" rel=\"Ext.Resizable-property-proxy\" class=\"docClass\">proxy</a>\nElement. Example:\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'Resize me',\n    x: 100,\n    y: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    floating: true,\n    frame: true,\n    width: 400,\n    height: 200,\n    listeners: {\n        render: function(p) {\n            new <a href=\"#!/api/Ext.Resizable\" rel=\"Ext.Resizable\" class=\"docClass\">Ext.Resizable</a>(p.getEl(), {\n                handles: 'all',\n                pinned: true,\n                transparent: true,\n                resizeElement: function() {\n                    var box = this.proxy.getBox();\n                    p.updateBox(box);\n                    if (p.layout) {\n                        p.doLayout();\n                    }\n                    return box;\n                }\n           });\n       }\n    }\n}).show();\n</code></pre>\n\n</p></div></div></div><div id='method-resizeTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-resizeTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-resizeTo' class='name expandable'>resizeTo</a>( <span class='pre'>width, height</span> )</div><div class='description'><div class='short'>Perform a manual resize and fires the 'resize' event. ...</div><div class='long'><p>Perform a manual resize and fires the 'resize' event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-snap' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-snap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-snap' class='name expandable'>snap</a>( <span class='pre'>value, inc, min</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>inc</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>min</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-startSizing' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-startSizing' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-startSizing' class='name expandable'>startSizing</a>( <span class='pre'>e, handle</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>handle</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-syncHandleHeight' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-syncHandleHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-syncHandleHeight' class='name expandable'>syncHandleHeight</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-updateChildSize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-method-updateChildSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-method-updateChildSize' class='name expandable'>updateChildSize</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-beforeresize' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-event-beforeresize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-event-beforeresize' class='name expandable'>beforeresize</a>( <span class='pre'>this, e</span> )</div><div class='description'><div class='short'>Fired before resize is allowed. ...</div><div class='long'><p>Fired before resize is allowed. Set <a href=\"#!/api/Ext.Resizable-cfg-enabled\" rel=\"Ext.Resizable-cfg-enabled\" class=\"docClass\">enabled</a> to false to cancel resize.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Resizable\" rel=\"Ext.Resizable\" class=\"docClass\">Ext.Resizable</a><div class='sub-desc'>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The mousedown event</p>\n</div></li></ul></div></div></div><div id='event-resize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.Resizable'>Ext.Resizable</span><br/><a href='source/Resizable.html#Ext-Resizable-event-resize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Resizable-event-resize' class='name expandable'>resize</a>( <span class='pre'>this, width, height, e</span> )</div><div class='description'><div class='short'>Fired after a resize. ...</div><div class='long'><p>Fired after a resize.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Resizable\" rel=\"Ext.Resizable\" class=\"docClass\">Ext.Resizable</a><div class='sub-desc'>\n</div></li><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new width</p>\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new height</p>\n</div></li><li><span class='pre'>e</span> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class='sub-desc'><p>The mouseup event</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"Resizable.html#Ext-Resizable","filename":"Resizable.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.Resizable","meta":{},"name":"enabled","id":"property-enabled"},{"tagname":"property","owner":"Ext.Resizable","meta":{},"name":"proxy","id":"property-proxy"}],"cfg":[{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"adjustments","id":"cfg-adjustments"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"animate","id":"cfg-animate"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"constrainTo","id":"cfg-constrainTo"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"disableTrackOver","id":"cfg-disableTrackOver"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"draggable","id":"cfg-draggable"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"duration","id":"cfg-duration"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"dynamic","id":"cfg-dynamic"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"easing","id":"cfg-easing"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"enabled","id":"cfg-enabled"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"handleCls","id":"cfg-handleCls"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"handles","id":"cfg-handles"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"height","id":"cfg-height"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"heightIncrement","id":"cfg-heightIncrement"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"maxHeight","id":"cfg-maxHeight"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"maxWidth","id":"cfg-maxWidth"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"minHeight","id":"cfg-minHeight"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"minWidth","id":"cfg-minWidth"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"minX","id":"cfg-minX"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"minY","id":"cfg-minY"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"multiDirectional","id":"cfg-multiDirectional"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"pinned","id":"cfg-pinned"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"preserveRatio","id":"cfg-preserveRatio"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"resizeChild","id":"cfg-resizeChild"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"resizeRegion","id":"cfg-resizeRegion"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"transparent","id":"cfg-transparent"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"width","id":"cfg-width"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"widthIncrement","id":"cfg-widthIncrement"},{"tagname":"cfg","owner":"Ext.Resizable","meta":{},"name":"wrap","id":"cfg-wrap"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.Resizable","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"constrain","id":"method-constrain"},{"tagname":"method","owner":"Ext.Resizable","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.Resizable","meta":{},"name":"getEl","id":"method-getEl"},{"tagname":"method","owner":"Ext.Resizable","meta":{},"name":"getResizeChild","id":"method-getResizeChild"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"handleOut","id":"method-handleOut"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"handleOver","id":"method-handleOver"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"onMouseDown","id":"method-onMouseDown"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"onMouseMove","id":"method-onMouseMove"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"onMouseUp","id":"method-onMouseUp"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.Resizable","meta":{},"name":"resizeElement","id":"method-resizeElement"},{"tagname":"method","owner":"Ext.Resizable","meta":{},"name":"resizeTo","id":"method-resizeTo"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"snap","id":"method-snap"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"startSizing","id":"method-startSizing"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"syncHandleHeight","id":"method-syncHandleHeight"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.Resizable","meta":{"private":true},"name":"updateChildSize","id":"method-updateChildSize"}],"event":[{"tagname":"event","owner":"Ext.Resizable","meta":{},"name":"beforeresize","id":"event-beforeresize"},{"tagname":"event","owner":"Ext.Resizable","meta":{},"name":"resize","id":"event-resize"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.Resizable","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.Resizable","mixins":[],"mixedInto":[]});