from ctypes import c_void_p
from types import MappingProxyType, TracebackType
from typing import Any, Callable, Iterator, Literal, MutableMapping, Self, TypeAlias

from ._enums import SampleType
from ._formats import ChannelLayout, VideoFormat
from ._functions import FramePtr
from ._nodes import RawNode
from ._typings import _VapourSynthMapValue

__all__ = [
    "RawFrame",
    "VideoFrame",
    "AudioFrame",
    "FrameProps",
]

class video_view(memoryview):  # type: ignore[misc]
    @property
    def shape(self) -> tuple[int, int]: ...
    @property
    def strides(self) -> tuple[int, int]: ...
    @property
    def ndim(self) -> Literal[2]: ...
    @property
    def obj(self) -> FramePtr: ...  # type: ignore[override]
    def __getitem__(self, index: tuple[int, int]) -> int | float: ...  # type: ignore[override]
    def __setitem__(self, index: tuple[int, int], other: int | float) -> None: ...  # type: ignore[override]
    def tolist(self) -> list[int | float]: ...  # type: ignore[override]

class audio_view(memoryview):  # type: ignore[misc]
    @property
    def shape(self) -> tuple[int]: ...
    @property
    def strides(self) -> tuple[int]: ...
    @property
    def ndim(self) -> Literal[1]: ...
    @property
    def obj(self) -> FramePtr: ...  # type: ignore[override]
    def __getitem__(self, index: int) -> int | float: ...  # type: ignore[override]
    def __setitem__(self, index: int, other: int | float) -> None: ...  # type: ignore[override]
    def tolist(self) -> list[int | float]: ...  # type: ignore[override]

class RawFrame:
    @property
    def closed(self) -> bool: ...
    def close(self) -> None: ...
    def copy(self) -> Self: ...
    @property
    def props(self) -> FrameProps: ...
    @props.setter
    def props(self, new_props: MappingProxyType[str, _VapourSynthMapValue]) -> None: ...
    def get_write_ptr(self, plane: int) -> c_void_p: ...
    def get_read_ptr(self, plane: int) -> c_void_p: ...
    def get_stride(self, plane: int) -> int: ...
    @property
    def readonly(self) -> bool: ...
    def __enter__(self: Self) -> Self: ...
    def __exit__(
        self,
        exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        traceback: TracebackType | None,
        /,
    ) -> bool | None: ...
    def __getitem__(self, index: int) -> memoryview: ...
    def __len__(self) -> int: ...

class VideoFrame(RawFrame):
    format: VideoFormat
    width: int
    height: int

    def readchunks(self) -> Iterator[video_view]: ...
    def __getitem__(self, index: int) -> video_view: ...

class AudioFrame(RawFrame):
    sample_type: SampleType
    bits_per_sample: int
    bytes_per_sample: int
    channel_layout: int
    num_channels: int

    @property
    def channels(self) -> ChannelLayout: ...
    def __getitem__(self, index: int) -> audio_view: ...

_PropValue: TypeAlias = (
    int
    | float
    | str
    | bytes
    | RawFrame
    | RawNode
    | Callable[..., Any]
    | list[int]
    | list[float]
    | list[str]
    | list[bytes]
    | list[RawFrame]
    | list[RawNode]
    | list[Callable[..., Any]]
)

class FrameProps(MutableMapping[str, _PropValue]):
    def setdefault(self, key: str, default: _VapourSynthMapValue = 0) -> _PropValue: ...
    def copy(self) -> MutableMapping[str, _PropValue]: ...

    # Since we're inheriting from the MutableMapping abstract class,
    # we *have* to specify that we have indeed created these methods.
    # If we don't, mypy will complain that we're working with abstract methods.

    def __setattr__(self, name: str, value: _VapourSynthMapValue) -> None: ...
    def __getattr__(self, name: str) -> _PropValue: ...
    def __delattr__(self, name: str) -> None: ...
    def __setitem__(self, name: str, value: _VapourSynthMapValue) -> None: ...
    def __getitem__(self, name: str) -> _PropValue: ...
    def __delitem__(self, name: str) -> None: ...
    def __iter__(self) -> Iterator[str]: ...
    def __len__(self) -> int: ...
