from slidge import BaseGateway, BaseSession, LegacyContact, LegacyMUC, LegacyBookmarks, LegacyRoster, LegacyParticipant
from slidge.util.test import SlidgeTest
from slixmpp.exceptions import XMPPError

class Gateway(BaseGateway):
    COMPONENT_NAME = "Megacorp Chat XMPP Gateway"
    GROUPS = True


class Session(BaseSession):
    async def login(self):
        pass


class Contact(LegacyContact):
    pass


class Roster(LegacyRoster):
    async def legacy_id_to_jid_username(self, legacy_id: str) -> str:
        if not legacy_id.startswith("room-"):
            raise XMPPError


class Bookmarks(LegacyBookmarks):
    async def fill(self):
        pass


class TestSpaces(SlidgeTest):
    plugin = globals()

    def setUp(self):
        super().setUp()
        self._add_slidge_user()

    def test_archive_correction_no_event_id(self) -> None:
        muc = self.get_joined_muc("room-correction")
        part: LegacyParticipant = self.run_coro(muc.get_participant("part"))
        part.send_text("a body", "a-legacy-id")
        self.next_sent()  # part presence

        msg = self.next_sent()
        assert msg["body"] == "a body", msg
        assert msg["stanza_id"]["id"] == "a-legacy-id", msg
        part.correct("a-legacy-id", "a new body")
        msg = self.next_sent()
        assert msg["body"] == "a new body", msg
        correction_stanza_id = msg["stanza_id"]["id"]

        messages = list(muc.archive.get_all(before_id=correction_stanza_id))
        assert len(messages) == 1
        assert messages[0]

    def test_archive_correction_specify_event_id(self) -> None:
        muc = self.get_joined_muc("room-correction")
        part: LegacyParticipant = self.run_coro(muc.get_participant("part"))
        part.send_text("a body", "a-legacy-id")
        self.next_sent()  # part presence

        msg = self.next_sent()
        assert msg["body"] == "a body", msg
        assert msg["stanza_id"]["id"] == "a-legacy-id", msg
        part.correct("a-legacy-id", "a new body", correction_event_id="another-legacy-id")
        msg = self.next_sent()
        assert msg["body"] == "a new body", msg
        correction_stanza_id = msg["stanza_id"]["id"]
        assert correction_stanza_id == "another-legacy-id"

        messages = list(muc.archive.get_all(before_id=correction_stanza_id))
        assert len(messages) == 1
        assert messages[0]

        messages = list(muc.get_archived_messages(correction_stanza_id))
        assert len(messages) == 1

    def test_archive_correction_specify_existing_event_id(self) -> None:
        muc = self.get_joined_muc("room-correction")
        part: LegacyParticipant = self.run_coro(muc.get_participant("part"))
        part.send_text("a body", "a-legacy-id")
        self.next_sent()  # part presence

        msg = self.next_sent()
        assert msg["body"] == "a body", msg
        assert msg["stanza_id"]["id"] == "a-legacy-id", msg
        part.correct("a-legacy-id", "a new body", correction_event_id="a-legacy-id")
        msg = self.next_sent()
        assert msg["body"] == "a new body", msg
        correction_stanza_id = msg["stanza_id"]["id"]
        assert correction_stanza_id == "a-legacy-id"

        messages = list(muc.archive.get_all(before_id=correction_stanza_id))
        assert not messages
