/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QString>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/globals.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ConfigSetting.hpp"


namespace MsXpS
{

namespace MassXpert
{

class ConfigSettings

{
  public:
  ConfigSettings(const QString &application_name = QString());
  ConfigSettings(const ConfigSettings &other);
  ConfigSettings &operator=(const ConfigSettings &other);

  ~ConfigSettings();

  void setApplicationName(const QString &application_name);
  QString getApplicationName();

  QString getConfigSettingKey(const ConfigSettingSPtr &config_setting_sp) const;
  const ConfigSettingSPtr getConfigSetting(QString key,
                                           UserType user_type) const;

  std::vector<ConfigSettingSPtr> &getConfigSettingsRef();
  const std::vector<ConfigSettingSPtr> &getConfigSettingsCstRef() const;

  QString toString() const;

  protected:
  QString m_applicationName;
  std::vector<ConfigSettingSPtr> m_configSettings;
};

typedef std::shared_ptr<ConfigSettings> ConfigSettingsSPtr;
typedef std::shared_ptr<const ConfigSettings> ConfigSettingsCstSPtr;

} // namespace MassXpert
} // namespace MsXpS
