"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readHMetric = readHMetric;
exports.readVMetric = readVMetric;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const io_bin_metric_1 = require("@ot-builder/io-bin-metric");
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
const ot_metadata_1 = require("@ot-builder/ot-metadata");
function readHMetric(sfnt, maxp, hhea, designSpace) {
    const bHmtx = sfnt.tables.get(ot_glyphs_1.MetricBasic.TagHmtx);
    const bHvar = sfnt.tables.get(ot_glyphs_1.MetricVariance.TagHvar);
    if (!hhea)
        throw errors_1.Errors.MissingKeyTable(ot_metadata_1.MetricHead.TagHhea);
    if (!bHmtx)
        throw errors_1.Errors.MissingKeyTable(ot_glyphs_1.MetricBasic.TagHmtx);
    const hmtx = new bin_util_1.BinaryView(bHmtx).next(io_bin_metric_1.MetricBasicIo, hhea, maxp);
    const hvar = designSpace && bHvar
        ? new bin_util_1.BinaryView(bHvar).next(io_bin_metric_1.MetricVarianceIo, maxp, designSpace, false)
        : null;
    return { hhea, hmtx, hvar };
}
function readVMetric(sfnt, maxp, vhea, designSpace) {
    const bVmtx = sfnt.tables.get(ot_glyphs_1.MetricBasic.TagVmtx);
    const bVvar = sfnt.tables.get(ot_glyphs_1.MetricVariance.TagVvar);
    const bVorg = sfnt.tables.get(ot_glyphs_1.Vorg.Tag);
    if (!vhea || !bVmtx)
        return null;
    const vmtx = new bin_util_1.BinaryView(bVmtx).next(io_bin_metric_1.MetricBasicIo, vhea, maxp);
    const vorg = bVorg ? new bin_util_1.BinaryView(bVorg).next(io_bin_metric_1.VorgIo) : null;
    const vvar = designSpace && bVvar
        ? new bin_util_1.BinaryView(bVvar).next(io_bin_metric_1.MetricVarianceIo, maxp, designSpace, true)
        : null;
    return { vhea, vmtx, vvar, vorg };
}
//# sourceMappingURL=read.js.map