"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gcFont = gcFont;
const ImpLib = require("@ot-builder/common-impl");
const Ot = require("@ot-builder/ot");
const Rectify = require("@ot-builder/rectify");
const initial_visible_glyphs_1 = require("../support/initial-visible-glyphs");
const index_1 = require("./merge-consolidate/index");
function gcFont(font, gsf) {
    if (font.gsub)
        cleanupInaccessibleLookups(font.gsub);
    if (font.gpos)
        cleanupInaccessibleLookups(font.gpos);
    const { glyphs, rectifier } = (0, initial_visible_glyphs_1.createSubsetRectifier)(font, { has: () => true });
    font.glyphs = gsf.createStoreFromList(glyphs);
    Rectify.inPlaceRectifyFontGlyphReferences(rectifier, font);
    if (font.gpos)
        font.gpos = (0, index_1.consolidateGsubGpos)(font.fvar, font.gpos);
    if (font.gsub)
        font.gsub = (0, index_1.consolidateGsubGpos)(font.fvar, font.gsub);
}
function cleanupInaccessibleLookups(table) {
    const keptFeatures = new Set();
    for (const script of table.scripts.values()) {
        if (script.defaultLanguage)
            collectAccessibleFeatures(script.defaultLanguage, keptFeatures);
        for (const lang of script.languages.values())
            collectAccessibleFeatures(lang, keptFeatures);
    }
    const keptLookups = new Set();
    for (const feature of table.features) {
        if (!keptFeatures.has(feature))
            emptyFeature(feature);
        else
            for (const lookup of feature.lookups)
                keptLookups.add(lookup);
    }
    if (table.featureVariations) {
        for (const fv of table.featureVariations) {
            for (const [from, to] of fv.substitutions) {
                if (!keptFeatures.has(from))
                    emptyFeature(to);
                else
                    for (const lookup of to.lookups)
                        keptLookups.add(lookup);
            }
        }
    }
    extendIndirectLookups(keptLookups);
    ImpLib.ArrayHelper.inPlaceShrinkArray(keptLookups, table.lookups);
}
function isChainingLookup(lookup) {
    return lookup instanceof Ot.Gsub.Chaining || lookup instanceof Ot.Gpos.Chaining;
}
function extendIndirectLookups(keptLookups) {
    let sizeOld = keptLookups.size;
    for (;;) {
        const sizeNew = keptLookups.size;
        for (const l of keptLookups) {
            if (isChainingLookup(l)) {
                for (const rule of l.rules) {
                    for (const app of rule.applications)
                        keptLookups.add(app.apply);
                }
            }
        }
        if (sizeNew === sizeOld) {
            break;
        }
        else {
            sizeOld = sizeNew;
        }
    }
}
function collectAccessibleFeatures(lang, sink) {
    if (lang.requiredFeature)
        sink.add(lang.requiredFeature);
    for (const feature of lang.features)
        sink.add(feature);
}
function emptyFeature(f) {
    f.lookups = [];
    f.params = null;
}
//# sourceMappingURL=gc.js.map