/* Generated by wayland-scanner 1.23.0 */

#ifndef COLOR_MANAGEMENT_V1_CLIENT_PROTOCOL_H
#define COLOR_MANAGEMENT_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * @page page_color_management_v1 The color_management_v1 protocol
 * color management protocol
 *
 * @section page_desc_color_management_v1 Description
 *
 * The aim of the color management extension is to allow clients to know
 * the color properties of outputs, and to tell the compositor about the color
 * properties of their content on surfaces. Doing this enables a compositor
 * to perform automatic color management of content for different outputs
 * according to how content is intended to look like.
 *
 * The color properties are represented as an image description object which
 * is immutable after it has been created. A wl_output always has an
 * associated image description that clients can observe. A wl_surface
 * always has an associated preferred image description as a hint chosen by
 * the compositor that clients can also observe. Clients can set an image
 * description on a wl_surface to denote the color characteristics of the
 * surface contents.
 *
 * An image description includes SDR and HDR colorimetry and encoding, HDR
 * metadata, and viewing environment parameters. An image description does
 * not include the properties set through color-representation extension.
 * It is expected that the color-representation extension is used in
 * conjunction with the color management extension when necessary,
 * particularly with the YUV family of pixel formats.
 *
 * Recommendation ITU-T H.273
 * "Coding-independent code points for video signal type identification"
 * shall be referred to as simply H.273 here.
 *
 * The color-and-hdr repository
 * (https://gitlab.freedesktop.org/pq/color-and-hdr) contains
 * background information on the protocol design and legacy color management.
 * It also contains a glossary, learning resources for digital color, tools,
 * samples and more.
 *
 * The terminology used in this protocol is based on common color science and
 * color encoding terminology where possible. The glossary in the color-and-hdr
 * repository shall be the authority on the definition of terms in this
 * protocol.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 *
 * @section page_ifaces_color_management_v1 Interfaces
 * - @subpage page_iface_wp_color_manager_v1 - color manager singleton
 * - @subpage page_iface_wp_color_management_output_v1 - output color properties
 * - @subpage page_iface_wp_color_management_surface_v1 - color management
 * extension to a surface
 * - @subpage page_iface_wp_color_management_surface_feedback_v1 - color
 * management extension to a surface
 * - @subpage page_iface_wp_image_description_creator_icc_v1 - holder of image
 * description ICC information
 * - @subpage page_iface_wp_image_description_creator_params_v1 - holder of
 * image description parameters
 * - @subpage page_iface_wp_image_description_v1 - Colorimetric image
 * description
 * - @subpage page_iface_wp_image_description_info_v1 - Colorimetric image
 * description information
 * @section page_copyright_color_management_v1 Copyright
 * <pre>
 *
 * Copyright 2019 Sebastian Wick
 * Copyright 2019 Erwin Burema
 * Copyright 2020 AMD
 * Copyright 2020-2024 Collabora, Ltd.
 * Copyright 2024 Xaver Hugl
 * Copyright 2022-2025 Red Hat, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_output;
struct wl_surface;
struct wp_color_management_output_v1;
struct wp_color_management_surface_feedback_v1;
struct wp_color_management_surface_v1;
struct wp_color_manager_v1;
struct wp_image_description_creator_icc_v1;
struct wp_image_description_creator_params_v1;
struct wp_image_description_info_v1;
struct wp_image_description_v1;

#ifndef WP_COLOR_MANAGER_V1_INTERFACE
#  define WP_COLOR_MANAGER_V1_INTERFACE
/**
 * @page page_iface_wp_color_manager_v1 wp_color_manager_v1
 * @section page_iface_wp_color_manager_v1_desc Description
 *
 * A singleton global interface used for getting color management extensions
 * for wl_surface and wl_output objects, and for creating client defined
 * image description objects. The extension interfaces allow
 * getting the image description of outputs and setting the image
 * description of surfaces.
 *
 * Compositors should never remove this global.
 * @section page_iface_wp_color_manager_v1_api API
 * See @ref iface_wp_color_manager_v1.
 */
/**
 * @defgroup iface_wp_color_manager_v1 The wp_color_manager_v1 interface
 *
 * A singleton global interface used for getting color management extensions
 * for wl_surface and wl_output objects, and for creating client defined
 * image description objects. The extension interfaces allow
 * getting the image description of outputs and setting the image
 * description of surfaces.
 *
 * Compositors should never remove this global.
 */
extern const struct wl_interface wp_color_manager_v1_interface;
#endif
#ifndef WP_COLOR_MANAGEMENT_OUTPUT_V1_INTERFACE
#  define WP_COLOR_MANAGEMENT_OUTPUT_V1_INTERFACE
/**
 * @page page_iface_wp_color_management_output_v1 wp_color_management_output_v1
 * @section page_iface_wp_color_management_output_v1_desc Description
 *
 * A wp_color_management_output_v1 describes the color properties of an
 * output.
 *
 * The wp_color_management_output_v1 is associated with the wl_output global
 * underlying the wl_output object. Therefore the client destroying the
 * wl_output object has no impact, but the compositor removing the output
 * global makes the wp_color_management_output_v1 object inert.
 * @section page_iface_wp_color_management_output_v1_api API
 * See @ref iface_wp_color_management_output_v1.
 */
/**
 * @defgroup iface_wp_color_management_output_v1 The
 * wp_color_management_output_v1 interface
 *
 * A wp_color_management_output_v1 describes the color properties of an
 * output.
 *
 * The wp_color_management_output_v1 is associated with the wl_output global
 * underlying the wl_output object. Therefore the client destroying the
 * wl_output object has no impact, but the compositor removing the output
 * global makes the wp_color_management_output_v1 object inert.
 */
extern const struct wl_interface wp_color_management_output_v1_interface;
#endif
#ifndef WP_COLOR_MANAGEMENT_SURFACE_V1_INTERFACE
#  define WP_COLOR_MANAGEMENT_SURFACE_V1_INTERFACE
/**
 * @page page_iface_wp_color_management_surface_v1
 * wp_color_management_surface_v1
 * @section page_iface_wp_color_management_surface_v1_desc Description
 *
 * A wp_color_management_surface_v1 allows the client to set the color
 * space and HDR properties of a surface.
 *
 * If the wl_surface associated with the wp_color_management_surface_v1 is
 * destroyed, the wp_color_management_surface_v1 object becomes inert.
 * @section page_iface_wp_color_management_surface_v1_api API
 * See @ref iface_wp_color_management_surface_v1.
 */
/**
 * @defgroup iface_wp_color_management_surface_v1 The
 * wp_color_management_surface_v1 interface
 *
 * A wp_color_management_surface_v1 allows the client to set the color
 * space and HDR properties of a surface.
 *
 * If the wl_surface associated with the wp_color_management_surface_v1 is
 * destroyed, the wp_color_management_surface_v1 object becomes inert.
 */
extern const struct wl_interface wp_color_management_surface_v1_interface;
#endif
#ifndef WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_INTERFACE
#  define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_INTERFACE
/**
 * @page page_iface_wp_color_management_surface_feedback_v1
 * wp_color_management_surface_feedback_v1
 * @section page_iface_wp_color_management_surface_feedback_v1_desc Description
 *
 * A wp_color_management_surface_feedback_v1 allows the client to get the
 * preferred image description of a surface.
 *
 * If the wl_surface associated with this object is destroyed, the
 * wp_color_management_surface_feedback_v1 object becomes inert.
 * @section page_iface_wp_color_management_surface_feedback_v1_api API
 * See @ref iface_wp_color_management_surface_feedback_v1.
 */
/**
 * @defgroup iface_wp_color_management_surface_feedback_v1 The
 * wp_color_management_surface_feedback_v1 interface
 *
 * A wp_color_management_surface_feedback_v1 allows the client to get the
 * preferred image description of a surface.
 *
 * If the wl_surface associated with this object is destroyed, the
 * wp_color_management_surface_feedback_v1 object becomes inert.
 */
extern const struct wl_interface
    wp_color_management_surface_feedback_v1_interface;
#endif
#ifndef WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_INTERFACE
#  define WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_INTERFACE
/**
 * @page page_iface_wp_image_description_creator_icc_v1
 * wp_image_description_creator_icc_v1
 * @section page_iface_wp_image_description_creator_icc_v1_desc Description
 *
 * This type of object is used for collecting all the information required
 * to create a wp_image_description_v1 object from an ICC file. A complete
 * set of required parameters consists of these properties:
 * - ICC file
 *
 * Each required property must be set exactly once if the client is to create
 * an image description. The set requests verify that a property was not
 * already set. The create request verifies that all required properties are
 * set. There may be several alternative requests for setting each property,
 * and in that case the client must choose one of them.
 *
 * Once all properties have been set, the create request must be used to
 * create the image description object, destroying the creator in the
 * process.
 * @section page_iface_wp_image_description_creator_icc_v1_api API
 * See @ref iface_wp_image_description_creator_icc_v1.
 */
/**
 * @defgroup iface_wp_image_description_creator_icc_v1 The
 * wp_image_description_creator_icc_v1 interface
 *
 * This type of object is used for collecting all the information required
 * to create a wp_image_description_v1 object from an ICC file. A complete
 * set of required parameters consists of these properties:
 * - ICC file
 *
 * Each required property must be set exactly once if the client is to create
 * an image description. The set requests verify that a property was not
 * already set. The create request verifies that all required properties are
 * set. There may be several alternative requests for setting each property,
 * and in that case the client must choose one of them.
 *
 * Once all properties have been set, the create request must be used to
 * create the image description object, destroying the creator in the
 * process.
 */
extern const struct wl_interface wp_image_description_creator_icc_v1_interface;
#endif
#ifndef WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_INTERFACE
#  define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_INTERFACE
/**
 * @page page_iface_wp_image_description_creator_params_v1
 * wp_image_description_creator_params_v1
 * @section page_iface_wp_image_description_creator_params_v1_desc Description
 *
 * This type of object is used for collecting all the parameters required
 * to create a wp_image_description_v1 object. A complete set of required
 * parameters consists of these properties:
 * - transfer characteristic function (tf)
 * - chromaticities of primaries and white point (primary color volume)
 *
 * The following properties are optional and have a well-defined default
 * if not explicitly set:
 * - primary color volume luminance range
 * - reference white luminance level
 * - mastering display primaries and white point (target color volume)
 * - mastering luminance range
 *
 * The following properties are optional and will be ignored
 * if not explicitly set:
 * - maximum content light level
 * - maximum frame-average light level
 *
 * Each required property must be set exactly once if the client is to create
 * an image description. The set requests verify that a property was not
 * already set. The create request verifies that all required properties are
 * set. There may be several alternative requests for setting each property,
 * and in that case the client must choose one of them.
 *
 * Once all properties have been set, the create request must be used to
 * create the image description object, destroying the creator in the
 * process.
 * @section page_iface_wp_image_description_creator_params_v1_api API
 * See @ref iface_wp_image_description_creator_params_v1.
 */
/**
 * @defgroup iface_wp_image_description_creator_params_v1 The
 * wp_image_description_creator_params_v1 interface
 *
 * This type of object is used for collecting all the parameters required
 * to create a wp_image_description_v1 object. A complete set of required
 * parameters consists of these properties:
 * - transfer characteristic function (tf)
 * - chromaticities of primaries and white point (primary color volume)
 *
 * The following properties are optional and have a well-defined default
 * if not explicitly set:
 * - primary color volume luminance range
 * - reference white luminance level
 * - mastering display primaries and white point (target color volume)
 * - mastering luminance range
 *
 * The following properties are optional and will be ignored
 * if not explicitly set:
 * - maximum content light level
 * - maximum frame-average light level
 *
 * Each required property must be set exactly once if the client is to create
 * an image description. The set requests verify that a property was not
 * already set. The create request verifies that all required properties are
 * set. There may be several alternative requests for setting each property,
 * and in that case the client must choose one of them.
 *
 * Once all properties have been set, the create request must be used to
 * create the image description object, destroying the creator in the
 * process.
 */
extern const struct wl_interface
    wp_image_description_creator_params_v1_interface;
#endif
#ifndef WP_IMAGE_DESCRIPTION_V1_INTERFACE
#  define WP_IMAGE_DESCRIPTION_V1_INTERFACE
/**
 * @page page_iface_wp_image_description_v1 wp_image_description_v1
 * @section page_iface_wp_image_description_v1_desc Description
 *
 * An image description carries information about the color encoding used on
 * a surface when attached to a wl_surface via
 * wp_color_management_surface_v1.set_image_description. A compositor can use
 * this information to decode pixel values into colorimetrically meaningful
 * quantities.
 *
 * Note, that the wp_image_description_v1 object is not ready to be used
 * immediately after creation. The object eventually delivers either the
 * 'ready' or the 'failed' event, specified in all requests creating it. The
 * object is deemed "ready" after receiving the 'ready' event.
 *
 * An object which is not ready is illegal to use, it can only be destroyed.
 * Any other request in this interface shall result in the 'not_ready'
 * protocol error. Attempts to use an object which is not ready through other
 * interfaces shall raise protocol errors defined there.
 *
 * Once created and regardless of how it was created, a
 * wp_image_description_v1 object always refers to one fixed image
 * description. It cannot change after creation.
 * @section page_iface_wp_image_description_v1_api API
 * See @ref iface_wp_image_description_v1.
 */
/**
 * @defgroup iface_wp_image_description_v1 The wp_image_description_v1 interface
 *
 * An image description carries information about the color encoding used on
 * a surface when attached to a wl_surface via
 * wp_color_management_surface_v1.set_image_description. A compositor can use
 * this information to decode pixel values into colorimetrically meaningful
 * quantities.
 *
 * Note, that the wp_image_description_v1 object is not ready to be used
 * immediately after creation. The object eventually delivers either the
 * 'ready' or the 'failed' event, specified in all requests creating it. The
 * object is deemed "ready" after receiving the 'ready' event.
 *
 * An object which is not ready is illegal to use, it can only be destroyed.
 * Any other request in this interface shall result in the 'not_ready'
 * protocol error. Attempts to use an object which is not ready through other
 * interfaces shall raise protocol errors defined there.
 *
 * Once created and regardless of how it was created, a
 * wp_image_description_v1 object always refers to one fixed image
 * description. It cannot change after creation.
 */
extern const struct wl_interface wp_image_description_v1_interface;
#endif
#ifndef WP_IMAGE_DESCRIPTION_INFO_V1_INTERFACE
#  define WP_IMAGE_DESCRIPTION_INFO_V1_INTERFACE
/**
 * @page page_iface_wp_image_description_info_v1 wp_image_description_info_v1
 * @section page_iface_wp_image_description_info_v1_desc Description
 *
 * Sends all matching events describing an image description object exactly
 * once and finally sends the 'done' event.
 *
 * This means
 * - if the image description is parametric, it must send
 * - primaries
 * - named_primaries, if applicable
 * - at least one of tf_power and tf_named, as applicable
 * - luminances
 * - target_primaries
 * - target_luminance
 * - if the image description is parametric, it may send, if applicable,
 * - target_max_cll
 * - target_max_fall
 * - if the image description contains an ICC profile, it must send the
 * icc_file event
 *
 * Once a wp_image_description_info_v1 object has delivered a 'done' event it
 * is automatically destroyed.
 *
 * Every wp_image_description_info_v1 created from the same
 * wp_image_description_v1 shall always return the exact same data.
 * @section page_iface_wp_image_description_info_v1_api API
 * See @ref iface_wp_image_description_info_v1.
 */
/**
 * @defgroup iface_wp_image_description_info_v1 The wp_image_description_info_v1
 * interface
 *
 * Sends all matching events describing an image description object exactly
 * once and finally sends the 'done' event.
 *
 * This means
 * - if the image description is parametric, it must send
 * - primaries
 * - named_primaries, if applicable
 * - at least one of tf_power and tf_named, as applicable
 * - luminances
 * - target_primaries
 * - target_luminance
 * - if the image description is parametric, it may send, if applicable,
 * - target_max_cll
 * - target_max_fall
 * - if the image description contains an ICC profile, it must send the
 * icc_file event
 *
 * Once a wp_image_description_info_v1 object has delivered a 'done' event it
 * is automatically destroyed.
 *
 * Every wp_image_description_info_v1 created from the same
 * wp_image_description_v1 shall always return the exact same data.
 */
extern const struct wl_interface wp_image_description_info_v1_interface;
#endif

#ifndef WP_COLOR_MANAGER_V1_ERROR_ENUM
#  define WP_COLOR_MANAGER_V1_ERROR_ENUM
enum wp_color_manager_v1_error {
  /**
   * request not supported
   */
  WP_COLOR_MANAGER_V1_ERROR_UNSUPPORTED_FEATURE = 0,
  /**
   * color management surface exists already
   */
  WP_COLOR_MANAGER_V1_ERROR_SURFACE_EXISTS = 1,
};
#endif /* WP_COLOR_MANAGER_V1_ERROR_ENUM */

#ifndef WP_COLOR_MANAGER_V1_RENDER_INTENT_ENUM
#  define WP_COLOR_MANAGER_V1_RENDER_INTENT_ENUM
/**
 * @ingroup iface_wp_color_manager_v1
 * rendering intents
 *
 * See the ICC.1:2022 specification from the International Color Consortium
 * for more details about rendering intents.
 *
 * The principles of ICC defined rendering intents apply with all types of
 * image descriptions, not only those with ICC file profiles.
 *
 * Compositors must support the perceptual rendering intent. Other
 * rendering intents are optional.
 */
enum wp_color_manager_v1_render_intent {
  /**
   * perceptual
   */
  WP_COLOR_MANAGER_V1_RENDER_INTENT_PERCEPTUAL = 0,
  /**
   * media-relative colorimetric
   */
  WP_COLOR_MANAGER_V1_RENDER_INTENT_RELATIVE = 1,
  /**
   * saturation
   */
  WP_COLOR_MANAGER_V1_RENDER_INTENT_SATURATION = 2,
  /**
   * ICC-absolute colorimetric
   */
  WP_COLOR_MANAGER_V1_RENDER_INTENT_ABSOLUTE = 3,
  /**
   * media-relative colorimetric + black point compensation
   */
  WP_COLOR_MANAGER_V1_RENDER_INTENT_RELATIVE_BPC = 4,
};
#endif /* WP_COLOR_MANAGER_V1_RENDER_INTENT_ENUM */

#ifndef WP_COLOR_MANAGER_V1_FEATURE_ENUM
#  define WP_COLOR_MANAGER_V1_FEATURE_ENUM
/**
 * @ingroup iface_wp_color_manager_v1
 * compositor supported features
 */
enum wp_color_manager_v1_feature {
  /**
   * create_icc_creator request
   */
  WP_COLOR_MANAGER_V1_FEATURE_ICC_V2_V4 = 0,
  /**
   * create_parametric_creator request
   */
  WP_COLOR_MANAGER_V1_FEATURE_PARAMETRIC = 1,
  /**
   * parametric set_primaries request
   */
  WP_COLOR_MANAGER_V1_FEATURE_SET_PRIMARIES = 2,
  /**
   * parametric set_tf_power request
   */
  WP_COLOR_MANAGER_V1_FEATURE_SET_TF_POWER = 3,
  /**
   * parametric set_luminances request
   */
  WP_COLOR_MANAGER_V1_FEATURE_SET_LUMINANCES = 4,
  /**
   * parametric set_mastering_display_primaries request
   *
   * The compositor supports set_mastering_display_primaries
   * request with a target color volume fully contained inside the
   * primary color volume.
   */
  WP_COLOR_MANAGER_V1_FEATURE_SET_MASTERING_DISPLAY_PRIMARIES = 5,
  /**
   * parametric target exceeds primary color volume
   *
   * The compositor additionally supports target color volumes that
   * extend outside of the primary color volume.
   *
   * This can only be advertised if feature
   * set_mastering_display_primaries is supported as well.
   */
  WP_COLOR_MANAGER_V1_FEATURE_EXTENDED_TARGET_VOLUME = 6,
  /**
   * get_windows_scrgb request
   */
  WP_COLOR_MANAGER_V1_FEATURE_WINDOWS_SCRGB = 7,
};
#endif /* WP_COLOR_MANAGER_V1_FEATURE_ENUM */

#ifndef WP_COLOR_MANAGER_V1_PRIMARIES_ENUM
#  define WP_COLOR_MANAGER_V1_PRIMARIES_ENUM
/**
 * @ingroup iface_wp_color_manager_v1
 * named color primaries
 *
 * Named color primaries used to encode well-known sets of primaries. H.273
 * is the authority, when it comes to the exact values of primaries and
 * authoritative specifications, where an equivalent code point exists.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * Descriptions do list the specifications for convenience.
 */
enum wp_color_manager_v1_primaries {
  /**
   * Color primaries for the sRGB color space as defined by the BT.709 standard
   *
   * Color primaries as defined by - Rec. ITU-R BT.709-6 - Rec.
   * ITU-R BT.1361-0 conventional colour gamut system and extended
   * colour gamut system (historical) - IEC 61966-2-1 sRGB or sYCC -
   * IEC 61966-2-4 - Society of Motion Picture and Television
   * Engineers (SMPTE) RP 177 (1993) Annex B Equivalent to H.273
   * ColourPrimaries code point 1.
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_SRGB = 1,
  /**
   * Color primaries for PAL-M as defined by the BT.470 standard
   *
   * Color primaries as defined by - Rec. ITU-R BT.470-6 System M
   * (historical) - United States National Television System
   * Committee 1953 Recommendation for transmission standards for
   * color television - United States Federal Communications
   * Commission (2003) Title 47 Code of Federal Regulations 73.682
   * (a)(20) Equivalent to H.273 ColourPrimaries code point 4.
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_PAL_M = 2,
  /**
   * Color primaries for PAL as defined by the BT.601 standard
   *
   * Color primaries as defined by - Rec. ITU-R BT.470-6 System B,
   * G (historical) - Rec. ITU-R BT.601-7 625 - Rec. ITU-R BT.1358-0
   * 625 (historical) - Rec. ITU-R BT.1700-0 625 PAL and 625 SECAM
   * Equivalent to H.273 ColourPrimaries code point 5.
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_PAL = 3,
  /**
   * Color primaries for NTSC as defined by the BT.601 standard
   *
   * Color primaries as defined by - Rec. ITU-R BT.601-7 525 - Rec.
   * ITU-R BT.1358-1 525 or 625 (historical) - Rec. ITU-R BT.1700-0
   * NTSC - SMPTE 170M (2004) - SMPTE 240M (1999) (historical)
   * Equivalent to H.273 ColourPrimaries code point 6 and 7.
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_NTSC = 4,
  /**
   * Generic film with colour filters using Illuminant C
   *
   * Color primaries as defined by H.273 for generic film.
   * Equivalent to H.273 ColourPrimaries code point 8.
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_GENERIC_FILM = 5,
  /**
   * Color primaries as defined by the BT.2020 and BT.2100 standard
   *
   * Color primaries as defined by - Rec. ITU-R BT.2020-2 - Rec.
   * ITU-R BT.2100-0 Equivalent to H.273 ColourPrimaries code point
   * 9.
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_BT2020 = 6,
  /**
   * Color primaries of the full CIE 1931 XYZ color space
   *
   * Color primaries as defined as the maximum of the CIE 1931 XYZ
   * color space by - SMPTE ST 428-1 - (CIE 1931 XYZ as in ISO
   * 11664-1) Equivalent to H.273 ColourPrimaries code point 10.
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_CIE1931_XYZ = 7,
  /**
   * Color primaries of the DCI P3 color space as defined by the SMPTE RP 431
   * standard
   *
   * Color primaries as defined by Digital Cinema System and
   * published in SMPTE RP 431-2 (2011). Equivalent to H.273
   * ColourPrimaries code point 11.
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_DCI_P3 = 8,
  /**
   * Color primaries of Display P3 variant of the DCI-P3 color space as defined
   * by the SMPTE EG 432 standard
   *
   * Color primaries as defined by Digital Cinema System and
   * published in SMPTE EG 432-1 (2010). Equivalent to H.273
   * ColourPrimaries code point 12.
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_DISPLAY_P3 = 9,
  /**
   * Color primaries of the Adobe RGB color space as defined by the ISO 12640
   * standard
   *
   * Color primaries as defined by Adobe as "Adobe RGB" and later
   * published by ISO 12640-4 (2011).
   */
  WP_COLOR_MANAGER_V1_PRIMARIES_ADOBE_RGB = 10,
};
#endif /* WP_COLOR_MANAGER_V1_PRIMARIES_ENUM */

#ifndef WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ENUM
#  define WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ENUM
/**
 * @ingroup iface_wp_color_manager_v1
 * named transfer functions
 *
 * Named transfer functions used to represent well-known transfer
 * characteristics. H.273 is the authority, when it comes to the exact
 * formulas and authoritative specifications, where an equivalent code
 * point exists.
 *
 * A value of 0 is invalid and will never be present in the list of enums.
 *
 * Descriptions do list the specifications for convenience.
 */
enum wp_color_manager_v1_transfer_function {
  /**
   * BT.1886 display transfer characteristic
   *
   * Rec. ITU-R BT.1886 is the display transfer characteristic
   * assumed by - Rec. ITU-R BT.601-7 525 and 625 - Rec. ITU-R
   * BT.709-6 - Rec. ITU-R BT.2020-2 These recommendations are
   * referred to by H.273 TransferCharacteristics code points 1, 6,
   * 14, and 15, which are all equivalent.
   *
   * This TF implies these default luminances from Rec. ITU-R
   * BT.2035: - primary color volume minimum: 0.01 cd/m² - primary
   * color volume maximum: 100 cd/m² - reference white: 100 cd/m²
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_BT1886 = 1,
  /**
   * Assumed display gamma 2.2 transfer function
   *
   * Transfer characteristics as defined by - Rec. ITU-R BT.470-6
   * System M (historical) - United States National Television System
   * Committee 1953 Recommendation for transmission standards for
   * color television - United States Federal Communications
   * Commission (2003) Title 47 Code of Federal Regulations 73.682
   * (a) (20) - Rec. ITU-R BT.1700-0 625 PAL and 625 SECAM Equivalent
   * to H.273 TransferCharacteristics code point 4.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_GAMMA22 = 2,
  /**
   * Assumed display gamma 2.8 transfer function
   *
   * Transfer characteristics as defined by - Rec. ITU-R BT.470-6
   * System B, G (historical) Equivalent to H.273
   * TransferCharacteristics code point 5.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_GAMMA28 = 3,
  /**
   * SMPTE ST 240 transfer function
   *
   * Transfer characteristics as defined by - SMPTE ST 240 (1999)
   * Equivalent to H.273 TransferCharacteristics code point 7.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ST240 = 4,
  /**
   * extended linear transfer function
   *
   * Linear transfer function defined over all real numbers.
   * Normalised electrical values are equal the normalised optical
   * values.
   *
   * The differences to H.273 TransferCharacteristics code point 8
   * are the definition over all real numbers.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_EXT_LINEAR = 5,
  /**
   * logarithmic 100:1 transfer function
   *
   * Logarithmic transfer characteristic (100:1 range). Equivalent
   * to H.273 TransferCharacteristics code point 9.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_LOG_100 = 6,
  /**
   * logarithmic (100*Sqrt(10) : 1) transfer function
   *
   * Logarithmic transfer characteristic (100 * Sqrt(10) : 1
   * range). Equivalent to H.273 TransferCharacteristics code point
   * 10.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_LOG_316 = 7,
  /**
   * IEC 61966-2-4 transfer function
   *
   * Transfer characteristics as defined by - IEC 61966-2-4
   * Equivalent to H.273 TransferCharacteristics code point 11.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_XVYCC = 8,
  /**
   * sRGB piece-wise transfer function
   *
   * Transfer characteristics as defined by - IEC 61966-2-1 sRGB
   * Equivalent to H.273 TransferCharacteristics code point 13 with
   * MatrixCoefficients set to 0.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_SRGB = 9,
  /**
   * Extended sRGB piece-wise transfer function
   *
   * Transfer characteristics as defined by - IEC 61966-2-1 sYCC
   * Equivalent to H.273 TransferCharacteristics code point 13 with
   * MatrixCoefficients set to anything but 0.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_EXT_SRGB = 10,
  /**
   * perceptual quantizer transfer function
   *
   * Transfer characteristics as defined by - SMPTE ST 2084 (2014)
   * for 10-, 12-, 14- and 16-bit systems - Rec. ITU-R BT.2100-2
   * perceptual quantization (PQ) system Equivalent to H.273
   * TransferCharacteristics code point 16.
   *
   * This TF implies these default luminances - primary color volume
   * minimum: 0.005 cd/m² - primary color volume maximum: 10000
   * cd/m² - reference white: 203 cd/m²
   *
   * The difference between the primary color volume minimum and
   * maximum must be approximately 10000 cd/m² as that is the swing
   * of the EOTF defined by ST 2084 and BT.2100. The default value
   * for the reference white is a protocol addition: it is suggested
   * by Report ITU-R BT.2408-7 and is not part of ST 2084 or BT.2100.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ST2084_PQ = 11,
  /**
   * SMPTE ST 428 transfer function
   *
   * Transfer characteristics as defined by - SMPTE ST 428-1 (2019)
   * Equivalent to H.273 TransferCharacteristics code point 17.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ST428 = 12,
  /**
   * hybrid log-gamma transfer function
   *
   * Transfer characteristics as defined by - ARIB STD-B67 (2015) -
   * Rec. ITU-R BT.2100-2 hybrid log-gamma (HLG) system Equivalent to
   * H.273 TransferCharacteristics code point 18.
   *
   * This TF implies these default luminances - primary color volume
   * minimum: 0.005 cd/m² - primary color volume maximum: 1000
   * cd/m² - reference white: 203 cd/m²
   *
   * HLG is a relative display-referred signal with a specified
   * non-linear mapping to the display peak luminance (the HLG OOTF).
   * All absolute luminance values used here for HLG assume a 1000
   * cd/m² peak display.
   *
   * The default value for the reference white is a protocol
   * addition: it is suggested by Report ITU-R BT.2408-7 and is not
   * part of ARIB STD-B67 or BT.2100.
   */
  WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_HLG = 13,
};
#endif /* WP_COLOR_MANAGER_V1_TRANSFER_FUNCTION_ENUM */

/**
 * @ingroup iface_wp_color_manager_v1
 * @struct wp_color_manager_v1_listener
 */
struct wp_color_manager_v1_listener {
  /**
   * supported rendering intent
   *
   * When this object is created, it shall immediately send this
   * event once for each rendering intent the compositor supports.
   * @param render_intent rendering intent
   */
  void (*supported_intent)(void* data,
                           struct wp_color_manager_v1* wp_color_manager_v1,
                           uint32_t render_intent);
  /**
   * supported features
   *
   * When this object is created, it shall immediately send this
   * event once for each compositor supported feature listed in the
   * enumeration.
   * @param feature supported feature
   */
  void (*supported_feature)(void* data,
                            struct wp_color_manager_v1* wp_color_manager_v1,
                            uint32_t feature);
  /**
   * supported named transfer characteristic
   *
   * When this object is created, it shall immediately send this
   * event once for each named transfer function the compositor
   * supports with the parametric image description creator.
   * @param tf Named transfer function
   */
  void (*supported_tf_named)(void* data,
                             struct wp_color_manager_v1* wp_color_manager_v1,
                             uint32_t tf);
  /**
   * supported named primaries
   *
   * When this object is created, it shall immediately send this
   * event once for each named set of primaries the compositor
   * supports with the parametric image description creator.
   * @param primaries Named color primaries
   */
  void (*supported_primaries_named)(
      void* data, struct wp_color_manager_v1* wp_color_manager_v1,
      uint32_t primaries);
  /**
   * all features have been sent
   *
   * This event is sent when all supported rendering intents,
   * features, transfer functions and named primaries have been sent.
   */
  void (*done)(void* data, struct wp_color_manager_v1* wp_color_manager_v1);
};

/**
 * @ingroup iface_wp_color_manager_v1
 */
static inline int wp_color_manager_v1_add_listener(
    struct wp_color_manager_v1* wp_color_manager_v1,
    const struct wp_color_manager_v1_listener* listener, void* data) {
  return wl_proxy_add_listener((struct wl_proxy*)wp_color_manager_v1,
                               (void (**)(void))listener, data);
}

#define WP_COLOR_MANAGER_V1_DESTROY 0
#define WP_COLOR_MANAGER_V1_GET_OUTPUT 1
#define WP_COLOR_MANAGER_V1_GET_SURFACE 2
#define WP_COLOR_MANAGER_V1_GET_SURFACE_FEEDBACK 3
#define WP_COLOR_MANAGER_V1_CREATE_ICC_CREATOR 4
#define WP_COLOR_MANAGER_V1_CREATE_PARAMETRIC_CREATOR 5
#define WP_COLOR_MANAGER_V1_CREATE_WINDOWS_SCRGB 6

/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_SUPPORTED_INTENT_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_SUPPORTED_FEATURE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_SUPPORTED_TF_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_SUPPORTED_PRIMARIES_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_DONE_SINCE_VERSION 1

/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_GET_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_GET_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_GET_SURFACE_FEEDBACK_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_CREATE_ICC_CREATOR_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_CREATE_PARAMETRIC_CREATOR_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_manager_v1
 */
#define WP_COLOR_MANAGER_V1_CREATE_WINDOWS_SCRGB_SINCE_VERSION 1

/** @ingroup iface_wp_color_manager_v1 */
static inline void wp_color_manager_v1_set_user_data(
    struct wp_color_manager_v1* wp_color_manager_v1, void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)wp_color_manager_v1, user_data);
}

/** @ingroup iface_wp_color_manager_v1 */
static inline void* wp_color_manager_v1_get_user_data(
    struct wp_color_manager_v1* wp_color_manager_v1) {
  return wl_proxy_get_user_data((struct wl_proxy*)wp_color_manager_v1);
}

static inline uint32_t wp_color_manager_v1_get_version(
    struct wp_color_manager_v1* wp_color_manager_v1) {
  return wl_proxy_get_version((struct wl_proxy*)wp_color_manager_v1);
}

/**
 * @ingroup iface_wp_color_manager_v1
 *
 * Destroy the wp_color_manager_v1 object. This does not affect any other
 * objects in any way.
 */
static inline void wp_color_manager_v1_destroy(
    struct wp_color_manager_v1* wp_color_manager_v1) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_manager_v1, WP_COLOR_MANAGER_V1_DESTROY, NULL,
      wl_proxy_get_version((struct wl_proxy*)wp_color_manager_v1),
      WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_wp_color_manager_v1
 *
 * This creates a new wp_color_management_output_v1 object for the
 * given wl_output.
 *
 * See the wp_color_management_output_v1 interface for more details.
 */
static inline struct wp_color_management_output_v1*
wp_color_manager_v1_get_output(struct wp_color_manager_v1* wp_color_manager_v1,
                               struct wl_output* output) {
  struct wl_proxy* id;

  id = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_manager_v1, WP_COLOR_MANAGER_V1_GET_OUTPUT,
      &wp_color_management_output_v1_interface,
      wl_proxy_get_version((struct wl_proxy*)wp_color_manager_v1), 0, NULL,
      output);

  return (struct wp_color_management_output_v1*)id;
}

/**
 * @ingroup iface_wp_color_manager_v1
 *
 * If a wp_color_management_surface_v1 object already exists for the given
 * wl_surface, the protocol error surface_exists is raised.
 *
 * This creates a new color wp_color_management_surface_v1 object for the
 * given wl_surface.
 *
 * See the wp_color_management_surface_v1 interface for more details.
 */
static inline struct wp_color_management_surface_v1*
wp_color_manager_v1_get_surface(struct wp_color_manager_v1* wp_color_manager_v1,
                                struct wl_surface* surface) {
  struct wl_proxy* id;

  id = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_manager_v1, WP_COLOR_MANAGER_V1_GET_SURFACE,
      &wp_color_management_surface_v1_interface,
      wl_proxy_get_version((struct wl_proxy*)wp_color_manager_v1), 0, NULL,
      surface);

  return (struct wp_color_management_surface_v1*)id;
}

/**
 * @ingroup iface_wp_color_manager_v1
 *
 * This creates a new color wp_color_management_surface_feedback_v1 object
 * for the given wl_surface.
 *
 * See the wp_color_management_surface_feedback_v1 interface for more
 * details.
 */
static inline struct wp_color_management_surface_feedback_v1*
wp_color_manager_v1_get_surface_feedback(
    struct wp_color_manager_v1* wp_color_manager_v1,
    struct wl_surface* surface) {
  struct wl_proxy* id;

  id = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_manager_v1,
      WP_COLOR_MANAGER_V1_GET_SURFACE_FEEDBACK,
      &wp_color_management_surface_feedback_v1_interface,
      wl_proxy_get_version((struct wl_proxy*)wp_color_manager_v1), 0, NULL,
      surface);

  return (struct wp_color_management_surface_feedback_v1*)id;
}

/**
 * @ingroup iface_wp_color_manager_v1
 *
 * Makes a new ICC-based image description creator object with all
 * properties initially unset. The client can then use the object's
 * interface to define all the required properties for an image description
 * and finally create a wp_image_description_v1 object.
 *
 * This request can be used when the compositor advertises
 * wp_color_manager_v1.feature.icc_v2_v4.
 * Otherwise this request raises the protocol error unsupported_feature.
 */
static inline struct wp_image_description_creator_icc_v1*
wp_color_manager_v1_create_icc_creator(
    struct wp_color_manager_v1* wp_color_manager_v1) {
  struct wl_proxy* obj;

  obj = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_manager_v1,
      WP_COLOR_MANAGER_V1_CREATE_ICC_CREATOR,
      &wp_image_description_creator_icc_v1_interface,
      wl_proxy_get_version((struct wl_proxy*)wp_color_manager_v1), 0, NULL);

  return (struct wp_image_description_creator_icc_v1*)obj;
}

/**
 * @ingroup iface_wp_color_manager_v1
 *
 * Makes a new parametric image description creator object with all
 * properties initially unset. The client can then use the object's
 * interface to define all the required properties for an image description
 * and finally create a wp_image_description_v1 object.
 *
 * This request can be used when the compositor advertises
 * wp_color_manager_v1.feature.parametric.
 * Otherwise this request raises the protocol error unsupported_feature.
 */
static inline struct wp_image_description_creator_params_v1*
wp_color_manager_v1_create_parametric_creator(
    struct wp_color_manager_v1* wp_color_manager_v1) {
  struct wl_proxy* obj;

  obj = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_manager_v1,
      WP_COLOR_MANAGER_V1_CREATE_PARAMETRIC_CREATOR,
      &wp_image_description_creator_params_v1_interface,
      wl_proxy_get_version((struct wl_proxy*)wp_color_manager_v1), 0, NULL);

  return (struct wp_image_description_creator_params_v1*)obj;
}

/**
 * @ingroup iface_wp_color_manager_v1
 *
 * This creates a pre-defined image description for the so-called
 * Windows-scRGB stimulus encoding. This comes from the Windows 10 handling
 * of its own definition of an scRGB color space for an HDR screen
 * driven in BT.2100/PQ signalling mode.
 *
 * Windows-scRGB uses sRGB (BT.709) color primaries and white point.
 * The transfer characteristic is extended linear.
 *
 * The nominal color channel value range is extended, meaning it includes
 * negative and greater than 1.0 values. Negative values are used to
 * escape the sRGB color gamut boundaries. To make use of the extended
 * range, the client needs to use a pixel format that can represent those
 * values, e.g. floating-point 16 bits per channel.
 *
 * Nominal color value R=G=B=0.0 corresponds to BT.2100/PQ system
 * 0 cd/m², and R=G=B=1.0 corresponds to BT.2100/PQ system 80 cd/m².
 * The maximum is R=G=B=125.0 corresponding to 10k cd/m².
 *
 * Windows-scRGB is displayed by Windows 10 by converting it to
 * BT.2100/PQ, maintaining the CIE 1931 chromaticity and mapping the
 * luminance as above. No adjustment is made to the signal to account
 * for the viewing conditions.
 *
 * The reference white level of Windows-scRGB is unknown. If a
 * reference white level must be assumed for compositor processing, it
 * should be R=G=B=2.5375 corresponding to 203 cd/m² of Report ITU-R
 * BT.2408-7.
 *
 * The target color volume of Windows-scRGB is unknown. The color gamut
 * may be anything between sRGB and BT.2100.
 *
 * Note: EGL_EXT_gl_colorspace_scrgb_linear definition differs from
 * Windows-scRGB by using R=G=B=1.0 as the reference white level, while
 * Windows-scRGB reference white level is unknown or varies. However,
 * it seems probable that Windows implements both
 * EGL_EXT_gl_colorspace_scrgb_linear and Vulkan
 * VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT as Windows-scRGB.
 *
 * This request can be used when the compositor advertises
 * wp_color_manager_v1.feature.windows_scrgb.
 * Otherwise this request raises the protocol error unsupported_feature.
 *
 * The resulting image description object does not allow get_information
 * request. The wp_image_description_v1.ready event shall be sent.
 */
static inline struct wp_image_description_v1*
wp_color_manager_v1_create_windows_scrgb(
    struct wp_color_manager_v1* wp_color_manager_v1) {
  struct wl_proxy* image_description;

  image_description = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_manager_v1,
      WP_COLOR_MANAGER_V1_CREATE_WINDOWS_SCRGB,
      &wp_image_description_v1_interface,
      wl_proxy_get_version((struct wl_proxy*)wp_color_manager_v1), 0, NULL);

  return (struct wp_image_description_v1*)image_description;
}

/**
 * @ingroup iface_wp_color_management_output_v1
 * @struct wp_color_management_output_v1_listener
 */
struct wp_color_management_output_v1_listener {
  /**
   * image description changed
   *
   * This event is sent whenever the image description of the
   * output changed, followed by one wl_output.done event common to
   * output events across all extensions.
   *
   * If the client wants to use the updated image description, it
   * needs to do get_image_description again, because image
   * description objects are immutable.
   */
  void (*image_description_changed)(
      void* data,
      struct wp_color_management_output_v1* wp_color_management_output_v1);
};

/**
 * @ingroup iface_wp_color_management_output_v1
 */
static inline int wp_color_management_output_v1_add_listener(
    struct wp_color_management_output_v1* wp_color_management_output_v1,
    const struct wp_color_management_output_v1_listener* listener, void* data) {
  return wl_proxy_add_listener((struct wl_proxy*)wp_color_management_output_v1,
                               (void (**)(void))listener, data);
}

#define WP_COLOR_MANAGEMENT_OUTPUT_V1_DESTROY 0
#define WP_COLOR_MANAGEMENT_OUTPUT_V1_GET_IMAGE_DESCRIPTION 1

/**
 * @ingroup iface_wp_color_management_output_v1
 */
#define WP_COLOR_MANAGEMENT_OUTPUT_V1_IMAGE_DESCRIPTION_CHANGED_SINCE_VERSION 1

/**
 * @ingroup iface_wp_color_management_output_v1
 */
#define WP_COLOR_MANAGEMENT_OUTPUT_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_management_output_v1
 */
#define WP_COLOR_MANAGEMENT_OUTPUT_V1_GET_IMAGE_DESCRIPTION_SINCE_VERSION 1

/** @ingroup iface_wp_color_management_output_v1 */
static inline void wp_color_management_output_v1_set_user_data(
    struct wp_color_management_output_v1* wp_color_management_output_v1,
    void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)wp_color_management_output_v1,
                         user_data);
}

/** @ingroup iface_wp_color_management_output_v1 */
static inline void* wp_color_management_output_v1_get_user_data(
    struct wp_color_management_output_v1* wp_color_management_output_v1) {
  return wl_proxy_get_user_data(
      (struct wl_proxy*)wp_color_management_output_v1);
}

static inline uint32_t wp_color_management_output_v1_get_version(
    struct wp_color_management_output_v1* wp_color_management_output_v1) {
  return wl_proxy_get_version((struct wl_proxy*)wp_color_management_output_v1);
}

/**
 * @ingroup iface_wp_color_management_output_v1
 *
 * Destroy the color wp_color_management_output_v1 object. This does not
 * affect any remaining protocol objects.
 */
static inline void wp_color_management_output_v1_destroy(
    struct wp_color_management_output_v1* wp_color_management_output_v1) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_management_output_v1,
      WP_COLOR_MANAGEMENT_OUTPUT_V1_DESTROY, NULL,
      wl_proxy_get_version((struct wl_proxy*)wp_color_management_output_v1),
      WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_wp_color_management_output_v1
 *
 * This creates a new wp_image_description_v1 object for the current image
 * description of the output. There always is exactly one image description
 * active for an output so the client should destroy the image description
 * created by earlier invocations of this request. This request is usually
 * sent as a reaction to the image_description_changed event or when
 * creating a wp_color_management_output_v1 object.
 *
 * The image description of an output represents the color encoding the
 * output expects. There might be performance and power advantages, as well
 * as improved color reproduction, if a content update matches the image
 * description of the output it is being shown on. If a content update is
 * shown on any other output than the one it matches the image description
 * of, then the color reproduction on those outputs might be considerably
 * worse.
 *
 * The created wp_image_description_v1 object preserves the image
 * description of the output from the time the object was created.
 *
 * The resulting image description object allows get_information request.
 *
 * If this protocol object is inert, the resulting image description object
 * shall immediately deliver the wp_image_description_v1.failed event with
 * the no_output cause.
 *
 * If the interface version is inadequate for the output's image
 * description, meaning that the client does not support all the events
 * needed to deliver the crucial information, the resulting image
 * description object shall immediately deliver the
 * wp_image_description_v1.failed event with the low_version cause.
 *
 * Otherwise the object shall immediately deliver the ready event.
 */
static inline struct wp_image_description_v1*
wp_color_management_output_v1_get_image_description(
    struct wp_color_management_output_v1* wp_color_management_output_v1) {
  struct wl_proxy* image_description;

  image_description = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_management_output_v1,
      WP_COLOR_MANAGEMENT_OUTPUT_V1_GET_IMAGE_DESCRIPTION,
      &wp_image_description_v1_interface,
      wl_proxy_get_version((struct wl_proxy*)wp_color_management_output_v1), 0,
      NULL);

  return (struct wp_image_description_v1*)image_description;
}

#ifndef WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_ENUM
#  define WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_management_surface_v1
 * protocol errors
 */
enum wp_color_management_surface_v1_error {
  /**
   * unsupported rendering intent
   */
  WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_RENDER_INTENT = 0,
  /**
   * invalid image description
   */
  WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_IMAGE_DESCRIPTION = 1,
  /**
   * forbidden request on inert object
   */
  WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_INERT = 2,
};
#endif /* WP_COLOR_MANAGEMENT_SURFACE_V1_ERROR_ENUM */

#define WP_COLOR_MANAGEMENT_SURFACE_V1_DESTROY 0
#define WP_COLOR_MANAGEMENT_SURFACE_V1_SET_IMAGE_DESCRIPTION 1
#define WP_COLOR_MANAGEMENT_SURFACE_V1_UNSET_IMAGE_DESCRIPTION 2

/**
 * @ingroup iface_wp_color_management_surface_v1
 */
#define WP_COLOR_MANAGEMENT_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_management_surface_v1
 */
#define WP_COLOR_MANAGEMENT_SURFACE_V1_SET_IMAGE_DESCRIPTION_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_management_surface_v1
 */
#define WP_COLOR_MANAGEMENT_SURFACE_V1_UNSET_IMAGE_DESCRIPTION_SINCE_VERSION 1

/** @ingroup iface_wp_color_management_surface_v1 */
static inline void wp_color_management_surface_v1_set_user_data(
    struct wp_color_management_surface_v1* wp_color_management_surface_v1,
    void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)wp_color_management_surface_v1,
                         user_data);
}

/** @ingroup iface_wp_color_management_surface_v1 */
static inline void* wp_color_management_surface_v1_get_user_data(
    struct wp_color_management_surface_v1* wp_color_management_surface_v1) {
  return wl_proxy_get_user_data(
      (struct wl_proxy*)wp_color_management_surface_v1);
}

static inline uint32_t wp_color_management_surface_v1_get_version(
    struct wp_color_management_surface_v1* wp_color_management_surface_v1) {
  return wl_proxy_get_version((struct wl_proxy*)wp_color_management_surface_v1);
}

/**
 * @ingroup iface_wp_color_management_surface_v1
 *
 * Destroy the wp_color_management_surface_v1 object and do the same as
 * unset_image_description.
 */
static inline void wp_color_management_surface_v1_destroy(
    struct wp_color_management_surface_v1* wp_color_management_surface_v1) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_management_surface_v1,
      WP_COLOR_MANAGEMENT_SURFACE_V1_DESTROY, NULL,
      wl_proxy_get_version((struct wl_proxy*)wp_color_management_surface_v1),
      WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_wp_color_management_surface_v1
 *
 * If this protocol object is inert, the protocol error inert is raised.
 *
 * Set the image description of the underlying surface. The image
 * description and rendering intent are double-buffered state, see
 * wl_surface.commit.
 *
 * It is the client's responsibility to understand the image description
 * it sets on a surface, and to provide content that matches that image
 * description. Compositors might convert images to match their own or any
 * other image descriptions.
 *
 * Image descriptions which are not ready (see wp_image_description_v1)
 * are forbidden in this request, and in such case the protocol error
 * image_description is raised.
 *
 * All image descriptions which are ready (see wp_image_description_v1)
 * are allowed and must always be accepted by the compositor.
 *
 * A rendering intent provides the client's preference on how content
 * colors should be mapped to each output. The render_intent value must
 * be one advertised by the compositor with
 * wp_color_manager_v1.render_intent event, otherwise the protocol error
 * render_intent is raised.
 *
 * When an image description is set on a surface, the Transfer
 * Characteristics of the image description defines the valid range of
 * the nominal (real-valued) color channel values. The processing of
 * out-of-range color channel values is undefined, but compositors are
 * recommended to clamp the values to the valid range when possible.
 *
 * By default, a surface does not have an associated image description
 * nor a rendering intent. The handling of color on such surfaces is
 * compositor implementation defined. Compositors should handle such
 * surfaces as sRGB, but may handle them differently if they have specific
 * requirements.
 *
 * Setting the image description has copy semantics; after this request,
 * the image description can be immediately destroyed without affecting
 * the pending state of the surface.
 */
static inline void wp_color_management_surface_v1_set_image_description(
    struct wp_color_management_surface_v1* wp_color_management_surface_v1,
    struct wp_image_description_v1* image_description, uint32_t render_intent) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_management_surface_v1,
      WP_COLOR_MANAGEMENT_SURFACE_V1_SET_IMAGE_DESCRIPTION, NULL,
      wl_proxy_get_version((struct wl_proxy*)wp_color_management_surface_v1), 0,
      image_description, render_intent);
}

/**
 * @ingroup iface_wp_color_management_surface_v1
 *
 * If this protocol object is inert, the protocol error inert is raised.
 *
 * This request removes any image description from the surface. See
 * set_image_description for how a compositor handles a surface without
 * an image description. This is double-buffered state, see
 * wl_surface.commit.
 */
static inline void wp_color_management_surface_v1_unset_image_description(
    struct wp_color_management_surface_v1* wp_color_management_surface_v1) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_management_surface_v1,
      WP_COLOR_MANAGEMENT_SURFACE_V1_UNSET_IMAGE_DESCRIPTION, NULL,
      wl_proxy_get_version((struct wl_proxy*)wp_color_management_surface_v1),
      0);
}

#ifndef WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_ENUM
#  define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 * protocol errors
 */
enum wp_color_management_surface_feedback_v1_error {
  /**
   * forbidden request on inert object
   */
  WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_INERT = 0,
  /**
   * attempted to use an unsupported feature
   */
  WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_UNSUPPORTED_FEATURE = 1,
};
#endif /* WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_ERROR_ENUM */

/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 * @struct wp_color_management_surface_feedback_v1_listener
 */
struct wp_color_management_surface_feedback_v1_listener {
  /**
   * the preferred image description changed
   *
   * The preferred image description is the one which likely has
   * the most performance and/or quality benefits for the compositor
   * if used by the client for its wl_surface contents. This event is
   * sent whenever the compositor changes the wl_surface's preferred
   * image description.
   *
   * This event sends the identity of the new preferred state as the
   * argument, so clients who are aware of the image description
   * already can reuse it. Otherwise, if the client client wants to
   * know what the preferred image description is, it shall use the
   * get_preferred request.
   *
   * The preferred image description is not automatically used for
   * anything. It is only a hint, and clients may set any valid image
   * description with set_image_description, but there might be
   * performance and color accuracy improvements by providing the
   * wl_surface contents in the preferred image description.
   * Therefore clients that can, should render according to the
   * preferred image description
   * @param identity image description id number
   */
  void (*preferred_changed)(void* data,
                            struct wp_color_management_surface_feedback_v1*
                                wp_color_management_surface_feedback_v1,
                            uint32_t identity);
};

/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 */
static inline int wp_color_management_surface_feedback_v1_add_listener(
    struct wp_color_management_surface_feedback_v1*
        wp_color_management_surface_feedback_v1,
    const struct wp_color_management_surface_feedback_v1_listener* listener,
    void* data) {
  return wl_proxy_add_listener(
      (struct wl_proxy*)wp_color_management_surface_feedback_v1,
      (void (**)(void))listener, data);
}

#define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_DESTROY 0
#define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_GET_PREFERRED 1
#define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_GET_PREFERRED_PARAMETRIC 2

/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 */
#define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_PREFERRED_CHANGED_SINCE_VERSION \
  1

/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 */
#define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 */
#define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_GET_PREFERRED_SINCE_VERSION 1
/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 */
#define WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_GET_PREFERRED_PARAMETRIC_SINCE_VERSION \
  1

/** @ingroup iface_wp_color_management_surface_feedback_v1 */
static inline void wp_color_management_surface_feedback_v1_set_user_data(
    struct wp_color_management_surface_feedback_v1*
        wp_color_management_surface_feedback_v1,
    void* user_data) {
  wl_proxy_set_user_data(
      (struct wl_proxy*)wp_color_management_surface_feedback_v1, user_data);
}

/** @ingroup iface_wp_color_management_surface_feedback_v1 */
static inline void* wp_color_management_surface_feedback_v1_get_user_data(
    struct wp_color_management_surface_feedback_v1*
        wp_color_management_surface_feedback_v1) {
  return wl_proxy_get_user_data(
      (struct wl_proxy*)wp_color_management_surface_feedback_v1);
}

static inline uint32_t wp_color_management_surface_feedback_v1_get_version(
    struct wp_color_management_surface_feedback_v1*
        wp_color_management_surface_feedback_v1) {
  return wl_proxy_get_version(
      (struct wl_proxy*)wp_color_management_surface_feedback_v1);
}

/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 *
 * Destroy the wp_color_management_surface_feedback_v1 object.
 */
static inline void wp_color_management_surface_feedback_v1_destroy(
    struct wp_color_management_surface_feedback_v1*
        wp_color_management_surface_feedback_v1) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_management_surface_feedback_v1,
      WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_DESTROY, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_color_management_surface_feedback_v1),
      WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 *
 * If this protocol object is inert, the protocol error inert is raised.
 *
 * The preferred image description represents the compositor's preferred
 * color encoding for this wl_surface at the current time. There might be
 * performance and power advantages, as well as improved color
 * reproduction, if the image description of a content update matches the
 * preferred image description.
 *
 * This creates a new wp_image_description_v1 object for the currently
 * preferred image description for the wl_surface. The client should
 * stop using and destroy the image descriptions created by earlier
 * invocations of this request for the associated wl_surface.
 * This request is usually sent as a reaction to the preferred_changed
 * event or when creating a wp_color_management_surface_feedback_v1 object
 * if the client is capable of adapting to image descriptions.
 *
 * The created wp_image_description_v1 object preserves the preferred image
 * description of the wl_surface from the time the object was created.
 *
 * The resulting image description object allows get_information request.
 *
 * If the image description is parametric, the client should set it on its
 * wl_surface only if the image description is an exact match with the
 * client content. Particularly if everything else matches, but the target
 * color volume is greater than what the client needs, the client should
 * create its own parameric image description with its exact parameters.
 *
 * If the interface version is inadequate for the preferred image
 * description, meaning that the client does not support all the
 * events needed to deliver the crucial information, the resulting image
 * description object shall immediately deliver the
 * wp_image_description_v1.failed event with the low_version cause,
 * otherwise the object shall immediately deliver the ready event.
 */
static inline struct wp_image_description_v1*
wp_color_management_surface_feedback_v1_get_preferred(
    struct wp_color_management_surface_feedback_v1*
        wp_color_management_surface_feedback_v1) {
  struct wl_proxy* image_description;

  image_description = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_management_surface_feedback_v1,
      WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_GET_PREFERRED,
      &wp_image_description_v1_interface,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_color_management_surface_feedback_v1),
      0, NULL);

  return (struct wp_image_description_v1*)image_description;
}

/**
 * @ingroup iface_wp_color_management_surface_feedback_v1
 *
 * The same description as for get_preferred applies, except the returned
 * image description is guaranteed to be parametric. This is meant for
 * clients that can only deal with parametric image descriptions.
 *
 * If the compositor doesn't support parametric image descriptions, the
 * unsupported_feature error is emitted.
 */
static inline struct wp_image_description_v1*
wp_color_management_surface_feedback_v1_get_preferred_parametric(
    struct wp_color_management_surface_feedback_v1*
        wp_color_management_surface_feedback_v1) {
  struct wl_proxy* image_description;

  image_description = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_color_management_surface_feedback_v1,
      WP_COLOR_MANAGEMENT_SURFACE_FEEDBACK_V1_GET_PREFERRED_PARAMETRIC,
      &wp_image_description_v1_interface,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_color_management_surface_feedback_v1),
      0, NULL);

  return (struct wp_image_description_v1*)image_description;
}

#ifndef WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_ENUM
#  define WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_image_description_creator_icc_v1
 * protocol errors
 */
enum wp_image_description_creator_icc_v1_error {
  /**
   * incomplete parameter set
   */
  WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_INCOMPLETE_SET = 0,
  /**
   * property already set
   */
  WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_ALREADY_SET = 1,
  /**
   * fd not seekable and readable
   */
  WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_BAD_FD = 2,
  /**
   * no or too much data
   */
  WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_BAD_SIZE = 3,
  /**
   * offset + length exceeds file size
   */
  WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_OUT_OF_FILE = 4,
};
#endif /* WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_ERROR_ENUM */

#define WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_CREATE 0
#define WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_SET_ICC_FILE 1

/**
 * @ingroup iface_wp_image_description_creator_icc_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_creator_icc_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_SET_ICC_FILE_SINCE_VERSION 1

/** @ingroup iface_wp_image_description_creator_icc_v1 */
static inline void wp_image_description_creator_icc_v1_set_user_data(
    struct wp_image_description_creator_icc_v1*
        wp_image_description_creator_icc_v1,
    void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)wp_image_description_creator_icc_v1,
                         user_data);
}

/** @ingroup iface_wp_image_description_creator_icc_v1 */
static inline void* wp_image_description_creator_icc_v1_get_user_data(
    struct wp_image_description_creator_icc_v1*
        wp_image_description_creator_icc_v1) {
  return wl_proxy_get_user_data(
      (struct wl_proxy*)wp_image_description_creator_icc_v1);
}

static inline uint32_t wp_image_description_creator_icc_v1_get_version(
    struct wp_image_description_creator_icc_v1*
        wp_image_description_creator_icc_v1) {
  return wl_proxy_get_version(
      (struct wl_proxy*)wp_image_description_creator_icc_v1);
}

/** @ingroup iface_wp_image_description_creator_icc_v1 */
static inline void wp_image_description_creator_icc_v1_destroy(
    struct wp_image_description_creator_icc_v1*
        wp_image_description_creator_icc_v1) {
  wl_proxy_destroy((struct wl_proxy*)wp_image_description_creator_icc_v1);
}

/**
 * @ingroup iface_wp_image_description_creator_icc_v1
 *
 * Create an image description object based on the ICC information
 * previously set on this object. A compositor must parse the ICC data in
 * some undefined but finite amount of time.
 *
 * The completeness of the parameter set is verified. If the set is not
 * complete, the protocol error incomplete_set is raised. For the
 * definition of a complete set, see the description of this interface.
 *
 * If the particular combination of the information is not supported
 * by the compositor, the resulting image description object shall
 * immediately deliver the wp_image_description_v1.failed event with the
 * 'unsupported' cause. If a valid image description was created from the
 * information, the wp_image_description_v1.ready event will eventually
 * be sent instead.
 *
 * This request destroys the wp_image_description_creator_icc_v1 object.
 *
 * The resulting image description object does not allow get_information
 * request.
 */
static inline struct wp_image_description_v1*
wp_image_description_creator_icc_v1_create(
    struct wp_image_description_creator_icc_v1*
        wp_image_description_creator_icc_v1) {
  struct wl_proxy* image_description;

  image_description = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_icc_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_CREATE,
      &wp_image_description_v1_interface,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_icc_v1),
      WL_MARSHAL_FLAG_DESTROY, NULL);

  return (struct wp_image_description_v1*)image_description;
}

/**
 * @ingroup iface_wp_image_description_creator_icc_v1
 *
 * Sets the ICC profile file to be used as the basis of the image
 * description.
 *
 * The data shall be found through the given fd at the given offset, having
 * the given length. The fd must be seekable and readable. Violating these
 * requirements raises the bad_fd protocol error.
 *
 * If reading the data fails due to an error independent of the client, the
 * compositor shall send the wp_image_description_v1.failed event on the
 * created wp_image_description_v1 with the 'operating_system' cause.
 *
 * The maximum size of the ICC profile is 32 MB. If length is greater than
 * that or zero, the protocol error bad_size is raised. If offset + length
 * exceeds the file size, the protocol error out_of_file is raised.
 *
 * A compositor may read the file at any time starting from this request
 * and only until whichever happens first:
 * - If create request was issued, the wp_image_description_v1 object
 * delivers either failed or ready event; or
 * - if create request was not issued, this
 * wp_image_description_creator_icc_v1 object is destroyed.
 *
 * A compositor shall not modify the contents of the file, and the fd may
 * be sealed for writes and size changes. The client must ensure to its
 * best ability that the data does not change while the compositor is
 * reading it.
 *
 * The data must represent a valid ICC profile. The ICC profile version
 * must be 2 or 4, it must be a 3 channel profile and the class must be
 * Display or ColorSpace. Violating these requirements will not result in a
 * protocol error, but will eventually send the
 * wp_image_description_v1.failed event on the created
 * wp_image_description_v1 with the 'unsupported' cause.
 *
 * See the International Color Consortium specification ICC.1:2022 for more
 * details about ICC profiles.
 *
 * If ICC file has already been set on this object, the protocol error
 * already_set is raised.
 */
static inline void wp_image_description_creator_icc_v1_set_icc_file(
    struct wp_image_description_creator_icc_v1*
        wp_image_description_creator_icc_v1,
    int32_t icc_profile, uint32_t offset, uint32_t length) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_icc_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_ICC_V1_SET_ICC_FILE, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_icc_v1),
      0, icc_profile, offset, length);
}

#ifndef WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_ENUM
#  define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 * protocol errors
 */
enum wp_image_description_creator_params_v1_error {
  /**
   * incomplete parameter set
   */
  WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_INCOMPLETE_SET = 0,
  /**
   * property already set
   */
  WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_ALREADY_SET = 1,
  /**
   * request not supported
   */
  WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_UNSUPPORTED_FEATURE = 2,
  /**
   * invalid transfer characteristic
   */
  WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_INVALID_TF = 3,
  /**
   * invalid primaries named
   */
  WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_INVALID_PRIMARIES_NAMED = 4,
  /**
   * invalid luminance value or range
   */
  WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_INVALID_LUMINANCE = 5,
};
#endif /* WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_ERROR_ENUM */

#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_CREATE 0
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_TF_NAMED 1
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_TF_POWER 2
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_PRIMARIES_NAMED 3
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_PRIMARIES 4
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_LUMINANCES 5
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MASTERING_DISPLAY_PRIMARIES 6
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MASTERING_LUMINANCE 7
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MAX_CLL 8
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MAX_FALL 9

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_CREATE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_TF_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_TF_POWER_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_PRIMARIES_NAMED_SINCE_VERSION \
  1
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_PRIMARIES_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_LUMINANCES_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MASTERING_DISPLAY_PRIMARIES_SINCE_VERSION \
  1
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MASTERING_LUMINANCE_SINCE_VERSION \
  1
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MAX_CLL_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_creator_params_v1
 */
#define WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MAX_FALL_SINCE_VERSION 1

/** @ingroup iface_wp_image_description_creator_params_v1 */
static inline void wp_image_description_creator_params_v1_set_user_data(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    void* user_data) {
  wl_proxy_set_user_data(
      (struct wl_proxy*)wp_image_description_creator_params_v1, user_data);
}

/** @ingroup iface_wp_image_description_creator_params_v1 */
static inline void* wp_image_description_creator_params_v1_get_user_data(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1) {
  return wl_proxy_get_user_data(
      (struct wl_proxy*)wp_image_description_creator_params_v1);
}

static inline uint32_t wp_image_description_creator_params_v1_get_version(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1) {
  return wl_proxy_get_version(
      (struct wl_proxy*)wp_image_description_creator_params_v1);
}

/** @ingroup iface_wp_image_description_creator_params_v1 */
static inline void wp_image_description_creator_params_v1_destroy(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1) {
  wl_proxy_destroy((struct wl_proxy*)wp_image_description_creator_params_v1);
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Create an image description object based on the parameters previously
 * set on this object.
 *
 * The completeness of the parameter set is verified. If the set is not
 * complete, the protocol error incomplete_set is raised. For the
 * definition of a complete set, see the description of this interface.
 *
 * The protocol error invalid_luminance is raised if any of the following
 * requirements is not met:
 * - When max_cll is set, it must be greater than min L and less or equal
 * to max L of the mastering luminance range.
 * - When max_fall is set, it must be greater than min L and less or equal
 * to max L of the mastering luminance range.
 * - When both max_cll and max_fall are set, max_fall must be less or equal
 * to max_cll.
 *
 * If the particular combination of the parameter set is not supported
 * by the compositor, the resulting image description object shall
 * immediately deliver the wp_image_description_v1.failed event with the
 * 'unsupported' cause. If a valid image description was created from the
 * parameter set, the wp_image_description_v1.ready event will eventually
 * be sent instead.
 *
 * This request destroys the wp_image_description_creator_params_v1
 * object.
 *
 * The resulting image description object does not allow get_information
 * request.
 */
static inline struct wp_image_description_v1*
wp_image_description_creator_params_v1_create(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1) {
  struct wl_proxy* image_description;

  image_description = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_CREATE,
      &wp_image_description_v1_interface,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      WL_MARSHAL_FLAG_DESTROY, NULL);

  return (struct wp_image_description_v1*)image_description;
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Sets the transfer characteristic using explicitly enumerated named
 * functions.
 *
 * When the resulting image description is attached to an image, the
 * content should be encoded and decoded according to the industry standard
 * practices for the transfer characteristic.
 *
 * Only names advertised with wp_color_manager_v1 event supported_tf_named
 * are allowed. Other values shall raise the protocol error invalid_tf.
 *
 * If transfer characteristic has already been set on this object, the
 * protocol error already_set is raised.
 */
static inline void wp_image_description_creator_params_v1_set_tf_named(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    uint32_t tf) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_TF_NAMED, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      0, tf);
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Sets the color component transfer characteristic to a power curve with
 * the given exponent. Negative values are handled by mirroring the
 * positive half of the curve through the origin. The valid domain and
 * range of the curve are all finite real numbers. This curve represents
 * the conversion from electrical to optical color channel values.
 *
 * When the resulting image description is attached to an image, the
 * content should be encoded with the inverse of the power curve.
 *
 * The curve exponent shall be multiplied by 10000 to get the argument eexp
 * value to carry the precision of 4 decimals.
 *
 * The curve exponent must be at least 1.0 and at most 10.0. Otherwise the
 * protocol error invalid_tf is raised.
 *
 * If transfer characteristic has already been set on this object, the
 * protocol error already_set is raised.
 *
 * This request can be used when the compositor advertises
 * wp_color_manager_v1.feature.set_tf_power. Otherwise this request raises
 * the protocol error unsupported_feature.
 */
static inline void wp_image_description_creator_params_v1_set_tf_power(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    uint32_t eexp) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_TF_POWER, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      0, eexp);
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Sets the color primaries and white point using explicitly named sets.
 * This describes the primary color volume which is the basis for color
 * value encoding.
 *
 * Only names advertised with wp_color_manager_v1 event
 * supported_primaries_named are allowed. Other values shall raise the
 * protocol error invalid_primaries_named.
 *
 * If primaries have already been set on this object, the protocol error
 * already_set is raised.
 */
static inline void wp_image_description_creator_params_v1_set_primaries_named(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    uint32_t primaries) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_PRIMARIES_NAMED, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      0, primaries);
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Sets the color primaries and white point using CIE 1931 xy chromaticity
 * coordinates. This describes the primary color volume which is the basis
 * for color value encoding.
 *
 * Each coordinate value is multiplied by 1 million to get the argument
 * value to carry precision of 6 decimals.
 *
 * If primaries have already been set on this object, the protocol error
 * already_set is raised.
 *
 * This request can be used if the compositor advertises
 * wp_color_manager_v1.feature.set_primaries. Otherwise this request raises
 * the protocol error unsupported_feature.
 */
static inline void wp_image_description_creator_params_v1_set_primaries(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x,
    int32_t b_y, int32_t w_x, int32_t w_y) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_PRIMARIES, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      0, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Sets the primary color volume luminance range and the reference white
 * luminance level. These values include the minimum display emission
 * and ambient flare luminances, assumed to be optically additive and have
 * the chromaticity of the primary color volume white point.
 *
 * The default luminances from
 * https://www.color.org/chardata/rgb/srgb.xalter are
 * - primary color volume minimum: 0.2 cd/m²
 * - primary color volume maximum: 80 cd/m²
 * - reference white: 80 cd/m²
 *
 * Setting a named transfer characteristic can imply other default
 * luminances.
 *
 * The default luminances get overwritten when this request is used.
 * With transfer_function.st2084_pq the given 'max_lum' value is ignored,
 * and 'max_lum' is taken as 'min_lum' + 10000 cd/m².
 *
 * 'min_lum' and 'max_lum' specify the minimum and maximum luminances of
 * the primary color volume as reproduced by the targeted display.
 *
 * 'reference_lum' specifies the luminance of the reference white as
 * reproduced by the targeted display, and reflects the targeted viewing
 * environment.
 *
 * Compositors should make sure that all content is anchored, meaning that
 * an input signal level of 'reference_lum' on one image description and
 * another input signal level of 'reference_lum' on another image
 * description should produce the same output level, even though the
 * 'reference_lum' on both image representations can be different.
 *
 * 'reference_lum' may be higher than 'max_lum'. In that case reaching
 * the reference white output level in image content requires the
 * 'extended_target_volume' feature support.
 *
 * If 'max_lum' or 'reference_lum' are less than or equal to 'min_lum',
 * the protocol error invalid_luminance is raised.
 *
 * The minimum luminance is multiplied by 10000 to get the argument
 * 'min_lum' value and carries precision of 4 decimals. The maximum
 * luminance and reference white luminance values are unscaled.
 *
 * If the primary color volume luminance range and the reference white
 * luminance level have already been set on this object, the protocol error
 * already_set is raised.
 *
 * This request can be used if the compositor advertises
 * wp_color_manager_v1.feature.set_luminances. Otherwise this request
 * raises the protocol error unsupported_feature.
 */
static inline void wp_image_description_creator_params_v1_set_luminances(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    uint32_t min_lum, uint32_t max_lum, uint32_t reference_lum) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_LUMINANCES, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      0, min_lum, max_lum, reference_lum);
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Provides the color primaries and white point of the mastering display
 * using CIE 1931 xy chromaticity coordinates. This is compatible with the
 * SMPTE ST 2086 definition of HDR static metadata.
 *
 * The mastering display primaries and mastering display luminances define
 * the target color volume.
 *
 * If mastering display primaries are not explicitly set, the target color
 * volume is assumed to have the same primaries as the primary color volume.
 *
 * The target color volume is defined by all tristimulus values between 0.0
 * and 1.0 (inclusive) of the color space defined by the given mastering
 * display primaries and white point. The colorimetry is identical between
 * the container color space and the mastering display color space,
 * including that no chromatic adaptation is applied even if the white
 * points differ.
 *
 * The target color volume can exceed the primary color volume to allow for
 * a greater color volume with an existing color space definition (for
 * example scRGB). It can be smaller than the primary color volume to
 * minimize gamut and tone mapping distances for big color spaces (HDR
 * metadata).
 *
 * To make use of the entire target color volume a suitable pixel format
 * has to be chosen (e.g. floating point to exceed the primary color
 * volume, or abusing limited quantization range as with xvYCC).
 *
 * Each coordinate value is multiplied by 1 million to get the argument
 * value to carry precision of 6 decimals.
 *
 * If mastering display primaries have already been set on this object, the
 * protocol error already_set is raised.
 *
 * This request can be used if the compositor advertises
 * wp_color_manager_v1.feature.set_mastering_display_primaries. Otherwise
 * this request raises the protocol error unsupported_feature. The
 * advertisement implies support only for target color volumes fully
 * contained within the primary color volume.
 *
 * If a compositor additionally supports target color volume exceeding the
 * primary color volume, it must advertise
 * wp_color_manager_v1.feature.extended_target_volume. If a client uses
 * target color volume exceeding the primary color volume and the
 * compositor does not support it, the result is implementation defined.
 * Compositors are recommended to detect this case and fail the image
 * description gracefully, but it may as well result in color artifacts.
 */
static inline void
wp_image_description_creator_params_v1_set_mastering_display_primaries(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x,
    int32_t b_y, int32_t w_x, int32_t w_y) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MASTERING_DISPLAY_PRIMARIES,
      NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      0, r_x, r_y, g_x, g_y, b_x, b_y, w_x, w_y);
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Sets the luminance range that was used during the content mastering
 * process as the minimum and maximum absolute luminance L. These values
 * include the minimum display emission and ambient flare luminances,
 * assumed to be optically additive and have the chromaticity of the
 * primary color volume white point. This should be
 * compatible with the SMPTE ST 2086 definition of HDR static metadata.
 *
 * The mastering display primaries and mastering display luminances define
 * the target color volume.
 *
 * If mastering luminances are not explicitly set, the target color volume
 * is assumed to have the same min and max luminances as the primary color
 * volume.
 *
 * If max L is less than or equal to min L, the protocol error
 * invalid_luminance is raised.
 *
 * Min L value is multiplied by 10000 to get the argument min_lum value
 * and carry precision of 4 decimals. Max L value is unscaled for max_lum.
 *
 * This request can be used if the compositor advertises
 * wp_color_manager_v1.feature.set_mastering_display_primaries. Otherwise
 * this request raises the protocol error unsupported_feature. The
 * advertisement implies support only for target color volumes fully
 * contained within the primary color volume.
 *
 * If a compositor additionally supports target color volume exceeding the
 * primary color volume, it must advertise
 * wp_color_manager_v1.feature.extended_target_volume. If a client uses
 * target color volume exceeding the primary color volume and the
 * compositor does not support it, the result is implementation defined.
 * Compositors are recommended to detect this case and fail the image
 * description gracefully, but it may as well result in color artifacts.
 */
static inline void
wp_image_description_creator_params_v1_set_mastering_luminance(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    uint32_t min_lum, uint32_t max_lum) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MASTERING_LUMINANCE, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      0, min_lum, max_lum);
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Sets the maximum content light level (max_cll) as defined by CTA-861-H.
 *
 * max_cll is undefined by default.
 */
static inline void wp_image_description_creator_params_v1_set_max_cll(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    uint32_t max_cll) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MAX_CLL, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      0, max_cll);
}

/**
 * @ingroup iface_wp_image_description_creator_params_v1
 *
 * Sets the maximum frame-average light level (max_fall) as defined by
 * CTA-861-H.
 *
 * max_fall is undefined by default.
 */
static inline void wp_image_description_creator_params_v1_set_max_fall(
    struct wp_image_description_creator_params_v1*
        wp_image_description_creator_params_v1,
    uint32_t max_fall) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_creator_params_v1,
      WP_IMAGE_DESCRIPTION_CREATOR_PARAMS_V1_SET_MAX_FALL, NULL,
      wl_proxy_get_version(
          (struct wl_proxy*)wp_image_description_creator_params_v1),
      0, max_fall);
}

#ifndef WP_IMAGE_DESCRIPTION_V1_ERROR_ENUM
#  define WP_IMAGE_DESCRIPTION_V1_ERROR_ENUM
/**
 * @ingroup iface_wp_image_description_v1
 * protocol errors
 */
enum wp_image_description_v1_error {
  /**
   * attempted to use an object which is not ready
   */
  WP_IMAGE_DESCRIPTION_V1_ERROR_NOT_READY = 0,
  /**
   * get_information not allowed
   */
  WP_IMAGE_DESCRIPTION_V1_ERROR_NO_INFORMATION = 1,
};
#endif /* WP_IMAGE_DESCRIPTION_V1_ERROR_ENUM */

#ifndef WP_IMAGE_DESCRIPTION_V1_CAUSE_ENUM
#  define WP_IMAGE_DESCRIPTION_V1_CAUSE_ENUM
/**
 * @ingroup iface_wp_image_description_v1
 * generic reason for failure
 */
enum wp_image_description_v1_cause {
  /**
   * interface version too low
   */
  WP_IMAGE_DESCRIPTION_V1_CAUSE_LOW_VERSION = 0,
  /**
   * unsupported image description data
   */
  WP_IMAGE_DESCRIPTION_V1_CAUSE_UNSUPPORTED = 1,
  /**
   * error independent of the client
   */
  WP_IMAGE_DESCRIPTION_V1_CAUSE_OPERATING_SYSTEM = 2,
  /**
   * the relevant output no longer exists
   */
  WP_IMAGE_DESCRIPTION_V1_CAUSE_NO_OUTPUT = 3,
};
#endif /* WP_IMAGE_DESCRIPTION_V1_CAUSE_ENUM */

/**
 * @ingroup iface_wp_image_description_v1
 * @struct wp_image_description_v1_listener
 */
struct wp_image_description_v1_listener {
  /**
   * graceful error on creating the image description
   *
   * If creating a wp_image_description_v1 object fails for a
   * reason that is not defined as a protocol error, this event is
   * sent.
   *
   * The requests that create image description objects define
   * whether and when this can occur. Only such creation requests can
   * trigger this event. This event cannot be triggered after the
   * image description was successfully formed.
   *
   * Once this event has been sent, the wp_image_description_v1
   * object will never become ready and it can only be destroyed.
   * @param cause generic reason
   * @param msg ad hoc human-readable explanation
   */
  void (*failed)(void* data,
                 struct wp_image_description_v1* wp_image_description_v1,
                 uint32_t cause, const char* msg);
  /**
   * indication that the object is ready to be used
   *
   * Once this event has been sent, the wp_image_description_v1
   * object is deemed "ready". Ready objects can be used to send
   * requests and can be used through other interfaces.
   *
   * Every ready wp_image_description_v1 protocol object refers to an
   * underlying image description record in the compositor. Multiple
   * protocol objects may end up referring to the same record.
   * Clients may identify these "copies" by comparing their id
   * numbers: if the numbers from two protocol objects are identical,
   * the protocol objects refer to the same image description record.
   * Two different image description records cannot have the same id
   * number simultaneously. The id number does not change during the
   * lifetime of the image description record.
   *
   * The id number is valid only as long as the protocol object is
   * alive. If all protocol objects referring to the same image
   * description record are destroyed, the id number may be recycled
   * for a different image description record.
   *
   * Image description id number is not a protocol object id. Zero is
   * reserved as an invalid id number. It shall not be possible for a
   * client to refer to an image description by its id number in
   * protocol. The id numbers might not be portable between Wayland
   * connections. A compositor shall not send an invalid id number.
   *
   * This identity allows clients to de-duplicate image description
   * records and avoid get_information request if they already have
   * the image description information.
   * @param identity image description id number
   */
  void (*ready)(void* data,
                struct wp_image_description_v1* wp_image_description_v1,
                uint32_t identity);
};

/**
 * @ingroup iface_wp_image_description_v1
 */
static inline int wp_image_description_v1_add_listener(
    struct wp_image_description_v1* wp_image_description_v1,
    const struct wp_image_description_v1_listener* listener, void* data) {
  return wl_proxy_add_listener((struct wl_proxy*)wp_image_description_v1,
                               (void (**)(void))listener, data);
}

#define WP_IMAGE_DESCRIPTION_V1_DESTROY 0
#define WP_IMAGE_DESCRIPTION_V1_GET_INFORMATION 1

/**
 * @ingroup iface_wp_image_description_v1
 */
#define WP_IMAGE_DESCRIPTION_V1_FAILED_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_v1
 */
#define WP_IMAGE_DESCRIPTION_V1_READY_SINCE_VERSION 1

/**
 * @ingroup iface_wp_image_description_v1
 */
#define WP_IMAGE_DESCRIPTION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_v1
 */
#define WP_IMAGE_DESCRIPTION_V1_GET_INFORMATION_SINCE_VERSION 1

/** @ingroup iface_wp_image_description_v1 */
static inline void wp_image_description_v1_set_user_data(
    struct wp_image_description_v1* wp_image_description_v1, void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)wp_image_description_v1, user_data);
}

/** @ingroup iface_wp_image_description_v1 */
static inline void* wp_image_description_v1_get_user_data(
    struct wp_image_description_v1* wp_image_description_v1) {
  return wl_proxy_get_user_data((struct wl_proxy*)wp_image_description_v1);
}

static inline uint32_t wp_image_description_v1_get_version(
    struct wp_image_description_v1* wp_image_description_v1) {
  return wl_proxy_get_version((struct wl_proxy*)wp_image_description_v1);
}

/**
 * @ingroup iface_wp_image_description_v1
 *
 * Destroy this object. It is safe to destroy an object which is not ready.
 *
 * Destroying a wp_image_description_v1 object has no side-effects, not
 * even if a wp_color_management_surface_v1.set_image_description has not
 * yet been followed by a wl_surface.commit.
 */
static inline void wp_image_description_v1_destroy(
    struct wp_image_description_v1* wp_image_description_v1) {
  wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_v1,
      WP_IMAGE_DESCRIPTION_V1_DESTROY, NULL,
      wl_proxy_get_version((struct wl_proxy*)wp_image_description_v1),
      WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_wp_image_description_v1
 *
 * Creates a wp_image_description_info_v1 object which delivers the
 * information that makes up the image description.
 *
 * Not all image description protocol objects allow get_information
 * request. Whether it is allowed or not is defined by the request that
 * created the object. If get_information is not allowed, the protocol
 * error no_information is raised.
 */
static inline struct wp_image_description_info_v1*
wp_image_description_v1_get_information(
    struct wp_image_description_v1* wp_image_description_v1) {
  struct wl_proxy* information;

  information = wl_proxy_marshal_flags(
      (struct wl_proxy*)wp_image_description_v1,
      WP_IMAGE_DESCRIPTION_V1_GET_INFORMATION,
      &wp_image_description_info_v1_interface,
      wl_proxy_get_version((struct wl_proxy*)wp_image_description_v1), 0, NULL);

  return (struct wp_image_description_info_v1*)information;
}

/**
 * @ingroup iface_wp_image_description_info_v1
 * @struct wp_image_description_info_v1_listener
 */
struct wp_image_description_info_v1_listener {
  /**
   * end of information
   *
   * Signals the end of information events and destroys the object.
   */
  void (*done)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1);
  /**
   * ICC profile matching the image description
   *
   * The icc argument provides a file descriptor to the client
   * which may be memory-mapped to provide the ICC profile matching
   * the image description. The fd is read-only, and if mapped then
   * it must be mapped with MAP_PRIVATE by the client.
   *
   * The ICC profile version and other details are determined by the
   * compositor. There is no provision for a client to ask for a
   * specific kind of a profile.
   * @param icc ICC profile file descriptor
   * @param icc_size ICC profile size, in bytes
   */
  void (*icc_file)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      int32_t icc, uint32_t icc_size);
  /**
   * primaries as chromaticity coordinates
   *
   * Delivers the primary color volume primaries and white point
   * using CIE 1931 xy chromaticity coordinates.
   *
   * Each coordinate value is multiplied by 1 million to get the
   * argument value to carry precision of 6 decimals.
   * @param r_x Red x * 1M
   * @param r_y Red y * 1M
   * @param g_x Green x * 1M
   * @param g_y Green y * 1M
   * @param b_x Blue x * 1M
   * @param b_y Blue y * 1M
   * @param w_x White x * 1M
   * @param w_y White y * 1M
   */
  void (*primaries)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x,
      int32_t b_y, int32_t w_x, int32_t w_y);
  /**
   * named primaries
   *
   * Delivers the primary color volume primaries and white point
   * using an explicitly enumerated named set.
   * @param primaries named primaries
   */
  void (*primaries_named)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      uint32_t primaries);
  /**
   * transfer characteristic as a power curve
   *
   * The color component transfer characteristic of this image
   * description is a pure power curve. This event provides the
   * exponent of the power function. This curve represents the
   * conversion from electrical to optical pixel or color values.
   *
   * The curve exponent has been multiplied by 10000 to get the
   * argument eexp value to carry the precision of 4 decimals.
   * @param eexp the exponent * 10000
   */
  void (*tf_power)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      uint32_t eexp);
  /**
   * named transfer characteristic
   *
   * Delivers the transfer characteristic using an explicitly
   * enumerated named function.
   * @param tf named transfer function
   */
  void (*tf_named)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      uint32_t tf);
  /**
   * primary color volume luminance range and reference white
   *
   * Delivers the primary color volume luminance range and the
   * reference white luminance level. These values include the
   * minimum display emission and ambient flare luminances, assumed
   * to be optically additive and have the chromaticity of the
   * primary color volume white point.
   *
   * The minimum luminance is multiplied by 10000 to get the argument
   * 'min_lum' value and carries precision of 4 decimals. The maximum
   * luminance and reference white luminance values are unscaled.
   * @param min_lum minimum luminance (cd/m²) * 10000
   * @param max_lum maximum luminance (cd/m²)
   * @param reference_lum reference white luminance (cd/m²)
   */
  void (*luminances)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      uint32_t min_lum, uint32_t max_lum, uint32_t reference_lum);
  /**
   * target primaries as chromaticity coordinates
   *
   * Provides the color primaries and white point of the target
   * color volume using CIE 1931 xy chromaticity coordinates. This is
   * compatible with the SMPTE ST 2086 definition of HDR static
   * metadata for mastering displays.
   *
   * While primary color volume is about how color is encoded, the
   * target color volume is the actually displayable color volume. If
   * target color volume is equal to the primary color volume, then
   * this event is not sent.
   *
   * Each coordinate value is multiplied by 1 million to get the
   * argument value to carry precision of 6 decimals.
   * @param r_x Red x * 1M
   * @param r_y Red y * 1M
   * @param g_x Green x * 1M
   * @param g_y Green y * 1M
   * @param b_x Blue x * 1M
   * @param b_y Blue y * 1M
   * @param w_x White x * 1M
   * @param w_y White y * 1M
   */
  void (*target_primaries)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x,
      int32_t b_y, int32_t w_x, int32_t w_y);
  /**
   * target luminance range
   *
   * Provides the luminance range that the image description is
   * targeting as the minimum and maximum absolute luminance L. These
   * values include the minimum display emission and ambient flare
   * luminances, assumed to be optically additive and have the
   * chromaticity of the primary color volume white point. This
   * should be compatible with the SMPTE ST 2086 definition of HDR
   * static metadata.
   *
   * This luminance range is only theoretical and may not correspond
   * to the luminance of light emitted on an actual display.
   *
   * Min L value is multiplied by 10000 to get the argument min_lum
   * value and carry precision of 4 decimals. Max L value is unscaled
   * for max_lum.
   * @param min_lum min L (cd/m²) * 10000
   * @param max_lum max L (cd/m²)
   */
  void (*target_luminance)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      uint32_t min_lum, uint32_t max_lum);
  /**
   * target maximum content light level
   *
   * Provides the targeted max_cll of the image description.
   * max_cll is defined by CTA-861-H.
   *
   * This luminance is only theoretical and may not correspond to the
   * luminance of light emitted on an actual display.
   * @param max_cll Maximum content light-level (cd/m²)
   */
  void (*target_max_cll)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      uint32_t max_cll);
  /**
   * target maximum frame-average light level
   *
   * Provides the targeted max_fall of the image description.
   * max_fall is defined by CTA-861-H.
   *
   * This luminance is only theoretical and may not correspond to the
   * luminance of light emitted on an actual display.
   * @param max_fall Maximum frame-average light level (cd/m²)
   */
  void (*target_max_fall)(
      void* data,
      struct wp_image_description_info_v1* wp_image_description_info_v1,
      uint32_t max_fall);
};

/**
 * @ingroup iface_wp_image_description_info_v1
 */
static inline int wp_image_description_info_v1_add_listener(
    struct wp_image_description_info_v1* wp_image_description_info_v1,
    const struct wp_image_description_info_v1_listener* listener, void* data) {
  return wl_proxy_add_listener((struct wl_proxy*)wp_image_description_info_v1,
                               (void (**)(void))listener, data);
}

/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_ICC_FILE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_PRIMARIES_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_PRIMARIES_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_TF_POWER_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_TF_NAMED_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_LUMINANCES_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_TARGET_PRIMARIES_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_TARGET_LUMINANCE_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_TARGET_MAX_CLL_SINCE_VERSION 1
/**
 * @ingroup iface_wp_image_description_info_v1
 */
#define WP_IMAGE_DESCRIPTION_INFO_V1_TARGET_MAX_FALL_SINCE_VERSION 1

/** @ingroup iface_wp_image_description_info_v1 */
static inline void wp_image_description_info_v1_set_user_data(
    struct wp_image_description_info_v1* wp_image_description_info_v1,
    void* user_data) {
  wl_proxy_set_user_data((struct wl_proxy*)wp_image_description_info_v1,
                         user_data);
}

/** @ingroup iface_wp_image_description_info_v1 */
static inline void* wp_image_description_info_v1_get_user_data(
    struct wp_image_description_info_v1* wp_image_description_info_v1) {
  return wl_proxy_get_user_data((struct wl_proxy*)wp_image_description_info_v1);
}

static inline uint32_t wp_image_description_info_v1_get_version(
    struct wp_image_description_info_v1* wp_image_description_info_v1) {
  return wl_proxy_get_version((struct wl_proxy*)wp_image_description_info_v1);
}

/** @ingroup iface_wp_image_description_info_v1 */
static inline void wp_image_description_info_v1_destroy(
    struct wp_image_description_info_v1* wp_image_description_info_v1) {
  wl_proxy_destroy((struct wl_proxy*)wp_image_description_info_v1);
}

#ifdef __cplusplus
}
#endif

#endif
