/*----------------------------------------------------------------------------
 *
 * Filename: C:\Sonic\Trunk\EASLib\WTLibrary\hybrid_22khz_mcu.c
 * Source: C:\Sonic\Trunk\Wavetables\Sonic_20Khz_Drums.dls
 * CmdLine: -w C:\Sonic\Trunk\EASLib\WTLibrary\hybrid_22khz_mcu.c -l C:\Sonic\Trunk\EASLib\WTLibrary\hybrid_22khz.log -d 0 -c -f C:\Sonic\Release3-5\EASLib\FMSynth\GMdblib-3.fml C:\Sonic\Trunk\Wavetables\Sonic_20Khz_Drums.dls -w -l -d -c -f C:\Sonic\Trunk\Wavetables\Sonic_20Khz_Drums.dls 
 * Purpose: Wavetable sound libary
 *
 * Copyright (c) 2006 Sonic Network Inc.

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *----------------------------------------------------------------------------
 * Revision Control:
 *   $Revision:$
 *   $Date:$
 *----------------------------------------------------------------------------
*/

#include "eas_sndlib.h"

/*----------------------------------------------------------------------------
 * Articulations
 *----------------------------------------------------------------------------
*/
static const S_ARTICULATION eas_articulations[] = 
{
	{ /* articulation 0 */
		{ 32767, 30725, 0, 30725 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 1 */
		{ 32767, 26863, 0, 26863 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 2 */
		{ 32767, 30484, 0, 30668 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 3 */
		{ 32767, 26439, 0, 26439 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 4 */
		{ 32767, 0, 32767, 32715 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 5 */
		{ 32767, 21333, 0, 21333 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 6 */
		{ 32767, 31882, 0, 31938 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 7 */
		{ 32767, 32663, 32767, 32663 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 8 */
		{ 32767, 0, 32767, 0 },
		{ 32767, 1902, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 9 */
		{ 32767, 32349, 0, 32349 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 10 */
		{ 32767, 0, 32767, 17213 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -1
	},
	{ /* articulation 11 */
		{ 32767, 32072, 0, 32072 },
		{ 32767, 761, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -56
	},
	{ /* articulation 12 */
		{ 32767, 23749, 0, 23749 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 56
	},
	{ /* articulation 13 */
		{ 32767, 32010, 0, 32010 },
		{ 32767, 761, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -31
	},
	{ /* articulation 14 */
		{ 9511, 21333, 0, 21333 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 56
	},
	{ /* articulation 15 */
		{ 32767, 31844, 0, 31844 },
		{ 32767, 761, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -6
	},
	{ /* articulation 16 */
		{ 32767, 32123, 0, 32194 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 56
	},
	{ /* articulation 17 */
		{ 32767, 31730, 0, 31730 },
		{ 32767, 761, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 6
	},
	{ /* articulation 18 */
		{ 32767, 31391, 0, 31391 },
		{ 32767, 951, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 31
	},
	{ /* articulation 19 */
		{ 32767, 31964, 0, 31964 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 25
	},
	{ /* articulation 20 */
		{ 32767, 31056, 0, 31056 },
		{ 32767, 951, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 63
	},
	{ /* articulation 21 */
		{ 32767, 32289, 0, 32271 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -37
	},
	{ /* articulation 22 */
		{ 19021, 31882, 0, 31911 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -37
	},
	{ /* articulation 23 */
		{ 32767, 31988, 0, 32032 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -37
	},
	{ /* articulation 24 */
		{ 32767, 0, 32767, 32663 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 12
	},
	{ /* articulation 25 */
		{ 32767, 31352, 0, 31352 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -25
	},
	{ /* articulation 26 */
		{ 32767, 0, 32767, 32663 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 25
	},
	{ /* articulation 27 */
		{ 32767, 31817, 0, 31781 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -25
	},
	{ /* articulation 28 */
		{ 32767, 30725, 0, 30725 },
		{ 32767, 95, 0, 0 },
		0, 0, 951, 240, 0, 0, 0, 0, -56
	},
	{ /* articulation 29 */
		{ 32767, 32230, 0, 32218 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -37
	},
	{ /* articulation 30 */
		{ 32767, 26439, 0, 26439 },
		{ 32767, 3804, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 50
	},
	{ /* articulation 31 */
		{ 32767, 23749, 0, 23749 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -50
	},
	{ /* articulation 32 */
		{ 32767, 29434, 0, 29434 },
		{ 32767, 3804, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -50
	},
	{ /* articulation 33 */
		{ 32767, 30240, 0, 30234 },
		{ 32767, 3804, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -44
	},
	{ /* articulation 34 */
		{ 32767, 32558, 0, 32558 },
		{ 32767, 254, 0, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 25
	},
	{ /* articulation 35 */
		{ 32767, 0, 32767, 32663 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -63
	},
	{ /* articulation 36 */
		{ 3804, 23749, 0, 23749 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -63
	},
	{ /* articulation 37 */
		{ 32767, 23749, 0, 23749 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -59
	},
	{ /* articulation 38 */
		{ 32767, 30725, 0, 30725 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 50
	},
	{ /* articulation 39 */
		{ 32767, 28809, 0, 28809 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 44
	},
	{ /* articulation 40 */
		{ 1902, 30725, 0, 30725 },
		{ 32767, 380, 0, 0 },
		0, 0, 951, -100, 0, 0, 0, 0, 44
	},
	{ /* articulation 41 */
		{ 32767, 9042, 0, 9042 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 25
	},
	{ /* articulation 42 */
		{ 32767, 29889, 0, 29889 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 63
	},
	{ /* articulation 43 */
		{ 32767, 30240, 0, 30234 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 63
	},
	{ /* articulation 44 */
		{ 19021, 19970, 0, 19970 },
		{ 951, 32767, 32767, 0 },
		0, 0, 951, 100, 0, 0, 0, 0, -25
	},
	{ /* articulation 45 */
		{ 3804, 17213, 0, 17213 },
		{ 951, 32767, 32767, 0 },
		0, 0, 951, 500, 0, 0, 0, 0, -25
	},
	{ /* articulation 46 */
		{ 32767, 17213, 0, 17213 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -56
	},
	{ /* articulation 47 */
		{ 32767, 30725, 0, 30725 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, -56
	},
	{ /* articulation 48 */
		{ 32767, 0, 32767, 0 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 49 */
		{ 32767, 31180, 0, 31180 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 50 */
		{ 19021, 31964, 0, 32071 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 51 */
		{ 32767, 29669, 0, 29669 },
		{ 32767, 32767, 32767, 0 },
		0, 0, 951, 0, 0, 0, 0, 0, 0
	},
	{ /* articulation 52 */
		{ 32767, 31742, 0, 31352 },
		{ 32767, 294, 0, 0 },
		0, 0, 951, 0, 10000, 7121, 0, 0, 0
	}
}; /*end Articulations */

/*----------------------------------------------------------------------------
 * Regions
 *----------------------------------------------------------------------------
*/
static const S_WT_REGION eas_regions[] = 
{
	{ { 0, 27, 27 }, -2868, 16422, 0, 0, 19, 0 }, /* region 0 */
	{ { 0, 28, 28 }, -3568, 32767, 0, 0, 13, 0 }, /* region 1 */
	{ { 0, 29, 29 }, -4553, 32767, 0, 0, 9, 1 }, /* region 2 */
	{ { 0, 30, 30 }, -4853, 32767, 0, 0, 9, 2 }, /* region 3 */
	{ { 0, 31, 31 }, -3868, 23197, 0, 0, 15, 3 }, /* region 4 */
	{ { 1536, 32, 32 }, -3368, 20675, 0, 0, 29, 4 }, /* region 5 */
	{ { 1537, 33, 33 }, -3868, 20675, 792, 800, 17, 5 }, /* region 6 */
	{ { 1537, 34, 34 }, -3968, 16422, 792, 800, 17, 6 }, /* region 7 */
	{ { 0, 35, 35 }, -4968, 32767, 0, 0, 20, 7 }, /* region 8 */
	{ { 0, 36, 36 }, -4968, 32767, 0, 0, 20, 7 }, /* region 9 */
	{ { 0, 37, 37 }, -4051, 18426, 0, 0, 16, 8 }, /* region 10 */
	{ { 0, 38, 38 }, -4151, 23197, 0, 0, 5, 9 }, /* region 11 */
	{ { 0, 39, 39 }, -4668, 23197, 0, 0, 12, 10 }, /* region 12 */
	{ { 0, 40, 40 }, -4151, 23197, 0, 0, 5, 4 }, /* region 13 */
	{ { 1, 41, 41 }, -5855, 26028, 798, 993, 14, 11 }, /* region 14 */
	{ { 257, 42, 42 }, -4368, 26028, 4288, 6792, 2, 12 }, /* region 15 */
	{ { 1, 43, 43 }, -5755, 26028, 798, 993, 14, 13 }, /* region 16 */
	{ { 257, 44, 44 }, -4568, 26028, 4288, 6792, 2, 14 }, /* region 17 */
	{ { 1, 45, 45 }, -5755, 26028, 798, 993, 14, 15 }, /* region 18 */
	{ { 257, 46, 46 }, -4768, 26028, 4288, 6792, 2, 16 }, /* region 19 */
	{ { 1, 47, 47 }, -5455, 26028, 798, 993, 14, 17 }, /* region 20 */
	{ { 1, 48, 48 }, -5355, 26028, 798, 993, 14, 18 }, /* region 21 */
	{ { 1, 49, 49 }, -5368, 16422, 1294, 5241, 3, 19 }, /* region 22 */
	{ { 1, 50, 50 }, -5255, 26028, 798, 993, 14, 20 }, /* region 23 */
	{ { 1, 51, 51 }, -5268, 16422, 6592, 9921, 0, 21 }, /* region 24 */
	{ { 1, 52, 52 }, -5768, 32767, 1294, 5241, 3, 22 }, /* region 25 */
	{ { 1, 53, 53 }, -5418, 14636, 6592, 9921, 0, 23 }, /* region 26 */
	{ { 0, 54, 54 }, -5751, 26028, 0, 0, 11, 24 }, /* region 27 */
	{ { 1, 55, 55 }, -5468, 32767, 1294, 5241, 3, 25 }, /* region 28 */
	{ { 0, 56, 56 }, -7255, 32767, 0, 0, 24, 26 }, /* region 29 */
	{ { 1, 57, 57 }, -5868, 32767, 1294, 5241, 3, 27 }, /* region 30 */
	{ { 1, 58, 58 }, -7053, 23197, 0, 166, 26, 28 }, /* region 31 */
	{ { 1, 59, 59 }, -5968, 16422, 6592, 9921, 0, 29 }, /* region 32 */
	{ { 1, 60, 60 }, -6453, 23197, 432, 582, 18, 30 }, /* region 33 */
	{ { 1, 61, 61 }, -6853, 16422, 432, 582, 18, 30 }, /* region 34 */
	{ { 1, 62, 62 }, -7253, 20675, 432, 582, 18, 31 }, /* region 35 */
	{ { 1, 63, 63 }, -7353, 23197, 432, 582, 18, 32 }, /* region 36 */
	{ { 1, 64, 64 }, -7953, 23197, 432, 582, 18, 33 }, /* region 37 */
	{ { 0, 65, 65 }, -7555, 32767, 0, 0, 4, 34 }, /* region 38 */
	{ { 0, 66, 66 }, -7955, 20675, 0, 0, 4, 34 }, /* region 39 */
	{ { 512, 67, 67 }, -7155, 18426, 0, 0, 24, 35 }, /* region 40 */
	{ { 512, 68, 68 }, -7755, 18426, 0, 0, 24, 35 }, /* region 41 */
	{ { 0, 69, 69 }, -7755, 32767, 0, 0, 21, 36 }, /* region 42 */
	{ { 0, 70, 70 }, -6855, 21900, 0, 0, 21, 37 }, /* region 43 */
	{ { 769, 71, 71 }, -6355, 23197, 0, 1226, 10, 38 }, /* region 44 */
	{ { 769, 72, 72 }, -6955, 26028, 0, 1226, 10, 38 }, /* region 45 */
	{ { 1024, 73, 73 }, -7955, 32767, 0, 0, 7, 39 }, /* region 46 */
	{ { 1024, 74, 74 }, -8455, 32767, 0, 0, 7, 40 }, /* region 47 */
	{ { 1, 75, 75 }, -8068, 23197, 0, 29, 30, 41 }, /* region 48 */
	{ { 0, 76, 76 }, -10455, 23197, 0, 0, 28, 42 }, /* region 49 */
	{ { 0, 77, 77 }, -10055, 23197, 0, 0, 28, 43 }, /* region 50 */
	{ { 0, 78, 78 }, -8853, 16422, 0, 0, 23, 44 }, /* region 51 */
	{ { 0, 79, 79 }, -10253, 16422, 0, 0, 23, 45 }, /* region 52 */
	{ { 1280, 80, 80 }, -6468, 13045, 0, 0, 25, 46 }, /* region 53 */
	{ { 1280, 81, 81 }, -6568, 16422, 0, 0, 25, 47 }, /* region 54 */
	{ { 0, 82, 82 }, -8455, 20675, 0, 0, 22, 48 }, /* region 55 */
	{ { 0, 83, 83 }, -9068, 32767, 0, 0, 6, 49 }, /* region 56 */
	{ { 1, 84, 84 }, -8568, 23197, 0, 9337, 1, 50 }, /* region 57 */
	{ { 0, 85, 85 }, -9655, 32767, 0, 0, 27, 0 }, /* region 58 */
	{ { 0, 86, 86 }, -9068, 16422, 0, 0, 8, 51 }, /* region 59 */
	{ { 32769, 87, 87 }, -9168, 32767, 1335, 1603, 8, 52 } /* region 60 */
}; /* end Regions */

/*----------------------------------------------------------------------------
 * FM Regions
 *----------------------------------------------------------------------------
*/
static const S_FM_REGION eas_fmRegions[] = 
{

	{ /* FM region 0 */
		{ 37, 0, 127 }, 0, 255, 8, 0,
		{
			{ 514, 239, 47, 97, 0, 184, 3 },
			{ 1, 244, 89, 114, 0, 248, 2 },
			{ 3370, 244, 49, 76, 40, 192, 2 },
			{ -1, 227, 97, 51, 160, 212, 2 }
		}
	},
	{ /* FM region 1 */
		{ 37, 0, 127 }, 160, 255, 8, 0,
		{
			{ 2514, 223, 95, 72, 0, 176, 3 },
			{ 1, 244, 73, 145, 0, 244, 2 },
			{ 3600, 245, 81, 198, 40, 192, 2 },
			{ 3, 246, 81, 163, 108, 212, 2 }
		}
	},
	{ /* FM region 2 */
		{ 37, 0, 127 }, 160, 255, 119, 0,
		{
			{ 0, 216, 79, 72, 0, 216, 2 },
			{ 2, 244, 73, 145, 0, 244, 2 },
			{ 3370, 247, 33, 182, 60, 204, 2 },
			{ 1200, 246, 65, 163, 108, 204, 2 }
		}
	},
	{ /* FM region 3 */
		{ 37, 0, 127 }, 160, 255, 1, 0,
		{
			{ 3369, 248, 65, 71, 40, 208, 2 },
			{ -3, 245, 88, 113, 0, 244, 2 },
			{ 2784, 225, 65, 133, 80, 192, 2 },
			{ 3, 241, 81, 113, 80, 216, 2 }
		}
	},
	{ /* FM region 4 */
		{ 34, 0, 127 }, 0, 255, 128, 0,
		{
			{ 0, 229, 155, 183, 0, 228, 2 },
			{ -3, 243, 90, 81, 0, 244, 2 },
			{ 4800, 248, 109, 180, 36, 192, 2 },
			{ 3, 245, 90, 85, 16, 244, 2 }
		}
	},
	{ /* FM region 5 */
		{ 34, 0, 127 }, 9, 96, 192, 0,
		{
			{ 1200, 229, 157, 180, 0, 216, 2 },
			{ -3, 244, 90, 81, 0, 244, 2 },
			{ 1902, 255, 111, 182, 80, 208, 2 },
			{ 3, 246, 92, 83, 0, 244, 2 }
		}
	},
	{ /* FM region 6 */
		{ 34, 0, 127 }, 0, 255, 154, 0,
		{
			{ 3102, 244, 63, 102, 228, 228, 2 },
			{ 1200, 247, 93, 97, 0, 236, 2 },
			{ 1902, 255, 63, 98, 156, 220, 2 },
			{ 1200, 244, 92, 98, 0, 236, 2 }
		}
	},
	{ /* FM region 7 */
		{ 37, 0, 127 }, 0, 255, 202, 0,
		{
			{ 0, 251, 131, 19, 216, 220, 2 },
			{ 1201, 247, 62, 113, 0, 240, 2 },
			{ 0, 243, 154, 36, 240, 224, 2 },
			{ 2784, 250, 61, 36, 240, 208, 2 }
		}
	},
	{ /* FM region 8 */
		{ 33, 0, 127 }, 0, 255, 80, 0,
		{
			{ -1, 213, 191, 183, 0, 204, 2 },
			{ 1, 245, 154, 129, 0, 244, 2 },
			{ 3831, 252, 159, 100, 0, 200, 2 },
			{ 1197, 246, 91, 182, 0, 244, 2 }
		}
	},
	{ /* FM region 9 */
		{ 34, 0, 127 }, 48, 80, 21, 0,
		{
			{ 2982, 255, 43, 96, 0, 196, 3 },
			{ 3, 247, 71, 130, 0, 244, 2 },
			{ 3358, 253, 40, 98, 144, 208, 2 },
			{ -2, 246, 70, 130, 0, 236, 2 }
		}
	},
	{ /* FM region 10 */
		{ 34, 0, 127 }, 48, 80, 26, 0,
		{
			{ 3096, 249, 72, 100, 0, 208, 2 },
			{ 2185, 249, 102, 130, 0, 240, 2 },
			{ 3386, 247, 66, 100, 144, 212, 2 },
			{ -2, 247, 102, 130, 0, 240, 2 }
		}
	},
	{ /* FM region 11 */
		{ 34, 0, 127 }, 92, 67, 21, 0,
		{
			{ 2982, 255, 27, 146, 0, 200, 3 },
			{ 3, 246, 68, 146, 0, 240, 2 },
			{ 3358, 250, 149, 116, 144, 208, 2 },
			{ -3, 245, 68, 146, 0, 240, 0 }
		}
	},
	{ /* FM region 12 */
		{ 34, 0, 127 }, 0, 67, 0, 0,
		{
			{ 1500, 239, 60, 151, 0, 220, 2 },
			{ 0, 247, 76, 146, 0, 240, 2 },
			{ 2398, 234, 156, 151, 0, 212, 2 },
			{ 0, 246, 105, 146, 0, 244, 2 }
		}
	},
	{ /* FM region 13 */
		{ 34, 0, 127 }, 0, 67, 0, 0,
		{
			{ 2500, 255, 60, 151, 0, 220, 2 },
			{ 0, 249, 92, 146, 0, 244, 2 },
			{ 3369, 250, 156, 151, 0, 196, 2 },
			{ 0, 248, 89, 146, 0, 244, 2 }
		}
	},
	{ /* FM region 14 */
		{ 37, 0, 127 }, 160, 255, 0, 0,
		{
			{ 2300, 229, 112, 49, 0, 208, 2 },
			{ -3, 247, 67, 50, 0, 248, 2 },
			{ 1074, 255, 41, 49, 0, 196, 2 },
			{ 686, 240, 97, 18, 0, 196, 2 }
		}
	},
	{ /* FM region 15 */
		{ 37, 0, 127 }, 160, 255, 219, 0,
		{
			{ 3369, 255, 65, 70, 40, 216, 2 },
			{ 1, 246, 72, 113, 0, 240, 2 },
			{ 1902, 225, 33, 129, 80, 204, 2 },
			{ 2400, 225, 97, 113, 80, 200, 2 }
		}
	},
	{ /* FM region 16 */
		{ 35, 0, 127 }, 32, 48, 151, 0,
		{
			{ 1201, 215, 35, 66, 252, 208, 0 },
			{ -9581, 254, 63, 177, 240, 240, 3 },
			{ 1902, 248, 47, 64, 112, 244, 2 },
			{ 0, 247, 35, 66, 208, 212, 2 }
		}
	},
	{ /* FM region 17 */
		{ 33, 0, 127 }, 0, 255, 153, 0,
		{
			{ 1, 252, 31, 3, 244, 196, 2 },
			{ -1, 208, 31, 4, 248, 244, 2 },
			{ 1205, 209, 31, 4, 248, 236, 2 },
			{ 1899, 250, 31, 32, 0, 240, 2 }
		}
	},
	{ /* FM region 18 */
		{ 34, 0, 127 }, 32, 49, 201, 0,
		{
			{ 1, 220, 47, 3, 244, 220, 0 },
			{ -10000, 208, 63, 1, 248, 240, 3 },
			{ 1586, 255, 47, 3, 188, 216, 2 },
			{ -1, 202, 63, 32, 80, 232, 2 }
		}
	},
	{ /* FM region 19 */
		{ 33, 0, 127 }, 0, 143, 29, 0,
		{
			{ -1200, 223, 64, 0, 252, 216, 2 },
			{ 1200, 96, 41, 35, 248, 240, 2 },
			{ 1200, 143, 41, 64, 252, 224, 2 },
			{ 3102, 161, 41, 96, 248, 216, 2 }
		}
	},
	{ /* FM region 20 */
		{ 34, 0, 127 }, 0, 143, 34, 0,
		{
			{ -1200, 133, 79, 1, 252, 212, 2 },
			{ 1201, 112, 46, 34, 248, 232, 2 },
			{ 0, 116, 79, 65, 252, 200, 2 },
			{ 1900, 161, 46, 98, 248, 232, 2 }
		}
	},
	{ /* FM region 21 */
		{ 34, 0, 127 }, 0, 143, 187, 0,
		{
			{ 1202, 80, 74, 1, 252, 216, 2 },
			{ 2402, 112, 46, 34, 248, 232, 2 },
			{ 0, 99, 78, 97, 184, 216, 2 },
			{ 1899, 81, 46, 98, 236, 232, 2 }
		}
	},
	{ /* FM region 22 */
		{ 37, 0, 127 }, 22, 141, 34, 0,
		{
			{ 2787, 176, 79, 4, 252, 208, 2 },
			{ 2785, 144, 45, 34, 248, 236, 2 },
			{ 3369, 83, 77, 100, 184, 172, 2 },
			{ 1902, 102, 45, 100, 172, 212, 0 }
		}
	},
	{ /* FM region 23 */
		{ 34, 0, 127 }, 0, 143, 135, 0,
		{
			{ 1900, 112, 79, 3, 252, 220, 2 },
			{ 2400, 128, 45, 34, 248, 232, 2 },
			{ 1200, 115, 77, 98, 184, 220, 2 },
			{ 1904, 97, 45, 98, 236, 232, 2 }
		}
	},
	{ /* FM region 24 */
		{ 37, 0, 127 }, 0, 255, 157, 0,
		{
			{ 1200, 244, 54, 4, 20, 200, 2 },
			{ 0, 245, 92, 130, 0, 244, 2 },
			{ 3802, 247, 68, 21, 0, 196, 2 },
			{ 1, 245, 43, 114, 0, 204, 2 }
		}
	},
	{ /* FM region 25 */
		{ 37, 0, 127 }, 0, 128, 83, 0,
		{
			{ 0, 244, 51, 4, 200, 204, 0 },
			{ 0, 247, 108, 129, 0, 248, 0 },
			{ 2786, 243, 31, 70, 200, 220, 0 },
			{ 1902, 246, 44, 113, 12, 188, 0 }
		}
	},
	{ /* FM region 26 */
		{ 37, 0, 127 }, 0, 128, 61, 0,
		{
			{ 0, 246, 51, 97, 76, 204, 0 },
			{ 0, 244, 60, 97, 0, 240, 0 },
			{ 1786, 255, 31, 64, 0, 180, 0 },
			{ 1200, 247, 60, 97, 12, 204, 0 }
		}
	},
	{ /* FM region 27 */
		{ 37, 0, 127 }, 0, 128, 153, 0,
		{
			{ -2, 243, 53, 99, 96, 200, 0 },
			{ 0, 243, 60, 97, 0, 240, 0 },
			{ 3983, 247, 63, 100, 24, 204, 0 },
			{ 2, 242, 53, 99, 52, 212, 0 }
		}
	},
	{ /* FM region 28 */
		{ 37, 0, 127 }, 0, 128, 205, 0,
		{
			{ -2, 244, 47, 97, 20, 208, 0 },
			{ 0, 252, 75, 193, 0, 248, 0 },
			{ 0, 254, 63, 98, 132, 224, 0 },
			{ 2786, 251, 63, 98, 52, 192, 0 }
		}
	},
	{ /* FM region 29 */
		{ 37, 0, 127 }, 0, 128, 221, 0,
		{
			{ -1, 208, 191, 99, 220, 224, 0 },
			{ 1200, 243, 92, 97, 0, 244, 0 },
			{ 3984, 212, 11, 96, 168, 196, 0 },
			{ 1, 242, 127, 98, 108, 204, 0 }
		}
	},
	{ /* FM region 30 */
		{ 37, 0, 127 }, 0, 128, 174, 0,
		{
			{ -3, 212, 207, 99, 0, 228, 0 },
			{ 1902, 241, 108, 97, 0, 248, 0 },
			{ 3805, 212, 59, 98, 0, 220, 0 },
			{ 1902, 146, 107, 98, 144, 196, 0 }
		}
	},
	{ /* FM region 31 */
		{ 41, 0, 127 }, 0, 255, 128, 0,
		{
			{ 1206, 239, 43, 69, 0, 216, 2 },
			{ 4, 254, 42, 66, 0, 244, 2 },
			{ 702, 88, 55, 66, 0, 204, 2 },
			{ -4, 71, 55, 66, 0, 240, 2 }
		}
	},
	{ /* FM region 32 */
		{ 37, 0, 127 }, 0, 255, 85, 0,
		{
			{ 500, 239, 95, 82, 0, 184, 3 },
			{ 0, 248, 73, 132, 0, 252, 2 },
			{ 2786, 203, 59, 130, 0, 176, 2 },
			{ 0, 216, 42, 100, 0, 208, 2 }
		}
	},
	{ /* FM region 33 */
		{ 37, 0, 127 }, 0, 128, 73, 0,
		{
			{ 1, 229, 54, 131, 160, 208, 0 },
			{ -1, 244, 62, 97, 0, 248, 0 },
			{ 3986, 227, 127, 69, 140, 184, 0 },
			{ 1201, 249, 92, 114, 0, 204, 0 }
		}
	},
	{ /* FM region 34 */
		{ 37, 0, 127 }, 0, 128, 73, 0,
		{
			{ 1, 225, 54, 100, 200, 212, 0 },
			{ -1, 244, 94, 97, 0, 248, 0 },
			{ 3986, 249, 127, 88, 112, 188, 0 },
			{ 1201, 249, 92, 85, 52, 208, 0 }
		}
	},
	{ /* FM region 35 */
		{ 37, 0, 127 }, 0, 128, 188, 0,
		{
			{ -3, 198, 92, 179, 28, 212, 0 },
			{ 0, 243, 90, 145, 0, 248, 0 },
			{ 1901, 215, 95, 69, 28, 196, 0 },
			{ 3, 84, 108, 196, 32, 208, 0 }
		}
	},
	{ /* FM region 36 */
		{ 37, 0, 127 }, 0, 136, 6, 0,
		{
			{ 0, 226, 99, 36, 224, 216, 0 },
			{ 1902, 248, 78, 33, 0, 252, 0 },
			{ 3369, 239, 250, 33, 0, 204, 0 },
			{ 0, 230, 253, 33, 0, 208, 0 }
		}
	},
	{ /* FM region 37 */
		{ 37, 0, 127 }, 0, 136, 195, 0,
		{
			{ 0, 245, 99, 36, 152, 208, 0 },
			{ 1200, 248, 78, 33, 0, 252, 0 },
			{ 3369, 246, 250, 33, 0, 216, 0 },
			{ 0, 246, 61, 33, 0, 180, 0 }
		}
	},
	{ /* FM region 38 */
		{ 34, 0, 127 }, 0, 133, 221, 0,
		{
			{ 1, 244, 67, 35, 80, 220, 0 },
			{ 3, 246, 94, 33, 0, 244, 0 },
			{ -1, 245, 70, 35, 80, 236, 2 },
			{ -3, 246, 63, 33, 0, 236, 2 }
		}
	},
	{ /* FM region 39 */
		{ 34, 0, 127 }, 0, 133, 220, 0,
		{
			{ 0, 114, 51, 34, 132, 208, 0 },
			{ 3, 214, 62, 33, 0, 248, 0 },
			{ 0, 85, 54, 34, 44, 224, 2 },
			{ -3, 214, 63, 33, 0, 236, 2 }
		}
	},
	{ /* FM region 40 */
		{ 37, 0, 127 }, 48, 142, 187, 0,
		{
			{ -1, 33, 22, 33, 200, 208, 0 },
			{ 0, 81, 105, 33, 220, 240, 0 },
			{ 2786, 245, 19, 50, 208, 192, 0 },
			{ 1, 245, 21, 82, 200, 220, 0 }
		}
	},
	{ /* FM region 41 */
		{ 37, 0, 127 }, 48, 126, 103, 0,
		{
			{ -1, 193, 22, 33, 228, 212, 0 },
			{ 0, 81, 105, 33, 220, 244, 0 },
			{ 0, 245, 19, 50, 216, 228, 0 },
			{ 1200, 245, 19, 82, 200, 188, 0 }
		}
	},
	{ /* FM region 42 */
		{ 37, 0, 127 }, 16, 126, 202, 0,
		{
			{ -1, 49, 24, 41, 200, 212, 0 },
			{ 0, 81, 71, 49, 220, 244, 0 },
			{ 3371, 243, 19, 36, 232, 192, 0 },
			{ 1, 242, 24, 36, 220, 212, 0 }
		}
	},
	{ /* FM region 43 */
		{ 37, 0, 127 }, 16, 124, 205, 0,
		{
			{ 0, 129, 24, 49, 208, 200, 0 },
			{ 0, 67, 102, 81, 224, 244, 0 },
			{ 3804, 246, 23, 36, 160, 196, 0 },
			{ 1200, 244, 24, 35, 208, 200, 0 }
		}
	},
	{ /* FM region 44 */
		{ 37, 0, 127 }, 48, 144, 208, 0,
		{
			{ -3, 209, 22, 33, 200, 204, 2 },
			{ 0, 81, 89, 33, 220, 240, 2 },
			{ -5000, 208, 6, 33, 244, 188, 3 },
			{ 3, 97, 89, 33, 224, 200, 0 }
		}
	},
	{ /* FM region 45 */
		{ 37, 0, 127 }, 0, 255, 186, 0,
		{
			{ 500, 223, 95, 0, 0, 192, 3 },
			{ 0, 247, 89, 100, 0, 248, 2 },
			{ 3369, 255, 59, 168, 0, 212, 2 },
			{ 0, 216, 42, 97, 0, 212, 2 }
		}
	},
	{ /* FM region 46 */
		{ 34, 0, 127 }, 0, 255, 221, 0,
		{
			{ 1206, 235, 70, 69, 0, 216, 2 },
			{ 4, 248, 84, 66, 0, 244, 2 },
			{ 1902, 247, 52, 137, 80, 216, 2 },
			{ -4, 245, 84, 131, 0, 240, 2 }
		}
	},
	{ /* FM region 47 */
		{ 37, 0, 127 }, 0, 255, 105, 0,
		{
			{ 387, 231, 115, 34, 4, 216, 2 },
			{ 0, 248, 37, 65, 0, 252, 2 },
			{ 3308, 248, 117, 34, 8, 200, 2 },
			{ 1900, 213, 82, 50, 0, 192, 2 }
		}
	},
	{ /* FM region 48 */
		{ 34, 0, 127 }, 32, 160, 221, 0,
		{
			{ -7, 209, 22, 33, 200, 204, 2 },
			{ -7, 81, 73, 33, 220, 244, 0 },
			{ 7, 209, 22, 33, 200, 208, 0 },
			{ 7, 97, 73, 33, 224, 244, 2 }
		}
	},
	{ /* FM region 49 */
		{ 34, 0, 127 }, 64, 128, 189, 0,
		{
			{ -2, 209, 54, 32, 224, 216, 2 },
			{ -7726, 97, 105, 33, 220, 240, 3 },
			{ 1902, 209, 54, 34, 216, 208, 0 },
			{ 2, 81, 105, 33, 224, 236, 0 }
		}
	},
	{ /* FM region 50 */
		{ 34, 0, 127 }, 80, 144, 206, 0,
		{
			{ -3, 179, 38, 33, 160, 220, 2 },
			{ -7726, 81, 69, 34, 220, 244, 3 },
			{ 3, 193, 38, 33, 240, 212, 0 },
			{ -8000, 65, 69, 34, 224, 236, 3 }
		}
	},
	{ /* FM region 51 */
		{ 37, 0, 127 }, 96, 128, 204, 0,
		{
			{ -3, 97, 38, 33, 180, 216, 0 },
			{ 0, 81, 69, 34, 220, 240, 2 },
			{ 3369, 145, 38, 33, 240, 196, 2 },
			{ -13190, 65, 69, 34, 240, 200, 3 }
		}
	},
	{ /* FM region 52 */
		{ 34, 0, 127 }, 64, 128, 108, 0,
		{
			{ -3, 193, 37, 35, 236, 208, 0 },
			{ 2394, 97, 90, 36, 224, 232, 2 },
			{ 3, 65, 40, 35, 236, 204, 2 },
			{ 1203, 97, 89, 33, 224, 240, 0 }
		}
	},
	{ /* FM region 53 */
		{ 37, 0, 127 }, 128, 128, 122, 0,
		{
			{ 0, 193, 21, 34, 236, 188, 0 },
			{ 3, 97, 74, 36, 224, 248, 2 },
			{ 1906, 251, 24, 32, 96, 192, 3 },
			{ 1200, 97, 73, 32, 224, 184, 0 }
		}
	},
	{ /* FM region 54 */
		{ 34, 0, 127 }, 64, 133, 135, 0,
		{
			{ 0, 194, 25, 35, 120, 200, 2 },
			{ 0, 97, 75, 36, 224, 240, 0 },
			{ 2906, 254, 28, 48, 0, 184, 3 },
			{ 0, 216, 75, 80, 204, 240, 2 }
		}
	},
	{ /* FM region 55 */
		{ 41, 0, 127 }, 208, 64, 255, 0,
		{
			{ 475, 249, 16, 32, 252, 240, 2 },
			{ 702, 248, 71, 32, 0, 244, 2 },
			{ 1136, 232, 27, 32, 216, 248, 0 },
			{ 0, 249, 23, 48, 0, 248, 2 }
		}
	},
	{ /* FM region 56 */
		{ 37, 0, 127 }, 0, 132, 233, 0,
		{
			{ 0, 195, 95, 64, 240, 208, 0 },
			{ 0, 225, 94, 64, 248, 240, 0 },
			{ 0, 254, 127, 0, 4, 196, 4 },
			{ 1902, 228, 95, 1, 248, 200, 0 }
		}
	},
	{ /* FM region 57 */
		{ 37, 0, 127 }, 16, 140, 238, 0,
		{
			{ 0, 163, 90, 67, 228, 208, 0 },
			{ 0, 209, 77, 65, 248, 240, 0 },
			{ 1969, 173, 58, 65, 0, 176, 0 },
			{ 0, 210, 61, 52, 204, 220, 0 }
		}
	},
	{ /* FM region 58 */
		{ 37, 0, 127 }, 16, 140, 222, 0,
		{
			{ 0, 119, 74, 67, 160, 212, 0 },
			{ 0, 146, 61, 65, 248, 244, 0 },
			{ 1900, 137, 58, 65, 100, 196, 0 },
			{ 0, 119, 61, 52, 120, 200, 0 }
		}
	},
	{ /* FM region 59 */
		{ 37, 0, 127 }, 16, 135, 219, 0,
		{
			{ 0, 176, 79, 69, 240, 216, 0 },
			{ 0, 193, 79, 64, 248, 236, 0 },
			{ 0, 178, 123, 54, 92, 228, 0 },
			{ 3369, 212, 95, 38, 144, 212, 0 }
		}
	},
	{ /* FM region 60 */
		{ 34, 0, 127 }, 0, 119, 203, 0,
		{
			{ 2, 65, 77, 66, 228, 204, 0 },
			{ 2, 161, 74, 64, 240, 240, 0 },
			{ -2, 85, 60, 66, 180, 216, 2 },
			{ -2, 162, 74, 64, 220, 240, 2 }
		}
	},
	{ /* FM region 61 */
		{ 34, 0, 127 }, 16, 154, 237, 0,
		{
			{ 0, 179, 42, 64, 216, 208, 0 },
			{ 0, 209, 61, 64, 248, 244, 0 },
			{ -1200, 226, 55, 65, 244, 220, 2 },
			{ 1902, 162, 62, 52, 204, 236, 2 }
		}
	},
	{ /* FM region 62 */
		{ 34, 0, 127 }, 48, 119, 221, 0,
		{
			{ 2, 119, 79, 64, 208, 212, 0 },
			{ 2, 209, 110, 64, 248, 236, 0 },
			{ -2, 84, 79, 64, 136, 212, 2 },
			{ -2, 209, 110, 64, 240, 240, 2 }
		}
	},
	{ /* FM region 63 */
		{ 34, 0, 127 }, 32, 135, 221, 0,
		{
			{ 2, 165, 79, 64, 152, 216, 0 },
			{ 2, 225, 110, 64, 248, 236, 0 },
			{ -2, 132, 79, 64, 72, 224, 2 },
			{ -2, 241, 110, 64, 252, 236, 2 }
		}
	},
	{ /* FM region 64 */
		{ 37, 0, 127 }, 17, 127, 190, 0,
		{
			{ 0, 209, 60, 67, 244, 208, 0 },
			{ 1200, 145, 94, 65, 248, 244, 2 },
			{ 3369, 197, 47, 4, 128, 192, 0 },
			{ 1902, 167, 94, 6, 200, 200, 0 }
		}
	},
	{ /* FM region 65 */
		{ 37, 0, 127 }, 17, 143, 190, 0,
		{
			{ 0, 209, 60, 67, 244, 216, 0 },
			{ 1902, 145, 62, 65, 248, 240, 2 },
			{ 3369, 197, 47, 4, 128, 196, 0 },
			{ 2400, 167, 94, 6, 200, 212, 2 }
		}
	},
	{ /* FM region 66 */
		{ 37, 0, 127 }, 17, 143, 190, 0,
		{
			{ 0, 209, 60, 67, 244, 208, 0 },
			{ 1902, 145, 62, 65, 248, 240, 2 },
			{ 3369, 197, 47, 4, 128, 192, 0 },
			{ 1902, 167, 94, 6, 200, 216, 2 }
		}
	},
	{ /* FM region 67 */
		{ 37, 0, 127 }, 17, 125, 190, 0,
		{
			{ 0, 114, 109, 67, 244, 224, 0 },
			{ 1902, 166, 93, 97, 200, 240, 0 },
			{ 2786, 165, 95, 52, 160, 200, 0 },
			{ 2400, 173, 78, 54, 240, 212, 2 }
		}
	},
	{ /* FM region 68 */
		{ 34, 0, 127 }, 16, 140, 205, 0,
		{
			{ 0, 211, 55, 66, 244, 208, 0 },
			{ 1902, 193, 93, 65, 248, 240, 0 },
			{ 0, 204, 47, 4, 244, 216, 0 },
			{ 3600, 183, 95, 6, 160, 232, 0 }
		}
	},
	{ /* FM region 69 */
		{ 34, 0, 127 }, 16, 126, 222, 0,
		{
			{ 0, 243, 36, 66, 172, 200, 0 },
			{ 1200, 193, 110, 67, 248, 244, 0 },
			{ 0, 215, 33, 2, 232, 212, 0 },
			{ 3369, 178, 63, 6, 184, 240, 0 }
		}
	},
	{ /* FM region 70 */
		{ 34, 0, 127 }, 16, 140, 221, 0,
		{
			{ 1200, 213, 61, 66, 136, 200, 0 },
			{ 1902, 193, 93, 68, 248, 240, 0 },
			{ 0, 197, 47, 2, 228, 216, 0 },
			{ 3369, 183, 95, 2, 160, 236, 0 }
		}
	},
	{ /* FM region 71 */
		{ 34, 0, 127 }, 16, 124, 201, 0,
		{
			{ 1200, 195, 55, 68, 240, 208, 0 },
			{ 0, 209, 76, 65, 248, 236, 0 },
			{ 1902, 147, 47, 19, 208, 212, 0 },
			{ 0, 183, 79, 22, 156, 228, 0 }
		}
	},
	{ /* FM region 72 */
		{ 37, 0, 127 }, 32, 110, 234, 0,
		{
			{ 500, 237, 60, 68, 0, 192, 1 },
			{ 1, 161, 93, 65, 248, 240, 2 },
			{ 3365, 154, 47, 16, 48, 180, 6 },
			{ 1200, 165, 92, 52, 160, 212, 2 }
		}
	},
	{ /* FM region 73 */
		{ 37, 0, 127 }, 32, 142, 200, 0,
		{
			{ 0, 193, 60, 68, 248, 200, 0 },
			{ 1, 129, 61, 65, 248, 240, 2 },
			{ 3365, 154, 47, 16, 68, 184, 6 },
			{ 1200, 169, 92, 52, 160, 204, 2 }
		}
	},
	{ /* FM region 74 */
		{ 35, 0, 127 }, 32, 135, 36, 0,
		{
			{ 1199, 165, 79, 66, 152, 192, 2 },
			{ -3, 145, 110, 64, 248, 240, 2 },
			{ 0, 199, 79, 66, 44, 236, 2 },
			{ 2986, 136, 110, 67, 100, 196, 2 }
		}
	},
	{ /* FM region 75 */
		{ 37, 0, 127 }, 32, 190, 71, 0,
		{
			{ 868, 202, 140, 16, 24, 188, 2 },
			{ 0, 176, 77, 65, 248, 240, 2 },
			{ 3750, 169, 127, 16, 36, 228, 6 },
			{ 2400, 195, 60, 17, 232, 172, 2 }
		}
	},
	{ /* FM region 76 */
		{ 37, 0, 127 }, 224, 16, 123, 0,
		{
			{ 275, 202, 14, 2, 44, 196, 2 },
			{ 0, 165, 89, 65, 56, 244, 2 },
			{ 0, 255, 12, 2, 64, 216, 6 },
			{ 963, 169, 14, 4, 40, 196, 2 }
		}
	},
	{ /* FM region 77 */
		{ 50, 0, 127 }, 192, 128, 100, 0,
		{
			{ 1500, 202, 79, 68, 76, 204, 2 },
			{ -2, 97, 26, 64, 248, 232, 2 },
			{ 1588, 202, 223, 69, 4, 220, 0 },
			{ 3, 188, 121, 67, 48, 252, 2 }
		}
	},
	{ /* FM region 78 */
		{ 34, 0, 127 }, 112, 140, 205, 0,
		{
			{ 0, 68, 47, 66, 60, 176, 2 },
			{ -2, 113, 94, 64, 248, 236, 0 },
			{ 5000, 121, 47, 64, 32, 168, 7 },
			{ 3, 136, 94, 64, 0, 236, 0 }
		}
	},
	{ /* FM region 79 */
		{ 35, 0, 127 }, 32, 135, 33, 0,
		{
			{ 1199, 197, 79, 66, 152, 184, 2 },
			{ 0, 161, 110, 64, 248, 240, 2 },
			{ 0, 199, 79, 66, 44, 236, 2 },
			{ 2400, 255, 110, 65, 36, 208, 6 }
		}
	},
	{ /* FM region 80 */
		{ 34, 0, 127 }, 0, 192, 170, 0,
		{
			{ 1199, 192, 77, 33, 200, 212, 0 },
			{ 0, 209, 107, 33, 232, 240, 0 },
			{ 1201, 80, 77, 33, 200, 212, 0 },
			{ 0, 241, 107, 33, 232, 240, 0 }
		}
	},
	{ /* FM region 81 */
		{ 34, 0, 127 }, 0, 192, 221, 0,
		{
			{ -1, 192, 45, 33, 200, 212, 0 },
			{ -1, 209, 107, 33, 232, 244, 0 },
			{ 1, 80, 45, 33, 200, 212, 0 },
			{ 1, 241, 107, 33, 232, 244, 0 }
		}
	},
	{ /* FM region 82 */
		{ 37, 0, 127 }, 0, 112, 255, 0,
		{
			{ 4750, 221, 45, 34, 48, 172, 4 },
			{ -10000, 161, 107, 33, 200, 244, 3 },
			{ 2204, 137, 45, 37, 64, 184, 0 },
			{ -2, 211, 107, 33, 160, 208, 0 }
		}
	},
	{ /* FM region 83 */
		{ 37, 0, 127 }, 16, 127, 238, 0,
		{
			{ 2, 248, 45, 32, 204, 208, 0 },
			{ -9500, 241, 107, 33, 200, 240, 3 },
			{ 3369, 186, 45, 38, 24, 208, 0 },
			{ -2, 211, 107, 32, 220, 212, 0 }
		}
	},
	{ /* FM region 84 */
		{ 37, 0, 127 }, 0, 128, 221, 0,
		{
			{ -1, 192, 191, 99, 220, 216, 0 },
			{ 1200, 243, 92, 97, 0, 244, 0 },
			{ 3984, 200, 11, 96, 168, 192, 0 },
			{ 1, 194, 127, 98, 108, 200, 0 }
		}
	},
	{ /* FM region 85 */
		{ 34, 0, 127 }, 128, 128, 111, 0,
		{
			{ 1, 194, 25, 35, 120, 204, 2 },
			{ -9750, 193, 107, 36, 224, 244, 3 },
			{ 3906, 255, 28, 50, 12, 188, 3 },
			{ -1, 216, 107, 80, 204, 240, 2 }
		}
	},
	{ /* FM region 86 */
		{ 34, 0, 127 }, 32, 134, 222, 0,
		{
			{ 0, 195, 52, 33, 200, 208, 0 },
			{ 0, 177, 90, 33, 232, 240, 2 },
			{ 702, 195, 52, 33, 200, 208, 2 },
			{ 702, 177, 90, 34, 232, 240, 2 }
		}
	},
	{ /* FM region 87 */
		{ 34, 0, 127 }, 32, 134, 205, 0,
		{
			{ 0, 198, 75, 36, 120, 220, 2 },
			{ 0, 225, 78, 52, 40, 244, 2 },
			{ 0, 246, 47, 32, 220, 208, 2 },
			{ 1902, 241, 124, 32, 240, 236, 2 }
		}
	},
	{ /* FM region 88 */
		{ 35, 0, 127 }, 32, 120, 14, 0,
		{
			{ 3600, 244, 67, 34, 88, 208, 0 },
			{ 3, 194, 84, 33, 84, 240, 2 },
			{ -3, 194, 84, 33, 172, 236, 2 },
			{ 902, 254, 114, 34, 0, 224, 3 }
		}
	},
	{ /* FM region 89 */
		{ 34, 0, 127 }, 64, 169, 170, 0,
		{
			{ -3, 83, 69, 34, 184, 212, 0 },
			{ -7500, 50, 69, 33, 176, 244, 3 },
			{ 3, 81, 69, 34, 212, 212, 2 },
			{ -8500, 66, 69, 33, 176, 244, 3 }
		}
	},
	{ /* FM region 90 */
		{ 34, 0, 127 }, 64, 120, 221, 0,
		{
			{ -2, 82, 69, 34, 244, 216, 0 },
			{ 0, 145, 102, 33, 228, 240, 0 },
			{ 2, 81, 69, 34, 244, 208, 2 },
			{ 0, 145, 102, 33, 224, 240, 2 }
		}
	},
	{ /* FM region 91 */
		{ 35, 0, 127 }, 32, 138, 14, 0,
		{
			{ 2400, 148, 67, 34, 176, 200, 0 },
			{ 3, 194, 85, 33, 220, 236, 2 },
			{ -3, 194, 69, 33, 220, 236, 2 },
			{ 1905, 254, 114, 34, 48, 224, 2 }
		}
	},
	{ /* FM region 92 */
		{ 34, 0, 127 }, 82, 67, 71, 0,
		{
			{ 2982, 228, 22, 146, 88, 192, 3 },
			{ 3, 102, 84, 146, 196, 240, 2 },
			{ 3358, 50, 149, 116, 144, 208, 2 },
			{ -3, 85, 84, 146, 120, 240, 0 }
		}
	},
	{ /* FM region 93 */
		{ 37, 0, 127 }, 48, 126, 219, 0,
		{
			{ -3, 49, 19, 33, 120, 200, 0 },
			{ 0, 81, 70, 33, 220, 240, 0 },
			{ 3804, 242, 18, 50, 200, 200, 0 },
			{ 1203, 82, 19, 82, 200, 176, 0 }
		}
	},
	{ /* FM region 94 */
		{ 35, 0, 127 }, 32, 138, 13, 0,
		{
			{ 2786, 116, 67, 34, 204, 184, 0 },
			{ 1902, 114, 69, 33, 192, 232, 2 },
			{ -3, 178, 69, 33, 188, 232, 2 },
			{ 3804, 254, 82, 34, 164, 228, 2 }
		}
	},
	{ /* FM region 95 */
		{ 34, 0, 127 }, 48, 135, 238, 0,
		{
			{ -2, 34, 85, 34, 184, 224, 0 },
			{ 1, 113, 70, 33, 228, 236, 0 },
			{ 2, 19, 85, 34, 156, 224, 2 },
			{ -1, 129, 70, 33, 224, 236, 2 }
		}
	},
	{ /* FM region 96 */
		{ 50, 0, 127 }, 240, 112, 221, 0,
		{
			{ 3369, 213, 69, 32, 0, 204, 0 },
			{ 0, 193, 70, 33, 112, 232, 2 },
			{ 0, 145, 69, 34, 244, 208, 2 },
			{ -9000, 145, 70, 33, 224, 236, 3 }
		}
	},
	{ /* FM region 97 */
		{ 34, 0, 127 }, 96, 122, 168, 0,
		{
			{ -1, 99, 51, 33, 200, 208, 0 },
			{ -8500, 81, 83, 33, 232, 240, 3 },
			{ 702, 99, 52, 33, 200, 208, 2 },
			{ -9500, 65, 83, 34, 224, 240, 3 }
		}
	},
	{ /* FM region 98 */
		{ 34, 0, 127 }, 0, 67, 0, 0,
		{
			{ 1500, 217, 55, 151, 20, 224, 2 },
			{ 3, 231, 70, 146, 88, 220, 2 },
			{ 2369, 115, 148, 151, 32, 196, 2 },
			{ -3, 118, 36, 146, 64, 244, 2 }
		}
	},
	{ /* FM region 99 */
		{ 34, 0, 127 }, 64, 169, 204, 0,
		{
			{ -3, 228, 69, 34, 148, 220, 0 },
			{ -7448, 243, 69, 33, 200, 240, 3 },
			{ 3, 81, 68, 34, 212, 212, 2 },
			{ -8526, 65, 68, 33, 196, 240, 3 }
		}
	},
	{ /* FM region 100 */
		{ 34, 0, 127 }, 64, 119, 187, 0,
		{
			{ 2786, 228, 22, 146, 176, 192, 0 },
			{ 3, 102, 68, 146, 196, 236, 2 },
			{ 3369, 178, 149, 116, 176, 208, 2 },
			{ -3, 231, 68, 146, 120, 240, 0 }
		}
	},
	{ /* FM region 101 */
		{ 34, 0, 127 }, 240, 144, 239, 0,
		{
			{ -2, 49, 69, 34, 236, 208, 2 },
			{ -9000, 113, 102, 33, 228, 236, 3 },
			{ 2400, 149, 69, 34, 12, 216, 1 },
			{ 0, 145, 102, 33, 224, 236, 2 }
		}
	},
	{ /* FM region 102 */
		{ 50, 0, 127 }, 241, 176, 6, 0,
		{
			{ 1200, 247, 49, 64, 252, 204, 0 },
			{ 3804, 246, 101, 32, 0, 232, 2 },
			{ 1902, 247, 32, 32, 112, 188, 2 },
			{ 0, 228, 84, 32, 0, 240, 2 }
		}
	},
	{ /* FM region 103 */
		{ 37, 0, 127 }, 64, 101, 221, 0,
		{
			{ 1, 194, 68, 97, 196, 200, 2 },
			{ -10001, 247, 100, 114, 176, 240, 3 },
			{ 3370, 213, 33, 70, 52, 200, 2 },
			{ -1, 178, 68, 49, 208, 212, 0 }
		}
	},
	{ /* FM region 104 */
		{ 34, 0, 127 }, 0, 255, 203, 0,
		{
			{ -3, 245, 82, 99, 200, 232, 2 },
			{ 2787, 244, 84, 96, 0, 236, 2 },
			{ 1198, 133, 81, 100, 196, 220, 2 },
			{ 1902, 147, 67, 80, 0, 232, 2 }
		}
	},
	{ /* FM region 105 */
		{ 37, 0, 127 }, 0, 255, 140, 0,
		{
			{ 500, 255, 137, 179, 0, 200, 3 },
			{ 1902, 248, 90, 160, 0, 244, 2 },
			{ 3804, 245, 57, 35, 164, 204, 2 },
			{ 0, 245, 38, 51, 196, 208, 2 }
		}
	},
	{ /* FM region 106 */
		{ 37, 0, 127 }, 0, 255, 72, 0,
		{
			{ 1000, 238, 57, 65, 0, 188, 3 },
			{ 1902, 247, 103, 112, 0, 244, 2 },
			{ 2786, 250, 36, 81, 68, 212, 2 },
			{ 0, 249, 50, 49, 172, 204, 2 }
		}
	},
	{ /* FM region 107 */
		{ 37, 0, 127 }, 16, 119, 72, 0,
		{
			{ 1500, 255, 89, 65, 0, 196, 3 },
			{ 2790, 246, 39, 112, 0, 240, 0 },
			{ 1905, 246, 36, 81, 168, 208, 0 },
			{ 0, 249, 114, 49, 172, 212, 0 }
		}
	},
	{ /* FM region 108 */
		{ 37, 0, 127 }, 0, 255, 237, 0,
		{
			{ 1902, 254, 89, 65, 0, 212, 2 },
			{ 0, 248, 87, 112, 0, 240, 2 },
			{ 3369, 231, 62, 81, 0, 208, 2 },
			{ 3, 245, 118, 49, 96, 196, 2 }
		}
	},
	{ /* FM region 109 */
		{ 34, 0, 127 }, 16, 188, 205, 0,
		{
			{ -2, 179, 47, 50, 244, 224, 2 },
			{ 1900, 145, 94, 49, 248, 232, 2 },
			{ 3, 210, 46, 2, 244, 208, 2 },
			{ 2789, 133, 93, 4, 180, 244, 2 }
		}
	},
	{ /* FM region 110 */
		{ 37, 0, 127 }, 48, 135, 220, 0,
		{
			{ 1901, 162, 25, 35, 144, 208, 0 },
			{ 0, 113, 105, 65, 220, 240, 0 },
			{ 3369, 233, 88, 51, 120, 212, 0 },
			{ 0, 229, 24, 84, 200, 208, 0 }
		}
	},
	{ /* FM region 111 */
		{ 34, 0, 127 }, 112, 32, 190, 0,
		{
			{ 0, 53, 79, 66, 152, 212, 2 },
			{ 1200, 53, 75, 64, 136, 244, 2 },
			{ 500, 149, 60, 66, 16, 208, 2 },
			{ 1902, 200, 78, 64, 0, 248, 0 }
		}
	},
	{ /* FM region 112 */
		{ 37, 0, 127 }, 0, 144, 130, 0,
		{
			{ 2514, 255, 68, 53, 0, 204, 2 },
			{ 2400, 247, 133, 48, 0, 240, 2 },
			{ 4151, 243, 67, 50, 0, 212, 2 },
			{ 3369, 243, 66, 56, 0, 204, 2 }
		}
	},
	{ /* FM region 113 */
		{ 37, 0, 127 }, 0, 255, 0, 0,
		{
			{ 514, 253, 79, 51, 0, 196, 3 },
			{ 1905, 252, 89, 51, 0, 244, 2 },
			{ 4349, 245, 35, 51, 0, 208, 2 },
			{ 1205, 247, 34, 51, 0, 208, 2 }
		}
	},
	{ /* FM region 114 */
		{ 37, 0, 127 }, 0, 255, 0, 0,
		{
			{ 514, 221, 69, 35, 0, 204, 3 },
			{ 0, 250, 86, 115, 0, 252, 2 },
			{ 1884, 244, 116, 51, 0, 200, 2 },
			{ 1208, 210, 35, 51, 0, 208, 2 }
		}
	},
	{ /* FM region 115 */
		{ 37, 0, 127 }, 0, 255, 16, 0,
		{
			{ 514, 222, 85, 163, 0, 192, 3 },
			{ 0, 254, 108, 163, 0, 252, 2 },
			{ 3800, 255, 143, 160, 0, 176, 2 },
			{ 1200, 250, 105, 163, 0, 212, 2 }
		}
	},
	{ /* FM region 116 */
		{ 37, 0, 127 }, 0, 255, 16, 0,
		{
			{ 1514, 249, 101, 163, 0, 204, 3 },
			{ -1200, 249, 87, 160, 0, 252, 2 },
			{ 0, 235, 143, 160, 0, 204, 2 },
			{ 1200, 234, 73, 163, 0, 204, 2 }
		}
	},
	{ /* FM region 117 */
		{ 37, 0, 127 }, 0, 255, 16, 0,
		{
			{ 500, 239, 101, 160, 0, 204, 3 },
			{ -1195, 248, 104, 160, 0, 252, 2 },
			{ 1898, 252, 72, 163, 0, 216, 2 },
			{ 1239, 248, 87, 163, 0, 196, 2 }
		}
	},
	{ /* FM region 118 */
		{ 37, 0, 127 }, 0, 255, 255, 0,
		{
			{ 500, 255, 98, 160, 0, 196, 3 },
			{ -1, 249, 105, 160, 0, 252, 2 },
			{ 1907, 250, 71, 160, 0, 252, 2 },
			{ 1182, 249, 87, 161, 0, 192, 2 }
		}
	},
	{ /* FM region 119 */
		{ 37, 0, 127 }, 0, 0, 100, 0,
		{
			{ 600, 32, 15, 0, 252, 224, 6 },
			{ 0, 47, 111, 65, 0, 244, 2 },
			{ 1826, 16, 47, 0, 252, 216, 2 },
			{ 3551, 240, 47, 0, 252, 212, 2 }
		}
	},
	{ /* FM region 120 */
		{ 52, 0, 127 }, 240, 128, 235, 0,
		{
			{ 1228, 161, 47, 17, 196, 200, 3 },
			{ 3000, 123, 75, 17, 0, 240, 2 },
			{ 7022, 72, 43, 17, 0, 216, 0 },
			{ 4000, 150, 79, 17, 48, 196, 3 }
		}
	},
	{ /* FM region 121 */
		{ 37, 0, 127 }, 224, 16, 86, 0,
		{
			{ 275, 251, 6, 0, 36, 200, 2 },
			{ 0, 101, 104, 65, 56, 240, 2 },
			{ 0, 240, 6, 0, 252, 208, 6 },
			{ 1000, 195, 8, 0, 248, 200, 2 }
		}
	},
	{ /* FM region 122 */
		{ 34, 0, 127 }, 0, 0, 185, 0,
		{
			{ 600, 35, 66, 17, 72, 224, 4 },
			{ -13000, 81, 67, 17, 228, 244, 2 },
			{ 702, 97, 38, 17, 212, 196, 6 },
			{ -14000, 81, 65, 17, 224, 244, 3 }
		}
	},
	{ /* FM region 123 */
		{ 50, 0, 127 }, 240, 112, 237, 0,
		{
			{ -6528, 153, 127, 16, 0, 252, 3 },
			{ 1200, 105, 109, 16, 0, 216, 2 },
			{ -6022, 179, 139, 17, 0, 248, 3 },
			{ 2000, 104, 79, 17, 0, 240, 0 }
		}
	},
	{ /* FM region 124 */
		{ 50, 0, 127 }, 240, 240, 16, 0,
		{
			{ 1914, 240, 64, 160, 240, 208, 2 },
			{ 1200, 240, 73, 163, 240, 244, 0 },
			{ 1900, 240, 64, 160, 240, 148, 2 },
			{ 4151, 240, 73, 163, 240, 244, 0 }
		}
	},
	{ /* FM region 125 */
		{ 34, 0, 127 }, 240, 56, 235, 0,
		{
			{ -5522, 97, 32, 17, 196, 240, 3 },
			{ 0, 84, 75, 17, 180, 248, 3 },
			{ 702, 65, 38, 17, 224, 212, 6 },
			{ -4000, 161, 73, 17, 224, 252, 1 }
		}
	},
	{ /* FM region 126 */
		{ 53, 0, 127 }, 240, 248, 37, 0,
		{
			{ 1050, 243, 0, 0, 252, 224, 7 },
			{ 2000, 49, 68, 0, 224, 236, 3 },
			{ 350, 240, 0, 0, 252, 216, 1 },
			{ 700, 240, 0, 0, 252, 212, 3 }
		}
	},
	{ /* FM region 127 */
		{ 53, 0, 127 }, 240, 248, 37, 0,
		{
			{ 1050, 245, 85, 0, 0, 244, 7 },
			{ -5000, 247, 71, 0, 0, 252, 3 },
			{ 350, 240, 0, 0, 0, 164, 0 },
			{ 700, 32, 0, 0, 0, 252, 2 }
		}
	}}; /* end FM Regions */

/*----------------------------------------------------------------------------
 * Programs
 *----------------------------------------------------------------------------
*/
static const S_PROGRAM eas_programs[] = 
{
	{ 7864320, 0 } /* program 0 */
}; /* end Programs */

/*----------------------------------------------------------------------------
 * Banks
 *----------------------------------------------------------------------------
*/
static const S_BANK eas_banks[] =
{
	{ /* bank 0 */
		30976,
		{
			32768, 32769, 32770, 32771, 32772, 32773, 32774, 32775,
			32776, 32777, 32778, 32779, 32780, 32781, 32782, 32783,
			32784, 32785, 32786, 32787, 32788, 32789, 32790, 32791,
			32792, 32793, 32794, 32795, 32796, 32797, 32798, 32799,
			32800, 32801, 32802, 32803, 32804, 32805, 32806, 32807,
			32808, 32809, 32810, 32811, 32812, 32813, 32814, 32815,
			32816, 32817, 32818, 32819, 32820, 32821, 32822, 32823,
			32824, 32825, 32826, 32827, 32828, 32829, 32830, 32831,
			32832, 32833, 32834, 32835, 32836, 32837, 32838, 32839,
			32840, 32841, 32842, 32843, 32844, 32845, 32846, 32847,
			32848, 32849, 32850, 32851, 32852, 32853, 32854, 32855,
			32856, 32857, 32858, 32859, 32860, 32861, 32862, 32863,
			32864, 32865, 32866, 32867, 32868, 32869, 32870, 32871,
			32872, 32873, 32874, 32875, 32876, 32877, 32878, 32879,
			32880, 32881, 32882, 32883, 32884, 32885, 32886, 32887,
			32888, 32889, 32890, 32891, 32892, 32893, 32894, 32895
		}
	}
}; /* end Banks */

/*----------------------------------------------------------------------------
 * Samples
 *----------------------------------------------------------------------------
*/

static const EAS_SAMPLE eas_samples[] = 
{
	  13,  -24,   28,  -32,   33,  -37,   39,  -61,  119,  -76,  120,  -70,   99, -122,   89, -113,
	  91, -123,  122, -123,   77,   86, -116,    6, -118,  123,  -23,   64,  -93,   17,   24, -125,
	 124, -125,  124,  -24,  -12,   56,   87,  -54,   38,  -91,   64,   -2,  -41,  126, -127,   20,
	   8,  -48,  -62,  127, -128,   88,  -43,  -18,   86, -100,   44,  -32,  -26,   71,  -13,    6,
	  51,  -33,  -50,  106,  -59,   33,    5,  -20,   69,  -56,   54,  -48,   -6,   38,   -5,  -38,
	  35,   -1,   12,   -1,    4,   23,  -56,   19,   -7,    5,   -4,   31,  -38,    3,  -12,   -9,
	 -25,   -7,   24,  -32,   17,  -21,  -22,   24,  -20,    6,  -18,    0,  -15,    5,  -16,   15,
	   3,    2,  -10,    3,   27,  -31,   37,  -12,   32,   -5,    2,  -21,   27,  -14,   20,   -8,
	   5,   15,   -7,  -11,   20,  -37,    7,  -23,   17,  -22,   11,  -14,    8,  -44,   39,  -52,
	  26,    3,   14,  -10,   51,  -45,   29,  -19,   19,   -3,   41,  -21,   46,  -23,   10,   16,
	 -25,    3,    7,  -30,   19,   -9,   -5,   -1,    1,  -19,    1,  -24,  -23,   51,  -48,  -10,
	  17,  -34,  -38,   60,  -71,   26,  -43,   65,  -59,   70,  -26,   61,  -51,   63,  -51,   42,
	 -25,   58,  -36,   31,   10,  -14,   -9,    8,  -18,    8,    4,    8,    7,   31,  -52,   39,
	 -53,   53,  -56,   24,   11,    1,  -20,   -8,  -32,  -18,  -10,  -25,    4,    1,   37,  -37,
	  42,  -42,   53,  -57,   52,  -18,   30,   11,   20,  -52,   55,  -61,   56,  -50,   24,  -26,
	  38,  -42,   36,   -1,  -43,   58,  -46,    6,   18,  -35,   31,  -36,   28,  -55,   55,  -98,
	  52,  -41,   26,  -24,   48,  -31,   48,  -26,   30,   19,  -17,   23,   -8,   13,   15,   19,
	  -7,  -23,   41,  -36,   20,  -39,   65,  -64,   66,  -38,   -9,    7,  -14,  -10,   -3,    6,
	  15,  -19,  -40,   53,  -67,  -11,  -12,  -25,   23,  -11,  -12,   46,  -48,   39,  -20,   20,
	 -14,   31,  -54,   71,  -25,    2,   -8,   -5,   -9,    1,    7,   27,   17,  -14,   43,  -31,
	  27,   11,  -33,   20,   -2,  -33,   45,  -38,   17,   -9,  -11,  -17,  -22,  -19,   20,  -25,
	   4,   29,  -35,   14,  -17,    1,   -7,   19,    2,   16,   32,   -3,  -17,    4,    0,   -9,
	  17,    5,   -8,   52,  -32,   40,  -39,   -5,  -18,   14,  -21,   31,   10,  -17,    8,  -34,
	  -7,    1,  -44,    7,   10,   -8,   -6,  -18,  -25,   -1,  -19,   16,  -29,   62,    6,    9,
	  21,    0,  -14,    4,    5,   20,   13,   27,   -1,   18,   -5,   21,  -31,   11,    2,   -9,
	  -4,   21,  -27,    8,  -21,  -28,  -19,   14,  -12,    5,  -20,   20,  -36,    4,  -18,  -27,
	  -4,   -4,   15,    4,   48,   -7,  -11,   20,   -6,    7,   20,    1,   20,    0,   35,  -35,
	  28,  -37,    7,  -43,   21,  -22,   23,  -18,   12,  -22,  -13,  -20,  -11,    7,   23,  -10,
	  19,  -18,   17,  -41,    4,  -16,   -8,   21,   11,   -4,   10,   30,  -24,   32,  -15,   15,
	 -13,   28,   -5,   38,  -10,    0,  -22,  -13,  -12,   24,  -18,   30,   -7,    4,  -16,   27,
	 -28,   -3,   -1,   18,  -14,   31,  -24,   -3,  -13,  -19,  -36,   -2,  -31,    9,   -2,  -12,
	  17,   12,  -50,   46,  -49,   43,  -15,   13,   22,   15,  -25,   10,   -8,   -6,   14,   -2,
	  24,   15,    9,   17,  -13,    5,   14,  -15,    7,   20,    4,    4,   18,  -16,    3,  -47,
	  31,  -46,   19,  -24,    5,  -19,   -1,  -42,   14,  -44,   18,   -7,   -1,   15,    9,  -35,
	  32,  -44,   39,  -46,   23,  -16,   36,  -25,   45,  -34,   32,   -8,   10,    5,   28,    0,
	  12,   11,    3,   20,  -23,    6,   -8,   16,    7,   17,  -19,   32,  -44,    3,   -8,  -21,
	  -8,   -5,    2,  -29,    2,   -3,  -19,  -14,    3,    7,  -23,   10,    1,    3,    8,   13,
	 -44,   20,   21,  -16,   23,    3,    5,   10,  -11,   32,  -11,   13,   -7,   30,    4,   16,
	  -7,   -6,   -7,   14,  -40,    4,  -16,  -26,    3,   -1,    0,   -6,    5,  -50,   37,  -27,
	  18,  -16,  -14,    6,   -1,   -4,  -15,    8,  -12,   14,    9,  -22,   42,  -10,   23,  -11,
	  36,  -15,   13,   30,    1,   47,  -20,   33,  -14,  -12,    1,  -20,   -9,   -9,  -11,  -13,
	   7,  -37,   25,  -47,   14,  -13,    4,  -12,    9,  -32,   18,  -48,   -1,  -35,   -1,   -7,
	  35,  -20,   53,   -4,   34,   -7,   13,   19,    9,   30,    6,   45,  -22,   23,  -18,   -6,
	  -1,    3,  -30,   14,  -15,    9,  -39,   10,  -33,  -13,  -24,   10,   14,   14,  -10,    2,
	 -34,   -4,  -20,  -21,  -14,   40,  -10,   17,  -14,   28,  -17,   37,  -26,   69,  -15,   38,
	   2,   21,  -25,   37,  -61,   13,   -9,    5,  -17,   18,  -41,   22,  -57,   -1,   -9,  -13,
	  24,  -10,   38,   -5,    8,  -16,   -2,    1,   12,  -25,   -2,  -13,    2,    2,  -16,  -19,
	  32,  -30,   22,   20,   -4,   12,   11,  -17,   19,  -17,   -3,   20,  -33,   65,  -27,   32,
	 -14,    8,   -8,   13,  -19,    9,   -2,    7,   33,  -40,   18,  -18,  -18,    6,  -23,  -11,
	 -11,  -28,    4,  -11,  -15,  -14,   -8,   -5,   34,   -6,   19,    1,   -3,    9,   -1,    5,
	   5,   14,  -11,   40,   -3,   18,  -20,   16,   -7,    2,   -5,    9,  -16,    9,  -17,    0,
	 -17,    4,  -17,   -3,    3,    8,  -14,  -19,   12,  -21,   -7,    1,   -2,   -8,   16,    3,
	  -6,   35,  -23,   33,  -13,   11,   12,    3,   -7,   26,  -11,   19,  -18,   23,  -22,   39,
	 -49,   39,  -50,   11,  -38,   26,  -29,   10,   -6,  -22,   15,   -8,   15,  -37,   36,  -43,
	  39,  -43,   18,  -26,    1,   11,    4,   -2,    9,    7,    2,    7,   19,    1,    1,   -4,
	  16,   -5,   16,   -9,   -3,    4,   -4,   -1,  -17,    0,   11,   16,  -27,   12,  -15,   15,
	  -3,    0,   10,   -3,   -5,   12,  -13,   -7,  -13,  -31,   -1,   -3,  -17,   15,  -31,   25,
	 -10,   15,   -1,    2,    4,   10,    7,   32,  -13,    7,  -22,    2,  -10,   16,    1,  -15,
	  19,  -24,   16,  -18,  -12,   18,   -9,    9,   24,   -8,    8,   11,    0,  -31,   17,  -55,
	  21,  -43,   40,  -40,   29,  -54,   44,  -34,   22,   11,   16,    7,   19,   21,   -6,    2,
	  -7,  -16,   22,    0,   -1,   -4,    5,   -8,   26,  -42,    4,   -6,  -21,   35,  -16,    8,
	   0,  -22,  -13,   11,  -31,    7,  -28,    4,   17,  -12,  -18,   -2,  -23,   23,   -1,   19,
	  34,    7,    7,   35,  -19,   11,   -8,  -17,    8,    4,   16,  -16,  -13,    9,  -15,   -5,
	  -1,   -6,    7,    3,   11,    1,   -7,  -24,   21,  -31,   36,   -3,  -10,    8,    2,  -17,
	  12,  -24,    6,   -3,    9,   15,    3,   13,   -8,  -13,   -3,    6,  -19,   14,  -33,   16,
	 -17,   -5,  -31,    3,  -29,   24,   -7,   -6,   35,  -20,   -5,   34,  -20,   25,   -3,   10,
	  25,    8,   14,  -13,    0,    1,   17,  -33,   51,  -38,   45,  -32,   39,   -3,   -2,  -24,
	   3,  -18,   14,   -4,  -44,    2,  -25,  -15,   -2,  -23,    3,   -2,   -2,   20,  -14,    8,
	 -10,   -4,   21,   11,  -13,   32,   -4,    8,   19,  -16,   -2,   -2,   -2,   14,   -2,   -1,
	  27,  -26,   20,   11,  -13,   10,   -3,   -7,   12,  -13,   -3,  -30,  -16,   10,  -26,   -3,
	 -10,   -2,   -9,   15,  -17,    1,   -2,   -7,   14,   -8,   12,   -3,   -1,    2,   47,  -26,
	  22,  -19,   16,    2,   13,   -3,   21,  -10,   22,  -32,   43,  -24,   16,    0,    5,   -2,
	  12,  -44,  -12,    1,  -26,    1,  -36,    5,    2,    9,  -17,   20,  -37,   14,   -9,   -5,
	   6,   -3,  -13,   23,  -19,   25,  -33,    6,   17,   10,   19,   15,   -4,   12,    5,   -9,
	  33,  -20,   26,   -9,   11,   -2,   11,  -21,   -7,  -13,   -4,   -8,  -12,    0,  -10,   -9,
	   8,  -33,    9,  -26,    8,    6,   -8,   12,    7,   -8,    0,    7,  -16,   25,   -8,   27,
	  12,    0,    9,   -9,    4,  -17,   14,  -16,   11,   -8,   18,   -2,    4,    2,  -20,  -18,
	  22,  -16,   -5,    3,  -24,   13,  -10,  -12,  -10,    2,  -16,   33,  -15,   21,  -15,   -4,
	 -19,   29,  -22,   18,    2,   20,   12,   18,  -22,   -7,  -16,    7,  -19,   14,    1,  -17,
	  33,  -22,   38,   -8,    3,   -3,   21,  -17,   51,  -43,   15,  -22,  -23,   -6,  -12,  -14,
	  14,    9,    6,    4,  -31,    3,  -16,  -14,   22,  -22,    5,   13,  -25,   17,   -2,  -18,
	   7,    1,    5,   36,  -16,   23,    4,  -15,   29,  -20,   10,    1,   24,   17,   16,   -4,
	 -16,  -37,  -11,    1,  -33,   27,  -36,   17,  -22,    2,  -33,   16,  -29,   32,   -7,   24,
	 -12,   14,  -12,   22,  -16,   15,  -20,   19,    9,   14,   12,   -1,  -24,   13,   -6,   -1,
	  32,  -19,   24,   12,  -26,    4,  -31,  -38,   18,  -16,  -13,    3,  -14,   -1,   11,  -15,
	  15,    0,   -2,   30,   -6,   35,  -23,   10,  -35,    5,  -14,   17,  -21,   20,    4,    7,
	   8,   -5,  -15,   20,  -25,   26,    6,   -3,    3,    5,  -24,   26,  -35,    4,    0,   -6,
	  13,  -23,    8,  -25,    1,   -2,    9,    3,   17,    4,    0,   13,  -15,    3,  -21,  -16,
	   4,   -5,  -10,   11,   -2,    7,   23,  -22,   25,  -19,   18,   25,   -9,   14,  -21,   -7,
	  11,  -24,   22,  -12,   -7,    6,    9,  -33,   11,  -20,    2,   -9,    2,    3,  -13,   12,
	 -15,   23,  -21,   16,  -16,   -2,    8,   13,  -12,   18,  -10,   16,  -12,   20,  -18,   18,
	  -1,   21,  -21,   20,  -30,   -6,   10,   -2,   13,   -6,  -15,    6,    2,   -1,    1,  -19,
	   9,  -15,   -3,  -11,    0,   -5,    1,    5,    1,   -4,   -8,    1,  -16,   23,    0,  -23,
	   2,    8,   -6,   38,   -4,    2,   13,  -17,   31,   -4,   -8,   22,  -14,    0,   12,  -22,
	   7,   -7,   11,    4,   -4,  -12,   -9,  -22,    2,  -17,  -17,  -11,    7,  -17,   19,  -24,
	   9,   -8,   -6,   29,   -4,   10,    4,    4,   23,   -1,    9,   -6,  -12,   23,   16,   -6,
	  33,  -29,   12,   -7,  -10,   17,   -4,  -18,   21,    0,  -14,   -2,  -20,  -21,   10,  -28,
	   5,  -18,   -4,    0,  -11,    1,    5,  -17,    3,    9,   20,    6,    1,   -7,    2,   -7,
	   3,    9,  -22,   29,    6,   -1,   25,  -10,    6,   -1,    4,   12,   18,  -13,   28,  -11,
	   6,  -15,  -14,  -22,   -7,    5,  -14,    1,  -16,  -12,   -5,    5,   -9,    4,   -1,  -14,
	  21,  -10,   -5,    0,  -17,   -7,    2,  -10,    6,   11,    1,   37,  -17,    6,   21,  -24,
	  41,    2,   23,    0,   10,  -18,   16,  -26,   14,  -21,  -19,   18,   -9,  -14,   -1,   -9,
	 -14,   -3,   -7,  -10,    7,   -7,   19,  -11,   15,  -25,   -3,   -6,    2,    8,  -10,    4,
	  12,   -3,   11,   -2,   -2,    5,   31,   -9,   39,  -21,   14,  -23,   18,  -16,   -1,   -3,
	  -6,    0,   22,   -9,   -5,  -17,   -4,  -12,    2,   -3,   -7,   10,  -10,    7,  -20,  -19,
	 -10,    0,  -14,   32,  -15,  -18,   13,   -9,    2,   17,  -14,    6,   36,   -9,   28,    1,
	   0,   17,  -10,    5,   17,   -8,   12,   -2,    3,    2,  -22,   -6,  -14,    6,    8,  -11,
	 -14,    2,  -23,   25,  -35,    3,  -18,    1,  -14,   22,   -1,  -12,   -7,   -9,   13,   -4,
	  12,    4,   -3,   18,    0,    1,    8,  -14,   14,   -2,    1,   17,   -3,  -14,   35,  -17,
	  19,  -14,   -6,    1,   -9,   18,  -17,   -4,  -13,   -2,  -14,   10,  -10,   -6,    0,    3,
	   5,  -12,  -13,   -3,   -6,   -6,   11,  -13,   -7,   13,   -2,    6,   13,   -7,   11,   -5,
	  23,    1,   29,  -17,   23,  -10,   18,  -16,   12,  -20,   10,    7,   -9,   -5,  -21,   -9,
	   5,  -13,   -2,    0,  -15,  -11,    3,    0,  -18,    5,  -25,   -2,    3,   -2,   -3,    4,
	   8,   14,   -7,   15,    4,    8,   19,    9,   11,    7,   -3,   14,  -11,    1,   15,  -35,
	   3,    3,  -10,  -16,    0,  -15,    2,    3,  -12,   27,  -23,   32,  -15,   10,  -14,    3,
	 -27,   10,  -15,   12,  -24,    7,    2,    9,   -2,   -2,   -1,    3,    1,    1,    8,   -4,
	   0,    6,   -6,    1,    1,   -1,    8,  -11,   31,  -27,   13,    4,   -3,    5,   -1,    0,
	   2,    9,    0,   12,  -31,    4,  -27,    1,  -25,   20,  -21,  -14,   12,  -14,    0,   -5,
	 -23,   18,   -1,   15,   19,   -5,   20,   -8,   14,   -7,   16,    3,    0,    8,   10,    0,
	  -8,  -10,    3,   -8,    9,  -12,    4,   15,   -6,    2,  -12,  -29,   -3,  -16,  -11,   35,
	 -18,   -1,  -28,    7,  -12,    0,    7,   -5,   22,   10,   10,   -4,    6,  -13,   21,  -23,
	  20,    8,  -13,   11,   15,   -6,   -6,  -22,   -1,    3,   14,    7,   11,  -27,   12,  -17,
	 -12,    8,  -15,    3,   -8,   12,  -12,    5,  -30,   12,  -18,    9,   -2,    3,    4,   15,
	   1,    5,   -9,    0,   -8,   24,   -2,   21,    5,   -4,   -4,   14,  -15,    0,   -1,    3,
	  17,   -5,   13,  -19,  -10,   -4,   -6,   -4,   -7,   18,  -27,    8,    1,  -12,  -21,  -13,
	   1,   -9,   11,    1,   -3,   -1,   22,  -21,    9,    6,   -3,   20,   -2,   17,    7,  -12,
	   1,    4,    4,   -9,    9,  -20,   24,    7,   -9,   -3,   -7,   -6,   10,    7,    3,    9,
	  -2,   -3,   -4,    1,  -19,   -8,  -16,    0,  -12,    0,  -25,    4,  -22,   10,   -9,    0,
	  -3,   15,   -1,    8,   11,  -15,   10,   13,    1,   22,   -5,   15,    1,   24,    6,    0,
	  -6,    5,    5,   10,    8,   -1,  -11,  -14,    3,  -31,    2,  -22,   -4,   -8,  -15,   -2,
	 -31,  -12,    6,   -7,    5,    2,    3,   -4,   19,    3,    4,    7,    7,   -8,   31,   -6,
	  26,    1,   -2,    2,   -3,  -10,   -4,   -4,    9,    3,   12,  -16,   16,   -9,   -1,    5,
	   4,   -7,   13,  -17,    0,  -11,  -13,  -22,    1,   -9,    4,   -7,    7,  -10,    5,   -1,
	  -6,   -3,  -21,    7,  -10,   18,   -3,    1,   -7,  -11,   11,   -8,   12,   20,    3,   13,
	  16,   -1,    3,   13,   -3,   23,   16,   -3,   15,  -14,   12,   -6,   -8,  -28,    0,  -33,
	   4,  -11,  -12,  -13,  -21,  -17,  -16,   -5,  -12,   16,   -7,   15,   -6,   -5,    3,   -9,
	  21,   17,   13,   14,   11,   21,  -12,   31,  -18,    7,   12,    8,    9,    7,    1,   -3,
	  -7,  -14,   17,  -35,  -10,   -2,  -18,   -8,  -10,  -20,  -22,    2,  -10,   -3,    1,   -1,
	   4,   -5,   11,  -20,   11,   -6,   27,    7,   18,    8,   -1,    2,    3,   11,   -9,    5,
	   5,   -7,   29,   -6,   20,  -21,   23,  -15,   19,  -19,    2,  -22,   11,  -26,   -7,  -10,
	 -30,   -1,   -3,   -6,   15,  -22,   16,   -7,   -9,   -2,   -7,   -5,   11,   17,  -13,    2,
	   8,   -5,    6,   27,   -6,   12,   -6,    4,   15,    3,   14,   -3,  -12,   11,   -2,    6,
	   5,    4,   -6,  -12,    0,  -32,    2,  -22,   22,  -12,   -5,   -7,  -11,   -7,    6,   -1,
	  -3,   -3,  -16,    2,   -1,    0,    0,   -7,   -2,    1,   12,   -4,    5,   20,    1,   16,
	  -2,   14,   -1,   19,    8,   29,   -8,    7,  -14,   -2,    3,  -13,    8,  -40,   22,  -18,
	   2,  -14,   -8,  -11,   -8,   12,  -21,   -1,  -10,  -12,   -6,   -4,  -14,    6,  -19,    7,
	  14,    1,   11,   11,  -11,   25,    1,   14,   -5,   31,    0,   22,    4,    1,    3,    6,
	  -3,    4,   -2,  -20,   -7,  -26,    1,  -12,   -7,  -10,    2,   -1,   -5,   -7,   -8,  -10,
	   6,   -7,   -6,   10,  -17,    6,    3,   15,   -8,   15,   -7,   12,    1,    9,   -4,   -2,
	  10,    9,   -1,   10,   -4,    9,   -8,   17,    0,  -13,   -7,   -2,  -11,    3,   -2,  -15,
	  -4,  -11,   -5,   -9,    1,    8,  -10,    8,   -8,   -6,  -18,   21,  -19,   26,  -19,   -1,
	 -11,   10,    4,   12,  -10,   16,  -10,   17,    8,   13,   -1,   17,    1,    5,   -1,   11,
	  -8,    9,   16,  -17,    3,  -26,  -17,  -14,    6,  -17,    4,  -20,    0,   -1,   -6,   -4,
	   2,  -15,   13,   -3,   -1,    0,   -2,   -8,   11,    7,   -3,   -8,    5,   14,   -1,   28,
	 -19,   13,   -4,    8,    1,   11,    7,    6,   -8,   -2,  -13,  -10,  -22,    6,   11,   -1,
	  -1,   -5,  -13,   18,    3,  -10,    9,  -17,   -8,    9,   -9,    1,  -17,   -4,  -16,   18,
	  -6,   15,  -10,   17,    5,    0,   -5,    0,  -11,   12,   15,    4,    8,    5,   -4,    0,
	  -2,    3,  -17,   -2,   -1,   11,   -6,   -7,    2,  -33,   23,   -6,   -1,   -2,   -2,   -1,
	  -8,    3,  -29,   -2,  -34,   16,   -3,   16,    1,   10,  -12,   23,    0,   -3,   16,   12,
	  19,   23,   -1,    8,  -26,   16,  -32,   26,  -13,    2,  -11,    5,   -1,  -15,   -9,  -16,
	   7,   -6,   14,  -15,    5,  -10,   -7,   -9,   -9,    6,  -17,   13,   18,   -5,   -3,   -4,
	  -4,  -18,   28,   -6,   13,   17,   24,   -2,    9,  -14,    1,  -11,    7,   17,    1,  -15,
	  10,  -23,   -4,  -12,    5,  -20,   17,  -10,    6,    0,   -9,    4,   -8,  -15,    6,  -16,
	   7,    9,    3,    6,  -12,  -17,    0,    4,   13,   22,   -4,   10,   -8,    7,  -12,    5,
	   5,    1,   11,    2,   10,   -3,   -2,    3,  -10,   -5,   -7,   -4,  -18,   17,   -2,  -14,
	 -16,   -7,  -10,   -3,    6,   -1,   14,  -11,   15,  -18,    2,   -6,    0,   -1,    0,   20,
	 -17,    1,    6,    2,    6,   12,   -3,    7,   25,   -5,   17,  -14,    0,   -6,    0,   -2,
	  -5,   -1,  -10,    8,    2,   -9,  -19,   -7,  -17,    5,    3,   -7,    4,  -15,   -5,    9,
	 -12,   -1,   -5,    3,   -5,   26,   -2,    3,   -4,    5,    3,    7,   10,    5,    6,    6,
	  26,  -17,    0,   -1,    3,   -3,   10,   -7,   -7,   -9,   11,  -18,    0,  -16,   -6,   -5,
	   3,    7,  -14,  -14,    0,  -21,   14,   -8,   -1,  -12,    2,    1,    2,   -3,   -1,   -3,
	  18,    5,    5,    9,   12,    7,   18,    8,    5,  -25,   16,  -15,   16,   -7,    9,  -22,
	   1,   14,  -13,   -5,    2,   -6,   -8,   13,  -17,    6,  -16,    1,   -5,  -14,   -6,   -6,
	 -15,   -2,    9,   -9,  -18,   15,  -19,   12,    7,    4,    8,   14,   15,    6,   10,   -3,
	   9,   -7,   23,  -17,   21,  -20,    7,    0,   -9,    8,  -10,    1,    4,    2,    3,   -9,
	  -9,  -15,   -6,  -21,  -16,   -6,    0,  -11,   19,   -8,   -9,    5,   -6,    0,    5,   14,
	   7,    1,   12,    8,    7,   -5,   12,    8,   -4,   19,    4,   -7,    2,    3,  -12,   -8,
	  -1,    0,    5,    7,   -5,   -8,  -22,   -8,  -21,   -2,   -9,   10,  -20,   13,   -6,    8,
	 -17,   -9,   -6,    2,    5,    8,    6,   -3,   10,   -9,   -2,   15,   -6,   20,    7,   11,
	  10,   -3,   -4,   -8,   25,  -25,   18,  -12,   17,   -6,   20,  -22,   -1,  -17,  -10,    5,
	 -10,    9,  -13,   -9,   -6,   10,  -25,   -5,   -2,   -5,   13,    2,   -5,   -8,  -10,   11,
	 -27,   10,   -4,   11,    0,   33,   -4,   10,  -14,    1,   12,   -2,   27,   -8,    6,   11,
	   9,  -12,   -4,  -10,  -13,   12,    5,    1,  -10,  -14,  -15,   -8,   -7,   -9,    3,   -5,
	  10,    3,  -11,  -12,  -13,   -3,   -3,    3,    2,    9,   17,   -6,   25,   -3,   -3,   -8,
	  19,    3,   30,  -10,   12,  -22,    7,   -5,  -10,   -3,   21,   -8,   12,    6,   -5,  -13,
	 -13,   -9,   -9,   -1,  -23,   13,  -17,   15,  -22,  -11,  -18,    8,  -14,   20,    1,    4,
	  -5,    3,    3,    5,   11,    1,    2,   27,    1,   10,   -7,   -8,   -2,   -2,    7,   -1,
	  17,   -5,   24,   -7,    5,  -10,  -20,   -6,    5,   -4,   -5,   -1,  -18,   -5,  -14,   -1,
	 -20,    1,    7,   -7,   12,   -4,   -2,   -4,    2,    8,    0,    7,    1,    6,   -2,   18,
	  -5,   -7,    4,    3,   -2,   13,    4,    0,    2,   -3,    2,  -10,   -6,    1,   -6,    6,
	  -7,   -3,  -21,   -2,  -12,    5,   -1,   -9,    7,   -3,   13,    5,    5,   -8,    0,   -8,
	  19,   -5,   13,   13,   -7,    3,    0,  -10,    0,   -8,   20,   -8,   13,  -20,   -5,   -7,
	   3,    5,   -7,    2,   -5,   -4,  -14,   11,  -23,  -13,    2,   -1,   12,   13,    5,   -6,
	  23,   -9,    9,   -6,   -9,   18,  -13,   16,   -3,   -7,  -17,    3,  -13,   12,   -9,    4,
	   0,    0,   13,  -18,   -1,    3,  -13,   20,   -5,    1,  -20,   15,  -23,   18,   -4,   -8,
	   5,   -7,   16,    4,    6,   -3,    7,  -21,   19,  -17,   -7,    9,    5,    3,   -5,   -3,
	 -16,   -9,   25,   -9,   12,   -5,   10,   -5,    9,   -4,   -6,   -3,    4,   10,   -2,   11,
	 -12,   -2,  -14,    8,  -23,   -5,    0,   -8,    9,   -2,  -11,   -3,   -9,    9,    2,    2,
	   4,   -5,    7,   11,  -16,    0,   -6,    7,    6,   25,    5,    6,   -4,    3,    4,    3,
	   2,   -8,   -3,    5,   -1,  -11,   -4,   -9,   -3,  -15,   10,  -12,   -5,   11,   -4,   -7,
	   6,  -29,   -5,    6,   11,    3,    9,  -18,   13,  -14,   19,   -1,   -2,    4,    5,   12,
	   1,    5,   -8,    3,    1,   20,   -6,    2,    3,  -16,   10,  -10,  -18,  -11,   -7,   -7,
	   9,   -4,   -8,    9,  -15,   13,  -13,   -3,   -7,    3,    8,   11,   -6,  -16,    1,   -8,
	  20,    4,   15,   -5,   -3,   11,   -5,    6,    0,   -5,   10,   13,    0,   -6,  -11,    0,
	  11,  -11,   10,   -7,   -8,    1,   16,   -9,    2,  -22,   -9,    0,    4,    5,  -12,  -22,
	   2,   -8,   -8,   14,  -16,    0,   13,    0,    9,   -7,    2,   -1,    7,    8,   -3,   -3,
	   2,   15,    5,   10,   -7,   12,   -4,   22,   -4,   -3,  -12,   -2,  -15,    8,   -2,  -22,
	   7,  -10,    5,   12,  -20,   -9,  -11,   -2,  -12,    2,   -9,    5,   -3,   11,    7,   -9,
	   4,   -4,   24,   -7,   21,  -15,   -3,    2,   14,   -1,    5,   18,  -12,   13,    3,    5,
	 -10,  -11,    0,   -8,   -2,   -4,    2,  -15,    9,  -10,  -16,   -9,   -7,    0,   -1,    3,
	  -8,  -10,    5,   -8,    4,   -3,    8,   -2,   20,    1,    6,   -4,   -9,    4,   14,    7,
	  -1,    3,   -5,   18,   -7,   20,   -6,  -10,    8,    1,   -2,    3,   -4,   -5,   -3,   -6,
	   0,  -16,   -7,   12,    0,  -17,    4,  -31,   -7,    1,    1,   -4,    8,  -11,    6,   -1,
	  11,   -5,   -7,   -4,    2,    4,   15,   -3,   21,   -5,   20,    3,  -12,   21,   -1,   10,
	   5,    6,  -20,   -1,  -18,    2,    3,   -4,   -5,   -1,    6,   -2,  -11,  -17,  -15,  -13,
	   0,    6,  -18,    7,  -18,    7,   -7,    6,    7,  -10,   18,   16,    2,   -1,    3,  -11,
	   6,   14,    1,   15,   -2,   29,   -8,   17,  -14,    2,  -19,   12,    8,   -6,   -1,  -23,
	   6,  -11,    7,  -19,  -18,    0,    1,   -8,   -8,   -4,  -20,    8,   -8,    4,   10,  -12,
	  13,    0,   18,  -10,   -3,   -4,    6,    4,   17,    7,   -2,   18,   -9,   14,  -10,   -4,
	 -11,    4,    3,   23,  -17,   -6,   -2,   -7,   -7,    9,  -10,    1,    2,   -4,  -14,   -7,
	  -6,   -8,   -4,    7,    2,   -3,    3,    0,   13,  -10,   -4,   -9,   -6,   18,   11,   -4,
	  16,   -8,   -4,    1,   -1,    7,    3,    3,    3,   10,  -15,   -2,   -9,    9,    0,    2,
	   2,   -9,   12,   -7,    0,  -23,   -7,  -19,    2,   -1,    0,    4,  -15,    7,    3,   -3,
	   0,    9,  -12,   19,    4,    8,  -13,   -6,    5,   -1,   14,   10,    9,   13,   -3,   16,
	 -18,   13,  -18,    7,  -10,   13,   -6,  -11,   -3,    7,  -23,   -6,  -11,  -21,    9,   -1,
	   4,   -3,  -16,    0,  -12,    7,   14,   -5,   15,    0,    6,   -5,   -3,   -9,    9,    4,
	  10,    4,   -2,   -7,   10,   -1,   10,   -6,  -14,   15,   -4,   13,   -4,   -4,  -14,    5,
	  -2,    4,   -9,    3,  -14,    2,    3,  -10,   -1,   -9,    0,    3,   -6,   12,  -16,    0,
	   4,   10,  -25,    6,   -5,    2,    8,    3,   -2,   -4,   15,    4,    7,    2,   -1,   -6,
	  10,   11,    2,   -2,  -14,    6,   -3,    0,   -3,   -9,  -10,    1,   -1,  -15,    9,  -29,
	   9,  -10,    7,   -3,   -3,  -10,   -2,   14,    4,   -6,    0,    1,   12,    4,   18,  -15,
	  19,    1,   15,    1,    1,    3,  -10,    8,   -1,    7,  -30,    8,  -19,   -2,   -5,   -9,
	 -10,    0,   -1,    6,   -4,  -12,    1,  -18,   10,   -1,  -12,    2,    7,   12,   11,    0,
	  -4,   -1,    6,   10,   17,   -8,    1,  -12,    5,   -2,    1,   -7,   -1,    4,    3,   -3,
	  -1,  -18,    8,   -9,    0,   -2,    8,  -12,   12,    7,   -5,   -2,  -16,   -7,    9,   -5,
	  11,   -9,   -4,    3,    1,   -9,   -1,   -2,   -6,    7,   12,    0,   -8,    9,  -10,    3,
	   0,    2,   -3,   11,   14,    4,    3,  -12,    3,   -3,    2,   12,   -4,   -2,   -2,    9,
	 -21,   -5,  -28,   -6,  -10,    6,    7,   -6,   -3,  -24,    7,  -11,   10,    0,    8,   13,
	  10,    6,   -7,   -2,   -5,    7,   -1,    9,   18,   -2,   12,   -4,    7,  -26,   13,   -6,
	  19,    6,    6,   -5,  -16,   -6,   -8,  -18,   -2,    1,  -11,    3,    4,  -16,   -8,  -10,
	  -3,    2,   -3,    5,    5,    0,   11,    0,  -14,    0,    1,   14,   11,   13,    0,   -2,
	   5,   -1,   -4,   -2,   -4,    5,   21,    3,   14,   -5,  -22,    5,  -11,   -3,   -6,   -3,
	 -11,    0,   -5,  -13,  -10,  -18,    3,    9,  -10,    2,    3,  -11,   11,  -11,    5,  -19,
	  23,   -1,   20,   18,    4,   -3,   -6,    9,    4,   -3,    8,    4,    6,    2,    5,  -14,
	  -6,   -3,    2,   -6,   -4,   -3,  -11,    0,   -5,    0,  -21,   -2,  -10,   11,    5,   -4,
	  -5,   -5,   -8,   10,  -10,    4,   -1,    6,   12,    9,    2,    8,  -20,    8,   -2,   11,
	 -11,    1,   -4,    5,    6,   -6,    6,  -14,   14,    4,   -2,   12,   -3,  -10,    8,   -5,
	 -15,   -9,   -1,    5,    8,   -3,    0,  -23,   -9,  -11,    4,  -12,    3,   -4,    4,    1,
	  15,  -12,    3,   13,    2,    5,    8,   -8,    7,   11,   -3,   17,  -11,    5,    3,   19,
	  13,    3,  -11,  -11,   -2,   -9,   -7,   -4,  -24,   -1,  -17,   -3,  -17,    0,  -15,    2,
	  -1,   -5,   -4,    3,    2,    2,   11,   -4,    3,   -6,   11,    8,    3,    6,    3,    7,
	   7,    6,   -6,    2,    0,   14,   14,    3,    8,   -6,    4,   -3,    6,  -13,   -2,   -9,
	  -4,    5,  -13,   -5,  -21,   -1,   -6,   -1,   -5,  -14,    8,   -7,    5,   -7,  -17,  -11,
	   7,    3,   20,    7,    1,   -3,    4,    5,   14,   -3,    5,    3,   10,    8,    6,   -6,
	  -2,    6,    3,    7,   -6,   -3,   -3,   -6,   -1,  -27,  -11,  -17,    0,   11,    7,    1,
	  -7,   -9,  -13,    5,  -11,    0,  -10,   15,    2,    5,   -2,   -5,    1,    6,    6,   -6,
	  -5,    6,    2,    5,    3,   10,  -16,   11,    8,   18,    3,   13,  -11,    7,    5,   -7,
	  -6,  -20,   15,   -1,   10,   -1,  -13,  -17,  -11,   -3,  -13,   -4,  -14,   -3,   -2,   -6,
	   6,  -28,    9,   -8,   10,    0,   12,   -2,   10,    9,    1,    3,   -6,    5,   17,   24,
	  18,    3,    4,   -9,   -4,    2,   -8,   -4,   -2,  -11,    1,   -8,  -12,   -9,  -10,    5,
	   0,   -7,   -9,    7,  -18,    6,  -10,  -12,   -1,   -1,   13,    1,   18,    2,   -3,    4,
	   3,    3,   -3,    3,   10,    9,    7,    5,   -8,   -7,    0,    3,   -7,    7,   -2,   -2,
	   5,  -10,    2,   -5,   -3,   -1,    4,    1,   -2,  -10,    4,   -9,   -5,  -12,  -18,    3,
	   6,   -3,    3,  -15,   -1,  -13,    6,   -2,    8,    0,    8,   16,   -2,   17,   -4,    8,
	   3,   23,   -1,   11,   -8,   10,   -4,   -5,   -3,  -13,   -2,   -1,   -2,    2,   -9,  -13,
	 -13,   -2,  -11,   -2,  -20,   -5,    0,    3,    2,   -1,  -10,    1,    8,    3,    9,    6,
	   4,   -3,   13,    3,    4,   11,    2,   11,    8,   -2,   -1,   -2,   -2,   -2,   -1,  -21,
	  -1,  -14,    8,    6,   -8,  -10,    2,  -16,    4,   -3,   -1,  -10,    7,   -1,    4,   -4,
	 -12,    3,   -2,   13,    2,   -3,   -9,   -2,    6,   -7,    8,   -8,   -5,   12,    7,    8,
	  -3,    6,   -1,   16,    0,    7,   -8,    3,   -7,   -1,    0,   -6,   -4,   -8,    6,   -1,
	   4,  -19,    2,   -3,   -8,   -3,  -12,    4,   -6,    2,   -7,    1,  -13,    2,    9,   -1,
	  17,  -19,    3,   -3,   23,    9,    6,    3,    6,    6,   -5,   11,  -11,    1,    0,   -5,
	   6,   -6,   -4,   -5,   -7,    3,   -4,  -14,   -9,   -7,   -1,    5,  -11,    4,  -19,   14,
	  -4,    3,    4,    2,    0,    9,   -2,   -3,    2,   -2,   10,   15,   -3,   14,   -6,   -4,
	   6,    1,   -8,   11,   -9,    4,    3,   -9,    2,    2,   -2,    2,   -2,   -9,   -2,   -2,
	   1,   -6,   -6,  -22,  -16,  -10,   12,    0,    5,   -8,   -2,   -4,   -2,    5,   -1,    7,
	   7,    9,    1,    7,    6,   -1,   10,   11,    5,   -3,    8,    1,   -1,    8,  -15,   -6,
	 -10,   12,    0,    2,   -5,   -9,  -12,   -7,   -4,  -14,   -4,    0,   -1,    5,   -7,   -8,
	 -12,    0,    2,   16,   -3,   11,   -4,   16,   11,    2,   -3,    2,    8,   -1,    7,  -13,
	   4,   -3,   -1,    3,  -10,   -2,  -11,    3,    2,    3,   -7,  -10,   -5,  -10,   12,   -8,
	   5,   -7,   15,    1,  -10,    7,  -16,    1,    3,    4,   -5,    7,   -7,    4,   -2,   -1,
	  -8,    0,   -2,   17,   10,   -2,    6,   -5,    3,   10,   -7,    2,   -3,    4,    5,    5,
	  -3,   -8,   -8,   -1,    1,    7,   -5,  -11,   -2,  -10,   -4,  -15,   -7,  -10,   -2,    2,
	  -4,  -10,   -8,    0,    2,    6,    3,    2,    3,   10,   14,    8,    7,    3,    5,   -5,
	  20,   -6,   -1,   -2,    0,    1,   -2,   -2,   -8,    3,   -3,   10,  -14,    3,   -3,   -2,
	   0,   -5,    0,  -15,    4,   -2,    0,    4,   -7,    3,   -8,    7,  -14,   -2,   -6,    4,
	   2,    3,  -10,   -2,    5,   -3,   12,   -2,   -5,   -9,    1,    4,    1,   11,  -12,   15,
	   5,   20,   10,   -5,    1,    5,    3,  -13,    6,  -16,    5,    1,   -5,   -8,   -3,  -14,
	  -6,   -2,   -5,   -8,  -17,   -9,    3,   -6,   -2,   -3,   -3,    1,   14,    2,    4,    5,
	   3,    8,    7,   12,    0,   11,    4,   16,    2,   -3,   -9,   -1,    1,   -1,   -3,   -6,
	 -14,    4,   -6,    2,  -14,   -9,  -11,   -1,    0,    0,   -5,   -6,  -10,    5,   -5,    2,
	  -3,    2,    2,   17,   -2,   -1,   -3,    3,   11,    1,   10,    2,    7,    6,    5,   -5,
	  -3,   -3,   -2,    7,    2,    1,  -18,   -5,   -2,   -3,   -5,    0,   -2,    0,    8,   -9,
	 -10,  -15,   -7,   -2,   -1,    6,   -8,   16,  -10,   13,   -4,    2,   -4,    4,    7,    9,
	   6,   -5,   -2,    8,   -1,   11,   -6,   -1,    5,    8,    0,    9,  -20,    0,   -9,    4,
	  -3,    1,   -4,  -11,    2,   -6,    0,  -12,    0,    1,    5,   -2,    1,   -7,   -4,    3,
	  -1,  -10,    3,   -3,    7,    4,    8,   -9,   -6,  -10,    0,    0,    2,   -4,    6,    9,
	  10,    2,    0,   -1,    2,   14,    3,    7,   -7,    2,   -2,   -2,   -6,   -9,    2,   -3,
	   6,   -3,   -7,   -9,  -10,   -2,    2,   -1,  -11,    2,    1,    7,   -4,   -7,  -19,    3,
	  -1,    6,    6,    6,    6,    0,    6,    7,    3,   -1,    3,    8,    3,    4,  -10,   -5,
	  -7,    5,   -4,  -14,    2,   -8,    5,   -2,    2,  -16,   -4,  -11,    2,    4,   -1,    2,
	  -1,    0,    5,    4,  -12,    3,    9,    7,   13,   -3,   -7,    2,    6,   -1,    7,   -1,
	  -1,    5,   -5,    7,  -11,   -9,  -13,    2,    5,    2,   -2,   -7,    5,    4,   -4,   -2,
	 -15,   -4,    3,    0,    0,   -5,    2,   -7,   -1,    9,   -2,   -1,    5,    1,    1,   -4,
	  -5,   -4,    6,    8,    7,   -5,    4,   -7,    4,    0,    1,   -6,   -5,   -2,    5,   -1,
	   0,    1,    1,    3,    9,   -4,   -2,   -4,   -9,   -1,    4,  -17,    1,  -13,   11,   -1,
	   6,   -9,   -1,    5,    1,    8,   -3,    4,   -5,    1,    7,   -5,    1,   -3,    5,    3,
	   4,   -7,  -11,   -7,    1,    5,  -13,   11,  -11,    1,    3,    6,   -9,    6,   -5,   -7,
	   4,  -13,    5,   -7,   10,    5,    6,  -15,   -1,    6,    4,   18,   -7,   -7,   -3,   -4,
	   2,   -5,    3,   -4,    9,   -4,    3,    3,   -3,  -10,    0,   -1,    2,    5,   -3,    7,
	   3,    2,   -6,  -11,   -2,   -1,    4,   -5,    4,   -5,    0,   -5,    5,   -5,   -4,    2,
	   4,    2,    5,   -8,  -13,   -3,    0,   -1,   -2,    4,    6,    9,    1,    3,   -7,   -1,
	   1,   12,    1,    1,   -1,   -5,   -1,    2,   -8,   -9,   -7,   -2,    3,   10,   -6,   -7,
	 -12,   -7,   -4,   -5,    6,    0,   10,    5,    7,   -4,   -2,   -8,   10,    5,    9,    4,
	  -1,   -1,   -1,   -1,   -1,   -2,   -3,    3,    9,   -2,    9,  -14,  -13,   -8,  -10,    1,
	   1,    3,    3,    1,   -3,  -12,   -5,   -7,    1,    6,    6,   -2,   -7,   -3,   -3,    2,
	   2,    4,   -9,   14,    8,   11,   -3,    5,  -11,    1,   -1,    5,    3,    8,    2,    8,
	  -2,   -6,  -13,  -10,    0,    4,    3,    4,   -3,   -9,    1,   -5,   -5,   -6,    1,   -2,
	   2,  -10,   -6,  -15,    1,   -5,    4,   -1,    2,    2,    4,   10,    4,    2,  -13,    0,
	   4,    8,   17,    2,    5,    4,    2,   -6,    5,   -5,    0,    8,   -2,   -1,   -5,   -4,
	  -5,   -1,   -5,   -4,   -5,    0,    0,    1,   -9,  -15,   -3,  -12,    1,   -1,   -7,   10,
	   2,    5,   -1,    2,   -6,    2,    2,   10,   10,   -1,    2,   -2,    4,    5,    0,   -6,
	  12,    5,    3,   -1,   -8,   -8,   -4,   -4,    3,  -11,    0,   -1,   -1,    0,   -2,  -14,
	  -6,   -9,    2,    1,    7,   -4,    3,   -1,    0,   -3,    1,    2,    7,    5,    4,    3,
	  -2,   -3,    1,    6,   -1,    6,  -11,    7,    2,   -6,    2,   -4,    0,    2,    3,   -7,
	  -9,    3,    0,    4,   -6,    0,  -21,    0,   -5,   -1,    0,   -1,    1,   -6,   -1,   -1,
	   0,   -7,    5,    7,   -2,    8,   -4,   -1,    3,    9,   -6,   10,   -6,    7,    9,   10,
	   9,   -6,    5,  -14,    6,   -5,    1,    2,   -3,    0,   -9,  -10,  -14,   -2,   -3,    6,
	  -8,  -15,    3,   -9,    0,   -3,    0,   -6,   -1,    3,    9,   10,    3,    3,  -10,    6,
	   1,    3,   -1,    9,   12,    4,    4,   -9,   -7,   -5,    8,    6,    1,    1,   -4,   -5,
	  -5,   -1,  -11,   -3,   -4,    1,   -1,    1,  -10,   -7,   -2,   -3,   -4,   -3,   -6,   11,
	   5,    3,    2,   -8,   -5,   -2,    3,    9,   13,    5,    4,    4,    0,   -5,   -1,   -5,
	   9,    2,    3,   -9,   -4,    3,   -6,    2,    1,   -9,    5,   -2,    3,   -2,   -9,   -8,
	 -15,   -5,   -3,    3,  -13,   11,    6,   -3,    1,   -6,   -6,   -1,    6,    4,    6,    7,
	   1,    5,    0,    8,   -6,    7,    2,    6,    2,   -5,    0,   -3,   -1,    3,   -7,   -1,
	  -3,    5,    7,    6,  -18,  -10,  -11,   -7,   -3,   10,   -4,    3,   -4,   -8,   -5,  -12,
	  -3,   -4,   12,   10,    2,   -4,    6,    3,    1,    2,    0,   -3,    3,    7,    7,   -5,
	   2,   -4,    1,    3,   11,    2,    3,    4,   -2,   -7,   -5,  -17,  -11,    4,   -3,    5,
	  -7,   -7,   -6,   -1,   -8,   -5,   -5,    1,    7,    1,    2,   -1,   -9,    7,    1,    7,
	   3,    3,    6,    9,    6,    1,   -6,   -4,    2,    5,    7,    4,   -2,    1,    3,  -11,
	  -1,  -16,   -2,   -6,    1,    3,   -8,  -15,  -11,    4,   -1,    9,   -2,   -5,    0,    6,
	   0,   -7,    0,   -8,    4,    2,    6,    2,    0,    2,    6,    2,   -2,    4,   -2,    4,
	  14,    2,    2,   -6,   -6,   -3,    4,   -4,   -1,   -4,    1,   -3,   -6,   -1,  -13,   -1,
	  -2,    7,   -8,   -7,  -10,    0,    4,    3,   -8,   -3,    1,    4,    6,    4,    6,   -3,
	   5,    3,    4,    0,    6,    1,    4,    7,   -3,  -10,    8,   -1,    9,   -1,    1,  -11,
	  -7,   -3,   -3,   -6,   -8,   -9,   -6,    1,   -3,   -6,   -6,   -5,    0,    0,    2,   -3,
	   0,    6,    4,    3,    2,    7,    4,   11,   14,    5,   -1,   -5,    1,   -2,    7,    3,
	   0,    1,    2,   -5,   -7,  -10,  -12,  -10,   -5,   -5,   -6,   -6,   -9,    1,   -8,   -2,
	  -1,   -9,    1,    8,    2,   -5,   -2,   -5,    0,    5,    6,    6,    7,    8,   10,    2,
	   0,   -3,   -1,    2,   13,    3,    0,   -6,    0,    1,   -3,    0,  -12,   -2,    4,   -4,
	   4,   -8,  -11,   -1,   -2,    1,   -1,    2,  -12,    3,   -6,    1,  -12,   -7,   -7,    3,
	   0,    9,    0,    1,    6,    1,   -1,    2,    1,    2,    8,    9,   -3,   -1,    0,    7,
	   3,    8,   -1,   -4,   -1,    1,    3,   -9,   -1,  -17,   -3,   -2,   -4,   -4,   -3,   -4,
	  -6,  -11,  -15,   -2,   -5,    6,   10,    1,    3,   -1,   -3,   13,    7,    1,    6,    4,
	   4,    9,    5,   -3,   -5,    9,    3,    5,   -3,    1,   -3,    3,    0,   -7,   -5,   -7,
	   0,   -5,    0,   -1,  -15,  -11,   -4,   -5,  -10,    2,   -7,    5,   -4,    1,   -9,    2,
	   1,    8,    7,   10,    2,    2,    0,    4,    3,   -2,    0,    4,    2,    6,    8,   -2,
	   4,    4,   -2,    5,   -3,   -6,    3,   -3,   -5,   -9,   -8,  -11,   -5,   -1,   -1,   -5,
	  -7,   -5,   -8,    0,   -3,    5,   -7,   11,    1,    0,    2,   -3,   -1,    3,    9,    6,
	  -3,    8,    1,   11,    2,    8,   -3,   -3,    6,    2,    1,    2,   -7,   -3,   -2,   -4,
	  -8,   -3,   -3,    5,  -10,  -10,   -4,  -12,   -2,    3,   -5,    3,   -6,   -8,   -2,    5,
	  -3,    0,    1,    4,    8,    4,    5,    0,    4,    8,    1,    7,   -3,    0,    3,    4,
	   4,   -5,   -2,   -7,   -3,    0,    5,   -5,   -9,    3,   -2,   -1,   -2,   -5,   -1,   -4,
	  -3,  -11,   -4,   -5,   -6,    0,    5,    0,   -5,    5,    3,    8,   -1,    3,    3,    2,
	   5,    7,   -4,    3,    1,    3,   10,    2,   -7,    1,    0,    6,   -4,   -3,   -5,   -7,
	  -2,   -4,   -3,   -6,    0,  -10,    4,   -6,   -4,   -7,   -2,    1,   -4,   -1,   -3,   -1,
	   2,    6,    2,    4,   -2,    2,    4,    2,    5,   -3,    4,    2,    1,    0,    8,   -3,
	   2,    5,   -5,    3,   -5,   -2,    5,   -5,    3,   -1,   -4,   -3,    4,  -10,   -5,   -7,
	  -4,   -4,    0,    0,   -7,   -1,   -1,    2,    1,   -2,  -12,   -4,   -1,    0,    4,   -5,
	   2,    0,    3,   12,   11,    3,   11,   -1,   -3,    6,   -6,    1,    1,    7,    6,   -7,
	  -1,   -7,   -4,   -4,   -7,   -8,   -1,   -6,   -6,   -2,   -3,   -5,    0,   -4,    8,   -7,
	   1,    4,   -3,    6,    1,   -7,    3,    5,    6,    5,   13,    2,    2,   -4,    4,   -3,
	   1,    4,   -4,    2,   -3,  -10,  -10,   -7,   -2,   -2,   -2,    0,   -6,   -2,    1,   -3,
	  -4,   -2,   -5,   -2,    7,    1,    6,   -5,    6,   -1,   -1,    2,   -3,    4,   11,    2,
	  -1,    2,   -7,   -5,    8,    0,    3,   -3,   -5,   -1,   -2,    3,    1,   -4,    4,    7,
	   0,    2,    3,   -3,    0,    1,   -5,  -15,   -5,   -3,    1,    3,   -3,  -11,   -4,   -7,
	   1,   -2,   -1,   -1,    0,    1,    1,   -5,   -1,    3,   -2,    7,    1,   -4,   -1,    0,
	   4,    5,    3,    3,   -1,    8,   11,    1,    4,    1,   -5,    7,   -6,   -4,   -2,   -4,
	  -2,    3,   -8,   -3,  -13,   -6,    3,   -3,   -7,   -4,   -7,    3,    3,   -3,    2,   -1,
	   1,   -4,   -2,   -2,   -5,    1,   11,    9,   -2,    6,   -3,    7,    7,    1,    1,   -7,
	   2,   -3,    1,    4,   -4,   -4,    5,    1,    0,   -3,   -6,    2,   -3,    0,   -8,  -12,
	  -6,   -2,   -3,    6,   -1,   -9,    0,   -1,    1,    3,   -2,   -1,    0,    1,    6,    0,
	  -3,    5,    1,    6,    1,   -1,    4,    1,    7,   -3,   -1,   -1,   -4,    4,   14,   -1,
	  -1,    2,   -4,   -1,   -6,   -8,   -8,   -3,   -2,    2,   -9,   -5,   -7,  -12,    5,    0,
	  -3,   -4,   -3,    5,    4,    3,   -2,   -6,    4,    7,    3,    5,    7,   -3,    8,    0,
	  -5,   -1,   -1,   11,   10,    3,    4,   -8,   -3,   -3,    1,   -3,    0,   -4,   -3,    1,
	  -7,   -8,  -16,   -7,   -6,   -2,    3,   -7,   -2,    1,   -4,    0,   -5,   -5,    1,    5,
	  10,    5,    0,    3,    0,    1,   13,    0,    5,    9,    6,    8,   -1,   -4,    0,   -3,
	   6,    4,   -4,    0,   -3,  -15,   -2,  -12,  -15,   -3,   -6,    2,    1,   -3,   -4,   -9,
	  -9,   -3,   -3,   -2,    3,    4,    9,    0,    2,    1,    2,   14,    5,    3,    8,    2,
	   7,    4,   -4,   -4,   -1,   -9,    9,   -5,   -1,   -7,  -10,   -2,   -7,   -4,    0,   -5,
	   2,    5,    1,    0,   -5,   -5,   -1,   -1,   -3,    4,   -8,    5,    3,   -4,    4,   -5,
	  -3,    9,    4,    8,    0,    0,    2,    0,   -2,    0,   -2,   -7,   12,   -1,    5,   -4,
	   2,   -3,    0,    2,   -2,   -4,   -2,    2,   -5,    3,   -7,   -9,   -4,   -3,   -2,   -6,
	  -6,   -2,   -6,   -1,   -7,   -8,    1,    3,    6,   10,    4,    5,    0,    5,    8,    1,
	   3,    8,    5,   11,   12,   -7,    4,    0,   -3,    2,   -1,   -8,   -7,   -4,   -2,   -6,
	  -9,   -6,  -13,   -4,   -1,    0,   -9,   -5,   -3,   -4,   -2,    3,    1,    1,    9,    4,
	   2,    6,   -1,    3,    6,    2,    0,   -3,    3,    2,    6,    3,   -1,   -4,    4,    1,
	   2,    2,   -5,   -8,   -1,   -3,   -1,   -9,   -4,    1,   -5,    5,   -7,   -4,    0,    3,
	 -10,    3,   -3,   -5,    1,    5,    4,    1,   -5,    1,   -5,    4,    1,   -6,    0,    5,
	   8,    8,    1,    6,    0,    3,    4,    2,   -3,    1,   -3,   -3,    3,  -10,   -6,   -8,
	  -2,   -1,   -3,   -6,   -6,   -5,   -6,   -6,   -5,    5,   -3,    5,    6,   -2,   -1,   -1,
	  -4,    6,   -2,    6,    6,    2,   12,    8,   -2,    3,   -6,   -2,    5,    4,   -3,   -2,
	  -5,   -4,   -7,   -6,    1,   -5,    2,    2,    0,    1,   -7,    0,   -4,   -2,   -1,   -2,
	  -5,    7,   -5,   -2,   -3,   -2,   -3,    4,    4,    9,    0,    1,    1,   -5,   -3,   -4,
	  -4,    4,    3,    6,    1,   -2,   -2,   -7,    4,    1,    1,   -3,    3,   -1,    2,    0,
	  -7,    0,    0,   -1,   -3,   -2,   -1,   -5,   -2,   -3,   -8,   -5,   -5,   -1,    5,    5,
	   2,    2,   -3,    4,    3,    4,    6,    3,   -1,   10,   -4,   -3,   -2,   -3,    0,   -4,
	   0,   -2,   -2,    0,    2,   -5,   -2,   -5,   -9,    8,   -2,   -1,   -1,   -3,   -3,   -2,
	  -6,    2,    1,    2,    9,    0,    1,    4,   -5,    2,    4,   -6,   -1,    2,   -1,    6,
	   3,    0,   -5,   -3,   -1,    0,    3,   -3,    0,   -6,   -2,   -3,   -4,   -2,    0,    3,
	   2,    2,    0,  -10,    1,   -6,   -5,   -1,   -2,    5,    3,    6,   -2,   -6,   -1,   -3,
	   2,    4,    1,   -1,    0,    1,    1,    3,   -1,    5,   -1,    7,    6,    1,   -2,    0,
	  -6,   -2,   -2,   -8,   -2,   -2,   -3,   -5,   -5,   -8,   -3,   -1,    5,   -3,    1,    2,
	   1,    2,   -3,   -2,   -3,    2,    6,    2,    6,    0,    0,   -2,    9,   -1,    3,   -2,
	   3,    0,    0,    0,   -6,   -6,   -1,   -5,   -7,    1,   -3,   -6,    2,   -2,   -1,   -5,
	  -2,    1,    4,    2,    2,   -3,   -1,    6,   -2,    2,    4,   -3,    2,    2,    2,   -3,
	   1,    0,   -4,    2,   -1,   -2,    3,    1,    1,   -1,   -5,   -8,   -2,   -5,    0,    1,
	  -6,    3,   -4,    2,    3,   -6,    3,    0,    2,   -2,   -1,   -4,   -2,   -4,    4,    0,
	  -3,    0,   -6,   -3,   10,   -3,    3,    0,    4,    7,    3,    0,    5,    1,    5,    1,
	  -3,   -2,    0,   -6,    3,   -1,   -7,   -5,   -7,   -1,   -2,   -2,   -2,   -3,   -2,    2,
	  -2,   -1,   -3,   -3,    2,   -2,   -6,   -3,   -3,    4,    3,    2,    0,   -1,    5,    5,
	   8,    2,    2,   -2,    4,    0,    5,   -5,   -3,   -1,   -3,   -3,   -6,   -4,   -2,    3,
	   0,   -2,   -2,   -5,    5,   -1,    3,   -1,   -1,   -3,    0,    0,   -5,   -4,   -3,   -2,
	   5,    0,   -4,   -4,    1,    2,    6,    0,   -3,   -1,    2,    3,    7,   -3,    0,   -4,
	  -2,    4,    3,    0,    1,    3,   -3,    1,   -7,   -4,    0,    1,    1,   -4,   -4,   -4,
	  -9,   -1,   -2,   -3,   -2,   -3,   -3,    4,    3,   -1,   -4,    2,    4,    4,    3,    2,
	  -1,    0,    9,   -1,    4,    2,    7,   -1,    6,   -2,   -2,   -5,   -1,   -9,   -2,   -2,
	  -6,   -1,   -1,    1,   -8,   -6,   -5,   -1,   -1,    1,   -4,   -5,    3,    1,    5,    3,
	  -3,    0,   -2,    7,    0,    1,   -2,    3,   -1,    5,   -1,   -5,    7,   -1,    3,    2,
	  -5,   -6,   -2,    4,    2,   -1,   -3,   -1,   -1,   -1,   -1,   -2,   -4,    1,   -5,    3,
	  -1,   -3,   -5,    2,    6,   -6,   -1,   -5,   -4,    4,   -1,   -1,   -2,   -1,    2,    0,
	   3,    1,    4,    2,    7,   -1,    2,    0,   -2,    1,    4,   -5,   -3,   -7,   -2,    0,
	  -1,   -1,   -3,    0,    0,   -2,   -6,    2,   -4,    2,   -4,    1,   -7,   -2,   -1,    5,
	   3,   -2,   -7,   -4,    1,    6,    4,    5,    1,    4,    0,    5,    1,   -1,    2,    0,
	  -3,   -3,   -5,   -6,    3,   -1,    5,   -1,   -2,    1,    1,    4,    2,   -6,   -3,   -4,
	  -3,    2,   -2,   -8,   -3,   -6,   -4,   -2,  -11,    0,    0,    1,    6,   -3,   -2,    1,
	   2,   10,    8,    4,   -2,   -1,    2,    2,    1,   -2,    3,    1,    5,    3,   -1,    0,
	  -4,    4,   -7,   -2,   -7,   -8,   -4,   -3,   -2,   -7,   -7,   -3,   -1,    5,   -2,    0,
	  -7,    2,   -1,    3,    1,    4,    6,    5,    8,    3,    2,   -1,    3,   -3,    0,    0,
	  -5,   -1,    1,    1,   -5,   -3,   -2,    6,    4,    5,   -4,   -8,   -4,   -3,   -2,   -5,
	  -4,   -4,   -4,    2,   -3,   -2,   -4,   -4,   -4,    6,    1,    0,    1,    3,    3,    5,
	   2,    1,    0,    6,    2,   -1,    1,   -3,   -3,    2,   -1,    0,    1,    3,    1,    4,
	  -4,   -5,  -10,   -8,    1,   -6,   -3,   -4,   -6,   -3,    0,    2,   -3,   -1,    2,    0,
	   8,    1,    4,    4,    3,    6,    3,    1,    3,    5,    1,    2,   -4,   -7,   -3,   -3,
	   3,    0,   -7,   -5,    0,   -3,   -1,   -2,   -4,    0,   -5,    1,   -6,   -1,   -5,   -3,
	   1,    4,   -1,   -3,    3,    3,    5,   -1,   -2,    2,   -1,    2,    1,   -1,   -5,    5,
	   1,    2,    2,   -4,    0,   -1,    3,    0,   -2,   -1,    2,    1,    5,    4,   -3,   -5,
	   0,   -2,   -2,   -6,   -3,   -3,   -4,   -1,   -5,   -4,   -1,   -2,    0,    2,   -2,   -6,
	  -3,    1,    1,    1,   -1,    3,    4,    7,    2,    3,    4,   -1,    7,    2,    3,    1,
	  -1,    1,   -2,    0,   -4,   -5,   -6,    0,   -2,   -7,   -2,   -5,   -5,    1,   -4,   -5,
	  -5,    3,   -1,    1,    2,   -2,    0,    1,    4,    1,   -4,    2,    2,    0,    9,    2,
	   0,    4,    3,    1,    2,   -4,   -2,   -4,    3,   -4,   -2,   -6,    0,   -1,    5,    2,
	  -4,    0,   -4,   -4,   -1,   -5,   -4,   -7,   -3,    1,    0,   -2,   -1,   -5,    1,    0,
	  -1,    0,    2,    4,    0,    3,   -2,    1,    2,    6,    0,    1,    5,    0,    3,    3,
	   2,   -5,   -2,    1,    5,    2,   -2,   -5,   -9,    0,   -6,   -1,   -6,   -7,   -5,   -4,
	   0,   -2,   -5,   -3,    2,   -2,    3,    2,    0,    9,    2,    0,    4,   -3,    4,    5,
	   8,    6,   -2,   -4,   -1,    0,   -2,   -2,    1,   -5,    2,   -5,   -1,   -4,   -3,   -4,
	   0,   -2,   -7,   -3,   -1,    0,   -1,    0,   -6,    3,   -2,    5,    2,   -1,   -2,    1,
	   0,    1,   -1,   -3,    2,    3,    1,    2,   -4,   -3,   -1,    5,    5,    3,   -4,    0,
	   1,    2,    5,   -5,    1,   -5,    2,   -2,    2,   -4,   -3,    0,   -4,   -3,   -9,   -7,
	  -4,    2,   -2,    1,   -6,   -3,    0,    1,    5,    1,   -5,    0,    0,    2,    1,    2,
	   0,    6,    4,    6,    3,    2,    3,    1,   -2,   -2,   -9,   -4,   -1,    4,    0,   -1,
	  -5,   -8,   -5,   -4,    0,   -4,   -1,   -3,    0,    0,   -4,   -3,   -1,    1,    2,    0,
	  -2,   -3,    1,    3,    2,    3,    3,    0,    8,    2,    7,   -1,    3,   -2,    4,    0,
	   0,    1,   -4,    5,   -1,   -3,   -3,   -6,   -4,    2,    1,   -5,   -4,   -7,   -4,   -4,
	  -7,   -2,  -10,    1,    0,    1,   -3,    4,   -2,    5,    2,    1,   -3,   -1,    2,    8,
	   4,    5,    0,    1,    4,    5,    2,    2,   -2,    1,   -4,    0,   -3,   -3,   -1,    0,
	   2,   -4,   -4,   -5,   -1,   -7,    0,   -4,   -5,   -1,   -3,    2,   -2,    0,    3,    0,
	   2,    0,    1,   -2,    2,    4,   -1,    0,   -3,   -1,    1,    3,    2,   -3,    2,    0,
	   2,    2,   -1,    2,   -2,   -3,    0,    0,   -2,    2,   -2,    4,   -3,   -6,   -7,   -6,
	   2,   -1,   -4,   -1,   -7,   -1,   -3,    3,   -1,    0,   -2,    2,    2,   -3,    3,   -4,
	   5,    7,    6,    3,    1,   -1,    6,    2,    1,    0,   -1,   -1,    1,   -3,    1,   -3,
	  -5,   -5,   -3,   -8,   -3,  -11,   -1,   -1,    0,   -8,   -2,   -5,    3,    4,    0,    1,
	  -2,    2,    0,    6,    4,    1,    4,    1,    5,    0,    0,    1,    2,    5,    0,    1,
	 -10,    0,   -5,    2,    0,   -6,   -6,   -2,   -2,    2,   -3,    0,   -4,    2,   -4,    1,
	  -3,   -4,    1,   -2,    2,    1,   -2,    0,    3,    2,   -3,   -1,   -5,   -3,    4,    2,
	   3,   -1,    4,    1,    5,   -1,    2,   -3,    2,   -3,    0,   -3,   -2,    1,    1,    5,
	   1,   -2,   -5,    1,   -1,   -4,   -3,   -7,    0,   -5,   -4,   -4,    0,   -4,    4,    0,
	  -1,    1,   -8,    1,    0,    9,    1,    2,   -2,    5,    5,    1,    6,   -1,    6,    3,
	   1,    1,   -2,   -2,   -4,   -3,   -2,   -3,   -7,   -4,   -4,   -1,   -3,   -8,   -1,   -8,
	   4,   -5,    0,   -3,    1,    0,    4,   -1,    0,    1,    3,    3,    4,   -4,    6,   -2,
	   2,    5,    4,   -3,    4,   -3,    5,    0,   -4,    0,    0,   -1,    0,   -4,   -4,    3,
	  -1,   -2,   -4,   -8,   -9,   -5,   -4,    4,   -4,    1,   -4,    1,    1,   -1,   -1,   -1,
	   3,    2,    3,    0,    1,    2,    1,    5,    3,    1,    0,    5,    3,    3,    0,   -5,
	  -4,   -2,    5,    0,   -2,   -5,   -2,   -6,   -2,   -5,   -8,   -2,    1,   -1,   -3,   -7,
	  -8,   -6,    0,    4,    7,   -2,    7,   -1,    7,    3,    2,   -5,    0,    2,    0,    1,
	  -3,    2,    2,    3,    3,   -3,    0,   -2,    3,   -1,   -1,   -4,   -6,   -2,   -3,    4,
	  -4,    0,   -4,    6,   -2,   -6,   -2,   -7,    1,    2,   -1,   -3,   -2,   -2,    3,   -1,
	   0,   -3,   -1,    4,    7,    4,    0,    2,   -1,    0,    6,   -2,    1,    1,    5,    4,
	   1,   -3,   -3,   -2,    2,    2,    1,   -6,   -6,   -3,   -4,   -2,   -6,   -5,   -4,   -5,
	  -2,   -8,   -8,   -3,    0,    4,    0,    1,   -1,    2,    5,    4,    2,    2,    3,    3,
	   4,   10,    0,    2,    0,    3,    1,    1,    0,   -3,    1,   -3,    1,   -7,    0,    1,
	  -2,    1,   -6,   -4,  -10,   -1,   -4,   -2,   -2,   -3,    2,   -4,    1,   -5,   -4,   -4,
	   2,    1,    1,   -4,   -1,    3,    1,    6,    2,   -2,   -2,    3,    3,    2,    7,   -5,
	   5,    0,    8,    1,   -1,    2,    3,   -1,   -6,    0,  -10,    3,   -1,   -1,   -5,   -6,
	  -8,   -2,    0,   -3,   -5,   -8,   -4,    2,   -3,   -1,   -2,    0,   -1,    7,   -1,    3,
	   2,    4,    7,    3,    4,   -1,    5,    1,    9,    1,   -2,   -1,   -1,    1,   -3,   -2,
	  -6,   -7,    1,   -3,   -1,   -9,   -4,   -6,    0,    2,   -3,   -2,   -4,   -3,    0,   -4,
	  -1,   -4,    0,    1,    6,   -1,    1,   -1,    3,    5,   -1,    3,    4,    5,    7,    4,
	  -2,    0,   -2,    0,    3,    1,   -1,   -8,   -2,   -1,   -2,   -5,   -1,   -2,   -2,    2,
	  -5,   -7,   -9,   -2,   -3,   -2,    1,   -5,    4,   -4,    5,   -1,   -1,   -3,    2,    3,
	   7,    3,   -1,    3,    4,   -1,    5,   -4,    0,    4,    4,    3,    4,   -9,    1,   -5,
	   2,   -2,   -2,   -3,   -7,   -1,   -2,   -2,   -5,   -3,   -1,    1,   -2,   -1,   -4,   -4,
	   1,   -1,   -7,    0,   -1,    2,    5,    4,   -4,   -5,   -4,    0,    2,    1,   -1,    3,
	   5,    4,    0,    0,   -1,    3,    8,    3,    3,   -4,    0,    1,    0,   -2,   -6,   -2,
	  -4,    3,   -2,   -3,   -5,   -6,   -3,   -1,   -1,   -7,    0,    0,    3,   -5,   -4,  -11,
	   0,    0,    3,    3,    1,    1,    1,    4,    6,    1,    1,    2,    9,    3,    3,   -4,
	  -4,   -3,    2,   -1,   -6,    1,   -5,    2,    0,   -1,   -8,   -5,   -6,    1,    0,   -2,
	  -1,   -2,   -1,    2,    0,   -9,    0,    5,    4,    7,   -3,   -3,    3,    4,    2,    4,
	   0,   -1,    3,    1,    5,   -5,   -6,   -7,    0,    3,    0,   -2,   -4,    3,    3,   -3,
	  -4,   -7,   -2,    4,    1,   -1,   -4,   -1,   -6,   -2,    3,   -2,   -3,    1,    4,    1,
	  -1,   -4,   -3,    3,    4,    5,   -2,    2,   -3,    4,    0,    3,   -3,   -3,    0,    3,
	   1,   -2,   -1,   -3,    2,    4,   -2,   -2,   -3,   -1,   -1,    3,  -11,   -2,   -8,    5,
	  -1,    3,   -5,   -2,    2,   -1,    3,   -3,    0,   -1,   -1,    5,   -2,    0,   -2,    3,
	   2,    3,   -2,   -6,   -3,    2,    4,   -6,    5,   -6,    1,    2,    3,   -6,    2,   -3,
	  -4,    3,   -9,    2,   -6,    3,    4,    2,   -9,   -1,    1,    2,    8,   -3,   -4,   -1,
	  -2,    2,   -2,    2,   -3,    3,   -1,    1,    2,   -1,   -6,    1,    2,    2,    1,   -2,
	   2,    3,    1,   -3,   -6,   -3,    0,    1,   -3,    0,   -3,   -1,   -4,    2,   -4,   -3,
	  -1,    4,    0,    5,   -6,   -7,   -1,    0,    0,   -3,   -1,    2,    4,    0,    3,   -4,
	  -1,    1,    7,    4,    2,   -1,   -4,    0,    2,   -4,   -5,   -5,   -1,    1,    4,   -5,
	  -4,   -6,   -3,   -2,   -3,    2,   -2,    5,    2,    3,   -4,   -2,   -5,    6,    3,    4,
	   2,   -3,    1,    0,    0,    1,   -3,   -1,    1,    7,    0,    6,   -6,   -7,   -2,   -7,
	   0,   -1,    0,    2,    1,   -2,   -7,   -2,   -5,    0,    2,    0,   -3,   -5,   -1,   -3,
	   0,   -1,    0,   -6,    8,    4,    5,   -1,    1,   -4,    1,    1,    4,    2,    5,    3,
	   6,    0,   -2,   -9,   -4,   -1,    0,    0,    1,   -1,   -4,   -1,   -5,   -5,   -5,    0,
	   0,    1,   -6,   -5,   -9,    0,   -3,    0,   -2,    0,    0,    3,    4,    2,    1,   -7,
	   1,    3,    4,    9,    1,    4,    4,    2,   -4,    2,   -2,    1,    5,   -2,    0,   -3,
	  -4,   -3,   -2,   -4,   -4,   -4,    1,   -1,    2,   -6,   -8,   -3,   -8,   -1,   -2,   -4,
	   5,    2,    3,   -1,    0,   -4,    2,   -1,    5,    5,   -1,    3,    0,    3,    3,    0,
	  -4,    9,    4,    2,   -1,   -6,   -4,   -2,   -2,    2,   -7,    0,    0,   -2,   -2,   -2,
	 -10,   -4,   -7,    0,   -2,    2,   -2,    2,    1,    0,   -3,    0,    1,    6,    3,    2,
	   0,    0,   -1,    2,    3,   -1,    4,   -5,    6,    2,   -3,    0,   -3,    0,    1,    0,
	  -5,   -6,    1,    0,    1,   -5,   -2,  -14,    0,   -4,   -1,   -1,   -1,    1,   -3,    0,
	  -2,   -1,   -4,    4,    5,   -1,    5,   -1,    3,    3,    5,   -3,    5,   -3,    5,    5,
	   6,    4,   -6,    2,   -9,    4,   -4,    0,    1,   -2,   -1,   -8,   -6,  -11,   -2,   -3,
	   3,   -6,   -8,    3,   -5,    1,   -3,    1,   -3,    1,    3,    5,    6,    2,    1,   -6,
	   4,   -1,    1,    0,    7,    7,    2,    3,   -6,   -4,   -4,    3,    3,    0,    1,   -1,
	  -2,   -4,    0,   -8,   -2,   -3,    1,   -2,    1,   -5,   -2,   -1,   -3,   -3,   -4,   -3,
	   7,    4,    1,   -1,   -6,   -5,   -3,    2,    5,    8,    3,    3,    2,    1,   -4,   -1,
	  -2,    6,    3,    2,   -4,   -1,    1,   -5,   -1,   -1,   -5,    2,   -2,    1,   -2,   -7,
	  -5,  -11,   -4,   -3,    3,   -8,    8,    4,   -2,   -2,   -4,   -4,   -1,    4,    3,    5,
	   5,    2,    4,   -1,    6,   -3,    6,    2,    3,    0,   -4,    0,   -2,   -2,    0,   -5,
	  -2,   -1,    4,    3,    1,  -13,   -8,   -8,   -5,   -3,    7,   -2,    3,   -2,   -5,   -3,
	  -8,   -2,   -3,    8,    6,    1,   -2,    5,    3,    1,    2,    0,   -1,    2,    4,    3,
	  -5,    1,   -3,    0,    1,    7,    1,    2,    3,   -1,   -4,   -4,  -10,   -7,    3,    0,
	   2,   -5,   -5,   -4,   -1,   -7,   -3,   -3,    1,    3,    0,    0,   -1,   -6,    6,    1,
	   4,    1,    2,    5,    6,    4,   -1,   -4,   -3,    1,    2,    5,    2,   -1,    1,    3,
	  -8,   -1,  -10,   -2,   -5,    0,   -1,   -6,  -10,   -7,    2,   -2,    6,   -1,   -2,    1,
	   4,   -1,   -5,   -1,   -5,    4,    1,    4,    2,    1,    3,    4,    0,   -2,    1,   -1,
	   3,    8,    2,    1,   -4,   -3,   -3,    3,   -3,   -1,   -4,    0,   -4,   -6,   -2,   -8,
	   1,   -2,    5,   -6,   -5,   -6,    0,    3,    1,   -6,   -3,    1,    2,    4,    2,    4,
	  -2,    3,    3,    3,    1,    5,    1,    2,    3,   -2,   -6,    6,   -1,    6,   -2,    1,
	  -7,   -5,   -2,   -3,   -6,   -6,   -6,   -4,    0,   -2,   -4,   -4,   -3,    0,   -1,    1,
	  -3,   -1,    3,    1,    1,    0,    6,    4,    8,   10,    5,    0,   -3,    1,   -2,    5,
	   2,    1,    1,    1,   -4,   -6,   -8,   -8,   -8,   -5,   -4,   -5,   -4,   -5,    0,   -5,
	  -3,    0,   -7,    0,    4,    1,   -4,   -1,   -4,   -2,    4,    4,    5,    6,    6,    7,
	   0,    0,   -1,    0,    2,    9,    2,    1,   -3,    0,    1,   -3,    1,   -9,   -1,    3,
	  -4,    3,   -6,   -7,   -2,   -1,   -1,   -1,    1,   -9,    2,   -5,    1,   -8,   -6,   -6,
	   1,   -1,    6,    0,    2,    5,    2,    0,    2,    1,    2,    6,    5,   -2,   -1,    0,
	   4,    1,    6,    0,   -2,    1,    0,    3,   -7,   -1,  -13,   -4,   -3,   -3,   -3,   -2,
	  -3,   -5,   -9,  -11,   -2,   -3,    4,    7,   -1,    2,    0,   -2,    8,    5,    1,    4,
	   3,    2,    7,    3,   -2,   -4,    7,    2,    3,   -2,    1,   -1,    2,    0,   -5,   -4,
	  -4,    0,   -4,    0,   -1,  -10,   -9,   -3,   -5,   -8,    1,   -5,    3,   -3,    0,   -7,
	   1,    0,    5,    4,    7,    1,    1,    0,    2,    2,   -2,   -1,    2,    1,    4,    6,
	  -1,    4,    3,   -1,    4,   -2,   -3,    3,   -1,   -2,   -6,   -6,   -7,   -3,   -1,    0,
	  -4,   -6,   -5,   -6,    0,   -3,    3,   -5,    7,    0,   -1,    1,   -3,   -1,    1,    6,
	   3,   -3,    7,    1,   10,    1,    6,   -1,   -2,    5,    2,    1,    1,   -4,   -2,    0,
	  -3,   -7,   -2,   -4,    4,   -8,   -8,   -4,  -10,   -2,    2,   -4,    1,   -5,   -7,   -1,
	   3,   -1,    1,    1,    4,    6,    2,    2,    0,    4,    7,    0,    5,   -2,    0,    3,
	   3,    3,   -3,   -1,   -5,   -2,    0,    3,   -4,   -6,    2,   -1,    0,   -2,   -4,    0,
	  -4,   -3,   -9,   -3,   -4,   -4,    0,    3,   -1,   -4,    3,    1,    5,   -2,    1,    2,
	   2,    4,    5,   -3,    2,    1,    3,    7,    1,   -5,    1,    0,    5,   -3,   -2,   -3,
	  -4,    0,   -3,   -2,   -5,    0,   -8,    3,   -6,   -4,   -6,   -2,    2,   -4,   -2,   -3,
	  -2,    1,    4,    2,    3,   -2,    2,    4,    1,    4,   -2,    3,    2,    1,    1,    7,
	  -1,    2,    4,   -4,    2,   -4,   -2,    5,   -4,    3,   -1,   -3,   -2,    3,   -8,   -4,
	  -6,   -3,   -3,   -1,    0,   -6,   -1,    0,    1,    1,   -2,  -10,   -3,   -1,    0,    2,
	  -5,    1,    1,    2,   10,    8,    2,    8,   -1,   -2,    4,   -5,    2,    2,    7,    6,
	  -6,   -1,   -5,   -4,   -3,   -6,   -7,    0,   -5,   -5,   -1,   -2,   -5,    0,   -4,    6,
	  -6,    0,    3,   -3,    4,    0,   -6,    2,    5,    5,    4,   10,    0,    2,   -3,    3,
	  -2,    0,    3,   -3,    2,   -3,   -8,   -8,   -5,   -1,   -1,   -1,    0,   -5,   -2,    0,
	  -3,   -4,   -1,   -5,   -2,    5,    0,    5,   -4,    4,   -1,   -1,    1,   -3,    3,    9,
	   2,   -1,    1,   -6,   -3,    7,    1,    3,   -2,   -4,    0,   -1,    3,    1,   -3,    4,
	   6,    0,    1,    2,   -3,    0,    0,   -5,  -13,   -4,   -2,    1,    2,   -3,  -10,   -4,
	  -7,    1,   -2,   -2,   -1,    0,    1,    1,   -4,   -1,    2,   -2,    7,    1,   -3,    0,
	   0,    4,    5,    2,    2,   -1,    6,    9,    1,    3,    1,   -5,    5,   -6,   -5,   -2,
	  -4,   -2,    2,   -7,   -4,  -11,   -5,    3,   -3,   -6,   -4,   -6,    3,    3,   -3,    2,
	   0,    1,   -3,   -1,   -2,   -4,    1,   10,    8,   -2,    4,   -3,    6,    6,    1,    0,
	  -7,    2,   -2,    1,    3,   -4,   -4,    4,    1,    0,   -2,   -5,    2,   -2,    0,   -7,
	 -11,   -5,   -2,   -2,    5,   -1,   -8,   -1,   -1,    1,    2,   -2,   -1,    1,    1,    5,
	   0,   -3,    5,    1,    6,    1,   -1,    3,    1,    6,   -3,   -1,   -1,   -3,    4,   12,
	  -1,   -1,    2,   -4,   -1,   -6,   -8,   -7,   -3,   -2,    1,   -9,   -5,   -6,  -10,    5,
	   1,   -2,   -3,   -2,    5,    4,    3,   -1,   -5,    4,    6,    3,    4,    6,   -2,    7,
	   0,   -4,   -1,   -1,    9,    8,    2,    2,   -8,   -3,   -3,    0,   -2,    0,   -4,   -2,
	   0,   -6,   -7,  -14,   -6,   -5,   -1,    3,   -6,   -2,    1,   -3,    0,   -4,   -5,    1,
	   5,    9,    4,    0,    3,    0,    1,   12,    0,    4,    8,    5,    7,   -1,   -4,    0,
	  -3,    5,    4,   -4,    0,   -3,  -13,   -2,  -10,  -14,   -3,   -5,    2,    1,   -3,   -4,
	  -8,   -8,   -3,   -2,   -2,    3,    4,    8,    0,    2,    1,    2,   12,    5,    3,    8,
	   2,    6,    3,   -4,   -4,   -2,   -8,    8,   -5,   -2,   -6,  -10,   -2,   -6,   -4,    0,
	  -4,    2,    5,    1,    0,   -4,   -4,   -1,   -1,   -3,    4,   -7,    4,    3,   -3,    4,
	  -4,   -3,    8,    4,    7,    0,    0,    2,   -1,   -2,   -1,   -2,   -7,   11,   -1,    5,
	  -4,    2,   -2,    0,    2,   -2,   -4,   -2,    1,   -5,    3,   -6,   -9,   -3,   -3,   -2,
	  -5,   -5,   -2,   -6,   -2,   -7,   -8,    1,    3,    5,    9,    4,    4,    0,    5,    8,
	   1,    3,    7,    5,   10,   11,   -7,    3,    0,   -3,    1,   -1,   -7,   -7,   -3,   -2,
	  -6,   -9,   -6,  -12,   -4,   -1,    0,   -8,   -5,   -3,   -3,   -2,    3,    1,    1,    9,
	   4,    2,    5,   -1,    2,    6,    2,    0,   -3,    2,    2,    5,    2,   -1,   -4,    4,
	   1,    1,    2,   -5,   -8,   -1,   -3,   -1,   -9,   -4,    1,   -4,    5,   -6,   -4,    0,
	   3,   -9,    3,   -3,   -5,    1,    4,    4,    1,   -4,    1,   -4,    4,    1,   -6,    0,
	   5,    7,    8,    1,    6,    0,    3,    4,    2,   -3,    1,   -3,   -3,    3,   -9,   -6,
	  -7,   -2,   -1,   -3,   -5,   -6,   -5,   -5,   -6,   -5,    4,   -3,    5,    5,   -2,   -1,
	  -1,   -3,    6,   -2,    5,    6,    2,   11,    8,   -1,    3,   -6,   -2,    5,    4,   -3,
	  -3,   -5,   -3,   -7,   -5,    0,   -5,    2,    1,    0,    1,   -7,    0,   -3,   -2,   -1,
	  -2,   -5,    7,   -4,   -2,   -3,   -2,   -3,    4,    4,    9,    0,    1,    1,   -5,   -3,
	  -4,   -4,    4,    3,    6,    0,   -2,   -2,   -6,    4,    1,    1,   -3,    3,   -1,    2,
	   0,   -7,    0,    0,   -1,   -3,   -2,   -1,   -5,   -2,   -3,   -8,   -5,   -5,   -1,    5,
	   5,    2,    2,   -3,    4,    3,    3,    6,    3,   -1,   10,   -4,   -3,   -2,   -3,    0,
	  -4,    0,   -2,   -2,    0,    1,   -4,   -2,   -5,   -9,    8,   -2,   -1,   -1,   -3,   -3,
	  -2,   -6,    2,    1,    2,    9,    0,    1,    3,   -4,    2,    4,   -6,   -1,    2,   -1,
	   6,    3,    0,   -5,   -3,   -1,    0,    3,   -3,    0,   -6,   -2,   -3,   -4,   -2,    0,
	   3,    2,    2,    0,  -10,    1,   -6,   -5,   -1,   -2,    5,    3,    6,   -2,   -6,   -1,
	  -3,    2,   11,   11,  -28,  -10,   54,  -53,    2,   43,  -37,    0,   43,  -48,    7,   11,
	 -18,   19,  -33,   32,   -1,   -7,   -6,   19,  -21,   23,  -38,    0,   54,  -49,    0,   15,
	  20,  -28,  -20,   53,  -28,  -48,   70,   -6,  -60,   51,    5,  -32,    1,   31,  -10,  -33,
	  24,   33,  -68,   21,   50,  -67,   -1,   57,  -28,  -21,   26,   15,  -48,    9,   33,  -32,
	  -3,   23,  -10,    5,   -4,  -10,   24,  -42,   29,  -13,    0,   26,  -15,  -26,   46,  -17,
	 -38,   45,  -26,    8,   -1,    4,   -5,   -3,   15,  -27,   -2,   39,  -37,  -25,   74,  -33,
	 -25,   16,   24,  -26,  -25,   46,   10,  -74,   50,   33,  -80,   37,   32,  -51,   13,   26,
	 -21,   -5,    0,   18,  -33,   -1,   49,  -29,  -29,   38,    7,  -26,  -20,   45,  -21,  -18,
	  26,   -6,   -6,   17,  -29,   -5,   41,  -38,   10,   19,  -18,   -7,   15,    2,  -24,    1,
	  21,   -6,  -28,   51,  -30,   -7,   10,    6,  -22,   -3,   37,  -32,  -24,   63,  -16,  -60,
	  65,  -10,  -35,   15,   17,  -15,   -8,   -1,   33,  -37,  -10,   55,  -44,   -5,   41,  -35,
	  -9,   20,   -5,  -18,   13,   19,  -27,    2,   34,  -34,   -7,   21,  -27,   27,  -25,   26,
	   5,  -30,   32,  -45,   38,   -3,  -41,   24,   25,  -31,    5,    9,    9,  -37,   13,   31,
	 -36,    7,   20,  -18,  -25,   56,  -50,   13,   17,  -17,   19,  -40,   46,   -3,  -82,   88,
	  -1,  -73,   66,  -10,   -4,  -18,   13,    5,  -27,   14,    7,   -7,  -10,   37,  -39,   11,
	  14,  -38,   35,  -21,    5,   11,  -27,   45,  -37,   -6,   34,  -39,   23,   16,  -51,   51,
	 -11,  -28,   19,   -6,   12,  -29,   12,   26,  -21,  -25,   48,  -35,   -6,   24,   -9,    0,
	 -31,   54,  -19,  -47,   73,  -33,  -43,   81,  -59,   12,   15,  -28,   22,  -26,   33,   -2,
	 -29,   14,   34,  -63,   28,   16,  -40,   31,  -22,   18,    8,  -22,   25,  -31,    6,   26,
	 -54,   33,   19,  -53,   56,  -25,   -9,   24,  -39,   34,  -18,  -15,   35,  -18,  -16,   43,
	 -41,   -3,   47,  -54,    9,   33,  -13,  -24,   -2,   41,  -26,  -35,   73,  -49,    1,   32,
	 -34,   20,  -28,   22,   -5,  -16,   23,   18,  -62,   47,    5,  -57,   51,  -15,   -5,    0,
	   4,   12,  -11,  -15,   29,  -28,    4,   26,  -44,   43,  -19,  -14,   35,  -37,   23,  -15,
	 -11,   45,  -54,   17,   42,  -67,   18,   47,  -58,   17,   25,  -35,   14,   -6,   11,   -3,
	 -42,   73,  -50,  -12,   67,  -68,   28,   -6,   -4,   16,  -44,   47,    8,  -64,   80,  -39,
	 -31,   54,  -43,   14,   -2,   11,  -14,    4,   -3,   19,  -34,    0,   61,  -98,   69,   12,
	 -61,   48,  -35,   28,  -12,  -38,   85,  -86,   42,   25,  -76,   77,  -31,  -37,   39,   -2,
	 -12,    7,  -10,   16,   -1,  -33,   60,  -48,  -16,   70,  -69,   13,   38,  -43,   15,    0,
	   0,   22,  -65,   75,  -28,  -60,   96,  -58,   -8,   32,   -6,    1,  -11,    4,   17,  -46,
	  17,   46,  -86,   66,    9,  -69,   67,  -21,  -30,   33,  -32,   42,  -34,    1,   50,  -74,
	  40,    5,  -34,   21,    7,  -23,   21,  -14,   10,   -1,  -33,   58,  -48,   -3,   65,  -77,
	  14,   51,  -65,   32,  -10,    0,   24,  -58,   71,  -27,  -54,   86,  -56,  -12,   45,  -17,
	 -18,   21,   -1,   -5,  -14,   12,   19,  -75,   78,    1,  -80,   84,  -25,  -33,   48,  -50,
	  45,  -30,  -15,   69,  -86,   46,   22,  -56,   14,   36,  -35,    2,   16,  -11,    4,  -24,
	  41,  -27,  -19,   53,  -42,   -4,   49,  -67,   36,    2,  -26,   37,  -46,   58,  -40,  -26,
	  82,  -70,   -7,   55,  -30,  -20,   36,   -1,  -32,   11,    7,    7,  -41,   39,   18,  -68,
	  65,  -11,  -39,   40,  -34,   30,  -20,  -12,   70,  -98,   53,   27,  -74,   40,   10,  -31,
	  11,   20,  -19,    6,   -6,   12,  -19,   -9,   46,  -36,  -31,   83,  -65,    8,   32,  -48,
	  42,  -45,   49,  -23,  -32,   68,  -59,    5,   39,  -31,   -1,   23,  -20,   -8,   17,   -7,
	 -15,   -1,   16,   25,  -63,   51,   14,  -66,   47,  -10,  -15,    5,   -1,   36,  -72,   54,
	  22,  -86,   64,   -3,  -31,   13,   11,   -8,  -12,   14,   15,  -34,    6,   29,  -24,  -25,
	  62,  -49,   -9,   49,  -56,   45,  -31,   18,    4,  -37,   57,  -41,  -11,   38,  -38,    7,
	  24,  -20,   10,  -13,   20,  -17,   -8,   18,   -4,  -30,   35,   14,  -63,   56,   -7,  -52,
	  50,   -5,   -4,  -19,   17,   36,  -83,   51,   14,  -52,   30,    4,    0,  -15,   14,    8,
	 -43,   32,    3,  -20,    2,   19,  -11,  -20,   45,  -42,   14,    3,   -5,    9,  -31,   43,
	 -20,  -30,   51,  -24,  -19,   47,  -42,   21,  -17,   25,  -24,  -20,   52,  -37,    1,   20,
	  -6,  -21,   25,   -2,  -33,   30,   -9,  -15,   23,  -13,   26,  -49,   29,   22,  -76,   71,
	 -12,  -37,   27,    4,    7,  -41,   30,   10,  -45,   28,   13,  -13,  -21,   31,   -1,  -33,
	  27,    6,  -18,  -10,   24,   -6,  -26,   33,  -10,  -37,   72,  -60,   24,    1,  -13,   15,
	 -36,   52,  -44,   18,   14,  -31,   23,    2,  -16,   -8,   10,   23,  -47,   19,   17,  -10,
	 -17,   10,   29,  -69,   56,   -5,  -38,   47,  -28,   14,  -21,    6,   32,  -55,   33,   12,
	 -39,   24,    5,  -11,  -25,   31,   12,  -47,   35,    9,  -25,    1,    7,    5,  -36,   57,
	 -52,   18,   29,  -45,   37,  -45,   35,  -13,  -17,   41,  -31,    7,    8,  -18,   15,  -19,
	  19,  -22,    2,   33,  -37,   20,   -4,    2,  -25,   27,    0,  -34,   37,  -13,   -6,    3,
	   1,   17,  -46,   28,   32,  -78,   60,   -7,  -25,   18,   -6,   12,  -35,   31,    4,  -38,
	  37,  -11,   -8,  -13,   37,  -22,  -17,   32,  -27,   25,  -34,   24,    9,  -43,   41,  -19,
	  -1,   29,  -48,   29,   -6,   -8,   10,  -11,   27,  -35,   18,    9,  -19,   -7,   12,    4,
	 -27,   30,    2,  -24,   13,    7,  -18,   -1,   16,   11,  -68,   77,  -15,  -45,   43,  -24,
	  29,  -38,   16,   21,  -43,   27,   -7,  -10,   11,    1,   -4,  -13,   26,  -17,   -1,    1,
	  -1,    3,  -19,   34,  -24,  -13,   49,  -51,   22,    3,  -23,   29,  -33,   28,   -7,  -15,
	  31,  -35,    2,   29,  -28,  -11,   27,   -4,  -18,   19,    2,  -31,   26,  -16,   17,  -28,
	  34,   -3,  -49,   64,  -39,    6,    1,   -8,   25,  -38,   32,    4,  -53,   47,    0,  -32,
	  16,   14,   -1,  -37,   31,   -4,   -7,   -8,    9,    7,  -20,   36,  -34,    4,   25,  -39,
	  25,  -13,    4,   12,  -36,   51,  -38,    0,   34,  -51,   27,   13,  -34,   14,   12,   -9,
	 -23,   41,  -21,   -1,  -16,   28,   10,  -62,   66,  -23,  -26,   26,   -9,   13,  -29,   13,
	  31,  -62,   49,    1,  -49,   49,  -18,   -7,    2,   14,  -10,  -19,   20,    5,   -8,  -17,
	  37,  -27,   -5,   23,  -35,   17,   15,  -30,   30,  -20,   28,  -32,   -5,   48,  -64,   29,
	  13,  -37,   35,  -10,   -1,   -7,   -3,   14,  -16,   -9,   26,   -5,  -35,   48,  -21,  -21,
	  40,  -26,  -11,   21,    3,    0,  -42,   47,    8,  -71,   72,  -21,  -21,   25,  -15,    7,
	 -16,   14,   -1,  -24,   18,   32,  -48,   12,   30,  -46,   12,   26,  -45,   36,  -20,   18,
	  -3,  -34,   52,  -40,   -2,   25,  -29,   32,  -11,  -18,   18,   -3,    3,  -24,    7,   36,
	 -40,  -10,   50,  -35,  -19,   47,  -30,   -4,   22,  -17,    8,  -22,   29,    4,  -72,   85,
	 -21,  -48,   57,  -19,   -8,  -10,   17,    5,  -31,   16,   24,  -47,   29,   12,  -31,   14,
	   2,  -27,   43,  -26,    5,   13,  -33,   48,  -46,   -6,   58,  -67,   13,   45,  -50,   26,
	  -6,   -6,   -2,   -9,   24,  -20,   -7,   40,  -37,   -5,   36,  -29,  -17,   38,  -21,    2,
	  -5,    6,   14,  -52,   59,  -11,  -59,   82,  -38,  -22,   32,  -11,   -6,   -4,   11,   14,
	 -38,   30,    5,  -44,   24,   25,  -37,    0,   21,    1,   -9,  -24,   49,  -36,  -12,   47,
	 -49,   20,   34,  -70,   43,    6,  -31,   21,  -20,   24,  -13,  -10,   37,  -35,   -8,   37,
	 -26,  -22,   44,  -20,  -13,   20,   -7,    8,  -28,   36,  -15,  -42,   79,  -41,  -28,   46,
	 -17,   -8,   -5,    5,   29,  -44,   17,   24,  -43,   20,   13,  -42,   16,   37,  -43,    5,
	  22,    4,  -31,    6,   26,  -40,   11,   31,  -45,   24,    9,  -27,   26,  -29,   26,  -13,
	 -16,   38,  -40,   19,   21,  -37,   -9,   51,  -32,  -18,   34,  -11,   -7,  -11,   22,    0,
	 -40,   49,  -20,  -23,   44,  -22,   -9,    3,   -2,   19,  -44,   42,    6,  -52,   41,    6,
	 -43,   20,   28,  -48,   31,    8,  -23,   10,   -7,    7,  -19,    4,   31,  -41,   15,   28,
	 -40,   16,   -8,   16,  -25,   -4,   51,  -55,   19,    0,    8,  -29,   29,  -16,  -11,   37,
	 -39,   18,    4,   -6,   -5,  -14,   35,   -6,  -52,   72,  -37,   -9,   13,   11,  -17,  -22,
	  53,  -32,  -20,   42,  -19,  -18,   12,   19,  -29,   12,   12,  -24,   15,   -6,    6,  -12,
	 -15,   54,  -44,   -2,   41,  -48,   32,  -20,   -4,    9,    1,    5,  -35,   48,  -11,  -17,
	  -9,   24,    1,  -37,   38,   -9,  -16,   16,   -2,  -11,   -1,   13,   11,  -55,   67,  -31,
	 -19,   37,  -26,   -4,   12,   16,  -34,   11,   21,  -22,  -10,   12,    0,    0,  -21,   37,
	 -16,  -11,   29,  -37,   15,   -3,   17,  -37,   13,   38,  -54,   30,   -2,  -19,   11,  -11,
	  20,  -20,   15,    4,  -22,   13,    2,   -8,  -13,   20,    4,  -28,   33,   -9,  -34,   38,
	 -13,   -6,  -14,   46,  -33,   -9,   36,  -34,    4,    8,   -9,   11,   -9,    5,    1,  -17,
	  23,  -16,   -3,    4,   18,  -26,  -11,   54,  -53,    5,   18,   -5,  -11,    8,   11,  -20,
	  12,  -10,    1,    2,    5,   -4,   -5,   -1,   23,  -35,   22,   -1,  -25,   19,    3,   -7,
	 -11,   22,    1,  -37,   45,  -26,  -12,   20,    2,  -23,   17,   13,  -23,   -4,   18,    1,
	 -15,  -15,   33,    4,  -49,   46,  -25,    3,    5,    2,  -11,    7,   13,  -33,   13,   10,
	 -24,   12,    6,   -3,   -4,   12,   -9,  -10,   -3,   20,  -19,   -3,   19,   -2,  -21,   16,
	   5,  -33,   35,  -17,   -3,    2,   17,  -12,  -21,   27,  -17,   -6,   19,   -8,   -6,   14,
	 -12,   10,  -16,   13,    0,  -19,   11,   20,  -23,   -9,   38,  -50,   22,   17,  -24,   -5,
	  17,    7,  -24,    0,   23,  -18,  -14,   27,  -15,    5,    6,   -9,    1,   -2,    7,  -24,
	  16,   10,  -12,   -9,   26,  -19,  -14,   30,  -18,  -13,   19,  -10,   10,   -8,    6,    1,
	 -27,   35,  -13,  -20,   26,   -5,  -11,  -10,   28,   -9,  -32,   36,   -3,  -25,   12,   28,
	 -51,   36,   -6,  -20,   18,   -2,   -3,   -1,  -11,   28,  -31,   -4,   48,  -56,   16,   19,
	 -18,    6,   -4,    1,  -10,   11,    0,   -4,   -6,   25,  -26,   -9,   30,  -26,   -6,   23,
	 -13,   10,   -7,   -3,   19,  -56,   64,  -30,  -31,   50,   -4,  -31,   15,   15,  -27,    6,
	  13,   -6,  -14,   20,   -2,  -27,   23,    7,  -30,   10,   19,  -10,   -1,  -13,   27,  -31,
	   3,   38,  -56,   29,   20,  -45,   24,    5,  -17,    0,    5,    3,   -9,    2,   24,  -25,
	 -14,   31,  -13,  -22,   28,   -6,   -8,    1,    3,   13,  -41,   51,  -39,  -20,   60,  -30,
	 -28,   48,  -14,  -26,   25,  -10,    7,  -17,   16,    5,  -25,   13,   10,  -32,   11,   35,
	 -46,   17,   10,    5,  -32,   10,   21,  -44,   19,   30,  -39,   15,    7,  -18,   11,  -11,
	  10,  -13,    1,   19,  -14,  -12,   30,  -25,  -18,   43,  -23,  -15,   30,  -13,   -6,  -14,
	  43,  -42,   -9,   55,  -36,  -17,   43,  -21,  -11,   12,  -13,   16,  -28,   23,   10,  -38,
	  27,   17,  -47,   22,   20,  -46,   30,   -7,    6,  -10,   -6,   26,  -34,   15,   22,  -39,
	  15,   21,  -43,   26,   -6,    1,  -14,   12,   20,  -26,  -12,   41,  -29,  -29,   57,  -40,
	   2,   27,  -22,    8,  -10,   10,  -10,  -10,   30,  -14,  -29,   47,  -17,  -24,   25,  -11,
	   3,  -17,   30,   -3,  -32,   28,    7,  -44,   35,   12,  -46,   39,   -6,  -10,   -2,   -3,
	  23,  -31,   -4,   49,  -48,    6,   39,  -55,   32,   -8,   -9,    0,    8,    7,  -15,   -3,
	  29,  -26,  -16,   43,  -44,   13,   26,  -30,    9,    6,   -5,    4,  -28,   30,    9,  -56,
	  64,  -19,  -33,   43,  -25,   -8,   14,    8,  -14,   -8,   18,   11,  -44,   23,   17,  -39,
	  20,   19,  -24,   -1,   12,    7,  -27,   -2,   47,  -51,    3,   47,  -55,   28,    1,  -23,
	  17,    4,  -12,    5,   -9,   18,   -9,  -21,   30,  -24,    6,   12,  -11,   -2,   14,  -13,
	  -3,  -10,   26,  -10,  -45,   74,  -31,  -31,   51,  -26,  -14,   19,   -8,    2,   -4,    3,
	  23,  -43,   20,   15,  -31,   13,   20,  -36,   18,    9,  -17,   -3,    0,   21,  -32,   12,
	  32,  -50,   21,   12,  -26,   16,   -6,    5,    1,  -16,   21,   -5,  -27,   28,  -11,  -11,
	  19,   -2,  -20,   28,  -17,   -2,    4,   -5,    9,  -26,   43,  -31,  -11,   47,  -42,    1,
	  19,  -16,    5,   -8,   12,    9,  -41,   41,   -7,  -32,   22,   25,  -51,   23,   14,  -18,
	   7,  -21,   31,  -22,   -2,   24,  -24,    6,   18,  -39,   25,   -9,    3,    5,  -17,   28,
	 -13,  -17,   27,  -21,  -12,   25,  -12,  -12,   32,  -19,   -6,   11,  -24,   29,  -21,   11,
	  -2,  -17,   36,  -29,   -9,   24,  -16,   -2,    7,   -6,   17,  -27,   27,  -20,  -11,   23,
	  -1,  -31,   25,   15,  -32,   12,   -8,   21,  -22,   -8,   26,  -16,  -15,   47,  -45,    8,
	  12,  -12,   14,  -28,   33,  -10,  -15,   15,  -11,    6,    2,  -17,    5,   23,  -20,   -5,
	  19,  -21,   12,   -8,   -8,   31,  -38,   31,  -17,  -14,   31,  -27,   -1,   19,  -20,   19,
	 -10,    4,   -2,   -7,    2,    1,   -6,    6,   12,  -27,   12,    8,  -10,   -7,    8,   -1,
	  -3,  -15,   47,  -53,   15,   25,  -40,   24,   -7,   12,  -13,  -11,   22,   -7,  -22,   14,
	   7,   -5,  -11,   13,    5,   -8,   -9,    4,    7,  -22,   22,  -12,   16,   -9,  -16,   29,
	 -32,    8,   23,  -36,   14,    7,   -3,    5,  -27,   24,   -1,  -20,   14,    7,   -7,   -4,
	   9,  -21,    6,   23,  -27,    7,   -1,   23,  -30,   -3,   31,  -39,   26,  -17,   -3,   30,
	 -24,    9,   -7,  -13,   30,  -24,    3,    2,    9,   -6,  -15,   24,  -18,    9,  -20,   16,
	   2,   -8,   11,  -11,    6,  -10,    6,   11,  -38,   27,   20,  -42,   28,  -26,   35,  -21,
	 -29,   51,  -32,    8,   -3,   15,  -19,    3,   14,  -33,   24,    4,   -9,   -9,    4,   23,
	 -29,    0,   21,  -32,   39,  -38,   20,    8,  -34,   38,  -27,    8,   12,  -12,    3,   -8,
	  11,  -11,    1,    3,   -9,   18,  -18,   10,    0,   -7,    4,  -13,   17,  -13,    0,   33,
	 -56,   42,  -11,   -7,    7,  -17,   36,  -50,   24,   21,  -25,   -7,   14,    9,  -27,    8,
	  23,  -28,    3,    8,    2,  -12,  -10,   39,  -43,   24,   -4,   -5,   18,  -38,   39,  -26,
	  -8,   26,  -24,   14,   10,  -20,    5,   -9,   15,  -19,   13,  -12,    5,   24,  -39,   24,
	  -8,    8,  -16,  -14,   53,  -49,   16,    5,  -22,   26,  -28,   18,  -13,    7,   18,  -31,
	   6,   17,  -12,  -13,    3,   26,  -35,   16,   18,  -36,   21,  -12,   28,  -49,   27,   22,
	 -38,   13,   -1,   17,  -28,   -5,   30,  -22,    2,   25,  -42,   32,  -19,   18,  -23,   -1,
	  21,  -20,   22,  -31,   25,    3,  -25,    9,   -6,   27,  -29,   -3,   32,  -35,   19,   -7,
	  -8,   11,  -12,   28,  -35,    1,   39,  -33,   -6,    2,   30,  -35,   -1,   41,  -42,   18,
	  -9,    6,   -8,   -2,   26,  -46,   24,   24,  -41,   11,   11,   -2,  -12,   -9,   48,  -59,
	  31,  -10,    6,  -12,   -5,   34,  -43,   33,  -12,   -7,   11,  -11,    1,    7,  -12,   17,
	 -23,   32,  -24,   -5,   19,  -26,   27,  -28,   24,  -15,   -5,   31,  -41,   11,   11,   -4,
	 -19,   10,   37,  -53,    2,   43,  -35,    2,   -3,   20,  -20,    3,   32,  -53,   30,    5,
	 -24,   10,   -7,   41,  -53,   10,   33,  -31,   -8,   11,   12,  -30,   28,    4,  -37,   28,
	   8,  -30,   12,  -17,   42,  -38,    5,   24,  -33,   35,  -41,   23,   -1,   -4,    5,  -20,
	  32,  -18,  -10,   25,  -22,   -4,   14,    6,  -24,   -5,   62,  -80,   28,   19,  -20,    4,
	 -14,   41,  -49,   14,   34,  -45,    3,   13,   17,  -37,   -4,   66,  -61,   -5,   35,  -15,
	  -5,   -2,   14,  -24,   21,    5,  -41,   41,  -22,   18,  -24,    5,   44,  -66,   34,   -3,
	 -17,   24,  -26,   20,  -13,   14,   -1,  -31,   39,  -19,  -20,   31,  -14,    0,  -12,   46,
	 -61,   29,   19,  -44,   36,  -26,   30,  -31,   -7,   49,  -41,  -15,   54,  -42,   -1,   12,
	  24,  -48,    8,   44,  -57,   17,   13,    7,  -34,   13,   33,  -55,   28,    4,  -14,    4,
	  -9,   32,  -42,   15,   28,  -58,   40,  -12,    0,    7,   -8,    8,  -24,   29,   -9,  -29,
	  38,  -23,    9,   -8,   13,   -7,  -14,   24,  -37,   32,   -7,    3,  -17,    1,   39,  -46,
	 -20,   78,  -68,   15,   17,   -6,   -4,  -15,   37,  -47,   15,   20,  -17,  -12,   28,    9,
	 -52,   25,   31,  -54,   24,    4,   -1,  -11,   -5,   51,  -74,   36,    9,  -27,   17,   -6,
	   8,  -12,    3,    6,  -16,   14,    0,  -15,   10,    3,    7,  -31,   34,  -22,   -2,   17,
	 -20,    9,   10,   -7,  -13,   -5,   45,  -52,    8,   30,  -33,   15,  -11,   28,  -32,   -5,
	  44,  -42,   -4,   42,  -25,  -29,   29,   14,  -36,   12,   19,  -20,    8,  -14,   33,  -42,
	  16,   23,  -48,   32,    2,  -14,    2,   -1,   14,  -21,   -9,   42,  -47,   24,    0,  -10,
	   0,   15,  -19,   -1,   21,  -31,   13,   15,  -23,   10,  -14,   20,   -7,  -27,   50,  -32,
	  -5,   18,  -10,   -1,   -8,   25,  -36,   12,   34,  -45,    6,   27,  -20,  -16,   12,   19,
	 -22,    0,   12,    0,  -13,   -8,   31,  -41,   17,   16,  -29,   17,   11,  -19,   -4,   -2,
	  36,  -55,   30,   13,  -35,   25,   -7,   -8,   10,   -4,   -8,   13,   -7,    0,    4,  -16,
	   8,   13,  -35,   40,  -25,   -6,   44,  -51,   17,   15,  -18,   -3,    1,   14,  -18,   -1,
	  24,  -23,   -9,   20,   -6,   -9,    1,   24,  -30,    6,    6,   10,  -29,    8,   31,  -48,
	  21,   27,  -43,   13,    4,   -4,   -5,   -2,   19,  -18,   12,  -15,    4,   16,  -25,    9,
	   1,    2,    0,  -13,   12,    3,  -16,   -3,   18,  -10,   -6,   25,  -41,   21,   11,  -30,
	  20,   -3,    0,    1,  -14,   27,  -19,  -21,   38,  -28,    9,   -3,   14,  -22,   13,   -4,
	  -2,   -6,   12,    2,  -26,   30,   -1,  -38,   31,    7,  -32,   25,  -16,   14,   -4,   -9,
	  15,  -19,    6,    4,  -11,    2,   11,   -8,   -4,   10,   -7,   -4,    6,  -10,    2,   11,
	  -9,    0,   -5,   15,  -16,    0,    9,   -2,   -7,    0,   11,  -11,  -12,   35,  -44,   20,
	  13,  -19,    2,   13,  -11,  -14,   12,   10,  -22,   -2,   27,  -24,   -2,   15,    5,  -29,
	  22,  -10,    6,   -2,   -3,   16,  -31,   20,   11,  -39,   29,    9,  -34,   25,  -10,    5,
	  -2,  -15,   14,    0,   -5,   -6,   19,  -18,   13,  -22,    5,   24,  -30,   -1,   35,  -23,
	 -12,   12,   12,  -26,    5,   22,  -32,   16,   16,  -27,    2,   10,   -4,  -12,    2,   23,
	 -19,   -1,    1,   11,  -17,    4,    8,  -18,   12,   12,  -24,    1,   24,  -20,  -15,   29,
	  -5,  -31,   42,  -23,   -8,   20,  -18,   19,  -33,   24,    8,  -22,    0,   32,  -38,    9,
	  21,  -25,    2,   23,  -30,    7,   16,  -20,   12,  -10,    8,  -14,   12,   16,  -41,   24,
	  14,  -30,    6,    2,   19,  -22,   -6,   25,   -8,  -24,   23,   -1,  -29,   32,    9,  -53,
	  50,    4,  -42,   12,   12,    3,  -24,   15,   14,  -25,    5,    4,    7,  -25,   26,   -5,
	 -23,   28,    0,  -32,   23,   -1,  -21,   14,   10,   -7,  -13,   21,  -25,   16,   -8,    1,
	  -1,   -1,   13,  -22,   12,   12,  -28,    3,   13,    1,  -15,   -3,   38,  -41,   -5,   45,
	 -37,   -9,   30,   -4,  -35,   42,  -10,  -25,   19,   -4,    3,  -18,   12,   22,  -43,   25,
	  14,  -37,   21,    4,  -19,    5,   17,  -12,  -17,   26,   -4,  -22,   11,    7,    6,  -31,
	  35,  -15,  -14,   22,  -14,    0,    0,   14,  -16,  -12,   31,  -17,  -19,   25,  -10,    0,
	   2,   12,  -23,    8,   16,  -44,   37,    0,  -19,   -2,   21,   -5,  -25,   22,   12,  -38,
	   3,   37,  -11,  -38,   36,   11,  -54,   40,   -9,  -11,   14,  -11,   11,  -19,   17,   17,
	 -47,   16,   25,  -17,  -23,   34,   -3,  -29,   25,  -17,    5,   14,  -17,    3,   -4,   21,
	 -23,  -11,   35,  -31,    7,   13,  -17,   13,   -6,    6,  -22,   13,    5,   -8,   -8,   16,
	   8,  -34,   18,   21,  -49,   32,   12,  -45,   32,    0,    1,  -32,   27,    2,  -20,   10,
	   6,    3,  -26,   18,   19,  -50,   31,   13,  -40,   20,   12,   -7,  -19,   21,   -9,  -12,
	  24,  -21,    6,    7,   -6,   -2,   -9,   23,  -19,   -8,   15,   -7,   18,  -26,   13,    5,
	 -21,   21,  -19,    4,   25,  -26,  -14,   32,   -2,  -33,   21,    8,  -29,   38,  -35,   17,
	   8,  -19,   15,  -29,   24,   15,  -40,   10,   28,  -21,  -26,   34,    7,  -42,   35,   -3,
	 -14,   -1,   18,   -6,  -30,   29,   -1,  -11,    8,   -8,   16,  -22,   -2,   25,  -27,   14,
	   0,   -9,    1,    9,    1,  -25,   22,  -16,   12,    8,  -33,   32,    2,  -35,   19,    4,
	   0,  -17,   15,    1,   -6,    9,  -15,   16,  -30,   25,    8,  -46,   40,   11,  -39,    8,
	  11,    2,  -21,   10,   11,  -17,   15,   -6,   -4,  -10,   18,   -6,  -23,   29,   -2,   -7,
	 -13,    9,   24,  -48,   23,   17,  -30,   27,  -22,    9,    4,  -16,    8,    4,   -9,   -2,
	  19,  -12,  -12,   21,  -22,   15,   -8,   -2,   20,  -39,   32,   -5,  -16,   11,    5,  -15,
	  -8,   30,   -5,  -36,   34,   -5,  -13,    1,    3,   22,  -37,   14,    6,   -8,    0,   -6,
	  11,  -17,   23,   -6,  -18,   19,   -7,   -4,  -14,   11,   17,  -32,   24,   -6,   -2,    9,
	 -26,   30,  -24,    2,   18,  -19,    7,    4,   -6,   -3,   -1,    3,    1,    0,  -21,   39,
	 -20,  -33,   51,  -27,   -6,   24,  -18,    8,  -10,   12,   -3,  -23,   25,  -11,    5,  -19,
	  25,    2,  -34,   29,   -5,   -9,   -7,   18,  -12,  -18,   30,   -4,  -26,   20,   -9,   22,
	 -32,    7,   26,  -28,    6,   -9,   19,  -20,    5,    2,   -9,   26,  -15,  -13,   18,  -19,
	  15,   -3,  -26,   34,    2,  -33,    6,   36,  -36,  -12,   36,  -32,   29,  -24,   10,   13,
	 -39,   30,   -6,  -17,   12,    9,   -9,  -17,   28,   -6,  -27,   21,    4,  -15,    6,   13,
	 -13,  -16,   30,  -21,    1,   -4,    4,   28,  -60,   46,   -3,  -21,    3,    5,   -8,   17,
	 -17,    3,   11,   -6,   -9,   11,   -8,  -17,   44,  -36,    0,   20,   -9,   -4,  -13,   29,
	 -24,    5,   -3,    6,   14,  -36,   26,   -3,  -23,   30,   -3,  -30,   25,    3,  -12,  -22,
	  42,  -13,  -27,   19,    9,   -3,  -20,   16,   -7,   -3,    7,   -5,    6,  -13,   22,  -21,
	 -15,   39,  -17,  -21,   30,  -23,   19,   -6,  -20,   31,  -24,    0,    8,   12,  -31,   20,
	   8,  -27,   20,  -14,   20,  -22,   -2,   17,    0,  -18,   11,    0,    7,  -28,   22,   -2,
	 -19,   31,  -17,   -8,   -2,   28,  -24,  -16,   34,   -4,  -28,    9,   26,  -12,  -30,   29,
	  -7,   -6,   10,   -1,  -10,    5,   -3,    6,  -23,   29,  -18,   10,  -16,    7,   28,  -48,
	  21,    4,  -12,    9,    4,  -12,    5,   -1,   -7,    2,    0,   -3,   11,  -15,   -3,   26,
	 -19,   -4,    3,    1,   10,  -37,   49,  -26,   -9,    6,   18,  -23,    0,   17,   -3,  -27,
	  25,    3,  -22,   10,    6,   -3,  -19,   32,  -23,    9,   -3,   -3,   11,  -31,   27,   12,
	 -42,   23,   13,  -12,  -18,   30,  -10,  -19,   13,   -4,    0,   17,  -25,   12,   -2,   -2,
	   4,   -8,    9,  -12,    8,  -17,   24,   -2,  -19,   14,  -16,   18,   -6,  -12,   22,  -12,
	 -17,   20,    0,   -4,  -13,   19,   -5,  -18,   30,  -19,    8,  -17,   19,   -9,   -6,    8,
	   1,    1,  -36,   48,   -9,  -40,   46,    1,  -50,   44,   -5,  -14,   -3,   10,    4,  -17,
	  11,   -1,   11,  -25,    9,   10,  -24,   19,    2,   -9,   -4,    4,   10,  -26,   20,   -8,
	   6,   -3,  -12,   17,    7,  -31,   18,  -14,   17,   -7,    0,    2,   -8,    9,  -15,   19,
	 -16,    8,    2,  -22,   21,   15,  -33,    4,   24,  -20,  -13,   36,  -18,  -24,   33,  -16,
	  -8,   20,  -19,   22,  -32,   21,    0,   -5,   -7,   18,  -17,  -11,   26,   -5,  -25,   25,
	   3,  -17,   -3,   15,    7,  -35,   22,   -3,    2,   -2,   -6,    7,   -3,   -4,    4,  -13,
	  25,  -17,    1,   -4,    7,  -12,   13,   -2,  -11,   12,    2,  -25,   24,    0,  -25,   17,
	  -4,    6,   -9,   14,  -11,   -8,    5,    0,   10,  -25,   23,    1,  -28,   27,    5,  -26,
	   0,   23,  -11,  -20,   21,   10,  -30,   12,    9,   -5,  -16,   25,  -12,  -19,   26,   -3,
	 -12,    1,    9,   -1,  -15,   11,    3,  -12,    6,   -5,   11,   -7,   -8,    6,    3,  -11,
	   4,    5,    0,  -11,    7,   -1,    6,  -17,    1,   26,  -35,   14,    6,   -6,   -8,   15,
	  -7,   -9,   13,   -2,  -20,   19,    6,  -11,  -14,   24,    7,  -36,   19,   11,  -24,    1,
	  23,  -18,   -4,   18,  -10,  -19,   29,  -10,   -9,   -1,    6,   10,  -23,   10,   19,  -32,
	  11,   11,   -4,  -13,    5,   12,  -17,    3,   13,  -20,   11,    0,   -8,    5,   14,  -32,
	  19,    1,  -22,   28,  -16,   -8,   13,    3,    0,  -11,  -10,   38,  -40,    3,   22,   -9,
	 -16,   19,   -4,  -13,   13,    9,  -29,    9,   16,   -9,  -20,   25,   -2,  -22,   11,    6,
	   4,  -22,   12,   16,  -35,   15,   26,  -42,   13,   12,   -5,  -20,   24,   -4,  -18,   20,
	  -7,  -11,    9,    5,   -7,    1,   -2,   -2,   10,  -18,    9,   11,  -17,   -2,    7,   -5,
	  28,  -48,   12,   31,  -36,   12,    8,   -2,  -14,    8,    2,   -5,   -1,   11,  -17,   -4,
	  21,   -1,  -27,   19,    3,  -13,    0,    8,   15,  -39,   19,   17,  -43,   34,    4,  -32,
	  16,    8,  -10,   -8,   21,  -10,  -12,    6,    9,   -4,  -10,    3,    9,  -13,    8,    2,
	  -7,    1,    1,    2,  -18,   22,  -10,    2,    5,  -19,   19,   -4,  -11,   11,   -5,    2,
	 -13,    7,   15,  -24,    9,   11,  -20,   -2,   21,    1,  -38,   21,    9,   -2,  -22,   23,
	   6,  -41,   34,   -2,  -19,   27,  -10,  -23,   20,   -3,   13,  -34,   20,   10,  -15,   -3,
	  14,   -1,  -19,    3,    4,    5,    8,  -14,    9,  -18,   18,   -1,  -22,   24,   -8,   -8,
	  10,  -10,   14,  -12,   -4,    6,  -14,   30,  -38,   28,   -5,  -23,   19,    4,  -10,   -9,
	  22,   -7,  -22,   17,    8,   -5,  -19,   25,   -9,  -23,   31,   -6,  -26,   31,  -20,   18,
	 -29,   22,   20,  -54,   33,   -4,    1,   -3,    4,   -8,    0,   -5,   13,   -6,   -6,    9,
	  -1,  -24,   36,   -9,  -26,   30,  -24,   11,    8,  -23,   22,  -16,    5,  -11,   20,   -2,
	 -26,   23,   -9,   -3,    0,    9,  -10,   -6,   13,   -3,  -17,   25,  -12,   -2,   -8,   16,
	   4,  -35,   39,  -14,   -9,   -2,   23,   -6,  -37,   40,  -12,  -11,    4,    8,    1,  -13,
	   1,   17,  -26,   12,   10,  -27,   17,    4,   -6,  -18,   42,  -32,    2,    4,  -16,   36,
	 -31,    0,   10,    0,   -1,  -12,   15,    0,  -28,   22,   -3,   -1,    6,   -6,   -9,   -3,
	  25,  -18,   -8,    7,    6,    5,  -39,   48,  -16,  -23,   22,   -2,   -8,    1,   18,  -25,
	  -9,   25,    1,  -28,   16,    9,    0,  -34,   37,   -4,  -27,   27,  -18,   -1,    6,    4,
	  -5,   -8,   16,   -9,   10,  -21,    6,   12,  -14,   -4,    6,    9,    3,  -31,   33,  -14,
	 -12,   23,  -28,   25,  -10,    2,  -11,    1,   11,    6,  -30,    3,   40,  -21,  -34,   46,
	 -12,  -22,   11,    6,   -2,  -10,   14,  -10,  -21,   49,  -29,  -16,   17,    9,  -15,  -13,
	  32,  -19,    0,    0,    8,    0,  -14,    8,   -4,  -16,   30,  -17,    2,   -1,    0,    9,
	 -15,    6,   -4,   11,  -15,   -6,   28,  -28,   17,  -18,    7,   11,  -19,   12,    3,  -24,
	  21,    3,  -29,   15,   26,  -25,  -27,   51,  -18,  -19,    7,   20,  -21,  -11,   36,  -32,
	  -3,   35,  -27,   -4,    6,    8,    2,  -31,   18,   18,  -29,    1,   25,  -16,   -8,   19,
	 -30,   13,   16,  -20,    8,  -12,   19,   -3,  -21,   15,    0,   -6,   -3,    4,    6,    1,
	 -20,    2,   20,   -5,  -27,   31,   -7,  -21,   19,    6,  -19,  -10,   40,  -28,  -17,   40,
	 -15,  -22,   12,   13,  -23,    6,   14,  -12,   -7,   10,   11,  -11,  -30,   45,   -9,  -44,
	  48,   -5,  -14,   -5,   20,  -22,    9,    3,  -10,    0,    4,    4,   -7,   -9,   24,  -23,
	   3,    8,  -15,   15,   -2,  -19,   21,   -8,   -6,   -1,   14,   -7,  -12,   18,  -10,   -3,
	   3,   21,  -37,    2,   29,  -23,   -7,   22,  -10,   -2,   -7,   20,  -10,  -20,   15,    5,
	 -25,   17,   23,  -29,  -16,   50,  -35,   -9,   19,    4,  -22,    2,   24,  -19,  -10,   25,
	  -9,  -22,   23,    3,  -15,   -6,   10,   -4,   13,  -29,   17,   13,  -26,   -2,   25,  -23,
	  14,  -16,   12,   -2,   -2,    4,  -11,    1,   11,    0,  -22,   14,   18,  -28,   -6,   11,
	  22,  -29,  -10,   42,  -30,  -12,   26,  -12,  -15,   19,   15,  -41,   10,   33,  -16,  -32,
	  20,   29,  -47,   10,   36,  -35,   -1,   20,  -19,    1,    9,    5,  -14,  -16,   15,   29,
	 -38,   -6,   35,  -16,  -20,   18,    6,   -9,   -7,    1,    4,    6,   -4,    0,   -9,    2,
	   8,    2,  -14,   -4,   24,  -12,  -32,   41,   -1,  -26,    1,   23,  -22,    4,   11,  -10,
	  -6,    8,   16,  -28,  -12,   52,  -28,  -40,   53,    2,  -29,    2,   17,  -10,   -5,   -2,
	   8,   -1,  -13,   25,  -10,  -33,   51,  -16,  -32,   12,   29,  -27,  -11,   25,    7,  -27,
	   4,   12,    0,  -15,    5,   -2,    4,  -11,   11,   21,  -51,   15,   37,  -46,    7,   24,
	  -9,  -20,    2,   27,  -11,  -17,    4,   22,  -40,   26,   16,  -36,    2,   35,  -32,   -2,
	  12,   14,  -23,  -17,   26,   10,  -26,    3,   20,  -20,   -9,   28,  -16,   -9,   19,   -4,
	 -21,   15,   12,  -17,  -15,   24,   -7,   -6,    5,   -2,   10,  -21,    4,   12,   -9,  -11,
	  30,  -12,  -32,   38,    3,  -33,   11,   11,    0,  -24,    4,   44,  -37,  -18,   36,   -8,
	 -25,   21,    5,  -24,   10,   -1,   18,  -22,   -2,   30,  -38,   -8,   41,  -24,   -3,    4,
	   8,   -6,  -11,   20,  -11,  -20,   22,   -2,    2,   -8,    8,  -12,    8,  -17,   11,   18,
	 -34,   19,   -4,    5,   -3,   -9,    5,   -6,    6,   -4,   -6,   17,   -5,  -11,    2,   12,
	  -8,  -16,   15,    3,  -21,   13,    8,   -7,   -8,   12,   -5,   -5,  -17,   33,   -1,  -44,
	  35,   15,  -42,   18,   15,  -21,    4,   -4,   10,   -5,  -14,   27,  -21,   -7,   19,    1,
	  -3,   -8,   -6,    9,   -1,  -23,   29,  -13,   -1,   -2,    4,    8,   -6,  -20,   26,  -22,
	   5,   21,  -25,    9,    3,  -11,   16,  -12,   -4,   20,  -20,   -8,   25,  -13,   -5,    6,
	 -11,   13,    6,  -30,   13,   24,  -31,  -11,   27,    9,  -43,   28,    2,   -3,   -5,   -4,
	  13,  -16,   -1,   10,   -8,   -4,   11,    8,  -23,   14,    0,   -4,  -10,    1,   14,  -14,
	   3,    2,   -3,   20,  -35,   26,   -6,  -25,   38,  -32,   12,  -10,   16,  -10,   14,  -24,
	   9,   33,  -83,   72,  -13,  -27,   28,  -26,   25,  -13,    8,  -25,   18,   15,  -29,   17,
	  -3,    9,  -25,    2,   19,  -20,   18,  -20,   13,    4,  -18,   32,  -32,  -10,   35,  -18,
	 -12,   16,   10,  -15,   -5,    4,   13,  -21,    1,    0,   14,  -18,    9,   12,  -26,   27,
	 -27,    9,    1,   -4,   -1,    1,   14,  -33,   52,  -49,   -1,   46,  -50,   21,   -5,   12,
	  -9,   -7,    6,    1,   -2,  -10,   14,   -2,  -10,   13,  -19,   23,  -26,   18,   -2,  -22,
	  34,  -30,    8,   20,  -38,   14,   18,  -18,   -5,    9,    3,   -6,  -13,   24,   -1,  -28,
	  12,   11,  -14,   -1,   21,  -37,   31,  -16,    5,    6,  -26,   32,  -23,    4,    2,    9,
	   2,  -40,   40,   -7,  -10,    2,    0,    9,  -16,   -1,   16,   -3,  -10,   -3,   19,  -22,
	   6,    7,   -9,   -4,  -10,   39,  -38,    5,   27,  -28,    0,   13,   -8,    1,   -3,    5,
	  -3,   -9,   13,   -8,   -4,   13,  -14,   -6,   22,  -14,  -13,   31,  -30,   22,  -15,  -15,
	  55,  -56,    6,   26,  -23,    8,    1,    4,  -17,    8,    6,   -9,    9,  -11,   15,  -18,
	   5,   14,  -18,    9,  -22,   26,   -2,  -23,   25,  -11,    1,  -16,   15,   12,  -28,   -4,
	  35,  -31,   -3,   28,   -8,  -12,   -8,   26,  -21,   -1,    3,   -2,   12,  -18,   18,   -3,
	  -6,   -9,   14,  -23,    9,   36,  -57,   29,   21,  -50,   29,   -2,  -13,    7,    0,   -5,
	   6,   -1,   -4,   10,  -25,   23,   -3,  -19,   28,  -20,   11,  -17,   -5,   37,  -39,   19,
	  -7,    1,    7,  -17,   12,   14,  -36,    6,   23,  -23,    9,   12,  -19,    4,    2,    2,
	   6,  -27,   14,   17,  -39,   14,   34,  -22,  -31,   34,    6,  -36,   28,   -1,  -28,   24,
	   1,  -18,   24,  -20,    9,   -2,  -15,   21,   -4,  -23,   23,  -10,   -4,   15,  -12,    3,
	  -6,    2,   10,  -28,   28,   -6,  -15,   14,  -14,   10,    1,  -18,   14,    5,  -19,   15,
	   2,  -18,   22,  -17,   -7,   29,  -43,   45,  -15,  -40,   62,  -27,  -23,   23,   10,  -20,
	 -20,   41,   -7,  -20,    9,   10,  -22,    8,    5,    9,  -21,    0,   22,  -11,  -18,   27,
	  -4,  -34,   30,    3,   -9,   -2,    1,    4,  -13,    6,   16,  -25,   11,  -11,    8,    1,
	 -11,   14,   -4,   -6,    4,    1,   -2,   -7,    1,   -3,   11,  -31,   57,  -36,  -10,   37,
	 -44,   22,   -2,  -10,    4,   -1,    7,   -2,   -7,    7,   14,  -33,    5,   24,  -29,    7,
	  10,   -1,  -13,    0,   26,  -23,  -16,   43,  -32,  -14,   23,   11,  -23,   -5,   13,   13,
	 -44,   44,   -7,  -18,    7,   -7,   12,  -12,   -1,   -1,    7,    0,   -6,   26,  -37,   17,
	  -6,    4,  -19,   18,   13,  -37,   24,    4,   -7,    0,  -13,   15,    3,  -28,   22,   14,
	 -41,   27,    5,  -28,   38,  -30,    9,   -6,   -1,   18,  -28,    8,   26,  -36,    4,   21,
	  -3,  -30,   28,   -6,    1,  -26,   45,  -28,  -15,   34,  -15,  -12,    6,    8,    1,   -9,
	 -16,   26,    1,  -50,   65,  -34,  -12,   25,   -9,    4,  -14,   21,  -17,   -2,   -6,   10,
	  17,  -29,   -6,   40,  -23,  -20,   27,    0,  -40,   44,  -27,   16,   -6,    2,    3,  -20,
	  15,   15,  -32,   -1,   28,   -9,  -29,   38,  -22,   14,  -21,   16,   -5,   -6,   17,  -35,
	  20,   13,  -19,    0,    2,    2,   16,  -32,    0,   47,  -61,   16,   31,  -37,   21,   -8,
	   6,   -7,    3,   -6,    8,   -9,  -12,   29,  -13,  -20,   33,  -16,    0,  -21,   46,  -39,
	   2,   17,   -3,  -11,   -6,   18,    2,  -35,   29,   17,  -37,    0,   42,  -42,    9,   -3,
	  16,  -19,   -2,   24,  -17,   -2,    0,   -1,    6,  -12,   19,  -12,  -16,   27,   -2,  -27,
	  16,   17,  -42,   38,  -22,    8,    2,  -12,   -1,   15,  -18,   13,   -6,  -11,    7,   21,
	 -36,   26,  -23,   38,  -48,   15,   26,  -20,  -18,   24,   -1,   -4,  -20,   34,  -16,  -17,
	  18,   11,  -30,   15,    7,  -10,  -10,   12,   15,  -31,   -1,   28,   -6,  -32,   30,    4,
	 -24,    1,   28,  -28,    7,  -11,   33,  -39,   23,  -15,   19,  -12,  -12,   11,    4,  -25,
	  33,  -22,   14,   -4,   -3,   -6,   10,  -21,   31,  -40,   19,   13,  -10,   -1,   14,  -18,
	  -3,   10,   -4,   -5,   -2,   10,   -6,  -14,   21,   14,  -40,   15,    6,    3,  -31,   28,
	  12,  -42,   11,   43,  -44,    2,   27,  -17,  -18,   22,  -16,   33,  -59,   37,   15,  -35,
	  11,   20,  -22,    1,   -7,   22,  -22,    7,   -1,    9,  -16,   -4,   20,    3,  -38,   31,
	   9,  -31,   -3,   39,  -34,    8,    4,  -19,   41,  -41,   11,   21,  -40,   19,   18,  -47,
	  45,  -14,   -5,  -13,   26,   -4,  -28,   19,   15,  -45,   38,   -4,   -9,   -4,   17,  -29,
	  28,  -27,   34,  -25,  -20,   39,    5,  -52,   49,  -15,  -13,    5,   -3,   14,   -2,  -20,
	  17,   -3,  -12,   18,   -7,   -9,    1,   10,    7,  -31,   19,   13,  -29,   12,  -22,   52,
	 -30,  -28,   40,    7,  -60,   56,  -19,   -5,   -5,   22,  -26,   13,    1,    5,  -28,   30,
	 -12,    3,  -17,   25,  -26,   16,  -16,   20,   -5,  -14,   26,  -19,  -33,   67,  -47,    2,
	  20,  -19,   21,  -22,   12,   12,  -25,    0,   17,  -26,   24,   -4,  -15,    6,    9,   -8,
	  13,  -28,   24,  -15,   13,  -27,   26,    3,  -11,  -31,   61,  -31,  -19,   24,    5,  -33,
	  22,   -3,   14,  -35,   22,   10,  -28,    8,   23,  -24,   -2,    1,   18,  -18,   -8,   26,
	 -15,  -12,   26,  -31,   15,   10,  -24,   18,  -19,   35,  -32,   -1,   15,    7,  -40,   36,
	 -14,   -4,   16,  -12,  -22,   51,  -54,   41,  -31,   14,    4,  -17,    5,   13,  -24,   29,
	 -31,   12,   25,  -34,   -2,   30,  -36,   21,  -16,   22,   -4,  -36,   42,  -11,   -6,  -12,
	  31,  -16,  -29,   34,    6,  -29,   -4,   37,  -23,  -25,   51,  -34,    9,  -11,   23,  -25,
	  14,   -8,    5,  -20,   32,  -22,    6,   14,  -16,   -3,   24,  -49,   51,  -46,   31,   -4,
	 -21,   26,  -13,    0,    7,   -9,   -2,   -1,    8,  -21,   22,  -21,   29,  -29,   10,   22,
	 -41,   37,  -24,   -7,   15,    3,  -25,   26,    1,  -15,    5,    2,   14,  -33,   -3,   54,
	 -69,   27,   13,    5,  -37,   27,    4,   -6,  -19,   19,   -3,   -9,    2,   10,  -11,   15,
	 -30,   38,  -35,   20,    0,  -29,   37,  -16,    1,  -14,   21,  -12,   -7,   22,  -33,   30,
	 -19,    4,   -7,   -1,   31,  -57,   46,  -15,   -8,   20,  -21,   -1,   18,  -21,   17,  -12,
	   6,    7,  -20,    2,   32,  -57,   46,   -7,  -25,   12,   25,  -32,   -3,   18,    1,  -12,
	 -15,   31,    4,  -56,   52,  -11,   -6,  -20,   23,   19,  -50,   37,   -7,   -9,   -1,   14,
	 -22,   10,   14,  -36,   37,  -18,   -8,   25,  -31,   20,  -16,   21,  -26,   10,    7,  -15,
	   9,    3,  -14,   19,  -25,   24,  -15,   -4,   -4,   27,  -37,   21,    7,  -12,    1,   -5,
	   4,    5,  -12,   -4,   10,  -12,   17,  -10,  -16,   52,  -56,    5,   29,  -12,   -5,  -28,
	  56,  -30,  -19,   34,   -3,  -30,   20,    4,  -21,   12,    9,  -17,   21,  -35,   43,  -19,
	 -20,   21,   -4,  -13,   12,  -10,    9,    0,   -6,   -4,   10,  -19,   25,  -23,    6,   -3,
	  10,   -5,  -15,   31,  -12,  -14,   -4,   22,  -15,   -5,    1,   17,  -17,   -8,   28,  -15,
	  -8,    6,  -10,    2,    7,    8,  -31,   25,    3,  -20,   -2,   26,  -10,  -22,   12,   20,
	 -25,    6,  -11,   33,  -36,   -2,   43,  -36,   -8,   20,   -9,   -7,    2,    4,    5,   -7,
	  -5,   24,  -28,   11,    6,  -24,   20,   -7,   -2,    6,   -9,   -1,   20,  -35,   13,   27,
	 -31,   -7,   31,  -13,  -12,   -6,   27,  -14,  -24,   33,   -6,  -10,   15,  -14,    6,  -13,
	   9,    0,   -8,   -1,   19,  -20,    6,   10,   -9,  -15,   23,  -20,   -4,   31,  -24,    2,
	 -13,   23,    1,  -25,   14,   12,  -16,  -18,   25,    4,  -25,   15,   -3,    2,    6,  -16,
	  21,  -12,  -19,   19,    1,  -18,   21,    1,  -30,   25,    3,  -15,   -5,    6,   18,  -34,
	   4,   32,  -13,  -18,    1,   28,  -21,  -30,   44,   -1,  -41,   28,   16,  -32,    9,   14,
	 -17,    6,  -11,    5,   21,  -43,   38,  -11,  -24,   39,  -15,  -18,   18,   -3,  -15,    0,
	  20,  -15,    2,   -1,   -6,   32,  -43,   13,   19,  -26,   -3,   17,   10,  -29,   19,    1,
	 -19,   22,  -13,    7,  -16,   10,    8,  -17,   -1,   12,    1,  -18,    1,   40,  -49,    6,
	  34,  -35,   -8,   30,   -2,  -23,    4,   15,   12,  -39,    2,   55,  -57,   -8,   47,  -27,
	  -7,   18,   -7,    2,  -11,    0,   19,  -21,    4,    2,   10,  -32,   34,  -16,  -12,   20,
	 -12,    2,   -4,   20,  -12,  -22,   22,  -14,    9,  -12,    6,   21,  -24,   -7,   27,  -13,
	 -22,   13,   16,  -38,   37,   -2,  -21,   19,  -14,    2,   -6,    6,    7,  -16,  -11,   44,
	 -22,  -35,   52,  -10,  -41,   24,   16,  -13,  -19,   14,   21,  -20,  -29,   55,  -20,  -21,
	   5,   28,  -30,   -3,   22,   -6,  -10,    5,   11,  -11,   -7,   15,  -11,   -4,  -10,   18,
	   1,  -23,   24,    3,  -24,   10,    5,    0,  -32,   35,   -7,  -12,    1,   11,   18,  -53,
	  36,    7,  -26,    0,   24,  -27,    0,   26,  -24,    6,    6,  -13,   16,  -21,   13,    1,
	 -25,   20,   26,  -61,   40,   21,  -41,   -6,   28,    1,  -24,   -7,   38,  -14,  -25,   20,
	   5,  -16,   -1,    6,   13,  -20,   -7,   39,  -33,   -8,   25,  -14,    5,  -20,   26,    2,
	 -28,   14,   14,  -18,  -23,   64,  -60,   11,   24,   -9,  -13,   -2,   17,   -5,  -25,   16,
	  22,  -13,  -44,   61,  -14,  -38,   35,   -7,  -18,   28,  -16,  -10,   25,   -9,  -20,    8,
	   6,    8,  -23,   11,   19,  -27,   -1,   15,    0,  -25,   18,    8,    2,  -34,   38,    1,
	 -41,   23,   -7,   13,   -6,  -19,   45,  -20,  -27,   24,   14,  -61,   53,  -13,  -13,   21,
	 -21,   36,  -25,  -33,   58,  -33,  -26,   35,   19,  -50,    7,   50,  -35,  -20,   28,    5,
	 -29,   -1,   28,  -20,    3,  -10,   20,   -8,  -16,   35,  -22,  -13,   17,  -10,   -3,   15,
	 -25,   24,   -7,    0,   -8,   -3,   29,  -32,   -7,   30,  -16,    9,  -29,   24,   10,  -27,
	  -9,   49,  -40,    4,   14,  -28,   37,  -29,  -18,   68,  -67,   12,   45,  -48,    3,   31,
	 -21,  -16,    9,   20,   -3,  -40,   38,   17,  -65,   41,    8,  -15,   -9,   -2,   46,  -51,
	  -7,   64,  -51,  -31,   57,  -21,    5,  -10,   -7,   35,  -36,    0,   20,  -20,   14,  -16,
	  10,    9,   -1,  -26,   26,  -18,   -3,    5,   14,   -8,  -17,   32,  -25,    1,   17,  -29,
	  17,   17,  -47,   50,  -19,  -12,    9,   -1,  -11,   17,  -29,   44,  -25,  -36,   63,  -32,
	 -18,   29,   -7,    9,  -38,   32,   14,  -50,   21,   37,  -57,   13,   37,  -17,  -16,   -9,
	  28,   -6,  -60,   76,  -13,  -34,   29,    1,   -5,    9,  -41,   35,   -2,  -48,   52,   -5,
	  -3,  -17,   14,    5,  -12,  -13,   24,  -20,    7,   -4,   10,    2,  -13,   10,   -2,  -18,
	  20,    2,  -33,   37,  -18,   -9,   25,  -21,   14,  -15,    9,   -2,  -14,   15,   10,  -44,
	  37,    7,  -36,   15,   18,   -9,  -21,    2,   45,  -53,    3,   47,  -48,    3,   25,  -17,
	  14,  -24,   -2,   53,  -72,   22,   38,  -32,  -13,   22,  -15,   30,  -36,    6,   27,  -30,
	  -4,   21,   -3,  -20,    8,   13,   -3,  -29,   43,  -10,  -41,   33,  -14,   20,  -22,    9,
	  13,  -14,  -10,   25,  -30,   14,    6,  -29,   29,    2,  -23,    4,   14,  -15,   -3,   13,
	  11,  -29,   21,   -1,  -25,   13,    5,    1,   -9,  -18,   58,  -31,  -44,   56,    7,  -69,
	  46,  -10,   11,   -3,  -27,   41,    1,  -58,   46,    7,  -33,   14,  -14,   30,  -22,  -24,
	  77,  -66,    6,    6,   27,  -36,   -2,   21,   10,  -62,   57,   11,  -46,   23,    7,   -8,
	 -18,   24,  -21,   17,  -35,   40,   -4,  -31,   36,  -13,  -10,    0,   -2,    2,    0,    2,
	 -14,   18,   22,  -53,   11,   43,  -45,  -13,   39,   -7,  -12,   -6,   22,   -8,  -27,   19,
	  15,  -35,   13,   21,  -30,   26,  -35,   40,  -17,  -11,   -5,   33,  -25,   -4,   -9,   32,
	 -10,  -44,   65,  -23,  -18,    0,   28,  -31,   17,  -23,   45,  -50,   11,   52,  -68,   13,
	  23,  -10,  -32,   41,  -13,    4,  -13,    5,    9,  -11,    4,   -8,    6,   12,  -25,    4,
	  24,  -20,  -15,   11,   30,  -42,    5,   30,   -7,  -40,   27,   17,  -27,   -5,   14,   16,
	 -26,   -9,   39,  -23,  -11,   17,  -16,   30,  -52,   43,   -9,   -4,  -28,   31,    4,  -15,
	 -15,   34,    6,  -69,   65,   -3,  -40,    6,   42,  -40,    8,   11,   18,  -29,  -28,   62,
	 -40,  -17,   31,    2,  -22,   20,  -13,   16,  -18,    0,   -6,   12,   -4,  -10,   17,    0,
	  -6,  -25,   44,  -25,   -6,    0,   24,  -13,  -33,   43,    1,  -46,   36,    3,    0,  -34,
	  38,  -11,  -14,    5,  -11,   30,  -19,    3,  -12,   45,  -56,   -3,   41,  -20,  -21,   17,
	  22,  -18,  -15,   14,   37,  -92,   53,   25,  -48,   -2,   57,  -44,   -4,    3,   35,  -31,
	 -32,   59,  -24,  -17,    9,   28,  -39,   22,  -10,    9,   -7,    0,    7,  -29,   33,  -16,
	 -17,   37,  -24,  -17,   43,  -14,  -28,   18,   18,  -33,    5,    4,   21,  -34,   13,    4,
	  -6,    7,  -15,   14,   -8,   11,  -17,   -1,   15,    0,  -42,   58,  -18,  -35,   37,   14,
	 -47,    9,   27,  -14,  -33,   20,   58,  -79,   11,   49,  -18,  -55,   58,   -6,  -29,    6,
	  12,   16,  -55,   61,  -29,  -20,   37,  -15,   -1,    9,  -26,   22,    3,  -25,    0,   31,
	 -18,   -1,  -12,   40,  -11,  -64,   62,  -11,  -23,    3,   32,  -11,  -18,   19,    5,  -36,
	  15,   11,  -21,    6,   18,  -16,    5,   16,  -35,   14,   -2,   19,  -53,   45,   31,  -81,
	  31,   46,  -51,  -14,   44,  -13,  -23,  -11,   67,  -62,   -3,   50,  -23,  -26,   24,   16,
	 -34,   -2,    3,   27,  -33,    1,   38,  -35,   13,    0,  -24,   50,  -59,   11,   31,  -20,
	  -6,   10,   20,  -28,  -15,   38,   -2,  -60,   43,   32,  -68,   24,   47,  -54,    9,    3,
	  23,  -46,   11,   36,  -56,   34,   -2,  -20,   12,   24,  -36,    9,    7,   18,  -45,   11,
	  45,  -50,  -10,   42,    4,  -63,   62,  -10,  -22,   -9,   26,    8,  -52,   41,   14,  -54,
	  41,   -9,   -8,   12,  -26,   33,  -25,    6,    3,  -14,   20,  -28,   -2,   50,  -23,  -51,
	  64,   11,  -86,   57,   17,  -39,   -5,   19,   41,  -79,   33,   43,  -64,    2,   40,  -21,
	  -7,   -6,   38,  -37,   -8,   43,  -39,    5,   16,    3,  -49,   67,  -38,  -20,   39,  -20,
	  10,  -24,   43,  -15,  -47,   57,  -13,  -53,   59,  -16,    8,  -27,   35,   -4,  -36,   35,
	 -29,   13,   -5,    5,  -13,   32,   -5,  -48,   57,  -29,  -15,   30,  -26,   23,  -34,   33,
	  25,  -79,   54,   25,  -70,   16,   33,   -1,  -60,   37,   52,  -76,    7,   54,  -22,  -61,
	  76,  -23,  -30,   30,  -15,   14,  -21,   24,   -4,  -20,   23,    0,  -49,   63,  -31,  -12,
	  28,  -15,    9,  -17,   26,  -25,   -1,    4,   15,  -31,   22,    8,  -23,   18,   -8,   -7,
	   6,   -1,    7,  -12,   -1,   32,  -62,   42,   14,  -59,   41,   13,  -31,   -5,   40,  -14,
	 -49,   36,   38,  -64,    1,   68,  -54,  -29,   61,  -16,  -29,    8,   37,  -22,  -33,   42,
	  18,  -75,   47,    6,  -25,   26,  -33,   42,  -32,    1,    4,    3,   -2,    5,  -20,   27,
	   4,  -43,   33,    2,  -27,    6,   26,  -25,    8,    2,   19,  -46,   26,   15,  -56,   44,
	  12,  -34,   -4,   43,  -34,   -1,    2,   27,  -40,   -3,   52,  -64,   26,   21,  -30,   -3,
	  30,    1,  -37,   13,   27,  -28,  -31,   49,    4,  -63,   61,    2,  -23,  -10,   22,    7,
	 -53,   17,   43,  -51,   21,   15,  -26,   37,  -31,   -4,    9,    0,  -28,   28,    4,  -10,
	  -5,   21,    2,  -40,   32,    9,  -50,   20,   43,  -63,   32,   -6,   13,  -24,   -4,   62,
	 -87,   46,   12,  -27,  -14,   25,   13,  -44,   25,   24,  -29,   -8,   13,   18,  -56,   46,
	   6,  -51,   55,  -19,  -10,   -4,   17,    3,  -52,   60,   -3,  -49,   41,  -14,    0,   -4,
	  -3,   17,   -9,   -9,    1,   18,  -11,  -17,    3,   17,   -5,  -23,   15,   42,  -83,   51,
	  -1,  -17,    6,  -16,   57,  -83,   48,   16,  -46,   10,   24,   -8,  -32,   32,   15,  -49,
	  26,   19,  -24,  -22,   40,   20,  -80,   64,  -11,  -24,   14,  -11,   17,  -18,   18,   -5,
	 -21,   45,  -36,  -11,   24,  -16,    5,  -10,   32,  -13,  -17,   24,  -15,   -4,   -8,    9,
	   0,  -16,   33,  -36,   36,   -7,  -39,   46,  -35,   33,  -61,   51,   10,  -63,   50,   11,
	 -34,   -5,   39,   -8,  -46,   41,    6,  -45,   22,   14,   -4,  -41,   74,  -33,  -44,   57,
	 -19,  -20,  -12,   42,   -4,  -37,   30,   18,  -31,    0,   -1,   10,  -16,    3,    8,    1,
	   9,  -31,   21,   -2,  -11,   -1,    3,   24,  -40,   15,   31,  -52,   20,   -1,   13,  -32,
	  31,    6,  -44,   41,  -17,  -18,   21,   18,  -32,  -10,   41,   -2,  -60,   42,    9,  -25,
	  -9,   38,  -10,  -29,   40,  -27,   -7,   14,    8,  -20,   -2,   26,  -11,  -35,   42,   -2,
	 -36,   28,   -1,    3,  -33,   39,   -7,  -24,    9,    4,    4,  -10,    7,   -2,    0,   15,
	 -52,   45,    4,  -38,   14,   29,  -20,  -23,   39,   -1,  -38,   13,   23,  -26,   -1,   12,
	   2,  -30,   41,  -10,  -30,   36,   -3,  -22,   -6,   35,  -20,  -32,   27,   22,  -41,   19,
	  23,  -18,  -18,   22,   -5,  -34,   39,  -19,    5,   -3,   29,  -26,  -21,   47,  -38,  -23,
	  38,   -4,  -15,    6,   19,  -12,   -4,    6,  -14,   17,  -14,  -11,   22,    3,  -20,  -13,
	  38,   -2,  -52,   43,   16,  -30,  -19,   37,    1,  -51,   47,    2,  -23,   -1,   22,  -10,
	 -24,   17,   21,  -62,   51,   11,  -38,   19,    8,   -3,  -50,   61,  -18,  -15,    4,   16,
	  -9,  -15,   29,  -32,   -2,   37,  -43,    9,   35,  -36,   13,  -16,   28,  -28,   -5,   41,
	 -35,   -3,   12,   15,  -29,    2,   19,  -20,   19,  -21,    7,   18,  -20,    1,  -24,   47,
	 -17,  -45,   54,   10,  -43,    0,   37,   -3,  -63,   58,    4,  -55,   43,   -2,   -6,  -31,
	  50,  -35,  -10,   37,  -12,  -17,    1,   29,  -34,   -5,   31,  -19,  -10,   29,  -26,   32,
	 -44,   25,   -5,  -27,   43,  -45,   33,   12,  -29,   -6,   38,  -18,  -34,   23,   18,  -21,
	 -12,   17,   27,  -52,   18,   32,  -49,   42,  -19,  -24,   40,  -26,   -7,    0,   32,  -12,
	 -44,   69,  -18,  -46,   21,   26,  -41,   -5,   49,  -24,   -8,   22,    0,  -23,  -17,   32,
	  -6,  -42,   64,  -40,   17,    0,    3,  -11,  -28,   63,  -61,   13,   26,  -12,   -7,    4,
	  -5,    8,   -2,   -5,  -14,   18,   13,  -38,    6,   36,   -7,  -71,   86,  -10,  -56,   45,
	 -11,   -2,  -18,    9,   26,  -38,   24,    1,  -24,   41,  -35,  -10,   24,   -1,  -24,   10,
	  25,  -15,  -20,   10,   36,  -44,  -32,   96,  -69,   -8,   44,  -32,   12,  -20,   33,  -33,
	  11,   24,  -24,  -15,   40,  -23,  -27,   20,   18,  -19,   -4,   28,  -23,    9,   -9,    4,
	 -19,   32,  -27,  -15,   59,  -37,  -17,   28,    2,  -20,  -12,   28,   20,  -68,   46,    2,
	 -24,    3,    6,   16,  -28,   17,    8,  -21,    1,    6,  -21,   15,   34,  -68,   43,   41,
	 -81,   31,   10,   -5,  -28,    1,   51,  -37,  -21,   64,  -40,  -23,   44,  -25,  -12,   15,
	   7,  -21,   14,    0,    6,  -29,   29,    7,  -39,   30,  -10,    0,   -4,   -5,   13,    8,
	 -24,   23,  -28,   38,  -27,  -34,   50,   -5,  -33,   10,   55,  -47,  -22,   43,   -3,  -45,
	  11,   38,  -37,   15,   16,  -25,   24,  -22,   -4,    0,    4,   14,  -41,   33,   35,  -67,
	  13,   52,  -57,    0,   25,   -4,   -7,  -11,   18,    5,  -37,   32,    2,  -39,   54,  -24,
	 -18,   13,   16,  -27,   -2,    7,   31,  -52,   29,   17,  -41,   38,  -23,  -15,   28,   -4,
	 -28,   40,  -13,  -20,    8,   13,    0,  -40,   37,   20,  -53,   14,   39,  -34,  -21,   27,
	  14,  -28,   12,   14,  -23,    7,    3,  -28,   24,    6,  -23,   10,    9,   20,  -39,  -12,
	  61,  -39,  -44,   74,  -24,  -25,   21,   13,  -31,   10,   11,   -3,  -21,   19,    7,  -43,
	  46,  -26,   -2,   22,  -16,    0,   13,  -16,   10,   -9,  -20,   33,  -30,   29,   -2,  -29,
	  44,   -8,  -62,   54,   13,  -50,    8,   34,    7,  -43,    9,   41,  -34,  -39,   54,   -6,
	 -28,    9,   20,  -16,   -6,   25,  -30,   -6,   45,  -51,    4,   36,  -21,  -22,   28,    4,
	 -25,   18,    6,   -5,  -33,   37,   -9,  -19,   14,    8,   -5,   -4,    5,   -1,  -13,    0,
	  16,  -46,   49,   -5,  -25,   30,   -8,  -16,   15,  -17,   -4,   24,  -26,   14,   -8,   16,
	   3,  -40,   16,   47,  -78,   21,   65,  -53,  -20,   24,   26,  -55,    6,   55,  -47,   -6,
	  35,   -4,  -28,   14,    1,  -19,   15,   -9,   20,  -22,   19,   -6,  -31,   32,    7,  -36,
	  14,   20,  -18,   -7,    9,    9,  -27,   22,  -15,    8,    9,  -15,    2,   -2,    9,  -19,
	  11,    5,   11,  -38,   38,   -4,  -35,   23,   17,  -48,   34,   15,  -51,   41,   -2,  -11,
	 -30,   35,   20,  -65,   33,   34,  -37,  -23,   48,   -2,  -48,   21,   19,  -12,  -34,   42,
	   8,  -49,   33,   10,  -27,   25,  -15,   -6,    9,  -11,    7,  -14,   22,   -7,  -11,   18,
	   4,  -18,  -12,   30,  -40,   14,   16,  -11,   -2,   30,  -36,    4,   20,  -19,  -25,   21,
	  17,  -39,   38,  -11,   13,  -32,   19,   13,  -49,   41,   -2,  -25,    8,   24,  -23,  -16,
	  41,   -9,  -44,   34,   28,  -48,  -15,   59,  -22,  -54,   64,   -6,  -10,  -20,   29,    4,
	 -56,   42,    7,  -31,   20,    0,   -5,    9,   -3,  -27,   33,  -15,  -18,   25,    5,  -21,
	  10,   -6,   -4,    1,    5,   14,  -42,   47,  -10,  -14,  -15,   30,   -6,  -53,   64,   -4,
	 -33,   13,   27,  -34,  -16,   37,   -4,  -42,   38,   11,  -35,   11,   17,  -10,  -33,   55,
	 -35,   -6,   14,   20,  -35,  -11,   63,  -52,  -17,   55,  -22,  -23,   19,   -2,    0,   -5,
	 -10,   21,   -5,  -14,   12,    1,  -10,    6,  -15,   11,   13,  -37,   43,  -14,  -17,   11,
	  10,  -13,  -28,   43,  -15,  -25,   35,   11,  -45,   20,   25,  -34,  -21,   51,  -16,  -42,
	  35,   18,  -23,  -32,   75,  -47,  -18,   34,   -1,  -28,    1,   34,  -40,   16,   23,  -26,
	   4,   18,  -22,   -4,   -7,   18,   -8,  -25,   41,    0,  -24,   13,    9,  -30,   14,   -4,
	 -14,   30,  -18,    5,    9,  -12,   -3,   -8,   25,  -22,  -18,   50,  -18,  -43,   48,    0,
	 -39,   11,   27,  -14,  -26,   42,  -10,  -33,    4,   61,  -72,    7,   58,  -40,  -22,   28,
	  24,  -62,   19,   31,  -22,  -23,   41,  -13,  -16,    5,   11,  -13,   -4,   23,  -21,    4,
	   7,   -8,  -20,   33,  -19,  -10,   26,   -7,  -13,    2,   18,  -21,  -10,   28,  -20,  -15,
	  54,  -36,  -26,   56,  -30,  -32,   42,   -5,  -21,    1,   40,  -26,  -19,   29,    7,  -59,
	  34,   24,  -43,   20,    3,   12,  -36,   23,   23,  -48,   -1,   61,  -49,  -25,   62,  -27,
	 -23,   19,   13,  -17,    4,    0,    9,  -29,   19,   -5,   -7,   13,   -9,   17,   -7,    0,
	 -14,   11,   -5,  -17,    2,   35,  -29,  -10,   45,  -27,  -21,   31,   -9,  -17,   12,    5,
	 -10,  -12,   26,    0,  -37,   34,    6,  -36,   18,    8,   -2,  -42,   39,   16,  -47,   25,
	  37,  -57,    1,   51,  -59,   13,   19,  -10,  -10,   11,   11,   -8,  -32,   42,  -19,  -36,
	  59,  -26,    1,   -7,   17,  -14,   -2,   -1,   -2,    5,   -5,    4,    0,   15,  -25,   -3,
	  30,  -28,  -15,   36,  -13,   -5,  -13,   26,    2,  -45,   41,    2,  -38,   21,   20,  -29,
	 -11,   46,  -27,  -35,   46,    3,  -38,   20,   25,  -48,   19,   18,  -26,    5,    3,   10,
	 -17,  -13,   46,  -29,  -27,   52,  -40,   18,   -6,    9,  -14,   -8,   21,  -11,  -11,   16,
	  14,  -42,   33,    5,  -31,   14,    0,  -14,   19,   -9,   11,   -5,    2,    2,  -39,   58,
	 -35,  -26,   47,   -1,  -40,   19,   32,  -36,  -14,   37,   -2,  -40,   18,   32,  -47,   -6,
	  49,  -34,   -7,   36,  -16,  -15,    2,   22,  -36,   -5,   53,  -56,   27,    6,    2,  -13,
	  -8,   28,  -40,    4,   22,   -2,  -33,   46,  -14,  -36,   51,  -10,  -47,   40,   -2,  -18,
	   3,   11,   13,  -50,   57,  -33,   -5,   30,  -31,   -4,   19,   -3,  -17,   20,   -2,   -8,
	 -16,   34,   -6,  -45,   30,   35,  -73,   21,   55,  -52,    3,   11,   19,  -42,   -2,   55,
	 -57,   13,   23,  -11,  -16,   12,   16,  -45,   25,    9,  -22,   -2,   37,  -23,  -29,   49,
	 -24,  -27,   46,  -23,   -8,   22,  -14,    6,  -26,   45,  -42,   -9,   41,  -15,  -12,   11,
	  13,  -25,   -1,   10,    9,  -42,   37,   -2,  -20,   17,   14,  -41,   25,   17,  -52,   45,
	 -14,    1,  -23,   21,   30,  -74,   44,   35,  -53,   -4,   42,  -18,  -36,   30,    9,  -26,
	  17,   15,  -18,  -12,   37,  -32,  -25,   48,  -27,   -6,   20,   -8,   12,  -32,   38,  -22,
	 -17,   36,  -18,  -13,   15,    7,  -22,   14,   -3,    5,  -21,   33,  -18,  -18,   17,   12,
	 -31,   10,   34,  -51,   33,  -12,   15,  -23,    1,   19,  -50,   51,   -7,  -41,   47,   11,
	 -56,   20,   30,  -23,  -34,   37,   17,  -29,  -14,   54,  -25,  -45,   50,  -16,  -17,   11,
	  14,   -2,  -30,   44,  -16,  -32,   39,  -18,  -16,   26,   -5,  -22,   25,   -7,    1,  -18,
	  27,   -8,  -21,   23,    0,  -30,   16,   27,  -54,   46,   -1,  -24,   -9,   28,    8,  -62,
	  48,    6,  -31,   13,   17,  -25,   17,  -16,   -1,    9,    2,    0,  -15,   12,   19,  -42,
	  -2,   57,  -56,   -2,   47,  -11,  -40,   21,   38,  -56,  -22,   71,  -26,  -41,   52,    3,
	 -29,   14,   -1,   -7,  -20,   29,   -3,  -34,   41,   -1,  -35,   26,   12,  -38,   25,   -6,
	  -4,    7,   -9,    6,  -14,   31,  -24,   -7,   24,    3,  -47,   33,    9,  -28,   -7,   23,
	  18,  -44,   22,   29,  -48,    1,   46,  -52,   14,   21,  -21,   -9,   26,    3,  -41,   20,
	  34,  -52,  -14,   75,  -39,  -40,   53,    0,  -35,    6,   29,  -15,  -36,   44,    0,  -39,
	  36,  -15,  -11,   25,   -9,   -8,    6,    0,    1,  -30,   29,   -1,  -17,   12,   20,  -34,
	  17,    4,  -35,   29,   -4,  -10,   -8,   35,    0,  -45,   34,   18,  -77,   45,   22,  -29,
	  -9,   24,   14,  -50,   29,   15,  -34,   -1,   47,  -52,    3,   58,  -54,  -12,   40,   -7,
	 -28,   10,   33,  -22,  -50,   79,  -24,  -38,   25,   10,   -5,  -30,   27,   16,  -42,   15,
	  14,  -19,   11,    6,  -33,   35,    2,  -46,   49,  -20,   -7,   13,   -4,    0,  -12,   14,
	   3,  -50,   58,   -8,  -44,   40,   17,  -22,  -41,   60,  -13,  -48,   25,   50,  -62,   -3,
	  71,  -55,  -12,   23,    3,  -20,   -1,   13,   20,  -50,   48,  -27,  -23,   57,  -43,   -5,
	   8,   30,  -34,  -16,   51,  -18,  -42,   35,   19,  -40,   23,    0,  -35,   39,  -23,    0,
	  21,  -24,   16,   -6,    2,   14,  -53,   43,    1,  -46,   51,   -2,  -19,    3,   25,  -32,
	 -11,   24,   -1,  -34,   25,   42,  -74,   29,   42,  -41,  -34,   56,   -3,  -32,  -26,   84,
	 -35,  -72,  101,  -39,  -13,    5,   24,  -31,   -2,   21,  -25,    2,   22,    0,  -37,   43,
	   2,  -41,   23,   -6,   -9,    9,   -7,   24,  -19,   -8,   24,  -33,   31,  -11,  -37,   57,
	 -25,  -22,   35,   -2,  -29,    2,   26,   -1,  -39,   20,   51,  -72,   14,   45,  -45,  -17,
	  49,  -30,  -12,   24,   25,  -48,  -23,  107,  -96,  -10,   61,   -7,  -47,   22,   34,  -35,
	 -13,   21,   17,  -55,   40,   12,  -43,   23,    6,  -21,   19,  -10,   -4,   10,    3,   -2,
	 -35,   38,   -7,  -29,   31,    1,  -15,   15,  -11,    5,   -8,   -3,   10,  -30,   40,   10,
	 -62,   43,   30,  -80,   22,   59,  -63,   -6,   42,    4,  -35,   -2,   67,  -87,   21,   44,
	 -44,   -6,   34,   -6,  -39,   26,   28,  -26,  -47,   87,  -25,  -74,   69,   15,  -63,   22,
	  19,    3,  -13,  -14,   36,  -30,    1,    5,   -9,    9,    3,  -14,   29,   -9,  -25,   14,
	   6,   -6,  -38,   54,  -12,  -38,   46,   14,  -70,   48,   19,  -68,   37,   25,  -27,  -25,
	  29,   39,  -81,   27,   50,  -53,  -12,   44,   -4,  -46,   23,   27,  -32,  -24,   67,  -34,
	 -36,   65,  -33,  -31,   52,  -22,  -23,   21,    8,   18,  -61,   46,   14,  -59,   26,   31,
	 -49,   24,   11,  -27,   30,  -29,    8,   -7,   20,  -20,   -4,   11,    0,   -1,    0,   -1,
	   0,   -1,    1,   -2,    2,   -1,   -4,   -2,    1,   19,   -2,  -20,    3,  -10,  -11,   12,
	   3,  -10,   -3,   25,   -4,    1,    6,    4,  -12,   10,    2,   -4,  -28,  -11,    9,    2,
	   1,   18,   -9,  -20,   12,   11,   10,    1,   -5,    5,  -15,    4,    7,  -27,   -3,    4,
	  -8,   38,  -31,  -15,    7,   13,  -34,   37,   -6,  -19,   -6,   20,   41,  -31,  -20,   28,
	 -13,   30,   -4,    0,  -23,   -1,    0,  -13,   21,    3,  -32,   19,   30,  -52,   18,  -24,
	 -27,   31,  -14,    4,    1,  -16,   14,   12,  -20,   32,   14,  -41,   37,   -6,   -5,    1,
	  27,  -34,   42,    9,    2,  -34,   20,  -25,   11,   15,  -10,  -14,  -19,  -24,    5,  -12,
	   3,  -17,    2,   46,  -13,  -15,   31,  -23,  -16,   21,   25,   -6,  -36,   10,    1,   26,
	 -18,  -12,    1,   21,   -8,   17,  -16,  -29,  -39,   17,   -5,   -1,   -4,   -6,  -18,   33,
	 -21,   24,  -17,   31,    0,    4,    0,    6,  -26,   18,   24,   46,    5,   19,  -10,   11,
	  25,  -13,   10,   50,  -50,  -52,   21,  -23,  -29,   -8,   34,  -35,  -39,   15,  -16,  -43,
	  -5,  -29,   29,   -1,   -8,  -30,   18,    5,  -14,   52,   12,   -4,  -28,   19,   25,   25,
	  16,  -44,   53,  -20,   49,  -23,   25,  -32,    1,  -63,   50,   37,  -52,  -13,   13,    4,
	 -18,   22,  -56,    7,   23,  -46,   -7,   39,  -69,  -15,   26,   28,   21,    9,  -64,   55,
	  23,  -34,   46,  -26,   -9,   36,  -31,    4,    5,   37,  -58,   28,   49,  -25,   20,   -1,
	 -12,  -25,   -6,   12,    9,  -23,  -34,    0,   -2,   14,    3,   -4,  -13,   25,   23,  -11,
	   1,  -34,    6,    9,   30,  -36,  -19,   11,  -16,   14,   76,  -97,   33,   25,  -50,    8,
	  25,  -35,   20,  -20,    4,  -27,   63,  -73,   25,   35,  -22,    7,  -33,   13,    2,    6,
	  -3,    5,    1,   17,    1,  -36,   40,   -4,   10,  -28,   -9,   14,  -16,    5,   20,  -32,
	 -45,   59,  -10,   26,  -29,  -10,  -13,  -32,   44,  -74,   81,  -51,  -12,   66,  -11,  -33,
	  17,   38,   12,   57,  -39,    5,   39,    9,   -4,    4,    0,   25,  -50,   24,  -19,   -1,
	 -30,  -21,   24,  -46,  -20,  -35,   19,  -10,    1,  -45,   -7,   29,   -8,  -70,   51,   -4,
	 -51,   42,   20,   21,   21,  -24,    7,   69,    1,   17,   10,    9,    8,   16,   -8,   66,
	 -32,  -13,  -24,   30,   50,  -86,  -15,   34,  -23,  -56,  -26,    7,   22,  -45,   23,  -41,
	  50,  -84,  -19,   50,    0,    2,  -20,  -31,   49,  -12,   -8,   12,   63,  -20,  -23,   57,
	 -37,   85,  -57,  -29,   83,  -11,  -15,  -29,   25,  -44,   33,  -51,   74,  -56,   63,  -99,
	  72,   15,  -40,  -41,  -29,   68,  -66,   46,   12,   21,  -65,    5,   62,  -24,  -24,  -15,
	   7,  -25,    7,   -4,  -16,   47,   13,  -38,    3,   55,  -31,  -40,   31,   -1,  -35,   22,
	   4,   34,   -6,   -1,  -12,    6,   75,  -51,   12,   57,  -19,  -24,   -5,   12,  -10,   26,
	 -13,   10,  -44,   25,  -13,  -26,   39,  -42,  -25,  -65,   36,  -55,  -41,  -12,    2,    8,
	  22,   22,  -24,  -27,   51,  -38,   36,    1,  -14,   -8,   88,    2,   15,   28,    6,   46,
	   8,   32,  -22,   37,  -29,   10,    3,  -36,    9,   -9,    2,    6,  -15,  -79,   32,  -15,
	 -26,   -4,  -29,  -28,    7,   16,  -29,  -27,    3,    8,    2,    9,    5,    1,  -13,   38,
	  16,   26,  -16,    0,   19,  -14,   20,  -29,   -3,   43,   17,  -14,   39,  -34,  -15,   24,
	  36,  -27,   -1,    7,  -55,   24,   50,  -43,   21,    5,   -5, -122,   78,  -43,  -33,   12,
	 -12,    9,  -45,   -3,   -1,  -22,   37,   -3,   17,  -35,  -11,   32,    5,   62,    0,   -4,
	  20,   18,  -33,   93,    2,  -77,   45,   33,  -29,  -35,   45,  -55,   48,  -12,   15,  -54,
	  16,   -3,  -50,    1,  -21,  -39,   16,   -1,  -33,  -38,   19,  -45,    9,   34,   26,  -15,
	  21,   60,  -32,    7,   -2,   24,   21,   28,  -19,  -12,    7,   60,   23,  -23,    7,  -44,
	 -54,   54,  -17,  -42,   38,  -24,  -23,   18,    9,  -31,    4,   24,  -26,  -27,   33,  -53,
	  15,   26,  -38,   11,   13,  -39,   24,   32,   19,   14,   16,  -27,  -24,   14,   14,    9,
	   6,  -48,   -8,   -8,   60,  -39,    1,  -32,   51,  -34,    0,   33,  -16,  -33,  -10,   60,
	 -40,   -1,    3,   31,   50,  -16,  -32,  -40,   45,  -34,   -8,   54,  -80,    0,   19,   21,
	 -21,   87,  -70,  -19,   23,   25,  -56,   40,  -33,   19,  -44,   -8,    7,  -12,   18,  -20,
	  22,  -10,   18,    5,   -7,   26,   33,  -65,   49,   -9,   -9,   27,   22,   22,  -37,   18,
	 -19,   -1,   61,  -23,  -39,    4,    4,  -32,   -3,   27,  -39,   -3,   38,  -19,  -12,   -8,
	 -37,    3,  -10,  -14,  -37,    0,    4,   24,    1,   33,  -35,   29,   -2,   24,   24,  -21,
	  23,   -3,  -31,   47,   12,  -26,   35,  -19,  -17,   22,   20,  -27,    1,  -16,  -18,   17,
	  -2,  -19,  -22,   25,   -2,  -11,   -3,  -60,   -2,   30,   64,  -76,   -7,  -29,   45,    1,
	  46,  -23,  -43,    2,   43,   68,  -38,   -8,   45,   -7,   -8,   15,  -47,  -27,   71,  -12,
	  -3,  -17,  -54,  -29,   75,  -51,    8,  -27,   12,  -18,   60,  -29,  -42,   22,   51,  -32,
	 -27,   28,  -11,   48,  -34,   30,   26,  -19,   20,   14,  -16,    2,    7,  -36,   70,  -14,
	 -21,  -39,   82,  -50,  -49,   33,  -28,    9,  -17,  -15,  -51,    5,    7,  -17,   58,  -29,
	 -33,    2,   29,   14,  -46,    3,   28,    2,   28,  -22,    7,   -3,   28,    2,   40,  -71,
	   2,   23,   24,   19,   11,  -62,   56,    1,  -24,   -7,  -10,  -26,   30,  -49,   18,  -40,
	  52,  -51,   46,   -3,  -28,  -26,   40,   11,   -5,    8,  -46,   25,  -10,   34,  -25,   44,
	 -17,   -7,   12,   12,  -28,  -19,   30,  -26,    6,  -38,   13,   45,  -43,   24,   24,  -49,
	 -13,   19,    3,   27,   -5,   -8,    5,   -6,   -4,   39,    7,    1,  -38,   22,   20,  -20,
	  19,  -24,  -50,   47,  -11,  -25,   32,  -59,   17,   12,   35,  -50,  -14,   -7,   15,   33,
	 -15,   11,  -45,   10,   14,   50,  -68,   -4,   11,  -35,   20,   88,  -72,   40,   16,   -9,
	   3,   55,  -44,   25,  -24,    6,   14,  -66,    9,    7,  -10,    9,   -7,    1,  -42,  -24,
	 -26,   74,   -5,  -23,  -44,   12,   11,   12,   57,  -60,  -19,    7,   -2,   40,    3,  -26,
	 -14,   44,   29,    7,  -23,   21,  -32,   42,   13,  -30,  -16,   36,   -9,    3,  -21,   17,
	 -67,   30,   -4,   23,  -19,    8,  -32,    5,   31,   -4,  -26,   18,  -24,    6,   39,   -7,
	 -24,   -2,   -5,    6,   -3,   11,  -10,   -6,   16,  -15,  -15,    5,  -19,  -17,   38,  -27,
	  35,  -48,    7,  -20,    4,   12,    1,  -33,   28,  -24,   -2,   28,  -10,  -11,   23,   -2,
	   5,   21,   -5,    8,    0,   21,   12,  -24,   36,  -40,   36,   29,   -2,  -19,    1,    3,
	  -8,    9,  -11,  -13,  -31,   26,   -5,   23,  -26,  -30,    1,   30,  -19,   -2,  -15,    3,
	   5,    5,   -3,    3,  -43,   38,   16,  -30,   18,   12,   -1,   -4,   20,  -47,   11,    1,
	  21,  -15,    1,    0,  -43,   -5,   37,  -28,   11,  -51,   21,    2,   20,  -24,   22,  -46,
	  34,   -1,    7,   27,  -12,  -24,   28,   39,   -4,   10,  -19,    8,    6,   37,  -26,    2,
	 -12,  -32,   36,   17,  -11,  -14,  -26,   -1,   17,   17,  -53,  -10,  -11,   23,  -16,  -26,
	  10,  -33,    1,   61,   -5,  -21,  -14,  -28,   50,   13,  -41,   17,  -12,   38,  -19,   24,
	  36,  -75,   16,    1,   58,  -15,  -19,  -33,   56,  -40,   39,  -18,    1,    0,  -34,   11,
	  32,   -6,  -52,   32,    2,   39,  -31,  -23,    0,  -11,   10,  -26,   55,   -6,  -51,    0,
	  36,  -33,  -14,   -9,   30,  -11,   -5,   14,  -17,    6,  -34,   28,   16,   -3,  -21,    7,
	  25,   13,  -30,   14,   12,   33,    3,  -16,    9,  -12,  -17,   15,    2,   23,   14,  -46,
	   1,   13,   -4,  -19,    6,   30,  -53,  -13,    1,  -17,   13,  -38,   11,   20,    1,  -24,
	  19,  -10,    7,  -28,   48,   25,  -59,  -33,   51,   12,   -4,   -3,   13,  -23,   64,    0,
	  -5,  -24,   -6,   21,  -27,   28,  -19,  -29,   51,  -24,   -9,  -12,    3,   -3,   35,    6,
	 -33,  -37,   -5,   45,  -47,   30,  -16,   -9,  -10,   51,  -31,   32,   10,  -22,  -10,    8,
	 -13,  -28,    8,   15,  -25,   39,  -36,    2,   50,  -30,   36,  -40,  -14,   35,   -9,   -3,
	  12,  -25,   36,   -7,  -20,   -6,   48,   -5,   31,   -4,  -18,  -48,   67,  -47,   26,  -30,
	   6,    9,  -14,  -29,    3,   23,  -12,  -27,   29,  -22,  -36,   -9,   51,  -30,  -18,  -16,
	  47,   -4,  -25,   18,   16,   13,  -11,   15,   10,    2,  -36,   42,    3,   -9,  -21,   52,
	 -19,   18,  -34,   -3,  -11,   23,   19,  -13,  -17,  -19,   16,   -1,    0,  -32,   -1,   -4,
	  25,    9,  -37,   -3,   -9,   45,  -15,  -29,   36,    4,  -29,   -9,   35,   16,  -36,  -21,
	  25,  -12,   10,  -21,   25,    5,  -17,   -8,   12,   35,  -56,    4,  -15,   47,  -32,   -5,
	  18,    3,   11,    2,    7,    1,    1,  -24,   23,    6,    7,  -46,  -37,   73,   12,   -2,
	 -20,   34,  -45,   32,  -23,   15,  -40,  -34,   12,    4,   13,  -39,    3,   23,   17,  -24,
	 -15,   16,   19,  -30,   -9,   12,   53,  -64,    1,   23,   40,  -11,    8,   33,  -36,   42,
	 -68,   71,  -16,  -10,  -41,   22,   16,  -19,  -18,   26,   -2,    1,    4,  -21,   -3,  -16,
	  -4,   16,  -31,    1,  -26,   -5,   -8,   43,  -69,   28,   14,   10,  -16,   21,  -18,   -2,
	 -14,    0,   32,   23,  -28,  -21,   68,    0,  -40,   24,   32,    1,  -10,    8,  -20,   32,
	 -37,   16,   -3,   24,  -10,   -5,  -30,   35,  -39,   12,    6,  -26,   -2,  -58,   65,  -66,
	  13,  -10,   -6,  -15,   28,  -27,  -39,   51,  -28,   16,  -10,   60,  -51,   30,   51,  -24,
	  11,   -9,   -7,   14,   39,  -33,    4,  -14,   25,  -13,   -8,   35,  -40,   -1,   27,   -9,
	  11,   -9,  -13,    5,   19,  -37,  -12,   23,    1,   -2,  -31,   37,   -7,  -41,   35,   16,
	  -6,  -28,   -8,    9,  -23,   22,   -8,   27,  -17,  -27,  -10,   10,   12,   -6,   11,  -51,
	  21,  -19,  -29,   23,  -10,   -4,   32,    3,   25,    7,  -25,   23,   35,  -21,   -2,   -3,
	  23,   -4,   14,    6,   -8,   -5,   -6,   10,   10,    5,  -38,   -7,   16,  -38,   -2,   12,
	   8,  -54,    5,   18,  -12,  -18,   23,   17,  -52,   50,  -78,   11,    4,    5,   19,    7,
	  27,  -24,    5,    3,   35,  -20,   34,  -15,  -10,    4,   21,   16,  -14,   12,   -8,   -2,
	  42,  -30,  -22,   28,   -9,  -34,  -11,   23,  -36,    0,   15,  -10,   14,  -37,   -7,  -19,
	  30,  -18,   15,  -17,  -14,  -14,   51,  -20,   -8,   13,  -12,    7,   35,    9,  -12,  -13,
	  48,    1,   -2,  -32,   13,   -5,    1,   15,   40,  -66,   18,    1,   49,  -45,  -38,   -8,
	  14,  -16,   -2,   24,  -13,  -62,   15,   54,  -28,  -18,   -3,   10,   13,  -21,  -18,   -9,
	  44,  -13,    8,   37,    6,  -18,    4,   27,  -18,   21,    3,   -8,   13,   27,  -19,   14,
	   2,  -27,  -11,   -8,   17,  -38,  -26,   29,  -31,    5,   -7,   -5,   -9,   -4,  -11,    9,
	  -3,   -5,  -18,   16,    3,    0,   -8,   -2,   -6,   -1,   58,  -11,   12,    2,   31,  -21,
	  13,   27,  -17,  -23,   54,   18,  -33,   -7,   -7,    3,   -2,  -25,   15,   -1,  -25,  -41,
	 -13,   46,  -71,  -15,   40,   10,  -14,    0,  -10,   18,    0,  -31,   25,   -8,  -10,  -13,
	  24,   30,   -9,    6,    4,   26,   -3,    5,   31,  -25,    0,   -7,   16,   20,   -1,  -12,
	 -22,   11,  -10,   -3,  -26,   12,    3,    2,  -17,  -31,    4,  -26,   15,   13,    6,  -22,
	  -5,    5,    8,   11,  -23,   17,   17,  -33,    0,   12,   21,  -20,   -3,   20,   21,   -7,
	 -20,   38,   20,  -27,  -16,    3,    7,   -8,   -3,    0,   22,  -38,  -37,   26,   23,  -26,
	  -8,   -5,    0,  -12,   -2,   30,   -8,   -4,   -2,  -13,   15,  -24,   -4,   29,   10,   32,
	  -7,  -57,   48,  -13,   41,  -13,   16,  -20,  -20,   33,  -13,   26,  -17,  -18,   20,   10,
	 -44,   18,    2,  -18,    3,  -13,   -5,  -25,  -16,    7,   30,  -32,    8,  -34,   19,   -5,
	  23,  -28,   12,   -4,  -14,   30,    1,   -2,   15,  -20,  -16,   44,   -2,   34,  -31,   36,
	 -25,   15,   -3,   13,  -10,  -36,   39,   -5,    0,  -16,    1,   27,  -28,   24,  -26,   -8,
	 -12,  -16,   25,   -2,  -12,  -28,   16,  -17,    7,  -24,   31,  -15,   -8,   31,  -22,   -7,
	   0,   14,   16,  -17,    8,  -15,   24,   -3,   17,  -14,    6,   -4,  -22,   22,    9,    1,
	   3,  -21,   18,   -8,   11,    0,   10,   -3,  -12,    3,   15,  -15,    1,    2,  -13,    3,
	 -23,   -3,   15,  -11,   -5,    9,  -30,   -6,  -10,   27,   -2,   -9,  -12,   10,    4,    0,
	 -16,   16,  -10,  -27,   51,   -5,   -4,   -1,   -4,    5,   38,  -18,  -11,   17,    1,   -2,
	   8,    0,   -7,    6,   -6,   -4,    9,  -12,  -11,   11,    1,  -14,    1,  -31,   13,    3,
	 -28,   12,   24,  -30,    7,   -6,    5,   -4,   -6,    8,    1,   14,  -19,   -1,   32,  -22,
	  -9,   34,    6,   -9,   -9,   -5,   15,    6,  -25,   14,    6,  -41,    0,   10,    2,   12,
	 -18,    6,    5,   -1,  -16,    4,   26,  -33,    5,    4,   -4,   -9,    5,   -2,   14,  -10,
	 -11,   16,   -6,   11,   -5,  -15,   14,   18,  -19,   21,  -24,   13,    6,  -13,   21,  -12,
	 -11,   -2,   10,   -6,   -7,  -13,   12,  -13,    1,   10,   -7,    2,   -2,  -21,   24,    5,
	   2,    5,  -24,   17,  -17,  -15,    9,   20,  -12,   -9,  -15,   14,   -1,   -2,   14,  -13,
	   5,  -32,   21,   10,    7,  -11,   24,   -1,  -23,   24,  -25,   31,    7,  -16,   -2,   -4,
	   9,  -19,   17,    4,  -27,   22,   21,  -28,   -6,   32,  -48,    6,   -4,   20,   -6,  -41,
	  11,   31,  -16,  -14,    2,   -8,  -13,  -13,   35,  -15,   15,  -20,    1,   26,    7,  -13,
	  18,    5,  -19,   11,   -7,   20,   22,  -35,  -11,   20,  -24,   21,  -20,   34,  -15,  -17,
	  -8,   -2,   16,   -9,  -12,    2,   20,  -31,   24,  -21,    2,   12,  -27,   28,  -10,   -5,
	  24,    7,  -29,    4,    6,  -24,   33,   -4,   -8,  -16,    1,   32,  -28,   13,    7,    2,
	 -10,  -38,   30,    2,  -18,   -2,   17,   13,   -6,  -46,   -1,   61,  -48,   18,   10,    2,
	 -17,  -13,    8,   27,   -8,    0,   11,   -5,   20,  -39,    4,   19,   -8,  -13,  -15,   29,
	 -36,   29,  -16,   14,  -25,   17,  -14,  -15,   18,    5,    3,   -5,   -2,  -19,   31,  -12,
	  14,  -23,   31,  -24,   -4,    0,    4,    2,   11,  -15,   22,  -27,   -4,    9,   -8,   22,
	  -2,    7,  -33,  -12,   -3,   30,   -3,  -10,   12,  -19,    2,   -9,   16,   -4,  -15,    5,
	  32,  -13,  -13,   22,  -11,    1,    3,   18,  -12,    3,  -17,   16,   15,  -36,   -2,   10,
	 -12,    9,  -29,   14,   12,  -23,    5,   39,  -20,  -39,   13,   14,  -13,    2,  -16,   43,
	 -25,   -1,  -12,   19,   11,  -27,    0,   28,    3,   -3,  -15,   -1,   10,  -31,   43,   -6,
	   5,  -10,    4,  -18,   24,   -6,  -14,   -8,   -5,    4,    1,   -5,  -20,   21,    5,  -19,
	  22,   -8,  -13,   -3,   20,  -10,   20,  -12,   -7,   11,  -11,  -15,    6,    3,   24,   -9,
	  -4,   -3,   -4,  -20,   44,  -12,  -15,    4,   -3,   -6,    2,    9,    3,  -17,   -7,    9,
	  -2,    2,  -22,   18,   -8,   -2,  -10,    4,    6,   -1,   -4,    9,   -1,    6,   -9,    8,
	   2,    4,    4,   -6,   17,  -32,   11,   -1,   21,   -7,  -29,   12,    2,  -35,   28,   12,
	 -15,   15,  -43,   37,  -30,   -4,    2,   27,    8,  -22,   -1,  -13,   20,  -28,   36,   -6,
	 -12,   -4,   -8,   14,    2,  -12,    5,   12,   -3,  -11,    3,   -1,    2,   18,   12,  -11,
	   4,  -31,   13,   10,  -10,   12,    7,  -35,   10,  -17,   -3,   12,   -5,    2,    0,  -23,
	   7,    5,   -4,   23,  -30,    2,    4,   -3,   18,  -16,   17,   16,  -12,   -3,  -14,   17,
	  -1,   -5,    9,   19,  -23,   11,   -8,  -19,   34,   -7,  -13,    1,    3,   19,  -23,  -15,
	  19,  -17,    5,  -24,   16,    4,   -5,   -7,    7,   -2,  -20,    4,   15,   21,  -29,   -7,
	  16,   -3,  -17,    9,    3,   15,  -15,   -5,   12,  -14,    8,   21,  -15,   12,  -18,   -1,
	  17,  -19,    2,   16,   16,  -11,  -30,   22,  -12,  -12,   -1,   21,  -28,   29,  -30,   -6,
	  19,  -14,   -5,    0,   10,   18,   -8,  -15,   -1,    7,  -15,   28,   -3,   -3,   -9,   -8,
	   0,    6,   18,  -32,    7,   -3,  -11,    6,   30,  -42,   32,  -13,   -8,    5,    8,    8,
	 -15,    3,    4,  -22,   27,   -6,    6,  -11,    1,   -6,   13,   -5,    2,  -12,   29,  -30,
	  10,  -15,   18,  -19,    8,   21,    1,  -28,   15,  -20,   25,  -25,   -1,   11,   -2,    1,
	 -22,   -3,   15,    1,  -22,   18,   16,  -24,    1,   19,    6,    9,   -7,  -22,    8,   -6,
	   2,   14,   -9,   -4,  -13,   10,  -12,   13,    0,  -11,  -12,   -2,   -6,   20,   -9,    4,
	   5,  -14,    3,    9,   -2,   13,   -5,    0,   14,  -17,   -1,   -3,    8,   -6,    7,   29,
	 -19,  -13,    3,   27,  -17,   -8,   11,   -2,  -14,   -9,    7,   -3,   -9,  -14,   24,  -12,
	 -35,  -13,   40,  -10,    1,   -7,    1,    2,   -1,    1,   16,    3,  -13,  -11,   30,    2,
	  -9,    0,   -9,    2,   15,   -9,    8,    3,  -19,   12,    5,  -21,    5,   -6,   16,   -4,
	   7,   -4,   -2,    9,  -35,   27,   -6,    0,  -12,   15,  -29,    8,    2,   -7,    4,    1,
	 -15,   28,  -15,  -13,   18,    4,   -1,    1,   -4,   -7,  -16,   21,  -11,   25,  -19,    2,
	 -10,   20,  -32,   11,    6,    6,  -15,   22,    8,  -25,  -13,    5,   20,   13,    7,  -23,
	  -6,    7,   -4,    4,    0,   -7,    3,  -10,   -4,    9,    1,    3,   -8,    2,   16,  -22,
	  -7,   -3,   12,   -4,   -4,    8,  -10,    6,  -13,   -5,    3,    3,    6,    4,    4,   -9,
	 -27,    1,   16,   17,  -15,    0,  -12,   15,   -2,   -6,   10,    3,  -16,  -16,   22,   13,
	 -12,    4,   -4,    7,   11,  -12,  -14,   15,   -1,    3,  -12,    7,   -7,   12,  -14,    9,
	  -9,    2,    2,    9,  -12,  -17,   12,  -17,   14,   -2,  -18,    2,   16,   -5,    1,    8,
	  -5,  -12,    0,   -3,   21,   -2,  -17,   10,   10,   -4,  -16,    6,   15,   -1,  -25,  -11,
	  18,    0,  -11,    8,   15,  -16,  -18,   -4,   39,    3,  -30,   -6,   22,    2,  -22,    2,
	  21,   -9,   -9,   12,   -3,   19,  -24,  -12,   20,   -8,    4,    3,   -3,   15,  -20,   -3,
	  14,   -7,   -4,  -14,    9,   -8,    0,    7,   -6,   -8,   -4,   -3,    4,   13,  -18,    0,
	   9,   -2,    5,   -4,   10,    3,   -9,   -6,    9,   -3,    1,    4,   -3,    4,  -11,    2,
	  -3,    5,   11,  -13,   -1,    4,   -7,    1,  -11,    1,   17,  -17,    2,   13,    1,  -21,
	  -2,    7,   -5,   -4,   -5,   16,   -5,   -7,    4,    8,    8,  -14,    4,    8,   -7,   -1,
	   5,    2,  -11,   -9,    9,    6,  -10,   -2,    6,   -7,   -2,   -1,   15,  -17,   -4,    5,
	  -2,    2,   -3,   -5,   11,   -3,    1,   16,  -12,   -3,   -7,    6,    5,   -4,    5,    0,
	  -3,  -15,    5,    3,   -8,    9,    3,   -8,    1,   -6,   -4,    0,   -7,   21,  -18,    9,
	  -8,   11,   -2,  -10,   10,    1,   14,  -19,  -11,   -7,   18,   -7,    4,    6,    2,  -15,
	   2,    4,    5,   -3,    0,    0,   12,   -2,  -15,   -4,   18,   -7,   -9,   18,   -7,   -6,
	  -9,    4,    7,  -21,   11,  -18,   14,   -5,   -4,    8,    5,    4,   -3,   -4,  -11,   11,
	 -15,   19,    2,  -18,    8,   -4,  -13,   18,    3,  -14,   -3,    9,  -11,    2,   10,   -9,
	  -5,   -1,  -15,   13,   16,   -9,   -4,   29,  -15,  -14,    6,    9,   -1,  -15,   12,   12,
	  -6,   -6,   13,  -10,   18,  -14,    7,  -12,    5,   -9,  -12,   16,   -6,  -16,    7,   -1,
	 -22,    8,    2,   -1,    9,    4,  -31,   -9,   12,   14,   -9,   -5,   17,  -25,    7,    0,
	  13,    4,   -1,  -17,   10,   13,   -7,  -11,   17,    2,  -23,   27,    5,  -10,   -3,   13,
	   5,   -5,   -5,   -4,    0,   -3,   -5,    3,    4,   -9,   -7,    5,    4,  -13,  -10,    1,
	   7,   -4,   -2,   -3,   -5,   15,   -9,    0,    1,   12,  -17,   -6,   32,  -15,  -16,  -11,
	  20,    0,    2,  -11,   -5,   25,  -21,    3,   10,   15,  -24,   -4,    8,   -5,    0,   15,
	  -1,   -7,    1,  -18,   21,   -7,    3,  -12,    0,   12,  -10,    6,   -3,   -2,    2,   -1,
	   9,    1,   -9,    7,   -9,   -4,    9,  -16,   -4,    8,  -10,    4,   -3,   -2,   13,   -9,
	   4,  -16,    4,   -3,   -5,   14,    7,   -8,    2,    9,    0,   -2,  -12,    7,   -3,    2,
	  -4,  -15,   11,   -8,  -11,   -4,   23,   -5,   -1,    4,   -9,    7,   -4,    7,    8,  -13,
	  -6,   -4,   16,   10,  -11,    8,   -1,   -1,    2,   -5,    0,   -3,   -6,    2,    3,   -6,
	  13,  -19,   -9,   19,  -11,    6,  -12,   12,  -10,   -3,  -11,  -10,   14,    2,  -19,   14,
	   4,   -6,    4,   11,   -7,    3,   -3,   -8,   24,  -18,    6,   -8,   15,  -14,   -7,   19,
	   0,  -11,   -3,    2,    2,    0,    2,    6,   -7,  -22,   16,    0,   11,  -12,    7,  -12,
	  10,  -16,    4,    8,  -11,  -11,    4,   16,  -19,   13,    1,  -19,   12,   19,  -15,   -4,
	   9,   -8,  -13,    5,   14,  -12,    5,  -21,    7,    4,   11,  -19,   -1,   15,  -16,   -3,
	 -12,   14,    1,    1,   15,   -6,  -13,    7,    0,    6,    4,  -11,   -3,   10,   14,  -20,
	   7,    3,    1,    5,   17,  -17,   -5,    3,   -4,    6,   -1,    3,  -18,   10,  -10,    0,
	   0,   14,  -18,  -19,   17,  -23,   -5,   -1,    4,   -4,   -2,    1,  -13,   26,  -15,    2,
	 -10,    3,   13,    0,   -6,    3,   -4,    3,    0,   -2,    9,    2,    9,  -14,   23,   -4,
	 -10,   15,    7,  -16,    0,    9,    3,    0,   14,  -12,    0,    4,  -10,    1,  -11,  -13,
	  -6,   15,  -14,   -7,    2,  -20,    4,   -7,    9,   -3,    2,  -14,   -1,    1,   -1,    9,
	 -18,   10,   -1,    1,   -3,   22,    1,   -1,    5,   -4,   10,    2,    5,    0,    3,   -2,
	  -1,    5,   -2,   -3,   -5,   10,    2,  -16,    2,    3,   -1,   -1,  -11,    7,    6,    0,
	 -10,   10,   -7,   -2,  -15,   15,    4,  -25,    0,    4,    4,  -12,    0,    5,   -7,   -6,
	   6,    6,   -8,    1,   -1,   -7,   17,   -9,    2,    8,    4,   -6,   -6,   19,   -5,  -11,
	  12,  -12,    3,    3,   -5,    9,   11,  -26,    0,    0,    7,    5,   -8,   11,   -5,   -6,
	 -16,    7,   12,  -10,    0,   -6,    7,   -8,    3,   -4,   11,   -9,  -16,   13,   18,  -18,
	   2,   -5,    7,    5,    0,   -1,    4,   -9,  -13,   18,    5,   -4,  -14,    1,    7,   -5,
	   4,   -9,   15,    3,  -10,   -4,    5,    3,  -11,  -17,   18,    4,   -9,   -3,    3,   -5,
	 -11,   -3,    0,    7,   -1,   -8,   -2,    6,   -7,    7,   -3,    6,    3,  -12,   15,   -5,
	  23,  -12,    8,  -12,   -4,   10,    1,    4,   -3,    0,    0,    8,    0,    1,   11,  -27,
	  -9,    9,   -4,   -3,   12,  -19,   -2,   -8,   -6,    1,   -1,    2,  -12,    5,  -11,    3,
	  -1,   -1,  -10,   18,    0,    3,    2,    4,   -5,   11,   -3,    9,   -2,   -5,    7,   -6,
	   8,   10,    2,   -1,   -8,    1,  -16,    2,    9,    1,   -4,    0,  -15,   -5,    6,  -14,
	  -9,   14,  -22,    3,    7,   -1,   -2,   -2,    0,    1,   -2,    1,    9,    0,    7,   -1,
	   6,    4,    0,   -6,   -2,    2,    4,   -9,   11,    1,  -25,    9,   -6,    5,    0,   -7,
	  -8,    3,    5,    1,   -2,    3,   -9,   -5,    7,   14,  -12,    3,  -10,   10,    3,  -16,
	  -3,   26,   -8,   -9,   -2,   15,    0,  -21,    8,   11,  -17,    3,    8,   -8,   10,  -19,
	  -3,    8,   -4,    6,  -10,    3,    4,   -6,   -4,    6,    0,    4,  -19,    9,    3,   -7,
	  17,   -7,    2,    3,  -27,   12,    5,  -14,    5,   -6,   -6,    6,   11,  -11,    6,  -12,
	  -2,    9,    8,    1,  -18,   18,   -9,    0,   13,   -8,  -10,   24,  -11,    4,   13,   -4,
	 -18,   -3,    2,    9,   -7,   -1,    4,   -6,    0,  -11,    5,   -1,   -1,   -8,  -10,   -6,
	   6,  -15,   20,    6,  -25,   11,   -5,   -7,   12,    4,    0,   -6,    6,    2,   -1,    5,
	   1,  -11,    9,   20,  -11,   14,   -6,  -15,   11,  -11,    7,    1,   -5,    2,   -8,   -2,
	  12,   -5,  -16,    8,   -4,  -10,    2,    2,   -6,   -8,    5,    0,    3,    4,  -17,   13,
	   4,   -9,    1,    5,    4,    8,   -7,   -3,    3,   -2,    4,   14,   -9,   -6,   -7,   -3,
	  11,  -17,    0,    9,  -10,    0,    1,    0,   -9,   -7,    8,    7,   -3,   15,  -22,    2,
	   7,    0,    2,    4,   -2,   -6,   -3,   -1,    9,    2,   -2,    1,   -4,   -1,   -6,    2,
	   4,   -8,    3,   -2,    1,    0,   -9,   14,   -6,   -5,    3,   -1,   -6,    5,   -5,   -6,
	   5,   -5,   -1,   12,  -10,   -6,   -3,    9,   -7,   -8,   14,   -5,  -11,    9,   -1,    5,
	  -5,    3,    1,    0,    1,    3,   -7,    7,   -1,    1,    4,    5,  -16,    7,    6,   -6,
	  -2,   11,   -8,   -9,    3,   -9,   -2,   15,  -11,  -11,    6,   -1,   -7,   -4,    4,    2,
	  -9,    1,    1,   -2,    0,    6,   -3,   -3,    6,   -7,    6,   11,  -11,   -9,    0,   15,
	  -8,   14,   -2,  -13,    1,    4,    0,    7,   -2,  -10,   -1,    8,   -6,   -4,    5,    1,
	  -6,    1,   -8,    0,   -4,    7,    4,   -3,   -8,   -4,   -3,    8,    3,   -8,   -3,   16,
	  -7,   -1,    0,   -1,   -4,   -2,    2,    6,   -1,   -2,   -4,    5,    5,   -4,   -2,   -8,
	  -6,   10,    4,   -5,   -2,   -2,   -2,    0,   -4,    0,    2,    0,  -12,    6,    2,    0,
	   3,    2,  -11,    2,    1,   -2,   10,    1,   -6,    9,   -8,   -3,    5,   -1,    5,   -2,
	   0,   -5,   -7,    8,    5,   -4,   -9,   -1,    1,   -2,   -7,    4,  -12,   -4,    5,    0,
	  -4,    5,  -13,    8,    2,    4,    1,  -10,   -6,   -3,   17,    4,    1,   -7,    6,    2,
	   1,   -3,   -1,    0,    7,   -8,   -2,    6,    2,   -8,    0,   21,  -16,   -5,   -1,   -2,
	   4,    0,  -18,   11,  -10,   -4,   11,   -4,   -1,   -2,    2,   -3,    2,   -2,   -8,   -1,
	   1,   -3,    8,    2,    0,    1,    5,   -7,    2,   -4,   -1,    4,    5,    0,    1,   -6,
	 -11,   -6,    7,    8,    5,   -7,  -12,    7,    2,   -6,   -3,    7,   -4,   -3,   -1,    2,
	   9,    0,   -7,    9,    5,  -15,   -3,   -7,    2,    3,   -2,    0,   -3,    6,  -13,   -2,
	   0,   -5,    3,    9,   -5,    9,  -12,   -9,   12,    4,    1,    5,    3,   -4,   -2,    3,
	  11,  -16,    2,    0,   10,   -9,   -4,    8,   -4,   -7,    2,    2,   -6,    3,  -22,    8,
	  11,   -7,   -6,   -2,   -5,   -5,   -8,    3,    7,   12,   -8,   -1,    4,    8,  -14,    4,
	  13,   -6,   -8,    2,   17,   -1,   -3,   12,  -10,   -2,   -7,    0,   -6,   16,  -17,   -4,
	  10,   -9,   -2,    1,    0,   -1,   -7,    7,  -10,   -3,    3,   -1,   -7,   11,  -11,    3,
	   3,    8,   -6,   -2,    1,    0,  -15,   15,    5,    0,    7,   -5,    4,   -3,   -2,    2,
	  -4,   10,   -9,   -9,   15,   -6,  -12,   14,    3,   -7,    0,   -9,   -1,   -5,    3,   -4,
	   3,    4,  -14,   -2,   -1,    8,   -3,   13,   -5,  -18,   12,   -1,   -7,    0,    5,   -2,
	  -6,   14,    3,   -9,    3,    1,  -10,    0,    7,    3,   -7,    4,    2,  -14,    4,    4,
	  -6,   14,   -4,  -12,    6,    2,  -10,    1,    5,   -6,  -10,    3,    8,  -11,    9,   -1,
	  -3,    2,   -6,   -8,    4,    2,  -10,    6,   11,   -7,    0,    2,    1,  -10,    8,    6,
	  -5,    2,   -2,    3,   -4,    1,    4,  -11,    6,    4,   -8,    4,    4,  -13,   -4,    2,
	   6,   -3,    2,   -4,  -11,   11,    2,  -13,    9,    3,  -21,   -2,   17,   -4,   -1,    6,
	 -11,   -2,    1,   -4,    4,    5,    0,    0,    1,   13,   -8,    0,   -3,    2,   -6,    1,
	   7,   -4,    2,    2,   -5,   -5,    8,  -14,   -4,    8,  -10,   -1,    3,   -4,   -6,    6,
	   5,  -12,   -6,    5,    1,   -4,    2,   -4,   -1,    8,   -8,    1,    8,   -4,    6,   -1,
	  17,   -8,   -7,   -1,    4,   -1,   14,   -5,    0,   -6,   -1,    0,   -1,    2,  -10,   -7,
	   0,    6,   -6,    4,  -12,   -1,    7,   -5,   -2,    0,    3,    0,   -9,   10,   -8,   -1,
	  -5,   11,  -15,    6,    6,   -1,    1,    1,   -4,    4,   -7,   12,  -11,   10,    2,  -15,
	   5,   11,    5,   -7,   -7,    0,    0,   -5,   11,    0,   -5,  -10,  -12,   15,    1,   -2,
	  -4,    2,    6,   -9,   -8,   -3,   -1,   -5,    5,   -4,    1,    5,  -13,   -1,   10,    0,
	   0,   -2,    1,    9,    0,    3,   -7,   14,   -2,    0,   -2,    3,  -12,    9,    4,    0,
	  -4,   -7,    0,   -6,   -5,    5,   -3,   -5,   -5,    4,    7,  -13,   -7,   -6,    3,    1,
	   0,    6,   -3,   -5,   -4,    7,    1,    3,    1,   -3,    5,    3,    3,    2,   -1,    2,
	   4,   -9,    8,    2,   -5,    6,  -12,    7,   -5,   -8,   -6,    9,  -14,    4,   -7,    4,
	  -6,    1,   -2,  -11,    4,   -4,    2,    7,   -4,    4,    5,   -2,   -4,   -5,    6,    2,
	   0,    5,    9,    3,   -4,   -7,    1,    6,    3,   -2,   -7,    1,    1,   -6,    0,    8,
	 -12,  -11,    7,  -12,    0,    2,   -5,    4,   -1,   -9,   -2,    7,   -8,    1,    1,    5,
	   1,   -4,    5,   -8,    4,    2,   -5,    7,    6,   -6,   -3,   -8,   13,   -2,   -3,    2,
	   0,    0,   -5,    6,    5,   -6,   -3,   -3,    2,    8,  -12,    4,    7,  -12,  -10,   13,
	  -3,   -2,    1,   -5,    1,    1,   -2,    5,   -5,   -6,  -12,    4,    0,    4,    3,    3,
	 -10,   -8,   -3,   10,   -5,    7,   -8,    3,   -1,    6,    0,    3,    6,    4,   -6,    2,
	   5,    5,   -6,   -4,   -2,    4,   -2,   -9,   -4,    7,   -1,  -12,   10,   -5,   -9,  -11,
	   1,    4,   -8,    1,    7,   -3,    4,   -7,   -1,    8,   -5,   -6,    9,   -1,    0,    8,
	   3,    7,   -9,    6,   -1,    9,   -7,    2,    3,   -4,   -5,    6,   -6,    8,  -10,  -12,
	   4,    3,    1,   -1,   -9,   -1,   -4,   -5,   -3,    6,    7,  -11,   -4,    6,    0,   -3,
	   3,    4,   -5,   -4,    1,   -3,    3,   -2,    0,    1,   -1,    3,   -9,    7,    3,   -7,
	  -2,    5,    5,   -9,    7,    0,   -8,    8,    1,   -5,    6,   -4,   -6,    2,    6,   -3,
	   0,    0,   -3,   -9,   -6,   -2,    9,    2,   -2,  -11,    7,    9,   -9,   -7,    8,    0,
	  -7,    1,    4,   -5,   -3,   -3,    5,    5,   -3,  -13,    7,    5,   -6,    5,   -2,    7,
	  -9,   -8,    6,    2,   -5,    3,    7,   -4,   -6,   -7,    1,    7,    6,   -5,   -5,    6,
	 -10,   10,    1,   -4,    4,   -4,   -2,    1,    9,  -10,    0,    4,   -8,   -1,   -5,   -1,
	   3,   -2,    6,    1,   -5,   -5,   -5,    2,   -3,    3,    3,   -1,    0,   -4,    0,    9,
	  -1,   -6,   -6,    4,   -1,    2,    5,    0,   -2,   -2,   -4,    2,    4,   -1,   -4,    4,
	   0,   -3,   -9,   -2,    6,    0,   -7,   -1,    3,   -2,   -1,    2,    2,   -7,   -2,    0,
	   2,    4,   -6,    3,   -3,    6,    0,    0,   -2,   -6,    1,   11,   -2,   -1,   -8,    3,
	  -7,    1,   -2,    6,   -9,    6,    0,   -1,    1,   -6,   -7,    5,   -1,    2,   -2,   -1,
	  -1,    0,   -3,    1,    2,   -1,   -3,   -5,    3,    7,   -9,    5,    3,   -5,   -5,    5,
	  -1,    0,    4,    4,  -11,    8,   -3,  -10,    9,   -7,   -1,    1,   -2,    1,   -3,    6,
	  -3,   -5,    2,    4,   -7,    5,    2,   -2,   -3,    1,   -2,   -4,    2,    0,   -4,    8,
	   2,  -12,    0,    6,  -10,   -2,    8,   -6,   -3,    6,   -4,    2,    9,   -4,   -7,    2,
	   5,   -1,    1,    4,    0,   -5,    2,   -7,    2,    4,    1,   -5,   -1,    7,   -5,   -5,
	  12,   -7,  -12,    6,   -4,   -3,    3,    4,   -3,   -5,   -1,   -3,  -10,    9,   -8,   -2,
	   6,   -3,   -4,    6,   -1,    0,    3,    2,    1,   -3,   -5,    2,    0,    4,   -3,   -3,
	   1,    4,   -8,    0,    7,    4,   -9,    0,    3,    1,    1,   -5,   -4,    3,   -1,   -4,
	   4,    3,   -8,   -2,   -2,   -3,   -1,    0,   -3,   -2,    3,   -2,    1,    0,   -1,    0,
	  -6,    8,   -5,    5,   -5,    5,   -3,    5,   -7,    1,   -3,   -1,   -1,    2,    8,   -2,
	  -5,    1,   -3,   -1,   -4,   -4,    9,   -1,    1,   -3,   -2,    1,  -14,    8,    3,  -14,
	   4,    1,    2,    2,    0,   -5,    3,   -1,    2,   -2,    8,   -8,   -3,   -3,    7,   -1,
	  -3,   -1,   -3,    1,    5,   -7,    7,  -12,   -1,    1,    4,    3,   -7,    5,    6,   -2,
	   2,   -6,   -3,    0,   -5,    2,    1,   -1,    2,   -7,    1,    8,   -5,   -4,   -3,    2,
	  -2,   -5,    3,    2,   -3,   -6,   -1,    1,   -4,    4,    5,    2,  -14,   -1,    3,   -4,
	   3,   10,    2,    2,   -4,   -1,    4,    3,   -6,    2,    1,   -2,   -9,    7,   -2,    1,
	  -4,   -5,    1,   -7,   -1,    1,    2,    2,   -1,   -6,    5,   -1,  -12,   -4,   11,   -2,
	  -3,    6,   -4,    2,    0,    0,   -2,    0,    3,    2,    4,    2,   -3,   -6,    9,  -10,
	  -4,    2,    4,   -1,   -5,   -1,    2,    1,    2,   -7,   -2,   -4,   -4,   -2,    7,    5,
	  -6,    0,    1,   -1,   -4,    2,   -6,    3,    9,  -11,   -2,    8,    0,   -5,    6,   -1,
	   3,   -5,    6,    1,  -10,   -4,   -3,    4,   10,   -8,   -2,    1,    4,   -8,    4,    3,
	  -8,   -5,    2,    4,   -5,    6,   -2,    2,    2,   -3,  -10,    0,   -6,    2,    4,   12,
	  -4,  -10,    6,    2,   -5,    2,   -3,    6,   -4,    0,   -6,   -4,    7,    0,   -4,   12,
	   0,  -14,    3,    2,    1,    1,    2,   -7,   -1,    3,   -1,   -4,   10,   -9,  -11,    6,
	   4,   -9,   -5,   -1,    5,    0,    6,   -5,   -5,   -4,    3,   -7,    9,    0,   -1,    0,
	   4,   -3,   -2,   -1,   -4,    0,   10,    3,   -5,    4,   -4,   -6,    8,    0,   -7,   -3,
	  17,   -9,   -8,   -1,    3,   -3,   -3,    0,   -4,   -3,   -5,   -4,    8,    8,   -9,   -5,
	   4,    0,   -7,    6,    7,    3,   -6,    3,   -3,    1,   -4,   -4,    4,   10,    1,   -5,
	  -2,    0,   -9,    4,    1,    1,   -4,   -2,    6,   -3,   -5,    0,   -6,    3,    0,   -2,
	   4,    1,    0,   -4,    3,   -1,  -10,   -2,   -2,    2,    9,  -11,    8,    3,   -2,   -1,
	  -1,   -3,   -1,   -8,    4,    6,    2,   -7,    2,   -1,    3,   -6,    0,    1,   -1,    2,
	   2,    3,   -1,  -13,    2,    9,    3,   -5,   -3,    2,   -3,    5,   -4,   -2,    0,   -4,
	  -1,    1,   -4,    0,   -4,    0,   -2,   -2,   -5,    1,    4,   -1,    1,   -4,    1,    2,
	   0,   -2,    2,    1,    1,    0,    7,    0,   -3,   -4,   -2,    5,    0,   -3,   -2,    3,
	   2,   -9,   -1,   -1,   -1,   -4,    1,    5,   -6,    1,   -4,    8,  -12,    1,   -5,    3,
	   3,   -1,   -6,    9,   -3,   -2,    0,    4,    0,   -3,    4,   10,   -5,   -4,   -2,    0,
	   2,   -3,   -2,   -2,    0,    0,   -3,    0,    3,   -8,    0,   -5,    1,    0,    5,    1,
	   4,  -14,   -2,    1,    3,    1,    0,   -1,    6,   -2,    2,   -5,    4,    1,   -2,   -3,
	   1,    3,    5,   -5,    3,   -1,   -8,    0,   -3,    5,   -7,    2,   -4,    2,   -4,    2,
	  -3,   -2,   -7,    4,    2,   -2,   -4,    5,   -5,   -3,    0,   -4,    3,    5,   -6,    5,
	   8,   -5,    0,    2,    1,   -6,    0,    5,    1,   -2,    6,  -10,    7,   -9,    3,   -5,
	   4,   -1,   -1,   -4,    5,   -6,    5,   -1,   -9,   -1,    2,    4,   -2,    0,    5,   -9,
	   1,    0,   -2,    1,   -1,   -3,   -1,    9,   -1,   -9,   -2,    2,    1,    2,   -2,    3,
	  -7,    3,   -1,    3,   -1,   -5,   -5,    9,    1,   -1,   -3,    2,   -7,    1,    3,   -4,
	  -2,    5,    3,   -2,    0,   -5,   -1,   -1,   -3,    1,   -2,    0,   -1,   -2,    7,   -3,
	 -12,   -1,   -2,    0,    5,    4,   -4,   -2,    6,   -3,   -5,    8,   -5,   -4,    2,    6,
	   1,   -1,   -1,   -4,    4,    3,   -6,   -4,    6,   -1,   -4,    2,    2,  -10,   -4,    3,
	   0,   -3,    5,   -4,   -5,   -1,    2,   -5,   -1,    2,   -2,    1,    6,   -2,   -4,    5,
	  -2,    1,    4,    0,   -2,    0,    3,    0,   -2,   -4,   -6,    6,    3,   -2,   -1,   -1,
	   1,   -1,    0,    0,  -14,   -1,    3,    0,    0,    4,   -6,   -2,    0,   -2,   -3,   -3,
	   3,   -4,    7,    4,   -4,   -3,   -2,    3,    1,    0,    1,    2,    5,   -2,   -6,   -1,
	   1,    1,   -4,    3,    0,   -2,   -3,    2,   -8,    1,   -2,   -5,    0,    2,   -2,    6,
	   2,   -1,   -7,    4,   -5,    2,   -4,   -6,    5,    5,    2,   -1,   -3,   -4,   -7,    0,
	   6,   -3,    0,   -4,    8,    1,   -6,   -1,    2,    0,   -2,   -1,    7,   -5,   -4,    0,
	   7,    0,   -5,   -4,    3,   -2,    3,   -3,    1,    3,   -1,   -6,    2,    3,   -7,    3,
	   0,   -3,   -3,   -2,   -4,    2,   -2,   -1,   -3,    2,   -4,    0,    4,    2,   -6,    1,
	  -1,    1,    1,    4,    1,    2,   -4,    0,    0,    5,    0,   -5,   -5,    7,    0,   -4,
	  -4,    2,   -6,   -4,    5,   -1,   -1,   -4,   -3,    3,   -1,   -6,    1,    4,   -1,   -3,
	  -3,    3,    4,   -1,    3,    2,    0,   -3,   -3,    5,    2,   -3,   -1,    1,   -1,   -2,
	  -1,    2,    1,   -5,   -1,    1,   -3,   -3,   -4,    0,    2,   -3,   -2,    0,    4,   -1,
	  -2,    0,    3,   -6,    0,    3,    5,   -1,   -2,    3,    0,   -3,    0,   -3,    8,   -4,
	  -6,    4,    2,   -5,    0,   -1,    2,   -5,   -7,   -2,    1,    2,    1,    0,   -2,   -1,
	  -2,    0,    4,    0,   -5,    2,    7,    5,   -5,    3,   -3,    0,    1,    0,   -2,    5,
	 -10,    0,    1,    3,  -12,    1,   -2,   -1,    1,   -2,   -4,    3,   -6,   -2,    3,    0,
	  -6,    0,    2,    4,    2,   -3,    6,    2,   -7,    2,    1,   -4,    9,    3,   -1,    0,
	  -2,   -7,    0,    5,    3,   -6,    4,   -8,   -3,   -3,   -1,   -3,    3,   -3,   -5,    3,
	  -3,    3,   -1,    2,   -7,   -2,   -1,   -4,    2,    2,    4,    3,    0,    0,   -1,   -2,
	   1,    4,   -2,    2,   -1,    2,   -2,   -1,   -8,    2,    2,   -3,   -1,    2,   -2,   -5,
	   0,   -1,   -4,   -1,    5,    1,    3,   -2,   -1,    0,    2,    6,   -4,   -1,   -6,   -2,
	   2,    4,    1,   -2,   -5,   -4,    0,    3,   -4,    1,    4,   -1,   -9,   -1,    1,   -1,
	  -2,   -2,    2,    1,   -5,    6,   -1,    5,   -4,   -3,   -2,    8,   -2,    1,    5,    2,
	  -8,    0,    2,    0,    3,   -3,   -4,    3,   -7,   -6,    4,    1,   -6,    0,    2,   -2,
	  -4,   -2,    2,    4,   -5,   -2,    3,    0,   -5,    1,    7,    6,   -4,   -7,    4,    3,
	  -6,   -3,   12,   -3,   -3,   -5,   -2,    2,   -2,   -7,   -2,   10,   -4,   -5,    2,    0,
	  -3,   -5,    3,   -1,    3,   -2,   -3,    3,    6,   -8,    2,    5,   -3,   -3,   -5,   13,
	  -3,   -1,    1,    1,   -4,   -3,    0,    3,   -3,   -2,   -1,    1,    2,   -7,   -6,    3,
	  -7,   -3,    3,    1,    2,    1,   -7,    3,   -3,   -1,   -5,    6,    3,   -1,   -6,    6,
	   3,   -2,   -3,   -1,    1,   -3,    3,   -5,    4,    0,   -6,   -3,    5,   -1,   -5,    8,
	  -2,   -1,    0,   -4,    5,   -4,   -5,   -1,    1,    4,   -1,    1,    5,   -5,    3,   -2,
	  -2,   -5,   -2,    2,    4,   -2,    2,    1,  -16,    5,    1,   -1,   -2,   -2,    1,   -4,
	   0,   -8,    2,    4,   -5,    0,    6,   -2,    0,    0,    0,   -1,    2,   -5,    6,   -1,
	  -1,    2,   -1,    4,   -5,    1,    0,   -4,   -2,   -3,    2,    2,    4,   -3,    1,   -9,
	  -1,    2,    0,    1,   -1,   -1,   -4,    3,   -7,    6,   -4,    2,   -4,    7,   -3,   -1,
	   3,   -7,    0,   10,   -1,   -8,    2,    2,   -5,   -5,    4,   -2,   -2,   -7,   -5,    4,
	   2,    3,  -11,   10,   -6,   -5,   -4,    0,    9,   -1,    0,    4,   -6,   -1,    3,   -1,
	   6,   -6,   -1,   -1,    9,   -5,   -3,    7,   -1,   -1,    4,    2,   -7,    3,   -2,    0,
	  -2,    2,   -9,    0,    4,   -6,    0,    2,    3,  -14,    4,   -3,  -12,    3,   -1,    3,
	  -4,    4,   -8,    6,    5,   -3,   -2,   -4,    8,    0,   -3,   -1,    1,   -4,    4,   -3,
	   7,    0,    1,   -5,    1,    6,  -10,    1,    8,   -5,   -8,    6,    4,   -2,    5,    2,
	  -9,    4,   -1,   -1,    0,   -4,   -5,    3,    4,  -11,    3,   -7,   -4,    1,    2,    0,
	  -3,   -2,   -7,    4,   -9,    4,   -6,   -1,    2,   -2,   -1,    3,    9,   -6,    2,   -1,
	   3,    4,    2,    3,   -1,    0,   -1,    1,    4,    0,   -3,    3,    6,   -7,   -4,    4,
	  -3,    0,   -5,   -2,    2,    4,   -1,   -1,    0,   -9,   -4,   -6,   14,  -11,   -5,   -1,
	   5,   -6,   -3,    3,   -2,   -6,    3,    5,   -1,   -4,    5,   -7,    7,    4,   -7,    6,
	   4,   -2,   -4,    5,    8,  -12,    3,   -1,   -5,    3,   -3,    2,   10,   -7,  -12,    3,
	  -2,    5,   -4,    4,    3,   -6,   -4,   -6,   10,   -4,    2,   -3,    2,    0,   -2,    0,
	   2,    2,  -12,   -2,   13,   -2,   -6,    0,   -5,   10,    1,   -1,   -2,    0,  -12,    3,
	  11,    0,   -5,   -9,    7,   -4,    2,   -3,    0,    9,   -2,   -6,    0,    3,   -2,  -13,
	   1,   12,   -7,   -3,    0,   -1,   -4,   -4,   -5,    1,    5,   -4,   -7,    2,    0,   -3,
	   5,   -2,   10,  -12,    5,    1,   10,    8,   -6,    4,  -12,    7,   -1,    5,    0,   -1,
	  -2,    7,    4,   -4,    5,   -4,  -20,    6,    1,   -6,    5,    0,  -14,    3,  -12,    3,
	  -8,    6,  -10,    2,   -4,   -3,    1,    4,   -7,    4,    8,    2,    1,    2,    2,    3,
	   3,    0,    7,   -7,    3,   -1,   -1,   11,    3,    1,   -6,    0,   -8,  -10,    8,    6,
	  -4,   -1,   -5,  -11,    3,   -1,  -14,    6,   -4,  -13,   10,    0,    1,   -5,    0,    0,
	   1,   -3,    7,    4,    3,    3,   -1,    6,    1,   -1,   -6,    2,    2,   -3,   -4,   15,
	 -17,   -4,    1,   -3,    4,   -4,   -6,   -2,    4,    4,   -4,    3,   -4,   -7,   -2,   13,
	  -1,   -4,   -2,   -3,    9,   -7,  -12,   13,   10,  -12,   -3,    4,   13,  -14,   -6,   12,
	  -4,  -10,   11,   -5,    4,   -1,  -17,    9,   -1,    4,   -3,   -5,    6,    0,   -7,    3,
	   2,    4,   -9,   -9,   13,   -8,    7,    6,   -8,   11,  -15,  -11,   16,  -10,   -2,    1,
	  -8,   -1,   11,   -1,   -4,    2,  -13,    9,    3,   11,  -16,    4,    7,   -9,    9,    4,
	 -16,   11,    9,  -10,   13,    4,  -10,  -12,    2,    4,    4,  -10,    7,   -6,    0,   -8,
	  -3,    3,   -1,   -4,   -9,   -9,    3,   -5,   -3,   24,  -19,   -5,    7,  -11,    4,    9,
	   1,   -3,   -1,    7,   -4,    4,    4,   -4,   -7,   22,    0,   -1,   10,  -19,    3,    1,
	  -6,    9,   -7,    3,   -5,   -5,    5,    9,  -17,   -2,    4,   -9,   -4,    5,   -3,   -7,
	  -3,    6,   -4,   10,  -12,   -3,   13,   -6,   -5,    5,    3,    8,    0,   -7,    0,    2,
	  -3,   12,    3,  -10,   -4,   -8,    8,   -1,  -16,   13,   -5,   -5,    0,    3,   -6,   -8,
	  -2,   13,   -5,   12,   -4,  -17,   11,    0,    2,    2,    3,   -6,   -3,   -3,    4,    7,
	  -3,    1,   -2,   -2,   -3,   -4,    7,   -3,   -4,    4,   -5,    6,  -11,    5,    7,  -10,
	   0,    2,   -6,   -1,    5,   -3,    3,   -5,    5,   -8,    4,   10,   -8,    3,   -4,    7,
	  -5,    3,   -3,   -2,    4,    2,   -4,   -7,    2,   -3,   -5,    6,   -2,    5,   -4,    6,
	 -10,   -5,    5,    0,   -8,    6,   -6,   -1,   -3,    5,    2,    0,   -4,   10,  -12,   -5,
	 -21,   -1,   -4,    5,    3,    2,   18,  -14,    8,    5,    1,   -4,   -5,   -2,   -9,    0,
	 -12,   20,   -4,    7,    1,    6,    7,   -1,   -5,   13,   -1,   -7,    6,   -2,   -5,    2,
	   1,    4,    6,   -7,    6,   -9,   -3,    6,   -3,    8,  -10,    8,   -6,    0,  -20,    1,
	  -5,    5,   -4,   -8,  -12,  -13,    8,   -2,   17,    3,   -5,  -20,   -1,   -7,    3,   22,
	  22,   12,  -11,  -13,  -15,   -9,   21,   -3,   25,   43,   -4,   -3,   -6,  -21,  -30,  -37,
	  -9,    8,   -5,    8,   53,   50,    1,   -5,  -13,  -15,  -41,  -23,    6,  -34,  -47,  -17,
	  -2,    2,  -13,   22,   29,   32,   44,   51,   55,   10,   15,    7,    0,  -31,  -48,  -38,
	 -48,  -43,  -13,    7,    4,  -46,  -23,   -6,    6,    4,   12,   50,   26,    4,   24,   40,
	  33,   20,   17,   17,   -7,  -30,   10,   -2,  -17,    5,  -36,   -7,  -38,  -30,  -13,    1,
	   9,   -1,   -6,  -29,  -15,  -11,    7,    3,    6,   16,   27,  -22,   -8,    5,   24,   27,
	   0,    4,   -5,   -5,   -2,   15,   12,   12,    2,   13,    0,  -19,  -26,    4,  -19,  -24,
	 -33,  -21,  -28,    0,    6,   18,   20,   15,   40,    2,   -8,   17,   21,   47,   -2,  -12,
	  11,   -9,   22,  -19,    3,  -27,  -29,  -10,  -38,  -36,  -42,   33,   12,  -29,   10,  -15,
	   0,   -1,  -22,   24,   27,    8,   15,    7,   16,  -13,    9,   33,    8,   -4,   33,   70,
	  21,  -26,  -18,  -15,  -22,  -76,   -2,   15,  -35,   -4,    8,    5,   -3,  -45,    6,   24,
	 -20,    6,  -15,    8,   -1,    2,    7,   -4,   39,    4,   22,   34,  -25,   26,   -1,  -31,
	  -4,   10,    2,   22,  -25,  -19,   -2,   -2,  -44,  -29,  -17,   10,   -6,   29,   -8,   12,
	  18,   -9,   -6,  -36,    4,  -14,   -8,   10,  -12,   28,    9,   16,   17,  -29,   26,    0,
	   1,   11,  -13,   11,    1,    7,   -7,   -3,   -5,   22,  -10,   10,  -29,   22,  -29,  -30,
	  29,  -30,    3,  -43,   21,    5,  -18,    6,   -5,   23,   18,  -31,   35,   28,  -19,    9,
	  13,   10,   -3,  -10,   37,  -69,    7,   11,  -16,    8,  -76,   11,   58,  -57,   18,   -7,
	 -11,   26,  -40,  100,  -53,   -1,   14,    3,  -26,  -35,   21,   20,  -30,   10,  -26,   37,
	  25,  -97,  118,  -72,   37,   11,  -15,   52,  -22,    6,   85,  -32,   24,  -63,   48,  -60,
	 -19,    3,  -28,  -19,    7,  -28,   15,  -22,    7,   20,   -7,   16,  -13,    8,   25,  -27,
	   2,    7,  -18,   15,  -30,   23,   -3,   28,  -31,   34,   22,  -23,   -6,   -6,   28,  -68,
	 -10,   -3,  -22,   12,  -43,   70,  -52,   32,    8,   -4,   55,  -14,   19,   21,   45,  -13,
	 -33,   -9,   20,  -22,  -14,    9,  -21,   -2,    6,  -56,   17,  -26,   23,  -13,   -8,   -1,
	   3,   31,   16,   20,  -12,  -10,   50,  -27,  -17,  -13,  -26,   29,  -23,   -7,   58,  -40,
	 -20,   16,   16,  -13,  -65,   63,   18,  -25,   23,   -3,    6,   11,  -11,  -24,  -19,    8,
	  32,  -44,   47,  -50,   26,    6,   43,  -58,   15,  -21,   46,  -81,   60,  -28,   65,  -37,
	  42,   42,  -55,   -6,  -23,   -9,  -52,  -25,   -5,    7,  -67,   26,   59,  -62,   31,   63,
	 -23,   52,  -16,   27,   14,  -13,   19,  -41,   -8,   37,   -7,    9,  -33,   16,    7,   36,
	 -40,  -26,  -26,   49,   -3,    3,  -50,   33,   23,  -10,  -13,  -14,  -19,  -13,    1,    2,
	 -41,  -19,   32,   -3,  -29,    9,   58,    1,    9,   15,   19,  -19,   59,    2,    6,   -6,
	 -24,   52,  -67,    3,    5,  -37,    3,   31,  -42,   45,   -1,  -31,   -6,   19,   11,  -17,
	  -5,   -2,  -22,    3,  -35,   35,  -39,    8,   17,    6,    7,  -32,    2,   -1,   40,  -32,
	  -2,   26,   -5,    2,   -5,  -12,   18,   21,  -15,   29,  -28,   13,  -23,   36,   28,  -75,
	  55,  -53,   50,  -45,    9,   -3,   42,  -10,  -33,    8,   -9,  -17,    8,   13,  -13,   34,
	 -48,   39,   -5,  -26,   24,   19,  -34,   29,  -41,   22,  -42,  -11,  -15,   37,    0,  -31,
	  15,    4,   11,   18,  -28,   23,   -3,  -52,   33,   -1,   -8,   19,  -39,   44,   -3,  -16,
	  31,    7,  -17,   38,  -44,   62,  -21,    0,   -7,  -13,   25,   12,  -50,  -13,    2,    9,
	 -47,   43,  -29,  -12,   -3,   -3,  -37,  -22,    0,   -6,   60,  -69,   27,    9,   12,   13,
	  -7,   46,   43,   -2,    3,   -5,   -5,   17,   13,  -37,   35,  -39,  -38,   33,  -44,  -10,
	  11,   -9,   50,  -68,   26,  -22,   10,  -20,   34,  -13,  -17,   21,  -34,   -1,   42,  -23,
	  -7,    9,    3,    1,   -1,   -9,   36,  -15,    5,  -21,   40,  -47,   25,  -11,   20,   24,
	 -19,   16,  -13,    6,  -25,   -2,   19,  -17,    7,  -36,   28,   -8,  -28,  -11,    9,   25,
	 -55,    7,   39,  -36,   -3,    8,   28,   25,  -33,   29,    1,  -28,   -1,   -7,   40,  -50,
	  22,   15,   21,   -2,   -1,   18,    8,   46,  -52,   -1,   14,  -39,  -10,   18,  -10,  -27,
	 -15,   -9,    2,   -7,  -47,   23,   17,  -40,   12,   37,  -24,   22,    9,    5,   27,  -14,
	 -17,  -17,   23,   16,  -18,   19,   32,  -19,  -10,   13,   12,  -33,   31,   -4,   12,  -17,
	  22,   -3,   -8,  -33,   16,  -45,  -17,  -13,  -24,   23,   19,  -22,   52,  -63,   23,   26,
	   8,  -11,   30,   40,  -35,   28,   -5,   11,  -10,  -16,   18,  -35,  -21,   -6,    9,    0,
	 -33,    9,  -15,  -24,   15,  -23,  -19,   30,   13,  -20,   37,   24,  -48,   47,   21,  -31,
	  51,  -22,   40,  -24,   47,  -55,   31,  -21,  -57,   15,   -7,  -28,    5,   25,  -12,  -42,
	  46,  -43,  -21,    6,    4,   14,  -15,   11,   51,  -27,    6,   21,  -27,   42,   17,  -35,
	   3,    3,  -15,   11,   17,  -26,    0,    6,   11,   18,  -37,    4,   28,  -14,  -14,  -30,
	  43,  -50,  -17,   55,  -50,   16,  -32,   51,  -35,  -13,   -4,   54,  -22,   23,  -48,   51,
	   2,   10,  -16,    7,  -10,   15,  -48,   25,   -5,   -4,    6,   21,  -17,   -2,   30,  -23,
	  16,   -3,  -12,  -11,   21,  -57,    3,   10,   -3,    0,  -19,   36,  -42,   50,    0,  -30,
	  55,  -15,   12,  -10,   28,  -47,   29,  -16,    6,  -37,   -1,   -6,    3,  -45,   35,  -30,
	   8,   -4,  -12,   32,   42,  -23,    3,    5,   30,  -38,   15,   16,  -36,   60,   -1,  -53,
	  28,  -25,  -10,   45,  -20,    2,  -22,   24,   -6,  -19,  -31,   18,    6,  -56,  -15,   -3,
	  -5,    1,   12,    5,   -7,   70,   -9,   -7,   49,  -31,   48,   36,  -15,    5,  -23,   35,
	 -51,    4,  -32,  -40,    7,  -20,  -15,   -7,   17,  -32,   -2,   17,    1,   -8,   46,   -4,
	  12,   15,   41,  -50,   29,  -21,  -13,   10,  -20,   12,    2,  -24,   12,   -1,    6,    8,
	 -29,   19,  -27,   51,  -67,   83,  -44,  -22,   21,   -2,  -14,   13,  -52,   72,  -37,   19,
	 -25,   43,  -37,  -22,   19,  -12,  -36,   14,   17,   -3,   27,  -39,   58,  -23,    1,   14,
	  52,  -25,   15,   -1,    1,  -23,  -11,   -9,    4,   14,  -83,   23,    4,  -38,  -21,    2,
	  -1,   17,    2,   48,  -30,   24,   29,    9,   19,  -44,   46,   22,    5,  -32,   39,    0,
	 -28,  -27,   16,  -32,  -31,    7,  -17,  -13,   -9,   -6,   14,  -33,  -18,   35,  -39,   52,
	 -40,   31,   12,   14,  -24,   52,  -35,   11,    1,   26,   10,  -18,   20,    7,   -7,   -5,
	   7,    5,  -15,  -10,   -7,    8,  -10,  -26,   21,  -16,  -14,   13,  -27,   27,  -44,    6,
	  18,    6,  -12,   -4,  -11,   12,   -1,    7,    6,    3,   20,   -5,   11,   15,    9,  -10,
	  37,  -37,   -3,   11,  -23,    9,  -35,   19,  -32,    4,   14,  -28,   41,  -42,   43,   -5,
	  11,  -20,  -16,   20,  -10,    6,    6,   -4,    1,   -6,    7,   20,  -42,   25,  -29,   34,
	 -31,  -10,   14,   -4,   -9,   -4,   13,    7,   -7,   -2,  -19,   25,  -10,    0,   16,   -1,
	  -9,   -6,   53,  -52,   10,   -7,    5,  -10,    1,    4,    9,  -24,   10,  -21,   61,  -40,
	   3,    3,   12,  -38,   31,   -3,   -7,    8,  -13,    8,  -15,    4,  -33,   44,  -29,    5,
	   5,   37,  -52,   16,  -13,   25,    7,  -34,   17,   -7,   14,  -11,   24,  -32,   22,  -23,
	  42,    5,  -30,   21,   19,  -21,    2,  -11,   14,  -18,  -16,  -34,   41,  -30,    7,    2,
	 -23,   20,  -37,   26,  -17,   18,  -37,   64,    0,   14,  -19,    5,   12,   -8,  -13,   22,
	  -9,  -26,   24,   17,   -8,    3,   -5,  -14,  -14,   17,  -30,   14,   26,  -67,   38,   -9,
	 -20,   11,   11,  -22,   11,   15,    1,   11,  -22,    0,    1,   38,  -43,    2,   15,  -31,
	   2,   -5,   29,  -18,  -27,   21,   -8,   15,  -20,   46,  -24,   20,   16,   -7,   24,  -63,
	  40,   -8,    9,   -8,   14,  -10,  -11,  -28,    4,   10,    8,  -26,   13,   11,  -35,   -1,
	  40,  -36,   -5,   -3,   38,   -7,  -23,    3,    4,   17,    3,  -15,   11,   24,  -67,   26,
	   2,   21,  -54,   30,   14,  -34,   12,   25,  -16,   12,  -13,   -7,   47,  -24,  -23,    7,
	  18,   -4,  -19,   31,  -18,  -14,  -11,   21,  -15,    5,  -31,   40,  -53,   21,   -4,   30,
	 -32,   -3,   14,   -5,   30,  -17,    3,   13,    8,   -4,   -5,  -11,  -12,    8,   -7,   16,
	  10,  -21,   35,  -59,   13,   10,   -3,   -7,    1,    2,  -16,   -4,   27,  -43,   35,  -16,
	 -14,   36,    0,  -51,   13,   31,  -19,   14,   21,  -19,   14,   -3,  -27,   29,  -10,   34,
	 -46,   30,  -12,  -17,   11,  -34,   23,  -23,   10,   -3,    4,   -8,  -14,   25,  -16,   35,
	 -12,   22,   -7,    3,    9,    0,   11,   -5,  -10,  -16,    9,  -21,    7,  -36,   -4,  -13,
	   4,   -6,   -7,   -2,   -1,    0,   14,   16,  -15,    7,   27,  -28,   43,  -32,   17,    7,
	 -25,   33,   -7,    6,  -10,   11,  -20,    1,    5,   28,  -11,  -26,   20,  -17,   29,  -40,
	   1,   -6,   13,  -23,   23,  -23,  -28,   18,    5,  -22,   16,  -19,   41,   -9,  -16,  -11,
	  45,  -17,    6,  -51,   34,   36,  -44,   29,  -33,   22,  -13,    3,    5,  -26,    2,   11,
	  23,  -17,    0,   -7,   12,    3,  -27,   18,   13,   -2,  -30,   22,   -6,    7,    1,   -4,
	   5,   -1,   12,  -14,    1,  -15,   -5,   12,    6,    3,  -13,   15,  -14,   14,   -1,  -12,
	   3,    3,   -4,  -18,    7,    2,   -7,   -5,    9,  -15,    7,   17,  -27,   45,  -52,   60,
	 -15,  -12,   -9,  -11,  -14,   27,  -18,   -9,   21,  -10,   10,    3,  -23,   -4,    8,  -23,
	  19,  -31,   12,   18,   12,   -7,    1,   15,    3,   27,  -38,   -7,   42,   -9,    1,   -7,
	 -22,    5,  -10,    0,  -28,    5,   12,   -6,    0,  -12,  -15,   18,   19,  -14,  -27,   47,
	  -6,   -1,  -21,   32,  -31,   52,  -41,    3,  -39,   34,  -29,   16,    8,   -6,   33,   16,
	 -23,  -10,   16,    9,    2,  -33,   40,    0,  -21,   -2,  -18,    1,   13,  -32,   24,  -11,
	 -14,   24,  -20,    0,  -19,   11,   23,    1,  -30,    4,   38,  -23,   11,    0,    9,   18,
	 -36,   10,  -21,   -1,   -5,   -1,   23,  -24,    9,   27,  -13,    4,  -39,   60,  -17,  -11,
	 -12,   25,   -9,  -36,   26,   -7,   -3,   28,  -27,   26,  -12,  -20,    8,   13,  -40,    7,
	 -23,   38,  -33,   14,    8,   -1,  -23,   36,  -19,   15,   13,  -36,    4,   17,  -32,   31,
	 -23,   20,    0,   23,   -3,    5,  -17,  -11,   12,  -24,   21,  -29,   34,  -26,   -1,    4,
	 -14,   21,    9,   -1,   -1,   21,  -33,   29,    1,  -28,   28,  -20,   22,  -24,  -13,  -13,
	  -6,   10,  -22,   33,  -49,   17,  -24,    1,   22,  -11,   43,  -27,   28,   28,  -33,   36,
	   5,   -5,    2,   22,  -28,   16,  -24,  -16,    4,  -69,   66,  -47,  -12,   19,  -17,   -1,
	  24,  -32,   46,  -36,   -3,   50,  -26,   24,  -22,    9,   39,  -53,    0,   32,   -1,  -21,
	  29,  -26,   -4,   29,  -45,   12,  -10,   11,  -12,   20,  -23,  -11,   20,   10,   -1,  -24,
	  33,  -16,   12,    2,    4,   14,  -17,  -17,   20,  -42,    6,  -18,    0,   -4,  -10,   11,
	   2,  -10,    4,    7,    2,   27,  -35,   11,   12,    4,  -11,   19,  -19,   40,   -6,  -16,
	  44,    2,  -10,   32,  -37,    1,  -23,   -8,   23,  -59,   11,   -5,   -9,   -9,   -1,   -8,
	   5,  -18,   26,  -14,   27,  -10,    9,   30,   23,  -31,   30,   -1,   -1,  -14,  -13,   35,
	 -76,   42,  -79,   43,  -29,    1,    2,   -5,   -6,    5,   30,   15,  -20,   23,   25,  -37,
	  39,   -5,  -20,   24,   -7,    2,   20,  -38,   20,  -31,  -12,   -2,  -12,   13,  -31,   10,
	  -9,    0,  -11,   27,  -16,   10,   -2,   44,  -46,   18,   33,  -16,  -12,    3,   11,   15,
	 -26,    8,  -22,   19,   -3,  -11,    5,  -48,   31,   16,  -15,   -5,   -2,   17,    6,   -9,
	  -8,    9,   25,   -7,    0,    7,   -8,   -5,   10,  -11,  -26,   26,  -15,   17,  -31,  -11,
	  15,   -1,  -16,    1,   10,    4,   -7,   18,   -6,    2,   11,   -2,   11,  -26,   -4,   25,
	 -27,  -19,    7,   29,  -29,   13,  -10,    3,  -27,   31,  -55,   38,  -13,   17,   -9,   32,
	 -27,   17,   18,   -3,  -10,   17,  -45,   58,  -12,  -18,   25,    4,  -40,   35,  -61,   10,
	  -3,    2,  -15,  -14,   33,  -20,   -2,   -4,  -19,   31,  -29,   25,    8,  -11,   -3,   32,
	   1,  -26,   12,   25,  -42,    5,   27,    1,    2,   17,  -25,   -2,    6,    9,  -17,    9,
	 -11,    9,    9,  -21,   11,   15,  -55,   34,  -24,   -6,   -1,   -9,   17,  -13,    1,  -11,
	  31,  -24,  -15,   38,  -21,   27,  -30,   30,  -35,   28,   15,  -30,   56,  -40,  -17,   39,
	  -9,   -7,    4,  -18,    7,   13,  -25,    3,   -9,  -13,  -13,   27,  -35,   13,    0,    6,
	  -3,   26,  -20,   27,  -23,   25,  -25,   38,   -2,   -3,    8,  -11,    0,    0,    0,  -28,
	  28,  -27,   -6,   23,  -33,   -8,   -1,  -29,    0,    2,   26,  -40,   15,    2,   23,   28,
	 -32,   17,   26,  -17,   10,    1,  -14,   17,    1,   14,   -9,  -10,  -15,   12,   -3,  -19,
	   2,   20,  -19,  -19,  -14,    4,   -2,   -8,   13,  -16,   22,   -9,   28,    7,   -9,  -22,
	  49,  -28,    3,   -5,    9,   -2,    5,  -26,   39,  -12,  -29,   19,  -11,    7,  -33,   27,
	 -32,   15,   -9,   -9,   16,   -7,   -3,   27,   -4,  -18,   19,   23,  -20,    3,    2,   11,
	 -21,   14,    4,  -13,    8,  -15,    9,    4,  -37,    9,  -11,   22,  -20,  -12,   17,   12,
	 -20,   -2,   13,   18,  -19,   -1,   19,  -28,   12,    2,   12,    2,  -37,   12,   21,  -19,
	 -23,   17,   21,  -35,    9,   26,  -20,  -15,   12,   14,   23,  -20,   17,    9,  -16,   -4,
	   5,    3,   -8,  -24,   13,   -5,    5,   -7,  -11,   31,  -24,  -34,   28,   -8,  -26,   16,
	  -7,    2,   -2,    9,  -21,   42,  -54,   34,   42,  -22,   16,   -1,   14,  -15,  -12,   21,
	 -16,   -3,  -18,   55,  -46,   11,    6,  -19,   18,  -36,   -9,   12,  -21,   23,  -41,   37,
	 -12,  -10,    1,   13,   -5,   -7,   42,    2,    1,   -2,    4,   -3,   15,  -53,   27,   -3,
	 -26,  -14,   32,  -30,   -5,   11,   12,   -3,   -4,  -24,   35,  -37,   12,    4,    5,  -17,
	  32,    0,  -18,   41,  -41,   43,   -2,   22,  -36,    7,   -5,   11,  -25,    7,  -29,    9,
	   2,   -4,  -11,    5,   -2,   15,  -31,  -11,   24,    3,  -15,   26,   11,  -10,   18,    5,
	  -8,   -2,  -43,   43,    2,  -43,  -20,   25,    4,   -3,   39,  -11,   -6,   -3,   -1,  -12,
	  22,  -21,    6,   22,   -7,  -17,   -5,   18,   -4,  -14,    3,   18,  -11,  -18,   -3,   -2,
	   2,   -5,    1,   10,  -28,   17,    8,   -8,  -12,   23,  -13,   10,    0,  -12,   14,   11,
	 -11,   34,  -21,    3,    1,   -9,  -17,    1,    9,  -28,    5,  -34,   21,   -8,    8,    8,
	 -13,   18,    2,  -15,    5,   -3,   11,   -2,   11,   -2,   15,  -10,   14,    5,   -1,   18,
	  -6,    1,  -26,   13,  -25,    2,    6,  -39,  -14,    0,   -5,   13,  -22,  -14,   34,  -22,
	  -1,   16,  -13,   11,   32,  -10,   31,   -5,   18,  -21,   34,  -47,   32,   -9,   10,    8,
	 -31,    5,    4,   -9,    5,  -52,   16,  -14,    4,   20,  -11,  -13,   13,  -10,  -12,   11,
	  16,  -20,   13,  -12,   14,   10,    1,  -15,   32,  -24,   18,    0,    5,  -26,    6,   16,
	 -23,  -10,   12,  -40,   17,  -14,  -13,   38,   -5,    5,  -19,   -3,   17,   14,   -8,    8,
	 -15,   21,   -6,   10,  -12,  -16,   27,    6,  -35,   16,  -26,   45,  -25,   -1,   -9,   29,
	 -25,    8,  -31,    9,   25,  -10,    4,   11,  -22,   -5,    1,  -12,    6,  -10,  -11,   17,
	 -31,    5,   21,   -6,   33,  -55,   47,    6,   -6,    2,   11,   14,  -11,   10,  -14,  -26,
	   8,  -18,    4,   11,    6,   -4,   -2,  -20,   -2,  -26,   38,    4,  -24,   -6,    7,   22,
	 -15,   30,    0,   13,    3,  -11,    4,  -10,  -28,   38,  -14,   -9,   -5,  -45,   40,  -21,
	 -28,   31,    0,   -9,   18,  -45,   20,   12,  -20,   39,  -25,   14,    1,   17,   -4,   29,
	 -12,   26,   -8,  -21,  -19,   10,    3,  -31,   34,  -16,  -12,    5,  -14,   -4,  -13,   13,
	  -7,   13,  -15,  -23,   40,  -27,   15,    4,  -11,   23,  -20,   -2,    7,    8,    3,    2,
	  -4,    1,    7,  -22,   42,  -37,   24,    1,   -9,   16,  -31,    9,    6,   -3,  -25,   40,
	 -41,    0,    2,   -7,   18,    0,  -10,   21,   -5,  -17,   29,  -37,   27,    3,  -22,   10,
	  11,   -5,   13,  -17,   15,  -19,  -23,   17,  -10,  -35,   20,    4,   -4,    3,  -10,    7,
	  15,  -14,   10,   -3,   10,  -25,   13,    1,   20,  -13,   13,   19,  -38,   18,   -4,   19,
	 -10,    9,  -27,   19,  -35,   -8,  -10,   39,  -14,    2,   14,   36,  -16,   -8,   -8,   -7,
	  -2,  -11,    4,    1,  -42,   51,  -17,   10,  -15,  -33,   29,  -25,   -7,    6,    2,   11,
	   3,  -20,   37,  -28,    6,   34,  -22,    5,   28,   -4,   17,    5,  -47,   28,    1,   -3,
	 -21,    8,   -6,   -7,   10,  -15,    6,  -30,    6,  -19,    1,   -4,   30,  -22,   29,  -13,
	  -4,   -2,   11,   -1,  -15,   38,   -4,   -9,   25,  -29,  -17,   10,   -2,   -3,    7,  -15,
	  24,  -26,   21,    2,    6,  -20,   10,  -26,   41,  -33,   19,  -11,    6,   -3,   -9,    5,
	   3,  -21,    8,   -5,   -7,   10,   13,  -10,   -3,   -4,  -10,   26,   -1,    1,    5,   11,
	  -3,    2,   23,  -35,   21,  -43,   17,   -4,    2,  -24,   14,  -22,   -3,    3,   -5,   -2,
	  12,  -13,   16,   -5,    7,   17,    4,  -44,   26,   17,   -4,   36,  -58,   43,  -20,    8,
	   3,  -23,  -18,  -17,   16,    4,    3,  -33,   15,   -4,  -10,   19,  -20,   23,   13,   -6,
	  -4,   25,  -12,   21,   -9,   -4,    6,   -1,   23,   -7,  -15,    3,  -15,    3,  -13,  -23,
	  -3,  -32,    4,    6,  -18,    0,   11,  -14,   42,  -37,   26,  -20,   50,  -18,   18,   11,
	   4,   18,   -5,    8,  -22,   30,    5,  -20,   16,  -20,  -28,    2,    4,  -10,  -10,  -10,
	 -27,   38,  -38,   14,  -17,  -20,   34,  -11,   -5,   -5,   10,    5,   25,  -20,   -2,   28,
	  -8,   26,  -39,   68,  -50,   53,  -35,   -5,    3,  -23,   24,    8,  -21,  -28,   19,    6,
	 -18,  -13,   -7,   26,   -7,    0,   -4,    7,   -7,  -15,   29,  -10,  -12,   13,    9,   -4,
	 -34,   39,  -49,   38,  -31,   29,  -26,    2,  -18,   45,    3,  -16,   -2,   29,    4,  -27,
	   2,   17,    6,  -12,   -3,   12,  -12,  -14,  -22,   11,  -13,    6,   -2,   30,  -39,   12,
	   5,   10,  -18,    3,   -5,   24,  -39,   15,   49,  -42,   19,    9,  -25,    5,  -60,   31,
	 -19,   -8,    9,   28,   28,  -34,   21,   -4,   25,   24,  -18,   17,  -35,    1,    7,  -28,
	  32,  -29,    6,    7,    4,  -23,   21,  -17,  -14,   16,  -29,   21,  -43,  -24,    2,   58,
	 -33,   60,  -20,   24,  -29,   18,  -24,   29,  -14,   -6,   10,  -19,   15,   38,  -38,   35,
	 -15,  -11,   20,    9,  -57,   -4,    0,   -8,   15,   -8,  -20,   -6,    9,   21,    8,  -21,
	  12,    1,    6,  -29,   24,   17,    6,  -33,   26,   20,  -12,   14,  -17,    3,   -2,  -19,
	  -6,   13,  -55,   -5,    5,    8,   21,  -12,   11,  -13,   15,  -34,   45,  -47,   43,   -6,
	   5,   34,  -32,   28,  -15,   12,  -38,   30,  -16,    1,   -4,   -2,    6,    4,  -26,    2,
	  21,  -42,    5,   19,  -20,   44,  -70,   38,   -5,   -4,   -8,   20,  -16,   22,  -25,   46,
	 -21,    1,  -31,   48,  -32,    7,  -23,   62,  -48,   38,   -2,  -30,   41,  -57,   41,  -41,
	   9,   -5,   16,    9,    1,  -50,   80,  -48,    5,  -20,   11,   -9,  -19,   -8,    1,   20,
	 -24,    4,   36,  -42,   42,  -32,   39,    6,  -12,    1,   12,    3,  -17,    2,  -13,   57,
	 -70,   26,    6,    0,  -23,    8,    4,  -17,  -10,  -41,   34,  -10,  -46,   51,   23,  -10,
	  -4,  -10,   16,   -9,    4,   32,  -14,    6,   -7,   23,  -18,   -9,    5,  -14,    4,   15,
	 -29,   10,   15,  -14,   19,  -28,   40,  -30,  -20,   17,    3,    5,   37,  -32,   12,    0,
	 -18,    1,   -7,  -23,    4,  -51,   69,  -22,  -43,   30,  -39,   54,  -64,   29,   21,   -2,
	   2,  -22,   29,    2,   14,    5,    8,   -7,    7,   34,    2,  -25,   10,   -7,   -5,   24,
	 -64,   -1,  -18,   -7,   23,  -24,   26,  -23,  -35,  -17,   51,  -60,   53,   -2,   14,   17,
	   6,    5,   11,   -9,   15,   21,   -1,   21,  -49,   45,  -34,  -16,   12,    0,  -34,    2,
	 -67,   50,  -48,   23,  -20,  -12,   20,  -22,   32,  -15,   15,  -23,   65,   -9,   33,   26,
	  -3,    4,   14,    8,  -17,  -17,  -47,   57,  -63,   13,    8,  -30,   -8,  -31,  -12,   28,
	 -45,    9,   -3,   19,  -31,   31,   -2,   41,  -46,   38,   38,  -23,   21,  -13,    9,   35,
	  -2,    5,   13,  -36,   -2,  -10,   15,  -16,  -48,   22,   29,  -49,  -21,   15,  -10,  -15,
	 -23,   26,   40,  -39,   26,  -10,   13,   21,  -46,   35,  -20,    8,   -1,   30,   17,  -64,
	  22,    2,   22,  -30,    6,   19,  -18,  -34,   38,   -4,   13,    0,  -11,   50,  -51,   21,
	 -10,   13,  -42,   -9,   45,    4,  -82,   12,   37,  -11,  -12,   -8,   21,    6,  -33,   32,
	 -14,    6,   13,  -44,   37,  -22,   20,    2,   12,  -15,   26,   30,  -17,  -11,  -30,   18,
	  -4,   -5,   11,   -2,  -22,  -15,   25,  -16,   11,  -15,   21,   -8,  -17,   -9,   27,   11,
	 -43,    2,    4,   31,  -59,   -5,   44,  -16,   26,  -13,    3,    1,   -1,  -40,   70,  -44,
	  43,  -15,    2,   22,  -36,   13,   41,  -43,  -12,    4,   12,  -34,  -22,    9,   22,  -23,
	 -22,   27,  -24,   22,  -18,   45,   12,  -32,    7,   17,  -24,  -15,    4,   20,    6,  -40,
	  29,   48,  -64,   28,   -3,   -6,   43,  -22,  -34,   36,  -41,   13,   -2,  -59,   72,  -53,
	  39,  -30,   -3,   16,   29,  -40,    5,   30,  -21,   15,  -35,    9,   14,    2,    4,  -16,
	   4,    8,   14,    1,   30,  -32,    5,  -14,   28,  -26,   -1,  -12,  -16,   -4,  -22,   -5,
	  28,   -8,  -24,    7,   42,  -22,   -3,   -9,   16,   38,  -42,   25,    8,   10,   -9,   38,
	 -28,   31,   -8,  -34,   22,  -70,   21,   15,  -36,  -10,  -15,   -1,   49,  -37,  -17,   51,
	 -24,   11,   30,  -27,   33,  -39,  -12,   36,   -4,  -49,   38,   12,   10,  -17,  -11,   59,
	 -26,  -59,   33,   28,  -37,   17,  -39,   40,  -16,  -29,   28,   14,  -19,  -14,   18,   23,
	 -17,  -16,   15,  -11,    9,  -16,   45,  -25,  -27,   -1,   40,  -36,    1,   19,   -1,  -14,
	  -3,    1,   29,   -9,  -58,   54,  -12,  -19,   16,   13,   29,  -74,   48,  -20,   22,  -66,
	   3,   23,    2,  -31,   11,   41,  -41,    2,   25,    4,    8,   -3,    8,   23,  -10,   -6,
	  27,   -1,  -67,   31,  -29,   29,  -29,    0,   17,  -20,  -18,  -10,   29,  -45,   43,  -35,
	  61,    4,  -49,   31,  -10,   53,  -60,   19,   11,   15,  -22,   -3,  -20,   26,    3,  -60,
	  59,  -41,  -26,   17,   22,   12,   -6,  -12,   30,  -14,   -8,   -7,   16,   54,  -34,  -18,
	  26,  -15,  -11,    7,  -44,   39,  -52,   48,  -53,   18,  -38,    3,   13,  -11,   37,  -12,
	  11,    9,   14,   -7,   40,  -19,   -6,    6,  -15,   29,  -34,    1,   18,  -18,   -9,  -24,
	 -30,   17,  -50,   31,    4,    8,   17,   -7,   -5,    0,   17,   25,   16,   15,   43,  -54,
	  39,  -10,    2,  -40,  -23,   26,    3,  -61,   -2,   15,   -6,  -56,   46,   -2,   16,  -80,
	  43,   52,   -9,  -30,   41,   17,    2,  -33,   -7,   52,   -7,  -29,   31,    0,  -23,   10,
	 -24,   44,  -82,   18,   45,  -14,  -40,  -40,   40,   12,  -66,    0,   74,  -35,   -5,   17,
	  67,  -59,   32,   -4,   29,   -1,  -48,   39,    1,    8,  -63,   43,  -12,  -37,   -5,  -12,
	  25,    2,  -21,    7,   24,  -34,  -11,   19,   28,    6,  -34,   44,   13,  -35,  -19,   28,
	 -50,  -13,   56,    7,  -32,  -12,   19,    6,   -1,   -6,    6,    0,   17,  -26,   41,  -20,
	  -5,   -6,   43,  -58,   10,  -12,  -14,   74,  -84,   74,  -28,  -15,  -27,   19,  -15,   -3,
	  17,   24,   10,  -60,   64,    0,   -9,  -39,    1,   25,  -12,  -25,   22,    8,  -21,  -40,
	  73,  -32,  -18,  -11,    6,   57,  -52,   36,  -19,   37,  -40,    9,    2,   14,  -15,   27,
	 -33,   35,    7,  -37,   24,   10,  -66,   17,    1,  -10,   13,  -38,   15,   -9,   43,  -30,
	  19,  -15,   17,   -8,    7,    8,  -38,   66,  -55,   10,    9,  -37,   37,  -32,  -11,   47,
	 -14,   11,   37,  -41,  -33,   12,    3,   34,  -59,   35,   14,   -4,   -7,   -2,  -21,   48,
	 -52,   49,   -8,  -44,    0,   11,   -6,   -2,   11,  -35,   64,  -38,  -35,   64,    7,  -32,
	  15,   15,   19,  -39,   18,  -31,   25,    6,  -28,   25,   17,  -34,  -26,   21,  -18,   15,
	 -15,  -31,   24,   -4,  -26,   41,   -2,  -18,  -24,   75,  -21,    1,   -6,   -2,   16,   12,
	 -24,   15,    8,  -14,    7,    7,   -4,  -37,   45,  -67,   39,  -41,    9,   19,   13,  -60,
	  44,  -22,   23,    2,  -35,   14,   35,  -25,    7,   21,  -39,   15,    1,   39,  -43,   26,
	 -18,  -14,   36,  -10,  -16,  -15,   29,  -34,   16,   -1,  -13,   24,    0,  -43,   55,  -18,
	 -31,   22,  -15,  -15,   43,  -33,   50,  -10,  -43,   22,  -27,   60,  -30,   14,    0,   10,
	  -3,   10,  -20,   11,  -34,   -7,   70,  -59,  -26,   25,  -23,    7,  -29,    8,   11,  -13,
	  -8,    3,   13,  -13,   35,   -8,   34,  -33,    9,   30,   -5,   33,  -37,  -10,   56,  -38,
	  -5,   14,  -50,  -24,   39,  -11,  -11,  -27,  -22,   46,  -13,   -6,   -1,   -6,   37,  -56,
	  48,  -11,   24,  -14,   32,  -13,   -1,    5,    8,   37,  -86,   36,   -1,   -6,  -12,   13,
	 -40,    3,    9,   15,  -13,  -23,    3,  -15,   61,  -50,  -12,   29,  -14,   -2,   25,  -31,
	  52,  -41,   31,   31,  -27,  -10,    9,   22,  -15,    3,  -11,   22,  -25,    8,  -40,    0,
	  -5,    2,   -9,   40,  -62,    5,   16,   -6,   -7,  -21,   31,   29,  -28,   -3,   47,  -31,
	  51,  -34,   59,  -32,   -8,   44,   -7,   -2,  -20,    3,   64,  -51,  -58,   -3,    0,  -39,
	  26,  -22,   14,  -39,    8,   20,  -30,   -2,    7,    8,   37,   15,   -9,   43,   -5,    2,
	  11,   -5,   10,    2,  -37,   56,  -59,  -11,    8,  -14,  -30,  -29,   -3,   29,   -1,  -33,
	  42,  -44,   53,  -58,   85,  -28,   -5,   -2,   41,    5,   15,  -49,   30,   26,  -46,   17,
	   9,  -55,    0,   38,  -46,   32,  -32,   10,   15,  -60,    8,   23,   -1,    7,  -35,   71,
	 -11,  -39,   39,  -22,   -8,   -3,   10,   36,   13,  -73,   53,  -15,    7,   -7,  -15,   25,
	  -7,  -24,   21,    9,  -51,  -11,   27,  -15,   11,   -6,   26,  -26,   27,   16,  -33,   47,
	 -29,  -18,   53,  -53,   -2,   38,  -29,   12,  -37,   18,   10,  -10,  -20,   -8,   12,   15,
	 -43,   32,    3,  -44,   35,   29,  -38,   17,  -16,   13,   45,  -37,   21,   18,   -7,  -38,
	  32,  -21,   -6,   -4,   20,  -14,   -9,  -16,   14,    1,  -19,  -13,   22,   -4,  -39,   58,
	 -34,    3,   17,  -10,   50,   -3,  -47,   36,   29,  -27,  -13,   39,  -20,   -8,   12,  -40,
	 -20,    1,    0,  -24,   23,  -40,   38,    4,   -1,  -19,   16,   10,   -4,   28,  -25,   44,
	 -17,   19,  -21,   50,  -10,  -16,  -13,    7,  -28,   11,   -9,  -17,   13,  -52,   22,   -3,
	 -21,  -49,   75,  -42,   34,   -3,   18,    1,   10,  -20,   13,   13,   22,  -11,  -35,   46,
	 -29,   44,  -39,  -31,   37,  -22,  -27,   42,  -57,   40,  -34,    4,   12,    9,  -29,   13,
	   6,  -10,    4,   21,    7,  -17,    3,   25,  -18,   44,  -26,   -1,   20,  -38,   19,   24,
	 -35,  -18,   -6,  -14,   23,  -32,  -15,   24,   -6,  -50,   62,  -39,   -3,    0,  -23,   87,
	 -44,   37,   -9,   -4,   67,  -73,   46,   45,  -32,  -14,    8,   -4,  -22,   -5,  -22,  -20,
	  36,  -34,    6,   26,  -35,  -18,   15,    0,  -12,    0,   12,  -10,   28,  -15,   24,   13,
	 -21,   19,   15,  -17,   20,   -7,    0,  -21,    7,  -16,    5,  -12,   -1,  -11,    7,   32,
	 -68,   69,  -55,   24,    2,   -3,   21,  -47,   28,   20,  -15,  -29,   -2,   23,    4,  -18,
	  15,  -22,   36,  -38,   17,  -23,   14,  -18,   17,   31,  -37,   30,    8,   -1,   -3,   -5,
	 -12,   22,  -18,  -28,   33,    0,   -9,  -16,   20,    9,  -26,  -20,   21,    2,   -4,   14,
	 -24,   16,  -11,   12,   -1,  -39,    7,   51,   -2,    1,  -12,  -30,   63,  -43,  -19,   -2,
	  -6,   20,   10,  -18,   -2,   23,   15,   -3,  -34,    1,    9,   10,  -22,  -29,   28,   28,
	 -32,   -2,   23,  -26,    2,   11,   25,  -35,  -14,   15,   23,  -48,   12,    7,   22,  -52,
	  25,   17,   16,  -47,   29,   13,  -19,   12,  -67,   65,   -6,  -30,   32,    7,  -12,   14,
	 -19,   27,  -52,   -2,   15,   40,  -69,   -5,   33,   15,    6,  -51,   36,   21,   -2,  -24,
	  15,   -3,   -9,   -4,   30,  -34,   -2,  -19,   27,  -23,    3,  -12,    2,   18,  -15,   -6,
	  -3,   22,  -30,   55,  -21,   26,  -35,   44,  -27,   25,  -21,    4,   14,  -20,   -1,   10,
	 -42,   12,    7,  -12,    5,  -37,   13,    1,    3,  -33,   24,   15,    0,   -4,   10,  -14,
	  -6,   35,   -6,   -4,   -8,   13,   26,   -7,  -32,   36,   -9,    5,  -15,   14,  -15,  -36,
	   8,    2,  -15,  -22,   -7,   28,   -4,  -25,   17,   39,  -16,    4,   20,    8,    4,   -2,
	   4,   31,  -46,  -12,   15,    0,   -9,  -36,   18,  -10,  -12,    7,  -17,    3,  -13,   -4,
	  37,  -27,    6,  -16,   76,  -41,   13,  -14,   25,   28,  -21,  -10,   31,   -4,  -39,   21,
	  -9,  -35,   12,    3,  -16,    7,  -54,   51,  -34,   44,  -45,   30,   -7,  -30,   49,  -21,
	  -1,   27,   12,   -8,    9,    8,    5,  -27,   42,  -30,   32,  -28,  -27,   19,  -18,  -36,
	  10,  -25,   19,   -9,  -14,   -5,   13,   31,  -21,   22,  -28,   15,   13,   10,  -12,    6,
	  32,    1,   24,  -47,   36,   -4,  -23,    0,  -16,    6,  -41,    1,   17,  -33,   -9,    5,
	  34,   -5,  -15,   -1,   30,   13,  -30,   20,    7,  -12,  -16,   11,   20,   -4,  -19,   21,
	  26,  -25,  -17,   -5,   23,  -32,   -3,  -12,   18,   -5,  -28,    8,   15,  -14,  -10,   31,
	  11,  -43,   12,   35,   -5,    3,  -33,   48,   -1,  -11,   -6,   28,  -23,  -13,   13,    9,
	  -7,  -22,    2,  -25,   32,  -38,   17,  -16,   10,  -54,   69,  -62,   61,  -30,    4,   24,
	   3,  -12,    4,   27,  -22,   22,    0,    4,  -15,    4,  -46,   20,  -16,   29,  -30,   14,
	 -25,   30,  -18,   16,  -12,   -7,   21,  -10,   16,  -23,   15,    9,  -12,   12,   13,  -21,
	  19,  -28,   -2,    5,  -15,    0,    3,  -17,    6,   -6,   18,  -11,    6,   13,   -1,   15,
	 -23,   14,    5,  -17,  -14,    5,   24,  -23,   15,  -26,    9,  -10,   15,  -29,    2,  -12,
	  23,    8,   10,  -37,   26,    7,   -5,  -25,    3,   16,   14,  -10,   -5,  -16,   22,   -7,
	  -8,   18,  -58,   86,  -15,   -5,    4,  -30,   40,   -7,  -21,  -12,    9,  -10,   16,  -48,
	  40,  -29,   -6,   -5,  -22,   21,    3,  -20,   39,  -36,   29,   -5,    2,    3,   15,    2,
	   6,   21,  -11,   28,  -13,    2,  -33,   24,    1,  -28,   12,  -33,   12,   11,    0,  -41,
	  11,   -5,   -9,   26,  -34,   15,    2,   18,   -7,  -25,    5,   11,   -4,   -7,   35,   -6,
	  23,   12,  -42,   33,  -32,   26,  -41,   25,  -23,   15,  -13,   11,   -5,   -4,    0,   -8,
	  -4,    1,   10,    6,   -8,   -7,   18,    8,  -11,  -19,    9,   17,   -2,  -13,    8,  -21,
	  31,  -16,  -24,    3,  -12,   10,   23,   -8,   12,    8,   23,   -7,  -22,   -8,    5,   -5,
	 -14,  -33,    4,    7,  -11,  -11,   15,  -22,   38,   -2,  -11,   24,  -16,   38,   14,   -6,
	   7,  -14,   18,  -13,    2,   -8,  -14,   13,  -19,  -13,    2,    2,  -23,   -9,   11,    1,
	 -12,   16,    1,    2,   18,    1,  -20,    9,   -5,  -14,   16,  -11,    2,    8,   -2,   -9,
	   0,   11,   13,  -22,   18,  -16,   35,  -39,   45,  -22,  -18,   12,    1,  -19,   21,  -48,
	  42,  -20,    9,  -23,   20,  -11,  -27,   21,  -13,  -14,  -11,   29,  -13,   25,  -25,   36,
	 -13,    8,   17,   34,  -14,   11,    4,   -4,  -15,   -9,  -12,    1,   19,  -69,    7,   10,
	 -34,  -20,    1,   -5,   13,    6,   34,  -17,    5,   40,   -1,   21,  -38,   35,   22,   11,
	 -28,   28,   11,  -25,  -26,   12,  -20,  -38,   10,  -16,  -11,  -11,   -6,   13,  -22,  -31,
	  43,  -42,   49,  -33,   20,   17,   13,  -22,   44,  -21,   -4,   14,    9,   33,   10,    0,
	  -1,    0,    0,   -2,   11,   23,   22,   24,   25,   20,   21,   15,   40,   -1,  -24,  -42,
	  -5,  -19,  -11,   -8,    4,  -46,  -31,  -14,  -33,  -40,  -44,  -48,  -89,  -63,  -47,  -33,
	 -27,  -10,   -6,   22,   25,   26,   28,   37,   11,   15,   51,   44,   54,   66,   66,   71,
	 111,   84,   70,   63,   47,   39,   22,   47,  -28,  -79, -111,  -90,  -91, -112,  -81,  -87,
	 -49,  -46,   -5,  -24,   26,   24,   47,   29,   23,   30,   30,   13,   -1,    4,  -14,   17,
	  35,   62,   31,   53,   59,   72,   64,   27,   26,    9,    9,  -61,  -44,  -88,  -74,  -81,
	 -83, -124,  -96,  -37,  -78,  -48,  -56,  -68,  -60,    7,   44,   39,   54,   77,  102,  110,
	 108,   89,  101,  100,  105,   64,   22,   -1,   44,   40,  -19,  -29,  -35,  -16,  -27,  -40,
	 -77,  -82, -113, -104,  -93,  -57,  -72,  -56,   -3,    1,    7,   -1,   49,   39,   30,   31,
	  23,   10,   31,   11,    7,  -19,   -2,   -2,   28,   62,   92,   75,   33,   34,  -20,  -47,
	 -61,  -85, -105,  -93, -119, -112,  -54,  -70,  -67,  -32,   -1,    4,    4,   20,   29,   62,
	  70,   54,   62,   78,  115,   92,   85,   78,   52,   21,   19,   27,    2,   -8,   13,    0,
	   5,    3,    9,   18,    0,  -59,  -61,  -45,  -57,  -65,  -76,  -89, -102,  -48,  -24,   17,
	   6,   26,   33,   35,   26,   41,   63,   20,   12,   29,   34,    8,    7,   31,   21,   31,
	  39,   33,   -5,   -8,  -55,  -57,  -98,  -94,  -88,  -64,  -82,  -74,  -39,  -14,    3,   16,
	  22,    8,    2,   17,    5,   36,   76,   74,   71,   57,   73,   62,   47,   30,   32,   19,
	   4,    7,  -14,  -18,   -2,   17,   -5,   13,   22,   31,   10,    8,  -13,  -47,  -80,  -85,
	 -86,  -71,  -73,  -60,  -35,  -10,    9,   19,   49,   53,   47,   60,   73,   43,   33,   20,
	  13,   -1,   -7,   -7,    7,    9,   -2,    5,  -14,  -40,  -69,  -61,  -66,  -67,  -84,  -58,
	 -58,  -33,    2,   -7,   -5,   12,   32,   18,   25,   19,   24,   65,   59,   62,   64,   63,
	  55,   60,   52,   31,   19,  -12,  -26,   -4,   -7,  -10,   -3,    6,  -22,  -14,   12,   19,
	   4,  -26,  -38,  -40,  -56,  -61,  -66,  -59,  -65,  -51,  -20,   29,   40,   51,   52,   62,
	  61,   53,   26,   20,    6,    8,    6,    9,  -14,  -14,  -15,   -2,  -11,  -23,  -36,  -38,
	 -60,  -77,  -69,  -60,  -51,  -56,  -44,  -27,   10,   -2,   14,   10,   22,   16,   41,   60,
	  39,   35,   60,   62,   43,   45,   63,   52,   17,   12,   15,   -1,   -2,    0,  -38,  -48,
	 -32,  -22,   -7,    3,   13,   10,   -2,   -1,   -8,  -12,  -25,  -48,  -46,  -52,  -49,  -36,
	 -17,    9,   17,   26,   48,   57,   55,   69,   60,   32,    6,    4,   -6,  -20,  -24,   -9,
	 -21,  -25,  -14,  -18,  -38,  -38,  -32,  -51,  -52,  -60,  -34,   -6,   -6,  -16,  -11,   -2,
	  -1,   17,   19,    3,   11,   25,   31,   41,   39,   33,   33,   41,   34,   34,   23,   21,
	  15,    6,  -13,  -24,  -28,  -20,   -8,  -12,  -19,  -12,   -5,    9,   14,    2,  -12,  -25,
	 -28,  -21,  -28,  -23,  -22,  -18,  -26,   -5,   24,   45,   46,   47,   39,   33,   36,   42,
	  29,    7,   -5,  -10,  -21,  -29,  -39,  -39,  -31,  -24,  -29,  -39,  -51,  -43,  -27,  -22,
	 -18,  -25,  -26,  -20,    9,   19,   18,    4,   -2,   19,   30,   38,   25,   24,   28,   33,
	  41,   38,   34,   32,   38,   24,    8,    4,   -8,  -11,  -15,  -25,  -31,  -25,  -20,  -22,
	 -15,  -11,   -9,  -12,  -17,  -20,  -20,  -15,   -6,  -11,   -8,    0,   11,   29,   19,   17,
	  17,   18,   28,   31,   25,   18,   23,   18,   10,    1,   -7,  -18,  -26,  -24,  -30,  -41,
	 -38,  -44,  -32,  -31,  -31,  -35,  -25,  -12,   -2,   -8,  -11,  -13,  -13,   -2,    8,   15,
	  19,   29,   35,   37,   39,   43,   42,   40,   35,   27,   25,   18,   15,    9,    4,   -4,
	 -15,  -28,  -28,  -26,  -28,  -18,  -15,  -25,  -23,  -12,  -11,  -14,  -10,   -2,   -4,   -1,
	   8,   15,   19,   22,   25,   16,   16,   17,    5,    7,   13,   18,   13,    9,    6,    6,
	   4,   -4,  -21,  -31,  -28,  -37,  -39,  -34,  -38,  -38,  -32,  -17,   -6,   -4,  -14,  -19,
	  -9,    3,   -2,    3,    4,    7,    8,   13,   23,   35,   38,   43,   42,   31,   25,   23,
	  17,    8,    3,    4,   -7,   -7,  -10,  -13,  -20,  -19,  -28,  -33,  -30,  -23,  -18,  -13,
	 -17,  -12,    3,   14,   23,   31,   27,   23,   21,   22,   19,   12,    4,    2,    2,   -2,
	   0,    4,   11,   11,    6,    4,   -2,   -5,  -14,  -17,  -30,  -38,  -44,  -42,  -28,  -21,
	 -23,  -21,  -15,  -15,   -4,    8,   11,    4,   -7,  -15,   -7,    5,   10,   21,   26,   28,
	  27,   34,   37,   36,   28,   19,   10,   11,    8,   -2,  -18,  -17,  -19,  -19,  -22,  -24,
	 -21,  -24,  -18,  -17,  -13,  -19,  -13,   -1,   12,   19,   22,   21,   19,   19,   30,   34,
	  24,   13,    7,    2,    1,    1,    2,   -1,   -2,   -6,    0,    0,   -2,  -15,  -21,  -17,
	 -21,  -28,  -32,  -31,  -31,  -32,  -27,  -24,  -17,   -4,    1,   -3,   -1,    1,    4,    7,
	   8,   15,   16,   15,   15,   20,   32,   36,   38,   32,   19,   12,    3,    2,   -2,   -4,
	 -11,  -19,  -17,  -15,  -11,  -16,  -20,  -27,  -30,  -28,  -22,  -13,   -6,   -2,    2,   12,
	  23,   29,   45,   44,   36,   32,   21,   16,   14,   10,    1,   -9,   -8,   -2,   -1,   -7,
	 -13,  -13,  -12,   -9,  -11,  -18,  -24,  -26,  -28,  -30,  -24,  -21,  -21,  -21,  -11,  -11,
	 -10,    0,   -2,    0,    4,   12,   13,   14,   12,   17,   22,   28,   30,   28,   20,   16,
	  13,    8,    2,   -2,   -6,  -15,  -14,  -18,  -15,  -15,  -16,  -18,  -18,  -16,  -19,  -18,
	 -17,  -10,    0,   -1,    4,   13,   22,   37,   39,   36,   27,   27,   32,   26,   15,    6,
	  -1,   -4,   -5,   -7,  -11,  -11,   -9,  -15,  -15,  -14,  -18,  -21,  -19,  -17,  -21,  -19,
	 -15,  -15,  -10,  -15,  -14,  -12,  -11,   -6,   -2,    1,   -2,    1,    5,   14,   22,   33,
	  35,   23,   18,   16,   13,   11,    6,    1,   -9,  -18,  -11,   -6,   -7,   -8,   -9,  -11,
	 -11,  -12,  -13,  -17,  -21,  -24,  -24,  -15,   -4,    7,   12,   17,   25,   30,   28,   31,
	  32,   31,   27,   22,   15,   12,    3,   -2,   -8,   -6,   -3,   -9,  -13,  -22,  -24,  -20,
	 -18,  -22,  -24,  -18,  -14,  -13,  -10,  -11,   -9,   -3,   -2,   -3,   -5,  -10,  -10,   -5,
	  -1,    4,   11,   15,   19,   22,   27,   23,   20,   16,   14,    5,   -3,  -11,  -15,  -16,
	 -12,  -12,  -11,   -5,    1,   -3,  -10,  -13,  -15,  -11,  -10,  -10,  -11,   -8,   -3,    2,
	   7,    9,   15,   25,   30,   33,   31,   25,   21,   20,   16,   13,    7,   -2,   -8,   -5,
	  -4,  -11,  -20,  -21,  -22,  -21,  -17,  -20,  -21,  -22,  -19,  -19,  -11,   -4,   -2,   -2,
	  -2,    2,    5,    2,    0,    0,   -3,    1,    8,   16,   13,   14,   17,   15,   13,    8,
	   5,   -1,   -6,  -10,  -13,  -14,  -14,  -13,  -10,   -7,   -8,   -8,   -6,   -6,   -3,   -1,
	  -1,   -9,  -12,   -7,    3,   13,   17,   14,   13,   17,   22,   23,   24,   18,   15,   18,
	  18,   18,   15,    8,    0,   -5,   -8,  -11,  -15,  -17,  -21,  -26,  -26,  -24,  -26,  -24,
	 -13,   -9,   -6,   -3,   -2,    3,    4,    6,    7,    5,    2,    4,    2,   -2,   -4,   -3,
	   5,   13,   17,   10,    3,   -1,   -2,   -4,   -5,  -11,  -14,  -13,  -11,   -8,   -8,   -8,
	  -6,   -3,    0,   -1,   -5,   -5,    0,    4,    3,    1,    2,    0,    0,    6,   13,   20,
	  17,   17,   18,   21,   18,   14,   13,   11,   11,    7,    9,    3,   -5,  -12,  -14,  -18,
	 -21,  -23,  -26,  -26,  -13,   -3,   -6,  -13,  -14,   -5,    5,    8,    3,    0,    1,    3,
	   6,    4,   -1,   -1,    1,    3,    7,    5,    3,    0,    1,   -1,    3,    0,   -3,  -11,
	 -11,   -9,  -10,   -9,   -8,   -5,   -7,   -7,  -10,   -9,   -6,   -1,    4,    6,    4,    2,
	   5,   10,   13,    9,   12,   13,   14,   15,   16,   13,   12,   10,   13,   14,   13,    8,
	   2,   -1,   -4,   -6,   -9,  -15,  -20,  -21,  -19,  -14,  -16,  -22,  -21,  -13,   -5,   -3,
	  -3,   -1,    3,    5,   10,    9,    9,    6,    8,    7,    7,    7,    3,   -4,   -6,   -4,
	  -1,   -4,   -8,  -10,  -11,   -8,   -4,   -6,  -10,   -7,   -8,  -11,  -11,   -8,   -5,   -4,
	   0,    3,    3,    8,   10,   10,   12,   12,   11,   10,   13,   12,   10,    6,    8,    9,
	   9,   11,   13,   11,    9,   10,    7,    2,   -3,   -8,   -9,  -14,  -16,  -16,  -19,  -18,
	 -14,  -13,  -11,  -11,  -10,   -5,   -1,    3,    5,    2,    2,    9,   14,   11,    9,   10,
	   7,    2,    0,    2,   -2,   -9,  -13,  -15,  -18,  -17,  -15,  -13,  -10,   -5,   -5,   -7,
	  -7,   -4,   -1,    0,   -2,   -4,   -2,    1,    4,    9,   10,   10,   11,   11,   13,   14,
	  10,   11,    9,    9,    4,    6,    5,    4,    5,    7,    8,   10,    9,    4,   -4,   -8,
	  -9,  -10,  -11,  -12,  -14,  -15,  -17,  -15,   -9,   -4,   -1,   -6,   -5,    2,    8,    8,
	   6,    5,    3,    4,    5,    9,   10,   10,    5,   -1,   -5,  -10,  -12,  -14,  -16,  -18,
	 -17,  -11,  -10,  -11,   -8,   -5,   -2,   -2,    0,    3,    4,    5,    3,    2,    3,    5,
	   9,   12,   12,   11,   10,   12,   14,   12,    8,    5,    0,   -1,    1,    3,    0,    1,
	   3,    5,    6,    5,    0,   -5,  -11,  -10,  -13,  -12,  -13,  -15,  -14,   -8,   -4,   -3,
	  -3,   -4,    0,    4,    5,    3,    6,    4,    4,    7,   10,    9,    9,    8,    5,    5,
	   2,   -4,  -10,  -15,  -17,  -20,  -22,  -22,  -19,  -14,  -11,  -10,   -8,   -6,    0,    3,
	   5,    3,    4,    8,   11,   11,   12,   13,   12,   12,   15,   15,   16,   16,   13,   11,
	   6,    3,   -2,   -5,   -5,   -3,   -2,   -1,    2,    0,   -3,   -4,   -5,   -7,  -10,  -12,
	 -11,  -12,  -11,   -8,   -4,   -2,    0,    1,    2,    2,    2,    4,    3,    3,    4,    5,
	   9,   10,    6,    2,    1,    2,    0,   -3,   -7,  -13,  -18,  -19,  -18,  -16,  -18,  -20,
	 -19,  -14,   -8,   -4,   -1,    3,    3,    5,    7,    9,    9,   10,   12,   13,   13,   13,
	  13,   16,   15,   13,    9,    6,    3,    2,    1,    0,   -3,   -5,   -6,   -4,   -2,   -2,
	  -4,   -4,   -5,   -5,   -3,   -3,   -4,   -6,   -6,   -7,   -4,    0,    2,    3,    2,    2,
	   1,    2,    2,    1,    4,    5,    4,    1,    0,    2,    2,    0,   -2,   -6,   -8,   -6,
	  -7,   -9,  -11,  -15,  -18,  -19,  -18,  -18,  -17,  -13,   -9,   -2,    2,    3,    5,   10,
	  12,   13,   14,   14,   15,   17,   17,   16,   16,   15,   13,   11,    7,    2,   -6,  -10,
	  -8,   -6,   -8,   -8,   -7,   -6,   -6,   -3,   -4,   -6,   -5,   -3,   -2,   -2,    0,    1,
	   0,    2,    2,    3,    2,    3,    2,    3,    3,    5,    2,    0,    4,    6,    5,   -1,
	  -4,   -2,   -1,   -2,   -6,   -8,   -9,  -10,  -12,  -10,  -14,  -17,  -22,  -22,  -21,  -19,
	 -15,   -8,   -3,    1,    7,   12,   12,   15,   19,   22,   21,   18,   16,   16,   16,   13,
	  12,    6,    3,    3,    2,   -3,   -6,   -7,  -12,  -12,  -11,   -8,   -9,   -8,   -7,   -3,
	   0,    0,    0,    0,   -2,   -2,    0,    1,    2,    2,    4,    6,    6,    7,    5,    4,
	   3,    4,    5,    3,    0,   -2,   -2,   -4,   -6,  -10,   -8,   -8,  -10,  -11,  -12,  -12,
	 -12,  -13,  -16,  -16,  -16,  -14,  -11,   -8,   -4,   -2,    1,    6,   12,   17,   19,   20,
	  20,   21,   21,   19,   13,   10,    9,    5,    0,   -3,   -4,   -4,   -5,   -6,   -6,   -4,
	  -7,  -10,  -12,  -12,  -12,  -10,   -7,   -4,   -2,    4,    6,    8,    7,    7,    7,    7,
	   8,    8,    7,    5,    6,    6,    4,    1,   -1,   -1,    0,   -3,   -7,  -10,  -10,   -8,
	 -11,  -14,  -14,  -12,  -11,   -9,   -6,   -8,   -8,   -8,  -11,  -13,  -12,   -9,   -8,   -5,
	   0,    4,    8,   11,   14,   18,   18,   20,   23,   23,   20,   14,    9,    4,    0,   -3,
	  -6,   -8,   -8,   -8,   -8,   -9,  -10,  -11,  -10,   -9,   -8,   -8,   -7,   -6,   -3,    0,
	   3,    6,   12,   16,   16,   14,   10,    8,    9,    7,    4,    1,    0,    0,   -2,   -1,
	   0,    0,   -3,   -7,  -10,  -13,  -13,  -12,  -13,  -15,  -14,  -13,   -9,   -6,   -5,   -5,
	  -7,   -8,   -9,   -7,   -6,   -5,   -7,   -5,    1,    8,   13,   17,   19,   20,   21,   22,
	  22,   18,   12,    9,    5,   -1,   -5,   -9,  -11,  -13,  -12,  -12,  -11,  -10,   -8,   -7,
	  -7,   -6,   -7,   -6,   -3,    0,    1,    3,    7,   10,   11,   12,   15,   15,   14,    9,
	   6,    3,    1,    0,   -2,   -2,   -2,   -3,   -6,   -8,  -10,  -11,  -13,  -15,  -15,  -15,
	 -13,  -12,  -12,   -7,   -5,   -5,   -5,   -4,   -3,   -3,   -4,   -4,   -1,   -1,    1,    4,
	   7,   10,   12,   14,   17,   20,   22,   19,   14,    8,    5,    2,   -2,   -5,  -10,  -14,
	 -13,  -11,  -10,  -10,  -10,  -10,   -8,   -6,   -3,   -3,   -3,   -1,   -1,    2,    6,   10,
	  13,   14,   15,   15,   15,   13,   11,    8,    5,    1,   -1,   -3,   -3,   -6,  -10,  -12,
	 -12,  -12,  -12,  -13,  -15,  -18,  -19,  -15,  -11,   -6,   -4,   -3,   -4,   -4,   -2,    1,
	   4,    2,   -1,   -2,    1,    4,    6,    8,    7,    7,   11,   14,   15,   15,   15,   13,
	  10,    6,    1,   -3,   -6,   -9,  -13,  -15,  -15,  -13,  -11,   -9,   -9,   -9,   -7,   -3,
	   0,    2,    2,    4,    7,   11,   15,   16,   14,   11,   12,   13,   15,   13,    9,    4,
	   1,   -1,   -4,   -6,   -8,  -11,  -15,  -17,  -17,  -17,  -17,  -15,  -13,  -13,  -12,  -10,
	  -7,   -6,   -4,    1,    2,    2,    3,    4,    5,    4,    4,    3,    5,    6,    6,    8,
	   7,    7,    9,   11,   10,    9,    8,    5,    2,    0,   -2,   -6,  -10,  -13,  -13,  -14,
	 -14,  -13,  -11,   -9,   -4,   -1,   -1,   -1,    2,    6,    8,   10,   11,   12,   14,   14,
	  14,   13,   11,   10,    7,    4,    2,    3,    1,   -3,   -6,  -10,  -14,  -17,  -18,  -18,
	 -19,  -19,  -17,  -15,  -13,   -9,   -5,   -1,    1,    0,    1,    3,    5,    6,    6,    6,
	   7,    8,    9,    8,    4,    1,    0,    2,    4,    5,    6,    5,    4,    4,    4,    3,
	   1,   -3,   -7,   -9,  -11,  -12,  -12,  -12,  -11,  -10,   -7,   -4,   -2,    1,    4,    5,
	   8,   11,   13,   14,   14,   11,   11,   11,   10,   10,    9,    6,    5,    3,    1,   -2,
	  -5,  -10,  -14,  -16,  -17,  -18,  -19,  -20,  -19,  -17,  -14,  -10,   -5,   -1,    1,    3,
	   5,    6,    6,    6,    6,    6,    6,    6,    6,    8,    7,    6,    4,    2,    0,   -1,
	   0,    0,    1,    2,    1,    1,    2,    1,   -2,   -5,   -8,   -9,  -10,  -11,  -12,  -12,
	 -10,   -7,   -4,   -1,    2,    8,   11,   13,   15,   15,   13,   12,   11,   10,    9,    8,
	   6,    5,    4,    4,    3,    0,   -3,   -6,  -10,  -14,  -18,  -21,  -22,  -21,  -18,  -16,
	 -13,  -10,   -6,   -3,    0,    3,    5,    5,    5,    6,    7,    8,    8,    8,    7,    8,
	   7,    6,    5,    4,    1,    0,   -2,   -4,   -4,   -5,   -4,   -4,   -3,   -2,   -1,   -2,
	  -3,   -4,   -7,   -8,   -9,   -9,   -9,   -8,   -5,   -2,    2,    4,    8,   11,   14,   15,
	  15,   14,   12,   10,    7,    5,    4,    4,    2,    1,    1,    2,   -1,   -3,   -7,  -10,
	 -15,  -18,  -18,  -18,  -18,  -17,  -15,  -11,   -7,   -3,    1,    3,    4,    5,    6,    7,
	   7,    8,    8,    9,   10,   10,    9,    6,    4,    2,    0,   -3,   -4,   -6,   -7,   -7,
	  -6,   -5,   -3,   -2,   -2,   -2,   -2,   -3,   -4,   -5,   -6,   -6,   -6,   -6,   -5,   -4,
	  -1,    4,    7,    9,   11,   12,   12,   11,   10,    9,    8,    7,    5,    3,    3,    2,
	   1,    0,   -1,   -4,   -7,   -8,  -10,  -13,  -14,  -15,  -15,  -15,  -14,  -11,   -9,   -6,
	  -3,    0,    2,    4,    5,    6,    7,    8,    9,   10,   10,    9,    8,    6,    5,    3,
	   1,   -3,   -6,   -8,   -8,   -7,   -7,   -7,   -6,   -4,   -2,    0,   -1,   -2,   -3,   -3,
	  -3,   -3,   -4,   -3,   -3,   -1,    1,    3,    4,    6,    7,    8,    9,   10,   10,    9,
	   7,    6,    6,    4,    3,    2,    1,   -1,   -2,   -4,   -6,   -9,  -11,  -12,  -12,  -12,
	 -11,  -11,  -10,   -9,   -8,   -7,   -5,   -4,   -1,    1,    3,    5,    7,    9,   10,   11,
	  10,    9,    8,    7,    6,    2,   -1,   -3,   -4,   -6,   -7,   -7,   -7,   -7,   -6,   -5,
	  -5,   -4,   -3,   -3,   -4,   -4,   -4,   -3,   -2,    0,    0,    1,    1,    2,    4,    6,
	   6,    7,    7,    8,    7,    7,    7,    7,    7,    6,    5,    2,    0,   -2,   -4,   -5,
	  -7,   -8,   -8,   -8,   -9,  -10,  -10,   -9,   -8,   -7,   -7,   -7,   -5,   -3,   -2,    0,
	   1,    2,    4,    6,    9,   10,   11,   12,   10,    8,    6,    3,    1,   -2,   -4,   -6,
	  -7,   -7,   -7,   -7,   -8,   -7,   -7,   -6,   -6,   -5,   -4,   -3,   -3,   -2,   -1,    1,
	   2,    2,    3,    4,    5,    5,    5,    6,    6,    6,    5,    5,    6,    6,    6,    4,
	   3,    2,    1,   -1,   -3,   -4,   -6,   -8,   -9,   -9,   -8,   -8,   -6,   -5,   -5,   -5,
	  -6,   -6,   -6,   -5,   -4,   -2,    0,    2,    4,    6,    7,    8,    9,    9,    9,    9,
	   6,    4,    1,   -1,   -3,   -5,   -6,   -7,   -7,   -7,   -6,   -6,   -6,   -6,   -6,   -5,
	  -4,   -3,   -3,   -2,   -1,    1,    3,    4,    5,    5,    5,    5,    5,    5,    4,    4,
	   4,    4,    4,    4,    4,    4,    4,    2,    1,   -1,   -3,   -4,   -5,   -6,   -7,   -7,
	  -7,   -7,   -7,   -6,   -5,   -4,   -4,   -3,   -3,   -3,   -3,   -2,   -1,    0,    1,    3,
	   5,    7,    8,    8,    8,    7,    6,    4,    2,    0,   -2,   -3,   -4,   -5,   -6,   -7,
	  -7,   -7,   -7,   -6,   -6,   -5,   -5,   -5,   -3,   -2,    0,    1,    2,    3,    4,    5,
	   6,    6,    6,    5,    5,    4,    3,    3,    3,    3,    3,    3,    2,    1,    1,   -1,
	  -2,   -3,   -4,   -5,   -6,   -6,   -7,   -6,   -5,   -4,   -3,   -3,   -3,   -3,   -3,   -2,
	  -1,   -1,    0,    1,    1,    1,    2,    3,    5,    6,    6,    6,    5,    4,    2,    1,
	   0,   -2,   -4,   -5,   -5,   -6,   -6,   -6,   -7,   -7,   -7,   -6,   -5,   -4,   -3,   -2,
	  -1,    0,    2,    3,    3,    4,    4,    5,    5,    5,    4,    4,    4,    4,    3,    3,
	   2,    1,    1,    0,    0,   -1,   -1,   -2,   -3,   -4,   -5,   -5,   -5,   -5,   -5,   -4,
	  -4,   -3,   -3,   -2,   -1,   -1,   -1,   -1,    0,    0,    0,    1,    2,    3,    3,    4,
	   4,    4,    4,    4,    3,    1,    0,    0,   -2,   -3,   -4,   -5,   -5,   -6,   -6,   -6,
	  -5,   -4,   -4,   -4,   -3,   -2,   -2,   -1,    0,    2,    3,    3,    4,    4,    4,    4,
	   3,    3,    3,    3,    2,    2,    1,    1,    1,    0,   -1,   -1,   -2,   -3,   -3,   -3,
	  -3,   -3,   -3,   -3,   -3,   -3,   -3,   -2,   -2,   -2,   -1,   -1,   -1,    0,    0,    0,
	   0,    1,    1,    1,    1,    1,    2,    2,    2,    2,    1,    1,    0,    0,   -1,   -1,
	  -2,   -3,   -3,   -3,   -4,   -4,   -4,   -4,   -3,   -3,   -2,   -1,   -1,   -1,    0,    1,
	   1,    1,    2,    2,    2,    3,    3,    2,    2,    1,    1,    1,    0,    0,    0,    0,
	  -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
	   0,    0,   -8,  -33,  -24,  -25,  -25,  -26,  -27,  -32,  -28,  -36,  -31,  -36,  -22,  -34,
	  11,  -74,  -14,   94,   41,   28,   33,   30,   40,   34,   23,   41,   40,   60,   56,   59,
	  60,   44,   39,   54,   45,   52,   17,   44,   62,   34,   33,   19,   18,   43,   35,   22,
	  36,  -15,  -10,   32,   -7,  -12,   -6,   -8,  -50,  -47,  -44,   -4,  -25,  -48,  -76,  -58,
	 -75,  -96,  -85, -118, -114,  -63, -106, -103,  -83, -110,  -99,  -84,  -76,  -58,  -63,  -61,
	 -51,  -53,  -36,  -32,  -41,  -27,  -11,   11,    8,   27,   19,   30,   35,   28,   57,   53,
	  38,   71,   51,   68,  110,   78,   89,  109,   97,   82,   94,  115,  114,   79,   70,   79,
	  94,   85,   76,   84,   95,   83,   82,   55,   54,   54,   41,   41,   27,   20,    6,  -11,
	 -21,  -16,  -14,  -33,  -33,  -52,  -54,  -59,  -62,  -71,  -79,  -88,  -88,  -78,  -78,  -72,
	 -71,  -94,  -99,  -93,  -90,  -78,  -87, -105, -103,  -79,  -62,  -71,  -78,  -63,  -61,  -66,
	 -49,  -23,  -10,  -11,  -24,  -20,   -4,  -22,    9,    8,   27,   43,   34,   38,   51,   83,
	  65,   58,   74,   75,   70,   73,   71,   65,  100,   89,   94,   65,   84,   49,   49,   61,
	  54,   43,   51,   58,   53,   35,   40,   36,   38,   34,   23,   14,  -12,  -10,   -1,   -1,
	 -11,  -12,  -19,  -33,  -66,  -52,  -42,  -37,  -55,  -42,  -28,  -32,  -29,  -35,  -41,  -28,
	 -25,  -46,  -85,  -64,  -62,  -55,  -49,  -68,  -55,  -53,  -52,  -47,  -43,  -26,  -32,  -41,
	 -34,  -35,  -40,  -26,   -8,   -1,   -6,  -11,    5,   -2,    8,    3,    8,    6,    4,   20,
	  29,   43,   24,   33,   20,   30,   24,   39,   38,   40,   29,   37,   36,   39,   61,   58,
	  41,   51,   59,   51,   55,   58,   48,   32,   45,   40,   27,   30,   41,   44,   26,   19,
	  23,   -3,    7,    0,   -3,    2,    3,   -6,   -5,  -14,   -6,  -10,  -27,  -45,  -47,  -41,
	 -38,  -50,  -51,  -46,  -43,  -45,  -65,  -65,  -80,  -95,  -82,  -74,  -66,  -69,  -67,  -33,
	 -31,  -53,  -48,  -51,  -43,  -18,  -24,  -24,  -33,  -26,  -10,    0,  -17,   -6,   17,   31,
	   2,   23,   45,   46,   12,   75,   38,   63,   69,   31,   38,   80,   57,   48,   59,   81,
	  74,   32,   52,   72,   24,   60,   44,   55,   40,   28,   48,   33,   24,   10,   -2,   21,
	  34,   13,   18,    7,   -1,  -12,  -20,  -18,  -30,   -9,   -7,  -30,  -27,  -26,  -38,  -20,
	 -54,  -55,  -64,  -53,  -36,  -62,  -37,  -71,  -47,  -42,  -71,  -45,  -55,  -50,  -54,  -56,
	 -36,  -37,  -54,  -36,  -12,  -38,  -33,  -26,   -7,  -22,  -44,  -10,    2,    3,   15,    8,
	  18,    6,   12,    8,   15,   28,   22,   50,   35,   55,   42,   36,   49,   52,   64,   48,
	  60,   49,   60,   62,   40,   47,   68,   52,   59,   61,   44,   53,   44,   35,   31,   31,
	  47,   22,    6,    4,   -7,    5,   -4,  -21,  -13,   -9,  -10,  -27,  -46,  -32,  -44,  -46,
	 -62,  -44,  -51,  -67,  -53,  -59,  -63,  -74,  -67,  -61,  -61,  -65,  -47,  -58,  -57,  -45,
	 -41,  -46,  -41,  -38,  -22,  -25,  -34,  -16,  -10,  -18,    0,    1,   -6,    5,   17,   15,
	  10,   23,   38,   28,   28,   54,   40,   19,   55,   55,   41,   46,   53,   40,   49,   51,
	  52,   41,   56,   39,   53,   38,   33,   35,   18,   15,   38,   30,   23,   27,   13,   11,
	   7,   16,   -1,    0,    0,   13,   -6,  -10,  -15,  -10,  -10,  -24,  -20,  -16,  -38,  -36,
	 -21,  -40,  -32,  -42,  -38,  -52,  -53,  -41,  -48,  -58,  -50,  -47,  -37,  -41,  -45,  -29,
	 -41,   -6,  -48,  -24,  -25,  -15,   -9,  -10,  -10,  -10,   -1,  -17,    4,    3,   10,   -4,
	   9,   15,   25,   24,   19,   23,   34,   28,   33,   37,   38,   26,   36,   47,   35,   46,
	  45,   28,   35,   32,   32,   24,   21,   26,   23,   19,   37,   20,    9,   29,   -2,   26,
	  24,    8,    4,   14,   21,   11,   -9,   -8,    4,   -9,  -31,  -11,  -15,  -21,  -24,  -29,
	 -22,  -33,  -26,  -29,  -48,  -32,  -44,  -28,  -22,  -35,  -30,  -38,  -31,  -46,  -44,  -36,
	 -27,  -23,  -29,  -24,  -11,  -20,  -28,  -13,  -34,  -19,   -1,    7,   -3,   -1,    6,   -3,
	   5,    4,    8,   17,   26,   19,   33,   27,   16,   35,   14,   36,   39,   22,   32,   31,
	  19,   32,   23,   29,   21,   30,   29,   23,   31,   13,   24,   17,   11,   26,   18,   12,
	   5,   23,   16,    9,   15,  -10,    3,   18,  -15,   -4,   -4,    6,  -14,  -15,   -5,  -34,
	 -11,  -20,  -18,   -8,  -17,  -29,  -30,  -29,  -19,  -34,  -35,  -20,  -36,  -20,  -16,  -21,
	 -38,  -16,  -30,  -24,  -25,  -19,  -18,  -15,   -7,   -5,   -5,  -10,  -23,   -3,  -14,    0,
	  -1,  -12,   -9,    7,    7,    2,   12,    5,    7,   19,   10,   21,   21,   27,   30,   22,
	  18,   34,   22,   11,   26,   24,   20,   21,   25,   29,   22,   27,   27,   20,   10,   20,
	  16,   22,   15,   16,   16,    5,   19,   10,    3,   22,   -5,   -5,   -7,  -16,   -4,  -11,
	 -22,   -7,  -16,  -11,  -23,  -16,  -30,  -24,  -28,  -20,  -29,  -24,  -32,  -22,  -22,  -30,
	 -17,  -23,  -28,  -22,  -20,  -21,  -21,  -17,  -30,  -15,  -14,  -20,   -9,    3,    6,    5,
	 -20,   10,   13,   -2,   11,    8,   -1,    7,   16,    5,   22,   23,   13,   22,   13,   22,
	  25,   15,   16,   11,   15,   13,    7,   12,   19,   18,   20,   12,   23,   11,    6,   10,
	   1,   11,   19,    5,   20,    0,   11,   11,    1,   14,   15,   -3,   -1,   -7,    6,   -6,
	  -9,   -9,    4,   -3,  -10,  -20,  -14,   -9,  -14,   -7,  -10,   -5,   -4,  -29,  -14,  -12,
	 -26,  -21,  -27,  -18,  -10,  -19,  -27,  -18,   -8,  -25,   -8,  -13,  -15,  -14,  -15,    5,
	 -13,   -7,  -11,   -4,  -12,    0,   15,    5,    4,    1,   11,    6,    4,    3,    6,   21,
	  19,    8,   15,   13,    6,   14,   16,   18,   17,   20,   15,   11,   15,   24,   13,   11,
	  19,    7,   17,   14,    6,   17,    7,    7,    6,    6,    5,   11,    0,    6,    0,   -6,
	   5,    1,  -11,   -6,   -1,   -8,   -9,  -15,   -7,   -4,  -16,  -17,  -13,  -13,  -17,  -14,
	 -12,  -12,  -28,  -13,  -19,  -25,  -31,  -24,  -17,  -17,  -16,   -7,  -15,  -12,   -8,  -15,
	  -8,  -16,  -10,   -4,   -1,   -2,    3,    5,    2,   -2,    5,    3,    6,   10,    8,   11,
	  14,   14,   13,   15,   22,   16,   14,   18,   13,   17,   19,   16,   10,   17,    8,   17,
	  14,    3,   14,    7,   10,   10,    7,    6,    6,   -1,    6,    1,    0,   12,   -6,    6,
	  12,   -4,   -5,   -4,   -2,   -2,   -1,   -2,   -8,  -11,   -9,  -11,  -11,  -18,   -6,   -5,
	 -16,   -9,  -14,  -10,  -13,  -10,  -11,  -15,  -14,  -14,  -12,  -17,  -17,  -17,   -7,  -11,
	 -14,  -15,  -12,   -6,  -15,   -5,  -13,   -9,    0,   12,   -2,   -2,    6,    2,   -7,    4,
	  10,    2,    9,    8,    7,    4,    5,   11,   15,   11,   10,   18,    9,   13,   13,   13,
	  21,   11,   18,   19,   13,   14,   16,    6,    8,    1,   19,   11,   10,   11,    1,    3,
	  -1,   -1,    5,  -11,    5,   -1,   -5,   -3,  -13,  -10,   -6,   -7,   -5,  -15,  -10,  -11,
	 -18,   -8,  -16,  -20,  -18,   -9,  -12,  -17,  -21,  -21,  -13,  -21,   -8,  -10,  -10,   -5,
	 -16,   -7,    2,   -6,   -6,   -9,   -7,   -2,   -9,   -5,    6,   -7,    1,    3,   -1,    2,
	   1,    2,    9,    8,    5,   15,   12,    1,   11,    9,    8,   10,   15,   14,    5,   13,
	  17,   14,   15,   10,    7,   16,    5,    5,    5,    8,    9,   10,   10,    7,    0,    4,
	   6,    9,  -10,   -4,    5,    2,   -1,    0,   -3,   -4,   -5,  -10,   -5,   -8,   -9,  -10,
	  -3,  -13,   -6,   -9,  -20,  -15,  -11,  -18,  -14,  -10,  -12,  -20,  -14,  -14,   -7,  -12,
	 -21,  -14,   -9,   -8,  -11,   -5,   -2,   -7,   -4,    4,   -2,   -3,   -1,    0,   -1,    8,
	   6,    9,    7,   10,    6,    3,    4,    7,   10,   11,    6,    9,   17,   11,    9,    7,
	  -2,   16,   13,   12,   18,    5,   16,    9,    4,    9,    6,    8,    9,    4,    4,    3,
	  -2,   -3,    2,   -6,   -3,    1,   -7,   -6,   -3,   -6,  -14,   -8,   -9,   -4,  -13,   -9,
	  -8,  -16,  -10,  -12,  -13,  -11,   -7,   -8,  -12,   -9,   -8,   -7,  -11,   -4,   -8,   -7,
	  -8,   -3,  -13,  -10,   -3,    6,   -5,   -5,    0,   -5,   -3,    6,   -2,   -2,    4,   -2,
	   6,    2,   -2,    5,    5,   -2,    5,   15,   13,    4,    6,    6,   14,    9,    4,    8,
	   7,    3,   11,   12,    2,   10,    7,   10,    8,    4,    6,    2,    0,    3,    2,    4,
	   2,   -6,   -2,    2,   -4,    3,   -5,   -6,   -5,   -5,   -5,   -4,   -8,   -7,   -4,   -4,
	  -7,   -8,   -7,  -13,  -10,  -10,  -11,   -9,   -8,   -8,   -7,  -11,   -7,   -3,   -9,   -6,
	  -7,   -3,   -4,   -5,    3,   -3,   -1,   -2,   -4,    1,    4,    0,    3,    0,    5,    2,
	   0,    5,    4,    1,    3,    1,    0,    1,    7,    3,    0,    4,    3,    6,    5,    0,
	   9,    5,    7,    6,    3,    6,    2,    3,    5,   -4,    9,    0,    4,   10,    0,    5,
	   1,   -2,    4,   -3,   -3,   -2,    0,    2,   -7,    3,  -10,   -1,   -6,   -9,   -2,   -4,
	 -10,   -3,   -7,   -6,   -4,  -10,   -6,   -6,  -11,   -6,    0,   -6,   -8,   -4,   -1,   -9,
	 -10,    0,   -6,   -7,   -2,   -7,    1,   -5,   -5,   -1,    1,   -6,    2,    0,   -3,   -1,
	   7,   -4,    0,    7,    0,    8,    2,    3,    4,    4,    2,    5,   -1,    6,    7,    5,
	   6,    4,    2,    4,    6,    8,    6,    3,    1,    8,    9,    2,   -1,    4,    3,    4,
	   3,   -3,    7,    4,    3,   -2,    2,   -4,   -6,   -2,   -5,   -2,   -3,    0,   -5,   -6,
	 -13,   -5,   -6,  -11,   -9,  -10,   -5,   -4,   -9,   -9,   -7,   -7,   -8,   -8,   -6,   -5,
	  -7,   -5,   -1,   -3,   -4,   -2,   -2,    2,   -3,    1,    2,   -3,    1,    2,    1,    0,
	   1,    5,    0,    2,    5,    2,    0,    4,    1,    7,    3,    2,    6,    0,    5,    7,
	   5,    5,    1,    3,    3,    5,   10,    3,    4,    8,    2,    7,    3,   -2,    3,    0,
	  -1,   -1,    1,    0,    1,   -3,   -2,   -5,   -4,   -3,   -1,   -7,   -8,   -4,   -4,  -10,
	  -2,   -8,   -8,   -8,   -8,   -9,   -6,   -8,   -9,   -4,   -2,   -7,   -5,   -2,   -7,   -6,
	  -9,   -2,    0,   -4,    4,   -6,   -3,   -4,   -1,    2,    1,    2,    9,    0,    3,    0,
	   6,    4,    0,    5,    6,    2,    7,    7,    5,    7,    6,    8,    6,    6,    5,    5,
	   1,    6,    5,   -1,    3,    4,   -1,    4,    1,    4,    3,   -5,    0,    4,    1,    4,
	  -2,   -3,   -4,    0,   -4,   -8,   -2,   -5,   -4,   -8,   -6,   -5,   -3,   -3,   -7,   -9,
	  -6,  -10,  -10,   -6,   -6,   -5,   -4,   -7,   -6,   -4,  -10,   -3,  -10,    0,   -2,   -2,
	  -6,   -1,    3,   -3,   -3,    1,    2,    1,    4,    3,    4,    3,    4,    1,    2,    6,
	   5,    5,    5,    7,    9,    1,    5,    4,    4,    7,    2,    9,    2,    4,    8,    2,
	   5,    6,    3,   -2,   -2,   -1,   -2,   -1,    1,   -2,   -4,    1,   -6,   -2,   -5,   -3,
	  -5,   -5,   -6,   -4,   -3,   -4,  -10,   -4,   -3,   -8,   -4,    0,   -3,   -5,   -6,   -6,
	  -3,   -1,   -7,   -3,    1,   -1,   -4,   -2,    1,   -2,    0,   -1,   -2,    0,    0,    5,
	  -2,    0,    3,    3,    1,    5,    2,    4,    1,    4,    1,    2,    3,    3,    3,    4,
	   3,    3,    5,    1,    4,    2,    3,    1,    2,    0,    2,    1,   -2,   -2,   -1,    0,
	  -2,   -1,   -1,   -3,   -5,   -2,    0,   -5,   -1,    0,   -5,   -2,   -2,   -2,   -3,   -3,
	  -1,   -4,   -1,   -2,   -4,   -2,   -1,   -2,   -1,    0,   -3,   -1,   -1,    0,    1,   -1,
	  -1,    3,   -4,   -2,   -2,    4,   -2,   -1,   -1,   -1,    0,    0,   -1,   -1,   -1,   -1,
	   2,    0,   -1,    2,   -1,    0,   -1,    2,    0,    3,    5,   -2,    1,    2,    0,    5,
	   0,   -3,    4,   -3,    1,    2,    0,    4,   -1,   -2,    1,    0,    0,    0,   -1,    1,
	  -2,    0,    1,    1,    0,   -5,    1,   -2,   -1,    0,   -2,   -3,   -1,   -3,    0,   -2,
	  -3,   -4,    1,   -2,   -3,   -2,   -2,   -1,   -1,   -2,   -1,   -4,   -5,    2,   -4,    0,
	   1,   -1,    2,   -2,   -1,    0,    0,    1,   -3,    3,    2,    0,   -2,    2,    1,    2,
	  -2,    5,    3,   -2,   -2,   -1,    1,    0,    0,    1,    3,    2,    0,    0,   -1,   -2,
	   1,    1,    2,    1,    1,   -1,    0,   -1,   -1,   -1,   -3,    1,    1,    2,   -2,   -1,
	   0,    0,   -2,    0,   -1,   -1,    2,   -2,    1,   -1,    0,    0,   -1,   -1,   -2,    0,
	  -1,    1,   -1,   -1,    2,   -2,    0,   -1,   -1,    2,   -1,    0,   -3,   -1,    0,    0,
	   0,   -3,   -3,   -2,    0,    0,   -1,   -1,    0,   -4,    2,    0,   -2,    0,    1,   -3,
	  -1,    2,    1,    0,   -1,    0,    0,   -1,    0,    2,   -1,   -1,    0,    0,   -2,    1,
	   1,    0,    1,    0,    2,   -3,   -2,    2,   -1,   -1,    2,   -2,    1,    1,    0,    0,
	   1,    1,    0,   -4,    3,   -1,    2,    0,    2,   -1,   -2,    0,    1,    1,   -1,   -1,
	  -1,   -1,   -1,   -2,   -2,   -2,   -2,   -2,   -1,   -1,    1,    0,   -5,    0,   -1,   -1,
	  -1,    1,   -1,    1,   -1,    1,    0,   -2,    0,   -2,    1,   -1,    1,    0,   -1,   -2,
	   0,   -1,    0,    0,    2,    0,    0,    0,    1,    0,    0,    2,    0,   -1,    0,    0,
	   0,    2,   -1,    1,    1,   -1,   -1,    0,    0,    1,    1,    0,    0,    0,    0,   -1,
	   0,    0,   -2,    0,    0,   -1,    1,   -2,   -1,   -1,   -1,   -2,   -1,   -2,    1,   -1,
	   0,   -2,   -2,    1,   -2,   -1,    1,    0,    1,    1,   -1,   -1,    0,   -1,    0,    0,
	   0,   -2,    0,   -1,    0,    0,   -1,   -2,   -2,   -2,    1,   -1,    0,    0,   -1,    1,
	   1,   -2,   -1,   -2,   -1,    1,   -1,   -1,   -2,   -2,    0,    0,    1,   -1,   -1,   -1,
	  -1,   -2,    2,    0,    0,    1,    1,    1,   -2,    0,   -1,    0,   -1,   -1,    2,    0,
	  -1,   -1,   -1,    1,   -1,    2,    0,   -1,    1,    1,    0,    1,    0,   -1,   -1,   -1,
	  -1,   -3,    0,    0,   -1,    1,    0,    0,   -2,   -2,   -2,    0,   -1,    0,    0,   -1,
	   0,   -1,   -2,   -1,   -2,    0,   -2,    0,    0,   -1,   -2,    1,   -2,    0,   -1,   -2,
	   2,    0,   -1,    2,   -1,    1,   -1,    0,    0,   -1,    0,    0,    0,   -1,    0,    1,
	   0,    0,    1,    0,   -1,   -1,    0,   -2,   -1,    0,    0,    1,    0,    0,    0,    0,
	  -1,   -1,    1,   -1,   -2,   -1,    0,    0,   -2,    0,   -1,    0,    0,    0,    1,    0,
	   0,   -1,    1,    0,   -1,    0,    1,   -1,    0,   -1,   -2,    0,   -1,    0,   -1,   -1,
	  -1,    0,   -1,    0,    0,    0,   -1,   -1,    0,   -2,    0,    0,    0,   -2,   -2,    0,
	  -2,   -1,   -1,   -1,   -2,    0,   -1,   -1,   -1,    0,    0,   -1,   -1,    0,    1,   -1,
	  -1,    0,   -1,    0,    0,    1,    1,    0,    0,   -1,    0,    0,    0,    0,    0,    1,
	  -1,    0,    0,    0,    1,    0,    0,   -1,    0,    0,   -1,   -1,    0,   -1,   -1,    0,
	  -1,    0,   -1,   -1,    0,   -2,   -1,    0,   -1,   -1,   -1,   -1,    0,   -1,    0,    0,
	   0,    0,   -1,    1,    0,    0,    0,   -1,   -1,    0,   -1,   -1,    0,    0,    0,    0,
	   0,   -1,   -1,    0,   -1,   -1,    0,    0,   -1,    0,   -2,    0,   -1,   -1,   -1,    0,
	  -1,   -1,    0,   -1,    0,    0,    0,   -2,   -1,    0,   -1,   -1,    0,    1,   -1,   -1,
	   0,    0,    0,    0,   -1,   -1,   -1,   -1,    0,    1,    0,    0,    0,    0,    0,   -1,
	   0,    0,    0,    0,    0,    0,   -1,    0,    0,   -1,    0,    0,   -1,   -1,   -1,    0,
	   0,   -1,   -1,    0,   -1,    0,    0,    0,   -1,    0,   -1,   -1,    0,   -2,   -1,   -1,
	  -1,    0,   -1,    0,   -1,   -1,    0,    0,   -1,    0,   -1,    0,   -1,   -1,   -1,    0,
	  -1,    0,   -1,    0,    0,   -1,    0,   -1,    0,    0,   -1,   -1,    0,    0,    0,   -1,
	   0,   -1,    0,    1,   -1,    0,    0,    0,    0,    0,   -1,    0,    0,    0,   -1,    0,
	   0,   -1,   -1,    0,    0,    0,   -1,    0,    1,   -1,   -1,   -1,    0,    0,   -1,   -1,
	  -1,   -1,    0,   -1,    0,    0,    0,    0,    0,    0,   -1,   -1,    0,   -1,   -1,    0,
	  -1,    0,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,
	   0,   -1,    0,    0,   -1,   -1,    0,   -1,    0,   -1,    0,    0,   -1,    0,   -1,   -1,
	  -1,    0,   -1,    0,    0,    0,    0,    0,   -1,   -1,    0,    0,    0,    0,    0,    0,
	   0,    0,   -1,    0,    0,   -1,    0,    0,    0,    0,   -1,    0,   -1,    0,    0,    0,
	  -1,   -1,    0,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,    0,   -1,
	  -1,   -1,    0,    0,    0,   -1,    0,   -1,   -1,    0,   -1,    0,    0,   -1,   -1,   -1,
	  -1,   -1,    0,    0,   -1,    0,    0,   -1,    0,    0,    0,    0,    0,    0,    0,   -1,
	   0,    0,    0,    0,   -1,    0,    0,    0,    0,   -1,    0,    0,    0,    0,   -1,    0,
	   0,   -1,    0,   -1,    0,    0,   -1,   -1,   -1,    0,   -1,   -1,    0,   -1,   -1,    0,
	   0,   -1,   -1,   -1,   -1,    0,   -1,   -1,    0,    0,   -1,    0,    0,    0,   -1,   -1,
	   0,   -1,   -1,   -1,    0,    0,   -1,   -1,   -1,   -1,   -1,    0,   -1,    0,    0,   -1,
	  -1,    0,    0,   -1,    0,    0,   -1,   -1,   -1,    0,   -1,    0,    0,   -1,   -1,    0,
	   0,   -1,   -1,    0,    0,    0,   -1,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0,    0,    0,    0,   -1,   -1,    0,    0,    0,   -1,    0,   -1,    0,
	  -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
	  -1,    0,   11,   -3,   47,  -12,  -15,  -34,    3,   12,   38,    5,  -24,  -26,   -9,  -12,
	  63,  -18,   12,  -17,  -50,   34,   -6,   40,   -2,   -8,  -37,   -6,    9,   12,   32,   -4,
	 -33,    2,  -33,   35,   20,    6,  -11,  -33,  -11,   12,   23,   30,  -21,  -13,  -28,   -6,
	  33,   14,    7,  -18,  -22,  -11,   18,   23,    5,   -4,  -22,  -30,   29,  -11,   40,  -12,
	 -15,   -5,  -11,   16,   13,   -9,    5,  -19,    3,    4,    2,   19,  -28,   24,  -41,   40,
	  -9,   -8,    4,  -29,   28,   -1,   22,  -16,  -32,   16,  -22,   45,   19,  -45,   17,  -54,
	  25,   28,   33,  -19,  -30,  -21,  -25,   83,  -20,   15,   -3,  -74,   12,   33,    4,   53,
	 -26,  -57,   -9,    0,   36,   33,    8,  -67,   -2,  -17,   27,   55,  -17,  -11,  -31,  -23,
	  24,   22,    6,   19,  -55,   27,  -48,   55,   -8,   14,    7,  -61,   26,  -25,   34,   32,
	 -26,   11,  -50,    5,   14,   -1,   67,  -75,   47,  -79,   29,   15,    8,   42,  -49,    2,
	 -34,   -3,   51,  -23,   52,  -33,  -32,   -7,  -14,   52,    6,   29,  -73,    5,   -9,   -2,
	  64,  -39,   -6,   25,  -60,   30,    5,   16,  -13,   40,  -61,    7,   20,  -50,   75,  -36,
	  10,  -12,   -4,  -17,   23,   16,  -18,   31,  -38,  -21,   33,  -37,   56,  -11,   -5,   -1,
	 -43,   43,  -56,   93,  -67,   40,  -17,  -46,   60,  -56,   62,  -24,   14,  -18,  -23,    9,
	 -16,   44,   19,  -53,   58, -124,   81,  -18,   32,   26,  -43,  -23,  -28,   42,    1,   60,
	 -27,  -61,   14,  -37,   42,   64,  -32,   -2,  -43,  -31,   25,   59,   -7,   -1,  -19,  -73,
	  51,   23,   18,    7,  -24,  -65,   29,   18,   -2,   57,  -47,  -27,    4,   -2,   16,   41,
	 -25,  -47,   36,  -51,   49,   24,  -37,   13,  -15,  -11,   12,   26,  -58,   52,  -20,  -16,
	  31,  -24,  -20,   52,  -16,   -9,   32,  -69,    5,   48,  -34,   52,  -12,  -59,   20,  -10,
	  30,   16,   21,  -75,    1,    8,  -33,  126,  -57,    9,  -37,  -49,   32,   24,   62,  -59,
	  19,  -85,   -2,   91,  -23,   65,  -49,  -75,   19,  -16,   68,    9,   16,  -77,   -3,    3,
	 -13,  111,  -69,   17,  -30,  -59,   56,    1,   19,   23,  -26,  -21,  -24,   25,  -31,   97,
	 -59,    4,  -16,  -34,   40,   17,   16,  -24,   -6,  -40,   26,   17,    3,    4,  -23,   -3,
	  -1,   23,   -8,    6,  -29,   -2,   21,  -13,   22,  -11,  -31,   40,  -35,   48,  -27,    7,
	 -39,    4,   28,  -12,   55,  -68,    9,   -9,    2,   51,  -21,  -20,  -18,  -15,   33,   20,
	  15,  -57,   41,  -78,   72,   -2,   -7,   13,  -60,   11,   13,   49,  -19,   10,  -55,  -23,
	  59,   -6,   22,    2,  -79,   40,  -11,   46,  -11,   11,  -66,   13,   24,  -24,   80,  -65,
	   5,  -22,    1,   19,   23,   -8,  -27,  -11,    2,    0,   64,  -61,   21,  -52,   34,   23,
	   7,   -1,  -51,   21,  -41,   86,  -45,   49,  -62,   -6,    0,   11,   51,  -33,   16,  -62,
	  -1,   23,    8,   62,  -45,  -35,    7,  -39,   88,  -54,   70,  -86,   33,  -27,   -1,   61,
	 -60,   58,  -62,   10,   15,  -28,   65,  -48,   11,   -2,  -44,   78,  -64,   75,  -78,   26,
	 -29,   22,   40,  -30,   16,  -53,  -12,   56,  -15,   48,  -51,  -22,  -10,    9,   52,  -20,
	  40,  -92,   16,   -3,   26,   43,  -19,  -35,  -31,   15,   13,   49,  -11,  -34,  -24,   -1,
	   9,   50,  -12,  -25,  -17,  -10,   15,   44,  -20,    0,  -28,  -22,   32,    5,   27,  -33,
	  15,  -67,   61,  -19,   19,   18,  -46,   -1,   -1,    7,   18,   14,  -27,  -21,   18,  -27,
	  42,   22,  -56,   38,  -56,   21,   17,    2,    5,   -3,  -11,  -38,   48,  -27,   32,    8,
	 -50,    1,   10,   -3,   38,  -10,  -16,  -36,   34,  -45,   74,  -12,  -30,   16,  -52,   22,
	  24,   17,   -1,  -13,  -41,  -10,   50,   -5,   41,  -32,  -62,   25,   -5,   48,   24,  -26,
	 -61,    4,   -2,   44,   62,  -59,  -23,  -38,   -4,   61,   34,    0,  -57,  -18,  -41,   63,
	  36,    6,   -1,  -69,  -11,   10,   19,   60,  -31,    3,  -64,   18,  -19,   61,   10,  -17,
	  10,  -73,   13,   30,   -7,   64,  -39,  -27,  -34,    8,   20,   46,   24,  -87,   29,  -70,
	  51,   51,  -12,    6,  -44,  -30,   10,   52,   -7,    2,   -6,  -72,   63,   -9,   17,   15,
	 -37,  -24,   14,   24,  -11,   43,  -55,  -29,   42,  -19,   47,    1,  -49,  -13,   13,    6,
	  38,    4,  -59,   -2,    7,    5,   61,  -31,  -42,   11,  -32,   54,   14,  -11,  -23,  -10,
	 -20,   40,   19,  -18,    0,  -19,  -28,   52,  -14,   -5,   29,  -70,   53,  -17,   19,  -18,
	  15,  -30,   -2,   37,  -41,   38,    7,  -61,   67,  -67,   35,   11,  -12,   11,  -34,   38,
	 -61,   89,  -59,   10,   28,  -60,   52,  -19,  -22,   34,  -30,   42,  -42,   45,  -68,   35,
	  19,  -45,   80,  -81,   26,  -16,    4,   30,    0,  -13,  -19,  -14,   23,  -22,   75,  -77,
	  47,  -45,   -5,   48,  -36,   48,  -50,   18,  -35,   25,    5,    4,   14,  -16,  -33,   40,
	 -49,   71,  -38,   17,  -30,   -6,   12,    4,   31,  -27,   -6,  -12,  -11,   27,   15,  -13,
	  12,  -54,   32,  -19,   53,  -17,   -1,  -16,  -39,   39,   -5,   30,   -3,  -29,  -13,   -2,
	  23,   16,    4,  -18,  -41,   26,  -11,   35,   18,  -48,   13,  -33,   28,    1,   38,  -45,
	   5,  -13,  -18,   49,    1,  -21,   16,  -44,   14,   16,    7,   -6,   -5,  -10,  -18,   52,
	 -33,   25,  -11,  -36,   31,  -15,   14,   11,  -22,    9,  -27,   41,  -42,   56,  -50,   15,
	  10,  -28,   30,  -18,    3,    7,   -7,    7,  -16,   13,  -27,   29,    5,  -25,   42,  -71,
	  44,  -18,   21,    8,   -7,  -21,  -15,   21,   -9,   36,   -2,  -43,   17,  -26,   14,   45,
	 -33,   19,  -40,    1,   -3,   37,   -5,   -5,   -2,  -46,   38,    0,    7,   18,  -33,  -12,
	  11,  -11,   33,    2,  -16,  -15,   -3,    1,   18,   26,  -32,   -4,  -14,  -17,   54,   -1,
	  -1,  -17,  -35,   10,   12,   40,  -12,  -10,  -30,  -31,   51,  -12,   65,  -35,  -34,  -12,
	 -32,   60,   22,   19,  -33,  -39,  -20,    2,   75,    2,    9,  -42,  -72,   35,   13,   65,
	   5,  -28,  -60,  -15,   23,   40,   44,  -33,  -34,  -34,   -5,   48,   33,    2,  -21,  -47,
	 -15,   25,   33,   12,    7,  -55,  -12,    7,   19,   28,    9,  -34,  -28,    5,    7,   32,
	  15,  -41,    8,  -32,   10,   36,   -4,   14,  -40,   16,  -45,   56,  -15,   17,    0,  -33,
	   2,    0,    7,   23,  -12,   -1,  -26,    3,    6,   10,   24,  -32,   21,  -50,   33,   -9,
	  15,   11,  -24,    1,  -12,   12,    4,   13,  -10,  -11,   -2,   -5,    7,   17,  -23,   25,
	 -27,   12,   -6,    0,    8,  -16,   18,  -24,   31,  -27,    9,   -3,   -2,   18,   -4,   -7,
	 -11,  -12,   10,   12,   15,  -17,    7,  -34,   18,    8,    4,    9,  -18,  -14,   -3,   15,
	   9,    7,    0,  -37,   21,  -13,   16,   18,  -32,   12,  -23,   21,    3,   12,  -14,  -14,
	   3,   -5,   24,    4,  -21,    9,  -32,   26,   14,   -1,   12,  -40,    0,   -6,   24,   11,
	   3,  -11,  -34,   17,   -8,   28,   18,  -36,    9,  -38,   13,   26,   11,    7,  -20,  -13,
	 -34,   49,  -24,   41,   -8,  -36,    4,   -8,    3,   47,  -11,   -5,  -24,  -15,   -9,   44,
	   8,   -5,    8,  -61,   17,   14,   14,   23,  -15,  -43,    1,   -1,   28,   27,    1,  -40,
	  -6,  -20,   18,   45,  -22,    4,  -20,  -34,   39,   12,    3,    9,  -31,  -23,   15,   17,
	  -7,   36,  -36,  -19,   30,  -30,   36,    1,  -16,   -8,    5,  -14,   20,   10,  -13,    0,
	   6,  -30,   37,  -22,    3,   14,  -27,   24,  -15,   14,  -15,   19,  -22,    4,   17,  -31,
	  29,  -14,  -10,   27,  -26,   22,  -14,    8,  -17,    9,   -2,  -11,   33,  -27,   14,    0,
	 -29,   31,  -21,   21,   -7,   -2,  -14,   -4,   20,  -15,   37,  -27,   -9,    7,  -24,   24,
	   8,   -9,   12,  -23,    7,  -14,   30,  -22,   25,  -16,  -20,   24,  -27,   23,    8,   -9,
	   6,  -11,  -18,   12,   -3,   22,  -14,   28,  -61,   41,  -32,   21,   29,  -26,    8,  -31,
	   2,    5,   28,    3,   -9,  -14,  -21,   -3,   48,  -33,   49,  -62,    9,   -1,    6,   33,
	 -24,   11,  -44,   24,   -2,    6,   25,  -40,    8,    1,  -16,   49,  -41,   27,  -41,   18,
	   0,    3,   31,  -50,   36,  -42,   22,   15,  -18,   24,  -34,    5,   12,  -21,   52,  -56,
	  52,  -58,   29,   -8,   -8,   39,  -51,   48,  -47,   24,    4,  -16,   22,  -28,    6,    7,
	 -22,   48,  -55,   51,  -44,   31,  -10,   -5,    8,  -36,   41,  -31,   35,   -9,  -16,   10,
	 -17,    6,   21,  -13,   10,  -26,    5,  -17,   39,   -3,    3,    1,  -43,   12,    1,   17,
	  15,   -7,  -24,   -9,    5,   15,   17,    8,  -38,    2,  -25,   25,   15,   12,  -13,  -16,
	 -11,    3,   19,    9,   -9,   -9,  -15,    1,   19,   -1,   14,  -20,   -1,  -12,   15,   -7,
	  11,  -10,   -2,   -3,   10,   -9,   18,  -17,    2,   -4,   -3,    4,    3,   -2,   -5,    9,
	  -9,    4,    5,  -13,    5,    5,  -21,   22,  -16,   11,   -4,   13,  -22,    5,    3,  -23,
	  35,  -14,   -6,   13,  -24,    4,   17,   -6,    6,   -7,   -6,  -27,   43,  -28,   25,    9,
	 -45,   28,  -23,    8,   25,  -14,    0,  -15,   -4,   -3,   27,    3,  -15,   18,  -59,   34,
	   3,   -3,   38,  -39,  -11,    4,   -9,   27,    9,   -2,  -38,   21,  -31,   19,   47,  -53,
	  43,  -47,  -11,   29,   -2,   19,   -7,   -9,  -36,   19,   12,   -8,   53,  -58,    1,    2,
	 -33,   67,  -23,   25,  -44,    5,  -25,   28,   32,  -29,   32,  -60,    0,   25,   -7,   39,
	 -14,  -29,  -12,    2,   11,   20,   23,  -54,   18,  -25,    1,   45,  -10,  -10,   -4,  -29,
	   7,   28,    7,  -11,    9,  -46,   16,   11,    8,    8,   -7,  -25,   -3,   16,   -3,   32,
	 -25,   -7,  -20,   12,    0,   30,  -14,   -4,  -15,   -6,    6,   24,   -9,    3,  -16,  -24,
	  23,   -3,   27,  -20,   15,  -56,   42,  -17,   21,   13,  -27,   -8,   -2,    5,    8,   21,
	 -21,  -12,    4,  -14,   15,   24,  -39,   31,  -38,   19,   -2,   16,  -16,    3,   -6,  -21,
	  30,  -14,   16,    4,  -30,   11,   -7,    7,   12,   -5,  -10,   -9,    9,  -17,   37,  -15,
	  -5,    6,  -26,   12,   13,   -8,    7,   -2,  -18,    1,   17,  -13,   15,    4,  -37,   25,
	 -18,    8,   13,    1,  -23,   21,  -25,   10,    7,   -1,   -6,   10,  -15,   -7,   21,  -26,
	  29,  -12,   -3,   -3,    0,  -16,   29,  -18,   21,  -15,    1,  -23,   22,   -4,    3,   21,
	 -43,   22,  -19,    4,   21,   -8,    4,  -11,   -7,   -5,    7,   19,  -20,   31,  -47,   11,
	   2,   -9,   44,  -28,    8,  -31,    5,   -1,   20,   24,  -38,   14,  -32,   -4,   47,  -30,
	  38,  -41,   -1,  -12,   12,   27,  -16,   29,  -57,   12,   -1,    3,   38,  -29,    3,  -25,
	  -1,   28,  -10,   36,  -52,   20,  -33,   27,   14,  -11,   18,  -42,   13,    3,    3,   20,
	 -21,    0,  -20,   15,    4,    0,   23,  -49,   28,  -24,   18,   16,  -15,   -2,  -26,   22,
	 -10,   33,   -7,  -26,   11,  -25,   19,   21,  -14,    8,  -33,    6,   -2,   30,    2,  -12,
	  -6,  -37,   34,   -4,   22,    1,  -33,   -3,   -4,   15,   20,    3,  -20,  -16,    2,  -14,
	  38,   -3,   -7,    2,  -24,   -4,   22,   -4,   11,   -2,  -15,  -19,   21,  -15,   24,    8,
	 -21,    1,  -12,   -3,    9,   21,  -22,   17,  -26,   -2,    6,   14,   -8,   19,  -24,  -10,
	   8,  -10,   17,    9,   -7,  -12,    8,  -27,   29,   -3,    4,   -4,   -3,  -26,   25,   -9,
	  13,    9,  -19,   -7,    2,   -4,   10,   19,  -29,   13,  -16,   -3,   18,    4,  -12,   10,
	 -24,    1,    6,   10,   -9,   19,  -26,   -3,   16,  -15,   20,   -4,  -16,    1,    3,   -4,
	   9,    6,  -19,    7,    3,  -18,   26,  -13,   -7,   12,  -13,    2,    9,   -5,   -7,   15,
	 -18,    6,    8,  -18,   13,   -2,  -12,   15,  -12,    9,   -6,   -2,  -16,   25,  -14,   18,
	   1,  -29,   11,   -4,   14,    2,    3,  -26,    6,   -3,    1,   19,   -3,  -15,   12,  -29,
	  17,   -2,   12,   -2,   -4,   -3,  -28,   34,  -21,   31,   -7,  -17,   -3,  -13,   20,    1,
	  14,  -14,  -22,   11,  -13,   33,   -2,  -11,   -4,  -30,   33,  -12,   30,  -17,  -17,   -4,
	  -4,   25,    2,    3,  -20,  -22,   20,  -13,   42,  -15,  -11,   -9,  -16,   23,    8,   16,
	 -28,   -3,  -11,    4,   27,   -8,    5,  -17,   -9,    8,   -2,   25,  -27,   17,  -32,   19,
	  -4,   16,   -8,  -16,    6,  -20,   32,    0,  -14,    8,  -34,   18,   12,    3,   13,  -36,
	  11,  -34,   49,  -14,   22,  -12,  -38,   17,  -21,   42,    5,  -10,  -12,  -34,    8,   18,
	  18,   26,  -50,    9,  -50,   42,   16,   10,   10,  -51,    2,  -21,   38,   16,    7,  -17,
	 -29,  -12,   13,   19,   25,  -16,   -7,  -40,   14,    5,   23,    6,  -11,  -23,   -3,   11,
	   2,   25,  -26,    0,  -12,    5,    4,    9,    2,  -18,   10,  -15,    5,   20,  -26,   23,
	 -28,    6,    8,    1,   12,  -26,   10,  -19,   20,    7,  -14,   17,  -37,   18,    1,   -1,
	  23,  -28,    9,  -25,   20,    1,    6,    6,  -23,    9,  -15,   12,   10,  -11,    5,   -5,
	 -12,   15,   -8,    4,    4,   -4,   -6,    8,  -11,    3,    6,   -6,    0,    6,  -12,    1,
	  14,  -26,   27,  -17,   -3,   15,  -18,   15,  -10,    1,   -6,    4,    9,  -17,   28,  -42,
	  18,    3,  -17,   45,  -38,    9,  -12,   -7,   19,    8,    7,  -31,    8,  -18,    6,   53,
	 -51,   34,  -41,  -13,   32,   -4,   17,  -10,   -6,  -28,   25,    0,   -2,   23,  -32,   -7,
	  21,  -28,   36,   -7,  -14,    7,  -10,   -4,   13,   -3,   -7,    7,   -5,   -6,   14,  -10,
	 -10,   22,  -29,   22,    0,  -23,   24,  -25,   15,    3,    3,   -4,   -9,    5,  -23,   33,
	 -10,   -6,   22,  -48,   31,   -8,    7,   10,  -15,   -5,  -14,   20,   -7,   16,    3,  -32,
	  20,  -21,   13,   18,  -20,    9,  -25,   13,   -3,   21,   -4,  -10,   -4,  -18,   18,    6,
	   2,    6,  -32,    8,   -4,   18,   10,   -3,  -21,  -12,    3,    3,   28,   -3,  -18,   -4,
	 -14,   10,   19,    5,   -9,  -10,  -21,    8,   21,    2,   11,  -23,  -12,   -8,   14,   12,
	  -1,    5,  -31,   14,   -9,   15,    7,  -14,    5,  -19,   11,   -3,    5,    1,  -11,   12,
	 -13,   14,   -6,  -10,    5,   -9,   16,   -4,    3,  -15,   -5,    9,    2,   14,  -11,   -9,
	  -7,   -7,   22,   -2,   12,  -14,  -15,   -2,    2,   19,    0,    6,  -28,   -3,    0,    5,
	  27,  -10,   -8,  -15,   -9,   12,   10,   20,  -25,    5,  -23,    0,   27,  -10,   21,  -27,
	  -3,  -14,   17,    8,    1,    6,  -28,    2,    7,   -2,   21,  -14,   -6,   -9,    3,    6,
	   2,   16,  -33,   19,  -17,    7,   10,   -6,   -3,   -4,    0,    0,   11,   -1,  -13,    5,
	  -9,   -1,   25,  -27,   19,  -20,    3,    9,    1,    2,  -11,    5,  -19,   26,   -4,   -6,
	  13,  -28,   10,   13,  -11,   17,  -19,   -1,  -10,   22,   -4,   -1,   13,  -43,   29,   -8,
	   3,   18,  -25,    5,  -13,   16,   -5,   12,    0,  -29,   25,  -23,   14,   17,  -29,   23,
	 -23,    8,    2,    0,    4,   -8,   11,  -25,   22,   -8,   -6,   28,  -35,   19,   -6,  -17,
	  25,  -15,    9,   -5,    1,  -12,   10,    5,  -14,   22,  -24,    0,   18,  -23,   23,   -9,
	 -10,    8,   -1,   -1,    4,   -4,  -13,    8,    6,   -7,   22,  -27,   -8,   10,   -6,   23,
	   1,  -17,  -10,   -9,   15,   14,   15,  -17,  -24,   -1,  -11,   41,    4,   -4,  -12,  -35,
	  12,   13,   19,   12,  -22,  -25,   -6,    8,   22,   17,   -3,  -36,    7,  -21,   21,   32,
	 -22,    8,  -23,  -17,   17,   15,    1,   10,  -19,  -20,    2,   10,    3,   23,  -13,  -21,
	   7,  -19,   26,   12,  -10,    4,  -35,    4,    7,   12,   19,  -17,   -3,  -24,   14,    7,
	   7,   15,  -43,   12,  -13,    8,   37,  -29,   13,  -34,   11,    2,   11,   14,  -34,   22,
	 -31,   20,   14,  -14,   18,  -29,    5,   -4,    3,   13,  -11,   13,  -23,    9,   -3,   -5,
	  22,  -22,   12,  -10,  -11,   15,   -2,    6,    4,  -10,  -15,   11,   -5,   10,    8,  -14,
	 -12,   12,  -10,   16,   17,  -37,   16,  -18,   -3,   31,  -11,   -1,   -9,   -8,    0,   22,
	   6,  -21,    9,  -32,   14,   26,  -19,   27,  -40,    6,   -4,   13,   14,  -14,    3,  -34,
	  21,    1,   10,   15,  -32,    5,  -10,    5,   19,  -10,    3,  -21,   10,   -7,   14,    9,
	 -23,   18,  -25,    9,    7,   -5,    4,   -1,   -8,   -2,   15,  -17,   16,   -5,  -17,   16,
	 -13,    9,    3,    2,  -17,   13,  -10,   -2,   29,  -33,   17,  -15,  -10,   23,   -6,   12,
	 -14,   -3,   -9,    2,   26,  -23,   28,  -45,   14,   -1,    1,   33,  -35,   17,  -34,   15,
	  10,    3,   12,  -31,    7,  -15,   18,   19,  -19,   12,  -39,   16,    5,    8,   17,  -37,
	  16,  -35,   39,   -3,    8,   -5,  -31,    9,   -4,   26,    0,   -3,  -18,  -15,   19,   -2,
	  25,  -12,  -21,    1,  -16,   26,    4,    6,  -20,   -1,  -14,   11,   21,  -20,   22,  -32,
	   0,   14,   -9,   19,  -10,   -2,  -13,   14,   -9,    4,   17,  -36,   30,  -20,   -2,   22,
	 -21,   13,  -11,    7,  -12,   15,   -6,  -15,   25,  -29,   20,    3,  -18,   17,  -17,    7,
	  -3,   11,   -9,   -4,   13,  -33,   34,  -10,   -5,   22,  -34,   11,   -4,    8,   -1,   11,
	 -14,  -16,   24,  -27,   31,    3,  -29,   19,  -23,    2,   26,  -11,    1,   -3,  -14,   -4,
	  27,  -14,    3,    9,  -38,   26,   -1,   -7,   20,  -15,  -12,   14,   -8,    4,    7,  -11,
	 -10,   12,   -3,    0,   16,  -28,    7,    1,   -2,   14,   -7,  -10,   -5,    4,    5,    9,
	   3,  -22,    4,   -5,    0,   27,  -18,    1,   -9,  -10,   13,   10,    1,   -9,   -1,  -21,
	  15,   11,   -8,   15,  -21,   -8,   12,   -4,   13,    0,  -12,   -5,    2,   -1,    9,    2,
	  -8,    0,   -4,    1,    4,   -1,   -1,   -1,   -1,   -2,  -15,   21,  -17,   23,  -30,    1,
	  34,  -34,    6,    5,  -15,   19,    1,  -25,    6,   20,   -2,  -28,   15,   10,  -15,    0,
	  -7,   10,    7,   -5,   -9,   -6,   19,   -3,  -21,    3,   20,   -4,  -20,    1,   16,   -3,
	  -8,   -2,    5,    1,   -8,   -6,    3,    9,    2,  -13,   -4,   15,   -7,   -9,    0,    3,
	   6,   -7,   -7,    5,    8,   -8,   -4,    0,    1,    1,   -6,   -4,    7,    2,   -2,   -7,
	   0,    4,   -3,   -4,    0,    2,    0,   -2,   -4,    1,    4,   -2,   -4,   -3,    1,    3,
	  -5,   -4,    4,    3,   -6,   -5,    4,   -1,   -2,   -3,    0,    3,   -3,   -1,   -4,    3,
	   3,   -5,   -3,    1,    1,   -2,   -3,    1,    2,   -2,   -4,    0,    0,    0,   -1,   -3,
	   1,    1,   -3,   -2,    1,    0,   -2,   -2,    0,    0,   -2,   -1,    0,   -1,    1,   -2,
	  -2,    1,    0,   -2,    0,   -1,    0,   -1,   -1,   -1,    0,    0,   -1,   -3,    1,    1,
	  -2,   -2,    0,    1,   -1,   -2,   -1,    0,    0,    0,   -2,   -1,    1,    0,   -3,    0,
	   2,   -1,   -2,    0,    0,    0,   -2,    0,   -1,    0,   -1,   -1,    1,    0,   -1,    0,
	  -1,    1,    0,  -13,    5,    7,  -11,   24,  -50,   41,    4,  -29,   14,  -11,    8,   11,
	 -15,  -12,   15,   18,  -21,  -14,   22,   -2,  -11,   -3,   -3,   18,   -3,   -5,  -14,    9,
	  22,  -24,  -16,   23,   12,  -23,   -8,    9,   10,   -4,   -8,   -3,   11,   -4,  -14,    0,
	   8,    8,   -5,  -14,    8,   10,  -12,   -4,   -2,   10,    0,  -11,   -3,   11,    0,   -7,
	  -2,   -1,    7,   -6,   -8,    3,    6,    0,   -3,   -8,    7,    2,   -7,   -2,    2,    1,
	  -2,   -4,   -1,    3,    3,   -4,   -5,    1,    3,   -3,   -6,    2,    5,   -1,   -7,   -1,
	   3,   -1,   -4,   -3,    5,    0,   -3,   -2,   -1,    4,   -1,   -5,   -1,    3,   -1,   -4,
	  -1,    3,    1,   -4,   -2,    1,    0,   -2,   -3,    0,    2,   -1,   -4,    1,    1,   -1,
	  -2,   -2,    1,   -1,   -3,    0,    0,    0,   -1,   -2,    0,    0,   -2,   -1,    0,   -1,
	   0,   -2,   -1,    0,   -1,    0,   -1,   -2,    2,   -1,   -2,   -1,    0,    1,   -2,    0,
	  -1,   -1,    0,   -1,   -2,    0,    1,   -1,   -3,    0,    1,   -1,   -3,    0,    1,   -2,
	  -1,    0,    0,   -1,   -1,    0,   -1,   -1,   -1,   -1,    0,    0,   -1,   -1,    0,    0,
	  -2,    0,    0,    0,    0,   -2,    1,   -1,    0,   -1,    0,    0,    0,   -1,    0,    0,
	   0,    0,   -1,    0,    0,   -1,    0,   -1,    1,    0,    0,    0,    1,   -1,   -1,    0,
	   0,    0,    1,   -2,    4,   -3,    3,  -40,   71,  -73,   67,  -27,  -68,  127,  -80,    3,
	   5,    1,   17,  -14,    1,  -30,   53,   -3,  -42,   15,   19,   -9,  -17,   -1,   13,   16,
	 -17,    4,  -32,   43,   15,  -68,   18,   54,  -38,   -7,   -1,   11,    7,   -3,  -18,    5,
	  25,  -27,   -9,    9,   19,   -6,  -12,   -8,   20,   -1,  -15,   -1,    1,   17,  -10,  -16,
	  12,   12,  -13,    0,   -6,   10,    2,  -16,   -1,   14,   -4,    4,  -11,   -2,   12,   -6,
	  -8,    4,    4,   -2,   -4,    1,   -2,    4,    3,   -7,   -5,    8,    0,  -10,    1,    4,
	   2,   -4,   -6,    4,    1,   -1,   -7,    1,    8,   -9,    2,   -5,    3,    3,   -4,   -3,
	   0,    3,   -3,   -5,    4,    3,   -3,   -4,    0,    2,    0,   -3,   -4,    5,    0,   -5,
	  -1,    2,    0,   -3,    0,   -1,    2,   -2,   -4,    3,    0,   -1,   -2,   -1,    2,   -2,
	  -2,    1,   -1,    0,   -1,   -3,    1,    1,   -2,    1,   -3,    1,    1,   -3,   -1,    1,
	   0,   -1,   -2,    1,   -1,   -1,    1,   -2,    1,   -1,   -1,   -1,   -1,    0,    1,   -3,
	   0,    0,    1,   -4,    0,    1,   -2,    0,   -2,    0,    0,    0,   -2,    1,   -1,    0,
	  -2,    0,    2,   -2,   -1,    0,   -1,    2,   -2,   -1,    1,   -2,    0,   -1,    1,   -1,
	  -1,   -1,    1,   -2,    1,   -1,   -1,    2,   -3,    0,    0,   -1,    1,   -1,    0,    1,
	   0,   -2,    0,   -1,    1,   -2,    0,    0,   -1,    1,    0,   -2,    0,    1,   -2,    1,
	   0,    0,   -1,    0,    1,   -1,   -1,   -1,    1,    1,   -1,    0,    0,    0,   -1,    1,
	   0,   -1,    1,    0,    0,    1,    0,   -1,    1,    0,    3,  -40,   58,  -39,   12,   42,
	-117,  108,    1,  -66,   22,   17,    0,   -9,   10,  -39,   42,    4,  -23,  -12,   28,    3,
	 -34,    9,   17,    3,   -9,   10,  -29,   13,   53,  -79,    3,   64,  -26,  -24,   16,   -9,
	  14,    2,   -8,  -15,   31,   -9,  -30,   11,   29,  -15,   -7,    0,    3,    6,   -4,   -9,
	  -6,   22,    1,  -24,    9,   11,   -8,    0,   -2,    2,    8,  -12,   -6,   10,    2,    2,
	  -9,   -4,   11,   -2,  -10,    3,    2,    3,   -5,   -1,    1,   -1,    6,   -4,   -8,    9,
	   2,   -8,   -3,    6,    3,   -4,   -3,   -1,    6,   -2,   -8,    0,    9,   -4,   -3,   -2,
	   2,    4,   -4,   -1,   -1,    4,   -2,   -6,    4,    2,   -1,   -4,    0,    1,    2,   -3,
	  -5,    3,    3,   -3,   -4,    3,    0,   -1,    0,   -2,    2,    0,   -3,    0,    3,    0,
	  -3,   -1,    2,    0,   -3,    1,    0,   -1,    2,   -2,   -2,    2,   -1,    0,   -1,   -1,
	   1,   -1,   -2,    0,    0,    1,   -3,    1,    0,   -1,    1,   -2,   -1,    2,   -2,   -1,
	   0,   -1,    2,   -3,   -1,    1,    1,   -2,   -2,    2,    1,   -2,   -1,    0,    0,    1,
	  -3,    1,    0,    0,    0,   -2,    3,    0,   -2,    0,    0,    1,    0,   -1,    1,   -2,
	   0,    0,    0,   -1,    1,    0,    0,    0,   -1,    1,   -1,    1,    0,   -1,    1,   -2,
	   0,    1,    1,    0,    1,   -2,    1,    0,    1,    0,    0,    3,   -1,    0,    1,    0,
	   0,    3,  -29,   35,  -12,  -16,   56,  -88,   39,   62,  -79,    5,   29,    1,  -13,   12,
	 -29,   26,   17,  -28,   -3,   12,    5,  -11,  -19,   28,    1,   -5,    9,  -21,   -7,   60,
	 -56,  -20,   57,  -10,  -27,   21,  -21,   16,   12,  -12,  -21,   24,    6,  -29,    4,   19,
	   2,   -7,   -5,   -3,    7,    6,  -11,   -9,   11,   13,  -18,   -4,   13,    1,   -3,   -6,
	  -1,   10,   -8,   -6,    5,    3,    5,   -3,  -11,    4,    9,  -11,    0,    4,    3,   -4,
	  -1,    0,    0,    7,    0,  -14,    7,    5,   -7,   -4,    4,    5,   -1,   -4,   -4,    4,
	   1,   -4,   -4,    7,   -1,   -1,   -3,    0,    5,   -1,   -4,   -1,    2,    0,   -3,    1,
	   1,    2,   -2,   -4,    1,    2,    0,   -5,    2,    3,   -2,   -2,    1,    1,   -2,    2,
	  -3,    0,    0,   -1,   -1,    0,    1,    0,   -3,    0,    0,   -1,    1,   -1,   -2,    1,
	  -1,    0,   -2,    2,    1,   -2,   -1,    1,    0,   -1,   -1,    0,    1,   -1,    0,   -2,
	   1,    1,   -1,    0,   -1,   -1,    0,    0,   -1,   -1,    0,   -1,   -1,    2,   -2,   -1,
	   1,    0,    0,   -1,   -1,    1,    0,   -1,    1,   -1,    0,    1,   -3,    1,    1,   -1,
	  -1,    0,    1,    0,    0,    0,   -1,    0,    0,   -1,    0,    1,    0,    0,    2,   -2,
	   0,    1,    0,    0,    0,    0,    1,    0,    0,    1,    0,    1,   -1,   -1,   -7,   -9,
	  35,  -52,   59,  -33,  -32,   64,  -15,  -41,   19,   22,  -20,    9,  -11,   -3,   33,  -27,
	   2,    7,   -9,   19,  -37,   24,    7,  -11,   11,   -1,  -30,   37,    8,  -57,   36,   19,
	 -33,   14,    0,  -17,   26,    1,  -20,   -5,   26,  -18,  -13,   14,    7,   -6,    4,   -9,
	  -4,   11,    3,  -14,   -7,   20,    0,  -18,   10,    1,    4,   -5,   -7,    6,    0,   -3,
	  -2,   -2,    8,    5,  -11,   -6,   10,   -1,  -10,    6,   -2,   -1,    1,   -3,    0,    3,
	   5,   -9,   -5,    9,   -3,   -4,    1,    1,    3,   -1,   -4,   -1,    2,   -2,   -5,    5,
	  -3,    0,    1,   -5,    4,    2,   -3,   -3,    0,    0,   -2,    1,    0,   -2,    3,   -2,
	  -5,    2,    2,   -2,   -4,    3,    0,   -2,    1,   -2,   -2,    5,   -2,   -6,    1,    2,
	  -1,   -1,    0,    1,   -1,   -2,   -1,   -1,    2,    0,   -4,    0,    1,    0,   -3,    0,
	   2,    0,   -3,    0,    0,    1,   -1,   -1,    1,    0,   -1,   -2,    1,    0,    0,   -1,
	   0,   -2,    1,    0,   -1,    1,   -1,    0,   -2,    1,    1,   -2,   -1,    2,   -2,    1,
	  -3,    1,    1,   -1,    0,    0,   -1,    1,    0,   -2,    2,   -1,   -1,    0,    0,    1,
	   0,    1,    0,   -2,    1,    0,    0,   -1,    1,    0,    0,    0,    0,   -3,  -20,   45,
	 -56,   40,   -5,  -34,   27,   24,  -42,   -1,   29,  -14,   -4,    2,   -7,   24,  -20,   -1,
	  18,  -25,   25,  -29,    9,   21,  -26,   14,    4,  -20,    7,   27,  -42,    5,   31,  -24,
	  -2,   19,  -30,   21,    8,  -11,  -17,   20,    1,  -22,   11,    7,   -7,    6,   -5,   -7,
	   3,   11,   -6,  -18,   11,   16,  -20,    1,    5,    2,   -3,   -3,    0,   -3,    4,   -1,
	  -7,    2,   10,   -9,   -8,    7,    2,   -9,    5,   -1,   -5,    2,    1,   -3,   -2,    9,
	  -5,   -8,    4,    1,   -5,    0,    1,    2,   -1,    0,   -5,    4,   -1,   -5,    4,   -3,
	   1,    1,   -5,    3,    0,    0,   -3,    0,   -1,   -2,    1,    2,   -5,    2,    1,   -5,
	  -2,    3,   -1,   -5,    2,    1,   -4,    2,   -1,   -4,    2,    3,   -7,   -1,    2,    0,
	  -2,    1,    0,   -2,   -1,    0,   -3,    1,    2,   -3,   -2,    3,    0,   -3,   -1,    1,
	   0,   -1,   -2,   -1,    1,    0,    0,   -1,    0,    0,   -2,    0,    0,    1,   -2,    2,
	  -3,    1,    0,    0,   -2,    1,    0,   -1,    0,    0,   -1,   -1,    2,   -3,    0,    0,
	  -1,    0,    0,   -1,    1,    0,   -4,  -13,   32,  -41,   31,  -10,  -10,    4,   22,  -25,
	  -8,   21,   -3,  -14,    5,    1,   12,  -23,    8,   18,  -31,   25,  -26,   10,   17,  -23,
	   8,    5,   -9,    0,   16,  -25,    2,   23,  -22,   -2,   22,  -30,   15,    7,   -6,  -13,
	  12,    1,  -17,    9,    5,   -6,    4,   -3,   -7,    5,    7,   -6,  -13,    7,   10,  -11,
	   0,    0,    4,   -3,   -3,    2,   -7,    4,    2,   -5,    0,    6,   -3,   -8,    4,    2,
	  -8,    7,    0,   -8,   -1,    6,    0,   -8,    6,    0,   -5,    1,    0,   -5,    3,    2,
	  -3,   -2,    4,   -5,   -1,   -1,   -2,    3,   -4,    1,   -1,   -3,    3,   -1,   -2,   -2,
	   1,   -2,   -2,    1,    1,   -4,    1,    2,   -5,   -3,    5,   -3,   -4,    4,   -1,   -4,
	   2,   -1,   -4,    3,    1,   -5,   -2,    2,    0,   -2,    2,   -1,   -4,    3,   -1,   -3,
	   0,    1,   -2,   -2,    1,   -1,   -1,   -1,    0,    0,   -1,   -1,   -1,    0,   -1,    1,
	  -1,   -1,    0,   -2,    1,    0,   -1,   -1,    0,   -1,   -1,   -1,    2,   -2,   -1,    1,
	  -1,   -2,    1,   -1,   -1,    1,   -2,    1,   -7,   -3,   15,  -23,   20,  -16,    9,  -12,
	  16,  -12,   -8,   11,    5,  -18,    6,    8,    0,  -18,   16,    4,  -19,   16,  -17,   10,
	   5,   -8,   -2,    9,   -5,   -4,   10,  -17,    5,   13,  -18,    2,   12,  -17,   10,    0,
	  -2,   -8,    7,   -4,   -7,    6,    1,   -3,    1,    3,   -9,   -2,   10,   -7,   -8,    4,
	   6,   -6,    1,    0,    0,   -2,    1,   -1,   -8,    6,    1,   -5,    2,    4,   -2,   -4,
	   1,    1,   -7,    5,   -1,   -4,   -2,    4,    0,   -4,    4,   -3,   -4,    1,    0,   -3,
	   0,    2,   -1,   -2,    2,   -2,   -1,   -3,    0,    3,   -4,    3,   -3,    0,    2,    0,
	  -3,   -1,    1,   -3,   -1,    2,    0,   -1,    0,    0,   -3,    0,    1,   -4,   -1,    2,
	   0,   -2,    0,    1,   -3,    1,    1,   -3,   -2,    2,   -1,   -1,    2,   -1,   -2,    1,
	   0,   -1,   -1,    0,    2,   33,   42,   58,   71,   79,   85,   88,   91,   94,   79,   95,
	  82,  106,   86,  105,   47,   16,   -6,   13,   44,   31,  -15,  -38,  -36,   20,   70,   41,
	  48,   58,   24,  -57, -127, -119, -102, -126, -128, -111,  -78,  -82,  -88,  -87,  -60,  -66,
	 -98, -104,  -99,  -97,  -99, -104, -101,  -88,  -87,  -91,  -61,  -27,  -34,  -54,  -55,  -45,
	 -24,  -10,   -5,   -4,    5,   34,   63,  101,   94,   78,   52,   51,   52,   74,   81,   77,
	  59,   46,   17,    7,   39,   53,   47,   42,   66,   83,   73,   52,   28,   22,   11,    8,
	  11,    0,  -15,  -23,  -15,  -14,   -6,   16,   46,   62,   71,   76,   90,  102,  103,  103,
	 101,  100,   90,   75,   63,   67,   49,   37,   28,   12,    5,    6,   15,   15,    8,   -7,
	 -12,   -4,  -10,  -28,  -24,  -17,  -25,  -50,  -64,  -81, -103, -116, -116, -113,  -95,  -72,
	 -54,  -41,  -47,  -65,  -65,  -50,  -33,  -24,   -7,   11,    8,   -4,  -13,  -28,  -51,  -75,
	 -90,  -91,  -90,  -90,  -87,  -88,  -83,  -84,  -82,  -81,  -81,  -76,  -65,  -71,  -85,  -84,
	 -79,  -83,  -81,  -77,  -72,  -70,  -65,  -66,  -66,  -65,  -66,  -68,  -61,  -56,  -51,  -36,
	 -13,   -3,   -5,   -8,  -12,  -12,    3,   16,   21,   31,   50,   69,   77,   82,   90,  102,
	 110,  114,  116,  117,  118,  119,  116,  112,  109,  105,   98,   99,  103,  102,   91,   73,
	  64,   63,   61,   57,   51,   40,   24,   35,   57,   75,   84,   79,   65,   37,    4,  -26,
	 -45,  -57,  -54,  -46,  -45,  -54,  -67,  -67,  -48,  -16,   15,   35,   44,   45,   44,   45,
	  46,   38,   23,    2,  -15,  -34,  -52,  -60,  -70,  -77,  -80,  -79,  -74,  -77,  -84,  -86,
	 -80,  -72,  -68,  -72,  -80,  -87,  -92,  -96, -101, -104, -104, -101,  -93,  -90,  -89,  -86,
	 -85,  -84,  -83,  -82,  -81,  -79,  -77,  -76,  -73,  -71,  -66,  -62,  -55,  -39,  -31,  -27,
	 -25,  -31,  -37,  -46,  -51,  -53,  -54,  -48,  -45,  -38,  -20,    3,   24,   35,   39,   32,
	  16,    5,    3,    0,   -6,  -13,  -13,  -11,   -2,   14,   28,   40,   50,   53,   50,   55,
	  64,   74,   90,  105,  108,  112,  106,  104,  109,  112,  123,  127,  127,  127,  127,  127,
	 127,  118,  113,  107,  110,  114,  111,  104,  101,  101,  102,  103,   99,   99,   89,   73,
	  53,   35,   20,    0,  -22,  -43,  -63,  -77,  -82,  -76,  -65,  -48,  -36,  -29,  -24,  -25,
	 -29,  -37,  -40,  -49,  -59,  -67,  -73,  -76,  -78,  -79,  -75,  -73,  -74,  -75,  -68,  -52,
	 -44,  -30,  -19,   -9,   -6,   -9,  -13,  -24,  -33,  -35,  -31,  -30,  -35,  -40,  -44,  -45,
	 -51,  -53,  -54,  -50,  -50,  -47,  -42,  -50,  -55,  -54,  -56,  -56,  -54,  -54,  -49,  -48,
	 -41,  -32,  -28,  -18,  -13,   -5,    6,   18,   33,   49,   60,   71,   78,   88,   95,   97,
	  93,   88,   91,   93,   97,   98,   97,   94,   91,   85,   81,   72,   70,   66,   61,   60,
	  64,   66,   74,   83,   92,  102,  108,  109,  107,  102,   97,   95,   91,   87,   80,   74,
	  67,   62,   61,   58,   61,   61,   57,   53,   43,   35,   27,   25,   24,   20,   20,   22,
	  27,   34,   36,   32,   21,    8,   -3,  -10,  -16,  -18,  -16,  -16,  -19,  -15,  -11,  -11,
	 -12,  -20,  -34,  -45,  -59,  -72,  -80,  -89,  -94,  -95, -102, -111, -114, -111, -111, -108,
	-106, -104, -101,  -98,  -93,  -90,  -86,  -86,  -83,  -82,  -81,  -79,  -76,  -73,  -70,  -72,
	 -78,  -81,  -79,  -79,  -72,  -60,  -43,  -31,  -25,  -27,  -34,  -37,  -40,  -42,  -41,  -39,
	 -36,  -34,  -25,  -12,   -4,    5,   12,   16,   17,   15,   13,    6,   -4,   -7,   -8,   -6,
	  -1,    4,    7,    9,   12,   16,   19,   19,   22,   28,   29,   28,   29,   30,   34,   40,
	  49,   57,   71,   78,   85,   92,   96,   95,   89,   85,   86,   93,   99,  104,  102,  100,
	  94,   85,   77,   73,   69,   66,   63,   60,   60,   59,   57,   52,   47,   41,   31,   18,
	   6,   -3,   -7,  -11,  -12,  -14,  -18,  -22,  -23,  -22,  -24,  -30,  -37,  -41,  -44,  -50,
	 -56,  -64,  -67,  -65,  -62,  -58,  -58,  -58,  -59,  -61,  -62,  -66,  -72,  -78,  -79,  -77,
	 -73,  -68,  -64,  -61,  -56,  -53,  -54,  -52,  -52,  -57,  -63,  -69,  -70,  -68,  -65,  -62,
	 -59,  -57,  -56,  -58,  -60,  -61,  -63,  -64,  -62,  -61,  -60,  -58,  -54,  -49,  -45,  -42,
	 -39,  -36,  -32,  -28,  -22,  -13,   -7,   -3,    2,   13,   28,   41,   52,   64,   71,   73,
	  73,   70,   64,   61,   60,   64,   66,   65,   66,   64,   61,   60,   62,   65,   64,   66,
	  67,   67,   68,   66,   64,   66,   68,   73,   76,   74,   72,   66,   58,   52,   46,   42,
	  38,   38,   41,   47,   52,   52,   48,   45,   42,   40,   38,   34,   29,   27,   26,   28,
	  29,   28,   29,   30,   31,   28,   24,   21,   19,   17,   14,   10,    6,    3,   -4,   -9,
	 -15,  -19,  -26,  -33,  -40,  -49,  -55,  -60,  -65,  -70,  -73,  -72,  -72,  -71,  -70,  -71,
	 -75,  -78,  -81,  -83,  -86,  -86,  -85,  -84,  -82,  -80,  -77,  -72,  -69,  -66,  -63,  -61,
	 -61,  -61,  -61,  -61,  -60,  -58,  -53,  -48,  -42,  -36,  -30,  -28,  -30,  -32,  -33,  -32,
	 -31,  -28,  -22,  -18,  -10,   -5,    0,    3,    6,   11,   16,   19,   22,   24,   26,   27,
	  29,   34,   40,   46,   48,   48,   48,   45,   40,   36,   33,   31,   33,   35,   40,   48,
	  55,   62,   68,   73,   76,   78,   78,   77,   79,   82,   85,   87,   87,   87,   86,   86,
	  86,   83,   78,   71,   63,   55,   48,   44,   39,   36,   36,   36,   35,   32,   28,   24,
	  18,   13,    9,    6,    4,    1,   -2,   -5,  -11,  -17,  -20,  -21,  -20,  -21,  -24,  -28,
	 -32,  -34,  -33,  -33,  -35,  -37,  -40,  -43,  -47,  -52,  -58,  -63,  -69,  -74,  -77,  -80,
	 -81,  -82,  -81,  -80,  -77,  -74,  -69,  -62,  -54,  -48,  -48,  -51,  -54,  -57,  -57,  -57,
	 -56,  -55,  -55,  -56,  -57,  -56,  -55,  -54,  -54,  -54,  -54,  -52,  -49,  -45,  -41,  -38,
	 -34,  -31,  -29,  -27,  -24,  -20,  -17,  -11,   -7,   -3,    0,    5,   10,   16,   22,   27,
	  31,   34,   38,   42,   44,   45,   48,   50,   52,   57,   61,   64,   64,   65,   65,   63,
	  60,   57,   55,   55,   58,   61,   63,   65,   67,   69,   71,   74,   77,   79,   79,   77,
	  74,   71,   68,   66,   63,   60,   57,   55,   51,   46,   40,   36,   30,   25,   20,   17,
	  16,   17,   16,   14,   12,   10,    7,    3,   -1,   -5,  -11,  -15,  -17,  -18,  -18,  -19,
	 -21,  -25,  -29,  -32,  -33,  -33,  -36,  -39,  -43,  -46,  -50,  -53,  -56,  -58,  -59,  -60,
	 -61,  -62,  -63,  -65,  -66,  -67,  -68,  -70,  -72,  -72,  -70,  -67,  -63,  -61,  -60,  -60,
	 -58,  -56,  -54,  -53,  -52,  -52,  -52,  -51,  -50,  -49,  -47,  -45,  -43,  -40,  -37,  -35,
	 -34,  -32,  -29,  -25,  -21,  -18,  -14,   -9,   -4,    0,    4,    7,   11,   15,   18,   21,
	  25,   28,   33,   37,   41,   44,   46,   47,   47,   46,   46,   45,   43,   42,   42,   43,
	  46,   48,   49,   50,   52,   55,   59,   62,   65,   66,   67,   68,   69,   69,   70,   72,
	  74,   74,   73,   72,   71,   69,   65,   61,   57,   53,   50,   46,   43,   38,   35,   32,
	  28,   23,   19,   17,   17,   15,   13,   11,    9,    5,    1,   -3,   -6,   -9,  -12,  -14,
	 -17,  -19,  -23,  -27,  -31,  -35,  -38,  -40,  -43,  -46,  -48,  -52,  -55,  -57,  -61,  -64,
	 -66,  -67,  -68,  -69,  -70,  -70,  -70,  -69,  -69,  -70,  -71,  -70,  -66,  -62,  -59,  -55,
	 -52,  -50,  -46,  -43,  -41,  -38,  -36,  -35,  -35,  -34,  -33,  -33,  -33,  -33,  -31,  -30,
	 -28,  -26,  -25,  -24,  -21,  -20,  -20,  -19,  -19,  -18,  -17,  -16,  -15,  -13,  -11,   -8,
	  -3,    2,    9,   15,   21,   27,   33,   38,   41,   45,   48,   51,   53,   55,   56,   56,
	  56,   56,   56,   56,   56,   55,   57,   58,   60,   61,   62,   62,   64,   66,   68,   69,
	  71,   72,   73,   74,   72,   70,   67,   63,   60,   57,   54,   50,   46,   41,   36,   31,
	  27,   23,   19,   16,   14,   12,   11,    9,    8,    5,    2,   -1,   -4,   -8,  -10,  -15,
	 -18,  -19,  -20,  -22,  -22,  -23,  -23,  -24,  -26,  -29,  -31,  -33,  -35,  -36,  -37,  -38,
	 -41,  -44,  -46,  -48,  -50,  -52,  -54,  -56,  -59,  -61,  -63,  -63,  -64,  -65,  -64,  -63,
	 -62,  -61,  -60,  -59,  -58,  -57,  -58,  -57,  -57,  -55,  -53,  -50,  -49,  -47,  -46,  -43,
	 -40,  -37,  -33,  -31,  -28,  -26,  -23,  -20,  -16,  -14,  -12,   -9,   -5,   -2,    1,    5,
	   9,   13,   17,   21,   24,   26,   29,   32,   35,   37,   37,   38,   39,   41,   43,   44,
	  45,   46,   48,   50,   51,   53,   52,   52,   50,   48,   47,   46,   46,   46,   46,   47,
	  48,   49,   51,   54,   56,   58,   60,   61,   62,   62,   62,   61,   59,   57,   55,   54,
	  53,   52,   51,   49,   46,   41,   36,   31,   27,   22,   18,   14,   11,    9,    6,    3,
	   0,   -2,   -5,   -8,  -11,  -16,  -20,  -25,  -28,  -31,  -34,  -37,  -39,  -41,  -41,  -42,
	 -42,  -42,  -43,  -45,  -46,  -47,  -49,  -50,  -52,  -54,  -56,  -57,  -58,  -60,  -61,  -63,
	 -64,  -64,  -64,  -63,  -63,  -61,  -59,  -58,  -57,  -55,  -54,  -53,  -52,  -52,  -51,  -50,
	 -49,  -47,  -46,  -45,  -44,  -42,  -40,  -38,  -35,  -32,  -30,  -28,  -25,  -22,  -19,  -17,
	 -15,  -12,   -9,   -5,   -1,    3,    7,   11,   15,   19,   23,   25,   27,   30,   34,   36,
	  37,   38,   39,   40,   42,   44,   45,   46,   47,   49,   50,   52,   53,   52,   51,   49,
	  47,   47,   46,   46,   46,   47,   47,   48,   50,   52,   55,   57,   59,   61,   62,   62,
	  62,   61,   60,   58,   56,   54,   54,   53,   51,   50,   47,   44,   39,   34,   29,   25,
	  20,   16,   13,   10,    7,    4,    2,   -1,   -3,   -6,   -9,  -14,  -18,  -22,  -26,  -30,
	 -33,  -35,  -38,  -40,  -41,  -41,  -42,  -42,  -43,  -44,  -46,  -47,  -48,  -49,  -51,  -53,
	 -55,  -56,  -57,  -59,  -60,  -62,  -63,  -64,  -64,  -63,  -63,  -62,  -60,  -59,  -57,  -56,
	 -55,  -53,  -52,  -52,  -51,  -51,  -50,  -48,  -46,  -45,  -44,  -43,  -41,  -39,  -36,  -34,
	 -31,  -29,  -26,  -24,  -21,  -16,    1,   -2,   -1,   -9,   -9,   -6,    5,    6,   -1,  -10,
	   8,   24,   11,   -2,  -14,   -9,  -15,  -13,    5,   14,   12,   -6,   -1,  -12,    1,   -9,
	  12,   12,   10,    5,  -19,  -11,  -13,   -2,    8,    5,    1,   -2,   -3,    9,   -6,    6,
	   5,    6,   -3,  -17,   -7,    3,    2,   -1,    0,    7,   -7,    5,    4,    6,  -18,  -24,
	   6,   20,   -1,   -4,   -1,   10,    3,  -10,    8,    7,  -11,  -17,  -15,    5,   18,    4,
	   1,    8,  -16,   -4,    0,   11,    9,  -10,  -15,    0,  -22,  -12,   19,   34,   16,   -9,
	 -16,   -7,  -12,  -10,   13,   23,   -1,  -10,   -2,   -3,  -11,   13,    7,   -6,   -9,    3,
	  11,  -10,  -18,   12,   22,    7,  -27,  -29,   -4,   20,   20,   10,    8,  -16,  -26,   -6,
	  22,   21,    7,   15,    8,  -50,  -50,   -7,   35,   22,  -13,   32,   41,  -33,  -46,  -10,
	  23,   -7,  -25,   23,   21,  -38,  -36,   14,   44,    2,    2,   34,  -14,  -51,  -29,   11,
	  19,    7,   22,   13,  -23,  -21,   -8,   -9,    1,   14,   26,   26,   -8,  -34,  -33,    4,
	   1,   -6,   -2,   16,   -7,  -23,   12,   27,    5,    6,    6,    0,   -8,    0,   -1,  -17,
	 -13,  -12,    3,    9,    4,   11,   23,   36,    0,  -43,  -16,    4,  -21,  -26,   27,   16,
	 -25,    3,   65,    4,  -34,   24,  -10,  -38,  -14,   13,    4,  -15,   36,   44,  -42,  -51,
	  20,   -5,   -6,   68,   20,  -18,  -39,  -11,    9,   17,    6,  -33,  -20,  -13,   48,   30,
	  22,   -4,   -9,  -53,  -20,   32,   32,  -16,   17,  -11,  -36,   -8,   -5,   39,   28,   33,
	  21,  -64,  -48,    3,  -22,   15,   62,  -26,    0,    3,    5,   73,  -14,  -48,  -20,  -59,
	   4,   70,   60,   -7,   -2,  -88,  -22,  -17,   39,   17,   33,   -3,   15,   28,  -47,  -80,
	 -37,    5,    7,  104,   16,  -99,  -92,  -36,  109,   78,   26,  -15,  -92,  -21,   62,   48,
	 -51,  -81,  -25,   55,   63,   35,   21, -115,  -54,  101,   73,  -41, -110,  -66,   50,  107,
	  45,   -8, -109,  -38,   12,  102,    3,   17,  -45,   -2,  -36,   39,   46,  -12,  -28,  -27,
	 -17,   17,  -18,   82,   -5,   -3,  -25,   -5,  -14,   15,    9,   -3,  -17,   -6,    2,    7,
	 -36,  -13,    6,   21,  -23,  -20,   16,  -18,    3,   -2,   26,    0,   13,  -23,   -2,  -19,
	 -28,  -18,   15,   12,   22,   -4,   23,  -17,  -22,   -9,  -18,   -4,   11,   13,    0,   34,
	 -16,  -20,   26,   23,   15,   -4,  -25,    7,    8,   -9,    8,   44,    1,  -40,   17,  -32,
	   9,  -30,  -52,   52,    3,    2,  -21,   83,   58,  -14,  -46,  -61,  -12,  -67,  -20,   64,
	  72,   57,  -10,    5,    1,  -77,   31,  -47,  -39,   12,   22,   57,   28,    0,    9,  -76,
	  15,  -74,   33,  -12,   39,  114,  -35,  -36,  -38,  -23,   27,  -21,   14,   56,   47,    6,
	 -72,  -61,   -4,   18,   -4,   19,   13,   45,   71,   48,   -1, -125,  -52,  -56,  -20,  -18,
	 -12,   51,   78,   68,  -46,   32,  -40,  -29,  -28,  -81,  -25,   75,   42,   58,  -38,    1,
	 -29,  -34,   31,  -36,  -14,   10,   64,   37,    2,  -31,  -72,  -17,  -33,   30,  -52,  -54,
	  25,   43,   70,   81,   -9,  -73,    4,  -65,   15,  -28,   25,    0,   28,   19,   51,  -26,
	   6,    0,  -37,  -15,  -22,  -20,  -16,   -5,   50,   56,   67,   25,   16,  -35,  -29,  -14,
	 -39,   19,  -24,  -52,  -13,  -32,  -10,   39,   33,   59,    6,   37,   55,   11,   -9,  -35,
	 -15,  -57,  -56,  -36,  -34,   19,   19,    6,   20,   17,  -11,    5,   26,   19,   16,    7,
	 -20,  -26,  -55,  -62,  -36,  -18,   19,   37,   47,   25,   -6,  -14,    1,   -4,  -13,   12,
	  23,   34,   38,   41,   33,   31,  -10,  -56,  -52,  -49,  -31,  -40,  -21,  -12,    0,    5,
	  12,   22,   22,   21,   31,   12,    2,   -8,   -4,  -18,   -7,    3,    1,   -1,   11,   12,
	  18,   17,    9,   -2,  -12,  -13,  -11,   -1,    8,    3,    3,    2,    5,   -5,  -16,  -15,
	 -13,   -8,  -12,   -9,   -2,   -1,    2,    7,   10,    7,   11,   14,    7,   -1,   -4,    5,
	  -3,   -2,    0,   -6,  -10,   -1,   -5,    3,    9,    0,   -8,   -9,   -6,   -6,    0,    6,
	   3,    6,    7,   10,    0,   -8,   -3,   -5,   -1,   -8,   -7,   -4,   -3,   -3,    0,   -1,
	  -6,    2,    7,    7,    5,    4,   10,    5,    8,   -1,  -11,  -15,  -11,  -15,  -10,   -1,
	  -8,  -12,   -5,    1,    3,    6,    8,   11,   18,   22,   26,   10,  -10,   -1,  -15,   -3,
	 -21,  -16,  -14,  -12,   -7,   -8,  -18,  -20,  -11,    9,   20,   27,   26,   11,    1,   21,
	   6,    3,   -9,  -15,   -9,  -20,    3,    5,   21,   14,    6,   11,  -21,  -22,   -6,  -21,
	 -23,  -18,   11,    6,    5,   21,    9,   23,   16,   -3,  -30,   -7,  -27,   -4,    5,   18,
	  22,   16,    2,    7,   -1,   -2,  -10,  -14,  -10,  -17,  -10,  -15,  -16,    3,   12,   30,
	  18,   -1,   -6,  -15,   -3,    5,   11,  -18,   -2,    8,   21,   11,  -13,   -4,  -30,   -7,
	   0,   12,   25,   -3,   17,   14,  -20,   -6,  -27,  -41,  -11,  -12,   23,   -8,   13,   24,
	  18,   27,  -11,   -8,  -12,   -2,   17,   23,   13,  -20,  -21,   -2,  -21,  -34,  -46,  -23,
	  28,   48,    9,  -10,    8,   29,   27,    5,  -29,  -12,   13,   -5,   -2,  -35,    1,    3,
	  24,   13,   17,  -18,  -30,  -21,   14,   -1,    6,   -8,   48,   45,   -7,  -34,  -49,  -32,
	  -6,  -26,   20,   29,   76,   30,  -21,  -66,  -36,  -15,   40,   -5,   29,    3,   10,  -39,
	 -25,   -2,   24,   19,   19,   -4,   -8,    3,  -22,  -23,  -18,   13,   17,   -3,  -25,   23,
	  66,   26,  -18,  -27,  -34,  -30,  -30,   36,   25,   28,  -22,  -17,   -7,  -22,   21,   18,
	  42,    8,  -25,  -28,  -31,  -10,   15,   18,    0,   -1,   -5,   16,  -12,   13,   13,   12,
	  -8,  -37,   -9,   13,   -5,    8,   -3,   13,   -8,    4,   24,  -16,  -43,  -18,   26,   26,
	 -11,   -9,   19,    9,  -15,    9,   15,  -12,  -31,  -27,    8,   29,    5,    7,   17,  -33,
	 -14,   14,   23,   -1,  -18,  -18,   -4,  -35,  -17,   47,   71,  -16,  -20,  -11,  -16,  -25,
	   6,   37,   14,  -18,    1,   -8,  -14,   10,   14,    2,  -20,    0,   20,  -10,  -25,   14,
	  32,    7,  -39,  -38,   -3,   34,   25,   13,    3,  -24,  -34,    5,   38,   18,    7,   29,
	 -30,  -74,  -41,   36,   40,  -12,   26,   55,  -17,  -59,  -26,   28,   -2,  -31,   24,   25,
	 -44,  -39,   21,   44,   -1,   10,   33,  -34,  -50,  -12,   18,   13,   20,   17,   -6,  -31,
	 -10,   -6,   -1,    7,   12,   14,    6,  -16,  -24,    6,    9,  -16,  -16,    6,    2,  -10,
	  13,   12,  -10,    0,   11,   11,   10,   -3,  -22,  -22,  -12,   -7,   19,   17,   -2,  -12,
	   6,   16,    7,  -11,   -1,  -20,  -22,   -8,   26,   16,   -3,   12,    1,  -33,    2,   30,
	 -23,   -5,   28,  -17,  -19,   21,    9,  -28,  -14,   25,   -1,    4,   24,    0,  -26,   -9,
	   7,    2,   -2,   20,  -10,  -11,    5,   -3,   -4,    8,   -9,   14,   18,   25,  -22,  -15,
	 -22,   -3,  -12,   27,   30,   15,  -11,  -26,   -4,   15,   -7,  -14,   23,  -23,   -4,   34,
	  -2,  -38,   14,  -11,  -24,   16,   34,   11,  -13,    3,   -3,  -19,  -34,    0,   -3,   24,
	  43,    1,  -12,  -38,  -25,  -11,   23,   35,   12,  -28,  -25,  -16,    7,   22,    1,  -10,
	   8,    8,   -3,    6,  -24,  -20,  -13,    9,   31,   12,  -16,    7,  -29,    5,    8,  -28,
	   3,    4,   12,   26,   -9,  -15,   -5,  -20,    9,   21,    0,    1,   -9,    0,    8,   -3,
	  -7,   -9,   -3,   22,    8,    3,  -11,   -9,  -11,    3,   15,    9,  -10,    1,   -3,   -3,
	  -2,   -5,    9,    0,   12,    7,  -15,   -7,    0,   -8,    5,    9,   -5,    7,   -7,   10,
	   4,  -11,   -2,   -8,   -4,    9,    9,    0,   -2,  -11,   -3,   -4,    3,    4,    3,   -2,
	   3,    3,   -8,   -9,   -2,    0,    3,    5,   -1,  -10,   -7,    2,    8,    3,    0,   -5,
	  -5,    2,    4,   -2,   -5,   -3,    2,    3,    0,    2,   -5,   -3,    3,    2,   -2,   -4,
	  -2,    1,    2,    1,    0,   -1,    1,   -2,   -5,    0,    0,    2,    0,   -3,   -2,    0,
	   1,    0,   -2,   -2,   -2,    0,    3,    3,   -2,   -5,   -1,   -1,   -1,   -4,    3,    9,
	   1,   -1,   -2,  -11,   -7,    1,    9,   11,    8,   -4,  -11,  -12,   -9,   -4,   18,   15,
	  14,    1,  -22,  -29,  -14,    3,   30,   29,   14,   -2,  -35,  -43,  -11,   13,   36,   42,
	  15,  -16,  -49,  -44,  -10,   28,   47,   38,   11,  -25,  -66,  -39,    4,   36,   58,   33,
	  -3,  -44,  -65,  -29,   19,   52,   54,   23,  -13,  -59,  -65,  -15,   32,   69,   49,    8,
	 -30,  -74,  -51,    3,   43,   71,   40,   -5,  -48,  -77,  -31,   16,   57,   67,   24,  -15,
	 -67,  -72,  -12,   36,   66,   59,    5,  -31,  -80,  -51,    3,   49,   75,   37,   -2,  -59,
	 -81,  -28,   20,   67,   66,   22,  -23,  -76,  -65,  -10,   41,   78,   48,    4,  -36,  -85,
	 -47,    6,   59,   80,   31,   -8,  -69,  -82,  -22,   29,   73,   63,   17,  -31,  -81,  -63,
	  -1,   47,   79,   47,    3,  -56,  -90,  -40,   19,   75,   73,   28,  -25,  -86,  -74,  -10,
	  48,   85,   56,    6,  -51,  -93,  -48,   11,   67,   86,   33,  -11,  -78,  -87,  -29,   36,
	  89,   66,   13,  -38,  -91,  -60,    2,   50,   83,   48,    0,  -56,  -90,  -41,   16,   71,
	  78,   30,  -17,  -80,  -75,  -20,   31,   82,   62,   15,  -32,  -85,  -66,   -7,   48,   84,
	  50,    4,  -53,  -87,  -44,    8,   62,   78,   35,   -8,  -65,  -83,  -30,   23,   70,   71,
	  24,  -20,  -76,  -75,  -12,   32,   73,   62,   15,  -30,  -85,  -62,   -2,   41,   76,   51,
	   9,  -39,  -86,  -52,    1,   45,   79,   46,    8,  -49,  -89,  -46,    3,   54,   80,   43,
	   7,  -55,  -83,  -50,    0,   53,   76,   54,   11,  -52,  -83,  -55,    0,   40,   67,   58,
	  22,  -32,  -79,  -67,  -11,   28,   63,   52,   37,   -9,  -70,  -63,  -28,   10,   42,   49,
	  53,    8,  -46,  -64,  -41,    1,   22,   38,   51,   39,  -16,  -63,  -46,  -23,    5,   33,
	  38,   48,   14,  -42,  -57,  -29,   -5,   22,   37,   40,   28,  -23,  -53,  -39,  -10,   14,
	  30,   40,   31,   -1,  -48,  -40,  -18,   11,   19,   31,   26,   14,  -20,  -50,  -25,   -5,
	  11,   31,   30,   14,    0,  -35,  -39,   -4,   -1,   19,   27,   17,    9,  -10,  -39,  -21,
	  -8,    9,   24,   26,   13,   -5,  -19,  -30,  -12,   -1,   17,   25,   16,    3,  -19,  -26,
	 -13,   -6,   17,   22,   20,    5,  -16,  -32,  -19,   -1,   23,   27,   23,    4,  -30,  -33,
	 -23,   -1,   35,   35,   24,   -2,  -41,  -45,  -21,    9,   45,   41,   22,  -12,  -50,  -46,
	 -18,   28,   55,   45,   10,  -27,  -78,  -42,    0,   53,   66,   32,   -1,  -61,  -74,  -28,
	  27,   64,   64,   24,  -28,  -80,  -66,  -15,   53,   84,   48,    5,  -59,  -94,  -41,   17,
	  75,   80,   26,  -21,  -91,  -79,  -12,   48,   87,   55,   10,  -58,  -96,  -46,    9,   80,
	  81,   30,  -23,  -84,  -80,  -15,   49,   90,   49,    9,  -57,  -95,  -45,   17,   76,   79,
	  26,  -20,  -91,  -75,  -18,   52,   90,   52,    6,  -59,  -92,  -41,   15,   68,   80,   31,
	 -21,  -87,  -76,  -13,   45,   87,   49,   11,  -60,  -94,  -35,   14,   80,   68,   22,  -23,
	 -89,  -66,   -7,   47,   93,   44,   -8,  -61,  -95,  -31,   24,   86,   75,   10,  -35,  -96,
	 -66,   -1,   61,  100,   44,  -12,  -77, -105,  -33,   32,   97,   92,   16,  -44, -111,  -90,
	  -5,   65,  121,   65,   -3,  -80, -123,  -59,   17,   98,  111,   46,  -25, -112, -109,  -33,
	  42,  112,   90,   30,  -55, -115,  -84,  -17,   66,  105,   71,   13,  -73, -113,  -61,    0,
	  77,   96,   56,    4,  -80, -108,  -50,    8,   78,   93,   47,    3,  -88,  -98,  -40,    7,
	  65,   76,   53,   18,  -71,  -90,  -44,    0,   39,   57,   43,   34,  -19,  -69,  -54,  -19,
	  18,   32,   31,   34,    7,  -40,  -36,  -21,   -1,   12,   12,   25,   27,   -9,  -32,  -14,
	 -14,    2,    0,    1,   20,   19,   -2,  -13,  -11,  -18,  -12,   -2,   18,   24,   12,   -2,
	 -14,  -19,  -19,  -12,   18,   24,   22,   -2,  -15,  -32,  -20,    3,   22,   26,   17,  -13,
	 -31,  -27,  -13,   17,   33,   32,    5,  -29,  -47,  -29,    2,   33,   42,   32,   -6,  -53,
	 -52,  -24,   22,   51,   41,   27,  -32,  -74,  -45,    0,   45,   59,   33,   -1,  -62,  -66,
	 -31,   26,   73,   49,   17,  -42,  -80,  -42,   -8,   63,   72,   28,  -10,  -75,  -72,  -23,
	  32,   88,   47,   13,  -56,  -93,  -38,   10,   76,   69,   26,  -20,  -96,  -66,  -10,   48,
	  90,   47,    0,  -69, -103,  -29,   25,   87,   73,   18,  -35, -104,  -68,   -2,   61,   93,
	  47,   -5,  -83,  -98,  -31,   30,   92,   68,   17,  -39,  -97,  -63,   -5,   64,   88,   35,
	  -9,  -74,  -86,  -22,   31,   85,   54,   13,  -44,  -93,  -46,    9,   65,   75,   23,  -17,
	 -75,  -78,  -15,   39,   84,   54,    3,  -52,  -96,  -46,   12,   71,   90,   29,  -18,  -89,
	 -87,  -26,   36,   86,   72,   26,  -37, -106,  -77,  -12,   45,   99,   68,   22,  -46, -108,
	 -73,  -10,   43,   87,   69,   19,  -27,  -92,  -79,  -12,   27,   63,   57,   26,    4,  -53,
	 -75,  -35,   12,   33,   37,   31,   26,   -9,  -53,  -39,  -16,    6,   20,   23,   22,   13,
	  -8,  -22,  -23,  -18,   -3,    9,   25,   19,    4,   -8,  -20,  -17,  -10,    6,   16,   17,
	  13,   -8,  -34,  -21,   -6,   17,   33,   23,    6,  -32,  -51,  -23,   11,   36,   46,   31,
	 -11,  -46,  -65,  -31,   15,   59,   55,   28,  -20,  -73,  -64,  -26,   42,   78,   51,   14,
	 -53,  -85,  -48,   -4,   70,   80,   38,  -16,  -80,  -76,  -32,   39,   90,   58,   19,  -59,
	 -99,  -50,   14,   71,   75,   36,  -21,  -94,  -70,  -23,   51,   88,   53,    9,  -68,  -97,
	 -40,   16,   83,   73,   29,  -33, -100,  -61,  -13,   58,   87,   41,    0,  -74,  -81,  -35,
	  24,   87,   55,   20,  -41,  -88,  -58,    0,   69,   73,   34,   -5,  -86,  -75,  -20,   38,
	  79,   49,   13,  -48,  -90,  -39,    2,   71,   68,   31,  -16,  -84,  -67,  -15,   38,   79,
	  42,   12,  -50,  -85,  -37,    2,   62,   71,   34,   -5,  -83,  -75,  -24,   27,   82,   51,
	  27,  -30,  -88,  -54,  -15,   44,   73,   50,   16,  -49,  -81,  -47,   -6,   38,   58,   50,
	  27,  -31,  -69,  -52,  -13,   15,   36,   45,   33,   -5,  -41,  -44,  -23,    2,   14,   27,
	  33,   10,  -25,  -20,  -18,   -6,    1,   -1,   17,   22,    3,  -13,  -10,  -17,  -13,   -6,
	  13,   24,   15,    1,  -11,  -19,  -19,  -16,   12,   24,   24,    3,  -12,  -29,  -26,   -1,
	  18,   27,   19,   -4,  -31,  -28,  -19,   11,   30,   35,   12,  -21,  -46,  -35,   -6,   28,
	  42,   36,    5,  -46,  -57,  -31,   10,   50,   43,   33,  -16,  -71,  -55,   -9,   35,   62,
	  38,   10,  -51,  -71,  -40,   11,   69,   58,   24,  -26,  -81,  -50,  -18,   48,   79,   37,
	   1,  -62,  -81,  -32,   16,   84,   59,   20,  -37,  -96,  -50,   -2,   63,   78,   33,   -4,
	 -85,  -80,  -20,   33,   88,   59,   10,  -50, -107,  -47,   14,   75,   85,   27,  -19,  -95,
	 -83,  -15,   47,   94,   60,    8,  -66, -105,  -46,   15,   83,   81,   26,  -23,  -91,  -76,
	 -18,   48,   92,   47,    1,  -59,  -94,  -36,   18,   78,   66,   19,  -27,  -91,  -60,   -3,
	  53,   80,   35,   -8,  -62,  -86,  -28,   27,   79,   66,   13,  -38,  -94,  -62,    1,   56,
	  95,   42,   -6,  -75,  -96,  -39,   22,   80,   80,   36,  -20,  -97,  -92,  -24,   30,   93,
	  79,   32,  -27, -102,  -87,  -22,   31,   81,   79,   29,  -14,  -81,  -91,  -25,   19,   56,
	  63,   31,   11,  -39,  -77,  -47,    3,   31,   37,   33,   27,    3,  -48,  -46,  -20,    0,
	  18,   22,   23,   16,   -3,  -20,  -19,  -15,   -4,    2,    8,    5,    0,    0,    0,    1,
	  -1,   -1,    3,   -4,   -2,    1,   -1,   -2,    2,    3,   -6,    1,    2,   -6,    2,    2,
	  -4,   -1,    2,   -5,    1,    4,   -4,    0,   -1,    0,   -1,   -2,    2,    2,   -6,    0,
	   4,   -3,   -3,    4,   -2,   -3,   -2,    0,    1,    1,   -2,   -2,    3,   -8,   27,  -42,
	  11,   21,  -35,   34,  -25,   12,    9,  -24,   14,   13,  -38,   53,  -42,   -3,   46,  -73,
	  55,  -16,   -9,   28,  -49,   38,  -12,  -21,   49,  -51,   20,   32,  -73,   64,  -28,   -7,
	  32,  -50,   42,  -11,  -30,   49,  -21,  -31,   46,  -25,   -7,   20,  -22,   18,  -16,  -10,
	  21,  -23,    5,   28,  -35,    8,    0,    8,  -26,   19,    6,  -11,  -20,   64,  -46,  -18,
	  51,  -73,  119, -117,   46,   36,  -80,   67,  -46,   22,    0,  -24,   56,  -59,   14,   26,
	 -40,   24,   -9,   20,  -20,  -15,   43,  -26,  -11,    9,   14,   -3,  -31,    6,   54,  -62,
	   3,   67,  -78,   20,   21,  -25,   31,  -41,   18,   27,  -53,   32,   15,  -48,   37,  -11,
	   4,  -12,   -3,   31,  -24,  -21,   42,  -10,  -45,   55,  -32,   34,  -43,  -14,   86,  -78,
	   8,   39,  -35,   -2,   13,    2,    5,  -11,   -4,    7,    5,  -31,   37,   -4,  -28,   28,
	  -9,  -11,   10,   -1,    4,  -18,   17,   -9,  -13,   24,  -18,   20,  -18,  -30,   59,  -25,
	 -29,   48,  -15,  -29,   23,    4,   -3,  -18,   14,    6,   -8,  -19,   19,    8,  -13,    0,
	  13,  -18,    4,    1,    0,    0,   10,  -14,  -12,   39,  -46,   23,    9,  -22,   23,  -20,
	 -22,   63,  -42,  -28,   77,  -66,   12,   38,  -56,   31,   27,  -77,   66,  -11,  -39,   59,
	 -33,  -41,   92,  -54,  -50,   96,  -36,  -46,   46,  -17,   31,  -43,  -28,   98,  -57,  -50,
	  84,  -22,  -44,   39,   -8,   17,  -28,  -13,   63,  -67,   16,   10,    3,  -15,   -4,   36,
	 -34,   -1,   26,  -27,   -2,   13,    7,  -22,    0,   27,  -11,  -19,    6,   26,  -42,   14,
	  18,   -7,  -14,  -10,   37,  -14,  -24,   25,   -4,   -5,  -10,    3,   35,  -39,   -7,   31,
	  -8,  -23,   15,    4,   -1,  -25,   28,    7,  -35,   34,  -16,   -1,    9,  -35,   45,  -22,
	 -17,   48,  -52,   24,   22,  -65,   48,    7,  -45,   47,  -19,  -33,   71,  -70,   46,   -7,
	 -52,   68,  -25,  -35,   48,  -13,  -17,   14,    2,  -12,    8,  -10,    1,   22,  -32,    4,
	  34,  -26,  -18,   29,   -7,  -19,   15,   -7,   15,   -8,  -29,   50,  -22,  -35,   53,  -19,
	 -37,   47,   -9,  -40,   41,    1,  -27,    7,    3,    0,    0,   -7,   13,   -7,  -21,   26,
	  14,  -44,   11,   40,  -51,   10,   26,  -28,   16,  -13,   -3,   31,  -42,   11,   34,  -52,
	  11,   34,  -43,   10,   29,  -19,  -21,   27,  -10,   -5,   10,  -14,   11,    3,  -35,   43,
	   3,  -52,   37,   22,  -66,   49,  -12,  -19,   50,  -58,   16,   42,  -70,   50,   -2,  -42,
	  60,  -69,   43,   11,  -57,   54,   -8,  -31,   23,   -8,   -7,   24,  -32,   11,   21,  -51,
	  60,  -44,   -6,   68,  -87,   33,   45,  -79,   50,   -7,  -13,   21,  -40,   31,   12,  -41,
	  18,   24,  -39,   15,    7,  -17,   25,  -20,  -12,   43,  -47,   17,    6,  -16,   10,    4,
	 -11,   -1,   14,  -10,   -7,    6,    9,  -23,    9,    3,   13,  -30,   16,   16,  -33,   17,
	   4,  -17,   23,  -29,    3,   54,  -86,   50,   11,  -41,   30,  -23,   15,   18,  -60,   56,
	   7,  -65,   49,   -4,  -12,    1,   -6,   19,   -4,  -33,   35,  -10,  -12,   13,   -2,   -2,
	  -2,    2,  -10,   16,   -8,  -11,   19,   -6,  -19,   24,  -14,    9,    3,  -24,   24,   -6,
	 -13,   19,  -11,   -6,    6,   -9,   16,   -8,  -10,   14,  -10,   -1,   -5,   16,   -8,  -25,
	  37,  -11,  -27,   37,  -14,  -13,   19,  -17,   14,   -5,  -15,   26,  -27,   10,   11,  -23,
	  22,   -5,  -19,   25,   -7,  -28,   44,  -35,    0,   25,  -31,   31,  -10,  -26,   46,  -41,
	   2,   33,  -40,   24,    8,  -43,   44,  -12,  -25,   37,  -25,   -6,   29,  -27,    5,   24,
	 -40,   24,   -1,  -25,   23,   -1,   -6,   -2,   -1,   14,  -24,    8,   13,  -11,    0,  -13,
	  16,   15,  -56,   43,   12,  -35,   14,   -9,   18,  -10,  -19,   28,   -3,  -27,   23,   -2,
	 -14,   27,  -35,   10,   35,  -68,   44,    7,  -43,   46,  -21,  -25,   56,  -35,  -21,   51,
	 -33,   -8,   28,  -27,   19,   -2,  -26,   36,  -26,    3,   13,  -12,    6,  -10,    8,  -14,
	  15,  -12,    0,   13,   -9,  -16,   32,  -27,    3,   23,  -49,   49,  -17,  -31,   63,  -64,
	  25,   36,  -76,   61,  -11,  -47,   75,  -54,   -9,   69,  -81,   32,   29,  -63,   46,   -7,
	 -26,   39,  -31,    6,   18,  -26,   13,   -5,    5,   -5,   -2,    5,  -12,   17,  -17,   -2,
	  22,  -25,    1,   20,  -19,    3,    6,   -6,    3,   -9,   10,   -6,   -3,    7,   -7,   -3,
	  12,   -5,   -5,  -11,   24,   -7,  -23,   24,    0,  -14,    0,   12,  -10,   -2,    5,    0,
	   1,  -10,   10,   -2,  -17,   26,  -11,  -16,   28,  -22,    6,    4,  -17,   30,  -27,   -7,
	  46,  -54,   15,   29,  -42,   25,   -4,  -15,   26,  -29,   11,   15,  -28,   19,   -7,    1,
	   8,  -20,   14,    1,  -15,   11,   -2,   -2,    0,  -10,   15,   -5,  -12,   15,   -1,  -15,
	  12,    4,  -15,    9,   -1,   -9,    9,   -5,   -6,   13,  -12,    1,    6,   -6,   -3,    6,
	  -4,    0,   -6,   11,   -9,   -2,   13,  -12,   -2,   -1,    8,  -11,    4,    2,   -6,    4,
	  -4,    4,    0,  -13,   15,    0,  -21,   23,   -5,  -15,   15,   -2,   -9,    6,   -2,   -4,
	   2,    3,   -1,   -7,    7,   -2,   -9,    6,    2,   -9,    4,    5,  -12,   10,   -9,    4,
	   5,  -16,   12,   -2,  -13,   20,  -13,   -4,   17,  -23,   14,    2,  -20,   22,  -13,   -3,
	  15,  -22,   12,    4,  -18,   17,   -7,   -7,   13,  -14,    6,    4,  -10,    9,   -5,   -6,
	   7,    0,   -7,    8,   -4,   -1,    0,   -6,    4,    7,  -14,    2,   13,  -16,    3,   10,
	 -15,    7,   -1,  -10,   14,  -10,   -2,   11,   -9,   -4,    7,   -6,    3,   -3,   -5,    9,
	  -6,   -3,    5,    1,   -7,    3,   -2,    0,   -2,    0,    4,   -3,   -2,    4,   -6,    4,
	  -2,   -2,    0,    1,    0,   -7,    7,   -2,   -7,    9,   -7,   -4,   11,  -15,   11,   -2,
	  -9,    9,   -4,   -3,    2,    3,   -7,    5,    0,   -5,    6,   -7,    1,    7,  -10,   -2,
	  13,   -9,   -4,    8,   -4,   -2,   -1,    1,    1,   -7,    4,    5,   -8,    0,    6,   -6,
	   0,    3,   -4,    0,    1,   -2,    2,   -4,   -4,    8,   -7,   -1,    6,   -9,    8,   -3,
	  -6,   12,  -12,    1,   10,  -11,    1,    5,   -6,    3,   -2,   -3,    7,  -10,    2,    7,
	 -12,    5,    2,   -5,    3,   -5,    0,    6,  -10,    3,    4,   -8,    2,    2,   -3,    3,
	  -8,    8,    2,  -14,   10,    3,  -12,    8,    2,  -11,    8,   -2,   -6,    9,   -7,   -4,
	  10,   -9,   -1,    7,   -7,    1,    3,   -8,    8,   -2,   -8,   10,   -3,   -5,    5,   -6,
	   3,    1,   -8,   10,   -5,   -5,    7,   -4,   -2,    2,   -3,    1,   -1,   -3,    4,   -3,
	   0,    0,    0,    0,   -4,    3,   -2,   -3,    3,   -5,    3,    0,   -7,    5,    1,   -8,
	   5,    1,   -6,    6,   -5,    0,    3,   -7,    3,    2,   -6,    3,    2,   -6,    3,    1,
	  -3,   -2,    5,   -4,   -1,    3,   -4,    0,    0,   -3,    5,   -5,   -3,    7,   -5,   -3,
	   6,   -4,    0,   -1,   -3,    3,   -2,   -1,    2,   -1,   -2,    1,   -2,    1,   -1,   -7,
	   8,   -1,    5,   -7,   13,  -22,    8,   -7,    8, -110,  -28,   24,   54,   36,    2,   60,
	 -45,   57,   42,  -43,   20,   41,  -66,   24,  -11,   18,  -18,  -38,  -63,  -36,   30,  -11,
	  33,   25,   30,   18,   11,  -18,   -5,    5,  -46,   40,    1,  -13,  -18,  -20,  -31,   20,
	  10,   29,   -7,  -18,   40,  -29,  -17,   42,  -19,    6,   -4,    6,   -8,   10,  -26,   -5,
	   3,    1,  -17,    6,    0,   19,   -1,    8,    0,   -6,  -10,   -1,  -12,   -1,    1,   -3,
	   8,   -7,    4,   11,    4,   14,  -13,   16,  -19,   -4,  -13,  -13,  -14,    6,    4,   -1,
	   4,   11,   -1,   11,   -1,    1,   -4,   -1,  -15,    6,   -9,    1,   -1,    0,    3,    1,
	  -8,    3,   -1,   -1,    2,   -2,    2,   -2,    1,   -5,   -7,    3,   -3,    6,   -3,    4,
	  -1,    0,   -4,    2,   -7,    3,   -6,   -1,   -1,    4,    0,    3,   -2,    2,   -5,    5,
	  -8,   -3,   -3,    2,   -5,    7,   -1,    4,   -2,    4,  -10,    6,   -6,   -1,   -4,    5,
	 -13,    7,   -6,    5,   -8,   17,  -20,   14,   -6,    9,  -40,   71, -127,    9,  -73,  127,
	  76,  -28,   74,  -32,    8,  -62,  -49,  -38,   40,  -68,   22,  -12,   68,   10,   39,  -10,
	   0,   35,  -23,    0,  -59,  -15,   -7,   -3,  -23,    1,  -20,   37,   27,    2,   30,   -2,
	  17,    2,   -5,   -7,  -27,  -29,   16,   -3,  -11,    1,  -16,   -5,   -8,  -10,    7,   32,
	   9,    5,   -4,   16,    5,   -8,  -17,  -16,    5,  -13,    8,   11,   15,  -10,   -9,    0,
	  -1,    2,    7,   -3,  -23,    9,    2,    3,    1,  -13,   -1,   -6,   11,   -6,    8,    1,
	  12,  -12,    9,  -14,    8,   -1,    0,   -3,  -13,    4,   -7,   -4,    8,    5,   -5,   -7,
	   4,   -2,   -3,    2,    3,   -6,    8,   -3,    1,   -3,   -2,    2,   -6,    2,   -4,   -3,
	  -4,    3,    1,    0,    0,    1,   -1,   -1,    2,   -2,    0,   -4,   -2,    1,    2,    0,
	  -3,    1,   -3,    0,   -1,   -3,   -6,    2,   -2,    3,   -4,   10,   -8,    9,   -5,   12,
	 -19,   46,   37, -128,   60,  -90,  102,  -65,   40,  -57,   39,   -6,   23,   -8,   19,   24,
	  15,  -17,  -47,  -27,  -36,  -16,   21,    3,   23,   14,   50,   -8,   19,   25,    7,   -9,
	 -28,  -63,  -37,    0,  -42,   54,  -17,   68,   -3,   30,  -12,   -4,   11,  -15,    9,  -25,
	 -15,   -2,  -27,  -25,   38,   -8,  -13,   33,   24,   12,  -38,   39,  -12,   -3,  -17,  -44,
	  38,    2,   27,    3,   -5,   -4,  -13,  -30,  -56,   -4,   11,    1,    9,   17,   46,   25,
	 -14,    6,   -3,   -7,  -21,    2,   16,   -5,  -22,    2,   -2,    6,  -12,  -25,  -15,   10,
	   9,    8,   11,   43,    8,   -5,  -22,  -16,   14,  -31,   16,    7,   -7,  -26,  -20,   -2,
	   9,   11,   26,    7,    6,  -20,  -13,    0,    4,   17,  -17,  -18,   10,    2,  -10,   27,
	  -8,   24,  -23,  -14,    1,    0,   13,  -19,   14,   10,  -16,   16,   -4,  -20,   20,  -33,
	   2,    2,   24,   21,   -3,  -26,  -24,  -18,  -18,   10,   10,   24,   18,    2,    9,  -24,
	  16,  -14,   -8,    9,   -5,  -14,    8,   -5,   30,  -11,   11,  -13,  -15,  -12,    7,    4,
	 -13,  -13,   13,  -13,   12,   23,    9,    0,   14,  -10,   -9,  -35,   -2,  -21,   12,   -1,
	  17,   19,   11,   -4,    0,  -18,  -24,   11,  -10,    1,   11,   12,  -13,  -16,   10,  -23,
	  21,    9,   -9,    3,   12,   -6,    3,   -5,   12,    0,   -2,    0,  -19,   -9,    5,  -11,
	  -7,   10,    1,   -3,    9,   18,   -6,    0,   -1,    1,  -13,    2,    1,   -3,   -8,   17,
	  -4,   -9,   18,  -15,    8,   -1,  -11,   -5,  -14,   11,   -5,   -7,   12,   16,   -7,    7,
	  -3,  -11,   -5,   -6,    1,    4,   -3,   -3,   15,    5,    0,    3,    6,  -16,    4,  -14,
	  -6,   -9,   -4,    2,   11,   11,    7,   -2,    4,  -12,   -7,  -14,   -6,   -7,    9,    4,
	   7,   -2,    6,    5,    6,   -4,   -3,   -4,    7,   -7,  -11,   -9,    0,   -3,    7,   -2,
	  -2,    3,   13,   -4,   -6,  -15,    9,   -7,   -1,    4,    6,    5,    8,   -6,   -8,    0,
	 -11,   -4,    6,   -8,    4,    3,    5,   13,   -4,   -9,   -3,    4,   -3,   -3,    4,   -1,
	 -12,    6,  -14,    2,    3,   15,    2,    6,   -7,   -8,    3,    1,   -2,    3,   -3,  -12,
	  -6,  -14,    7,   -2,   13,    6,   10,    6,    0,   -2,  -10,  -12,   -8,   -6,   -7,   -6,
	   6,    4,   -2,    5,    2,    0,   -1,    3,  -11,    4,    0,   20,   -8,   -2,    0,   -1,
	  -3,    7,   -3,   -4,   -2,   -6,  -10,  -10,   -8,    1,    2,    5,    8,    2,    5,    8,
	   3,    4,    3,   -2,  -15,    0,   -1,   -7,   -2,   -5,  -10,   10,   -1,    5,    3,    5,
	  -1,   -2,   -8,   -5,   -9,    1,   -8,    6,    5,    4,    1,    1,    2,    3,   -2,    4,
	  -7,    1,   -7,   -9,   -2,    0,    2,    3,    6,   -8,    8,    3,    0,   -2,   -9,   -3,
	  -2,    0,    3,   -1,   -2,   -3,    7,   -3,   10,   -8,    1,  -12,    3,   -7,    2,   -3,
	   7,    4,    4,    0,    0,   -6,   -1,   -5,   -3,   -4,   -7,    0,    5,    7,    0,    2,
	  -3,   10,   -1,    3,   -7,   -5,   -4,   -9,   -3,   -7,    5,   -4,    9,    2,    1,    4,
	   5,    0,   -5,    1,   -8,    4,   -9,    5,   -5,    0,    3,   -2,   -1,    1,    1,   -7,
	   7,    0,    3,   -5,    0,   -3,   -1,   -1,   -5,   -1,    1,   -1,    1,   -1,    0,    2,
	   0,    2,   -7,   -7,    4,   -1,    0,    3,    4,   -1,   -3,   -4,   -6,    3,   -2,    4,
	  -1,    5,   -2,   -1,   -5,   -2,   -4,    1,    3,    2,    2,    0,   -3,    1,    1,   -3,
	  -3,   -1,    1,   -3,   -2,   -1,   -2,   -3,   -1,    0,    4,    3,    5,    2,    1,   -4,
	  -9,   -3,   -7,    1,   -2,    7,   -2,    3,    3,    3,    1,    0,   -1,   -6,   -7,   -6,
	  -4,   -1,    1,    0,    5,    2,   -2,    2,   -3,   -1,    3,   -1,    1,   -4,   -4,   -5,
	   0,   -7,    2,   -4,    3,    4,    1,    2,   -1,   -1,   -2,   -2,    0,   -1,    1,   -1,
	  -1,   -3,    1,    1,    3,   -3,   -1,    1,    1,   -2,   -3,   -8,   -5,    0,   -1,    5,
	   2,    3,    1,   -2,   -1,   -1,   -3,    1,    1,   -2,   -3,   -3,   -1,    0,   -1,    1,
	   2,    2,    5,    0,   -1,   -2,   -1,   -2,    0,   -4,    0,   -5,   -1,   -1,    0,    1,
	   5,    4,   -2,   -1,   -2,    0,   -6,   -1,    0,    1,   -1,   -2,    1,    0,    0,    3,
	   1,   -2,    1,   -2,   -4,   -1,    0,   -1,   -1,   -4,   -2,   -4,    2,   -1,    1,    0,
	   3,    2,    0,    4,   -1,    4,   -6,    2,   -4,   -3,   -5,   -4,   -3,    0,    2,    0,
	   1,    4,    2,    2,   -2,   -2,   -5,   -6,   -5,   -3,   -2,    1,   -1,    0,    0,    2,
	   2,    2,    0,    4,   -2,    3,    2,   -1,   -2,   -3,   -3,   -3,   -5,   -5,   -5,   -1,
	  -1,    0,    2,    2,    4,    1,    2,    1,    2,   -1,   -1,   -3,   -4,   -5,   -3,   -2,
	  -2,   -1,    1,    4,    2,    2,    2,    1,   -1,   -2,   -6,   -2,   -3,    2,   -1,    1,
	  -2,    0,    2,    1,    2,   -2,    1,    0,   -2,   -2,   -3,    0,   -2,   -1,   -1,    0,
	  -2,   -2,    1,    0,    2,   -1,    1,   -1,    0,   -1,   -1,   -7,    8,   -1,    5,   -7,
	  13,  -22,    8,   -7,    8, -110,  -28,   24,   54,   36,    2,   60,  -45,   57,   42,  -43,
	  20,   41,  -66,   24,  -11,   18,  -18,  -38,  -63,  -36,   30,  -11,   33,   25,   30,   18,
	  11,  -18,   -5,    5,  -46,   40,    1,  -13,  -18,  -20,  -31,   20,   10,   29,   -7,  -18,
	  40,  -29,  -17,   42,  -19,    6,   -4,    6,   -8,   10,  -26,   -5,    3,    1,  -17,    6,
	   0,   19,   -1,    8,    0,   -6,  -10,   -1,  -12,   -1,    1,   -3,    8,   -7,    4,   11,
	   4,   14,  -13,   16,  -19,   -4,  -13,  -13,  -14,    6,    4,   -1,    4,   11,   -1,   11,
	  -1,    1,   -4,   -1,  -15,    6,   -9,    1,   -1,    0,    3,    1,   -8,    3,   -1,   -1,
	   2,   -2,    2,   -2,    1,   -5,   -7,    3,   -3,    6,   -3,    4,   -1,    0,   -4,    2,
	  -7,    3,   -6,   -1,   -1,    4,    0,    3,   -2,    2,   -5,    5,   -8,   -3,   -3,    2,
	  -5,    7,   -1,    4,   -2,    4,  -10,    6,   -6,   -1,   -4,    5,  -13,    7,   -6,    5,
	  -8,   17,  -20,   14,   -6,    9,  -40,   71, -127,    9,  -73,  127,   76,  -28,   74,  -32,
	   8,  -62,  -49,  -38,   40,  -68,   22,  -12,   68,   10,   39,  -10,    0,   35,  -23,    0,
	 -59,  -15,   -7,   -3,  -23,    1,  -20,   37,   27,    2,   30,   -2,   17,    2,   -5,   -7,
	 -27,  -29,   16,   -3,  -11,    1,  -16,   -5,   -8,  -10,    7,   32,    9,    5,   -4,   16,
	   5,   -8,  -17,  -16,    5,  -13,    8,   11,   15,  -10,   -9,    0,   -1,    2,    7,   -3,
	 -23,    9,    2,    3,    1,  -13,   -1,   -6,   11,   -6,    8,    1,   12,  -12,    9,  -14,
	   8,   -1,    0,   -3,  -13,    4,   -7,   -4,    8,    5,   -5,   -7,    4,   -2,   -3,    2,
	   3,   -6,    8,   -3,    1,   -3,   -2,    2,   -6,    2,   -4,   -3,   -4,    3,    1,    0,
	   0,    1,   -1,   -1,    2,   -2,    0,   -4,   -2,    1,    2,    0,   -3,    1,   -3,    0,
	  -1,   -3,   -6,    2,   -2,    3,   -4,   10,   -8,    9,   -5,   12,  -19,   46,   37, -128,
	  60,  -90,  102,  -65,   40,  -57,   39,   -6,   23,   -8,   19,   24,   15,  -17,  -47,  -27,
	 -36,  -16,   21,    3,   23,   14,   50,   -8,   19,   25,    7,   -9,  -28,  -63,  -37,    0,
	 -42,   54,  -17,   68,   -3,   30,  -12,   -4,   11,  -15,    9,  -25,  -15,   -2,  -27,  -25,
	  38,   -8,  -13,   33,   24,   12,  -38,   39,  -12,   -3,  -17,  -44,   38,    2,   27,    3,
	  -5,   -4,  -13,  -30,  -56,   -4,   11,    1,    9,   17,   46,   25,  -14,    6,   -3,   -7,
	 -21,    2,   16,   -5,  -22,    2,   -2,    6,  -12,  -25,  -15,   10,    9,    8,   11,   43,
	   8,   -5,  -22,  -16,   14,  -31,   16,    7,   -7,  -26,  -20,   -2,    9,   11,   26,    7,
	   6,  -20,  -13,    0,    4,   17,  -17,  -18,   10,    2,  -10,   27,   -8,   24,  -23,  -14,
	   1,    0,   13,  -19,   14,   10,  -16,   16,   -4,  -20,   20,  -33,    2,    2,   24,   21,
	  -3,  -26,  -24,  -18,  -18,   10,   10,   24,   18,    2,    9,  -24,   16,  -14,   -8,    9,
	  -5,  -14,    8,   -5,   30,  -11,   11,  -13,  -15,  -12,    7,    4,  -13,  -13,   13,  -13,
	  12,   23,    9,    0,   14,  -10,   -9,  -35,   -2,  -21,   12,   -1,   17,   19,   11,   -4,
	   0,  -18,  -24,   11,  -10,    1,   11,   12,  -13,  -16,   10,  -23,   21,    9,   -9,    3,
	  12,   -6,    3,   -5,   12,    0,   -2,    0,  -19,   -9,    5,  -11,   -7,   10,    1,   -3,
	   9,   18,   -6,    0,   -1,    1,  -13,    2,    1,   -3,   -8,   17,   -4,   -9,   18,  -15,
	   8,   -1,  -11,   -5,  -14,   11,   -5,   -7,   12,   16,   -7,    7,   -3,  -11,   -5,   -6,
	   1,    4,   -3,   -3,   15,    5,    0,    3,    6,  -16,    4,  -14,   -6,   -9,   -4,    2,
	  11,   11,    7,   -2,    4,  -12,   -7,  -14,   -6,   -7,    9,    4,    7,   -2,    6,    5,
	   6,   -4,   -3,   -4,    7,   -7,  -11,   -9,    0,   -3,    7,   -2,   -2,    3,   13,   -4,
	  -6,  -15,    9,   -7,   -1,    4,    6,    5,    8,   -6,   -8,    0,  -11,   -4,    6,   -8,
	   4,    3,    5,   13,   -4,   -9,   -3,    4,   -3,   -3,    4,   -1,  -12,    6,  -14,    2,
	   3,   15,    2,    6,   -7,   -8,    3,    1,   -2,    3,   -3,  -12,   -6,  -14,    7,   -2,
	  13,    6,   10,    6,    0,   -2,  -10,  -12,   -8,   -6,   -7,   -6,    6,    4,   -2,    5,
	   2,    0,   -1,    3,  -11,    4,    0,   20,   -8,   -2,    0,   -1,   -3,    7,   -3,   -4,
	  -2,   -6,  -10,  -10,   -8,    1,    2,    5,    8,    2,    5,    8,    3,    4,    3,   -2,
	 -15,    0,   -1,   -7,   -2,   -5,  -10,   10,   -1,    5,    3,    5,   -1,   -2,   -8,   -5,
	  -9,    1,   -8,    6,    5,    4,    1,    1,    2,    3,   -2,    4,   -7,    1,   -7,   -9,
	  -2,    0,    2,    3,    6,   -8,    8,    3,    0,   -2,   -9,   -3,   -2,    0,    3,   -1,
	  -2,   -3,    7,   -3,   10,   -8,    1,  -12,    3,   -7,    2,   -3,    7,    4,    4,    0,
	   0,   -6,   -1,   -5,   -3,   -4,   -7,    0,    5,    7,    0,    2,   -3,   10,   -1,    3,
	  -7,   -5,   -4,   -9,   -3,   -7,    5,   -4,    9,    2,    1,    4,    5,    0,   -5,    1,
	  -8,    4,   -9,    5,   -5,    0,    3,   -2,   -1,    1,    1,   -7,    7,    0,    3,   -5,
	   0,   -3,   -1,   -1,   -5,   -1,    1,   -1,    1,   -1,    0,    2,    0,    2,   -7,   -7,
	   4,   -1,    0,    3,    4,   -1,   -3,   -4,   -6,    3,   -2,    4,   -1,    5,   -2,   -1,
	  -5,   -2,   -4,    1,    3,    2,    2,    0,   -3,    1,    1,   -3,   -3,   -1,    1,   -3,
	  -2,   -1,   -2,   -3,   -1,    0,    4,    3,    5,    2,    1,   -4,   -9,   -3,   -7,    1,
	  -2,    7,   -2,    3,    3,    3,    1,    0,   -1,   -6,   -7,   -6,   -4,   -1,    1,    0,
	   5,    2,   -2,    2,   -3,   -1,    3,   -1,    1,   -4,   -4,   -5,    0,   -7,    2,   -4,
	   3,    4,    1,    2,   -1,   -1,   -2,   -2,    0,   -1,    1,   -1,   -1,   -3,    1,    1,
	   3,   -3,   -1,    1,    1,   -2,   -3,   -8,   -5,    0,   -1,    5,    2,    3,    1,   -2,
	  -1,   -1,   -3,    1,    1,   -2,   -3,   -3,   -1,    0,   -1,    1,    2,    2,    5,    0,
	  -1,   -2,   -1,   -2,    0,   -4,    0,   -5,   -1,   -1,    0,    1,    5,    4,   -2,   -1,
	  -2,    0,   -6,   -1,    0,    1,   -1,   -2,    1,    0,    0,    3,    1,   -2,    1,   -2,
	  -4,   -1,    0,   -1,   -1,   -4,   -2,   -4,    2,   -1,    1,    0,    3,    2,    0,    4,
	  -1,    4,   -6,    2,   -4,   -3,   -5,   -4,   -3,    0,    2,    0,    1,    4,    2,    2,
	  -2,   -2,   -5,   -6,   -5,   -3,   -2,    1,   -1,    0,    0,    2,    2,    2,    0,    4,
	  -2,    3,    2,   -1,   -2,   -3,   -3,   -3,   -5,   -5,   -5,   -1,   -1,    0,    2,    2,
	   4,    1,    2,    1,    2,   -1,   -1,   -3,   -4,   -5,   -3,   -2,   -2,   -1,    1,    4,
	   2,    2,    2,    1,   -1,   -2,   -6,   -2,   -3,    2,   -1,    1,   -2,    0,    2,    1,
	   2,   -2,    1,    0,   -2,   -2,   -3,    0,   -2,   -1,   -1,    0,   -2,   -2,    1,    0,
	   2,   -1,    1,   -1,    0,   -1,   -1,    1,   -7,    5,  -22,  -32,  -35,  -32,  -43,  -35,
	 -55,  -42,  -66,  -48,  -80,  -57,  -17, -128,  -59,  -76,    0,  -26,    1,  -33,   21,    3,
	  16,   15,   26,   43,   28,   66,    6,   97,   40,  103,   67,  101,  102,   98,   94,   21,
	  98,   90,   57,   78,   89,   81,   61,   -6,   54,    4,   62,   19,   27,   34,   12,   16,
	  14,  -17,   19,   -5,   -2,  -13,  -38,  -24,   -3,  -33,  -14,  -11,  -16,    0,  -13,    7,
	 -26,  -13,  -16,    6,  -57,  -23,  -28,  -13,   -9,  -34,  -32,  -20,  -87,  -62,  -28,  -38,
	 -75,  -37,  -27,  -41,  -71,  -48,  -30,  -44,  -83,  -67,  -52,  -48,  -45,  -46,  -45,  -63,
	 -47,  -40,  -32,  -45,  -24,  -32,  -43,  -21,  -17,    0,   21,   26,   43,   51,   62,   47,
	  41,   55,   57,   68,   34,   53,   63,   62,   71,   60,   61,   56,   53,   56,   54,   38,
	  50,   58,   50,   40,   28,   54,   39,   41,   38,   22,   32,   20,   -3,   19,   -1,   -7,
	  -6,  -16,  -16,  -14,  -27,  -29,  -46,  -66,  -61,  -51,  -54,  -61,  -41,  -50,  -47,  -52,
	 -55,  -45,  -44,  -28,  -58,  -56,  -31,  -37,  -36,  -32,  -18,  -16,  -34,  -29,   -9,  -21,
	 -20,  -30,  -22,  -17,  -19,   -8,  -12,  -14,   -6,  -14,   -6,  -11,   -2,    4,   -6,    9,
	   8,   17,   23,   13,   31,   13,   24,   30,   28,   29,   30,   43,   34,   37,   52,   42,
	  44,   50,   67,   59,   49,   54,   48,   43,   51,   45,   42,   62,   47,   39,   37,   36,
	  24,   28,   13,    3,    9,  -11,   -3,   -9,  -14,  -18,  -34,  -27,  -29,  -39,  -42,  -38,
	 -46,  -37,  -46,  -43,  -41,  -35,  -38,  -31,  -38,  -34,  -39,  -39,  -34,  -48,  -44,  -47,
	 -49,  -54,  -52,  -44,  -53,  -37,  -47,  -38,  -31,  -38,  -27,  -19,  -19,  -15,  -16,    0,
	   0,    2,    7,   13,   29,   22,   32,   32,   39,   47,   41,   40,   55,   48,   41,   44,
	  57,   43,   36,   47,   43,   42,   37,   32,   32,   27,   33,   36,   30,   23,   25,   25,
	  22,   18,   22,   20,   16,    8,    6,   12,    7,    0,    1,    3,   -5,  -14,   -9,   -7,
	  -8,  -19,  -15,  -16,  -23,  -21,  -21,  -32,  -31,  -29,  -26,  -27,  -29,  -33,  -26,  -29,
	 -30,  -39,  -28,  -41,  -43,  -35,  -34,  -32,  -29,  -28,  -28,  -25,  -27,  -24,  -27,  -27,
	 -27,  -22,  -23,  -17,   -9,  -10,  -14,  -10,   -8,   -4,   -2,   -1,   -3,    5,    4,   10,
	  11,    7,   13,   11,   14,   27,   22,   22,   22,   27,   36,   34,   36,   37,   45,   44,
	  47,   48,   51,   49,   52,   51,   52,   48,   50,   47,   48,   42,   40,   29,   33,   24,
	  22,   12,    5,    0,   -3,   -5,   -9,  -21,  -21,  -25,  -19,  -28,  -28,  -30,  -33,  -39,
	 -42,  -42,  -46,  -46,  -45,  -42,  -43,  -47,  -47,  -36,  -32,  -30,  -34,  -31,  -22,  -29,
	 -29,  -30,  -26,  -28,  -30,  -21,  -26,  -27,  -21,  -19,  -16,  -11,  -12,   -8,   -2,    1,
	  -4,    1,    0,    1,    9,    8,    7,   12,   10,   13,   20,   17,   18,   21,   26,   29,
	  30,   30,   29,   34,   33,   34,   33,   30,   32,   33,   28,   33,   29,   35,   32,   31,
	  30,   31,   30,   25,   27,   24,   21,   21,   20,   16,   17,   12,    6,    4,   -3,    1,
	  -6,   -7,  -11,  -13,  -11,  -10,   -8,  -13,  -12,   -9,  -17,  -14,  -19,  -24,  -22,  -24,
	 -30,  -32,  -30,  -33,  -37,  -39,  -40,  -42,  -39,  -41,  -39,  -40,  -41,  -35,  -35,  -35,
	 -37,  -36,  -33,  -30,  -25,  -25,  -19,  -16,  -16,  -10,   -6,   -7,   -4,   -2,    1,    3,
	   6,   10,    9,   15,   17,   18,   17,   13,   19,   18,   17,   19,   20,   24,   24,   27,
	  27,   29,   30,   26,   28,   28,   27,   28,   26,   25,   24,   25,   20,   19,   17,   18,
	  15,   12,   13,   10,    6,    8,    6,    3,    4,    3,    0,   -3,    0,   -1,   -2,   -5,
	  -4,   -5,   -4,   -5,   -6,   -8,   -9,   -9,  -12,  -11,  -16,  -16,  -15,  -15,  -13,  -17,
	 -16,  -17,  -17,  -21,  -20,  -25,  -24,  -24,  -24,  -26,  -30,  -30,  -27,  -30,  -26,  -26,
	 -27,  -27,  -25,  -24,  -19,  -20,  -17,  -13,  -12,   -8,   -8,   -8,   -6,   -5,   -2,   -1,
	   0,    3,    8,   10,   12,   16,   18,   24,   25,   25,   28,   30,   28,   32,   33,   31,
	  32,   31,   35,   33,   31,   31,   27,   28,   26,   23,   23,   20,   22,   18,   16,   13,
	  11,    9,    5,    4,   -2,   -2,   -3,   -8,   -9,  -11,  -12,  -13,  -15,  -15,  -15,  -15,
	 -15,  -14,  -12,  -12,  -13,  -13,   -8,  -11,  -10,  -12,  -10,  -12,  -12,   -8,   -8,   -9,
	  -9,   -9,   -8,   -9,  -10,  -11,  -11,  -10,  -13,  -14,  -13,  -16,  -16,  -17,  -17,  -18,
	 -19,  -18,  -17,  -16,  -16,  -15,  -15,  -13,  -12,  -10,  -12,  -10,   -9,   -8,   -6,   -6,
	  -3,    0,    0,    1,    2,    2,    3,    4,    4,    5,    6,    7,    8,    9,   10,   11,
	  12,   12,   13,   14,   14,   15,   15,   15,   16,   16,   16,   16,   16,   16,   16,   16,
	  16,   16,   15,   15,   14,   13,   13,   12,   11,   10,    9,    8,    7,    6,    5,    4,
	   3,    2,    1,    0,   -1,   -1,   -2,   -3,   -4,   -5,   -5,   -6,   -7,   -7,   -8,   -9,
	  -9,  -10,  -11,  -11,  -12,  -12,  -13,  -13,  -13,  -13,  -14,  -14,  -14,  -15,  -15,  -15,
	 -15,  -15,  -15,  -16,  -16,  -16,  -15,  -15,  -15,  -14,  -13,  -13,  -12,  -11,  -10,   -9,
	  -8,   -7,   -6,   -5,   -4,   -2,   -1,    0,    1,    2,    4,    5,    6,    7,    8,    9,
	  10,   11,   12,   12,   13,   13,   14,   14,   15,   15,   15,   15,   16,   16,   16,   16,
	  17,   17,   17,   17,   17,   17,   16,   16,   15,   15,   14,   14,   13,   12,   11,   10,
	   9,    7,    6,    5,    3,    1,    0,   -2,   -4,   -5,   -7,   -9,  -10,  -11,  -13,  -14,
	 -15,  -15,  -16,  -17,  -17,  -18,  -18,  -18,  -18,  -18,  -18,  -18,  -18,  -18,  -18,  -18,
	 -18,  -17,  -17,  -16,  -16,  -15,  -14,  -14,  -13,  -12,  -11,  -10,   -9,   -8,   -7,   -6,
	  -4,   -3,   -2,   -1,    0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    9,   10,
	  11,   11,   12,   13,   13,   13,   14,   14,   14,   15,   15,   15,   15,   15,   15,   15,
	  15,   15,   15,   15,   14,   14,   14,   13,   12,   12,   11,   10,    9,    8,    8,    7,
	   6,    5,    4,    3,    2,    1,    0,    0,   -1,   10,  -20,   30,   25,   21,   14,    4,
	  15,  -48,  -33,   11,  -70,   54,   -5,  -21,   -8,   -3,   73,  -52,   65,  -55,   80,  -28,
	 -67,   -3,  -13,   21,  -49,   -2,   11,   36,   59,  -60,   34,  -28,   21,  -25,  -45,   54,
	   5,    0,  -19,  -12,   20,   54,  -51,  -23,   22,   36,  -59,  -20,    8,   28,   -9,  -54,
	 127,  -44,   69, -128,    5,   69,   -8,  -98,   45,   69,   20,  -97,   23,   -7,  121,  -81,
	  -2,  -21,   51,  -67,  -14,  -24,  127,  -60,   45, -116,  127,  -29,  -93,  -23,  107,   -5,
	 -21,  -62,   37,   41,   29,  -74,  -63,  103,   24,  -59,  -44,   62,   43,  -28,  -46,    7,
	  72,   19,  -70,  -47,   42,   53,  -68,  -13,   37,   59,  -38,  -60,   39,   66,   27, -128,
	  36,   77,   15,  -74,  -15,   75,   38,  -49,  -11,  -39,   16,   -8,  -30,   35,   41,   -1,
	  -2,   17,  -68,   99,  -97,   60,  -49,   32,  -44,  -29,   82,  -26,   39,  -35,   10,   38,
	 -20,  -21,  -92,   83,  -24,   13,   31,  -33,   22,   45,  -31,  -24,    9,  -24,  -32,   42,
	 -17,   34,    7,  -27,    6,   61,   -9,  -34,   -5,   -8,  -17,   -6,  -34,   17,   43,   -9,
	  35,  -34,   16,   27,  -24,  -17,  -17,    5,  -17,   42,  -31,   22,   17,  -26,  -22,   32,
	  41,  -27,  -25,  -10,   -5,   16,   -2,   13,   -1,   48,  -33,  -27,    6,   16,   13,  -37,
	 -11,   18,   25,  -42,  -11,   46,   -7,  -15,    9,   15,    4,   -3,  -36,  -24,   31,   -8,
	  14,   12,   27,  -19,  -17,  -14,   -7,   42,   -5,  -15,    5,    1,  -15,   14,   43,  -19,
	   1,  -25,  -35,   16,   16,   29,  -12,    8,  -14,    1,   21,   -8,  -12,  -22,   -4,   24,
	  26,  -16,  -22,   37,    3,  -41,    7,    4,    3,   30,    4,  -27,   11,   -6,  -26,   33,
	  23,  -23,  -14,  -20,   -7,   -4,   36,    0,   18,   10,  -27,    1,    1,   16,   -1,   -4,
	 -44,   -5,   17,    9,   13,   -4,   -3,   31,   24,  -14,  -26,    9,  -27,  -28,   19,   22,
	  32,  -11,  -15,    5,   15,  -23,  -21,   16,   14,   18,  -11,  -26,   13,   10,  -12,  -12,
	  11,   14,   -6,  -13,   -3,    6,   -6,    3,   12,   32,   14,  -22,  -45,  -10,   37,   11,
	 -50,  -11,   50,   22,  -13,   -4,   -4,   15,  -16,  -33,    7,   34,   -9,  -14,   -1,   21,
	  15,  -14,  -12,   -6,    7,    8,    2,    0,   -5,    6,   15,    4,   -9,   13,    3,  -51,
	 -18,   27,   10,    5,  -11,    6,   -1,    5,   22,    2,  -14,  -39,  -12,   19,   17,    4,
	  11,    5,  -25,    2,   23,    8,    2,   -3,  -39,  -22,    4,   18,    6,   14,   25,   20,
	 -17,  -20,   17,    7,  -43,  -38,  -18,   17,   24,   -6,   30,   44,    6,  -36,  -20,    7,
	  24,    1,  -69,  -25,   47,   15,   -4,   35,   19,  -18,  -22,  -12,   20,   39,  -36,  -49,
	   9,   28,  -16,    9,   34,   36,  -22,  -69,  -16,   39,    7,  -28,   -3,   33,  -18,   -7,
	  18,   53,   24,  -37,  -61,  -10,   38,    2,  -24,  -11,   12,   17,    0,   28,   50,   -5,
	 -59,  -57,   22,   14,  -15,   -5,   22,    9,  -20,   19,   33,   31,  -33,  -62,  -13,   -2,
	  45,   -9,   -4,   -3,   19,    8,   -8,   40,    8,  -16,  -44,  -19,   16,    3,   23,  -32,
	  22,    5,   -9,    5,   26,   21,  -27,  -18,  -45,    3,   15,    0,    7,    7,    7,   13,
	  18,  -10,    3,   -5,  -30,  -30,   -3,    9,   31,   17,  -10,   19,   28,  -33,  -20,   31,
	  14,  -67,  -27,   13,   20,   29,    1,   -2,   24,   -3,  -26,  -12,   32,   -7,  -31,  -17,
	   5,   22,   11,   -6,    6,    7,    2,    7,    5,  -12,  -22,  -17,  -24,   22,   47,    1,
	   2,   10,    5,  -29,   -5,   13,    1,  -30,  -28,   -5,   23,   25,    6,    5,    1,    7,
	   0,    5,    3,  -33,  -37,   -6,   19,   20,   26,   -1,  -15,   21,    9,  -14,  -13,    0,
	 -11,  -24,   -9,    9,   23,    1,    1,   32,   11,  -25,  -18,    5,   -5,   -6,   -9,  -10,
	   2,   18,    4,   12,    6,   -2,   -8,    2,    2,   -7,    2,  -22,   -5,   17,   25,   15,
	  -5,   -1,  -24,   -8,  -10,   -5,   12,    7,   -4,  -10,    4,    8,   22,   11,   -1,  -12,
	 -31,  -17,    6,   12,   11,    5,   -3,   -1,   22,    0,   -4,    3,  -18,  -17,   -3,   16,
	   9,    2,   -5,    0,    4,   -9,   18,   17,  -22,  -19,   -8,   -6,   21,   11,   -6,  -16,
	  33,   13,  -15,   -3,  -15,    1,   -3,  -10,   -7,    8,   17,  -11,    9,   19,    0,    5,
	   0,  -18,  -13,    2,  -20,   10,   29,  -11,  -13,    5,   11,   16,    4,  -25,  -21,   13,
	  -5,    1,    3,   -1,    6,   13,   -7,   -1,   17,   -6,   -6,   -9,   -6,   -3,   -1,    1,
	  18,   11,  -22,    2,   18,   -2,  -15,    1,    5,  -12,  -10,   -7,    9,   26,   10,  -11,
	   5,    0,   -7,   -3,  -11,   -9,   -3,    2,  -10,   19,   28,   -3,   -3,   -4,    9,  -14,
	  -5,   -7,    8,   -3,  -27,    5,   37,   11,   -2,    3,  -27,  -15,   12,   -2,   14,    2,
	  -8,  -16,   22,   11,   -1,   10,  -17,   -8,   -5,  -23,    2,   29,    8,  -21,    8,   12,
	   6,    8,  -17,    3,   -2,  -12,  -27,   16,   25,   -5,   -7,    2,   19,    1,  -15,    7,
	   2,   -5,  -34,    2,   18,   17,  -10,    2,   18,   -1,  -12,  -10,    5,    1,  -16,   -9,
	  12,   21,    4,  -10,    2,   12,    1,  -19,  -11,   20,    5,  -14,  -21,    5,   17,   -5,
	   3,   17,    4,  -25,   -5,    5,    4,    0,   -5,    2,    2,   -1,    1,   13,    0,  -11,
	  -8,    3,    2,   -1,   -3,   -3,   11,    8,   -6,    2,    7,    4,   -5,  -23,   -2,   14,
	  -1,  -15,   -2,   15,   10,    1,   -4,   16,    1,  -24,  -12,    8,    8,  -20,   -2,   14,
	  13,   10,    2,    2,   -9,   -6,   -9,   -3,    5,    7,   -3,   -9,    0,    2,    8,    3,
	  -1,    2,   -4,    0,   -2,    0,   -2,    3,    5,   -4,  -28,   22,  -43,   36,  -13, -127,
	 -43,    2,  -18,  126,   78, -127,  -48,   68,  -74,  -67,   33,   62,   83,   42,  -32,  -46,
	 -70,  -26,  115,   21,  -66,   72,   52,  -27,   44,   50,   50,   61,   28,  -12,    3,  -59,
	  49,    3,  -19,   39,   94,   16,   31,    6,   29,    3, -100,   -1,   -4,  -60,   19,    7,
	 -29,  -28,  -38,   -3,  -47,  -20,  -21,   -1,    5,  -55,  -12,  -55,  -39,   26,   47,  -22,
	  -9,  -41,  -21,  -19,  -37,    0,   45,  -56,   24,   75,  -50,   -9,   31,   28,   26,   13,
	  -3,  -15,  -27,    1,    1,  -31,  -10,   38,   -1,    7,   43,   19,   21,   41,   33,    9,
	 -17,   -3,  -42,  -76,  -30,   -8,   -9,   -1,   21,   22,   38,   32,   22,    0,  -18,  -32,
	 -58,  -12,    5,  -48,  -13,   64,   29,   -2,    2,   19,   43,   25,  -19,  -39,  -69,  -92,
	 -15,   23,   30,   30,   51,   37,   35,   37,   30,  -27,  -63,    5,  -30,  -56,  -16,   26,
	  52,   20,   14,   59,   27,   -9,   22,   -4,  -20,  -37,  -17,  -34,  -34,   -1,   35,   26,
	  31,    5,  -16,    4,   33,   22,    8,    5,  -28,  -41,  -20,  -10,   -6,   -2,  -16,   12,
	  31,  -23,    7,   -2,  -39,  -28,  -13,    8,    5,   16,   -4,   -6,  -18,  -24,  -27,  -50,
	  -6,    5,   12,    0,   -2,  -14,  -23,    5,  -28,  -10,    2,   28,   15,    2,   22,   27,
	  41,   31,    2,   12,   31,    5,   12,   -6,   15,   40,   34,   18,   26,   26,   12,   34,
	  23,   34,   30,   22,   10,  -26,  -22,    1,    0,   -1,   12,   -4,  -21,   -5,   -5,  -20,
	 -31,  -25,  -24,  -42,  -44,  -41,  -41,  -37,  -29,  -28,  -29,  -40,  -17,  -21,  -38,  -42,
	 -38,  -40,  -36,  -13,  -14,   -8,  -15,   -7,   -6,    5,   12,   -1,  -17,   -1,    9,    2,
	  16,   30,   27,   37,   36,   38,   36,   36,   19,   45,   45,   33,   26,   33,   28,   36,
	  31,   17,   12,   22,   11,   11,   17,    5,  -13,    6,   10,    2,   -6,    2,    9,   15,
	  -6,   -8,  -23,  -44,   -3,  -11,  -35,  -25,  -35,  -23,  -21,    0,  -11,  -21,  -17,   11,
	  -6,  -11,  -17,  -33,  -16,  -16,   -4,   -7,   -7,   -9,   -4,    1,    1,   -3,    6,    7,
	   4,  -17,  -11,   -6,   -4,    1,    3,    6,    4,    5,   -4,   17,    7,    3,    9,  -20,
	   0,   -7,   -3,   -5,    4,    9,   16,    2,    3,    8,   15,   15,    1,   -3,    8,   -1,
	   5,   14,    7,    4,    8,   -8,    2,   -3,    5,   11,    5,    3,   -4,   10,   17,   13,
	 -11,   -5,    1,   -3,    0,   -6,  -12,    2,   -3,   13,   -5,  -25,  -15,   -7,    4,    1,
	  -8,   -4,  -12,  -16,    3,    9,   -6,    3,  -21,   -4,    4,  -14,    1,   -1,   -2,    3,
	  -8,   -5,    0,    7,   -2,   -3,   -1,    3,   -9,    5,   -4,  -17,   -1,    9,    3,    7,
	   1,   -4,   -3,    5,    2,   -7,   -9,   12,   -6,  -14,  -16,    2,   -1,   16,    2,    2,
	   7,   -6,  -26,    3,   -2,   -4,   -2,   10,    3,   -7,    3,    8,    9,    5,    4,    1,
	  -5,   -5,   11,    8,    7,   11,   12,   -1,   -5,  -16,   13,    7,    2,   11,    4,   -4,
	   9,   -8,   -8,   14,   11,   -8,    0,   -1,   -5,   -2,   -1,  -10,   -5,   -9,   -9,  -16,
	 -12,   -8,  -16,    5,  -10,   -4,  -11,   -3,    1,    0,   -3,   -5,  -13,   -9,   -2,   -8,
	   5,   -9,   -7,   -2,    2,  -11,   -7,   13,    8,   -3,    2,    7,   -2,   -1,    5,    0,
	  11,    6,   13,   15,    1,   -4,    9,    5,    3,    8,   -3,   -4,   16,    4,   11,    9,
	   0,    8,    1,   -6,   -5,  -18,    3,    7,  -18,   -4,    0,   -3,   -3,   -6,   -4,   -5,
	  -5,  -10,   -2,   -9,   -5,   -2,   -4,  -11,   -2,    1,   -5,   -2,   11,   -6,   -9,    1,
	   4,   -6,   -1,   -5,    1,    2,    9,    5,    0,    4,    4,   -2,    7,    0,  -10,    5,
	   2,   -3,    0,   -6,    7,   -4,   -3,    6,   -1,   -6,   -1,   -1,    2,   -2,   -6,   -3,
	   0,    8,   -6,    4,   -1,   -5,   -3,    3,    1,   -5,   -6,   -2,   -3,    5,    6,    0,
	   7,   -3,    3,   -1,    0,   -2,    9,    1,    1,   -3,    4,    5,   -5,    2,   -2,    2,
	 -11,   -2,   -4,   11,    4,    5,    0,   -5,  -12,   -6,   -5,   -5,    3,   -2,   -2,    2,
	   2,    1,    0,   -1,   -8,   -5,   -5,   -3,    2,   -1,    3,   -1,    3,    0,   -1,    0,
	  -1,    1,    1,   -4,   -4,    2,   -2,    1,   -6,    1,    2,    4,    2,    2,   -5,   -1,
	   6,   -3,   -1,   -4,   11,    3,   -9,   -2,   -6,   -3,    2,    4,    2,    1,    2,    4,
	   3,   -6,   -4,   -3,   -2,    0,    2,   -2,    5,    2,   -1,    3,   -9,   -3,   -3,   -4,
	  -4,   -1,    0,   -2,    7,    3,    1,    1,   -2,   -4,   -2,   -3,   -2,   -4,    2,    4,
	  -1,    2,    3,    0,    3,   -1,    0,   -2,   -2,   -3,    1,   -1,   -4,    5,   -1,    5,
	   0,   -3,   -2,   -1,   -4,    3,   -1,   -3,   -2,   -2,   -1,    0,    0,    1,   -1,    0,
	  -2,   -2,    0,   -3,   -1,    0,    0,    1,    1,   -2,   -1,    1,   -3,    1,    2,    0,
	  -1,    0,   -1,    1,    5,   -2,    1,   -3,   -3,   -1,   -3,    0,    1,    3,    2,   -1,
	  -1,   -2,   -2,   -1,    1,   30,   -9,  -44,   13,   26,  -53,  -41,    2,   76,   47,   40,
	 -52,  -53,   -5,   12,  -33,   15,   62,   53,  -27,  -98,  -26,  -42,   52,   75,   43,  -32,
	  -3,  -83,  -13,  -36,   35,   39,   56,   25,   -9, -122,  -22,   -3,   79,   -6,    6,   25,
	 -20,  -12,  -40,  -19,   15,   74,   37,  -14,  -33,    6,   25,    7,  -10,   -4,   42,    4,
	 -33,  -87,  -55,   29,   39,   21,  -34,  -27,    1,   26,    5,  -22,  -13,   10,   56,    0,
	 -26,  -40,   30,   42,   23,   -7,  -23,   28,   21,    9,  -37,  -25,   11,   25,    8,  -48,
	 -19,  -15,   41,   -2,  -30,  -28,    4,   30,  -12,  -23,  -28,   17,   38,    3,  -12,   -8,
	  17,   26,    9,  -32,    0,   12,   49,   -3,  -29,  -17,    2,   41,  -17,  -24,  -17,    9,
	  30,  -23,  -22,  -21,   19,   17,  -12,  -35,  -18,   12,   29,    2,  -27,    7,   14,   42,
	 -11,  -24,   -3,   15,   40,  -23,  -24,  -17,   21,   22,  -10,  -23,  -10,   23,   13,   -4,
	 -37,    0,   15,   19,  -12,  -40,   -2,   13,   30,  -16,  -22,   -3,   22,   22,  -13,  -16,
	  -7,   34,    9,   -5,  -34,   -5,   29,   10,   -3,  -39,    3,   17,   14,  -13,  -25,    5,
	  21,   12,  -18,  -22,   -8,   31,    8,   -5,  -27,   -9,   30,    1,   -3,  -30,    6,   27,
	   4,  -14,  -31,    8,   25,   10,  -14,  -21,   -3,   24,    4,  -11,  -17,   -1,   30,   -1,
	 -12,  -26,    3,   32,    3,  -13,  -26,    5,   23,    3,  -14,  -17,    6,   22,    1,  -17,
	 -16,    4,   25,    4,  -18,  -19,    4,   23,    5,  -17,  -14,    5,   21,    1,  -20,  -11,
	   7,   23,    2,  -19,  -17,    8,   19,    6,  -18,  -15,   10,   14,    6,  -26,   -5,   11,
	  15,    4,  -27,   -5,    4,   22,    1,  -17,  -12,    6,   15,    1,  -16,  -13,   20,    8,
	   4,  -28,   -7,   17,    9,   10,  -31,    3,    1,   13,    0,  -18,    0,    6,   17,  -10,
	 -14,  -15,   21,   10,    3,  -19,  -14,   22,   -4,   11,  -27,    8,    9,    7,   -2,  -26,
	   8,    2,   23,  -13,   -7,  -13,   12,   11,  -11,   -2,  -15,   27,   -8,    2,  -22,    0,
	  18,    0,    6,  -27,   10,   -4,   19,  -13,   -7,    1,    2,   19,  -26,    7,  -17,   28,
	  -2,   -8,   -6,  -11,   23,   -9,   10,  -24,   12,   -2,   10,   -8,  -14,   13,   -5,   25,
	 -33,    7,  -11,   17,    8,  -19,    9,  -18,   26,  -17,    6,  -12,    8,    8,   -5,    0,
	 -23,   20,  -10,   25,  -24,    2,    0,   -2,   17,  -30,   22,  -16,   25,  -15,   -7,   -2,
	  -4,   21,  -15,   13,  -25,   19,  -11,    9,   -8,   -7,   19,  -15,   20,  -34,   17,   -9,
	  15,    0,  -15,   11,  -17,   24,  -24,   16,  -15,   15,    0,  -11,    6,  -21,   30,  -18,
	  18,  -22,    6,    3,   -6,   10,  -20,   23,  -17,   20,  -23,    7,   -3,    2,   16,  -24,
	  18,  -26,   27,  -15,    5,   -2,   -5,   19,  -21,   12,  -22,   22,   -9,    9,  -11,   -5,
	  11,  -13,   21,  -27,   22,  -17,   13,   -5,  -13,   14,  -14,   28,  -24,    9,  -16,   12,
	   3,   -7,    5,  -14,   22,  -20,   14,  -21,   14,    3,   -2,    6,  -26,   20,  -17,   23,
	 -17,    3,    0,   -2,   11,  -23,   14,  -14,   26,  -14,    0,  -10,   -3,   18,  -14,   15,
	 -24,   19,   -9,    4,   -8,   -9,   18,   -6,   15,  -29,   11,  -10,   16,   -1,  -11,    9,
	 -13,   23,  -23,    8,  -13,   12,   10,  -11,    0,  -20,   22,   -7,   12,  -19,    4,    4,
	   1,    4,  -23,   18,  -10,   22,  -17,   -7,    0,   -1,   23,  -20,    6,  -18,   18,    0,
	  -3,   -8,   -5,   20,   -8,    6,  -27,   14,    2,   11,   -5,  -20,   13,  -10,   24,  -22,
	   3,   -5,   11,    8,  -20,    1,  -12,   28,   -7,    0,  -19,    2,   15,   -5,    6,  -25,
	  20,   -4,   13,  -19,  -10,   10,    5,   17,  -27,    1,  -10,   22,   -2,  -10,   -2,   -7,
	  26,  -18,    4,  -24,   18,   10,    1,   -8,  -23,   16,    2,   15,  -22,   -1,    3,   10,
	   5,  -27,    9,   -8,   35,  -19,   -3,  -18,    7,   19,   -7,   -3,  -16,   14,    6,   -5,
	  -9,  -12,   23,   -5,   11,  -33,   19,  -10,   23,  -22,    3,   -5,   14,   -2,   -8,   -8,
	   7,    7,    2,  -14,    0,   -2,   17,  -14,    3,  -17,   20,   -5,    7,  -19,    3,    3,
	  10,   -5,   -9,   -4,    6,    6,   -2,  -10,    1,    2,   12,  -13,    0,  -11,   18,   -3,
	   3,  -16,    2,    4,    7,   -5,   -6,    0,    6,    1,   -6,   -6,    4,    6,    5,  -11,
	  -2,   -4,   12,   -6,    1,   -9,    9,    0,    1,  -11,    0,    6,    5,   -2,  -11,    1,
	   2,    7,   -5,   -7,    3,    1,    8,  -13,    0,   -6,   15,   -3,   -2,  -11,    1,    9,
	   1,   -2,  -12,    6,    2,    5,   -9,   -5,    3,    6,    5,  -12,   -3,   -3,   12,    0,
	  -5,   -7,    0,    8,   -2,   -2,   -9,    7,    3,    5,  -11,   -4,    0,    9,    2,   -7,
	  -6,    0,    7,    1,   -6,   -3,    1,    8,   -4,   -5,   -7,    7,    4,    4,  -11,   -1,
	  -2,   10,   -5,   -1,   -7,    8,    1,    1,  -12,    1,    4,    7,   -4,   -8,   -4,    8,
	   0,    3,  -16,   11,   -7,    1,    0,    0,   -1,   -1,   -4,    1,   -1,   -3,  -13,   -8,
	 -14,   -3,   -2,   -2,    1,    8,    5,    7,  -21,  -13,   -2,   -6,   -8,  -22,   -6,    5,
	  11,   34,   41,   33,   13,   28,   33,   48,   35,   21,   -3,  -26,  -18,  -10,    3,    7,
	  22,   21,   63,   40,   41,   43,    4,   -8,  -43,  -63,  -77,  -77,  -59,  -18,    3,    2,
	 -21,  -46,  -74,  -90, -108, -101,  -94,  -89,  -84,  -85,  -77,  -59,  -50,  -33,   -7,   18,
	  37,   47,   64,  101,  127,  125,  127,  126,  126,  126,  122,  100,   87,   62,   37,   28,
	  27,   25,   27,   34,   25,   -4,  -45,  -85, -123, -128, -126, -128, -127, -123,  -92,  -73,
	 -55,  -45,  -37,  -33,  -32,  -33,  -43,  -53,  -55,  -43,  -20,    3,   20,   34,   42,   49,
	  55,   63,   74,   84,   93,  101,  107,  112,  117,  109,   92,   63,   33,    8,  -13,  -25,
	 -29,  -30,  -27,  -27,  -32,  -46,  -63,  -82,  -98, -109, -116, -121, -118, -104,  -80,  -49,
	 -12,   21,   45,   58,   64,   66,   66,   61,   51,   44,   37,   32,   32,   33,   33,   28,
	  23,   15,    8,    3,    2,    9,   16,   20,   24,   23,   14,   -1,  -20,  -37,  -48,  -53,
	 -52,  -47,  -38,  -26,  -13,   -5,   -1,   -4,  -10,  -22,  -34,  -43,  -48,  -46,  -34,  -16,
	   5,   25,   45,   65,   78,   84,   83,   71,   55,   39,   24,    9,   -3,  -12,  -23,  -34,
	 -45,  -57,  -65,  -71,  -71,  -63,  -49,  -34,  -21,  -11,   -2,    2,    8,   11,   12,   14,
	  14,   20,   28,   38,   50,   58,   63,   61,   56,   46,   33,   17,   -1,  -19,  -34,  -45,
	 -48,  -44,  -32,  -19,   -5,    5,    7,    4,   -2,   -7,  -11,  -15,  -18,  -21,  -23,  -26,
	 -28,  -30,  -31,  -29,  -26,  -20,  -12,   -1,   11,   21,   32,   42,   51,   55,   55,   52,
	  46,   41,   37,   32,   30,   28,   27,   24,   19,   12,   -1,  -21,  -45,  -67,  -89, -103,
	-107, -101,  -90,  -70,  -51,  -33,  -18,   -2,   11,   23,   33,   39,   44,   49,   52,   57,
	  59,   59,   56,   52,   48,   41,   35,   28,   20,   15,   11,    4,    0,   -5,  -11,  -18,
	 -25,  -34,  -42,  -47,  -48,  -46,  -40,  -33,  -27,  -24,  -21,  -24,  -32,  -42,  -51,  -56,
	 -58,  -56,  -47,  -35,  -18,    2,   24,   48,   70,   88,   99,  104,  102,   97,   89,   79,
	  69,   59,   49,   37,   27,   14,    0,  -14,  -29,  -44,  -58,  -71,  -81,  -87,  -88,  -88,
	 -85,  -81,  -77,  -72,  -63,  -51,  -37,  -21,   -5,   12,   29,   43,   53,   59,   61,   57,
	  48,   36,   24,   13,    8,    8,   15,   25,   38,   48,   54,   54,   50,   43,   33,   22,
	  11,    3,   -6,  -15,  -25,  -35,  -46,  -54,  -61,  -65,  -68,  -69,  -69,  -68,  -64,  -59,
	 -52,  -43,  -32,  -20,   -7,    6,   19,   31,   42,   51,   58,   62,   64,   62,   58,   52,
	  44,   35,   26,   17,    9,    1,   -5,  -10,  -15,  -18,  -19,  -20,  -19,  -18,  -16,  -15,
	 -14,  -14,  -15,  -16,  -17,  -18,  -19,  -19,  -19,  -19,  -18,  -16,  -14,  -11,   -9,   -6,
	  -3,    0,    3,    6,   10,   14,   18,   22,   27,   32,   35,   37,   37,   35,   30,   23,
	  14,    4,   -6,  -15,  -24,  -31,  -36,  -39,  -40,  -39,  -37,  -32,  -26,  -19,  -10,   -1,
	   8,   17,   24,   29,   32,   33,   32,   29,   25,   20,   15,   11,    7,    3,   -1,   -5,
	  -9,  -14,  -19,  -24,  -28,  -31,  -32,  -31,  -27,  -23,  -16,  -10,   -3,    2,    7,   10,
	  12,   13,   13,   13,   12,   10,    8,    7,    5,    5,    5,    5,    6,    8,   10,   13,
	  17,   20,   23,   25,   26,   25,   21,   16,    9,    1,   -7,  -16,  -24,  -31,  -37,  -42,
	 -47,  -49,  -51,  -52,  -51,  -48,  -43,  -37,  -30,  -20,   -7,    6,   19,    0,   -4,   10,
	  10,   11,  -15,    4,   -1,    3,  -11,   11,    2,  -12,    3,   18,  -10,  -62,   89,  -16,
	 -95,  118, -128,  122, -128,  112, -100,  109, -121,  120, -104,   58,   10,  -88,  127, -102,
	   6,   98, -126,   35,   89, -111,   -7,  112,  -53,  -94,   92,   64, -106,  -53,  109,   52,
	-100,  -75,   86,   95,  -45, -119,  -12,  111,   74,  -58, -118,  -27,   97,  100,   -4, -107,
	 -95,   17,  109,   92,   -4,  -99, -109,  -26,   78,  115,   66,  -27, -104, -109,  -41,   55,
	 112,   98,   32,  -53, -109, -105,  -44,   41,  102,  109,   67,   -4,  -74, -112, -102,  -47,
	  27,   88,  112,   93,   45,  -19,  -78, -110, -105,  -65,   -4,   59,  101,  110,   87,   43,
	 -13,  -67, -103, -111,  -89,  -44,   13,   65,  100,  109,   93,   59,   14,  -36,  -78, -104,
	-108,  -90,  -53,   -6,   43,   83,  104,  106,   88,   57,   17,  -27,  -66,  -95, -108, -102,
	 -80,  -44,   -2,   41,   77,   99,  106,   98,   77,   46,   10,  -29,  -64,  -91, -105, -105,
	 -91,  -64,  -29,   10,   48,   78,   98,  105,  100,   84,   59,   30,   -3,  -36,  -65,  -88,
	-101, -105,  -99,  -83,  -60,  -32,   -1,   30,   58,   80,   96,  103,  102,   94,   80,   62,
	  40,   16,  -10,  -35,  -58,  -78,  -92, -101, -104, -100,  -91,  -77,  -58,  -36,  -13,   12,
	  36,   57,   75,   89,   98,  102,  102,   97,   88,   76,   61,   44,   25,    5,  -15,  -35,
	 -54,  -70,  -84,  -94, -101, -104, -103,  -98,  -89,  -77,  -63,  -46,  -27,   -8,   12,   31,
	  49,   65,   79,   90,   97,  102,  104,  102,   97,   90,   81,   70,   57,   42,   27,   10,
	  -7,  -24,  -40,  -56,  -70,  -81,  -91,  -99, -103, -105, -105, -101,  -95,  -87,  -76,  -63,
	 -49,  -34,  -18,   -1,   16,   32,   48,   62,   74,   85,   93,  100,  104,  105,  105,  102,
	  97,   90,   82,   72,   61,   48,   35,   21,    6,   -9,  -24,  -38,  -52,  -65,  -76,  -86,
	 -94, -101, -105, -108, -108, -106, -102,  -96,  -87,  -78,  -66,  -54,  -40,  -26,  -11,    4,
	  19,   34,   48,   61,   73,   83,   92,   99,  104,  107,  108,  108,  105,  101,   96,   89,
	  80,   70,   60,   48,   36,   22,    9,   -5,  -19,  -33,  -46,  -58,  -69,  -80,  -89,  -96,
	-102, -107, -109, -110, -110, -107, -102,  -97,  -89,  -80,  -70,  -59,  -47,  -33,  -20,   -6,
	   7,   19,   30,   41,   50,   58,   65,   71,   75,   78,   79,   80,   79,   77,   74,   70,
	  65,   60,   54,   48,   42,   36,   29,   22,   16,   10,    4,   -2,   -7,  -12,  -16,  -19,
	 -22,  -24,  -26,  -27,  -27,  -27,  -26,  -25,  -23,  -22,  -19,  -17,  -14,  -12,  -10,    0,
	  -5,   -2,   -5,    2,  -29,   22,    0,  -27,   67,  -59,   45,  -13,  -37,   28,   65,   -4,
	   6,   60,    5,   58,   44,   60,   27,   43,   96,   71,   81,   48,   96,   70,   23,   90,
	  66,   80,   88,   40,   20,   61,   64,   12,   36,   24,    4,    7,    5,  -27,  -38,  -26,
	 -33,  -49,  -50,  -70,  -69,  -93,  -92,  -94, -104, -104, -101, -110, -107, -111, -111, -126,
	 -87, -119, -100,  -94, -112,  -93,  -93,  -80,  -81,  -76,  -58,  -56,  -70,  -30,  -21,  -42,
	 -13,   -3,    2,    8,   20,   28,   41,   45,   59,   62,   69,   84,   85,   90,  103,  109,
	 111,  118,  121,  121,  123,  121,  122,  121,  122,  121,  122,  121,  121,  120,  121,  120,
	 121,  120,  121,  120,  120,  119,  120,  119,  120,  118,  105,  106,  110,   83,   89,   92,
	  75,   67,   61,   57,   47,   40,   33,   24,   17,   10,    3,   -2,  -10,  -20,  -31,  -31,
	 -37,  -49,  -50,  -63,  -66,  -69,  -74,  -79,  -91,  -89,  -92,  -95, -102, -106, -104, -107,
	-113, -113, -110, -113, -116, -114, -115, -114, -115, -114, -113, -114, -113, -114, -113, -112,
	-113, -109, -105, -111, -106, -107, -103, -100, -103,  -99,  -97,  -98,  -99,  -92,  -92,  -93,
	 -92,  -92,  -90,  -88,  -90,  -88,  -86,  -89,  -85,  -85,  -87,  -85,  -85,  -82,  -83,  -82,
	 -80,  -78,  -79,  -76,  -74,  -73,  -73,  -69,  -68,  -66,  -64,  -65,  -62,  -58,  -56,  -56,
	 -52,  -50,  -47,  -43,  -42,  -39,  -35,  -33,  -31,  -27,  -23,  -21,  -16,  -16,   -8,   -7,
	  -3,    1,    0,   10,   15,   15,   19,   26,   29,   30,   38,   41,   42,   47,   54,   54,
	  57,   63,   68,   69,   72,   77,   78,   80,   85,   84,   86,   87,   86,   87,   86,   85,
	  86,   85,   84,   85,   84,   83,   84,   83,   82,   82,   83,   82,   81,   82,   81,   80,
	  81,   80,   79,   80,   79,   79,   78,   79,   78,   78,   77,   74,   70,   66,   64,   61,
	  55,   52,   49,   45,   40,   35,   32,   29,   24,   19,   15,   12,    8,    4,    0,   -4,
	  -8,  -11,  -15,  -17,  -20,  -25,  -26,  -29,  -32,  -34,  -37,  -39,  -41,  -43,  -45,  -46,
	 -48,  -49,  -50,  -50,  -52,  -52,  -53,  -52,  -53,  -54,  -53,  -53,  -52,  -52,  -51,  -50,
	 -50,  -49,  -48,  -48,  -46,  -45,  -44,  -42,  -41,  -40,  -39,  -37,  -35,  -34,  -32,  -30,
	 -28,  -27,  -24,  -23,  -22,  -20,  -19,  -17,  -15,  -14,  -13,  -12,  -10,   -9,   -8,   -8,
	  -6,   -6,   -5,   -4,   -4,   -3,   -3,   -2,   -2,   -1,   -2,   -1,   -2,   -1,   -1,    0,
	  -1,    0,    1,    6,  -11,   19,  -25,   24,  -15,   11,   -6,    1,    9,   -6,   -3,   11,
	 -18,   28,  -23,    8,    6,   -2,   -1,    0,   -5,   18,  -23,   24,  -28,   27,  -12,   -1,
	  -2,    6,    4,  -14,   19,  -29,   42,  -40,   22,   -6,   -3,   14,  -16,    4,    8,   -9,
	  13,  -22,   17,    5,  -24,   37,  -34,   20,   -4,  -11,   19,  -20,   21,  -16,    1,   17,
	 -17,    5,   -9,   25,  -31,   31,  -40,   32,  -11,   -7,    4,   -4,   13,  -23,   29,  -40,
	  51,  -49,   20,    3,  -20,   38,  -47,   34,  -21,   14,   -9,    4,  -13,   20,  -29,   37,
	 -57,   59,  -48,   23,   -5,   -7,    5,   -6,   -5,   13,  -17,    9,   -4,  -12,   22,  -19,
	  -8,   10,   -5,   -7,    8,  -18,   19,  -13,    5,  -12,    6,  -10,   18,  -40,   66,  -91,
	  82,  -56,   17,   19,  -51,   56,  -45,   30,  -19,    5,   -6,    7,   -9,   -4,   -2,   -5,
	  13,  -19,    1,   20,  -28,   13,   -6,    0,  -17,   33,  -48,   38,  -16,  -20,   53,  -75,
	  75,  -61,   30,  -12,   -9,    2,    5,   -9,   -7,   15,  -17,    9,    4,  -46,   70,  -85,
	  86,  -67,   29,   18,  -60,   76,  -70,   29,   -8,   -1,    1,   14,  -58,   93, -118,  127,
	-125,   85,  -36,   -2,   17,  -39,   46,  -61,   70,  -99,  122, -120,   56,   15,  -85,  116,
	-101,   30,   43, -108,  127, -122,   72,  -38,   -3,   20,  -31,   29,  -37,   42,  -50,   63,
	 -72,   40,   -7,  -46,   66,  -82,   53,  -25,    1,    1,   -1,   -3,    3,  -24,   24,  -34,
	  27,  -24,   36,  -49,   37,  -38,   35,  -42,   13,   -4,  -14,   14,  -29,   42,  -58,   58,
	 -60,   41,  -39,   27,  -35,   27,  -32,   25,  -37,   43,  -50,   32,  -20,   -4,    4,  -14,
	  16,  -43,   66,  -93,   79,  -58,   27,  -11,  -21,   34,  -40,   24,   -7,  -25,   31,  -29,
	  19,  -18,   -2,    1,   -6,    4,  -31,   47,  -63,   62,  -64,   32,    2,  -29,   23,  -21,
	  19,  -41,   59,  -76,   62,  -52,   26,  -11,   -1,  -10,    6,  -10,   -7,   17,  -42,   34,
	 -12,  -34,   73, -106,   92,  -61,   26,  -24,    8,   -7,   -2,    3,  -24,   31,  -44,   27,
	  -9,  -22,   38,  -43,   15,   -4,   -3,   -2,  -12,    5,    1,   -7,    7,  -25,   17,  -17,
	   4,  -15,   27,  -40,   34,  -18,    6,  -13,   12,   -3,   -9,   -6,    8,  -18,   18,  -36,
	  54,  -55,   30,  -25,   26,  -41,   38,  -49,   48,  -38,    8,   16,  -40,   47,  -52,   34,
	 -12,   -4,    2,  -13,    0,    1,    6,  -11,   19,  -25,   24,  -15,   11,   -6,    1,    9,
	  -6,   -3,   11,  -18,   28,  -23,    8,    6,   -2,   -1,    0,   -5,   18,  -23,   24,  -28,
	  27,  -12,   -1,   -2,    6,    4,  -14,   19,  -29,   42,  -40,   22,   -6,   -3,   14,  -16,
	   4,    8,   -9,   13,  -22,   17,    5,  -24,   37,  -34,   20,   -4,  -11,   19,  -20,   21,
	 -16,    1,   17,  -17,    5,   -9,   25,  -31,   31,  -40,   32,  -11,   -7,    4,   -4,   13,
	 -23,   29,  -40,   51,  -49,   20,    3,  -20,   38,  -47,   34,  -21,   14,   -9,    4,  -13,
	  20,  -29,   37,  -57,   59,  -48,   23,   -5,   -7,    5,   -6,   -5,   13,  -17,    9,   -4,
	 -12,   22,  -19,   -8,   10,   -5,   -7,    8,  -18,   19,  -13,    5,  -12,    6,  -10,   18,
	 -40,   66,  -91,   82,  -56,   17,   19,  -51,   56,  -45,   30,  -19,    5,   -6,    7,   -9,
	  -4,   -2,   -5,   13,  -19,    1,   20,  -28,   13,   -6,    0,  -17,   33,  -48,   38,  -16,
	 -20,   53,  -75,   75,  -61,   30,  -12,   -9,    2,    5,   -9,   -7,   15,  -17,    9,    4,
	 -46,   70,  -85,   86,  -67,   29,   18,  -60,   76,  -70,   29,   -8,   -1,    1,   14,  -58,
	  93, -118,  127, -125,   85,  -36,   -2,   17,  -39,   46,  -61,   70,  -99,  122, -120,   56,
	  15,  -85,  116, -101,   30,   43, -108,  127, -122,   72,  -38,   -3,   20,  -31,   29,  -37,
	  42,  -50,   63,  -72,   40,   -7,  -46,   66,  -82,   53,  -25,    1,    1,   -1,   -3,    3,
	 -24,   24,  -34,   27,  -24,   36,  -49,   37,  -38,   35,  -42,   13,   -4,  -14,   14,  -29,
	  42,  -58,   58,  -60,   41,  -39,   27,  -35,   27,  -32,   25,  -37,   43,  -50,   32,  -20,
	  -4,    4,  -14,   16,  -43,   66,  -93,   79,  -58,   27,  -11,  -21,   34,  -40,   24,   -7,
	 -25,   31,  -29,   19,  -18,   -2,    1,   -6,    4,  -31,   47,  -63,   62,  -64,   32,    2,
	 -29,   23,  -21,   19,  -41,   59,  -76,   62,  -52,   26,  -11,   -1,  -10,    6,  -10,   -7,
	  17,  -42,   34,  -12,  -34,   73, -106,   92,  -61,   26,  -24,    8,   -7,   -2,    3,  -24,
	  31,  -44,   27,   -9,  -22,   38,  -43,   15,   -4,   -3,   -2,  -12,    5,    1,   -7,    7,
	 -25,   17,  -17,    4,  -15,   27,  -40,   34,  -18,    6,  -13,   12,   -3,   -9,   -6,    8,
	 -18,   18,  -36,   54,  -55,   30,  -25,   26,  -41,   38,  -49,   48,  -38,    8,   16,  -40,
	  47,  -52,   34,  -12,   -4,    2,  -13,   -1,   -9,  -21,  -32,  -43,  -55,  -58,  -40,   -8,
	  15,   29,   38,   44,   59,   63,   51,   20,  -20,  -47,  -61,  -58,  -48,  -42,  -43,  -35,
	 -15,   15,   41,   55,   61,   62,   70,   67,   45,   11,  -31,  -62,  -80,  -78,  -71,  -62,
	 -54,  -39,  -15,   18,   50,   68,   79,   83,   92,   88,   57,   16,  -31,  -71,  -94,  -95,
	 -90,  -83,  -71,  -55,  -28,    7,   49,   77,   93,  100,  109,  107,   78,   36,  -20,  -71,
	 -99, -104, -100,  -92,  -83,  -69,  -43,   -5,   42,   79,  100,  108,  114,  112,   90,   51,
	  -9,  -65, -100, -110, -105,  -95,  -87,  -76,  -52,  -11,   35,   75,  100,  107,  111,  106,
	  90,   52,   -4,  -60,  -97, -109,  -99,  -87,  -80,  -65,  -35,    5,   43,   75,   91,   95,
	  93,   87,   71,   31,  -19,  -64,  -93,  -99,  -88,  -76,  -66,  -44,   -9,   28,   59,   79,
	  84,   80,   71,   59,   35,   -5,  -45,  -76,  -96,  -95,  -77,  -59,  -39,   -9,   28,   61,
	  86,   98,   93,   74,   52,   28,   -6,  -43,  -72,  -94, -108,  -99,  -77,  -52,  -20,   19,
	  56,   84,  106,  115,  106,   79,   45,    3,  -40,  -74,  -93, -108, -112, -100,  -79,  -46,
	  -1,   45,   78,  100,  113,  118,  108,   81,   39,  -19,  -67,  -93, -103, -108, -104,  -94,
	 -74,  -32,   19,   61,   88,  102,  108,  109,  100,   73,   21,  -44,  -87, -102, -104,  -97,
	 -90,  -78,  -49,    0,   46,   78,   90,   92,   89,   87,   77,   43,  -15,  -72, -101, -104,
	 -93,  -79,  -69,  -47,   -3,   47,   84,   96,   89,   74,   65,   58,   37,   -7,  -61,  -99,
	-110, -101,  -82,  -62,  -38,    2,   49,   92,  112,  106,   82,   59,   41,   18,  -19,  -61,
	 -95, -111, -110,  -98,  -74,  -39,    6,   54,   99,  122,  123,  104,   79,   50,   12,  -32,
	 -72, -100, -111, -110, -106,  -90,  -54,   -4,   49,   99,  123,  126,  113,   95,   69,   24,
	 -27,  -72, -102, -114, -109, -104,  -94,  -64,  -16,   36,   87,  116,  121,  111,   97,   76,
	  36,  -15,  -61,  -94, -110, -108,  -98,  -86,  -60,  -19,   29,   77,  104,  109,   99,   86,
	  67,   35,   -7,  -47,  -82,  -98, -101,  -92,  -77,  -48,  -14,   25,   67,   92,   95,   83,
	  66,   45,   18,   -9,  -37,  -62,  -77,  -81,  -78,  -54,  -16,    0,    0,    0,   12,  -10,
	  16,  -14,  -18,   17,  -31,   -2,    3,  -19,   -8,   17,   28,   37,   31,   -1,  -25,  -16,
	 -47,  -13,  -43,  -22,    6,   34,   41,   49,   41,   27,    6,  -33,  -62,  -54,  -59,  -32,
	 -13,   29,   53,   73,   60,   54,   16,  -19,  -58,  -77,  -89,  -42,  -46,   17,   55,   78,
	  86,   81,   33,   -3,  -35,  -84, -110,  -75,  -70,    0,   39,   78,   92,  105,   70,   13,
	 -15,  -82, -107, -103,  -84,  -41,   20,   81,   85,  127,   86,   39,   -4,  -63, -103,  -99,
	-107,  -69,    2,   68,   82,  127,   84,   58,   28,  -44,  -88, -104, -108,  -83,  -13,   29,
	  69,  116,   87,   77,   40,  -16,  -65,  -89, -104,  -89,  -40,   -1,   47,   96,   90,   85,
	  52,    9,  -38,  -62,  -96,  -95,  -62,  -22,   21,   73,   78,   86,   65,   35,  -15,  -41,
	 -80,  -92,  -69,  -48,    1,   43,   65,   80,   73,   49,    8,  -23,  -59,  -75,  -74,  -60,
	 -22,   17,   49,   69,   65,   60,   25,   -1,  -36,  -59,  -70,  -61,  -40,   -9,   30,   52,
	  57,   63,   37,   17,  -12,  -41,  -61,  -57,  -50,  -30,    9,   30,   49,   60,   47,   28,
	   6,  -20,  -49,  -51,  -53,  -42,  -11,   13,   34,   53,   50,   34,   18,   -3,  -35,  -39,
	 -52,  -49,  -23,    0,   18,   41,   47,   36,   31,   10,  -21,  -28,  -43,  -49,  -31,  -13,
	   2,   28,   39,   35,   38,   19,   -7,  -18,  -33,  -42,  -36,  -26,  -12,   19,   30,   34,
	  36,   22,    6,   -5,  -25,  -38,  -36,  -29,  -17,    8,   19,   26,   35,   28,   12,    3,
	 -17,  -30,  -29,  -29,  -22,   -3,    9,   19,   33,   26,   14,    8,   -9,  -18,  -22,  -28,
	 -25,   -9,    3,   15,   22,   20,   18,   12,    1,  -11,  -22,  -24,  -21,  -13,   -3,    8,
	  11,   20,   21,   12,    5,   -6,  -19,  -16,  -17,  -17,   -7,    3,    8,   20,   17,    7,
	   7,   -2,  -11,  -13,  -16,  -17,   -5,    2,    5,   12,   13,    8,    6,    3,   -9,  -11,
	  -9,  -14,   -5,    1,   -3,    6,   11,    6,    7,    2,   -6,   -4,   -4,  -10,   -6,   -3,
	  -4,    5,    8,    2,    5,    4,   -2,    0,   -3,   -9,   -4,   -3,   -3,    2,    3,    0,
	   6,    4,    0,   -1,   -2,   -2,    0,   -4,    8,   -1,    9,   14,   53,   57,   33,   -4,
	 -20,  -14,  -31,  -71, -112,  -43,   30,  -22, -102,  -74,   38,   90,   35,  -22,   20,   99,
	  96,   22,  -42,   -5,   48,   16,  -74,  -97,  -51,   10,  -21,  -80,  -68,   24,   77,   43,
	  -9,   20,   90,   99,   32,  -28,   -8,   41,   18,  -63,  -97,  -55,   -2,  -18,  -74,  -67,
	  11,   69,   44,   -1,   17,   83,   98,   40,  -20,   -8,   35,   20,  -55,  -95,  -60,   -8,
	 -19,  -69,  -68,    3,   61,   45,    1,   15,   78,   99,   46,  -14,   -8,   33,   22,  -48,
	 -93,  -62,  -13,  -19,  -67,  -70,   -5,   56,   44,    3,   13,   73,   99,   51,  -10,   -7,
	  32,   25,  -42,  -91,  -66,  -15,  -18,  -65,  -73,  -11,   51,   44,    3,    9,   69,  100,
	  55,   -6,   -8,   32,   30,  -36,  -89,  -68,  -17,  -17,  -64,  -77,  -18,   47,   45,    3,
	   5,   64,  100,   60,   -2,   -8,   32,   34,  -30,  -87,  -70,  -19,  -14,  -63,  -80,  -25,
	  43,   45,    3,    1,   59,  100,   66,    1,   -9,   31,   39,  -23,  -84,  -74,  -20,  -12,
	 -59,  -84,  -32,   38,   46,    3,   -3,   53,  101,   71,    6,  -10,   31,   43,  -14,  -81,
	 -76,  -24,   -9,  -57,  -86,  -41,   33,   46,    5,   -9,   47,   99,   77,    9,  -11,   28,
	  49,   -6,  -76,  -79,  -25,   -9,  -50,  -91,  -46,    9,  -41,    2,    6,  -33,   33,   -4,
	  -1,   34,  -93,   60,  -49,   68,  -21,   41,  -38,  -38,   27,  -87,  127,  -34,   38,   -3,
	 -34,   -2,  -85,   79,  -24,    4,   75,  -23,   11,  -70,    1,   -6,   -6,   63,  -48,   76,
	 -71,    2,   -7,  -15,   46,  -32,   48,  -25,   -5,   10,  -31,   18,  -23,    5,    6,   17,
	  11,    3,   24,  -46,  -21,   -1,   -5,   31,    1,   36,  -23,  -11,   -4,  -29,   14,   -5,
	  29,    9,   -2,   -2,  -20,   -2,  -15,   13,    7,    4,   15,  -11,    4,  -13,   -1,    1,
	 -13,   15,   -6,    9,    9,   -2,   -4,  -11,   -2,  -11,    7,   12,    9,    5,   -6,   -6,
	 -16,   -2,    3,    6,   13,    1,    7,  -14,   -3,  -11,   -1,    8,    0,   18,   -3,   -3,
	  -6,  -13,    0,    4,    2,    9,    2,    2,   -6,   -4,   -1,   -8,    2,    4,    2,    7,
	  -4,    2,    1,   -7,   -3,   -2,    0,    2,    8,   -2,    2,   -1,   -7,   -3,   -1,    3,
	   4,    3,    3,   -3,   -4,   -4,    0,    2,    1,    5,   -1,   -2,    1,   -4,   -1,    1,
	   0,    2,    8,  -22,   25,   30,    6,  -19,  -62,  -19,   10,   83,   57,  -67,  -88,  -52,
	  63,  127,   42,  -63, -121,  -70,   82,  111,   46,  -43, -114,  -35,   45,   73,   39,  -19,
	 -54,  -41,    9,   49,   24,  -16,  -14,   -9,   -6,   10,    8,  -22,   25,   30,    6,  -19,
	 -62,  -19,   10,   83,   57,  -67,  -88,  -52,   63,  127,   42,  -63, -121,  -70,   82,  111,
	  46,  -43, -114,  -35,   45,   73,   39,  -19,  -54,  -41,    9,   49,   24,  -16,  -14,   -9,
	  -6,   10,   94,  127,  124,  127,  127,  114,   73,   35,  -11,  -52,  -98, -118, -125, -128,
	-128, -128, -128, -128, -128, -128, -124,  -86,  -47,    0,   40,   87,  106,  116,  119,  125,
	  37,   -7,  122,   72,  -57,  -71,  -88,  -28,   48,  127,   36,  -30,  -53, -126,  -16,   71,
	  92,   51,   -1,  -83, -128,   14,   43,   83,   86,  -14, -106,  -87,   -7,   28,    1,  122,
	   0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	   0,    0,    0,    0
};

static const EAS_U32 eas_sampleLengths[] = 
{
	9922, 9338, 6793, 5242, 3057, 2818, 2806, 1835,
	1603, 1262, 1227, 1168, 1132, 1132, 994, 907,
	817, 801, 583, 418, 402, 387, 387, 357,
	347, 212, 167, 40, 40, 32, 30
};

static const EAS_U32 eas_sampleOffsets[] = 
{
	0x00000000, 0x000026c2, 0x00004b3c, 0x000065c5, 0x00007a3f, 0x00008630, 0x00009132, 0x00009c28,
	0x0000a353, 0x0000a996, 0x0000ae84, 0x0000b34f, 0x0000b7df, 0x0000bc4b, 0x0000c0b7, 0x0000c499,
	0x0000c824, 0x0000cb55, 0x0000ce76, 0x0000d0bd, 0x0000d25f, 0x0000d3f1, 0x0000d574, 0x0000d6f7,
	0x0000d85c, 0x0000d9b7, 0x0000da8b, 0x0000db32, 0x0000db5a, 0x0000db82, 0x0000dba2
};

/*----------------------------------------------------------------------------
 * S_EAS (hybrid)
 *----------------------------------------------------------------------------
*/
const S_EAS easlib_hybrid_22khz_mcu = 
{
	0x01534145,
	0x00105622,
	eas_banks,
	eas_programs,
	eas_regions,
	eas_articulations,
	eas_sampleLengths,
	eas_sampleOffsets,
	eas_samples,
	eas_fmRegions,
	1,
	1,
	61,
	53,
	31,
	128
}; /* end S_EAS */

/*----------------------------------------------------------------------------
 * Statistics
 *
 * Number of banks: 1
 * Number of programs: 1
 * Number of regions: 61
 * Number of articulations: 53
 * Number of samples: 31
 * Size of sample pool: 56276
 *----------------------------------------------------------------------------
*/
/* end C:\Sonic\Trunk\EASLib\WTLibrary\hybrid_22khz_mcu.c */
