#compdef ffmpeg-normalize

# AUTOMATICALLY GENERATED by `shtab`


_shtab_ffmpeg_normalize_commands() {
  local _commands=(
    
  )
  _describe 'ffmpeg-normalize commands' _commands
}

_shtab_ffmpeg_normalize_options=(
  "(- : *)"{-h,--help}"[show this help message and exit]"
  "--input-list[Path to a text file containing a line-separated list of input files]:input_list:"
  {-o,--output}"[Output file names. Will be applied per input file.

If no output file name is specified for an input file, the output files
will be written to the default output folder with the name \`\<input\>.\<ext\>\`,
where \`\<ext\>\` is the output extension (see \`-ext\` option).

Example\: ffmpeg-normalize 1.wav 2.wav -o 1n.wav 2n.wav
]:output:"
  {-of,--output-folder}"[Output folder (default\: \`normalized\`)

This folder will be used for input files that have no explicit output
name specified.
]:output_folder:"
  {-f,--force}"[Force overwrite existing files]"
  {-d,--debug}"[Print debugging output]"
  {-v,--verbose}"[Print verbose output]"
  {-q,--quiet}"[Only print errors in output]"
  {-n,--dry-run}"[Do not run normalization, only print what would be done]"
  {-pr,--progress}"[Show progress bar for files and streams]"
  "(- : *)--version[Print version and exit]"
  "--preset[Load options from a preset file.

Preset files are JSON files located in the presets directory.
The directory location depends on your OS\:
- Linux\/macOS\: \~\/.config\/ffmpeg-normalize\/presets\/
- Windows\: \%APPDATA\%\/ffmpeg-normalize\/presets\/

Use --list-presets to see available presets.
CLI options specified on the command line take precedence over preset values.
]:preset:"
  "--list-presets[List all available presets and exit]"
  {-nt,--normalization-type}"[Normalization type (default\: \`ebu\`).

EBU normalization performs two passes and normalizes according to EBU
R128.

RMS-based normalization brings the input file to the specified RMS
level.

Peak normalization brings the signal to the specified peak level.
]:normalization_type:(ebu rms peak)"
  {-t,--target-level}"[Normalization target level in dB\/LUFS (default\: -23).

For EBU normalization, it corresponds to Integrated Loudness Target
in LUFS. The range is -70.0 - -5.0.

Otherwise, the range is -99 to 0.
]:target_level:"
  {-p,--print-stats}"[Print loudness statistics for both passes formatted as JSON to stdout.]"
  "--replaygain[Write ReplayGain tags to the original file without normalizing.
This mode will overwrite the input file and ignore other options.
Only works with EBU normalization, and only with .mp3, .mp4\/.m4a, .ogg, .opus for now.
]"
  "--batch[Preserve relative loudness between files (album mode).

When operating on a group of unrelated files, you usually want all of them at the same
level. However, a group of music files all from the same album is generally meant to be
listened to at the relative volumes they were recorded at. In batch mode, all the specified
files are considered to be part of a single album and their relative volumes are preserved.
This is done by averaging the loudness of all the files, computing a single adjustment from
that, and applying a relative adjustment to all the files.

Batch mode works with all normalization types (EBU, RMS, peak).
]"
  {-lrt,--loudness-range-target}"[EBU Loudness Range Target in LUFS (default\: 7.0).
Range is 1.0 - 50.0.
]:loudness_range_target:"
  "--keep-loudness-range-target[Keep the input loudness range target to allow for linear normalization.
]"
  "--keep-lra-above-loudness-range-target[Keep input loudness range above loudness range target.
Can be used as an alternative to \`--keep-loudness-range-target\` to allow for linear normalization.
]"
  {-tp,--true-peak}"[EBU Maximum True Peak in dBTP (default\: -2.0).
Range is -9.0 - \+0.0.
]:true_peak:"
  "--offset[EBU Offset Gain (default\: 0.0).
The gain is applied before the true-peak limiter in the first pass only.
The offset for the second pass will be automatically determined based on the first pass statistics.
Range is -99.0 - \+99.0.
]:offset:"
  "--lower-only[Whether the audio should not increase in loudness.

If the measured loudness from the first pass is lower than the target
loudness then normalization will be skipped for the audio source.

For EBU normalization, this compares input integrated loudness to the target level.
For peak normalization, this compares the input peak level to the target level.
For RMS normalization, this compares the input RMS level to the target level.
]"
  "--auto-lower-loudness-target[Automatically lower EBU Integrated Loudness Target to prevent falling
back to dynamic filtering.

Makes sure target loudness is lower than measured loudness minus peak
loudness (input_i - input_tp) by a small amount (0.1 LUFS).
]"
  "--dual-mono[Treat mono input files as \"dual-mono\".

If a mono file is intended for playback on a stereo system, its EBU R128
measurement will be perceptually incorrect. If set, this option will
compensate for this effect. Multi-channel input files are not affected
by this option.
]"
  "--dynamic[Force dynamic normalization mode.

Instead of applying linear EBU R128 normalization, choose a dynamic
normalization. This is not usually recommended.

Dynamic mode will automatically change the sample rate to 192 kHz. Use
-ar\/--sample-rate to specify a different output sample rate.
]"
  {-as,--audio-streams}"[Select specific audio streams to normalize by stream index (comma-separated).
Example\: --audio-streams 0,2 will normalize only streams 0 and 2.

By default, all audio streams are normalized.
]:audio_streams:"
  "--audio-default-only[Only normalize audio streams with the \'default\' disposition flag.
This is useful for files with multiple audio tracks where only the main track
should be normalized (e.g., keeping commentary tracks unchanged).
]"
  "--keep-other-audio[Keep non-selected audio streams in the output file (copy without normalization).
Only applies when --audio-streams or --audio-default-only is used.

By default, only selected streams are included in the output.
]"
  {-c:a,--audio-codec}"[Audio codec to use for output files.
See \`ffmpeg -encoders\` for a list.

Will use PCM audio with input stream bit depth by default.
]:audio_codec:"
  {-b:a,--audio-bitrate}"[Audio bitrate in bits\/s, or with K suffix.

If not specified, will use codec default.
]:audio_bitrate:"
  {-ar,--sample-rate}"[Audio sample rate to use for output files in Hz.

Will use input sample rate by default, except for EBU normalization,
which will change the input sample rate to 192 kHz.
]:sample_rate:"
  {-ac,--audio-channels}"[Set the number of audio channels.
If not specified, the input channel layout will be used.
]:audio_channels:"
  {-koa,--keep-original-audio}"[Copy original, non-normalized audio streams to output file]"
  {-prf,--pre-filter}"[Add an audio filter chain before applying normalization.
Multiple filters can be specified by comma-separating them.
]:pre_filter:"
  {-pof,--post-filter}"[Add an audio filter chain after applying normalization.
Multiple filters can be specified by comma-separating them.

For EBU, the filter will be applied during the second pass.
]:post_filter:"
  {-vn,--video-disable}"[Do not write video streams to output]"
  {-c:v,--video-codec}"[Video codec to use for output files (default\: \'copy\').
See \`ffmpeg -encoders\` for a list.

Will attempt to copy video codec by default.
]:video_codec:"
  {-sn,--subtitle-disable}"[Do not write subtitle streams to output]"
  {-mn,--metadata-disable}"[Do not write metadata to output]"
  {-cn,--chapters-disable}"[Do not write chapters to output]"
  {-ei,--extra-input-options}"[Extra input options list.

A list of extra ffmpeg command line arguments valid for the input,
applied before ffmpeg\'s \`-i\`.

You can either use a JSON-formatted list (i.e., a list of
comma-separated, quoted elements within square brackets), or a simple
string of space-separated arguments.

If JSON is used, you need to wrap the whole argument in quotes to
prevent shell expansion and to preserve literal quotes inside the
string. If a simple string is used, you need to specify the argument
with \`-e\=\`.

Examples\: \`-e \'\[ \"-f\", \"mpegts\" \]\'\` or \`-e\=\"-f mpegts\"\`
]:extra_input_options:"
  {-e,--extra-output-options}"[Extra output options list.

A list of extra ffmpeg command line arguments.

You can either use a JSON-formatted list (i.e., a list of
comma-separated, quoted elements within square brackets), or a simple
string of space-separated arguments.

If JSON is used, you need to wrap the whole argument in quotes to
prevent shell expansion and to preserve literal quotes inside the
string. If a simple string is used, you need to specify the argument
with \`-e\=\`.

Examples\: \`-e \'\[ \"-vbr\", \"3\" \]\'\` or \`-e\=\"-vbr 3\"\`
]:extra_output_options:"
  {-ofmt,--output-format}"[Media format to use for output file(s).
See \'ffmpeg -formats\' for a list.

If not specified, the format will be inferred by ffmpeg from the output
file name. If the output file name is not explicitly specified, the
extension will govern the format (see \'--extension\' option).
]:output_format:"
  {-ext,--extension}"[Output file extension to use for output files that were not explicitly
specified. (Default\: \`mkv\`)
]:extension:"
  "(*)::Input media file(s):"
)


_shtab_ffmpeg_normalize() {
  local context state line curcontext="$curcontext" one_or_more='(-)*' remainder='(*)'

  if ((${_shtab_ffmpeg_normalize_options[(I)${(q)one_or_more}*]} + ${_shtab_ffmpeg_normalize_options[(I)${(q)remainder}*]} == 0)); then  # noqa: E501
    _shtab_ffmpeg_normalize_options+=(': :_shtab_ffmpeg_normalize_commands' '*::: :->ffmpeg-normalize')
  fi
  _arguments -C -s $_shtab_ffmpeg_normalize_options

  case $state in
    ffmpeg-normalize)
      words=($line[1] "${words[@]}")
      (( CURRENT += 1 ))
      curcontext="${curcontext%:*:*}:_shtab_ffmpeg_normalize-$line[1]:"
      case $line[1] in
        
      esac
  esac
}



typeset -A opt_args

if [[ $zsh_eval_context[-1] == eval ]]; then
  # eval/source/. command, register function for later
  compdef _shtab_ffmpeg_normalize -N ffmpeg-normalize
else
  # autoload from fpath, call function directly
  _shtab_ffmpeg_normalize "$@"
fi

