#include "prusaparts.hpp"

const TestData PRUSA_PART_POLYGONS =
{
    {
        {-5000000, 8954050},
        {5000000, 8954050},
        {5000000, -45949},
        {4972609, -568550},
        {3500000, -8954050},
        {-3500000, -8954050},
        {-4972609, -568550},
        {-5000000, -45949},
        {-5000000, 8954050},
    },
    {
        {-63750000, -8000000},
        {-54750000, 46000000},
        {50750000, 46000000},
        {63750000, 33000000},
        {63750000, -46000000},
        {-54750000, -46000000},
        {-63750000, -28000000},
        {-63750000, -8000000},
    },
    {
        {-52750000, 41512348},
        {-31250000, 45987651},
        {52750000, 45987651},
        {52750000, -45987651},
        {-52750000, -45987651},
        {-52750000, 41512348},
    },
    {
        {-3900000, 14000000},
        {-2167950, 14000000},
        {1721454, 7263400},
        {3828529, 3613790},
        {3838809, 3582149},
        {3871560, 3270569},
        {3900000, 3000000},
        {3500000, -3000000},
        {3471560, -3270565},
        {3447549, -3498986},
        {3292510, -3976167},
        {3099999, -4512949},
        {2530129, -5500000},
        {807565, -8483570},
        {-2377349, -14000000},
        {-3900000, -14000000},
        {-3900000, 14000000},
    },
    {
        {-31750000, -1000000},
        {-25250000, 40500000},
        {-18250000, 47500000},
        {10750000, 47500000},
        {16750000, 41500000},
        {31750000, -37000000},
        {31750000, -43857898},
        {28107900, -47500000},
        {18392099, -47500000},
        {-20750000, -46500000},
        {-31750000, -4000000},
        {-31750000, -1000000},
    },
    {
        {-34625000, -14265399},
        {-10924999, 24875000},
        {33325000, 24875000},
        {37575000, 20625000},
        {37575000, 17625000},
        {26575000, -24875000},
        {-8924999, -24875000},
        {-34625000, -24484600},
        {-37575000, -19375000},
        {-34625000, -14265399},
    },
    {
        {-14000000, 9000000},
        {-11000000, 17000000},
        {14000000, 17000000},
        {14000000, -17000000},
        {-11000000, -17000000},
        {-14000000, -8000000},
        {-14000000, 9000000},
    },
    {
        {-5300000, 2227401},
        {-237800, 5150001},
        {5299999, 5150001},
        {5299999, 650001},
        {4699999, -5149997},
        {-5300000, -5149997},
        {-5300000, 2227401},
    },
    {
        {-12000000, 18000000},
        {12000000, 18000000},
        {12000000, -18000000},
        {-12000000, -18000000},
        {-12000000, 18000000},
    },
    {
        {-18000000, -1000000},
        {-15000000, 22000000},
        {-11000000, 26000000},
        {11000000, 26000000},
        {15000000, 22000000},
        {18000000, -1000000},
        {18000000, -26000000},
        {-18000000, -26000000},
        {-18000000, -1000000},
    },
    {
        {-77500000, 30000000},
        {-72500000, 35000000},
        {72500000, 35000000},
        {77500000, 30000000},
        {77500000, -32928901},
        {75428901, -35000000},
        {-75428901, -35000000},
        {-77500000, -32928901},
        {-77500000, 30000000},
    },
    {
        {-9945219, -3065619},
        {-9781479, -2031780},
        {-9510560, -1020730},
        {-9135450, -43529},
        {-2099999, 14110899},
        {2099999, 14110899},
        {9135450, -43529},
        {9510560, -1020730},
        {9781479, -2031780},
        {9945219, -3065619},
        {10000000, -4110899},
        {9945219, -5156179},
        {9781479, -6190019},
        {9510560, -7201069},
        {9135450, -8178270},
        {8660249, -9110899},
        {8090169, -9988750},
        {7431449, -10802209},
        {6691309, -11542349},
        {5877850, -12201069},
        {5000000, -12771149},
        {4067369, -13246350},
        {3090169, -13621459},
        {2079119, -13892379},
        {1045279, -14056119},
        {0, -14110899},
        {-1045279, -14056119},
        {-2079119, -13892379},
        {-3090169, -13621459},
        {-4067369, -13246350},
        {-5000000, -12771149},
        {-5877850, -12201069},
        {-6691309, -11542349},
        {-7431449, -10802209},
        {-8090169, -9988750},
        {-8660249, -9110899},
        {-9135450, -8178270},
        {-9510560, -7201069},
        {-9781479, -6190019},
        {-9945219, -5156179},
        {-10000000, -4110899},
        {-9945219, -3065619},
    },
    {
        {-34192394, -5192389},
        {-31499996, 39000000},
        {-8183795, 47668998},
        {-6769596, 47668998},
        {-4648197, 45547698},
        {34192394, 6707109},
        {34192394, 5192389},
        {31500003, -39000000},
        {8183803, -47668998},
        {6769603, -47668998},
        {4648202, -45547698},
        {-32474895, -8424619},
        {-34192394, -6707109},
        {-34192394, -5192389},
    },
    {
        {-23475500, -11910099},
        {-18000000, 8217699},
        {-11139699, 20100000},
        {-10271400, 20899999},
        {9532010, 20899999},
        {11199999, 20100000},
        {18500000, 8600000},
        {23475500, -11910099},
        {23799999, -14899999},
        {23706600, -15788900},
        {23668899, -16147499},
        {23281299, -17340400},
        {22654100, -18426700},
        {21814800, -19358900},
        {20799999, -20096199},
        {19654100, -20606300},
        {18427200, -20867099},
        {17799999, -20899999},
        {-17799999, -20899999},
        {-18427200, -20867099},
        {-19654100, -20606300},
        {-20799999, -20096199},
        {-21814800, -19358900},
        {-22654100, -18426700},
        {-23281299, -17340400},
        {-23668899, -16147499},
        {-23799999, -14899999},
        {-23475500, -11910099},
    },
    {
        {-32000000, 10000000},
        {-31934440, 10623733},
        {-31740640, 11220210},
        {-31427049, 11763360},
        {-31007389, 12229430},
        {-30500000, 12598079},
        {-29927051, 12853170},
        {-29313585, 12983570},
        {16000000, 16000000},
        {26000000, 16000000},
        {31007400, 12229430},
        {31427101, 11763360},
        {31740600, 11220210},
        {31934398, 10623733},
        {32000000, 10000000},
        {32000000, -13000000},
        {31934398, -13623699},
        {31740600, -14220199},
        {31427101, -14763399},
        {31007400, -15229400},
        {30500000, -15598100},
        {29927101, -15853200},
        {29313598, -15983600},
        {29000000, -16000000},
        {-28000000, -16000000},
        {-29313585, -15983600},
        {-29927051, -15853200},
        {-30500000, -15598100},
        {-31007389, -15229400},
        {-31427049, -14763399},
        {-31740640, -14220199},
        {-31934440, -13623699},
        {-32000000, -13000000},
        {-32000000, 10000000},
    },
    {
        {-36133789, -46431022},
        {-36040100, -46171817},
        {-35852722, -45653411},
        {2200073, 59616485},
        {12112792, 87039184},
        {14274505, 93019332},
        {14382049, 93291641},
        {14508483, 93563430},
        {14573425, 93688369},
        {14654052, 93832443},
        {14818634, 94096328},
        {14982757, 94327621},
        {15001708, 94352630},
        {15202392, 94598999},
        {15419342, 94833160},
        {15497497, 94910552},
        {15650848, 95053039},
        {15894866, 95256866},
        {16104309, 95412185},
        {16149047, 95443206},
        {16410888, 95611038},
        {16677795, 95759750},
        {16782348, 95812332},
        {16947143, 95889144},
        {17216400, 95999465},
        {17483123, 96091293},
        {17505554, 96098251},
        {17745178, 96165542},
        {18000671, 96223373},
        {18245880, 96265884},
        {18484039, 96295257},
        {18976715, 96319580},
        {31135131, 96319580},
        {31697082, 96287902},
        {31746368, 96282104},
        {32263000, 96190719},
        {32338623, 96172576},
        {32821411, 96026641},
        {32906188, 95995391},
        {33360565, 95797012},
        {33443420, 95754882},
        {33869171, 95505874},
        {33900756, 95485122},
        {34136413, 95318618},
        {34337127, 95159790},
        {34377288, 95125930},
        {34619628, 94905410},
        {34756286, 94767364},
        {34859008, 94656143},
        {35090606, 94378067},
        {35120849, 94338546},
        {35309295, 94072113},
        {35434875, 93871475},
        {35510070, 93740310},
        {35688232, 93385772},
        {35699096, 93361679},
        {35839782, 93012557},
        {35905487, 92817459},
        {35961578, 92625488},
        {36048004, 92249023},
        {36051574, 92229934},
        {36108856, 91831405},
        {36122985, 91667816},
        {36133789, 91435317},
        {36129669, 91085830},
        {36127685, 91046661},
        {36092742, 90669830},
        {36069946, 90514739},
        {36031829, 90308425},
        {35948211, 89965225},
        {34482635, 84756820},
        {27911407, 61403976},
        {-5872558, -58657440},
        {-14243621, -88406509},
        {-14576812, -89590599},
        {-15421997, -92594200},
        {-15657684, -93431732},
        {-16038940, -93720520},
        {-16420196, -94009307},
        {-17182708, -94586875},
        {-18834838, -95838272},
        {-19470275, -96319580},
        {-21368133, -96319580},
        {-22763854, -96319534},
        {-29742462, -96319274},
        {-32533935, -96319168},
        {-36133789, -54619018},
        {-36133789, -46431022},
    },
    {
        {-26000000, 25500000},
        {-6500000, 45000000},
        {17499998, 45000000},
        {23966310, 38533699},
        {26000000, 36500000},
        {26000000, -19000000},
        {25950000, -24500000},
        {17000000, -42214698},
        {14300000, -45000000},
        {-14299999, -45000000},
        {-17500000, -41714698},
        {-23400001, -24500000},
        {-26000000, -10464000},
        {-26000000, 25500000},
    },
    {
        {-26000000, 16636100},
        {-25072200, 18777799},
        {-16500000, 35299999},
        {-15050000, 36750000},
        {13550000, 36750000},
        {15000000, 35299999},
        {26000000, 16045200},
        {26000000, -2750000},
        {16500000, -34507900},
        {14840600, -36167301},
        {14257900, -36750000},
        {-14257900, -36750000},
        {-16500000, -34507900},
        {-26000000, -2750000},
        {-26000000, 16636100},
    },
    {
        {-18062349, 18950099},
        {4644938, 20049900},
        {6230361, 20049900},
        {7803279, 19851200},
        {9338899, 19456899},
        {10812990, 18873300},
        {12202310, 18109500},
        {13484951, 17177600},
        {14640670, 16092300},
        {15651250, 14870700},
        {16500749, 13532100},
        {17175849, 12097599},
        {17665750, 10589700},
        {17962850, 9032400},
        {18062349, 7450099},
        {17962850, 5867799},
        {15810750, -11007740},
        {15683750, -11727769},
        {15506849, -12437200},
        {15280929, -13132559},
        {15007040, -13810470},
        {14686531, -14467609},
        {14320949, -15100799},
        {13912099, -15706950},
        {13461959, -16283100},
        {12972730, -16826450},
        {12446790, -17334339},
        {11886699, -17804309},
        {11295190, -18234069},
        {10675149, -18621520},
        {10029590, -18964771},
        {9361650, -19262149},
        {8674600, -19512220},
        {7971780, -19713699},
        {7256609, -19865798},
        {6532589, -19967498},
        {5803222, -20018501},
        {5437650, -20024900},
        {-1062349, -20049900},
        {-16562349, -20049900},
        {-18062349, -18549900},
        {-18062349, 18950099},
    },
    {
        {-18062349, 41299900},
        {-1062349, 41299900},
        {15280929, -8117440},
        {15506849, -8812799},
        {15683750, -9522230},
        {15810750, -10242259},
        {17962850, -27117799},
        {18062349, -28700099},
        {17962850, -30282400},
        {17665750, -31839700},
        {17175849, -33347599},
        {16500749, -34782100},
        {15651250, -36120700},
        {14640670, -37342300},
        {13484951, -38427600},
        {12202310, -39359500},
        {10812990, -40123298},
        {9338899, -40706901},
        {7803279, -41101200},
        {6230361, -41299900},
        {4644938, -41299900},
        {-18062349, -40200099},
        {-18062349, 41299900},
    },
    {
        {-11750000, 13057900},
        {-9807860, 15000000},
        {4392139, 24000000},
        {11750000, 24000000},
        {11750000, -24000000},
        {4392139, -24000000},
        {-9807860, -15000000},
        {-11750000, -13057900},
        {-11750000, 13057900},
    },
    {
        {-12500000, 17500000},
        {12500000, 17500000},
        {12500000, -17500000},
        {-12500000, -17500000},
        {-12500000, 17500000},
    },
    {
        {-23500000, 11500000},
        {-13857859, 21000000},
        {-11000000, 21000000},
        {18500000, 500000},
        {23500000, -4500000},
        {23500000, -19500000},
        {22000000, -21000000},
        {-23500000, -21000000},
        {-23500000, 11500000},
    },
    {
        {-13000000, 5250000},
        {-4000000, 6750000},
        {4000000, 6750000},
        {13000000, 5250000},
        {13000000, 838459},
        {11376299, -1973939},
        {10350899, -3750000},
        {8618800, -6750000},
        {-8498290, -6750000},
        {-13000000, 1047180},
        {-13000000, 5250000},
    },
    {
        {-25000000, 50500000},
        {-21500000, 54000000},
        {18286800, 54000000},
        {25000000, 47286800},
        {25000000, -47286800},
        {18286800, -54000000},
        {-21500000, -54000000},
        {-25000000, -50500000},
        {-25000000, 50500000},
    },
    {
        {-19000000, 46000000},
        {-16799999, 46000000},
        {14000000, 34000000},
        {19000000, 29000000},
        {19000000, -29000000},
        {14000000, -34000000},
        {-16799999, -46000000},
        {-19000000, -46000000},
        {-19000000, 46000000},
    },
    {
        {-7956170, 836226},
        {-7825180, 1663290},
        {-7767529, 1914530},
        {-7608449, 2472140},
        {-7308360, 3253890},
        {-7083650, 3717780},
        {-6928199, 4000000},
        {-6472139, 4702280},
        {-5988090, 5304979},
        {-5945159, 5353040},
        {-5353040, 5945159},
        {-4702280, 6472139},
        {-4544519, 6583869},
        {-4000000, 6928199},
        {-3253890, 7308360},
        {-2836839, 7480130},
        {-2472140, 7608449},
        {-1663290, 7825180},
        {-964293, 7941669},
        {-836226, 7956170},
        {0, 8000000},
        {836226, 7956170},
        {964293, 7941669},
        {1663290, 7825180},
        {2472140, 7608449},
        {2836839, 7480130},
        {3253890, 7308360},
        {4000000, 6928199},
        {4544519, 6583869},
        {4702280, 6472139},
        {5353040, 5945159},
        {5945159, 5353040},
        {5988090, 5304979},
        {6472139, 4702280},
        {6928199, 4000000},
        {7083650, 3717780},
        {7308360, 3253890},
        {7608449, 2472140},
        {7767529, 1914530},
        {7825180, 1663290},
        {7956170, 836226},
        {8000000, 0},
        {7956170, -836226},
        {7825180, -1663290},
        {7767529, -1914530},
        {7608449, -2472140},
        {7308360, -3253890},
        {7083650, -3717780},
        {6928199, -4000000},
        {6472139, -4702280},
        {5988090, -5304979},
        {5945159, -5353040},
        {5353040, -5945159},
        {4702280, -6472139},
        {4544519, -6583869},
        {4000000, -6928199},
        {3253890, -7308360},
        {2836839, -7480130},
        {2472140, -7608449},
        {1663290, -7825180},
        {964293, -7941669},
        {836226, -7956170},
        {0, -8000000},
        {-836226, -7956170},
        {-964293, -7941669},
        {-1663290, -7825180},
        {-2472140, -7608449},
        {-2836839, -7480130},
        {-3253890, -7308360},
        {-4000000, -6928199},
        {-4544519, -6583869},
        {-4702280, -6472139},
        {-5353040, -5945159},
        {-5945159, -5353040},
        {-5988090, -5304979},
        {-6472139, -4702280},
        {-6928199, -4000000},
        {-7083650, -3717780},
        {-7308360, -3253890},
        {-7608449, -2472140},
        {-7767529, -1914530},
        {-7825180, -1663290},
        {-7956170, -836226},
        {-8000000, 0},
        {-7956170, 836226},
    },
};

const TestData PRUSA_STEGOSAUR_POLYGONS =
{
    {
        {113210205, 107034095},
        {113561798, 109153793},
        {113750099, 109914001},
        {114396499, 111040199},
        {114599197, 111321998},
        {115570404, 112657096},
        {116920097, 114166595},
        {117630599, 114609390},
        {119703704, 115583900},
        {120559494, 115811996},
        {121045410, 115754493},
        {122698097, 115526496},
        {123373001, 115370193},
        {123482406, 115315689},
        {125664199, 114129798},
        {125920303, 113968193},
        {128551208, 111866195},
        {129075592, 111443199},
        {135044692, 106572608},
        {135254898, 106347694},
        {135415100, 106102897},
        {136121704, 103779891},
        {136325103, 103086303},
        {136690093, 101284896},
        {136798309, 97568496},
        {136798309, 97470397},
        {136787399, 97375297},
        {136753295, 97272102},
        {136687988, 97158699},
        {136539794, 96946899},
        {135526702, 95550994},
        {135388488, 95382293},
        {135272491, 95279098},
        {135214904, 95250595},
        {135122894, 95218002},
        {134966705, 95165191},
        {131753997, 94380798},
        {131226806, 94331001},
        {129603393, 94193893},
        {129224197, 94188003},
        {127874107, 94215103},
        {126812797, 94690200},
        {126558197, 94813896},
        {118361801, 99824195},
        {116550796, 101078796},
        {116189704, 101380493},
        {114634002, 103027999},
        {114118103, 103820297},
        {113399200, 105568000},
        {113201705, 106093597},
        {113210205, 107034095},
    },
    {
        {77917999, 130563003},
        {77926300, 131300903},
        {77990196, 132392700},
        {78144195, 133328002},
        {78170593, 133427093},
        {78235900, 133657592},
        {78799598, 135466705},
        {78933296, 135832397},
        {79112899, 136247604},
        {79336303, 136670898},
        {79585197, 137080596},
        {79726303, 137309005},
        {79820297, 137431900},
        {79942199, 137549407},
        {90329193, 145990203},
        {90460197, 146094390},
        {90606399, 146184509},
        {90715194, 146230010},
        {90919601, 146267211},
        {142335296, 153077697},
        {143460296, 153153594},
        {143976593, 153182189},
        {145403991, 153148605},
        {145562301, 153131195},
        {145705993, 153102905},
        {145938796, 153053192},
        {146134094, 153010101},
        {146483184, 152920196},
        {146904693, 152806396},
        {147180099, 152670196},
        {147357788, 152581695},
        {147615295, 152423095},
        {147782287, 152294708},
        {149281799, 150908386},
        {149405303, 150784912},
        {166569305, 126952499},
        {166784301, 126638099},
        {166938491, 126393699},
        {167030899, 126245101},
        {167173004, 126015899},
        {167415298, 125607200},
        {167468292, 125504699},
        {167553100, 125320899},
        {167584594, 125250694},
        {167684997, 125004394},
        {167807098, 124672401},
        {167938995, 124255203},
        {168052307, 123694000},
        {170094100, 112846900},
        {170118408, 112684204},
        {172079101, 88437797},
        {172082000, 88294403},
        {171916290, 82827606},
        {171911590, 82705703},
        {171874893, 82641906},
        {169867004, 79529907},
        {155996795, 58147998},
        {155904998, 58066299},
        {155864791, 58054199},
        {134315704, 56830902},
        {134086486, 56817901},
        {98200096, 56817798},
        {97838195, 56818599},
        {79401695, 56865097},
        {79291297, 56865501},
        {79180694, 56869499},
        {79058799, 56885097},
        {78937301, 56965301},
        {78324691, 57374599},
        {77932998, 57638401},
        {77917999, 57764297},
        {77917999, 130563003},
    },
    {
        {75566848, 109289947},
        {75592651, 109421951},
        {75644248, 109534446},
        {95210548, 141223846},
        {95262649, 141307449},
        {95487854, 141401443},
        {95910850, 141511642},
        {96105651, 141550338},
        {106015045, 142803451},
        {106142852, 142815155},
        {166897460, 139500244},
        {167019348, 139484741},
        {168008239, 138823043},
        {168137542, 138735153},
        {168156250, 138616851},
        {173160751, 98882049},
        {174381546, 87916046},
        {174412246, 87579048},
        {174429443, 86988746},
        {174436141, 86297348},
        {174438949, 84912048},
        {174262939, 80999145},
        {174172546, 80477546},
        {173847549, 79140846},
        {173623840, 78294349},
        {173120239, 76485046},
        {173067138, 76300544},
        {173017852, 76137542},
        {172941543, 75903045},
        {172892547, 75753143},
        {172813537, 75533348},
        {172758453, 75387046},
        {172307556, 74196746},
        {171926544, 73192848},
        {171891448, 73100448},
        {171672546, 72524147},
        {171502441, 72085144},
        {171414459, 71859146},
        {171294250, 71552352},
        {171080139, 71019744},
        {171039245, 70928146},
        {170970550, 70813346},
        {170904235, 70704040},
        {170786254, 70524353},
        {168063247, 67259048},
        {167989547, 67184844},
        {83427947, 67184844},
        {78360847, 67201248},
        {78238845, 67220550},
        {78151550, 67350547},
        {77574554, 68220550},
        {77494949, 68342651},
        {77479949, 68464546},
        {75648345, 106513351},
        {75561050, 109165740},
        {75566848, 109289947},
    },
    {
        {75619415, 108041595},
        {83609863, 134885772},
        {83806945, 135450820},
        {83943908, 135727371},
        {84799934, 137289794},
        {86547897, 140033782},
        {86674118, 140192962},
        {86810661, 140364715},
        {87045211, 140619918},
        {88187042, 141853240},
        {93924575, 147393783},
        {94058013, 147454803},
        {111640083, 153754562},
        {111762550, 153787933},
        {111975250, 153835311},
        {112127426, 153842803},
        {116797996, 154005157},
        {116969688, 154010681},
        {117141731, 154005935},
        {117333145, 153988037},
        {118007507, 153919952},
        {118159675, 153902130},
        {118931480, 153771942},
        {120878150, 153379089},
        {121172164, 153319259},
        {122074508, 153034362},
        {122260681, 152970367},
        {122313438, 152949584},
        {130755096, 149423736},
        {130996063, 149316818},
        {138893524, 144469665},
        {138896423, 144466918},
        {169883666, 97686134},
        {170115036, 96518981},
        {170144317, 96365257},
        {174395645, 67672065},
        {174396560, 67664222},
        {174288452, 66839241},
        {174170364, 66096923},
        {174112731, 65952033},
        {174021377, 65823486},
        {173948608, 65743225},
        {173863830, 65654769},
        {170408340, 63627494},
        {170004867, 63394714},
        {169585632, 63194389},
        {169441162, 63137046},
        {168944274, 62952133},
        {160605072, 60214218},
        {160331573, 60126396},
        {159674743, 59916877},
        {150337249, 56943778},
        {150267730, 56922073},
        {150080139, 56864868},
        {149435333, 56676422},
        {149310241, 56640579},
        {148055419, 56285041},
        {147828796, 56230949},
        {147598205, 56181800},
        {147149963, 56093917},
        {146834457, 56044700},
        {146727966, 56028717},
        {146519729, 56004882},
        {146328521, 55989326},
        {146170684, 55990036},
        {146151321, 55990745},
        {145800170, 56003616},
        {145639526, 56017753},
        {145599426, 56022491},
        {145481338, 56039184},
        {145389556, 56052757},
        {145325134, 56062591},
        {145176574, 56086135},
        {145017272, 56113922},
        {107163085, 63504539},
        {101013870, 65454101},
        {100921798, 65535285},
        {95362182, 74174079},
        {75652366, 107803443},
        {75635391, 107834983},
        {75628814, 107853294},
        {75603431, 107933692},
        {75619415, 108041595},
    },
    {
        {83617141, 120264900},
        {84617370, 126416427},
        {84648635, 126601341},
        {84693695, 126816085},
        {84762496, 127082641},
        {84772140, 127117034},
        {84860748, 127391693},
        {84927398, 127550239},
        {85072967, 127789642},
        {85155151, 127908851},
        {86745422, 130042907},
        {86982666, 130317489},
        {89975143, 133230743},
        {90091384, 133338500},
        {96260833, 138719818},
        {96713928, 139103668},
        {98139297, 140307388},
        {102104766, 143511505},
        {102142089, 143536468},
        {102457626, 143735107},
        {103386764, 144312988},
        {103845001, 144579177},
        {104139175, 144737136},
        {104551254, 144932250},
        {104690155, 144985778},
        {104844238, 145010009},
        {105020034, 145010375},
        {128999633, 144082305},
        {129096542, 144076141},
        {133932327, 143370178},
        {134130615, 143326751},
        {134281250, 143289520},
        {135247116, 142993438},
        {150774948, 137828704},
        {150893478, 137786178},
        {151350921, 137608901},
        {159797760, 134318115},
        {159979827, 134244384},
        {159988128, 134240997},
        {160035186, 134221633},
        {160054962, 134211486},
        {160168762, 134132736},
        {160181228, 134121047},
        {160336425, 133961502},
        {160689147, 133564331},
        {161446258, 132710739},
        {163306427, 130611648},
        {164845474, 128873855},
        {165270233, 128393600},
        {165281478, 128380706},
        {165300598, 128358673},
        {165303497, 128355194},
        {166411590, 122772674},
        {166423767, 122708648},
        {164745605, 66237312},
        {164740341, 66193061},
        {164721755, 66082092},
        {164721160, 66078750},
        {164688476, 65914146},
        {164668426, 65859436},
        {164563110, 65765937},
        {164431152, 65715034},
        {163997619, 65550788},
        {163946426, 65531440},
        {162998107, 65173629},
        {162664978, 65049140},
        {162482696, 64991668},
        {162464660, 64989639},
        {148029083, 66896141},
        {147862396, 66932853},
        {130087829, 73341102},
        {129791564, 73469726},
        {100590927, 90307685},
        {100483535, 90373847},
        {100364990, 90458930},
        {96447448, 93276664},
        {95179656, 94189010},
        {93692718, 95260208},
        {87904327, 99430885},
        {87663711, 99606147},
        {87576202, 99683990},
        {87498199, 99801719},
        {85740264, 104173728},
        {85538925, 104710494},
        {84786132, 107265830},
        {84635955, 107801383},
        {84619506, 107868064},
        {84518463, 108287200},
        {84456848, 108613471},
        {84419158, 108826194},
        {84375244, 109093818},
        {84329818, 109435180},
        {84249862, 110179664},
        {84218429, 110572166},
        {83630020, 117995208},
        {83595535, 118787673},
        {83576217, 119290679},
        {83617141, 120264900},
    },
    {
        {91735549, 117640846},
        {91748252, 117958145},
        {91823547, 118515449},
        {92088752, 119477249},
        {97995346, 140538452},
        {98031051, 140660446},
        {98154449, 141060241},
        {98179855, 141133758},
        {98217056, 141232849},
        {98217147, 141233047},
        {98269256, 141337051},
        {98298950, 141387954},
        {98337753, 141445755},
        {99455047, 142984451},
        {99656250, 143247344},
        {102567855, 146783752},
        {102685150, 146906845},
        {102828948, 147031250},
        {102972457, 147120452},
        {103676147, 147539642},
        {103758956, 147586151},
        {103956756, 147682144},
        {104479949, 147931457},
        {104744453, 148044143},
        {104994750, 148123443},
        {105375648, 148158645},
        {109266250, 148178253},
        {109447753, 148169052},
        {109693649, 148129150},
        {113729949, 147337448},
        {113884552, 147303054},
        {115155349, 146956146},
        {117637145, 146174346},
        {154694046, 134048049},
        {156979949, 133128555},
        {157076843, 133059356},
        {157125045, 133001449},
        {157561340, 132300750},
        {157865753, 131795959},
        {157923156, 131667358},
        {158007049, 131297653},
        {158112747, 130777053},
        {158116653, 130640853},
        {158268951, 119981643},
        {158260040, 119824752},
        {158229949, 119563751},
        {149914047, 73458648},
        {149877548, 73331748},
        {144460754, 66413558},
        {144230545, 66153152},
        {144128051, 66075057},
        {143974853, 65973152},
        {142812744, 65353149},
        {141810943, 64837249},
        {141683349, 64805152},
        {141505157, 64784652},
        {108214355, 61896251},
        {107826354, 61866352},
        {107072151, 61821750},
        {106938850, 61873550},
        {106584251, 62055152},
        {106419952, 62147548},
        {100459152, 65546951},
        {100343849, 65615150},
        {100198852, 65716949},
        {99825149, 65979751},
        {94619247, 70330352},
        {94492355, 70480850},
        {94445846, 70547355},
        {94425354, 70588752},
        {94379753, 70687652},
        {94110252, 71443450},
        {94095252, 71569053},
        {91737251, 117308746},
        {91731048, 117430946},
        {91735549, 117640846},
    },
    {
        {108231399, 111763748},
        {108335403, 111927955},
        {108865203, 112754745},
        {109206703, 113283851},
        {127117500, 125545951},
        {127212097, 125560951},
        {127358497, 125563652},
        {131348007, 125551147},
        {131412002, 125550849},
        {131509506, 125535446},
        {131579391, 125431343},
        {132041000, 124735656},
        {132104690, 124637847},
        {144108505, 100950546},
        {144120605, 100853042},
        {144123291, 100764648},
        {144122695, 100475143},
        {144086898, 85637748},
        {144083602, 85549346},
        {144071105, 85451843},
        {144007003, 85354545},
        {143679595, 84864547},
        {143468597, 84551048},
        {143367889, 84539146},
        {109847702, 84436347},
        {109684700, 84458953},
        {105946502, 89406143},
        {105915901, 91160446},
        {105880905, 93187744},
        {105876701, 93441345},
        {108231399, 111763748},
    },
    {
        {102614700, 117684249},
        {102675102, 118074157},
        {102888999, 118743148},
        {103199707, 119517555},
        {103446800, 120099655},
        {103488204, 120193450},
        {104063903, 121373947},
        {104535499, 122192245},
        {104595802, 122295249},
        {104663002, 122402854},
        {104945701, 122854858},
        {105740501, 124038848},
        {106809700, 125479354},
        {107564399, 126380050},
        {108116203, 126975646},
        {123724700, 142516540},
        {124938400, 143705444},
        {127919601, 146599243},
        {128150894, 146821456},
        {128251602, 146917251},
        {128383605, 147041839},
        {128527709, 147176147},
        {128685699, 147321456},
        {128861007, 147481246},
        {132825103, 151046661},
        {133005493, 151205657},
        {133389007, 151488143},
        {133896499, 151858062},
        {134172302, 151991546},
        {134375000, 152063140},
        {135316101, 152300949},
        {136056304, 152220947},
        {136242706, 152186843},
        {136622207, 152016448},
        {136805404, 151908355},
        {147099594, 145766845},
        {147246704, 144900756},
        {147387603, 144048461},
        {144353698, 99345855},
        {144333801, 99232254},
        {144244598, 98812850},
        {144228698, 98757858},
        {144174606, 98616455},
        {133010101, 72396743},
        {132018905, 70280853},
        {130667404, 67536949},
        {129167297, 64854446},
        {128569198, 64098350},
        {124458503, 59135948},
        {124260597, 58946949},
        {123908706, 58658851},
        {123460098, 58327850},
        {122674499, 57840648},
        {122041801, 57712150},
        {121613403, 57699047},
        {121359901, 57749351},
        {121123199, 57826450},
        {120953498, 57882247},
        {120431701, 58198547},
        {120099205, 58599349},
        {119892303, 58903049},
        {102835296, 115179351},
        {102686599, 115817245},
        {102612396, 116540557},
        {102614700, 117684249},
    },
    {
        {98163757, 71203430},
        {98212463, 73314544},
        {98326538, 74432693},
        {98402908, 75169799},
        {98524154, 76328353},
        {99088806, 79911361},
        {99304885, 80947769},
        {100106689, 84244186},
        {100358123, 85080337},
        {101715545, 89252807},
        {101969528, 89987213},
        {107989440, 106391418},
        {126299575, 140277343},
        {127061813, 141486663},
        {127405746, 141872253},
        {127846908, 142318450},
        {130818496, 145301574},
        {134366424, 148100921},
        {135308380, 148798828},
        {135745666, 149117523},
        {136033020, 149251800},
        {136500579, 149387725},
        {136662719, 149418395},
        {136973922, 149474822},
        {137184890, 149484375},
        {137623748, 149434356},
        {137830810, 149355072},
        {138681732, 148971343},
        {139374465, 148463409},
        {139589187, 148264312},
        {139809707, 148010711},
        {139985610, 147685028},
        {140196029, 147284973},
        {140355834, 146978668},
        {142079666, 142575622},
        {146702194, 129469726},
        {151285888, 113275238},
        {151543731, 112046264},
        {151701629, 110884704},
        {151837020, 108986206},
        {151837097, 107724029},
        {151760101, 106529205},
        {151581970, 105441925},
        {151577301, 105413757},
        {151495269, 105014709},
        {151393142, 104551513},
        {151058502, 103296112},
        {150705520, 102477264},
        {150137725, 101686370},
        {149427032, 100938537},
        {102979965, 60772064},
        {101930953, 60515609},
        {101276748, 60634414},
        {100717803, 60918136},
        {100125732, 61584625},
        {99618148, 62413436},
        {99457214, 62709442},
        {99368347, 62914794},
        {99166992, 63728332},
        {98313827, 69634780},
        {98176910, 70615707},
        {98162902, 70798233},
        {98163757, 71203430},
    },
    {
        {79090698, 116426399},
        {80959800, 137087692},
        {81030303, 137762298},
        {81190704, 138903503},
        {81253700, 139084197},
        {81479301, 139544998},
        {81952003, 140118896},
        {82319900, 140523895},
        {82967803, 140993896},
        {83022903, 141032104},
        {83777900, 141493606},
        {84722099, 141849899},
        {84944396, 141887207},
        {86144699, 141915893},
        {87643997, 141938095},
        {88277503, 141887695},
        {88582099, 141840606},
        {89395401, 141712203},
        {90531204, 141528396},
        {91014801, 141438400},
        {92097595, 141190093},
        {123348297, 132876998},
        {123399505, 132860000},
        {123452804, 132841506},
        {123515502, 132818908},
        {123543800, 132806198},
        {124299598, 132437393},
        {124975502, 132042098},
        {125047500, 131992202},
        {125119506, 131930603},
        {166848800, 86317703},
        {168976409, 83524902},
        {169359603, 82932701},
        {169852600, 81917800},
        {170686904, 79771202},
        {170829406, 79245597},
        {170885498, 78796295},
        {170909301, 78531898},
        {170899703, 78238700},
        {170842803, 77553199},
        {170701293, 76723495},
        {170302307, 75753898},
        {169924301, 75067398},
        {169359802, 74578796},
        {168148605, 73757499},
        {163261596, 71124702},
        {162986007, 70977798},
        {162248703, 70599098},
        {158193405, 68923995},
        {157514297, 68667495},
        {156892700, 68495201},
        {156607299, 68432998},
        {154301895, 68061904},
        {93440299, 68061904},
        {88732002, 68255996},
        {88627304, 68298500},
        {88111396, 68541900},
        {86393898, 69555404},
        {86138298, 69706695},
        {85871704, 69913200},
        {85387199, 70393402},
        {79854499, 76783203},
        {79209701, 77649398},
        {79108505, 78072502},
        {79090698, 78472198},
        {79090698, 116426399},
    },
    {
        {90956314, 84639938},
        {91073814, 85141891},
        {91185752, 85505371},
        {109815368, 137196487},
        {110342590, 138349899},
        {110388549, 138447540},
        {110652862, 138971343},
        {110918045, 139341140},
        {114380859, 143159042},
        {114446723, 143220352},
        {114652198, 143392166},
        {114712196, 143437301},
        {114782165, 143476028},
        {114873054, 143514923},
        {115217086, 143660934},
        {115306060, 143695526},
        {115344009, 143707580},
        {115444541, 143737747},
        {115589378, 143779937},
        {115751358, 143823989},
        {115802780, 143825820},
        {116872810, 143753616},
        {116927055, 143744644},
        {154690734, 133504180},
        {155009704, 133371856},
        {155029907, 133360061},
        {155089141, 133323181},
        {155342315, 133163360},
        {155602294, 132941406},
        {155669158, 132880294},
        {155821624, 132737884},
        {155898986, 132656890},
        {155934936, 132608932},
        {155968627, 132562713},
        {156062896, 132431808},
        {156111694, 132363174},
        {156148147, 132297180},
        {158738342, 127281066},
        {159026672, 126378631},
        {159073699, 125806335},
        {159048522, 125299743},
        {159040313, 125192901},
        {158898300, 123934677},
        {149829376, 70241508},
        {149763031, 69910629},
        {149684692, 69628723},
        {149557800, 69206214},
        {149366485, 68864326},
        {149137390, 68578514},
        {148637466, 68048767},
        {147027725, 66632934},
        {146228607, 66257507},
        {146061309, 66184646},
        {146017929, 66174186},
        {145236465, 66269500},
        {144802490, 66345039},
        {144673995, 66376220},
        {93732284, 79649864},
        {93345336, 79785865},
        {93208084, 79840286},
        {92814521, 79997779},
        {92591087, 80098968},
        {92567016, 80110511},
        {92032684, 80860725},
        {91988853, 80930152},
        {91471725, 82210029},
        {91142349, 83076683},
        {90969284, 83653182},
        {90929664, 84043212},
        {90926315, 84325256},
        {90956314, 84639938},
    },
    {
        {114758499, 88719909},
        {114771591, 88860549},
        {115515533, 94195907},
        {115559539, 94383651},
        {119882980, 109502059},
        {120660522, 111909683},
        {126147735, 124949630},
        {127127212, 127107215},
        {129976379, 132117279},
        {130754470, 133257080},
        {130820968, 133340835},
        {130889312, 133423858},
        {131094787, 133652832},
        {131257629, 133828247},
        {131678619, 134164276},
        {131791107, 134248901},
        {131969482, 134335189},
        {132054107, 134373718},
        {132927368, 134701141},
        {133077072, 134749313},
        {133196075, 134785705},
        {133345230, 134804351},
        {133498809, 134809051},
        {133611541, 134797607},
        {134621170, 134565322},
        {134741165, 134527511},
        {134892089, 134465240},
        {135071212, 134353820},
        {135252029, 134185821},
        {135384979, 134003631},
        {135615585, 133576675},
        {135793029, 132859008},
        {135890228, 131382904},
        {135880828, 131261657},
        {135837570, 130787963},
        {135380661, 127428909},
        {132830596, 109495368},
        {132815826, 109411666},
        {132765869, 109199302},
        {132724380, 109068161},
        {127490066, 93353515},
        {125330810, 87852828},
        {125248336, 87647026},
        {125002182, 87088424},
        {124894592, 86872482},
        {121007278, 80019584},
        {120962829, 79941261},
        {120886489, 79833923},
        {120154983, 78949615},
        {119366561, 78111709},
        {119014755, 77776794},
        {116728790, 75636238},
        {116660522, 75593933},
        {116428192, 75458541},
        {116355255, 75416870},
        {116264663, 75372528},
        {115952728, 75233367},
        {115865554, 75205482},
        {115756835, 75190956},
        {115564163, 75197830},
        {115481170, 75202087},
        {115417144, 75230400},
        {115226959, 75337806},
        {115203842, 75351448},
        {114722015, 75746932},
        {114672103, 75795661},
        {114594619, 75891891},
        {114565811, 75973831},
        {114478256, 76240814},
        {114178039, 77252197},
        {114137664, 77769668},
        {114109771, 78154464},
        {114758499, 88719909},
    },
    {
        {108135070, 109828002},
        {108200347, 110091529},
        {108319419, 110298500},
        {108439025, 110488388},
        {108663574, 110766731},
        {108812957, 110935768},
        {109321914, 111398925},
        {109368087, 111430320},
        {109421295, 111466331},
        {110058998, 111849746},
        {127160308, 120588981},
        {127350692, 120683456},
        {128052749, 120997207},
        {128326919, 121113449},
        {131669586, 122213058},
        {131754745, 122240592},
        {131854583, 122264770},
        {132662048, 122449813},
        {132782669, 122449897},
        {132909118, 122443687},
        {133013442, 122436058},
        {140561035, 121609939},
        {140786346, 121583320},
        {140876144, 121570228},
        {140962356, 121547996},
        {141052612, 121517837},
        {141231292, 121442184},
        {141309371, 121390007},
        {141370132, 121327003},
        {141456008, 121219932},
        {141591598, 121045005},
        {141905761, 120634796},
        {141894607, 120305725},
        {141881881, 120110855},
        {141840881, 119885009},
        {141685043, 119238922},
        {141617416, 118962882},
        {141570434, 118858856},
        {131617462, 100598548},
        {131542846, 100487213},
        {131229385, 100089019},
        {131091476, 99928108},
        {119824127, 90297180},
        {119636337, 90142387},
        {119507492, 90037765},
        {119436744, 89983657},
        {119423942, 89974159},
        {119207366, 89822471},
        {119117149, 89767097},
        {119039489, 89726867},
        {116322929, 88522857},
        {114817031, 87882110},
        {114683975, 87826751},
        {114306411, 87728507},
        {113876434, 87646003},
        {113792106, 87629974},
        {113658988, 87615974},
        {113574333, 87609275},
        {112813575, 87550102},
        {112578567, 87560157},
        {112439880, 87571647},
        {112306922, 87599395},
        {112225082, 87622535},
        {112132568, 87667175},
        {112103477, 87682830},
        {110795242, 88511634},
        {110373565, 88847793},
        {110286537, 88934989},
        {109730873, 89531501},
        {109648735, 89628883},
        {109552581, 89768859},
        {109514228, 89838470},
        {109501640, 89877586},
        {109480964, 89941864},
        {109461761, 90032417},
        {109457778, 90055458},
        {108105194, 109452575},
        {108094238, 109620979},
        {108135070, 109828002},
    },
    {
        {108764694, 108910400},
        {108965499, 112306495},
        {109598602, 120388298},
        {110573898, 128289596},
        {110597801, 128427795},
        {113786201, 137983795},
        {113840301, 138134704},
        {113937202, 138326904},
        {114046005, 138520401},
        {114150802, 138696792},
        {114164703, 138717895},
        {114381896, 139021194},
        {114701004, 139425292},
        {114997398, 139747497},
        {115065597, 139805191},
        {115134498, 139850891},
        {115167098, 139871704},
        {115473396, 139992797},
        {115537498, 139995101},
        {116762596, 139832000},
        {116897499, 139808593},
        {118401802, 139225585},
        {118437500, 139209594},
        {118488204, 139182189},
        {118740097, 139033996},
        {118815795, 138967285},
        {134401000, 116395492},
        {134451507, 116309997},
        {135488098, 113593597},
        {137738006, 106775695},
        {140936492, 97033889},
        {140960006, 96948997},
        {141026504, 96660995},
        {141067291, 96467094},
        {141124893, 95771896},
        {141511795, 90171600},
        {141499801, 90026000},
        {141479598, 89907798},
        {141276794, 88844596},
        {141243804, 88707397},
        {140778305, 87031593},
        {140733306, 86871696},
        {140697204, 86789993},
        {140619796, 86708190},
        {140398391, 86487396},
        {125798797, 72806198},
        {125415802, 72454498},
        {123150398, 70566093},
        {123038803, 70503997},
        {122681198, 70305397},
        {121919204, 70104797},
        {121533699, 70008094},
        {121273696, 70004898},
        {121130599, 70020797},
        {121045097, 70033294},
        {120847099, 70082298},
        {120481895, 70278999},
        {120367004, 70379692},
        {120272796, 70475097},
        {119862098, 71004791},
        {119745101, 71167297},
        {119447799, 71726997},
        {119396499, 71825798},
        {119348701, 71944496},
        {109508796, 98298797},
        {109368598, 98700897},
        {109298400, 98926391},
        {108506301, 102750991},
        {108488197, 102879898},
        {108764694, 108910400},
    },
    {
        {106666252, 87231246},
        {106673248, 87358055},
        {107734146, 101975646},
        {107762649, 102357955},
        {108702445, 111208351},
        {108749450, 111345153},
        {108848350, 111542648},
        {110270645, 114264358},
        {110389648, 114445144},
        {138794845, 143461151},
        {139048355, 143648956},
        {139376144, 143885345},
        {139594451, 144022644},
        {139754043, 144110046},
        {139923950, 144185852},
        {140058242, 144234451},
        {140185653, 144259552},
        {140427551, 144292648},
        {141130950, 144281448},
        {141157653, 144278152},
        {141214355, 144266555},
        {141347457, 144223449},
        {141625350, 144098953},
        {141755142, 144040145},
        {141878143, 143971557},
        {142011444, 143858154},
        {142076843, 143796356},
        {142160644, 143691055},
        {142224456, 143560852},
        {142925842, 142090850},
        {142935653, 142065353},
        {142995956, 141899154},
        {143042556, 141719757},
        {143102951, 141436157},
        {143129257, 141230453},
        {143316055, 139447250},
        {143342544, 133704650},
        {143307556, 130890960},
        {142461257, 124025558},
        {141916046, 120671051},
        {141890457, 120526153},
        {140002349, 113455749},
        {139909149, 113144149},
        {139853454, 112974456},
        {137303756, 105228057},
        {134700546, 98161254},
        {134617950, 97961547},
        {133823547, 96118057},
        {133688751, 95837356},
        {133481353, 95448059},
        {133205444, 94948150},
        {131178955, 91529853},
        {131144744, 91482055},
        {113942047, 67481246},
        {113837051, 67360549},
        {113048950, 66601745},
        {112305549, 66002746},
        {112030853, 65790351},
        {111970649, 65767547},
        {111912445, 65755249},
        {111854248, 65743453},
        {111657447, 65716354},
        {111576950, 65707351},
        {111509750, 65708549},
        {111443550, 65718551},
        {111397247, 65737449},
        {111338546, 65764648},
        {111129547, 65863349},
        {111112449, 65871551},
        {110995254, 65927856},
        {110968849, 65946151},
        {110941444, 65966751},
        {110836448, 66057853},
        {110490447, 66445449},
        {110404144, 66576751},
        {106802055, 73202148},
        {106741950, 73384948},
        {106715454, 73469650},
        {106678054, 73627151},
        {106657455, 75433448},
        {106666252, 87231246},
    },
    {
        {101852752, 106261352},
        {101868949, 106406051},
        {102347549, 108974250},
        {112286750, 152027954},
        {112305648, 152106536},
        {112325752, 152175857},
        {112391448, 152290863},
        {113558250, 154187454},
        {113592048, 154226745},
        {113694351, 154313156},
        {113736549, 154335647},
        {113818145, 154367462},
        {114284454, 154490951},
        {114415847, 154504547},
        {114520751, 154489151},
        {114571350, 154478057},
        {114594551, 154472854},
        {114630546, 154463958},
        {114715148, 154429443},
        {146873657, 136143051},
        {146941741, 136074249},
        {147190155, 135763549},
        {147262649, 135654937},
        {147309951, 135557159},
        {147702255, 133903945},
        {147934143, 131616348},
        {147967041, 131273864},
        {148185852, 127892250},
        {148195648, 127669754},
        {148179656, 126409851},
        {148119552, 126182151},
        {147874053, 125334152},
        {147818954, 125150352},
        {146958557, 122656646},
        {139070251, 101025955},
        {139002655, 100879051},
        {119028450, 63067649},
        {118846649, 62740753},
        {115676048, 57814651},
        {115550453, 57629852},
        {115330352, 57319751},
        {115094749, 56998352},
        {114978347, 56847454},
        {114853050, 56740550},
        {114695053, 56609550},
        {114582252, 56528148},
        {114210449, 56375953},
        {113636245, 56214950},
        {113470352, 56171649},
        {109580749, 55503551},
        {109491645, 55495452},
        {109238754, 55511550},
        {109080352, 55534049},
        {108027748, 55687351},
        {107839950, 55732349},
        {107614456, 55834953},
        {107488143, 55925952},
        {107302551, 56062553},
        {107218353, 56145751},
        {107199447, 56167251},
        {107052749, 56354850},
        {106978652, 56476348},
        {106869644, 56710754},
        {104541351, 62448753},
        {104454551, 62672554},
        {104441253, 62707351},
        {104231750, 63366348},
        {104222648, 63419952},
        {104155746, 63922649},
        {104127349, 64147552},
        {104110847, 64299957},
        {102235450, 92366752},
        {101804351, 102877655},
        {101852752, 106261352},
    },
    {
        {106808700, 120885696},
        {106818695, 120923103},
        {106873901, 121057098},
        {115123603, 133614700},
        {115128799, 133619598},
        {115182197, 133661804},
        {115330101, 133740707},
        {115455398, 133799407},
        {115595001, 133836807},
        {115651000, 133851806},
        {116413604, 134055206},
        {116654495, 134097900},
        {116887603, 134075210},
        {117071098, 134040405},
        {117458801, 133904891},
        {118057998, 133572601},
        {118546997, 133261001},
        {118578498, 133239395},
        {118818603, 133011596},
        {121109695, 130501495},
        {122661598, 128760101},
        {142458190, 102765197},
        {142789001, 102099601},
        {143105010, 101386505},
        {143154800, 101239700},
        {143193908, 100825500},
        {143160507, 100282501},
        {143133499, 100083602},
        {143092697, 99880500},
        {143050689, 99766700},
        {142657501, 98974502},
        {142580307, 98855201},
        {122267196, 76269897},
        {122036399, 76105003},
        {121832000, 76028305},
        {121688796, 75983108},
        {121591598, 75955001},
        {121119697, 75902099},
        {120789596, 75953498},
        {120487495, 76041900},
        {120042701, 76365798},
        {119886695, 76507301},
        {119774200, 76635299},
        {119739097, 76686904},
        {119685195, 76798202},
        {119456199, 77320098},
        {106877601, 119561401},
        {106854797, 119645103},
        {106849098, 119668807},
        {106847099, 119699005},
        {106840400, 119801406},
        {106807800, 120719299},
        {106806098, 120862808},
        {106808700, 120885696},
    },
    {
        {99663352, 105328948},
        {99690048, 105797050},
        {99714050, 105921447},
        {99867248, 106439949},
        {100111557, 107256546},
        {104924850, 120873649},
        {105106155, 121284049},
        {105519149, 122184753},
        {105586051, 122292655},
        {105665054, 122400154},
        {106064147, 122838455},
        {106755355, 123453453},
        {106929054, 123577651},
        {107230346, 123771949},
        {107760650, 123930648},
        {108875854, 124205154},
        {108978752, 124228050},
        {131962051, 123738754},
        {135636047, 123513954},
        {135837249, 123500747},
        {136357345, 123442749},
        {136577346, 123394454},
        {136686645, 123367752},
        {137399353, 123185050},
        {137733947, 123063156},
        {137895355, 122997154},
        {138275650, 122829154},
        {138394256, 122767753},
        {138516845, 122670150},
        {139987045, 121111251},
        {149171646, 108517349},
        {149274353, 108372848},
        {149314758, 108314247},
        {149428848, 108140846},
        {149648651, 107650550},
        {149779541, 107290252},
        {149833343, 107115249},
        {149891357, 106920051},
        {150246353, 105630249},
        {150285842, 105423454},
        {150320953, 105233749},
        {150336639, 104981552},
        {150298049, 104374053},
        {150287948, 104271850},
        {150026153, 103481147},
        {149945449, 103301651},
        {149888946, 103213455},
        {149800949, 103103851},
        {149781143, 103079650},
        {149714141, 103005447},
        {149589950, 102914146},
        {149206054, 102698951},
        {128843856, 91378150},
        {128641754, 91283050},
        {119699851, 87248046},
        {117503555, 86311950},
        {117145851, 86178054},
        {116323654, 85925048},
        {115982551, 85834045},
        {115853050, 85819252},
        {115222549, 85771949},
        {107169357, 85771949},
        {107122650, 85776451},
        {106637145, 85831550},
        {105095046, 86423950},
        {104507850, 86703750},
        {104384155, 86763153},
        {104332351, 86790145},
        {104198257, 86882644},
        {103913757, 87109451},
        {103592346, 87388450},
        {103272651, 87666748},
        {103198051, 87779052},
        {101698654, 90600952},
        {101523551, 90958450},
        {101360054, 91347450},
        {101295349, 91542144},
        {99774551, 98278152},
        {99746749, 98417755},
        {99704055, 98675453},
        {99663352, 99022949},
        {99663352, 105328948},
    },
    {
        {95036499, 101778106},
        {95479103, 102521301},
        {95587295, 102700103},
        {98306503, 106984901},
        {98573303, 107377700},
        {100622406, 110221702},
        {101252304, 111089599},
        {104669502, 115750198},
        {121838500, 131804107},
        {122000503, 131943695},
        {122176803, 132023406},
        {122474105, 132025390},
        {122703804, 132023101},
        {123278808, 131878112},
        {124072998, 131509109},
        {124466506, 131102508},
        {152779296, 101350906},
        {153016510, 101090606},
        {153269699, 100809097},
        {153731994, 100214096},
        {153927902, 99939796},
        {154641098, 98858100},
        {154864303, 98517601},
        {155056594, 97816604},
        {155083511, 97645599},
        {155084899, 97462097},
        {154682601, 94386100},
        {154376007, 92992599},
        {154198593, 92432403},
        {153830505, 91861701},
        {153686904, 91678695},
        {151907104, 90314605},
        {151368896, 89957603},
        {146983306, 87632202},
        {139082397, 84273605},
        {128947692, 80411399},
        {121179000, 78631301},
        {120264701, 78458198},
        {119279510, 78304603},
        {116913101, 77994102},
        {116151504, 77974601},
        {115435104, 78171401},
        {113544105, 78709106},
        {113231002, 78879898},
        {112726303, 79163604},
        {112310501, 79411102},
        {96169998, 97040802},
        {95196304, 98364402},
        {95167800, 98409599},
        {95083503, 98570701},
        {94986999, 99022201},
        {94915100, 100413299},
        {95036499, 101778106},
    },
    {
        {82601348, 96004745},
        {83443847, 128861953},
        {84173248, 136147354},
        {104268249, 141388839},
        {104373649, 141395355},
        {105686950, 141389541},
        {149002243, 140435653},
        {159095748, 133388244},
        {159488143, 133112655},
        {159661849, 132894653},
        {163034149, 128290847},
        {164801849, 124684249},
        {167405746, 72553245},
        {167330444, 71960746},
        {167255050, 71791847},
        {167147155, 71572044},
        {166999557, 71341545},
        {166723937, 70961448},
        {166238250, 70611541},
        {165782348, 70359649},
        {165649444, 70286849},
        {165332946, 70122344},
        {165164154, 70062248},
        {164879150, 69967544},
        {164744949, 69928947},
        {164691452, 69915245},
        {164669448, 69910247},
        {159249938, 68738952},
        {158528259, 68704742},
        {147564254, 68604644},
        {116196655, 68982742},
        {115364944, 69005050},
        {115193145, 69013549},
        {101701248, 70984146},
        {93918449, 72233047},
        {93789749, 72285247},
        {93777046, 72292648},
        {93586044, 72444046},
        {93366348, 72662345},
        {93301147, 72745452},
        {93260345, 72816345},
        {83523948, 92593849},
        {83430145, 92810241},
        {82815048, 94665542},
        {82755554, 94858551},
        {82722953, 95014350},
        {82594253, 95682350},
        {82601348, 96004745},
    },
    {
        {110371345, 125796493},
        {110411544, 126159599},
        {110445251, 126362899},
        {111201950, 127863800},
        {112030052, 129270492},
        {112367050, 129799301},
        {113088348, 130525604},
        {113418144, 130853698},
        {117363449, 134705505},
        {118131149, 135444793},
        {118307449, 135607299},
        {119102546, 136297195},
        {119385047, 136531906},
        {120080848, 137094390},
        {120794845, 137645401},
        {121150344, 137896392},
        {121528945, 138162506},
        {121644546, 138242095},
        {122142349, 138506408},
        {127540847, 141363006},
        {127933448, 141516204},
        {128728256, 141766799},
        {129877151, 141989898},
        {130626052, 142113891},
        {130912246, 142135192},
        {131246841, 142109100},
        {131496047, 142027404},
        {131596252, 141957794},
        {131696350, 141873504},
        {131741043, 141803405},
        {138788452, 128037704},
        {139628646, 125946197},
        {138319351, 112395401},
        {130035354, 78066703},
        {124174049, 69908798},
        {123970649, 69676895},
        {123874252, 69571899},
        {123246643, 68961303},
        {123193954, 68924400},
        {121952049, 68110000},
        {121787345, 68021896},
        {121661544, 67970306},
        {121313446, 67877502},
        {121010650, 67864799},
        {120995346, 67869705},
        {120583747, 68122207},
        {120509750, 68170600},
        {120485847, 68189102},
        {112160148, 77252403},
        {111128646, 78690704},
        {110969650, 78939407},
        {110512550, 79663406},
        {110397247, 79958206},
        {110371345, 80038299},
        {110371345, 125796493},
    },
    {
        {112163948, 137752700},
        {112171150, 137837997},
        {112203048, 137955993},
        {112240150, 138008209},
        {112343246, 138111099},
        {112556243, 138223205},
        {112937149, 138307998},
        {113318748, 138331909},
        {126076446, 138428298},
        {126165245, 138428695},
        {126312446, 138417907},
        {134075546, 136054504},
        {134322753, 135949401},
        {134649948, 135791198},
        {135234954, 135493408},
        {135290145, 135464691},
        {135326248, 135443695},
        {135920043, 135032592},
        {135993850, 134975799},
        {136244247, 134761199},
        {136649444, 134378692},
        {137067153, 133964294},
        {137188156, 133839096},
        {137298049, 133704498},
        {137318954, 133677795},
        {137413543, 133522201},
        {137687347, 133043792},
        {137816055, 132660705},
        {137836044, 131747695},
        {137807144, 131318603},
        {136279342, 119078704},
        {136249053, 118945800},
        {127306152, 81348602},
        {127114852, 81065505},
        {127034248, 80951400},
        {126971649, 80893707},
        {125093551, 79178001},
        {124935745, 79036003},
        {115573745, 71767601},
        {115411148, 71701805},
        {115191947, 71621002},
        {115017051, 71571304},
        {114870147, 71572898},
        {113869552, 71653900},
        {112863349, 72976104},
        {112756347, 73223899},
        {112498947, 73832206},
        {112429351, 73998504},
        {112366050, 74168098},
        {112273246, 74487098},
        {112239250, 74605400},
        {112195549, 74899902},
        {112163948, 75280700},
        {112163948, 137752700},
    },
    {
        {78562347, 141451843},
        {79335624, 142828186},
        {79610343, 143188140},
        {79845077, 143445724},
        {81379173, 145126678},
        {81826751, 145577178},
        {82519126, 146209472},
        {83964973, 147280502},
        {85471343, 148377868},
        {86115539, 148760803},
        {88839988, 150281188},
        {89021247, 150382217},
        {90775917, 151320526},
        {91711380, 151767288},
        {92757591, 152134277},
        {93241058, 152201766},
        {113402145, 153091995},
        {122065994, 146802825},
        {164111053, 91685104},
        {164812759, 90470565},
        {165640182, 89037384},
        {171027435, 66211853},
        {171450805, 64406951},
        {171463150, 64349624},
        {171469787, 64317184},
        {171475585, 64282028},
        {171479812, 64253036},
        {171483596, 64210433},
        {171484405, 64153488},
        {171483001, 64140785},
        {171481719, 64132751},
        {171478668, 64115478},
        {171472702, 64092437},
        {171462768, 64075408},
        {171448089, 64061347},
        {171060333, 63854789},
        {169640502, 63197738},
        {169342147, 63086711},
        {166413101, 62215766},
        {151881774, 58826736},
        {146010574, 57613151},
        {141776962, 56908004},
        {140982940, 57030628},
        {139246154, 57540817},
        {139209609, 57566974},
        {127545310, 66015594},
        {127476654, 66104812},
        {105799087, 98784980},
        {85531921, 129338897},
        {79319717, 138704513},
        {78548156, 140188079},
        {78530448, 140530456},
        {78515594, 141299987},
        {78562347, 141451843},
    },
    {
        {77755004, 128712387},
        {78073547, 130552612},
        {78433593, 132017822},
        {79752693, 136839645},
        {80479461, 138929260},
        {80903221, 140119674},
        {81789848, 141978454},
        {82447387, 143105575},
        {83288436, 144264328},
        {84593582, 145846542},
        {84971939, 146242813},
        {86905578, 147321304},
        {87874191, 147594131},
        {89249092, 147245132},
        {89541542, 147169052},
        {98759140, 144071609},
        {98894233, 144024261},
        {113607818, 137992843},
        {128324356, 131649307},
        {139610076, 126210189},
        {146999572, 122112884},
        {147119415, 122036041},
        {148717330, 120934616},
        {149114776, 120652725},
        {171640289, 92086624},
        {171677917, 92036224},
        {171721191, 91973869},
        {171851608, 91721557},
        {171927795, 91507644},
        {172398696, 89846351},
        {172436752, 89559959},
        {169361663, 64753852},
        {169349029, 64687164},
        {169115127, 63616458},
        {168965728, 63218254},
        {168911788, 63121219},
        {168901611, 63106807},
        {168896896, 63100486},
        {168890686, 63092460},
        {168876586, 63081058},
        {168855529, 63067909},
        {168808746, 63046024},
        {167251068, 62405864},
        {164291717, 63716899},
        {152661651, 69910156},
        {142312393, 75421356},
        {78778053, 111143295},
        {77887222, 113905914},
        {77591979, 124378433},
        {77563247, 126586669},
        {77755004, 128712387},
    },
    {
        {105954101, 131182754},
        {105959197, 131275848},
        {105972801, 131473556},
        {105981498, 131571044},
        {106077903, 132298553},
        {106134094, 132715255},
        {106155700, 132832351},
        {106180099, 132942657},
        {106326797, 133590347},
        {106375099, 133719345},
        {106417602, 133829345},
        {106471000, 133930343},
        {106707901, 134308654},
        {106728401, 134340545},
        {106778198, 134417556},
        {106832397, 134491851},
        {106891296, 134562957},
        {106981300, 134667358},
        {107044204, 134736557},
        {107111000, 134802658},
        {107180999, 134865661},
        {107291099, 134961349},
        {107362998, 135020355},
        {107485397, 135112854},
        {107558998, 135166946},
        {107690399, 135256256},
        {107765098, 135305252},
        {107903594, 135390548},
        {108183898, 135561843},
        {108459503, 135727951},
        {108532501, 135771850},
        {108796096, 135920059},
        {108944099, 135972549},
        {109102401, 136010757},
        {109660598, 136071044},
        {109971595, 136100250},
        {110209594, 136116851},
        {110752799, 136122344},
        {111059906, 136105758},
        {111152900, 136100357},
        {111237197, 136091354},
        {111316101, 136075057},
        {111402000, 136050949},
        {111475296, 136026657},
        {143546600, 123535949},
        {143899002, 122454353},
        {143917404, 122394348},
        {143929199, 122354652},
        {143944793, 122295753},
        {143956207, 122250953},
        {143969497, 122192253},
        {143980102, 122143249},
        {143991302, 122083053},
        {144000396, 122031753},
        {144009796, 121970954},
        {144017303, 121917655},
        {144025405, 121850250},
        {144030609, 121801452},
        {144036804, 121727455},
        {144040008, 121683456},
        {144043502, 121600952},
        {144044708, 121565048},
        {144045700, 121470352},
        {144045898, 121446952},
        {144041503, 121108657},
        {144037506, 121023452},
        {143733795, 118731750},
        {140461395, 95238647},
        {140461105, 95236755},
        {140433807, 95115249},
        {140392608, 95011650},
        {134840805, 84668952},
        {134824996, 84642456},
        {134781494, 84572952},
        {134716796, 84480850},
        {127473899, 74425453},
        {127467002, 74417152},
        {127431701, 74381652},
        {127402603, 74357147},
        {127375503, 74334457},
        {127294906, 74276649},
        {127181900, 74207649},
        {127177597, 74205451},
        {127123901, 74178451},
        {127078903, 74155853},
        {127028999, 74133148},
        {126870803, 74070953},
        {126442901, 73917648},
        {126432403, 73914955},
        {126326004, 73889846},
        {126262405, 73880645},
        {126128097, 73878456},
        {125998199, 73877655},
        {108701095, 74516647},
        {108644599, 74519348},
        {108495201, 74528953},
        {108311302, 74556457},
        {108252799, 74569458},
        {108079002, 74612152},
        {107981399, 74638954},
        {107921295, 74657951},
        {107862197, 74685951},
        {107601303, 74828948},
        {107546997, 74863449},
        {107192794, 75098846},
        {107131202, 75151153},
        {106260002, 76066146},
        {106195098, 76221145},
        {106168502, 76328453},
        {106144699, 76437454},
        {106124496, 76538452},
        {106103698, 76649650},
        {106084197, 76761650},
        {106066299, 76874450},
        {106049903, 76987457},
        {106034797, 77101150},
        {106020904, 77214950},
        {106008201, 77328948},
        {105996902, 77443145},
        {105986099, 77565849},
        {105977005, 77679649},
        {105969299, 77793151},
        {105963096, 77906349},
        {105958297, 78019149},
        {105955299, 78131454},
        {105954101, 78242950},
        {105954101, 131182754},
    },
    {
        {91355499, 77889205},
        {114834197, 120804504},
        {114840301, 120815200},
        {124701507, 132324798},
        {124798805, 132436706},
        {124901504, 132548309},
        {125126602, 132788909},
        {125235000, 132901901},
        {125337707, 133005401},
        {125546302, 133184707},
        {125751602, 133358703},
        {126133300, 133673004},
        {126263900, 133775604},
        {126367401, 133855499},
        {126471908, 133935104},
        {126596008, 134027496},
        {127119308, 134397094},
        {127135101, 134408203},
        {127433609, 134614303},
        {127554107, 134695709},
        {128155395, 135070907},
        {128274505, 135141799},
        {129132003, 135573211},
        {129438003, 135713195},
        {129556106, 135767196},
        {131512695, 136648498},
        {132294509, 136966598},
        {132798400, 137158798},
        {133203796, 137294494},
        {133377410, 137350799},
        {133522399, 137396606},
        {133804397, 137480697},
        {134017807, 137542205},
        {134288696, 137618408},
        {134564208, 137680099},
        {134844696, 137740097},
        {135202606, 137807098},
        {135489105, 137849807},
        {135626800, 137864898},
        {135766906, 137878692},
        {135972808, 137895797},
        {136110107, 137905502},
        {136235000, 137913101},
        {136485809, 137907196},
        {139194305, 136979202},
        {140318298, 136536209},
        {140380004, 136505004},
        {140668197, 136340499},
        {140724304, 136298904},
        {140808197, 136228210},
        {140861801, 136180603},
        {140917404, 136129104},
        {140979202, 136045104},
        {141022903, 135984207},
        {147591094, 126486999},
        {147661315, 126356101},
        {147706100, 126261901},
        {147749099, 126166000},
        {147817108, 126007507},
        {147859100, 125908599},
        {153693206, 111901100},
        {153731109, 111807800},
        {153760894, 111698806},
        {158641998, 92419303},
        {158644500, 92263702},
        {158539703, 92013504},
        {158499603, 91918899},
        {158335510, 91626800},
        {158264007, 91516304},
        {158216308, 91449203},
        {158178314, 91397506},
        {158094299, 91283203},
        {157396408, 90368202},
        {157285491, 90224700},
        {157169906, 90079200},
        {157050003, 89931304},
        {156290603, 89006805},
        {156221099, 88922897},
        {156087707, 88771003},
        {155947906, 88620498},
        {155348602, 88004203},
        {155113204, 87772796},
        {154947296, 87609703},
        {154776306, 87448204},
        {154588806, 87284301},
        {153886306, 86716400},
        {153682403, 86560501},
        {152966705, 86032402},
        {152687805, 85828704},
        {152484313, 85683204},
        {152278808, 85539001},
        {150878204, 84561401},
        {150683013, 84426498},
        {150599395, 84372703},
        {150395599, 84243202},
        {149988906, 83989395},
        {149782897, 83864501},
        {149568908, 83739799},
        {148872100, 83365303},
        {148625396, 83242202},
        {128079010, 73079605},
        {127980506, 73031005},
        {126701103, 72407104},
        {126501701, 72312202},
        {126431503, 72280601},
        {126311706, 72230606},
        {126260101, 72210899},
        {126191902, 72187599},
        {126140106, 72170303},
        {126088203, 72155303},
        {126036102, 72142700},
        {125965904, 72126899},
        {125913009, 72116600},
        {125859603, 72108505},
        {125788101, 72100296},
        {125733505, 72094398},
        {125678100, 72090400},
        {125621398, 72088302},
        {125548805, 72087303},
        {125490707, 72086898},
        {125430908, 72088203},
        {125369804, 72091094},
        {125306900, 72095306},
        {125233505, 72100997},
        {125168609, 72106506},
        {125102203, 72113601},
        {125034103, 72122207},
        {124964309, 72132095},
        {124890701, 72143707},
        {124819305, 72155105},
        {91355499, 77889099},
        {91355499, 77889205},
    },
    {
        {84531845, 127391708},
        {84916946, 130417510},
        {86133247, 131166900},
        {86338447, 131292892},
        {86748847, 131544799},
        {102193946, 136599502},
        {103090942, 136796798},
        {103247146, 136822509},
        {104083549, 136911499},
        {106119346, 137109802},
        {106265853, 137122207},
        {106480247, 137139205},
        {110257850, 137133605},
        {116917747, 136131408},
        {117054946, 136106704},
        {119043945, 135244293},
        {119249046, 135154708},
        {136220947, 126833007},
        {165896347, 91517105},
        {166032546, 91314697},
        {166055435, 91204902},
        {166056152, 91176803},
        {166047256, 91100006},
        {166039733, 91063705},
        {165814849, 90080802},
        {165736450, 89837707},
        {165677246, 89732101},
        {165676956, 89731803},
        {165560241, 89629302},
        {154419952, 82608505},
        {153822143, 82239700},
        {137942749, 74046104},
        {137095245, 73845504},
        {135751342, 73537704},
        {134225952, 73208602},
        {132484344, 72860801},
        {124730346, 73902000},
        {120736549, 74464401},
        {100401245, 78685401},
        {90574645, 90625701},
        {90475944, 90748809},
        {90430747, 90808700},
        {90321548, 90958305},
        {90254852, 91077903},
        {90165641, 91244003},
        {90134941, 91302398},
        {84474647, 103745697},
        {84328048, 104137901},
        {84288543, 104327606},
        {84038047, 106164604},
        {84013351, 106368698},
        {83943847, 110643203},
        {84531845, 127391708},
    },
};

using Slic3r::ExPolygon;
using Slic3r::Polygon;
using Slic3r::Polygons;
using Slic3r::ExPolygons;

struct MyPoly {
    ExPolygon poly;
    MyPoly(Polygon contour, Polygons holes)
        : poly(std::move(contour))
    {
        poly.holes = std::move(holes);
    }

    operator ExPolygon () { return poly; }
};

const TestDataEx PRUSA_PART_POLYGONS_EX = {
    ExPolygons{
        // "x-carriage.stl":
        MyPoly{{
                   {-22097700, -14878600}, {-21981300, -14566100},
                   {-21807600, -14303900}, {-21354100, -13619200},
                   {-20514800, -12806600}, {-19500000, -12163900},
                   {-18553700, -11796600}, {-18354100, -11719200},
                   {-18146200, -11680600}, {-17127200, -11491800},
                   {-15872800, -11491800}, {-14853800, -11680600},
                   {-14645900, -11719200}, {-14446300, -11796600},
                   {-13500000, -12163900}, {-12485200, -12806600},
                   {-11645900, -13619200}, {-11192400, -14303900},
                   {-11018700, -14566100}, {-10902300, -14878600},
                   {-10857000, -15000000}, {-2200000, -15000000},
                   {-2242640, -14957400},  {500000, -12214700},
                   {500000, 5500000},      {9450000, 5500000},
                   {9450000, 7500000},     {273885, 7500000},
                   {273885, 11050000},     {2706110, 11050000},
                   {2706110, 11000000},    {9500000, 11000000},
                   {9500000, 66500000},    {7466310, 68533696},
                   {999999, 75000000},     {-8500000, 75000000},
                   {-8500000, 74250000},   {-7500000, 74250000},
                   {-7500000, 71750000},   {-8500000, 71750000},
                   {-8500000, 68250000},   {-7500000, 68250000},
                   {-7500000, 65750000},   {-8500000, 65750000},
                   {-8500000, 64000000},   {-12500000, 64000000},
                   {-12500000, 67000000},  {-14500000, 67000000},
                   {-14500000, 73000000},  {-12500000, 73000000},
                   {-12500000, 75000000},  {-23000000, 75000000},
                   {-23000000, 59500000},  {-38500000, 59500000},
                   {-42500000, 55500000},  {-42500000, 19536000},
                   {-36767700, 18000000},  {-34000000, 18000000},
                   {-34000000, 13000000},  {-39900000, 13000000},
                   {-39900000, 11000000},  {-34000000, 11000000},
                   {-34000000, 7500000},   {-39900000, 7500000},
                   {-39900000, 5500000},   {-34000000, 5500000},
                   {-34000000, -11714700}, {-30757400, -14957400},
                   {-30800000, -15000000}, {-22143000, -15000000},
               },
               {
                   {
                       {2311850, 65709900}, {2076590, 65759904},
                       {1943770, 65788100}, {1600000, 65941200},
                       {1362567, 66113636}, {1329590, 66137604},
                       {1295560, 66162300}, {1043769, 66442000},
                       {855618, 66767900},  {739334, 67125800},
                       {714193, 67365000},  {700000, 67500000},
                       {714193, 67635000},  {739334, 67874200},
                       {855618, 68232104},  {1043769, 68558000},
                       {1295560, 68837696}, {1329590, 68862400},
                       {1352596, 68879119}, {1600000, 69058800},
                       {1943770, 69211896}, {2076590, 69240096},
                       {2311850, 69290104}, {2688150, 69290104},
                       {3056230, 69211896}, {3400000, 69058800},
                       {3541910, 68955704}, {3704430, 68837696},
                       {3762210, 68773496}, {3865370, 68658896},
                       {3956230, 68558000}, {4024119, 68440400},
                       {4065821, 68368176}, {4144380, 68232104},
                       {4260660, 67874200}, {4300000, 67500000},
                       {4260660, 67125800}, {4144380, 66767900},
                       {4024119, 66559600}, {3956230, 66442000},
                       {3865370, 66341104}, {3762210, 66226500},
                       {3704430, 66162300}, {3541910, 66044296},
                       {3400000, 65941200}, {3056230, 65788100},
                       {2688150, 65709900},
                   },
                   {
                       {-27606700, 54303400}, {-27818500, 54330100},
                       {-27896000, 54350000}, {-28025300, 54383200},
                       {-28223800, 54461800}, {-28410900, 54564600},
                       {-28583600, 54690100}, {-28739200, 54836300},
                       {-28875300, 55000800}, {-28989700, 55181000},
                       {-29080600, 55374200}, {-29146600, 55577200},
                       {-29150000, 55595100}, {-29186600, 55786900},
                       {-29200000, 56000000}, {-29186600, 56213100},
                       {-29150000, 56404900}, {-29146600, 56422800},
                       {-29080600, 56625800}, {-28989700, 56819000},
                       {-28875300, 56999200}, {-28739200, 57163700},
                       {-28583600, 57309900}, {-28410900, 57435400},
                       {-28223800, 57538200}, {-28025300, 57616800},
                       {-27896000, 57650000}, {-27818500, 57669900},
                       {-27606700, 57696600}, {-27393300, 57696600},
                       {-27181400, 57669900}, {-27104000, 57650000},
                       {-26974700, 57616800}, {-26776200, 57538200},
                       {-26589100, 57435400}, {-26416400, 57309900},
                       {-26260800, 57163700}, {-26124700, 56999200},
                       {-26010300, 56819000}, {-25919400, 56625800},
                       {-25853400, 56422800}, {-25850000, 56404900},
                       {-25813400, 56213100}, {-25800000, 56000000},
                       {-25813400, 55786900}, {-25850000, 55595100},
                       {-25853400, 55577200}, {-25919400, 55374200},
                       {-26010300, 55181000}, {-26124700, 55000800},
                       {-26260800, 54836300}, {-26416400, 54690100},
                       {-26589100, 54564600}, {-26776200, 54461800},
                       {-26974700, 54383200}, {-27104000, 54350000},
                       {-27181400, 54330100}, {-27393300, 54303400},
                   },
                   {
                       {-4106740, 54303400}, {-4318550, 54330100},
                       {-4396010, 54350000}, {-4525330, 54383200},
                       {-4723820, 54461800}, {-4910900, 54564600},
                       {-5083620, 54690100}, {-5239250, 54836300},
                       {-5375330, 55000800}, {-5489720, 55181000},
                       {-5580620, 55374200}, {-5646590, 55577200},
                       {-5650000, 55595100}, {-5686590, 55786900},
                       {-5700000, 56000000}, {-5686590, 56213100},
                       {-5650000, 56404900}, {-5646590, 56422800},
                       {-5580620, 56625800}, {-5489720, 56819000},
                       {-5375330, 56999200}, {-5239250, 57163700},
                       {-5083620, 57309900}, {-4910900, 57435400},
                       {-4723820, 57538200}, {-4525330, 57616800},
                       {-4396010, 57650000}, {-4318550, 57669900},
                       {-4106740, 57696600}, {-3893260, 57696600},
                       {-3681450, 57669900}, {-3603990, 57650000},
                       {-3474670, 57616800}, {-3276170, 57538200},
                       {-3089090, 57435400}, {-2916380, 57309900},
                       {-2760750, 57163700}, {-2624670, 56999200},
                       {-2510280, 56819000}, {-2419380, 56625800},
                       {-2353410, 56422800}, {-2350000, 56404900},
                       {-2313400, 56213100}, {-2300000, 56000000},
                       {-2313400, 55786900}, {-2350000, 55595100},
                       {-2353410, 55577200}, {-2419380, 55374200},
                       {-2510280, 55181000}, {-2624670, 55000800},
                       {-2760750, 54836300}, {-2916380, 54690100},
                       {-3089090, 54564600}, {-3276170, 54461800},
                       {-3474670, 54383200}, {-3603990, 54350000},
                       {-3681450, 54330100}, {-3893260, 54303400},
                   },
                   {
                       {-16103600, 27353300}, {-16309200, 27379200},
                       {-16509899, 27430800}, {-16702499, 27507000},
                       {-16884100, 27606900}, {-17051800, 27728700},
                       {-17202800, 27870500}, {-17334900, 28030200},
                       {-17445900, 28205100}, {-17534100, 28392600},
                       {-17598200, 28589700}, {-17637000, 28793200},
                       {-17650000, 29000000}, {-17637000, 29206800},
                       {-17598200, 29410300}, {-17534100, 29607400},
                       {-17445900, 29794900}, {-17334900, 29969800},
                       {-17202800, 30129500}, {-17051800, 30271300},
                       {-16884100, 30393100}, {-16702499, 30493000},
                       {-16509899, 30569200}, {-16309200, 30620800},
                       {-16103600, 30646700}, {-15896400, 30646700},
                       {-15690800, 30620800}, {-15490100, 30569200},
                       {-15297500, 30493000}, {-15115900, 30393100},
                       {-14948200, 30271300}, {-14797200, 30129500},
                       {-14665100, 29969800}, {-14554100, 29794900},
                       {-14465900, 29607400}, {-14401800, 29410300},
                       {-14363000, 29206800}, {-14350000, 29000000},
                       {-14363000, 28793200}, {-14401800, 28589700},
                       {-14465900, 28392600}, {-14554100, 28205100},
                       {-14665100, 28030200}, {-14797200, 27870500},
                       {-14948200, 27728700}, {-15115900, 27606900},
                       {-15297500, 27507000}, {-15490100, 27430800},
                       {-15690800, 27379200}, {-15896400, 27353300},
                   },
                   {
                       {-5809180, 22879200}, {-6202540, 23007000},
                       {-6551750, 23228700}, {-6834880, 23530200},
                       {-7034130, 23892600}, {-7136990, 24293200},
                       {-7136990, 24706800}, {-7034130, 25107400},
                       {-6834880, 25469800}, {-6551750, 25771300},
                       {-6202540, 25993000}, {-5809180, 26120800},
                       {-5396390, 26146700}, {-4990120, 26069200},
                       {-4615890, 25893100}, {-4297200, 25629500},
                       {-4054090, 25294900}, {-3901840, 24910300},
                       {-3850000, 24500000}, {-3901840, 24089700},
                       {-4054090, 23705100}, {-4297200, 23370500},
                       {-4615890, 23106900}, {-4990120, 22930800},
                       {-5396390, 22853300},
                   },
                   {
                       {-28809200, 22879200}, {-29202500, 23007000},
                       {-29551800, 23228700}, {-29834900, 23530200},
                       {-30034100, 23892600}, {-30137000, 24293200},
                       {-30137000, 24706800}, {-30034100, 25107400},
                       {-29834900, 25469800}, {-29551800, 25771300},
                       {-29202500, 25993000}, {-28809200, 26120800},
                       {-28396400, 26146700}, {-27990100, 26069200},
                       {-27615900, 25893100}, {-27297200, 25629500},
                       {-27054100, 25294900}, {-26901800, 24910300},
                       {-26850000, 24500000}, {-26901800, 24089700},
                       {-27054100, 23705100}, {-27297200, 23370500},
                       {-27615900, 23106900}, {-27990100, 22930800},
                       {-28396400, 22853300},
                   },
                   {
                       {-15718329, 8800000},
                       {-15729700, 8808230},
                       {-15736300, 8814060},
                       {-15742800, 8833890},
                       {-15876410, 9243607},
                       {-15729700, 9696850},
                       {-14969700, 10251100},
                       {-14030300, 10251100},
                       {-13270300, 9696850},
                       {-13123590, 9243607},
                       {-13257200, 8833890},
                       {-13263700, 8814060},
                       {-13270300, 8808230},
                       {-13281671, 8800000},
                   },
               }},
    },
    ExPolygons{
        // "Spool-holder.stl":
        MyPoly{{
                   {338485792, -31307222}, {338867040, -31018436},
                   {339248320, -30729652}, {339769915, -30334566},
                   {340010848, -30152082}, {340392096, -29863298},
                   {340773344, -29574512}, {341244704, -27899436},
                   {341480384, -27061900}, {342060734, -24999444},
                   {342187424, -24549286}, {343068058, -21419626},
                   {343130112, -21199134}, {343521972, -19806477},
                   {344953440, -14719350}, {345583712, -12479458},
                   {345898880, -11359512}, {346213984, -10239566},
                   {346529152, -9119620},  {346684120, -8568830},
                   {347258496, -6527694},  {348879776, -765989},
                   {351121248, 7199785},   {351160318, 7338666},
                   {351581888, 8836852},   {358349952, 32889144},
                   {361733984, 44915292},  {362502080, 47644968},
                   {365226370, 57326618},  {367181933, 64276284},
                   {369782208, 73517048},  {372004549, 81414857},
                   {375270080, 93019880},  {377062304, 99389120},
                   {380702368, 112325160}, {387982496, 138197232},
                   {390913664, 148614048}, {392379232, 153822448},
                   {392462848, 154165648}, {392500992, 154371968},
                   {392523776, 154527056}, {392558720, 154903888},
                   {392560704, 154943056}, {392564832, 155292544},
                   {392554016, 155525040}, {392539872, 155688624},
                   {392482592, 156087152}, {392479040, 156106240},
                   {392392608, 156482704}, {392336512, 156674688},
                   {392270816, 156869776}, {392130112, 157218896},
                   {392119264, 157242992}, {391941088, 157597536},
                   {391865920, 157728704}, {391740320, 157929344},
                   {391551872, 158195776}, {391521632, 158235296},
                   {391290048, 158513360}, {391187328, 158624592},
                   {391050656, 158762640}, {390808320, 158983152},
                   {390768160, 159017008}, {390567456, 159175840},
                   {390331776, 159342352}, {390300192, 159363104},
                   {389874464, 159612112}, {389791584, 159654240},
                   {389337216, 159852608}, {389252448, 159883872},
                   {388769664, 160029808}, {388694016, 160047936},
                   {388177408, 160139328}, {388128128, 160145120},
                   {387566176, 160176800}, {375407744, 160176800},
                   {374915072, 160152480}, {374676896, 160123104},
                   {374431712, 160080592}, {374176224, 160022768},
                   {373936576, 159955472}, {373914144, 159948512},
                   {373647424, 159856688}, {373378176, 159746368},
                   {373213376, 159669552}, {373108832, 159616976},
                   {372841920, 159468256}, {372580064, 159300432},
                   {372535328, 159269408}, {372325888, 159114096},
                   {372081888, 158910256}, {371928512, 158767776},
                   {371850368, 158690384}, {371633408, 158456224},
                   {371432736, 158209856}, {371413792, 158184848},
                   {371249664, 157953552}, {371085088, 157689664},
                   {371004448, 157545600}, {370939520, 157420656},
                   {370813088, 157148864}, {370705536, 156876560},
                   {368543808, 150896416}, {363439712, 136776352},
                   {358631104, 123473712}, {358408023, 122856568},
                   {356409504, 117327816}, {355922364, 115980139},
                   {355915437, 115960977}, {352669088, 106980280},
                   {351986938, 105093166}, {351083520, 102593952},
                   {349781616, 98992320},  {348098080, 94334952},
                   {340262048, 72657256},  {338954668, 69040480},
                   {336962208, 63528480},  {332255104, 50506656},
                   {327202016, 36527760},  {322789144, 24319856},
                   {322760544, 24240790},  {322533686, 23613197},
                   {322519552, 23574124},  {320672032, 18463012},
                   {320578304, 18203810},  {320531456, 18074210},
                   {320484608, 17944606},  {320437760, 17815006},
                   {320297248, 17426202},  {320297248, 9238203},
                   {321164066, 9238176},   {321689312, 9238155},
                   {323777376, 9238073},   {324473408, 9238046},
                   {325169440, 9238018},   {325496384, 10782991},
                   {325496360, 12868520},  {327892320, 12868504},
                   {329090336, 12868496},  {330288320, 12868487},
                   {331486336, 12868480},  {332684279, 12868472},
                   {332096736, 10092249},  {332096736, -26761938},
                   {325697024, -26761692}, {325697024, -26311692},
                   {324897056, -26311692}, {323897056, -27061692},
                   {323897056, -29536704}, {323897088, -30511784},
                   {323897088, -32461944}, {323897091, -32461944},
                   {328084288, -32462100}, {329480000, -32462150},
                   {332271456, -32462258}, {335062912, -32462360},
                   {336960768, -32462360},
               },
               {
                   {
                       {376588032, 136952960}, {375810912, 137178704},
                       {375411104, 137361136}, {375032960, 137582800},
                       {374679360, 137841776}, {374353152, 138136224},
                       {374058688, 138462448}, {373799680, 138816048},
                       {373578048, 139194192}, {373395584, 139594016},
                       {373169856, 140371136}, {373093728, 141176800},
                       {373169856, 141982464}, {373395584, 142759600},
                       {373578048, 143159392}, {373799680, 143537536},
                       {374058688, 143891136}, {374353152, 144217360},
                       {374679360, 144511824}, {375032960, 144770816},
                       {375411104, 144992464}, {375810912, 145174896},
                       {376588032, 145400656}, {377393696, 145476800},
                       {378199360, 145400656}, {378976512, 145174896},
                       {379376320, 144992480}, {379754464, 144770816},
                       {380108064, 144511808}, {380434272, 144217360},
                       {380728736, 143891136}, {380987744, 143537536},
                       {381209376, 143159392}, {381391776, 142759600},
                       {381617568, 141982464}, {381693696, 141176800},
                       {381617568, 140371136}, {381391776, 139594000},
                       {381209376, 139194192}, {380987744, 138816064},
                       {380728736, 138462464}, {380434272, 138136240},
                       {380108064, 137841792}, {379754464, 137582800},
                       {379376320, 137361136}, {378976512, 137178704},
                       {378199360, 136952960}, {377393696, 136876800},
                   },
                   {
                       {354604704, 97626944},  {355293600, 99532704},
                       {355982496, 101438472}, {356671392, 103344232},
                       {357360288, 105250000}, {358424054, 108192839},
                       {358738080, 109061520}, {359426976, 110967296},
                       {360115840, 112873056}, {362111392, 113825960},
                       {368097952, 116684672}, {370093472, 117637584},
                       {372089024, 118590488}, {374084544, 119543392},
                       {378075584, 121449192}, {377003072, 117637704},
                       {375930560, 113826200}, {375394304, 111920456},
                       {374321792, 108108952}, {373249280, 104297464},
                       {368952928, 102391616}, {362508448, 99532856},
                       {360360288, 98579944},  {358212128, 97627024},
                       {356063968, 96674096},  {353915808, 95721176},
                   },
                   {
                       {342204640, 63323192}, {342893536, 65228960},
                       {344271328, 69040480}, {344960192, 70946248},
                       {345649120, 72852016}, {346338016, 74757776},
                       {347026880, 76663536}, {347715776, 78569304},
                       {354618176, 81428112}, {356918976, 82381040},
                       {359219776, 83333976}, {361520576, 84286920},
                       {363821376, 85239856}, {366122176, 86192784},
                       {368422976, 87145720}, {367886720, 85239976},
                       {366814208, 81428472}, {366277952, 79522728},
                       {365741664, 77616984}, {365205408, 75711224},
                       {364132896, 71899736}, {363596640, 69993984},
                       {361143232, 69041032}, {356236352, 67135128},
                       {353782944, 66182184}, {351329504, 65229232},
                       {348876064, 64276284}, {346422592, 63323328},
                       {343969184, 62370380}, {341515744, 61417428},
                   },
                   {
                       {329804576, 29019442}, {330493472, 30925208},
                       {331182368, 32830970}, {331871232, 34736732},
                       {332560160, 36642500}, {333249056, 38548264},
                       {333937920, 40454024}, {334626816, 42359792},
                       {335315744, 44265552}, {337921792, 45218520},
                       {340527872, 46171484}, {343133952, 47124452},
                       {345740000, 48077416}, {348346080, 49030384},
                       {350952160, 49983348}, {353558208, 50936312},
                       {356164288, 51889284}, {358770368, 52842248},
                       {358234112, 50936496}, {357697856, 49030752},
                       {357161568, 47125000}, {356089056, 43313504},
                       {355552800, 41407752}, {355016544, 39502008},
                       {354480288, 37596256}, {353944032, 35690508},
                       {351185344, 34737524}, {348426624, 33784544},
                       {345667904, 32831566}, {342909216, 31878584},
                       {340150528, 30925604}, {334633088, 29019640},
                       {331874400, 28066660}, {329115680, 27113678},
                   },
               }},
    },
    ExPolygons{
        // "x-end-idler.stl":
        MyPoly{{
                   {-6500000, -10475000}, {0, -10475000},
                   {0, -10468600},        {365572, -10468600},
                   {1094940, -10417600},  {1818960, -10315900},
                   {2534130, -10163800},  {3236950, -9962320},
                   {3924000, -9712250},   {4591940, -9414870},
                   {5237500, -9071620},   {5857540, -8684170},
                   {6449050, -8254410},   {7009140, -7784440},
                   {7535080, -7276550},   {8024310, -6733200},
                   {8474450, -6157050},   {8883300, -5550900},
                   {9248880, -4917710},   {9569390, -4260570},
                   {9843280, -3582660},   {10069200, -2887300},
                   {10246100, -2177870},  {10373100, -1457840},
                   {10449500, -730699},   {10475000, 0},
                   {10449500, 730699},    {10373100, 1457840},
                   {10246100, 2177870},   {10069200, 2887300},
                   {9843280, 3582660},    {9569390, 4260570},
                   {9248880, 4917710},    {8883300, 5550900},
                   {8474450, 6157050},    {8024310, 6733200},
                   {7739860, 7049120},    {8047300, 7272490},
                   {9203020, 8357790},    {10213600, 9579380},
                   {11063100, 10918000},  {11738200, 12352500},
                   {12228100, 13860400},  {12525200, 15417700},
                   {12624700, 17000000},  {12525200, 18582300},
                   {12228100, 20139600},  {11738200, 21647500},
                   {11063100, 23082000},  {10213600, 24420600},
                   {9203020, 25642200},   {8047300, 26727500},
                   {6764660, 27659400},   {5375340, 28423200},
                   {3901250, 29006800},   {2365630, 29401100},
                   {792712, 29599800},    {-792712, 29599800},
                   {-2365630, 29401100},  {-3901250, 29006800},
                   {-5181320, 28500000},  {-23500000, 28500000},
                   {-23500000, -9000000}, {-22000000, -10500000},
                   {-6500000, -10500000},
               },
               {
                   {
                       {6562230, 22074800}, {6357580, 22107300},
                       {6158600, 22165100}, {5968430, 22247400},
                       {5790080, 22352800}, {5626350, 22479800},
                       {5479830, 22626400}, {5352830, 22790100},
                       {5247350, 22968400}, {5165060, 23158600},
                       {5107250, 23357600}, {5074840, 23562200},
                       {5068330, 23769300}, {5087830, 23975600},
                       {5133030, 24177800}, {5203220, 24372800},
                       {5297290, 24557400}, {5413760, 24728800},
                       {5550790, 24884200}, {5706220, 25021300},
                       {5877600, 25137700}, {6062220, 25231800},
                       {6257180, 25302000}, {6459400, 25347200},
                       {6665690, 25366700}, {6872790, 25360200},
                       {7077450, 25327800}, {7276430, 25270000},
                       {7466600, 25187700}, {7644950, 25082200},
                       {7808680, 24955200}, {7955200, 24808700},
                       {8082200, 24645000}, {8187670, 24466600},
                       {8269970, 24276400}, {8327780, 24077400},
                       {8360190, 23872800}, {8366700, 23665700},
                       {8347200, 23459400}, {8302000, 23257200},
                       {8231809, 23062200}, {8137740, 22877600},
                       {8021270, 22706200}, {7884240, 22550800},
                       {7728810, 22413800}, {7557430, 22297300},
                       {7372810, 22203200}, {7177850, 22133000},
                       {6975630, 22087800}, {6769340, 22068300},
                   },
                   {
                       {1094940, 10417600},  {365572, 10468600},
                       {0, 10468600},        {0, 10475000},
                       {-1431080, 10475000}, {-6000000, 15108169},
                       {-6000000, 19962102}, {-5802370, 20350000},
                       {-5420410, 20938200}, {-4979070, 21483200},
                       {-4483170, 21979100}, {-3938160, 22420400},
                       {-3350000, 22802400}, {-2725130, 23120800},
                       {-2070410, 23372100}, {-1393010, 23553600},
                       {-700340, 23663300},  {0, 23700000},
                       {700340, 23663300},   {1393010, 23553600},
                       {2070410, 23372100},  {2725130, 23120800},
                       {3350000, 22802400},  {3938160, 22420400},
                       {4483170, 21979100},  {4979070, 21483200},
                       {5420410, 20938200},  {5802370, 20350000},
                       {6120750, 19725100},  {6372080, 19070400},
                       {6553590, 18393000},  {6663300, 17700300},
                       {6700000, 17000000},  {6663300, 16299700},
                       {6553590, 15607000},  {6372080, 14929600},
                       {6120750, 14274900},  {5802370, 13650000},
                       {5420410, 13061800},  {4979070, 12516800},
                       {4483170, 12020900},  {3938160, 11579600},
                       {3350000, 11197600},  {2725130, 10879200},
                       {2070410, 10627900},  {1393010, 10446400},
                       {1156540, 10409000},
                   },
                   {
                       {-1455380, -6847030}, {-2847160, -6394820},
                       {-4114500, -5663120}, {-5202010, -4683910},
                       {-6062180, -3500000}, {-6657400, -2163120},
                       {-6961650, -731699},  {-6961650, 731699},
                       {-6657400, 2163120},  {-6062180, 3500000},
                       {-5202010, 4683910},  {-4114500, 5663120},
                       {-2847160, 6394820},  {-1455380, 6847030},
                       {0, 7000000},         {1455380, 6847030},
                       {2847160, 6394820},   {4114500, 5663120},
                       {5018810, 4848870},   {5421400, 5186681},
                       {5472037, 5130444},   {6083180, 4451690},
                       {6090937, 4443078},   {6007070, 4372710},
                       {5647390, 4070900},   {6062180, 3500000},
                       {6657400, 2163120},   {6961650, 731699},
                       {6961650, -731699},   {6657400, -2163120},
                       {6062180, -3500000},  {5202010, -4683910},
                       {4114500, -5663120},  {2847160, -6394820},
                       {1455380, -6847030},  {0, -7000000},
                   },
               }},
    },
    ExPolygons{
        // "Einsy-hinges.stl":
        MyPoly{
            {
                {865247, 3337040},   {1400000, 3575130},   {1873570, 3919190},
                {2265250, 4354200},  {2557930, 4861140},   {2738810, 5417850},
                {2762880, 5646830},  {2785290, 5860020},   {2786450, 5871067},
                {2796080, 5962680},  {2800000, 6000000},   {2738810, 6582150},
                {2728530, 6613790},  {2344020, 7279790},   {2195738, 7536616},
                {1639530, 8500000},  {1552105, 8651421},   {935040, 9720210},
                {621454, 10263400},  {-3267950, 17000000}, {-5000000, 17000000},
                {-5000000, 6000000}, {-2800000, 6000000},  {-2738810, 5417850},
                {-2557930, 4861140}, {-2265250, 4354200},  {-1873570, 3919190},
                {-1400000, 3575130}, {-865247, 3337040},   {-292679, 3215340},
                {292679, 3215340},
            },
            {}},
        MyPoly{{
                   {412054, -4263360},    {725639, -3720210},
                   {1315606, -2698356},   {1430130, -2500000},
                   {2000000, -1512950},   {2000000, -1309600},
                   {2192510, -976168},    {2347550, -498987},
                   {2400000, 0},          {2382076, 170521},
                   {2362880, 353169},     {2349180, 483565},
                   {2347550, 498987},     {2192510, 976168},
                   {1941640, 1410680},    {1605910, 1783550},
                   {1200000, 2078460},    {741640, 2282540},
                   {250868, 2386850},     {-250868, 2386850},
                   {-741640, 2282540},    {-1200000, 2078460},
                   {-1605910, 1783550},   {-1941640, 1410680},
                   {-2192510, 976168},    {-2347550, 498987},
                   {-2400000, 0},         {-5000000, 0},
                   {-5000000, -11000000}, {-3477350, -11000000},
               },
               {}},
    },
    ExPolygons{
        // "LCD-cover-ORIGINAL-MK3.stl":
        MyPoly{{
                   {78000000, -11928900},
                   {78000000, 51000000},
                   {73000000, 56000000},
                   {-72000000, 56000000},
                   {-77000000, 51000000},
                   {-77000000, -11928900},
                   {-74928904, -14000000},
                   {75928904, -14000000},
               },
               {
                   {
                       {44000000, 26000000}, {44000000, 31980000},
                       {43992900, 31987100}, {44000000, 31994200},
                       {44000000, 32000000}, {44005800, 32000000},
                       {56000000, 43994200}, {56000000, 44000000},
                       {56005800, 44000000}, {56013700, 44007900},
                       {56021600, 44000000}, {69500000, 44000000},
                       {69500000, 36020800}, {69510400, 36010400},
                       {63500000, 30000000}, {50900000, 30000000},
                       {49000000, 28100000}, {49000000, 26000000},
                       {48000000, 26000000}, {48000000, 28500000},
                       {47992900, 28507100}, {50503100, 31017300},
                       {50520500, 31000000}, {63085800, 31000000},
                       {68500000, 36414200}, {68500000, 43000000},
                       {56420000, 43000000}, {45000000, 31580000},
                       {45000000, 26000000},
                   },
                   {
                       {-54500000, 8000000},
                       {-54500000, 38500000},
                       {30500000, 38500000},
                       {30500000, 8000000},
                   },
                   {
                       {61872800, 15032900}, {60645900, 15293700},
                       {59500000, 15803800}, {58485200, 16541100},
                       {57645900, 17473300}, {57018700, 18559600},
                       {56631100, 19752500}, {56500000, 21000000},
                       {56631100, 22247500}, {57018700, 23440400},
                       {57645900, 24526700}, {58485200, 25458900},
                       {59500000, 26196200}, {60645900, 26706300},
                       {61872800, 26967100}, {63127200, 26967100},
                       {64354104, 26706300}, {65500000, 26196200},
                       {66514800, 25458900}, {67354104, 24526700},
                       {67981304, 23440400}, {68368896, 22247500},
                       {68500000, 21000000}, {68368896, 19752500},
                       {67981304, 18559600}, {67354104, 17473300},
                       {66514800, 16541100}, {65500000, 15803800},
                       {64354104, 15293700}, {63127200, 15032900},
                   },
                   {
                       {57000000, 1500000},
                       {57000000, 5500000},
                       {58300000, 5500000},
                       {58300000, 1500000},
                   },
                   {
                       {55000000, 1500000},
                       {55000000, 5500000},
                       {56300000, 5500000},
                       {56300000, 1500000},
                   },
                   {
                       {59000000, 1500000},
                       {59000000, 5500000},
                       {60300000, 5500000},
                       {60300000, 1500000},
                   },
                   {
                       {61000000, 1500000},
                       {61000000, 5500000},
                       {62300000, 5500000},
                       {62300000, 1500000},
                   },
                   {
                       {63000000, 1500000},
                       {63000000, 5500000},
                       {64300004, 5500000},
                       {64300004, 1500000},
                   },
                   {
                       {65000000, 1500000},
                       {65000000, 5500000},
                       {66300004, 5500000},
                       {66300004, 1500000},
                   },
                   {
                       {67000000, 1500000},
                       {67000000, 5500000},
                       {68300000, 5500000},
                       {68300000, 1500000},
                   },
               }},
    },
    ExPolygons{
        // "x-end-motor.stl":
        MyPoly{{
                   {2365630, -29401100},   {3901250, -29006800},
                   {5375340, -28423200},   {6764660, -27659400},
                   {8047300, -26727500},   {9203020, -25642200},
                   {10213600, -24420600},  {11063100, -23082000},
                   {11738200, -21647500},  {12228100, -20139600},
                   {12525200, -18582300},  {12624700, -17000000},
                   {12525200, -15417700},  {12228100, -13860400},
                   {11738200, -12352500},  {11063100, -10918000},
                   {10213600, -9579380},   {9203020, -8357790},
                   {8047300, -7272490},    {7739860, -7049120},
                   {8024310, -6733200},    {8474450, -6157050},
                   {8883300, -5550900},    {9248880, -4917710},
                   {9569390, -4260570},    {9843280, -3582660},
                   {10069200, -2887300},   {10246100, -2177870},
                   {10373100, -1457840},   {10449500, -730699},
                   {10475000, 0},          {10449500, 730699},
                   {10373100, 1457840},    {10246100, 2177870},
                   {10069200, 2887300},    {9843280, 3582660},
                   {9569390, 4260570},     {9248880, 4917710},
                   {8883300, 5550900},     {8474450, 6157050},
                   {8024310, 6733200},     {7535080, 7276550},
                   {7009140, 7784440},     {6449050, 8254410},
                   {5857540, 8684170},     {5237500, 9071620},
                   {4591940, 9414870},     {3924000, 9712250},
                   {3236950, 9962320},     {2534130, 10163800},
                   {1818960, 10315900},    {1094940, 10417600},
                   {365572, 10468600},     {0, 10468600},
                   {0, 10475000},          {-6500000, 10475000},
                   {-6500000, 53000000},   {-23500000, 53000000},
                   {-23500000, -28500000}, {-5181320, -28500000},
                   {-3901250, -29006800},  {-2365630, -29401100},
                   {-792712, -29599800},   {792712, -29599800},
               },
               {
                   {
                       {-1455380, -6847030}, {-2847160, -6394820},
                       {-4114500, -5663120}, {-5202010, -4683910},
                       {-6062180, -3500000}, {-6657400, -2163120},
                       {-6961650, -731699},  {-6961650, 731699},
                       {-6657400, 2163120},  {-6062180, 3500000},
                       {-5202010, 4683910},  {-4114500, 5663120},
                       {-2847160, 6394820},  {-1455380, 6847030},
                       {0, 7000000},         {1455380, 6847030},
                       {2847160, 6394820},   {4114500, 5663120},
                       {5202010, 4683910},   {6062180, 3500000},
                       {6657400, 2163120},   {6961650, 731699},
                       {6961650, -731699},   {6657400, -2163120},
                       {6062180, -3500000},  {5641320, -4079259},
                       {6084032, -4450744},  {6083180, -4451690},
                       {5472037, -5130444},  {5414502, -5194343},
                       {5328022, -5121778},  {5011080, -4855830},
                       {4114500, -5663120},  {2847160, -6394820},
                       {1455380, -6847030},  {0, -7000000},
                   },
                   {
                       {-700340, -23663300},  {-1393010, -23553600},
                       {-2070410, -23372100}, {-2725130, -23120800},
                       {-3350000, -22802400}, {-3938160, -22420400},
                       {-4483170, -21979100}, {-4979070, -21483200},
                       {-5420410, -20938200}, {-5802370, -20350000},
                       {-6120750, -19725100}, {-6372080, -19070400},
                       {-6500000, -18593000}, {-6500000, -15515603},
                       {-1406282, -10475000}, {0, -10475000},
                       {0, -10468600},        {365572, -10468600},
                       {1094940, -10417600},  {1156540, -10409000},
                       {1393010, -10446400},  {2070410, -10627900},
                       {2725130, -10879200},  {3350000, -11197600},
                       {3938160, -11579600},  {4483170, -12020900},
                       {4979070, -12516800},  {5420410, -13061800},
                       {5802370, -13650000},  {6120750, -14274900},
                       {6372080, -14929600},  {6553590, -15607000},
                       {6663300, -16299700},  {6700000, -17000000},
                       {6663300, -17700300},  {6553590, -18393000},
                       {6372080, -19070400},  {6120750, -19725100},
                       {5802370, -20350000},  {5420410, -20938200},
                       {4979070, -21483200},  {4483170, -21979100},
                       {3938160, -22420400},  {3350000, -22802400},
                       {2725130, -23120800},  {2070410, -23372100},
                       {1393010, -23553600},  {700340, -23663300},
                       {0, -23700000},
                   },
                   {
                       {6459400, -25347200}, {6257180, -25302000},
                       {6062220, -25231800}, {5877600, -25137700},
                       {5706220, -25021300}, {5550790, -24884200},
                       {5413760, -24728800}, {5297290, -24557400},
                       {5203220, -24372800}, {5133030, -24177800},
                       {5087830, -23975600}, {5068330, -23769300},
                       {5074840, -23562200}, {5107250, -23357600},
                       {5165060, -23158600}, {5247350, -22968400},
                       {5352830, -22790100}, {5479830, -22626400},
                       {5626350, -22479800}, {5790080, -22352800},
                       {5968430, -22247400}, {6158600, -22165100},
                       {6357580, -22107300}, {6562230, -22074800},
                       {6769340, -22068300}, {6975630, -22087800},
                       {7177850, -22133000}, {7372810, -22203200},
                       {7557430, -22297300}, {7728810, -22413800},
                       {7884240, -22550800}, {8021270, -22706200},
                       {8137740, -22877600}, {8231809, -23062200},
                       {8302000, -23257200}, {8347200, -23459400},
                       {8366700, -23665700}, {8360190, -23872800},
                       {8327780, -24077400}, {8269970, -24276400},
                       {8187670, -24466600}, {8082200, -24645000},
                       {7955200, -24808700}, {7808680, -24955200},
                       {7644950, -25082200}, {7466600, -25187700},
                       {7276430, -25270000}, {7077450, -25327800},
                       {6872790, -25360200}, {6665690, -25366700},
                   },
               }},
    },
    ExPolygons{
        // "y-belt-idler.stl":
        MyPoly{{
                   {12500000, 40000000},
                   {-12500000, 40000000},
                   {-12500000, 5000000},
                   {12500000, 5000000},
               },
               {
                   {
                       {-103604, 34353300},  {-309178, 34379200},
                       {-509877, 34430800},  {-702536, 34507000},
                       {-884113, 34606900},  {-1051750, 34728700},
                       {-1202800, 34870500}, {-1334880, 35030200},
                       {-1445910, 35205100}, {-1534130, 35392600},
                       {-1598160, 35589700}, {-1636990, 35793200},
                       {-1650000, 36000000}, {-1636990, 36206800},
                       {-1598160, 36410300}, {-1534130, 36607400},
                       {-1445910, 36794900}, {-1334880, 36969800},
                       {-1202800, 37129500}, {-1051750, 37271300},
                       {-884113, 37393100},  {-702536, 37493000},
                       {-509877, 37569200},  {-309178, 37620800},
                       {-103604, 37646700},  {103604, 37646700},
                       {309178, 37620800},   {509877, 37569200},
                       {702536, 37493000},   {884113, 37393100},
                       {1051750, 37271300},  {1202800, 37129500},
                       {1334880, 36969800},  {1445910, 36794900},
                       {1534130, 36607400},  {1598160, 36410300},
                       {1636990, 36206800},  {1650000, 36000000},
                       {1636990, 35793200},  {1598160, 35589700},
                       {1534130, 35392600},  {1445910, 35205100},
                       {1334880, 35030200},  {1202800, 34870500},
                       {1051750, 34728700},  {884113, 34606900},
                       {702536, 34507000},   {509877, 34430800},
                       {309178, 34379200},   {103604, 34353300},
                   },
                   {
                       {-103604, 8353260},   {-309178, 8379229},
                       {-509877, 8430760},   {-702536, 8507040},
                       {-884113, 8606860},   {-1051750, 8728650},
                       {-1202800, 8870500},  {-1334880, 9030150},
                       {-1445910, 9205110},  {-1534130, 9392590},
                       {-1598160, 9589660},  {-1636990, 9793200},
                       {-1650000, 10000000}, {-1636990, 10206800},
                       {-1598160, 10410300}, {-1534130, 10607400},
                       {-1445910, 10794900}, {-1334880, 10969800},
                       {-1202800, 11129500}, {-1051750, 11271300},
                       {-884113, 11393100},  {-702536, 11493000},
                       {-509877, 11569200},  {-309178, 11620800},
                       {-103604, 11646700},  {103604, 11646700},
                       {309178, 11620800},   {509877, 11569200},
                       {702536, 11493000},   {884113, 11393100},
                       {1051750, 11271300},  {1202800, 11129500},
                       {1334880, 10969800},  {1445910, 10794900},
                       {1534130, 10607400},  {1598160, 10410300},
                       {1636990, 10206800},  {1650000, 10000000},
                       {1636990, 9793200},   {1598160, 9589660},
                       {1534130, 9392590},   {1445910, 9205110},
                       {1334880, 9030150},   {1202800, 8870500},
                       {1051750, 8728650},   {884113, 8606860},
                       {702536, 8507040},    {509877, 8430760},
                       {309178, 8379229},    {103604, 8353260},
                   },
               }},
    },
    ExPolygons{
        // "z-screw-cover.stl":
        MyPoly{{
                   {836227, -7956170},   {927804, -7941670},
                   {964293, -7941670},   {1029899, -7925500},
                   {1663290, -7825180},  {2472140, -7608450},
                   {2751896, -7501064},  {2836840, -7480130},
                   {2919650, -7436670},  {3253890, -7308360},
                   {4000000, -6928200},  {4470019, -6622970},
                   {4544520, -6583870},  {4583731, -6549125},
                   {4702280, -6472140},  {5353040, -5945160},
                   {5945160, -5353040},  {5973910, -5317540},
                   {5988090, -5304980},  {6011204, -5271483},
                   {6472140, -4702280},  {6928200, -4000000},
                   {7039150, -3782250},  {7083650, -3717780},
                   {7117560, -3628360},  {7308360, -3253890},
                   {7608450, -2472140},  {7734580, -2001420},
                   {7767530, -1914530},  {7775550, -1848520},
                   {7825180, -1663290},  {7956170, -836227},
                   {8000000, 0},         {7956170, 836227},
                   {7825180, 1663290},   {7775550, 1848520},
                   {7767530, 1914530},   {7734580, 2001420},
                   {7608450, 2472140},   {7308360, 3253890},
                   {7117560, 3628360},   {7083650, 3717780},
                   {7039150, 3782250},   {6928200, 4000000},
                   {6472140, 4702280},   {6011204, 5271483},
                   {5988090, 5304980},   {5973910, 5317540},
                   {5945160, 5353040},   {5353040, 5945160},
                   {4702280, 6472140},   {4583731, 6549125},
                   {4544520, 6583870},   {4470019, 6622970},
                   {4000000, 6928200},   {3253890, 7308360},
                   {2919650, 7436670},   {2836840, 7480130},
                   {2751896, 7501064},   {2472140, 7608450},
                   {1663290, 7825180},   {1029899, 7925500},
                   {964293, 7941670},    {927804, 7941670},
                   {836227, 7956170},    {0, 8000000},
                   {-836227, 7956170},   {-927804, 7941670},
                   {-964293, 7941670},   {-1029899, 7925500},
                   {-1663290, 7825180},  {-2472140, 7608450},
                   {-2751896, 7501064},  {-2836840, 7480130},
                   {-2919650, 7436670},  {-3253890, 7308360},
                   {-4000000, 6928200},  {-4470019, 6622970},
                   {-4544520, 6583870},  {-4583731, 6549125},
                   {-4702280, 6472140},  {-5353040, 5945160},
                   {-5945160, 5353040},  {-5973910, 5317540},
                   {-5988090, 5304980},  {-6011204, 5271483},
                   {-6472140, 4702280},  {-6928200, 4000000},
                   {-7039150, 3782250},  {-7083650, 3717780},
                   {-7117560, 3628360},  {-7308360, 3253890},
                   {-7608450, 2472140},  {-7734580, 2001420},
                   {-7767530, 1914530},  {-7775550, 1848520},
                   {-7825180, 1663290},  {-7956170, 836227},
                   {-8000000, 0},        {-7956170, -836227},
                   {-7825180, -1663290}, {-7775550, -1848520},
                   {-7767530, -1914530}, {-7734580, -2001420},
                   {-7608450, -2472140}, {-7308360, -3253890},
                   {-7117560, -3628360}, {-7083650, -3717780},
                   {-7039150, -3782250}, {-6928200, -4000000},
                   {-6472140, -4702280}, {-6011204, -5271483},
                   {-5988090, -5304980}, {-5973910, -5317540},
                   {-5945160, -5353040}, {-5353040, -5945160},
                   {-4702280, -6472140}, {-4583731, -6549125},
                   {-4544520, -6583870}, {-4470019, -6622970},
                   {-4000000, -6928200}, {-3253890, -7308360},
                   {-2919650, -7436670}, {-2836840, -7480130},
                   {-2751896, -7501064}, {-2472140, -7608450},
                   {-1663290, -7825180}, {-1029899, -7925500},
                   {-964293, -7941670},  {-927804, -7941670},
                   {-836227, -7956170},  {0, -8000000},
               },
               {
                   {
                       {400000, -3200000},   {-400000, -3200000},
                       {-440000, -3400000},  {-799999, -3400000},
                       {-875001, -3600000},  {-1300000, -3600000},
                       {-1416318, -3948965}, {-1708290, -3836890},
                       {-2100000, -3637310}, {-2468700, -3397870},
                       {-2810350, -3121210}, {-3121210, -2810350},
                       {-3397870, -2468700}, {-3637310, -2100000},
                       {-3836890, -1708290}, {-3994440, -1297870},
                       {-4108220, -873229},  {-4152979, -590596},
                       {-3200000, -400000},  {-3200000, 400000},
                       {-3400000, 440000},   {-3400000, 799999},
                       {-3600000, 874998},   {-3600000, 1300000},
                       {-3948965, 1416318},  {-3836890, 1708290},
                       {-3637310, 2100000},  {-3397870, 2468700},
                       {-3121210, 2810350},  {-2810350, 3121210},
                       {-2468700, 3397870},  {-2100000, 3637310},
                       {-1708290, 3836890},  {-1297870, 3994440},
                       {-873229, 4108220},   {-590596, 4152979},
                       {-400000, 3200000},   {400000, 3200000},
                       {440000, 3400000},    {799999, 3400000},
                       {874998, 3600000},    {1300000, 3600000},
                       {1416318, 3948965},   {1708290, 3836890},
                       {2100000, 3637310},   {2468700, 3397870},
                       {2810350, 3121210},   {3121210, 2810350},
                       {3397870, 2468700},   {3637310, 2100000},
                       {3836890, 1708290},   {3994440, 1297870},
                       {4108220, 873229},    {4152979, 590596},
                       {3200000, 400000},    {3200000, -400000},
                       {3400000, -440000},   {3400000, -799999},
                       {3600000, -874998},   {3600000, -1300000},
                       {3948965, -1416318},  {3836890, -1708290},
                       {3637310, -2100000},  {3397870, -2468700},
                       {3121210, -2810350},  {2810350, -3121210},
                       {2468700, -3397870},  {2100000, -3637310},
                       {1708290, -3836890},  {1297870, -3994440},
                       {873229, -4108220},   {590596, -4152979},
                   },
               }},
    },
    ExPolygons{
        // "cable-holder.stl":
        MyPoly{{
                   {-2043150, -34799100}, {-1990180, -34549300},
                   {-1988820, -34542900}, {-1986150, -34536800},
                   {-1882530, -34303500}, {-1732900, -34097100},
                   {-1728930, -34091600}, {-1723900, -34087100},
                   {-1534730, -33916300}, {-1308420, -33785400},
                   {-1059890, -33704400}, {-806907, -33677700},
                   {-799999, -33677000},  {-793091, -33677700},
                   {-540110, -33704400},  {-291578, -33785400},
                   {-65267, -33916300},   {123903, -34087100},
                   {128930, -34091600},   {132903, -34097100},
                   {282532, -34303500},   {386150, -34536800},
                   {388820, -34542900},   {390183, -34549300},
                   {443151, -34799100},   {443151, -34908100},
                   {556848, -34908100},   {556848, -34799100},
                   {609816, -34549300},   {611179, -34542900},
                   {613849, -34536800},   {717467, -34303500},
                   {867096, -34097100},   {871069, -34091600},
                   {876096, -34087100},   {1065270, -33916300},
                   {1291580, -33785400},  {1540110, -33704400},
                   {1793090, -33677700},  {1800000, -33677000},
                   {1806910, -33677700},  {2059890, -33704400},
                   {2308420, -33785400},  {2534730, -33916300},
                   {2723900, -34087100},  {2728930, -34091600},
                   {2732900, -34097100},  {2882530, -34303500},
                   {2986150, -34536800},  {2988820, -34542900},
                   {2990180, -34549300},  {3043150, -34799100},
                   {3043150, -34908100},  {4000000, -34908100},
                   {4000000, -29539900},  {4215720, -29345700},
                   {4830130, -28500000},  {5255280, -27545100},
                   {5472610, -26522600},  {5472610, -26000000},
                   {5500000, -26000000},  {5500000, -17000000},
                   {4805710, -17000000},  {4215720, -17815100},
                   {3438930, -18517200},  {2533680, -19041900},
                   {1539560, -19366100},  {499999, -19475800},
                   {-539558, -19366100},  {-1533680, -19041900},
                   {-2438930, -18517200}, {-3215720, -17815100},
                   {-3805710, -17000000}, {-4500000, -17000000},
                   {-4500000, -26000000}, {-4472610, -26000000},
                   {-4472610, -26522600}, {-4255280, -27545100},
                   {-3830130, -28500000}, {-3215720, -29345700},
                   {-3000000, -29539900}, {-3000000, -34908100},
                   {-2043150, -34908100},
               },
               {
                   {
                       {136154, -28711800},   {-211788, -28598700},
                       {-382749, -28500000},  {-528624, -28415800},
                       {-800503, -28171000},  {-1015540, -27875000},
                       {-1164350, -27540800}, {-1240410, -27182900},
                       {-1240410, -26817100}, {-1164350, -26459200},
                       {-1015540, -26125000}, {-800503, -25829000},
                       {-528624, -25584200},  {-382751, -25500000},
                       {-211788, -25401300},  {136154, -25288200},
                       {500000, -25250000},   {863845, -25288200},
                       {1211790, -25401300},  {1382750, -25500000},
                       {1528620, -25584200},  {1800500, -25829000},
                       {2015539, -26125000},  {2164350, -26459200},
                       {2240410, -26817100},  {2240410, -27182900},
                       {2164350, -27540800},  {2015539, -27875000},
                       {1800500, -28171000},  {1528620, -28415800},
                       {1382750, -28500000},  {1211790, -28598700},
                       {863845, -28711800},   {499999, -28750000},
                   },
               }},
    },
    ExPolygons{
        // "Einsy-doors.stl":
        MyPoly{{
                   {105500000, 91975304},
                   {21500000, 91975304},
                   {21500000, 87500000},
                   {0, 87500000},
                   {0, 0},
                   {105500000, 0},
               },
               {
                   {
                       {46000000, 60500000},
                       {46000000, 79500000},
                       {49650000, 79500000},
                       {49650000, 60500000},
                   },
                   {
                       {58000000, 60500000},
                       {58000000, 79500000},
                       {61650000, 79500000},
                       {61650000, 60500000},
                   },
                   {
                       {70000000, 60500000},
                       {70000000, 79500000},
                       {73650000, 79500000},
                       {73650000, 60500000},
                   },
                   {
                       {64000000, 60500000},
                       {64000000, 79500000},
                       {67650000, 79500000},
                       {67650000, 60500000},
                   },
                   {
                       {94000000, 60500000},
                       {94000000, 79500000},
                       {97650000, 79500000},
                       {97650000, 60500000},
                   },
                   {
                       {52000000, 60500000},
                       {52000000, 79500000},
                       {55650000, 79500000},
                       {55650000, 60500000},
                   },
                   {
                       {88000000, 60500000},
                       {88000000, 79500000},
                       {91650000, 79500000},
                       {91650000, 60500000},
                   },
                   {
                       {82000000, 60500000},
                       {82000000, 79500000},
                       {85650000, 79500000},
                       {85650000, 60500000},
                   },
                   {
                       {40000000, 60500000},
                       {40000000, 79500000},
                       {43650000, 79500000},
                       {43650000, 60500000},
                   },
                   {
                       {76000000, 60500000},
                       {76000000, 79500000},
                       {79650000, 79500000},
                       {79650000, 60500000},
                   },
                   {
                       {52000000, 35500000},
                       {52000000, 54500000},
                       {55650000, 54500000},
                       {55650000, 35500000},
                   },
                   {
                       {40000000, 35500000},
                       {40000000, 54500000},
                       {43650000, 54500000},
                       {43650000, 35500000},
                   },
                   {
                       {58000000, 35500000},
                       {58000000, 54500000},
                       {61650000, 54500000},
                       {61650000, 35500000},
                   },
                   {
                       {76000000, 35500000},
                       {76000000, 54500000},
                       {79650000, 54500000},
                       {79650000, 35500000},
                   },
                   {
                       {94000000, 35500000},
                       {94000000, 54500000},
                       {97650000, 54500000},
                       {97650000, 35500000},
                   },
                   {
                       {82000000, 35500000},
                       {82000000, 54500000},
                       {85650000, 54500000},
                       {85650000, 35500000},
                   },
                   {
                       {64000000, 35500000},
                       {64000000, 54500000},
                       {67650000, 54500000},
                       {67650000, 35500000},
                   },
                   {
                       {70000000, 35500000},
                       {70000000, 54500000},
                       {73650000, 54500000},
                       {73650000, 35500000},
                   },
                   {
                       {46000000, 35500000},
                       {46000000, 54500000},
                       {49650000, 54500000},
                       {49650000, 35500000},
                   },
                   {
                       {88000000, 35500000},
                       {88000000, 54500000},
                       {91650000, 54500000},
                       {91650000, 35500000},
                   },
                   {
                       {40000000, 10500000},
                       {40000000, 29500000},
                       {43650000, 29500000},
                       {43650000, 10500000},
                   },
                   {
                       {82000000, 10500000},
                       {82000000, 29500000},
                       {85650000, 29500000},
                       {85650000, 10500000},
                   },
                   {
                       {94000000, 10500000},
                       {94000000, 29500000},
                       {97650000, 29500000},
                       {97650000, 10500000},
                   },
                   {
                       {88000000, 10500000},
                       {88000000, 29500000},
                       {91650000, 29500000},
                       {91650000, 10500000},
                   },
                   {
                       {76000000, 10500000},
                       {76000000, 29500000},
                       {79650000, 29500000},
                       {79650000, 10500000},
                   },
                   {
                       {64000000, 10500000},
                       {64000000, 29500000},
                       {67650000, 29500000},
                       {67650000, 10500000},
                   },
                   {
                       {52000000, 10500000},
                       {52000000, 29500000},
                       {55650000, 29500000},
                       {55650000, 10500000},
                   },
                   {
                       {70000000, 10500000},
                       {70000000, 29500000},
                       {73650000, 29500000},
                       {73650000, 10500000},
                   },
                   {
                       {46000000, 10500000},
                       {46000000, 29500000},
                       {49650000, 29500000},
                       {49650000, 10500000},
                   },
                   {
                       {58000000, 10500000},
                       {58000000, 29500000},
                       {61650000, 29500000},
                       {61650000, 10500000},
                   },
               }},
    },
    ExPolygons{
        // "y-motor-holder.stl":
        MyPoly{{
                   {47000000, 0},        {47000000, 15000000},
                   {42000000, 20000000}, {37468500, 20000000},
                   {37500000, 19500000}, {37409300, 18058700},
                   {37138700, 16640100}, {36692400, 15266600},
                   {36077500, 13959800}, {35303700, 12740500},
                   {34383100, 11627700}, {33330398, 10639100},
                   {32161998, 9790230},  {30896500, 9094490},
                   {29553700, 8562850},  {28154900, 8203700},
                   {26722100, 8022690},  {25277900, 8022690},
                   {23845100, 8203700},  {22446300, 8562850},
                   {21103500, 9094490},  {19838000, 9790230},
                   {18669600, 10639100}, {17616900, 11627700},
                   {16696301, 12740500}, {15922500, 13959800},
                   {15307600, 15266600}, {14861300, 16640100},
                   {14590700, 18058700}, {14500000, 19500000},
                   {14590700, 20941300}, {14861300, 22359900},
                   {15000000, 22786800}, {15000000, 38000000},
                   {12500000, 40500000}, {9642140, 40500000},
                   {71067, 30928900},    {0, 31000000},
                   {0, -1500000},        {45500000, -1500000},
               },
               {
                   {
                       {10396400, 33353298}, {10190800, 33379200},
                       {9990120, 33430802},  {9797460, 33507000},
                       {9615890, 33606900},  {9448250, 33728700},
                       {9297200, 33870500},  {9165120, 34030200},
                       {9054090, 34205100},  {8965870, 34392600},
                       {8901840, 34589700},  {8863010, 34793200},
                       {8850000, 35000000},  {8863010, 35206800},
                       {8901840, 35410300},  {8965870, 35607400},
                       {9054090, 35794900},  {9165120, 35969800},
                       {9297200, 36129500},  {9448250, 36271300},
                       {9615890, 36393100},  {9797460, 36493000},
                       {9990120, 36569200},  {10190800, 36620800},
                       {10396400, 36646700}, {10603600, 36646700},
                       {10809200, 36620800}, {11009900, 36569200},
                       {11202500, 36493000}, {11384100, 36393100},
                       {11551700, 36271300}, {11702800, 36129500},
                       {11834900, 35969800}, {11945900, 35794900},
                       {12034100, 35607400}, {12098200, 35410300},
                       {12137000, 35206800}, {12150000, 35000000},
                       {12137000, 34793200}, {12098200, 34589700},
                       {12034100, 34392600}, {11945900, 34205100},
                       {11834900, 34030200}, {11702800, 33870500},
                       {11551700, 33728700}, {11384100, 33606900},
                       {11202500, 33507000}, {11009900, 33430802},
                       {10809200, 33379200}, {10603600, 33353298},
                   },
                   {
                       {41396400, 2353260}, {41190800, 2379230},
                       {40990100, 2430760}, {40797500, 2507040},
                       {40615900, 2606860}, {40448200, 2728650},
                       {40297200, 2870500}, {40165100, 3030150},
                       {40054100, 3205110}, {39965900, 3392590},
                       {39901800, 3589660}, {39863000, 3793200},
                       {39850000, 4000000}, {39863000, 4206800},
                       {39901800, 4410340}, {39965900, 4607400},
                       {40054100, 4794890}, {40165100, 4969840},
                       {40297200, 5129500}, {40448200, 5271350},
                       {40615900, 5393140}, {40797500, 5492960},
                       {40990100, 5569240}, {41190800, 5620770},
                       {41396400, 5646740}, {41603600, 5646740},
                       {41809200, 5620770}, {42009900, 5569240},
                       {42202500, 5492960}, {42384100, 5393140},
                       {42551800, 5271350}, {42702800, 5129500},
                       {42834900, 4969840}, {42945900, 4794890},
                       {43034100, 4607400}, {43098200, 4410340},
                       {43137000, 4206800}, {43150000, 4000000},
                       {43137000, 3793200}, {43098200, 3589660},
                       {43034100, 3392590}, {42945900, 3205110},
                       {42834900, 3030150}, {42702800, 2870500},
                       {42551800, 2728650}, {42384100, 2606860},
                       {42202500, 2507040}, {42009900, 2430760},
                       {41809200, 2379230}, {41603600, 2353260},
                   },
               }},
    },
    ExPolygons{
        // "heatbed-cable-cover.stl":
        MyPoly{{
                   {15000000, 48000000},
                   {11000000, 52000000},
                   {-11000000, 52000000},
                   {-15000000, 48000000},
                   {-15000000, 35500000},
                   {15000000, 35500000},
               },
               {
                   {
                       {-10100500, 43403200}, {-10299800, 43428300},
                       {-10494400, 43478300}, {-10681200, 43552300},
                       {-10857300, 43649100}, {-11019900, 43767200},
                       {-11166300, 43904700}, {-11294400, 44059500},
                       {-11402100, 44229200}, {-11487600, 44411000},
                       {-11549700, 44602100}, {-11587400, 44799500},
                       {-11600000, 45000000}, {-11587400, 45200500},
                       {-11549700, 45397900}, {-11487600, 45589000},
                       {-11402100, 45770800}, {-11294400, 45940500},
                       {-11166300, 46095300}, {-11019900, 46232800},
                       {-10857300, 46350900}, {-10681200, 46447700},
                       {-10494400, 46521700}, {-10299800, 46571700},
                       {-10100500, 46596800}, {-9899530, 46596800},
                       {-9700190, 46571700},  {-9505570, 46521700},
                       {-9318750, 46447700},  {-9142680, 46350900},
                       {-8980120, 46232800},  {-8833650, 46095300},
                       {-8705570, 45940500},  {-8597910, 45770800},
                       {-8512360, 45589000},  {-8450270, 45397900},
                       {-8412620, 45200500},  {-8400000, 45000000},
                       {-8412620, 44799500},  {-8450270, 44602100},
                       {-8512360, 44411000},  {-8597910, 44229200},
                       {-8705570, 44059500},  {-8833650, 43904700},
                       {-8980120, 43767200},  {-9142680, 43649100},
                       {-9318750, 43552300},  {-9505570, 43478300},
                       {-9700190, 43428300},  {-9899530, 43403200},
                   },
                   {
                       {9899530, 43403200},  {9700190, 43428300},
                       {9505570, 43478300},  {9318750, 43552300},
                       {9142680, 43649100},  {8980120, 43767200},
                       {8833650, 43904700},  {8705570, 44059500},
                       {8597910, 44229200},  {8512360, 44411000},
                       {8450270, 44602100},  {8412620, 44799500},
                       {8400000, 45000000},  {8412620, 45200500},
                       {8450270, 45397900},  {8512360, 45589000},
                       {8597910, 45770800},  {8705570, 45940500},
                       {8833650, 46095300},  {8980120, 46232800},
                       {9142680, 46350900},  {9318750, 46447700},
                       {9505570, 46521700},  {9700190, 46571700},
                       {9899530, 46596800},  {10100500, 46596800},
                       {10299800, 46571700}, {10494400, 46521700},
                       {10681200, 46447700}, {10857300, 46350900},
                       {11019900, 46232800}, {11166300, 46095300},
                       {11294400, 45940500}, {11402100, 45770800},
                       {11487600, 45589000}, {11549700, 45397900},
                       {11587400, 45200500}, {11600000, 45000000},
                       {11587400, 44799500}, {11549700, 44602100},
                       {11487600, 44411000}, {11402100, 44229200},
                       {11294400, 44059500}, {11166300, 43904700},
                       {11019900, 43767200}, {10857300, 43649100},
                       {10681200, 43552300}, {10494400, 43478300},
                       {10299800, 43428300}, {10100500, 43403200},
                   },
               }},
        MyPoly{{
                   {18000000, 25000000},
                   {16426001, 26574000},
                   {11000000, 32000000},
                   {-11000000, 32000000},
                   {-18000000, 25000000},
                   {-18000000, 0},
                   {18000000, 0},
               },
               {
                   {
                       {-10100500, 23403200}, {-10299800, 23428300},
                       {-10494400, 23478300}, {-10681200, 23552300},
                       {-10857300, 23649100}, {-11019900, 23767200},
                       {-11166300, 23904700}, {-11294400, 24059500},
                       {-11402100, 24229200}, {-11487600, 24411000},
                       {-11549700, 24602100}, {-11587400, 24799500},
                       {-11600000, 25000000}, {-11587400, 25200500},
                       {-11549700, 25397900}, {-11487600, 25589000},
                       {-11402100, 25770800}, {-11294400, 25940500},
                       {-11166300, 26095300}, {-11019900, 26232800},
                       {-10857300, 26350900}, {-10681200, 26447700},
                       {-10494400, 26521700}, {-10299800, 26571700},
                       {-10100500, 26596800}, {-9899530, 26596800},
                       {-9700190, 26571700},  {-9505570, 26521700},
                       {-9318750, 26447700},  {-9142680, 26350900},
                       {-8980120, 26232800},  {-8833650, 26095300},
                       {-8705570, 25940500},  {-8597910, 25770800},
                       {-8512360, 25589000},  {-8450270, 25397900},
                       {-8412620, 25200500},  {-8400000, 25000000},
                       {-8412620, 24799500},  {-8450270, 24602100},
                       {-8512360, 24411000},  {-8597910, 24229200},
                       {-8705570, 24059500},  {-8833650, 23904700},
                       {-8980120, 23767200},  {-9142680, 23649100},
                       {-9318750, 23552300},  {-9505570, 23478300},
                       {-9700190, 23428300},  {-9899530, 23403200},
                   },
                   {
                       {9899530, 23403200},  {9700190, 23428300},
                       {9505570, 23478300},  {9318750, 23552300},
                       {9142680, 23649100},  {8980120, 23767200},
                       {8833650, 23904700},  {8705570, 24059500},
                       {8597910, 24229200},  {8512360, 24411000},
                       {8450270, 24602100},  {8412620, 24799500},
                       {8400000, 25000000},  {8412620, 25200500},
                       {8450270, 25397900},  {8512360, 25589000},
                       {8597910, 25770800},  {8705570, 25940500},
                       {8833650, 26095300},  {8980120, 26232800},
                       {9142680, 26350900},  {9318750, 26447700},
                       {9505570, 26521700},  {9700190, 26571700},
                       {9899530, 26596800},  {10100500, 26596800},
                       {10299800, 26571700}, {10494400, 26521700},
                       {10681200, 26447700}, {10857300, 26350900},
                       {11019900, 26232800}, {11166300, 26095300},
                       {11294400, 25940500}, {11402100, 25770800},
                       {11487600, 25589000}, {11549700, 25397900},
                       {11587400, 25200500}, {11600000, 25000000},
                       {11587400, 24799500}, {11549700, 24602100},
                       {11487600, 24411000}, {11402100, 24229200},
                       {11294400, 24059500}, {11166300, 23904700},
                       {11019900, 23767200}, {10857300, 23649100},
                       {10681200, 23552300}, {10494400, 23478300},
                       {10299800, 23428300}, {10100500, 23403200},
                   },
                   {
                       {-100465, 5903160},  {-299809, 5928340},
                       {-494427, 5978310},  {-681247, 6052280},
                       {-857323, 6149070},  {-1019880, 6267180},
                       {-1166350, 6404720}, {-1294430, 6559540},
                       {-1402090, 6729190}, {-1487640, 6911000},
                       {-1549730, 7102100}, {-1587380, 7299470},
                       {-1600000, 7500000}, {-1587380, 7700530},
                       {-1549730, 7897900}, {-1487640, 8088999},
                       {-1402090, 8270810}, {-1294430, 8440460},
                       {-1166350, 8595270}, {-1019880, 8732820},
                       {-857323, 8850920},  {-681247, 8947720},
                       {-494427, 9021690},  {-299809, 9071660},
                       {-100465, 9096840},  {100465, 9096840},
                       {299809, 9071660},   {494427, 9021690},
                       {681247, 8947720},   {857323, 8850920},
                       {1019880, 8732820},  {1166350, 8595270},
                       {1294430, 8440460},  {1402090, 8270810},
                       {1487640, 8088999},  {1549730, 7897900},
                       {1587380, 7700530},  {1600000, 7500000},
                       {1587380, 7299470},  {1549730, 7102100},
                       {1487640, 6911000},  {1402090, 6729190},
                       {1294430, 6559540},  {1166350, 6404720},
                       {1019880, 6267180},  {857323, 6149070},
                       {681247, 6052280},   {494427, 5978310},
                       {299809, 5928340},   {100465, 5903160},
                   },
               }},
    },
    ExPolygons{
        // "y-rod-holder.stl":
        MyPoly{{
                   {-4130159, -11630200}, {-4125905, -11625938},
                   {-4036359, -11536400}, {-3977214, -11477197},
                   {-3893620, -11393600}, {-3968460, -11001300},
                   {-4000000, -10500000}, {-3968460, -9998670},
                   {-3874330, -9505240},  {-3719110, -9027500},
                   {-3505230, -8572980},  {-3236070, -8148860},
                   {-2915870, -7761810},  {-2549700, -7417950},
                   {-2143310, -7122690},  {-1920140, -7000000},
                   {-1703120, -6880690},  {-1236070, -6695770},
                   {-749525, -6570850},   {-251162, -6507890},
                   {251162, -6507890},    {749525, -6570850},
                   {1236070, -6695770},   {1703120, -6880690},
                   {1920140, -7000000},   {2143310, -7122690},
                   {2549700, -7417950},   {2915870, -7761810},
                   {3236070, -8148860},   {3505230, -8572980},
                   {3719110, -9027500},   {3874330, -9505240},
                   {3968460, -9998670},   {4000000, -10500000},
                   {3968460, -11001300},  {3916390, -11274300},
                   {4089891, -11447789},  {4113299, -11471200},
                   {4642140, -12000000},  {8618800, -12000000},
                   {10350900, -9000000},  {11376300, -7223940},
                   {13000000, -4411540},  {13000000, 0},
                   {4000000, 0},          {4000000, 1500000},
                   {-4000000, 1500000},   {-4000000, 0},
                   {-13000000, 0},        {-13000000, -4202820},
                   {-8498290, -12000000}, {-4500000, -12000000},
               },
               {}},
    },
    ExPolygons{
        // "extruder-body.stl":
        MyPoly{{
                   {32000000, -41357900},  {32000000, -34500000},
                   {27500000, -30000000},  {22600000, -30000000},
                   {22600000, -29900000},  {22500000, -30000000},
                   {17000000, -24500000},  {17000000, -12000000},
                   {23000000, -12000000},  {23000000, -18000000},
                   {23928900, -18000000},  {26000000, -15928900},
                   {26000000, -10000000},  {23000000, -7000000},
                   {17000000, -7000000},   {17000000, 44000000},
                   {11000000, 50000000},   {-18000000, 50000000},
                   {-25000000, 43000000},  {-25000000, 5750000},
                   {-27250000, 5750000},   {-31500000, 1500000},
                   {-31500000, -1500000},  {-24500000, -1500000},
                   {-24500000, 2500000},   {-21309400, 2500000},
                   {-20500000, 1098080},   {-20500000, -44000000},
                   {-15500000, -44000000}, {-15500000, -38000000},
                   {-14000000, -36500000}, {14000000, -36500000},
                   {14000000, -38916000},  {14423151, -39823468},
                   {14452100, -39885600},  {15259800, -41617700},
                   {18642100, -45000000},  {28357900, -45000000},
               },
               {
                   {
                       {-19603600, 40853300}, {-19790500, 40876900},
                       {-19809200, 40879200}, {-19991600, 40926100},
                       {-20009900, 40930800}, {-20202500, 41007000},
                       {-20384100, 41106900}, {-20491899, 41185194},
                       {-20551700, 41228700}, {-20551800, 41228700},
                       {-20702800, 41370500}, {-20834900, 41530200},
                       {-20945900, 41705100}, {-21034100, 41892600},
                       {-21098200, 42089700}, {-21137000, 42293200},
                       {-21150000, 42500000}, {-21137000, 42706800},
                       {-21098200, 42910300}, {-21034100, 43107400},
                       {-20945900, 43294900}, {-20834900, 43469800},
                       {-20702800, 43629500}, {-20551800, 43771300},
                       {-20551700, 43771300}, {-20491899, 43814806},
                       {-20384100, 43893100}, {-20202500, 43993000},
                       {-20009900, 44069200}, {-19991600, 44073900},
                       {-19809200, 44120800}, {-19790500, 44123100},
                       {-19603600, 44146700}, {-19396400, 44146700},
                       {-19209500, 44123100}, {-19190800, 44120800},
                       {-19008400, 44073900}, {-18990100, 44069200},
                       {-18797500, 43993000}, {-18615900, 43893100},
                       {-18448200, 43771300}, {-18297200, 43629500},
                       {-18165100, 43469800}, {-18054100, 43294900},
                       {-17965900, 43107400}, {-17901800, 42910300},
                       {-17863000, 42706800}, {-17850000, 42500000},
                       {-17863000, 42293200}, {-17901800, 42089700},
                       {-17965900, 41892600}, {-18054100, 41705100},
                       {-18165100, 41530200}, {-18297200, 41370500},
                       {-18448200, 41228700}, {-18615900, 41106900},
                       {-18797500, 41007000}, {-18990100, 40930800},
                       {-19008400, 40926100}, {-19190800, 40879200},
                       {-19209500, 40876900}, {-19396400, 40853300},
                   },
                   {
                       {11396400, 40853300}, {11190800, 40879200},
                       {10990100, 40930800}, {10797500, 41007000},
                       {10615900, 41106900}, {10448200, 41228700},
                       {10297200, 41370500}, {10165100, 41530200},
                       {10054100, 41705100}, {9965870, 41892600},
                       {9901840, 42089700},  {9863010, 42293200},
                       {9850000, 42500000},  {9863010, 42706800},
                       {9901840, 42910300},  {9965870, 43107400},
                       {10054100, 43294900}, {10165100, 43469800},
                       {10297200, 43629500}, {10448200, 43771300},
                       {10615900, 43893100}, {10797500, 43993000},
                       {10990100, 44069200}, {11190800, 44120800},
                       {11396400, 44146700}, {11603600, 44146700},
                       {11809200, 44120800}, {12009900, 44069200},
                       {12202500, 43993000}, {12384100, 43893100},
                       {12551700, 43771300}, {12702800, 43629500},
                       {12834900, 43469800}, {12945900, 43294900},
                       {13034100, 43107400}, {13098200, 42910300},
                       {13137000, 42706800}, {13150000, 42500000},
                       {13137000, 42293200}, {13098200, 42089700},
                       {13034100, 41892600}, {12945900, 41705100},
                       {12834900, 41530200}, {12702800, 41370500},
                       {12551700, 41228700}, {12384100, 41106900},
                       {12202500, 41007000}, {12009900, 40930800},
                       {11809200, 40879200}, {11603600, 40853300},
                   },
                   {
                       {-3181780, 21500000},  {-15111782, 22578598},
                       {-15737800, 24505100}, {-15797300, 25071800},
                       {-15997500, 26976600}, {-16000000, 27000000},
                       {-15737800, 29494900}, {-14962500, 31880800},
                       {-13708200, 34053400}, {-12029600, 35917700},
                       {-10000000, 37392300}, {-8500000, 38060100},
                       {-7708200, 38412700},  {-5282850, 38928200},
                       {-5254340, 38934300},  {-3000000, 38934300},
                       {-3000000, 33500000},  {-1092350, 31592300},
                       {-1091812, 31591773},  {-1065440, 31565400},
                       {-1063162, 31563127},  {-963937, 31463900},
                       {-889918, 31389900},   {-860013, 31360013},
                       {-612800, 31112800},   {-589409, 31089400},
                       {-366049, 30866044},   {-339918, 30839900},
                       {-206119, 30706100},   {0, 30500000},
                       {206119, 30706100},    {339918, 30839900},
                       {362385, 30862377},    {889918, 31389900},
                       {963937, 31463900},    {1063442, 31563406},
                       {1065440, 31565400},   {1091822, 31591782},
                       {1092350, 31592300},   {4000000, 34500000},
                       {4000000, 35939184},   {4029570, 35917700},
                       {5708200, 34053400},   {6962550, 31880800},
                       {7737770, 29494900},   {8000000, 27000000},
                       {7737770, 24505100},   {6962550, 22119200},
                       {6605070, 21500000},   {1727920, 21500000},
                       {1698940, 21529000},   {1530830, 21697100},
                       {1516490, 21711437},   {1125240, 22102700},
                       {894136, 22333800},    {648935, 22579000},
                       {318574, 22909343},    {131860, 23096100},
                       {0, 23227900},         {-131860, 23096100},
                       {-318574, 22909343},   {-648935, 22579000},
                       {-894136, 22333800},   {-1125240, 22102700},
                       {-1516490, 21711437},  {-1530830, 21697100},
                       {-1698940, 21529000},  {-1727920, 21500000},
                   },
                   {
                       {-19603600, 9853260},  {-19809200, 9879230},
                       {-20009900, 9930760},  {-20202500, 10007000},
                       {-20384100, 10106900}, {-20551800, 10228700},
                       {-20702800, 10370500}, {-20834900, 10530200},
                       {-20945900, 10705100}, {-21034100, 10892600},
                       {-21098200, 11089700}, {-21137000, 11293200},
                       {-21150000, 11500000}, {-21137000, 11706800},
                       {-21098200, 11910300}, {-21034100, 12107400},
                       {-20945900, 12294900}, {-20834900, 12469800},
                       {-20702800, 12629500}, {-20551800, 12771300},
                       {-20384100, 12893100}, {-20202500, 12993000},
                       {-20009900, 13069200}, {-19809200, 13120800},
                       {-19603600, 13146700}, {-19396400, 13146700},
                       {-19190800, 13120800}, {-18990100, 13069200},
                       {-18797500, 12993000}, {-18615900, 12893100},
                       {-18448200, 12771300}, {-18297200, 12629500},
                       {-18165100, 12469800}, {-18054100, 12294900},
                       {-17965900, 12107400}, {-17901800, 11910300},
                       {-17863000, 11706800}, {-17850000, 11500000},
                       {-17863000, 11293200}, {-17901800, 11089700},
                       {-17965900, 10892600}, {-18054100, 10705100},
                       {-18165100, 10530200}, {-18297200, 10370500},
                       {-18448200, 10228700}, {-18615900, 10106900},
                       {-18797500, 10007000}, {-18990100, 9930760},
                       {-19190800, 9879230},  {-19396400, 9853260},
                   },
                   {
                       {11396400, 9853260},  {11190800, 9879230},
                       {10990100, 9930760},  {10797500, 10007000},
                       {10615900, 10106900}, {10448200, 10228700},
                       {10297200, 10370500}, {10165100, 10530200},
                       {10054100, 10705100}, {9965870, 10892600},
                       {9901840, 11089700},  {9863010, 11293200},
                       {9850000, 11500000},  {9863010, 11706800},
                       {9901840, 11910300},  {9965870, 12107400},
                       {10054100, 12294900}, {10165100, 12469800},
                       {10297200, 12629500}, {10448200, 12771300},
                       {10615900, 12893100}, {10797500, 12993000},
                       {10990100, 13069200}, {11190800, 13120800},
                       {11396400, 13146700}, {11603600, 13146700},
                       {11809200, 13120800}, {12009900, 13069200},
                       {12202500, 12993000}, {12384100, 12893100},
                       {12551700, 12771300}, {12702800, 12629500},
                       {12834900, 12469800}, {12945900, 12294900},
                       {13034100, 12107400}, {13098200, 11910300},
                       {13137000, 11706800}, {13150000, 11500000},
                       {13137000, 11293200}, {13098200, 11089700},
                       {13034100, 10892600}, {12945900, 10705100},
                       {12834900, 10530200}, {12702800, 10370500},
                       {12551700, 10228700}, {12384100, 10106900},
                       {12202500, 10007000}, {12009900, 9930760},
                       {11809200, 9879230},  {11603600, 9853260},
                   },
                   {
                       {-17177700, 1309310}, {-17525300, 1383200},
                       {-17850000, 1527760}, {-18137500, 1736650},
                       {-18375300, 2000760}, {-18553000, 2308550},
                       {-18662800, 2646550}, {-18700000, 3000000},
                       {-18662800, 3353450}, {-18553000, 3691450},
                       {-18375300, 3999230}, {-18137500, 4263350},
                       {-17850000, 4472240}, {-17525300, 4616800},
                       {-17177700, 4690690}, {-16822300, 4690690},
                       {-16474701, 4616800}, {-16150000, 4472240},
                       {-15862500, 4263350}, {-15624700, 3999230},
                       {-15447000, 3691450}, {-15337100, 3353450},
                       {-15300000, 3000000}, {-15337100, 2646550},
                       {-15447000, 2308550}, {-15624700, 2000760},
                       {-15862500, 1736650}, {-16150000, 1527760},
                       {-16474701, 1383200}, {-16822300, 1309310},
                   },
                   {
                       {-11603600, -2146740}, {-11809200, -2120770},
                       {-12009900, -2069240}, {-12202500, -1992960},
                       {-12384100, -1893140}, {-12551700, -1771350},
                       {-12702800, -1629500}, {-12834900, -1469840},
                       {-12945900, -1294890}, {-13034100, -1107400},
                       {-13098200, -910337},  {-13137000, -706800},
                       {-13150000, -500000},  {-13137000, -293200},
                       {-13098200, -89661},   {-13034100, 107405},
                       {-12945900, 294893},   {-12834900, 469845},
                       {-12702800, 629502},   {-12551700, 771346},
                       {-12384100, 893141},   {-12202500, 992964},
                       {-12009900, 1069240},  {-11809200, 1120770},
                       {-11603600, 1146740},  {-11396400, 1146740},
                       {-11190800, 1120770},  {-10990100, 1069240},
                       {-10797500, 992964},   {-10615900, 893141},
                       {-10448200, 771346},   {-10297200, 629502},
                       {-10165100, 469845},   {-10054100, 294893},
                       {-9965870, 107405},    {-9901840, -89661},
                       {-9863010, -293200},   {-9850000, -499999},
                       {-9863010, -706800},   {-9901840, -910337},
                       {-9965870, -1107400},  {-10054100, -1294890},
                       {-10165100, -1469840}, {-10297200, -1629500},
                       {-10448200, -1771350}, {-10615900, -1893140},
                       {-10797500, -1992960}, {-10990100, -2069240},
                       {-11190800, -2120770}, {-11396400, -2146740},
                   },
                   {
                       {11396400, -2146740}, {11190800, -2120770},
                       {10990100, -2069240}, {10797500, -1992960},
                       {10615900, -1893140}, {10448200, -1771350},
                       {10297200, -1629500}, {10165100, -1469840},
                       {10054100, -1294890}, {9965870, -1107400},
                       {9901840, -910337},   {9863010, -706800},
                       {9850000, -500000},   {9863010, -293200},
                       {9901840, -89661},    {9965870, 107405},
                       {10054100, 294893},   {10165100, 469845},
                       {10297200, 629502},   {10448200, 771346},
                       {10615900, 893141},   {10797500, 992964},
                       {10990100, 1069240},  {11190800, 1120770},
                       {11396400, 1146740},  {11603600, 1146740},
                       {11809200, 1120770},  {12009900, 1069240},
                       {12202500, 992964},   {12384100, 893141},
                       {12551700, 771346},   {12702800, 629502},
                       {12834900, 469845},   {12945900, 294893},
                       {13034100, 107405},   {13098200, -89661},
                       {13137000, -293200},  {13150000, -499999},
                       {13137000, -706800},  {13098200, -910337},
                       {13034100, -1107400}, {12945900, -1294890},
                       {12834900, -1469840}, {12702800, -1629500},
                       {12551700, -1771350}, {12384100, -1893140},
                       {12202500, -1992960}, {12009900, -2069240},
                       {11809200, -2120770}, {11603600, -2146740},
                   },
               }},
    },
    ExPolygons{
        // "z-axis-top.stl":
        MyPoly{{
                   {34521100, -3478930},
                   {38000000, 0},
                   {38000000, 23000000},
                   {33000000, 28000000},
                   {24000000, 28000000},
                   {20000000, 21071800},
                   {12000000, 21071800},
                   {8000000, 28000000},
                   {8000000, 34200000},
                   {2200000, 40000000},
                   {0, 40000000},
                   {0, 1000000},
                   {6000000, -5000000},
                   {33000000, -5000000},
               },
               {
                   {
                       {12000000, 3071800},
                       {8000000, 10000000},
                       {12000000, 16928200},
                       {20000000, 16928200},
                       {24000000, 10000000},
                       {20000000, 3071800},
                   },
               }},
        MyPoly{{
                   {8000000, -46200000},
                   {8000000, -40000000},
                   {12000000, -33071800},
                   {20000000, -33071800},
                   {24000000, -40000000},
                   {33000000, -40000000},
                   {38000000, -35000000},
                   {38000000, -12000000},
                   {34521100, -8521070},
                   {33000000, -7000000},
                   {6000000, -7000000},
                   {0, -13000000},
                   {0, -52000000},
                   {2200000, -52000000},
               },
               {
                   {
                       {12000000, -28928200},
                       {8000000, -22000000},
                       {12000000, -15071800},
                       {20000000, -15071800},
                       {24000000, -22000000},
                       {20000000, -28928200},
                   },
               }},
    },
    ExPolygons{
        // "y-belt-holder.stl":
        MyPoly{{
                   {12500000, 24000000},
                   {5142140, 24000000},
                   {4500000, 23357900},
                   {4500000, 15000000},
                   {-9057860, 15000000},
                   {-11000000, 13057900},
                   {-11000000, -13057900},
                   {-9057860, -15000000},
                   {4500000, -15000000},
                   {4500000, -23357900},
                   {5142140, -24000000},
                   {12500000, -24000000},
               },
               {}},
    },
    ExPolygons{
        // "LCD-knob.stl":
        MyPoly{{
                   {1045280, -9945220},  {2079119, -9781480},
                   {3090170, -9510560},  {4067370, -9135450},
                   {5000000, -8660250},  {5877850, -8090170},
                   {6691310, -7431450},  {7431450, -6691310},
                   {8090170, -5877850},  {8660250, -5000000},
                   {9135450, -4067370},  {9510560, -3090170},
                   {9781480, -2079119},  {9945220, -1045280},
                   {10000000, 0},        {9945220, 1045280},
                   {9781480, 2079119},   {9510560, 3090170},
                   {9135450, 4067370},   {8660250, 5000000},
                   {8090170, 5877850},   {7431450, 6691310},
                   {6691310, 7431450},   {5877850, 8090170},
                   {5000000, 8660250},   {4067370, 9135450},
                   {3090170, 9510560},   {2100000, 9775880},
                   {2100000, 18221800},  {-2100000, 18221800},
                   {-2100000, 9775880},  {-3090170, 9510560},
                   {-4067370, 9135450},  {-5000000, 8660250},
                   {-5877850, 8090170},  {-6691310, 7431450},
                   {-7431450, 6691310},  {-8090170, 5877850},
                   {-8660250, 5000000},  {-9135450, 4067370},
                   {-9510560, 3090170},  {-9781480, 2079119},
                   {-9945220, 1045280},  {-10000000, 0},
                   {-9945220, -1045280}, {-9781480, -2079119},
                   {-9510560, -3090170}, {-9135450, -4067370},
                   {-8660250, -5000000}, {-8090170, -5877850},
                   {-7431450, -6691310}, {-6691310, -7431450},
                   {-5877850, -8090170}, {-5000000, -8660250},
                   {-4067370, -9135450}, {-3090170, -9510560},
                   {-2079119, -9781480}, {-1045280, -9945220},
                   {0, -10000000},
               },
               {}},
    },
    ExPolygons{
        // "rpi-zero-frame.stl":
        MyPoly{{
                   {58000000, -25983600}, {58313600, -25983600},
                   {58927100, -25853200}, {59500000, -25598100},
                   {60007400, -25229400}, {60427100, -24763400},
                   {60740600, -24220200}, {60934400, -23623700},
                   {61000000, -23000000}, {61000000, 0},
                   {60934400, 623734},    {60740600, 1220210},
                   {60427100, 1763360},   {60007400, 2229430},
                   {59500000, 2598080},   {58927100, 2853170},
                   {58313600, 2983570},   {58000000, 2983570},
                   {58000000, 3000000},   {55000000, 3000000},
                   {55000000, 6000000},   {45000000, 6000000},
                   {45000000, 3000000},   {0, 3000000},
                   {0, 2983570},          {-313585, 2983570},
                   {-927051, 2853170},    {-1500000, 2598080},
                   {-2007390, 2229430},   {-2427050, 1763360},
                   {-2740640, 1220210},   {-2934440, 623734},
                   {-3000000, 0},         {-3000000, -23000000},
                   {-2934440, -23623700}, {-2740640, -24220200},
                   {-2427050, -24763400}, {-2007390, -25229400},
                   {-1500000, -25598100}, {-927051, -25853200},
                   {-313585, -25983600},  {313585, -25983600},
                   {927051, -25853200},   {1000000, -25820720},
                   {1000000, -26000000},  {58000000, -26000000},
               },
               {
                   {
                       {44883600, -2063829},
                       {44638500, -2012070},
                       {44409000, -1909530},
                       {44205900, -1762070},
                       {44037900, -1575550},
                       {43912900, -1358750},
                       {43834800, -1120470},
                       {43822600, -1000000},
                       {46195173, -1000000},
                       {46182500, -1120470},
                       {46105300, -1358750},
                       {45979300, -1575550},
                       {45812300, -1762070},
                       {45609200, -1909530},
                       {45379700, -2012070},
                       {45134600, -2063829},
                   },
                   {
                       {51045700, -1970080},
                       {50800600, -1918320},
                       {50571100, -1815780},
                       {50368000, -1668320},
                       {50200000, -1481800},
                       {50075000, -1265000},
                       {49996900, -1025740},
                       {49994200, -1000000},
                       {52347300, -1000000},
                       {52344600, -1025740},
                       {52267400, -1265000},
                       {52141400, -1481800},
                       {51973500, -1668320},
                       {51771300, -1815780},
                       {51541800, -1918320},
                       {51296700, -1970080},
                   },
                   {
                       {3000000, -20000000},
                       {3000000, -3000000},
                       {43887500, -3000000},
                       {43912900, -2922230},
                       {44037900, -2705430},
                       {44205900, -2518910},
                       {44409000, -2371440},
                       {44638500, -2268910},
                       {44883600, -2217150},
                       {45134600, -2217150},
                       {45379700, -2268910},
                       {45609200, -2371440},
                       {45812300, -2518910},
                       {45979300, -2705430},
                       {46105300, -2922230},
                       {46130400, -3000000},
                       {55000000, -3000000},
                       {55000000, -20000000},
                   },
                   {
                       {22525500, -22729500}, {22321000, -22686100},
                       {22130000, -22601000}, {21960900, -22478100},
                       {21821000, -22322800}, {21716500, -22141700},
                       {21651900, -21942900}, {21630000, -21735000},
                       {21651900, -21527100}, {21716500, -21328300},
                       {21821000, -21147200}, {21960900, -20991900},
                       {22130000, -20869000}, {22321000, -20783900},
                       {22525500, -20740500}, {22734500, -20740500},
                       {22939000, -20783900}, {23130000, -20869000},
                       {23299100, -20991900}, {23439000, -21147200},
                       {23543500, -21328300}, {23608100, -21527100},
                       {23630000, -21735000}, {23608100, -21942900},
                       {23543500, -22141700}, {23439000, -22322800},
                       {23299100, -22478100}, {23130000, -22601000},
                       {22939000, -22686100}, {22734500, -22729500},
                   },
                   {
                       {7285470, -25269500}, {7080980, -25226100},
                       {6890000, -25141000}, {6720870, -25018100},
                       {6580980, -24862800}, {6476450, -24681700},
                       {6411850, -24482900}, {6390000, -24275000},
                       {6411850, -24067100}, {6476450, -23868300},
                       {6580980, -23687200}, {6720870, -23531900},
                       {6890000, -23409000}, {7080980, -23323900},
                       {7285470, -23280500}, {7494530, -23280500},
                       {7699020, -23323900}, {7890000, -23409000},
                       {8059129, -23531900}, {8199020, -23687200},
                       {8303540, -23868300}, {8368150, -24067100},
                       {8390000, -24275000}, {8368150, -24482900},
                       {8303540, -24681700}, {8199020, -24862800},
                       {8059129, -25018100}, {7890000, -25141000},
                       {7699020, -25226100}, {7494530, -25269500},
                   },
                   {
                       {22525500, -25269500}, {22321000, -25226100},
                       {22130000, -25141000}, {21960900, -25018100},
                       {21821000, -24862800}, {21716500, -24681700},
                       {21651900, -24482900}, {21630000, -24275000},
                       {21651900, -24067100}, {21716500, -23868300},
                       {21821000, -23687200}, {21960900, -23531900},
                       {22130000, -23409000}, {22321000, -23323900},
                       {22525500, -23280500}, {22734500, -23280500},
                       {22939000, -23323900}, {23130000, -23409000},
                       {23299100, -23531900}, {23439000, -23687200},
                       {23543500, -23868300}, {23608100, -24067100},
                       {23630000, -24275000}, {23608100, -24482900},
                       {23543500, -24681700}, {23439000, -24862800},
                       {23299100, -25018100}, {23130000, -25141000},
                       {22939000, -25226100}, {22734500, -25269500},
                   },
                   {
                       {14905500, -25269500}, {14701000, -25226100},
                       {14510000, -25141000}, {14340900, -25018100},
                       {14201000, -24862800}, {14096500, -24681700},
                       {14031900, -24482900}, {14010000, -24275000},
                       {14031900, -24067100}, {14096500, -23868300},
                       {14201000, -23687200}, {14340900, -23531900},
                       {14510000, -23409000}, {14701000, -23323900},
                       {14905500, -23280500}, {15114500, -23280500},
                       {15319000, -23323900}, {15510000, -23409000},
                       {15679100, -23531900}, {15819000, -23687200},
                       {15923500, -23868300}, {15988100, -24067100},
                       {16010000, -24275000}, {15988100, -24482900},
                       {15923500, -24681700}, {15819000, -24862800},
                       {15679100, -25018100}, {15510000, -25141000},
                       {15319000, -25226100}, {15114500, -25269500},
                   },
                   {
                       {12365500, -25269500}, {12161000, -25226100},
                       {11970000, -25141000}, {11800900, -25018100},
                       {11661000, -24862800}, {11556500, -24681700},
                       {11491900, -24482900}, {11470000, -24275000},
                       {11491900, -24067100}, {11556500, -23868300},
                       {11661000, -23687200}, {11800900, -23531900},
                       {11970000, -23409000}, {12161000, -23323900},
                       {12365500, -23280500}, {12574500, -23280500},
                       {12779000, -23323900}, {12970000, -23409000},
                       {13139100, -23531900}, {13279000, -23687200},
                       {13383500, -23868300}, {13448100, -24067100},
                       {13470000, -24275000}, {13448100, -24482900},
                       {13383500, -24681700}, {13279000, -24862800},
                       {13139100, -25018100}, {12970000, -25141000},
                       {12779000, -25226100}, {12574500, -25269500},
                   },
                   {
                       {9825470, -25269500},  {9620980, -25226100},
                       {9430000, -25141000},  {9260870, -25018100},
                       {9120980, -24862800},  {9016450, -24681700},
                       {8951850, -24482900},  {8930000, -24275000},
                       {8951850, -24067100},  {9016450, -23868300},
                       {9120980, -23687200},  {9260870, -23531900},
                       {9430000, -23409000},  {9620980, -23323900},
                       {9825470, -23280500},  {10034500, -23280500},
                       {10239000, -23323900}, {10430000, -23409000},
                       {10599100, -23531900}, {10739000, -23687200},
                       {10843500, -23868300}, {10908100, -24067100},
                       {10930000, -24275000}, {10908100, -24482900},
                       {10843500, -24681700}, {10739000, -24862800},
                       {10599100, -25018100}, {10430000, -25141000},
                       {10239000, -25226100}, {10034500, -25269500},
                   },
               }},
    },
    ExPolygons{
        // "extruder-idler.stl":
        MyPoly{{
                   {31500000, 47000000}, {21500000, 47000000},
                   {21500000, 43000000}, {21483600, 43000000},
                   {21483600, 42686400}, {21443900, 42500000},
                   {21391492, 42253213}, {21356700, 42089700},
                   {21353200, 42072900}, {21302200, 41958400},
                   {21234000, 41805300}, {21184936, 41695077},
                   {21111500, 41530200}, {21098100, 41500000},
                   {21058200, 41445200}, {20966500, 41319000},
                   {20900900, 41228700}, {20812400, 41106900},
                   {20729400, 40992600}, {20660700, 40930800},
                   {20566175, 40845649}, {20359300, 40659400},
                   {20263400, 40572900}, {19720200, 40259400},
                   {19123700, 40065600}, {18688436, 40019806},
                   {18500000, 40000000}, {18409800, 40009500},
                   {17876300, 40065600}, {17279800, 40259400},
                   {16736601, 40572900}, {16640699, 40659400},
                   {16435924, 40843758}, {16339300, 40930800},
                   {16270599, 40992600}, {16187599, 41106900},
                   {16099100, 41228700}, {15996000, 41370500},
                   {16270599, 40992600}, {15901900, 41500000},
                   {15888500, 41530200}, {15810600, 41705100},
                   {15755314, 41829246}, {15735700, 41873300},
                   {15646800, 42072900}, {15643300, 42089700},
                   {15608508, 42253213}, {15556100, 42500000},
                   {15516400, 42686400}, {15516400, 43000000},
                   {15500000, 43000000}, {15500000, 47000000},
                   {6500000, 47000000},  {6500000, 39000000},
                   {3500000, 39000000},  {3500000, 22000000},
                   {6500000, 22000000},  {6500000, 13000000},
                   {31500000, 13000000},
               },
               {
                   {
                       {12923500, 25400000},
                       {12144000, 25850000},
                       {12144000, 32150002},
                       {12923500, 32599998},
                       {17600000, 35300000},
                       {18379400, 34850000},
                       {23056000, 32150002},
                       {23056000, 32000000},
                       {22750000, 32000000},
                       {22750000, 30992100},
                       {21750000, 29994100},
                       {21750000, 25096023},
                       {17600000, 22700000},
                   },
                   {
                       {26393300, 16803400}, {26181400, 16830100},
                       {25974700, 16883200}, {25776200, 16961800},
                       {25589100, 17064600}, {25416400, 17190100},
                       {25260800, 17336300}, {25124700, 17500800},
                       {25010300, 17681000}, {24919400, 17874200},
                       {24853400, 18077200}, {24813400, 18286900},
                       {24800000, 18500000}, {24813400, 18713100},
                       {24853400, 18922800}, {24919400, 19125800},
                       {25010300, 19319000}, {25124700, 19499200},
                       {25260800, 19663700}, {25416400, 19809900},
                       {25589100, 19935400}, {25776200, 20038200},
                       {25974700, 20116800}, {26181400, 20169900},
                       {26393300, 20196600}, {26606700, 20196600},
                       {26818500, 20169900}, {27025300, 20116800},
                       {27223800, 20038200}, {27410900, 19935400},
                       {27583600, 19809900}, {27739200, 19663700},
                       {27875300, 19499200}, {27989700, 19319000},
                       {28080600, 19125800}, {28146600, 18922800},
                       {28186600, 18713100}, {28200000, 18500000},
                       {28186600, 18286900}, {28146600, 18077200},
                       {28080600, 17874200}, {27989700, 17681000},
                       {27875300, 17500800}, {27739200, 17336300},
                       {27583600, 17190100}, {27410900, 17064600},
                       {27223800, 16961800}, {27025300, 16883200},
                       {26818500, 16830100}, {26606700, 16803400},
                   },
                   {
                       {11393300, 16803400}, {11181500, 16830100},
                       {10974700, 16883200}, {10776200, 16961800},
                       {10589100, 17064600}, {10416400, 17190100},
                       {10260800, 17336300}, {10124700, 17500800},
                       {10010300, 17681000}, {9919380, 17874200},
                       {9853410, 18077200},  {9813400, 18286900},
                       {9800000, 18500000},  {9813400, 18713100},
                       {9853410, 18922800},  {9919380, 19125800},
                       {10010300, 19319000}, {10124700, 19499200},
                       {10260800, 19663700}, {10416400, 19809900},
                       {10589100, 19935400}, {10776200, 20038200},
                       {10974700, 20116800}, {11181500, 20169900},
                       {11393300, 20196600}, {11606700, 20196600},
                       {11818500, 20169900}, {12025300, 20116800},
                       {12223800, 20038200}, {12410900, 19935400},
                       {12583600, 19809900}, {12739200, 19663700},
                       {12875300, 19499200}, {12989700, 19319000},
                       {13080600, 19125800}, {13146600, 18922800},
                       {13186600, 18713100}, {13200000, 18500000},
                       {13186600, 18286900}, {13146600, 18077200},
                       {13080600, 17874200}, {12989700, 17681000},
                       {12875300, 17500800}, {12739200, 17336300},
                       {12583600, 17190100}, {12410900, 17064600},
                       {12223800, 16961800}, {12025300, 16883200},
                       {11818500, 16830100}, {11606700, 16803400},
                   },
               }},
    },
    ExPolygons{
        // "filament-sensor-cover.stl":
        MyPoly{{
                   {18000000, 30500000},
                   {-6000000, 30500000},
                   {-6000000, -5500000},
                   {18000000, -5500000},
               },
               {
                   {
                       {-1167240, 22908800}, {-1494430, 22978300},
                       {-1800000, 23114400}, {-2070610, 23311000},
                       {-2294430, 23559500}, {-2461670, 23849200},
                       {-2565040, 24167300}, {-2582520, 24333700},
                       {-2600000, 24500000}, {-2582520, 24666300},
                       {-2565040, 24832700}, {-2461670, 25150800},
                       {-2294430, 25440500}, {-2070610, 25689000},
                       {-1800000, 25885600}, {-1494430, 26021700},
                       {-1167240, 26091200}, {-832754, 26091200},
                       {-505572, 26021700},  {-200000, 25885600},
                       {70608, 25689000},    {294427, 25440500},
                       {461672, 25150800},   {565036, 24832700},
                       {582518, 24666300},   {599999, 24500000},
                       {582518, 24333700},   {565036, 24167300},
                       {461672, 23849200},   {294427, 23559500},
                       {70608, 23311000},    {-200000, 23114400},
                       {-505572, 22978300},  {-832754, 22908800},
                   },
                   {
                       {-144249, 15627600},  {-426443, 15687500},
                       {-689999, 15804900},  {-740738, 15841700},
                       {-923400, 15974500},  {-965366, 16021099},
                       {-1116440, 16188900}, {-1229330, 16384399},
                       {-1260690, 16438700}, {-1280070, 16498400},
                       {-1349840, 16713100}, {-1373440, 16937600},
                       {-1380000, 17000000}, {-1373440, 17062400},
                       {-1349840, 17286900}, {-1280070, 17501600},
                       {-1260690, 17561300}, {-1229330, 17615600},
                       {-1116440, 17811100}, {-965366, 17978900},
                       {-923400, 18025500},  {-872661, 18062400},
                       {-689999, 18195100},  {-483738, 18286900},
                       {-426443, 18312500},  {-144249, 18372400},
                       {144249, 18372400},   {426443, 18312500},
                       {483738, 18286900},   {689999, 18195100},
                       {872661, 18062400},   {923400, 18025500},
                       {965366, 17978900},   {1116440, 17811100},
                       {1229330, 17615600},  {1260690, 17561300},
                       {1280070, 17501600},  {1349840, 17286900},
                       {1373440, 17062400},  {1380000, 17000000},
                       {1373440, 16937600},  {1349840, 16713100},
                       {1280070, 16498400},  {1260690, 16438700},
                       {1229330, 16384399},  {1116440, 16188900},
                       {965366, 16021099},   {923400, 15974500},
                       {872661, 15937600},   {689999, 15804900},
                       {483738, 15713100},   {426443, 15687500},
                       {144249, 15627600},
                   },
                   {
                       {11832800, 10408800}, {11505600, 10478300},
                       {11200000, 10614400}, {10929400, 10811000},
                       {10705600, 11059500}, {10538300, 11349200},
                       {10435000, 11667300}, {10400000, 12000000},
                       {10435000, 12332700}, {10538300, 12650800},
                       {10705600, 12940500}, {10929400, 13189000},
                       {11200000, 13385600}, {11505600, 13521700},
                       {11832800, 13591200}, {12167200, 13591200},
                       {12494400, 13521700}, {12800000, 13385600},
                       {13070600, 13189000}, {13294400, 12940500},
                       {13461700, 12650800}, {13565000, 12332700},
                       {13585100, 12141400}, {13600000, 12000000},
                       {13582500, 11833700}, {13565000, 11667300},
                       {13461700, 11349200}, {13294400, 11059500},
                       {13070600, 10811000}, {12800000, 10614400},
                       {12494400, 10478300}, {12167200, 10408800},
                   },
               }},
    },
    ExPolygons{
        // "nozzle-fan.stl":
        MyPoly{{
                   {-14922022, 12367866}, {-14205200, 14337200},
                   {-13800000, 15450500}, {-13800000, 17000000},
                   {-13789800, 17000000}, {-13704300, 17813300},
                   {-13694100, 17910800}, {-12789600, 20694300},
                   {-11326200, 23229000}, {-9367830, 25404000},
                   {-7000000, 27124400},  {-5253290, 27902000},
                   {-4326240, 28314800},  {-1463400, 28923300},
                   {1463400, 28923300},   {4326240, 28314800},
                   {5253290, 27902000},   {7000000, 27124400},
                   {9367830, 25404000},   {11326200, 23229000},
                   {12789600, 20694300},  {13694100, 17910800},
                   {13704300, 17813300},  {13789800, 17000000},
                   {13800000, 17000000},  {13800000, 15606900},
                   {14240100, 14397700},  {15015200, 12268200},
                   {15476800, 11000000},  {17800000, 11000000},
                   {17800000, 11032900},  {18427200, 11032900},
                   {19654100, 11293700},  {20800000, 11803800},
                   {21814800, 12541100},  {22654100, 13473300},
                   {23281300, 14559600},  {23668900, 15752500},
                   {23706600, 16111099},  {23800000, 17000000},
                   {23789800, 17000000},  {23475500, 19989900},
                   {21925100, 24761700},  {19416400, 29106800},
                   {18612200, 30000000},  {18000000, 30679900},
                   {18000000, 35500000},  {18500000, 35500000},
                   {18500000, 40500000},  {17839500, 40500000},
                   {11200000, 52000000},  {9532010, 52000000},
                   {9532010, 52800000},   {5416000, 52800000},
                   {5416000, 52000000},   {4793090, 52000000},
                   {4793090, 52800000},   {-65918, 52800000},
                   {-65918, 52000000},    {-296738, 52000000},
                   {-296738, 52800000},   {-4368740, 52800000},
                   {-4368740, 52000000},  {-4995880, 52000000},
                   {-4995880, 52800000},  {-5997880, 52800000},
                   {-5997880, 52000000},  {-6891430, 52000000},
                   {-6891430, 52800000},  {-10271400, 52800000},
                   {-10271400, 52000000}, {-11139700, 52000000},
                   {-18000000, 40117700}, {-18000000, 30679900},
                   {-18612200, 30000000}, {-19416400, 29106800},
                   {-21925100, 24761700}, {-23475500, 19989900},
                   {-23789800, 17000000}, {-23800000, 17000000},
                   {-23668900, 15752500}, {-23281300, 14559600},
                   {-22654100, 13473300}, {-21814800, 12541100},
                   {-20800000, 11803800}, {-19654100, 11293700},
                   {-18427200, 11032900}, {-17800000, 11032900},
                   {-17800000, 11000000}, {-15419900, 11000000},
               },
               {}},
    },
    ExPolygons{
        // "x-carriage-back.stl":
        MyPoly{{
                   {-5981270, -38729200},  {-5354100, -37638700},
                   {-4514780, -36703000},  {-3500000, -35962900},
                   {-2354100, -35450800},  {-1969730, -35368800},
                   {-1127170, -35189000},  {127170, -35189000},
                   {969727, -35368800},    {1354100, -35450800},
                   {2500000, -35962900},   {3514780, -36703000},
                   {4354100, -37638700},   {4981270, -38729200},
                   {5068930, -39000000},   {13757900, -39000000},
                   {16000000, -36757900},  {16000000, -5000000},
                   {25500000, -5000000},   {25500000, 13795200},
                   {25057400, 14352100},   {24542500, 15342500},
                   {24400000, 15200000},   {14600000, 25000000},
                   {14500000, 25000000},   {14500000, 33050000},
                   {13050000, 34500000},   {-500000, 34500000},
                   {-500000, 28500000},    {-8000000, 28500000},
                   {-8000000, 32500000},   {-5000000, 32500000},
                   {-5000000, 34500000},   {-15550000, 34500000},
                   {-17000000, 33050000},  {-17000000, 25000000},
                   {-17100000, 25000000},  {-25572200, 16527800},
                   {-25903900, 15532800},  {-26500000, 14386100},
                   {-26500000, -5000000},  {-17000000, -5000000},
                   {-17000000, -36757900}, {-14757900, -39000000},
                   {-6068930, -39000000},
               },
               {
                   {
                       {-13103600, 29353300}, {-13309200, 29379200},
                       {-13509900, 29430800}, {-13702500, 29507000},
                       {-13884100, 29606900}, {-14051700, 29728700},
                       {-14202800, 29870500}, {-14334900, 30030200},
                       {-14445900, 30205100}, {-14534100, 30392600},
                       {-14598200, 30589700}, {-14637000, 30793200},
                       {-14650000, 31000000}, {-14637000, 31206800},
                       {-14598200, 31410300}, {-14534100, 31607400},
                       {-14445900, 31794900}, {-14334900, 31969800},
                       {-14202800, 32129502}, {-14051700, 32271302},
                       {-13884100, 32393100}, {-13702500, 32493000},
                       {-13509900, 32569198}, {-13309200, 32620800},
                       {-13103600, 32646702}, {-12896400, 32646702},
                       {-12690800, 32620800}, {-12490100, 32569198},
                       {-12297500, 32493000}, {-12115900, 32393100},
                       {-11948200, 32271302}, {-11797200, 32129502},
                       {-11665100, 31969800}, {-11554100, 31794900},
                       {-11465900, 31607400}, {-11401800, 31410300},
                       {-11363000, 31206800}, {-11350000, 31000000},
                       {-11363000, 30793200}, {-11401800, 30589700},
                       {-11465900, 30392600}, {-11554100, 30205100},
                       {-11665100, 30030200}, {-11797200, 29870500},
                       {-11948200, 29728700}, {-12115900, 29606900},
                       {-12297500, 29507000}, {-12490100, 29430800},
                       {-12690800, 29379200}, {-12896400, 29353300},
                   },
                   {
                       {10396400, 29353300}, {10190800, 29379200},
                       {9990120, 29430800},  {9797460, 29507000},
                       {9615890, 29606900},  {9448250, 29728700},
                       {9297200, 29870500},  {9165120, 30030200},
                       {9054090, 30205100},  {8965870, 30392600},
                       {8901840, 30589700},  {8863010, 30793200},
                       {8850000, 31000000},  {8863010, 31206800},
                       {8901840, 31410300},  {8965870, 31607400},
                       {9054090, 31794900},  {9165120, 31969800},
                       {9297200, 32129502},  {9448250, 32271302},
                       {9615890, 32393100},  {9797460, 32493000},
                       {9990120, 32569198},  {10190800, 32620800},
                       {10396400, 32646702}, {10603600, 32646702},
                       {10809200, 32620800}, {11009900, 32569198},
                       {11202500, 32493000}, {11384100, 32393100},
                       {11551700, 32271302}, {11702800, 32129502},
                       {11834900, 31969800}, {11945900, 31794900},
                       {12034100, 31607400}, {12098200, 31410300},
                       {12137000, 31206800}, {12150000, 31000000},
                       {12137000, 30793200}, {12098200, 30589700},
                       {12034100, 30392600}, {11945900, 30205100},
                       {11834900, 30030200}, {11702800, 29870500},
                       {11551700, 29728700}, {11384100, 29606900},
                       {11202500, 29507000}, {11009900, 29430800},
                       {10809200, 29379200}, {10603600, 29353300},
                   },
                   {
                       {-8000000, 17500000},
                       {-8000000, 22500000},
                       {-4500000, 22500000},
                       {-4500000, 17500000},
                   },
                   {
                       {-1103600, 2353260}, {-1309180, 2379230},
                       {-1509880, 2430760}, {-1702540, 2507040},
                       {-1884110, 2606860}, {-2051750, 2728650},
                       {-2202800, 2870500}, {-2334880, 3030150},
                       {-2445910, 3205110}, {-2534130, 3392590},
                       {-2598160, 3589660}, {-2636990, 3793200},
                       {-2650000, 4000000}, {-2636990, 4206800},
                       {-2598160, 4410340}, {-2534130, 4607400},
                       {-2445910, 4794890}, {-2334880, 4969840},
                       {-2202800, 5129500}, {-2051750, 5271350},
                       {-1884110, 5393140}, {-1702540, 5492960},
                       {-1509880, 5569240}, {-1309180, 5620770},
                       {-1103600, 5646740}, {-896395, 5646740},
                       {-690821, 5620770},  {-490122, 5569240},
                       {-297463, 5492960},  {-115886, 5393140},
                       {51749, 5271350},    {202798, 5129500},
                       {334878, 4969840},   {445906, 4794890},
                       {534131, 4607400},   {598162, 4410340},
                       {636989, 4206800},   {650000, 4000000},
                       {636989, 3793200},   {598162, 3589660},
                       {534131, 3392590},   {445906, 3205110},
                       {334878, 3030150},   {202798, 2870500},
                       {51749, 2728650},    {-115886, 2606860},
                       {-297463, 2507040},  {-490122, 2430760},
                       {-690821, 2379230},  {-896395, 2353260},
                   },
                   {
                       {10876300, -3434440}, {10279800, -3240640},
                       {9736640, -2927050},  {9270570, -2507390},
                       {8901920, -2000000},  {8646830, -1427050},
                       {8516430, -813585},   {8516430, -186414},
                       {8646830, 427051},    {8901920, 999999},
                       {9270570, 1507390},   {9736640, 1927050},
                       {10279800, 2240640},  {10876300, 2434440},
                       {11500000, 2500000},  {12123700, 2434440},
                       {12720200, 2240640},  {13263400, 1927050},
                       {13729400, 1507390},  {14098100, 1000000},
                       {14353200, 427051},   {14483600, -186414},
                       {14483600, -813585},  {14353200, -1427050},
                       {14098100, -2000000}, {13729400, -2507390},
                       {13263400, -2927050}, {12720200, -3240640},
                       {12123700, -3434440}, {11500000, -3500000},
                   },
                   {
                       {-12123700, -3434440}, {-12720200, -3240640},
                       {-13263400, -2927050}, {-13729400, -2507390},
                       {-14098100, -2000000}, {-14353200, -1427050},
                       {-14483600, -813585},  {-14483600, -186414},
                       {-14353200, 427051},   {-14098100, 999999},
                       {-13729400, 1507390},  {-13263400, 1927050},
                       {-12720200, 2240640},  {-12123700, 2434440},
                       {-11500000, 2500000},  {-10876300, 2434440},
                       {-10279800, 2240640},  {-9736640, 1927050},
                       {-9270570, 1507390},   {-8901920, 1000000},
                       {-8646830, 427051},    {-8516430, -186414},
                       {-8516430, -813585},   {-8646830, -1427050},
                       {-8901920, -2000000},  {-9270570, -2507390},
                       {-9736640, -2927050},  {-10279800, -3240640},
                       {-10876300, -3434440}, {-11500000, -3500000},
                   },
                   {
                       {-1539560, -22890700}, {-2533680, -22567700},
                       {-3438930, -22045100}, {-3590280, -21908800},
                       {-4215720, -21345700}, {-4806270, -20532800},
                       {-4830130, -20500000}, {-5012570, -20090200},
                       {-5255280, -19545100}, {-5472610, -18522600},
                       {-5472610, -18000000}, {-5500000, -18000000},
                       {-5500000, -14000000}, {-5472610, -14000000},
                       {-5472610, -13477400}, {-5255280, -12454900},
                       {-5052740, -12000000}, {-4830130, -11500000},
                       {-4215720, -10654300}, {-3438930, -9954910},
                       {-3189080, -9810670},  {-2533680, -9432270},
                       {-1539560, -9109260},  {-500000, -9000000},
                       {539558, -9109260},    {1309400, -9359400},
                       {1533680, -9432270},   {2438930, -9954910},
                       {3215720, -10654300},  {3830130, -11500000},
                       {4052740, -12000000},  {4255280, -12454900},
                       {4472610, -13477400},  {4472610, -14000000},
                       {4500000, -14000000},  {4500000, -18000000},
                       {4472610, -18000000},  {4472610, -18522600},
                       {4255280, -19545100},  {4012570, -20090200},
                       {3830130, -20500000},  {3806270, -20532800},
                       {3215720, -21345700},  {2590280, -21908800},
                       {2438930, -22045100},  {1533680, -22567700},
                       {539558, -22890700},   {-499999, -23000000},
                   },
                   {
                       {-832658, -28565000},  {-1150780, -28461700},
                       {-1440460, -28294400}, {-1689030, -28070600},
                       {-1885640, -27800000}, {-2021689, -27494400},
                       {-2091229, -27167200}, {-2091229, -26832800},
                       {-2021689, -26505600}, {-1885640, -26200000},
                       {-1689030, -25929400}, {-1440460, -25705600},
                       {-1150780, -25538300}, {-832658, -25435000},
                       {-500000, -25400000},  {-167341, -25435000},
                       {150778, -25538300},   {440456, -25705600},
                       {689032, -25929400},   {885640, -26200000},
                       {1021690, -26505600},  {1091230, -26832800},
                       {1091230, -27167200},  {1021690, -27494400},
                       {885640, -27800000},   {689032, -28070600},
                       {440456, -28294400},   {150778, -28461700},
                       {-167341, -28565000},  {-499999, -28600000},
                   },
                   {
                       {9396390, -37646700},  {9190820, -37620800},
                       {8990120, -37569200},  {8797460, -37493000},
                       {8615890, -37393100},  {8448250, -37271300},
                       {8297200, -37129500},  {8165120, -36969800},
                       {8054089, -36794900},  {7965870, -36607400},
                       {7901840, -36410300},  {7863010, -36206800},
                       {7850000, -36000000},  {7863010, -35793200},
                       {7901840, -35589700},  {7965870, -35392600},
                       {8054089, -35205100},  {8165120, -35030200},
                       {8297200, -34870500},  {8448250, -34728700},
                       {8615890, -34606900},  {8797460, -34507000},
                       {8990120, -34430800},  {9190820, -34379200},
                       {9396390, -34353300},  {9603600, -34353300},
                       {9809180, -34379200},  {10009900, -34430800},
                       {10202500, -34507000}, {10384100, -34606900},
                       {10551700, -34728700}, {10702800, -34870500},
                       {10834900, -35030200}, {10945900, -35205100},
                       {11034100, -35392600}, {11098200, -35589700},
                       {11137000, -35793200}, {11150000, -36000000},
                       {11137000, -36206800}, {11098200, -36410300},
                       {11034100, -36607400}, {10945900, -36794900},
                       {10834900, -36969800}, {10702800, -37129500},
                       {10551700, -37271300}, {10384100, -37393100},
                       {10202500, -37493000}, {10009900, -37569200},
                       {9809180, -37620800},  {9603600, -37646700},
                   },
                   {
                       {-10603600, -37646700}, {-10809200, -37620800},
                       {-11009900, -37569200}, {-11202500, -37493000},
                       {-11384100, -37393100}, {-11551700, -37271300},
                       {-11702800, -37129500}, {-11834900, -36969800},
                       {-11945900, -36794900}, {-12034100, -36607400},
                       {-12098200, -36410300}, {-12137000, -36206800},
                       {-12150000, -36000000}, {-12137000, -35793200},
                       {-12098200, -35589700}, {-12034100, -35392600},
                       {-11945900, -35205100}, {-11834900, -35030200},
                       {-11702800, -34870500}, {-11551700, -34728700},
                       {-11384100, -34606900}, {-11202500, -34507000},
                       {-11009900, -34430800}, {-10809200, -34379200},
                       {-10603600, -34353300}, {-10396400, -34353300},
                       {-10190800, -34379200}, {-9990120, -34430800},
                       {-9797460, -34507000},  {-9615890, -34606900},
                       {-9448250, -34728700},  {-9297200, -34870500},
                       {-9165120, -35030200},  {-9054090, -35205100},
                       {-8965870, -35392600},  {-8901840, -35589700},
                       {-8863010, -35793200},  {-8850000, -36000000},
                       {-8863010, -36206800},  {-8901840, -36410300},
                       {-8965870, -36607400},  {-9054090, -36794900},
                       {-9165120, -36969800},  {-9297200, -37129500},
                       {-9448250, -37271300},  {-9615890, -37393100},
                       {-9797460, -37493000},  {-9990120, -37569200},
                       {-10190800, -37620800}, {-10396400, -37646700},
                   },
               }},
    },
    ExPolygons{
        // "extruder-idler-plug.stl":
        MyPoly{{
                   {-13000000, 42500000}, {-12967200, 42811900},
                   {-12906100, 43000000}, {-12870300, 43110100},
                   {-12713500, 43381700}, {-12503700, 43614700},
                   {-12250000, 43799000}, {-11963500, 43926600},
                   {-11656800, 43991800}, {-11343200, 43991800},
                   {-11036500, 43926600}, {-10750000, 43799000},
                   {-10496300, 43614700}, {-10286500, 43381700},
                   {-10129700, 43110100}, {-10093900, 43000000},
                   {-10032800, 42811900}, {-10000000, 42500000},
                   {-10000000, 40200000}, {-7000000, 40200000},
                   {-7000000, 46000000},  {-6400000, 46000000},
                   {-6400000, 50500000},  {-11937800, 50500000},
                   {-17000000, 47577400}, {-17000000, 40200000},
                   {-13000000, 40200000},
               },
               {}},
    },
    ExPolygons{
        // "z-axis-bottom.stl":
        MyPoly{{
                   {45101600, -4898420},
                   {50000000, 0},
                   {50000000, 40786800},
                   {43286800, 47500000},
                   {3500000, 47500000},
                   {0, 44000000},
                   {0, -2000000},
                   {3000000, -5000000},
                   {45000000, -5000000},
               },
               {
                   {
                       {13696400, 33853300}, {13509500, 33876900},
                       {13490800, 33879200}, {13308400, 33926100},
                       {13290100, 33930800}, {13097500, 34007000},
                       {12915900, 34106900}, {12748300, 34228700},
                       {12597200, 34370500}, {12465100, 34530200},
                       {12354100, 34705100}, {12265900, 34892600},
                       {12201800, 35089700}, {12163000, 35293200},
                       {12150000, 35500000}, {12163000, 35706800},
                       {12201800, 35910300}, {12265900, 36107400},
                       {12354100, 36294900}, {12465100, 36469800},
                       {12597200, 36629500}, {12748300, 36771300},
                       {12915900, 36893100}, {13097500, 36993000},
                       {13290100, 37069200}, {13308400, 37073900},
                       {13490800, 37120800}, {13509500, 37123100},
                       {13696400, 37146700}, {13903600, 37146700},
                       {14090500, 37123100}, {14109200, 37120800},
                       {14291600, 37073900}, {14309900, 37069200},
                       {14502500, 36993000}, {14684100, 36893100},
                       {14791899, 36814806}, {14851700, 36771300},
                       {14851800, 36771300}, {15002800, 36629500},
                       {15134900, 36469800}, {15245900, 36294900},
                       {15334100, 36107400}, {15398200, 35910300},
                       {15437000, 35706800}, {15450000, 35500000},
                       {15437000, 35293200}, {15398200, 35089700},
                       {15334100, 34892600}, {15245900, 34705100},
                       {15134900, 34530200}, {15002800, 34370500},
                       {14851800, 34228700}, {14851700, 34228700},
                       {14791899, 34185194}, {14684100, 34106900},
                       {14502500, 34007000}, {14309900, 33930800},
                       {14291600, 33926100}, {14109200, 33879200},
                       {14090500, 33876900}, {13903600, 33853300},
                   },
                   {
                       {44696400, 33853300}, {44509500, 33876900},
                       {44490800, 33879200}, {44308400, 33926100},
                       {44290100, 33930800}, {44097500, 34007000},
                       {43915900, 34106900}, {43748200, 34228700},
                       {43597200, 34370500}, {43465100, 34530200},
                       {43354100, 34705100}, {43265900, 34892600},
                       {43201800, 35089700}, {43163000, 35293200},
                       {43150000, 35500000}, {43163000, 35706800},
                       {43201800, 35910300}, {43265900, 36107400},
                       {43354100, 36294900}, {43465100, 36469800},
                       {43597200, 36629500}, {43748200, 36771300},
                       {43915900, 36893100}, {44097500, 36993000},
                       {44290100, 37069200}, {44308400, 37073900},
                       {44490800, 37120800}, {44509500, 37123100},
                       {44696400, 37146700}, {44903600, 37146700},
                       {45090500, 37123100}, {45109200, 37120800},
                       {45291600, 37073900}, {45309900, 37069200},
                       {45502500, 36993000}, {45684100, 36893100},
                       {45851700, 36771300}, {46002800, 36629500},
                       {46134900, 36469800}, {46245900, 36294900},
                       {46334100, 36107400}, {46398200, 35910300},
                       {46437000, 35706800}, {46450000, 35500000},
                       {46437000, 35293200}, {46398200, 35089700},
                       {46334100, 34892600}, {46245900, 34705100},
                       {46134900, 34530200}, {46002800, 34370500},
                       {45851700, 34228700}, {45684100, 34106900},
                       {45502500, 34007000}, {45309900, 33930800},
                       {45291600, 33926100}, {45109200, 33879200},
                       {45090500, 33876900}, {44903600, 33853300},
                   },
                   {
                       {28300000, 8702230},  {28300000, 8861350},
                       {28129300, 8861350},  {25839000, 9348170},
                       {23700000, 10300500}, {21805700, 11676800},
                       {20239000, 13416800}, {19068300, 15444600},
                       {18344700, 17671400}, {18100000, 20000000},
                       {18344700, 22328600}, {19068300, 24555500},
                       {20239000, 26583200}, {21805700, 28323200},
                       {23700000, 29699500}, {25839000, 30651800},
                       {28129300, 31138600}, {30470700, 31138600},
                       {32761002, 30651800}, {34900000, 29699500},
                       {36794300, 28323200}, {38361000, 26583200},
                       {39531700, 24555500}, {40255300, 22328600},
                       {40500000, 20000000}, {40255300, 17671400},
                       {39531700, 15444600}, {38361000, 13416800},
                       {36794300, 11676800}, {34900000, 10300500},
                       {32761002, 9348170},  {30470700, 8861350},
                       {30300000, 8861350},  {30300000, 8702230},
                   },
                   {
                       {29045700, -1042009}, {28541100, -978263},
                       {28048500, -851778},  {27575600, -664549},
                       {27129900, -419528},  {26718400, -120578},
                       {26347700, 227584},   {26023500, 619470},
                       {25751000, 1048900},  {25534400, 1509100},
                       {25377200, 1992810},  {25281900, 2492400},
                       {25250000, 3000000},  {25281900, 3507600},
                       {25377200, 4007190},  {25534400, 4490900},
                       {25751000, 4951100},  {26023500, 5380530},
                       {26347700, 5772420},  {26718400, 6120580},
                       {27129900, 6419530},  {27575600, 6664550},
                       {28048500, 6851780},  {28300000, 6916360},
                       {28300000, 7213590},  {28487100, 7261610},
                       {28717100, 7290670},  {29027600, 7329900},
                       {29572400, 7329900},  {29882900, 7290670},
                       {30112900, 7261610},  {30300000, 7213590},
                       {30300000, 6916360},  {30551500, 6851780},
                       {31024400, 6664550},  {31470100, 6419530},
                       {31881600, 6120580},  {32252300, 5772420},
                       {32576500, 5380530},  {32849000, 4951100},
                       {33065602, 4490900},  {33222802, 4007190},
                       {33318100, 3507600},  {33349998, 3000000},
                       {33318100, 2492400},  {33222802, 1992810},
                       {33065602, 1509100},  {32849000, 1048900},
                       {32576500, 619470},   {32252300, 227584},
                       {31881600, -120578},  {31470100, -419528},
                       {31024400, -664549},  {30551500, -851778},
                       {30058900, -978263},  {29554300, -1042009},
                   },
                   {
                       {44696400, 2853260}, {44509500, 2876870},
                       {44490800, 2879230}, {44308400, 2926070},
                       {44290100, 2930760}, {44097500, 3007040},
                       {43915900, 3106860}, {43748200, 3228650},
                       {43597200, 3370500}, {43465100, 3530160},
                       {43354100, 3705110}, {43265900, 3892600},
                       {43201800, 4089660}, {43163000, 4293200},
                       {43150000, 4500000}, {43163000, 4706800},
                       {43201800, 4910340}, {43265900, 5107410},
                       {43354100, 5294890}, {43465100, 5469850},
                       {43597200, 5629500}, {43748200, 5771350},
                       {43915900, 5893140}, {44097500, 5992960},
                       {44290100, 6069240}, {44308400, 6073930},
                       {44490800, 6120770}, {44696400, 6146740},
                       {44903600, 6146740}, {45109200, 6120770},
                       {45291600, 6073930}, {45309900, 6069240},
                       {45502500, 5992960}, {45684100, 5893140},
                       {45851700, 5771350}, {46002800, 5629500},
                       {46134900, 5469850}, {46245900, 5294890},
                       {46334100, 5107410}, {46398200, 4910340},
                       {46437000, 4706800}, {46450000, 4500000},
                       {46437000, 4293200}, {46398200, 4089660},
                       {46334100, 3892600}, {46245900, 3705110},
                       {46134900, 3530160}, {46002800, 3370500},
                       {45851700, 3228650}, {45684100, 3106860},
                       {45502500, 3007040}, {45309900, 2930760},
                       {45291600, 2926070}, {45109200, 2879230},
                       {45090500, 2876870}, {44903600, 2853260},
                   },
                   {
                       {13696400, 2853260}, {13509500, 2876870},
                       {13490800, 2879230}, {13308400, 2926070},
                       {13290100, 2930760}, {13097500, 3007040},
                       {12915900, 3106860}, {12748300, 3228650},
                       {12597200, 3370500}, {12465100, 3530160},
                       {12354100, 3705110}, {12265900, 3892600},
                       {12201800, 4089660}, {12163000, 4293200},
                       {12150000, 4500000}, {12163000, 4706800},
                       {12201800, 4910340}, {12265900, 5107410},
                       {12354100, 5294890}, {12465100, 5469850},
                       {12597200, 5629500}, {12748300, 5771350},
                       {12915900, 5893140}, {13097500, 5992960},
                       {13290100, 6069240}, {13308400, 6073930},
                       {13490800, 6120770}, {13696400, 6146740},
                       {13903600, 6146740}, {14109200, 6120770},
                       {14291600, 6073930}, {14309900, 6069240},
                       {14502500, 5992960}, {14684100, 5893140},
                       {14754724, 5841850}, {14851700, 5771350},
                       {14851800, 5771350}, {15002800, 5629500},
                       {15134900, 5469850}, {15245900, 5294890},
                       {15334100, 5107410}, {15398200, 4910340},
                       {15437000, 4706800}, {15450000, 4500000},
                       {15437000, 4293200}, {15398200, 4089660},
                       {15334100, 3892600}, {15245900, 3705110},
                       {15134900, 3530160}, {15002800, 3370500},
                       {14851800, 3228650}, {14851700, 3228650},
                       {14754724, 3158150}, {14684100, 3106860},
                       {14502500, 3007040}, {14309900, 2930760},
                       {14291600, 2926070}, {14109200, 2879230},
                       {14090500, 2876870}, {13903600, 2853260},
                   },
               }},
        MyPoly{{
                   {50000000, -53786800},
                   {50000000, -13000000},
                   {45101600, -8101579},
                   {45000000, -8000000},
                   {3000000, -8000000},
                   {0, -11000000},
                   {0, -57000000},
                   {3500000, -60500000},
                   {43286800, -60500000},
               },
               {
                   {
                       {29027600, -20329900}, {28717100, -20290700},
                       {28487100, -20261600}, {28300000, -20213600},
                       {28300000, -19916400}, {28048500, -19851800},
                       {27575600, -19664500}, {27129900, -19419500},
                       {26718400, -19120600}, {26347700, -18772400},
                       {26023500, -18380500}, {25751000, -17951100},
                       {25534400, -17490900}, {25377200, -17007200},
                       {25281900, -16507601}, {25250000, -16000000},
                       {25281900, -15492400}, {25377200, -14992800},
                       {25534400, -14509100}, {25751000, -14048900},
                       {26023500, -13619500}, {26347700, -13227600},
                       {26718400, -12879400}, {27129900, -12580500},
                       {27575600, -12335500}, {28048500, -12148200},
                       {28541100, -12021700}, {29045700, -11958000},
                       {29554300, -11958000}, {30058900, -12021700},
                       {30551500, -12148200}, {31024400, -12335500},
                       {31470100, -12580500}, {31881600, -12879400},
                       {32252300, -13227600}, {32576500, -13619500},
                       {32849000, -14048900}, {33065602, -14509100},
                       {33222802, -14992800}, {33318100, -15492400},
                       {33349998, -16000000}, {33318100, -16507601},
                       {33222802, -17007200}, {33065602, -17490900},
                       {32849000, -17951100}, {32576500, -18380500},
                       {32252300, -18772400}, {31881600, -19120600},
                       {31470100, -19419500}, {31024400, -19664500},
                       {30551500, -19851800}, {30300000, -19916400},
                       {30300000, -20213600}, {30112900, -20261600},
                       {29882900, -20290700}, {29572400, -20329900},
                   },
                   {
                       {13696400, -19146700}, {13509500, -19123100},
                       {13490800, -19120800}, {13308400, -19073900},
                       {13290100, -19069200}, {13097500, -18993000},
                       {12915900, -18893100}, {12748300, -18771300},
                       {12597200, -18629500}, {12465100, -18469800},
                       {12354100, -18294900}, {12265900, -18107400},
                       {12201800, -17910300}, {12163000, -17706800},
                       {12150000, -17500000}, {12163000, -17293200},
                       {12201800, -17089700}, {12265900, -16892600},
                       {12354100, -16705099}, {12465100, -16530199},
                       {12597200, -16370501}, {12748300, -16228701},
                       {12915900, -16106899}, {13097500, -16007000},
                       {13290100, -15930800}, {13308400, -15926100},
                       {13490800, -15879200}, {13509500, -15876900},
                       {13696400, -15853300}, {13903600, -15853300},
                       {14090500, -15876900}, {14109200, -15879200},
                       {14291600, -15926100}, {14309900, -15930800},
                       {14502500, -16007000}, {14684100, -16106899},
                       {14791305, -16184763}, {14851700, -16228701},
                       {14851800, -16228701}, {15002800, -16370501},
                       {15134900, -16530199}, {15245900, -16705099},
                       {15334100, -16892600}, {15398200, -17089700},
                       {15437000, -17293200}, {15450000, -17500000},
                       {15437000, -17706800}, {15398200, -17910300},
                       {15334100, -18107400}, {15245900, -18294900},
                       {15134900, -18469800}, {15002800, -18629500},
                       {14851800, -18771300}, {14851700, -18771300},
                       {14791899, -18814806}, {14684100, -18893100},
                       {14502500, -18993000}, {14309900, -19069200},
                       {14291600, -19073900}, {14109200, -19120800},
                       {14090500, -19123100}, {13903600, -19146700},
                   },
                   {
                       {44696400, -19146700}, {44509500, -19123100},
                       {44490800, -19120800}, {44308400, -19073900},
                       {44290100, -19069200}, {44097500, -18993000},
                       {43915900, -18893100}, {43748200, -18771300},
                       {43597200, -18629500}, {43465100, -18469800},
                       {43354100, -18294900}, {43265900, -18107400},
                       {43201800, -17910300}, {43163000, -17706800},
                       {43150000, -17500000}, {43163000, -17293200},
                       {43201800, -17089700}, {43265900, -16892600},
                       {43354100, -16705099}, {43465100, -16530199},
                       {43597200, -16370501}, {43748200, -16228701},
                       {43915900, -16106899}, {44097500, -16007000},
                       {44290100, -15930800}, {44308400, -15926100},
                       {44490800, -15879200}, {44509500, -15876900},
                       {44696400, -15853300}, {44903600, -15853300},
                       {45090500, -15876900}, {45109200, -15879200},
                       {45291600, -15926100}, {45309900, -15930800},
                       {45502500, -16007000}, {45684100, -16106899},
                       {45851700, -16228701}, {46002800, -16370501},
                       {46134900, -16530199}, {46245900, -16705099},
                       {46334100, -16892600}, {46398200, -17089700},
                       {46437000, -17293200}, {46450000, -17500000},
                       {46437000, -17706800}, {46398200, -17910300},
                       {46334100, -18107400}, {46245900, -18294900},
                       {46134900, -18469800}, {46002800, -18629500},
                       {45851700, -18771300}, {45684100, -18893100},
                       {45502500, -18993000}, {45309900, -19069200},
                       {45291600, -19073900}, {45109200, -19120800},
                       {45090500, -19123100}, {44903600, -19146700},
                   },
                   {
                       {28129300, -44138600}, {25839000, -43651800},
                       {23700000, -42699500}, {21805700, -41323200},
                       {20239000, -39583200}, {19068300, -37555500},
                       {18344700, -35328600}, {18100000, -33000000},
                       {18344700, -30671400}, {19068300, -28444500},
                       {20239000, -26416800}, {21805700, -24676800},
                       {23700000, -23300500}, {25839000, -22348200},
                       {28129300, -21861400}, {28300000, -21861400},
                       {28300000, -21702200}, {30300000, -21702200},
                       {30300000, -21861400}, {30470700, -21861400},
                       {32761002, -22348200}, {34900000, -23300500},
                       {36794300, -24676800}, {38361000, -26416800},
                       {39531700, -28444500}, {40255300, -30671400},
                       {40500000, -33000000}, {40255300, -35328600},
                       {39531700, -37555500}, {38361000, -39583200},
                       {36794300, -41323200}, {34900000, -42699500},
                       {32761002, -43651800}, {30470700, -44138600},
                   },
                   {
                       {44696400, -50146700}, {44509500, -50123100},
                       {44490800, -50120800}, {44308400, -50073900},
                       {44290100, -50069200}, {44097500, -49993000},
                       {43915900, -49893100}, {43748200, -49771300},
                       {43597200, -49629500}, {43465100, -49469800},
                       {43354100, -49294900}, {43265900, -49107400},
                       {43201800, -48910300}, {43163000, -48706800},
                       {43150000, -48500000}, {43163000, -48293200},
                       {43201800, -48089700}, {43265900, -47892600},
                       {43354100, -47705100}, {43465100, -47530200},
                       {43597200, -47370500}, {43748200, -47228700},
                       {43915900, -47106900}, {44097500, -47007000},
                       {44290100, -46930800}, {44308400, -46926100},
                       {44490800, -46879200}, {44509500, -46876900},
                       {44696400, -46853300}, {44903600, -46853300},
                       {45090500, -46876900}, {45109200, -46879200},
                       {45291600, -46926100}, {45309900, -46930800},
                       {45502500, -47007000}, {45684100, -47106900},
                       {45851700, -47228700}, {46002800, -47370500},
                       {46134900, -47530200}, {46245900, -47705100},
                       {46334100, -47892600}, {46398200, -48089700},
                       {46437000, -48293200}, {46450000, -48500000},
                       {46437000, -48706800}, {46398200, -48910300},
                       {46334100, -49107400}, {46245900, -49294900},
                       {46134900, -49469800}, {46002800, -49629500},
                       {45851700, -49771300}, {45684100, -49893100},
                       {45502500, -49993000}, {45309900, -50069200},
                       {45291600, -50073900}, {45109200, -50120800},
                       {45090500, -50123100}, {44903600, -50146700},
                   },
                   {
                       {13696400, -50146700}, {13509500, -50123100},
                       {13490800, -50120800}, {13308400, -50073900},
                       {13290100, -50069200}, {13097500, -49993000},
                       {12915900, -49893100}, {12748300, -49771300},
                       {12597200, -49629500}, {12465100, -49469800},
                       {12354100, -49294900}, {12265900, -49107400},
                       {12201800, -48910300}, {12163000, -48706800},
                       {12150000, -48500000}, {12163000, -48293200},
                       {12201800, -48089700}, {12265900, -47892600},
                       {12354100, -47705100}, {12465100, -47530200},
                       {12597200, -47370500}, {12748300, -47228700},
                       {12915900, -47106900}, {13097500, -47007000},
                       {13290100, -46930800}, {13308400, -46926100},
                       {13490800, -46879200}, {13509500, -46876900},
                       {13696400, -46853300}, {13903600, -46853300},
                       {14090500, -46876900}, {14109200, -46879200},
                       {14291600, -46926100}, {14309900, -46930800},
                       {14502500, -47007000}, {14684100, -47106900},
                       {14791899, -47185194}, {14851700, -47228700},
                       {14851800, -47228700}, {15002800, -47370500},
                       {15134900, -47530200}, {15245900, -47705100},
                       {15334100, -47892600}, {15398200, -48089700},
                       {15437000, -48293200}, {15450000, -48500000},
                       {15437000, -48706800}, {15398200, -48910300},
                       {15334100, -49107400}, {15245900, -49294900},
                       {15134900, -49469800}, {15002800, -49629500},
                       {14851800, -49771300}, {14851700, -49771300},
                       {14791899, -49814806}, {14684100, -49893100},
                       {14502500, -49993000}, {14309900, -50069200},
                       {14291600, -50073900}, {14109200, -50120800},
                       {14090500, -50123100}, {13903600, -50146700},
                   },
               }},
    },
    ExPolygons{
        // "extruder-cover.stl":
        MyPoly{{
                   {20500000, 366025},     {21732100, 2500000},
                   {24500000, 2500000},    {24500000, -1500000},
                   {31500000, -1500000},   {31500000, 1500000},
                   {27250000, 5750000},    {-17000000, 5750000},
                   {-17000000, -26799100}, {-35109600, -33390400},
                   {-40700000, -33390400}, {-43650000, -38500000},
                   {-40700000, -43609600}, {-34800000, -43609600},
                   {-33470820, -41307370}, {-17000000, -35312500},
                   {-17000000, -36500000}, {-15000000, -36500000},
                   {-15000000, -44000000}, {20500000, -44000000},
               },
               {
                   {
                       {16832800, 1408760}, {16667299, 1434960},
                       {16505600, 1478310}, {16349199, 1538330},
                       {16200001, 1614360}, {16059500, 1705570},
                       {15929400, 1810970}, {15811000, 1929390},
                       {15705600, 2059540}, {15614400, 2200000},
                       {15538300, 2349220}, {15478300, 2505570},
                       {15435000, 2667340}, {15408800, 2832750},
                       {15400000, 3000000}, {15408800, 3167240},
                       {15435000, 3332660}, {15478300, 3494430},
                       {15538300, 3650780}, {15614400, 3800000},
                       {15705600, 3940460}, {15811000, 4070610},
                       {15929400, 4189030}, {16059500, 4294430},
                       {16200001, 4385640}, {16349199, 4461670},
                       {16505600, 4521690}, {16667299, 4565040},
                       {16832800, 4591230}, {17000000, 4600000},
                       {17167200, 4591230}, {17332700, 4565040},
                       {17494400, 4521690}, {17650800, 4461670},
                       {17800000, 4385640}, {17940500, 4294430},
                       {18070600, 4189030}, {18189000, 4070610},
                       {18294400, 3940460}, {18385600, 3800000},
                       {18461700, 3650780}, {18521700, 3494430},
                       {18565000, 3332660}, {18591200, 3167240},
                       {18600000, 3000000}, {18591200, 2832750},
                       {18565000, 2667340}, {18521700, 2505570},
                       {18461700, 2349220}, {18385600, 2200000},
                       {18294400, 2059540}, {18189000, 1929390},
                       {18070600, 1810970}, {17940500, 1705570},
                       {17800000, 1614360}, {17650800, 1538330},
                       {17494400, 1478310}, {17332700, 1434960},
                       {17167200, 1408760}, {17000000, 1400000},
                   },
                   {
                       {-11603600, -2146740}, {-11809200, -2120770},
                       {-12009900, -2069240}, {-12202500, -1992960},
                       {-12384100, -1893140}, {-12551700, -1771350},
                       {-12702800, -1629500}, {-12834900, -1469840},
                       {-12945900, -1294890}, {-13034100, -1107400},
                       {-13098200, -910337},  {-13137000, -706800},
                       {-13150000, -499999},  {-13137000, -293200},
                       {-13098200, -89661},   {-13034100, 107405},
                       {-12945900, 294893},   {-12834900, 469845},
                       {-12702800, 629502},   {-12551700, 771346},
                       {-12384100, 893141},   {-12202500, 992964},
                       {-12009900, 1069240},  {-11809200, 1120770},
                       {-11603600, 1146740},  {-11396400, 1146740},
                       {-11190800, 1120770},  {-10990100, 1069240},
                       {-10797500, 992964},   {-10615900, 893141},
                       {-10448200, 771346},   {-10297200, 629502},
                       {-10165100, 469845},   {-10054100, 294893},
                       {-9965870, 107405},    {-9901840, -89661},
                       {-9863010, -293200},   {-9850000, -500000},
                       {-9863010, -706800},   {-9901840, -910337},
                       {-9965870, -1107400},  {-10054100, -1294890},
                       {-10165100, -1469840}, {-10297200, -1629500},
                       {-10448200, -1771350}, {-10615900, -1893140},
                       {-10797500, -1992960}, {-10990100, -2069240},
                       {-11190800, -2120770}, {-11396400, -2146740},
                   },
                   {
                       {-37917200, -40091200}, {-38244400, -40021700},
                       {-38550000, -39885600}, {-38820600, -39689000},
                       {-39044400, -39440500}, {-39211700, -39150800},
                       {-39315000, -38832700}, {-39350000, -38500000},
                       {-39315000, -38167300}, {-39211700, -37849200},
                       {-39044400, -37559500}, {-38820600, -37311000},
                       {-38550000, -37114400}, {-38244400, -36978300},
                       {-37917200, -36908800}, {-37582800, -36908800},
                       {-37255600, -36978300}, {-36950000, -37114400},
                       {-36679400, -37311000}, {-36455600, -37559500},
                       {-36288300, -37849200}, {-36185000, -38167300},
                       {-36150000, -38500000}, {-36185000, -38832700},
                       {-36288300, -39150800}, {-36455600, -39440500},
                       {-36679400, -39689000}, {-36950000, -39885600},
                       {-37255600, -40021700}, {-37582800, -40091200},
                   },
                   {
                       {14353700, -41892300}, {14067400, -41831500},
                       {13800000, -41712400}, {13563200, -41540400},
                       {13367400, -41322900}, {13221000, -41069400},
                       {13130600, -40791100}, {13100000, -40500000},
                       {13130600, -40208900}, {13221000, -39930600},
                       {13367400, -39677100}, {13563200, -39459600},
                       {13800000, -39287600}, {14067400, -39168500},
                       {14353700, -39107700}, {14646300, -39107700},
                       {14932600, -39168500}, {15200000, -39287600},
                       {15436800, -39459600}, {15632600, -39677100},
                       {15779000, -39930600}, {15869400, -40208900},
                       {15900000, -40500000}, {15869400, -40791100},
                       {15779000, -41069400}, {15632600, -41322900},
                       {15436800, -41540400}, {15200000, -41712400},
                       {14932600, -41831500}, {14646300, -41892300},
                   },
               }},
    },
    ExPolygons{
        // "Einsy-base.stl":
        MyPoly{{
                   {85000000, 2000000},
                   {87000000, 5464100},
                   {91000000, 5464100},
                   {93000000, 2000000},
                   {91845296, 0},
                   {118500000, 0},
                   {118500000, 79000000},
                   {105500000, 92000000},
                   {0, 92000000},
                   {0, 41000000},
                   {-5000000, 41000000},
                   {-9000000, 38000000},
                   {-9000000, 18000000},
                   {-5000000, 15000000},
                   {0, 15000000},
                   {0, 0},
                   {86154704, 0},
               },
               {
                   {
                       {58301400, 86110400}, {57912900, 86193000},
                       {57550000, 86354600}, {57228700, 86588000},
                       {56962900, 86883200}, {56764300, 87227200},
                       {56641500, 87605000}, {56600000, 88000000},
                       {56641500, 88395000}, {56764300, 88772800},
                       {56962900, 89116800}, {57228700, 89412000},
                       {57550000, 89645400}, {57912900, 89807000},
                       {58301400, 89889600}, {58698600, 89889600},
                       {59087100, 89807000}, {59450000, 89645400},
                       {59771300, 89412000}, {60037100, 89116800},
                       {60235700, 88772800}, {60358500, 88395000},
                       {60400000, 88000000}, {60358500, 87605000},
                       {60235700, 87227200}, {60037100, 86883200},
                       {59771300, 86588000}, {59450000, 86354600},
                       {59087100, 86193000}, {58698600, 86110400},
                   },
                   {
                       {78916400, 80204400}, {78752800, 80239200},
                       {78600000, 80307200}, {78464696, 80405504},
                       {78352800, 80529800}, {78269200, 80674600},
                       {78217496, 80833704}, {78200000, 81000000},
                       {78217496, 81166296}, {78269200, 81325400},
                       {78352800, 81470200}, {78464696, 81594496},
                       {78600000, 81692800}, {78752800, 81760800},
                       {78916400, 81795600}, {79083600, 81795600},
                       {79247200, 81760800}, {79400000, 81692800},
                       {79535304, 81594496}, {79647200, 81470200},
                       {79730800, 81325400}, {79782504, 81166296},
                       {79800000, 81000000}, {79782504, 80833704},
                       {79730800, 80674600}, {79647200, 80529800},
                       {79535304, 80405504}, {79400000, 80307200},
                       {79247200, 80239200}, {79083600, 80204400},
                   },
                   {
                       {20916400, 80204400}, {20752800, 80239200},
                       {20600000, 80307200}, {20464700, 80405504},
                       {20352800, 80529800}, {20269200, 80674600},
                       {20217500, 80833704}, {20200000, 81000000},
                       {20217500, 81166296}, {20269200, 81325400},
                       {20352800, 81470200}, {20464700, 81594496},
                       {20600000, 81692800}, {20752800, 81760800},
                       {20916400, 81795600}, {21083600, 81795600},
                       {21247200, 81760800}, {21400000, 81692800},
                       {21535300, 81594496}, {21647200, 81470200},
                       {21730800, 81325400}, {21782500, 81166296},
                       {21800000, 81000000}, {21782500, 80833704},
                       {21730800, 80674600}, {21647200, 80529800},
                       {21535300, 80405504}, {21400000, 80307200},
                       {21247200, 80239200}, {21083600, 80204400},
                   },
                   {
                       {81000000, 60500000},
                       {81000000, 78500000},
                       {84650000, 78500000},
                       {84650000, 60500000},
                   },
                   {
                       {70000000, 60500000},
                       {70000000, 78500000},
                       {73650000, 78500000},
                       {73650000, 60500000},
                   },
                   {
                       {75500000, 60500000},
                       {75500000, 78500000},
                       {79150000, 78500000},
                       {79150000, 60500000},
                   },
                   {
                       {26000000, 60500000},
                       {26000000, 78500000},
                       {29650000, 78500000},
                       {29650000, 60500000},
                   },
                   {
                       {86500000, 60500000},
                       {86500000, 78500000},
                       {90150000, 78500000},
                       {90150000, 60500000},
                   },
                   {
                       {48000000, 60500000},
                       {48000000, 78500000},
                       {51650000, 78500000},
                       {51650000, 60500000},
                   },
                   {
                       {64500000, 60500000},
                       {64500000, 78500000},
                       {68150000, 78500000},
                       {68150000, 60500000},
                   },
                   {
                       {59000000, 60500000},
                       {59000000, 78500000},
                       {62650000, 78500000},
                       {62650000, 60500000},
                   },
                   {
                       {20500000, 60500000},
                       {20500000, 78500000},
                       {24150000, 78500000},
                       {24150000, 60500000},
                   },
                   {
                       {92000000, 60500000},
                       {92000000, 78500000},
                       {95650000, 78500000},
                       {95650000, 60500000},
                   },
                   {
                       {42500000, 60500000},
                       {42500000, 78500000},
                       {46150000, 78500000},
                       {46150000, 60500000},
                   },
                   {
                       {31500000, 60500000},
                       {31500000, 78500000},
                       {35150000, 78500000},
                       {35150000, 60500000},
                   },
                   {
                       {37000000, 60500000},
                       {37000000, 78500000},
                       {40650000, 78500000},
                       {40650000, 60500000},
                   },
                   {
                       {53500000, 60500000},
                       {53500000, 78500000},
                       {57150000, 78500000},
                       {57150000, 60500000},
                   },
                   {
                       {7301400, 73110400}, {6912870, 73193000},
                       {6550000, 73354600}, {6228650, 73588000},
                       {5962870, 73883200}, {5900000, 73992104},
                       {5764260, 74227200}, {5641520, 74605000},
                       {5600000, 75000000}, {5641520, 75395000},
                       {5764260, 75772800}, {5900000, 76007896},
                       {5962870, 76116800}, {6228650, 76412000},
                       {6550000, 76645400}, {6912870, 76807000},
                       {7301400, 76889600}, {7698600, 76889600},
                       {8087129, 76807000}, {8450000, 76645400},
                       {8771350, 76412000}, {9037130, 76116800},
                       {9100000, 76007896}, {9235740, 75772800},
                       {9358480, 75395000}, {9400000, 75000000},
                       {9358480, 74605000}, {9235740, 74227200},
                       {9100000, 73992104}, {9037130, 73883200},
                       {8771350, 73588000}, {8450000, 73354600},
                       {8087129, 73193000}, {7698600, 73110400},
                   },
                   {
                       {102301000, 73110400}, {101913000, 73193000},
                       {101550000, 73354600}, {101229000, 73588000},
                       {100963000, 73883200}, {100764000, 74227200},
                       {100642000, 74605000}, {100600000, 75000000},
                       {100642000, 75395000}, {100764000, 75772800},
                       {100963000, 76116800}, {101229000, 76412000},
                       {101550000, 76645400}, {101913000, 76807000},
                       {102301000, 76889600}, {102699000, 76889600},
                       {103087000, 76807000}, {103450000, 76645400},
                       {103771000, 76412000}, {104037000, 76116800},
                       {104236000, 75772800}, {104358000, 75395000},
                       {104400000, 75000000}, {104358000, 74605000},
                       {104236000, 74227200}, {104037000, 73883200},
                       {103771000, 73588000}, {103450000, 73354600},
                       {103087000, 73193000}, {102699000, 73110400},
                   },
                   {
                       {37000000, 35500000},
                       {37000000, 53500000},
                       {40650000, 53500000},
                       {40650000, 35500000},
                   },
                   {
                       {53500000, 35500000},
                       {53500000, 53500000},
                       {57150000, 53500000},
                       {57150000, 35500000},
                   },
                   {
                       {75500000, 35500000},
                       {75500000, 53500000},
                       {79150000, 53500000},
                       {79150000, 35500000},
                   },
                   {
                       {31500000, 35500000},
                       {31500000, 53500000},
                       {35150000, 53500000},
                       {35150000, 35500000},
                   },
                   {
                       {92000000, 35500000},
                       {92000000, 53500000},
                       {95650000, 53500000},
                       {95650000, 35500000},
                   },
                   {
                       {81000000, 35500000},
                       {81000000, 53500000},
                       {84650000, 53500000},
                       {84650000, 35500000},
                   },
                   {
                       {86500000, 35500000},
                       {86500000, 53500000},
                       {90150000, 53500000},
                       {90150000, 35500000},
                   },
                   {
                       {48000000, 35500000},
                       {48000000, 53500000},
                       {51650000, 53500000},
                       {51650000, 35500000},
                   },
                   {
                       {42500000, 35500000},
                       {42500000, 53500000},
                       {46150000, 53500000},
                       {46150000, 35500000},
                   },
                   {
                       {70000000, 35500000},
                       {70000000, 53500000},
                       {73650000, 53500000},
                       {73650000, 35500000},
                   },
                   {
                       {20500000, 35500000},
                       {20500000, 53500000},
                       {24150000, 53500000},
                       {24150000, 35500000},
                   },
                   {
                       {59000000, 35500000},
                       {59000000, 53500000},
                       {62650000, 53500000},
                       {62650000, 35500000},
                   },
                   {
                       {64500000, 35500000},
                       {64500000, 53500000},
                       {68150000, 53500000},
                       {68150000, 35500000},
                   },
                   {
                       {26000000, 35500000},
                       {26000000, 53500000},
                       {29650000, 53500000},
                       {29650000, 35500000},
                   },
                   {
                       {16290899, 8010959},  {15882000, 8097890},
                       {15500000, 8267950},  {15161700, 8513710},
                       {14882000, 8824430},  {14672900, 9186530},
                       {14543700, 9584180},  {14500000, 10000000},
                       {14500000, 34000000}, {14543700, 34415800},
                       {14672900, 34813500}, {14882000, 35175600},
                       {15161700, 35486300}, {15500000, 35732000},
                       {15882000, 35902100}, {16290899, 35989000},
                       {16709101, 35989000}, {17118000, 35902100},
                       {17500000, 35732000}, {17838300, 35486300},
                       {18118000, 35175600}, {18327100, 34813500},
                       {18456300, 34415800}, {18500000, 34000000},
                       {18500000, 10000000}, {18456300, 9584180},
                       {18327100, 9186530},  {18118000, 8824430},
                       {17838300, 8513710},  {17500000, 8267950},
                       {17118000, 8097890},  {16709101, 8010959},
                   },
                   {
                       {59000000, 10500000},
                       {59000000, 28500000},
                       {62650000, 28500000},
                       {62650000, 10500000},
                   },
                   {
                       {81000000, 10500000},
                       {81000000, 28500000},
                       {84650000, 28500000},
                       {84650000, 10500000},
                   },
                   {
                       {75500000, 10500000},
                       {75500000, 28500000},
                       {79150000, 28500000},
                       {79150000, 10500000},
                   },
                   {
                       {70000000, 10500000},
                       {70000000, 28500000},
                       {73650000, 28500000},
                       {73650000, 10500000},
                   },
                   {
                       {20500000, 10500000},
                       {20500000, 28500000},
                       {24150000, 28500000},
                       {24150000, 10500000},
                   },
                   {
                       {92000000, 10500000},
                       {92000000, 28500000},
                       {95650000, 28500000},
                       {95650000, 10500000},
                   },
                   {
                       {26000000, 10500000},
                       {26000000, 28500000},
                       {29650000, 28500000},
                       {29650000, 10500000},
                   },
                   {
                       {53500000, 10500000},
                       {53500000, 28500000},
                       {57150000, 28500000},
                       {57150000, 10500000},
                   },
                   {
                       {48000000, 10500000},
                       {48000000, 28500000},
                       {51650000, 28500000},
                       {51650000, 10500000},
                   },
                   {
                       {42500000, 10500000},
                       {42500000, 28500000},
                       {46150000, 28500000},
                       {46150000, 10500000},
                   },
                   {
                       {37000000, 10500000},
                       {37000000, 28500000},
                       {40650000, 28500000},
                       {40650000, 10500000},
                   },
                   {
                       {31500000, 10500000},
                       {31500000, 28500000},
                       {35150000, 28500000},
                       {35150000, 10500000},
                   },
                   {
                       {64500000, 10500000},
                       {64500000, 28500000},
                       {68150000, 28500000},
                       {68150000, 10500000},
                   },
                   {
                       {86500000, 10500000},
                       {86500000, 28500000},
                       {90150000, 28500000},
                       {90150000, 10500000},
                   },
                   {
                       {102301000, 12110400}, {101913000, 12193000},
                       {101550000, 12354600}, {101229000, 12588000},
                       {100963000, 12883200}, {100764000, 13227200},
                       {100642000, 13605000}, {100600000, 14000000},
                       {100642000, 14395000}, {100764000, 14772800},
                       {100963000, 15116800}, {101229000, 15412000},
                       {101550000, 15645400}, {101913000, 15807000},
                       {102301000, 15889600}, {102699000, 15889600},
                       {103087000, 15807000}, {103450000, 15645400},
                       {103771000, 15412000}, {104037000, 15116800},
                       {104236000, 14772800}, {104358000, 14395000},
                       {104400000, 14000000}, {104358000, 13605000},
                       {104236000, 13227200}, {104037000, 12883200},
                       {103771000, 12588000}, {103450000, 12354600},
                       {103087000, 12193000}, {102699000, 12110400},
                   },
                   {
                       {7301400, 12110400}, {6912870, 12193000},
                       {6550000, 12354600}, {6228650, 12588000},
                       {5962870, 12883200}, {5900000, 12992100},
                       {5764260, 13227200}, {5641520, 13605000},
                       {5600000, 14000000}, {5641520, 14395000},
                       {5764260, 14772800}, {5900000, 15007900},
                       {5962870, 15116800}, {6228650, 15412000},
                       {6550000, 15645400}, {6912870, 15807000},
                       {7301400, 15889600}, {7698600, 15889600},
                       {8087129, 15807000}, {8450000, 15645400},
                       {8771350, 15412000}, {9037130, 15116800},
                       {9100000, 15007900}, {9235740, 14772800},
                       {9358480, 14395000}, {9400000, 14000000},
                       {9358480, 13605000}, {9235740, 13227200},
                       {9100000, 12992100}, {9037130, 12883200},
                       {8771350, 12588000}, {8450000, 12354600},
                       {8087129, 12193000}, {7698600, 12110400},
                   },
               }},
    },
    ExPolygons{
        // "lcd-supports.stl":
        MyPoly{{
                   {4192390, 4192390},    {4192390, 5707110},
                   {2474870, 7424620},    {1626350, 6576090},
                   {3040560, 5161880},    {1767770, 3889090},
                   {-2474870, 8131730},   {-5303300, 5303300},
                   {-36769600, 36769600}, {-33941100, 39598000},
                   {-38183750, 43840650}, {-36911000, 45113400},
                   {-35496800, 43699200}, {-34648200, 44547700},
                   {-36769600, 46669000}, {-38183800, 46669000},
                   {-46852800, 38000000}, {-61500000, 38000000},
                   {-61500000, 12000000}, {-50000000, 12000000},
                   {-50000000, 11984300}, {-37204500, -811183},
                   {-811183, -811183},
               },
               {
                   {
                       {-36000000, 8000000},
                       {-51500000, 23500000},
                       {-37357900, 23500000},
                       {-21857900, 8000000},
                   },
               }},
        MyPoly{{
                   {-13147200, -40000000}, {1500000, -40000000},
                   {1500000, -14000000},   {-10000000, -14000000},
                   {-10000000, -13984300}, {-22795500, -1188820},
                   {-59188800, -1188820},  {-64192400, -6192390},
                   {-64192400, -7707110},  {-62474900, -9424620},
                   {-61626300, -8576090},  {-63040571, -7161851},
                   {-61767800, -5889090},  {-57525100, -10131700},
                   {-54696700, -7303300},  {-23230400, -38769600},
                   {-26058900, -41598000}, {-21816250, -45840650},
                   {-23089000, -47113400}, {-24503200, -45699200},
                   {-25351800, -46547700}, {-23230400, -48669000},
                   {-21816200, -48669000},
               },
               {
                   {
                       {-22642100, -25500000},
                       {-38142100, -10000000},
                       {-24000000, -10000000},
                       {-9357800, -24642200},
                       {-9288210, -24711800},
                       {-8500000, -25500000},
                   },
               }},
    },
};
