# 2024-08-29 Triage Log

Not a bad week. More improvements than regressions.

Triage done by **@pnkfelix**.
Revision range: [4fe1e2bd..acb4e8b6](https://perf.rust-lang.org/?start=4fe1e2bd5bf5a6f1cb245f161a5e9d315766f103&end=acb4e8b6251f1d8da36f08e7a70fa23fc581839e&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 2.3%]    | 25    |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.1%, 1.9%]    | 16    |
| Improvements ✅ <br /> (primary)   | -1.4% | [-10.4%, -0.2%] | 54    |
| Improvements ✅ <br /> (secondary) | -2.6% | [-8.1%, -0.3%]  | 56    |
| All ❌✅ (primary)                 | -0.8% | [-10.4%, 2.3%]  | 79    |


5 Regressions, 3 Improvements, 3 Mixed; 5 of them in rollups
44 artifact comparisons made in total

#### Regressions

Update stdarch submodule [#128866](https://github.com/rust-lang/rust/pull/128866) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4d7c095832494257a9f57e13fd151a9d4f5c6851&end=59a74db37df8628f778faf75faa41958bb07a42a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.5%] | 2     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.1%, 0.7%] | 14    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.5%] | 2     |

* primary regressions are to cratelift-codegen llvm-opt-full and helloworld llvm-doc-full
* from the graphs, the cranelift regression looks like a blip, and the helloworld regression seems tiny compared to other changes in its history -- I infer the auto-computed significance threshold is quite low here, probably because historically the build time for helloworld is very stable?
* In any case, doesn't seem worth investigating. Marking as triaged.

Rollup of 9 pull requests [#129365](https://github.com/rust-lang/rust/pull/129365) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a32d4a0e822a29a6682e08b75a8df4c29c7fa9f1&end=739b1fdb158a3216d1b592d0d79d77d256f59815&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.4%] | 15    |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.4%] | 15    |

* primary regressions are solely to various incr-patched scenarios
* confirmed that PR #127279 is root cause
* note that PR #127279 is addressing an issue in incr-comp; it might be expected that it would cause some incr-comp benchmarks to be impacted.
* left some comments and marked as triaged.

Rollup of 9 pull requests [#129521](https://github.com/rust-lang/rust/pull/129521) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=697d9530d78aeba31458cadfc338adb2aea90bee&end=717aec0f8eebdc5eb51756e5129dde15e8b25710&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.4%, 0.9%] | 6     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.4%, 0.9%] | 6     |

* primary regressions are solely to various incremental scenarios for the bitmaps crate
* PR #129513 and PR #129546 seem to have recovered much of the losses here... but after review, they are probably just masking the loss introduced by PR #129521
* opened [discussion in zulip](https://rust-lang.zulipchat.com/#narrow/stream/247081-t-compiler.2Fperformance/topic/numeric.20precision.20in.20rustc-perf.20detailed.20results/near/466074054) about how to actually dig more deeply into regressions like this.
* nothing here seems like it should have impacted incr-comp, and this regression seems minor enough that it does not warrant deeper investigation
* marking as triaged

Rollup of 9 pull requests [#129632](https://github.com/rust-lang/rust/pull/129632) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=515395af0efdbdd657ff08a1f6d28e553856654f&end=bf662eb80838008acabc307dd64d84935ce3a20d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4% | [0.6%, 2.3%] | 2     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.4% | [0.6%, 2.3%] | 2     |

* primary doc-full regressions to typenum and stm32f4
* the regression for typenum's walltime is flagged as significant as well.
* the self-profile results for typenum imply that we are spending more time in create_renderer
* enqueued a rust-timer run against PR #192560 which is the most obvious candidate as a rustdoc change

Implement a first version of RFC 3525: struct target features [#127537](https://github.com/rust-lang/rust/pull/127537) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=100fde5246bf56f22fb5cc85374dd841296fce0e&end=acb4e8b6251f1d8da36f08e7a70fa23fc581839e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.0%] | 72    |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.2%, 2.2%] | 19    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.0%] | 72    |

* this is being actively investigated by the PR author after getting feedback from @nnethercote
* not marking as triaged

#### Improvements

Rollup of 9 pull requests [#129331](https://github.com/rust-lang/rust/pull/129331) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5aea14073eee9e403c3bb857490cd6aa4a395531&end=4d7c095832494257a9f57e13fd151a9d4f5c6851&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -3.2% | [-10.3%, -0.5%] | 19    |
| Improvements ✅ <br /> (secondary) | -5.0% | [-7.4%, -1.4%]  | 21    |
| All ❌✅ (primary)                 | -3.2% | [-10.3%, -0.5%] | 19    |


Do not call source_span when not tracking dependencies. [#129513](https://github.com/rust-lang/rust/pull/129513) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=600edc948ab5de7a92538bcc2f49cb8d47925e2d&end=ab869e094a907cc5d19b4080f22eccaf347f1f95&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 20    |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 3     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 20    |


Get rid of `predicates_defined_on` [#129546](https://github.com/rust-lang/rust/pull/129546) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d9a2cc4daee38c63b2f69710ed61d40acc32b709&end=748c54848dc2964b7e133f945cabe5bc64079947&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 3.2%  | [3.2%, 3.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.3%, -0.2%] | 108   |
| Improvements ✅ <br /> (secondary) | -0.7% | [-2.0%, -0.1%] | 68    |
| All ❌✅ (primary)                 | -0.4% | [-1.3%, -0.2%] | 108   |


#### Mixed

Rollup of 6 pull requests [#129275](https://github.com/rust-lang/rust/pull/129275) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5601d14249818d952da612fec481b7af3ed03a39&end=636d7ff91b9847d6d43c7bbe023568828f6e3246&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 8     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.0%, -1.0%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 1     |

* sole primary regression is to helloworld doc-full.
* marked as triaged.

Don't generate functions with the `rustc_intrinsic_must_be_overridden` attribute [#129239](https://github.com/rust-lang/rust/pull/129239) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a971212545766fdfe0dd68e5d968133f79944a19&end=4d5b3b196284aded6ae99d12bcf149ffdc8ef379&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-2.2%, -0.6%] | 6     |
| All ❌✅ (primary)                 | -0.1% | [-0.3%, 0.2%]  | 3     |

* sole primary regression is to html5ever opt-full
* from inspecting the PR, its hard to imagine doing this in a better way, and Isuspect the reported regression is noise.
* marked as triaged

Add a precondition check for Layout::from_size_align_unchecked [#126556](https://github.com/rust-lang/rust/pull/126556) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=59a74db37df8628f778faf75faa41958bb07a42a&end=982c6f8721416431ec62bb0b9105c0578a9fc603&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.3%  | [1.1%, 1.5%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 9     |


* this PR went through significant microoptimization during develoment and review
* also, already marked as triaged
