# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationProtectionClustersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_list_by_replication_protection_containers(self, resource_group):
        response = self.client.replication_protection_clusters.list_by_replication_protection_containers(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_get(self, resource_group):
        response = self.client.replication_protection_clusters.get(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_begin_create(self, resource_group):
        response = self.client.replication_protection_clusters.begin_create(
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            replication_protection_cluster={
                "id": "str",
                "name": "str",
                "properties": {
                    "activeLocation": "str",
                    "agentClusterId": "str",
                    "allowedOperations": ["str"],
                    "areAllClusterNodesRegistered": bool,
                    "clusterFqdn": "str",
                    "clusterNodeFqdns": ["str"],
                    "clusterProtectedItemIds": ["str"],
                    "clusterRegisteredNodes": [
                        {"biosId": "str", "clusterNodeFqdn": "str", "isSharedDiskVirtualNode": bool, "machineId": "str"}
                    ],
                    "currentScenario": {"jobId": "str", "scenarioName": "str", "startTime": "2020-02-20 00:00:00"},
                    "healthErrors": [
                        {
                            "creationTimeUtc": "2020-02-20 00:00:00",
                            "customerResolvability": "str",
                            "entityId": "str",
                            "errorCategory": "str",
                            "errorCode": "str",
                            "errorId": "str",
                            "errorLevel": "str",
                            "errorMessage": "str",
                            "errorSource": "str",
                            "errorType": "str",
                            "innerHealthErrors": [
                                {
                                    "creationTimeUtc": "2020-02-20 00:00:00",
                                    "customerResolvability": "str",
                                    "entityId": "str",
                                    "errorCategory": "str",
                                    "errorCode": "str",
                                    "errorId": "str",
                                    "errorLevel": "str",
                                    "errorMessage": "str",
                                    "errorSource": "str",
                                    "errorType": "str",
                                    "possibleCauses": "str",
                                    "recommendedAction": "str",
                                    "recoveryProviderErrorMessage": "str",
                                    "summaryMessage": "str",
                                }
                            ],
                            "possibleCauses": "str",
                            "recommendedAction": "str",
                            "recoveryProviderErrorMessage": "str",
                            "summaryMessage": "str",
                        }
                    ],
                    "lastSuccessfulFailoverTime": "2020-02-20 00:00:00",
                    "lastSuccessfulTestFailoverTime": "2020-02-20 00:00:00",
                    "policyFriendlyName": "str",
                    "policyId": "str",
                    "primaryFabricFriendlyName": "str",
                    "primaryFabricProvider": "str",
                    "primaryProtectionContainerFriendlyName": "str",
                    "protectionClusterType": "str",
                    "protectionState": "str",
                    "protectionStateDescription": "str",
                    "providerSpecificDetails": "replication_cluster_provider_specific_settings",
                    "provisioningState": "str",
                    "recoveryContainerId": "str",
                    "recoveryFabricFriendlyName": "str",
                    "recoveryFabricId": "str",
                    "recoveryProtectionContainerFriendlyName": "str",
                    "replicationHealth": "str",
                    "sharedDiskProperties": {
                        "activeLocation": "str",
                        "allowedOperations": ["str"],
                        "currentScenario": {"jobId": "str", "scenarioName": "str", "startTime": "2020-02-20 00:00:00"},
                        "healthErrors": [
                            {
                                "creationTimeUtc": "2020-02-20 00:00:00",
                                "customerResolvability": "str",
                                "entityId": "str",
                                "errorCategory": "str",
                                "errorCode": "str",
                                "errorId": "str",
                                "errorLevel": "str",
                                "errorMessage": "str",
                                "errorSource": "str",
                                "errorType": "str",
                                "innerHealthErrors": [
                                    {
                                        "creationTimeUtc": "2020-02-20 00:00:00",
                                        "customerResolvability": "str",
                                        "entityId": "str",
                                        "errorCategory": "str",
                                        "errorCode": "str",
                                        "errorId": "str",
                                        "errorLevel": "str",
                                        "errorMessage": "str",
                                        "errorSource": "str",
                                        "errorType": "str",
                                        "possibleCauses": "str",
                                        "recommendedAction": "str",
                                        "recoveryProviderErrorMessage": "str",
                                        "summaryMessage": "str",
                                    }
                                ],
                                "possibleCauses": "str",
                                "recommendedAction": "str",
                                "recoveryProviderErrorMessage": "str",
                                "summaryMessage": "str",
                            }
                        ],
                        "protectionState": "str",
                        "replicationHealth": "str",
                        "sharedDiskProviderSpecificDetails": "shared_disk_replication_provider_specific_settings",
                        "testFailoverState": "str",
                    },
                    "testFailoverState": "str",
                    "testFailoverStateDescription": "str",
                },
                "type": "str",
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_begin_purge(self, resource_group):
        response = self.client.replication_protection_clusters.begin_purge(
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_begin_apply_recovery_point(self, resource_group):
        response = self.client.replication_protection_clusters.begin_apply_recovery_point(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            apply_cluster_recovery_point_input={
                "properties": {
                    "providerSpecificDetails": "apply_cluster_recovery_point_provider_specific_input",
                    "clusterRecoveryPointId": "str",
                    "individualNodeRecoveryPoints": ["str"],
                }
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_begin_failover_commit(self, resource_group):
        response = self.client.replication_protection_clusters.begin_failover_commit(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_get_operation_results(self, resource_group):
        response = self.client.replication_protection_clusters.get_operation_results(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            job_id="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_begin_repair_replication(self, resource_group):
        response = self.client.replication_protection_clusters.begin_repair_replication(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_begin_test_failover(self, resource_group):
        response = self.client.replication_protection_clusters.begin_test_failover(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            failover_input={
                "properties": {
                    "failoverDirection": "str",
                    "networkId": "str",
                    "networkType": "str",
                    "providerSpecificDetails": "cluster_test_failover_provider_specific_input",
                }
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_begin_test_failover_cleanup(self, resource_group):
        response = self.client.replication_protection_clusters.begin_test_failover_cleanup(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            cleanup_input={"properties": {"comments": "str"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_begin_unplanned_failover(self, resource_group):
        response = self.client.replication_protection_clusters.begin_unplanned_failover(
            resource_name="str",
            fabric_name="str",
            protection_container_name="str",
            replication_protection_cluster_name="str",
            failover_input={
                "properties": {
                    "failoverDirection": "str",
                    "providerSpecificDetails": "cluster_unplanned_failover_provider_specific_input",
                    "sourceSiteOperations": "str",
                }
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_protection_clusters_list(self, resource_group):
        response = self.client.replication_protection_clusters.list(
            resource_name="str",
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
