//===-- Implementation of ilogb function ----------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#include "src/math/ilogb.h"
#include "src/__support/math/ilogb.h"

namespace LIBC_NAMESPACE_DECL {

LLVM_LIBC_FUNCTION(int, ilogb, (double x)) { return math::ilogb(x); }

} // namespace LIBC_NAMESPACE_DECL
