// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"MSAM",

  0xf2,
  "TeX math symbols",
  0x00600000,
  0x0c45ea36,
  22,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00000000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38d },
  { 0x06, "quad", 0x001471c0 },
  { 0x07, "extra_space", 0x00000000 },
  { 0x08, "num1", 0x000d00d0 },
  { 0x09, "num2", 0x000646fd },
  { 0x0a, "num3", 0x0007c240 },
  { 0x0b, "denom1", 0x000dd165 },
  { 0x0c, "denom2", 0x0006dead },
  { 0x0d, "sup1", 0x00080c28 },
  { 0x0e, "sup2", 0x0006b6d3 },
  { 0x0f, "sup3", 0x000497b5 },
  { 0x10, "sub1", 0x0002aaab },
  { 0x11, "sub2", 0x00055555 },
  { 0x12, "supdrop", 0x000697b0 },
  { 0x13, "subdrop", 0x00015555 },
  { 0x14, "delim1", 0x001fbbbb },
  { 0x15, "delim2", 0x0015999b },
  { 0x16, "axis_height", 0x00040000 }
};



static TFM::Character character[] = {
  { 0x00, 0x000f6845, 0x000c9370, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x000f6845, 0x000c9370, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000f6845, 0x000c9370, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x000f6845, 0x000c9370, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000f6845, 0x000c9370, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x000612f5, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000d5550, 0x000af3c8, 0x0001fb65, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x000d5550, 0x000af3c8, 0x0001fb65, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x000f6845, 0x000a18c0, 0x00024343, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x000f6845, 0x000a18c0, 0x00024343, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x00138e30, 0x0008b0c8, 0x00007f00, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x00138e30, 0x0008b0c8, 0x00007f00, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x000f6845, 0x000c9370, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x000e5ecb, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x00117b3b, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x000c4bd5, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x00138e30, 0x0008b0c8, 0x00007f00, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x00138e30, 0x0008b0c8, 0x00007f00, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x00138e30, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x00138e30, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x001071c0, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x001071c0, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x0008aaa8, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x0008aaa8, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x0008aaa8, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x0008aaa8, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x0015a125, 0x0008b0c8, 0x00007f00, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x0015a125, 0x0008b0c8, 0x00007f00, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x00138e30, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x00138e30, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x000a38e0, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x000a38e0, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x00138e30, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x001ad08b, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x22, 0x00138e30, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x00138e30, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x000f6845, 0x000d1af8, 0x000502e3, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x000f6845, 0x000d1af8, 0x000502e3, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x000f6845, 0x000d1af8, 0x000502e3, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x000f6845, 0x000d8f30, 0x00058f30, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x0015a125, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x000d5550, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000d5550, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000f6845, 0x000a18c0, 0x00024343, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x000e84b5, 0x001071c0, 0x00024343, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x000f6845, 0x000c9370, 0x0004b523, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x000f6845, 0x000c9370, 0x0004b523, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000f6845, 0x000d8f30, 0x00058f30, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x000f6845, 0x000d8f30, 0x00058f30, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x000f6845, 0x000c25eb, 0x00041448, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x0005da13, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x00095550, 0x0008083d, 0x0000083d, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x000f6845, 0x000a18c0, 0x00024343, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x000f6845, 0x000a18c0, 0x00024343, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x000f6845, 0x000d8f30, 0x00058f30, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x000f6845, 0x000c25eb, 0x00041448, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x42, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x43, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x44, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x45, 0x000f6845, 0x000b3bbd, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x46, 0x001025f0, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x47, 0x000a38e0, 0x000c25eb, 0x00041448, 0x00000000, 0, 0, 0, 0 },
  { 0x48, 0x000ce390, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x49, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x4a, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x4b, 0x00095550, 0x0008083d, 0x0000083d, 0x00000000, 0, 0, 0, 0 },
  { 0x4c, 0x00095550, 0x0008083d, 0x0000083d, 0x00000000, 0, 0, 0, 0 },
  { 0x4d, 0x000ce390, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4e, 0x000ce390, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x4f, 0x000ce390, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x50, 0x000f6845, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x51, 0x000f6845, 0x000fe54d, 0x0007e54d, 0x00000000, 0, 0, 0, 0 },
  { 0x52, 0x000f6845, 0x000fe54d, 0x0007e54d, 0x00000000, 0, 0, 0, 0 },
  { 0x53, 0x000f6845, 0x0011b8a5, 0x0009b8a5, 0x00000000, 0, 0, 0, 0 },
  { 0x54, 0x000f6845, 0x0011b8a5, 0x0009b8a5, 0x00000000, 0, 0, 0, 0 },
  { 0x55, 0x000ec8fb, 0x000af3c8, 0x00000000, 0x00007778, 0, 0, 0, 0 },
  { 0x56, 0x00138e30, 0x000af3c8, 0x0002d79d, 0x00000000, 0, 0, 0, 0 },
  { 0x57, 0x00138e30, 0x000af3c8, 0x0002d79d, 0x00000000, 0, 0, 0, 0 },
  { 0x58, 0x001071c0, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x59, 0x000c4bd5, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x5a, 0x000c4bd5, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x5b, 0x000c4bd5, 0x000c25eb, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000e5ecb, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x000e5ecb, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x000e5ecb, 0x0008b0c8, 0x00007f00, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x000f6845, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x000f6845, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x000f6845, 0x000af3c8, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x000f6845, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x000d5550, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x000d5550, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x000f06a3, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x000f06a3, 0x0008b0c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x000f6845, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x000f6845, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x000f6845, 0x000d8f30, 0x00058f30, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x000f6845, 0x000d8f30, 0x00058f30, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x000f6845, 0x000a18c0, 0x0001fb65, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x000f6845, 0x000a18c0, 0x0001fb65, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x0019c710, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x0019c710, 0x00096865, 0x00016865, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x000a38e0, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x000a38e0, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x001025d5, 0x000af3c8, 0x0002a81d, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x000f6835, 0x000af3c8, 0x0002a81d, 0x00000000, 0, 0, 0, 0 },
  { 0x74, 0x000d5550, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x000f6845, 0x000c25eb, 0x00024343, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x000f6845, 0x00063d28, 0xfffe3d28, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x000f6845, 0x0008083d, 0x0000083d, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x000a38e0, 0x000712f3, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x000a38e0, 0x000712f3, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x001071c0, 0x000af3c8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000a38e0, 0x000d1af8, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x7c, 0x000b425b, 0x000712f3, 0x00032c15, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x000f6845, 0x000a18c0, 0x00024343, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x000f6845, 0x000a18c0, 0x00024343, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x000f6845, 0x000a18c0, 0x00024343, 0x00000000, 0, 0, 0, 0 }
};

void
msam6_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
