//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/customerinsights/armcustomerinsights"
	"net/http"
	"net/url"
	"regexp"
)

// ImagesServer is a fake server for instances of the armcustomerinsights.ImagesClient type.
type ImagesServer struct {
	// GetUploadURLForData is the fake for method ImagesClient.GetUploadURLForData
	// HTTP status codes to indicate success: http.StatusOK
	GetUploadURLForData func(ctx context.Context, resourceGroupName string, hubName string, parameters armcustomerinsights.GetImageUploadURLInput, options *armcustomerinsights.ImagesClientGetUploadURLForDataOptions) (resp azfake.Responder[armcustomerinsights.ImagesClientGetUploadURLForDataResponse], errResp azfake.ErrorResponder)

	// GetUploadURLForEntityType is the fake for method ImagesClient.GetUploadURLForEntityType
	// HTTP status codes to indicate success: http.StatusOK
	GetUploadURLForEntityType func(ctx context.Context, resourceGroupName string, hubName string, parameters armcustomerinsights.GetImageUploadURLInput, options *armcustomerinsights.ImagesClientGetUploadURLForEntityTypeOptions) (resp azfake.Responder[armcustomerinsights.ImagesClientGetUploadURLForEntityTypeResponse], errResp azfake.ErrorResponder)
}

// NewImagesServerTransport creates a new instance of ImagesServerTransport with the provided implementation.
// The returned ImagesServerTransport instance is connected to an instance of armcustomerinsights.ImagesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewImagesServerTransport(srv *ImagesServer) *ImagesServerTransport {
	return &ImagesServerTransport{srv: srv}
}

// ImagesServerTransport connects instances of armcustomerinsights.ImagesClient to instances of ImagesServer.
// Don't use this type directly, use NewImagesServerTransport instead.
type ImagesServerTransport struct {
	srv *ImagesServer
}

// Do implements the policy.Transporter interface for ImagesServerTransport.
func (i *ImagesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ImagesClient.GetUploadURLForData":
		resp, err = i.dispatchGetUploadURLForData(req)
	case "ImagesClient.GetUploadURLForEntityType":
		resp, err = i.dispatchGetUploadURLForEntityType(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *ImagesServerTransport) dispatchGetUploadURLForData(req *http.Request) (*http.Response, error) {
	if i.srv.GetUploadURLForData == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetUploadURLForData not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/images/getDataImageUploadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcustomerinsights.GetImageUploadURLInput](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.GetUploadURLForData(req.Context(), resourceGroupNameParam, hubNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ImageDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (i *ImagesServerTransport) dispatchGetUploadURLForEntityType(req *http.Request) (*http.Response, error) {
	if i.srv.GetUploadURLForEntityType == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetUploadURLForEntityType not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/images/getEntityTypeImageUploadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcustomerinsights.GetImageUploadURLInput](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.GetUploadURLForEntityType(req.Context(), resourceGroupNameParam, hubNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ImageDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
