// Copyright (c) 2010-2026, Lawrence Livermore National Security, LLC. Produced
// at the Lawrence Livermore National Laboratory. All Rights reserved. See files
// LICENSE and NOTICE for details. LLNL-CODE-443271.
//
// This file is part of the GLVis visualization tool and library. For more
// information and source code availability see https://glvis.org.
//
// GLVis is free software; you can redistribute it and/or modify it under the
// terms of the BSD-3 license. We welcome feedback and contributions, see file
// CONTRIBUTING.md for details.

#include "palettes_base.hpp"

const Palette BPAL_1 = Palette("5-color",
{
   {0.0f, 0.0f, 1.0f, 1.0f},
   {0.0f, 1.0f, 1.0f, 1.0f},
   {0.0f, 1.0f, 0.0f, 1.0f},
   {1.0f, 1.0f, 0.0f, 1.0f},
   {1.0f, 0.0f, 0.0f, 1.0f},
});

const Palette BPAL_2 = Palette("red",
{
   {1.0f, 0.0f, 0.0f, 1.0f},
   {1.0f, 0.0f, 0.0f, 1.0f},
});

const Palette BPAL_3 = Palette("jet-like",
{
   {0.0f, 0.0f, 0.5f, 1.0f},
   {0.0f, 0.0f, 0.5625f, 1.0f},
   {0.0f, 0.0f, 0.625f, 1.0f},
   {0.0f, 0.0f, 0.6875f, 1.0f},
   {0.0f, 0.0f, 0.75f, 1.0f},
   {0.0f, 0.0f, 0.8125f, 1.0f},
   {0.0f, 0.0f, 0.875f, 1.0f},
   {0.0f, 0.0f, 0.9375f, 1.0f},
   {0.0f, 0.0f, 1.0f, 1.0f},
   {0.0f, 0.0625f, 1.0f, 1.0f},
   {0.0f, 0.125f, 1.0f, 1.0f},
   {0.0f, 0.1875f, 1.0f, 1.0f},
   {0.0f, 0.25f, 1.0f, 1.0f},
   {0.0f, 0.3125f, 1.0f, 1.0f},
   {0.0f, 0.375f, 1.0f, 1.0f},
   {0.0f, 0.4375f, 1.0f, 1.0f},
   {0.0f, 0.5f, 1.0f, 1.0f},
   {0.0f, 0.5625f, 1.0f, 1.0f},
   {0.0f, 0.625f, 1.0f, 1.0f},
   {0.0f, 0.6875f, 1.0f, 1.0f},
   {0.0f, 0.75f, 1.0f, 1.0f},
   {0.0f, 0.8125f, 1.0f, 1.0f},
   {0.0f, 0.875f, 1.0f, 1.0f},
   {0.0f, 0.9375f, 1.0f, 1.0f},
   {0.0f, 1.0f, 1.0f, 1.0f},
   {0.0f, 0.975f, 0.875f, 1.0f},
   {0.0f, 0.95f, 0.75f, 1.0f},
   {0.0f, 0.925f, 0.625f, 1.0f},
   {0.0f, 0.9f, 0.5f, 1.0f},
   {0.0f, 0.875f, 0.375f, 1.0f},
   {0.0f, 0.85f, 0.25f, 1.0f},
   {0.0f, 0.825f, 0.125f, 1.0f},
   {0.0f, 0.8f, 0.0f, 1.0f},
   {0.2872f, 0.825f, 0.0f, 1.0f},
   {0.4353f, 0.85f, 0.0f, 1.0f},
   {0.5552f, 0.875f, 0.0f, 1.0f},
   {0.6598f, 0.9f, 0.0f, 1.0f},
   {0.7543f, 0.925f, 0.0f, 1.0f},
   {0.8415f, 0.95f, 0.0f, 1.0f},
   {0.923f, 0.975f, 0.0f, 1.0f},
   {1.0f, 1.0f, 0.0f, 1.0f},
   {1.0f, 0.9375f, 0.0f, 1.0f},
   {1.0f, 0.875f, 0.0f, 1.0f},
   {1.0f, 0.8125f, 0.0f, 1.0f},
   {1.0f, 0.75f, 0.0f, 1.0f},
   {1.0f, 0.6875f, 0.0f, 1.0f},
   {1.0f, 0.625f, 0.0f, 1.0f},
   {1.0f, 0.5625f, 0.0f, 1.0f},
   {1.0f, 0.5f, 0.0f, 1.0f},
   {1.0f, 0.4375f, 0.0f, 1.0f},
   {1.0f, 0.375f, 0.0f, 1.0f},
   {1.0f, 0.3125f, 0.0f, 1.0f},
   {1.0f, 0.25f, 0.0f, 1.0f},
   {1.0f, 0.1875f, 0.0f, 1.0f},
   {1.0f, 0.125f, 0.0f, 1.0f},
   {1.0f, 0.0625f, 0.0f, 1.0f},
   {1.0f, 0.0f, 0.0f, 1.0f},
   {0.9375f, 0.0f, 0.0f, 1.0f},
   {0.875f, 0.0f, 0.0f, 1.0f},
   {0.8125f, 0.0f, 0.0f, 1.0f},
   {0.75f, 0.0f, 0.0f, 1.0f},
   {0.6875f, 0.0f, 0.0f, 1.0f},
   {0.625f, 0.0f, 0.0f, 1.0f},
   {0.5625f, 0.0f, 0.0f, 1.0f},
   {0.5f, 0.0f, 0.0f, 1.0f},
});

const Palette BPAL_4 = Palette("coldhot",
{
   {0.019531f, 0.1875f, 0.378906f, 1.0f},
   {0.128906f, 0.398438f, 0.671875f, 1.0f},
   {0.261719f, 0.574219f, 0.761719f, 1.0f},
   {0.570312f, 0.769531f, 0.867188f, 1.0f},
   {0.816406f, 0.894531f, 0.9375f, 1.0f},
   {0.964844f, 0.964844f, 0.964844f, 1.0f},
   {0.992188f, 0.855469f, 0.777344f, 1.0f},
   {0.953125f, 0.644531f, 0.507812f, 1.0f},
   {0.835938f, 0.375f, 0.300781f, 1.0f},
   {0.695312f, 0.09375f, 0.167969f, 1.0f},
   {0.402344f, 0.0f, 0.121094f, 1.0f},
});

const Palette BPAL_5 = Palette("bone",
{
   {0.0f, 0.0f, 0.00520833f, 1.0f},
   {0.0138889f, 0.0138889f, 0.0243056f, 1.0f},
   {0.0277778f, 0.0277778f, 0.0434028f, 1.0f},
   {0.0416667f, 0.0416667f, 0.0625f, 1.0f},
   {0.0555556f, 0.0555556f, 0.0815972f, 1.0f},
   {0.0694444f, 0.0694444f, 0.100694f, 1.0f},
   {0.0833333f, 0.0833333f, 0.119792f, 1.0f},
   {0.0972222f, 0.0972222f, 0.138889f, 1.0f},
   {0.111111f, 0.111111f, 0.157986f, 1.0f},
   {0.125f, 0.125f, 0.177083f, 1.0f},
   {0.138889f, 0.138889f, 0.196181f, 1.0f},
   {0.152778f, 0.152778f, 0.215278f, 1.0f},
   {0.166667f, 0.166667f, 0.234375f, 1.0f},
   {0.180556f, 0.180556f, 0.253472f, 1.0f},
   {0.194444f, 0.194444f, 0.272569f, 1.0f},
   {0.208333f, 0.208333f, 0.291667f, 1.0f},
   {0.222222f, 0.222222f, 0.310764f, 1.0f},
   {0.236111f, 0.236111f, 0.329861f, 1.0f},
   {0.25f, 0.25f, 0.348958f, 1.0f},
   {0.263889f, 0.263889f, 0.368056f, 1.0f},
   {0.277778f, 0.277778f, 0.387153f, 1.0f},
   {0.291667f, 0.291667f, 0.40625f, 1.0f},
   {0.305556f, 0.305556f, 0.425347f, 1.0f},
   {0.319444f, 0.319444f, 0.444444f, 1.0f},
   {0.333333f, 0.338542f, 0.458333f, 1.0f},
   {0.347222f, 0.357639f, 0.472222f, 1.0f},
   {0.361111f, 0.376736f, 0.486111f, 1.0f},
   {0.375f, 0.395833f, 0.5f, 1.0f},
   {0.388889f, 0.414931f, 0.513889f, 1.0f},
   {0.402778f, 0.434028f, 0.527778f, 1.0f},
   {0.416667f, 0.453125f, 0.541667f, 1.0f},
   {0.430556f, 0.472222f, 0.555556f, 1.0f},
   {0.444444f, 0.491319f, 0.569444f, 1.0f},
   {0.458333f, 0.510417f, 0.583333f, 1.0f},
   {0.472222f, 0.529514f, 0.597222f, 1.0f},
   {0.486111f, 0.548611f, 0.611111f, 1.0f},
   {0.5f, 0.567708f, 0.625f, 1.0f},
   {0.513889f, 0.586806f, 0.638889f, 1.0f},
   {0.527778f, 0.605903f, 0.652778f, 1.0f},
   {0.541667f, 0.625f, 0.666667f, 1.0f},
   {0.555556f, 0.644097f, 0.680556f, 1.0f},
   {0.569444f, 0.663194f, 0.694444f, 1.0f},
   {0.583333f, 0.682292f, 0.708333f, 1.0f},
   {0.597222f, 0.701389f, 0.722222f, 1.0f},
   {0.611111f, 0.720486f, 0.736111f, 1.0f},
   {0.625f, 0.739583f, 0.75f, 1.0f},
   {0.638889f, 0.758681f, 0.763889f, 1.0f},
   {0.652778f, 0.777778f, 0.777778f, 1.0f},
   {0.674479f, 0.791667f, 0.791667f, 1.0f},
   {0.696181f, 0.805556f, 0.805556f, 1.0f},
   {0.717882f, 0.819444f, 0.819444f, 1.0f},
   {0.739583f, 0.833333f, 0.833333f, 1.0f},
   {0.761285f, 0.847222f, 0.847222f, 1.0f},
   {0.782986f, 0.861111f, 0.861111f, 1.0f},
   {0.804688f, 0.875f, 0.875f, 1.0f},
   {0.826389f, 0.888889f, 0.888889f, 1.0f},
   {0.84809f, 0.902778f, 0.902778f, 1.0f},
   {0.869792f, 0.916667f, 0.916667f, 1.0f},
   {0.891493f, 0.930556f, 0.930556f, 1.0f},
   {0.913194f, 0.944444f, 0.944444f, 1.0f},
   {0.934896f, 0.958333f, 0.958333f, 1.0f},
   {0.956597f, 0.972222f, 0.972222f, 1.0f},
   {0.978299f, 0.986111f, 0.986111f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
});

const Palette BPAL_6 = Palette("hot",
{
   {0.0416667f, 0.0f, 0.0f, 1.0f},
   {0.0833333f, 0.0f, 0.0f, 1.0f},
   {0.125f, 0.0f, 0.0f, 1.0f},
   {0.166667f, 0.0f, 0.0f, 1.0f},
   {0.208333f, 0.0f, 0.0f, 1.0f},
   {0.25f, 0.0f, 0.0f, 1.0f},
   {0.291667f, 0.0f, 0.0f, 1.0f},
   {0.333333f, 0.0f, 0.0f, 1.0f},
   {0.375f, 0.0f, 0.0f, 1.0f},
   {0.416667f, 0.0f, 0.0f, 1.0f},
   {0.458333f, 0.0f, 0.0f, 1.0f},
   {0.5f, 0.0f, 0.0f, 1.0f},
   {0.541667f, 0.0f, 0.0f, 1.0f},
   {0.583333f, 0.0f, 0.0f, 1.0f},
   {0.625f, 0.0f, 0.0f, 1.0f},
   {0.666667f, 0.0f, 0.0f, 1.0f},
   {0.708333f, 0.0f, 0.0f, 1.0f},
   {0.75f, 0.0f, 0.0f, 1.0f},
   {0.791667f, 0.0f, 0.0f, 1.0f},
   {0.833333f, 0.0f, 0.0f, 1.0f},
   {0.875f, 0.0f, 0.0f, 1.0f},
   {0.916667f, 0.0f, 0.0f, 1.0f},
   {0.958333f, 0.0f, 0.0f, 1.0f},
   {1.0f, 0.0f, 0.0f, 1.0f},
   {1.0f, 0.0416667f, 0.0f, 1.0f},
   {1.0f, 0.0833333f, 0.0f, 1.0f},
   {1.0f, 0.125f, 0.0f, 1.0f},
   {1.0f, 0.166667f, 0.0f, 1.0f},
   {1.0f, 0.208333f, 0.0f, 1.0f},
   {1.0f, 0.25f, 0.0f, 1.0f},
   {1.0f, 0.291667f, 0.0f, 1.0f},
   {1.0f, 0.333333f, 0.0f, 1.0f},
   {1.0f, 0.375f, 0.0f, 1.0f},
   {1.0f, 0.416667f, 0.0f, 1.0f},
   {1.0f, 0.458333f, 0.0f, 1.0f},
   {1.0f, 0.5f, 0.0f, 1.0f},
   {1.0f, 0.541667f, 0.0f, 1.0f},
   {1.0f, 0.583333f, 0.0f, 1.0f},
   {1.0f, 0.625f, 0.0f, 1.0f},
   {1.0f, 0.666667f, 0.0f, 1.0f},
   {1.0f, 0.708333f, 0.0f, 1.0f},
   {1.0f, 0.75f, 0.0f, 1.0f},
   {1.0f, 0.791667f, 0.0f, 1.0f},
   {1.0f, 0.833333f, 0.0f, 1.0f},
   {1.0f, 0.875f, 0.0f, 1.0f},
   {1.0f, 0.916667f, 0.0f, 1.0f},
   {1.0f, 0.958333f, 0.0f, 1.0f},
   {1.0f, 1.0f, 0.0f, 1.0f},
   {1.0f, 1.0f, 0.0625f, 1.0f},
   {1.0f, 1.0f, 0.125f, 1.0f},
   {1.0f, 1.0f, 0.1875f, 1.0f},
   {1.0f, 1.0f, 0.25f, 1.0f},
   {1.0f, 1.0f, 0.3125f, 1.0f},
   {1.0f, 1.0f, 0.375f, 1.0f},
   {1.0f, 1.0f, 0.4375f, 1.0f},
   {1.0f, 1.0f, 0.5f, 1.0f},
   {1.0f, 1.0f, 0.5625f, 1.0f},
   {1.0f, 1.0f, 0.625f, 1.0f},
   {1.0f, 1.0f, 0.6875f, 1.0f},
   {1.0f, 1.0f, 0.75f, 1.0f},
   {1.0f, 1.0f, 0.8125f, 1.0f},
   {1.0f, 1.0f, 0.875f, 1.0f},
   {1.0f, 1.0f, 0.9375f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
});

const Palette BPAL_7 = Palette("pink",
{
   {0.117851f, 0.0f, 0.0f, 1.0f},
   {0.195857f, 0.102869f, 0.102869f, 1.0f},
   {0.250661f, 0.145479f, 0.145479f, 1.0f},
   {0.295468f, 0.178174f, 0.178174f, 1.0f},
   {0.334324f, 0.205738f, 0.205738f, 1.0f},
   {0.369112f, 0.230022f, 0.230022f, 1.0f},
   {0.400892f, 0.251976f, 0.251976f, 1.0f},
   {0.430331f, 0.272166f, 0.272166f, 1.0f},
   {0.457882f, 0.290957f, 0.290957f, 1.0f},
   {0.483867f, 0.308607f, 0.308607f, 1.0f},
   {0.508525f, 0.3253f, 0.3253f, 1.0f},
   {0.532042f, 0.341178f, 0.341178f, 1.0f},
   {0.554563f, 0.356348f, 0.356348f, 1.0f},
   {0.576204f, 0.370899f, 0.370899f, 1.0f},
   {0.597061f, 0.3849f, 0.3849f, 1.0f},
   {0.617213f, 0.39841f, 0.39841f, 1.0f},
   {0.636729f, 0.411476f, 0.411476f, 1.0f},
   {0.655663f, 0.424139f, 0.424139f, 1.0f},
   {0.674066f, 0.436436f, 0.436436f, 1.0f},
   {0.69198f, 0.448395f, 0.448395f, 1.0f},
   {0.709441f, 0.460044f, 0.460044f, 1.0f},
   {0.726483f, 0.471405f, 0.471405f, 1.0f},
   {0.743134f, 0.482498f, 0.482498f, 1.0f},
   {0.759421f, 0.493342f, 0.493342f, 1.0f},
   {0.766356f, 0.517549f, 0.503953f, 1.0f},
   {0.773229f, 0.540674f, 0.514344f, 1.0f},
   {0.780042f, 0.562849f, 0.524531f, 1.0f},
   {0.786796f, 0.584183f, 0.534522f, 1.0f},
   {0.793492f, 0.604765f, 0.544331f, 1.0f},
   {0.800132f, 0.624669f, 0.553966f, 1.0f},
   {0.806718f, 0.643958f, 0.563436f, 1.0f},
   {0.81325f, 0.662687f, 0.57275f, 1.0f},
   {0.81973f, 0.6809f, 0.581914f, 1.0f},
   {0.82616f, 0.698638f, 0.590937f, 1.0f},
   {0.832539f, 0.715937f, 0.599824f, 1.0f},
   {0.83887f, 0.732828f, 0.608581f, 1.0f},
   {0.845154f, 0.749338f, 0.617213f, 1.0f},
   {0.851392f, 0.765493f, 0.625727f, 1.0f},
   {0.857584f, 0.781313f, 0.634126f, 1.0f},
   {0.863731f, 0.796819f, 0.642416f, 1.0f},
   {0.869835f, 0.812029f, 0.6506f, 1.0f},
   {0.875897f, 0.82696f, 0.658682f, 1.0f},
   {0.881917f, 0.841625f, 0.666667f, 1.0f},
   {0.887896f, 0.85604f, 0.674556f, 1.0f},
   {0.893835f, 0.870216f, 0.682355f, 1.0f},
   {0.899735f, 0.884164f, 0.690066f, 1.0f},
   {0.905597f, 0.897896f, 0.697691f, 1.0f},
   {0.911421f, 0.911421f, 0.705234f, 1.0f},
   {0.917208f, 0.917208f, 0.727166f, 1.0f},
   {0.922958f, 0.922958f, 0.748455f, 1.0f},
   {0.928673f, 0.928673f, 0.769156f, 1.0f},
   {0.934353f, 0.934353f, 0.789314f, 1.0f},
   {0.939999f, 0.939999f, 0.808969f, 1.0f},
   {0.945611f, 0.945611f, 0.828159f, 1.0f},
   {0.95119f, 0.95119f, 0.846913f, 1.0f},
   {0.956736f, 0.956736f, 0.865261f, 1.0f},
   {0.96225f, 0.96225f, 0.883229f, 1.0f},
   {0.967733f, 0.967733f, 0.900837f, 1.0f},
   {0.973185f, 0.973185f, 0.918109f, 1.0f},
   {0.978607f, 0.978607f, 0.935061f, 1.0f},
   {0.983999f, 0.983999f, 0.951711f, 1.0f},
   {0.989361f, 0.989361f, 0.968075f, 1.0f},
   {0.994695f, 0.994695f, 0.984167f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
});

const Palette BPAL_8 = Palette("cool",
{
   {0.0f, 1.0f, 1.0f, 1.0f},
   {0.015873f, 0.984127f, 1.0f, 1.0f},
   {0.031746f, 0.968254f, 1.0f, 1.0f},
   {0.047619f, 0.952381f, 1.0f, 1.0f},
   {0.0634921f, 0.936508f, 1.0f, 1.0f},
   {0.0793651f, 0.920635f, 1.0f, 1.0f},
   {0.0952381f, 0.904762f, 1.0f, 1.0f},
   {0.111111f, 0.888889f, 1.0f, 1.0f},
   {0.126984f, 0.873016f, 1.0f, 1.0f},
   {0.142857f, 0.857143f, 1.0f, 1.0f},
   {0.15873f, 0.84127f, 1.0f, 1.0f},
   {0.174603f, 0.825397f, 1.0f, 1.0f},
   {0.190476f, 0.809524f, 1.0f, 1.0f},
   {0.206349f, 0.793651f, 1.0f, 1.0f},
   {0.222222f, 0.777778f, 1.0f, 1.0f},
   {0.238095f, 0.761905f, 1.0f, 1.0f},
   {0.253968f, 0.746032f, 1.0f, 1.0f},
   {0.269841f, 0.730159f, 1.0f, 1.0f},
   {0.285714f, 0.714286f, 1.0f, 1.0f},
   {0.301587f, 0.698413f, 1.0f, 1.0f},
   {0.31746f, 0.68254f, 1.0f, 1.0f},
   {0.333333f, 0.666667f, 1.0f, 1.0f},
   {0.349206f, 0.650794f, 1.0f, 1.0f},
   {0.365079f, 0.634921f, 1.0f, 1.0f},
   {0.380952f, 0.619048f, 1.0f, 1.0f},
   {0.396825f, 0.603175f, 1.0f, 1.0f},
   {0.412698f, 0.587302f, 1.0f, 1.0f},
   {0.428571f, 0.571429f, 1.0f, 1.0f},
   {0.444444f, 0.555556f, 1.0f, 1.0f},
   {0.460317f, 0.539683f, 1.0f, 1.0f},
   {0.47619f, 0.52381f, 1.0f, 1.0f},
   {0.492063f, 0.507937f, 1.0f, 1.0f},
   {0.507937f, 0.492063f, 1.0f, 1.0f},
   {0.52381f, 0.47619f, 1.0f, 1.0f},
   {0.539683f, 0.460317f, 1.0f, 1.0f},
   {0.555556f, 0.444444f, 1.0f, 1.0f},
   {0.571429f, 0.428571f, 1.0f, 1.0f},
   {0.587302f, 0.412698f, 1.0f, 1.0f},
   {0.603175f, 0.396825f, 1.0f, 1.0f},
   {0.619048f, 0.380952f, 1.0f, 1.0f},
   {0.634921f, 0.365079f, 1.0f, 1.0f},
   {0.650794f, 0.349206f, 1.0f, 1.0f},
   {0.666667f, 0.333333f, 1.0f, 1.0f},
   {0.68254f, 0.31746f, 1.0f, 1.0f},
   {0.698413f, 0.301587f, 1.0f, 1.0f},
   {0.714286f, 0.285714f, 1.0f, 1.0f},
   {0.730159f, 0.269841f, 1.0f, 1.0f},
   {0.746032f, 0.253968f, 1.0f, 1.0f},
   {0.761905f, 0.238095f, 1.0f, 1.0f},
   {0.777778f, 0.222222f, 1.0f, 1.0f},
   {0.793651f, 0.206349f, 1.0f, 1.0f},
   {0.809524f, 0.190476f, 1.0f, 1.0f},
   {0.825397f, 0.174603f, 1.0f, 1.0f},
   {0.84127f, 0.15873f, 1.0f, 1.0f},
   {0.857143f, 0.142857f, 1.0f, 1.0f},
   {0.873016f, 0.126984f, 1.0f, 1.0f},
   {0.888889f, 0.111111f, 1.0f, 1.0f},
   {0.904762f, 0.0952381f, 1.0f, 1.0f},
   {0.920635f, 0.0793651f, 1.0f, 1.0f},
   {0.936508f, 0.0634921f, 1.0f, 1.0f},
   {0.952381f, 0.047619f, 1.0f, 1.0f},
   {0.968254f, 0.031746f, 1.0f, 1.0f},
   {0.984127f, 0.015873f, 1.0f, 1.0f},
   {1.0f, 0.0f, 1.0f, 1.0f},
});

const Palette BPAL_9 = Palette("summer",
{
   {0.0f, 0.5f, 0.4f, 1.0f},
   {0.015873f, 0.507937f, 0.4f, 1.0f},
   {0.031746f, 0.515873f, 0.4f, 1.0f},
   {0.047619f, 0.52381f, 0.4f, 1.0f},
   {0.0634921f, 0.531746f, 0.4f, 1.0f},
   {0.0793651f, 0.539683f, 0.4f, 1.0f},
   {0.0952381f, 0.547619f, 0.4f, 1.0f},
   {0.111111f, 0.555556f, 0.4f, 1.0f},
   {0.126984f, 0.563492f, 0.4f, 1.0f},
   {0.142857f, 0.571429f, 0.4f, 1.0f},
   {0.15873f, 0.579365f, 0.4f, 1.0f},
   {0.174603f, 0.587302f, 0.4f, 1.0f},
   {0.190476f, 0.595238f, 0.4f, 1.0f},
   {0.206349f, 0.603175f, 0.4f, 1.0f},
   {0.222222f, 0.611111f, 0.4f, 1.0f},
   {0.238095f, 0.619048f, 0.4f, 1.0f},
   {0.253968f, 0.626984f, 0.4f, 1.0f},
   {0.269841f, 0.634921f, 0.4f, 1.0f},
   {0.285714f, 0.642857f, 0.4f, 1.0f},
   {0.301587f, 0.650794f, 0.4f, 1.0f},
   {0.31746f, 0.65873f, 0.4f, 1.0f},
   {0.333333f, 0.666667f, 0.4f, 1.0f},
   {0.349206f, 0.674603f, 0.4f, 1.0f},
   {0.365079f, 0.68254f, 0.4f, 1.0f},
   {0.380952f, 0.690476f, 0.4f, 1.0f},
   {0.396825f, 0.698413f, 0.4f, 1.0f},
   {0.412698f, 0.706349f, 0.4f, 1.0f},
   {0.428571f, 0.714286f, 0.4f, 1.0f},
   {0.444444f, 0.722222f, 0.4f, 1.0f},
   {0.460317f, 0.730159f, 0.4f, 1.0f},
   {0.47619f, 0.738095f, 0.4f, 1.0f},
   {0.492063f, 0.746032f, 0.4f, 1.0f},
   {0.507937f, 0.753968f, 0.4f, 1.0f},
   {0.52381f, 0.761905f, 0.4f, 1.0f},
   {0.539683f, 0.769841f, 0.4f, 1.0f},
   {0.555556f, 0.777778f, 0.4f, 1.0f},
   {0.571429f, 0.785714f, 0.4f, 1.0f},
   {0.587302f, 0.793651f, 0.4f, 1.0f},
   {0.603175f, 0.801587f, 0.4f, 1.0f},
   {0.619048f, 0.809524f, 0.4f, 1.0f},
   {0.634921f, 0.81746f, 0.4f, 1.0f},
   {0.650794f, 0.825397f, 0.4f, 1.0f},
   {0.666667f, 0.833333f, 0.4f, 1.0f},
   {0.68254f, 0.84127f, 0.4f, 1.0f},
   {0.698413f, 0.849206f, 0.4f, 1.0f},
   {0.714286f, 0.857143f, 0.4f, 1.0f},
   {0.730159f, 0.865079f, 0.4f, 1.0f},
   {0.746032f, 0.873016f, 0.4f, 1.0f},
   {0.761905f, 0.880952f, 0.4f, 1.0f},
   {0.777778f, 0.888889f, 0.4f, 1.0f},
   {0.793651f, 0.896825f, 0.4f, 1.0f},
   {0.809524f, 0.904762f, 0.4f, 1.0f},
   {0.825397f, 0.912698f, 0.4f, 1.0f},
   {0.84127f, 0.920635f, 0.4f, 1.0f},
   {0.857143f, 0.928571f, 0.4f, 1.0f},
   {0.873016f, 0.936508f, 0.4f, 1.0f},
   {0.888889f, 0.944444f, 0.4f, 1.0f},
   {0.904762f, 0.952381f, 0.4f, 1.0f},
   {0.920635f, 0.960317f, 0.4f, 1.0f},
   {0.936508f, 0.968254f, 0.4f, 1.0f},
   {0.952381f, 0.97619f, 0.4f, 1.0f},
   {0.968254f, 0.984127f, 0.4f, 1.0f},
   {0.984127f, 0.992063f, 0.4f, 1.0f},
   {1.0f, 1.0f, 0.4f, 1.0f},
});

const Palette BPAL_10 = Palette("hsv",
{
   {1.0f, 0.0f, 0.0f, 1.0f},
   {1.0f, 0.09375f, 0.0f, 1.0f},
   {1.0f, 0.1875f, 0.0f, 1.0f},
   {1.0f, 0.28125f, 0.0f, 1.0f},
   {1.0f, 0.375f, 0.0f, 1.0f},
   {1.0f, 0.46875f, 0.0f, 1.0f},
   {1.0f, 0.5625f, 0.0f, 1.0f},
   {1.0f, 0.65625f, 0.0f, 1.0f},
   {1.0f, 0.75f, 0.0f, 1.0f},
   {1.0f, 0.84375f, 0.0f, 1.0f},
   {1.0f, 0.9375f, 0.0f, 1.0f},
   {0.96875f, 1.0f, 0.0f, 1.0f},
   {0.875f, 1.0f, 0.0f, 1.0f},
   {0.78125f, 1.0f, 0.0f, 1.0f},
   {0.6875f, 1.0f, 0.0f, 1.0f},
   {0.59375f, 1.0f, 0.0f, 1.0f},
   {0.5f, 1.0f, 0.0f, 1.0f},
   {0.40625f, 1.0f, 0.0f, 1.0f},
   {0.3125f, 1.0f, 0.0f, 1.0f},
   {0.21875f, 1.0f, 0.0f, 1.0f},
   {0.125f, 1.0f, 0.0f, 1.0f},
   {0.03125f, 1.0f, 0.0f, 1.0f},
   {0.0f, 1.0f, 0.0625f, 1.0f},
   {0.0f, 1.0f, 0.15625f, 1.0f},
   {0.0f, 1.0f, 0.25f, 1.0f},
   {0.0f, 1.0f, 0.34375f, 1.0f},
   {0.0f, 1.0f, 0.4375f, 1.0f},
   {0.0f, 1.0f, 0.53125f, 1.0f},
   {0.0f, 1.0f, 0.625f, 1.0f},
   {0.0f, 1.0f, 0.71875f, 1.0f},
   {0.0f, 1.0f, 0.8125f, 1.0f},
   {0.0f, 1.0f, 0.90625f, 1.0f},
   {0.0f, 1.0f, 1.0f, 1.0f},
   {0.0f, 0.90625f, 1.0f, 1.0f},
   {0.0f, 0.8125f, 1.0f, 1.0f},
   {0.0f, 0.71875f, 1.0f, 1.0f},
   {0.0f, 0.625f, 1.0f, 1.0f},
   {0.0f, 0.53125f, 1.0f, 1.0f},
   {0.0f, 0.4375f, 1.0f, 1.0f},
   {0.0f, 0.34375f, 1.0f, 1.0f},
   {0.0f, 0.25f, 1.0f, 1.0f},
   {0.0f, 0.15625f, 1.0f, 1.0f},
   {0.0f, 0.0625f, 1.0f, 1.0f},
   {0.03125f, 0.0f, 1.0f, 1.0f},
   {0.125f, 0.0f, 1.0f, 1.0f},
   {0.21875f, 0.0f, 1.0f, 1.0f},
   {0.3125f, 0.0f, 1.0f, 1.0f},
   {0.40625f, 0.0f, 1.0f, 1.0f},
   {0.5f, 0.0f, 1.0f, 1.0f},
   {0.59375f, 0.0f, 1.0f, 1.0f},
   {0.6875f, 0.0f, 1.0f, 1.0f},
   {0.78125f, 0.0f, 1.0f, 1.0f},
   {0.875f, 0.0f, 1.0f, 1.0f},
   {0.96875f, 0.0f, 1.0f, 1.0f},
   {1.0f, 0.0f, 0.9375f, 1.0f},
   {1.0f, 0.0f, 0.84375f, 1.0f},
   {1.0f, 0.0f, 0.75f, 1.0f},
   {1.0f, 0.0f, 0.65625f, 1.0f},
   {1.0f, 0.0f, 0.5625f, 1.0f},
   {1.0f, 0.0f, 0.46875f, 1.0f},
   {1.0f, 0.0f, 0.375f, 1.0f},
   {1.0f, 0.0f, 0.28125f, 1.0f},
   {1.0f, 0.0f, 0.1875f, 1.0f},
   {1.0f, 0.0f, 0.09375f, 1.0f},
});

const Palette BPAL_11 = Palette("copper",
{
   {0.0f, 0.0f, 0.0f, 1.0f},
   {0.0198413f, 0.0124f, 0.00789683f, 1.0f},
   {0.0396825f, 0.0248f, 0.0157937f, 1.0f},
   {0.0595238f, 0.0372f, 0.0236905f, 1.0f},
   {0.0793651f, 0.0496f, 0.0315873f, 1.0f},
   {0.0992063f, 0.062f, 0.0394841f, 1.0f},
   {0.119048f, 0.0744f, 0.047381f, 1.0f},
   {0.138889f, 0.0868f, 0.0552778f, 1.0f},
   {0.15873f, 0.0992f, 0.0631746f, 1.0f},
   {0.178571f, 0.1116f, 0.0710714f, 1.0f},
   {0.198413f, 0.124f, 0.0789683f, 1.0f},
   {0.218254f, 0.1364f, 0.0868651f, 1.0f},
   {0.238095f, 0.1488f, 0.0947619f, 1.0f},
   {0.257937f, 0.1612f, 0.102659f, 1.0f},
   {0.277778f, 0.1736f, 0.110556f, 1.0f},
   {0.297619f, 0.186f, 0.118452f, 1.0f},
   {0.31746f, 0.1984f, 0.126349f, 1.0f},
   {0.337302f, 0.2108f, 0.134246f, 1.0f},
   {0.357143f, 0.2232f, 0.142143f, 1.0f},
   {0.376984f, 0.2356f, 0.15004f, 1.0f},
   {0.396825f, 0.248f, 0.157937f, 1.0f},
   {0.416667f, 0.2604f, 0.165833f, 1.0f},
   {0.436508f, 0.2728f, 0.17373f, 1.0f},
   {0.456349f, 0.2852f, 0.181627f, 1.0f},
   {0.47619f, 0.2976f, 0.189524f, 1.0f},
   {0.496032f, 0.31f, 0.197421f, 1.0f},
   {0.515873f, 0.3224f, 0.205317f, 1.0f},
   {0.535714f, 0.3348f, 0.213214f, 1.0f},
   {0.555556f, 0.3472f, 0.221111f, 1.0f},
   {0.575397f, 0.3596f, 0.229008f, 1.0f},
   {0.595238f, 0.372f, 0.236905f, 1.0f},
   {0.615079f, 0.3844f, 0.244802f, 1.0f},
   {0.634921f, 0.3968f, 0.252698f, 1.0f},
   {0.654762f, 0.4092f, 0.260595f, 1.0f},
   {0.674603f, 0.4216f, 0.268492f, 1.0f},
   {0.694444f, 0.434f, 0.276389f, 1.0f},
   {0.714286f, 0.4464f, 0.284286f, 1.0f},
   {0.734127f, 0.4588f, 0.292183f, 1.0f},
   {0.753968f, 0.4712f, 0.300079f, 1.0f},
   {0.77381f, 0.4836f, 0.307976f, 1.0f},
   {0.793651f, 0.496f, 0.315873f, 1.0f},
   {0.813492f, 0.5084f, 0.32377f, 1.0f},
   {0.833333f, 0.5208f, 0.331667f, 1.0f},
   {0.853175f, 0.5332f, 0.339563f, 1.0f},
   {0.873016f, 0.5456f, 0.34746f, 1.0f},
   {0.892857f, 0.558f, 0.355357f, 1.0f},
   {0.912698f, 0.5704f, 0.363254f, 1.0f},
   {0.93254f, 0.5828f, 0.371151f, 1.0f},
   {0.952381f, 0.5952f, 0.379048f, 1.0f},
   {0.972222f, 0.6076f, 0.386944f, 1.0f},
   {0.992063f, 0.62f, 0.394841f, 1.0f},
   {1.0f, 0.6324f, 0.402738f, 1.0f},
   {1.0f, 0.6448f, 0.410635f, 1.0f},
   {1.0f, 0.6572f, 0.418532f, 1.0f},
   {1.0f, 0.6696f, 0.426429f, 1.0f},
   {1.0f, 0.682f, 0.434325f, 1.0f},
   {1.0f, 0.6944f, 0.442222f, 1.0f},
   {1.0f, 0.7068f, 0.450119f, 1.0f},
   {1.0f, 0.7192f, 0.458016f, 1.0f},
   {1.0f, 0.7316f, 0.465913f, 1.0f},
   {1.0f, 0.744f, 0.47381f, 1.0f},
   {1.0f, 0.7564f, 0.481706f, 1.0f},
   {1.0f, 0.7688f, 0.489603f, 1.0f},
   {1.0f, 0.7812f, 0.4975f, 1.0f},
});

const Palette BPAL_12 = Palette("white",
{
   {1.0f, 1.0f, 1.0f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
});

const Palette BPAL_13 = Palette("vivid",
{
   {0.0f, 0.0f, 1.0f, 1.0f},
   {0.0f, 0.115756f, 1.0f, 1.0f},
   {0.0f, 0.223602f, 1.0f, 1.0f},
   {0.0f, 0.324324f, 1.0f, 1.0f},
   {0.0f, 0.418605f, 1.0f, 1.0f},
   {0.0f, 0.507042f, 1.0f, 1.0f},
   {0.0f, 0.590164f, 1.0f, 1.0f},
   {0.0f, 0.668435f, 1.0f, 1.0f},
   {0.0f, 0.742268f, 1.0f, 1.0f},
   {0.0f, 0.81203f, 1.0f, 1.0f},
   {0.0f, 0.878049f, 1.0f, 1.0f},
   {0.0f, 0.940618f, 1.0f, 1.0f},
   {0.0f, 1.0f, 1.0f, 1.0f},
   {0.0f, 0.975f, 0.75f, 1.0f},
   {0.0f, 0.95f, 0.5f, 1.0f},
   {0.0f, 0.925f, 0.25f, 1.0f},
   {0.0f, 0.9f, 0.0f, 1.0f},
   {0.101258f, 0.90625f, 0.0f, 1.0f},
   {0.194476f, 0.9125f, 0.0f, 1.0f},
   {0.280576f, 0.91875f, 0.0f, 1.0f},
   {0.360341f, 0.925f, 0.0f, 1.0f},
   {0.434447f, 0.93125f, 0.0f, 1.0f},
   {0.503476f, 0.9375f, 0.0f, 1.0f},
   {0.567931f, 0.94375f, 0.0f, 1.0f},
   {0.628253f, 0.95f, 0.0f, 1.0f},
   {0.684827f, 0.95625f, 0.0f, 1.0f},
   {0.737991f, 0.9625f, 0.0f, 1.0f},
   {0.788046f, 0.96875f, 0.0f, 1.0f},
   {0.835255f, 0.975f, 0.0f, 1.0f},
   {0.879856f, 0.98125f, 0.0f, 1.0f},
   {0.922058f, 0.9875f, 0.0f, 1.0f},
   {0.962049f, 0.99375f, 0.0f, 1.0f},
   {1.0f, 1.0f, 0.0f, 1.0f},
   {0.99375f, 0.967105f, 0.0f, 1.0f},
   {0.9875f, 0.932065f, 0.0f, 1.0f},
   {0.98125f, 0.894663f, 0.0f, 1.0f},
   {0.975f, 0.854651f, 0.0f, 1.0f},
   {0.96875f, 0.811747f, 0.0f, 1.0f},
   {0.9625f, 0.765625f, 0.0f, 1.0f},
   {0.95625f, 0.715909f, 0.0f, 1.0f},
   {0.95f, 0.662162f, 0.0f, 1.0f},
   {0.94375f, 0.603873f, 0.0f, 1.0f},
   {0.9375f, 0.540441f, 0.0f, 1.0f},
   {0.93125f, 0.471154f, 0.0f, 1.0f},
   {0.925f, 0.395161f, 0.0f, 1.0f},
   {0.91875f, 0.311441f, 0.0f, 1.0f},
   {0.9125f, 0.21875f, 0.0f, 1.0f},
   {0.90625f, 0.115566f, 0.0f, 1.0f},
   {0.9f, 0.0f, 0.0f, 1.0f},
   {0.925f, 0.0f, 0.460432f, 1.0f},
   {0.95f, 0.0f, 0.719101f, 1.0f},
   {0.975f, 0.0f, 0.884793f, 1.0f},
   {1.0f, 0.0f, 1.0f, 1.0f},
   {0.965326f, 0.0f, 1.0f, 1.0f},
   {0.929577f, 0.0f, 1.0f, 1.0f},
   {0.892704f, 0.0f, 1.0f, 1.0f},
   {0.854651f, 0.0f, 1.0f, 1.0f},
   {0.815362f, 0.0f, 1.0f, 1.0f},
   {0.774775f, 0.0f, 1.0f, 1.0f},
   {0.732824f, 0.0f, 1.0f, 1.0f},
   {0.689441f, 0.0f, 1.0f, 1.0f},
   {0.64455f, 0.0f, 1.0f, 1.0f},
   {0.598071f, 0.0f, 1.0f, 1.0f},
   {0.549918f, 0.0f, 1.0f, 1.0f},
   {0.5f, 0.0f, 1.0f, 1.0f},
});

const Palette BPAL_14 = Palette("aluminum",
{
   {0.429688f, 0.445312f, 0.410156f, 1.0f},
   {0.4375f, 0.445312f, 0.414062f, 1.0f},
   {0.441406f, 0.449219f, 0.417969f, 1.0f},
   {0.445312f, 0.453125f, 0.421875f, 1.0f},
   {0.449219f, 0.457031f, 0.425781f, 1.0f},
   {0.453125f, 0.460938f, 0.429688f, 1.0f},
   {0.457031f, 0.464844f, 0.433594f, 1.0f},
   {0.460938f, 0.46875f, 0.4375f, 1.0f},
   {0.464844f, 0.472656f, 0.441406f, 1.0f},
   {0.476562f, 0.484375f, 0.453125f, 1.0f},
   {0.488281f, 0.496094f, 0.464844f, 1.0f},
   {0.496094f, 0.503906f, 0.472656f, 1.0f},
   {0.496094f, 0.507812f, 0.476562f, 1.0f},
   {0.5f, 0.511719f, 0.480469f, 1.0f},
   {0.503906f, 0.511719f, 0.484375f, 1.0f},
   {0.503906f, 0.515625f, 0.484375f, 1.0f},
   {0.507812f, 0.515625f, 0.488281f, 1.0f},
   {0.511719f, 0.519531f, 0.492188f, 1.0f},
   {0.519531f, 0.53125f, 0.5f, 1.0f},
   {0.546875f, 0.554688f, 0.527344f, 1.0f},
   {0.546875f, 0.558594f, 0.53125f, 1.0f},
   {0.550781f, 0.558594f, 0.53125f, 1.0f},
   {0.550781f, 0.558594f, 0.53125f, 1.0f},
   {0.550781f, 0.558594f, 0.535156f, 1.0f},
   {0.550781f, 0.5625f, 0.535156f, 1.0f},
   {0.554688f, 0.5625f, 0.535156f, 1.0f},
   {0.554688f, 0.5625f, 0.535156f, 1.0f},
   {0.554688f, 0.5625f, 0.535156f, 1.0f},
   {0.554688f, 0.5625f, 0.535156f, 1.0f},
   {0.554688f, 0.5625f, 0.539062f, 1.0f},
   {0.554688f, 0.5625f, 0.539062f, 1.0f},
   {0.554688f, 0.566406f, 0.539062f, 1.0f},
   {0.558594f, 0.570312f, 0.542969f, 1.0f},
   {0.582031f, 0.589844f, 0.566406f, 1.0f},
   {0.59375f, 0.601562f, 0.574219f, 1.0f},
   {0.597656f, 0.605469f, 0.582031f, 1.0f},
   {0.601562f, 0.609375f, 0.585938f, 1.0f},
   {0.605469f, 0.613281f, 0.589844f, 1.0f},
   {0.613281f, 0.621094f, 0.597656f, 1.0f},
   {0.617188f, 0.625f, 0.601562f, 1.0f},
   {0.621094f, 0.628906f, 0.605469f, 1.0f},
   {0.625f, 0.632812f, 0.609375f, 1.0f},
   {0.628906f, 0.636719f, 0.613281f, 1.0f},
   {0.632812f, 0.640625f, 0.617188f, 1.0f},
   {0.636719f, 0.644531f, 0.621094f, 1.0f},
   {0.640625f, 0.648438f, 0.628906f, 1.0f},
   {0.644531f, 0.652344f, 0.632812f, 1.0f},
   {0.648438f, 0.65625f, 0.636719f, 1.0f},
   {0.652344f, 0.660156f, 0.640625f, 1.0f},
   {0.660156f, 0.667969f, 0.648438f, 1.0f},
   {0.667969f, 0.675781f, 0.65625f, 1.0f},
   {0.675781f, 0.683594f, 0.664062f, 1.0f},
   {0.683594f, 0.6875f, 0.671875f, 1.0f},
   {0.683594f, 0.691406f, 0.671875f, 1.0f},
   {0.683594f, 0.691406f, 0.671875f, 1.0f},
   {0.6875f, 0.691406f, 0.675781f, 1.0f},
   {0.6875f, 0.695312f, 0.675781f, 1.0f},
   {0.691406f, 0.695312f, 0.679688f, 1.0f},
   {0.691406f, 0.699219f, 0.679688f, 1.0f},
   {0.695312f, 0.699219f, 0.683594f, 1.0f},
   {0.695312f, 0.699219f, 0.683594f, 1.0f},
   {0.695312f, 0.703125f, 0.6875f, 1.0f},
   {0.699219f, 0.703125f, 0.6875f, 1.0f},
   {0.699219f, 0.707031f, 0.6875f, 1.0f},
   {0.703125f, 0.707031f, 0.691406f, 1.0f},
   {0.703125f, 0.707031f, 0.691406f, 1.0f},
   {0.703125f, 0.710938f, 0.695312f, 1.0f},
   {0.707031f, 0.710938f, 0.695312f, 1.0f},
   {0.707031f, 0.714844f, 0.699219f, 1.0f},
   {0.710938f, 0.714844f, 0.699219f, 1.0f},
   {0.710938f, 0.714844f, 0.699219f, 1.0f},
   {0.710938f, 0.71875f, 0.703125f, 1.0f},
   {0.730469f, 0.734375f, 0.71875f, 1.0f},
   {0.746094f, 0.75f, 0.734375f, 1.0f},
   {0.746094f, 0.75f, 0.734375f, 1.0f},
   {0.746094f, 0.75f, 0.734375f, 1.0f},
   {0.746094f, 0.75f, 0.738281f, 1.0f},
   {0.746094f, 0.75f, 0.738281f, 1.0f},
   {0.746094f, 0.75f, 0.738281f, 1.0f},
   {0.75f, 0.753906f, 0.738281f, 1.0f},
   {0.75f, 0.753906f, 0.742188f, 1.0f},
   {0.75f, 0.753906f, 0.742188f, 1.0f},
   {0.753906f, 0.757812f, 0.746094f, 1.0f},
   {0.761719f, 0.765625f, 0.753906f, 1.0f},
   {0.773438f, 0.777344f, 0.765625f, 1.0f},
   {0.792969f, 0.796875f, 0.789062f, 1.0f},
   {0.800781f, 0.800781f, 0.796875f, 1.0f},
   {0.804688f, 0.804688f, 0.800781f, 1.0f},
   {0.808594f, 0.8125f, 0.808594f, 1.0f},
   {0.816406f, 0.816406f, 0.8125f, 1.0f},
   {0.820312f, 0.824219f, 0.816406f, 1.0f},
   {0.828125f, 0.828125f, 0.824219f, 1.0f},
   {0.832031f, 0.832031f, 0.828125f, 1.0f},
   {0.835938f, 0.839844f, 0.832031f, 1.0f},
   {0.835938f, 0.835938f, 0.828125f, 1.0f},
   {0.832031f, 0.835938f, 0.824219f, 1.0f},
   {0.828125f, 0.832031f, 0.816406f, 1.0f},
   {0.828125f, 0.828125f, 0.8125f, 1.0f},
   {0.824219f, 0.824219f, 0.808594f, 1.0f},
   {0.820312f, 0.820312f, 0.800781f, 1.0f},
   {0.816406f, 0.816406f, 0.796875f, 1.0f},
   {0.808594f, 0.808594f, 0.777344f, 1.0f},
   {0.800781f, 0.796875f, 0.761719f, 1.0f},
   {0.824219f, 0.820312f, 0.792969f, 1.0f},
   {0.835938f, 0.832031f, 0.804688f, 1.0f},
   {0.84375f, 0.84375f, 0.816406f, 1.0f},
   {0.851562f, 0.851562f, 0.828125f, 1.0f},
   {0.859375f, 0.855469f, 0.835938f, 1.0f},
   {0.863281f, 0.863281f, 0.84375f, 1.0f},
   {0.871094f, 0.867188f, 0.851562f, 1.0f},
   {0.875f, 0.871094f, 0.855469f, 1.0f},
   {0.878906f, 0.875f, 0.863281f, 1.0f},
   {0.882812f, 0.882812f, 0.867188f, 1.0f},
   {0.886719f, 0.882812f, 0.871094f, 1.0f},
   {0.890625f, 0.886719f, 0.875f, 1.0f},
   {0.894531f, 0.890625f, 0.878906f, 1.0f},
   {0.894531f, 0.894531f, 0.882812f, 1.0f},
   {0.898438f, 0.898438f, 0.886719f, 1.0f},
   {0.902344f, 0.898438f, 0.890625f, 1.0f},
   {0.902344f, 0.902344f, 0.894531f, 1.0f},
   {0.90625f, 0.90625f, 0.898438f, 1.0f},
   {0.90625f, 0.90625f, 0.902344f, 1.0f},
   {0.910156f, 0.910156f, 0.902344f, 1.0f},
   {0.910156f, 0.910156f, 0.90625f, 1.0f},
   {0.914062f, 0.914062f, 0.910156f, 1.0f},
   {0.917969f, 0.917969f, 0.914062f, 1.0f},
   {0.921875f, 0.921875f, 0.917969f, 1.0f},
   {0.925781f, 0.925781f, 0.921875f, 1.0f},
   {0.929688f, 0.925781f, 0.925781f, 1.0f},
   {0.929688f, 0.929688f, 0.929688f, 1.0f},
   {0.929688f, 0.929688f, 0.929688f, 1.0f},
   {0.933594f, 0.929688f, 0.929688f, 1.0f},
   {0.933594f, 0.933594f, 0.933594f, 1.0f},
   {0.929688f, 0.929688f, 0.929688f, 1.0f},
   {0.925781f, 0.925781f, 0.925781f, 1.0f},
   {0.914062f, 0.914062f, 0.914062f, 1.0f},
   {0.90625f, 0.90625f, 0.90625f, 1.0f},
   {0.894531f, 0.894531f, 0.894531f, 1.0f},
   {0.878906f, 0.878906f, 0.878906f, 1.0f},
   {0.859375f, 0.859375f, 0.859375f, 1.0f},
   {0.832031f, 0.832031f, 0.832031f, 1.0f},
   {0.679688f, 0.679688f, 0.683594f, 1.0f},
   {0.730469f, 0.730469f, 0.738281f, 1.0f},
   {0.753906f, 0.753906f, 0.765625f, 1.0f},
   {0.769531f, 0.769531f, 0.785156f, 1.0f},
   {0.777344f, 0.777344f, 0.792969f, 1.0f},
   {0.785156f, 0.785156f, 0.796875f, 1.0f},
   {0.796875f, 0.792969f, 0.800781f, 1.0f},
   {0.804688f, 0.796875f, 0.800781f, 1.0f},
   {0.8125f, 0.804688f, 0.804688f, 1.0f},
   {0.816406f, 0.804688f, 0.804688f, 1.0f},
   {0.808594f, 0.800781f, 0.800781f, 1.0f},
   {0.804688f, 0.792969f, 0.792969f, 1.0f},
   {0.796875f, 0.789062f, 0.789062f, 1.0f},
   {0.792969f, 0.785156f, 0.785156f, 1.0f},
   {0.785156f, 0.777344f, 0.78125f, 1.0f},
   {0.78125f, 0.773438f, 0.773438f, 1.0f},
   {0.773438f, 0.769531f, 0.769531f, 1.0f},
   {0.761719f, 0.757812f, 0.761719f, 1.0f},
   {0.738281f, 0.738281f, 0.738281f, 1.0f},
   {0.722656f, 0.726562f, 0.726562f, 1.0f},
   {0.722656f, 0.730469f, 0.726562f, 1.0f},
   {0.726562f, 0.734375f, 0.722656f, 1.0f},
   {0.726562f, 0.738281f, 0.722656f, 1.0f},
   {0.726562f, 0.742188f, 0.722656f, 1.0f},
   {0.730469f, 0.742188f, 0.71875f, 1.0f},
   {0.730469f, 0.746094f, 0.71875f, 1.0f},
   {0.730469f, 0.75f, 0.71875f, 1.0f},
   {0.730469f, 0.753906f, 0.71875f, 1.0f},
   {0.730469f, 0.753906f, 0.71875f, 1.0f},
   {0.71875f, 0.738281f, 0.703125f, 1.0f},
   {0.699219f, 0.714844f, 0.683594f, 1.0f},
   {0.679688f, 0.695312f, 0.667969f, 1.0f},
   {0.652344f, 0.664062f, 0.640625f, 1.0f},
   {0.621094f, 0.628906f, 0.613281f, 1.0f},
   {0.617188f, 0.625f, 0.609375f, 1.0f},
   {0.617188f, 0.621094f, 0.609375f, 1.0f},
   {0.613281f, 0.621094f, 0.605469f, 1.0f},
   {0.609375f, 0.617188f, 0.601562f, 1.0f},
   {0.605469f, 0.613281f, 0.597656f, 1.0f},
   {0.601562f, 0.605469f, 0.59375f, 1.0f},
   {0.59375f, 0.597656f, 0.589844f, 1.0f},
   {0.582031f, 0.589844f, 0.578125f, 1.0f},
   {0.570312f, 0.574219f, 0.566406f, 1.0f},
   {0.546875f, 0.546875f, 0.542969f, 1.0f},
   {0.523438f, 0.523438f, 0.523438f, 1.0f},
   {0.523438f, 0.523438f, 0.523438f, 1.0f},
   {0.523438f, 0.523438f, 0.523438f, 1.0f},
   {0.523438f, 0.523438f, 0.523438f, 1.0f},
   {0.523438f, 0.523438f, 0.519531f, 1.0f},
   {0.523438f, 0.519531f, 0.519531f, 1.0f},
   {0.519531f, 0.519531f, 0.515625f, 1.0f},
   {0.515625f, 0.511719f, 0.503906f, 1.0f},
   {0.507812f, 0.503906f, 0.492188f, 1.0f},
   {0.464844f, 0.457031f, 0.449219f, 1.0f},
   {0.507812f, 0.492188f, 0.492188f, 1.0f},
   {0.542969f, 0.519531f, 0.527344f, 1.0f},
   {0.507812f, 0.511719f, 0.496094f, 1.0f},
   {0.507812f, 0.511719f, 0.496094f, 1.0f},
   {0.507812f, 0.511719f, 0.496094f, 1.0f},
   {0.507812f, 0.511719f, 0.496094f, 1.0f},
   {0.507812f, 0.511719f, 0.496094f, 1.0f},
   {0.507812f, 0.511719f, 0.496094f, 1.0f},
   {0.507812f, 0.507812f, 0.496094f, 1.0f},
   {0.507812f, 0.507812f, 0.496094f, 1.0f},
   {0.503906f, 0.507812f, 0.492188f, 1.0f},
   {0.503906f, 0.503906f, 0.492188f, 1.0f},
   {0.5f, 0.503906f, 0.492188f, 1.0f},
   {0.5f, 0.5f, 0.488281f, 1.0f},
   {0.496094f, 0.496094f, 0.488281f, 1.0f},
   {0.492188f, 0.488281f, 0.484375f, 1.0f},
   {0.484375f, 0.480469f, 0.476562f, 1.0f},
   {0.476562f, 0.46875f, 0.46875f, 1.0f},
   {0.476562f, 0.464844f, 0.46875f, 1.0f},
   {0.472656f, 0.464844f, 0.464844f, 1.0f},
   {0.472656f, 0.464844f, 0.464844f, 1.0f},
   {0.472656f, 0.464844f, 0.464844f, 1.0f},
   {0.472656f, 0.464844f, 0.464844f, 1.0f},
   {0.472656f, 0.460938f, 0.464844f, 1.0f},
   {0.472656f, 0.460938f, 0.464844f, 1.0f},
   {0.472656f, 0.460938f, 0.464844f, 1.0f},
   {0.472656f, 0.460938f, 0.464844f, 1.0f},
   {0.472656f, 0.457031f, 0.464844f, 1.0f},
   {0.46875f, 0.457031f, 0.460938f, 1.0f},
   {0.46875f, 0.457031f, 0.460938f, 1.0f},
   {0.46875f, 0.457031f, 0.460938f, 1.0f},
   {0.46875f, 0.453125f, 0.460938f, 1.0f},
   {0.464844f, 0.453125f, 0.460938f, 1.0f},
   {0.464844f, 0.453125f, 0.457031f, 1.0f},
   {0.464844f, 0.453125f, 0.457031f, 1.0f},
   {0.464844f, 0.453125f, 0.457031f, 1.0f},
   {0.464844f, 0.453125f, 0.457031f, 1.0f},
   {0.464844f, 0.453125f, 0.457031f, 1.0f},
   {0.464844f, 0.453125f, 0.460938f, 1.0f},
   {0.464844f, 0.453125f, 0.460938f, 1.0f},
   {0.464844f, 0.453125f, 0.460938f, 1.0f},
   {0.464844f, 0.453125f, 0.460938f, 1.0f},
   {0.464844f, 0.453125f, 0.460938f, 1.0f},
   {0.464844f, 0.453125f, 0.460938f, 1.0f},
   {0.46875f, 0.453125f, 0.460938f, 1.0f},
   {0.472656f, 0.457031f, 0.464844f, 1.0f},
   {0.46875f, 0.453125f, 0.460938f, 1.0f},
   {0.476562f, 0.457031f, 0.46875f, 1.0f},
   {0.484375f, 0.464844f, 0.476562f, 1.0f},
   {0.488281f, 0.472656f, 0.484375f, 1.0f},
   {0.496094f, 0.480469f, 0.492188f, 1.0f},
   {0.503906f, 0.488281f, 0.5f, 1.0f},
   {0.511719f, 0.492188f, 0.503906f, 1.0f},
   {0.515625f, 0.496094f, 0.511719f, 1.0f},
   {0.519531f, 0.503906f, 0.515625f, 1.0f},
   {0.527344f, 0.507812f, 0.523438f, 1.0f},
   {0.53125f, 0.511719f, 0.527344f, 1.0f},
   {0.535156f, 0.519531f, 0.53125f, 1.0f},
   {0.542969f, 0.523438f, 0.539062f, 1.0f},
   {0.546875f, 0.527344f, 0.542969f, 1.0f},
   {0.554688f, 0.535156f, 0.546875f, 1.0f},
});

const Palette BPAL_15 = Palette("sunrise",
{
   {0.859375f, 0.859375f, 0.859375f, 1.0f},
   {0.859375f, 0.859375f, 0.855469f, 1.0f},
   {0.863281f, 0.863281f, 0.855469f, 1.0f},
   {0.863281f, 0.863281f, 0.855469f, 1.0f},
   {0.863281f, 0.867188f, 0.855469f, 1.0f},
   {0.867188f, 0.867188f, 0.851562f, 1.0f},
   {0.867188f, 0.871094f, 0.851562f, 1.0f},
   {0.871094f, 0.871094f, 0.851562f, 1.0f},
   {0.871094f, 0.875f, 0.851562f, 1.0f},
   {0.871094f, 0.875f, 0.847656f, 1.0f},
   {0.875f, 0.878906f, 0.847656f, 1.0f},
   {0.875f, 0.878906f, 0.847656f, 1.0f},
   {0.878906f, 0.882812f, 0.847656f, 1.0f},
   {0.878906f, 0.882812f, 0.84375f, 1.0f},
   {0.882812f, 0.886719f, 0.84375f, 1.0f},
   {0.882812f, 0.890625f, 0.84375f, 1.0f},
   {0.882812f, 0.890625f, 0.84375f, 1.0f},
   {0.886719f, 0.894531f, 0.839844f, 1.0f},
   {0.886719f, 0.894531f, 0.839844f, 1.0f},
   {0.890625f, 0.898438f, 0.839844f, 1.0f},
   {0.890625f, 0.898438f, 0.839844f, 1.0f},
   {0.890625f, 0.902344f, 0.835938f, 1.0f},
   {0.894531f, 0.902344f, 0.835938f, 1.0f},
   {0.894531f, 0.90625f, 0.835938f, 1.0f},
   {0.898438f, 0.90625f, 0.835938f, 1.0f},
   {0.898438f, 0.910156f, 0.832031f, 1.0f},
   {0.902344f, 0.910156f, 0.832031f, 1.0f},
   {0.902344f, 0.914062f, 0.832031f, 1.0f},
   {0.90625f, 0.917969f, 0.828125f, 1.0f},
   {0.910156f, 0.921875f, 0.828125f, 1.0f},
   {0.914062f, 0.925781f, 0.824219f, 1.0f},
   {0.917969f, 0.929688f, 0.824219f, 1.0f},
   {0.917969f, 0.9375f, 0.820312f, 1.0f},
   {0.921875f, 0.941406f, 0.820312f, 1.0f},
   {0.925781f, 0.945312f, 0.816406f, 1.0f},
   {0.929688f, 0.949219f, 0.816406f, 1.0f},
   {0.933594f, 0.953125f, 0.8125f, 1.0f},
   {0.9375f, 0.957031f, 0.8125f, 1.0f},
   {0.9375f, 0.960938f, 0.808594f, 1.0f},
   {0.941406f, 0.964844f, 0.808594f, 1.0f},
   {0.945312f, 0.953125f, 0.789062f, 1.0f},
   {0.945312f, 0.9375f, 0.773438f, 1.0f},
   {0.945312f, 0.925781f, 0.757812f, 1.0f},
   {0.949219f, 0.914062f, 0.742188f, 1.0f},
   {0.949219f, 0.898438f, 0.722656f, 1.0f},
   {0.953125f, 0.886719f, 0.707031f, 1.0f},
   {0.953125f, 0.875f, 0.691406f, 1.0f},
   {0.957031f, 0.863281f, 0.671875f, 1.0f},
   {0.957031f, 0.847656f, 0.65625f, 1.0f},
   {0.957031f, 0.835938f, 0.640625f, 1.0f},
   {0.960938f, 0.824219f, 0.625f, 1.0f},
   {0.960938f, 0.808594f, 0.605469f, 1.0f},
   {0.964844f, 0.796875f, 0.589844f, 1.0f},
   {0.964844f, 0.785156f, 0.574219f, 1.0f},
   {0.964844f, 0.769531f, 0.558594f, 1.0f},
   {0.96875f, 0.757812f, 0.539062f, 1.0f},
   {0.96875f, 0.742188f, 0.519531f, 1.0f},
   {0.972656f, 0.722656f, 0.496094f, 1.0f},
   {0.972656f, 0.707031f, 0.472656f, 1.0f},
   {0.976562f, 0.6875f, 0.449219f, 1.0f},
   {0.980469f, 0.671875f, 0.425781f, 1.0f},
   {0.980469f, 0.652344f, 0.40625f, 1.0f},
   {0.984375f, 0.636719f, 0.382812f, 1.0f},
   {0.984375f, 0.621094f, 0.359375f, 1.0f},
   {0.988281f, 0.601562f, 0.335938f, 1.0f},
   {0.988281f, 0.585938f, 0.3125f, 1.0f},
   {0.992188f, 0.566406f, 0.289062f, 1.0f},
   {0.992188f, 0.550781f, 0.269531f, 1.0f},
   {0.988281f, 0.539062f, 0.265625f, 1.0f},
   {0.980469f, 0.53125f, 0.261719f, 1.0f},
   {0.972656f, 0.523438f, 0.261719f, 1.0f},
   {0.964844f, 0.515625f, 0.257812f, 1.0f},
   {0.957031f, 0.507812f, 0.257812f, 1.0f},
   {0.949219f, 0.496094f, 0.253906f, 1.0f},
   {0.941406f, 0.488281f, 0.253906f, 1.0f},
   {0.933594f, 0.480469f, 0.253906f, 1.0f},
   {0.925781f, 0.472656f, 0.25f, 1.0f},
   {0.914062f, 0.464844f, 0.25f, 1.0f},
   {0.90625f, 0.453125f, 0.246094f, 1.0f},
   {0.898438f, 0.445312f, 0.246094f, 1.0f},
   {0.890625f, 0.4375f, 0.242188f, 1.0f},
   {0.882812f, 0.429688f, 0.242188f, 1.0f},
   {0.875f, 0.421875f, 0.238281f, 1.0f},
   {0.867188f, 0.410156f, 0.238281f, 1.0f},
   {0.859375f, 0.402344f, 0.234375f, 1.0f},
   {0.851562f, 0.394531f, 0.234375f, 1.0f},
   {0.84375f, 0.386719f, 0.230469f, 1.0f},
   {0.835938f, 0.378906f, 0.230469f, 1.0f},
   {0.828125f, 0.367188f, 0.226562f, 1.0f},
   {0.820312f, 0.359375f, 0.226562f, 1.0f},
   {0.8125f, 0.351562f, 0.222656f, 1.0f},
   {0.804688f, 0.34375f, 0.222656f, 1.0f},
   {0.796875f, 0.335938f, 0.21875f, 1.0f},
   {0.789062f, 0.328125f, 0.21875f, 1.0f},
   {0.777344f, 0.3125f, 0.214844f, 1.0f},
   {0.757812f, 0.292969f, 0.210938f, 1.0f},
   {0.742188f, 0.273438f, 0.207031f, 1.0f},
   {0.722656f, 0.25f, 0.203125f, 1.0f},
   {0.703125f, 0.230469f, 0.199219f, 1.0f},
   {0.683594f, 0.210938f, 0.191406f, 1.0f},
   {0.664062f, 0.191406f, 0.1875f, 1.0f},
   {0.648438f, 0.167969f, 0.183594f, 1.0f},
   {0.628906f, 0.148438f, 0.179688f, 1.0f},
   {0.609375f, 0.128906f, 0.175781f, 1.0f},
   {0.589844f, 0.109375f, 0.171875f, 1.0f},
   {0.574219f, 0.09375f, 0.164062f, 1.0f},
   {0.5625f, 0.0976562f, 0.160156f, 1.0f},
   {0.550781f, 0.0976562f, 0.15625f, 1.0f},
   {0.539062f, 0.101562f, 0.152344f, 1.0f},
   {0.527344f, 0.105469f, 0.148438f, 1.0f},
   {0.515625f, 0.105469f, 0.140625f, 1.0f},
   {0.503906f, 0.109375f, 0.136719f, 1.0f},
   {0.492188f, 0.109375f, 0.132812f, 1.0f},
   {0.480469f, 0.113281f, 0.128906f, 1.0f},
   {0.46875f, 0.117188f, 0.125f, 1.0f},
   {0.457031f, 0.117188f, 0.117188f, 1.0f},
   {0.445312f, 0.121094f, 0.113281f, 1.0f},
   {0.433594f, 0.121094f, 0.109375f, 1.0f},
   {0.421875f, 0.125f, 0.105469f, 1.0f},
   {0.410156f, 0.128906f, 0.0976562f, 1.0f},
   {0.398438f, 0.128906f, 0.09375f, 1.0f},
   {0.382812f, 0.132812f, 0.0898438f, 1.0f},
   {0.371094f, 0.136719f, 0.0820312f, 1.0f},
   {0.359375f, 0.136719f, 0.078125f, 1.0f},
   {0.34375f, 0.140625f, 0.0742188f, 1.0f},
   {0.332031f, 0.144531f, 0.0664062f, 1.0f},
   {0.320312f, 0.144531f, 0.0625f, 1.0f},
   {0.304688f, 0.148438f, 0.0546875f, 1.0f},
   {0.292969f, 0.152344f, 0.0507812f, 1.0f},
   {0.285156f, 0.15625f, 0.0507812f, 1.0f},
   {0.285156f, 0.160156f, 0.0664062f, 1.0f},
   {0.285156f, 0.164062f, 0.078125f, 1.0f},
   {0.289062f, 0.167969f, 0.09375f, 1.0f},
   {0.289062f, 0.175781f, 0.105469f, 1.0f},
   {0.289062f, 0.179688f, 0.121094f, 1.0f},
   {0.289062f, 0.183594f, 0.132812f, 1.0f},
   {0.292969f, 0.1875f, 0.148438f, 1.0f},
   {0.292969f, 0.195312f, 0.160156f, 1.0f},
   {0.292969f, 0.199219f, 0.175781f, 1.0f},
   {0.292969f, 0.203125f, 0.1875f, 1.0f},
   {0.292969f, 0.207031f, 0.203125f, 1.0f},
   {0.296875f, 0.214844f, 0.214844f, 1.0f},
   {0.296875f, 0.21875f, 0.230469f, 1.0f},
   {0.296875f, 0.222656f, 0.242188f, 1.0f},
   {0.296875f, 0.226562f, 0.257812f, 1.0f},
   {0.300781f, 0.234375f, 0.269531f, 1.0f},
   {0.300781f, 0.238281f, 0.285156f, 1.0f},
   {0.300781f, 0.242188f, 0.296875f, 1.0f},
   {0.300781f, 0.25f, 0.3125f, 1.0f},
   {0.300781f, 0.253906f, 0.324219f, 1.0f},
   {0.304688f, 0.257812f, 0.339844f, 1.0f},
   {0.304688f, 0.261719f, 0.351562f, 1.0f},
   {0.304688f, 0.269531f, 0.367188f, 1.0f},
   {0.304688f, 0.273438f, 0.378906f, 1.0f},
   {0.308594f, 0.277344f, 0.394531f, 1.0f},
   {0.308594f, 0.28125f, 0.40625f, 1.0f},
   {0.308594f, 0.289062f, 0.421875f, 1.0f},
   {0.308594f, 0.296875f, 0.441406f, 1.0f},
   {0.3125f, 0.304688f, 0.464844f, 1.0f},
   {0.3125f, 0.3125f, 0.484375f, 1.0f},
   {0.3125f, 0.320312f, 0.507812f, 1.0f},
   {0.316406f, 0.328125f, 0.53125f, 1.0f},
   {0.316406f, 0.335938f, 0.550781f, 1.0f},
   {0.320312f, 0.34375f, 0.574219f, 1.0f},
   {0.320312f, 0.351562f, 0.59375f, 1.0f},
   {0.320312f, 0.359375f, 0.617188f, 1.0f},
   {0.324219f, 0.367188f, 0.636719f, 1.0f},
   {0.324219f, 0.375f, 0.660156f, 1.0f},
   {0.324219f, 0.382812f, 0.679688f, 1.0f},
   {0.328125f, 0.390625f, 0.703125f, 1.0f},
   {0.328125f, 0.398438f, 0.722656f, 1.0f},
   {0.328125f, 0.40625f, 0.746094f, 1.0f},
   {0.332031f, 0.414062f, 0.765625f, 1.0f},
   {0.332031f, 0.421875f, 0.789062f, 1.0f},
   {0.335938f, 0.425781f, 0.796875f, 1.0f},
   {0.34375f, 0.433594f, 0.800781f, 1.0f},
   {0.347656f, 0.441406f, 0.800781f, 1.0f},
   {0.355469f, 0.445312f, 0.804688f, 1.0f},
   {0.363281f, 0.453125f, 0.804688f, 1.0f},
   {0.367188f, 0.460938f, 0.808594f, 1.0f},
   {0.375f, 0.464844f, 0.8125f, 1.0f},
   {0.378906f, 0.472656f, 0.8125f, 1.0f},
   {0.386719f, 0.480469f, 0.816406f, 1.0f},
   {0.390625f, 0.488281f, 0.816406f, 1.0f},
   {0.398438f, 0.492188f, 0.820312f, 1.0f},
   {0.402344f, 0.5f, 0.824219f, 1.0f},
   {0.410156f, 0.507812f, 0.824219f, 1.0f},
   {0.417969f, 0.511719f, 0.828125f, 1.0f},
   {0.421875f, 0.519531f, 0.828125f, 1.0f},
   {0.429688f, 0.527344f, 0.832031f, 1.0f},
   {0.433594f, 0.53125f, 0.835938f, 1.0f},
   {0.441406f, 0.539062f, 0.835938f, 1.0f},
   {0.445312f, 0.546875f, 0.839844f, 1.0f},
   {0.453125f, 0.550781f, 0.839844f, 1.0f},
   {0.457031f, 0.558594f, 0.84375f, 1.0f},
   {0.464844f, 0.566406f, 0.847656f, 1.0f},
   {0.472656f, 0.574219f, 0.847656f, 1.0f},
   {0.476562f, 0.578125f, 0.851562f, 1.0f},
   {0.484375f, 0.585938f, 0.851562f, 1.0f},
   {0.488281f, 0.59375f, 0.855469f, 1.0f},
   {0.496094f, 0.597656f, 0.859375f, 1.0f},
   {0.5f, 0.605469f, 0.859375f, 1.0f},
   {0.507812f, 0.613281f, 0.863281f, 1.0f},
   {0.515625f, 0.617188f, 0.863281f, 1.0f},
   {0.519531f, 0.625f, 0.867188f, 1.0f},
   {0.527344f, 0.632812f, 0.871094f, 1.0f},
   {0.53125f, 0.636719f, 0.871094f, 1.0f},
   {0.539062f, 0.644531f, 0.875f, 1.0f},
   {0.542969f, 0.652344f, 0.875f, 1.0f},
   {0.550781f, 0.660156f, 0.878906f, 1.0f},
   {0.554688f, 0.664062f, 0.882812f, 1.0f},
   {0.5625f, 0.671875f, 0.882812f, 1.0f},
   {0.570312f, 0.679688f, 0.886719f, 1.0f},
   {0.574219f, 0.683594f, 0.886719f, 1.0f},
   {0.582031f, 0.691406f, 0.890625f, 1.0f},
   {0.585938f, 0.699219f, 0.894531f, 1.0f},
   {0.59375f, 0.703125f, 0.894531f, 1.0f},
   {0.601562f, 0.710938f, 0.898438f, 1.0f},
   {0.605469f, 0.71875f, 0.902344f, 1.0f},
   {0.613281f, 0.726562f, 0.902344f, 1.0f},
   {0.621094f, 0.734375f, 0.90625f, 1.0f},
   {0.625f, 0.738281f, 0.910156f, 1.0f},
   {0.632812f, 0.746094f, 0.910156f, 1.0f},
   {0.636719f, 0.753906f, 0.914062f, 1.0f},
   {0.644531f, 0.761719f, 0.914062f, 1.0f},
   {0.652344f, 0.769531f, 0.917969f, 1.0f},
   {0.65625f, 0.777344f, 0.921875f, 1.0f},
   {0.664062f, 0.78125f, 0.921875f, 1.0f},
   {0.671875f, 0.789062f, 0.925781f, 1.0f},
   {0.675781f, 0.796875f, 0.929688f, 1.0f},
   {0.683594f, 0.804688f, 0.929688f, 1.0f},
   {0.691406f, 0.8125f, 0.933594f, 1.0f},
   {0.695312f, 0.816406f, 0.9375f, 1.0f},
   {0.703125f, 0.824219f, 0.9375f, 1.0f},
   {0.710938f, 0.832031f, 0.941406f, 1.0f},
   {0.714844f, 0.839844f, 0.945312f, 1.0f},
   {0.722656f, 0.847656f, 0.945312f, 1.0f},
   {0.730469f, 0.851562f, 0.949219f, 1.0f},
   {0.734375f, 0.859375f, 0.953125f, 1.0f},
   {0.742188f, 0.867188f, 0.953125f, 1.0f},
   {0.75f, 0.875f, 0.957031f, 1.0f},
   {0.753906f, 0.882812f, 0.957031f, 1.0f},
   {0.761719f, 0.886719f, 0.960938f, 1.0f},
   {0.769531f, 0.894531f, 0.964844f, 1.0f},
   {0.773438f, 0.902344f, 0.964844f, 1.0f},
   {0.78125f, 0.910156f, 0.96875f, 1.0f},
   {0.789062f, 0.917969f, 0.972656f, 1.0f},
   {0.792969f, 0.921875f, 0.972656f, 1.0f},
   {0.800781f, 0.929688f, 0.976562f, 1.0f},
   {0.808594f, 0.9375f, 0.980469f, 1.0f},
   {0.8125f, 0.945312f, 0.980469f, 1.0f},
   {0.820312f, 0.953125f, 0.984375f, 1.0f},
   {0.828125f, 0.957031f, 0.988281f, 1.0f},
   {0.832031f, 0.964844f, 0.988281f, 1.0f},
   {0.839844f, 0.972656f, 0.992188f, 1.0f},
   {0.847656f, 0.980469f, 0.992188f, 1.0f},
});

const Palette BPAL_16 = Palette("horizon",
{
   {0.046875f, 0.355469f, 0.566406f, 1.0f},
   {0.0546875f, 0.363281f, 0.570312f, 1.0f},
   {0.0625f, 0.367188f, 0.574219f, 1.0f},
   {0.0703125f, 0.371094f, 0.578125f, 1.0f},
   {0.078125f, 0.378906f, 0.582031f, 1.0f},
   {0.0859375f, 0.382812f, 0.585938f, 1.0f},
   {0.09375f, 0.386719f, 0.589844f, 1.0f},
   {0.101562f, 0.394531f, 0.59375f, 1.0f},
   {0.109375f, 0.398438f, 0.597656f, 1.0f},
   {0.117188f, 0.402344f, 0.597656f, 1.0f},
   {0.125f, 0.410156f, 0.601562f, 1.0f},
   {0.132812f, 0.414062f, 0.605469f, 1.0f},
   {0.140625f, 0.417969f, 0.609375f, 1.0f},
   {0.148438f, 0.425781f, 0.613281f, 1.0f},
   {0.15625f, 0.429688f, 0.617188f, 1.0f},
   {0.164062f, 0.433594f, 0.621094f, 1.0f},
   {0.171875f, 0.441406f, 0.625f, 1.0f},
   {0.179688f, 0.445312f, 0.625f, 1.0f},
   {0.1875f, 0.449219f, 0.628906f, 1.0f},
   {0.195312f, 0.457031f, 0.632812f, 1.0f},
   {0.203125f, 0.460938f, 0.636719f, 1.0f},
   {0.210938f, 0.464844f, 0.640625f, 1.0f},
   {0.21875f, 0.472656f, 0.644531f, 1.0f},
   {0.226562f, 0.476562f, 0.648438f, 1.0f},
   {0.234375f, 0.480469f, 0.652344f, 1.0f},
   {0.242188f, 0.488281f, 0.652344f, 1.0f},
   {0.25f, 0.492188f, 0.65625f, 1.0f},
   {0.257812f, 0.496094f, 0.660156f, 1.0f},
   {0.265625f, 0.503906f, 0.664062f, 1.0f},
   {0.273438f, 0.507812f, 0.667969f, 1.0f},
   {0.28125f, 0.511719f, 0.671875f, 1.0f},
   {0.289062f, 0.519531f, 0.675781f, 1.0f},
   {0.296875f, 0.523438f, 0.679688f, 1.0f},
   {0.308594f, 0.527344f, 0.679688f, 1.0f},
   {0.316406f, 0.535156f, 0.683594f, 1.0f},
   {0.324219f, 0.539062f, 0.6875f, 1.0f},
   {0.332031f, 0.542969f, 0.691406f, 1.0f},
   {0.339844f, 0.550781f, 0.695312f, 1.0f},
   {0.347656f, 0.554688f, 0.699219f, 1.0f},
   {0.355469f, 0.558594f, 0.703125f, 1.0f},
   {0.363281f, 0.566406f, 0.707031f, 1.0f},
   {0.371094f, 0.570312f, 0.707031f, 1.0f},
   {0.378906f, 0.574219f, 0.710938f, 1.0f},
   {0.386719f, 0.582031f, 0.714844f, 1.0f},
   {0.394531f, 0.585938f, 0.71875f, 1.0f},
   {0.402344f, 0.589844f, 0.722656f, 1.0f},
   {0.410156f, 0.597656f, 0.726562f, 1.0f},
   {0.417969f, 0.601562f, 0.730469f, 1.0f},
   {0.425781f, 0.605469f, 0.734375f, 1.0f},
   {0.433594f, 0.613281f, 0.738281f, 1.0f},
   {0.441406f, 0.617188f, 0.738281f, 1.0f},
   {0.449219f, 0.621094f, 0.742188f, 1.0f},
   {0.457031f, 0.628906f, 0.746094f, 1.0f},
   {0.464844f, 0.632812f, 0.75f, 1.0f},
   {0.472656f, 0.636719f, 0.753906f, 1.0f},
   {0.480469f, 0.644531f, 0.757812f, 1.0f},
   {0.488281f, 0.648438f, 0.761719f, 1.0f},
   {0.496094f, 0.652344f, 0.765625f, 1.0f},
   {0.503906f, 0.660156f, 0.765625f, 1.0f},
   {0.511719f, 0.664062f, 0.769531f, 1.0f},
   {0.519531f, 0.667969f, 0.773438f, 1.0f},
   {0.527344f, 0.671875f, 0.777344f, 1.0f},
   {0.535156f, 0.679688f, 0.78125f, 1.0f},
   {0.542969f, 0.683594f, 0.78125f, 1.0f},
   {0.546875f, 0.6875f, 0.785156f, 1.0f},
   {0.554688f, 0.691406f, 0.789062f, 1.0f},
   {0.5625f, 0.695312f, 0.792969f, 1.0f},
   {0.570312f, 0.699219f, 0.792969f, 1.0f},
   {0.574219f, 0.703125f, 0.796875f, 1.0f},
   {0.582031f, 0.710938f, 0.800781f, 1.0f},
   {0.589844f, 0.714844f, 0.804688f, 1.0f},
   {0.597656f, 0.71875f, 0.804688f, 1.0f},
   {0.601562f, 0.722656f, 0.808594f, 1.0f},
   {0.609375f, 0.726562f, 0.8125f, 1.0f},
   {0.617188f, 0.730469f, 0.816406f, 1.0f},
   {0.625f, 0.734375f, 0.816406f, 1.0f},
   {0.628906f, 0.742188f, 0.820312f, 1.0f},
   {0.636719f, 0.746094f, 0.824219f, 1.0f},
   {0.644531f, 0.75f, 0.828125f, 1.0f},
   {0.652344f, 0.753906f, 0.832031f, 1.0f},
   {0.65625f, 0.757812f, 0.832031f, 1.0f},
   {0.664062f, 0.761719f, 0.835938f, 1.0f},
   {0.671875f, 0.765625f, 0.839844f, 1.0f},
   {0.679688f, 0.773438f, 0.84375f, 1.0f},
   {0.683594f, 0.777344f, 0.84375f, 1.0f},
   {0.691406f, 0.78125f, 0.847656f, 1.0f},
   {0.699219f, 0.785156f, 0.851562f, 1.0f},
   {0.707031f, 0.789062f, 0.855469f, 1.0f},
   {0.710938f, 0.792969f, 0.855469f, 1.0f},
   {0.71875f, 0.796875f, 0.859375f, 1.0f},
   {0.726562f, 0.804688f, 0.863281f, 1.0f},
   {0.734375f, 0.808594f, 0.867188f, 1.0f},
   {0.738281f, 0.8125f, 0.867188f, 1.0f},
   {0.746094f, 0.816406f, 0.871094f, 1.0f},
   {0.753906f, 0.820312f, 0.875f, 1.0f},
   {0.761719f, 0.824219f, 0.878906f, 1.0f},
   {0.765625f, 0.828125f, 0.878906f, 1.0f},
   {0.773438f, 0.835938f, 0.882812f, 1.0f},
   {0.78125f, 0.839844f, 0.886719f, 1.0f},
   {0.789062f, 0.84375f, 0.890625f, 1.0f},
   {0.792969f, 0.847656f, 0.890625f, 1.0f},
   {0.800781f, 0.851562f, 0.894531f, 1.0f},
   {0.808594f, 0.855469f, 0.898438f, 1.0f},
   {0.816406f, 0.859375f, 0.902344f, 1.0f},
   {0.820312f, 0.867188f, 0.902344f, 1.0f},
   {0.828125f, 0.871094f, 0.90625f, 1.0f},
   {0.835938f, 0.875f, 0.910156f, 1.0f},
   {0.839844f, 0.878906f, 0.914062f, 1.0f},
   {0.847656f, 0.882812f, 0.914062f, 1.0f},
   {0.855469f, 0.886719f, 0.917969f, 1.0f},
   {0.863281f, 0.890625f, 0.921875f, 1.0f},
   {0.867188f, 0.898438f, 0.925781f, 1.0f},
   {0.875f, 0.902344f, 0.925781f, 1.0f},
   {0.882812f, 0.90625f, 0.929688f, 1.0f},
   {0.890625f, 0.910156f, 0.933594f, 1.0f},
   {0.894531f, 0.914062f, 0.9375f, 1.0f},
   {0.902344f, 0.917969f, 0.9375f, 1.0f},
   {0.910156f, 0.921875f, 0.941406f, 1.0f},
   {0.917969f, 0.925781f, 0.945312f, 1.0f},
   {0.921875f, 0.933594f, 0.949219f, 1.0f},
   {0.929688f, 0.9375f, 0.949219f, 1.0f},
   {0.9375f, 0.941406f, 0.953125f, 1.0f},
   {0.945312f, 0.945312f, 0.957031f, 1.0f},
   {0.949219f, 0.949219f, 0.960938f, 1.0f},
   {0.957031f, 0.953125f, 0.960938f, 1.0f},
   {0.964844f, 0.957031f, 0.964844f, 1.0f},
   {0.972656f, 0.964844f, 0.96875f, 1.0f},
   {0.976562f, 0.96875f, 0.972656f, 1.0f},
   {0.984375f, 0.972656f, 0.972656f, 1.0f},
   {0.992188f, 0.976562f, 0.976562f, 1.0f},
   {0.992188f, 0.988281f, 0.988281f, 1.0f},
   {0.988281f, 0.980469f, 0.976562f, 1.0f},
   {0.984375f, 0.972656f, 0.964844f, 1.0f},
   {0.984375f, 0.964844f, 0.953125f, 1.0f},
   {0.980469f, 0.957031f, 0.945312f, 1.0f},
   {0.976562f, 0.949219f, 0.933594f, 1.0f},
   {0.972656f, 0.941406f, 0.925781f, 1.0f},
   {0.972656f, 0.933594f, 0.914062f, 1.0f},
   {0.96875f, 0.925781f, 0.90625f, 1.0f},
   {0.964844f, 0.917969f, 0.894531f, 1.0f},
   {0.964844f, 0.914062f, 0.886719f, 1.0f},
   {0.960938f, 0.90625f, 0.875f, 1.0f},
   {0.957031f, 0.898438f, 0.867188f, 1.0f},
   {0.957031f, 0.890625f, 0.859375f, 1.0f},
   {0.953125f, 0.886719f, 0.847656f, 1.0f},
   {0.949219f, 0.878906f, 0.839844f, 1.0f},
   {0.949219f, 0.871094f, 0.832031f, 1.0f},
   {0.945312f, 0.863281f, 0.824219f, 1.0f},
   {0.941406f, 0.859375f, 0.8125f, 1.0f},
   {0.941406f, 0.851562f, 0.804688f, 1.0f},
   {0.9375f, 0.84375f, 0.796875f, 1.0f},
   {0.9375f, 0.839844f, 0.789062f, 1.0f},
   {0.933594f, 0.832031f, 0.777344f, 1.0f},
   {0.929688f, 0.824219f, 0.769531f, 1.0f},
   {0.925781f, 0.816406f, 0.757812f, 1.0f},
   {0.925781f, 0.808594f, 0.746094f, 1.0f},
   {0.921875f, 0.800781f, 0.738281f, 1.0f},
   {0.917969f, 0.792969f, 0.726562f, 1.0f},
   {0.914062f, 0.785156f, 0.714844f, 1.0f},
   {0.914062f, 0.777344f, 0.703125f, 1.0f},
   {0.910156f, 0.765625f, 0.691406f, 1.0f},
   {0.90625f, 0.757812f, 0.683594f, 1.0f},
   {0.902344f, 0.75f, 0.671875f, 1.0f},
   {0.898438f, 0.742188f, 0.660156f, 1.0f},
   {0.898438f, 0.734375f, 0.652344f, 1.0f},
   {0.894531f, 0.726562f, 0.640625f, 1.0f},
   {0.890625f, 0.71875f, 0.632812f, 1.0f},
   {0.890625f, 0.714844f, 0.621094f, 1.0f},
   {0.886719f, 0.707031f, 0.613281f, 1.0f},
   {0.882812f, 0.699219f, 0.601562f, 1.0f},
   {0.878906f, 0.691406f, 0.59375f, 1.0f},
   {0.878906f, 0.683594f, 0.582031f, 1.0f},
   {0.875f, 0.675781f, 0.570312f, 1.0f},
   {0.871094f, 0.667969f, 0.5625f, 1.0f},
   {0.871094f, 0.660156f, 0.550781f, 1.0f},
   {0.871094f, 0.660156f, 0.550781f, 1.0f},
   {0.867188f, 0.660156f, 0.550781f, 1.0f},
   {0.867188f, 0.65625f, 0.546875f, 1.0f},
   {0.867188f, 0.65625f, 0.546875f, 1.0f},
   {0.867188f, 0.65625f, 0.542969f, 1.0f},
   {0.867188f, 0.652344f, 0.542969f, 1.0f},
   {0.867188f, 0.652344f, 0.542969f, 1.0f},
   {0.867188f, 0.652344f, 0.539062f, 1.0f},
   {0.867188f, 0.652344f, 0.539062f, 1.0f},
   {0.867188f, 0.648438f, 0.535156f, 1.0f},
   {0.863281f, 0.648438f, 0.535156f, 1.0f},
   {0.863281f, 0.648438f, 0.535156f, 1.0f},
   {0.863281f, 0.644531f, 0.53125f, 1.0f},
   {0.863281f, 0.644531f, 0.53125f, 1.0f},
   {0.863281f, 0.644531f, 0.53125f, 1.0f},
   {0.863281f, 0.640625f, 0.527344f, 1.0f},
   {0.863281f, 0.640625f, 0.527344f, 1.0f},
   {0.863281f, 0.640625f, 0.523438f, 1.0f},
   {0.863281f, 0.640625f, 0.523438f, 1.0f},
   {0.859375f, 0.636719f, 0.523438f, 1.0f},
   {0.859375f, 0.636719f, 0.519531f, 1.0f},
   {0.859375f, 0.636719f, 0.519531f, 1.0f},
   {0.859375f, 0.632812f, 0.515625f, 1.0f},
   {0.859375f, 0.632812f, 0.515625f, 1.0f},
   {0.859375f, 0.632812f, 0.515625f, 1.0f},
   {0.859375f, 0.632812f, 0.511719f, 1.0f},
   {0.859375f, 0.628906f, 0.511719f, 1.0f},
   {0.859375f, 0.628906f, 0.507812f, 1.0f},
   {0.855469f, 0.628906f, 0.507812f, 1.0f},
   {0.855469f, 0.625f, 0.507812f, 1.0f},
   {0.855469f, 0.625f, 0.503906f, 1.0f},
   {0.855469f, 0.625f, 0.503906f, 1.0f},
   {0.855469f, 0.621094f, 0.5f, 1.0f},
   {0.855469f, 0.621094f, 0.5f, 1.0f},
   {0.855469f, 0.621094f, 0.5f, 1.0f},
   {0.855469f, 0.621094f, 0.496094f, 1.0f},
   {0.855469f, 0.617188f, 0.496094f, 1.0f},
   {0.851562f, 0.617188f, 0.496094f, 1.0f},
   {0.851562f, 0.617188f, 0.492188f, 1.0f},
   {0.851562f, 0.613281f, 0.492188f, 1.0f},
   {0.851562f, 0.613281f, 0.488281f, 1.0f},
   {0.851562f, 0.613281f, 0.488281f, 1.0f},
   {0.851562f, 0.613281f, 0.488281f, 1.0f},
   {0.851562f, 0.609375f, 0.484375f, 1.0f},
   {0.851562f, 0.609375f, 0.484375f, 1.0f},
   {0.851562f, 0.609375f, 0.480469f, 1.0f},
   {0.847656f, 0.605469f, 0.480469f, 1.0f},
   {0.847656f, 0.605469f, 0.476562f, 1.0f},
   {0.847656f, 0.601562f, 0.476562f, 1.0f},
   {0.847656f, 0.601562f, 0.472656f, 1.0f},
   {0.847656f, 0.597656f, 0.46875f, 1.0f},
   {0.847656f, 0.597656f, 0.46875f, 1.0f},
   {0.84375f, 0.597656f, 0.464844f, 1.0f},
   {0.84375f, 0.59375f, 0.464844f, 1.0f},
   {0.84375f, 0.59375f, 0.460938f, 1.0f},
   {0.84375f, 0.589844f, 0.460938f, 1.0f},
   {0.84375f, 0.589844f, 0.457031f, 1.0f},
   {0.84375f, 0.585938f, 0.457031f, 1.0f},
   {0.839844f, 0.585938f, 0.453125f, 1.0f},
   {0.839844f, 0.585938f, 0.449219f, 1.0f},
   {0.839844f, 0.582031f, 0.449219f, 1.0f},
   {0.839844f, 0.582031f, 0.445312f, 1.0f},
   {0.839844f, 0.578125f, 0.445312f, 1.0f},
   {0.839844f, 0.578125f, 0.441406f, 1.0f},
   {0.839844f, 0.574219f, 0.441406f, 1.0f},
   {0.835938f, 0.574219f, 0.4375f, 1.0f},
   {0.835938f, 0.574219f, 0.433594f, 1.0f},
   {0.835938f, 0.570312f, 0.433594f, 1.0f},
   {0.835938f, 0.570312f, 0.429688f, 1.0f},
   {0.835938f, 0.566406f, 0.429688f, 1.0f},
   {0.835938f, 0.566406f, 0.425781f, 1.0f},
   {0.832031f, 0.566406f, 0.425781f, 1.0f},
   {0.832031f, 0.5625f, 0.421875f, 1.0f},
   {0.832031f, 0.5625f, 0.421875f, 1.0f},
   {0.832031f, 0.558594f, 0.417969f, 1.0f},
   {0.832031f, 0.558594f, 0.414062f, 1.0f},
   {0.832031f, 0.554688f, 0.414062f, 1.0f},
   {0.828125f, 0.554688f, 0.410156f, 1.0f},
   {0.828125f, 0.554688f, 0.410156f, 1.0f},
   {0.828125f, 0.550781f, 0.40625f, 1.0f},
   {0.828125f, 0.550781f, 0.40625f, 1.0f},
});

const Palette BPAL_17 = Palette("byr",
{
   {0.019531f, 0.136719f, 0.3125f, 1.0f},
   {0.019531f, 0.144531f, 0.324219f, 1.0f},
   {0.019531f, 0.152344f, 0.335938f, 1.0f},
   {0.019531f, 0.15625f, 0.347656f, 1.0f},
   {0.019531f, 0.164062f, 0.359375f, 1.0f},
   {0.023438f, 0.171875f, 0.371094f, 1.0f},
   {0.023438f, 0.179688f, 0.382812f, 1.0f},
   {0.023438f, 0.1875f, 0.390625f, 1.0f},
   {0.023438f, 0.191406f, 0.402344f, 1.0f},
   {0.023438f, 0.199219f, 0.414062f, 1.0f},
   {0.023438f, 0.207031f, 0.425781f, 1.0f},
   {0.023438f, 0.214844f, 0.4375f, 1.0f},
   {0.023438f, 0.222656f, 0.449219f, 1.0f},
   {0.027344f, 0.230469f, 0.460938f, 1.0f},
   {0.027344f, 0.234375f, 0.472656f, 1.0f},
   {0.027344f, 0.242188f, 0.484375f, 1.0f},
   {0.027344f, 0.25f, 0.496094f, 1.0f},
   {0.027344f, 0.257812f, 0.507812f, 1.0f},
   {0.027344f, 0.265625f, 0.519531f, 1.0f},
   {0.027344f, 0.269531f, 0.53125f, 1.0f},
   {0.027344f, 0.277344f, 0.539062f, 1.0f},
   {0.027344f, 0.285156f, 0.550781f, 1.0f},
   {0.03125f, 0.292969f, 0.5625f, 1.0f},
   {0.03125f, 0.300781f, 0.574219f, 1.0f},
   {0.03125f, 0.304688f, 0.585938f, 1.0f},
   {0.03125f, 0.320312f, 0.609375f, 1.0f},
   {0.039062f, 0.328125f, 0.617188f, 1.0f},
   {0.046875f, 0.339844f, 0.621094f, 1.0f},
   {0.058594f, 0.347656f, 0.628906f, 1.0f},
   {0.066406f, 0.359375f, 0.636719f, 1.0f},
   {0.074219f, 0.367188f, 0.640625f, 1.0f},
   {0.082031f, 0.378906f, 0.648438f, 1.0f},
   {0.09375f, 0.386719f, 0.65625f, 1.0f},
   {0.101562f, 0.398438f, 0.660156f, 1.0f},
   {0.109375f, 0.40625f, 0.667969f, 1.0f},
   {0.117188f, 0.417969f, 0.675781f, 1.0f},
   {0.128906f, 0.425781f, 0.679688f, 1.0f},
   {0.136719f, 0.4375f, 0.6875f, 1.0f},
   {0.144531f, 0.445312f, 0.695312f, 1.0f},
   {0.152344f, 0.453125f, 0.699219f, 1.0f},
   {0.160156f, 0.464844f, 0.707031f, 1.0f},
   {0.171875f, 0.472656f, 0.710938f, 1.0f},
   {0.179688f, 0.484375f, 0.71875f, 1.0f},
   {0.1875f, 0.492188f, 0.726562f, 1.0f},
   {0.195312f, 0.503906f, 0.730469f, 1.0f},
   {0.207031f, 0.511719f, 0.738281f, 1.0f},
   {0.214844f, 0.523438f, 0.746094f, 1.0f},
   {0.222656f, 0.53125f, 0.75f, 1.0f},
   {0.230469f, 0.542969f, 0.757812f, 1.0f},
   {0.242188f, 0.550781f, 0.765625f, 1.0f},
   {0.257812f, 0.570312f, 0.777344f, 1.0f},
   {0.265625f, 0.574219f, 0.78125f, 1.0f},
   {0.269531f, 0.582031f, 0.78125f, 1.0f},
   {0.277344f, 0.585938f, 0.785156f, 1.0f},
   {0.28125f, 0.59375f, 0.785156f, 1.0f},
   {0.289062f, 0.597656f, 0.789062f, 1.0f},
   {0.296875f, 0.605469f, 0.789062f, 1.0f},
   {0.300781f, 0.609375f, 0.792969f, 1.0f},
   {0.308594f, 0.613281f, 0.796875f, 1.0f},
   {0.316406f, 0.621094f, 0.796875f, 1.0f},
   {0.320312f, 0.625f, 0.800781f, 1.0f},
   {0.328125f, 0.632812f, 0.800781f, 1.0f},
   {0.332031f, 0.636719f, 0.804688f, 1.0f},
   {0.339844f, 0.644531f, 0.808594f, 1.0f},
   {0.347656f, 0.648438f, 0.808594f, 1.0f},
   {0.351562f, 0.652344f, 0.8125f, 1.0f},
   {0.359375f, 0.660156f, 0.8125f, 1.0f},
   {0.363281f, 0.664062f, 0.816406f, 1.0f},
   {0.371094f, 0.671875f, 0.816406f, 1.0f},
   {0.378906f, 0.675781f, 0.820312f, 1.0f},
   {0.382812f, 0.679688f, 0.824219f, 1.0f},
   {0.390625f, 0.6875f, 0.824219f, 1.0f},
   {0.398438f, 0.691406f, 0.828125f, 1.0f},
   {0.402344f, 0.699219f, 0.828125f, 1.0f},
   {0.410156f, 0.703125f, 0.832031f, 1.0f},
   {0.414062f, 0.710938f, 0.832031f, 1.0f},
   {0.421875f, 0.714844f, 0.835938f, 1.0f},
   {0.429688f, 0.71875f, 0.839844f, 1.0f},
   {0.441406f, 0.726562f, 0.839844f, 1.0f},
   {0.449219f, 0.730469f, 0.84375f, 1.0f},
   {0.460938f, 0.738281f, 0.84375f, 1.0f},
   {0.46875f, 0.742188f, 0.847656f, 1.0f},
   {0.476562f, 0.75f, 0.851562f, 1.0f},
   {0.488281f, 0.753906f, 0.851562f, 1.0f},
   {0.496094f, 0.757812f, 0.855469f, 1.0f},
   {0.503906f, 0.765625f, 0.859375f, 1.0f},
   {0.515625f, 0.769531f, 0.859375f, 1.0f},
   {0.523438f, 0.777344f, 0.863281f, 1.0f},
   {0.535156f, 0.78125f, 0.863281f, 1.0f},
   {0.542969f, 0.789062f, 0.867188f, 1.0f},
   {0.550781f, 0.792969f, 0.871094f, 1.0f},
   {0.5625f, 0.796875f, 0.871094f, 1.0f},
   {0.570312f, 0.804688f, 0.875f, 1.0f},
   {0.582031f, 0.808594f, 0.875f, 1.0f},
   {0.589844f, 0.816406f, 0.878906f, 1.0f},
   {0.597656f, 0.820312f, 0.882812f, 1.0f},
   {0.609375f, 0.824219f, 0.882812f, 1.0f},
   {0.617188f, 0.832031f, 0.886719f, 1.0f},
   {0.625f, 0.835938f, 0.890625f, 1.0f},
   {0.636719f, 0.84375f, 0.890625f, 1.0f},
   {0.644531f, 0.847656f, 0.894531f, 1.0f},
   {0.664062f, 0.859375f, 0.898438f, 1.0f},
   {0.671875f, 0.863281f, 0.902344f, 1.0f},
   {0.679688f, 0.867188f, 0.90625f, 1.0f},
   {0.6875f, 0.871094f, 0.910156f, 1.0f},
   {0.695312f, 0.875f, 0.914062f, 1.0f},
   {0.699219f, 0.878906f, 0.917969f, 1.0f},
   {0.707031f, 0.882812f, 0.921875f, 1.0f},
   {0.714844f, 0.886719f, 0.925781f, 1.0f},
   {0.722656f, 0.890625f, 0.929688f, 1.0f},
   {0.730469f, 0.894531f, 0.933594f, 1.0f},
   {0.738281f, 0.898438f, 0.9375f, 1.0f},
   {0.746094f, 0.902344f, 0.941406f, 1.0f},
   {0.753906f, 0.90625f, 0.945312f, 1.0f},
   {0.761719f, 0.910156f, 0.949219f, 1.0f},
   {0.765625f, 0.910156f, 0.949219f, 1.0f},
   {0.773438f, 0.914062f, 0.953125f, 1.0f},
   {0.78125f, 0.917969f, 0.957031f, 1.0f},
   {0.789062f, 0.921875f, 0.960938f, 1.0f},
   {0.796875f, 0.925781f, 0.964844f, 1.0f},
   {0.804688f, 0.929688f, 0.96875f, 1.0f},
   {0.8125f, 0.933594f, 0.972656f, 1.0f},
   {0.820312f, 0.9375f, 0.976562f, 1.0f},
   {0.824219f, 0.941406f, 0.980469f, 1.0f},
   {0.832031f, 0.945312f, 0.984375f, 1.0f},
   {0.839844f, 0.949219f, 0.988281f, 1.0f},
   {0.855469f, 0.957031f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.78125f, 1.0f},
   {0.996094f, 0.992188f, 0.769531f, 1.0f},
   {0.996094f, 0.988281f, 0.753906f, 1.0f},
   {0.996094f, 0.984375f, 0.742188f, 1.0f},
   {0.996094f, 0.980469f, 0.730469f, 1.0f},
   {0.996094f, 0.976562f, 0.71875f, 1.0f},
   {0.996094f, 0.972656f, 0.703125f, 1.0f},
   {0.996094f, 0.96875f, 0.691406f, 1.0f},
   {0.996094f, 0.964844f, 0.679688f, 1.0f},
   {0.996094f, 0.960938f, 0.667969f, 1.0f},
   {0.996094f, 0.957031f, 0.652344f, 1.0f},
   {0.996094f, 0.953125f, 0.640625f, 1.0f},
   {0.996094f, 0.949219f, 0.628906f, 1.0f},
   {0.996094f, 0.949219f, 0.617188f, 1.0f},
   {0.996094f, 0.945312f, 0.601562f, 1.0f},
   {0.996094f, 0.941406f, 0.589844f, 1.0f},
   {0.996094f, 0.9375f, 0.578125f, 1.0f},
   {0.996094f, 0.933594f, 0.5625f, 1.0f},
   {0.996094f, 0.929688f, 0.550781f, 1.0f},
   {0.996094f, 0.925781f, 0.539062f, 1.0f},
   {0.996094f, 0.921875f, 0.527344f, 1.0f},
   {0.996094f, 0.917969f, 0.511719f, 1.0f},
   {0.996094f, 0.914062f, 0.5f, 1.0f},
   {0.996094f, 0.910156f, 0.488281f, 1.0f},
   {0.996094f, 0.90625f, 0.476562f, 1.0f},
   {0.996094f, 0.898438f, 0.449219f, 1.0f},
   {0.996094f, 0.894531f, 0.441406f, 1.0f},
   {0.992188f, 0.886719f, 0.433594f, 1.0f},
   {0.992188f, 0.882812f, 0.425781f, 1.0f},
   {0.988281f, 0.878906f, 0.421875f, 1.0f},
   {0.988281f, 0.875f, 0.414062f, 1.0f},
   {0.984375f, 0.867188f, 0.40625f, 1.0f},
   {0.984375f, 0.863281f, 0.398438f, 1.0f},
   {0.980469f, 0.859375f, 0.390625f, 1.0f},
   {0.980469f, 0.855469f, 0.382812f, 1.0f},
   {0.976562f, 0.847656f, 0.378906f, 1.0f},
   {0.976562f, 0.84375f, 0.371094f, 1.0f},
   {0.972656f, 0.839844f, 0.363281f, 1.0f},
   {0.972656f, 0.835938f, 0.355469f, 1.0f},
   {0.96875f, 0.828125f, 0.347656f, 1.0f},
   {0.96875f, 0.824219f, 0.339844f, 1.0f},
   {0.964844f, 0.820312f, 0.332031f, 1.0f},
   {0.964844f, 0.8125f, 0.328125f, 1.0f},
   {0.960938f, 0.808594f, 0.320312f, 1.0f},
   {0.960938f, 0.804688f, 0.3125f, 1.0f},
   {0.957031f, 0.800781f, 0.304688f, 1.0f},
   {0.957031f, 0.792969f, 0.296875f, 1.0f},
   {0.953125f, 0.789062f, 0.289062f, 1.0f},
   {0.953125f, 0.785156f, 0.285156f, 1.0f},
   {0.949219f, 0.78125f, 0.277344f, 1.0f},
   {0.945312f, 0.769531f, 0.261719f, 1.0f},
   {0.945312f, 0.757812f, 0.253906f, 1.0f},
   {0.941406f, 0.746094f, 0.246094f, 1.0f},
   {0.941406f, 0.734375f, 0.242188f, 1.0f},
   {0.9375f, 0.722656f, 0.234375f, 1.0f},
   {0.9375f, 0.710938f, 0.226562f, 1.0f},
   {0.933594f, 0.699219f, 0.21875f, 1.0f},
   {0.933594f, 0.6875f, 0.210938f, 1.0f},
   {0.929688f, 0.675781f, 0.207031f, 1.0f},
   {0.929688f, 0.664062f, 0.199219f, 1.0f},
   {0.925781f, 0.652344f, 0.191406f, 1.0f},
   {0.925781f, 0.640625f, 0.183594f, 1.0f},
   {0.921875f, 0.628906f, 0.175781f, 1.0f},
   {0.921875f, 0.621094f, 0.171875f, 1.0f},
   {0.921875f, 0.609375f, 0.164062f, 1.0f},
   {0.917969f, 0.597656f, 0.15625f, 1.0f},
   {0.917969f, 0.585938f, 0.148438f, 1.0f},
   {0.914062f, 0.574219f, 0.140625f, 1.0f},
   {0.914062f, 0.5625f, 0.132812f, 1.0f},
   {0.910156f, 0.550781f, 0.128906f, 1.0f},
   {0.910156f, 0.539062f, 0.121094f, 1.0f},
   {0.90625f, 0.527344f, 0.113281f, 1.0f},
   {0.90625f, 0.515625f, 0.105469f, 1.0f},
   {0.902344f, 0.503906f, 0.097656f, 1.0f},
   {0.902344f, 0.492188f, 0.09375f, 1.0f},
   {0.898438f, 0.480469f, 0.085938f, 1.0f},
   {0.898438f, 0.46875f, 0.078125f, 1.0f},
   {0.894531f, 0.460938f, 0.074219f, 1.0f},
   {0.890625f, 0.453125f, 0.070312f, 1.0f},
   {0.886719f, 0.445312f, 0.070312f, 1.0f},
   {0.878906f, 0.4375f, 0.066406f, 1.0f},
   {0.875f, 0.429688f, 0.0625f, 1.0f},
   {0.871094f, 0.421875f, 0.058594f, 1.0f},
   {0.867188f, 0.417969f, 0.058594f, 1.0f},
   {0.863281f, 0.410156f, 0.054688f, 1.0f},
   {0.859375f, 0.402344f, 0.050781f, 1.0f},
   {0.851562f, 0.394531f, 0.046875f, 1.0f},
   {0.847656f, 0.386719f, 0.046875f, 1.0f},
   {0.84375f, 0.378906f, 0.042969f, 1.0f},
   {0.839844f, 0.371094f, 0.039062f, 1.0f},
   {0.835938f, 0.363281f, 0.035156f, 1.0f},
   {0.832031f, 0.355469f, 0.03125f, 1.0f},
   {0.828125f, 0.347656f, 0.03125f, 1.0f},
   {0.820312f, 0.339844f, 0.027344f, 1.0f},
   {0.816406f, 0.332031f, 0.023438f, 1.0f},
   {0.8125f, 0.324219f, 0.019531f, 1.0f},
   {0.808594f, 0.320312f, 0.019531f, 1.0f},
   {0.804688f, 0.3125f, 0.015625f, 1.0f},
   {0.800781f, 0.304688f, 0.011719f, 1.0f},
   {0.792969f, 0.296875f, 0.007812f, 1.0f},
   {0.789062f, 0.289062f, 0.007812f, 1.0f},
   {0.78125f, 0.273438f, 0.0f, 1.0f},
   {0.773438f, 0.269531f, 0.003906f, 1.0f},
   {0.761719f, 0.265625f, 0.007812f, 1.0f},
   {0.753906f, 0.261719f, 0.011719f, 1.0f},
   {0.742188f, 0.253906f, 0.015625f, 1.0f},
   {0.734375f, 0.25f, 0.015625f, 1.0f},
   {0.722656f, 0.246094f, 0.019531f, 1.0f},
   {0.714844f, 0.242188f, 0.023438f, 1.0f},
   {0.703125f, 0.238281f, 0.027344f, 1.0f},
   {0.695312f, 0.234375f, 0.03125f, 1.0f},
   {0.683594f, 0.226562f, 0.035156f, 1.0f},
   {0.675781f, 0.222656f, 0.039062f, 1.0f},
   {0.664062f, 0.21875f, 0.042969f, 1.0f},
   {0.65625f, 0.214844f, 0.046875f, 1.0f},
   {0.644531f, 0.210938f, 0.046875f, 1.0f},
   {0.636719f, 0.207031f, 0.050781f, 1.0f},
   {0.625f, 0.203125f, 0.054688f, 1.0f},
   {0.617188f, 0.195312f, 0.058594f, 1.0f},
   {0.605469f, 0.191406f, 0.0625f, 1.0f},
   {0.597656f, 0.1875f, 0.066406f, 1.0f},
   {0.585938f, 0.183594f, 0.070312f, 1.0f},
   {0.578125f, 0.179688f, 0.074219f, 1.0f},
   {0.566406f, 0.175781f, 0.074219f, 1.0f},
   {0.558594f, 0.167969f, 0.078125f, 1.0f},
   {0.546875f, 0.164062f, 0.082031f, 1.0f},
   {0.527344f, 0.15625f, 0.089844f, 1.0f},
});

const Palette BPAL_18 = Palette("ocean",
{
   {0.110363f, 0.00169078f, 0.253026f, 1.0f},
   {0.112295f, 0.00603321f, 0.257538f, 1.0f},
   {0.11418f, 0.0106084f, 0.262052f, 1.0f},
   {0.11602f, 0.0154203f, 0.266566f, 1.0f},
   {0.117813f, 0.0204727f, 0.271076f, 1.0f},
   {0.119559f, 0.0257694f, 0.275581f, 1.0f},
   {0.121258f, 0.0313141f, 0.280079f, 1.0f},
   {0.12291f, 0.0371103f, 0.284567f, 1.0f},
   {0.124516f, 0.043066f, 0.289045f, 1.0f},
   {0.126074f, 0.0488032f, 0.293509f, 1.0f},
   {0.127585f, 0.0543413f, 0.29796f, 1.0f},
   {0.129049f, 0.0597148f, 0.302396f, 1.0f},
   {0.130467f, 0.0649499f, 0.306815f, 1.0f},
   {0.131837f, 0.0700677f, 0.311216f, 1.0f},
   {0.13316f, 0.0750846f, 0.315599f, 1.0f},
   {0.134436f, 0.0800143f, 0.319962f, 1.0f},
   {0.135665f, 0.084868f, 0.324305f, 1.0f},
   {0.136846f, 0.0896551f, 0.328626f, 1.0f},
   {0.137981f, 0.0943834f, 0.332924f, 1.0f},
   {0.139069f, 0.0990597f, 0.337199f, 1.0f},
   {0.14011f, 0.10369f, 0.341449f, 1.0f},
   {0.141104f, 0.108279f, 0.345674f, 1.0f},
   {0.142051f, 0.112831f, 0.349873f, 1.0f},
   {0.142951f, 0.11735f, 0.354045f, 1.0f},
   {0.143805f, 0.121839f, 0.35819f, 1.0f},
   {0.144612f, 0.126301f, 0.362305f, 1.0f},
   {0.145372f, 0.130739f, 0.366392f, 1.0f},
   {0.146087f, 0.135155f, 0.370448f, 1.0f},
   {0.146756f, 0.139551f, 0.374473f, 1.0f},
   {0.147379f, 0.14393f, 0.378466f, 1.0f},
   {0.147956f, 0.148292f, 0.382427f, 1.0f},
   {0.148488f, 0.152639f, 0.386354f, 1.0f},
   {0.148976f, 0.156972f, 0.390248f, 1.0f},
   {0.149419f, 0.161293f, 0.394106f, 1.0f},
   {0.149818f, 0.165603f, 0.39793f, 1.0f},
   {0.150174f, 0.169902f, 0.401717f, 1.0f},
   {0.150488f, 0.174192f, 0.405468f, 1.0f},
   {0.150759f, 0.178473f, 0.409181f, 1.0f},
   {0.150989f, 0.182746f, 0.412857f, 1.0f},
   {0.151178f, 0.187011f, 0.416494f, 1.0f},
   {0.151327f, 0.191269f, 0.420093f, 1.0f},
   {0.151437f, 0.19552f, 0.423652f, 1.0f},
   {0.15151f, 0.199766f, 0.427171f, 1.0f},
   {0.151545f, 0.204005f, 0.43065f, 1.0f},
   {0.151545f, 0.208239f, 0.434088f, 1.0f},
   {0.15151f, 0.212467f, 0.437486f, 1.0f},
   {0.151442f, 0.21669f, 0.440842f, 1.0f},
   {0.151342f, 0.220909f, 0.444157f, 1.0f},
   {0.151211f, 0.225122f, 0.44743f, 1.0f},
   {0.151052f, 0.229331f, 0.450662f, 1.0f},
   {0.150865f, 0.233535f, 0.453852f, 1.0f},
   {0.150653f, 0.237734f, 0.457f, 1.0f},
   {0.150417f, 0.241929f, 0.460107f, 1.0f},
   {0.150158f, 0.246119f, 0.463171f, 1.0f},
   {0.14988f, 0.250304f, 0.466194f, 1.0f},
   {0.149584f, 0.254485f, 0.469176f, 1.0f},
   {0.149271f, 0.258662f, 0.472116f, 1.0f},
   {0.148945f, 0.262833f, 0.475016f, 1.0f},
   {0.148608f, 0.267f, 0.477874f, 1.0f},
   {0.148261f, 0.271161f, 0.480693f, 1.0f},
   {0.147907f, 0.275318f, 0.483471f, 1.0f},
   {0.147548f, 0.27947f, 0.48621f, 1.0f},
   {0.147188f, 0.283617f, 0.48891f, 1.0f},
   {0.146828f, 0.287759f, 0.491572f, 1.0f},
   {0.146471f, 0.291895f, 0.494196f, 1.0f},
   {0.14612f, 0.296026f, 0.496782f, 1.0f},
   {0.145777f, 0.300152f, 0.499331f, 1.0f},
   {0.145445f, 0.304272f, 0.501845f, 1.0f},
   {0.145126f, 0.308387f, 0.504323f, 1.0f},
   {0.144824f, 0.312496f, 0.506766f, 1.0f},
   {0.144541f, 0.3166f, 0.509175f, 1.0f},
   {0.14428f, 0.320698f, 0.511551f, 1.0f},
   {0.144043f, 0.32479f, 0.513894f, 1.0f},
   {0.143834f, 0.328876f, 0.516205f, 1.0f},
   {0.143654f, 0.332957f, 0.518485f, 1.0f},
   {0.143507f, 0.337032f, 0.520735f, 1.0f},
   {0.143394f, 0.341102f, 0.522955f, 1.0f},
   {0.14332f, 0.345165f, 0.525146f, 1.0f},
   {0.143285f, 0.349223f, 0.527309f, 1.0f},
   {0.143293f, 0.353275f, 0.529445f, 1.0f},
   {0.143346f, 0.357322f, 0.531555f, 1.0f},
   {0.143446f, 0.361363f, 0.533639f, 1.0f},
   {0.143595f, 0.365398f, 0.535697f, 1.0f},
   {0.143796f, 0.369428f, 0.537732f, 1.0f},
   {0.144051f, 0.373452f, 0.539743f, 1.0f},
   {0.144361f, 0.377471f, 0.541731f, 1.0f},
   {0.144727f, 0.381484f, 0.543697f, 1.0f},
   {0.145153f, 0.385493f, 0.545641f, 1.0f},
   {0.145639f, 0.389496f, 0.547565f, 1.0f},
   {0.146187f, 0.393494f, 0.549469f, 1.0f},
   {0.146798f, 0.397487f, 0.551354f, 1.0f},
   {0.147474f, 0.401475f, 0.55322f, 1.0f},
   {0.148215f, 0.405458f, 0.555068f, 1.0f},
   {0.149022f, 0.409437f, 0.556898f, 1.0f},
   {0.149896f, 0.413411f, 0.558711f, 1.0f},
   {0.150838f, 0.417381f, 0.560508f, 1.0f},
   {0.151848f, 0.421347f, 0.562289f, 1.0f},
   {0.152927f, 0.425308f, 0.564055f, 1.0f},
   {0.154075f, 0.429265f, 0.565806f, 1.0f},
   {0.155292f, 0.433218f, 0.567543f, 1.0f},
   {0.156579f, 0.437168f, 0.569266f, 1.0f},
   {0.157935f, 0.441113f, 0.570976f, 1.0f},
   {0.15936f, 0.445055f, 0.572673f, 1.0f},
   {0.160854f, 0.448994f, 0.574357f, 1.0f},
   {0.162417f, 0.452929f, 0.57603f, 1.0f},
   {0.164048f, 0.456862f, 0.577691f, 1.0f},
   {0.165748f, 0.460791f, 0.57934f, 1.0f},
   {0.167515f, 0.464717f, 0.580978f, 1.0f},
   {0.169349f, 0.46864f, 0.582606f, 1.0f},
   {0.171249f, 0.47256f, 0.584224f, 1.0f},
   {0.173216f, 0.476478f, 0.585831f, 1.0f},
   {0.175248f, 0.480393f, 0.587429f, 1.0f},
   {0.177344f, 0.484306f, 0.589017f, 1.0f},
   {0.179505f, 0.488217f, 0.590596f, 1.0f},
   {0.181729f, 0.492125f, 0.592166f, 1.0f},
   {0.184016f, 0.496031f, 0.593728f, 1.0f},
   {0.186365f, 0.499935f, 0.59528f, 1.0f},
   {0.188775f, 0.503838f, 0.596825f, 1.0f},
   {0.191246f, 0.507738f, 0.598361f, 1.0f},
   {0.193777f, 0.511637f, 0.599889f, 1.0f},
   {0.196368f, 0.515533f, 0.601409f, 1.0f},
   {0.199019f, 0.519429f, 0.602921f, 1.0f},
   {0.201727f, 0.523322f, 0.604426f, 1.0f},
   {0.204494f, 0.527214f, 0.605923f, 1.0f},
   {0.207319f, 0.531105f, 0.607413f, 1.0f},
   {0.210201f, 0.534994f, 0.608895f, 1.0f},
   {0.21314f, 0.538881f, 0.61037f, 1.0f},
   {0.216136f, 0.542767f, 0.611838f, 1.0f},
   {0.219188f, 0.546652f, 0.613299f, 1.0f},
   {0.222296f, 0.550535f, 0.614753f, 1.0f},
   {0.225461f, 0.554417f, 0.6162f, 1.0f},
   {0.228682f, 0.558297f, 0.617639f, 1.0f},
   {0.231959f, 0.562176f, 0.619072f, 1.0f},
   {0.235293f, 0.566053f, 0.620498f, 1.0f},
   {0.238683f, 0.569928f, 0.621917f, 1.0f},
   {0.242129f, 0.573802f, 0.62333f, 1.0f},
   {0.245633f, 0.577674f, 0.624735f, 1.0f},
   {0.249194f, 0.581544f, 0.626134f, 1.0f},
   {0.252812f, 0.585411f, 0.627526f, 1.0f},
   {0.256489f, 0.589277f, 0.628911f, 1.0f},
   {0.260225f, 0.593141f, 0.630289f, 1.0f},
   {0.26402f, 0.597002f, 0.631661f, 1.0f},
   {0.267876f, 0.60086f, 0.633027f, 1.0f},
   {0.271793f, 0.604715f, 0.634385f, 1.0f},
   {0.275772f, 0.608567f, 0.635738f, 1.0f},
   {0.279814f, 0.612416f, 0.637084f, 1.0f},
   {0.283921f, 0.616261f, 0.638424f, 1.0f},
   {0.288092f, 0.620102f, 0.639758f, 1.0f},
   {0.292331f, 0.623939f, 0.641085f, 1.0f},
   {0.296638f, 0.627771f, 0.642408f, 1.0f},
   {0.301014f, 0.631598f, 0.643724f, 1.0f},
   {0.305461f, 0.635419f, 0.645036f, 1.0f},
   {0.309981f, 0.639234f, 0.646343f, 1.0f},
   {0.314576f, 0.643043f, 0.647645f, 1.0f},
   {0.319247f, 0.646845f, 0.648943f, 1.0f},
   {0.323996f, 0.650639f, 0.650237f, 1.0f},
   {0.328826f, 0.654426f, 0.651529f, 1.0f},
   {0.333738f, 0.658203f, 0.652818f, 1.0f},
   {0.338735f, 0.661971f, 0.654106f, 1.0f},
   {0.343819f, 0.665728f, 0.655393f, 1.0f},
   {0.348992f, 0.669475f, 0.656681f, 1.0f},
   {0.354256f, 0.673209f, 0.65797f, 1.0f},
   {0.359614f, 0.676931f, 0.659262f, 1.0f},
   {0.365068f, 0.680639f, 0.660558f, 1.0f},
   {0.370621f, 0.684332f, 0.661861f, 1.0f},
   {0.376275f, 0.68801f, 0.663171f, 1.0f},
   {0.382031f, 0.691671f, 0.664492f, 1.0f},
   {0.387893f, 0.695314f, 0.665825f, 1.0f},
   {0.393862f, 0.698939f, 0.667173f, 1.0f},
   {0.399939f, 0.702544f, 0.66854f, 1.0f},
   {0.406126f, 0.706127f, 0.669928f, 1.0f},
   {0.412423f, 0.709689f, 0.671341f, 1.0f},
   {0.418832f, 0.713228f, 0.672783f, 1.0f},
   {0.425351f, 0.716743f, 0.674258f, 1.0f},
   {0.43198f, 0.720233f, 0.67577f, 1.0f},
   {0.438718f, 0.723698f, 0.677325f, 1.0f},
   {0.445561f, 0.727137f, 0.678928f, 1.0f},
   {0.452508f, 0.730549f, 0.680584f, 1.0f},
   {0.459553f, 0.733935f, 0.682297f, 1.0f},
   {0.466691f, 0.737294f, 0.684074f, 1.0f},
   {0.473918f, 0.740628f, 0.685919f, 1.0f},
   {0.481225f, 0.743936f, 0.687837f, 1.0f},
   {0.488606f, 0.747219f, 0.689834f, 1.0f},
   {0.496053f, 0.750479f, 0.691913f, 1.0f},
   {0.503557f, 0.753717f, 0.694078f, 1.0f},
   {0.51111f, 0.756934f, 0.696333f, 1.0f},
   {0.518702f, 0.760132f, 0.698679f, 1.0f},
   {0.526326f, 0.763313f, 0.701119f, 1.0f},
   {0.533972f, 0.76648f, 0.703654f, 1.0f},
   {0.541633f, 0.769633f, 0.706284f, 1.0f},
   {0.549302f, 0.772776f, 0.70901f, 1.0f},
   {0.556972f, 0.775909f, 0.71183f, 1.0f},
   {0.564637f, 0.779036f, 0.714743f, 1.0f},
   {0.572291f, 0.782158f, 0.717748f, 1.0f},
   {0.579929f, 0.785277f, 0.720843f, 1.0f},
   {0.587548f, 0.788395f, 0.724025f, 1.0f},
   {0.595145f, 0.791512f, 0.727293f, 1.0f},
   {0.602716f, 0.794632f, 0.730643f, 1.0f},
   {0.610258f, 0.797754f, 0.734073f, 1.0f},
   {0.617772f, 0.800881f, 0.73758f, 1.0f},
   {0.625254f, 0.804013f, 0.741162f, 1.0f},
   {0.632704f, 0.807153f, 0.744815f, 1.0f},
   {0.640122f, 0.810299f, 0.748537f, 1.0f},
   {0.647507f, 0.813455f, 0.752325f, 1.0f},
   {0.654858f, 0.816619f, 0.756177f, 1.0f},
   {0.662177f, 0.819794f, 0.76009f, 1.0f},
   {0.669464f, 0.82298f, 0.764062f, 1.0f},
   {0.676718f, 0.826177f, 0.768091f, 1.0f},
   {0.68394f, 0.829386f, 0.772174f, 1.0f},
   {0.691131f, 0.832607f, 0.776309f, 1.0f},
   {0.698292f, 0.835842f, 0.780494f, 1.0f},
   {0.705423f, 0.839089f, 0.784728f, 1.0f},
   {0.712525f, 0.842351f, 0.789009f, 1.0f},
   {0.719599f, 0.845627f, 0.793334f, 1.0f},
   {0.726646f, 0.848917f, 0.797703f, 1.0f},
   {0.733666f, 0.852223f, 0.802113f, 1.0f},
   {0.74066f, 0.855544f, 0.806563f, 1.0f},
   {0.74763f, 0.85888f, 0.811052f, 1.0f},
   {0.754576f, 0.862232f, 0.815579f, 1.0f},
   {0.761499f, 0.8656f, 0.820142f, 1.0f},
   {0.768399f, 0.868985f, 0.824739f, 1.0f},
   {0.775279f, 0.872386f, 0.829371f, 1.0f},
   {0.782137f, 0.875804f, 0.834035f, 1.0f},
   {0.788975f, 0.87924f, 0.83873f, 1.0f},
   {0.795795f, 0.882692f, 0.843456f, 1.0f},
   {0.802596f, 0.886163f, 0.848212f, 1.0f},
   {0.809379f, 0.889651f, 0.852996f, 1.0f},
   {0.816145f, 0.893157f, 0.857808f, 1.0f},
   {0.822895f, 0.896682f, 0.862646f, 1.0f},
   {0.829629f, 0.900225f, 0.86751f, 1.0f},
   {0.836347f, 0.903787f, 0.872399f, 1.0f},
   {0.843051f, 0.907368f, 0.877312f, 1.0f},
   {0.849741f, 0.910968f, 0.882248f, 1.0f},
   {0.856417f, 0.914588f, 0.887207f, 1.0f},
   {0.86308f, 0.918227f, 0.892187f, 1.0f},
   {0.869731f, 0.921887f, 0.897188f, 1.0f},
   {0.876369f, 0.925567f, 0.902209f, 1.0f},
   {0.882995f, 0.929268f, 0.907248f, 1.0f},
   {0.889609f, 0.932989f, 0.912306f, 1.0f},
   {0.896212f, 0.936732f, 0.917381f, 1.0f},
   {0.902803f, 0.940497f, 0.922471f, 1.0f},
   {0.909383f, 0.944284f, 0.927577f, 1.0f},
   {0.915952f, 0.948093f, 0.932697f, 1.0f},
   {0.92251f, 0.951926f, 0.93783f, 1.0f},
   {0.929056f, 0.955782f, 0.942975f, 1.0f},
   {0.93559f, 0.959662f, 0.94813f, 1.0f},
   {0.942112f, 0.963567f, 0.953295f, 1.0f},
   {0.94862f, 0.967497f, 0.958467f, 1.0f},
   {0.955115f, 0.971454f, 0.963646f, 1.0f},
   {0.961594f, 0.975438f, 0.968831f, 1.0f},
   {0.968055f, 0.979451f, 0.974019f, 1.0f},
   {0.974497f, 0.983494f, 0.97921f, 1.0f},
   {0.980916f, 0.987569f, 0.984403f, 1.0f},
   {0.987309f, 0.991677f, 0.989598f, 1.0f},
   {0.993672f, 0.99582f, 0.994796f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
});

const Palette BPAL_19 = Palette("pastel",
{
   {0.996094f, 0.746094f, 0.746094f, 1.0f},
   {0.996094f, 0.75f, 0.746094f, 1.0f},
   {0.996094f, 0.757812f, 0.746094f, 1.0f},
   {0.996094f, 0.761719f, 0.746094f, 1.0f},
   {0.996094f, 0.769531f, 0.746094f, 1.0f},
   {0.996094f, 0.773438f, 0.746094f, 1.0f},
   {0.996094f, 0.78125f, 0.746094f, 1.0f},
   {0.996094f, 0.785156f, 0.746094f, 1.0f},
   {0.996094f, 0.792969f, 0.746094f, 1.0f},
   {0.996094f, 0.796875f, 0.746094f, 1.0f},
   {0.996094f, 0.804688f, 0.746094f, 1.0f},
   {0.996094f, 0.808594f, 0.746094f, 1.0f},
   {0.996094f, 0.816406f, 0.746094f, 1.0f},
   {0.996094f, 0.820312f, 0.746094f, 1.0f},
   {0.996094f, 0.828125f, 0.746094f, 1.0f},
   {0.996094f, 0.832031f, 0.746094f, 1.0f},
   {0.996094f, 0.839844f, 0.746094f, 1.0f},
   {0.996094f, 0.84375f, 0.746094f, 1.0f},
   {0.996094f, 0.851562f, 0.746094f, 1.0f},
   {0.996094f, 0.855469f, 0.746094f, 1.0f},
   {0.996094f, 0.863281f, 0.746094f, 1.0f},
   {0.996094f, 0.867188f, 0.746094f, 1.0f},
   {0.996094f, 0.875f, 0.746094f, 1.0f},
   {0.996094f, 0.878906f, 0.746094f, 1.0f},
   {0.996094f, 0.886719f, 0.746094f, 1.0f},
   {0.996094f, 0.890625f, 0.746094f, 1.0f},
   {0.996094f, 0.898438f, 0.746094f, 1.0f},
   {0.996094f, 0.902344f, 0.746094f, 1.0f},
   {0.996094f, 0.910156f, 0.746094f, 1.0f},
   {0.996094f, 0.914062f, 0.746094f, 1.0f},
   {0.996094f, 0.921875f, 0.746094f, 1.0f},
   {0.996094f, 0.925781f, 0.746094f, 1.0f},
   {0.996094f, 0.933594f, 0.746094f, 1.0f},
   {0.996094f, 0.9375f, 0.746094f, 1.0f},
   {0.996094f, 0.945312f, 0.746094f, 1.0f},
   {0.996094f, 0.949219f, 0.746094f, 1.0f},
   {0.996094f, 0.957031f, 0.746094f, 1.0f},
   {0.996094f, 0.960938f, 0.746094f, 1.0f},
   {0.996094f, 0.96875f, 0.746094f, 1.0f},
   {0.996094f, 0.972656f, 0.746094f, 1.0f},
   {0.996094f, 0.980469f, 0.746094f, 1.0f},
   {0.996094f, 0.984375f, 0.746094f, 1.0f},
   {0.996094f, 0.992188f, 0.746094f, 1.0f},
   {0.992188f, 0.996094f, 0.746094f, 1.0f},
   {0.984375f, 0.996094f, 0.746094f, 1.0f},
   {0.980469f, 0.996094f, 0.746094f, 1.0f},
   {0.972656f, 0.996094f, 0.746094f, 1.0f},
   {0.96875f, 0.996094f, 0.746094f, 1.0f},
   {0.960938f, 0.996094f, 0.746094f, 1.0f},
   {0.957031f, 0.996094f, 0.746094f, 1.0f},
   {0.949219f, 0.996094f, 0.746094f, 1.0f},
   {0.945312f, 0.996094f, 0.746094f, 1.0f},
   {0.9375f, 0.996094f, 0.746094f, 1.0f},
   {0.933594f, 0.996094f, 0.746094f, 1.0f},
   {0.925781f, 0.996094f, 0.746094f, 1.0f},
   {0.921875f, 0.996094f, 0.746094f, 1.0f},
   {0.914062f, 0.996094f, 0.746094f, 1.0f},
   {0.910156f, 0.996094f, 0.746094f, 1.0f},
   {0.902344f, 0.996094f, 0.746094f, 1.0f},
   {0.898438f, 0.996094f, 0.746094f, 1.0f},
   {0.890625f, 0.996094f, 0.746094f, 1.0f},
   {0.886719f, 0.996094f, 0.746094f, 1.0f},
   {0.878906f, 0.996094f, 0.746094f, 1.0f},
   {0.875f, 0.996094f, 0.746094f, 1.0f},
   {0.867188f, 0.996094f, 0.746094f, 1.0f},
   {0.863281f, 0.996094f, 0.746094f, 1.0f},
   {0.855469f, 0.996094f, 0.746094f, 1.0f},
   {0.851562f, 0.996094f, 0.746094f, 1.0f},
   {0.84375f, 0.996094f, 0.746094f, 1.0f},
   {0.839844f, 0.996094f, 0.746094f, 1.0f},
   {0.832031f, 0.996094f, 0.746094f, 1.0f},
   {0.828125f, 0.996094f, 0.746094f, 1.0f},
   {0.820312f, 0.996094f, 0.746094f, 1.0f},
   {0.816406f, 0.996094f, 0.746094f, 1.0f},
   {0.808594f, 0.996094f, 0.746094f, 1.0f},
   {0.804688f, 0.996094f, 0.746094f, 1.0f},
   {0.796875f, 0.996094f, 0.746094f, 1.0f},
   {0.792969f, 0.996094f, 0.746094f, 1.0f},
   {0.785156f, 0.996094f, 0.746094f, 1.0f},
   {0.78125f, 0.996094f, 0.746094f, 1.0f},
   {0.773438f, 0.996094f, 0.746094f, 1.0f},
   {0.769531f, 0.996094f, 0.746094f, 1.0f},
   {0.761719f, 0.996094f, 0.746094f, 1.0f},
   {0.757812f, 0.996094f, 0.746094f, 1.0f},
   {0.75f, 0.996094f, 0.746094f, 1.0f},
   {0.746094f, 0.996094f, 0.746094f, 1.0f},
   {0.746094f, 0.996094f, 0.75f, 1.0f},
   {0.746094f, 0.996094f, 0.757812f, 1.0f},
   {0.746094f, 0.996094f, 0.761719f, 1.0f},
   {0.746094f, 0.996094f, 0.769531f, 1.0f},
   {0.746094f, 0.996094f, 0.773438f, 1.0f},
   {0.746094f, 0.996094f, 0.78125f, 1.0f},
   {0.746094f, 0.996094f, 0.785156f, 1.0f},
   {0.746094f, 0.996094f, 0.792969f, 1.0f},
   {0.746094f, 0.996094f, 0.796875f, 1.0f},
   {0.746094f, 0.996094f, 0.804688f, 1.0f},
   {0.746094f, 0.996094f, 0.808594f, 1.0f},
   {0.746094f, 0.996094f, 0.816406f, 1.0f},
   {0.746094f, 0.996094f, 0.820312f, 1.0f},
   {0.746094f, 0.996094f, 0.828125f, 1.0f},
   {0.746094f, 0.996094f, 0.832031f, 1.0f},
   {0.746094f, 0.996094f, 0.839844f, 1.0f},
   {0.746094f, 0.996094f, 0.84375f, 1.0f},
   {0.746094f, 0.996094f, 0.851562f, 1.0f},
   {0.746094f, 0.996094f, 0.855469f, 1.0f},
   {0.746094f, 0.996094f, 0.863281f, 1.0f},
   {0.746094f, 0.996094f, 0.867188f, 1.0f},
   {0.746094f, 0.996094f, 0.875f, 1.0f},
   {0.746094f, 0.996094f, 0.878906f, 1.0f},
   {0.746094f, 0.996094f, 0.886719f, 1.0f},
   {0.746094f, 0.996094f, 0.890625f, 1.0f},
   {0.746094f, 0.996094f, 0.898438f, 1.0f},
   {0.746094f, 0.996094f, 0.902344f, 1.0f},
   {0.746094f, 0.996094f, 0.910156f, 1.0f},
   {0.746094f, 0.996094f, 0.914062f, 1.0f},
   {0.746094f, 0.996094f, 0.921875f, 1.0f},
   {0.746094f, 0.996094f, 0.925781f, 1.0f},
   {0.746094f, 0.996094f, 0.933594f, 1.0f},
   {0.746094f, 0.996094f, 0.9375f, 1.0f},
   {0.746094f, 0.996094f, 0.945312f, 1.0f},
   {0.746094f, 0.996094f, 0.949219f, 1.0f},
   {0.746094f, 0.996094f, 0.957031f, 1.0f},
   {0.746094f, 0.996094f, 0.960938f, 1.0f},
   {0.746094f, 0.996094f, 0.96875f, 1.0f},
   {0.746094f, 0.996094f, 0.972656f, 1.0f},
   {0.746094f, 0.996094f, 0.980469f, 1.0f},
   {0.746094f, 0.996094f, 0.984375f, 1.0f},
   {0.746094f, 0.996094f, 0.992188f, 1.0f},
   {0.746094f, 0.992188f, 0.996094f, 1.0f},
   {0.746094f, 0.984375f, 0.996094f, 1.0f},
   {0.746094f, 0.980469f, 0.996094f, 1.0f},
   {0.746094f, 0.972656f, 0.996094f, 1.0f},
   {0.746094f, 0.96875f, 0.996094f, 1.0f},
   {0.746094f, 0.960938f, 0.996094f, 1.0f},
   {0.746094f, 0.957031f, 0.996094f, 1.0f},
   {0.746094f, 0.949219f, 0.996094f, 1.0f},
   {0.746094f, 0.945312f, 0.996094f, 1.0f},
   {0.746094f, 0.9375f, 0.996094f, 1.0f},
   {0.746094f, 0.933594f, 0.996094f, 1.0f},
   {0.746094f, 0.925781f, 0.996094f, 1.0f},
   {0.746094f, 0.921875f, 0.996094f, 1.0f},
   {0.746094f, 0.914062f, 0.996094f, 1.0f},
   {0.746094f, 0.910156f, 0.996094f, 1.0f},
   {0.746094f, 0.902344f, 0.996094f, 1.0f},
   {0.746094f, 0.898438f, 0.996094f, 1.0f},
   {0.746094f, 0.890625f, 0.996094f, 1.0f},
   {0.746094f, 0.886719f, 0.996094f, 1.0f},
   {0.746094f, 0.878906f, 0.996094f, 1.0f},
   {0.746094f, 0.875f, 0.996094f, 1.0f},
   {0.746094f, 0.867188f, 0.996094f, 1.0f},
   {0.746094f, 0.863281f, 0.996094f, 1.0f},
   {0.746094f, 0.855469f, 0.996094f, 1.0f},
   {0.746094f, 0.851562f, 0.996094f, 1.0f},
   {0.746094f, 0.84375f, 0.996094f, 1.0f},
   {0.746094f, 0.839844f, 0.996094f, 1.0f},
   {0.746094f, 0.832031f, 0.996094f, 1.0f},
   {0.746094f, 0.828125f, 0.996094f, 1.0f},
   {0.746094f, 0.820312f, 0.996094f, 1.0f},
   {0.746094f, 0.816406f, 0.996094f, 1.0f},
   {0.746094f, 0.808594f, 0.996094f, 1.0f},
   {0.746094f, 0.804688f, 0.996094f, 1.0f},
   {0.746094f, 0.796875f, 0.996094f, 1.0f},
   {0.746094f, 0.792969f, 0.996094f, 1.0f},
   {0.746094f, 0.785156f, 0.996094f, 1.0f},
   {0.746094f, 0.78125f, 0.996094f, 1.0f},
   {0.746094f, 0.773438f, 0.996094f, 1.0f},
   {0.746094f, 0.769531f, 0.996094f, 1.0f},
   {0.746094f, 0.761719f, 0.996094f, 1.0f},
   {0.746094f, 0.757812f, 0.996094f, 1.0f},
   {0.746094f, 0.75f, 0.996094f, 1.0f},
   {0.746094f, 0.746094f, 0.996094f, 1.0f},
   {0.75f, 0.746094f, 0.996094f, 1.0f},
   {0.757812f, 0.746094f, 0.996094f, 1.0f},
   {0.761719f, 0.746094f, 0.996094f, 1.0f},
   {0.769531f, 0.746094f, 0.996094f, 1.0f},
   {0.773438f, 0.746094f, 0.996094f, 1.0f},
   {0.78125f, 0.746094f, 0.996094f, 1.0f},
   {0.785156f, 0.746094f, 0.996094f, 1.0f},
   {0.792969f, 0.746094f, 0.996094f, 1.0f},
   {0.796875f, 0.746094f, 0.996094f, 1.0f},
   {0.804688f, 0.746094f, 0.996094f, 1.0f},
   {0.808594f, 0.746094f, 0.996094f, 1.0f},
   {0.816406f, 0.746094f, 0.996094f, 1.0f},
   {0.820312f, 0.746094f, 0.996094f, 1.0f},
   {0.828125f, 0.746094f, 0.996094f, 1.0f},
   {0.832031f, 0.746094f, 0.996094f, 1.0f},
   {0.839844f, 0.746094f, 0.996094f, 1.0f},
   {0.84375f, 0.746094f, 0.996094f, 1.0f},
   {0.851562f, 0.746094f, 0.996094f, 1.0f},
   {0.855469f, 0.746094f, 0.996094f, 1.0f},
   {0.863281f, 0.746094f, 0.996094f, 1.0f},
   {0.867188f, 0.746094f, 0.996094f, 1.0f},
   {0.875f, 0.746094f, 0.996094f, 1.0f},
   {0.878906f, 0.746094f, 0.996094f, 1.0f},
   {0.886719f, 0.746094f, 0.996094f, 1.0f},
   {0.890625f, 0.746094f, 0.996094f, 1.0f},
   {0.898438f, 0.746094f, 0.996094f, 1.0f},
   {0.902344f, 0.746094f, 0.996094f, 1.0f},
   {0.910156f, 0.746094f, 0.996094f, 1.0f},
   {0.914062f, 0.746094f, 0.996094f, 1.0f},
   {0.921875f, 0.746094f, 0.996094f, 1.0f},
   {0.925781f, 0.746094f, 0.996094f, 1.0f},
   {0.933594f, 0.746094f, 0.996094f, 1.0f},
   {0.9375f, 0.746094f, 0.996094f, 1.0f},
   {0.945312f, 0.746094f, 0.996094f, 1.0f},
   {0.949219f, 0.746094f, 0.996094f, 1.0f},
   {0.957031f, 0.746094f, 0.996094f, 1.0f},
   {0.960938f, 0.746094f, 0.996094f, 1.0f},
   {0.96875f, 0.746094f, 0.996094f, 1.0f},
   {0.972656f, 0.746094f, 0.996094f, 1.0f},
   {0.980469f, 0.746094f, 0.996094f, 1.0f},
   {0.984375f, 0.746094f, 0.996094f, 1.0f},
   {0.992188f, 0.746094f, 0.996094f, 1.0f},
   {0.996094f, 0.746094f, 0.992188f, 1.0f},
   {0.996094f, 0.746094f, 0.984375f, 1.0f},
   {0.996094f, 0.746094f, 0.980469f, 1.0f},
   {0.996094f, 0.746094f, 0.972656f, 1.0f},
   {0.996094f, 0.746094f, 0.96875f, 1.0f},
   {0.996094f, 0.746094f, 0.960938f, 1.0f},
   {0.996094f, 0.746094f, 0.957031f, 1.0f},
   {0.996094f, 0.746094f, 0.949219f, 1.0f},
   {0.996094f, 0.746094f, 0.945312f, 1.0f},
   {0.996094f, 0.746094f, 0.9375f, 1.0f},
   {0.996094f, 0.746094f, 0.933594f, 1.0f},
   {0.996094f, 0.746094f, 0.925781f, 1.0f},
   {0.996094f, 0.746094f, 0.921875f, 1.0f},
   {0.996094f, 0.746094f, 0.914062f, 1.0f},
   {0.996094f, 0.746094f, 0.910156f, 1.0f},
   {0.996094f, 0.746094f, 0.902344f, 1.0f},
   {0.996094f, 0.746094f, 0.898438f, 1.0f},
   {0.996094f, 0.746094f, 0.890625f, 1.0f},
   {0.996094f, 0.746094f, 0.886719f, 1.0f},
   {0.996094f, 0.746094f, 0.878906f, 1.0f},
   {0.996094f, 0.746094f, 0.875f, 1.0f},
   {0.996094f, 0.746094f, 0.867188f, 1.0f},
   {0.996094f, 0.746094f, 0.863281f, 1.0f},
   {0.996094f, 0.746094f, 0.855469f, 1.0f},
   {0.996094f, 0.746094f, 0.851562f, 1.0f},
   {0.996094f, 0.746094f, 0.84375f, 1.0f},
   {0.996094f, 0.746094f, 0.839844f, 1.0f},
   {0.996094f, 0.746094f, 0.832031f, 1.0f},
   {0.996094f, 0.746094f, 0.828125f, 1.0f},
   {0.996094f, 0.746094f, 0.820312f, 1.0f},
   {0.996094f, 0.746094f, 0.816406f, 1.0f},
   {0.996094f, 0.746094f, 0.808594f, 1.0f},
   {0.996094f, 0.746094f, 0.804688f, 1.0f},
   {0.996094f, 0.746094f, 0.796875f, 1.0f},
   {0.996094f, 0.746094f, 0.792969f, 1.0f},
   {0.996094f, 0.746094f, 0.785156f, 1.0f},
   {0.996094f, 0.746094f, 0.78125f, 1.0f},
   {0.996094f, 0.746094f, 0.773438f, 1.0f},
   {0.996094f, 0.746094f, 0.769531f, 1.0f},
   {0.996094f, 0.746094f, 0.761719f, 1.0f},
   {0.996094f, 0.746094f, 0.757812f, 1.0f},
   {0.996094f, 0.746094f, 0.75f, 1.0f},
   {0.996094f, 0.746094f, 0.746094f, 1.0f},
});

const Palette BPAL_20 = Palette("tropical",
{
   {0.0351562f, 0.15625f, 0.0117188f, 1.0f},
   {0.0351562f, 0.160156f, 0.0117188f, 1.0f},
   {0.03125f, 0.167969f, 0.0117188f, 1.0f},
   {0.03125f, 0.171875f, 0.0117188f, 1.0f},
   {0.03125f, 0.179688f, 0.0117188f, 1.0f},
   {0.03125f, 0.183594f, 0.0117188f, 1.0f},
   {0.0273438f, 0.1875f, 0.0117188f, 1.0f},
   {0.0273438f, 0.195312f, 0.0078125f, 1.0f},
   {0.0273438f, 0.199219f, 0.0078125f, 1.0f},
   {0.0273438f, 0.203125f, 0.0078125f, 1.0f},
   {0.0234375f, 0.210938f, 0.0078125f, 1.0f},
   {0.0234375f, 0.214844f, 0.0078125f, 1.0f},
   {0.0234375f, 0.21875f, 0.0078125f, 1.0f},
   {0.0195312f, 0.226562f, 0.0078125f, 1.0f},
   {0.0195312f, 0.230469f, 0.00390625f, 1.0f},
   {0.0195312f, 0.242188f, 0.00390625f, 1.0f},
   {0.015625f, 0.25f, 0.00390625f, 1.0f},
   {0.015625f, 0.261719f, 0.00390625f, 1.0f},
   {0.0117188f, 0.269531f, 0.0f, 1.0f},
   {0.0117188f, 0.28125f, 0.0f, 1.0f},
   {0.0078125f, 0.289062f, 0.0f, 1.0f},
   {0.0078125f, 0.300781f, 0.0f, 1.0f},
   {0.0078125f, 0.308594f, 0.0f, 1.0f},
   {0.015625f, 0.320312f, 0.00390625f, 1.0f},
   {0.0234375f, 0.328125f, 0.00390625f, 1.0f},
   {0.0273438f, 0.339844f, 0.0078125f, 1.0f},
   {0.0351562f, 0.347656f, 0.0117188f, 1.0f},
   {0.0429688f, 0.359375f, 0.015625f, 1.0f},
   {0.0507812f, 0.367188f, 0.0195312f, 1.0f},
   {0.0546875f, 0.378906f, 0.0195312f, 1.0f},
   {0.0625f, 0.386719f, 0.0234375f, 1.0f},
   {0.0703125f, 0.398438f, 0.0273438f, 1.0f},
   {0.078125f, 0.40625f, 0.03125f, 1.0f},
   {0.0820312f, 0.417969f, 0.0351562f, 1.0f},
   {0.0898438f, 0.425781f, 0.0351562f, 1.0f},
   {0.0976562f, 0.4375f, 0.0390625f, 1.0f},
   {0.105469f, 0.445312f, 0.0429688f, 1.0f},
   {0.109375f, 0.457031f, 0.046875f, 1.0f},
   {0.117188f, 0.464844f, 0.046875f, 1.0f},
   {0.125f, 0.472656f, 0.0507812f, 1.0f},
   {0.128906f, 0.484375f, 0.0546875f, 1.0f},
   {0.136719f, 0.492188f, 0.0585938f, 1.0f},
   {0.144531f, 0.503906f, 0.0625f, 1.0f},
   {0.152344f, 0.511719f, 0.0625f, 1.0f},
   {0.15625f, 0.519531f, 0.0664062f, 1.0f},
   {0.164062f, 0.53125f, 0.0703125f, 1.0f},
   {0.171875f, 0.539062f, 0.0742188f, 1.0f},
   {0.175781f, 0.550781f, 0.0742188f, 1.0f},
   {0.183594f, 0.558594f, 0.078125f, 1.0f},
   {0.191406f, 0.566406f, 0.0820312f, 1.0f},
   {0.214844f, 0.578125f, 0.0859375f, 1.0f},
   {0.25f, 0.585938f, 0.0898438f, 1.0f},
   {0.285156f, 0.59375f, 0.0976562f, 1.0f},
   {0.320312f, 0.601562f, 0.101562f, 1.0f},
   {0.355469f, 0.609375f, 0.105469f, 1.0f},
   {0.394531f, 0.621094f, 0.113281f, 1.0f},
   {0.429688f, 0.628906f, 0.117188f, 1.0f},
   {0.464844f, 0.636719f, 0.121094f, 1.0f},
   {0.5f, 0.644531f, 0.128906f, 1.0f},
   {0.535156f, 0.652344f, 0.132812f, 1.0f},
   {0.570312f, 0.660156f, 0.136719f, 1.0f},
   {0.601562f, 0.667969f, 0.144531f, 1.0f},
   {0.636719f, 0.679688f, 0.148438f, 1.0f},
   {0.667969f, 0.6875f, 0.152344f, 1.0f},
   {0.703125f, 0.695312f, 0.15625f, 1.0f},
   {0.734375f, 0.703125f, 0.164062f, 1.0f},
   {0.769531f, 0.710938f, 0.167969f, 1.0f},
   {0.800781f, 0.71875f, 0.171875f, 1.0f},
   {0.835938f, 0.726562f, 0.175781f, 1.0f},
   {0.867188f, 0.734375f, 0.183594f, 1.0f},
   {0.902344f, 0.742188f, 0.1875f, 1.0f},
   {0.917969f, 0.738281f, 0.1875f, 1.0f},
   {0.921875f, 0.71875f, 0.1875f, 1.0f},
   {0.921875f, 0.703125f, 0.183594f, 1.0f},
   {0.921875f, 0.683594f, 0.183594f, 1.0f},
   {0.921875f, 0.664062f, 0.179688f, 1.0f},
   {0.925781f, 0.648438f, 0.179688f, 1.0f},
   {0.925781f, 0.628906f, 0.175781f, 1.0f},
   {0.925781f, 0.613281f, 0.175781f, 1.0f},
   {0.925781f, 0.59375f, 0.171875f, 1.0f},
   {0.929688f, 0.574219f, 0.167969f, 1.0f},
   {0.929688f, 0.558594f, 0.167969f, 1.0f},
   {0.929688f, 0.539062f, 0.164062f, 1.0f},
   {0.933594f, 0.523438f, 0.164062f, 1.0f},
   {0.933594f, 0.503906f, 0.160156f, 1.0f},
   {0.933594f, 0.484375f, 0.160156f, 1.0f},
   {0.933594f, 0.46875f, 0.15625f, 1.0f},
   {0.9375f, 0.449219f, 0.15625f, 1.0f},
   {0.9375f, 0.433594f, 0.152344f, 1.0f},
   {0.9375f, 0.414062f, 0.152344f, 1.0f},
   {0.9375f, 0.394531f, 0.148438f, 1.0f},
   {0.941406f, 0.378906f, 0.144531f, 1.0f},
   {0.941406f, 0.359375f, 0.144531f, 1.0f},
   {0.941406f, 0.34375f, 0.140625f, 1.0f},
   {0.945312f, 0.324219f, 0.140625f, 1.0f},
   {0.945312f, 0.304688f, 0.136719f, 1.0f},
   {0.945312f, 0.289062f, 0.136719f, 1.0f},
   {0.945312f, 0.269531f, 0.132812f, 1.0f},
   {0.949219f, 0.253906f, 0.132812f, 1.0f},
   {0.949219f, 0.238281f, 0.128906f, 1.0f},
   {0.941406f, 0.238281f, 0.132812f, 1.0f},
   {0.933594f, 0.238281f, 0.132812f, 1.0f},
   {0.925781f, 0.242188f, 0.136719f, 1.0f},
   {0.921875f, 0.242188f, 0.136719f, 1.0f},
   {0.914062f, 0.242188f, 0.136719f, 1.0f},
   {0.90625f, 0.246094f, 0.140625f, 1.0f},
   {0.902344f, 0.246094f, 0.140625f, 1.0f},
   {0.894531f, 0.246094f, 0.144531f, 1.0f},
   {0.886719f, 0.25f, 0.144531f, 1.0f},
   {0.878906f, 0.25f, 0.144531f, 1.0f},
   {0.875f, 0.25f, 0.148438f, 1.0f},
   {0.867188f, 0.253906f, 0.148438f, 1.0f},
   {0.859375f, 0.253906f, 0.152344f, 1.0f},
   {0.855469f, 0.253906f, 0.152344f, 1.0f},
   {0.847656f, 0.257812f, 0.15625f, 1.0f},
   {0.839844f, 0.257812f, 0.15625f, 1.0f},
   {0.832031f, 0.257812f, 0.15625f, 1.0f},
   {0.828125f, 0.261719f, 0.160156f, 1.0f},
   {0.820312f, 0.261719f, 0.160156f, 1.0f},
   {0.8125f, 0.261719f, 0.164062f, 1.0f},
   {0.808594f, 0.261719f, 0.164062f, 1.0f},
   {0.800781f, 0.265625f, 0.167969f, 1.0f},
   {0.792969f, 0.265625f, 0.167969f, 1.0f},
   {0.785156f, 0.265625f, 0.167969f, 1.0f},
   {0.78125f, 0.269531f, 0.171875f, 1.0f},
   {0.773438f, 0.269531f, 0.171875f, 1.0f},
   {0.765625f, 0.269531f, 0.175781f, 1.0f},
   {0.757812f, 0.273438f, 0.175781f, 1.0f},
   {0.753906f, 0.273438f, 0.175781f, 1.0f},
   {0.746094f, 0.273438f, 0.179688f, 1.0f},
   {0.738281f, 0.277344f, 0.179688f, 1.0f},
   {0.722656f, 0.277344f, 0.183594f, 1.0f},
   {0.707031f, 0.28125f, 0.1875f, 1.0f},
   {0.6875f, 0.285156f, 0.195312f, 1.0f},
   {0.667969f, 0.289062f, 0.199219f, 1.0f},
   {0.648438f, 0.292969f, 0.203125f, 1.0f},
   {0.632812f, 0.296875f, 0.207031f, 1.0f},
   {0.613281f, 0.300781f, 0.210938f, 1.0f},
   {0.59375f, 0.304688f, 0.214844f, 1.0f},
   {0.574219f, 0.308594f, 0.222656f, 1.0f},
   {0.558594f, 0.308594f, 0.226562f, 1.0f},
   {0.539062f, 0.3125f, 0.230469f, 1.0f},
   {0.527344f, 0.316406f, 0.242188f, 1.0f},
   {0.523438f, 0.316406f, 0.269531f, 1.0f},
   {0.523438f, 0.3125f, 0.296875f, 1.0f},
   {0.519531f, 0.3125f, 0.324219f, 1.0f},
   {0.515625f, 0.3125f, 0.347656f, 1.0f},
   {0.515625f, 0.3125f, 0.375f, 1.0f},
   {0.511719f, 0.3125f, 0.402344f, 1.0f},
   {0.511719f, 0.308594f, 0.429688f, 1.0f},
   {0.507812f, 0.308594f, 0.457031f, 1.0f},
   {0.507812f, 0.308594f, 0.484375f, 1.0f},
   {0.503906f, 0.308594f, 0.511719f, 1.0f},
   {0.503906f, 0.308594f, 0.539062f, 1.0f},
   {0.5f, 0.304688f, 0.5625f, 1.0f},
   {0.5f, 0.304688f, 0.589844f, 1.0f},
   {0.496094f, 0.304688f, 0.617188f, 1.0f},
   {0.496094f, 0.304688f, 0.644531f, 1.0f},
   {0.492188f, 0.300781f, 0.671875f, 1.0f},
   {0.492188f, 0.300781f, 0.699219f, 1.0f},
   {0.488281f, 0.300781f, 0.726562f, 1.0f},
   {0.488281f, 0.300781f, 0.753906f, 1.0f},
   {0.484375f, 0.300781f, 0.777344f, 1.0f},
   {0.484375f, 0.296875f, 0.804688f, 1.0f},
   {0.480469f, 0.296875f, 0.832031f, 1.0f},
   {0.480469f, 0.296875f, 0.859375f, 1.0f},
   {0.476562f, 0.296875f, 0.886719f, 1.0f},
   {0.476562f, 0.296875f, 0.914062f, 1.0f},
   {0.472656f, 0.292969f, 0.941406f, 1.0f},
   {0.472656f, 0.292969f, 0.96875f, 1.0f},
   {0.46875f, 0.292969f, 0.992188f, 1.0f},
   {0.472656f, 0.304688f, 0.992188f, 1.0f},
   {0.476562f, 0.320312f, 0.992188f, 1.0f},
   {0.476562f, 0.332031f, 0.992188f, 1.0f},
   {0.480469f, 0.34375f, 0.992188f, 1.0f},
   {0.484375f, 0.355469f, 0.992188f, 1.0f},
   {0.488281f, 0.371094f, 0.988281f, 1.0f},
   {0.492188f, 0.382812f, 0.988281f, 1.0f},
   {0.492188f, 0.394531f, 0.988281f, 1.0f},
   {0.496094f, 0.410156f, 0.988281f, 1.0f},
   {0.5f, 0.421875f, 0.988281f, 1.0f},
   {0.503906f, 0.433594f, 0.984375f, 1.0f},
   {0.507812f, 0.449219f, 0.984375f, 1.0f},
   {0.511719f, 0.460938f, 0.984375f, 1.0f},
   {0.511719f, 0.472656f, 0.984375f, 1.0f},
   {0.515625f, 0.488281f, 0.984375f, 1.0f},
   {0.519531f, 0.5f, 0.980469f, 1.0f},
   {0.523438f, 0.511719f, 0.980469f, 1.0f},
   {0.527344f, 0.527344f, 0.980469f, 1.0f},
   {0.527344f, 0.539062f, 0.980469f, 1.0f},
   {0.53125f, 0.550781f, 0.980469f, 1.0f},
   {0.535156f, 0.5625f, 0.976562f, 1.0f},
   {0.539062f, 0.578125f, 0.976562f, 1.0f},
   {0.542969f, 0.589844f, 0.976562f, 1.0f},
   {0.542969f, 0.601562f, 0.976562f, 1.0f},
   {0.546875f, 0.617188f, 0.976562f, 1.0f},
   {0.550781f, 0.628906f, 0.972656f, 1.0f},
   {0.554688f, 0.640625f, 0.972656f, 1.0f},
   {0.558594f, 0.667969f, 0.972656f, 1.0f},
   {0.566406f, 0.691406f, 0.96875f, 1.0f},
   {0.574219f, 0.71875f, 0.96875f, 1.0f},
   {0.578125f, 0.742188f, 0.96875f, 1.0f},
   {0.585938f, 0.769531f, 0.964844f, 1.0f},
   {0.589844f, 0.796875f, 0.964844f, 1.0f},
   {0.597656f, 0.820312f, 0.960938f, 1.0f},
   {0.605469f, 0.847656f, 0.960938f, 1.0f},
   {0.609375f, 0.871094f, 0.960938f, 1.0f},
   {0.617188f, 0.898438f, 0.957031f, 1.0f},
   {0.621094f, 0.925781f, 0.957031f, 1.0f},
   {0.628906f, 0.949219f, 0.953125f, 1.0f},
   {0.636719f, 0.976562f, 0.953125f, 1.0f},
   {0.636719f, 0.992188f, 0.941406f, 1.0f},
   {0.625f, 0.984375f, 0.910156f, 1.0f},
   {0.613281f, 0.980469f, 0.875f, 1.0f},
   {0.601562f, 0.972656f, 0.84375f, 1.0f},
   {0.589844f, 0.96875f, 0.808594f, 1.0f},
   {0.578125f, 0.960938f, 0.777344f, 1.0f},
   {0.566406f, 0.953125f, 0.746094f, 1.0f},
   {0.554688f, 0.949219f, 0.710938f, 1.0f},
   {0.542969f, 0.941406f, 0.679688f, 1.0f},
   {0.535156f, 0.933594f, 0.644531f, 1.0f},
   {0.519531f, 0.929688f, 0.609375f, 1.0f},
   {0.496094f, 0.914062f, 0.539062f, 1.0f},
   {0.472656f, 0.902344f, 0.464844f, 1.0f},
   {0.445312f, 0.886719f, 0.394531f, 1.0f},
   {0.421875f, 0.875f, 0.320312f, 1.0f},
   {0.40625f, 0.863281f, 0.273438f, 1.0f},
   {0.40625f, 0.859375f, 0.269531f, 1.0f},
   {0.402344f, 0.851562f, 0.265625f, 1.0f},
   {0.402344f, 0.84375f, 0.261719f, 1.0f},
   {0.402344f, 0.835938f, 0.253906f, 1.0f},
   {0.402344f, 0.828125f, 0.246094f, 1.0f},
   {0.398438f, 0.816406f, 0.238281f, 1.0f},
   {0.398438f, 0.804688f, 0.230469f, 1.0f},
   {0.398438f, 0.796875f, 0.222656f, 1.0f},
   {0.394531f, 0.785156f, 0.214844f, 1.0f},
   {0.394531f, 0.773438f, 0.207031f, 1.0f},
   {0.390625f, 0.761719f, 0.195312f, 1.0f},
   {0.390625f, 0.75f, 0.1875f, 1.0f},
   {0.390625f, 0.734375f, 0.179688f, 1.0f},
   {0.386719f, 0.722656f, 0.167969f, 1.0f},
   {0.386719f, 0.710938f, 0.160156f, 1.0f},
   {0.382812f, 0.695312f, 0.148438f, 1.0f},
   {0.382812f, 0.679688f, 0.136719f, 1.0f},
   {0.382812f, 0.667969f, 0.125f, 1.0f},
   {0.378906f, 0.652344f, 0.117188f, 1.0f},
   {0.378906f, 0.636719f, 0.105469f, 1.0f},
   {0.375f, 0.625f, 0.09375f, 1.0f},
   {0.375f, 0.609375f, 0.0820312f, 1.0f},
   {0.371094f, 0.59375f, 0.0703125f, 1.0f},
   {0.371094f, 0.578125f, 0.0585938f, 1.0f},
   {0.367188f, 0.5625f, 0.046875f, 1.0f},
   {0.367188f, 0.546875f, 0.0351562f, 1.0f},
   {0.363281f, 0.527344f, 0.0234375f, 1.0f},
   {0.363281f, 0.511719f, 0.0117188f, 1.0f},
   {0.359375f, 0.496094f, 0.0f, 1.0f},
});

const Palette BPAL_21 = Palette("wood",
{
   {0.996094f, 0.695312f, 0.398438f, 1.0f},
   {0.980469f, 0.675781f, 0.367188f, 1.0f},
   {0.976562f, 0.667969f, 0.359375f, 1.0f},
   {0.972656f, 0.660156f, 0.351562f, 1.0f},
   {0.96875f, 0.65625f, 0.34375f, 1.0f},
   {0.964844f, 0.652344f, 0.335938f, 1.0f},
   {0.960938f, 0.648438f, 0.332031f, 1.0f},
   {0.960938f, 0.644531f, 0.328125f, 1.0f},
   {0.957031f, 0.640625f, 0.324219f, 1.0f},
   {0.957031f, 0.636719f, 0.320312f, 1.0f},
   {0.953125f, 0.636719f, 0.316406f, 1.0f},
   {0.953125f, 0.632812f, 0.3125f, 1.0f},
   {0.953125f, 0.628906f, 0.308594f, 1.0f},
   {0.949219f, 0.628906f, 0.308594f, 1.0f},
   {0.949219f, 0.625f, 0.304688f, 1.0f},
   {0.949219f, 0.625f, 0.304688f, 1.0f},
   {0.945312f, 0.625f, 0.300781f, 1.0f},
   {0.945312f, 0.621094f, 0.296875f, 1.0f},
   {0.945312f, 0.621094f, 0.296875f, 1.0f},
   {0.945312f, 0.621094f, 0.296875f, 1.0f},
   {0.941406f, 0.617188f, 0.292969f, 1.0f},
   {0.941406f, 0.617188f, 0.292969f, 1.0f},
   {0.941406f, 0.617188f, 0.292969f, 1.0f},
   {0.941406f, 0.617188f, 0.289062f, 1.0f},
   {0.941406f, 0.613281f, 0.289062f, 1.0f},
   {0.941406f, 0.613281f, 0.289062f, 1.0f},
   {0.941406f, 0.613281f, 0.289062f, 1.0f},
   {0.941406f, 0.613281f, 0.289062f, 1.0f},
   {0.941406f, 0.613281f, 0.285156f, 1.0f},
   {0.9375f, 0.613281f, 0.285156f, 1.0f},
   {0.9375f, 0.613281f, 0.285156f, 1.0f},
   {0.9375f, 0.613281f, 0.285156f, 1.0f},
   {0.804688f, 0.523438f, 0.242188f, 1.0f},
   {0.828125f, 0.535156f, 0.246094f, 1.0f},
   {0.839844f, 0.542969f, 0.246094f, 1.0f},
   {0.851562f, 0.546875f, 0.246094f, 1.0f},
   {0.859375f, 0.554688f, 0.246094f, 1.0f},
   {0.863281f, 0.554688f, 0.25f, 1.0f},
   {0.871094f, 0.558594f, 0.25f, 1.0f},
   {0.875f, 0.5625f, 0.25f, 1.0f},
   {0.878906f, 0.566406f, 0.25f, 1.0f},
   {0.886719f, 0.566406f, 0.25f, 1.0f},
   {0.890625f, 0.570312f, 0.25f, 1.0f},
   {0.890625f, 0.570312f, 0.25f, 1.0f},
   {0.894531f, 0.574219f, 0.25f, 1.0f},
   {0.898438f, 0.574219f, 0.25f, 1.0f},
   {0.902344f, 0.578125f, 0.253906f, 1.0f},
   {0.902344f, 0.578125f, 0.253906f, 1.0f},
   {0.90625f, 0.578125f, 0.253906f, 1.0f},
   {0.910156f, 0.582031f, 0.253906f, 1.0f},
   {0.910156f, 0.582031f, 0.253906f, 1.0f},
   {0.914062f, 0.582031f, 0.253906f, 1.0f},
   {0.914062f, 0.582031f, 0.253906f, 1.0f},
   {0.914062f, 0.585938f, 0.253906f, 1.0f},
   {0.917969f, 0.585938f, 0.253906f, 1.0f},
   {0.917969f, 0.585938f, 0.253906f, 1.0f},
   {0.917969f, 0.585938f, 0.253906f, 1.0f},
   {0.921875f, 0.585938f, 0.253906f, 1.0f},
   {0.921875f, 0.585938f, 0.253906f, 1.0f},
   {0.921875f, 0.585938f, 0.253906f, 1.0f},
   {0.921875f, 0.589844f, 0.253906f, 1.0f},
   {0.921875f, 0.589844f, 0.253906f, 1.0f},
   {0.921875f, 0.589844f, 0.253906f, 1.0f},
   {0.921875f, 0.589844f, 0.253906f, 1.0f},
   {0.828125f, 0.527344f, 0.226562f, 1.0f},
   {0.84375f, 0.535156f, 0.230469f, 1.0f},
   {0.851562f, 0.542969f, 0.230469f, 1.0f},
   {0.859375f, 0.546875f, 0.230469f, 1.0f},
   {0.867188f, 0.550781f, 0.230469f, 1.0f},
   {0.871094f, 0.550781f, 0.234375f, 1.0f},
   {0.875f, 0.554688f, 0.234375f, 1.0f},
   {0.878906f, 0.558594f, 0.234375f, 1.0f},
   {0.882812f, 0.558594f, 0.234375f, 1.0f},
   {0.886719f, 0.5625f, 0.234375f, 1.0f},
   {0.890625f, 0.5625f, 0.234375f, 1.0f},
   {0.890625f, 0.566406f, 0.238281f, 1.0f},
   {0.894531f, 0.566406f, 0.238281f, 1.0f},
   {0.898438f, 0.566406f, 0.238281f, 1.0f},
   {0.898438f, 0.570312f, 0.238281f, 1.0f},
   {0.902344f, 0.570312f, 0.238281f, 1.0f},
   {0.902344f, 0.570312f, 0.238281f, 1.0f},
   {0.90625f, 0.570312f, 0.238281f, 1.0f},
   {0.90625f, 0.574219f, 0.238281f, 1.0f},
   {0.910156f, 0.574219f, 0.238281f, 1.0f},
   {0.910156f, 0.574219f, 0.238281f, 1.0f},
   {0.910156f, 0.574219f, 0.238281f, 1.0f},
   {0.910156f, 0.574219f, 0.238281f, 1.0f},
   {0.914062f, 0.578125f, 0.238281f, 1.0f},
   {0.914062f, 0.578125f, 0.238281f, 1.0f},
   {0.914062f, 0.578125f, 0.238281f, 1.0f},
   {0.914062f, 0.578125f, 0.242188f, 1.0f},
   {0.914062f, 0.578125f, 0.242188f, 1.0f},
   {0.914062f, 0.578125f, 0.242188f, 1.0f},
   {0.917969f, 0.578125f, 0.242188f, 1.0f},
   {0.917969f, 0.578125f, 0.242188f, 1.0f},
   {0.917969f, 0.578125f, 0.242188f, 1.0f},
   {0.789062f, 0.496094f, 0.207031f, 1.0f},
   {0.808594f, 0.507812f, 0.210938f, 1.0f},
   {0.820312f, 0.519531f, 0.214844f, 1.0f},
   {0.832031f, 0.523438f, 0.214844f, 1.0f},
   {0.839844f, 0.53125f, 0.21875f, 1.0f},
   {0.847656f, 0.535156f, 0.21875f, 1.0f},
   {0.855469f, 0.539062f, 0.222656f, 1.0f},
   {0.859375f, 0.542969f, 0.222656f, 1.0f},
   {0.867188f, 0.546875f, 0.226562f, 1.0f},
   {0.871094f, 0.546875f, 0.226562f, 1.0f},
   {0.875f, 0.550781f, 0.226562f, 1.0f},
   {0.878906f, 0.554688f, 0.226562f, 1.0f},
   {0.882812f, 0.554688f, 0.230469f, 1.0f},
   {0.886719f, 0.558594f, 0.230469f, 1.0f},
   {0.890625f, 0.558594f, 0.230469f, 1.0f},
   {0.894531f, 0.5625f, 0.230469f, 1.0f},
   {0.894531f, 0.5625f, 0.230469f, 1.0f},
   {0.898438f, 0.566406f, 0.230469f, 1.0f},
   {0.898438f, 0.566406f, 0.234375f, 1.0f},
   {0.902344f, 0.566406f, 0.234375f, 1.0f},
   {0.90625f, 0.570312f, 0.234375f, 1.0f},
   {0.90625f, 0.570312f, 0.234375f, 1.0f},
   {0.90625f, 0.570312f, 0.234375f, 1.0f},
   {0.910156f, 0.570312f, 0.234375f, 1.0f},
   {0.910156f, 0.574219f, 0.234375f, 1.0f},
   {0.910156f, 0.574219f, 0.234375f, 1.0f},
   {0.914062f, 0.574219f, 0.234375f, 1.0f},
   {0.914062f, 0.574219f, 0.234375f, 1.0f},
   {0.914062f, 0.574219f, 0.234375f, 1.0f},
   {0.914062f, 0.574219f, 0.234375f, 1.0f},
   {0.914062f, 0.574219f, 0.234375f, 1.0f},
   {0.914062f, 0.574219f, 0.234375f, 1.0f},
   {0.773438f, 0.488281f, 0.199219f, 1.0f},
   {0.773438f, 0.488281f, 0.199219f, 1.0f},
   {0.773438f, 0.488281f, 0.199219f, 1.0f},
   {0.777344f, 0.488281f, 0.199219f, 1.0f},
   {0.777344f, 0.488281f, 0.199219f, 1.0f},
   {0.777344f, 0.488281f, 0.199219f, 1.0f},
   {0.777344f, 0.488281f, 0.199219f, 1.0f},
   {0.777344f, 0.488281f, 0.199219f, 1.0f},
   {0.78125f, 0.492188f, 0.203125f, 1.0f},
   {0.78125f, 0.492188f, 0.203125f, 1.0f},
   {0.78125f, 0.492188f, 0.203125f, 1.0f},
   {0.785156f, 0.492188f, 0.203125f, 1.0f},
   {0.785156f, 0.492188f, 0.203125f, 1.0f},
   {0.785156f, 0.496094f, 0.203125f, 1.0f},
   {0.789062f, 0.496094f, 0.203125f, 1.0f},
   {0.789062f, 0.496094f, 0.203125f, 1.0f},
   {0.792969f, 0.5f, 0.203125f, 1.0f},
   {0.796875f, 0.5f, 0.207031f, 1.0f},
   {0.796875f, 0.5f, 0.207031f, 1.0f},
   {0.800781f, 0.503906f, 0.207031f, 1.0f},
   {0.804688f, 0.503906f, 0.207031f, 1.0f},
   {0.808594f, 0.507812f, 0.207031f, 1.0f},
   {0.8125f, 0.511719f, 0.210938f, 1.0f},
   {0.816406f, 0.511719f, 0.210938f, 1.0f},
   {0.820312f, 0.515625f, 0.210938f, 1.0f},
   {0.824219f, 0.519531f, 0.210938f, 1.0f},
   {0.828125f, 0.523438f, 0.214844f, 1.0f},
   {0.835938f, 0.527344f, 0.214844f, 1.0f},
   {0.84375f, 0.53125f, 0.21875f, 1.0f},
   {0.851562f, 0.535156f, 0.21875f, 1.0f},
   {0.863281f, 0.542969f, 0.222656f, 1.0f},
   {0.878906f, 0.554688f, 0.226562f, 1.0f},
   {0.804688f, 0.507812f, 0.207031f, 1.0f},
   {0.804688f, 0.507812f, 0.207031f, 1.0f},
   {0.804688f, 0.507812f, 0.207031f, 1.0f},
   {0.804688f, 0.507812f, 0.207031f, 1.0f},
   {0.804688f, 0.507812f, 0.207031f, 1.0f},
   {0.804688f, 0.507812f, 0.207031f, 1.0f},
   {0.804688f, 0.507812f, 0.207031f, 1.0f},
   {0.804688f, 0.507812f, 0.207031f, 1.0f},
   {0.804688f, 0.507812f, 0.207031f, 1.0f},
   {0.808594f, 0.507812f, 0.207031f, 1.0f},
   {0.808594f, 0.507812f, 0.207031f, 1.0f},
   {0.808594f, 0.507812f, 0.207031f, 1.0f},
   {0.808594f, 0.507812f, 0.207031f, 1.0f},
   {0.808594f, 0.507812f, 0.207031f, 1.0f},
   {0.808594f, 0.507812f, 0.210938f, 1.0f},
   {0.808594f, 0.507812f, 0.210938f, 1.0f},
   {0.8125f, 0.511719f, 0.210938f, 1.0f},
   {0.8125f, 0.511719f, 0.210938f, 1.0f},
   {0.8125f, 0.511719f, 0.210938f, 1.0f},
   {0.8125f, 0.511719f, 0.210938f, 1.0f},
   {0.8125f, 0.511719f, 0.210938f, 1.0f},
   {0.816406f, 0.511719f, 0.210938f, 1.0f},
   {0.816406f, 0.515625f, 0.210938f, 1.0f},
   {0.816406f, 0.515625f, 0.210938f, 1.0f},
   {0.820312f, 0.515625f, 0.210938f, 1.0f},
   {0.820312f, 0.515625f, 0.210938f, 1.0f},
   {0.824219f, 0.519531f, 0.210938f, 1.0f},
   {0.824219f, 0.519531f, 0.214844f, 1.0f},
   {0.828125f, 0.519531f, 0.214844f, 1.0f},
   {0.832031f, 0.523438f, 0.214844f, 1.0f},
   {0.832031f, 0.523438f, 0.214844f, 1.0f},
   {0.839844f, 0.527344f, 0.21875f, 1.0f},
   {0.753906f, 0.476562f, 0.195312f, 1.0f},
   {0.753906f, 0.476562f, 0.195312f, 1.0f},
   {0.753906f, 0.476562f, 0.195312f, 1.0f},
   {0.753906f, 0.476562f, 0.195312f, 1.0f},
   {0.753906f, 0.476562f, 0.195312f, 1.0f},
   {0.753906f, 0.472656f, 0.195312f, 1.0f},
   {0.753906f, 0.472656f, 0.195312f, 1.0f},
   {0.753906f, 0.472656f, 0.195312f, 1.0f},
   {0.753906f, 0.472656f, 0.195312f, 1.0f},
   {0.753906f, 0.472656f, 0.195312f, 1.0f},
   {0.753906f, 0.472656f, 0.195312f, 1.0f},
   {0.75f, 0.472656f, 0.195312f, 1.0f},
   {0.75f, 0.472656f, 0.195312f, 1.0f},
   {0.75f, 0.472656f, 0.195312f, 1.0f},
   {0.75f, 0.472656f, 0.195312f, 1.0f},
   {0.75f, 0.472656f, 0.191406f, 1.0f},
   {0.746094f, 0.46875f, 0.191406f, 1.0f},
   {0.746094f, 0.46875f, 0.191406f, 1.0f},
   {0.746094f, 0.46875f, 0.191406f, 1.0f},
   {0.742188f, 0.46875f, 0.191406f, 1.0f},
   {0.742188f, 0.46875f, 0.191406f, 1.0f},
   {0.742188f, 0.464844f, 0.191406f, 1.0f},
   {0.738281f, 0.464844f, 0.191406f, 1.0f},
   {0.738281f, 0.464844f, 0.191406f, 1.0f},
   {0.734375f, 0.464844f, 0.191406f, 1.0f},
   {0.734375f, 0.460938f, 0.1875f, 1.0f},
   {0.730469f, 0.460938f, 0.1875f, 1.0f},
   {0.730469f, 0.457031f, 0.1875f, 1.0f},
   {0.726562f, 0.457031f, 0.1875f, 1.0f},
   {0.722656f, 0.453125f, 0.1875f, 1.0f},
   {0.71875f, 0.453125f, 0.183594f, 1.0f},
   {0.707031f, 0.445312f, 0.183594f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
   {0.617188f, 0.386719f, 0.160156f, 1.0f},
});

const Palette BPAL_22 = Palette("mars",
{
   {0.0f, 0.0f, 0.0f, 1.0f},
   {0.0f, 0.0f, 0.0f, 1.0f},
   {0.0f, 0.0f, 0.0f, 1.0f},
   {0.00392157f, 0.0f, 0.00392157f, 1.0f},
   {0.0156863f, 0.00784314f, 0.0156863f, 1.0f},
   {0.027451f, 0.0156863f, 0.027451f, 1.0f},
   {0.0392157f, 0.027451f, 0.0392157f, 1.0f},
   {0.054902f, 0.0313725f, 0.054902f, 1.0f},
   {0.0862745f, 0.054902f, 0.0941176f, 1.0f},
   {0.137255f, 0.105882f, 0.168627f, 1.0f},
   {0.196078f, 0.14902f, 0.243137f, 1.0f},
   {0.25098f, 0.196078f, 0.317647f, 1.0f},
   {0.305882f, 0.243137f, 0.396078f, 1.0f},
   {0.329412f, 0.270588f, 0.45098f, 1.0f},
   {0.32549f, 0.278431f, 0.486275f, 1.0f},
   {0.32549f, 0.290196f, 0.529412f, 1.0f},
   {0.313725f, 0.294118f, 0.564706f, 1.0f},
   {0.309804f, 0.301961f, 0.6f, 1.0f},
   {0.305882f, 0.321569f, 0.631373f, 1.0f},
   {0.298039f, 0.352941f, 0.658824f, 1.0f},
   {0.294118f, 0.392157f, 0.686275f, 1.0f},
   {0.286275f, 0.419608f, 0.709804f, 1.0f},
   {0.278431f, 0.45098f, 0.729412f, 1.0f},
   {0.266667f, 0.486275f, 0.752941f, 1.0f},
   {0.258824f, 0.52549f, 0.788235f, 1.0f},
   {0.243137f, 0.560784f, 0.807843f, 1.0f},
   {0.231373f, 0.592157f, 0.835294f, 1.0f},
   {0.223529f, 0.631373f, 0.858824f, 1.0f},
   {0.211765f, 0.670588f, 0.839216f, 1.0f},
   {0.211765f, 0.717647f, 0.772549f, 1.0f},
   {0.211765f, 0.760784f, 0.709804f, 1.0f},
   {0.211765f, 0.807843f, 0.643137f, 1.0f},
   {0.211765f, 0.85098f, 0.572549f, 1.0f},
   {0.211765f, 0.870588f, 0.513725f, 1.0f},
   {0.211765f, 0.87451f, 0.458824f, 1.0f},
   {0.211765f, 0.870588f, 0.407843f, 1.0f},
   {0.211765f, 0.87451f, 0.345098f, 1.0f},
   {0.211765f, 0.870588f, 0.290196f, 1.0f},
   {0.235294f, 0.870588f, 0.254902f, 1.0f},
   {0.27451f, 0.87451f, 0.247059f, 1.0f},
   {0.317647f, 0.870588f, 0.239216f, 1.0f},
   {0.364706f, 0.87451f, 0.227451f, 1.0f},
   {0.4f, 0.870588f, 0.219608f, 1.0f},
   {0.466667f, 0.870588f, 0.196078f, 1.0f},
   {0.564706f, 0.87451f, 0.160784f, 1.0f},
   {0.647059f, 0.870588f, 0.129412f, 1.0f},
   {0.737255f, 0.87451f, 0.0941176f, 1.0f},
   {0.827451f, 0.870588f, 0.0588235f, 1.0f},
   {0.870588f, 0.854902f, 0.0470588f, 1.0f},
   {0.87451f, 0.811765f, 0.0588235f, 1.0f},
   {0.870588f, 0.776471f, 0.0745098f, 1.0f},
   {0.87451f, 0.737255f, 0.0823529f, 1.0f},
   {0.870588f, 0.698039f, 0.0941176f, 1.0f},
   {0.878431f, 0.666667f, 0.113725f, 1.0f},
   {0.890196f, 0.631373f, 0.137255f, 1.0f},
   {0.905882f, 0.603922f, 0.168627f, 1.0f},
   {0.917647f, 0.568627f, 0.188235f, 1.0f},
   {0.92549f, 0.541176f, 0.211765f, 1.0f},
   {0.933333f, 0.501961f, 0.223529f, 1.0f},
   {0.933333f, 0.454902f, 0.211765f, 1.0f},
   {0.941176f, 0.407843f, 0.2f, 1.0f},
   {0.933333f, 0.364706f, 0.188235f, 1.0f},
   {0.933333f, 0.317647f, 0.176471f, 1.0f},
   {0.933333f, 0.298039f, 0.196078f, 1.0f},
   {0.933333f, 0.309804f, 0.239216f, 1.0f},
   {0.941176f, 0.317647f, 0.278431f, 1.0f},
   {0.933333f, 0.329412f, 0.32549f, 1.0f},
   {0.933333f, 0.341176f, 0.372549f, 1.0f},
   {0.921569f, 0.352941f, 0.4f, 1.0f},
   {0.894118f, 0.360784f, 0.411765f, 1.0f},
   {0.87451f, 0.372549f, 0.431373f, 1.0f},
   {0.843137f, 0.380392f, 0.447059f, 1.0f},
   {0.823529f, 0.396078f, 0.462745f, 1.0f},
   {0.803922f, 0.396078f, 0.454902f, 1.0f},
   {0.788235f, 0.388235f, 0.439216f, 1.0f},
   {0.776471f, 0.384314f, 0.419608f, 1.0f},
   {0.764706f, 0.380392f, 0.4f, 1.0f},
   {0.74902f, 0.372549f, 0.376471f, 1.0f},
   {0.729412f, 0.372549f, 0.360784f, 1.0f},
   {0.709804f, 0.384314f, 0.352941f, 1.0f},
   {0.686275f, 0.388235f, 0.341176f, 1.0f},
   {0.658824f, 0.396078f, 0.32549f, 1.0f},
   {0.631373f, 0.4f, 0.309804f, 1.0f},
   {0.615686f, 0.411765f, 0.305882f, 1.0f},
   {0.6f, 0.419608f, 0.309804f, 1.0f},
   {0.592157f, 0.427451f, 0.313725f, 1.0f},
   {0.576471f, 0.439216f, 0.309804f, 1.0f},
   {0.560784f, 0.447059f, 0.309804f, 1.0f},
   {0.545098f, 0.447059f, 0.309804f, 1.0f},
   {0.537255f, 0.435294f, 0.309804f, 1.0f},
   {0.52549f, 0.423529f, 0.313725f, 1.0f},
   {0.509804f, 0.411765f, 0.309804f, 1.0f},
   {0.501961f, 0.407843f, 0.305882f, 1.0f},
   {0.490196f, 0.396078f, 0.309804f, 1.0f},
   {0.478431f, 0.388235f, 0.313725f, 1.0f},
   {0.470588f, 0.388235f, 0.321569f, 1.0f},
   {0.458824f, 0.384314f, 0.32549f, 1.0f},
   {0.447059f, 0.380392f, 0.329412f, 1.0f},
   {0.447059f, 0.380392f, 0.341176f, 1.0f},
   {0.458824f, 0.392157f, 0.352941f, 1.0f},
   {0.470588f, 0.4f, 0.364706f, 1.0f},
   {0.478431f, 0.407843f, 0.376471f, 1.0f},
   {0.490196f, 0.415686f, 0.396078f, 1.0f},
   {0.498039f, 0.427451f, 0.407843f, 1.0f},
   {0.505882f, 0.439216f, 0.419608f, 1.0f},
   {0.521569f, 0.45098f, 0.439216f, 1.0f},
   {0.52549f, 0.458824f, 0.45098f, 1.0f},
   {0.533333f, 0.470588f, 0.470588f, 1.0f},
   {0.545098f, 0.486275f, 0.486275f, 1.0f},
   {0.556863f, 0.498039f, 0.498039f, 1.0f},
   {0.568627f, 0.517647f, 0.517647f, 1.0f},
   {0.576471f, 0.533333f, 0.533333f, 1.0f},
   {0.588235f, 0.545098f, 0.545098f, 1.0f},
   {0.596078f, 0.560784f, 0.560784f, 1.0f},
   {0.603922f, 0.580392f, 0.580392f, 1.0f},
   {0.615686f, 0.6f, 0.6f, 1.0f},
   {0.627451f, 0.615686f, 0.615686f, 1.0f},
   {0.635294f, 0.635294f, 0.635294f, 1.0f},
   {0.647059f, 0.647059f, 0.647059f, 1.0f},
   {0.658824f, 0.658824f, 0.658824f, 1.0f},
   {0.666667f, 0.666667f, 0.666667f, 1.0f},
   {0.67451f, 0.67451f, 0.67451f, 1.0f},
   {0.686275f, 0.686275f, 0.686275f, 1.0f},
   {0.698039f, 0.698039f, 0.698039f, 1.0f},
   {0.709804f, 0.709804f, 0.709804f, 1.0f},
   {0.717647f, 0.717647f, 0.717647f, 1.0f},
   {0.733333f, 0.733333f, 0.733333f, 1.0f},
   {0.737255f, 0.737255f, 0.737255f, 1.0f},
   {0.74902f, 0.74902f, 0.74902f, 1.0f},
   {0.760784f, 0.760784f, 0.760784f, 1.0f},
   {0.768627f, 0.768627f, 0.768627f, 1.0f},
   {0.776471f, 0.776471f, 0.776471f, 1.0f},
   {0.788235f, 0.788235f, 0.788235f, 1.0f},
   {0.8f, 0.8f, 0.8f, 1.0f},
   {0.803922f, 0.803922f, 0.803922f, 1.0f},
   {0.815686f, 0.815686f, 0.815686f, 1.0f},
   {0.827451f, 0.827451f, 0.827451f, 1.0f},
   {0.839216f, 0.839216f, 0.839216f, 1.0f},
   {0.847059f, 0.847059f, 0.847059f, 1.0f},
   {0.858824f, 0.858824f, 0.858824f, 1.0f},
   {0.866667f, 0.866667f, 0.866667f, 1.0f},
   {0.878431f, 0.878431f, 0.878431f, 1.0f},
   {0.890196f, 0.890196f, 0.890196f, 1.0f},
   {0.901961f, 0.901961f, 0.901961f, 1.0f},
   {0.909804f, 0.909804f, 0.909804f, 1.0f},
   {0.921569f, 0.921569f, 0.921569f, 1.0f},
   {0.933333f, 0.933333f, 0.933333f, 1.0f},
   {0.941176f, 0.941176f, 0.941176f, 1.0f},
   {0.94902f, 0.94902f, 0.94902f, 1.0f},
   {0.94902f, 0.94902f, 0.94902f, 1.0f},
   {0.94902f, 0.94902f, 0.94902f, 1.0f},
});

const Palette BPAL_23 = Palette("rainbow",
{
   {1.0f, 0.0f, 0.0f, 1.0f},
   {1.0f, 0.0408947f, 0.0f, 1.0f},
   {1.0f, 0.0817211f, 0.0f, 1.0f},
   {1.0f, 0.122411f, 0.0f, 1.0f},
   {1.0f, 0.162895f, 0.0f, 1.0f},
   {1.0f, 0.203108f, 0.0f, 1.0f},
   {1.0f, 0.24298f, 0.0f, 1.0f},
   {1.0f, 0.282446f, 0.0f, 1.0f},
   {1.0f, 0.321439f, 0.0f, 1.0f},
   {1.0f, 0.359895f, 0.0f, 1.0f},
   {1.0f, 0.397748f, 0.0f, 1.0f},
   {1.0f, 0.434936f, 0.0f, 1.0f},
   {1.0f, 0.471397f, 0.0f, 1.0f},
   {1.0f, 0.507068f, 0.0f, 1.0f},
   {1.0f, 0.541892f, 0.0f, 1.0f},
   {1.0f, 0.575808f, 0.0f, 1.0f},
   {1.0f, 0.608761f, 0.0f, 1.0f},
   {1.0f, 0.640696f, 0.0f, 1.0f},
   {1.0f, 0.671559f, 0.0f, 1.0f},
   {1.0f, 0.701298f, 0.0f, 1.0f},
   {1.0f, 0.729864f, 0.0f, 1.0f},
   {1.0f, 0.757209f, 0.0f, 1.0f},
   {1.0f, 0.783287f, 0.0f, 1.0f},
   {1.0f, 0.808054f, 0.0f, 1.0f},
   {1.0f, 0.83147f, 0.0f, 1.0f},
   {1.0f, 0.853494f, 0.0f, 1.0f},
   {1.0f, 0.87409f, 0.0f, 1.0f},
   {1.0f, 0.893224f, 0.0f, 1.0f},
   {1.0f, 0.910864f, 0.0f, 1.0f},
   {1.0f, 0.926979f, 0.0f, 1.0f},
   {1.0f, 0.941544f, 0.0f, 1.0f},
   {1.0f, 0.954533f, 0.0f, 1.0f},
   {1.0f, 0.965926f, 0.0f, 1.0f},
   {1.0f, 0.975702f, 0.0f, 1.0f},
   {1.0f, 0.983846f, 0.0f, 1.0f},
   {1.0f, 0.990344f, 0.0f, 1.0f},
   {1.0f, 0.995185f, 0.0f, 1.0f},
   {1.0f, 0.998361f, 0.0f, 1.0f},
   {1.0f, 0.999866f, 0.0f, 1.0f},
   {0.999699f, 1.0f, 0.0f, 1.0f},
   {0.997859f, 1.0f, 0.0f, 1.0f},
   {0.99435f, 1.0f, 0.0f, 1.0f},
   {0.989177f, 1.0f, 0.0f, 1.0f},
   {0.982349f, 1.0f, 0.0f, 1.0f},
   {0.973877f, 1.0f, 0.0f, 1.0f},
   {0.963776f, 1.0f, 0.0f, 1.0f},
   {0.952063f, 1.0f, 0.0f, 1.0f},
   {0.938756f, 1.0f, 0.0f, 1.0f},
   {0.92388f, 1.0f, 0.0f, 1.0f},
   {0.907457f, 1.0f, 0.0f, 1.0f},
   {0.889516f, 1.0f, 0.0f, 1.0f},
   {0.870087f, 1.0f, 0.0f, 1.0f},
   {0.849202f, 1.0f, 0.0f, 1.0f},
   {0.826897f, 1.0f, 0.0f, 1.0f},
   {0.803208f, 1.0f, 0.0f, 1.0f},
   {0.778175f, 1.0f, 0.0f, 1.0f},
   {0.75184f, 1.0f, 0.0f, 1.0f},
   {0.724247f, 1.0f, 0.0f, 1.0f},
   {0.695443f, 1.0f, 0.0f, 1.0f},
   {0.665475f, 1.0f, 0.0f, 1.0f},
   {0.634393f, 1.0f, 0.0f, 1.0f},
   {0.602251f, 1.0f, 0.0f, 1.0f},
   {0.5691f, 1.0f, 0.0f, 1.0f},
   {0.534998f, 1.0f, 0.0f, 1.0f},
   {0.5f, 1.0f, 0.0f, 1.0f},
   {0.464166f, 1.0f, 0.0f, 1.0f},
   {0.427555f, 1.0f, 0.0f, 1.0f},
   {0.390229f, 1.0f, 0.0f, 1.0f},
   {0.35225f, 1.0f, 0.0f, 1.0f},
   {0.313682f, 1.0f, 0.0f, 1.0f},
   {0.274589f, 1.0f, 0.0f, 1.0f},
   {0.235036f, 1.0f, 0.0f, 1.0f},
   {0.19509f, 1.0f, 0.0f, 1.0f},
   {0.154818f, 1.0f, 0.0f, 1.0f},
   {0.114287f, 1.0f, 0.0f, 1.0f},
   {0.0735646f, 1.0f, 0.0f, 1.0f},
   {0.0327191f, 1.0f, 0.0f, 1.0f},
   {0.0f, 1.0f, 0.00818114f, 1.0f},
   {0.0f, 1.0f, 0.0490677f, 1.0f},
   {0.0f, 1.0f, 0.0898721f, 1.0f},
   {0.0f, 1.0f, 0.130526f, 1.0f},
   {0.0f, 1.0f, 0.170962f, 1.0f},
   {0.0f, 1.0f, 0.211112f, 1.0f},
   {0.0f, 1.0f, 0.250908f, 1.0f},
   {0.0f, 1.0f, 0.290285f, 1.0f},
   {0.0f, 1.0f, 0.329176f, 1.0f},
   {0.0f, 1.0f, 0.367516f, 1.0f},
   {0.0f, 1.0f, 0.405241f, 1.0f},
   {0.0f, 1.0f, 0.442289f, 1.0f},
   {0.0f, 1.0f, 0.478596f, 1.0f},
   {0.0f, 1.0f, 0.514103f, 1.0f},
   {0.0f, 1.0f, 0.548749f, 1.0f},
   {0.0f, 1.0f, 0.582478f, 1.0f},
   {0.0f, 1.0f, 0.615232f, 1.0f},
   {0.0f, 1.0f, 0.646956f, 1.0f},
   {0.0f, 1.0f, 0.677598f, 1.0f},
   {0.0f, 1.0f, 0.707107f, 1.0f},
   {0.0f, 1.0f, 0.735432f, 1.0f},
   {0.0f, 1.0f, 0.762527f, 1.0f},
   {0.0f, 1.0f, 0.788346f, 1.0f},
   {0.0f, 1.0f, 0.812847f, 1.0f},
   {0.0f, 1.0f, 0.835987f, 1.0f},
   {0.0f, 1.0f, 0.857729f, 1.0f},
   {0.0f, 1.0f, 0.878035f, 1.0f},
   {0.0f, 1.0f, 0.896873f, 1.0f},
   {0.0f, 1.0f, 0.91421f, 1.0f},
   {0.0f, 1.0f, 0.930017f, 1.0f},
   {0.0f, 1.0f, 0.944269f, 1.0f},
   {0.0f, 1.0f, 0.95694f, 1.0f},
   {0.0f, 1.0f, 0.968011f, 1.0f},
   {0.0f, 1.0f, 0.977462f, 1.0f},
   {0.0f, 1.0f, 0.985278f, 1.0f},
   {0.0f, 1.0f, 0.991445f, 1.0f},
   {0.0f, 1.0f, 0.995953f, 1.0f},
   {0.0f, 1.0f, 0.998795f, 1.0f},
   {0.0f, 1.0f, 0.999967f, 1.0f},
   {0.0f, 0.999465f, 1.0f, 1.0f},
   {0.0f, 0.99729f, 1.0f, 1.0f},
   {0.0f, 0.993448f, 1.0f, 1.0f},
   {0.0f, 0.987943f, 1.0f, 1.0f},
   {0.0f, 0.980785f, 1.0f, 1.0f},
   {0.0f, 0.971987f, 1.0f, 1.0f},
   {0.0f, 0.961562f, 1.0f, 1.0f},
   {0.0f, 0.949528f, 1.0f, 1.0f},
   {0.0f, 0.935906f, 1.0f, 1.0f},
   {0.0f, 0.920718f, 1.0f, 1.0f},
   {0.0f, 0.903989f, 1.0f, 1.0f},
   {0.0f, 0.885748f, 1.0f, 1.0f},
   {0.0f, 0.866025f, 1.0f, 1.0f},
   {0.0f, 0.844854f, 1.0f, 1.0f},
   {0.0f, 0.822268f, 1.0f, 1.0f},
   {0.0f, 0.798307f, 1.0f, 1.0f},
   {0.0f, 0.77301f, 1.0f, 1.0f},
   {0.0f, 0.74642f, 1.0f, 1.0f},
   {0.0f, 0.718582f, 1.0f, 1.0f},
   {0.0f, 0.689541f, 1.0f, 1.0f},
   {0.0f, 0.659346f, 1.0f, 1.0f},
   {0.0f, 0.628048f, 1.0f, 1.0f},
   {0.0f, 0.595699f, 1.0f, 1.0f},
   {0.0f, 0.562354f, 1.0f, 1.0f},
   {0.0f, 0.528068f, 1.0f, 1.0f},
   {0.0f, 0.492898f, 1.0f, 1.0f},
   {0.0f, 0.456904f, 1.0f, 1.0f},
   {0.0f, 0.420145f, 1.0f, 1.0f},
   {0.0f, 0.382683f, 1.0f, 1.0f},
   {0.0f, 0.344581f, 1.0f, 1.0f},
   {0.0f, 0.305903f, 1.0f, 1.0f},
   {0.0f, 0.266713f, 1.0f, 1.0f},
   {0.0f, 0.227076f, 1.0f, 1.0f},
   {0.0f, 0.18706f, 1.0f, 1.0f},
   {0.0f, 0.14673f, 1.0f, 1.0f},
   {0.0f, 0.106156f, 1.0f, 1.0f},
   {0.0f, 0.0654031f, 1.0f, 1.0f},
   {0.0f, 0.0245412f, 1.0f, 1.0f},
   {0.0163617f, 0.0f, 1.0f, 1.0f},
   {0.0572373f, 0.0f, 1.0f, 1.0f},
   {0.0980171f, 0.0f, 1.0f, 1.0f},
   {0.138633f, 0.0f, 1.0f, 1.0f},
   {0.179017f, 0.0f, 1.0f, 1.0f},
   {0.219101f, 0.0f, 1.0f, 1.0f},
   {0.258819f, 0.0f, 1.0f, 1.0f},
   {0.298104f, 0.0f, 1.0f, 1.0f},
   {0.33689f, 0.0f, 1.0f, 1.0f},
   {0.375112f, 0.0f, 1.0f, 1.0f},
   {0.412707f, 0.0f, 1.0f, 1.0f},
   {0.449611f, 0.0f, 1.0f, 1.0f},
   {0.485763f, 0.0f, 1.0f, 1.0f},
   {0.521103f, 0.0f, 1.0f, 1.0f},
   {0.55557f, 0.0f, 1.0f, 1.0f},
   {0.589108f, 0.0f, 1.0f, 1.0f},
   {0.621661f, 0.0f, 1.0f, 1.0f},
   {0.653173f, 0.0f, 1.0f, 1.0f},
   {0.683592f, 0.0f, 1.0f, 1.0f},
   {0.712868f, 0.0f, 1.0f, 1.0f},
   {0.740951f, 0.0f, 1.0f, 1.0f},
   {0.767795f, 0.0f, 1.0f, 1.0f},
   {0.793353f, 0.0f, 1.0f, 1.0f},
   {0.817585f, 0.0f, 1.0f, 1.0f},
   {0.840448f, 0.0f, 1.0f, 1.0f},
   {0.861906f, 0.0f, 1.0f, 1.0f},
   {0.881921f, 0.0f, 1.0f, 1.0f},
   {0.900461f, 0.0f, 1.0f, 1.0f},
   {0.917494f, 0.0f, 1.0f, 1.0f},
   {0.932993f, 0.0f, 1.0f, 1.0f},
   {0.94693f, 0.0f, 1.0f, 1.0f},
   {0.959283f, 0.0f, 1.0f, 1.0f},
   {0.970031f, 0.0f, 1.0f, 1.0f},
   {0.979156f, 0.0f, 1.0f, 1.0f},
   {0.986643f, 0.0f, 1.0f, 1.0f},
   {0.99248f, 0.0f, 1.0f, 1.0f},
   {0.996655f, 0.0f, 1.0f, 1.0f},
   {0.999163f, 0.0f, 1.0f, 1.0f},
   {1.0f, 0.0f, 1.0f, 1.0f},
});

const Palette BPAL_24 = Palette("cmyk",
{
   {0.300725f, 0.680491f, 0.901701f, 1.0f},
   {0.343564f, 0.712004f, 0.917969f, 1.0f},
   {0.386403f, 0.743518f, 0.934237f, 1.0f},
   {0.441409f, 0.694656f, 0.899639f, 1.0f},
   {0.496414f, 0.645794f, 0.86504f, 1.0f},
   {0.550366f, 0.581752f, 0.822636f, 1.0f},
   {0.604318f, 0.51771f, 0.780231f, 1.0f},
   {0.651771f, 0.474934f, 0.743461f, 1.0f},
   {0.699224f, 0.432157f, 0.70669f, 1.0f},
   {0.738903f, 0.424989f, 0.675772f, 1.0f},
   {0.778582f, 0.417821f, 0.644854f, 1.0f},
   {0.810852f, 0.444937f, 0.617053f, 1.0f},
   {0.843122f, 0.472052f, 0.589251f, 1.0f},
   {0.868355f, 0.522424f, 0.564101f, 1.0f},
   {0.893588f, 0.572795f, 0.538951f, 1.0f},
   {0.91124f, 0.630943f, 0.519525f, 1.0f},
   {0.928891f, 0.68909f, 0.500098f, 1.0f},
   {0.937118f, 0.739358f, 0.491394f, 1.0f},
   {0.945344f, 0.789625f, 0.482689f, 1.0f},
   {0.940976f, 0.819233f, 0.488234f, 1.0f},
   {0.936608f, 0.84884f, 0.493779f, 1.0f},
   {0.915305f, 0.849461f, 0.511525f, 1.0f},
   {0.894001f, 0.850082f, 0.529271f, 1.0f},
   {0.850401f, 0.817693f, 0.547873f, 1.0f},
   {0.806801f, 0.785304f, 0.566474f, 1.0f},
   {0.734503f, 0.71805f, 0.563027f, 1.0f},
   {0.662204f, 0.650797f, 0.559579f, 1.0f},
   {0.553381f, 0.54463f, 0.499912f, 1.0f},
   {0.444557f, 0.438462f, 0.440244f, 1.0f},
   {0.289045f, 0.280283f, 0.282844f, 1.0f},
   {0.133532f, 0.122103f, 0.125444f, 1.0f},
});

const Palette BPAL_25 = Palette("calewhite",
{
   {1.0f, 1.0f, 1.0f, 1.0f},
   {0.90625f, 0.90625f, 1.0f, 1.0f},
   {0.8125f, 0.8125f, 1.0f, 1.0f},
   {0.71875f, 0.71875f, 1.0f, 1.0f},
   {0.625f, 0.625f, 1.0f, 1.0f},
   {0.53125f, 0.53125f, 1.0f, 1.0f},
   {0.4375f, 0.4375f, 1.0f, 1.0f},
   {0.34375f, 0.34375f, 1.0f, 1.0f},
   {0.25f, 0.25f, 1.0f, 1.0f},
   {0.15625f, 0.15625f, 1.0f, 1.0f},
   {0.0625f, 0.0625f, 1.0f, 1.0f},
   {0.0f, 0.03125f, 1.0f, 1.0f},
   {0.0f, 0.125f, 1.0f, 1.0f},
   {0.0f, 0.21875f, 1.0f, 1.0f},
   {0.0f, 0.3125f, 1.0f, 1.0f},
   {0.0f, 0.40625f, 1.0f, 1.0f},
   {0.0f, 0.5f, 1.0f, 1.0f},
   {0.0f, 0.59375f, 1.0f, 1.0f},
   {0.0f, 0.6875f, 1.0f, 1.0f},
   {0.0f, 0.78125f, 1.0f, 1.0f},
   {0.0f, 0.875f, 1.0f, 1.0f},
   {0.0f, 0.96875f, 1.0f, 1.0f},
   {0.0f, 1.0f, 0.9375f, 1.0f},
   {0.0f, 1.0f, 0.84375f, 1.0f},
   {0.0f, 1.0f, 0.75f, 1.0f},
   {0.0f, 1.0f, 0.65625f, 1.0f},
   {0.0f, 1.0f, 0.5625f, 1.0f},
   {0.0f, 1.0f, 0.46875f, 1.0f},
   {0.0f, 1.0f, 0.375f, 1.0f},
   {0.0f, 1.0f, 0.28125f, 1.0f},
   {0.0f, 1.0f, 0.1875f, 1.0f},
   {0.0f, 1.0f, 0.09375f, 1.0f},
   {0.0f, 1.0f, 0.0f, 1.0f},
   {0.09375f, 1.0f, 0.0f, 1.0f},
   {0.1875f, 1.0f, 0.0f, 1.0f},
   {0.28125f, 1.0f, 0.0f, 1.0f},
   {0.375f, 1.0f, 0.0f, 1.0f},
   {0.46875f, 1.0f, 0.0f, 1.0f},
   {0.5625f, 1.0f, 0.0f, 1.0f},
   {0.65625f, 1.0f, 0.0f, 1.0f},
   {0.75f, 1.0f, 0.0f, 1.0f},
   {0.84375f, 1.0f, 0.0f, 1.0f},
   {0.9375f, 1.0f, 0.0f, 1.0f},
   {1.0f, 0.96875f, 0.0f, 1.0f},
   {1.0f, 0.875f, 0.0f, 1.0f},
   {1.0f, 0.78125f, 0.0f, 1.0f},
   {1.0f, 0.6875f, 0.0f, 1.0f},
   {1.0f, 0.59375f, 0.0f, 1.0f},
   {1.0f, 0.5f, 0.0f, 1.0f},
   {1.0f, 0.40625f, 0.0f, 1.0f},
   {1.0f, 0.3125f, 0.0f, 1.0f},
   {1.0f, 0.21875f, 0.0f, 1.0f},
   {1.0f, 0.125f, 0.0f, 1.0f},
   {1.0f, 0.03125f, 0.0f, 1.0f},
   {1.0f, 0.0f, 0.0625f, 1.0f},
   {1.0f, 0.0f, 0.15625f, 1.0f},
   {1.0f, 0.0f, 0.25f, 1.0f},
   {1.0f, 0.0f, 0.34375f, 1.0f},
   {1.0f, 0.0f, 0.4375f, 1.0f},
   {1.0f, 0.0f, 0.53125f, 1.0f},
   {1.0f, 0.0f, 0.625f, 1.0f},
   {1.0f, 0.0f, 0.71875f, 1.0f},
   {1.0f, 0.0f, 0.8125f, 1.0f},
   {1.0f, 0.0f, 0.90625f, 1.0f},
   {1.0f, 0.0f, 1.0f, 1.0f},
});

const Palette BPAL_26 = Palette("haxby",
{
   {0.039216f, 0.0f, 0.47451f, 1.0f},
   {0.156863f, 0.0f, 0.588235f, 1.0f},
   {0.078431f, 0.019608f, 0.686275f, 1.0f},
   {0.0f, 0.039216f, 0.784314f, 1.0f},
   {0.0f, 0.098039f, 0.831373f, 1.0f},
   {0.0f, 0.156863f, 0.878431f, 1.0f},
   {0.101961f, 0.4f, 0.941176f, 1.0f},
   {0.05098f, 0.505882f, 0.972549f, 1.0f},
   {0.098039f, 0.686275f, 1.0f, 1.0f},
   {0.196078f, 0.745098f, 1.0f, 1.0f},
   {0.266667f, 0.792157f, 1.0f, 1.0f},
   {0.380392f, 0.882353f, 0.941176f, 1.0f},
   {0.415686f, 0.921569f, 0.882353f, 1.0f},
   {0.486275f, 0.921569f, 0.784314f, 1.0f},
   {0.541176f, 0.92549f, 0.682353f, 1.0f},
   {0.67451f, 0.960784f, 0.658824f, 1.0f},
   {0.803922f, 1.0f, 0.635294f, 1.0f},
   {0.87451f, 0.960784f, 0.552941f, 1.0f},
   {0.941176f, 0.92549f, 0.47451f, 1.0f},
   {0.968627f, 0.843137f, 0.407843f, 1.0f},
   {1.0f, 0.741176f, 0.341176f, 1.0f},
   {1.0f, 0.627451f, 0.270588f, 1.0f},
   {0.956863f, 0.458824f, 0.294118f, 1.0f},
   {0.933333f, 0.313725f, 0.305882f, 1.0f},
   {1.0f, 0.352941f, 0.352941f, 1.0f},
   {1.0f, 0.486275f, 0.486275f, 1.0f},
   {1.0f, 0.619608f, 0.619608f, 1.0f},
   {0.960784f, 0.701961f, 0.682353f, 1.0f},
   {1.0f, 0.768627f, 0.768627f, 1.0f},
   {1.0f, 0.843137f, 0.843137f, 1.0f},
   {1.0f, 0.921569f, 0.921569f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
});

const Palette BPAL_27 = Palette("manga",
{
   {0.183594f, 0.214844f, 0.621094f, 1.0f},
   {0.167969f, 0.203125f, 0.625f, 1.0f},
   {0.128906f, 0.167969f, 0.632812f, 1.0f},
   {0.082031f, 0.125f, 0.636719f, 1.0f},
   {0.042969f, 0.089844f, 0.644531f, 1.0f},
   {0.019531f, 0.070312f, 0.648438f, 1.0f},
   {0.007812f, 0.0625f, 0.65625f, 1.0f},
   {0.0f, 0.058594f, 0.660156f, 1.0f},
   {0.0f, 0.0625f, 0.664062f, 1.0f},
   {0.0f, 0.0625f, 0.664062f, 1.0f},
   {0.0f, 0.0625f, 0.664062f, 1.0f},
   {0.0f, 0.0625f, 0.648438f, 1.0f},
   {0.0f, 0.0625f, 0.617188f, 1.0f},
   {0.0f, 0.058594f, 0.5625f, 1.0f},
   {0.0f, 0.050781f, 0.488281f, 1.0f},
   {0.0f, 0.046875f, 0.429688f, 1.0f},
   {0.0f, 0.046875f, 0.410156f, 1.0f},
   {0.0f, 0.050781f, 0.445312f, 1.0f},
   {0.0f, 0.0625f, 0.519531f, 1.0f},
   {0.0f, 0.074219f, 0.601562f, 1.0f},
   {0.0f, 0.085938f, 0.664062f, 1.0f},
   {0.0f, 0.09375f, 0.703125f, 1.0f},
   {0.0f, 0.101562f, 0.726562f, 1.0f},
   {0.0f, 0.105469f, 0.738281f, 1.0f},
   {0.0f, 0.113281f, 0.746094f, 1.0f},
   {0.003906f, 0.121094f, 0.753906f, 1.0f},
   {0.011719f, 0.128906f, 0.757812f, 1.0f},
   {0.027344f, 0.148438f, 0.761719f, 1.0f},
   {0.058594f, 0.175781f, 0.765625f, 1.0f},
   {0.105469f, 0.222656f, 0.769531f, 1.0f},
   {0.167969f, 0.277344f, 0.777344f, 1.0f},
   {0.21875f, 0.320312f, 0.78125f, 1.0f},
   {0.234375f, 0.339844f, 0.785156f, 1.0f},
   {0.210938f, 0.324219f, 0.789062f, 1.0f},
   {0.15625f, 0.285156f, 0.792969f, 1.0f},
   {0.097656f, 0.242188f, 0.796875f, 1.0f},
   {0.054688f, 0.214844f, 0.800781f, 1.0f},
   {0.027344f, 0.199219f, 0.804688f, 1.0f},
   {0.011719f, 0.195312f, 0.808594f, 1.0f},
   {0.007812f, 0.195312f, 0.8125f, 1.0f},
   {0.007812f, 0.203125f, 0.816406f, 1.0f},
   {0.007812f, 0.207031f, 0.816406f, 1.0f},
   {0.007812f, 0.214844f, 0.808594f, 1.0f},
   {0.007812f, 0.214844f, 0.792969f, 1.0f},
   {0.007812f, 0.210938f, 0.757812f, 1.0f},
   {0.007812f, 0.199219f, 0.695312f, 1.0f},
   {0.007812f, 0.1875f, 0.625f, 1.0f},
   {0.007812f, 0.171875f, 0.566406f, 1.0f},
   {0.007812f, 0.175781f, 0.550781f, 1.0f},
   {0.011719f, 0.195312f, 0.59375f, 1.0f},
   {0.015625f, 0.226562f, 0.667969f, 1.0f},
   {0.019531f, 0.261719f, 0.746094f, 1.0f},
   {0.023438f, 0.289062f, 0.804688f, 1.0f},
   {0.027344f, 0.3125f, 0.839844f, 1.0f},
   {0.03125f, 0.328125f, 0.859375f, 1.0f},
   {0.03125f, 0.34375f, 0.867188f, 1.0f},
   {0.039062f, 0.359375f, 0.875f, 1.0f},
   {0.046875f, 0.375f, 0.878906f, 1.0f},
   {0.058594f, 0.394531f, 0.882812f, 1.0f},
   {0.082031f, 0.417969f, 0.886719f, 1.0f},
   {0.121094f, 0.449219f, 0.890625f, 1.0f},
   {0.179688f, 0.496094f, 0.890625f, 1.0f},
   {0.25f, 0.542969f, 0.894531f, 1.0f},
   {0.304688f, 0.582031f, 0.898438f, 1.0f},
   {0.320312f, 0.597656f, 0.902344f, 1.0f},
   {0.292969f, 0.59375f, 0.90625f, 1.0f},
   {0.238281f, 0.578125f, 0.90625f, 1.0f},
   {0.183594f, 0.5625f, 0.910156f, 1.0f},
   {0.148438f, 0.558594f, 0.914062f, 1.0f},
   {0.128906f, 0.5625f, 0.914062f, 1.0f},
   {0.125f, 0.574219f, 0.917969f, 1.0f},
   {0.128906f, 0.589844f, 0.917969f, 1.0f},
   {0.136719f, 0.605469f, 0.921875f, 1.0f},
   {0.148438f, 0.621094f, 0.917969f, 1.0f},
   {0.15625f, 0.628906f, 0.910156f, 1.0f},
   {0.160156f, 0.632812f, 0.890625f, 1.0f},
   {0.164062f, 0.617188f, 0.847656f, 1.0f},
   {0.160156f, 0.585938f, 0.785156f, 1.0f},
   {0.15625f, 0.542969f, 0.710938f, 1.0f},
   {0.152344f, 0.511719f, 0.65625f, 1.0f},
   {0.160156f, 0.519531f, 0.644531f, 1.0f},
   {0.179688f, 0.566406f, 0.691406f, 1.0f},
   {0.214844f, 0.640625f, 0.765625f, 1.0f},
   {0.246094f, 0.71875f, 0.84375f, 1.0f},
   {0.277344f, 0.78125f, 0.894531f, 1.0f},
   {0.304688f, 0.824219f, 0.929688f, 1.0f},
   {0.328125f, 0.855469f, 0.945312f, 1.0f},
   {0.347656f, 0.878906f, 0.953125f, 1.0f},
   {0.367188f, 0.898438f, 0.957031f, 1.0f},
   {0.390625f, 0.914062f, 0.960938f, 1.0f},
   {0.414062f, 0.929688f, 0.960938f, 1.0f},
   {0.445312f, 0.945312f, 0.964844f, 1.0f},
   {0.488281f, 0.960938f, 0.964844f, 1.0f},
   {0.542969f, 0.964844f, 0.960938f, 1.0f},
   {0.597656f, 0.96875f, 0.953125f, 1.0f},
   {0.640625f, 0.96875f, 0.949219f, 1.0f},
   {0.660156f, 0.972656f, 0.945312f, 1.0f},
   {0.652344f, 0.972656f, 0.9375f, 1.0f},
   {0.640625f, 0.972656f, 0.929688f, 1.0f},
   {0.628906f, 0.976562f, 0.921875f, 1.0f},
   {0.632812f, 0.976562f, 0.914062f, 1.0f},
   {0.640625f, 0.976562f, 0.90625f, 1.0f},
   {0.660156f, 0.980469f, 0.902344f, 1.0f},
   {0.675781f, 0.980469f, 0.898438f, 1.0f},
   {0.695312f, 0.976562f, 0.894531f, 1.0f},
   {0.714844f, 0.972656f, 0.890625f, 1.0f},
   {0.726562f, 0.964844f, 0.878906f, 1.0f},
   {0.726562f, 0.9375f, 0.859375f, 1.0f},
   {0.707031f, 0.894531f, 0.816406f, 1.0f},
   {0.667969f, 0.828125f, 0.757812f, 1.0f},
   {0.621094f, 0.75f, 0.691406f, 1.0f},
   {0.589844f, 0.699219f, 0.644531f, 1.0f},
   {0.597656f, 0.695312f, 0.644531f, 1.0f},
   {0.652344f, 0.746094f, 0.695312f, 1.0f},
   {0.734375f, 0.820312f, 0.769531f, 1.0f},
   {0.808594f, 0.890625f, 0.839844f, 1.0f},
   {0.867188f, 0.941406f, 0.894531f, 1.0f},
   {0.90625f, 0.96875f, 0.925781f, 1.0f},
   {0.929688f, 0.984375f, 0.945312f, 1.0f},
   {0.945312f, 0.988281f, 0.957031f, 1.0f},
   {0.957031f, 0.992188f, 0.964844f, 1.0f},
   {0.96875f, 0.992188f, 0.972656f, 1.0f},
   {0.976562f, 0.992188f, 0.976562f, 1.0f},
   {0.980469f, 0.992188f, 0.984375f, 1.0f},
   {0.988281f, 0.992188f, 0.988281f, 1.0f},
   {0.992188f, 0.992188f, 0.992188f, 1.0f},
   {0.992188f, 0.992188f, 0.992188f, 1.0f},
   {0.992188f, 0.992188f, 0.992188f, 1.0f},
   {0.992188f, 0.992188f, 0.992188f, 1.0f},
   {0.992188f, 0.992188f, 0.992188f, 1.0f},
   {0.992188f, 0.992188f, 0.992188f, 1.0f},
   {0.988281f, 0.992188f, 0.988281f, 1.0f},
   {0.984375f, 0.992188f, 0.980469f, 1.0f},
   {0.976562f, 0.992188f, 0.976562f, 1.0f},
   {0.972656f, 0.992188f, 0.96875f, 1.0f},
   {0.964844f, 0.992188f, 0.957031f, 1.0f},
   {0.957031f, 0.988281f, 0.945312f, 1.0f},
   {0.945312f, 0.984375f, 0.929688f, 1.0f},
   {0.925781f, 0.96875f, 0.90625f, 1.0f},
   {0.894531f, 0.941406f, 0.867188f, 1.0f},
   {0.839844f, 0.890625f, 0.808594f, 1.0f},
   {0.769531f, 0.820312f, 0.734375f, 1.0f},
   {0.695312f, 0.746094f, 0.652344f, 1.0f},
   {0.644531f, 0.695312f, 0.597656f, 1.0f},
   {0.644531f, 0.699219f, 0.589844f, 1.0f},
   {0.691406f, 0.75f, 0.621094f, 1.0f},
   {0.757812f, 0.828125f, 0.667969f, 1.0f},
   {0.816406f, 0.894531f, 0.707031f, 1.0f},
   {0.859375f, 0.9375f, 0.726562f, 1.0f},
   {0.878906f, 0.964844f, 0.726562f, 1.0f},
   {0.890625f, 0.972656f, 0.714844f, 1.0f},
   {0.894531f, 0.976562f, 0.695312f, 1.0f},
   {0.898438f, 0.980469f, 0.675781f, 1.0f},
   {0.902344f, 0.980469f, 0.660156f, 1.0f},
   {0.90625f, 0.976562f, 0.640625f, 1.0f},
   {0.914062f, 0.976562f, 0.632812f, 1.0f},
   {0.921875f, 0.976562f, 0.628906f, 1.0f},
   {0.929688f, 0.972656f, 0.640625f, 1.0f},
   {0.9375f, 0.972656f, 0.652344f, 1.0f},
   {0.945312f, 0.972656f, 0.660156f, 1.0f},
   {0.949219f, 0.96875f, 0.640625f, 1.0f},
   {0.953125f, 0.96875f, 0.597656f, 1.0f},
   {0.960938f, 0.964844f, 0.542969f, 1.0f},
   {0.964844f, 0.960938f, 0.488281f, 1.0f},
   {0.964844f, 0.945312f, 0.445312f, 1.0f},
   {0.960938f, 0.929688f, 0.414062f, 1.0f},
   {0.960938f, 0.914062f, 0.390625f, 1.0f},
   {0.957031f, 0.898438f, 0.367188f, 1.0f},
   {0.953125f, 0.878906f, 0.347656f, 1.0f},
   {0.945312f, 0.855469f, 0.328125f, 1.0f},
   {0.929688f, 0.824219f, 0.304688f, 1.0f},
   {0.894531f, 0.78125f, 0.277344f, 1.0f},
   {0.84375f, 0.71875f, 0.246094f, 1.0f},
   {0.765625f, 0.640625f, 0.214844f, 1.0f},
   {0.691406f, 0.566406f, 0.179688f, 1.0f},
   {0.644531f, 0.519531f, 0.160156f, 1.0f},
   {0.65625f, 0.511719f, 0.152344f, 1.0f},
   {0.710938f, 0.542969f, 0.15625f, 1.0f},
   {0.785156f, 0.585938f, 0.160156f, 1.0f},
   {0.847656f, 0.617188f, 0.164062f, 1.0f},
   {0.890625f, 0.632812f, 0.160156f, 1.0f},
   {0.910156f, 0.628906f, 0.15625f, 1.0f},
   {0.917969f, 0.621094f, 0.148438f, 1.0f},
   {0.921875f, 0.605469f, 0.136719f, 1.0f},
   {0.917969f, 0.589844f, 0.128906f, 1.0f},
   {0.917969f, 0.574219f, 0.125f, 1.0f},
   {0.914062f, 0.5625f, 0.128906f, 1.0f},
   {0.914062f, 0.558594f, 0.148438f, 1.0f},
   {0.910156f, 0.5625f, 0.183594f, 1.0f},
   {0.90625f, 0.578125f, 0.238281f, 1.0f},
   {0.90625f, 0.59375f, 0.292969f, 1.0f},
   {0.902344f, 0.597656f, 0.320312f, 1.0f},
   {0.898438f, 0.582031f, 0.304688f, 1.0f},
   {0.894531f, 0.542969f, 0.25f, 1.0f},
   {0.890625f, 0.496094f, 0.179688f, 1.0f},
   {0.890625f, 0.449219f, 0.121094f, 1.0f},
   {0.886719f, 0.417969f, 0.082031f, 1.0f},
   {0.882812f, 0.394531f, 0.058594f, 1.0f},
   {0.878906f, 0.375f, 0.046875f, 1.0f},
   {0.875f, 0.359375f, 0.039062f, 1.0f},
   {0.867188f, 0.34375f, 0.03125f, 1.0f},
   {0.859375f, 0.328125f, 0.03125f, 1.0f},
   {0.839844f, 0.3125f, 0.027344f, 1.0f},
   {0.804688f, 0.289062f, 0.023438f, 1.0f},
   {0.746094f, 0.261719f, 0.019531f, 1.0f},
   {0.667969f, 0.226562f, 0.015625f, 1.0f},
   {0.59375f, 0.195312f, 0.011719f, 1.0f},
   {0.550781f, 0.175781f, 0.007812f, 1.0f},
   {0.566406f, 0.171875f, 0.007812f, 1.0f},
   {0.625f, 0.1875f, 0.007812f, 1.0f},
   {0.695312f, 0.199219f, 0.007812f, 1.0f},
   {0.757812f, 0.210938f, 0.007812f, 1.0f},
   {0.792969f, 0.214844f, 0.007812f, 1.0f},
   {0.808594f, 0.214844f, 0.007812f, 1.0f},
   {0.816406f, 0.207031f, 0.007812f, 1.0f},
   {0.816406f, 0.203125f, 0.007812f, 1.0f},
   {0.8125f, 0.195312f, 0.007812f, 1.0f},
   {0.808594f, 0.195312f, 0.011719f, 1.0f},
   {0.804688f, 0.199219f, 0.027344f, 1.0f},
   {0.800781f, 0.214844f, 0.054688f, 1.0f},
   {0.796875f, 0.242188f, 0.097656f, 1.0f},
   {0.792969f, 0.285156f, 0.15625f, 1.0f},
   {0.789062f, 0.324219f, 0.210938f, 1.0f},
   {0.785156f, 0.339844f, 0.234375f, 1.0f},
   {0.78125f, 0.320312f, 0.21875f, 1.0f},
   {0.777344f, 0.277344f, 0.167969f, 1.0f},
   {0.769531f, 0.222656f, 0.105469f, 1.0f},
   {0.765625f, 0.175781f, 0.058594f, 1.0f},
   {0.761719f, 0.148438f, 0.027344f, 1.0f},
   {0.757812f, 0.128906f, 0.011719f, 1.0f},
   {0.753906f, 0.121094f, 0.003906f, 1.0f},
   {0.746094f, 0.113281f, 0.0f, 1.0f},
   {0.738281f, 0.105469f, 0.0f, 1.0f},
   {0.726562f, 0.101562f, 0.0f, 1.0f},
   {0.703125f, 0.09375f, 0.0f, 1.0f},
   {0.664062f, 0.085938f, 0.0f, 1.0f},
   {0.601562f, 0.074219f, 0.0f, 1.0f},
   {0.519531f, 0.0625f, 0.0f, 1.0f},
   {0.445312f, 0.050781f, 0.0f, 1.0f},
   {0.410156f, 0.046875f, 0.0f, 1.0f},
   {0.429688f, 0.046875f, 0.0f, 1.0f},
   {0.488281f, 0.050781f, 0.0f, 1.0f},
   {0.5625f, 0.058594f, 0.0f, 1.0f},
   {0.617188f, 0.0625f, 0.0f, 1.0f},
   {0.648438f, 0.0625f, 0.0f, 1.0f},
   {0.664062f, 0.0625f, 0.0f, 1.0f},
   {0.664062f, 0.0625f, 0.0f, 1.0f},
   {0.664062f, 0.0625f, 0.0f, 1.0f},
   {0.660156f, 0.058594f, 0.0f, 1.0f},
   {0.65625f, 0.0625f, 0.007812f, 1.0f},
   {0.648438f, 0.070312f, 0.019531f, 1.0f},
   {0.644531f, 0.089844f, 0.042969f, 1.0f},
   {0.636719f, 0.125f, 0.082031f, 1.0f},
   {0.632812f, 0.167969f, 0.128906f, 1.0f},
   {0.625f, 0.203125f, 0.167969f, 1.0f},
   {0.621094f, 0.214844f, 0.183594f, 1.0f},
});

const Palette BPAL_28 = Palette("drywet",
{
   {0.328125f, 0.1875f, 0.019531f, 1.0f},
   {0.546875f, 0.316406f, 0.039062f, 1.0f},
   {0.746094f, 0.503906f, 0.175781f, 1.0f},
   {0.871094f, 0.757812f, 0.488281f, 1.0f},
   {0.960938f, 0.90625f, 0.761719f, 1.0f},
   {0.957031f, 0.957031f, 0.957031f, 1.0f},
   {0.777344f, 0.914062f, 0.894531f, 1.0f},
   {0.5f, 0.800781f, 0.753906f, 1.0f},
   {0.207031f, 0.589844f, 0.558594f, 1.0f},
   {0.003906f, 0.398438f, 0.371094f, 1.0f},
   {0.0f, 0.234375f, 0.1875f, 1.0f},
});

const Palette BPAL_29 = Palette("gfdl",
{
   {0.996078f, 0.984314f, 0.964706f, 1.0f},
   {0.92549f, 0.929412f, 0.945098f, 1.0f},
   {0.905882f, 0.909804f, 0.92549f, 1.0f},
   {0.862745f, 0.882353f, 0.901961f, 1.0f},
   {0.835294f, 0.854902f, 0.87451f, 1.0f},
   {0.811765f, 0.823529f, 0.858824f, 1.0f},
   {0.784314f, 0.796078f, 0.831373f, 1.0f},
   {0.74902f, 0.772549f, 0.811765f, 1.0f},
   {0.729412f, 0.74902f, 0.788235f, 1.0f},
   {0.694118f, 0.717647f, 0.768627f, 1.0f},
   {0.670588f, 0.690196f, 0.741176f, 1.0f},
   {0.639216f, 0.666667f, 0.72549f, 1.0f},
   {0.611765f, 0.639216f, 0.698039f, 1.0f},
   {0.580392f, 0.607843f, 0.666667f, 1.0f},
   {0.560784f, 0.588235f, 0.647059f, 1.0f},
   {0.517647f, 0.560784f, 0.623529f, 1.0f},
   {0.490196f, 0.537255f, 0.596078f, 1.0f},
   {0.462745f, 0.517647f, 0.576471f, 1.0f},
   {0.435294f, 0.490196f, 0.545098f, 1.0f},
   {0.4f, 0.447059f, 0.52549f, 1.0f},
   {0.384314f, 0.431373f, 0.509804f, 1.0f},
   {0.352941f, 0.407843f, 0.486275f, 1.0f},
   {0.32549f, 0.380392f, 0.458824f, 1.0f},
   {0.294118f, 0.356863f, 0.443137f, 1.0f},
   {0.270588f, 0.329412f, 0.415686f, 1.0f},
   {0.247059f, 0.301961f, 0.396078f, 1.0f},
   {0.223529f, 0.282353f, 0.372549f, 1.0f},
   {0.196078f, 0.254902f, 0.360784f, 1.0f},
   {0.168627f, 0.223529f, 0.32549f, 1.0f},
   {0.133333f, 0.203922f, 0.301961f, 1.0f},
   {0.113725f, 0.180392f, 0.27451f, 1.0f},
   {0.094118f, 0.14902f, 0.25098f, 1.0f},
   {0.07451f, 0.12549f, 0.227451f, 1.0f},
   {0.05098f, 0.109804f, 0.203922f, 1.0f},
   {0.047059f, 0.105882f, 0.196078f, 1.0f},
   {0.05098f, 0.117647f, 0.203922f, 1.0f},
   {0.062745f, 0.129412f, 0.219608f, 1.0f},
   {0.07451f, 0.141176f, 0.235294f, 1.0f},
   {0.086275f, 0.156863f, 0.254902f, 1.0f},
   {0.094118f, 0.176471f, 0.258824f, 1.0f},
   {0.105882f, 0.188235f, 0.27451f, 1.0f},
   {0.121569f, 0.207843f, 0.298039f, 1.0f},
   {0.133333f, 0.219608f, 0.309804f, 1.0f},
   {0.137255f, 0.243137f, 0.32549f, 1.0f},
   {0.145098f, 0.254902f, 0.337255f, 1.0f},
   {0.160784f, 0.270588f, 0.356863f, 1.0f},
   {0.176471f, 0.286275f, 0.372549f, 1.0f},
   {0.180392f, 0.301961f, 0.380392f, 1.0f},
   {0.196078f, 0.313725f, 0.396078f, 1.0f},
   {0.203922f, 0.32549f, 0.407843f, 1.0f},
   {0.219608f, 0.341176f, 0.423529f, 1.0f},
   {0.223529f, 0.360784f, 0.427451f, 1.0f},
   {0.247059f, 0.384314f, 0.45098f, 1.0f},
   {0.247059f, 0.396078f, 0.458824f, 1.0f},
   {0.262745f, 0.415686f, 0.478431f, 1.0f},
   {0.282353f, 0.439216f, 0.490196f, 1.0f},
   {0.290196f, 0.447059f, 0.498039f, 1.0f},
   {0.298039f, 0.462745f, 0.513725f, 1.0f},
   {0.309804f, 0.478431f, 0.529412f, 1.0f},
   {0.313725f, 0.501961f, 0.533333f, 1.0f},
   {0.329412f, 0.517647f, 0.54902f, 1.0f},
   {0.333333f, 0.529412f, 0.560784f, 1.0f},
   {0.34902f, 0.54902f, 0.580392f, 1.0f},
   {0.356863f, 0.564706f, 0.592157f, 1.0f},
   {0.372549f, 0.580392f, 0.607843f, 1.0f},
   {0.392157f, 0.603922f, 0.631373f, 1.0f},
   {0.403922f, 0.615686f, 0.643137f, 1.0f},
   {0.403922f, 0.631373f, 0.643137f, 1.0f},
   {0.423529f, 0.654902f, 0.666667f, 1.0f},
   {0.431373f, 0.662745f, 0.67451f, 1.0f},
   {0.447059f, 0.678431f, 0.694118f, 1.0f},
   {0.454902f, 0.698039f, 0.705882f, 1.0f},
   {0.47451f, 0.717647f, 0.72549f, 1.0f},
   {0.482353f, 0.72549f, 0.733333f, 1.0f},
   {0.501961f, 0.74902f, 0.756863f, 1.0f},
   {0.505882f, 0.772549f, 0.752941f, 1.0f},
   {0.517647f, 0.788235f, 0.764706f, 1.0f},
   {0.52549f, 0.807843f, 0.784314f, 1.0f},
   {0.541176f, 0.819608f, 0.8f, 1.0f},
   {0.54902f, 0.839216f, 0.811765f, 1.0f},
   {0.564706f, 0.858824f, 0.831373f, 1.0f},
   {0.580392f, 0.87451f, 0.847059f, 1.0f},
   {0.596078f, 0.894118f, 0.862745f, 1.0f},
   {0.596078f, 0.905882f, 0.862745f, 1.0f},
   {0.596078f, 0.905882f, 0.862745f, 1.0f},
   {0.576471f, 0.890196f, 0.819608f, 1.0f},
   {0.564706f, 0.878431f, 0.811765f, 1.0f},
   {0.54902f, 0.866667f, 0.760784f, 1.0f},
   {0.541176f, 0.858824f, 0.752941f, 1.0f},
   {0.529412f, 0.847059f, 0.729412f, 1.0f},
   {0.517647f, 0.835294f, 0.713725f, 1.0f},
   {0.498039f, 0.827451f, 0.662745f, 1.0f},
   {0.478431f, 0.807843f, 0.643137f, 1.0f},
   {0.470588f, 0.803922f, 0.607843f, 1.0f},
   {0.454902f, 0.784314f, 0.588235f, 1.0f},
   {0.443137f, 0.776471f, 0.556863f, 1.0f},
   {0.431373f, 0.764706f, 0.545098f, 1.0f},
   {0.415686f, 0.74902f, 0.501961f, 1.0f},
   {0.407843f, 0.741176f, 0.494118f, 1.0f},
   {0.392157f, 0.729412f, 0.458824f, 1.0f},
   {0.380392f, 0.713725f, 0.447059f, 1.0f},
   {0.368627f, 0.701961f, 0.415686f, 1.0f},
   {0.352941f, 0.682353f, 0.4f, 1.0f},
   {0.345098f, 0.678431f, 0.360784f, 1.0f},
   {0.329412f, 0.662745f, 0.345098f, 1.0f},
   {0.317647f, 0.647059f, 0.32549f, 1.0f},
   {0.305882f, 0.635294f, 0.313725f, 1.0f},
   {0.282353f, 0.623529f, 0.270588f, 1.0f},
   {0.27451f, 0.615686f, 0.262745f, 1.0f},
   {0.262745f, 0.592157f, 0.223529f, 1.0f},
   {0.258824f, 0.584314f, 0.215686f, 1.0f},
   {0.247059f, 0.576471f, 0.180392f, 1.0f},
   {0.243137f, 0.572549f, 0.176471f, 1.0f},
   {0.270588f, 0.584314f, 0.14902f, 1.0f},
   {0.282353f, 0.6f, 0.160784f, 1.0f},
   {0.313725f, 0.619608f, 0.117647f, 1.0f},
   {0.329412f, 0.639216f, 0.129412f, 1.0f},
   {0.372549f, 0.654902f, 0.098039f, 1.0f},
   {0.384314f, 0.666667f, 0.109804f, 1.0f},
   {0.419608f, 0.686275f, 0.070588f, 1.0f},
   {0.435294f, 0.701961f, 0.086275f, 1.0f},
   {0.478431f, 0.721569f, 0.023529f, 1.0f},
   {0.494118f, 0.741176f, 0.05098f, 1.0f},
   {0.529412f, 0.756863f, 0.0f, 1.0f},
   {0.545098f, 0.772549f, 0.0f, 1.0f},
   {0.588235f, 0.788235f, 0.0f, 1.0f},
   {0.603922f, 0.807843f, 0.0f, 1.0f},
   {0.635294f, 0.811765f, 0.0f, 1.0f},
   {0.658824f, 0.835294f, 0.0f, 1.0f},
   {0.698039f, 0.85098f, 0.0f, 1.0f},
   {0.721569f, 0.87451f, 0.0f, 1.0f},
   {0.756863f, 0.878431f, 0.0f, 1.0f},
   {0.780392f, 0.905882f, 0.0f, 1.0f},
   {0.823529f, 0.909804f, 0.0f, 1.0f},
   {0.847059f, 0.933333f, 0.0f, 1.0f},
   {0.878431f, 0.945098f, 0.0f, 1.0f},
   {0.901961f, 0.968627f, 0.0f, 1.0f},
   {0.933333f, 0.972549f, 0.0f, 1.0f},
   {0.960784f, 1.0f, 0.0f, 1.0f},
   {1.0f, 1.0f, 0.0f, 1.0f},
   {1.0f, 1.0f, 0.0f, 1.0f},
   {1.0f, 0.984314f, 0.0f, 1.0f},
   {1.0f, 0.972549f, 0.0f, 1.0f},
   {1.0f, 0.921569f, 0.0f, 1.0f},
   {1.0f, 0.905882f, 0.0f, 1.0f},
   {1.0f, 0.862745f, 0.0f, 1.0f},
   {1.0f, 0.847059f, 0.0f, 1.0f},
   {1.0f, 0.803922f, 0.0f, 1.0f},
   {1.0f, 0.788235f, 0.0f, 1.0f},
   {1.0f, 0.74902f, 0.0f, 1.0f},
   {1.0f, 0.733333f, 0.0f, 1.0f},
   {1.0f, 0.694118f, 0.0f, 1.0f},
   {1.0f, 0.678431f, 0.0f, 1.0f},
   {1.0f, 0.631373f, 0.0f, 1.0f},
   {1.0f, 0.619608f, 0.0f, 1.0f},
   {1.0f, 0.580392f, 0.0f, 1.0f},
   {1.0f, 0.568627f, 0.0f, 1.0f},
   {1.0f, 0.529412f, 0.0f, 1.0f},
   {1.0f, 0.509804f, 0.0f, 1.0f},
   {1.0f, 0.466667f, 0.0f, 1.0f},
   {1.0f, 0.458824f, 0.0f, 1.0f},
   {1.0f, 0.431373f, 0.0f, 1.0f},
   {1.0f, 0.407843f, 0.0f, 1.0f},
   {1.0f, 0.376471f, 0.0f, 1.0f},
   {0.980392f, 0.360784f, 0.0f, 1.0f},
   {0.952941f, 0.333333f, 0.0f, 1.0f},
   {0.929412f, 0.313725f, 0.0f, 1.0f},
   {0.909804f, 0.290196f, 0.0f, 1.0f},
   {0.886275f, 0.270588f, 0.0f, 1.0f},
   {0.862745f, 0.243137f, 0.0f, 1.0f},
   {0.843137f, 0.231373f, 0.0f, 1.0f},
   {0.819608f, 0.203922f, 0.0f, 1.0f},
   {0.792157f, 0.184314f, 0.0f, 1.0f},
   {0.772549f, 0.160784f, 0.0f, 1.0f},
   {0.74902f, 0.145098f, 0.0f, 1.0f},
   {0.72549f, 0.121569f, 0.023529f, 1.0f},
   {0.721569f, 0.117647f, 0.019608f, 1.0f},
   {0.686275f, 0.12549f, 0.023529f, 1.0f},
   {0.67451f, 0.117647f, 0.011765f, 1.0f},
   {0.631373f, 0.117647f, 0.035294f, 1.0f},
   {0.627451f, 0.117647f, 0.031373f, 1.0f},
   {0.603922f, 0.109804f, 0.031373f, 1.0f},
   {0.592157f, 0.101961f, 0.023529f, 1.0f},
   {0.54902f, 0.105882f, 0.035294f, 1.0f},
   {0.545098f, 0.101961f, 0.031373f, 1.0f},
   {0.505882f, 0.101961f, 0.027451f, 1.0f},
   {0.501961f, 0.098039f, 0.023529f, 1.0f},
   {0.47451f, 0.101961f, 0.035294f, 1.0f},
   {0.466667f, 0.098039f, 0.031373f, 1.0f},
   {0.431373f, 0.094118f, 0.039216f, 1.0f},
   {0.427451f, 0.090196f, 0.035294f, 1.0f},
   {0.392157f, 0.094118f, 0.039216f, 1.0f},
   {0.388235f, 0.090196f, 0.035294f, 1.0f},
   {0.360784f, 0.086275f, 0.039216f, 1.0f},
   {0.34902f, 0.078431f, 0.031373f, 1.0f},
   {0.313725f, 0.086275f, 0.047059f, 1.0f},
   {0.301961f, 0.078431f, 0.043137f, 1.0f},
   {0.290196f, 0.078431f, 0.043137f, 1.0f},
   {0.278431f, 0.070588f, 0.039216f, 1.0f},
   {0.239216f, 0.07451f, 0.039216f, 1.0f},
   {0.235294f, 0.070588f, 0.039216f, 1.0f},
   {0.215686f, 0.066667f, 0.043137f, 1.0f},
   {0.207843f, 0.062745f, 0.039216f, 1.0f},
   {0.180392f, 0.062745f, 0.043137f, 1.0f},
   {0.160784f, 0.05098f, 0.031373f, 1.0f},
   {0.141176f, 0.054902f, 0.035294f, 1.0f},
   {0.137255f, 0.05098f, 0.031373f, 1.0f},
   {0.113725f, 0.05098f, 0.035294f, 1.0f},
   {0.101961f, 0.043137f, 0.023529f, 1.0f},
   {0.082353f, 0.043137f, 0.031373f, 1.0f},
   {0.070588f, 0.031373f, 0.019608f, 1.0f},
   {0.058824f, 0.031373f, 0.023529f, 1.0f},
   {0.058824f, 0.031373f, 0.023529f, 1.0f},
   {0.054902f, 0.031373f, 0.019608f, 1.0f},
   {0.05098f, 0.031373f, 0.015686f, 1.0f},
   {0.047059f, 0.023529f, 0.019608f, 1.0f},
   {0.05098f, 0.027451f, 0.023529f, 1.0f},
   {0.043137f, 0.027451f, 0.019608f, 1.0f},
   {0.039216f, 0.015686f, 0.0f, 1.0f},
   {0.035294f, 0.019608f, 0.015686f, 1.0f},
   {0.031373f, 0.011765f, 0.0f, 1.0f},
   {0.023529f, 0.015686f, 0.0f, 1.0f},
   {0.023529f, 0.015686f, 0.0f, 1.0f},
   {0.0f, 0.0f, 0.0f, 1.0f},
   {0.0f, 0.0f, 0.0f, 1.0f},
});

const Palette BPAL_30 = Palette("wbgyr",
{
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.984375f, 0.992188f, 0.996094f, 1.0f},
   {0.976562f, 0.988281f, 0.996094f, 1.0f},
   {0.964844f, 0.984375f, 0.992188f, 1.0f},
   {0.953125f, 0.980469f, 0.992188f, 1.0f},
   {0.945312f, 0.976562f, 0.992188f, 1.0f},
   {0.933594f, 0.972656f, 0.992188f, 1.0f},
   {0.921875f, 0.96875f, 0.988281f, 1.0f},
   {0.914062f, 0.964844f, 0.988281f, 1.0f},
   {0.902344f, 0.960938f, 0.988281f, 1.0f},
   {0.894531f, 0.957031f, 0.988281f, 1.0f},
   {0.882812f, 0.953125f, 0.988281f, 1.0f},
   {0.871094f, 0.949219f, 0.984375f, 1.0f},
   {0.863281f, 0.945312f, 0.984375f, 1.0f},
   {0.851562f, 0.941406f, 0.984375f, 1.0f},
   {0.839844f, 0.9375f, 0.984375f, 1.0f},
   {0.832031f, 0.933594f, 0.984375f, 1.0f},
   {0.820312f, 0.929688f, 0.980469f, 1.0f},
   {0.808594f, 0.925781f, 0.980469f, 1.0f},
   {0.800781f, 0.921875f, 0.980469f, 1.0f},
   {0.789062f, 0.917969f, 0.980469f, 1.0f},
   {0.777344f, 0.914062f, 0.976562f, 1.0f},
   {0.769531f, 0.910156f, 0.976562f, 1.0f},
   {0.757812f, 0.90625f, 0.976562f, 1.0f},
   {0.746094f, 0.902344f, 0.976562f, 1.0f},
   {0.738281f, 0.898438f, 0.976562f, 1.0f},
   {0.726562f, 0.894531f, 0.972656f, 1.0f},
   {0.714844f, 0.890625f, 0.972656f, 1.0f},
   {0.707031f, 0.886719f, 0.972656f, 1.0f},
   {0.695312f, 0.882812f, 0.972656f, 1.0f},
   {0.6875f, 0.878906f, 0.972656f, 1.0f},
   {0.675781f, 0.875f, 0.96875f, 1.0f},
   {0.664062f, 0.871094f, 0.96875f, 1.0f},
   {0.65625f, 0.867188f, 0.96875f, 1.0f},
   {0.644531f, 0.863281f, 0.96875f, 1.0f},
   {0.632812f, 0.859375f, 0.964844f, 1.0f},
   {0.613281f, 0.851562f, 0.964844f, 1.0f},
   {0.605469f, 0.84375f, 0.960938f, 1.0f},
   {0.59375f, 0.835938f, 0.957031f, 1.0f},
   {0.585938f, 0.828125f, 0.949219f, 1.0f},
   {0.578125f, 0.820312f, 0.945312f, 1.0f},
   {0.570312f, 0.8125f, 0.941406f, 1.0f},
   {0.558594f, 0.804688f, 0.9375f, 1.0f},
   {0.550781f, 0.796875f, 0.929688f, 1.0f},
   {0.542969f, 0.789062f, 0.925781f, 1.0f},
   {0.53125f, 0.78125f, 0.921875f, 1.0f},
   {0.523438f, 0.769531f, 0.917969f, 1.0f},
   {0.515625f, 0.761719f, 0.914062f, 1.0f},
   {0.503906f, 0.753906f, 0.90625f, 1.0f},
   {0.496094f, 0.746094f, 0.902344f, 1.0f},
   {0.488281f, 0.738281f, 0.898438f, 1.0f},
   {0.480469f, 0.730469f, 0.894531f, 1.0f},
   {0.46875f, 0.722656f, 0.890625f, 1.0f},
   {0.460938f, 0.714844f, 0.882812f, 1.0f},
   {0.453125f, 0.707031f, 0.878906f, 1.0f},
   {0.441406f, 0.699219f, 0.875f, 1.0f},
   {0.433594f, 0.691406f, 0.871094f, 1.0f},
   {0.425781f, 0.683594f, 0.863281f, 1.0f},
   {0.414062f, 0.675781f, 0.859375f, 1.0f},
   {0.40625f, 0.667969f, 0.855469f, 1.0f},
   {0.398438f, 0.660156f, 0.851562f, 1.0f},
   {0.390625f, 0.652344f, 0.847656f, 1.0f},
   {0.378906f, 0.644531f, 0.839844f, 1.0f},
   {0.371094f, 0.636719f, 0.835938f, 1.0f},
   {0.363281f, 0.625f, 0.832031f, 1.0f},
   {0.351562f, 0.617188f, 0.828125f, 1.0f},
   {0.34375f, 0.609375f, 0.824219f, 1.0f},
   {0.335938f, 0.601562f, 0.816406f, 1.0f},
   {0.324219f, 0.59375f, 0.8125f, 1.0f},
   {0.316406f, 0.585938f, 0.808594f, 1.0f},
   {0.308594f, 0.578125f, 0.804688f, 1.0f},
   {0.300781f, 0.570312f, 0.796875f, 1.0f},
   {0.28125f, 0.554688f, 0.789062f, 1.0f},
   {0.28125f, 0.558594f, 0.773438f, 1.0f},
   {0.28125f, 0.5625f, 0.761719f, 1.0f},
   {0.28125f, 0.566406f, 0.746094f, 1.0f},
   {0.28125f, 0.570312f, 0.734375f, 1.0f},
   {0.28125f, 0.574219f, 0.71875f, 1.0f},
   {0.28125f, 0.578125f, 0.707031f, 1.0f},
   {0.28125f, 0.582031f, 0.691406f, 1.0f},
   {0.28125f, 0.585938f, 0.675781f, 1.0f},
   {0.28125f, 0.589844f, 0.664062f, 1.0f},
   {0.28125f, 0.597656f, 0.648438f, 1.0f},
   {0.28125f, 0.601562f, 0.636719f, 1.0f},
   {0.28125f, 0.605469f, 0.621094f, 1.0f},
   {0.28125f, 0.609375f, 0.609375f, 1.0f},
   {0.28125f, 0.613281f, 0.59375f, 1.0f},
   {0.28125f, 0.617188f, 0.578125f, 1.0f},
   {0.28125f, 0.621094f, 0.566406f, 1.0f},
   {0.28125f, 0.625f, 0.550781f, 1.0f},
   {0.28125f, 0.628906f, 0.539062f, 1.0f},
   {0.285156f, 0.632812f, 0.523438f, 1.0f},
   {0.285156f, 0.636719f, 0.511719f, 1.0f},
   {0.285156f, 0.640625f, 0.496094f, 1.0f},
   {0.285156f, 0.644531f, 0.484375f, 1.0f},
   {0.285156f, 0.648438f, 0.46875f, 1.0f},
   {0.285156f, 0.652344f, 0.453125f, 1.0f},
   {0.285156f, 0.65625f, 0.441406f, 1.0f},
   {0.285156f, 0.660156f, 0.425781f, 1.0f},
   {0.285156f, 0.664062f, 0.414062f, 1.0f},
   {0.285156f, 0.671875f, 0.398438f, 1.0f},
   {0.285156f, 0.675781f, 0.386719f, 1.0f},
   {0.285156f, 0.679688f, 0.371094f, 1.0f},
   {0.285156f, 0.683594f, 0.355469f, 1.0f},
   {0.285156f, 0.6875f, 0.34375f, 1.0f},
   {0.285156f, 0.691406f, 0.328125f, 1.0f},
   {0.285156f, 0.695312f, 0.316406f, 1.0f},
   {0.285156f, 0.699219f, 0.300781f, 1.0f},
   {0.285156f, 0.707031f, 0.273438f, 1.0f},
   {0.304688f, 0.710938f, 0.277344f, 1.0f},
   {0.324219f, 0.71875f, 0.277344f, 1.0f},
   {0.339844f, 0.722656f, 0.28125f, 1.0f},
   {0.359375f, 0.730469f, 0.28125f, 1.0f},
   {0.378906f, 0.734375f, 0.285156f, 1.0f},
   {0.398438f, 0.738281f, 0.289062f, 1.0f},
   {0.414062f, 0.746094f, 0.289062f, 1.0f},
   {0.433594f, 0.75f, 0.292969f, 1.0f},
   {0.453125f, 0.753906f, 0.292969f, 1.0f},
   {0.472656f, 0.761719f, 0.296875f, 1.0f},
   {0.492188f, 0.765625f, 0.300781f, 1.0f},
   {0.507812f, 0.773438f, 0.300781f, 1.0f},
   {0.527344f, 0.777344f, 0.304688f, 1.0f},
   {0.546875f, 0.78125f, 0.304688f, 1.0f},
   {0.566406f, 0.789062f, 0.308594f, 1.0f},
   {0.585938f, 0.792969f, 0.3125f, 1.0f},
   {0.601562f, 0.796875f, 0.3125f, 1.0f},
   {0.621094f, 0.804688f, 0.316406f, 1.0f},
   {0.640625f, 0.808594f, 0.316406f, 1.0f},
   {0.660156f, 0.816406f, 0.320312f, 1.0f},
   {0.675781f, 0.820312f, 0.320312f, 1.0f},
   {0.695312f, 0.824219f, 0.324219f, 1.0f},
   {0.714844f, 0.832031f, 0.328125f, 1.0f},
   {0.734375f, 0.835938f, 0.328125f, 1.0f},
   {0.753906f, 0.839844f, 0.332031f, 1.0f},
   {0.769531f, 0.847656f, 0.332031f, 1.0f},
   {0.789062f, 0.851562f, 0.335938f, 1.0f},
   {0.808594f, 0.859375f, 0.339844f, 1.0f},
   {0.828125f, 0.863281f, 0.339844f, 1.0f},
   {0.847656f, 0.867188f, 0.34375f, 1.0f},
   {0.863281f, 0.875f, 0.34375f, 1.0f},
   {0.882812f, 0.878906f, 0.347656f, 1.0f},
   {0.902344f, 0.882812f, 0.351562f, 1.0f},
   {0.921875f, 0.890625f, 0.351562f, 1.0f},
   {0.9375f, 0.894531f, 0.355469f, 1.0f},
   {0.957031f, 0.902344f, 0.355469f, 1.0f},
   {0.976562f, 0.90625f, 0.359375f, 1.0f},
   {0.976562f, 0.894531f, 0.355469f, 1.0f},
   {0.976562f, 0.878906f, 0.347656f, 1.0f},
   {0.976562f, 0.867188f, 0.34375f, 1.0f},
   {0.972656f, 0.851562f, 0.335938f, 1.0f},
   {0.972656f, 0.839844f, 0.332031f, 1.0f},
   {0.972656f, 0.828125f, 0.328125f, 1.0f},
   {0.972656f, 0.8125f, 0.320312f, 1.0f},
   {0.972656f, 0.800781f, 0.316406f, 1.0f},
   {0.972656f, 0.785156f, 0.3125f, 1.0f},
   {0.972656f, 0.773438f, 0.304688f, 1.0f},
   {0.972656f, 0.761719f, 0.300781f, 1.0f},
   {0.96875f, 0.746094f, 0.292969f, 1.0f},
   {0.96875f, 0.734375f, 0.289062f, 1.0f},
   {0.96875f, 0.71875f, 0.285156f, 1.0f},
   {0.96875f, 0.707031f, 0.277344f, 1.0f},
   {0.96875f, 0.695312f, 0.273438f, 1.0f},
   {0.96875f, 0.679688f, 0.269531f, 1.0f},
   {0.96875f, 0.667969f, 0.261719f, 1.0f},
   {0.964844f, 0.652344f, 0.257812f, 1.0f},
   {0.964844f, 0.640625f, 0.25f, 1.0f},
   {0.964844f, 0.625f, 0.246094f, 1.0f},
   {0.964844f, 0.613281f, 0.242188f, 1.0f},
   {0.964844f, 0.601562f, 0.234375f, 1.0f},
   {0.964844f, 0.585938f, 0.230469f, 1.0f},
   {0.964844f, 0.574219f, 0.226562f, 1.0f},
   {0.960938f, 0.558594f, 0.21875f, 1.0f},
   {0.960938f, 0.546875f, 0.214844f, 1.0f},
   {0.960938f, 0.535156f, 0.207031f, 1.0f},
   {0.960938f, 0.519531f, 0.203125f, 1.0f},
   {0.960938f, 0.507812f, 0.199219f, 1.0f},
   {0.960938f, 0.492188f, 0.191406f, 1.0f},
   {0.960938f, 0.480469f, 0.1875f, 1.0f},
   {0.960938f, 0.46875f, 0.183594f, 1.0f},
   {0.957031f, 0.453125f, 0.175781f, 1.0f},
   {0.957031f, 0.441406f, 0.171875f, 1.0f},
   {0.957031f, 0.414062f, 0.160156f, 1.0f},
   {0.953125f, 0.40625f, 0.160156f, 1.0f},
   {0.949219f, 0.398438f, 0.160156f, 1.0f},
   {0.945312f, 0.390625f, 0.160156f, 1.0f},
   {0.941406f, 0.382812f, 0.160156f, 1.0f},
   {0.9375f, 0.375f, 0.160156f, 1.0f},
   {0.933594f, 0.367188f, 0.160156f, 1.0f},
   {0.933594f, 0.359375f, 0.160156f, 1.0f},
   {0.929688f, 0.351562f, 0.160156f, 1.0f},
   {0.925781f, 0.34375f, 0.160156f, 1.0f},
   {0.921875f, 0.335938f, 0.160156f, 1.0f},
   {0.917969f, 0.328125f, 0.160156f, 1.0f},
   {0.914062f, 0.320312f, 0.160156f, 1.0f},
   {0.910156f, 0.3125f, 0.160156f, 1.0f},
   {0.90625f, 0.304688f, 0.160156f, 1.0f},
   {0.902344f, 0.296875f, 0.160156f, 1.0f},
   {0.898438f, 0.289062f, 0.160156f, 1.0f},
   {0.894531f, 0.28125f, 0.160156f, 1.0f},
   {0.890625f, 0.273438f, 0.160156f, 1.0f},
   {0.890625f, 0.261719f, 0.15625f, 1.0f},
   {0.886719f, 0.253906f, 0.15625f, 1.0f},
   {0.882812f, 0.246094f, 0.15625f, 1.0f},
   {0.878906f, 0.238281f, 0.15625f, 1.0f},
   {0.875f, 0.230469f, 0.15625f, 1.0f},
   {0.871094f, 0.222656f, 0.15625f, 1.0f},
   {0.867188f, 0.214844f, 0.15625f, 1.0f},
   {0.863281f, 0.207031f, 0.15625f, 1.0f},
   {0.859375f, 0.199219f, 0.15625f, 1.0f},
   {0.855469f, 0.191406f, 0.15625f, 1.0f},
   {0.851562f, 0.183594f, 0.15625f, 1.0f},
   {0.847656f, 0.175781f, 0.15625f, 1.0f},
   {0.847656f, 0.167969f, 0.15625f, 1.0f},
   {0.84375f, 0.160156f, 0.15625f, 1.0f},
   {0.839844f, 0.152344f, 0.15625f, 1.0f},
   {0.835938f, 0.144531f, 0.15625f, 1.0f},
   {0.832031f, 0.136719f, 0.15625f, 1.0f},
   {0.824219f, 0.121094f, 0.15625f, 1.0f},
   {0.816406f, 0.121094f, 0.15625f, 1.0f},
   {0.808594f, 0.117188f, 0.152344f, 1.0f},
   {0.804688f, 0.117188f, 0.152344f, 1.0f},
   {0.796875f, 0.117188f, 0.148438f, 1.0f},
   {0.789062f, 0.117188f, 0.148438f, 1.0f},
   {0.78125f, 0.113281f, 0.148438f, 1.0f},
   {0.777344f, 0.113281f, 0.144531f, 1.0f},
   {0.769531f, 0.113281f, 0.144531f, 1.0f},
   {0.761719f, 0.113281f, 0.140625f, 1.0f},
   {0.753906f, 0.109375f, 0.140625f, 1.0f},
   {0.75f, 0.109375f, 0.140625f, 1.0f},
   {0.742188f, 0.109375f, 0.136719f, 1.0f},
   {0.734375f, 0.105469f, 0.136719f, 1.0f},
   {0.726562f, 0.105469f, 0.132812f, 1.0f},
   {0.722656f, 0.105469f, 0.132812f, 1.0f},
   {0.714844f, 0.105469f, 0.132812f, 1.0f},
   {0.707031f, 0.101562f, 0.128906f, 1.0f},
   {0.699219f, 0.101562f, 0.128906f, 1.0f},
   {0.695312f, 0.101562f, 0.125f, 1.0f},
   {0.6875f, 0.101562f, 0.125f, 1.0f},
   {0.679688f, 0.097656f, 0.121094f, 1.0f},
   {0.671875f, 0.097656f, 0.121094f, 1.0f},
   {0.667969f, 0.097656f, 0.121094f, 1.0f},
   {0.660156f, 0.097656f, 0.117188f, 1.0f},
   {0.652344f, 0.09375f, 0.117188f, 1.0f},
   {0.644531f, 0.09375f, 0.113281f, 1.0f},
   {0.640625f, 0.09375f, 0.113281f, 1.0f},
   {0.632812f, 0.089844f, 0.113281f, 1.0f},
   {0.625f, 0.089844f, 0.109375f, 1.0f},
   {0.617188f, 0.089844f, 0.109375f, 1.0f},
   {0.613281f, 0.089844f, 0.105469f, 1.0f},
   {0.605469f, 0.085938f, 0.105469f, 1.0f},
   {0.597656f, 0.085938f, 0.105469f, 1.0f},
   {0.589844f, 0.085938f, 0.101562f, 1.0f},
   {0.585938f, 0.085938f, 0.101562f, 1.0f},
   {0.570312f, 0.082031f, 0.097656f, 1.0f},
});

const Palette BPAL_31 = Palette("seq25",
{
   {0.597656f, 0.058594f, 0.058594f, 1.0f},
   {0.695312f, 0.171875f, 0.171875f, 1.0f},
   {0.796875f, 0.316406f, 0.316406f, 1.0f},
   {0.894531f, 0.492188f, 0.492188f, 1.0f},
   {0.996094f, 0.695312f, 0.695312f, 1.0f},
   {0.597656f, 0.328125f, 0.058594f, 1.0f},
   {0.695312f, 0.433594f, 0.171875f, 1.0f},
   {0.796875f, 0.554688f, 0.316406f, 1.0f},
   {0.894531f, 0.691406f, 0.492188f, 1.0f},
   {0.996094f, 0.84375f, 0.695312f, 1.0f},
   {0.417969f, 0.597656f, 0.058594f, 1.0f},
   {0.519531f, 0.695312f, 0.171875f, 1.0f},
   {0.636719f, 0.796875f, 0.316406f, 1.0f},
   {0.761719f, 0.894531f, 0.492188f, 1.0f},
   {0.894531f, 0.996094f, 0.695312f, 1.0f},
   {0.058594f, 0.417969f, 0.597656f, 1.0f},
   {0.171875f, 0.519531f, 0.695312f, 1.0f},
   {0.316406f, 0.636719f, 0.796875f, 1.0f},
   {0.492188f, 0.761719f, 0.894531f, 1.0f},
   {0.695312f, 0.894531f, 0.996094f, 1.0f},
   {0.148438f, 0.058594f, 0.597656f, 1.0f},
   {0.257812f, 0.171875f, 0.695312f, 1.0f},
   {0.394531f, 0.316406f, 0.796875f, 1.0f},
   {0.558594f, 0.492188f, 0.894531f, 1.0f},
   {0.746094f, 0.695312f, 0.996094f, 1.0f},
});

const Palette BPAL_32 = Palette("terrain",
{
   {0.194771f, 0.210458f, 0.610458f, 1.0f},
   {0.184314f, 0.231373f, 0.631373f, 1.0f},
   {0.173856f, 0.252288f, 0.652288f, 1.0f},
   {0.163399f, 0.273203f, 0.673203f, 1.0f},
   {0.152941f, 0.294118f, 0.694118f, 1.0f},
   {0.142484f, 0.315033f, 0.715033f, 1.0f},
   {0.132026f, 0.335948f, 0.735948f, 1.0f},
   {0.121569f, 0.356863f, 0.756863f, 1.0f},
   {0.111111f, 0.377778f, 0.777778f, 1.0f},
   {0.105882f, 0.388235f, 0.788235f, 1.0f},
   {0.090196f, 0.419608f, 0.819608f, 1.0f},
   {0.084967f, 0.430065f, 0.830065f, 1.0f},
   {0.069281f, 0.461438f, 0.861438f, 1.0f},
   {0.064052f, 0.471895f, 0.871895f, 1.0f},
   {0.048366f, 0.503268f, 0.903268f, 1.0f},
   {0.043137f, 0.513725f, 0.913725f, 1.0f},
   {0.027451f, 0.545098f, 0.945098f, 1.0f},
   {0.016993f, 0.566013f, 0.966013f, 1.0f},
   {0.011765f, 0.576471f, 0.976471f, 1.0f},
   {0.0f, 0.605882f, 0.982353f, 1.0f},
   {0.0f, 0.621569f, 0.935294f, 1.0f},
   {0.0f, 0.637255f, 0.888235f, 1.0f},
   {0.0f, 0.645098f, 0.864706f, 1.0f},
   {0.0f, 0.668627f, 0.794118f, 1.0f},
   {0.0f, 0.684314f, 0.747059f, 1.0f},
   {0.0f, 0.7f, 0.7f, 1.0f},
   {0.0f, 0.707843f, 0.676471f, 1.0f},
   {0.0f, 0.731373f, 0.605882f, 1.0f},
   {0.0f, 0.747059f, 0.558824f, 1.0f},
   {0.0f, 0.762745f, 0.511765f, 1.0f},
   {0.0f, 0.770588f, 0.488235f, 1.0f},
   {0.0f, 0.794118f, 0.417647f, 1.0f},
   {0.019608f, 0.803922f, 0.403922f, 1.0f},
   {0.05098f, 0.810196f, 0.410196f, 1.0f},
   {0.082353f, 0.816471f, 0.416471f, 1.0f},
   {0.113725f, 0.822745f, 0.422745f, 1.0f},
   {0.145098f, 0.82902f, 0.42902f, 1.0f},
   {0.160784f, 0.832157f, 0.432157f, 1.0f},
   {0.207843f, 0.841569f, 0.441569f, 1.0f},
   {0.239216f, 0.847843f, 0.447843f, 1.0f},
   {0.270588f, 0.854118f, 0.454118f, 1.0f},
   {0.301961f, 0.860392f, 0.460392f, 1.0f},
   {0.333333f, 0.866667f, 0.466667f, 1.0f},
   {0.364706f, 0.872941f, 0.472941f, 1.0f},
   {0.396078f, 0.879216f, 0.479216f, 1.0f},
   {0.411765f, 0.882353f, 0.482353f, 1.0f},
   {0.458824f, 0.891765f, 0.491765f, 1.0f},
   {0.490196f, 0.898039f, 0.498039f, 1.0f},
   {0.521569f, 0.904314f, 0.504314f, 1.0f},
   {0.552941f, 0.910588f, 0.510588f, 1.0f},
   {0.584314f, 0.916863f, 0.516863f, 1.0f},
   {0.615686f, 0.923137f, 0.523137f, 1.0f},
   {0.647059f, 0.929412f, 0.529412f, 1.0f},
   {0.662745f, 0.932549f, 0.532549f, 1.0f},
   {0.709804f, 0.941961f, 0.541961f, 1.0f},
   {0.741176f, 0.948235f, 0.548235f, 1.0f},
   {0.772549f, 0.95451f, 0.55451f, 1.0f},
   {0.803922f, 0.960784f, 0.560784f, 1.0f},
   {0.835294f, 0.967059f, 0.567059f, 1.0f},
   {0.866667f, 0.973333f, 0.573333f, 1.0f},
   {0.898039f, 0.979608f, 0.579608f, 1.0f},
   {0.913725f, 0.982745f, 0.582745f, 1.0f},
   {0.960784f, 0.992157f, 0.592157f, 1.0f},
   {0.992157f, 0.998431f, 0.598431f, 1.0f},
   {0.988235f, 0.984941f, 0.593647f, 1.0f},
   {0.972549f, 0.964863f, 0.585176f, 1.0f},
   {0.956863f, 0.944784f, 0.576706f, 1.0f},
   {0.941176f, 0.924706f, 0.568235f, 1.0f},
   {0.92549f, 0.904627f, 0.559765f, 1.0f},
   {0.909804f, 0.884549f, 0.551294f, 1.0f},
   {0.894118f, 0.864471f, 0.542824f, 1.0f},
   {0.878431f, 0.844392f, 0.534353f, 1.0f},
   {0.862745f, 0.824314f, 0.525882f, 1.0f},
   {0.847059f, 0.804235f, 0.517412f, 1.0f},
   {0.831373f, 0.784157f, 0.508941f, 1.0f},
   {0.823529f, 0.774118f, 0.504706f, 1.0f},
   {0.8f, 0.744f, 0.492f, 1.0f},
   {0.784314f, 0.723922f, 0.483529f, 1.0f},
   {0.768627f, 0.703843f, 0.475059f, 1.0f},
   {0.752941f, 0.683765f, 0.466588f, 1.0f},
   {0.737255f, 0.663686f, 0.458118f, 1.0f},
   {0.721569f, 0.643608f, 0.449647f, 1.0f},
   {0.705882f, 0.623529f, 0.441176f, 1.0f},
   {0.690196f, 0.603451f, 0.432706f, 1.0f},
   {0.67451f, 0.583373f, 0.424235f, 1.0f},
   {0.658824f, 0.563294f, 0.415765f, 1.0f},
   {0.643137f, 0.543216f, 0.407294f, 1.0f},
   {0.627451f, 0.523137f, 0.398824f, 1.0f},
   {0.611765f, 0.503059f, 0.390353f, 1.0f},
   {0.596078f, 0.48298f, 0.381882f, 1.0f},
   {0.580392f, 0.462902f, 0.373412f, 1.0f},
   {0.572549f, 0.452863f, 0.369176f, 1.0f},
   {0.54902f, 0.422745f, 0.356471f, 1.0f},
   {0.533333f, 0.402667f, 0.348f, 1.0f},
   {0.517647f, 0.382588f, 0.339529f, 1.0f},
   {0.501961f, 0.36251f, 0.331059f, 1.0f},
   {0.513725f, 0.377569f, 0.348392f, 1.0f},
   {0.529412f, 0.397647f, 0.369412f, 1.0f},
   {0.545098f, 0.417725f, 0.390431f, 1.0f},
   {0.560784f, 0.437804f, 0.411451f, 1.0f},
   {0.576471f, 0.457882f, 0.432471f, 1.0f},
   {0.592157f, 0.477961f, 0.45349f, 1.0f},
   {0.607843f, 0.498039f, 0.47451f, 1.0f},
   {0.623529f, 0.518118f, 0.495529f, 1.0f},
   {0.639216f, 0.538196f, 0.516549f, 1.0f},
   {0.654902f, 0.558275f, 0.537569f, 1.0f},
   {0.670588f, 0.578353f, 0.558588f, 1.0f},
   {0.678431f, 0.588392f, 0.569098f, 1.0f},
   {0.701961f, 0.61851f, 0.600627f, 1.0f},
   {0.717647f, 0.638588f, 0.621647f, 1.0f},
   {0.733333f, 0.658667f, 0.642667f, 1.0f},
   {0.74902f, 0.678745f, 0.663686f, 1.0f},
   {0.764706f, 0.698824f, 0.684706f, 1.0f},
   {0.780392f, 0.718902f, 0.705725f, 1.0f},
   {0.796078f, 0.73898f, 0.726745f, 1.0f},
   {0.811765f, 0.759059f, 0.747765f, 1.0f},
   {0.827451f, 0.779137f, 0.768784f, 1.0f},
   {0.843137f, 0.799216f, 0.789804f, 1.0f},
   {0.858824f, 0.819294f, 0.810824f, 1.0f},
   {0.87451f, 0.839373f, 0.831843f, 1.0f},
   {0.890196f, 0.859451f, 0.852863f, 1.0f},
   {0.905882f, 0.879529f, 0.873882f, 1.0f},
   {0.921569f, 0.899608f, 0.894902f, 1.0f},
   {0.929412f, 0.909647f, 0.905412f, 1.0f},
   {0.952941f, 0.939765f, 0.936941f, 1.0f},
   {0.968627f, 0.959843f, 0.957961f, 1.0f},
   {0.984314f, 0.979922f, 0.97898f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
});

const Palette BPAL_33 = Palette("bwor",
{
   {0.105469f, 0.171875f, 0.382812f, 1.0f},
   {0.105469f, 0.179688f, 0.394531f, 1.0f},
   {0.109375f, 0.1875f, 0.40625f, 1.0f},
   {0.109375f, 0.195312f, 0.417969f, 1.0f},
   {0.113281f, 0.203125f, 0.429688f, 1.0f},
   {0.113281f, 0.207031f, 0.4375f, 1.0f},
   {0.113281f, 0.214844f, 0.449219f, 1.0f},
   {0.117188f, 0.222656f, 0.460938f, 1.0f},
   {0.117188f, 0.230469f, 0.472656f, 1.0f},
   {0.117188f, 0.238281f, 0.484375f, 1.0f},
   {0.121094f, 0.246094f, 0.496094f, 1.0f},
   {0.121094f, 0.253906f, 0.507812f, 1.0f},
   {0.125f, 0.261719f, 0.519531f, 1.0f},
   {0.125f, 0.265625f, 0.527344f, 1.0f},
   {0.125f, 0.273438f, 0.539062f, 1.0f},
   {0.128906f, 0.28125f, 0.550781f, 1.0f},
   {0.128906f, 0.289062f, 0.5625f, 1.0f},
   {0.128906f, 0.296875f, 0.574219f, 1.0f},
   {0.132812f, 0.304688f, 0.585938f, 1.0f},
   {0.132812f, 0.3125f, 0.597656f, 1.0f},
   {0.136719f, 0.320312f, 0.609375f, 1.0f},
   {0.136719f, 0.324219f, 0.617188f, 1.0f},
   {0.136719f, 0.332031f, 0.628906f, 1.0f},
   {0.140625f, 0.347656f, 0.652344f, 1.0f},
   {0.148438f, 0.359375f, 0.660156f, 1.0f},
   {0.15625f, 0.371094f, 0.667969f, 1.0f},
   {0.164062f, 0.382812f, 0.675781f, 1.0f},
   {0.175781f, 0.398438f, 0.683594f, 1.0f},
   {0.183594f, 0.410156f, 0.691406f, 1.0f},
   {0.191406f, 0.421875f, 0.699219f, 1.0f},
   {0.199219f, 0.433594f, 0.707031f, 1.0f},
   {0.207031f, 0.445312f, 0.714844f, 1.0f},
   {0.214844f, 0.457031f, 0.722656f, 1.0f},
   {0.222656f, 0.46875f, 0.730469f, 1.0f},
   {0.230469f, 0.480469f, 0.738281f, 1.0f},
   {0.242188f, 0.496094f, 0.75f, 1.0f},
   {0.25f, 0.507812f, 0.757812f, 1.0f},
   {0.257812f, 0.519531f, 0.765625f, 1.0f},
   {0.265625f, 0.53125f, 0.773438f, 1.0f},
   {0.273438f, 0.542969f, 0.78125f, 1.0f},
   {0.28125f, 0.554688f, 0.789062f, 1.0f},
   {0.289062f, 0.566406f, 0.796875f, 1.0f},
   {0.296875f, 0.578125f, 0.804688f, 1.0f},
   {0.308594f, 0.59375f, 0.8125f, 1.0f},
   {0.316406f, 0.605469f, 0.820312f, 1.0f},
   {0.324219f, 0.617188f, 0.828125f, 1.0f},
   {0.339844f, 0.640625f, 0.84375f, 1.0f},
   {0.351562f, 0.648438f, 0.847656f, 1.0f},
   {0.363281f, 0.660156f, 0.855469f, 1.0f},
   {0.375f, 0.667969f, 0.859375f, 1.0f},
   {0.386719f, 0.675781f, 0.863281f, 1.0f},
   {0.398438f, 0.683594f, 0.867188f, 1.0f},
   {0.410156f, 0.695312f, 0.875f, 1.0f},
   {0.417969f, 0.703125f, 0.878906f, 1.0f},
   {0.429688f, 0.710938f, 0.882812f, 1.0f},
   {0.441406f, 0.71875f, 0.890625f, 1.0f},
   {0.453125f, 0.730469f, 0.894531f, 1.0f},
   {0.464844f, 0.738281f, 0.898438f, 1.0f},
   {0.476562f, 0.746094f, 0.90625f, 1.0f},
   {0.488281f, 0.753906f, 0.910156f, 1.0f},
   {0.5f, 0.765625f, 0.914062f, 1.0f},
   {0.511719f, 0.773438f, 0.917969f, 1.0f},
   {0.523438f, 0.78125f, 0.925781f, 1.0f},
   {0.535156f, 0.789062f, 0.929688f, 1.0f},
   {0.546875f, 0.800781f, 0.933594f, 1.0f},
   {0.554688f, 0.808594f, 0.941406f, 1.0f},
   {0.566406f, 0.816406f, 0.945312f, 1.0f},
   {0.578125f, 0.824219f, 0.949219f, 1.0f},
   {0.589844f, 0.835938f, 0.953125f, 1.0f},
   {0.613281f, 0.851562f, 0.964844f, 1.0f},
   {0.621094f, 0.855469f, 0.964844f, 1.0f},
   {0.632812f, 0.859375f, 0.964844f, 1.0f},
   {0.640625f, 0.863281f, 0.964844f, 1.0f},
   {0.652344f, 0.867188f, 0.964844f, 1.0f},
   {0.660156f, 0.867188f, 0.964844f, 1.0f},
   {0.671875f, 0.871094f, 0.96875f, 1.0f},
   {0.679688f, 0.875f, 0.96875f, 1.0f},
   {0.6875f, 0.878906f, 0.96875f, 1.0f},
   {0.699219f, 0.882812f, 0.96875f, 1.0f},
   {0.707031f, 0.886719f, 0.96875f, 1.0f},
   {0.71875f, 0.890625f, 0.96875f, 1.0f},
   {0.726562f, 0.894531f, 0.96875f, 1.0f},
   {0.734375f, 0.894531f, 0.96875f, 1.0f},
   {0.746094f, 0.898438f, 0.96875f, 1.0f},
   {0.753906f, 0.902344f, 0.96875f, 1.0f},
   {0.765625f, 0.90625f, 0.96875f, 1.0f},
   {0.773438f, 0.910156f, 0.96875f, 1.0f},
   {0.785156f, 0.914062f, 0.972656f, 1.0f},
   {0.792969f, 0.917969f, 0.972656f, 1.0f},
   {0.800781f, 0.921875f, 0.972656f, 1.0f},
   {0.8125f, 0.921875f, 0.972656f, 1.0f},
   {0.820312f, 0.925781f, 0.972656f, 1.0f},
   {0.839844f, 0.933594f, 0.972656f, 1.0f},
   {0.847656f, 0.9375f, 0.972656f, 1.0f},
   {0.851562f, 0.9375f, 0.976562f, 1.0f},
   {0.859375f, 0.941406f, 0.976562f, 1.0f},
   {0.867188f, 0.945312f, 0.976562f, 1.0f},
   {0.871094f, 0.945312f, 0.976562f, 1.0f},
   {0.878906f, 0.949219f, 0.980469f, 1.0f},
   {0.886719f, 0.953125f, 0.980469f, 1.0f},
   {0.890625f, 0.953125f, 0.980469f, 1.0f},
   {0.898438f, 0.957031f, 0.980469f, 1.0f},
   {0.90625f, 0.960938f, 0.984375f, 1.0f},
   {0.910156f, 0.960938f, 0.984375f, 1.0f},
   {0.917969f, 0.964844f, 0.984375f, 1.0f},
   {0.925781f, 0.96875f, 0.984375f, 1.0f},
   {0.929688f, 0.96875f, 0.988281f, 1.0f},
   {0.9375f, 0.972656f, 0.988281f, 1.0f},
   {0.945312f, 0.976562f, 0.988281f, 1.0f},
   {0.949219f, 0.976562f, 0.988281f, 1.0f},
   {0.957031f, 0.980469f, 0.992188f, 1.0f},
   {0.964844f, 0.984375f, 0.992188f, 1.0f},
   {0.96875f, 0.984375f, 0.992188f, 1.0f},
   {0.976562f, 0.988281f, 0.992188f, 1.0f},
   {0.984375f, 0.992188f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.996094f, 0.992188f, 0.980469f, 1.0f},
   {0.996094f, 0.988281f, 0.964844f, 1.0f},
   {0.996094f, 0.988281f, 0.949219f, 1.0f},
   {0.996094f, 0.984375f, 0.929688f, 1.0f},
   {0.992188f, 0.980469f, 0.914062f, 1.0f},
   {0.992188f, 0.976562f, 0.898438f, 1.0f},
   {0.992188f, 0.972656f, 0.882812f, 1.0f},
   {0.992188f, 0.96875f, 0.867188f, 1.0f},
   {0.992188f, 0.96875f, 0.851562f, 1.0f},
   {0.992188f, 0.964844f, 0.832031f, 1.0f},
   {0.992188f, 0.960938f, 0.816406f, 1.0f},
   {0.992188f, 0.957031f, 0.800781f, 1.0f},
   {0.988281f, 0.953125f, 0.785156f, 1.0f},
   {0.988281f, 0.949219f, 0.769531f, 1.0f},
   {0.988281f, 0.949219f, 0.753906f, 1.0f},
   {0.988281f, 0.945312f, 0.734375f, 1.0f},
   {0.988281f, 0.941406f, 0.71875f, 1.0f},
   {0.988281f, 0.9375f, 0.703125f, 1.0f},
   {0.988281f, 0.933594f, 0.6875f, 1.0f},
   {0.988281f, 0.929688f, 0.671875f, 1.0f},
   {0.984375f, 0.929688f, 0.65625f, 1.0f},
   {0.984375f, 0.925781f, 0.636719f, 1.0f},
   {0.984375f, 0.917969f, 0.605469f, 1.0f},
   {0.984375f, 0.910156f, 0.589844f, 1.0f},
   {0.984375f, 0.898438f, 0.570312f, 1.0f},
   {0.984375f, 0.890625f, 0.554688f, 1.0f},
   {0.984375f, 0.878906f, 0.539062f, 1.0f},
   {0.984375f, 0.871094f, 0.519531f, 1.0f},
   {0.988281f, 0.859375f, 0.503906f, 1.0f},
   {0.988281f, 0.851562f, 0.484375f, 1.0f},
   {0.988281f, 0.839844f, 0.46875f, 1.0f},
   {0.988281f, 0.832031f, 0.453125f, 1.0f},
   {0.988281f, 0.820312f, 0.433594f, 1.0f},
   {0.988281f, 0.8125f, 0.417969f, 1.0f},
   {0.988281f, 0.804688f, 0.402344f, 1.0f},
   {0.988281f, 0.792969f, 0.382812f, 1.0f},
   {0.988281f, 0.785156f, 0.367188f, 1.0f},
   {0.988281f, 0.773438f, 0.347656f, 1.0f},
   {0.988281f, 0.765625f, 0.332031f, 1.0f},
   {0.988281f, 0.753906f, 0.316406f, 1.0f},
   {0.992188f, 0.746094f, 0.296875f, 1.0f},
   {0.992188f, 0.734375f, 0.28125f, 1.0f},
   {0.992188f, 0.726562f, 0.265625f, 1.0f},
   {0.992188f, 0.714844f, 0.246094f, 1.0f},
   {0.992188f, 0.707031f, 0.230469f, 1.0f},
   {0.992188f, 0.6875f, 0.195312f, 1.0f},
   {0.992188f, 0.675781f, 0.195312f, 1.0f},
   {0.988281f, 0.664062f, 0.191406f, 1.0f},
   {0.988281f, 0.652344f, 0.191406f, 1.0f},
   {0.988281f, 0.640625f, 0.191406f, 1.0f},
   {0.984375f, 0.628906f, 0.1875f, 1.0f},
   {0.984375f, 0.621094f, 0.1875f, 1.0f},
   {0.980469f, 0.609375f, 0.183594f, 1.0f},
   {0.980469f, 0.597656f, 0.183594f, 1.0f},
   {0.980469f, 0.585938f, 0.183594f, 1.0f},
   {0.976562f, 0.574219f, 0.179688f, 1.0f},
   {0.976562f, 0.5625f, 0.179688f, 1.0f},
   {0.976562f, 0.550781f, 0.179688f, 1.0f},
   {0.972656f, 0.539062f, 0.175781f, 1.0f},
   {0.972656f, 0.527344f, 0.175781f, 1.0f},
   {0.96875f, 0.515625f, 0.171875f, 1.0f},
   {0.96875f, 0.503906f, 0.171875f, 1.0f},
   {0.96875f, 0.492188f, 0.171875f, 1.0f},
   {0.964844f, 0.484375f, 0.167969f, 1.0f},
   {0.964844f, 0.472656f, 0.167969f, 1.0f},
   {0.964844f, 0.460938f, 0.167969f, 1.0f},
   {0.960938f, 0.449219f, 0.164062f, 1.0f},
   {0.960938f, 0.4375f, 0.164062f, 1.0f},
   {0.957031f, 0.414062f, 0.160156f, 1.0f},
   {0.953125f, 0.402344f, 0.160156f, 1.0f},
   {0.945312f, 0.390625f, 0.160156f, 1.0f},
   {0.941406f, 0.378906f, 0.160156f, 1.0f},
   {0.933594f, 0.367188f, 0.160156f, 1.0f},
   {0.929688f, 0.351562f, 0.160156f, 1.0f},
   {0.925781f, 0.339844f, 0.160156f, 1.0f},
   {0.917969f, 0.328125f, 0.160156f, 1.0f},
   {0.914062f, 0.316406f, 0.160156f, 1.0f},
   {0.90625f, 0.304688f, 0.160156f, 1.0f},
   {0.902344f, 0.292969f, 0.160156f, 1.0f},
   {0.894531f, 0.28125f, 0.160156f, 1.0f},
   {0.890625f, 0.269531f, 0.160156f, 1.0f},
   {0.886719f, 0.253906f, 0.15625f, 1.0f},
   {0.878906f, 0.242188f, 0.15625f, 1.0f},
   {0.875f, 0.230469f, 0.15625f, 1.0f},
   {0.867188f, 0.21875f, 0.15625f, 1.0f},
   {0.863281f, 0.207031f, 0.15625f, 1.0f},
   {0.859375f, 0.195312f, 0.15625f, 1.0f},
   {0.851562f, 0.183594f, 0.15625f, 1.0f},
   {0.847656f, 0.171875f, 0.15625f, 1.0f},
   {0.839844f, 0.15625f, 0.15625f, 1.0f},
   {0.835938f, 0.144531f, 0.15625f, 1.0f},
   {0.824219f, 0.121094f, 0.15625f, 1.0f},
   {0.8125f, 0.121094f, 0.152344f, 1.0f},
   {0.804688f, 0.117188f, 0.152344f, 1.0f},
   {0.792969f, 0.117188f, 0.148438f, 1.0f},
   {0.78125f, 0.113281f, 0.148438f, 1.0f},
   {0.769531f, 0.113281f, 0.144531f, 1.0f},
   {0.761719f, 0.113281f, 0.140625f, 1.0f},
   {0.75f, 0.109375f, 0.140625f, 1.0f},
   {0.738281f, 0.109375f, 0.136719f, 1.0f},
   {0.730469f, 0.105469f, 0.132812f, 1.0f},
   {0.71875f, 0.105469f, 0.132812f, 1.0f},
   {0.707031f, 0.101562f, 0.128906f, 1.0f},
   {0.699219f, 0.101562f, 0.128906f, 1.0f},
   {0.6875f, 0.101562f, 0.125f, 1.0f},
   {0.675781f, 0.097656f, 0.121094f, 1.0f},
   {0.664062f, 0.097656f, 0.121094f, 1.0f},
   {0.65625f, 0.09375f, 0.117188f, 1.0f},
   {0.644531f, 0.09375f, 0.113281f, 1.0f},
   {0.632812f, 0.09375f, 0.113281f, 1.0f},
   {0.625f, 0.089844f, 0.109375f, 1.0f},
   {0.613281f, 0.089844f, 0.109375f, 1.0f},
   {0.601562f, 0.085938f, 0.105469f, 1.0f},
   {0.589844f, 0.085938f, 0.101562f, 1.0f},
   {0.570312f, 0.082031f, 0.097656f, 1.0f},
});

const Palette BPAL_34 = Palette("19-lev",
{
   {0.992188f, 0.992188f, 0.992188f, 1.0f},
   {0.992188f, 0.992188f, 0.625f, 1.0f},
   {0.992188f, 0.992188f, 0.386719f, 1.0f},
   {0.953125f, 0.953125f, 0.429688f, 1.0f},
   {0.996094f, 0.820312f, 0.136719f, 1.0f},
   {0.996094f, 0.636719f, 0.097656f, 1.0f},
   {0.996094f, 0.347656f, 0.097656f, 1.0f},
   {0.898438f, 0.476562f, 0.394531f, 1.0f},
   {0.925781f, 0.566406f, 0.484375f, 1.0f},
   {0.933594f, 0.695312f, 0.570312f, 1.0f},
   {0.964844f, 0.777344f, 0.695312f, 1.0f},
   {0.996094f, 0.898438f, 0.898438f, 1.0f},
   {0.839844f, 0.878906f, 0.996094f, 1.0f},
   {0.585938f, 0.820312f, 0.996094f, 1.0f},
   {0.117188f, 0.738281f, 0.996094f, 1.0f},
   {0.078125f, 0.621094f, 0.996094f, 1.0f},
   {0.039062f, 0.421875f, 0.9375f, 1.0f},
   {0.042969f, 0.453125f, 0.996094f, 1.0f},
   {0.039062f, 0.40625f, 0.78125f, 1.0f},
   {0.0f, 0.347656f, 0.621094f, 1.0f},
});

const Palette BPAL_35 = Palette("lithology",
{
   {0.988281f, 0.953125f, 0.246094f, 1.0f},
   {0.996094f, 0.996094f, 0.535156f, 1.0f},
   {0.996094f, 0.824219f, 0.269531f, 1.0f},
   {0.996094f, 0.792969f, 0.136719f, 1.0f},
   {0.996094f, 0.996094f, 0.832031f, 1.0f},
   {0.921875f, 0.703125f, 0.0f, 1.0f},
   {0.996094f, 0.976562f, 0.910156f, 1.0f},
   {0.996094f, 0.976562f, 0.78125f, 1.0f},
   {0.996094f, 0.996094f, 0.714844f, 1.0f},
   {0.976562f, 0.929688f, 0.476562f, 1.0f},
   {0.953125f, 0.933594f, 0.890625f, 1.0f},
   {0.941406f, 0.894531f, 0.871094f, 1.0f},
   {0.890625f, 0.8125f, 0.742188f, 1.0f},
   {0.890625f, 0.84375f, 0.742188f, 1.0f},
   {0.996094f, 0.960938f, 0.847656f, 1.0f},
   {0.875f, 0.769531f, 0.617188f, 1.0f},
   {0.875f, 0.820312f, 0.703125f, 1.0f},
   {0.855469f, 0.796875f, 0.660156f, 1.0f},
   {0.957031f, 0.878906f, 0.738281f, 1.0f},
   {0.875f, 0.6875f, 0.617188f, 1.0f},
   {0.808594f, 0.730469f, 0.558594f, 1.0f},
   {0.878906f, 0.886719f, 0.761719f, 1.0f},
   {0.894531f, 0.855469f, 0.699219f, 1.0f},
   {0.859375f, 0.832031f, 0.703125f, 1.0f},
   {0.824219f, 0.789062f, 0.621094f, 1.0f},
   {0.785156f, 0.742188f, 0.535156f, 1.0f},
   {0.734375f, 0.683594f, 0.421875f, 1.0f},
   {0.746094f, 0.652344f, 0.261719f, 1.0f},
   {0.820312f, 0.757812f, 0.484375f, 1.0f},
   {0.996094f, 0.929688f, 0.746094f, 1.0f},
   {0.996094f, 0.894531f, 0.613281f, 1.0f},
   {0.996094f, 0.871094f, 0.519531f, 1.0f},
   {0.992188f, 0.898438f, 0.4375f, 1.0f},
   {0.992188f, 0.882812f, 0.34375f, 1.0f},
   {0.992188f, 0.855469f, 0.179688f, 1.0f},
   {0.964844f, 0.949219f, 0.628906f, 1.0f},
   {0.996094f, 0.808594f, 0.503906f, 1.0f},
   {0.996094f, 0.796875f, 0.597656f, 1.0f},
   {0.996094f, 0.886719f, 0.535156f, 1.0f},
   {0.996094f, 0.855469f, 0.402344f, 1.0f},
   {0.570312f, 0.859375f, 0.714844f, 1.0f},
   {0.847656f, 0.988281f, 0.824219f, 1.0f},
   {0.808594f, 0.933594f, 0.871094f, 1.0f},
   {0.832031f, 0.898438f, 0.796875f, 1.0f},
   {0.75f, 0.8125f, 0.75f, 1.0f},
   {0.671875f, 0.890625f, 0.78125f, 1.0f},
   {0.855469f, 0.992188f, 0.734375f, 1.0f},
   {0.730469f, 0.996094f, 0.863281f, 1.0f},
   {0.878906f, 0.9375f, 0.84375f, 1.0f},
   {0.835938f, 0.992188f, 0.601562f, 1.0f},
   {0.582031f, 0.996094f, 0.789062f, 1.0f},
   {0.800781f, 0.996094f, 0.847656f, 1.0f},
   {0.648438f, 0.984375f, 0.664062f, 1.0f},
   {0.792969f, 0.933594f, 0.804688f, 1.0f},
   {0.601562f, 0.804688f, 0.992188f, 1.0f},
   {0.410156f, 0.808594f, 0.609375f, 1.0f},
   {0.738281f, 0.855469f, 0.941406f, 1.0f},
   {0.71875f, 0.914062f, 0.761719f, 1.0f},
   {0.5625f, 0.644531f, 0.394531f, 1.0f},
   {0.714844f, 0.847656f, 0.796875f, 1.0f},
   {0.652344f, 0.726562f, 0.523438f, 1.0f},
   {0.644531f, 0.664062f, 0.675781f, 1.0f},
   {0.550781f, 0.742188f, 0.800781f, 1.0f},
   {0.730469f, 0.75f, 0.769531f, 1.0f},
   {0.335938f, 0.875f, 0.984375f, 1.0f},
   {0.261719f, 0.683594f, 0.972656f, 1.0f},
   {0.417969f, 0.761719f, 0.996094f, 1.0f},
   {0.21875f, 0.703125f, 0.691406f, 1.0f},
   {0.375f, 0.796875f, 0.746094f, 1.0f},
   {0.746094f, 0.886719f, 0.859375f, 1.0f},
   {0.800781f, 0.867188f, 0.996094f, 1.0f},
   {0.003906f, 0.609375f, 0.800781f, 1.0f},
   {0.601562f, 0.746094f, 0.75f, 1.0f},
   {0.75f, 0.679688f, 0.710938f, 1.0f},
   {0.722656f, 0.582031f, 0.59375f, 1.0f},
   {0.847656f, 0.757812f, 0.636719f, 1.0f},
   {0.507812f, 0.0f, 0.253906f, 1.0f},
   {0.429688f, 0.285156f, 0.035156f, 1.0f},
   {0.996094f, 0.714844f, 0.867188f, 1.0f},
   {0.996094f, 0.761719f, 0.890625f, 1.0f},
   {0.996094f, 0.816406f, 0.914062f, 1.0f},
   {0.996094f, 0.761719f, 0.96875f, 1.0f},
   {0.996094f, 0.894531f, 0.949219f, 1.0f},
   {0.996094f, 0.875f, 0.867188f, 1.0f},
   {0.972656f, 0.824219f, 0.824219f, 1.0f},
   {0.996094f, 0.949219f, 0.785156f, 1.0f},
   {0.996094f, 0.933594f, 0.847656f, 1.0f},
   {0.996094f, 0.894531f, 0.761719f, 1.0f},
   {0.996094f, 0.832031f, 0.613281f, 1.0f},
   {0.996094f, 0.632812f, 0.152344f, 1.0f},
   {0.996094f, 0.753906f, 0.433594f, 1.0f},
   {0.953125f, 0.542969f, 0.0f, 1.0f},
   {0.992188f, 0.859375f, 0.492188f, 1.0f},
   {0.992188f, 0.796875f, 0.40625f, 1.0f},
   {0.992188f, 0.773438f, 0.164062f, 1.0f},
   {0.992188f, 0.800781f, 0.671875f, 1.0f},
   {0.992188f, 0.714844f, 0.523438f, 1.0f},
   {0.992188f, 0.625f, 0.375f, 1.0f},
   {0.992188f, 0.527344f, 0.210938f, 1.0f},
   {0.992188f, 0.457031f, 0.09375f, 1.0f},
   {0.917969f, 0.375f, 0.003906f, 1.0f},
   {0.785156f, 0.320312f, 0.003906f, 1.0f},
   {0.691406f, 0.28125f, 0.003906f, 1.0f},
   {0.574219f, 0.234375f, 0.003906f, 1.0f},
   {0.921875f, 0.832031f, 0.773438f, 1.0f},
   {0.863281f, 0.699219f, 0.589844f, 1.0f},
   {0.824219f, 0.613281f, 0.472656f, 1.0f},
   {0.773438f, 0.5f, 0.3125f, 1.0f},
   {0.660156f, 0.394531f, 0.214844f, 1.0f},
   {0.757812f, 0.253906f, 0.0f, 1.0f},
   {0.371094f, 0.222656f, 0.121094f, 1.0f},
   {0.519531f, 0.308594f, 0.167969f, 1.0f},
   {0.625f, 0.207031f, 0.0f, 1.0f},
   {0.429688f, 0.144531f, 0.0f, 1.0f},
   {0.984375f, 0.429688f, 0.484375f, 1.0f},
   {0.996094f, 0.753906f, 0.714844f, 1.0f},
   {0.996094f, 0.878906f, 0.90625f, 1.0f},
   {0.890625f, 0.34375f, 0.566406f, 1.0f},
   {0.996094f, 0.933594f, 0.949219f, 1.0f},
   {0.863281f, 0.160156f, 0.445312f, 1.0f},
   {0.996094f, 0.816406f, 0.859375f, 1.0f},
   {0.996094f, 0.503906f, 0.621094f, 1.0f},
   {0.996094f, 0.660156f, 0.613281f, 1.0f},
   {0.90625f, 0.109375f, 0.0f, 1.0f},
   {0.996094f, 0.199219f, 0.089844f, 1.0f},
   {0.835938f, 0.0f, 0.0f, 1.0f},
   {0.972656f, 0.707031f, 0.730469f, 1.0f},
   {0.96875f, 0.742188f, 0.679688f, 1.0f},
   {0.996094f, 0.699219f, 0.769531f, 1.0f},
   {0.996094f, 0.433594f, 0.417969f, 1.0f},
   {0.984375f, 0.320312f, 0.382812f, 1.0f},
   {0.910156f, 0.472656f, 0.648438f, 1.0f},
   {0.984375f, 0.710938f, 0.710938f, 1.0f},
   {0.996094f, 0.652344f, 0.734375f, 1.0f},
   {0.953125f, 0.234375f, 0.421875f, 1.0f},
   {0.980469f, 0.136719f, 0.21875f, 1.0f},
   {0.953125f, 0.101562f, 0.527344f, 1.0f},
   {0.996094f, 0.386719f, 0.53125f, 1.0f},
   {0.996094f, 0.152344f, 0.351562f, 1.0f},
   {0.671875f, 0.0f, 0.0f, 1.0f},
   {0.996094f, 0.433594f, 0.355469f, 1.0f},
   {0.886719f, 0.464844f, 0.675781f, 1.0f},
   {0.925781f, 0.652344f, 0.789062f, 1.0f},
   {0.910156f, 0.574219f, 0.742188f, 1.0f},
   {0.996094f, 0.835938f, 0.816406f, 1.0f},
   {0.996094f, 0.746094f, 0.804688f, 1.0f},
   {0.996094f, 0.582031f, 0.679688f, 1.0f},
   {0.996094f, 0.433594f, 0.566406f, 1.0f},
   {0.996094f, 0.105469f, 0.316406f, 1.0f},
   {0.90625f, 0.0f, 0.214844f, 1.0f},
   {0.804688f, 0.0f, 0.191406f, 1.0f},
   {0.6875f, 0.0f, 0.164062f, 1.0f},
   {0.753906f, 0.003906f, 0.039062f, 1.0f},
   {0.578125f, 0.0f, 0.136719f, 1.0f},
   {0.636719f, 0.003906f, 0.035156f, 1.0f},
   {0.457031f, 0.003906f, 0.027344f, 1.0f},
   {0.652344f, 0.652344f, 0.996094f, 1.0f},
   {0.914062f, 0.683594f, 0.996094f, 1.0f},
   {0.804688f, 0.613281f, 0.996094f, 1.0f},
   {0.640625f, 0.285156f, 0.996094f, 1.0f},
   {0.503906f, 0.011719f, 0.996094f, 1.0f},
   {0.273438f, 0.0f, 0.546875f, 1.0f},
   {0.0f, 0.359375f, 0.0f, 1.0f},
   {0.488281f, 0.996094f, 0.488281f, 1.0f},
   {0.785156f, 0.996094f, 0.785156f, 1.0f},
   {0.898438f, 0.800781f, 0.996094f, 1.0f},
   {0.621094f, 0.996094f, 0.621094f, 1.0f},
   {0.910156f, 0.996094f, 0.910156f, 1.0f},
   {0.0f, 0.0f, 0.996094f, 1.0f},
   {0.996094f, 0.339844f, 0.996094f, 1.0f},
   {0.996094f, 0.550781f, 0.996094f, 1.0f},
   {0.996094f, 0.652344f, 0.996094f, 1.0f},
   {0.992188f, 0.402344f, 0.0f, 1.0f},
   {0.996094f, 0.0f, 0.0f, 1.0f},
   {0.722656f, 0.230469f, 0.40625f, 1.0f},
   {0.527344f, 0.167969f, 0.296875f, 1.0f},
   {0.785156f, 0.332031f, 0.492188f, 1.0f},
   {0.0f, 0.5f, 0.0f, 1.0f},
   {0.703125f, 0.808594f, 0.890625f, 1.0f},
   {0.855469f, 0.855469f, 0.902344f, 1.0f},
   {0.925781f, 0.925781f, 0.949219f, 1.0f},
   {0.75f, 0.75f, 0.75f, 1.0f},
   {0.691406f, 0.691406f, 0.691406f, 1.0f},
   {0.789062f, 0.789062f, 0.859375f, 1.0f},
   {0.632812f, 0.632812f, 0.75f, 1.0f},
   {0.710938f, 0.710938f, 0.804688f, 1.0f},
   {0.585938f, 0.585938f, 0.585938f, 1.0f},
   {0.636719f, 0.214844f, 0.988281f, 1.0f},
   {0.921875f, 0.835938f, 0.992188f, 1.0f},
   {0.875f, 0.734375f, 0.992188f, 1.0f},
   {0.832031f, 0.640625f, 0.992188f, 1.0f},
   {0.78125f, 0.523438f, 0.992188f, 1.0f},
   {0.796875f, 0.714844f, 0.996094f, 1.0f},
   {0.699219f, 0.582031f, 0.996094f, 1.0f},
   {0.5625f, 0.386719f, 0.996094f, 1.0f},
   {0.621094f, 0.0f, 0.789062f, 1.0f},
   {0.480469f, 0.0f, 0.609375f, 1.0f},
   {0.414062f, 0.0f, 0.414062f, 1.0f},
   {0.515625f, 0.378906f, 0.242188f, 1.0f},
   {0.8125f, 0.792969f, 0.6875f, 1.0f},
   {0.6875f, 0.652344f, 0.46875f, 1.0f},
   {0.53125f, 0.496094f, 0.3125f, 1.0f},
   {0.671875f, 0.496094f, 0.3125f, 1.0f},
   {0.425781f, 0.3125f, 0.199219f, 1.0f},
   {0.390625f, 0.007812f, 0.042969f, 1.0f},
   {0.53125f, 0.496094f, 0.3125f, 1.0f},
   {0.996094f, 0.996094f, 0.996094f, 1.0f},
   {0.597656f, 0.796875f, 0.996094f, 1.0f},
   {0.996094f, 0.832031f, 0.613281f, 1.0f},
   {0.996094f, 0.816406f, 0.859375f, 1.0f},
   {0.519531f, 0.308594f, 0.167969f, 1.0f},
   {0.417969f, 0.761719f, 0.996094f, 1.0f},
   {0.625f, 0.207031f, 0.0f, 1.0f},
});

const Palette BPAL_36 = Palette("gray",
{
   {0.0f, 0.0f, 0.0f, 1.0f},
   {0.015873f, 0.015873f, 0.015873f, 1.0f},
   {0.031746f, 0.031746f, 0.031746f, 1.0f},
   {0.047619f, 0.047619f, 0.047619f, 1.0f},
   {0.0634921f, 0.0634921f, 0.0634921f, 1.0f},
   {0.0793651f, 0.0793651f, 0.0793651f, 1.0f},
   {0.0952381f, 0.0952381f, 0.0952381f, 1.0f},
   {0.111111f, 0.111111f, 0.111111f, 1.0f},
   {0.126984f, 0.126984f, 0.126984f, 1.0f},
   {0.142857f, 0.142857f, 0.142857f, 1.0f},
   {0.15873f, 0.15873f, 0.15873f, 1.0f},
   {0.174603f, 0.174603f, 0.174603f, 1.0f},
   {0.190476f, 0.190476f, 0.190476f, 1.0f},
   {0.206349f, 0.206349f, 0.206349f, 1.0f},
   {0.222222f, 0.222222f, 0.222222f, 1.0f},
   {0.238095f, 0.238095f, 0.238095f, 1.0f},
   {0.253968f, 0.253968f, 0.253968f, 1.0f},
   {0.269841f, 0.269841f, 0.269841f, 1.0f},
   {0.285714f, 0.285714f, 0.285714f, 1.0f},
   {0.301587f, 0.301587f, 0.301587f, 1.0f},
   {0.31746f, 0.31746f, 0.31746f, 1.0f},
   {0.333333f, 0.333333f, 0.333333f, 1.0f},
   {0.349206f, 0.349206f, 0.349206f, 1.0f},
   {0.365079f, 0.365079f, 0.365079f, 1.0f},
   {0.380952f, 0.380952f, 0.380952f, 1.0f},
   {0.396825f, 0.396825f, 0.396825f, 1.0f},
   {0.412698f, 0.412698f, 0.412698f, 1.0f},
   {0.428571f, 0.428571f, 0.428571f, 1.0f},
   {0.444444f, 0.444444f, 0.444444f, 1.0f},
   {0.460317f, 0.460317f, 0.460317f, 1.0f},
   {0.47619f, 0.47619f, 0.47619f, 1.0f},
   {0.492063f, 0.492063f, 0.492063f, 1.0f},
   {0.507937f, 0.507937f, 0.507937f, 1.0f},
   {0.52381f, 0.52381f, 0.52381f, 1.0f},
   {0.539683f, 0.539683f, 0.539683f, 1.0f},
   {0.555556f, 0.555556f, 0.555556f, 1.0f},
   {0.571429f, 0.571429f, 0.571429f, 1.0f},
   {0.587302f, 0.587302f, 0.587302f, 1.0f},
   {0.603175f, 0.603175f, 0.603175f, 1.0f},
   {0.619048f, 0.619048f, 0.619048f, 1.0f},
   {0.634921f, 0.634921f, 0.634921f, 1.0f},
   {0.650794f, 0.650794f, 0.650794f, 1.0f},
   {0.666667f, 0.666667f, 0.666667f, 1.0f},
   {0.68254f, 0.68254f, 0.68254f, 1.0f},
   {0.698413f, 0.698413f, 0.698413f, 1.0f},
   {0.714286f, 0.714286f, 0.714286f, 1.0f},
   {0.730159f, 0.730159f, 0.730159f, 1.0f},
   {0.746032f, 0.746032f, 0.746032f, 1.0f},
   {0.761905f, 0.761905f, 0.761905f, 1.0f},
   {0.777778f, 0.777778f, 0.777778f, 1.0f},
   {0.793651f, 0.793651f, 0.793651f, 1.0f},
   {0.809524f, 0.809524f, 0.809524f, 1.0f},
   {0.825397f, 0.825397f, 0.825397f, 1.0f},
   {0.84127f, 0.84127f, 0.84127f, 1.0f},
   {0.857143f, 0.857143f, 0.857143f, 1.0f},
   {0.873016f, 0.873016f, 0.873016f, 1.0f},
   {0.888889f, 0.888889f, 0.888889f, 1.0f},
   {0.904762f, 0.904762f, 0.904762f, 1.0f},
   {0.920635f, 0.920635f, 0.920635f, 1.0f},
   {0.936508f, 0.936508f, 0.936508f, 1.0f},
   {0.952381f, 0.952381f, 0.952381f, 1.0f},
   {0.968254f, 0.968254f, 0.968254f, 1.0f},
   {0.984127f, 0.984127f, 0.984127f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
});

const Palette BPAL_37 = Palette("turbo",
{
   {0.18995f, 0.07176f, 0.23217f, 1.0f},
   {0.19483f, 0.08339f, 0.26149f, 1.0f},
   {0.19956f, 0.09498f, 0.29024f, 1.0f},
   {0.20415f, 0.10652f, 0.31844f, 1.0f},
   {0.2086f, 0.11802f, 0.34607f, 1.0f},
   {0.21291f, 0.12947f, 0.37314f, 1.0f},
   {0.21708f, 0.14087f, 0.39964f, 1.0f},
   {0.22111f, 0.15223f, 0.42558f, 1.0f},
   {0.225f, 0.16354f, 0.45096f, 1.0f},
   {0.22875f, 0.17481f, 0.47578f, 1.0f},
   {0.23236f, 0.18603f, 0.50004f, 1.0f},
   {0.23582f, 0.1972f, 0.52373f, 1.0f},
   {0.23915f, 0.20833f, 0.54686f, 1.0f},
   {0.24234f, 0.21941f, 0.56942f, 1.0f},
   {0.24539f, 0.23044f, 0.59142f, 1.0f},
   {0.2483f, 0.24143f, 0.61286f, 1.0f},
   {0.25107f, 0.25237f, 0.63374f, 1.0f},
   {0.25369f, 0.26327f, 0.65406f, 1.0f},
   {0.25618f, 0.27412f, 0.67381f, 1.0f},
   {0.25853f, 0.28492f, 0.693f, 1.0f},
   {0.26074f, 0.29568f, 0.71162f, 1.0f},
   {0.2628f, 0.30639f, 0.72968f, 1.0f},
   {0.26473f, 0.31706f, 0.74718f, 1.0f},
   {0.26652f, 0.32768f, 0.76412f, 1.0f},
   {0.26816f, 0.33825f, 0.7805f, 1.0f},
   {0.26967f, 0.34878f, 0.79631f, 1.0f},
   {0.27103f, 0.35926f, 0.81156f, 1.0f},
   {0.27226f, 0.3697f, 0.82624f, 1.0f},
   {0.27334f, 0.38008f, 0.84037f, 1.0f},
   {0.27429f, 0.39043f, 0.85393f, 1.0f},
   {0.27509f, 0.40072f, 0.86692f, 1.0f},
   {0.27576f, 0.41097f, 0.87936f, 1.0f},
   {0.27628f, 0.42118f, 0.89123f, 1.0f},
   {0.27667f, 0.43134f, 0.90254f, 1.0f},
   {0.27691f, 0.44145f, 0.91328f, 1.0f},
   {0.27701f, 0.45152f, 0.92347f, 1.0f},
   {0.27698f, 0.46153f, 0.93309f, 1.0f},
   {0.2768f, 0.47151f, 0.94214f, 1.0f},
   {0.27648f, 0.48144f, 0.95064f, 1.0f},
   {0.27603f, 0.49132f, 0.95857f, 1.0f},
   {0.27543f, 0.50115f, 0.96594f, 1.0f},
   {0.27469f, 0.51094f, 0.97275f, 1.0f},
   {0.27381f, 0.52069f, 0.97899f, 1.0f},
   {0.27273f, 0.5304f, 0.98461f, 1.0f},
   {0.27106f, 0.54015f, 0.9893f, 1.0f},
   {0.26878f, 0.54995f, 0.99303f, 1.0f},
   {0.26592f, 0.55979f, 0.99583f, 1.0f},
   {0.26252f, 0.56967f, 0.99773f, 1.0f},
   {0.25862f, 0.57958f, 0.99876f, 1.0f},
   {0.25425f, 0.5895f, 0.99896f, 1.0f},
   {0.24946f, 0.59943f, 0.99835f, 1.0f},
   {0.24427f, 0.60937f, 0.99697f, 1.0f},
   {0.23874f, 0.61931f, 0.99485f, 1.0f},
   {0.23288f, 0.62923f, 0.99202f, 1.0f},
   {0.22676f, 0.63913f, 0.98851f, 1.0f},
   {0.22039f, 0.64901f, 0.98436f, 1.0f},
   {0.21382f, 0.65886f, 0.97959f, 1.0f},
   {0.20708f, 0.66866f, 0.97423f, 1.0f},
   {0.20021f, 0.67842f, 0.96833f, 1.0f},
   {0.19326f, 0.68812f, 0.9619f, 1.0f},
   {0.18625f, 0.69775f, 0.95498f, 1.0f},
   {0.17923f, 0.70732f, 0.94761f, 1.0f},
   {0.17223f, 0.7168f, 0.93981f, 1.0f},
   {0.16529f, 0.7262f, 0.93161f, 1.0f},
   {0.15844f, 0.73551f, 0.92305f, 1.0f},
   {0.15173f, 0.74472f, 0.91416f, 1.0f},
   {0.14519f, 0.75381f, 0.90496f, 1.0f},
   {0.13886f, 0.76279f, 0.8955f, 1.0f},
   {0.13278f, 0.77165f, 0.8858f, 1.0f},
   {0.12698f, 0.78037f, 0.8759f, 1.0f},
   {0.12151f, 0.78896f, 0.86581f, 1.0f},
   {0.11639f, 0.7974f, 0.85559f, 1.0f},
   {0.11167f, 0.80569f, 0.84525f, 1.0f},
   {0.10738f, 0.81381f, 0.83484f, 1.0f},
   {0.10357f, 0.82177f, 0.82437f, 1.0f},
   {0.10026f, 0.82955f, 0.81389f, 1.0f},
   {0.0975f, 0.83714f, 0.80342f, 1.0f},
   {0.09532f, 0.84455f, 0.79299f, 1.0f},
   {0.09377f, 0.85175f, 0.78264f, 1.0f},
   {0.09287f, 0.85875f, 0.7724f, 1.0f},
   {0.09267f, 0.86554f, 0.7623f, 1.0f},
   {0.0932f, 0.87211f, 0.75237f, 1.0f},
   {0.09451f, 0.87844f, 0.74265f, 1.0f},
   {0.09662f, 0.88454f, 0.73316f, 1.0f},
   {0.09958f, 0.8904f, 0.72393f, 1.0f},
   {0.10342f, 0.896f, 0.715f, 1.0f},
   {0.10815f, 0.90142f, 0.70599f, 1.0f},
   {0.11374f, 0.90673f, 0.69651f, 1.0f},
   {0.12014f, 0.91193f, 0.6866f, 1.0f},
   {0.12733f, 0.91701f, 0.67627f, 1.0f},
   {0.13526f, 0.92197f, 0.66556f, 1.0f},
   {0.14391f, 0.9268f, 0.65448f, 1.0f},
   {0.15323f, 0.93151f, 0.64308f, 1.0f},
   {0.16319f, 0.93609f, 0.63137f, 1.0f},
   {0.17377f, 0.94053f, 0.61938f, 1.0f},
   {0.18491f, 0.94484f, 0.60713f, 1.0f},
   {0.19659f, 0.94901f, 0.59466f, 1.0f},
   {0.20877f, 0.95304f, 0.58199f, 1.0f},
   {0.22142f, 0.95692f, 0.56914f, 1.0f},
   {0.23449f, 0.96065f, 0.55614f, 1.0f},
   {0.24797f, 0.96423f, 0.54303f, 1.0f},
   {0.2618f, 0.96765f, 0.52981f, 1.0f},
   {0.27597f, 0.97092f, 0.51653f, 1.0f},
   {0.29042f, 0.97403f, 0.50321f, 1.0f},
   {0.30513f, 0.97697f, 0.48987f, 1.0f},
   {0.32006f, 0.97974f, 0.47654f, 1.0f},
   {0.33517f, 0.98234f, 0.46325f, 1.0f},
   {0.35043f, 0.98477f, 0.45002f, 1.0f},
   {0.36581f, 0.98702f, 0.43688f, 1.0f},
   {0.38127f, 0.98909f, 0.42386f, 1.0f},
   {0.39678f, 0.99098f, 0.41098f, 1.0f},
   {0.41229f, 0.99268f, 0.39826f, 1.0f},
   {0.42778f, 0.99419f, 0.38575f, 1.0f},
   {0.44321f, 0.99551f, 0.37345f, 1.0f},
   {0.45854f, 0.99663f, 0.3614f, 1.0f},
   {0.47375f, 0.99755f, 0.34963f, 1.0f},
   {0.48879f, 0.99828f, 0.33816f, 1.0f},
   {0.50362f, 0.99879f, 0.32701f, 1.0f},
   {0.51822f, 0.9991f, 0.31622f, 1.0f},
   {0.53255f, 0.99919f, 0.30581f, 1.0f},
   {0.54658f, 0.99907f, 0.29581f, 1.0f},
   {0.56026f, 0.99873f, 0.28623f, 1.0f},
   {0.57357f, 0.99817f, 0.27712f, 1.0f},
   {0.58646f, 0.99739f, 0.26849f, 1.0f},
   {0.59891f, 0.99638f, 0.26038f, 1.0f},
   {0.61088f, 0.99514f, 0.2528f, 1.0f},
   {0.62233f, 0.99366f, 0.24579f, 1.0f},
   {0.63323f, 0.99195f, 0.23937f, 1.0f},
   {0.64362f, 0.98999f, 0.23356f, 1.0f},
   {0.65394f, 0.98775f, 0.22835f, 1.0f},
   {0.66428f, 0.98524f, 0.2237f, 1.0f},
   {0.67462f, 0.98246f, 0.2196f, 1.0f},
   {0.68494f, 0.97941f, 0.21602f, 1.0f},
   {0.69525f, 0.9761f, 0.21294f, 1.0f},
   {0.70553f, 0.97255f, 0.21032f, 1.0f},
   {0.71577f, 0.96875f, 0.20815f, 1.0f},
   {0.72596f, 0.9647f, 0.2064f, 1.0f},
   {0.7361f, 0.96043f, 0.20504f, 1.0f},
   {0.74617f, 0.95593f, 0.20406f, 1.0f},
   {0.75617f, 0.95121f, 0.20343f, 1.0f},
   {0.76608f, 0.94627f, 0.20311f, 1.0f},
   {0.77591f, 0.94113f, 0.2031f, 1.0f},
   {0.78563f, 0.93579f, 0.20336f, 1.0f},
   {0.79524f, 0.93025f, 0.20386f, 1.0f},
   {0.80473f, 0.92452f, 0.20459f, 1.0f},
   {0.8141f, 0.91861f, 0.20552f, 1.0f},
   {0.82333f, 0.91253f, 0.20663f, 1.0f},
   {0.83241f, 0.90627f, 0.20788f, 1.0f},
   {0.84133f, 0.89986f, 0.20926f, 1.0f},
   {0.8501f, 0.89328f, 0.21074f, 1.0f},
   {0.85868f, 0.88655f, 0.2123f, 1.0f},
   {0.86709f, 0.87968f, 0.21391f, 1.0f},
   {0.8753f, 0.87267f, 0.21555f, 1.0f},
   {0.88331f, 0.86553f, 0.21719f, 1.0f},
   {0.89112f, 0.85826f, 0.2188f, 1.0f},
   {0.8987f, 0.85087f, 0.22038f, 1.0f},
   {0.90605f, 0.84337f, 0.22188f, 1.0f},
   {0.91317f, 0.83576f, 0.22328f, 1.0f},
   {0.92004f, 0.82806f, 0.22456f, 1.0f},
   {0.92666f, 0.82025f, 0.2257f, 1.0f},
   {0.93301f, 0.81236f, 0.22667f, 1.0f},
   {0.93909f, 0.80439f, 0.22744f, 1.0f},
   {0.94489f, 0.79634f, 0.228f, 1.0f},
   {0.95039f, 0.78823f, 0.22831f, 1.0f},
   {0.9556f, 0.78005f, 0.22836f, 1.0f},
   {0.96049f, 0.77181f, 0.22811f, 1.0f},
   {0.96507f, 0.76352f, 0.22754f, 1.0f},
   {0.96931f, 0.75519f, 0.22663f, 1.0f},
   {0.97323f, 0.74682f, 0.22536f, 1.0f},
   {0.97679f, 0.73842f, 0.22369f, 1.0f},
   {0.98f, 0.73f, 0.22161f, 1.0f},
   {0.98289f, 0.7214f, 0.21918f, 1.0f},
   {0.98549f, 0.7125f, 0.2165f, 1.0f},
   {0.98781f, 0.7033f, 0.21358f, 1.0f},
   {0.98986f, 0.69382f, 0.21043f, 1.0f},
   {0.99163f, 0.68408f, 0.20706f, 1.0f},
   {0.99314f, 0.67408f, 0.20348f, 1.0f},
   {0.99438f, 0.66386f, 0.19971f, 1.0f},
   {0.99535f, 0.65341f, 0.19577f, 1.0f},
   {0.99607f, 0.64277f, 0.19165f, 1.0f},
   {0.99654f, 0.63193f, 0.18738f, 1.0f},
   {0.99675f, 0.62093f, 0.18297f, 1.0f},
   {0.99672f, 0.60977f, 0.17842f, 1.0f},
   {0.99644f, 0.59846f, 0.17376f, 1.0f},
   {0.99593f, 0.58703f, 0.16899f, 1.0f},
   {0.99517f, 0.57549f, 0.16412f, 1.0f},
   {0.99419f, 0.56386f, 0.15918f, 1.0f},
   {0.99297f, 0.55214f, 0.15417f, 1.0f},
   {0.99153f, 0.54036f, 0.1491f, 1.0f},
   {0.98987f, 0.52854f, 0.14398f, 1.0f},
   {0.98799f, 0.51667f, 0.13883f, 1.0f},
   {0.9859f, 0.50479f, 0.13367f, 1.0f},
   {0.9836f, 0.49291f, 0.12849f, 1.0f},
   {0.98108f, 0.48104f, 0.12332f, 1.0f},
   {0.97837f, 0.4692f, 0.11817f, 1.0f},
   {0.97545f, 0.4574f, 0.11305f, 1.0f},
   {0.97234f, 0.44565f, 0.10797f, 1.0f},
   {0.96904f, 0.43399f, 0.10294f, 1.0f},
   {0.96555f, 0.42241f, 0.09798f, 1.0f},
   {0.96187f, 0.41093f, 0.0931f, 1.0f},
   {0.95801f, 0.39958f, 0.08831f, 1.0f},
   {0.95398f, 0.38836f, 0.08362f, 1.0f},
   {0.94977f, 0.37729f, 0.07905f, 1.0f},
   {0.94538f, 0.36638f, 0.07461f, 1.0f},
   {0.94084f, 0.35566f, 0.07031f, 1.0f},
   {0.93612f, 0.34513f, 0.06616f, 1.0f},
   {0.93125f, 0.33482f, 0.06218f, 1.0f},
   {0.92623f, 0.32473f, 0.05837f, 1.0f},
   {0.92105f, 0.31489f, 0.05475f, 1.0f},
   {0.91572f, 0.3053f, 0.05134f, 1.0f},
   {0.91024f, 0.29599f, 0.04814f, 1.0f},
   {0.90463f, 0.28696f, 0.04516f, 1.0f},
   {0.89888f, 0.27824f, 0.04243f, 1.0f},
   {0.89298f, 0.26981f, 0.03993f, 1.0f},
   {0.88691f, 0.26152f, 0.03753f, 1.0f},
   {0.88066f, 0.25334f, 0.03521f, 1.0f},
   {0.87422f, 0.24526f, 0.03297f, 1.0f},
   {0.8676f, 0.2373f, 0.03082f, 1.0f},
   {0.86079f, 0.22945f, 0.02875f, 1.0f},
   {0.8538f, 0.2217f, 0.02677f, 1.0f},
   {0.84662f, 0.21407f, 0.02487f, 1.0f},
   {0.83926f, 0.20654f, 0.02305f, 1.0f},
   {0.83172f, 0.19912f, 0.02131f, 1.0f},
   {0.82399f, 0.19182f, 0.01966f, 1.0f},
   {0.81608f, 0.18462f, 0.01809f, 1.0f},
   {0.80799f, 0.17753f, 0.0166f, 1.0f},
   {0.79971f, 0.17055f, 0.0152f, 1.0f},
   {0.79125f, 0.16368f, 0.01387f, 1.0f},
   {0.7826f, 0.15693f, 0.01264f, 1.0f},
   {0.77377f, 0.15028f, 0.01148f, 1.0f},
   {0.76476f, 0.14374f, 0.01041f, 1.0f},
   {0.75556f, 0.13731f, 0.00942f, 1.0f},
   {0.74617f, 0.13098f, 0.00851f, 1.0f},
   {0.73661f, 0.12477f, 0.00769f, 1.0f},
   {0.72686f, 0.11867f, 0.00695f, 1.0f},
   {0.71692f, 0.11268f, 0.00629f, 1.0f},
   {0.7068f, 0.1068f, 0.00571f, 1.0f},
   {0.6965f, 0.10102f, 0.00522f, 1.0f},
   {0.68602f, 0.09536f, 0.00481f, 1.0f},
   {0.67535f, 0.0898f, 0.00449f, 1.0f},
   {0.66449f, 0.08436f, 0.00424f, 1.0f},
   {0.65345f, 0.07902f, 0.00408f, 1.0f},
   {0.64223f, 0.0738f, 0.00401f, 1.0f},
   {0.63082f, 0.06868f, 0.00401f, 1.0f},
   {0.61923f, 0.06367f, 0.0041f, 1.0f},
   {0.60746f, 0.05878f, 0.00427f, 1.0f},
   {0.5955f, 0.05399f, 0.00453f, 1.0f},
   {0.58336f, 0.04931f, 0.00486f, 1.0f},
   {0.57103f, 0.04474f, 0.00529f, 1.0f},
   {0.55852f, 0.04028f, 0.00579f, 1.0f},
   {0.54583f, 0.03593f, 0.00638f, 1.0f},
   {0.53295f, 0.03169f, 0.00705f, 1.0f},
   {0.51989f, 0.02756f, 0.0078f, 1.0f},
   {0.50664f, 0.02354f, 0.00863f, 1.0f},
   {0.49321f, 0.01963f, 0.00955f, 1.0f},
   {0.4796f, 0.01583f, 0.01055f, 1.0f},
});

const Palette BPAL_38 = Palette("viridis",
{
   {0.267004f, 0.004874f, 0.329415f, 1.0f},
   {0.26851f, 0.009605f, 0.335427f, 1.0f},
   {0.269944f, 0.014625f, 0.341379f, 1.0f},
   {0.271305f, 0.019942f, 0.347269f, 1.0f},
   {0.272594f, 0.025563f, 0.353093f, 1.0f},
   {0.273809f, 0.031497f, 0.358853f, 1.0f},
   {0.274952f, 0.037752f, 0.364543f, 1.0f},
   {0.276022f, 0.044167f, 0.370164f, 1.0f},
   {0.277018f, 0.050344f, 0.375715f, 1.0f},
   {0.277941f, 0.056324f, 0.381191f, 1.0f},
   {0.278791f, 0.062145f, 0.386592f, 1.0f},
   {0.279566f, 0.067836f, 0.391917f, 1.0f},
   {0.280267f, 0.073417f, 0.397163f, 1.0f},
   {0.280894f, 0.078907f, 0.402329f, 1.0f},
   {0.281446f, 0.08432f, 0.407414f, 1.0f},
   {0.281924f, 0.089666f, 0.412415f, 1.0f},
   {0.282327f, 0.094955f, 0.417331f, 1.0f},
   {0.282656f, 0.100196f, 0.42216f, 1.0f},
   {0.28291f, 0.105393f, 0.426902f, 1.0f},
   {0.283091f, 0.110553f, 0.431554f, 1.0f},
   {0.283197f, 0.11568f, 0.436115f, 1.0f},
   {0.283229f, 0.120777f, 0.440584f, 1.0f},
   {0.283187f, 0.125848f, 0.44496f, 1.0f},
   {0.283072f, 0.130895f, 0.449241f, 1.0f},
   {0.282884f, 0.13592f, 0.453427f, 1.0f},
   {0.282623f, 0.140926f, 0.457517f, 1.0f},
   {0.28229f, 0.145912f, 0.46151f, 1.0f},
   {0.281887f, 0.150881f, 0.465405f, 1.0f},
   {0.281412f, 0.155834f, 0.469201f, 1.0f},
   {0.280868f, 0.160771f, 0.472899f, 1.0f},
   {0.280255f, 0.165693f, 0.476498f, 1.0f},
   {0.279574f, 0.170599f, 0.479997f, 1.0f},
   {0.278826f, 0.17549f, 0.483397f, 1.0f},
   {0.278012f, 0.180367f, 0.486697f, 1.0f},
   {0.277134f, 0.185228f, 0.489898f, 1.0f},
   {0.276194f, 0.190074f, 0.493001f, 1.0f},
   {0.275191f, 0.194905f, 0.496005f, 1.0f},
   {0.274128f, 0.199721f, 0.498911f, 1.0f},
   {0.273006f, 0.20452f, 0.501721f, 1.0f},
   {0.271828f, 0.209303f, 0.504434f, 1.0f},
   {0.270595f, 0.214069f, 0.507052f, 1.0f},
   {0.269308f, 0.218818f, 0.509577f, 1.0f},
   {0.267968f, 0.223549f, 0.512008f, 1.0f},
   {0.26658f, 0.228262f, 0.514349f, 1.0f},
   {0.265145f, 0.232956f, 0.516599f, 1.0f},
   {0.263663f, 0.237631f, 0.518762f, 1.0f},
   {0.262138f, 0.242286f, 0.520837f, 1.0f},
   {0.260571f, 0.246922f, 0.522828f, 1.0f},
   {0.258965f, 0.251537f, 0.524736f, 1.0f},
   {0.257322f, 0.25613f, 0.526563f, 1.0f},
   {0.255645f, 0.260703f, 0.528312f, 1.0f},
   {0.253935f, 0.265254f, 0.529983f, 1.0f},
   {0.252194f, 0.269783f, 0.531579f, 1.0f},
   {0.250425f, 0.27429f, 0.533103f, 1.0f},
   {0.248629f, 0.278775f, 0.534556f, 1.0f},
   {0.246811f, 0.283237f, 0.535941f, 1.0f},
   {0.244972f, 0.287675f, 0.53726f, 1.0f},
   {0.243113f, 0.292092f, 0.538516f, 1.0f},
   {0.241237f, 0.296485f, 0.539709f, 1.0f},
   {0.239346f, 0.300855f, 0.540844f, 1.0f},
   {0.237441f, 0.305202f, 0.541921f, 1.0f},
   {0.235526f, 0.309527f, 0.542944f, 1.0f},
   {0.233603f, 0.313828f, 0.543914f, 1.0f},
   {0.231674f, 0.318106f, 0.544834f, 1.0f},
   {0.229739f, 0.322361f, 0.545706f, 1.0f},
   {0.227802f, 0.326594f, 0.546532f, 1.0f},
   {0.225863f, 0.330805f, 0.547314f, 1.0f},
   {0.223925f, 0.334994f, 0.548053f, 1.0f},
   {0.221989f, 0.339161f, 0.548752f, 1.0f},
   {0.220057f, 0.343307f, 0.549413f, 1.0f},
   {0.21813f, 0.347432f, 0.550038f, 1.0f},
   {0.21621f, 0.351535f, 0.550627f, 1.0f},
   {0.214298f, 0.355619f, 0.551184f, 1.0f},
   {0.212395f, 0.359683f, 0.55171f, 1.0f},
   {0.210503f, 0.363727f, 0.552206f, 1.0f},
   {0.208623f, 0.367752f, 0.552675f, 1.0f},
   {0.206756f, 0.371758f, 0.553117f, 1.0f},
   {0.204903f, 0.375746f, 0.553533f, 1.0f},
   {0.203063f, 0.379716f, 0.553925f, 1.0f},
   {0.201239f, 0.38367f, 0.554294f, 1.0f},
   {0.19943f, 0.387607f, 0.554642f, 1.0f},
   {0.197636f, 0.391528f, 0.554969f, 1.0f},
   {0.19586f, 0.395433f, 0.555276f, 1.0f},
   {0.1941f, 0.399323f, 0.555565f, 1.0f},
   {0.192357f, 0.403199f, 0.555836f, 1.0f},
   {0.190631f, 0.407061f, 0.556089f, 1.0f},
   {0.188923f, 0.41091f, 0.556326f, 1.0f},
   {0.187231f, 0.414746f, 0.556547f, 1.0f},
   {0.185556f, 0.41857f, 0.556753f, 1.0f},
   {0.183898f, 0.422383f, 0.556944f, 1.0f},
   {0.182256f, 0.426184f, 0.55712f, 1.0f},
   {0.180629f, 0.429975f, 0.557282f, 1.0f},
   {0.179019f, 0.433756f, 0.55743f, 1.0f},
   {0.177423f, 0.437527f, 0.557565f, 1.0f},
   {0.175841f, 0.44129f, 0.557685f, 1.0f},
   {0.174274f, 0.445044f, 0.557792f, 1.0f},
   {0.172719f, 0.448791f, 0.557885f, 1.0f},
   {0.171176f, 0.45253f, 0.557965f, 1.0f},
   {0.169646f, 0.456262f, 0.55803f, 1.0f},
   {0.168126f, 0.459988f, 0.558082f, 1.0f},
   {0.166617f, 0.463708f, 0.558119f, 1.0f},
   {0.165117f, 0.467423f, 0.558141f, 1.0f},
   {0.163625f, 0.471133f, 0.558148f, 1.0f},
   {0.162142f, 0.474838f, 0.55814f, 1.0f},
   {0.160665f, 0.47854f, 0.558115f, 1.0f},
   {0.159194f, 0.482237f, 0.558073f, 1.0f},
   {0.157729f, 0.485932f, 0.558013f, 1.0f},
   {0.15627f, 0.489624f, 0.557936f, 1.0f},
   {0.154815f, 0.493313f, 0.55784f, 1.0f},
   {0.153364f, 0.497f, 0.557724f, 1.0f},
   {0.151918f, 0.500685f, 0.557587f, 1.0f},
   {0.150476f, 0.504369f, 0.55743f, 1.0f},
   {0.149039f, 0.508051f, 0.55725f, 1.0f},
   {0.147607f, 0.511733f, 0.557049f, 1.0f},
   {0.14618f, 0.515413f, 0.556823f, 1.0f},
   {0.144759f, 0.519093f, 0.556572f, 1.0f},
   {0.143343f, 0.522773f, 0.556295f, 1.0f},
   {0.141935f, 0.526453f, 0.555991f, 1.0f},
   {0.140536f, 0.530132f, 0.555659f, 1.0f},
   {0.139147f, 0.533812f, 0.555298f, 1.0f},
   {0.13777f, 0.537492f, 0.554906f, 1.0f},
   {0.136408f, 0.541173f, 0.554483f, 1.0f},
   {0.135066f, 0.544853f, 0.554029f, 1.0f},
   {0.133743f, 0.548535f, 0.553541f, 1.0f},
   {0.132444f, 0.552216f, 0.553018f, 1.0f},
   {0.131172f, 0.555899f, 0.552459f, 1.0f},
   {0.129933f, 0.559582f, 0.551864f, 1.0f},
   {0.128729f, 0.563265f, 0.551229f, 1.0f},
   {0.127568f, 0.566949f, 0.550556f, 1.0f},
   {0.126453f, 0.570633f, 0.549841f, 1.0f},
   {0.125394f, 0.574318f, 0.549086f, 1.0f},
   {0.124395f, 0.578002f, 0.548287f, 1.0f},
   {0.123463f, 0.581687f, 0.547445f, 1.0f},
   {0.122606f, 0.585371f, 0.546557f, 1.0f},
   {0.121831f, 0.589055f, 0.545623f, 1.0f},
   {0.121148f, 0.592739f, 0.544641f, 1.0f},
   {0.120565f, 0.596422f, 0.543611f, 1.0f},
   {0.120092f, 0.600104f, 0.54253f, 1.0f},
   {0.119738f, 0.603785f, 0.5414f, 1.0f},
   {0.119512f, 0.607464f, 0.540218f, 1.0f},
   {0.119423f, 0.611141f, 0.538982f, 1.0f},
   {0.119483f, 0.614817f, 0.537692f, 1.0f},
   {0.119699f, 0.61849f, 0.536347f, 1.0f},
   {0.120081f, 0.622161f, 0.534946f, 1.0f},
   {0.120638f, 0.625828f, 0.533488f, 1.0f},
   {0.12138f, 0.629492f, 0.531973f, 1.0f},
   {0.122312f, 0.633153f, 0.530398f, 1.0f},
   {0.123444f, 0.636809f, 0.528763f, 1.0f},
   {0.12478f, 0.640461f, 0.527068f, 1.0f},
   {0.126326f, 0.644107f, 0.525311f, 1.0f},
   {0.128087f, 0.647749f, 0.523491f, 1.0f},
   {0.130067f, 0.651384f, 0.521608f, 1.0f},
   {0.132268f, 0.655014f, 0.519661f, 1.0f},
   {0.134692f, 0.658636f, 0.517649f, 1.0f},
   {0.137339f, 0.662252f, 0.515571f, 1.0f},
   {0.14021f, 0.665859f, 0.513427f, 1.0f},
   {0.143303f, 0.669459f, 0.511215f, 1.0f},
   {0.146616f, 0.67305f, 0.508936f, 1.0f},
   {0.150148f, 0.676631f, 0.506589f, 1.0f},
   {0.153894f, 0.680203f, 0.504172f, 1.0f},
   {0.157851f, 0.683765f, 0.501686f, 1.0f},
   {0.162016f, 0.687316f, 0.499129f, 1.0f},
   {0.166383f, 0.690856f, 0.496502f, 1.0f},
   {0.170948f, 0.694384f, 0.493803f, 1.0f},
   {0.175707f, 0.6979f, 0.491033f, 1.0f},
   {0.180653f, 0.701402f, 0.488189f, 1.0f},
   {0.185783f, 0.704891f, 0.485273f, 1.0f},
   {0.19109f, 0.708366f, 0.482284f, 1.0f},
   {0.196571f, 0.711827f, 0.479221f, 1.0f},
   {0.202219f, 0.715272f, 0.476084f, 1.0f},
   {0.20803f, 0.718701f, 0.472873f, 1.0f},
   {0.214f, 0.722114f, 0.469588f, 1.0f},
   {0.220124f, 0.725509f, 0.466226f, 1.0f},
   {0.226397f, 0.728888f, 0.462789f, 1.0f},
   {0.232815f, 0.732247f, 0.459277f, 1.0f},
   {0.239374f, 0.735588f, 0.455688f, 1.0f},
   {0.24607f, 0.73891f, 0.452024f, 1.0f},
   {0.252899f, 0.742211f, 0.448284f, 1.0f},
   {0.259857f, 0.745492f, 0.444467f, 1.0f},
   {0.266941f, 0.748751f, 0.440573f, 1.0f},
   {0.274149f, 0.751988f, 0.436601f, 1.0f},
   {0.281477f, 0.755203f, 0.432552f, 1.0f},
   {0.288921f, 0.758394f, 0.428426f, 1.0f},
   {0.296479f, 0.761561f, 0.424223f, 1.0f},
   {0.304148f, 0.764704f, 0.419943f, 1.0f},
   {0.311925f, 0.767822f, 0.415586f, 1.0f},
   {0.319809f, 0.770914f, 0.411152f, 1.0f},
   {0.327796f, 0.77398f, 0.40664f, 1.0f},
   {0.335885f, 0.777018f, 0.402049f, 1.0f},
   {0.344074f, 0.780029f, 0.397381f, 1.0f},
   {0.35236f, 0.783011f, 0.392636f, 1.0f},
   {0.360741f, 0.785964f, 0.387814f, 1.0f},
   {0.369214f, 0.788888f, 0.382914f, 1.0f},
   {0.377779f, 0.791781f, 0.377939f, 1.0f},
   {0.386433f, 0.794644f, 0.372886f, 1.0f},
   {0.395174f, 0.797475f, 0.367757f, 1.0f},
   {0.404001f, 0.800275f, 0.362552f, 1.0f},
   {0.412913f, 0.803041f, 0.357269f, 1.0f},
   {0.421908f, 0.805774f, 0.35191f, 1.0f},
   {0.430983f, 0.808473f, 0.346476f, 1.0f},
   {0.440137f, 0.811138f, 0.340967f, 1.0f},
   {0.449368f, 0.813768f, 0.335384f, 1.0f},
   {0.458674f, 0.816363f, 0.329727f, 1.0f},
   {0.468053f, 0.818921f, 0.323998f, 1.0f},
   {0.477504f, 0.821444f, 0.318195f, 1.0f},
   {0.487026f, 0.823929f, 0.312321f, 1.0f},
   {0.496615f, 0.826376f, 0.306377f, 1.0f},
   {0.506271f, 0.828786f, 0.300362f, 1.0f},
   {0.515992f, 0.831158f, 0.294279f, 1.0f},
   {0.525776f, 0.833491f, 0.288127f, 1.0f},
   {0.535621f, 0.835785f, 0.281908f, 1.0f},
   {0.545524f, 0.838039f, 0.275626f, 1.0f},
   {0.555484f, 0.840254f, 0.269281f, 1.0f},
   {0.565498f, 0.84243f, 0.262877f, 1.0f},
   {0.575563f, 0.844566f, 0.256415f, 1.0f},
   {0.585678f, 0.846661f, 0.249897f, 1.0f},
   {0.595839f, 0.848717f, 0.243329f, 1.0f},
   {0.606045f, 0.850733f, 0.236712f, 1.0f},
   {0.616293f, 0.852709f, 0.230052f, 1.0f},
   {0.626579f, 0.854645f, 0.223353f, 1.0f},
   {0.636902f, 0.856542f, 0.21662f, 1.0f},
   {0.647257f, 0.8584f, 0.209861f, 1.0f},
   {0.657642f, 0.860219f, 0.203082f, 1.0f},
   {0.668054f, 0.861999f, 0.196293f, 1.0f},
   {0.678489f, 0.863742f, 0.189503f, 1.0f},
   {0.688944f, 0.865448f, 0.182725f, 1.0f},
   {0.699415f, 0.867117f, 0.175971f, 1.0f},
   {0.709898f, 0.868751f, 0.169257f, 1.0f},
   {0.720391f, 0.87035f, 0.162603f, 1.0f},
   {0.730889f, 0.871916f, 0.156029f, 1.0f},
   {0.741388f, 0.873449f, 0.149561f, 1.0f},
   {0.751884f, 0.874951f, 0.143228f, 1.0f},
   {0.762373f, 0.876424f, 0.137064f, 1.0f},
   {0.772852f, 0.877868f, 0.131109f, 1.0f},
   {0.783315f, 0.879285f, 0.125405f, 1.0f},
   {0.79376f, 0.880678f, 0.120005f, 1.0f},
   {0.804182f, 0.882046f, 0.114965f, 1.0f},
   {0.814576f, 0.883393f, 0.110347f, 1.0f},
   {0.82494f, 0.88472f, 0.106217f, 1.0f},
   {0.83527f, 0.886029f, 0.102646f, 1.0f},
   {0.845561f, 0.887322f, 0.099702f, 1.0f},
   {0.85581f, 0.888601f, 0.097452f, 1.0f},
   {0.866013f, 0.889868f, 0.095953f, 1.0f},
   {0.876168f, 0.891125f, 0.09525f, 1.0f},
   {0.886271f, 0.892374f, 0.095374f, 1.0f},
   {0.89632f, 0.893616f, 0.096335f, 1.0f},
   {0.906311f, 0.894855f, 0.098125f, 1.0f},
   {0.916242f, 0.896091f, 0.100717f, 1.0f},
   {0.926106f, 0.89733f, 0.104071f, 1.0f},
   {0.935904f, 0.89857f, 0.108131f, 1.0f},
   {0.945636f, 0.899815f, 0.112838f, 1.0f},
   {0.9553f, 0.901065f, 0.118128f, 1.0f},
   {0.964894f, 0.902323f, 0.123941f, 1.0f},
   {0.974417f, 0.90359f, 0.130215f, 1.0f},
   {0.983868f, 0.904867f, 0.136897f, 1.0f},
   {0.993248f, 0.906157f, 0.143936f, 1.0f},
});

const Palette BPAL_39 = Palette("plasma",
{
   {0.050383f, 0.029803f, 0.527975f, 1.0f},
   {0.063536f, 0.028426f, 0.533124f, 1.0f},
   {0.075353f, 0.027206f, 0.538007f, 1.0f},
   {0.086222f, 0.026125f, 0.542658f, 1.0f},
   {0.096379f, 0.025165f, 0.547103f, 1.0f},
   {0.10598f, 0.024309f, 0.551368f, 1.0f},
   {0.115124f, 0.023556f, 0.555468f, 1.0f},
   {0.123903f, 0.022878f, 0.559423f, 1.0f},
   {0.132381f, 0.022258f, 0.56325f, 1.0f},
   {0.140603f, 0.021687f, 0.566959f, 1.0f},
   {0.148607f, 0.021154f, 0.570562f, 1.0f},
   {0.156421f, 0.020651f, 0.574065f, 1.0f},
   {0.16407f, 0.020171f, 0.577478f, 1.0f},
   {0.171574f, 0.019706f, 0.580806f, 1.0f},
   {0.17895f, 0.019252f, 0.584054f, 1.0f},
   {0.186213f, 0.018803f, 0.587228f, 1.0f},
   {0.193374f, 0.018354f, 0.59033f, 1.0f},
   {0.200445f, 0.017902f, 0.593364f, 1.0f},
   {0.207435f, 0.017442f, 0.596333f, 1.0f},
   {0.21435f, 0.016973f, 0.599239f, 1.0f},
   {0.221197f, 0.016497f, 0.602083f, 1.0f},
   {0.227983f, 0.016007f, 0.604867f, 1.0f},
   {0.234715f, 0.015502f, 0.607592f, 1.0f},
   {0.241396f, 0.014979f, 0.610259f, 1.0f},
   {0.248032f, 0.014439f, 0.612868f, 1.0f},
   {0.254627f, 0.013882f, 0.615419f, 1.0f},
   {0.261183f, 0.013308f, 0.617911f, 1.0f},
   {0.267703f, 0.012716f, 0.620346f, 1.0f},
   {0.274191f, 0.012109f, 0.622722f, 1.0f},
   {0.280648f, 0.011488f, 0.625038f, 1.0f},
   {0.287076f, 0.010855f, 0.627295f, 1.0f},
   {0.293478f, 0.010213f, 0.62949f, 1.0f},
   {0.299855f, 0.009561f, 0.631624f, 1.0f},
   {0.30621f, 0.008902f, 0.633694f, 1.0f},
   {0.312543f, 0.008239f, 0.6357f, 1.0f},
   {0.318856f, 0.007576f, 0.63764f, 1.0f},
   {0.32515f, 0.006915f, 0.639512f, 1.0f},
   {0.331426f, 0.006261f, 0.641316f, 1.0f},
   {0.337683f, 0.005618f, 0.643049f, 1.0f},
   {0.343925f, 0.004991f, 0.64471f, 1.0f},
   {0.35015f, 0.004382f, 0.646298f, 1.0f},
   {0.356359f, 0.003798f, 0.64781f, 1.0f},
   {0.362553f, 0.003243f, 0.649245f, 1.0f},
   {0.368733f, 0.002724f, 0.650601f, 1.0f},
   {0.374897f, 0.002245f, 0.651876f, 1.0f},
   {0.381047f, 0.001814f, 0.653068f, 1.0f},
   {0.387183f, 0.001434f, 0.654177f, 1.0f},
   {0.393304f, 0.001114f, 0.655199f, 1.0f},
   {0.399411f, 0.000859f, 0.656133f, 1.0f},
   {0.405503f, 0.000678f, 0.656977f, 1.0f},
   {0.41158f, 0.000577f, 0.65773f, 1.0f},
   {0.417642f, 0.000564f, 0.65839f, 1.0f},
   {0.423689f, 0.000646f, 0.658956f, 1.0f},
   {0.429719f, 0.000831f, 0.659425f, 1.0f},
   {0.435734f, 0.001127f, 0.659797f, 1.0f},
   {0.441732f, 0.00154f, 0.660069f, 1.0f},
   {0.447714f, 0.00208f, 0.66024f, 1.0f},
   {0.453677f, 0.002755f, 0.66031f, 1.0f},
   {0.459623f, 0.003574f, 0.660277f, 1.0f},
   {0.46555f, 0.004545f, 0.660139f, 1.0f},
   {0.471457f, 0.005678f, 0.659897f, 1.0f},
   {0.477344f, 0.00698f, 0.659549f, 1.0f},
   {0.48321f, 0.00846f, 0.659095f, 1.0f},
   {0.489055f, 0.010127f, 0.658534f, 1.0f},
   {0.494877f, 0.01199f, 0.657865f, 1.0f},
   {0.500678f, 0.014055f, 0.657088f, 1.0f},
   {0.506454f, 0.016333f, 0.656202f, 1.0f},
   {0.512206f, 0.018833f, 0.655209f, 1.0f},
   {0.517933f, 0.021563f, 0.654109f, 1.0f},
   {0.523633f, 0.024532f, 0.652901f, 1.0f},
   {0.529306f, 0.027747f, 0.651586f, 1.0f},
   {0.534952f, 0.031217f, 0.650165f, 1.0f},
   {0.54057f, 0.03495f, 0.64864f, 1.0f},
   {0.546157f, 0.038954f, 0.64701f, 1.0f},
   {0.551715f, 0.043136f, 0.645277f, 1.0f},
   {0.557243f, 0.047331f, 0.643443f, 1.0f},
   {0.562738f, 0.051545f, 0.641509f, 1.0f},
   {0.568201f, 0.055778f, 0.639477f, 1.0f},
   {0.573632f, 0.060028f, 0.637349f, 1.0f},
   {0.579029f, 0.064296f, 0.635126f, 1.0f},
   {0.584391f, 0.068579f, 0.632812f, 1.0f},
   {0.589719f, 0.072878f, 0.630408f, 1.0f},
   {0.595011f, 0.07719f, 0.627917f, 1.0f},
   {0.600266f, 0.081516f, 0.625342f, 1.0f},
   {0.605485f, 0.085854f, 0.622686f, 1.0f},
   {0.610667f, 0.090204f, 0.619951f, 1.0f},
   {0.615812f, 0.094564f, 0.61714f, 1.0f},
   {0.620919f, 0.098934f, 0.614257f, 1.0f},
   {0.625987f, 0.103312f, 0.611305f, 1.0f},
   {0.631017f, 0.107699f, 0.608287f, 1.0f},
   {0.636008f, 0.112092f, 0.605205f, 1.0f},
   {0.640959f, 0.116492f, 0.602065f, 1.0f},
   {0.645872f, 0.120898f, 0.598867f, 1.0f},
   {0.650746f, 0.125309f, 0.595617f, 1.0f},
   {0.65558f, 0.129725f, 0.592317f, 1.0f},
   {0.660374f, 0.134144f, 0.588971f, 1.0f},
   {0.665129f, 0.138566f, 0.585582f, 1.0f},
   {0.669845f, 0.142992f, 0.582154f, 1.0f},
   {0.674522f, 0.147419f, 0.578688f, 1.0f},
   {0.67916f, 0.151848f, 0.575189f, 1.0f},
   {0.683758f, 0.156278f, 0.57166f, 1.0f},
   {0.688318f, 0.160709f, 0.568103f, 1.0f},
   {0.69284f, 0.165141f, 0.564522f, 1.0f},
   {0.697324f, 0.169573f, 0.560919f, 1.0f},
   {0.701769f, 0.174005f, 0.557296f, 1.0f},
   {0.706178f, 0.178437f, 0.553657f, 1.0f},
   {0.710549f, 0.182868f, 0.550004f, 1.0f},
   {0.714883f, 0.187299f, 0.546338f, 1.0f},
   {0.719181f, 0.191729f, 0.542663f, 1.0f},
   {0.723444f, 0.196158f, 0.538981f, 1.0f},
   {0.72767f, 0.200586f, 0.535293f, 1.0f},
   {0.731862f, 0.205013f, 0.531601f, 1.0f},
   {0.736019f, 0.209439f, 0.527908f, 1.0f},
   {0.740143f, 0.213864f, 0.524216f, 1.0f},
   {0.744232f, 0.218288f, 0.520524f, 1.0f},
   {0.748289f, 0.222711f, 0.516834f, 1.0f},
   {0.752312f, 0.227133f, 0.513149f, 1.0f},
   {0.756304f, 0.231555f, 0.509468f, 1.0f},
   {0.760264f, 0.235976f, 0.505794f, 1.0f},
   {0.764193f, 0.240396f, 0.502126f, 1.0f},
   {0.76809f, 0.244817f, 0.498465f, 1.0f},
   {0.771958f, 0.249237f, 0.494813f, 1.0f},
   {0.775796f, 0.253658f, 0.491171f, 1.0f},
   {0.779604f, 0.258078f, 0.487539f, 1.0f},
   {0.783383f, 0.2625f, 0.483918f, 1.0f},
   {0.787133f, 0.266922f, 0.480307f, 1.0f},
   {0.790855f, 0.271345f, 0.476706f, 1.0f},
   {0.794549f, 0.27577f, 0.473117f, 1.0f},
   {0.798216f, 0.280197f, 0.469538f, 1.0f},
   {0.801855f, 0.284626f, 0.465971f, 1.0f},
   {0.805467f, 0.289057f, 0.462415f, 1.0f},
   {0.809052f, 0.293491f, 0.45887f, 1.0f},
   {0.812612f, 0.297928f, 0.455338f, 1.0f},
   {0.816144f, 0.302368f, 0.451816f, 1.0f},
   {0.819651f, 0.306812f, 0.448306f, 1.0f},
   {0.823132f, 0.311261f, 0.444806f, 1.0f},
   {0.826588f, 0.315714f, 0.441316f, 1.0f},
   {0.830018f, 0.320172f, 0.437836f, 1.0f},
   {0.833422f, 0.324635f, 0.434366f, 1.0f},
   {0.836801f, 0.329105f, 0.430905f, 1.0f},
   {0.840155f, 0.33358f, 0.427455f, 1.0f},
   {0.843484f, 0.338062f, 0.424013f, 1.0f},
   {0.846788f, 0.342551f, 0.420579f, 1.0f},
   {0.850066f, 0.347048f, 0.417153f, 1.0f},
   {0.853319f, 0.351553f, 0.413734f, 1.0f},
   {0.856547f, 0.356066f, 0.410322f, 1.0f},
   {0.85975f, 0.360588f, 0.406917f, 1.0f},
   {0.862927f, 0.365119f, 0.403519f, 1.0f},
   {0.866078f, 0.36966f, 0.400126f, 1.0f},
   {0.869203f, 0.374212f, 0.396738f, 1.0f},
   {0.872303f, 0.378774f, 0.393355f, 1.0f},
   {0.875376f, 0.383347f, 0.389976f, 1.0f},
   {0.878423f, 0.387932f, 0.3866f, 1.0f},
   {0.881443f, 0.392529f, 0.383229f, 1.0f},
   {0.884436f, 0.397139f, 0.37986f, 1.0f},
   {0.887402f, 0.401762f, 0.376494f, 1.0f},
   {0.89034f, 0.406398f, 0.37313f, 1.0f},
   {0.89325f, 0.411048f, 0.369768f, 1.0f},
   {0.896131f, 0.415712f, 0.366407f, 1.0f},
   {0.898984f, 0.420392f, 0.363047f, 1.0f},
   {0.901807f, 0.425087f, 0.359688f, 1.0f},
   {0.904601f, 0.429797f, 0.356329f, 1.0f},
   {0.907365f, 0.434524f, 0.35297f, 1.0f},
   {0.910098f, 0.439268f, 0.34961f, 1.0f},
   {0.9128f, 0.444029f, 0.346251f, 1.0f},
   {0.915471f, 0.448807f, 0.34289f, 1.0f},
   {0.918109f, 0.453603f, 0.339529f, 1.0f},
   {0.920714f, 0.458417f, 0.336166f, 1.0f},
   {0.923287f, 0.463251f, 0.332801f, 1.0f},
   {0.925825f, 0.468103f, 0.329435f, 1.0f},
   {0.928329f, 0.472975f, 0.326067f, 1.0f},
   {0.930798f, 0.477867f, 0.322697f, 1.0f},
   {0.933232f, 0.48278f, 0.319325f, 1.0f},
   {0.93563f, 0.487712f, 0.315952f, 1.0f},
   {0.93799f, 0.492667f, 0.312575f, 1.0f},
   {0.940313f, 0.497642f, 0.309197f, 1.0f},
   {0.942598f, 0.502639f, 0.305816f, 1.0f},
   {0.944844f, 0.507658f, 0.302433f, 1.0f},
   {0.947051f, 0.512699f, 0.299049f, 1.0f},
   {0.949217f, 0.517763f, 0.295662f, 1.0f},
   {0.951344f, 0.52285f, 0.292275f, 1.0f},
   {0.953428f, 0.52796f, 0.288883f, 1.0f},
   {0.95547f, 0.533093f, 0.28549f, 1.0f},
   {0.957469f, 0.53825f, 0.282096f, 1.0f},
   {0.959424f, 0.543431f, 0.278701f, 1.0f},
   {0.961336f, 0.548636f, 0.275305f, 1.0f},
   {0.963203f, 0.553865f, 0.271909f, 1.0f},
   {0.965024f, 0.559118f, 0.268513f, 1.0f},
   {0.966798f, 0.564396f, 0.265118f, 1.0f},
   {0.968526f, 0.5697f, 0.261721f, 1.0f},
   {0.970205f, 0.575028f, 0.258325f, 1.0f},
   {0.971835f, 0.580382f, 0.254931f, 1.0f},
   {0.973416f, 0.585761f, 0.25154f, 1.0f},
   {0.974947f, 0.591165f, 0.248151f, 1.0f},
   {0.976428f, 0.596595f, 0.244767f, 1.0f},
   {0.977856f, 0.602051f, 0.241387f, 1.0f},
   {0.979233f, 0.607532f, 0.238013f, 1.0f},
   {0.980556f, 0.613039f, 0.234646f, 1.0f},
   {0.981826f, 0.618572f, 0.231287f, 1.0f},
   {0.983041f, 0.624131f, 0.227937f, 1.0f},
   {0.984199f, 0.629718f, 0.224595f, 1.0f},
   {0.985301f, 0.63533f, 0.221265f, 1.0f},
   {0.986345f, 0.640969f, 0.217948f, 1.0f},
   {0.987332f, 0.646633f, 0.214648f, 1.0f},
   {0.98826f, 0.652325f, 0.211364f, 1.0f},
   {0.989128f, 0.658043f, 0.2081f, 1.0f},
   {0.989935f, 0.663787f, 0.204859f, 1.0f},
   {0.990681f, 0.669558f, 0.201642f, 1.0f},
   {0.991365f, 0.675355f, 0.198453f, 1.0f},
   {0.991985f, 0.681179f, 0.195295f, 1.0f},
   {0.992541f, 0.68703f, 0.19217f, 1.0f},
   {0.993032f, 0.692907f, 0.189084f, 1.0f},
   {0.993456f, 0.69881f, 0.186041f, 1.0f},
   {0.993814f, 0.704741f, 0.183043f, 1.0f},
   {0.994103f, 0.710698f, 0.180097f, 1.0f},
   {0.994324f, 0.716681f, 0.177208f, 1.0f},
   {0.994474f, 0.722691f, 0.174381f, 1.0f},
   {0.994553f, 0.728728f, 0.171622f, 1.0f},
   {0.994561f, 0.734791f, 0.168938f, 1.0f},
   {0.994495f, 0.74088f, 0.166335f, 1.0f},
   {0.994355f, 0.746995f, 0.163821f, 1.0f},
   {0.994141f, 0.753137f, 0.161404f, 1.0f},
   {0.993851f, 0.759304f, 0.159092f, 1.0f},
   {0.993482f, 0.765499f, 0.156891f, 1.0f},
   {0.993033f, 0.77172f, 0.154808f, 1.0f},
   {0.992505f, 0.777967f, 0.152855f, 1.0f},
   {0.991897f, 0.784239f, 0.151042f, 1.0f},
   {0.991209f, 0.790537f, 0.149377f, 1.0f},
   {0.990439f, 0.796859f, 0.14787f, 1.0f},
   {0.989587f, 0.803205f, 0.146529f, 1.0f},
   {0.988648f, 0.809579f, 0.145357f, 1.0f},
   {0.987621f, 0.815978f, 0.144363f, 1.0f},
   {0.986509f, 0.822401f, 0.143557f, 1.0f},
   {0.985314f, 0.828846f, 0.142945f, 1.0f},
   {0.984031f, 0.835315f, 0.142528f, 1.0f},
   {0.982653f, 0.841812f, 0.142303f, 1.0f},
   {0.98119f, 0.848329f, 0.142279f, 1.0f},
   {0.979644f, 0.854866f, 0.142453f, 1.0f},
   {0.977995f, 0.861432f, 0.142808f, 1.0f},
   {0.976265f, 0.868016f, 0.143351f, 1.0f},
   {0.974443f, 0.874622f, 0.144061f, 1.0f},
   {0.97253f, 0.88125f, 0.144923f, 1.0f},
   {0.970533f, 0.887896f, 0.145919f, 1.0f},
   {0.968443f, 0.894564f, 0.147014f, 1.0f},
   {0.966271f, 0.901249f, 0.14818f, 1.0f},
   {0.964021f, 0.90795f, 0.14937f, 1.0f},
   {0.961681f, 0.914672f, 0.15052f, 1.0f},
   {0.959276f, 0.921407f, 0.151566f, 1.0f},
   {0.956808f, 0.928152f, 0.152409f, 1.0f},
   {0.954287f, 0.934908f, 0.152921f, 1.0f},
   {0.951726f, 0.941671f, 0.152925f, 1.0f},
   {0.949151f, 0.948435f, 0.152178f, 1.0f},
   {0.946602f, 0.95519f, 0.150328f, 1.0f},
   {0.944152f, 0.961916f, 0.146861f, 1.0f},
   {0.941896f, 0.96859f, 0.140956f, 1.0f},
   {0.940015f, 0.975158f, 0.131326f, 1.0f},
});

const Palette BPAL_40 = Palette("fusion",
{
   {0.152696f, 0.0159421f, 0.0698888f, 1.0f},
   {0.158252f, 0.0169861f, 0.0744861f, 1.0f},
   {0.163816f, 0.0180139f, 0.079049f, 1.0f},
   {0.169388f, 0.0190202f, 0.0835767f, 1.0f},
   {0.174972f, 0.02f, 0.088068f, 1.0f},
   {0.180569f, 0.0209485f, 0.0925211f, 1.0f},
   {0.186181f, 0.0218608f, 0.0969348f, 1.0f},
   {0.19181f, 0.0227318f, 0.101307f, 1.0f},
   {0.197456f, 0.0235573f, 0.105635f, 1.0f},
   {0.203121f, 0.0243325f, 0.109918f, 1.0f},
   {0.208806f, 0.0250524f, 0.114153f, 1.0f},
   {0.214513f, 0.0257133f, 0.118336f, 1.0f},
   {0.220242f, 0.0263109f, 0.122465f, 1.0f},
   {0.225994f, 0.0268414f, 0.126537f, 1.0f},
   {0.23177f, 0.0273013f, 0.130548f, 1.0f},
   {0.237569f, 0.0276873f, 0.134495f, 1.0f},
   {0.243393f, 0.0279961f, 0.138374f, 1.0f},
   {0.249242f, 0.0282259f, 0.14218f, 1.0f},
   {0.255115f, 0.0283749f, 0.14591f, 1.0f},
   {0.261012f, 0.028441f, 0.149558f, 1.0f},
   {0.266933f, 0.0284245f, 0.153121f, 1.0f},
   {0.272878f, 0.0283243f, 0.156592f, 1.0f},
   {0.278844f, 0.0281422f, 0.159968f, 1.0f},
   {0.284833f, 0.0278795f, 0.163243f, 1.0f},
   {0.290841f, 0.0275385f, 0.166411f, 1.0f},
   {0.296869f, 0.027123f, 0.169468f, 1.0f},
   {0.302913f, 0.0266377f, 0.172408f, 1.0f},
   {0.308971f, 0.0260884f, 0.175227f, 1.0f},
   {0.315042f, 0.0254817f, 0.177918f, 1.0f},
   {0.321123f, 0.0248258f, 0.180478f, 1.0f},
   {0.327212f, 0.0241301f, 0.182903f, 1.0f},
   {0.333303f, 0.0234051f, 0.185188f, 1.0f},
   {0.339396f, 0.0226616f, 0.18733f, 1.0f},
   {0.345486f, 0.0219129f, 0.189327f, 1.0f},
   {0.35157f, 0.0211716f, 0.191175f, 1.0f},
   {0.357644f, 0.0204524f, 0.192875f, 1.0f},
   {0.363705f, 0.0197698f, 0.194425f, 1.0f},
   {0.369748f, 0.0191391f, 0.195825f, 1.0f},
   {0.375771f, 0.0185759f, 0.197077f, 1.0f},
   {0.381769f, 0.0180955f, 0.198181f, 1.0f},
   {0.38774f, 0.0177135f, 0.199142f, 1.0f},
   {0.39368f, 0.0174451f, 0.199962f, 1.0f},
   {0.399586f, 0.017305f, 0.200644f, 1.0f},
   {0.405456f, 0.0173076f, 0.201194f, 1.0f},
   {0.411288f, 0.0174662f, 0.201617f, 1.0f},
   {0.417079f, 0.0177939f, 0.201916f, 1.0f},
   {0.422828f, 0.0183027f, 0.202099f, 1.0f},
   {0.428534f, 0.0190039f, 0.202171f, 1.0f},
   {0.434194f, 0.019908f, 0.202137f, 1.0f},
   {0.439808f, 0.0210248f, 0.202004f, 1.0f},
   {0.445377f, 0.0223633f, 0.201777f, 1.0f},
   {0.450898f, 0.0239318f, 0.201461f, 1.0f},
   {0.456372f, 0.0257383f, 0.201064f, 1.0f},
   {0.461799f, 0.0277898f, 0.200588f, 1.0f},
   {0.467178f, 0.0300931f, 0.200041f, 1.0f},
   {0.472511f, 0.0326545f, 0.199427f, 1.0f},
   {0.477797f, 0.03548f, 0.19875f, 1.0f},
   {0.483037f, 0.0385751f, 0.198014f, 1.0f},
   {0.488231f, 0.0419048f, 0.197225f, 1.0f},
   {0.493379f, 0.0453336f, 0.196385f, 1.0f},
   {0.498483f, 0.0488556f, 0.195499f, 1.0f},
   {0.503542f, 0.0524602f, 0.194569f, 1.0f},
   {0.508558f, 0.0561379f, 0.193599f, 1.0f},
   {0.513531f, 0.0598808f, 0.192592f, 1.0f},
   {0.518461f, 0.0636817f, 0.191551f, 1.0f},
   {0.52335f, 0.0675346f, 0.190477f, 1.0f},
   {0.528197f, 0.0714341f, 0.189374f, 1.0f},
   {0.533003f, 0.0753755f, 0.188244f, 1.0f},
   {0.537769f, 0.079355f, 0.187089f, 1.0f},
   {0.542495f, 0.0833693f, 0.18591f, 1.0f},
   {0.547182f, 0.0874152f, 0.18471f, 1.0f},
   {0.55183f, 0.0914904f, 0.18349f, 1.0f},
   {0.55644f, 0.0955927f, 0.182251f, 1.0f},
   {0.561011f, 0.0997203f, 0.180996f, 1.0f},
   {0.565545f, 0.103872f, 0.179725f, 1.0f},
   {0.570042f, 0.108045f, 0.17844f, 1.0f},
   {0.574502f, 0.11224f, 0.177142f, 1.0f},
   {0.578925f, 0.116456f, 0.175832f, 1.0f},
   {0.583312f, 0.120691f, 0.174511f, 1.0f},
   {0.587663f, 0.124945f, 0.173181f, 1.0f},
   {0.591978f, 0.129217f, 0.171843f, 1.0f},
   {0.596257f, 0.133508f, 0.170497f, 1.0f},
   {0.6005f, 0.137816f, 0.169144f, 1.0f},
   {0.604708f, 0.142141f, 0.167786f, 1.0f},
   {0.60888f, 0.146484f, 0.166423f, 1.0f},
   {0.613017f, 0.150844f, 0.165057f, 1.0f},
   {0.617119f, 0.15522f, 0.163688f, 1.0f},
   {0.621185f, 0.159614f, 0.162317f, 1.0f},
   {0.625217f, 0.164025f, 0.160946f, 1.0f},
   {0.629212f, 0.168453f, 0.159575f, 1.0f},
   {0.633173f, 0.172897f, 0.158205f, 1.0f},
   {0.637098f, 0.177359f, 0.156837f, 1.0f},
   {0.640987f, 0.181839f, 0.155473f, 1.0f},
   {0.644841f, 0.186335f, 0.154114f, 1.0f},
   {0.648659f, 0.19085f, 0.15276f, 1.0f},
   {0.652441f, 0.195381f, 0.151414f, 1.0f},
   {0.656187f, 0.199931f, 0.150076f, 1.0f},
   {0.659897f, 0.204499f, 0.148748f, 1.0f},
   {0.66357f, 0.209085f, 0.147431f, 1.0f},
   {0.667206f, 0.21369f, 0.146127f, 1.0f},
   {0.670805f, 0.218313f, 0.144838f, 1.0f},
   {0.674366f, 0.222955f, 0.143565f, 1.0f},
   {0.67789f, 0.227616f, 0.14231f, 1.0f},
   {0.681376f, 0.232296f, 0.141076f, 1.0f},
   {0.684823f, 0.236996f, 0.139864f, 1.0f},
   {0.688232f, 0.241716f, 0.138677f, 1.0f},
   {0.691602f, 0.246455f, 0.137517f, 1.0f},
   {0.694932f, 0.251214f, 0.136387f, 1.0f},
   {0.698222f, 0.255994f, 0.135289f, 1.0f},
   {0.701473f, 0.260794f, 0.134227f, 1.0f},
   {0.704682f, 0.265614f, 0.133204f, 1.0f},
   {0.70785f, 0.270455f, 0.132223f, 1.0f},
   {0.710976f, 0.275318f, 0.131287f, 1.0f},
   {0.714061f, 0.280201f, 0.1304f, 1.0f},
   {0.717103f, 0.285105f, 0.129567f, 1.0f},
   {0.720101f, 0.290031f, 0.12879f, 1.0f},
   {0.723056f, 0.294979f, 0.128076f, 1.0f},
   {0.725967f, 0.299948f, 0.127427f, 1.0f},
   {0.728834f, 0.304939f, 0.126849f, 1.0f},
   {0.731655f, 0.309951f, 0.126346f, 1.0f},
   {0.73443f, 0.314986f, 0.125925f, 1.0f},
   {0.737159f, 0.320042f, 0.125589f, 1.0f},
   {0.739842f, 0.32512f, 0.125345f, 1.0f},
   {0.742477f, 0.33022f, 0.125198f, 1.0f},
   {0.745064f, 0.335342f, 0.125153f, 1.0f},
   {0.747603f, 0.340486f, 0.125217f, 1.0f},
   {0.750093f, 0.345651f, 0.125394f, 1.0f},
   {0.752534f, 0.350839f, 0.125692f, 1.0f},
   {0.754925f, 0.356047f, 0.126115f, 1.0f},
   {0.757266f, 0.361278f, 0.126669f, 1.0f},
   {0.759556f, 0.366529f, 0.12736f, 1.0f},
   {0.761795f, 0.371801f, 0.128193f, 1.0f},
   {0.763983f, 0.377095f, 0.129174f, 1.0f},
   {0.766118f, 0.382408f, 0.130307f, 1.0f},
   {0.768202f, 0.387742f, 0.131598f, 1.0f},
   {0.770233f, 0.393096f, 0.13305f, 1.0f},
   {0.772211f, 0.398468f, 0.134668f, 1.0f},
   {0.774137f, 0.40386f, 0.136455f, 1.0f},
   {0.77601f, 0.40927f, 0.138415f, 1.0f},
   {0.777829f, 0.414698f, 0.14055f, 1.0f},
   {0.779596f, 0.420143f, 0.142864f, 1.0f},
   {0.78131f, 0.425604f, 0.145358f, 1.0f},
   {0.782972f, 0.431082f, 0.148034f, 1.0f},
   {0.784581f, 0.436574f, 0.150892f, 1.0f},
   {0.786138f, 0.442081f, 0.153935f, 1.0f},
   {0.787644f, 0.447602f, 0.157161f, 1.0f},
   {0.789099f, 0.453134f, 0.160572f, 1.0f},
   {0.790503f, 0.458679f, 0.164165f, 1.0f},
   {0.791858f, 0.464234f, 0.167941f, 1.0f},
   {0.793164f, 0.469799f, 0.171899f, 1.0f},
   {0.794423f, 0.475372f, 0.176036f, 1.0f},
   {0.795635f, 0.480953f, 0.180351f, 1.0f},
   {0.796802f, 0.48654f, 0.184842f, 1.0f},
   {0.797925f, 0.492132f, 0.189506f, 1.0f},
   {0.799005f, 0.497728f, 0.19434f, 1.0f},
   {0.800044f, 0.503326f, 0.199342f, 1.0f},
   {0.801044f, 0.508926f, 0.204509f, 1.0f},
   {0.802007f, 0.514527f, 0.209836f, 1.0f},
   {0.802934f, 0.520126f, 0.215322f, 1.0f},
   {0.803828f, 0.525723f, 0.220961f, 1.0f},
   {0.80469f, 0.531316f, 0.226751f, 1.0f},
   {0.805522f, 0.536905f, 0.232687f, 1.0f},
   {0.806328f, 0.542487f, 0.238765f, 1.0f},
   {0.807109f, 0.548063f, 0.244982f, 1.0f},
   {0.807867f, 0.55363f, 0.251334f, 1.0f},
   {0.808605f, 0.559187f, 0.257815f, 1.0f},
   {0.809325f, 0.564734f, 0.264422f, 1.0f},
   {0.81003f, 0.57027f, 0.271151f, 1.0f},
   {0.810723f, 0.575793f, 0.277997f, 1.0f},
   {0.811405f, 0.581303f, 0.284957f, 1.0f},
   {0.81208f, 0.586798f, 0.292025f, 1.0f},
   {0.812749f, 0.592278f, 0.299198f, 1.0f},
   {0.813416f, 0.597742f, 0.306472f, 1.0f},
   {0.814081f, 0.60319f, 0.313842f, 1.0f},
   {0.814749f, 0.608621f, 0.321305f, 1.0f},
   {0.815422f, 0.614033f, 0.328856f, 1.0f},
   {0.8161f, 0.619428f, 0.336492f, 1.0f},
   {0.816788f, 0.624804f, 0.344208f, 1.0f},
   {0.817487f, 0.63016f, 0.352001f, 1.0f},
   {0.818199f, 0.635498f, 0.359868f, 1.0f},
   {0.818926f, 0.640815f, 0.367804f, 1.0f},
   {0.819671f, 0.646113f, 0.375807f, 1.0f},
   {0.820434f, 0.651391f, 0.383873f, 1.0f},
   {0.821219f, 0.656648f, 0.391998f, 1.0f},
   {0.822027f, 0.661886f, 0.40018f, 1.0f},
   {0.822859f, 0.667103f, 0.408416f, 1.0f},
   {0.823717f, 0.672299f, 0.416702f, 1.0f},
   {0.824604f, 0.677476f, 0.425035f, 1.0f},
   {0.825519f, 0.682633f, 0.433414f, 1.0f},
   {0.826466f, 0.68777f, 0.441835f, 1.0f},
   {0.827445f, 0.692887f, 0.450296f, 1.0f},
   {0.828457f, 0.697985f, 0.458793f, 1.0f},
   {0.829505f, 0.703063f, 0.467326f, 1.0f},
   {0.830588f, 0.708123f, 0.475891f, 1.0f},
   {0.831709f, 0.713164f, 0.484487f, 1.0f},
   {0.832868f, 0.718186f, 0.493111f, 1.0f},
   {0.834066f, 0.72319f, 0.501762f, 1.0f},
   {0.835305f, 0.728177f, 0.510436f, 1.0f},
   {0.836585f, 0.733146f, 0.519133f, 1.0f},
   {0.837908f, 0.738098f, 0.527851f, 1.0f},
   {0.839273f, 0.743033f, 0.536587f, 1.0f},
   {0.840682f, 0.747952f, 0.545342f, 1.0f},
   {0.842136f, 0.752856f, 0.554111f, 1.0f},
   {0.843635f, 0.757743f, 0.562894f, 1.0f},
   {0.845181f, 0.762616f, 0.571691f, 1.0f},
   {0.846772f, 0.767474f, 0.580499f, 1.0f},
   {0.848412f, 0.772318f, 0.589315f, 1.0f},
   {0.850099f, 0.777148f, 0.598141f, 1.0f},
   {0.851834f, 0.781965f, 0.606973f, 1.0f},
   {0.853619f, 0.786769f, 0.615812f, 1.0f},
   {0.855453f, 0.791561f, 0.624655f, 1.0f},
   {0.857337f, 0.79634f, 0.633501f, 1.0f},
   {0.859272f, 0.801108f, 0.64235f, 1.0f},
   {0.861257f, 0.805865f, 0.6512f, 1.0f},
   {0.863294f, 0.810611f, 0.66005f, 1.0f},
   {0.865382f, 0.815346f, 0.6689f, 1.0f},
   {0.867523f, 0.820072f, 0.677746f, 1.0f},
   {0.869716f, 0.824788f, 0.68659f, 1.0f},
   {0.871962f, 0.829495f, 0.69543f, 1.0f},
   {0.874261f, 0.834194f, 0.704264f, 1.0f},
   {0.876615f, 0.838884f, 0.713092f, 1.0f},
   {0.879022f, 0.843566f, 0.721914f, 1.0f},
   {0.881484f, 0.848241f, 0.730727f, 1.0f},
   {0.884001f, 0.852908f, 0.739531f, 1.0f},
   {0.886573f, 0.857569f, 0.748324f, 1.0f},
   {0.889202f, 0.862223f, 0.757107f, 1.0f},
   {0.891887f, 0.866871f, 0.765878f, 1.0f},
   {0.894629f, 0.871513f, 0.774635f, 1.0f},
   {0.897428f, 0.87615f, 0.783378f, 1.0f},
   {0.900287f, 0.880781f, 0.792104f, 1.0f},
   {0.903205f, 0.885407f, 0.800814f, 1.0f},
   {0.906183f, 0.890027f, 0.809505f, 1.0f},
   {0.909223f, 0.894643f, 0.818177f, 1.0f},
   {0.912325f, 0.899254f, 0.826827f, 1.0f},
   {0.915492f, 0.90386f, 0.835453f, 1.0f},
   {0.918725f, 0.90846f, 0.844054f, 1.0f},
   {0.922025f, 0.913056f, 0.852627f, 1.0f},
   {0.925397f, 0.917646f, 0.86117f, 1.0f},
   {0.928842f, 0.922229f, 0.869678f, 1.0f},
   {0.932364f, 0.926807f, 0.878147f, 1.0f},
   {0.935968f, 0.931376f, 0.886572f, 1.0f},
   {0.939659f, 0.935937f, 0.894946f, 1.0f},
   {0.943442f, 0.940489f, 0.903261f, 1.0f},
   {0.947325f, 0.94503f, 0.911504f, 1.0f},
   {0.951314f, 0.94956f, 0.919662f, 1.0f},
   {0.955417f, 0.954078f, 0.927717f, 1.0f},
   {0.959638f, 0.958584f, 0.935645f, 1.0f},
   {0.963976f, 0.963083f, 0.94342f, 1.0f},
   {0.968422f, 0.967581f, 0.951016f, 1.0f},
   {0.972955f, 0.972089f, 0.958415f, 1.0f},
   {0.977538f, 0.976622f, 0.965616f, 1.0f},
   {0.982128f, 0.981193f, 0.972642f, 1.0f},
   {0.986687f, 0.985816f, 0.979537f, 1.0f},
   {0.991188f, 0.990494f, 0.986361f, 1.0f},
   {0.995624f, 0.995224f, 0.993167f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
   {0.992867f, 0.995994f, 0.996148f, 1.0f},
   {0.985701f, 0.992018f, 0.99234f, 1.0f},
   {0.978505f, 0.988071f, 0.988577f, 1.0f},
   {0.971281f, 0.984151f, 0.984857f, 1.0f},
   {0.96403f, 0.980258f, 0.981183f, 1.0f},
   {0.956754f, 0.97639f, 0.977554f, 1.0f},
   {0.949454f, 0.972547f, 0.973971f, 1.0f},
   {0.942131f, 0.968727f, 0.970434f, 1.0f},
   {0.934784f, 0.964931f, 0.966943f, 1.0f},
   {0.927415f, 0.961156f, 0.963499f, 1.0f},
   {0.920024f, 0.957404f, 0.960102f, 1.0f},
   {0.912611f, 0.953672f, 0.956752f, 1.0f},
   {0.905175f, 0.949962f, 0.953451f, 1.0f},
   {0.897718f, 0.946271f, 0.950198f, 1.0f},
   {0.89024f, 0.9426f, 0.946994f, 1.0f},
   {0.882739f, 0.938948f, 0.943839f, 1.0f},
   {0.875216f, 0.935315f, 0.940735f, 1.0f},
   {0.867672f, 0.931699f, 0.93768f, 1.0f},
   {0.860105f, 0.928101f, 0.934677f, 1.0f},
   {0.852516f, 0.924521f, 0.931726f, 1.0f},
   {0.844904f, 0.920957f, 0.928827f, 1.0f},
   {0.837271f, 0.917409f, 0.92598f, 1.0f},
   {0.829613f, 0.913877f, 0.923187f, 1.0f},
   {0.821934f, 0.910359f, 0.920447f, 1.0f},
   {0.81423f, 0.906857f, 0.917762f, 1.0f},
   {0.806504f, 0.903368f, 0.915133f, 1.0f},
   {0.798754f, 0.899893f, 0.912559f, 1.0f},
   {0.790979f, 0.896432f, 0.910042f, 1.0f},
   {0.783182f, 0.892982f, 0.907582f, 1.0f},
   {0.775361f, 0.889545f, 0.90518f, 1.0f},
   {0.767514f, 0.886119f, 0.902837f, 1.0f},
   {0.759644f, 0.882704f, 0.900553f, 1.0f},
   {0.751751f, 0.879298f, 0.898329f, 1.0f},
   {0.743833f, 0.875903f, 0.896165f, 1.0f},
   {0.735891f, 0.872516f, 0.894063f, 1.0f},
   {0.727925f, 0.869137f, 0.892023f, 1.0f},
   {0.719935f, 0.865766f, 0.890045f, 1.0f},
   {0.711922f, 0.862401f, 0.888131f, 1.0f},
   {0.703886f, 0.859043f, 0.886281f, 1.0f},
   {0.695828f, 0.85569f, 0.884496f, 1.0f},
   {0.687747f, 0.852341f, 0.882776f, 1.0f},
   {0.679645f, 0.848996f, 0.881122f, 1.0f},
   {0.671522f, 0.845653f, 0.879534f, 1.0f},
   {0.66338f, 0.842313f, 0.878012f, 1.0f},
   {0.655219f, 0.838973f, 0.876558f, 1.0f},
   {0.647041f, 0.835633f, 0.875171f, 1.0f},
   {0.638846f, 0.832293f, 0.873853f, 1.0f},
   {0.630638f, 0.82895f, 0.872602f, 1.0f},
   {0.622416f, 0.825605f, 0.87142f, 1.0f},
   {0.614183f, 0.822256f, 0.870307f, 1.0f},
   {0.605942f, 0.818901f, 0.869261f, 1.0f},
   {0.597694f, 0.81554f, 0.868284f, 1.0f},
   {0.589442f, 0.812172f, 0.867375f, 1.0f},
   {0.58119f, 0.808796f, 0.866533f, 1.0f},
   {0.57294f, 0.80541f, 0.865759f, 1.0f},
   {0.564695f, 0.802013f, 0.865051f, 1.0f},
   {0.556459f, 0.798604f, 0.864409f, 1.0f},
   {0.548237f, 0.795182f, 0.863833f, 1.0f},
   {0.540031f, 0.791745f, 0.863319f, 1.0f},
   {0.531847f, 0.788293f, 0.862868f, 1.0f},
   {0.52369f, 0.784825f, 0.862479f, 1.0f},
   {0.515564f, 0.781338f, 0.862149f, 1.0f},
   {0.507475f, 0.777832f, 0.861876f, 1.0f},
   {0.499428f, 0.774306f, 0.86166f, 1.0f},
   {0.491429f, 0.770759f, 0.861498f, 1.0f},
   {0.483484f, 0.76719f, 0.861387f, 1.0f},
   {0.475599f, 0.763597f, 0.861326f, 1.0f},
   {0.46778f, 0.75998f, 0.861311f, 1.0f},
   {0.460035f, 0.756338f, 0.861341f, 1.0f},
   {0.452369f, 0.75267f, 0.861413f, 1.0f},
   {0.44479f, 0.748976f, 0.861523f, 1.0f},
   {0.437305f, 0.745254f, 0.861669f, 1.0f},
   {0.429919f, 0.741504f, 0.861848f, 1.0f},
   {0.422641f, 0.737726f, 0.862057f, 1.0f},
   {0.415477f, 0.733919f, 0.862293f, 1.0f},
   {0.408434f, 0.730082f, 0.862553f, 1.0f},
   {0.401518f, 0.726216f, 0.862834f, 1.0f},
   {0.394737f, 0.72232f, 0.863132f, 1.0f},
   {0.388096f, 0.718395f, 0.863446f, 1.0f},
   {0.381603f, 0.714439f, 0.863772f, 1.0f},
   {0.375262f, 0.710453f, 0.864108f, 1.0f},
   {0.369081f, 0.706437f, 0.86445f, 1.0f},
   {0.363065f, 0.702391f, 0.864796f, 1.0f},
   {0.357219f, 0.698315f, 0.865144f, 1.0f},
   {0.351548f, 0.69421f, 0.865491f, 1.0f},
   {0.346057f, 0.690076f, 0.865835f, 1.0f},
   {0.340751f, 0.685912f, 0.866174f, 1.0f},
   {0.335633f, 0.68172f, 0.866506f, 1.0f},
   {0.330708f, 0.6775f, 0.866829f, 1.0f},
   {0.325978f, 0.673251f, 0.867141f, 1.0f},
   {0.321447f, 0.668975f, 0.867441f, 1.0f},
   {0.317117f, 0.664672f, 0.867727f, 1.0f},
   {0.31299f, 0.660343f, 0.867997f, 1.0f},
   {0.309069f, 0.655986f, 0.868251f, 1.0f},
   {0.305353f, 0.651604f, 0.868487f, 1.0f},
   {0.301845f, 0.647196f, 0.868704f, 1.0f},
   {0.298544f, 0.642764f, 0.868901f, 1.0f},
   {0.29545f, 0.638306f, 0.869077f, 1.0f},
   {0.292562f, 0.633824f, 0.869232f, 1.0f},
   {0.289879f, 0.629319f, 0.869365f, 1.0f},
   {0.287401f, 0.624789f, 0.869474f, 1.0f},
   {0.285123f, 0.620237f, 0.869561f, 1.0f},
   {0.283045f, 0.615661f, 0.869623f, 1.0f},
   {0.281164f, 0.611063f, 0.86966f, 1.0f},
   {0.279475f, 0.606442f, 0.869673f, 1.0f},
   {0.277976f, 0.6018f, 0.869661f, 1.0f},
   {0.276661f, 0.597135f, 0.869623f, 1.0f},
   {0.275528f, 0.592449f, 0.869559f, 1.0f},
   {0.27457f, 0.587741f, 0.869469f, 1.0f},
   {0.273784f, 0.583013f, 0.869353f, 1.0f},
   {0.273163f, 0.578263f, 0.86921f, 1.0f},
   {0.272703f, 0.573492f, 0.86904f, 1.0f},
   {0.272398f, 0.568701f, 0.868844f, 1.0f},
   {0.272241f, 0.563888f, 0.868621f, 1.0f},
   {0.272227f, 0.559055f, 0.86837f, 1.0f},
   {0.272351f, 0.554201f, 0.868092f, 1.0f},
   {0.272605f, 0.549327f, 0.867787f, 1.0f},
   {0.272985f, 0.544432f, 0.867454f, 1.0f},
   {0.273483f, 0.539516f, 0.867094f, 1.0f},
   {0.274094f, 0.53458f, 0.866706f, 1.0f},
   {0.274813f, 0.529622f, 0.866289f, 1.0f},
   {0.275632f, 0.524644f, 0.865845f, 1.0f},
   {0.276547f, 0.519645f, 0.865372f, 1.0f},
   {0.277551f, 0.514624f, 0.86487f, 1.0f},
   {0.278639f, 0.509582f, 0.86434f, 1.0f},
   {0.279807f, 0.504518f, 0.863781f, 1.0f},
   {0.281047f, 0.499433f, 0.863193f, 1.0f},
   {0.282356f, 0.494326f, 0.862575f, 1.0f},
   {0.283728f, 0.489196f, 0.861928f, 1.0f},
   {0.285159f, 0.484044f, 0.86125f, 1.0f},
   {0.286643f, 0.478869f, 0.860542f, 1.0f},
   {0.288177f, 0.47367f, 0.859803f, 1.0f},
   {0.289756f, 0.468448f, 0.859033f, 1.0f},
   {0.291376f, 0.463203f, 0.858231f, 1.0f},
   {0.293032f, 0.457932f, 0.857397f, 1.0f},
   {0.294722f, 0.452638f, 0.856531f, 1.0f},
   {0.296441f, 0.447318f, 0.855631f, 1.0f},
   {0.298186f, 0.441972f, 0.854697f, 1.0f},
   {0.299953f, 0.4366f, 0.853729f, 1.0f},
   {0.30174f, 0.431202f, 0.852725f, 1.0f},
   {0.303542f, 0.425776f, 0.851685f, 1.0f},
   {0.305357f, 0.420323f, 0.850609f, 1.0f},
   {0.307182f, 0.414842f, 0.849495f, 1.0f},
   {0.309014f, 0.409332f, 0.848342f, 1.0f},
   {0.310851f, 0.403792f, 0.84715f, 1.0f},
   {0.31269f, 0.398222f, 0.845917f, 1.0f},
   {0.314528f, 0.392622f, 0.844642f, 1.0f},
   {0.316362f, 0.38699f, 0.843325f, 1.0f},
   {0.318192f, 0.381326f, 0.841963f, 1.0f},
   {0.320013f, 0.375629f, 0.840556f, 1.0f},
   {0.321824f, 0.369899f, 0.839102f, 1.0f},
   {0.323624f, 0.364135f, 0.837599f, 1.0f},
   {0.325408f, 0.358335f, 0.836047f, 1.0f},
   {0.327177f, 0.3525f, 0.834443f, 1.0f},
   {0.328927f, 0.346628f, 0.832785f, 1.0f},
   {0.330656f, 0.340718f, 0.831072f, 1.0f},
   {0.332363f, 0.33477f, 0.829301f, 1.0f},
   {0.334045f, 0.328783f, 0.827471f, 1.0f},
   {0.3357f, 0.322756f, 0.82558f, 1.0f},
   {0.337327f, 0.316689f, 0.823624f, 1.0f},
   {0.338923f, 0.310579f, 0.821601f, 1.0f},
   {0.340487f, 0.304427f, 0.81951f, 1.0f},
   {0.342017f, 0.298231f, 0.817346f, 1.0f},
   {0.343509f, 0.291991f, 0.815108f, 1.0f},
   {0.344963f, 0.285706f, 0.812791f, 1.0f},
   {0.346376f, 0.279375f, 0.810393f, 1.0f},
   {0.347746f, 0.272997f, 0.80791f, 1.0f},
   {0.34907f, 0.266572f, 0.805338f, 1.0f},
   {0.350348f, 0.260099f, 0.802674f, 1.0f},
   {0.351575f, 0.253577f, 0.799914f, 1.0f},
   {0.35275f, 0.247006f, 0.797053f, 1.0f},
   {0.35387f, 0.240385f, 0.794086f, 1.0f},
   {0.354932f, 0.233715f, 0.791009f, 1.0f},
   {0.355934f, 0.226995f, 0.787817f, 1.0f},
   {0.356873f, 0.220225f, 0.784504f, 1.0f},
   {0.357746f, 0.213406f, 0.781065f, 1.0f},
   {0.358549f, 0.206539f, 0.777494f, 1.0f},
   {0.35928f, 0.199625f, 0.773785f, 1.0f},
   {0.359935f, 0.192665f, 0.769931f, 1.0f},
   {0.360509f, 0.185662f, 0.765925f, 1.0f},
   {0.361f, 0.178619f, 0.76176f, 1.0f},
   {0.361403f, 0.171539f, 0.757428f, 1.0f},
   {0.361714f, 0.164427f, 0.752923f, 1.0f},
   {0.361928f, 0.15729f, 0.748235f, 1.0f},
   {0.362041f, 0.150135f, 0.743357f, 1.0f},
   {0.362047f, 0.142971f, 0.73828f, 1.0f},
   {0.36194f, 0.13581f, 0.732995f, 1.0f},
   {0.361716f, 0.128666f, 0.727494f, 1.0f},
   {0.361368f, 0.121555f, 0.721768f, 1.0f},
   {0.36089f, 0.1145f, 0.715808f, 1.0f},
   {0.360275f, 0.107524f, 0.709606f, 1.0f},
   {0.359517f, 0.100659f, 0.703155f, 1.0f},
   {0.358608f, 0.0939408f, 0.696448f, 1.0f},
   {0.357543f, 0.0874113f, 0.689478f, 1.0f},
   {0.356313f, 0.0811204f, 0.682243f, 1.0f},
   {0.354912f, 0.0751246f, 0.674739f, 1.0f},
   {0.353334f, 0.0694873f, 0.666966f, 1.0f},
   {0.351572f, 0.0642768f, 0.658927f, 1.0f},
   {0.349622f, 0.0595637f, 0.650629f, 1.0f},
   {0.34748f, 0.0554164f, 0.642079f, 1.0f},
   {0.345142f, 0.0518949f, 0.633292f, 1.0f},
   {0.342608f, 0.0490444f, 0.624285f, 1.0f},
   {0.339878f, 0.0468879f, 0.615077f, 1.0f},
   {0.336955f, 0.0454217f, 0.605692f, 1.0f},
   {0.333842f, 0.044614f, 0.596156f, 1.0f},
   {0.330547f, 0.0444074f, 0.586498f, 1.0f},
   {0.327077f, 0.0447246f, 0.576747f, 1.0f},
   {0.323441f, 0.0454771f, 0.566931f, 1.0f},
   {0.31965f, 0.046573f, 0.557078f, 1.0f},
   {0.315715f, 0.047924f, 0.547215f, 1.0f},
   {0.311647f, 0.0494489f, 0.537366f, 1.0f},
   {0.307459f, 0.0510781f, 0.527552f, 1.0f},
   {0.303161f, 0.052753f, 0.517792f, 1.0f},
   {0.298765f, 0.0544273f, 0.508102f, 1.0f},
   {0.29428f, 0.0560632f, 0.498494f, 1.0f},
   {0.289717f, 0.057632f, 0.48898f, 1.0f},
   {0.285085f, 0.0591125f, 0.479568f, 1.0f},
   {0.280391f, 0.0604899f, 0.470264f, 1.0f},
   {0.275643f, 0.0617545f, 0.461072f, 1.0f},
   {0.270849f, 0.0628987f, 0.451995f, 1.0f},
   {0.266013f, 0.0639185f, 0.443035f, 1.0f},
   {0.261142f, 0.0648119f, 0.434193f, 1.0f},
   {0.25624f, 0.0655797f, 0.425468f, 1.0f},
   {0.251311f, 0.0662222f, 0.41686f, 1.0f},
   {0.24636f, 0.0667412f, 0.408367f, 1.0f},
   {0.241389f, 0.0671388f, 0.399988f, 1.0f},
   {0.236402f, 0.0674182f, 0.39172f, 1.0f},
   {0.231401f, 0.0675826f, 0.383562f, 1.0f},
   {0.226389f, 0.0676358f, 0.375509f, 1.0f},
   {0.221367f, 0.0675794f, 0.367561f, 1.0f},
   {0.216338f, 0.0674178f, 0.359714f, 1.0f},
   {0.211303f, 0.0671538f, 0.351965f, 1.0f},
   {0.206263f, 0.0667908f, 0.344311f, 1.0f},
   {0.201219f, 0.0663307f, 0.336751f, 1.0f},
   {0.196174f, 0.0657776f, 0.32928f, 1.0f},
   {0.191126f, 0.0651338f, 0.321895f, 1.0f},
   {0.186078f, 0.064401f, 0.314596f, 1.0f},
   {0.18103f, 0.0635819f, 0.307379f, 1.0f},
   {0.175982f, 0.0626788f, 0.30024f, 1.0f},
   {0.170935f, 0.0616938f, 0.293178f, 1.0f},
   {0.16589f, 0.0606287f, 0.28619f, 1.0f},
   {0.160845f, 0.0594852f, 0.279273f, 1.0f},
   {0.155803f, 0.0582641f, 0.272426f, 1.0f},
   {0.150762f, 0.0569672f, 0.265646f, 1.0f},
   {0.145723f, 0.0555958f, 0.25893f, 1.0f},
   {0.140685f, 0.0541513f, 0.252276f, 1.0f},
   {0.135649f, 0.0526338f, 0.245682f, 1.0f},
   {0.130615f, 0.0510438f, 0.239148f, 1.0f},
   {0.125581f, 0.0493829f, 0.232668f, 1.0f},
   {0.120548f, 0.0476499f, 0.226244f, 1.0f},
   {0.115516f, 0.0458462f, 0.219871f, 1.0f},
   {0.110483f, 0.0439708f, 0.213549f, 1.0f},
   {0.10545f, 0.042024f, 0.207275f, 1.0f},
   {0.100416f, 0.0399983f, 0.201049f, 1.0f},
   {0.0953789f, 0.037917f, 0.194868f, 1.0f},
});

const Palette BPAL_41 = Palette("iceburn",
{
   {0.578693f, 0.947005f, 0.953835f, 1.0f},
   {0.573301f, 0.942448f, 0.952186f, 1.0f},
   {0.567904f, 0.937906f, 0.95055f, 1.0f},
   {0.562502f, 0.933378f, 0.94893f, 1.0f},
   {0.557094f, 0.928865f, 0.947323f, 1.0f},
   {0.55168f, 0.924365f, 0.945732f, 1.0f},
   {0.54626f, 0.919878f, 0.944157f, 1.0f},
   {0.540834f, 0.915405f, 0.942596f, 1.0f},
   {0.535401f, 0.910945f, 0.941053f, 1.0f},
   {0.529962f, 0.906498f, 0.939525f, 1.0f},
   {0.524515f, 0.902063f, 0.938014f, 1.0f},
   {0.519061f, 0.897641f, 0.93652f, 1.0f},
   {0.5136f, 0.893231f, 0.935043f, 1.0f},
   {0.508131f, 0.888833f, 0.933583f, 1.0f},
   {0.502653f, 0.884447f, 0.932141f, 1.0f},
   {0.497168f, 0.880071f, 0.930716f, 1.0f},
   {0.491674f, 0.875708f, 0.92931f, 1.0f},
   {0.486172f, 0.871355f, 0.927922f, 1.0f},
   {0.480661f, 0.867012f, 0.926552f, 1.0f},
   {0.475141f, 0.86268f, 0.925202f, 1.0f},
   {0.469611f, 0.858358f, 0.92387f, 1.0f},
   {0.464073f, 0.854046f, 0.922557f, 1.0f},
   {0.458524f, 0.849744f, 0.921263f, 1.0f},
   {0.452966f, 0.845451f, 0.919989f, 1.0f},
   {0.447398f, 0.841167f, 0.918735f, 1.0f},
   {0.441819f, 0.836892f, 0.9175f, 1.0f},
   {0.436231f, 0.832626f, 0.916285f, 1.0f},
   {0.430631f, 0.828367f, 0.91509f, 1.0f},
   {0.425021f, 0.824117f, 0.913916f, 1.0f},
   {0.4194f, 0.819875f, 0.912761f, 1.0f},
   {0.413768f, 0.81564f, 0.911627f, 1.0f},
   {0.408125f, 0.811412f, 0.910514f, 1.0f},
   {0.40247f, 0.80719f, 0.909421f, 1.0f},
   {0.396803f, 0.802976f, 0.908349f, 1.0f},
   {0.391125f, 0.798767f, 0.907297f, 1.0f},
   {0.385435f, 0.794565f, 0.906267f, 1.0f},
   {0.379733f, 0.790368f, 0.905257f, 1.0f},
   {0.374018f, 0.786177f, 0.904268f, 1.0f},
   {0.368292f, 0.78199f, 0.903301f, 1.0f},
   {0.362553f, 0.777809f, 0.902354f, 1.0f},
   {0.356801f, 0.773631f, 0.901427f, 1.0f},
   {0.351037f, 0.769458f, 0.900522f, 1.0f},
   {0.345261f, 0.765288f, 0.899639f, 1.0f},
   {0.339472f, 0.761122f, 0.898775f, 1.0f},
   {0.33367f, 0.756959f, 0.897933f, 1.0f},
   {0.327856f, 0.752798f, 0.897111f, 1.0f},
   {0.322029f, 0.74864f, 0.896311f, 1.0f},
   {0.31619f, 0.744484f, 0.89553f, 1.0f},
   {0.310339f, 0.74033f, 0.894771f, 1.0f},
   {0.304475f, 0.736176f, 0.894031f, 1.0f},
   {0.2986f, 0.732024f, 0.893312f, 1.0f},
   {0.292713f, 0.727872f, 0.892613f, 1.0f},
   {0.286816f, 0.72372f, 0.891934f, 1.0f},
   {0.280907f, 0.719568f, 0.891274f, 1.0f},
   {0.274989f, 0.715415f, 0.890634f, 1.0f},
   {0.269061f, 0.711261f, 0.890013f, 1.0f},
   {0.263125f, 0.707106f, 0.889411f, 1.0f},
   {0.257181f, 0.702949f, 0.888827f, 1.0f},
   {0.25123f, 0.698789f, 0.888261f, 1.0f},
   {0.245275f, 0.694626f, 0.887714f, 1.0f},
   {0.239315f, 0.69046f, 0.887183f, 1.0f},
   {0.233354f, 0.686291f, 0.886669f, 1.0f},
   {0.227392f, 0.682117f, 0.886172f, 1.0f},
   {0.221432f, 0.677938f, 0.88569f, 1.0f},
   {0.215478f, 0.673755f, 0.885224f, 1.0f},
   {0.209532f, 0.669566f, 0.884772f, 1.0f},
   {0.203597f, 0.66537f, 0.884334f, 1.0f},
   {0.197677f, 0.661168f, 0.883909f, 1.0f},
   {0.191778f, 0.656959f, 0.883495f, 1.0f},
   {0.185905f, 0.652742f, 0.883094f, 1.0f},
   {0.180064f, 0.648516f, 0.882702f, 1.0f},
   {0.174262f, 0.644282f, 0.882319f, 1.0f},
   {0.168507f, 0.640039f, 0.881944f, 1.0f},
   {0.16281f, 0.635785f, 0.881576f, 1.0f},
   {0.15718f, 0.631522f, 0.881213f, 1.0f},
   {0.15163f, 0.627247f, 0.880854f, 1.0f},
   {0.146176f, 0.62296f, 0.880497f, 1.0f},
   {0.140831f, 0.618661f, 0.88014f, 1.0f},
   {0.135617f, 0.61435f, 0.879781f, 1.0f},
   {0.130552f, 0.610024f, 0.879418f, 1.0f},
   {0.125662f, 0.605685f, 0.879049f, 1.0f},
   {0.120972f, 0.601332f, 0.878672f, 1.0f},
   {0.116512f, 0.596963f, 0.878283f, 1.0f},
   {0.112313f, 0.592578f, 0.87788f, 1.0f},
   {0.108412f, 0.588177f, 0.877459f, 1.0f},
   {0.104844f, 0.583759f, 0.877017f, 1.0f},
   {0.101649f, 0.579324f, 0.876551f, 1.0f},
   {0.0988651f, 0.574871f, 0.876055f, 1.0f},
   {0.0965299f, 0.5704f, 0.875526f, 1.0f},
   {0.0946801f, 0.56591f, 0.874958f, 1.0f},
   {0.0933459f, 0.561401f, 0.874347f, 1.0f},
   {0.0925535f, 0.556873f, 0.873686f, 1.0f},
   {0.0923194f, 0.552325f, 0.872968f, 1.0f},
   {0.0926524f, 0.547757f, 0.872188f, 1.0f},
   {0.0935519f, 0.543171f, 0.871338f, 1.0f},
   {0.0950067f, 0.538564f, 0.87041f, 1.0f},
   {0.0969974f, 0.533939f, 0.869394f, 1.0f},
   {0.099496f, 0.529295f, 0.868282f, 1.0f},
   {0.102468f, 0.524634f, 0.867064f, 1.0f},
   {0.105875f, 0.519956f, 0.865728f, 1.0f},
   {0.109676f, 0.515263f, 0.864264f, 1.0f},
   {0.113826f, 0.510556f, 0.862659f, 1.0f},
   {0.11828f, 0.505837f, 0.860902f, 1.0f},
   {0.122996f, 0.501109f, 0.858977f, 1.0f},
   {0.127928f, 0.496374f, 0.856874f, 1.0f},
   {0.133035f, 0.491636f, 0.854577f, 1.0f},
   {0.138275f, 0.486898f, 0.852074f, 1.0f},
   {0.143607f, 0.482164f, 0.849352f, 1.0f},
   {0.148994f, 0.477439f, 0.846399f, 1.0f},
   {0.154398f, 0.472728f, 0.843205f, 1.0f},
   {0.159783f, 0.468035f, 0.839759f, 1.0f},
   {0.165116f, 0.463365f, 0.836057f, 1.0f},
   {0.170365f, 0.458725f, 0.832092f, 1.0f},
   {0.175501f, 0.454118f, 0.827863f, 1.0f},
   {0.180497f, 0.449549f, 0.82337f, 1.0f},
   {0.185329f, 0.445023f, 0.818618f, 1.0f},
   {0.189979f, 0.440544f, 0.813613f, 1.0f},
   {0.194429f, 0.436115f, 0.808363f, 1.0f},
   {0.198666f, 0.431738f, 0.80288f, 1.0f},
   {0.202682f, 0.427414f, 0.797177f, 1.0f},
   {0.206469f, 0.423147f, 0.791267f, 1.0f},
   {0.210024f, 0.418935f, 0.785165f, 1.0f},
   {0.213347f, 0.414778f, 0.778887f, 1.0f},
   {0.21644f, 0.410677f, 0.772449f, 1.0f},
   {0.219305f, 0.40663f, 0.765864f, 1.0f},
   {0.221949f, 0.402636f, 0.75915f, 1.0f},
   {0.224376f, 0.398693f, 0.752318f, 1.0f},
   {0.226594f, 0.3948f, 0.745383f, 1.0f},
   {0.22861f, 0.390954f, 0.738357f, 1.0f},
   {0.230432f, 0.387154f, 0.731252f, 1.0f},
   {0.232069f, 0.383398f, 0.724079f, 1.0f},
   {0.233528f, 0.379683f, 0.716847f, 1.0f},
   {0.234816f, 0.376008f, 0.709566f, 1.0f},
   {0.235942f, 0.37237f, 0.702244f, 1.0f},
   {0.236914f, 0.368768f, 0.694888f, 1.0f},
   {0.237739f, 0.3652f, 0.687506f, 1.0f},
   {0.238422f, 0.361664f, 0.680103f, 1.0f},
   {0.238973f, 0.358158f, 0.672686f, 1.0f},
   {0.239395f, 0.35468f, 0.665259f, 1.0f},
   {0.239696f, 0.351229f, 0.657827f, 1.0f},
   {0.239882f, 0.347804f, 0.650394f, 1.0f},
   {0.239957f, 0.344403f, 0.642964f, 1.0f},
   {0.239927f, 0.341025f, 0.635541f, 1.0f},
   {0.239796f, 0.337668f, 0.628127f, 1.0f},
   {0.239569f, 0.334331f, 0.620726f, 1.0f},
   {0.239251f, 0.331013f, 0.613339f, 1.0f},
   {0.238845f, 0.327713f, 0.60597f, 1.0f},
   {0.238356f, 0.32443f, 0.598619f, 1.0f},
   {0.237786f, 0.321164f, 0.59129f, 1.0f},
   {0.237139f, 0.317912f, 0.583983f, 1.0f},
   {0.236419f, 0.314674f, 0.576701f, 1.0f},
   {0.235628f, 0.31145f, 0.569444f, 1.0f},
   {0.234769f, 0.308238f, 0.562213f, 1.0f},
   {0.233844f, 0.305038f, 0.55501f, 1.0f},
   {0.232858f, 0.301849f, 0.547836f, 1.0f},
   {0.231811f, 0.298671f, 0.540691f, 1.0f},
   {0.230706f, 0.295502f, 0.533576f, 1.0f},
   {0.229545f, 0.292342f, 0.526493f, 1.0f},
   {0.22833f, 0.289192f, 0.519441f, 1.0f},
   {0.227063f, 0.286049f, 0.51242f, 1.0f},
   {0.225746f, 0.282913f, 0.505432f, 1.0f},
   {0.224381f, 0.279785f, 0.498477f, 1.0f},
   {0.222969f, 0.276663f, 0.491555f, 1.0f},
   {0.221511f, 0.273547f, 0.484667f, 1.0f},
   {0.22001f, 0.270437f, 0.477811f, 1.0f},
   {0.218466f, 0.267331f, 0.47099f, 1.0f},
   {0.216882f, 0.264231f, 0.464203f, 1.0f},
   {0.215257f, 0.261135f, 0.457449f, 1.0f},
   {0.213593f, 0.258043f, 0.45073f, 1.0f},
   {0.211892f, 0.254954f, 0.444044f, 1.0f},
   {0.210155f, 0.251869f, 0.437393f, 1.0f},
   {0.208382f, 0.248786f, 0.430775f, 1.0f},
   {0.206574f, 0.245706f, 0.424192f, 1.0f},
   {0.204732f, 0.242628f, 0.417642f, 1.0f},
   {0.202858f, 0.239552f, 0.411127f, 1.0f},
   {0.200952f, 0.236478f, 0.404645f, 1.0f},
   {0.199014f, 0.233405f, 0.398196f, 1.0f},
   {0.197046f, 0.230332f, 0.391781f, 1.0f},
   {0.195048f, 0.227261f, 0.385399f, 1.0f},
   {0.193021f, 0.224189f, 0.37905f, 1.0f},
   {0.190966f, 0.221118f, 0.372733f, 1.0f},
   {0.188882f, 0.218047f, 0.36645f, 1.0f},
   {0.186771f, 0.214975f, 0.360198f, 1.0f},
   {0.184633f, 0.211902f, 0.353979f, 1.0f},
   {0.182469f, 0.208828f, 0.347791f, 1.0f},
   {0.180279f, 0.205752f, 0.341635f, 1.0f},
   {0.178063f, 0.202675f, 0.335511f, 1.0f},
   {0.175822f, 0.199597f, 0.329417f, 1.0f},
   {0.173557f, 0.196516f, 0.323354f, 1.0f},
   {0.171267f, 0.193432f, 0.317321f, 1.0f},
   {0.168953f, 0.190346f, 0.311318f, 1.0f},
   {0.166616f, 0.187256f, 0.305345f, 1.0f},
   {0.164255f, 0.184164f, 0.299401f, 1.0f},
   {0.161871f, 0.181068f, 0.293487f, 1.0f},
   {0.159464f, 0.177967f, 0.287601f, 1.0f},
   {0.157034f, 0.174863f, 0.281743f, 1.0f},
   {0.154582f, 0.171754f, 0.275913f, 1.0f},
   {0.152107f, 0.168641f, 0.270111f, 1.0f},
   {0.14961f, 0.165522f, 0.264336f, 1.0f},
   {0.147091f, 0.162398f, 0.258587f, 1.0f},
   {0.14455f, 0.159268f, 0.252865f, 1.0f},
   {0.141987f, 0.156132f, 0.247169f, 1.0f},
   {0.139402f, 0.15299f, 0.241499f, 1.0f},
   {0.136795f, 0.149841f, 0.235853f, 1.0f},
   {0.134167f, 0.146684f, 0.230232f, 1.0f},
   {0.131516f, 0.143521f, 0.224635f, 1.0f},
   {0.128843f, 0.140349f, 0.219062f, 1.0f},
   {0.126149f, 0.137169f, 0.213511f, 1.0f},
   {0.123432f, 0.13398f, 0.207984f, 1.0f},
   {0.120693f, 0.130782f, 0.202479f, 1.0f},
   {0.117932f, 0.127575f, 0.196995f, 1.0f},
   {0.115148f, 0.124357f, 0.191532f, 1.0f},
   {0.112341f, 0.121129f, 0.18609f, 1.0f},
   {0.109511f, 0.11789f, 0.180668f, 1.0f},
   {0.106658f, 0.11464f, 0.175265f, 1.0f},
   {0.103781f, 0.111377f, 0.169881f, 1.0f},
   {0.100881f, 0.108101f, 0.164514f, 1.0f},
   {0.0979553f, 0.104812f, 0.159166f, 1.0f},
   {0.0950053f, 0.101509f, 0.153833f, 1.0f},
   {0.0920299f, 0.0981908f, 0.148517f, 1.0f},
   {0.0890287f, 0.0948575f, 0.143216f, 1.0f},
   {0.0860011f, 0.0915079f, 0.137929f, 1.0f},
   {0.0829463f, 0.0881411f, 0.132656f, 1.0f},
   {0.0798638f, 0.0847564f, 0.127395f, 1.0f},
   {0.0767526f, 0.0813528f, 0.122146f, 1.0f},
   {0.0736121f, 0.0779292f, 0.116907f, 1.0f},
   {0.0704412f, 0.0744845f, 0.111679f, 1.0f},
   {0.0672389f, 0.0710177f, 0.106458f, 1.0f},
   {0.0640041f, 0.0675273f, 0.101245f, 1.0f},
   {0.0607355f, 0.0640121f, 0.0960382f, 1.0f},
   {0.0574318f, 0.0604705f, 0.0908357f, 1.0f},
   {0.0540915f, 0.056901f, 0.0856362f, 1.0f},
   {0.0507128f, 0.0533017f, 0.0804381f, 1.0f},
   {0.047294f, 0.0496706f, 0.0752398f, 1.0f},
   {0.0438329f, 0.0460057f, 0.070039f, 1.0f},
   {0.0403253f, 0.0423046f, 0.0648337f, 1.0f},
   {0.036812f, 0.0385588f, 0.0596216f, 1.0f},
   {0.0334384f, 0.0349235f, 0.0543999f, 1.0f},
   {0.0302066f, 0.0314566f, 0.0491656f, 1.0f},
   {0.0271186f, 0.0281589f, 0.0439152f, 1.0f},
   {0.0241767f, 0.0250311f, 0.0386383f, 1.0f},
   {0.0213832f, 0.0220743f, 0.0336013f, 1.0f},
   {0.0187405f, 0.0192895f, 0.0289448f, 1.0f},
   {0.0162514f, 0.016678f, 0.024661f, 1.0f},
   {0.0139187f, 0.0142415f, 0.0207421f, 1.0f},
   {0.0117457f, 0.0119817f, 0.0171806f, 1.0f},
   {0.00973575f, 0.00990088f, 0.0139694f, 1.0f},
   {0.00789285f, 0.0080016f, 0.0111019f, 1.0f},
   {0.00622148f, 0.00628698f, 0.00857157f, 1.0f},
   {0.00472684f, 0.00476083f, 0.00637274f, 1.0f},
   {0.00341513f, 0.0034279f, 0.00450037f, 1.0f},
   {0.00229394f, 0.00229426f, 0.00295046f, 1.0f},
   {0.00137302f, 0.001368f, 0.00172056f, 1.0f},
   {0.000665757f, 0.000660629f, 0.000810978f, 1.0f},
   {0.000192918f, 0.000190603f, 0.000227925f, 1.0f},
   {0.0f, 0.0f, 0.0f, 1.0f},
   {0.000246148f, 0.000174022f, 0.000186778f, 1.0f},
   {0.000876506f, 0.000595218f, 0.000645816f, 1.0f},
   {0.00186026f, 0.00121727f, 0.00133402f, 1.0f},
   {0.00319002f, 0.00201789f, 0.00223163f, 1.0f},
   {0.00486438f, 0.00298218f, 0.00332572f, 1.0f},
   {0.00688465f, 0.004099f, 0.00460664f, 1.0f},
   {0.0092536f, 0.00535941f, 0.0060667f, 1.0f},
   {0.011975f, 0.006756f, 0.00769941f, 1.0f},
   {0.0150531f, 0.00828238f, 0.00949915f, 1.0f},
   {0.0184928f, 0.00993297f, 0.0114609f, 1.0f},
   {0.0222993f, 0.0117028f, 0.0135799f, 1.0f},
   {0.026478f, 0.0135874f, 0.0158521f, 1.0f},
   {0.0310346f, 0.0155826f, 0.0182732f, 1.0f},
   {0.0359748f, 0.0176847f, 0.0208395f, 1.0f},
   {0.0412853f, 0.0198902f, 0.0235473f, 1.0f},
   {0.0466369f, 0.0221957f, 0.0263928f, 1.0f},
   {0.0519583f, 0.0245984f, 0.0293725f, 1.0f},
   {0.0572533f, 0.0270952f, 0.032483f, 1.0f},
   {0.0625253f, 0.0296834f, 0.0357208f, 1.0f},
   {0.0677771f, 0.0323604f, 0.0390823f, 1.0f},
   {0.0730114f, 0.0351237f, 0.0424979f, 1.0f},
   {0.0782303f, 0.037971f, 0.0458515f, 1.0f},
   {0.083436f, 0.040891f, 0.0491545f, 1.0f},
   {0.0886303f, 0.0437692f, 0.0524087f, 1.0f},
   {0.0938147f, 0.0466043f, 0.0556155f, 1.0f},
   {0.0989907f, 0.0493983f, 0.0587762f, 1.0f},
   {0.10416f, 0.0521527f, 0.061892f, 1.0f},
   {0.109323f, 0.0548691f, 0.0649637f, 1.0f},
   {0.114482f, 0.0575492f, 0.0679924f, 1.0f},
   {0.119637f, 0.0601941f, 0.0709787f, 1.0f},
   {0.124789f, 0.0628052f, 0.0739234f, 1.0f},
   {0.129939f, 0.0653837f, 0.0768269f, 1.0f},
   {0.135089f, 0.0679305f, 0.0796898f, 1.0f},
   {0.140237f, 0.0704469f, 0.0825125f, 1.0f},
   {0.145387f, 0.0729337f, 0.0852953f, 1.0f},
   {0.150537f, 0.0753918f, 0.0880386f, 1.0f},
   {0.155688f, 0.0778222f, 0.0907425f, 1.0f},
   {0.160842f, 0.0802256f, 0.0934071f, 1.0f},
   {0.165997f, 0.0826029f, 0.0960328f, 1.0f},
   {0.171156f, 0.0849547f, 0.0986194f, 1.0f},
   {0.176318f, 0.0872819f, 0.101167f, 1.0f},
   {0.181484f, 0.0895851f, 0.103676f, 1.0f},
   {0.186653f, 0.0918649f, 0.106145f, 1.0f},
   {0.191827f, 0.094122f, 0.108576f, 1.0f},
   {0.197006f, 0.0963571f, 0.110968f, 1.0f},
   {0.202189f, 0.0985707f, 0.11332f, 1.0f},
   {0.207377f, 0.100763f, 0.115632f, 1.0f},
   {0.21257f, 0.102936f, 0.117905f, 1.0f},
   {0.217769f, 0.105089f, 0.120138f, 1.0f},
   {0.222973f, 0.107222f, 0.122331f, 1.0f},
   {0.228183f, 0.109337f, 0.124484f, 1.0f},
   {0.233398f, 0.111434f, 0.126595f, 1.0f},
   {0.238619f, 0.113514f, 0.128666f, 1.0f},
   {0.243847f, 0.115576f, 0.130696f, 1.0f},
   {0.249079f, 0.117622f, 0.132684f, 1.0f},
   {0.254318f, 0.119653f, 0.13463f, 1.0f},
   {0.259563f, 0.121668f, 0.136533f, 1.0f},
   {0.264813f, 0.123668f, 0.138394f, 1.0f},
   {0.27007f, 0.125654f, 0.140212f, 1.0f},
   {0.275332f, 0.127626f, 0.141986f, 1.0f},
   {0.280599f, 0.129585f, 0.143716f, 1.0f},
   {0.285873f, 0.131532f, 0.145402f, 1.0f},
   {0.291151f, 0.133466f, 0.147043f, 1.0f},
   {0.296435f, 0.13539f, 0.148639f, 1.0f},
   {0.301724f, 0.137302f, 0.150189f, 1.0f},
   {0.307018f, 0.139205f, 0.151693f, 1.0f},
   {0.312316f, 0.141098f, 0.153151f, 1.0f},
   {0.317619f, 0.142982f, 0.154562f, 1.0f},
   {0.322926f, 0.144857f, 0.155925f, 1.0f},
   {0.328237f, 0.146726f, 0.15724f, 1.0f},
   {0.333552f, 0.148587f, 0.158507f, 1.0f},
   {0.33887f, 0.150442f, 0.159726f, 1.0f},
   {0.344191f, 0.152292f, 0.160895f, 1.0f},
   {0.349514f, 0.154137f, 0.162015f, 1.0f},
   {0.35484f, 0.155979f, 0.163084f, 1.0f},
   {0.360167f, 0.157817f, 0.164103f, 1.0f},
   {0.365496f, 0.159653f, 0.165072f, 1.0f},
   {0.370826f, 0.161487f, 0.165989f, 1.0f},
   {0.376156f, 0.16332f, 0.166855f, 1.0f},
   {0.381486f, 0.165154f, 0.167669f, 1.0f},
   {0.386815f, 0.166989f, 0.16843f, 1.0f},
   {0.392144f, 0.168826f, 0.16914f, 1.0f},
   {0.39747f, 0.170666f, 0.169796f, 1.0f},
   {0.402795f, 0.172509f, 0.1704f, 1.0f},
   {0.408116f, 0.174358f, 0.17095f, 1.0f},
   {0.413434f, 0.176212f, 0.171448f, 1.0f},
   {0.418748f, 0.178073f, 0.171891f, 1.0f},
   {0.424057f, 0.179942f, 0.172281f, 1.0f},
   {0.429361f, 0.18182f, 0.172618f, 1.0f},
   {0.434658f, 0.183708f, 0.1729f, 1.0f},
   {0.439948f, 0.185607f, 0.173129f, 1.0f},
   {0.445231f, 0.187518f, 0.173304f, 1.0f},
   {0.450505f, 0.189442f, 0.173426f, 1.0f},
   {0.455769f, 0.191381f, 0.173494f, 1.0f},
   {0.461024f, 0.193336f, 0.173508f, 1.0f},
   {0.466268f, 0.195307f, 0.17347f, 1.0f},
   {0.4715f, 0.197295f, 0.173379f, 1.0f},
   {0.47672f, 0.199303f, 0.173235f, 1.0f},
   {0.481926f, 0.201331f, 0.17304f, 1.0f},
   {0.487118f, 0.20338f, 0.172792f, 1.0f},
   {0.492294f, 0.205452f, 0.172494f, 1.0f},
   {0.497455f, 0.207547f, 0.172144f, 1.0f},
   {0.502599f, 0.209667f, 0.171745f, 1.0f},
   {0.507726f, 0.211812f, 0.171296f, 1.0f},
   {0.512834f, 0.213985f, 0.170799f, 1.0f},
   {0.517922f, 0.216185f, 0.170253f, 1.0f},
   {0.52299f, 0.218414f, 0.169661f, 1.0f},
   {0.528038f, 0.220673f, 0.169022f, 1.0f},
   {0.533063f, 0.222963f, 0.168337f, 1.0f},
   {0.538065f, 0.225285f, 0.167609f, 1.0f},
   {0.543044f, 0.22764f, 0.166836f, 1.0f},
   {0.547999f, 0.230028f, 0.166021f, 1.0f},
   {0.552928f, 0.232451f, 0.165165f, 1.0f},
   {0.557832f, 0.234909f, 0.164268f, 1.0f},
   {0.562709f, 0.237403f, 0.163332f, 1.0f},
   {0.567558f, 0.239934f, 0.162358f, 1.0f},
   {0.57238f, 0.242502f, 0.161348f, 1.0f},
   {0.577173f, 0.245109f, 0.160301f, 1.0f},
   {0.581937f, 0.247753f, 0.15922f, 1.0f},
   {0.586672f, 0.250437f, 0.158107f, 1.0f},
   {0.591375f, 0.25316f, 0.156961f, 1.0f},
   {0.596048f, 0.255922f, 0.155785f, 1.0f},
   {0.60069f, 0.258725f, 0.154579f, 1.0f},
   {0.6053f, 0.261568f, 0.153346f, 1.0f},
   {0.609877f, 0.264451f, 0.152086f, 1.0f},
   {0.614422f, 0.267376f, 0.150801f, 1.0f},
   {0.618934f, 0.27034f, 0.149492f, 1.0f},
   {0.623413f, 0.273346f, 0.14816f, 1.0f},
   {0.627858f, 0.276393f, 0.146807f, 1.0f},
   {0.632269f, 0.27948f, 0.145434f, 1.0f},
   {0.636646f, 0.282608f, 0.144042f, 1.0f},
   {0.640989f, 0.285776f, 0.142633f, 1.0f},
   {0.645298f, 0.288985f, 0.141207f, 1.0f},
   {0.649572f, 0.292234f, 0.139767f, 1.0f},
   {0.653811f, 0.295523f, 0.138313f, 1.0f},
   {0.658016f, 0.298851f, 0.136847f, 1.0f},
   {0.662186f, 0.302219f, 0.13537f, 1.0f},
   {0.666321f, 0.305626f, 0.133883f, 1.0f},
   {0.670421f, 0.309071f, 0.132388f, 1.0f},
   {0.674487f, 0.312554f, 0.130885f, 1.0f},
   {0.678518f, 0.316075f, 0.129376f, 1.0f},
   {0.682515f, 0.319633f, 0.127863f, 1.0f},
   {0.686477f, 0.323228f, 0.126346f, 1.0f},
   {0.690405f, 0.326859f, 0.124827f, 1.0f},
   {0.694298f, 0.330526f, 0.123307f, 1.0f},
   {0.698158f, 0.334229f, 0.121787f, 1.0f},
   {0.701983f, 0.337966f, 0.120269f, 1.0f},
   {0.705775f, 0.341738f, 0.118753f, 1.0f},
   {0.709533f, 0.345543f, 0.117243f, 1.0f},
   {0.713258f, 0.349382f, 0.115738f, 1.0f},
   {0.71695f, 0.353253f, 0.11424f, 1.0f},
   {0.720608f, 0.357157f, 0.112751f, 1.0f},
   {0.724234f, 0.361093f, 0.111272f, 1.0f},
   {0.727828f, 0.365059f, 0.109804f, 1.0f},
   {0.731389f, 0.369057f, 0.10835f, 1.0f},
   {0.734918f, 0.373085f, 0.106912f, 1.0f},
   {0.738415f, 0.377142f, 0.105489f, 1.0f},
   {0.741881f, 0.381229f, 0.104085f, 1.0f},
   {0.745315f, 0.385344f, 0.102702f, 1.0f},
   {0.748718f, 0.389487f, 0.101341f, 1.0f},
   {0.752091f, 0.393659f, 0.100004f, 1.0f},
   {0.755433f, 0.397857f, 0.0986932f, 1.0f},
   {0.758744f, 0.402083f, 0.0974113f, 1.0f},
   {0.762026f, 0.406335f, 0.09616f, 1.0f},
   {0.765278f, 0.410612f, 0.0949418f, 1.0f},
   {0.7685f, 0.414916f, 0.0937593f, 1.0f},
   {0.771693f, 0.419244f, 0.0926146f, 1.0f},
   {0.774856f, 0.423597f, 0.0915105f, 1.0f},
   {0.777991f, 0.427975f, 0.0904495f, 1.0f},
   {0.781098f, 0.432376f, 0.0894347f, 1.0f},
   {0.784176f, 0.436801f, 0.0884686f, 1.0f},
   {0.787226f, 0.44125f, 0.087554f, 1.0f},
   {0.790249f, 0.445721f, 0.0866939f, 1.0f},
   {0.793243f, 0.450214f, 0.0858912f, 1.0f},
   {0.796211f, 0.45473f, 0.0851488f, 1.0f},
   {0.799151f, 0.459268f, 0.0844698f, 1.0f},
   {0.802064f, 0.463827f, 0.0838571f, 1.0f},
   {0.804951f, 0.468407f, 0.0833135f, 1.0f},
   {0.807811f, 0.473009f, 0.0828421f, 1.0f},
   {0.810645f, 0.477631f, 0.0824457f, 1.0f},
   {0.813453f, 0.482273f, 0.0821271f, 1.0f},
   {0.816236f, 0.486935f, 0.0818889f, 1.0f},
   {0.818992f, 0.491618f, 0.0817337f, 1.0f},
   {0.821724f, 0.49632f, 0.0816636f, 1.0f},
   {0.82443f, 0.501041f, 0.081681f, 1.0f},
   {0.827111f, 0.505782f, 0.0817882f, 1.0f},
   {0.829767f, 0.510541f, 0.0819867f, 1.0f},
   {0.832399f, 0.51532f, 0.0822781f, 1.0f},
   {0.835007f, 0.520116f, 0.082664f, 1.0f},
   {0.83759f, 0.524931f, 0.0831455f, 1.0f},
   {0.840149f, 0.529765f, 0.0837231f, 1.0f},
   {0.842685f, 0.534616f, 0.0843981f, 1.0f},
   {0.845197f, 0.539485f, 0.0851702f, 1.0f},
   {0.847685f, 0.544371f, 0.0860403f, 1.0f},
   {0.85015f, 0.549276f, 0.0870075f, 1.0f},
   {0.852592f, 0.554197f, 0.0880721f, 1.0f},
   {0.855011f, 0.559136f, 0.0892328f, 1.0f},
   {0.857408f, 0.564091f, 0.0904897f, 1.0f},
   {0.859782f, 0.569063f, 0.0918411f, 1.0f},
   {0.862133f, 0.574053f, 0.0932862f, 1.0f},
   {0.864462f, 0.579059f, 0.0948235f, 1.0f},
   {0.866769f, 0.584081f, 0.0964514f, 1.0f},
   {0.869054f, 0.58912f, 0.0981688f, 1.0f},
   {0.871317f, 0.594175f, 0.0999735f, 1.0f},
   {0.873559f, 0.599246f, 0.101864f, 1.0f},
   {0.875779f, 0.604333f, 0.103838f, 1.0f},
   {0.877978f, 0.609437f, 0.105894f, 1.0f},
   {0.880155f, 0.614556f, 0.10803f, 1.0f},
   {0.882312f, 0.619691f, 0.110244f, 1.0f},
   {0.884447f, 0.624842f, 0.112534f, 1.0f},
   {0.886562f, 0.630009f, 0.114897f, 1.0f},
   {0.888656f, 0.635191f, 0.117333f, 1.0f},
   {0.89073f, 0.640389f, 0.119839f, 1.0f},
   {0.892783f, 0.645603f, 0.122412f, 1.0f},
   {0.894816f, 0.650832f, 0.125052f, 1.0f},
   {0.896829f, 0.656076f, 0.127756f, 1.0f},
   {0.898822f, 0.661336f, 0.130523f, 1.0f},
   {0.900795f, 0.666611f, 0.13335f, 1.0f},
   {0.902748f, 0.671901f, 0.136236f, 1.0f},
   {0.904682f, 0.677207f, 0.13918f, 1.0f},
   {0.906596f, 0.682528f, 0.142179f, 1.0f},
   {0.90849f, 0.687864f, 0.145233f, 1.0f},
   {0.910366f, 0.693215f, 0.148339f, 1.0f},
   {0.912222f, 0.698581f, 0.151497f, 1.0f},
   {0.914059f, 0.703963f, 0.154705f, 1.0f},
   {0.915878f, 0.70936f, 0.157961f, 1.0f},
   {0.917677f, 0.714772f, 0.161265f, 1.0f},
   {0.919458f, 0.720199f, 0.164615f, 1.0f},
   {0.92122f, 0.725641f, 0.16801f, 1.0f},
   {0.922964f, 0.731099f, 0.171449f, 1.0f},
   {0.924689f, 0.736571f, 0.174931f, 1.0f},
   {0.926395f, 0.742059f, 0.178455f, 1.0f},
   {0.928084f, 0.747562f, 0.18202f, 1.0f},
   {0.929754f, 0.75308f, 0.185625f, 1.0f},
   {0.931407f, 0.758613f, 0.18927f, 1.0f},
   {0.933041f, 0.764162f, 0.192952f, 1.0f},
   {0.934657f, 0.769726f, 0.196672f, 1.0f},
   {0.936256f, 0.775305f, 0.200429f, 1.0f},
   {0.937837f, 0.780899f, 0.204223f, 1.0f},
   {0.9394f, 0.786509f, 0.208051f, 1.0f},
   {0.940945f, 0.792135f, 0.211915f, 1.0f},
   {0.942474f, 0.797775f, 0.215813f, 1.0f},
   {0.943984f, 0.803432f, 0.219744f, 1.0f},
   {0.945477f, 0.809104f, 0.223708f, 1.0f},
   {0.946953f, 0.814791f, 0.227705f, 1.0f},
   {0.948411f, 0.820494f, 0.231734f, 1.0f},
   {0.949853f, 0.826213f, 0.235794f, 1.0f},
   {0.951277f, 0.831948f, 0.239885f, 1.0f},
   {0.952684f, 0.837698f, 0.244007f, 1.0f},
   {0.954074f, 0.843465f, 0.248159f, 1.0f},
   {0.955446f, 0.849247f, 0.252341f, 1.0f},
   {0.956802f, 0.855046f, 0.256552f, 1.0f},
   {0.958141f, 0.860861f, 0.260792f, 1.0f},
   {0.959463f, 0.866692f, 0.265061f, 1.0f},
   {0.960767f, 0.872539f, 0.269358f, 1.0f},
});

const Palette BPAL_42 = Palette("viola",
{
   {0.111384f, 0.0266995f, 0.189946f, 1.0f},
   {0.116306f, 0.0284327f, 0.19596f, 1.0f},
   {0.121224f, 0.0301701f, 0.202004f, 1.0f},
   {0.12614f, 0.031905f, 0.208081f, 1.0f},
   {0.131052f, 0.0336362f, 0.21419f, 1.0f},
   {0.135964f, 0.0353576f, 0.220335f, 1.0f},
   {0.140873f, 0.0370664f, 0.226517f, 1.0f},
   {0.145779f, 0.038759f, 0.232738f, 1.0f},
   {0.150684f, 0.0404308f, 0.239f, 1.0f},
   {0.155588f, 0.0420315f, 0.245305f, 1.0f},
   {0.16049f, 0.0435692f, 0.251654f, 1.0f},
   {0.165389f, 0.0450443f, 0.258051f, 1.0f},
   {0.170286f, 0.0464568f, 0.264497f, 1.0f},
   {0.17518f, 0.0478068f, 0.270993f, 1.0f},
   {0.180071f, 0.0490944f, 0.277544f, 1.0f},
   {0.184958f, 0.0503191f, 0.28415f, 1.0f},
   {0.18984f, 0.0514805f, 0.290816f, 1.0f},
   {0.194716f, 0.0525801f, 0.297542f, 1.0f},
   {0.199586f, 0.0536168f, 0.304333f, 1.0f},
   {0.204448f, 0.0545915f, 0.311189f, 1.0f},
   {0.209299f, 0.0555038f, 0.318116f, 1.0f},
   {0.214139f, 0.0563556f, 0.325114f, 1.0f},
   {0.218964f, 0.0571477f, 0.332187f, 1.0f},
   {0.223773f, 0.0578815f, 0.339338f, 1.0f},
   {0.228561f, 0.0585596f, 0.34657f, 1.0f},
   {0.233325f, 0.059186f, 0.353885f, 1.0f},
   {0.23806f, 0.0597662f, 0.361286f, 1.0f},
   {0.242762f, 0.0603048f, 0.368775f, 1.0f},
   {0.247422f, 0.0608129f, 0.376353f, 1.0f},
   {0.252033f, 0.0613019f, 0.38402f, 1.0f},
   {0.256587f, 0.0617875f, 0.391775f, 1.0f},
   {0.261071f, 0.0622911f, 0.399613f, 1.0f},
   {0.265474f, 0.0628378f, 0.407531f, 1.0f},
   {0.269778f, 0.0634632f, 0.415516f, 1.0f},
   {0.273968f, 0.0642087f, 0.423554f, 1.0f},
   {0.278022f, 0.0651251f, 0.431622f, 1.0f},
   {0.281921f, 0.0662712f, 0.439691f, 1.0f},
   {0.285641f, 0.0677108f, 0.447724f, 1.0f},
   {0.289162f, 0.0695079f, 0.455676f, 1.0f},
   {0.292466f, 0.0717199f, 0.463497f, 1.0f},
   {0.29554f, 0.0743884f, 0.471138f, 1.0f},
   {0.298381f, 0.0775337f, 0.478552f, 1.0f},
   {0.300988f, 0.0811503f, 0.485701f, 1.0f},
   {0.303372f, 0.0852098f, 0.492561f, 1.0f},
   {0.305546f, 0.0896664f, 0.499119f, 1.0f},
   {0.307525f, 0.0944642f, 0.505374f, 1.0f},
   {0.309329f, 0.0995443f, 0.511332f, 1.0f},
   {0.310975f, 0.10485f, 0.517008f, 1.0f},
   {0.312479f, 0.11033f, 0.522417f, 1.0f},
   {0.313857f, 0.115941f, 0.52758f, 1.0f},
   {0.315122f, 0.121645f, 0.532514f, 1.0f},
   {0.316286f, 0.127412f, 0.53724f, 1.0f},
   {0.317359f, 0.133218f, 0.541773f, 1.0f},
   {0.31835f, 0.139044f, 0.546131f, 1.0f},
   {0.319268f, 0.144874f, 0.550328f, 1.0f},
   {0.320119f, 0.150696f, 0.554379f, 1.0f},
   {0.320909f, 0.156502f, 0.558295f, 1.0f},
   {0.321643f, 0.162285f, 0.562089f, 1.0f},
   {0.322327f, 0.168039f, 0.56577f, 1.0f},
   {0.322964f, 0.173761f, 0.569347f, 1.0f},
   {0.323559f, 0.179447f, 0.57283f, 1.0f},
   {0.324113f, 0.185097f, 0.576225f, 1.0f},
   {0.324631f, 0.19071f, 0.579539f, 1.0f},
   {0.325115f, 0.196283f, 0.582779f, 1.0f},
   {0.325567f, 0.201817f, 0.58595f, 1.0f},
   {0.32599f, 0.207313f, 0.589058f, 1.0f},
   {0.326385f, 0.21277f, 0.592107f, 1.0f},
   {0.326755f, 0.21819f, 0.595102f, 1.0f},
   {0.327101f, 0.223572f, 0.598047f, 1.0f},
   {0.327424f, 0.228918f, 0.600944f, 1.0f},
   {0.327725f, 0.234228f, 0.603798f, 1.0f},
   {0.328008f, 0.239504f, 0.606613f, 1.0f},
   {0.328271f, 0.244745f, 0.609389f, 1.0f},
   {0.328517f, 0.249954f, 0.612131f, 1.0f},
   {0.328746f, 0.255132f, 0.61484f, 1.0f},
   {0.328959f, 0.260279f, 0.61752f, 1.0f},
   {0.329158f, 0.265396f, 0.620171f, 1.0f},
   {0.329342f, 0.270484f, 0.622796f, 1.0f},
   {0.329514f, 0.275545f, 0.625397f, 1.0f},
   {0.329672f, 0.280578f, 0.627976f, 1.0f},
   {0.329819f, 0.285586f, 0.630533f, 1.0f},
   {0.329955f, 0.29057f, 0.633071f, 1.0f},
   {0.33008f, 0.295529f, 0.635591f, 1.0f},
   {0.330195f, 0.300465f, 0.638093f, 1.0f},
   {0.3303f, 0.305379f, 0.64058f, 1.0f},
   {0.330396f, 0.310272f, 0.643052f, 1.0f},
   {0.330483f, 0.315144f, 0.64551f, 1.0f},
   {0.330562f, 0.319997f, 0.647956f, 1.0f},
   {0.330633f, 0.324831f, 0.65039f, 1.0f},
   {0.330696f, 0.329646f, 0.652812f, 1.0f},
   {0.330752f, 0.334444f, 0.655225f, 1.0f},
   {0.330802f, 0.339226f, 0.657627f, 1.0f},
   {0.330844f, 0.343991f, 0.660021f, 1.0f},
   {0.33088f, 0.348742f, 0.662406f, 1.0f},
   {0.33091f, 0.353477f, 0.664784f, 1.0f},
   {0.330935f, 0.358199f, 0.667154f, 1.0f},
   {0.330953f, 0.362907f, 0.669517f, 1.0f},
   {0.330967f, 0.367602f, 0.671873f, 1.0f},
   {0.330975f, 0.372286f, 0.674224f, 1.0f},
   {0.330978f, 0.376957f, 0.676568f, 1.0f},
   {0.330977f, 0.381618f, 0.678908f, 1.0f},
   {0.330971f, 0.386268f, 0.681242f, 1.0f},
   {0.330961f, 0.390909f, 0.68357f, 1.0f},
   {0.330947f, 0.395539f, 0.685895f, 1.0f},
   {0.33093f, 0.400161f, 0.688214f, 1.0f},
   {0.330908f, 0.404775f, 0.690529f, 1.0f},
   {0.330883f, 0.40938f, 0.69284f, 1.0f},
   {0.330855f, 0.413978f, 0.695146f, 1.0f},
   {0.330824f, 0.418568f, 0.697447f, 1.0f},
   {0.330791f, 0.423152f, 0.699745f, 1.0f},
   {0.330755f, 0.42773f, 0.702038f, 1.0f},
   {0.330716f, 0.432302f, 0.704326f, 1.0f},
   {0.330676f, 0.436868f, 0.706611f, 1.0f},
   {0.330635f, 0.441429f, 0.70889f, 1.0f},
   {0.330592f, 0.445985f, 0.711165f, 1.0f},
   {0.330549f, 0.450537f, 0.713434f, 1.0f},
   {0.330505f, 0.455085f, 0.715699f, 1.0f},
   {0.330461f, 0.459629f, 0.717958f, 1.0f},
   {0.330418f, 0.46417f, 0.720211f, 1.0f},
   {0.330376f, 0.468707f, 0.722458f, 1.0f},
   {0.330335f, 0.473242f, 0.724699f, 1.0f},
   {0.330297f, 0.477773f, 0.726934f, 1.0f},
   {0.330261f, 0.482303f, 0.729161f, 1.0f},
   {0.330229f, 0.48683f, 0.731381f, 1.0f},
   {0.330202f, 0.491355f, 0.733593f, 1.0f},
   {0.33018f, 0.495879f, 0.735796f, 1.0f},
   {0.330165f, 0.500401f, 0.73799f, 1.0f},
   {0.330156f, 0.504922f, 0.740175f, 1.0f},
   {0.330157f, 0.509441f, 0.74235f, 1.0f},
   {0.330166f, 0.513959f, 0.744514f, 1.0f},
   {0.330188f, 0.518477f, 0.746667f, 1.0f},
   {0.330221f, 0.522993f, 0.748807f, 1.0f},
   {0.330269f, 0.527509f, 0.750935f, 1.0f},
   {0.330332f, 0.532024f, 0.753049f, 1.0f},
   {0.330414f, 0.536538f, 0.755149f, 1.0f},
   {0.330515f, 0.541051f, 0.757233f, 1.0f},
   {0.330638f, 0.545564f, 0.759301f, 1.0f},
   {0.330785f, 0.550076f, 0.761352f, 1.0f},
   {0.33096f, 0.554588f, 0.763385f, 1.0f},
   {0.331164f, 0.559098f, 0.765399f, 1.0f},
   {0.3314f, 0.563607f, 0.767393f, 1.0f},
   {0.331673f, 0.568115f, 0.769365f, 1.0f},
   {0.331985f, 0.572622f, 0.771315f, 1.0f},
   {0.33234f, 0.577127f, 0.773241f, 1.0f},
   {0.332742f, 0.58163f, 0.775142f, 1.0f},
   {0.333196f, 0.586132f, 0.777017f, 1.0f},
   {0.333706f, 0.59063f, 0.778864f, 1.0f},
   {0.334277f, 0.595125f, 0.780683f, 1.0f},
   {0.334914f, 0.599617f, 0.78247f, 1.0f},
   {0.335624f, 0.604105f, 0.784226f, 1.0f},
   {0.336412f, 0.608589f, 0.785948f, 1.0f},
   {0.337285f, 0.613067f, 0.787635f, 1.0f},
   {0.338249f, 0.617539f, 0.789285f, 1.0f},
   {0.339312f, 0.622005f, 0.790896f, 1.0f},
   {0.340483f, 0.626463f, 0.792468f, 1.0f},
   {0.341768f, 0.630912f, 0.793998f, 1.0f},
   {0.343177f, 0.635352f, 0.795485f, 1.0f},
   {0.344719f, 0.639781f, 0.796927f, 1.0f},
   {0.346402f, 0.644198f, 0.798322f, 1.0f},
   {0.348238f, 0.648602f, 0.799669f, 1.0f},
   {0.350236f, 0.652991f, 0.800966f, 1.0f},
   {0.352407f, 0.657363f, 0.802213f, 1.0f},
   {0.354761f, 0.661717f, 0.803407f, 1.0f},
   {0.357309f, 0.666052f, 0.804549f, 1.0f},
   {0.360062f, 0.670364f, 0.805638f, 1.0f},
   {0.363031f, 0.674653f, 0.806672f, 1.0f},
   {0.366225f, 0.678916f, 0.807653f, 1.0f},
   {0.369654f, 0.683151f, 0.808581f, 1.0f},
   {0.373329f, 0.687356f, 0.809456f, 1.0f},
   {0.377256f, 0.691529f, 0.810281f, 1.0f},
   {0.381442f, 0.695667f, 0.811057f, 1.0f},
   {0.385892f, 0.699768f, 0.811788f, 1.0f},
   {0.390611f, 0.703831f, 0.812478f, 1.0f},
   {0.395599f, 0.707854f, 0.81313f, 1.0f},
   {0.400855f, 0.711835f, 0.81375f, 1.0f},
   {0.406376f, 0.715773f, 0.814345f, 1.0f},
   {0.412156f, 0.719668f, 0.814919f, 1.0f},
   {0.418188f, 0.723517f, 0.815481f, 1.0f},
   {0.42446f, 0.727322f, 0.816038f, 1.0f},
   {0.430961f, 0.731083f, 0.816596f, 1.0f},
   {0.437675f, 0.7348f, 0.817164f, 1.0f},
   {0.444588f, 0.738475f, 0.817749f, 1.0f},
   {0.451682f, 0.742108f, 0.818358f, 1.0f},
   {0.458941f, 0.745703f, 0.818998f, 1.0f},
   {0.466347f, 0.74926f, 0.819674f, 1.0f},
   {0.473882f, 0.752782f, 0.820393f, 1.0f},
   {0.48153f, 0.756272f, 0.821159f, 1.0f},
   {0.489276f, 0.759731f, 0.821977f, 1.0f},
   {0.497103f, 0.763163f, 0.822849f, 1.0f},
   {0.504998f, 0.76657f, 0.823779f, 1.0f},
   {0.512948f, 0.769954f, 0.82477f, 1.0f},
   {0.520942f, 0.773318f, 0.825822f, 1.0f},
   {0.52897f, 0.776664f, 0.826937f, 1.0f},
   {0.537021f, 0.779995f, 0.828116f, 1.0f},
   {0.545087f, 0.783313f, 0.829359f, 1.0f},
   {0.553163f, 0.786619f, 0.830667f, 1.0f},
   {0.56124f, 0.789916f, 0.832039f, 1.0f},
   {0.569314f, 0.793206f, 0.833476f, 1.0f},
   {0.577381f, 0.796489f, 0.834976f, 1.0f},
   {0.585435f, 0.799768f, 0.836539f, 1.0f},
   {0.593475f, 0.803044f, 0.838164f, 1.0f},
   {0.601496f, 0.806319f, 0.83985f, 1.0f},
   {0.609498f, 0.809594f, 0.841596f, 1.0f},
   {0.617476f, 0.812869f, 0.843403f, 1.0f},
   {0.625431f, 0.816147f, 0.845267f, 1.0f},
   {0.633361f, 0.819427f, 0.847189f, 1.0f},
   {0.641265f, 0.822712f, 0.849167f, 1.0f},
   {0.649142f, 0.826002f, 0.851201f, 1.0f},
   {0.656992f, 0.829297f, 0.853289f, 1.0f},
   {0.664814f, 0.832599f, 0.85543f, 1.0f},
   {0.672609f, 0.835909f, 0.857624f, 1.0f},
   {0.680375f, 0.839226f, 0.859869f, 1.0f},
   {0.688114f, 0.842553f, 0.862165f, 1.0f},
   {0.695825f, 0.845888f, 0.86451f, 1.0f},
   {0.703508f, 0.849234f, 0.866905f, 1.0f},
   {0.711165f, 0.85259f, 0.869347f, 1.0f},
   {0.718794f, 0.855957f, 0.871836f, 1.0f},
   {0.726397f, 0.859335f, 0.874372f, 1.0f},
   {0.733974f, 0.862725f, 0.876954f, 1.0f},
   {0.741526f, 0.866128f, 0.87958f, 1.0f},
   {0.749052f, 0.869544f, 0.882251f, 1.0f},
   {0.756554f, 0.872973f, 0.884965f, 1.0f},
   {0.764032f, 0.876416f, 0.887722f, 1.0f},
   {0.771485f, 0.879873f, 0.890521f, 1.0f},
   {0.778917f, 0.883344f, 0.893362f, 1.0f},
   {0.786325f, 0.88683f, 0.896245f, 1.0f},
   {0.793711f, 0.890331f, 0.899168f, 1.0f},
   {0.801076f, 0.893848f, 0.902131f, 1.0f},
   {0.80842f, 0.897381f, 0.905134f, 1.0f},
   {0.815744f, 0.900929f, 0.908176f, 1.0f},
   {0.823047f, 0.904495f, 0.911257f, 1.0f},
   {0.83033f, 0.908077f, 0.914376f, 1.0f},
   {0.837595f, 0.911677f, 0.917533f, 1.0f},
   {0.844841f, 0.915294f, 0.920728f, 1.0f},
   {0.852069f, 0.918928f, 0.92396f, 1.0f},
   {0.859278f, 0.922581f, 0.927229f, 1.0f},
   {0.866471f, 0.926253f, 0.930535f, 1.0f},
   {0.873646f, 0.929943f, 0.933877f, 1.0f},
   {0.880804f, 0.933652f, 0.937254f, 1.0f},
   {0.887946f, 0.93738f, 0.940668f, 1.0f},
   {0.895072f, 0.941129f, 0.944117f, 1.0f},
   {0.902181f, 0.944897f, 0.947601f, 1.0f},
   {0.909275f, 0.948686f, 0.951121f, 1.0f},
   {0.916352f, 0.952495f, 0.954675f, 1.0f},
   {0.923415f, 0.956326f, 0.958264f, 1.0f},
   {0.930461f, 0.960179f, 0.961888f, 1.0f},
   {0.937492f, 0.964053f, 0.965546f, 1.0f},
   {0.944507f, 0.967949f, 0.969238f, 1.0f},
   {0.951506f, 0.971869f, 0.972965f, 1.0f},
   {0.958488f, 0.975812f, 0.976725f, 1.0f},
   {0.965454f, 0.979779f, 0.98052f, 1.0f},
   {0.972402f, 0.983771f, 0.984348f, 1.0f},
   {0.979332f, 0.987788f, 0.988211f, 1.0f},
   {0.986243f, 0.991831f, 0.992107f, 1.0f},
   {0.993133f, 0.995902f, 0.996036f, 1.0f},
   {1.0f, 1.0f, 1.0f, 1.0f},
   {0.996513f, 0.994573f, 0.996053f, 1.0f},
   {0.992953f, 0.989197f, 0.99212f, 1.0f},
   {0.989324f, 0.983869f, 0.988222f, 1.0f},
   {0.985637f, 0.978583f, 0.984382f, 1.0f},
   {0.981908f, 0.973329f, 0.980619f, 1.0f},
   {0.97816f, 0.968099f, 0.976942f, 1.0f},
   {0.974415f, 0.962881f, 0.973356f, 1.0f},
   {0.970693f, 0.957668f, 0.969856f, 1.0f},
   {0.967008f, 0.952456f, 0.966435f, 1.0f},
   {0.963372f, 0.947241f, 0.963085f, 1.0f},
   {0.95979f, 0.94202f, 0.959796f, 1.0f},
   {0.956263f, 0.936793f, 0.95656f, 1.0f},
   {0.952794f, 0.931561f, 0.953372f, 1.0f},
   {0.949381f, 0.926324f, 0.950226f, 1.0f},
   {0.946024f, 0.921082f, 0.947119f, 1.0f},
   {0.942719f, 0.915836f, 0.944046f, 1.0f},
   {0.939465f, 0.910587f, 0.941005f, 1.0f},
   {0.936261f, 0.905335f, 0.937995f, 1.0f},
   {0.933104f, 0.900082f, 0.935013f, 1.0f},
   {0.929993f, 0.894827f, 0.93206f, 1.0f},
   {0.926926f, 0.889572f, 0.929132f, 1.0f},
   {0.923902f, 0.884315f, 0.926231f, 1.0f},
   {0.920919f, 0.879058f, 0.923354f, 1.0f},
   {0.917978f, 0.873801f, 0.920502f, 1.0f},
   {0.915074f, 0.868544f, 0.917674f, 1.0f},
   {0.91221f, 0.863287f, 0.914869f, 1.0f},
   {0.909381f, 0.85803f, 0.912087f, 1.0f},
   {0.906591f, 0.852774f, 0.909328f, 1.0f},
   {0.903835f, 0.847517f, 0.90659f, 1.0f},
   {0.901115f, 0.842261f, 0.903875f, 1.0f},
   {0.898428f, 0.837005f, 0.901182f, 1.0f},
   {0.895776f, 0.831749f, 0.898509f, 1.0f},
   {0.893157f, 0.826493f, 0.895858f, 1.0f},
   {0.89057f, 0.821237f, 0.893227f, 1.0f},
   {0.888017f, 0.815981f, 0.890617f, 1.0f},
   {0.885495f, 0.810724f, 0.888027f, 1.0f},
   {0.883003f, 0.805467f, 0.885457f, 1.0f},
   {0.880544f, 0.800209f, 0.882907f, 1.0f},
   {0.878115f, 0.794951f, 0.880376f, 1.0f},
   {0.875716f, 0.789691f, 0.877864f, 1.0f},
   {0.873347f, 0.78443f, 0.875371f, 1.0f},
   {0.871008f, 0.779167f, 0.872897f, 1.0f},
   {0.868698f, 0.773903f, 0.870441f, 1.0f},
   {0.866418f, 0.768636f, 0.868003f, 1.0f},
   {0.864166f, 0.763367f, 0.865583f, 1.0f},
   {0.861943f, 0.758096f, 0.863181f, 1.0f},
   {0.859748f, 0.752823f, 0.860795f, 1.0f},
   {0.857581f, 0.747546f, 0.858427f, 1.0f},
   {0.855443f, 0.742265f, 0.856075f, 1.0f},
   {0.853331f, 0.736981f, 0.85374f, 1.0f},
   {0.851247f, 0.731693f, 0.85142f, 1.0f},
   {0.84919f, 0.726401f, 0.849116f, 1.0f},
   {0.847161f, 0.721104f, 0.846828f, 1.0f},
   {0.845158f, 0.715802f, 0.844555f, 1.0f},
   {0.843182f, 0.710495f, 0.842297f, 1.0f},
   {0.841232f, 0.705183f, 0.840053f, 1.0f},
   {0.839309f, 0.699864f, 0.837823f, 1.0f},
   {0.837411f, 0.694539f, 0.835607f, 1.0f},
   {0.835539f, 0.689207f, 0.833404f, 1.0f},
   {0.833693f, 0.683868f, 0.831214f, 1.0f},
   {0.831873f, 0.678521f, 0.829036f, 1.0f},
   {0.830078f, 0.673167f, 0.826871f, 1.0f},
   {0.828308f, 0.667804f, 0.824717f, 1.0f},
   {0.826563f, 0.662432f, 0.822574f, 1.0f},
   {0.824842f, 0.65705f, 0.820443f, 1.0f},
   {0.823147f, 0.65166f, 0.818321f, 1.0f},
   {0.821475f, 0.646259f, 0.816209f, 1.0f},
   {0.819828f, 0.640847f, 0.814106f, 1.0f},
   {0.818206f, 0.635423f, 0.812012f, 1.0f},
   {0.816608f, 0.629988f, 0.809926f, 1.0f},
   {0.815033f, 0.624541f, 0.807848f, 1.0f},
   {0.813481f, 0.619082f, 0.805776f, 1.0f},
   {0.811953f, 0.613608f, 0.803711f, 1.0f},
   {0.810449f, 0.608121f, 0.801652f, 1.0f},
   {0.808967f, 0.602619f, 0.799597f, 1.0f},
   {0.807508f, 0.597103f, 0.797546f, 1.0f},
   {0.806072f, 0.59157f, 0.795499f, 1.0f},
   {0.804659f, 0.586022f, 0.793454f, 1.0f},
   {0.803267f, 0.580456f, 0.791411f, 1.0f},
   {0.801898f, 0.574873f, 0.789369f, 1.0f},
   {0.800551f, 0.569272f, 0.787327f, 1.0f},
   {0.799225f, 0.563651f, 0.785284f, 1.0f},
   {0.797921f, 0.558011f, 0.783238f, 1.0f},
   {0.796637f, 0.552351f, 0.781189f, 1.0f},
   {0.795375f, 0.546669f, 0.779136f, 1.0f},
   {0.794133f, 0.540966f, 0.777078f, 1.0f},
   {0.792912f, 0.535241f, 0.775012f, 1.0f},
   {0.791711f, 0.529491f, 0.772939f, 1.0f},
   {0.790529f, 0.523718f, 0.770855f, 1.0f},
   {0.789367f, 0.51792f, 0.768761f, 1.0f},
   {0.788224f, 0.512096f, 0.766654f, 1.0f},
   {0.787099f, 0.506246f, 0.764533f, 1.0f},
   {0.785993f, 0.500368f, 0.762395f, 1.0f},
   {0.784905f, 0.494462f, 0.76024f, 1.0f},
   {0.783834f, 0.488527f, 0.758064f, 1.0f},
   {0.78278f, 0.482562f, 0.755867f, 1.0f},
   {0.781742f, 0.476567f, 0.753645f, 1.0f},
   {0.780721f, 0.470539f, 0.751397f, 1.0f},
   {0.779714f, 0.46448f, 0.749119f, 1.0f},
   {0.778721f, 0.458388f, 0.74681f, 1.0f},
   {0.777742f, 0.452261f, 0.744466f, 1.0f},
   {0.776777f, 0.4461f, 0.742084f, 1.0f},
   {0.775823f, 0.439904f, 0.739662f, 1.0f},
   {0.77488f, 0.433672f, 0.737195f, 1.0f},
   {0.773947f, 0.427403f, 0.734681f, 1.0f},
   {0.773023f, 0.421098f, 0.732116f, 1.0f},
   {0.772107f, 0.414755f, 0.729495f, 1.0f},
   {0.771196f, 0.408375f, 0.726814f, 1.0f},
   {0.77029f, 0.401957f, 0.72407f, 1.0f},
   {0.769387f, 0.395502f, 0.721257f, 1.0f},
   {0.768485f, 0.38901f, 0.71837f, 1.0f},
   {0.767582f, 0.382481f, 0.715405f, 1.0f},
   {0.766676f, 0.375916f, 0.712355f, 1.0f},
   {0.765763f, 0.369316f, 0.709216f, 1.0f},
   {0.764843f, 0.362683f, 0.705982f, 1.0f},
   {0.76391f, 0.356018f, 0.702647f, 1.0f},
   {0.762963f, 0.349324f, 0.699205f, 1.0f},
   {0.761998f, 0.342604f, 0.695649f, 1.0f},
   {0.761011f, 0.33586f, 0.691974f, 1.0f},
   {0.759998f, 0.329097f, 0.688174f, 1.0f},
   {0.758955f, 0.322318f, 0.684242f, 1.0f},
   {0.757876f, 0.31553f, 0.680173f, 1.0f},
   {0.756758f, 0.308738f, 0.675962f, 1.0f},
   {0.755595f, 0.301947f, 0.671604f, 1.0f},
   {0.754383f, 0.295165f, 0.667095f, 1.0f},
   {0.753115f, 0.2884f, 0.66243f, 1.0f},
   {0.751786f, 0.281658f, 0.657608f, 1.0f},
   {0.750392f, 0.274949f, 0.652627f, 1.0f},
   {0.748928f, 0.26828f, 0.647486f, 1.0f},
   {0.747387f, 0.261661f, 0.642186f, 1.0f},
   {0.745767f, 0.255099f, 0.636729f, 1.0f},
   {0.744062f, 0.248604f, 0.631117f, 1.0f},
   {0.74227f, 0.242182f, 0.625354f, 1.0f},
   {0.740387f, 0.235842f, 0.619445f, 1.0f},
   {0.738412f, 0.229591f, 0.613397f, 1.0f},
   {0.736341f, 0.223434f, 0.607216f, 1.0f},
   {0.734175f, 0.217376f, 0.60091f, 1.0f},
   {0.731913f, 0.211423f, 0.594487f, 1.0f},
   {0.729555f, 0.205578f, 0.587954f, 1.0f},
   {0.727102f, 0.199844f, 0.581321f, 1.0f},
   {0.724554f, 0.194222f, 0.574596f, 1.0f},
   {0.721914f, 0.188714f, 0.567788f, 1.0f},
   {0.719182f, 0.183321f, 0.560904f, 1.0f},
   {0.716362f, 0.178043f, 0.553954f, 1.0f},
   {0.713455f, 0.172878f, 0.546945f, 1.0f},
   {0.710465f, 0.167827f, 0.539885f, 1.0f},
   {0.707393f, 0.162888f, 0.53278f, 1.0f},
   {0.704242f, 0.158059f, 0.525637f, 1.0f},
   {0.701015f, 0.153339f, 0.518463f, 1.0f},
   {0.697715f, 0.148725f, 0.511264f, 1.0f},
   {0.694345f, 0.144216f, 0.504044f, 1.0f},
   {0.690906f, 0.139809f, 0.49681f, 1.0f},
   {0.687402f, 0.135503f, 0.489565f, 1.0f},
   {0.683834f, 0.131295f, 0.482314f, 1.0f},
   {0.680205f, 0.127184f, 0.475062f, 1.0f},
   {0.676518f, 0.123167f, 0.467812f, 1.0f},
   {0.672774f, 0.119243f, 0.460568f, 1.0f},
   {0.668975f, 0.115409f, 0.453333f, 1.0f},
   {0.665124f, 0.111665f, 0.446109f, 1.0f},
   {0.661221f, 0.108009f, 0.438901f, 1.0f},
   {0.657269f, 0.10444f, 0.431709f, 1.0f},
   {0.653269f, 0.100957f, 0.424538f, 1.0f},
   {0.649222f, 0.0975588f, 0.41739f, 1.0f},
   {0.64513f, 0.0942451f, 0.410265f, 1.0f},
   {0.640994f, 0.0910154f, 0.403168f, 1.0f},
   {0.636815f, 0.0878697f, 0.396098f, 1.0f},
   {0.632594f, 0.084808f, 0.38906f, 1.0f},
   {0.628332f, 0.0818307f, 0.382054f, 1.0f},
   {0.624029f, 0.0789384f, 0.375081f, 1.0f},
   {0.619687f, 0.0761319f, 0.368145f, 1.0f},
   {0.615307f, 0.0734123f, 0.361246f, 1.0f},
   {0.610887f, 0.0707809f, 0.354387f, 1.0f},
   {0.606431f, 0.0682393f, 0.347568f, 1.0f},
   {0.601936f, 0.0657895f, 0.340791f, 1.0f},
   {0.597405f, 0.0634334f, 0.334059f, 1.0f},
   {0.592837f, 0.0611733f, 0.327372f, 1.0f},
   {0.588232f, 0.0590117f, 0.320733f, 1.0f},
   {0.583591f, 0.0569514f, 0.314143f, 1.0f},
   {0.578913f, 0.054995f, 0.307604f, 1.0f},
   {0.5742f, 0.0531455f, 0.301118f, 1.0f},
   {0.569449f, 0.0514059f, 0.294686f, 1.0f},
   {0.564662f, 0.0497789f, 0.288311f, 1.0f},
   {0.559839f, 0.0482675f, 0.281994f, 1.0f},
   {0.554978f, 0.0468742f, 0.275738f, 1.0f},
   {0.55008f, 0.0456016f, 0.269546f, 1.0f},
   {0.545145f, 0.0444516f, 0.263419f, 1.0f},
   {0.540172f, 0.043426f, 0.25736f, 1.0f},
   {0.535161f, 0.0425257f, 0.251372f, 1.0f},
   {0.530112f, 0.0417513f, 0.245457f, 1.0f},
   {0.525023f, 0.0411026f, 0.239619f, 1.0f},
   {0.519896f, 0.0405785f, 0.23386f, 1.0f},
   {0.514728f, 0.0401731f, 0.228185f, 1.0f},
   {0.509521f, 0.0398886f, 0.222596f, 1.0f},
   {0.504274f, 0.0397224f, 0.217097f, 1.0f},
   {0.498986f, 0.0396687f, 0.211692f, 1.0f},
   {0.493657f, 0.0397217f, 0.206385f, 1.0f},
   {0.488288f, 0.039875f, 0.201179f, 1.0f},
   {0.482879f, 0.0401218f, 0.196078f, 1.0f},
   {0.47743f, 0.0404548f, 0.191088f, 1.0f},
   {0.471941f, 0.040858f, 0.18621f, 1.0f},
   {0.466413f, 0.0413265f, 0.18145f, 1.0f},
   {0.460847f, 0.0418505f, 0.176811f, 1.0f},
   {0.455244f, 0.0424193f, 0.172295f, 1.0f},
   {0.449607f, 0.0430223f, 0.167906f, 1.0f},
   {0.443935f, 0.0436486f, 0.163646f, 1.0f},
   {0.438232f, 0.0442876f, 0.159516f, 1.0f},
   {0.4325f, 0.0449288f, 0.155518f, 1.0f},
   {0.426741f, 0.0455621f, 0.151652f, 1.0f},
   {0.420958f, 0.0461778f, 0.147917f, 1.0f},
   {0.415153f, 0.0467671f, 0.144313f, 1.0f},
   {0.409329f, 0.0473218f, 0.140836f, 1.0f},
   {0.403489f, 0.0478344f, 0.137485f, 1.0f},
   {0.397635f, 0.0482986f, 0.134256f, 1.0f},
   {0.391771f, 0.0487086f, 0.131144f, 1.0f},
   {0.385899f, 0.0490598f, 0.128146f, 1.0f},
   {0.380022f, 0.049348f, 0.125256f, 1.0f},
   {0.374142f, 0.0495704f, 0.122469f, 1.0f},
   {0.36826f, 0.0497247f, 0.119779f, 1.0f},
   {0.362379f, 0.049809f, 0.117181f, 1.0f},
   {0.3565f, 0.0498221f, 0.114668f, 1.0f},
   {0.350626f, 0.0497638f, 0.112235f, 1.0f},
   {0.344757f, 0.0496336f, 0.109877f, 1.0f},
   {0.338894f, 0.0494318f, 0.107588f, 1.0f},
   {0.333039f, 0.0491588f, 0.105361f, 1.0f},
   {0.327191f, 0.0488154f, 0.103193f, 1.0f},
   {0.321353f, 0.0484026f, 0.101078f, 1.0f},
   {0.315523f, 0.0479213f, 0.0990101f, 1.0f},
   {0.309704f, 0.0473722f, 0.0969858f, 1.0f},
   {0.303894f, 0.0467573f, 0.0950006f, 1.0f},
   {0.298094f, 0.046077f, 0.0930498f, 1.0f},
   {0.292304f, 0.0453329f, 0.0911297f, 1.0f},
   {0.286524f, 0.0445263f, 0.0892364f, 1.0f},
   {0.280754f, 0.0436583f, 0.0873662f, 1.0f},
   {0.274993f, 0.0427298f, 0.0855157f, 1.0f},
   {0.269242f, 0.0417418f, 0.0836816f, 1.0f},
   {0.2635f, 0.0406954f, 0.0818606f, 1.0f},
   {0.257767f, 0.0395824f, 0.0800499f, 1.0f},
   {0.252042f, 0.0384269f, 0.0782466f, 1.0f},
   {0.246325f, 0.0372374f, 0.0764482f, 1.0f},
   {0.240616f, 0.0360173f, 0.0746518f, 1.0f},
   {0.234913f, 0.0347695f, 0.0728549f, 1.0f},
   {0.229216f, 0.0334984f, 0.0710553f, 1.0f},
   {0.223525f, 0.0322065f, 0.0692504f, 1.0f},
   {0.217838f, 0.030898f, 0.0674383f, 1.0f},
   {0.212156f, 0.0295752f, 0.0656162f, 1.0f},
   {0.206477f, 0.0282423f, 0.0637826f, 1.0f},
   {0.2008f, 0.0269023f, 0.0619351f, 1.0f},
   {0.195126f, 0.0255579f, 0.0600714f, 1.0f},
   {0.189451f, 0.0242126f, 0.0581897f, 1.0f},
   {0.183777f, 0.0228696f, 0.056288f, 1.0f},
   {0.1781f, 0.0215317f, 0.0543642f, 1.0f},
   {0.172422f, 0.0202021f, 0.0524161f, 1.0f},
   {0.166739f, 0.0188837f, 0.0504418f, 1.0f},
   {0.161051f, 0.0175793f, 0.048439f, 1.0f},
   {0.155356f, 0.016292f, 0.0464056f, 1.0f},
});

const Palette BPAL_43 = Palette("pride",
{
   {0.0875279f, 0.0544501f, 0.156334f, 1.0f},
   {0.092047f, 0.0563932f, 0.162039f, 1.0f},
   {0.0965089f, 0.0582961f, 0.167869f, 1.0f},
   {0.100909f, 0.0601633f, 0.173825f, 1.0f},
   {0.10524f, 0.062f, 0.179908f, 1.0f},
   {0.109498f, 0.063812f, 0.186117f, 1.0f},
   {0.113674f, 0.0656057f, 0.192451f, 1.0f},
   {0.117762f, 0.0673882f, 0.198907f, 1.0f},
   {0.121754f, 0.0691672f, 0.205478f, 1.0f},
   {0.125644f, 0.0709512f, 0.212159f, 1.0f},
   {0.129423f, 0.0727489f, 0.218942f, 1.0f},
   {0.133084f, 0.0745692f, 0.225815f, 1.0f},
   {0.136622f, 0.0764216f, 0.232769f, 1.0f},
   {0.14003f, 0.0783153f, 0.239789f, 1.0f},
   {0.143301f, 0.0802594f, 0.246861f, 1.0f},
   {0.146433f, 0.0822624f, 0.253972f, 1.0f},
   {0.14942f, 0.0843326f, 0.261106f, 1.0f},
   {0.152259f, 0.0864773f, 0.268248f, 1.0f},
   {0.154948f, 0.088703f, 0.275382f, 1.0f},
   {0.157486f, 0.0910153f, 0.282494f, 1.0f},
   {0.159869f, 0.0934188f, 0.28957f, 1.0f},
   {0.162099f, 0.0959172f, 0.296595f, 1.0f},
   {0.164175f, 0.0985131f, 0.303559f, 1.0f},
   {0.166097f, 0.101208f, 0.310448f, 1.0f},
   {0.167866f, 0.104003f, 0.317252f, 1.0f},
   {0.169484f, 0.106898f, 0.323962f, 1.0f},
   {0.17095f, 0.109892f, 0.330567f, 1.0f},
   {0.172267f, 0.112984f, 0.337062f, 1.0f},
   {0.173437f, 0.116171f, 0.343437f, 1.0f},
   {0.174461f, 0.11945f, 0.349688f, 1.0f},
   {0.175341f, 0.12282f, 0.355808f, 1.0f},
   {0.176079f, 0.126276f, 0.361793f, 1.0f},
   {0.176677f, 0.129815f, 0.367639f, 1.0f},
   {0.177138f, 0.133433f, 0.373341f, 1.0f},
   {0.177464f, 0.137125f, 0.378898f, 1.0f},
   {0.177658f, 0.140888f, 0.384306f, 1.0f},
   {0.177721f, 0.144717f, 0.389565f, 1.0f},
   {0.177657f, 0.148608f, 0.394671f, 1.0f},
   {0.177468f, 0.152556f, 0.399625f, 1.0f},
   {0.177157f, 0.156558f, 0.404426f, 1.0f},
   {0.176728f, 0.160608f, 0.409073f, 1.0f},
   {0.176182f, 0.164703f, 0.413567f, 1.0f},
   {0.175524f, 0.168839f, 0.417908f, 1.0f},
   {0.174757f, 0.173011f, 0.422096f, 1.0f},
   {0.173883f, 0.177216f, 0.426134f, 1.0f},
   {0.172907f, 0.18145f, 0.430022f, 1.0f},
   {0.171832f, 0.185709f, 0.433761f, 1.0f},
   {0.170663f, 0.189989f, 0.437354f, 1.0f},
   {0.169402f, 0.194288f, 0.440802f, 1.0f},
   {0.168055f, 0.198602f, 0.444107f, 1.0f},
   {0.166625f, 0.202928f, 0.447273f, 1.0f},
   {0.165118f, 0.207262f, 0.450301f, 1.0f},
   {0.163538f, 0.211603f, 0.453194f, 1.0f},
   {0.161889f, 0.215948f, 0.455955f, 1.0f},
   {0.160178f, 0.220293f, 0.458587f, 1.0f},
   {0.158409f, 0.224637f, 0.461093f, 1.0f},
   {0.156588f, 0.228977f, 0.463475f, 1.0f},
   {0.15472f, 0.233311f, 0.465738f, 1.0f},
   {0.152813f, 0.237638f, 0.467885f, 1.0f},
   {0.150871f, 0.241955f, 0.469918f, 1.0f},
   {0.148903f, 0.246261f, 0.471842f, 1.0f},
   {0.146913f, 0.250554f, 0.473659f, 1.0f},
   {0.144911f, 0.254833f, 0.475373f, 1.0f},
   {0.142903f, 0.259096f, 0.476988f, 1.0f},
   {0.140896f, 0.263342f, 0.478508f, 1.0f},
   {0.138899f, 0.267571f, 0.479934f, 1.0f},
   {0.136921f, 0.27178f, 0.481273f, 1.0f},
   {0.134969f, 0.275969f, 0.482525f, 1.0f},
   {0.133052f, 0.280138f, 0.483696f, 1.0f},
   {0.13118f, 0.284285f, 0.484789f, 1.0f},
   {0.129362f, 0.28841f, 0.485806f, 1.0f},
   {0.127608f, 0.292512f, 0.486752f, 1.0f},
   {0.125926f, 0.296592f, 0.48763f, 1.0f},
   {0.124327f, 0.300648f, 0.488442f, 1.0f},
   {0.12282f, 0.30468f, 0.489192f, 1.0f},
   {0.121416f, 0.308688f, 0.489883f, 1.0f},
   {0.120124f, 0.312672f, 0.490519f, 1.0f},
   {0.118953f, 0.316632f, 0.491102f, 1.0f},
   {0.117913f, 0.320568f, 0.491635f, 1.0f},
   {0.117013f, 0.324479f, 0.492121f, 1.0f},
   {0.116259f, 0.328366f, 0.492562f, 1.0f},
   {0.115661f, 0.332229f, 0.492962f, 1.0f},
   {0.115225f, 0.336067f, 0.493323f, 1.0f},
   {0.114957f, 0.339882f, 0.493648f, 1.0f},
   {0.114862f, 0.343674f, 0.493938f, 1.0f},
   {0.114945f, 0.347442f, 0.494197f, 1.0f},
   {0.115208f, 0.351187f, 0.494426f, 1.0f},
   {0.115653f, 0.354909f, 0.494628f, 1.0f},
   {0.116282f, 0.358609f, 0.494805f, 1.0f},
   {0.117095f, 0.362287f, 0.494958f, 1.0f},
   {0.118089f, 0.365944f, 0.49509f, 1.0f},
   {0.119263f, 0.369579f, 0.495203f, 1.0f},
   {0.120614f, 0.373194f, 0.495298f, 1.0f},
   {0.122137f, 0.376788f, 0.495376f, 1.0f},
   {0.123829f, 0.380363f, 0.495441f, 1.0f},
   {0.125683f, 0.383918f, 0.495492f, 1.0f},
   {0.127694f, 0.387455f, 0.495532f, 1.0f},
   {0.129855f, 0.390973f, 0.495561f, 1.0f},
   {0.13216f, 0.394474f, 0.495581f, 1.0f},
   {0.134601f, 0.397957f, 0.495594f, 1.0f},
   {0.137173f, 0.401424f, 0.4956f, 1.0f},
   {0.139867f, 0.404874f, 0.4956f, 1.0f},
   {0.142676f, 0.408309f, 0.495595f, 1.0f},
   {0.145594f, 0.411729f, 0.495587f, 1.0f},
   {0.148615f, 0.415134f, 0.495576f, 1.0f},
   {0.15173f, 0.418525f, 0.495562f, 1.0f},
   {0.154934f, 0.421902f, 0.495547f, 1.0f},
   {0.158221f, 0.425267f, 0.495531f, 1.0f},
   {0.161584f, 0.428619f, 0.495514f, 1.0f},
   {0.165018f, 0.43196f, 0.495498f, 1.0f},
   {0.168518f, 0.435289f, 0.495482f, 1.0f},
   {0.172079f, 0.438607f, 0.495466f, 1.0f},
   {0.175695f, 0.441915f, 0.495452f, 1.0f},
   {0.179363f, 0.445213f, 0.49544f, 1.0f},
   {0.183077f, 0.448501f, 0.495428f, 1.0f},
   {0.186835f, 0.451781f, 0.495419f, 1.0f},
   {0.190632f, 0.455053f, 0.495411f, 1.0f},
   {0.194464f, 0.458317f, 0.495405f, 1.0f},
   {0.19833f, 0.461574f, 0.4954f, 1.0f},
   {0.202225f, 0.464823f, 0.495397f, 1.0f},
   {0.206147f, 0.468067f, 0.495395f, 1.0f},
   {0.210093f, 0.471304f, 0.495395f, 1.0f},
   {0.214062f, 0.474536f, 0.495395f, 1.0f},
   {0.218051f, 0.477763f, 0.495396f, 1.0f},
   {0.222057f, 0.480985f, 0.495397f, 1.0f},
   {0.22608f, 0.484203f, 0.495398f, 1.0f},
   {0.230118f, 0.487417f, 0.495398f, 1.0f},
   {0.234168f, 0.490628f, 0.495397f, 1.0f},
   {0.238231f, 0.493836f, 0.495394f, 1.0f},
   {0.242305f, 0.497041f, 0.495388f, 1.0f},
   {0.246388f, 0.500243f, 0.495379f, 1.0f},
   {0.25048f, 0.503444f, 0.495367f, 1.0f},
   {0.254581f, 0.506642f, 0.49535f, 1.0f},
   {0.258689f, 0.50984f, 0.495327f, 1.0f},
   {0.262804f, 0.513036f, 0.495298f, 1.0f},
   {0.266926f, 0.516231f, 0.495262f, 1.0f},
   {0.271055f, 0.519426f, 0.495218f, 1.0f},
   {0.27519f, 0.52262f, 0.495166f, 1.0f},
   {0.279331f, 0.525814f, 0.495103f, 1.0f},
   {0.283478f, 0.529008f, 0.495029f, 1.0f},
   {0.287632f, 0.532203f, 0.494943f, 1.0f},
   {0.291793f, 0.535397f, 0.494845f, 1.0f},
   {0.29596f, 0.538592f, 0.494732f, 1.0f},
   {0.300136f, 0.541788f, 0.494604f, 1.0f},
   {0.304319f, 0.544984f, 0.494459f, 1.0f},
   {0.30851f, 0.548181f, 0.494298f, 1.0f},
   {0.312711f, 0.551379f, 0.494117f, 1.0f},
   {0.316921f, 0.554578f, 0.493917f, 1.0f},
   {0.321142f, 0.557778f, 0.493696f, 1.0f},
   {0.325374f, 0.560979f, 0.493453f, 1.0f},
   {0.329619f, 0.56418f, 0.493186f, 1.0f},
   {0.333876f, 0.567383f, 0.492895f, 1.0f},
   {0.338148f, 0.570586f, 0.492578f, 1.0f},
   {0.342435f, 0.57379f, 0.492235f, 1.0f},
   {0.346739f, 0.576994f, 0.491863f, 1.0f},
   {0.351059f, 0.580199f, 0.491462f, 1.0f},
   {0.355399f, 0.583405f, 0.491031f, 1.0f},
   {0.359758f, 0.58661f, 0.490569f, 1.0f},
   {0.364137f, 0.589816f, 0.490075f, 1.0f},
   {0.368539f, 0.593022f, 0.489546f, 1.0f},
   {0.372964f, 0.596227f, 0.488984f, 1.0f},
   {0.377413f, 0.599432f, 0.488385f, 1.0f},
   {0.381888f, 0.602636f, 0.48775f, 1.0f},
   {0.38639f, 0.605839f, 0.487078f, 1.0f},
   {0.390919f, 0.609041f, 0.486367f, 1.0f},
   {0.395478f, 0.612241f, 0.485617f, 1.0f},
   {0.400067f, 0.61544f, 0.484827f, 1.0f},
   {0.404688f, 0.618637f, 0.483996f, 1.0f},
   {0.409342f, 0.621831f, 0.483123f, 1.0f},
   {0.414029f, 0.625024f, 0.482208f, 1.0f},
   {0.41875f, 0.628213f, 0.48125f, 1.0f},
   {0.423508f, 0.631399f, 0.480247f, 1.0f},
   {0.428302f, 0.634582f, 0.4792f, 1.0f},
   {0.433135f, 0.637761f, 0.478108f, 1.0f},
   {0.438005f, 0.640937f, 0.476971f, 1.0f},
   {0.442915f, 0.644108f, 0.475788f, 1.0f},
   {0.447865f, 0.647274f, 0.474558f, 1.0f},
   {0.452857f, 0.650436f, 0.47328f, 1.0f},
   {0.45789f, 0.653593f, 0.471955f, 1.0f},
   {0.462966f, 0.656744f, 0.470581f, 1.0f},
   {0.468084f, 0.65989f, 0.46916f, 1.0f},
   {0.473246f, 0.66303f, 0.46769f, 1.0f},
   {0.478452f, 0.666164f, 0.466171f, 1.0f},
   {0.483703f, 0.669291f, 0.464602f, 1.0f},
   {0.488999f, 0.672412f, 0.462984f, 1.0f},
   {0.49434f, 0.675526f, 0.461315f, 1.0f},
   {0.499727f, 0.678632f, 0.459597f, 1.0f},
   {0.505159f, 0.681731f, 0.457828f, 1.0f},
   {0.510638f, 0.684823f, 0.456008f, 1.0f},
   {0.516163f, 0.687907f, 0.454137f, 1.0f},
   {0.521735f, 0.690983f, 0.452214f, 1.0f},
   {0.527353f, 0.69405f, 0.45024f, 1.0f},
   {0.533018f, 0.697109f, 0.448214f, 1.0f},
   {0.53873f, 0.70016f, 0.446137f, 1.0f},
   {0.544489f, 0.703202f, 0.444006f, 1.0f},
   {0.550294f, 0.706234f, 0.441823f, 1.0f},
   {0.556146f, 0.709258f, 0.439588f, 1.0f},
   {0.562044f, 0.712272f, 0.4373f, 1.0f},
   {0.567989f, 0.715277f, 0.434958f, 1.0f},
   {0.57398f, 0.718273f, 0.432562f, 1.0f},
   {0.580018f, 0.721259f, 0.430111f, 1.0f},
   {0.586101f, 0.724235f, 0.427606f, 1.0f},
   {0.592231f, 0.7272f, 0.425046f, 1.0f},
   {0.598406f, 0.730156f, 0.42243f, 1.0f},
   {0.604626f, 0.733102f, 0.419759f, 1.0f},
   {0.610891f, 0.736038f, 0.417032f, 1.0f},
   {0.617202f, 0.738963f, 0.414247f, 1.0f},
   {0.623557f, 0.741877f, 0.411404f, 1.0f},
   {0.629957f, 0.744781f, 0.408503f, 1.0f},
   {0.6364f, 0.747675f, 0.405543f, 1.0f},
   {0.642887f, 0.750558f, 0.402524f, 1.0f},
   {0.649419f, 0.75343f, 0.399444f, 1.0f},
   {0.655994f, 0.756291f, 0.396301f, 1.0f},
   {0.662611f, 0.759141f, 0.393097f, 1.0f},
   {0.669271f, 0.76198f, 0.38983f, 1.0f},
   {0.675974f, 0.764809f, 0.386497f, 1.0f},
   {0.68272f, 0.767626f, 0.383097f, 1.0f},
   {0.689506f, 0.770432f, 0.379633f, 1.0f},
   {0.696335f, 0.773226f, 0.376099f, 1.0f},
   {0.703206f, 0.77601f, 0.372494f, 1.0f},
   {0.710117f, 0.778782f, 0.368819f, 1.0f},
   {0.717069f, 0.781543f, 0.365071f, 1.0f},
   {0.724063f, 0.784292f, 0.361246f, 1.0f},
   {0.731096f, 0.78703f, 0.357345f, 1.0f},
   {0.73817f, 0.789757f, 0.353364f, 1.0f},
   {0.745284f, 0.792471f, 0.349301f, 1.0f},
   {0.752437f, 0.795175f, 0.345155f, 1.0f},
   {0.75963f, 0.797867f, 0.340922f, 1.0f},
   {0.766863f, 0.800546f, 0.336597f, 1.0f},
   {0.774133f, 0.803215f, 0.332182f, 1.0f},
   {0.781444f, 0.805871f, 0.327668f, 1.0f},
   {0.788793f, 0.808516f, 0.323055f, 1.0f},
   {0.79618f, 0.811149f, 0.318337f, 1.0f},
   {0.803607f, 0.81377f, 0.313509f, 1.0f},
   {0.811071f, 0.816379f, 0.30857f, 1.0f},
   {0.818574f, 0.818976f, 0.303509f, 1.0f},
   {0.826113f, 0.821562f, 0.298326f, 1.0f},
   {0.833692f, 0.824135f, 0.293009f, 1.0f},
   {0.841308f, 0.826696f, 0.287555f, 1.0f},
   {0.848961f, 0.829244f, 0.281953f, 1.0f},
   {0.856652f, 0.831781f, 0.276196f, 1.0f},
   {0.86438f, 0.834305f, 0.270275f, 1.0f},
   {0.872146f, 0.836817f, 0.264175f, 1.0f},
   {0.879948f, 0.839317f, 0.257889f, 1.0f},
   {0.887788f, 0.841804f, 0.251398f, 1.0f},
   {0.895665f, 0.844279f, 0.244689f, 1.0f},
   {0.903579f, 0.846741f, 0.23774f, 1.0f},
   {0.911529f, 0.849191f, 0.230535f, 1.0f},
   {0.919517f, 0.851628f, 0.223043f, 1.0f},
   {0.927541f, 0.854052f, 0.215238f, 1.0f},
   {0.935602f, 0.856464f, 0.207084f, 1.0f},
   {0.9437f, 0.858862f, 0.198538f, 1.0f},
   {0.951834f, 0.861248f, 0.189549f, 1.0f},
   {0.960006f, 0.863621f, 0.180051f, 1.0f},
   {0.968214f, 0.865981f, 0.169965f, 1.0f},
   {0.97646f, 0.868327f, 0.159177f, 1.0f},
   {0.976779f, 0.862386f, 0.155111f, 1.0f},
   {0.97706f, 0.856459f, 0.15107f, 1.0f},
   {0.977303f, 0.850545f, 0.147055f, 1.0f},
   {0.977509f, 0.844644f, 0.143066f, 1.0f},
   {0.977678f, 0.838756f, 0.139106f, 1.0f},
   {0.97781f, 0.832881f, 0.135175f, 1.0f},
   {0.977906f, 0.827018f, 0.131276f, 1.0f},
   {0.977966f, 0.821169f, 0.12741f, 1.0f},
   {0.977991f, 0.815331f, 0.123579f, 1.0f},
   {0.977979f, 0.809507f, 0.119784f, 1.0f},
   {0.977933f, 0.803695f, 0.116029f, 1.0f},
   {0.977852f, 0.797895f, 0.112316f, 1.0f},
   {0.977735f, 0.792107f, 0.108647f, 1.0f},
   {0.977584f, 0.786332f, 0.105026f, 1.0f},
   {0.977399f, 0.780569f, 0.101454f, 1.0f},
   {0.97718f, 0.774818f, 0.0979368f, 1.0f},
   {0.976926f, 0.76908f, 0.0944766f, 1.0f},
   {0.976639f, 0.763353f, 0.0910778f, 1.0f},
   {0.976318f, 0.757639f, 0.0877449f, 1.0f},
   {0.975963f, 0.751936f, 0.0844825f, 1.0f},
   {0.975575f, 0.746246f, 0.0812957f, 1.0f},
   {0.975153f, 0.740568f, 0.0781901f, 1.0f},
   {0.974698f, 0.734901f, 0.0751715f, 1.0f},
   {0.97421f, 0.729247f, 0.0722466f, 1.0f},
   {0.97369f, 0.723604f, 0.0694222f, 1.0f},
   {0.973136f, 0.717974f, 0.0667052f, 1.0f},
   {0.972549f, 0.712355f, 0.0641031f, 1.0f},
   {0.97193f, 0.706749f, 0.0616239f, 1.0f},
   {0.971278f, 0.701154f, 0.0592756f, 1.0f},
   {0.970593f, 0.695572f, 0.0570672f, 1.0f},
   {0.969876f, 0.690001f, 0.055007f, 1.0f},
   {0.969127f, 0.684443f, 0.053103f, 1.0f},
   {0.968345f, 0.678896f, 0.0513632f, 1.0f},
   {0.96753f, 0.673362f, 0.0497955f, 1.0f},
   {0.966684f, 0.667839f, 0.0484082f, 1.0f},
   {0.965805f, 0.662329f, 0.0472061f, 1.0f},
   {0.964894f, 0.656831f, 0.0461945f, 1.0f},
   {0.963951f, 0.651345f, 0.0453783f, 1.0f},
   {0.962976f, 0.645871f, 0.0447602f, 1.0f},
   {0.961969f, 0.640409f, 0.0443399f, 1.0f},
   {0.96093f, 0.63496f, 0.0441182f, 1.0f},
   {0.959859f, 0.629523f, 0.0440931f, 1.0f},
   {0.958756f, 0.624098f, 0.0442594f, 1.0f},
   {0.957621f, 0.618686f, 0.0446138f, 1.0f},
   {0.956454f, 0.613286f, 0.0451486f, 1.0f},
   {0.955256f, 0.607899f, 0.0458558f, 1.0f},
   {0.954026f, 0.602524f, 0.0467287f, 1.0f},
   {0.952763f, 0.597162f, 0.0477554f, 1.0f},
   {0.95147f, 0.591812f, 0.0489289f, 1.0f},
   {0.950145f, 0.586475f, 0.0502368f, 1.0f},
   {0.948788f, 0.581151f, 0.0516707f, 1.0f},
   {0.947399f, 0.57584f, 0.0532196f, 1.0f},
   {0.945979f, 0.570541f, 0.0548746f, 1.0f},
   {0.944527f, 0.565256f, 0.0566254f, 1.0f},
   {0.943044f, 0.559984f, 0.0584642f, 1.0f},
   {0.941529f, 0.554724f, 0.060381f, 1.0f},
   {0.939983f, 0.549478f, 0.0623701f, 1.0f},
   {0.938406f, 0.544245f, 0.0644216f, 1.0f},
   {0.936797f, 0.539025f, 0.0665308f, 1.0f},
   {0.935157f, 0.533818f, 0.06869f, 1.0f},
   {0.933486f, 0.528625f, 0.0708935f, 1.0f},
   {0.931783f, 0.523445f, 0.0731374f, 1.0f},
   {0.930049f, 0.518279f, 0.075415f, 1.0f},
   {0.928284f, 0.513127f, 0.0777229f, 1.0f},
   {0.926488f, 0.507987f, 0.0800575f, 1.0f},
   {0.924661f, 0.502862f, 0.0824143f, 1.0f},
   {0.922803f, 0.497751f, 0.0847901f, 1.0f},
   {0.920914f, 0.492653f, 0.0871832f, 1.0f},
   {0.918994f, 0.487569f, 0.0895898f, 1.0f},
   {0.917043f, 0.482499f, 0.0920077f, 1.0f},
   {0.915061f, 0.477443f, 0.0944346f, 1.0f},
   {0.913049f, 0.472401f, 0.0968695f, 1.0f},
   {0.911006f, 0.467373f, 0.0993103f, 1.0f},
   {0.908932f, 0.462359f, 0.101755f, 1.0f},
   {0.906828f, 0.45736f, 0.104203f, 1.0f},
   {0.904693f, 0.452375f, 0.106652f, 1.0f},
   {0.902527f, 0.447404f, 0.109102f, 1.0f},
   {0.900332f, 0.442447f, 0.111551f, 1.0f},
   {0.898106f, 0.437505f, 0.114f, 1.0f},
   {0.895849f, 0.432578f, 0.116447f, 1.0f},
   {0.893563f, 0.427665f, 0.118891f, 1.0f},
   {0.891246f, 0.422766f, 0.121333f, 1.0f},
   {0.888899f, 0.417883f, 0.12377f, 1.0f},
   {0.886523f, 0.413014f, 0.126204f, 1.0f},
   {0.884116f, 0.408159f, 0.128634f, 1.0f},
   {0.88168f, 0.40332f, 0.131059f, 1.0f},
   {0.879213f, 0.398495f, 0.133479f, 1.0f},
   {0.876718f, 0.393685f, 0.135893f, 1.0f},
   {0.874192f, 0.38889f, 0.138303f, 1.0f},
   {0.871637f, 0.384109f, 0.140708f, 1.0f},
   {0.869053f, 0.379344f, 0.143107f, 1.0f},
   {0.866439f, 0.374593f, 0.1455f, 1.0f},
   {0.863796f, 0.369858f, 0.147888f, 1.0f},
   {0.861124f, 0.365137f, 0.15027f, 1.0f},
   {0.858423f, 0.360431f, 0.152646f, 1.0f},
   {0.855693f, 0.35574f, 0.155017f, 1.0f},
   {0.852934f, 0.351064f, 0.157382f, 1.0f},
   {0.850146f, 0.346403f, 0.159741f, 1.0f},
   {0.84733f, 0.341757f, 0.162094f, 1.0f},
   {0.844485f, 0.337126f, 0.164442f, 1.0f},
   {0.841612f, 0.33251f, 0.166785f, 1.0f},
   {0.83871f, 0.327908f, 0.169121f, 1.0f},
   {0.83578f, 0.323321f, 0.171453f, 1.0f},
   {0.832822f, 0.318749f, 0.173779f, 1.0f},
   {0.829835f, 0.314192f, 0.176099f, 1.0f},
   {0.826821f, 0.309649f, 0.178415f, 1.0f},
   {0.823779f, 0.305121f, 0.180725f, 1.0f},
   {0.82071f, 0.300608f, 0.18303f, 1.0f},
   {0.817612f, 0.296109f, 0.18533f, 1.0f},
   {0.814487f, 0.291624f, 0.187624f, 1.0f},
   {0.811335f, 0.287154f, 0.189914f, 1.0f},
   {0.808155f, 0.282698f, 0.192198f, 1.0f},
   {0.804948f, 0.278255f, 0.194478f, 1.0f},
   {0.801715f, 0.273827f, 0.196753f, 1.0f},
   {0.798454f, 0.269413f, 0.199022f, 1.0f},
   {0.795166f, 0.265012f, 0.201287f, 1.0f},
   {0.791851f, 0.260625f, 0.203547f, 1.0f},
   {0.78851f, 0.256251f, 0.205802f, 1.0f},
   {0.785142f, 0.251891f, 0.208052f, 1.0f},
   {0.781748f, 0.247544f, 0.210297f, 1.0f},
   {0.778327f, 0.243209f, 0.212537f, 1.0f},
   {0.774881f, 0.238887f, 0.214772f, 1.0f},
   {0.771408f, 0.234578f, 0.217002f, 1.0f},
   {0.767908f, 0.230281f, 0.219226f, 1.0f},
   {0.764383f, 0.225997f, 0.221446f, 1.0f},
   {0.760832f, 0.221724f, 0.22366f, 1.0f},
   {0.757255f, 0.217462f, 0.225869f, 1.0f},
   {0.753653f, 0.213212f, 0.228073f, 1.0f},
   {0.750025f, 0.208973f, 0.23027f, 1.0f},
   {0.746371f, 0.204745f, 0.232462f, 1.0f},
   {0.742691f, 0.200527f, 0.234648f, 1.0f},
   {0.738986f, 0.19632f, 0.236827f, 1.0f},
   {0.735256f, 0.192122f, 0.239001f, 1.0f},
   {0.731501f, 0.187934f, 0.241167f, 1.0f},
   {0.72772f, 0.183755f, 0.243327f, 1.0f},
   {0.723913f, 0.179585f, 0.24548f, 1.0f},
   {0.720082f, 0.175423f, 0.247626f, 1.0f},
   {0.716225f, 0.17127f, 0.249764f, 1.0f},
   {0.712343f, 0.167123f, 0.251895f, 1.0f},
   {0.708436f, 0.162985f, 0.254017f, 1.0f},
   {0.704504f, 0.158852f, 0.25613f, 1.0f},
   {0.700546f, 0.154727f, 0.258234f, 1.0f},
   {0.696564f, 0.150607f, 0.26033f, 1.0f},
   {0.692555f, 0.146492f, 0.262415f, 1.0f},
   {0.688522f, 0.142382f, 0.26449f, 1.0f},
   {0.684463f, 0.138276f, 0.266555f, 1.0f},
   {0.680379f, 0.134175f, 0.268608f, 1.0f},
   {0.676269f, 0.130076f, 0.270649f, 1.0f},
   {0.672134f, 0.12598f, 0.272678f, 1.0f},
   {0.667973f, 0.121887f, 0.274694f, 1.0f},
   {0.663786f, 0.117795f, 0.276696f, 1.0f},
   {0.659574f, 0.113703f, 0.278684f, 1.0f},
   {0.655335f, 0.109612f, 0.280657f, 1.0f},
   {0.65107f, 0.105521f, 0.282614f, 1.0f},
   {0.646778f, 0.101429f, 0.284554f, 1.0f},
   {0.64246f, 0.0973356f, 0.286476f, 1.0f},
   {0.638115f, 0.09324f, 0.288379f, 1.0f},
   {0.633743f, 0.0891415f, 0.290263f, 1.0f},
   {0.629343f, 0.0850398f, 0.292126f, 1.0f},
   {0.624916f, 0.0809343f, 0.293967f, 1.0f},
   {0.620462f, 0.0768243f, 0.295785f, 1.0f},
   {0.615978f, 0.0727095f, 0.297579f, 1.0f},
   {0.611467f, 0.0685895f, 0.299346f, 1.0f},
   {0.606927f, 0.0644639f, 0.301086f, 1.0f},
   {0.602357f, 0.0603325f, 0.302798f, 1.0f},
   {0.597758f, 0.0561952f, 0.304478f, 1.0f},
   {0.593128f, 0.0520523f, 0.306127f, 1.0f},
   {0.588469f, 0.0479042f, 0.307741f, 1.0f},
   {0.583778f, 0.0437515f, 0.309318f, 1.0f},
   {0.579056f, 0.0395863f, 0.310858f, 1.0f},
   {0.574303f, 0.0355383f, 0.312357f, 1.0f},
   {0.569517f, 0.0317435f, 0.313813f, 1.0f},
   {0.564698f, 0.0281999f, 0.315223f, 1.0f},
   {0.559846f, 0.0249054f, 0.316585f, 1.0f},
   {0.55496f, 0.0218586f, 0.317896f, 1.0f},
   {0.550039f, 0.0190572f, 0.319153f, 1.0f},
   {0.545084f, 0.0164999f, 0.320353f, 1.0f},
   {0.540094f, 0.0141845f, 0.321492f, 1.0f},
   {0.535067f, 0.0121097f, 0.322568f, 1.0f},
   {0.530004f, 0.0102732f, 0.323575f, 1.0f},
   {0.524904f, 0.00867329f, 0.324512f, 1.0f},
   {0.519767f, 0.00730801f, 0.325372f, 1.0f},
   {0.514592f, 0.00617496f, 0.326154f, 1.0f},
   {0.509379f, 0.00527169f, 0.326851f, 1.0f},
   {0.504128f, 0.0045955f, 0.327459f, 1.0f},
   {0.498838f, 0.00414334f, 0.327975f, 1.0f},
   {0.49351f, 0.00391176f, 0.328392f, 1.0f},
   {0.488143f, 0.00389685f, 0.328707f, 1.0f},
   {0.482737f, 0.00409419f, 0.328915f, 1.0f},
   {0.477294f, 0.00449875f, 0.32901f, 1.0f},
   {0.471812f, 0.00510487f, 0.328987f, 1.0f},
   {0.466293f, 0.00590618f, 0.328842f, 1.0f},
   {0.460738f, 0.00689559f, 0.328571f, 1.0f},
   {0.455146f, 0.00806527f, 0.328168f, 1.0f},
   {0.449521f, 0.0094063f, 0.327629f, 1.0f},
   {0.443862f, 0.010909f, 0.32695f, 1.0f},
   {0.438172f, 0.0125631f, 0.326128f, 1.0f},
   {0.432451f, 0.0143571f, 0.325158f, 1.0f},
   {0.426703f, 0.0162788f, 0.324038f, 1.0f},
   {0.42093f, 0.0183152f, 0.322767f, 1.0f},
   {0.415133f, 0.0204528f, 0.321341f, 1.0f},
   {0.409315f, 0.0226772f, 0.31976f, 1.0f},
   {0.40348f, 0.0249737f, 0.318022f, 1.0f},
   {0.397629f, 0.0273272f, 0.31613f, 1.0f},
   {0.391766f, 0.0297224f, 0.314082f, 1.0f},
   {0.385894f, 0.0321439f, 0.31188f, 1.0f},
   {0.380016f, 0.0345764f, 0.309526f, 1.0f},
   {0.374134f, 0.037005f, 0.307024f, 1.0f},
   {0.368253f, 0.0394147f, 0.304375f, 1.0f},
   {0.362374f, 0.0417565f, 0.301584f, 1.0f},
   {0.356502f, 0.0439693f, 0.298655f, 1.0f},
   {0.350638f, 0.0460614f, 0.295593f, 1.0f},
   {0.344785f, 0.0480321f, 0.292402f, 1.0f},
   {0.338946f, 0.0498808f, 0.289087f, 1.0f},
   {0.333124f, 0.0516078f, 0.285654f, 1.0f},
   {0.32732f, 0.0532134f, 0.282108f, 1.0f},
   {0.321536f, 0.0546986f, 0.278455f, 1.0f},
   {0.315775f, 0.0560643f, 0.2747f, 1.0f},
   {0.310038f, 0.0573117f, 0.27085f, 1.0f},
   {0.304327f, 0.0584426f, 0.26691f, 1.0f},
   {0.298643f, 0.0594588f, 0.262884f, 1.0f},
   {0.292987f, 0.0603617f, 0.25878f, 1.0f},
   {0.287361f, 0.0611539f, 0.254601f, 1.0f},
   {0.281764f, 0.061837f, 0.250354f, 1.0f},
   {0.276199f, 0.0624134f, 0.246042f, 1.0f},
   {0.270665f, 0.0628854f, 0.241671f, 1.0f},
   {0.265163f, 0.0632551f, 0.237245f, 1.0f},
   {0.259693f, 0.0635247f, 0.232769f, 1.0f},
   {0.254256f, 0.0636966f, 0.228247f, 1.0f},
   {0.248852f, 0.0637729f, 0.223682f, 1.0f},
   {0.243481f, 0.063756f, 0.219079f, 1.0f},
   {0.238142f, 0.063648f, 0.21444f, 1.0f},
   {0.232836f, 0.0634509f, 0.209769f, 1.0f},
   {0.227563f, 0.0631668f, 0.20507f, 1.0f},
   {0.222321f, 0.0627979f, 0.200345f, 1.0f},
   {0.217111f, 0.0623461f, 0.195597f, 1.0f},
   {0.211933f, 0.0618131f, 0.190828f, 1.0f},
   {0.206786f, 0.0612009f, 0.186041f, 1.0f},
   {0.20167f, 0.0605113f, 0.181237f, 1.0f},
   {0.196583f, 0.0597458f, 0.17642f, 1.0f},
   {0.191525f, 0.058906f, 0.171591f, 1.0f},
   {0.186497f, 0.0579937f, 0.166751f, 1.0f},
   {0.181496f, 0.0570099f, 0.161903f, 1.0f},
   {0.176523f, 0.0559563f, 0.157047f, 1.0f},
   {0.171576f, 0.054834f, 0.152185f, 1.0f},
   {0.166655f, 0.0536444f, 0.147319f, 1.0f},
   {0.161759f, 0.0523882f, 0.142448f, 1.0f},
   {0.156887f, 0.0510668f, 0.137575f, 1.0f},
   {0.152038f, 0.0496809f, 0.1327f, 1.0f},
   {0.147211f, 0.0482316f, 0.127823f, 1.0f},
   {0.142405f, 0.0467194f, 0.122945f, 1.0f},
   {0.13762f, 0.0451451f, 0.118067f, 1.0f},
   {0.132854f, 0.0435092f, 0.113189f, 1.0f},
   {0.128105f, 0.0418123f, 0.108311f, 1.0f},
   {0.123374f, 0.040049f, 0.103433f, 1.0f},
});

// Init the base palettes
PaletteRegistry BasePalettes(
{
   BPAL_1, BPAL_2, BPAL_3, BPAL_4, BPAL_5,
   BPAL_6, BPAL_7, BPAL_8, BPAL_9, BPAL_10,
   BPAL_11, BPAL_12, BPAL_13, BPAL_14, BPAL_15,
   BPAL_16, BPAL_17, BPAL_18, BPAL_19, BPAL_20,
   BPAL_21, BPAL_22, BPAL_23, BPAL_24, BPAL_25,
   BPAL_26, BPAL_27, BPAL_28, BPAL_29, BPAL_30,
   BPAL_31, BPAL_32, BPAL_33, BPAL_34, BPAL_35,
   BPAL_36, BPAL_37, BPAL_38, BPAL_39, BPAL_40,
   BPAL_41, BPAL_42, BPAL_43
});