<!--
  This file is part of Code_Saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2021 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->

\page cs_ug_file_formats Supported input and output formats

[TOC]

External mesh and visualization formats {#sec_mesh_viz_formats}
=======================================

code_saturne supports multiple mesh formats, all of these having been requested
at some time by users or projects based on their meshing or post-processing
tools. All of these formats have advantages and disadvantages (in terms
of simplicity, functionality, longevity, and popularity) when compared to
each other. The following formats are currently supported:

* [CGNS](@ref sec_fmtdesc_cgns)
* [MED](@ref sec_fmtdesc_med)
* [Gmsh](@ref sec_fmtdesc_gmsh)
* [Simail NOPO](@ref sec_fmtdesc_des)
* [I-deas universal](@ref sec_fmtdesc_unv)
* [EnSight 6](@ref sec_fmtdesc_ensight6)
* [EnSight Gold](@ref sec_fmtdesc_ensightg)
* [GAMBIT neutral](@ref sec_fmtdesc_neu)
* [STAR-CCM+](@ref sec_fmtdesc_ccm)
* [ParaView Catalyst](@ref sec_fmtdesc_catalyst)

These formats are described in greater detail in the following sections.
Unless a specific option is used, the Preprocessor determines the mesh format directly
from the file suffix:

* `.case` for EnSight (6 or Gold)
* `.ccm` for Star-CCM+
* `.cgns` for CGNS
* `.des` for Simail NOPO
* `.med` for MED
* `.msh` for Gmsh
* `.neu` for GAMBIT neutral
* `.unv` for I-deas universal

Note that the preprocessor can read gzipped mesh files directly (for Formats
other than MED, CGNS, or CCM+, which use specific external libraries) on most machines.

Mesh formats supported for input {#sec_formats_in}
--------------------------------

### Gmsh {#sec_fmtdesc_gmsh}
<!-- -->

This format is used by the free [Gmsh](http://www.geuz.org/gmsh)
tool. This tool has both meshing and post-processing functionality,
but code_saturne only imports the meshes, allowing
MSH formats up to 4.1 (the latest revision as of March 2020).

Note that some meshes produced by Gmsh man contain some badly oriented
elements, so the Preprocessor's `--reorient` option may be necessary.

In the initial version of this format, two labels were associated with each element:
the first for the element's physical entity  number, the second defines its
elementary entity number. Using later versions it is possible to associate an
arbitrary number of labels with each element.

In code_saturne, it was chosen to interpret physical entity numbers to groups.
Although it is possible to build a mesh using Gmsh without defining any  physical
entities (in which case all elements will belong to the same group, the
documentation clearly says that geometric entities are to be used
so as to group elementary entities having similar "physical" meanings.

To obtain distinct groups with a mesh generated by Gmsh, it
is thus necessary for the user to define physical entities.
This requires an extra step, but allows for fine-grained control
over the groups associated with the mesh, while using only elementary
entities could lead to a high number of groups.

<table>
<tr><td> Default extension <td> `.msh`
<tr><td> File type         <td> text or binary file
<tr><td> Surface elements  <td> triangles, quadrangles
<tr><td> Volume elements   <td> tetrahedra, pyramids, prisms, hexahedra
<tr><td> Zone selection    <td> physical entities interpreted as groups
<tr><td> Compatibility     <td> all files of this type (current revision: 4.1)
<tr><td> Documentation     <td> included documentation, also available at:
                                [http://www.geuz.org/gmsh](http://www.geuz.org/gmsh)
</table>

### NOPO/Simail (INRIA/Distene) {#sec_fmtdesc_des}
<!-- -->

This format is output by Simail, which was used heavily at EDF until
a few years ago. code_saturne does not currently handle cylindrical or
spherical coordinates, but it seems that Simail always outputs meshes in
Cartesian coordinates, even if points have been defined in another system.
Most "classical" element types are available, except for pyramids.

Note that depending on the architecture on which a file was produced, it may may
not be directly readable by Simail on a different machine (due to
non-portable/non-standardized Fortran binary file headers and endianness issues),
but this is usually not a problem for the code_saturne preprocessor, which
automatically detects the byte ordering and the 32/64 bit variant and adapts
accordingly.

<table>
<tr><td> Default extension <td> `.des`
<tr><td> File type         <td> semi-portable "Fortran" binary (IEEE integer and
                                floating-point numbers on 4 or 8 bytes, depending
                                on 32 or 64 bit Simail version, bytes also ordered
                                based on the architecture)
<tr><td> Surface elements  <td> triangles, quadrangles
                                (+ volume element face references)
<tr><td> Volume elements   <td> tetrahedra, prisms, hexahedra
<tr><td> Zone selection    <td> element face references and volume sub-domains
                                (interpreted as numbered groups)
<tr><td> Compatibility     <td> all files of this type as long as the coordinate
                                system used is Cartesian and not cylindrical or
                                spherical
<tr><td> Documentation     <td> Simail user documentation and release notes or
                                MODULEF documentation:
                                http://www-rocq.inria.fr/modulef <br/>
                               Especially: <br/>
                                http://www-rocq.inria.fr/modulef/Doc/FR/Guide2-14/node49.html
</table>

### I-deas universal {#sec_fmtdesc_unv}
<!-- -->

This format was very popular in the 1990's and early 2000's, and though
the I-deas tool has not focused on the CFD (or even meshing) market since
many years, it is handled (at least in part) by many tools, and may
be considered as a major "legacy" format. It may contain many different
datasets, relative to CAD, meshing, materials, calculation results,
or part representation. Most of these datasets are ignored by code_saturne,
and only those relative to vertex, element, group, and coordinate system
definitions are handled.

This format's definition evolves with I-deas versions, albeit in a limited
manner: some datasets are declared obsolete, and are replaced by others,
but the definition of a given dataset type is never modified. Element and
Vertex definitions have not changed for many years, but group definitions
have gone through several dataset variants through the same period,
usually adding minor additional group types not relevant to meshing.
Datasets unknown to code_saturne are simply ignored.

Note that this is a text format. Most element types are handled, except
for pyramids.

<table>
<tr><td> Default extension <td> `.unv`
<tr><td> File type         <td> text
<tr><td> Surface elements  <td> triangles, quadrangles
<tr><td> Volume elements   <td> tetrahedra, prisms, hexahedra
<tr><td> Zone selection    <td> colors (always) and named groups
<tr><td> Compatibility     <td> I-deas *Master Series* 5 to 9, *NX Series* 10 to 12)
                                at least
<tr><td> Documentation     <td> Online I-deas NX Series documentation, and
                                https://docs.plm.automation.siemens.com/tdoc/nx/10/nx_help/#uid:index_advanced:xid602249:id625716:id625821
</table>

### GAMBIT neutral {#sec_fmtdesc_neu}
<!-- -->

This format may be produced by ANSYS GAMBIT meshing tool.
As this tool did not export meshes to other formats directly handled
by the Preprocesso (though FLUENT itself may export files to the CGNS or
I-dead universal formats), it was deemed useful to enable the Preprocessor
to directly read files in GAMBIT neutral format.

Note that this is a text format. "Classical" element types are usable.

<table>
<tr><td> Default extension <td> `.neu`
<tr><td> File type         <td> text
<tr><td> Surface elements  <td> triangles, quadrangles
<tr><td> Volume elements   <td> tetrahedra, pyramids, prisms, hexahedra
<tr><td> Zone selection    <td> boundary conditions for faces, element groups for cells
                                (interpreted as named groups)
<tr><td> Documentation     <td> GAMBIT on-line documentation
</table>

### EnSight 6 {#sec_fmtdesc_ensight6}
<!-- -->

This format was used for output by old version of the Harpoon meshing tool, developed
by Sharc Ltd, and may be produced by various other tools.
It  may represent all ``classical'' element types.

Designed for post processing, it does not explicitly handle the definition
of surface patches or volume zones, but allows the use of many *parts*
(i.e. groups of elements) which use a common vertex list.
A possible convention is to add surface
elements to the volume mesh, using one *part* per group. The volume
mesh may also be separated into several *parts* so as to identify
different zones. As *part* names may contain up to 80 characters,
we do not transform them into groups (whose names could be unwieldy),
so we simply convert their numbers to group names.

<table>
<tr><td> Default extension <td> `.case`
<tr><td> File type         <td> text file (*.case*), and text, binary, or
                                Fortran binary file with *.geo* extension,
                                describing 32-bit integers and floats in the IEEE format
<tr><td> Surface elements  <td> triangles, quadrangles
<tr><td> Volume elements   <td> tetrahedra, pyramids, prisms, hexahedra
<tr><td> Zone selection    <td> part numbers interpreted as numbered groups
<tr><td> Compatibility     <td> All files of this type
<tr><td> Documentation     <td> on-line documentation, also available at:
                                <a href="www3.ensight.com/EnSight10_Docs/UserManual.pdf">www3.ensight.com/EnSight10_Docs/UserManual.pdf</a>
</table>

Mesh formats supported for input or output {#sec_formats_inout}
------------------------------------------

### MED {#sec_fmtdesc_med}
<!-- -->

Initially defined by EDF R&D, this format *Modèle d'échanges de Données*,
or *Model for Exchange of Data* has been defined and maintained through
a working group comprising members of EDF R&D and CEA.
This is the reference format for the
[*SALOME*](http://www.salome-platform.org/) platform.
This format is quite complete, allowing the definition of all "classical"
element types, in nodal or descending connectivity.
It may handle polygonal faces and polyhedral cells,
as well as the definition of structured meshes.

This format, which requires a library also depending on the free HDF5 library,
allows both for reading and writing meshes with their attributes ("families" of
group combinations), as well as handling calculation data,
with the possibility (unused by code_saturne) of defining variables only on a
subset ("profile") of a mesh.

The MED library is available under a [LGPL](http://www.gnu.org) license,
and is even packaged in some Linux distributions
(at least Debian and Ubuntu). code_saturne requires at least MED 3.0.2, which in turn
requires HDF5 1.8. This format is upwards-compatible with MED 2.3,
so old files in that version of the format may still be read.
The current MED 4.x versions are based on HDF5 1.10.

<table>
<tr><td> Default extension <td> `.med`
<tr><td> File type            <td> portable binary, based on the
                                   [HDF5](http://www.hdfgroup.org/HDF5/index.html) library
<tr><td> Surface elements     <td> triangles, quadrangles, simple polygons
<tr><td> Volume elements      <td> tetrahedra, pyramids, prisms, hexahedra, simple polyhedra
<tr><td> Zone selection       <td> element groups (stored as families)
<tr><td> Input compatibility  <td> MED 2.3 to 4.1 (assuming up to date MED library);
                                   only unstructured nodal connectivity is supported
<tr><td> Output compatibility <td> MED 3.0 and above (based on MED library version)
<tr><td> Documentation        <td> on-line documentation; descripyion at
                                   https://www.salome-platform.org/user-section/about/med,
                                   download link at
                                   http://files.salome-platform.org/Salome/other/med-4.0.0.tar.gz
<tr><td> Parallel IO       <td> supported (using HDF5 parallel IO); still has unresolved bug.
</table>

### CGNS {#sec_fmtdesc_cgns}
<!-- -->

Promoted by organizations including the AIAA, NASA, Boeing Commercial, ANSYS,
Airbus, ONERA, SAFRAN, ANSYS, Pointwise, Inc., Numeca, and others,
the *CFD General Notation System* format is quite well established in
the world of CFD. The concept is similar to that of MED, with a bigger
emphasis on normalization of variable names or calculation information, and
even richer possibilities.

Slightly older than MED, this library was free from the start, with a good
English documentation, and is much better known. It is more focused
on CFD, whereas MED is more generic. A certain number of tools accompany
the CGNS distribution, including a mesh visualizer, and an interpolation
tool.

code_saturne should be able to read almost any mesh written in this format,
though meshes with overset interfaces may not be usable for a calculation
(calculations with overset interfaces may be possible in the context of
coupling code_saturne with itself, but with two separate meshes).
Other (abutting) interfaces are not handled automatically (as there are
at least 3 or 4 ways of defining them, and some mesh tools do not export
them (for example, ICEM-CFD can join non-conforming meshes, but it
exports joining surfaces as simple boundary faces with user-defined boundary
conditions). When present, the code_saturne user is simply informed of their
existence in the Preprocessor's log file, with a suggestion to use an
appropriate mesh joining option. Structured zones are converted to
unstructured zones immediately after being read.

Boundary condition information is interpreted as groups with the same
name. The format does not yet provide for selection of volume elements,
as only boundary conditions are defined in the model (and can be assigned to
faces in the case of unstructured meshes, or vertices in any case).
Regions (CPEX 0030 proposal, implement as of CGNS 3.1.) could be used for
this but are not handled yet by code_saturne.
Note that boundary conditions defined at vertices are not ignored by
the Preprocessor, but are assigned to the faces of which all vertices bear
the same condition. If one of a face's vertices does not bear
a boundary condition, that condition is not transferred to the face.
So whenever possible, boundary conditions should be assigned to faces
rather than vertices.

To better support CGNS files generated by different tools, the Preprocessor also
has the capability of building additional volume or surface
groups, based on the mesh sections to which cells or faces belong. This may be
activated using a sub-option of the mesh selection, and allows obtaining
zone selection information from meshes that do not have explicit
boundary condition information but that are subdivided in appropriate zones or
sections (which depends on the tool used to build the mesh).

When outputting to CGNS, an unstructured connectivity is used for the calculation
domain, with no face joining information or face boundary condition
information (this feature should be added later).

Many tools support CGNS, though that support may have limitations.
Some editors seem to use different means to mark zones to associate with
boundary conditions than the ones recommended in the CGNS documentation, and
some behaviours are worse. Also, some readers do not allow the user to
choose between multiple CGNS bases (meshes in the code_saturne),
so when outputting to CGNS, it may be necessary to output
each post-processing mesh using a separate output.

Note also that recent CGNS library versions (3.3.0 or 4.x) may require
running their `cgnsupdate` tool to allow reading older CGNS files, due to
some internal changes.

<table>
<tr><td> Default extension <td> `.cgns`
<tr><td> File type            <td> portable binary (using the ADF library specific to CGNS,
                                   or [HDF5](http://www.hdfgroup.org/HDF5/index.html))
<tr><td> Surface elements     <td> triangles, quadrangles, simple polygons
<tr><td> Volume elements      <td> tetrahedra, pyramids, prisms, hexahedra, simple polyhedra
<tr><td> Zone selection       <td> surface zone selection using boundary conditions;
                                   no direct volume zone selection, but the Preprocessor
                                   allows creation of groups associated to zones or sections
                                   in the mesh using mesh selection sub-options
<tr><td> Input compatibility  <td> CGNS 2.5 or CGNS 3.1 and above (based on library version)
<tr><td> Output compatibility <td> CGNS 3.1 and above (based on library version)
<tr><td> Documentation        <td> [on-line documentation](https://cgns.github.io/CGNS_docs_current/index.html)
<tr><td> Parallel IO          <td> supported by CGNS (using HDF5 parallel IO) but not yet
                                   by code_saturne.
</table>

### EnSight Gold {#sec_fmtdesc_ensightg}
<!-- -->

This format may represent all "classical" element types, as well as
arbitrary polygons and convex polyhedra.

This format offers many possibilities not used by code_saturne, such as
defining values on part of a mesh only (using "undefined" marker values or
partial values), assigning materials to elements, defining rigid
motion, or defining per-processor mesh parts with ghost cells for
parallel runs. Note that some libraries allowing direct EnSight Gold support
do not necessarily support the whole format specification.
Especially, VTK does not support material types.
Also, both EnSight Gold and VTK allow for automatic distribution,
reducing the usefulness of pre-distributed meshes with per-processor files.

Note than when using ParaView, if multiple parts (i.e. meshes) are
present in a give case, using the "Extract Blocks" filter is
required to separate those parts and obtain a proper visualization,
unless the `separate_meshes` writer option is used.
The VisIt software does not seem to handle multiple parts in an EnSight case,
so different meshes must be assigned to different *writers*,
or the `separate_meshes` writer option must be used.

This format may be used as an input format, similar to EnSight 6.
Compared to the latter, each *part* has its own coordinates and vertex
connectivity; hence as a convention, we consider that surface or
volume zones may only be considered to be part of the same mesh
if the file defines vertex IDs (which we consider to be
unique vertex labels). In this case, *part* numbers
are interpreted as group names. Without vertex IDs, only one part is read,
and no groups are assigned.

<table>
<tr><td> Default extension <td> *case_name*`.ensight` directory,
                                containing a file with the `.case` extension;
                                for input, any directory name is allowed
<tr><td> File type         <td> multiple binary or text files
<tr><td> Surface elements  <td> triangles, quadrangles, simple polygons
<tr><td> Volume elements   <td> tetrahedra, pyramids, prisms, hexahedra, simple polyhedra
<tr><td> Zone selection    <td> possibility of defining element materials (not used), or
                                interpret part number as group name if vertex IDs are
                                given
<tr><td> Compatibility     <td> files readable by EnSight 7.4 to 10.0, as well as tools
                                based on the [VTK](http://www.vtk.org) library,
                                especially [ParaView](http://www.paraview.org)
<tr><td> Documentation     <td> on-line documentation, also available at:
                                <a href="www3.ensight.com/EnSight10_Docs/UserManual.pdf">www3.ensight.com/EnSight10_Docs/UserManual.pdf</a>
<tr><td> Parallel IO       <td> supported for binary output, using "direct" MPI-IO
</table>

### STAR CCM+ {#sec_fmtdesc_ccm}
<!-- -->

\deprecated Use of the CGNS format should be stronlgy preferred to this format when possible,
            and CGNS output is available in STAR-CCM+ since version 12.06 at least.

This polyhedral format is the current CD-Adapco (SIEMENS PLM) format, and is
based on CD-Adapco's libccmio, which is based on ADF (the low-level file format
used by CGNS prior to the shift to HDF5). libccmio comes with a version
of ADF modified for performance, which can cause issues when linking also with
CGNS (code_saturne tries to work around this using dynamically loaded libraries
when possible).

Currently, geometric entity numbers are converted to numbered groups,
with the corresponding names printed to the Preprocessor log. Depending on whether
the names were generated automatically or set by the user, it would be
preferable to use the original group names rather than base their
names on their numbers.

This format may also be used for output, though its limitations
make this a less general solution than other output formats:
only 3D meshes are handled, though values can be output on boundary
face regions (which may not overlap). As such, to ensure consistency,
output using this format is limited as follows:

* output of the full volume mesh and cell or vertex data on that
  mesh is handled normally.
* output of the full surface mesh and per face data on that mesh
  handled normally, only if output of the full volume mesh to
  this format is also enabled. It is ignored otherwise.
* output of sub-meshes or meshes built during the preprocessing
  stage and all other data is ignored.

As such, this formal may be useful for interoperability of data
with a CCMIO-based tool-chain, but simultaneously using another output
format to visualize possible error output is stronlgy recommended,
as other issues due to undocumented/partially documented aspects of CCMIO
(especially the variable naming scheme) may appear.

It seems the CCMIO library is distributed by SIEMENS to its clients upon demand,
but it does not have a clear licencing scheme, so cannot be re-distributed
direclty by the code_saturne development team. Also, the most recent
version tested is 2.0.23.

<table>
<tr><td> Default extension <td> `.ccm`
<tr><td> File type         <td> binary file based on modified ADF library
<tr><td> Surface elements  <td> polygons
<tr><td> Volume elements   <td> polyhedra
<tr><td> Zone selection    <td> named face and cell sets (interpreted as numbered
                                groups, with name association in Preprocessor log)
<tr><td> Compatibility     <td> all files of this type? unsure.
<tr><td> Documentation     <td> documentation and source code provided by CD-Adapco
</table>

Mesh formats supported for output {#sec_formats_out}
---------------------------------

### ParaView/Catalyst {#sec_fmtdesc_catalyst}
<!-- -->

This is not a "true" output format in the sense that output is not written
directly to file, but is exported to the
[Catalyst](https://www.paraview.org/in-situ/) co-processor.
In turn, this co-processor will execute operations based on a
special [ParaView](https://www.paraview.org) Python script, and directly generate
output such as images or movies.

Co-processing scripts may be generated under ParaView 4.2 or above, using initial
output in another format (such as EnSight Gold). With ParaView 4.2 to 5.4,
this required activating the CoProcessing plugin. With ParaView 5.5 and above,
a "Generate Script" item can be found directly under the "Catalyst"
menubar item.

A code_saturne postprocessing writer will try to read a script named
`<writer_name>.py`, which should be placed in a case's `DATA` directory.
Using ParaView 5.5 or above, the root node (input) of the visualization
pipeline should be renamed to that of the code_saturne writer so
that the generated script can reference the input.

Note that this output is heavily dependent on ParaView.
Some operations may work very well, while other,
similar operations may fail.

<table>
<tr><td> Default extension <td> not applicable
<tr><td> File type         <td> co-processing
<tr><td> Surface elements  <td> triangles, quadrangles, simple polygons
<tr><td> Volume elements   <td> tetrahedra, pyramids, prisms, hexahedra, simple polyhedra
<tr><td> compatibility     <td> Catalyst from [ParaView](http://paraview.org) 4.2
                                or above (version 5.5 or above recommended)
<tr><td> Documentation     <td> on-line documentation,
                                [Kitware Wiki](http://paraview.org/Wiki/Main_Page), and
                                [code_saturne Wiki](https://github.com/code-saturne/code_saturne/wiki/In-situ-postprocessing-with-ParaView-Catalyst)
<tr><td> Parallel IO       <td> based on ParaView
</table>

Meshing tools an associated formats {#sec_mesh_tool_formats}
-----------------------------------

Most often, the choice of a mesh format is linked to the choice of
a meshing tool. Still, some tools allow exporting a mesh under several
formats handled by code_saturne. This is the case of FLUENT for example,
which can export meshes to both the I-deas universal and CGNS formats.

Traditionally, users exported files to the I-deas universal format,
but it does not handle pyramid elements, which are often used by these
tools to transition from hexahedral to tetrahedral cells in the case
of hybrid meshes. The user is encouraged to export to CGNS, which
does not have this limitation.

Tools related to the [__SALOME platform__](http://www.salome-platform.org/)
should preferably use SALOME's native MED format.
