from rtslib_fb import root
from rtslib_fb.utils import RTSLibError

__author__ = 'Paul Cuzner, Michael Christie'


class LIO(object):

    def __init__(self):
        self.lio_root = root.RTSRoot()
        self.error = False
        self.error_msg = ''
        self.changed = False

    def drop_lun_maps(self, config, update_config):

        disks_config = config.config['disks']
        backstore_object_names = [disk['backstore_object_name'] for _, disk in
                                  disks_config.items()]

        for stg_object in self.lio_root.storage_objects:

            if stg_object.name in backstore_object_names:

                # this is an rbd device that's in the config object,
                # so remove it
                try:
                    stg_object.delete()
                except RTSLibError as err:
                    self.error = True
                    self.error_msg = err
                else:
                    self.changed = True

                    if update_config:
                        # update the disk item to remove the wwn info
                        image_metadata = [disk for _, disk in config.config['disks'].items()
                                          if disk['backstore_object_name'] == stg_object.name][0]
                        image_metadata['wwn'] = ''
                        config.update_item("disks",
                                           stg_object.name,
                                           image_metadata)


class Gateway(LIO):

    def __init__(self, config_object):
        LIO.__init__(self)

        self.config = config_object

    def session_count(self):
        return len(list(self.lio_root.sessions))

    def drop_target(self, this_host):
        if this_host in self.config.config['gateways']:

            lio_root = root.RTSRoot()
            for tgt in lio_root.targets:
                if tgt.wwn in self.config.config['targets'] \
                        and this_host in self.config.config['targets'][tgt.wwn]['portals']:
                    tgt.delete()
                    self.changed = True
