/*	Copyright (C) 2018-2024 Martin Guy <martinwguy@gmail.com>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* audio.h - declarations for audio.c */

/* What the audio subsystem is doing:
 * STOPPED means it has reached the end of the piece and stopped automatically
 * PLAYING means it should be playing audio,
 * PAUSED  means we've paused it or it hasn't started playing yet
 */
#ifndef AUDIO_H
#define AUDIO_H 1

#include "a_file.h"

enum playing { STOPPED, PLAYING, PAUSED };
extern enum playing playing;

extern void audio_init(audio_file_t *audio_file, char *filename);
extern void audio_deinit(void);
extern void pause_audio(void);
extern void start_playing(void);
extern void stop_playing(void);
extern void continue_playing(void);
extern void set_playing_time(secs_t when);
extern void set_real_start_time(secs_t when);
extern secs_t get_playing_time(void);
extern secs_t get_audio_players_time(void);
extern void audio_set_softvol(double new);

#endif
