libonvif
========

A client side implementation of the ONVIF specification for Linux, Mac and Windows. Included are two tools for communicating with cameras, a command line program, onvif-util, and a program with a Graphical User Interface, onvi-gui.

&nbsp;

<!---
<table>
  <tr><td><image src="onvif-gui/onvif_gui/resources/onvif-gui.png"></td><td><h2>Onvif GUI</h2><br>Featuring<br><a href="https://github.com/Megvii-BaseDetection/YOLOX"><image src="assets/images/logo.png"  width="200"></a></td></tr>
<table>
--->

<image src="assets/images/header.png">

&nbsp;

## Introduction

<details>
<summary>Description</summary>
&nbsp;

Onvif GUI is an integrated camera management system with an intuitive user interface that can be easily installed and configured on a wide variety of hardware, including Windows, Mac and Linux. Built in AI can accurately detect objects of interest and raise alarms to alert users and start recording high resolution streams to disk for archive.

The system is designed to scale with available hardware and will run on simple configurations as well as high end systems for maximum performance. Onvif GUI can be arranged in a client server configuration where a host computer can manage connections to a group of cameras which are isolated from the rest of the network for improved security. Any number of client computers can then be used to observe the streams and receive alarms generated by the server. In such a scenario, the compute load is concentrated on the server, and lower powered computers can be used as observation stations.

The system has integrated OpenVINO support for AI analysis on iGPU Intel hardware. It also will support Apple Silicon NPU AI, enabling high performance in low power environments. This allows users to select the level of hardware appropriate for their application. Apple M4 Mac Mini makes an excellent choice for low to medium power configurations such as a server managing 12 cameras, for example. Intel Ultra Core series chips are also an excellent choice for a Windows based server managing a similar load. For maximum performance, a Linux server equipped with an NVIDIA GPU can be utilized to process data from a large fleet of cameras. 

The system can be configured with auto start settings and a user friendly icon so that non-technical users can feel comfortable working with the application without specialized training. File management is easy with an automated disk space manager and file playback controls. Multiple camera streams can be viewed in the display with a double click action to open a pop up window for displaying a high resolution stream for detailed viewing. Groups of cameras can be bundled together in different windows for display on multiple monitors from a single host computer.

---

&nbsp;

</details>

<details>
<summary>Screenshot</summary>
&nbsp;

Here is the application running 12 cameras on an Intel NUC with an i7 1360P acting as a host with the yolox detector using OpenVINO on the iGPU in Linux. The application has been configured to display the low resolution camera substreams in the main display on the right and the secondary window on the lower left is showing the high resolution display for a single camera as selected by double clicking the main display on the camera of interest. On the upper left is a separate system monitor application showing the compute load.

&nbsp;

<image src="assets/images/screenshot.png">

&nbsp;

The equivalent configuration on the base model Mac Mini M4

<image src="assets/images/screenshot_mac.png">

&nbsp;

And the same for Windows on an Intel Core Ultra 9 185H

<image src="assets/images/screenshot_win.png">

&nbsp;

---

&nbsp;

</details>

<details>
<summary>Recommended Configuration</summary>

&nbsp;

For maximum performance, the client-server configuration is recommended. In this configuration, Onvif GUI uses [MediaMTX](https://github.com/bluenviron/mediamtx) as a proxy server that will buffer the camera streams, providing a consistent low latency interface to the rest of the network. Additionally, this configuration isolates the cameras, blocking all traffic between the cameras and the internet. Isolating cameras on a private subnet may require installing a DHCP server on the Onvif GUI host for ip address assignments. Additionally, the Onvif GUI host can be configured as a file server using Samba or NFS so that clients have access to camera recordings as well. Please refer to the Notes section of this document for details on these additional configurations.

&nbsp;

<image src="assets/images/net_config.png" width="640">

&nbsp;

It is not recommended to use a wireless connection for the server interface in most instances. Wireless cameras are not recommended. A 1 Gb network interface on the server should be sufficient to host a reasonable number of cameras. Wired network connections will result in a more stable and performant experience than wireless connections. Wireless connection stability can also vary widely depending on hardware and drivers. Recent Apple Silicon Mac computers had a noticeably better WiFi experience and are recommended if a wireless connection is required. 

Mac computers with recent M4 chips provide excellent performance. If driving multiple monitors using high resolution streams is a system requirement, the Mac Mini M4 offers high performance with low power consumption, low noise and great value.

Linux computers with a discrete GPU offer very good performance. GPU cards with PCIe 4 compatibility will outperform those designed for PCIe 3. GPU cards with 16 PCIe lanes will outperform those with only 8 lanes. A Linux computer with an integrated GPU, such as a NUC can also provide very good performance, but do have limitations. These Linux configurations are capable of driving multiple monitors but may require some patience when setting up.

Windows computers will work well, but do require more computing power to achieve similar results to Linux systems with less capable hardware. If Windows is the intended OS for either host or client, a higher powered computer will be necessary for satisfactory results. Lower powered computers will run the software but will be limited to running a few streams in low resolution.

&nbsp;

---

</details>


## Installation

<details>
<summary>Install Onvif GUI</summary>
&nbsp;

<details>
<summary>Linux</summary>

&nbsp;

---

<details>
<summary>Flatpak</summary>

&nbsp;

Download the [Flatpak installer](https://github.com/sr99622/libonvif/releases/download/v3.1.9/OnvifGUI-3.1.9.flatpak), then open a terminal and navigate to the Downloads folder. Use the following command to install.

```
flatpak install OnvifGUI-3.1.9.flatpak
```

The program can then be launched from the Applications menu. To uninstall use the command.

```
flatpak uninstall io.github.sr99622.OnvifGUI
```

---

</details>

<details>
<summary>Snap</summary>

&nbsp;

Download the [snap installer](https://github.com/sr99622/libonvif/releases/download/v3.1.9/onvif-gui_3.1.9_amd64.snap), then open a terminal and navigate to the Downloads folder. Use the following command to install.

```
sudo snap install onvif-gui_3.1.9_amd64.snap --dangerous
```

The program can then be launched from the Applications menu. In order to get audio, you need to connect the pulseaudio driver.

```
sudo snap connect onvif-gui:pulseaudio
```

If you would like to use the NPU on Intel, the driver can be installed as follows.

```
sudo snap install intel-npu-driver
sudo chown root:render /dev/accel/accel0
sudo chmod g+rw /dev/accel/accel0
sudo usermod -a -G render $USER
sudo bash -c "echo 'SUBSYSTEM==\"accel\", KERNEL==\"accel*\", GROUP=\"render\", MODE=\"0660\"' > /etc/udev/rules.d/10-intel-vpu.rules"
sudo udevadm control --reload-rules
sudo udevadm trigger --subsystem-match=accel
sudo reboot now
```

To uninstall.

```
sudo snap remove onvif-gui
```

---

</details>

<details>
<summary>General Purpose Script Installation</summary> 

&nbsp;

To install Onvif GUI, copy the following command, paste it into a terminal window and press the Enter key. The command will download a script and install the program. You will be asked to enter a sudo password. If you are installing on an Intel platform, the script will ask if you want to install the compute drivers, which are necessary for YOLO analysis on Intel iGPU. For detailed information on what the script does, please consult the Notes - Operations section of this document. The end result of the script is an icon in the system Applications that can be used to launch the program. 

```
wget https://raw.githubusercontent.com/sr99622/libonvif/refs/heads/master/assets/scripts/install-onvif-gui.py && python3 install-onvif-gui.py
```

The program can be uninstalled by using the same script with the -u flag

```
python3 install-onvif-gui.py -u
```

</details>

---

&nbsp;

</details>

<details>
<summary>Mac</summary>

&nbsp;

---

An installer is available for Apple Silicon running Mac OS version Sequoia (15).

Download the [installer](https://github.com/sr99622/libonvif/releases/download/v3.1.9/OnvifGUI-3.1.9.dmg) and open it. Drag the OnvifGUI icon into the Applications folder. Once the installation is complete, the program can then be started from the Launchpad. To uninstall the program, use Finder to go to the Applications directory, then right click over the icon and select Move to Trash.

For other Mac OS versions, please build from source.

---

&nbsp;

</details>


<details>
<summary>Windows</summary>

&nbsp;

---

An installer is available for Windows.

Download the [installer](https://github.com/sr99622/libonvif/releases/download/v3.1.9/OnvifGUI-installer-3.1.9.exe) and double click on it. You will receive a warning message from the Operating System. Follow the prompts on the screen to install the program. It can be launched from the icon found in the Applications menu. To uninstall the program, go to Settings -> Apps -> Installed Apps and find the icon, then use the three dot button on the right to select action.

---

&nbsp;

</details>

<details>
<summary>NVIDIA GPU</summary>

&nbsp;

The installers for the application are configured for iGPU usage during YOLO operation. By default, Intel processors with iGPU are supported, as well as Mac Silicon. AMD iGPU is not supported, but can run in CPU only mode. If Yolo operation is desired for systems equipped with NVIDIA GPU, an alternate installation method is required. This is due to the large size of the files required for NVIDIA operation. To use the application with NVIDIA GPU on Linux or Windows, create a python virtual environment, then

```
pip install onvif-gui openvino
```

Then follow the directions at [PyTorch](https://pytorch.org/get-started/locally/) to complete the installation based on your operating system.

To use an icon with this configuration, please consult the Build From Source instructions.

</details>

&nbsp;

</details>


<details>

<summary>Build From Source</summary>
&nbsp;

<i>Building from source on Linux or MacOS may improve compatability with some cameras and systems</i>

---

<details>
<summary>Linux</summary>

&nbsp;

<details>
<summary>Ubuntu</summary>

* ### Step 1. Install Dependencies
  ```
  sudo apt install git cmake g++ python3-pip virtualenv libxml2-dev libavdevice-dev libsdl2-dev libxcb-cursor-dev
  ```

  Note: <i>The dependency</i> ```libxcb-cursor-dev``` <i>is needed for X11 platform compatibility. It is optional for Wayland only configuration.</i> 

* ### Step 2. Clone Repository
  ```
  git clone --recurse-submodules https://github.com/sr99622/libonvif
  cd libonvif
  git submodule update --init --recursive
  ```

  Note: <i>When updating the repository, using the command</i> ```git pull --recurse-submodules``` <i>will update the submodule directories as well.</i>

* ### Step 3. Create Virtual Environment
  ```
  virtualenv env
  source env/bin/activate
  ```

  Note: <i>The instructions that follow all assume that the Python virtual environment is located in the</i> ```env``` <i>subdirectory of the</i> ```libonvif``` <i>directory, and that the environment has been activated. The commands shown are intended to be run from within the</i> ```libonvif``` <i>directory</i>

* ### Step 4. Install
  ```
  assets/scripts/compile
  ```

* ### Step 5. Launch Program
  ```
  onvif-gui
  ```

* ### Step 6. Add Icon
  ```
  sudo env/bin/onvif-gui --icon
  ```

  At this point, the program can be launched by clicking the icon in Applications. See step 8 for more instructions on running from the command line.

* ### Step 7. Add Optional Modules for YoloX

  * #### Pytorch with NVIDIA Drivers

    <b>Please Note:</b> The instructions below will install a recent generic version of PyTorch. In some cases, there may be version specific idiosyncrasies that require a specfic version of PyTorch to match the version of the NVIDIA driver, which can be ascertained using the command ```nvidia-smi```. The installation version matrix can be found at [Getting Started](https://pytorch.org/get-started/locally/).
    
    ```
    pip install torch torchvision
    ```

  * #### OpenVINO with Intel GPU & NPU drivers
    ```
    pip install torch torchvision --index-url https://download.pytorch.org/whl/cpu
    pip install openvino
    ```

    [GPU Driver Installation](https://github.com/intel/compute-runtime/releases)

    [NPU Driver Installation](https://github.com/intel/linux-npu-driver/releases)

* ### Step 8. Run onvif-gui from Command Line

  * #### Run installed version
    ```
    onvif-gui
    ```
  * #### Run from code directly
    ```
    python onvif-gui/run.py
    ```

</details>

<details>
<summary>Fedora</summary>

<details>
<summary>Fedora Version 43</summary>

* ### Step 1. Install Dependencies
  ```
  sudo dnf install cmake g++ libxml2-devel python3.13 python3.13-devel python3-pip SDL2-devel git
  sudo dnf install https://download1.rpmfusion.org/free/fedora/rpmfusion-free-release-$(rpm -E %fedora).noarch.rpm
  sudo dnf install https://download1.rpmfusion.org/nonfree/fedora/rpmfusion-nonfree-release-$(rpm -E %fedora).noarch.rpm
  sudo dnf install ffmpeg-devel --allowerasing
  ```

* ### Step 2. Clone Repository
  ```
  git clone --recurse-submodules https://github.com/sr99622/libonvif
  cd libonvif
  git submodule update --init --recursive
  ```

  Note: <i>When updating the repository, using the command</i> ```git pull --recurse-submodules``` <i>will update the submodule directories as well.</i>

* ### Step 3. Create Virtual Environment

  ```
  python3.13 -m venv env
  source env/bin/activate
  ```

  Note: <i>The instructions that follow all assume that the Python virtual environment is located in the</i> ```env``` <i>subdirectory of the</i> ```libonvif``` <i>directory, and that the environment has been activated. The commands shown are intended to be run from within the</i> ```libonvif``` <i>directory</i>

* ### Step 4. Install
  ```
  assets/scripts/compile
  ```

* ### Step 5. Launch Program
  ```
  onvif-gui
  ```

* ### Step 6. Add Icon
  ```
  sudo env/bin/onvif-gui --icon
  ```

  At this point, the program can be launched by clicking the icon in Applications. See step 8 for more instructions on running from the command line.

* ### Step 7. Add Optional Modules for YoloX

  * #### Pytorch with NVIDIA Drivers

    <b>Please Note:</b> The instructions below will install a recent generic version of PyTorch. In some cases, there may be version specific idiosyncrasies that require a specfic version of PyTorch to match the version of the NVIDIA driver, which can be ascertained using the command ```nvidia-smi```. The installation version matrix can be found at [Getting Started](https://pytorch.org/get-started/locally/).
    
    ```
    pip install torch torchvision
    ```

  * #### OpenVINO with Intel GPU drivers
    ```
    pip install torch torchvision --index-url https://download.pytorch.org/whl/cpu
    pip install openvino
    sudo dnf install intel-compute-runtime
    ```

  A reboot after installing these libraries may avoid a crash on the initial run of the program with Yolo enabled.

* ### Step 8. Run onvif-gui from Command Line

  * #### Run installed version
    ```
    onvif-gui
    ```
  * #### Run from code directly
    ```
    python onvif-gui/run.py
    ```
</details>

<details>
<summary>Fedora Version 42 and Earlier</summary>

* ### Step 1. Install Dependencies
  ```
  sudo dnf install cmake g++ libxml2-devel python3-devel python3-pip SDL2-devel virtualenv git
  sudo dnf install https://download1.rpmfusion.org/free/fedora/rpmfusion-free-release-$(rpm -E %fedora).noarch.rpm
  sudo dnf install https://download1.rpmfusion.org/nonfree/fedora/rpmfusion-nonfree-release-$(rpm -E %fedora).noarch.rpm
  sudo dnf install ffmpeg-devel --allowerasing
  ```

* ### Step 2. Clone Repository
  ```
  git clone --recurse-submodules https://github.com/sr99622/libonvif
  cd libonvif
  git submodule update --init --recursive
  ```

  Note: <i>When updating the repository, using the command</i> ```git pull --recurse-submodules``` <i>will update the submodule directories as well.</i>

* ### Step 3. Create Virtual Environment
  ```
  python -m venv env
  source env/bin/activate
  ```

  Note: <i>The instructions that follow all assume that the Python virtual environment is located in the</i> ```env``` <i>subdirectory of the</i> ```libonvif``` <i>directory, and that the environment has been activated. The commands shown are intended to be run from within the</i> ```libonvif``` <i>directory</i>

* ### Step 4. Install
  ```
  assets/scripts/compile
  ```

* ### Step 5. Launch Program
  ```
  onvif-gui
  ```

* ### Step 6. Add Icon
  ```
  sudo env/bin/onvif-gui --icon
  ```

  At this point, the program can be launched by clicking the icon in Applications. See step 8 for more instructions on running from the command line.

* ### Step 7. Add Optional Modules for YoloX

  * #### Pytorch with NVIDIA Drivers

    <b>Please Note:</b> The instructions below will install a recent generic version of PyTorch. In some cases, there may be version specific idiosyncrasies that require a specfic version of PyTorch to match the version of the NVIDIA driver, which can be ascertained using the command ```nvidia-smi```. The installation version matrix can be found at [Getting Started](https://pytorch.org/get-started/locally/).
    
    ```
    pip install torch torchvision
    ```

  * #### OpenVINO with Intel GPU drivers
    ```
    pip install torch torchvision --index-url https://download.pytorch.org/whl/cpu
    pip install openvino
    sudo dnf install intel-compute-runtime
    ```

  A reboot after installing these libraries may avoid a crash on the initial run of the program with Yolo enabled.

* ### Step 8. Run onvif-gui from Command Line

  * #### Run installed version
    ```
    onvif-gui
    ```
  * #### Run from code directly
    ```
    python onvif-gui/run.py
    ```
</details>

&nbsp;

</details>

<details>
<summary>Manjaro</summary>

* ### Step 1. Install Dependencies
  ```
  sudo pacman -S cmake base-devel ffmpeg
  ```

* ### Step 2. Clone Repository
  ```
  git clone --recurse-submodules https://github.com/sr99622/libonvif
  cd libonvif
  git submodule update --init --recursive
  ```

  Note: <i>When updating the repository, using the command</i> ```git pull --recurse-submodules``` <i>will update the submodule directories as well.</i>

* ### Step 3. Create Virtual Environment
  ```
  python -m venv env
  source env/bin/activate
  ```

  Note: <i>The instructions that follow all assume that the Python virtual environment is located in the</i> ```env``` <i>subdirectory of the</i> ```libonvif``` <i>directory, and that the environment has been activated. The commands shown are intended to be run from within the</i> ```libonvif``` <i>directory</i>

* ### Step 4. Install
  ```
  assets/scripts/compile
  ```

* ### Step 5. Launch Program
  ```
  onvif-gui
  ```

* ### Step 6. Add Icon
  ```
  sudo env/bin/onvif-gui --icon
  ```

  At this point, the program can be launched by clicking the icon in Applications. See step 8 for more instructions on running from the command line. 

* ### Step 7. Add Optional Modules for YoloX

  * ### Pytorch with NVIDIA Drivers

    <b>Please Note:</b> The instructions below will install a recent generic version of PyTorch. In some cases, there may be version specific idiosyncrasies that require a specfic version of PyTorch to match the version of the NVIDIA driver, which can be ascertained using the command ```nvidia-smi```. The installation version matrix can be found at [Getting Started](https://pytorch.org/get-started/locally/).
    
    ```
    pip install torch torchvision
    ```

  * ### OpenVINO with Intel GPU drivers
    ```
    pip install torch torchvision --index-url https://download.pytorch.org/whl/cpu
    pip install openvino
    sudo pacman -S intel-compute-runtime
    ```

* ### Step 8. Run onvif-gui from Command Line

  * #### Run installed version
    ```
    onvif-gui
    ```
  * #### Run from code directly
    ```
    python onvif-gui/run.py
    ```


</details>

---

</details>

<details>
<summary>Mac</summary>

* ### Step 1. Install Homebrew

  Please refer to the [Homebrew Installation Instructions](https://brew.sh/).

* ### Step 2. Install Dependencies

  ```
  brew update
  brew upgrade
  brew install python
  brew install cmake
  brew install git
  brew tap homebrew-ffmpeg/ffmpeg
  brew install homebrew-ffmpeg/ffmpeg/ffmpeg
  ```

  <i>  Please note that the standard Homebrew core ffmpeg version is incompatible with onvif-gui. For this reason, the install procedure calls for the 3rd party tap [homebrew-ffmpeg](https://github.com/homebrew-ffmpeg/homebrew-ffmpeg). <b>If you already have another version of ffmpeg installed, this will create a conflict.</b> In order to install this version, it is necessary to run </i>```brew uninstall ffmpeg``` <i>before this tap can be installed.</i>

* ### Step 3. Create Virtual Environment

  <i> Homebrew will install the latest version of python. You can see the version installed using the command</i> `brew list python`.<i> Use the full python name with version to build the virtual environment</i>

  ```
  python3.13 -m venv onvif-gui-env
  source activate onvif-gui-env
  ```

* ### Step 4. Clone Repository

  ```
  git clone --recurse-submodules https://github.com/sr99622/libonvif
  cd libonvif
  git submodule update --init --recursive
  ```

* ### Step 5. Compile

  ```
  assets/scripts/compile
  ```

* ### Step 6. Launch Program

  ```
  onvif-gui
  ```

* ### Optional Step For Server Configuration

  To increase the number of socket connections available for the server, use the ulimit command to raise the file limit.

  ```
  ulimit -n 8192
  ```

  You can add this command to your shell resource file, e.g. .zshrc in the user home directory. This will then set the limit for each terminal session as it is opened on a persistent basis.

---

</details>

<details>
<summary>Windows</summary>
&nbsp;

In order to build from source on Windows, development tools and python are required. Please follow the instructions for installing [Visual Studio](https://visualstudio.microsoft.com/), [cmake](https://cmake.org/download/), [git](https://git-scm.com/download/win) and [python](https://www.python.org/downloads/windows/). When installing Visual Studio, select the desktop C++ development libraries to get the compiler.

* ### Step 1. Go to Home Directory

  ```
  cd %HOMEPATH%
  ```

* ### Step 2. Create Virtual Environment

  ```
  python -m venv onvif-gui-env
  onvif-gui-env\Scripts\activate
  ```
* ### Step 3. Clone Dependencies

  ```
  git clone https://github.com/sr99622/onvif-gui-win-libs
  ```

* ### Step 4. Clone Repository

  ```
  git clone --recurse-submodules https://github.com/sr99622/libonvif
  cd libonvif
  git submodule update --init --recursive
  ```

* ### Step 5. Set Environment Variables

  ```
  assets\scripts\components\windows\env_variables
  ```

* ### Step 6. Copy Run Time Libs to Install Path

  ```
  assets\scripts\components\windows\copy_libs
  ```

* ### Step 7. Install

  ```
  assets\scripts\compile
  ```

* ### Step 8. Launch Program

  ```
  python onvif-gui\run.py
  ```

</details>

---

&nbsp;

</details>

<details><summary>Firewall Rules</summary>

&nbsp;

Onvif GUI requires network access to communicate with cameras in Stand Alone or Server mode. If the host computer uses a firewall, it may be necessary to enable some communciations ports so that cameras can use the WS-Discovery protocol to announce their presence to the program.

Some Distributions come with ```firewalld``` pre-installed and configured. These commands will work with firewalld and present a common operation that other firewalls will implement in a similar fashion.

The firewalld package in some distributions includes pre-defined services for WS-Discovery which might manage this port automatically. If the service definition exists on your system, you can use the simpler command: 

```
sudo firewall-cmd --permanent --zone=public --add-service=ws-discovery-client
sudo firewall-cmd --reload
```

You can check for available WS-Discovery services with:

```
firewall-cmd --get-services | grep ws-discovery
```

To configure the service manually in the event that it is not included in the firewall services package.

To allow inbound traffic with a specific source port (source-port) in firewalld, you must use a rich rule. Standard port rules in firewalld filter traffic based on the destination port, so a more specific rule is needed to inspect the source port. The common use case for source port 3702/UDP is for WS-Discovery (Web Services Dynamic Discovery) protocols. 

Command to Allow Inbound Source Port 3702 

Run the following commands in your terminal to allow inbound UDP traffic from source port 3702 permanently: Add a rich rule to the desired zone (e.g., public) that accepts traffic where the source port is 3702.


```
sudo firewall-cmd --permanent --zone=public --add-rich-rule='rule family="ipv4" source-port port="3702" protocol="udp" accept'
sudo firewall-cmd --reload
```

```
sudo firewall-cmd --zone=public --list-rich-rules
```

The output should include the rule you just added. 

Onvif GUI in server configuration also requires ports to be opened for Onvif, RTSP and HTTP servers. The following commands should achieve this

```
sudo firewall-cmd --permanent --add-port=8554/tcp
sudo firewall-cmd --permanent --add-port=8550/tcp
sudo firewall-cmd --permanent --add-port=8800/tcp
sudo firewall-cmd --reload
```

For client configuration to be able to listen for alarms from the server, open port 8080 on the multicast address 239.255.255.247 using rich rule

```
sudo firewall-cmd --permanent --zone=public --add-rich-rule='rule family="ipv4" destination address="239.255.255.247" port port="8080" protocol="udp" accept'
sudo firewall-cmd --reload
```

</details>

</details>

## Operation

<details>
<summary>Getting Started</summary>

&nbsp;

<image src="onvif-gui/onvif_gui/resources/discover.png">

Discover

To get started, click the Discover button. A login screen will appear for each camera as it is found. The Settings tab may be used to set a default login that can be used to automatically submit login credentials to cameras. There is also an Auto Discover check box on the Settings panel.

Initially, cameras will populate the list using the default name provided by the manufacturer. To change the camera name, use the F2 key, or the right click context menu over the camera list.

<image src="onvif-gui/onvif_gui/resources/play.png">

Play

Upon completion of discovery, the camera list will be populated. A single click on a camera in the list will display the camera parameters in the lower part of the tab. Double clicking will start the camera output stream. The camera stream may also be started by clicking the play button or by typing the enter key while a camera is highlighted in the list.

Multiple cameras can stream simultaneously. The application will add camera output to the display for each camera as it is started. The controls for camera operations apply to the current camera, which is the highlighted camera in the list on the camera panel. The current camera will have a thin white border around it in the display.

Network conditions, compute load or internal camera issues may cause buffer overflow in the application pipeline. The result may be that packets are dropped, which can degrade the quality of the stream. If packets are being dropped, the camera display will show a yellow border.

<image src="onvif-gui/onvif_gui/resources/play_all.png">

Play All

The play action can be applied to all cameras simultaneously.

<image src="onvif-gui/onvif_gui/resources/stop.png">

Stop

When the camera stream is running, the play button for that camera will change appearance to the stop icon. Clicking the button will stop the stream.  The stream can also be stopped from the camera list by double clicking or typing the enter key.

<image src="onvif-gui/onvif_gui/resources/stop_all.png">

Stop All

The stop action can be applied to all cameras simultaneously.

<image src="onvif-gui/onvif_gui/resources/record.png">

Record

Recording can be initiated manually by clicking the record button. The file name is generated automatically and is based on the start time of the recording in date format as YYYYMMDDmmSS.mp4. The Archive Directory setting will determine the location of the file. A subdirectory is created for each camera to help organize files within the archive.

During manually initiated recording, a rotating red colored tick mark will show in the lower right corner of the stream display. The Record Button on the Camera Panel will show red during all recording operations. Note that recording initiated automatically during Alarm conditions or Record Always will disable the Record Button. 

Files created by the application are limited in length to 15 minutes. Recordings that require a longer time will be broken up into several parts that are each 15 minutes long. There will be a slight overlap between files broken up this way corresponding to the length of the Pre Record Buffer setting.

<image src="onvif-gui/onvif_gui/resources/history.png">

File Operations

Picture and Video files generated by the system can be viewed and managed with a built in file browser. See the File Operations section of this document for more details.

<image src="onvif-gui/onvif_gui/resources/snapshot.png">

Snapshot

A snapshot of the currently selected camera cna be saved as jpg file. The snapshot will be named by the system using YYYYMMMDDHHmmSS.jpg format, unless otherwise specified in the file save dialog. The file save dialog can be suppressed using the checkbox labelled "Snapshot File Dlg" on the Settings->General tab. There are two modes under which files may be saved, Local and Remote. The Local mode will use the stream currently displayed and convert that to a picture format. This mode will preserve the aspect ratio of the stream and any artifacts such as AI boxes drawn on the image. The Remote mode will address the camera directly through the network and request a snapshot of the Record Profile for the camera. This will generally be a higher resolution image and may be subject to latency or camera network errors. In the event that the camera fails to deliver the image, the Local mode will be used as a fallback.

<image src="onvif-gui/onvif_gui/resources/apply.png">

Apply

Camera parameters are available on the tabs on the lower right side of the application. Initially, the Apply button will be disabled with a dimmed icon. Once a parameter has been changed, the Apply button will be enabled, which can be used to commit the change to the camera. The camera may re-start the stream in order to make the changes.

<image src="onvif-gui/onvif_gui/resources/full_screen.png">

Full Screen

Toggle the application between full screen and normal mode.

<image src="onvif-gui/onvif_gui/resources/audio.png">

Mute

Camera audio can be controlled from the panel. The mute button can be clicked to mute the audio. The mute button appearance indicates the state of the audio. The volume slider can be used to control the volume. Note that the mute and volume controls are applied to each camera individually.

<image src="onvif-gui/onvif_gui/resources/help.png">

Help

Opens the system web browser to this page.

<h2>Keyboard Bindings</h2>

Many of the above functions can be executed without using the mouse via keyboard bindings. Below is a list of the bindings

<b>Enter</b>

This will start the currently selected camera. If the camera is already running, the Focus window will show with the high resolution camera stream. Please note that the first time the Focus window launches, the application focus will transfer to that window.

<b>Escape</b>

If the Focus window is visible, the Escape key will hide it. If Focus window is not visible, the camera stream is stopped.

<b>Ctl+D</b>

Start Discovery

<b>Ctl+A</b>

Start/Stop all cameras

<b>Ctl+F</b>

Open the File Browser

<b>Ctl+S</b>

Take a snapshot for the currently selected camera if running

<b>Ctl+R</b>

Toggle recording for the currently selected camera if running

<b>F1</b>

Show stream information for a running camera

<b>F2</b>

Rename the currently selected camera

<b>Delete</b>

Remove the currently selected camera from the list. This will remove the camera from the Cached Addresses for discovery. Use broadcast discovery to re-enlist the camera.



---
&nbsp;
</details>

<details>
<summary>Camera Parameters</summary>
&nbsp;

<i>Changes are committed to the camera by using the Apply button, if necessary.</i>

---

<details>
<summary>Media</summary>

&nbsp;

<image src="assets/images/media_tab.png" width="400"/>

&nbsp;

* ### W x H (Resolution)

    Camera resolution is adjusted using the combo box which has available settings. To change the camera resolution, make a selection from the combo box and then click the apply button. The camera may re-start the video stream in order to effect the change.

* ### Aspect

    When using substreams, the aspect ratio may be distorted. Changing the aspect ratio by using the combo box can restore the correct appearance of the video. If the aspect ratio has been changed this way, the label of the box will have a * appended. This setting is not native to the camera, so it is not necessary to click the apply button for this change.

* ### FPS

    Frame rate of the camera can be adjusted using the spin box. The change is made on the camera when the apply button is clicked. Higher frame rates will have a better appearance with smoother motion at the expense of increased compute load.

* ### GOP

    Keyframe interval of the video stream. Keyframes are a full frame encoding, whereas intermediate frames are differential representations of the changes between frames.  Keyframes are larger and require more computing power to process. Higher GOP intervals mean fewer keyframes and as a  result, less accurate representation of the video.  Lower GOP rates increase the accuracy of the  video at the expense of higher bandwidth and compute load. It is necessary to click the Apply button to enact these changes on the camera.

    Note that some cameras may have an option for Dynamic GOP or Adaptive Framerate, or some other name for a process that reduces the GOP automatically based on the lack of motion in the camera view. It is advised to turn this feature off when using onvif-gui. To access the feature, use the camera web application from the System Tab -> Browser button.

* ### Bitrate

    The bitrate of the video stream. Higher bitrates increase the quality of the video appearance at the expense of larger file sizes. This is most relevant when maintaining recordings of videos on the host file system. Bitrates are generally expressed in kbps by cameras, but may be inaccurate or scaled differently.  Use the Apply button after changing this setting to enact the change on the camera.

* ### Profile

    Most cameras are capable of producing multiple media streams. This feature can be useful when running many cameras on the same computer or if a compute intensive task is being run on a stream. The default stream of the camera is called the Main Stream. A secondary stream running at lower settings is called the Sub Stream. The application uses the terms Display Profile and Record Profile to describe these settings.

    Initially, the Main Stream is selected by default as both the Display Profile and the Record Profile. By changing the selection to a secondary profile on the Media Tab, a lower order Sub Stream can be displayed. The term lower order implies that the Sub Stream has lower resolution, lower frame rate and lower bitrate than the Main Stream. Note that the application may be processing both streams, but only the Display Profile selected on the Video Tab is displayed. The other stream, referred to as the Record Stream, is not decoded, but its packets are collected for writing to disk storage.

    The display will update automatically when the Video Tab Profile combo box is changed, so it is not necessary to click the Apply button when changing this setting.

* ### No Audio

    Audio can be disabled by selecting this check box. This is different than mute in the sense that under mute, the audio stream is decoded, but not played on the computer speakers. If the No Audio check box is selected, the audio stream is discarded. If the No Audio checkbox is deselected, the stream will restart in order to initialize the audio. The Apply button is not clicked when changing this parameter. This checkbox is selected by default.

    <b>** Please Note **</b> If the audio is enabled by deselecting this check box, and there is no physical audio device connected to the computer, there may be issues with stream processing. If an Audio Driver is specified on the Settings -> General panel such as pulseaudio, there should be a physical audio device such as headphones, speakers or HDMI connected to the host computer. Without a physical device, it may be possible in some cases for the audio driver to enter an undefined state which may cause the camera stream to stutter or freeze and may lead to lengthy timeouts when closing the camera stream. If there is no physical device available, the Audio Driver can be changed to dummy in order to avoid this problem. This condition applies only to camera streams which are displayed to the user interface. The Record Stream, if different than the Display Stream, is hidden and is not affected by this condition.

* ### Audio

    The audio encoder used by the camera is set here.  If the camera does not have audio capability, the audio section will be disabled. Note that some cameras may have audio capability, but the stream is not available due to configuration issues or lack of hardware accessories.  Available audio encoders will be shown in the combo box and may be set by the user. Changes to the audio parameter require that the Apply button is clicked to enact the change on the camera.
    
    AAC encoding is a higher quality stream and are recommended for recording. G711 style encoders are good for low latency playback if real time operation is important. Streams using AAC encoding map to mp4 file format and G711 uses mov. Note that some cameras have incorrect implementations for encoders and the audio may not be usable in the stream recording to disk. Please be aware that currently onvif-gui is unable to process G726.

* ### Samples

    Available sample sizes are shown in the combo box. Use the Apply button to enact the change on the camera.  Higher sample sizes increase the quality of the audio at the expense of higher bandwidth and disk space when recording. Lower sample sizes correlate to lower latency. The audio bitrate is implied by the sample size based on encoder parameters.

* ### Video Alarm

    This check box enables video analytic processing for alarm generation. See the section on Video Panel for reference to video alarm functions.  Note that the Video Alarm check box must be selected in order to enable the Video Panel for that camera. The Apply button is not used for this setting. During Alarm condition, a solid red circle will show in the stream display if not recording, or a blinking red circle if the stream is being recorded.

* ### Audio Alarm
 
    This check box enables audio analytic processing for alarm generation. See the section on Audio Panel for reference to audio alarm functions.  Note that the Audio Alarm check box must be selected in order to enable the Audio Panel for that camera. The Apply button is not used for this box. During Alarm condition, a solid red circle will show in the stream display if not recording, or a blinking red circle if the stream is being recorded.


</details>

<details>
<summary>Image</summary>

&nbsp;

<image src="assets/images/image_tab.png" width="400"/>

&nbsp;

The sliders control various parameters of the video quality.  The Apply button must be clicked after changing the setting to enact the change on the camera.

</details>

<details>
<summary>Network</summary>

&nbsp;

<image src="assets/images/network_tab.png" width="400"/>

&nbsp;

If the DHCP is enabled, all fields are set by the server, if DHCP is disabled, other network settings may be completed manually. Note that IP setting changes may cause the camera to be inaccessible if using cached addresses. Use the Discover button to find the camera, or enter the new address manually from the settings panel.

Take care when changing these settings, the program does not check for errors and it maybe possible to set the camera into an unreachable configuration. 

The Apply button must be clicked to enact any of these changes on the camera.

---

</details>

<details>
<summary>PTZ</summary>

&nbsp;

<image src="assets/images/ptz_tab.png" width="400"/>

&nbsp;

Settings pertain to preset selections or current camera position. The arrow buttons, Zoom In (+) and Zoom Out (-) control the position and zoom. The numbered buttons on the left correspond to preset positions. Clicking one of the numbered buttons will send the camera to the corresponding preset position. To set a preset, position the camera, then check Set Preset, then click the numbered preset button. It is not necessary to use the Apply button with any of the settings on this panel.

---

</details>

<details>
<summary>System</summary>

&nbsp;

<image src="assets/images/system_tab.png" width="400"/>

&nbsp;

* ### Recording

    The check box at the top of the Record group box will enable automatic recording of camera streams when selected. The Record Profile combo box below will select the camera profile to be recorded.
    
    If the Record Alarms radio button is selected, the application will record automatically during alarm condition. While the stream is being recorded during alarm condition, there will be a blinking red circle in the lower right corner of the stream display. File sizes are limited to 15 minute lengths, so multiple files will be created if the alarm condition lasts longer than this limit.

    Selecting the Record Always radio button will cause the application to record the camera at all times that it is streaming. The files are written to disk in 15 minute file lengths, and are named in a time format representing the start time of the recording. Unlike other recording modes, the Record Always condition does not display an indicator in the stream display.

    It not necessary to use the Apply button for any of the settings on this panel.

* ### Alarm Sounds

    The check box at the top of the Sounds group box will enable alarm sounds on the computer speaker when checked.  If the Loop radio button is selected, the sound will play continuously during an alarm condition.  Selection of the Once radio button will cause the application to play the alarm sound once per alarm condition.

* ### Record Profile

    The drop down box can be used to the select the camera profile that will be recorded to disk. The Record Profile can be different than the Display Profile shown in the application. This setting can be used most effectively when the application is configured to show the low resolution substream profile in the display, and use the high resolution main profile as the recording source. This enables the application to maintain real time display status, especially with multiple streams, while preserving high resolution accuracy in the recorded stream. Because the recorded stream in not decoded, but rather is piped directly from the camera to disk, the high resolution recording presents very little compute load on the host.

* ### Record Audio

    In many cases, the audio of the Display Profile will be disabled. By default, audio is disabled for camera streams. This is particulaly relevant when displaying multiple streams, as the audio from multiple cameras playing simultaneously may cause confusion. This checkbox allows the display audio to be disabled while preserving audio on the recorded stream.  

* ### Remote Snapshot Image

  By default, this option is disabled, which means that the system will use the currently playing camera display stream as the source for snapshot images. If the display stream is a low resolution stream, the snapshot will also be the same low resolution. If the Yolo detector is running and the Show Alarms on Display is enabled from Settings -> Alarms, detection boxes shown on the stream will be present on the snapshot image. This may be useful behavior when initially configuring the system when false positive detections are occurring, as the detection boxes will show the origin of the alarm.

  If a high resolution snapshot image is desired, this might be possible depending on the camera capabilities. Most, but not all cameras will expose a high resolution still image source available over the network. Some cameras will provide this capability in the spec, but in practice the image may not be usable. Experimentation is required to determine if the camera output is acceptable. In the event that the camera fails to deliver the image during runtime, the system will fall back to stream image capture. 

* ### Reboot

    Click to reboot the camera.

* ### Browser

    This will launch the web browser and connect to the camera.  Cameras will have a web interface that can be used to set parameters that are not available to the application.

* ### Sync Time

    Clicking the Sync Time button will bring up a dialog box with time settings options for the camera.

    &nbsp;

    <image src="assets/images/sync_time.png" width="640">

    &nbsp;

    At the top of the dialog are boxes showing the current settings for computer time and camera time respectively. The camera time is calculated based on the time offset parameter used by the computer for authentication. This time should, but may not necessarily, closely match the time displayed by the camera in the video stream. Variations in how cameras compute time may result in an offset mismatch between the time displayed in the camera video stream and the computed time shown on the dialog.

    The Time Zone and Daylight Savings Time fields can be edited by the user and set in the camera for configuration. 
    
    The Time Zone format can vary and different cameras will accept different formats. The long format shown in the example resembles POSIX standard and is the most comprehensive format which includes time offset from UTC and DST offset with DST start and finish parameters. Most cameras do not conform entirely to this standard, but may accept the string while selectively ignoring portions of the configuration. The most widely accepted form is UTC format or alternately, GMT format both of which have an optional +/- sign and hour plus optional minute offsets delimited by colon. Examples might be UTC0 or UTC-04:00. The GMT format is the same, but note that the polarity of the sign is reversed e.g. GMT0 or GMT+04:00. Other formats may possibly work e.g. EST5EDT, which may be worth trying.

    The Daylight Savings Time checkbox can be edited by the user, or it may be set automatically by the camera depending on the camera abilities. Not all cameras support DST, and some may save the DST flag but not act on the information when computing time.

    The Time Sync Method group box selects the time adjustment strategy used by the application.

    NTP Time setting will enable the NTP server box to allow editing. There are three types of server configuration. From DHCP will instruct the camera to use the NTP server data from the most recent DHCP configuration. This may or may not be the server data from the DHCP. In many cases, this will be a hardcoded address in the camera firmware. IPv4 address will use a numeric style IP address for the NTP server. A failure of this parameter configuration may or may not produce an error message from the camera. A Domain Name style server configuration will use a dot notation server name similar to a web address and will require proper DNS configuration for resolution. Once configured, the camera will use the Time Zone and DST information it has stored in its settings to deduce its time from the NTP server response to the camera query. In all cases, if the NTP server address is located on the internet the camera will require internet access in order to contact the server.

    Manual Time Setting will use the computer hosting the application to derive the time sent to the camera. The computer will send a UTC time to the camera and the camera will calculate its time based on the Time Zone and DST information that it has in its settings.

    UTC as Local setting is a specific type of manual setting that will force the camera into displaying the same time as the computer host. This is done by setting the camera Time Zone to UTC0 and setting the time on the camera to match the application computer host time. As UTC time is not dependent on DST, issues associated with DST can be ignored. If the computer time is accurate and regularly updated, this can be a good strategy for many cameras, as it circumvents a lot of ambiguity in time setting configurations which may be inaccurate or outdated. Note that some cameras, if connected to the internet, may eventually resort to hidden NTP settings that will reset the camera time (often incorrectly) if this strategy is employed. If a camera is using this type of NTP access, it is advisable to isolate it from the internet as a security precaution. If this is not practical or desired, the time zone and DST settings can be used such that the camera perhaps might display the correct time.

    Ultimately, there are many variations and inconsistencies when dealing with camera times. In most cases, UTC as Local with cameras isolated from the internet will provide the best results. Camera algorithms for time setting are often opaque and in many cases incomplete or incorrect. Cameras with proper time setting implementations can be set using the Time Zone and DST settings, but should be verified for accuracy and completeness, especially regarding DST. NTP use is discouraged, as cameras should be isolated from the internet as a security precaution. Using an NTP server on the internal network does not provide any advantage over Manual time setting via the application host computer.

</details>

---

&nbsp;
</details>

<details>
<summary>File Operations</summary>
&nbsp;

<i>Camera recordings can be viewed from within the application. Files can be searched for a particular moment in time. A server can share recordings using Samba so that Windows, Mac and Linux clients can view previously recorded streams from the server.</i>

<i>Snapshots generated by Yolo alarms or taken manually by the user are automatically linked to existing Video files such that activating play from the Picture panel will show the associated Video file starting at the time at which the snapshot was taken.</i>

<i>Keyboard bindings make file review effortless and responsive so that pictures and relevant videos can be searched and viewed quickly and easily.</i>

---

&nbsp;

The application maintains folders for the storage of camera snapshots and recordings. The folder locations by default are the OS picture and video storage locations, and can be changed using the directory setting at the top of the panel. There is a subfolder for each camera that has previously made pictures or recordings in the application. If you are using Onvif GUI as a client, and the server is configured to share files using Samba, you can use the server shared folder to access recordings made on the server. 

Inside the camera folders are the individual picture or video files recorded by the camera. The files are named using a datetime convention which represents the time that the snapshot images was taken or the start time of the video recording. Video recordings are prepended by a time interval specified on the Settings -> Alarm panel as Pre-Alarm Buffer Size. This insures that the moments immediately prior to the beginning of the recording are captured.

&nbsp;

<image src="assets/images/picture_panel.png" width="500">

&nbsp;

<image src="assets/images/file_panel.png" width="500">

&nbsp;

Double clicking on a picture file will start the associated video playing at the time stamp of the picture. The same action can be started using the Enter key when a picture file is highlighted. In the event that there is not video coverage for the picture timestamp, the playback will fail silently. While a video is playing, using the Escape key will return operation to picture browse mode. Using the up and down arrow keys will traverse the picture directory contents, showing each picture as the selection changes. Folders can be opened and closed using the Enter key. Right clicking over the file will bring up a context menu with various options.

File playback is configured such that one file is played at a time. Keyboard shortcuts are available for faster navigation. Video playback controls are available on either the Picture or Videos panel.

<h3>File Playback Controls For Mouse</h3>

<image src="onvif-gui/onvif_gui/resources/search.png"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <image src="onvif-gui/onvif_gui/resources/refresh.png"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <image src="onvif-gui/onvif_gui/resources/snapshot.png">

Search&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Refresh&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Snapshot

<image src="onvif-gui/onvif_gui/resources/play.png"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <image src="onvif-gui/onvif_gui/resources/pause.png"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <image src="onvif-gui/onvif_gui/resources/stop.png"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <image src="onvif-gui/onvif_gui/resources/previous.png"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <image src="onvif-gui/onvif_gui/resources/next.png"> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <image src="onvif-gui/onvif_gui/resources/audio.png">

Play&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pause&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Stop&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Prev&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Next&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mute

---

### Keyboard Shortcuts

Keyboard shortcuts are available when the file list of either the Picture Panel or the Video Panel has the application focus. A single click on any file or folder in the list will achieve this focus. Keyboard operations may be significantly faster than using the mouse when browsing through files.

* <h3>Enter</h3>

  The Enter key can be used to Play the file. Note that if another file is currently playing, it will be stopped before the new file starts.

* <h3>Space</h3>

  The space bar can be used to Pause the current file playing.
    
* <h3>Escape</h3>

  The Escape key can be used to stop the current file playing.
    
* <h3>Delete</h3>

  Files may be deleted by typing the Delete key.

* <h3>F1</h3>

  The F1 key will show a dialog with file properties.
    
* <h3>F2</h3>

  Files can be renamed using the F2 key.
    
* <h3>Right Arrow</h3>

  The Right Arrow will fast forward the file playing by 10 seconds.
    
* <h3>Left Arrow</h3>

  The Left Arrow will rewind the file playing by 10 seconds.

* <h3>Up Arrow</h3>

  The Up Arrow will move to the previous file without stopping the current file. Use the Enter key to start playing the newly highlighted file.

* <h3>Down Arrow</h3>

  The Down Arrow will move to the next file without stopping the current file. Use the Enter key to start playing the newly highlighted file.

### Progress / Seek Indicator

Both File Panels have a progress bar that will show the state of the playback. The total duration of the file is shown on the right hand side of the progress bar, and the left hand side will show the current file position which is indicated by the progress bar handle. If the mouse hovers over the bar, the position within the file will be shown above. The seek function will set the file position to the mouse location if the mouse is clicked on the progress bar. Sliding operation is not supported.

### Pop Up Menu

Right clicking over the file will bring up a context menu that can be used to perform file operations.

### Hide Camera Panel

Viewing files may be more convenient if a separate window is set up distinct from the camera display. This can be helpful if viewing archived recordings while cameras are being displayed in real time. A file view can be created from the Settings -> General tab using the three dot button in the Open New Window section. Once the file viewer is set up, the Hide Camera Panel checkbox can be selected so that only files and not cameras are shown on the file view window. Additionally, it may be helpful to expand the right side of the application to accomodate the full file parameter display tab. These settings will be preserved on the file viewer window and will not affect the default window started by the application.

### File Searching by Time

The application has the ability to search the files by camera for a particular moment in time.

&nbsp;

<image src="assets/images/file_search.png">

&nbsp;

The search dialog is launched by clicking the search icon on the File panel. Use the dialog box to select a Camera, Date and Time and the application will search the files for that particular moment. If found, a confirmation box will pop up and the file can be played directly. The application will automatically highlight the file in the list and forward the playback to a moment near the selected time. There may be a slight offset corresponding roughly to the Pre-Alarm Buffer Size from the Settings -> Alarm panel.

If the application was not able to find the exact match, a pop up box will ask if you want to play the closest file in time. Note that the application will highlight this closest match in the file list, so you could use that as a starting point for navigating through the files.

### Refresh File View

The files listed in the panel my not be updated automatically. Use the refresh icon to get a current listing of the files available for view.


### Event Browser

  If the Save Picture for Alarms checkbox on the Settings -> Alarm panel is selected (yes by default), the system will save a picture each time an alarm is triggered. Clicking the Events button on the file panel will pop up the Event Browser dialog which can be used to view the pictures.

  &nbsp;

  <image src="assets/images/event_browser.png" width="640">

  &nbsp;

  The pictures are shown as the current selection on the list changes. Double clicking, typing the Enter key or clicking the View button will start the video associated with the event at the time point of the occurrence of the event.

---

&nbsp;

</details>

<details>
<summary>Application Settings</summary>
&nbsp;

---

## General Settings

&nbsp;

<image src="assets/images/general.png" width="400">

&nbsp;

### Common Username and Password

Default camera login credentials. If there is a camera on the list that does not share these credentials, a pop up login box will appear during discovery. It is possible to add these alternate credentials into the stored profile of the camera by right clicking over the camera in the list and selecting the password option, which will silently add the credentials to the stored settings so that the camera can be discovered without having to type in the credentials.

### Hardware Decoder

A hardware decoder may be selected for the application. Multicore CPUs with more than a few cores will handle the decoding just as easily as a hardware decoder. Smaller CPUs with a small number of cores may benefit from hardware decoding. VAAPI and VDPAU pertain to Linux systems and DXVA2 and D3D11VA are for Windows. CUDA decoding is platform independent and requires NVIDIA GPU.

### Start Full Screen

Selecting this check box will cause the application to start in full screen mode. The full screen mode can be cancelled with the Escape key. The F12 key will also toggle full screen mode.

### Auto Time Sync

This selection will send a time sync message to each of the cameras once an hour. The camera time is set according to the parameters defined in the Sync Time dialog box described in Camera Parameters shown above.

### Snapshot File Dlg

When selected, a dialog box will appear when a snapshot is requested so that the picture file name can be changed for saving. Deselecting this checkbox will cause the system to automatically accept the generated file name without showing the dialog. Please note that the system uses the automatically generated filename to determine the snapshot time when searching video files, so changing the filename will disable the search functionality.

### Display Refresh Interval

Performance on some lower powered systems may be improved by increasing the display refresh interval.

### Open New Window

Manage profiles for secondary windows used to display a camera or a group of cameras separately from the main application window.

The default 'Reader' profile is a reserved profile that launches a specialized secondary File panel browser that can operate with it's own configuration for viewing files. The secondary File panel can be used during camera operation without interferring with the main program.

The default 'Focus' profile is a reserved profile that is integrated into application logic. The Focus Window can be launched by double clicking on a camera stream in the main display and can show that camera at higher resolution and frame rate for a more detailed view. The Focus Window will show only one camera at a time. The application will automatically configure the Focus settings for proxy type and auto discovery.

Additional profiles can be added using the three dot button to the right of the drop down box that will launch a configuration dialog box.

&nbsp;

<image src="assets/images/profile.png" width="360">

&nbsp;

New Windows can be configured to show specific groups of cameras, which can be useful if the host computer is driving several monitors such that different groups of cameras are shown on different monitors. The Open button will launch a window with the profile selected in the drop down box. Each profile will have a separate configuration that is set by the user.

It may be useful to create a profile excusively for viewing camera recordings from the File tab. This way the window can be configured with a larger navigation panel showing more complete file information. Additionally, the camera panel can be hidden in this profile so that the window opens directly to the file list.

### Show Logs

This button will show the logs of the application. Many events and errors encountered will be documented here. The log rolls over at 1 MB. The older logs can be managed using the Archive button on the logs display dialog.

### Help

Shows this file.

### Hide Display

If running Onvif GUI in server configuration, it may be desirable to run in headless mode. If this is the case, hiding the display will significantly reduce compute load by bypassing the rendering routines. In this configuration, the compute load will be similar to that of a console application. Once the display is hidden, the text of the button will change to Show Display with appropriate functionality.


## Discover Settings

&nbsp;

<image src="assets/images/discover.png" width="400">

&nbsp;

### Discovery Options

* Discovery Broadcast

  This option will broadcast a discovery packet to find cameras on the local network. If the host computer is attached to multiple networks it is possible to broadcast across all networks or only one selected network. Cameras discovered will have their data entered into the address cache so that they may be found without discovery later.

* Cached Addresses

  This option will cause the application to find cameras based on the cache data rather than the discovery broadcast. Note that cameras may be deleted from the cache by using the Delete key or the right click context menu on the camera list. This can be useful if a subset of cameras on the network is going to be streamed. Note that some cameras may respond with incomplete data when using a cached address.

* Add Camera

  It is possible to add a camera manually to the address cache by using the Add Camera button. The IP address and ONVIF port are required to connect.  The ONVIF port by default is 80. If successful, the camera will be added silently to the camera list. If a camera is added manually using this method, it will not persist in the interface unless the Cached Addresses option is selected.

### Auto Discovery

When selected, this option will cause the application to discover cameras automatically when it starts. This holds true whether the application is using Broadcast Discovery or Cached Addresses.  Note that if this option is selected and the Broadcast Discovery Option is also selected, the application will poll the network once per minute to find missing or new cameras.

### Auto Start

When selected in combination with the Auto Discovery check box, cameras shown in the list will start automatically when the application starts. This feature will work with either Discovery Broadcast or Cached Addresses.

## Storage Settings

&nbsp;

<image src="assets/images/storage.png" width="400">

&nbsp;

### Disk Usage

The application has the ability to manage the disk space used by the recorded media files. This setting is recommended as the files can overwhelm the computer and cause the application to crash. Allocating a directory for the camera recordings is done by assigning a directory using the Archive Dir selection widget. The default setting for the Archive Dir is the user's Video directory. It is advised to change this setting if the host computer employs the user's Video directory for other applications.

* Current Disk Usage

  When the application starts, or a new file is created for a camera recording, the approximate amount of disk space used by the application is displayed. This number is not exact, but can give a general idea of the amount of disk space used.

* Auto Manage Checkbox

  Select this check box to enable disk management.  A warning dialog will inform the user of the risk of the loss of files within the directory. Note that the application will only delete files that conform to the date style file naming convention that it uses. It is a good idea to use a directory that can be dedicated exclusively to the application.

  The maximum available disk space that could be allocated to the application based on the Archive Dir setting will be displayed next to the checkbox.

  The spin box can be used to limit the application disk usage in GB. Note that the application is conservative in it's estimate of required file size and the actual space occupied by the media files will be a few GB less than the allocated space.

* Archive Directory

  This widget sets the storage location for Video files generated by the system. Note that the location here is independent from the Videos panel of the File browser.

* Picture Directory

  This widget sets the storage location for Picture files generated by the system. Note that the location here is independent from the Pictures panel of the File browser.

### Max File Duration

  Video file duration is limited to this length. This is done so that Video files do not become excessively large. Video files will be padded at the start by the duration configured on the Settings -> Alarm tab Pre-Alarm buffer size, which by default is ten seconds. This insures some overlap between adjacent files so that information is not lost when files are truncated.

### File Write Buffer Size

  File management will remove oldest files based on the total size limit set in the Auto Management field. Because the calculation used by the manager is not exact, an additional buffer space is allocated for safety. The default value should be sufficient, but can be ajusted based on conditions if warranted.

## Proxy Settings

&nbsp;

<image src="assets/images/proxy.png" width="400">

&nbsp;

## Proxy Type

* Stand Alone

  Default setting, implements a single instance of the program that connects to the cameras directly.

* Client

  The application will act as a client to the proxy server using a connection string corresponding to one displayed by the server in the url box. If the connection string is changed, the Update button must be clicked to enact the changes. If the server is capable of generating detections, they can be received or ignored by the client using the 'Get alarm events from server' checkbox. If the server detections are not enabled, the client may generate detections locally if desired.

  If the server detections are enabled, the application will look for the interface that matches the subnet of the server. If the server address has been entered incorrectly, this condition will prompt an error message and the event listener will not be instantiated.

* Server
  
  The application will host a proxy server and allow other instances of the application configured as clients to connect over the local network to the cameras proxied by the server. The server backend is provided by [Media MTX](https://github.com/bluenviron/mediamtx). The application will download the appropriate binary executable file from the developer github page and copy it to the python environment bin folder. If you prefer to use your own Media MTX binary, the location can be set with the directory control.

  Diagnostic messages from the MediaMTX server may be visible in the terminal if the application is started from the command line. The Log Level selector can be used to tailor the verbosity of the messages.

* HTTP Server

  The application can host links to Video streams that can be accessed using a Web browser. The port number 8800.

* Alarm Broadcasting

  Alarm broadcasting by the server can be controlled using the 'Alarm Broadcasting' group box. This function will broadcast a single UDP packet containing the alarm states for all cameras on the server at an interval of once per second. The UDP packet can be received by any machine on the broadcast network.
  
  For server hosts running Windows, broadcasting is limited to the network with the highest priority. The Network combo box in this case will have only one entry which corresponds to the highest priority network. Please see the section in Notes -> Network Priority on Multi Homed Hosts to view instructions on how to set network priority. Linux and Mac OS hosts are able to select the network on which to broadcast alarms.

## Alarm Settings

&nbsp;

<image src="assets/images/alarm.png" width="400">

&nbsp;

### Pre-Alarm Buffer Size

When a camera is recording, this length of media is prepended to the file so that the moments prior to the alarm are preserved. If always recording, or the file length is limited by the system, this feature will insure that there is a small overlap between adjacent files.

### Post-Alarm Lag Time

In the case where a camera is configured to record during alarms, this length of time must pass after the cessation of the alarm before the file recording is turned off.  This helps to prevent excessive file creation. Alarm display and alarm sound functions are affected by this setting as well.

### Alarm Sounds

A few default alarm sounds for selection.  A system wide volume setting for the alarm volume can be made with the slider.

### Show Alarms on Display

When selected (default is yes) a red filled circle will be displayed on the camera stream during alarm conditions. The circle will blink if the stream is being recorded during an alarm. De-selecting this checkbox will show the camera stream without any alarm markings.

### Save Picture for Alarms

When selected (default is yes) a picture will be saved to the Pictures directory each time an alarm is triggered. The pictures are used to populate the Event Browser accessible from the File panel which can be used to view vidoes at the time point of the alarm.

---
&nbsp;
</details>

<details>
<summary>Video Panel</summary>
&nbsp;

<i>Video streams cam be analyzed to generate alarms.</i>

---

The Video Panel has multiple modes of operation. The default setting is for motion, which can be used without further configuration and will run easily on a CPU only computer. YOLOX requires the installation of additional python packages, namely pytorch and openvino. YOLOX will perform well on recent Apple Silicon M chips, NVIDIA GPU, and Intel Xe, UHD or ARC Graphics.

In order for the panel to be enabled, either a camera or a file must be selected. If a camera is selected, the Video Alarm check box must also be selected on the Media Tab of the Camera Panel. If a file is selected, the Enable File check box on the Video Panel must be selected.

Parameters set on the panel are applied to files globally, and to cameras individually.

If the analysis produces an alarm, record and alarm sound actions are taken based on the settings made on the System Tab of the Camera Panel. Files are not connected to alarm processing.

<details>
<summary><b>Motion Detection</b></summary>
&nbsp;

<i>Motion detection is useful in lower powered systems without AI processing capabilities</i>

---

&nbsp;

<image src="assets/images/motion.png" width="640">

&nbsp;

The motion detector measures the difference between two consecutive frames by calculating the percentage of pixels that have changed. If that result is over a threshold value, an alarm is triggered. The Diff check box will show a visualization of the differential pixel map that is used by the calculation. The status bar will light green to red as the value of the algorithm result increases. The Gain slider can amplify or attenuate the result to adjust the sensitivity of the detector. Higher Gain slider values increase the sensitivity of the detector.

Motion detection systems are prone to false alarms due to the indiscriminate nature of the analysis. They can be useful in settings where motion is limited, such as a controlled indoor environment. They are not recommended for general use, expecially in outdoor settings.

---
&nbsp;
</details>


<details>
<summary><b>YOLOX</b></summary>
&nbsp;

<i>YOLOX is an AI powered analysis for detecting specific types of objects</i>

---

&nbsp;

<image src="assets/images/yolox.png" width="640">

&nbsp;

<b>Prerequisites</b>

YOLOX will run with hardware acceleration on Apple Silicon, NVIDIA GPU and Intel iGPU, NPU, or ARC Graphics.

<b>Installation Requirements</b>

<b>Please Note:</b>The installation scripts for Linux and Mac OS install the necessary python libraries automatically. The Linux installation scripts will install iGPU drivers on Intel chips automatically. If using NVIDIA GPU, those drivers are usually installed by default on modern Linux distros, but some may require manual installation. Windows users will need to install drivers and python libraries manually for the time being.

<b>Configuration</b>

The upper portion of the yolox panel has a model configuration box. Model parameters are system wide, as there will be one model running that is shared by all cameras. The Name combo box selects the model, which is named according to the size of the number of parameters in the model. Larger models may produce more accurate results at the cost of increased compute load. The Size combo box sets the resolution to which the video is scaled for model input. Larger sizes may increase accuracy at the cost of increased compute load. It is possible to change the backend API of the yolo detector by using the API combo box. The Device combo box will populate automatically with available hardware.

The model is initialized automatically by starting a camera stream with the Camera tab Video Alarm checked. By default the application is configured to download a model automatically when a stream is started for the first time. There may be a delay while the model is downloaded, during which time a wait box is shown. Subsequent stream launches will run the model with less delay.

A model may be specified manually by de-selecting the Automatically download model checkbox and populating the Model file name box. Note that if a model is manually specified, it is still necessary to assign the correct Name corresponding to the model parameter size.

The lower portion of the panel has settings for detector configuration. Parameters on this section are assigned to each camera individually.

Skip Frames spin box sets the number of frames to skip between model analysis runs. If the Skip Frames value is set to zero, every frame produced by stream is set through the detector. If the Skip Frames value is set to one, every other frame is sent through the detector, and so on. This setting can be used to reduce computational burden on the system.

The yolox detector samples a number of frames as set by the Samples setting. The number of frames with positive detections required to trigger an alarm is set by the Limit slider. For example, if the Sample Size is 4 and the Limit slider is set to 2, at least two of the last four frames observed must have positive detections in order to trigger the alarm.

There is also a Confidence slider that applies to the yolox model output. Higher confidence settings require stricter conformance to model expectations to qualify a positive detection. Lower confidence settings will increase the number of detections at the risk of false detections.

It is necessary to assign at least one target to the panel in order to observe detections. The + button will launch a dialog box with a list of the available targets. Targets may be removed by using the - button or the delete key while the target is highlighted in the list.

---
&nbsp;
</details>

<details>
<summary><b>Ryzen AI (FOR REFERENCE ONLY - NOT WORKING WITH CURRENT API)</b></summary>
&nbsp;

<i>AMD NPU can run YOLOX using the Ryzen AI framework</i>

---

&nbsp;

Source code can be found on [github](https://github.com/sr99622/onvif-gui-ryzen-ai)

yolox will work with RyzenAI on AMD chips with NPU. Configuration Details are available on [Hugging Face](https://huggingface.co/amd/yolox-s). The AMD system is still under development, so options here are limited to a single model with fixed parameters, but performance is on par with competing solutions. Configuration for this model requires installation of the Ryzen AI Software which in turn requires anaconda as the python provider. Note as well that the anaconda installation required by this setup needs the anaconda binaries available in the PATH environment variable, which may cause conflicts with other python configurations. 

<b>Installing RyzenAI</b>

Installing the RyzenAI software can be challenging as the instructions are not entirely clear on the procedure. There are four major steps that need to be completed for a successful installation. 

  1.) Visual Studio needs to be installed with the Desktop Development with C++ module. This procedure is fairly well documented by Microsoft, the catch is to install the Desktop C++ module. 
  
  2.) Anaconda needs to be installed with the PATH variable set. There is a selection at the beginning of the Anaconda installation for this option along with a warning that it is not recommended. Please note that this selection has two issues. One is that the PATH setting may interfere with an existing Python installation by overriding the existing Python PATH and may cause other applications to fail. Another issue is the scope of the PATH environment variables setting. If the Anaconda installation is set for User, rather than System, the PATH will be set in the User scope only. The RyzenAI installation will expect the PATH in the System scope. You can recover from this error if encountered by copying the anaconda PATH variables from User to System. The PATH settings are accessed by going to Settings -> System -> About -> Advanced System Settings -> Environment Variables.

  3.) NPU Drivers need to be installed. The drivers are downloaded from the AMD website after a credential assignment requiring account creation. The drivers come in a zip file e.g. RAI_1.3.1_242_WHQL.zip, which should be unpacked. Open a powershell prompt in Administrator mode to run the executable inside the unzipped folder e.g. `.\npu_sw_installer.exe`. Upon completion of the command, use the Device Manager for Windows to find the NPU in the hardware devices list and check that the driver version matches the installation script to verify successful installation.

  4.) Install the Ryzen AI Software. The AI software is implemented as a conda environment which is set up by an installation application. You will need to download the installer from the AMD website using the credentials established previously for the driver download. The file will be an msi, e.g. ryzen-ai-1.3.1.msi. A common mistake is to think that this file is meant to be run by double clicking, as most files of this type would normally be run. Instead, use an Administrator privileged powershell prompt to start the install application, e.g. `.\ryzen-ai-1.3.1.msi`. This will avoid permission errors which are not properly reflected in the error messages. 

<b>Install Onvif GUI in the conda environment</b>

The Onvif GUI application will need to be installed into the anaconda environment generated by the Ryzen AI installation procedure. If you've lost track of the environment name, you can look for it using the command `conda env list`. The environment will have the necessary dependencies installed automatically. Activate the environment, e.g. `conda activate ryzen-ai-1.3.1`, and use the command `pip install onvif-gui` to install the application.

<b>Configure the VAIP</b>

Note as well that the configuration requires the location of the <b>vaip_config.json</b> file generated by the RyzenAI Software installation. This file can usually be found in the RyzenAI home directory which is in the `C:\Program Files\RyzenAI\1.3.1\voe-4.0-win_amd64` folder, where 1.3.1 is the version of the software and can be expected to change with version updates. The model itself will be downloaded automatically from HuggingFace by default, or can be installed manually if preferred.


&nbsp;
</details>

---

&nbsp;
</details>

<details>
<summary>Audio Panel</summary>
&nbsp;

<i>AAC Audio streams can be analyzed to generate alarms.</i>

---

The audio panel can analyze streams in both amplitude and frequency domains. Note that frequency analysis requires slightly more computing power than amplitude analysis. Please note that only AAC encoded audio is supported at this time.

In order for the panel to be enabled, either a camera or a file must be selected. If a camera is selected, the Video Alarm check box must also be selected on the Media Tab of the Camera Panel. If a file is selected, the Enable File check box on the Video Panel must also be selected.

Parameters set on the panel are applied to files globally, and to cameras individually.

If the analysis produces an alarm, record and alarm sound actions are taken based on the settings made on the System Tab of the Camera Panel. Files are not connected to alarm processing.


&nbsp;

<image src="assets/images/audio_panel.png" width="400">

&nbsp;

* ### Amplitude

The amplitude is measured by calculating the Root Mean Square (rms) value of the audio waveform. If the rms exceeds threshold, an alarm condition is triggered. The Gain slider can be used to amplify or attenuate the value of the signal in order to adjust the sensitivity of the detector.

* ### Frequency

The frequency spectrum is measured by the integrated area under the spectrum curve normalized. The spectrum may be filtered to eliminate undesired frequencies. Lower frequencies are often common background sounds that do not warrant an alarm condition, whereas higher frequency sounds are often associated with a sudden, sharp noise such as breaking glass.

There are filter bars that can be adjusted using the cursor handles. Frequencies excluded by the filter are depicted in gray. The Gain slider can be used to amplify or attenuate the value of the signal in order to adjust the sensitivity of the detector.

* ### Over/Under

The detector can be configured to alarm in the absence of sound by selecting the Under radio button. This may be useful in situations such as an engine room monitor configured to alarm if the engine stops running. This mode will invert the status bar level.

---

&nbsp;

</details>

<details>
<summary>Full Screen</summary>
&nbsp;

---

The application windows can be configured to run in full screen mode. The F12 key is used to toggle full screen. If the application is running full screen, the Escape key can be used to return to windowed operation.

The control tab on the right of the application window may be toggled using the F11 key. On Mac, it is necessary to use the command key + F11 combination to override the default workspace action. The size of the control tab can be changed by dragging the left hand edge of the tab. Reducing the size of the tab beyond it's minimum will hide the tab. If there is at least one stream in the display and the control tab is hidden, clicking on the stream display area will restore the control tab.

---

&nbsp;

</details>


<details>
<summary>Notes</summary>

&nbsp;

<details>
<summary>Servers</summary>

&nbsp;

<details>
<summary>DHCP Servers</summary>

&nbsp;

<i>A network set up as shown in the Recommended Configuration will require some mechanism for setting IP addresses to the cameras and computers that connect to the network. Although this may be achieved by setting  static IP for each device, a DHCP server is recommended. This is a service that is installed on the Onvif GUI server host computer. DHCP service configuration details are shown for each operating system.</i>

<details>
<summary>Linux</summary>

&nbsp;

Linux can be configured to run a kea [DHCP server](https://ubuntu.com/server/docs/how-to-install-and-configure-isc-kea). A sample configuration file `/etc/kea/kea-dhcp4.conf` for this server is shown below.

It is necessary to set the server ethernet interface to a static IP address for this configuration. It is recommended to manually set the Onvif GUI server ethernet address connecting to the camera network to be 10.1.1.1. This is a reserved network for private subnets. Please verify that your existing network does not use this address range. There are many references that can provide details on how to set a static ip. On Ubuntu, use the Settings -> Network -> Wired Network then click on the gear to get details, use the IPv4 tab and click the Manual radio button  to enable manual settings. The IP address should be set to `10.1.1.1`, the Subnet Mask to `255.255.255.0` and the Gateway to `10.1.1.1`. If you need internet access, you should have a second network connection to your local router, which is configured separately.

It will be necessary to find the name of the network interface intended to provide the DHCP service. On Linux, the command `ip a` will provide a listing of interface properties that will contain the relevant information. It will look something like `enp1s0` but will be different for each machine. The name will be associated with the ip address (<i>10.1.1.1 as set previously</i>) of the desired interface.

### Sample Configuration File

```
{
  "Dhcp4": {
    "interfaces-config": {
    "interfaces": [ "<your-interface-name>" ]
    },
    "control-socket": {
        "socket-type": "unix",
        "socket-name": "/run/kea/kea4-ctrl-socket"
    },
    "lease-database": {
        "type": "memfile",
        "lfc-interval": 3600
    },
    "valid-lifetime": 600,
    "max-valid-lifetime": 7200,
    "subnet4": [
    {
        "id": 1,
        "subnet": "10.1.1.0/24",
        "pools": [
        {
            "pool": "10.1.1.64 - 10.1.1.242"
        }
        ],
        "option-data": [
        {
            "name": "routers",
            "data": "10.1.1.1"
        },
        {
            "name": "domain-name-servers",
            "data": "10.1.1.1"
        },
        {
            "name": "domain-name",
            "data": "mydomain.example"
        }
        ]
    }
    ]
  }
}
```

This is a basic configuration that will assign addresses in the range of 10.1.1.64 - 10.1.1.242, leaving the balance of addresses available for static ip. The router and name server addresses point back to the server, which is a dead end. This means that there is no direct traffic between the cameras and the internet or the rest of the network. All communication with the cameras is proxied by the Onvif GUI server.

The service can be set up by copying the sample file to `/etc/kea/kea-dhcp4.conf`, replacing the tag `<your-interface-name>` with the appropriate data from the `ip a` command,  This can be done using the command `sudo nano /etc/kea/kea-dhcp4.conf`, then copying the text above and using ctrl+O, enter, ctrl+X to save and exit.

Use the commands shown below to control the service. Be sure to use the enable command to get persistent service operation through reboots.

```
sudo systemctl enable kea-dhcp4-server
sudo systemctl disable kea-dhcp4-server
sudo systemctl start kea-dhcp4-server
sudo systemctl restart kea-dhcp4-server
sudo systemctl stop kea-dhcp4-server
sudo systemctl status kea-dhcp4-server
```

The `enable` and `disable` commands install and uninstall the kea dhcp4 service into the boot protocol, controlling whether the service is started automatically at boot time. The balance of the commands control or show information about the service.

&nbsp;

---

</details>

<details>
<summary>Mac</summary>

&nbsp;

On Mac OS, the DHCP service is provided by bootpd. The service is configured with a file named `/etc/bootpd.plist`. A sample configuration file is shown below. 

It is necessary to set the server ethernet interface to a static IP address for this configuration. It is recommended to manually set the Onvif GUI server ethernet address connecting to the camera network to be 10.1.1.1. This is a reserved network for private subnets. Please verify that your existing network does not use this address range. To make this configuration, use the Settings -> Network -> Ethernet -> TCP/IP -> Configure IPv4 -> Manually (combo box). The IP address should be set to `10.1.1.1`, the Subnet Mask to `255.255.255.0` and the Router to `10.1.1.1`. If you need internet access, you should have a second network connection to your local router, which is configured separately. Note that you may need to update network priorities in order to use the internet connected interface. Please refer to the section Network Priority on Multi Homed Hosts of this document.

This file is configured to use the interface named `en0`, which in most cases will be the ethernet interface on the Mac computer. Please check the name using the `ifconfig` command to verify that this is the correct information.

### Sample Configuration File

```
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>bootp_enabled</key>
    <false/>
    <key>detect_other_dhcp_server</key>
    <integer>1</integer>
    <key>dhcp_enabled</key>
    <array>
        <string>en0</string>
    </array>
    <key>reply_threshold_seconds</key>
    <integer>0</integer>
    <key>Subnets</key>
    <array>
        <dict>
            <key>allocate</key>
            <true/>
            <key>dhcp_router</key>
            <string>10.1.1.1</string>
            <key>lease_max</key>
            <integer>86400</integer>
            <key>lease_min</key>
            <integer>86400</integer>
            <key>name</key>
            <string>10.1.1</string>
            <key>net_address</key>
            <string>10.1.1.0</string>
            <key>net_mask</key>
            <string>255.255.255.0</string>
            <key>net_range</key>
            <array>
                <string>10.1.1.64</string>
                <string>10.1.1.242</string>
            </array>
        </dict>
    </array>
</dict>
</plist>
```

This is a basic configuration that will assign addresses in the range of 10.1.1.64 - 10.1.1.242, leaving the balance of addresses available for static ip. The router and name server addresses point back to the server, which is a dead end. This means that there is no direct traffic between the cameras and the internet or the rest of the network. All communication with the cameras is proxied by the Onvif GUI server.

The service can be set up by copying the sample file to `/etc/bootpd.plist`, replacing the tag `en0` tag in the `dhcp_enabled` key with the appropriate data from the `ifconfig` command if necessary. This can be done using the command `sudo nano /etc/bootpd.plist`, then copying the text above and using ctrl+O, enter, ctrl+X to save and exit.

The service can then be started using the command

```
sudo launchctl load -w /System/Library/LaunchDaemons/bootps.plist
```

The service can be stopped with

```
sudo launchctl unload -w /System/Library/LaunchDaemons/bootps.plist
```

&nbsp;

---

</details>

<details>
<summary>Windows</summary>

&nbsp;

[DHCP Server for Windows](https://www.dhcpserver.de/cms/) is made available by third party . Older versions are available for [download](https://www.dhcpserver.de/cms/download/) free of charge. Instructions for installation can be found [here](https://www.dhcpserver.de/cms/running_the_server/). Please consider making a donation to the developer if you find the software useful.

Please note that the installation procedure does not include instructions for setting up a static IP address on the network interface, which is necessary for operation. This should be done before configuring the DHCP service. An exhaustive resource on this topic is available at [How to set a static IP address on Windows 11](https://pureinfotech.com/set-static-ip-address-windows-11/).

</details>

&nbsp;

---

</details>

<details>
<summary>Setting Up a Samba Share on Linux</summary>

&nbsp;

It is possible for Windows clients to access camera recordings residing on a Linux server on the local network by installing a samba share on the Linux server. There are a few steps needed to set up the server, which are often not well documented for this type of configuration. The following instructions will set up the shared folder on the server, then show how a Windows client can attach to the shared folder as a mapped drive. Please note that this setup is intended for use in a simple private network where all users can be trusted with data. More sophisticated configurations that control data access are possible, but are beyond the scope of these instructions.

* #### Linux Server Configuration

  <h4>Step 1. <b>Set Fixed IP Address</b></h4> The server should have a fixed IP address. This is not completely necessary for system operation, but will prevent mishaps later that can occur if the server address changes. For Ubuntu and similar systems, there is a GUI control dialog that can be used to assign a fixed IP address. The address chosen will depend on the router settings, which will set aside a range of addresses that are available for fixed IP. Usually this will be at the bottom and/or top of the IP range controlled by the router. The router setting that defines these ranges is set by DHCP. Check ahead of time that the desired IP address is not already taken and is available per the router configuration.

  <h4>Step 2. <b>Install and Configure Samba</b></h4> On Ubuntu, the Samba server is installed using the apt command

  ```
  sudo apt install samba
  ```

  The Samba configuration is performed by editing the `/etc/samba/smb.conf` file. The Samba installation will create a default file in this location, which is not a good fit for this type of configuration. It is recommnded to move the file to a backup and start with a fresh file for configuration, following the commands

  ```
  cd /etc/samba
  sudo mv smb.conf smb.conf.bak
  sudo nano smb.conf
  ```

  You will now be starting from a clean slate. The following text saved into the `smb.conf` file will create a sharing configuration that is compatible with the application. For this configuration, you will need to know the account under which Onvif GUI was installated. For example, if you created a user onvif-gui, and were logged on as that user during the time the appliation was installed, the default directory for the application will be /home/onvif-gui. The configuration shown below will share two sub-directories used by the program, namely Videos and Pictures.
  
  ```
  [global]
    workgroup = WORKGROUP

  [Videos]
    comment = Shared Videos Folder
    path = /home/onvif-gui/Videos
    browasble = yes
    read only = yes

  [Pictures]
    comment = Shared Pictures Folder
    path = /home/onvif-gui/Pictures
    browsable = yes
    read only = yes

  [Documents]
    comment = Shared Documents Folder
    path = /home/onvif-gui/Documents
    browsable = yes
    read only = no
  ```

  <h4>Step 3. Re-start the Samba service</h4> After changing the configuration file, it is necessary to re-start the service in order to enact the changes made. This should be done any time changes are made to the smb.conf file.

  ```
  sudo systemctl restart smbd
  ```
  
  <h4>Step 4. <b>Add User and Set Samba Password</b></h4>

  The command to add a user is

  ```
  sudo useradd -m <username>
  ```
  
  The samba access requires a passord for the user
    
  ```
  sudo smbpasswd -a <username>
  ```

  The system will prompt you to enter a password.

  ____________
  
  A script to get a list of active samba accounts

  ```
  #!/bin/bash

  # Run pdbedit and extract only the Unix usernames
  sudo pdbedit -L -v | while IFS= read -r line; do
    # Skip empty lines
    [[ -z "$line" ]] && continue

    # Match only lines that start with "Unix username:"
    if [[ "$line" == "Unix username:"* ]]; then
      value="${line#Unix username: }"
      echo "$value"
    fi
  done

  ```

  _____________


* #### Windows Client Configuration

  Open the file navigator in Windows and go to the Network section. Using the address bar at the top, enter the IP address of the server such as, for example,

  ```
  \\10.1.1.3
  ```

  If all goes well, you get a shared folder icon in the navigator. Double click the folder to get a login screen. Use the credentials of the Onvif GUI account on the Linux server. If successful, create a shared drive by right clicking over the folder and using the drop down menu, and make the drive persisent. Open the Ovnif GUI application, go to the Files tab and use the navigation bar at the top to select the Videos folder from the shared drive. You should see the folders holding the camera recordings.

* #### Linux Client Configuration

  Detailed configuration instructions can be found in the Operations -> Mount SMB Drive from Linux section of the notes.

---

&nbsp;

</details>

<details>
<summary>Network Priority on Multi Homed Hosts</summary>

&nbsp;

---

When connecting a host computer to multiple networks, it may be difficult to reach remote computers if one of the connected networks does not have internet access. This can happen if the host computer uses the wired ethernet interface to isolate cameras on a network without internet access and the host intends to use the wireless connection to communicate with the internet. In this situation, the host operating system may attempt to use the wired ethernet connection to communicate with the internet which can result in lengthy delays or the inability to access the internet altogether.

The issue can be addressed by assigning priorities to network adapters. Most Linux distributions seem to be able to handle this situation on their own, so the issue is mostly associated with Windows and MacOS. The basic concept is to set the priority of the connection with the ability to access the internet a higher value than interfaces which are not connected to the internet.

### Windows

Open a powershell in Administrator mode and use the following command to show interface priorities

```
Get-NetIPInterface
```

This will show a table of the network interfaces and their associated priority. Interfaces are tagged with an identifier referred to as InterfaceIndex. The priority of the interface is referred to as InterfaceMetric where lower numbers have higher priority. The priority of an interface is set using the command

```
Set-NetIPInterface -InterfaceIndex <idx> -InterfaceMetric <metric>
```

Where `<idx>` is the network identifier number and `<metric>` is the priority

### MacOS

Click the Apple icon in the upper left corner of the screen and select System Settings -> Network. On the right on the dialog should be a drop down shown as `...v` with a question mark to the right. Click the drop down and select Set Service Order. You can then drag and drop the interface names to set the priority.

---

</details>

<details>
<summary>Using MacOS as a Server</summary>

&nbsp;

### Introduction

MacOS has a number of qualities that make it desirable as a server platform. It has a capable NPU that can process YOLO models for inference in a very power-efficient manner. It has a good built in DHCP server that can easily be used for the camera network. It has a polished graphical interface capable of driving multiple monitors. It will also run silent in most conditions without creating a lot of fan noise which can be problematic with some systems. 

### Power Management

Apple Silicon is very power efficient, and features have been added to the operating system to further enhance efficiency. These features can have the effect of making the server sleep or get behind in processing video frames that are sent by the cameras. This is undesirable when depending upon the alarm function as the data is not processed in a timely manner. The settings for Energy should be adjusted to disable the low power mode for the device during periods of no user interaction. The setting "Prevent automatic sleeping when the display is off" should be set to on. 

### File Handle Management

The operating system will limit the number of file handles that can be open simoultaneously. These handles are also associated with network socket creation. This has the effect of limiting the number of clients that can connect to the server. In order to increase the number of handles, the ```ulimit``` command can be used.

```
ulimit -n 8192
```

This command can be added to the shell resource file, e.g. .zshrc in the user home directory. This will then set the limit for each terminal session as it is opened on a persistent basis.

</details>

<details>
<summary>File Sharing on Mac OS</summary>

&nbsp;

Open Sharing Settings: Go to the Apple menu > System Settings > General > Sharing (scroll down if needed).

Enable File Sharing: Turn on the toggle for File Sharing.

Configure SMB: Click the info button (i) or Options next to File Sharing.

Turn on SMB Sharing: Check the box for "Share files and folders using SMB".

Select Users: Under "Windows File Sharing," check the box for each user account that needs access and enter their password.

(Optional) Add Folders: In the main Sharing window, use the "+" button to add specific folders to share and set their permissions (read/write for users). 

</details>


---

</details>

<details>
<summary>Python</summary>

&nbsp;

#### Introduction

Python configuration is critical to program operation. Part of the configuration involves the use of virtual environments, which may appear nebulous due to the abstract nature of the concept. Compounding the difficulty of developing an understanding of the mechanics of the implementation is the existence of several variations of Python tools that are capable of creating and managing virtual environments. The recommendation here is to focus on the original work from [python.org](https://python.org) and ignore other derivative products such as Anaconda and pyenv.

Python is a standard tool installed on every Linux distribution. Each Linux distro makes it's own version of Python, and it is often used to help manage shell scripts for system maintenance. Python has become quite popular and is now available on many other platforms. Python is not universally loved, however, and tales abound of Linux machines brought down by bad Python versions. This is a legitimate gripe as it is indeed possible to break the functionality of a system Python by overwriting its components with incompatible versions.

#### Virtual Environments

Virtual environments are a solution to the issue of system interaction with multiple Python installations. A virtual environment has two main components, the Folder and the Shell Variables.

* #### Folder

  A virtual environment Folder is a subdirectory on the disk containing all the files necessary to run a particular version of Python. This allows a Python version separate from the system installed version to operate independently. Python has been optimized to minimize the size of the Folder, so the virtual environments are lightwieght. The virtual environment Folder is created by a call to the venv module as ```python3 -m venv <name>```, where ```<name>``` is chosen by the user. Note that ```<name>``` is traditionally entered as a relative path name, but a full path name is valid. Note that some Linux distributions have the venv module included by default, while other distributions require the installation of additional libraries.

* #### Shell Variables

  An important feature of the virtual environment Folder is that it is not located on the system $PATH. This is done in order to minimize interaction with the system Python and other libraries. When virtual environments are activated, the shell in which Python executes has additional environment variables added to the inherited system environment variables. Python appears to other processes also operating within the shell that it is installed as the system Python. When the shell is closed, the shell variables do not persist. This is how the virtual environment prevents the interaction of the environment Python and the system Python. 
  
  Virtual enviroments are activated by calling the ```source <name>\bin\activate``` command. This opens a shell. The ```deactivate``` command closes the shell. During the time that the environment is active, the terminal prompt is changed to the environment name.

&nbsp;

The following commands create a virtual environment named after the caller supplied ```<name>``` and activate it. You should notice that the terminal prompt will now show the environment name set by ```<name>```. This is a visual cue indicating that the environment is active.

```
python3 -m venv <name>
source <name>/bin/activate
```

Python applications are then run in the virtual environment, for example ```python --version```. You may also observe the shell variables using the ```printenv``` commmand, which will show the virtual environment Folder at the front of the $PATH. The deactivate command closes the shell, and the terminal prompt will return to its original state.

```
deactivate
```

It is worth noting at this point that Python on Linux is invoked by calling python3, which is a symbolic link to an executable file named after the system Python version e.g. python3.12. By using this strategy, multiple versions of Python can reside in the /usr/bin directory and coexist peacefully as long as the symlink python3 remains attached to the original system Python. If you want to invoke a particular Python version, just use the full python3.xx name of the executable. As a further note, virtual environments will have a symlink in their bin folder to the Python version that was used to create them, and the link is simply named python. The effect of this is that when a virtual environment is active, a call to python invokes the Python version used to create it.

#### Installing and Running Programs Written in Python

Virtual environments give developers the ability to build complex applications in a repeatable way without compromising system integrity. Independence from system libraries allows the use of localized versions of those libraries thereby avoiding problems with mismatched versions or missing system libraries. The Python installation helper, ```pip``` will install Python programs and packages into the virtual environment Folder, where any files needed to run the program are located as well.

When a program written in Python is installed in a virtual environment, a script is placed into the ```bin``` directory of the Folder. This script can be accessed directly from the system shell without activating the virtual environment. When called, the program script will activate its own shell and start the program. In this manner, a program written in Python can be started the same way as a binary compiled program, allowing integration into the system Applications folder with an icon for launching. Knowledge of the location of the virtual environment folder is required and the script is invoked using the full path name. 

#### Installing Python

Most if not all modern Linux systems have a recent system Python version installed by default. The system version of Python can be observed using the command

```
python3 --version
```

If the system Python version is at least 3.10, Onvif GUI can run directly on the system version. Onvif GUI can be run on older Linux versions with an upgraded Python version if the system kernel is at least 5.4 and the system Python is at least 3.8. The kernel version can be observed using the command

```
uname -r
```

The installation script will ask the user if they want to install an upgrade Python if the qualifications are met. The Python installation methods shown below are for reference.

<details>
<summary>Compile Python3.12 Ubuntu</summary>

&nbsp;

<i>Important Note: The binaries are installed using the</i> ```make altinstall``` <i> command rather than the traditional </i> ```make install```. <i>This is important to prevent overwriting the system Python binaries.</i>

```
sudo apt update -y
sudo apt upgrade -y

sudo apt install -y build-essential libssl-dev zlib1g-dev libbz2-dev \
    libreadline-dev libsqlite3-dev wget curl llvm libncurses5-dev libncursesw5-dev \
    xz-utils tk-dev libffi-dev liblzma-dev python-openssl git pkg-config

cd /tmp
wget https://www.python.org/ftp/python/3.12.9/Python-3.12.9.tgz
tar -xf Python-3.12.9.tgz
cd Python-3.12.9
./configure --enable-optimizations

make -j$(nproc)
sudo make altinstall
```

&nbsp;

</details>

<details><summary>Compile Python3.12 CentOS 9</summary>

&nbsp;

```
sudo dnf update
sudo dnf install -y gcc openssl-devel bzip2-devel libffi-devel wget tar make zlib-devel \
    sqlite-devel xz-devel ncurses-devel readline-devel tk-devel libuuid-devel
cd /tmp
wget https://www.python.org/ftp/python/3.12.9/Python-3.12.9.tgz
tar -xf Python-3.12.9.tgz
cd Python-3.12.9
./configure --enable-optimizations
make -j $(nproc)
sudo make altinstall
```

&nbsp;

</details>

<details><summary>Install Python3.12 Using deadsnakes Ubuntu</summary>

&nbsp;

```
sudo add-apt-repository ppa:deadsnakes/ppa
sudo apt update
sudo apt install -y python3.12-dev
sudo apt install -y python3.12-venv
```

&nbsp;

</details>

<details><summary>Installing Python on Windows and Mac OS</summary>
&nbsp;

The Python [website](https://python.org) has installers available for Windows and Mac OS. These are graphical applications that are suitable for non-technical users. It is also possible to use the installers from the command line.

[Windows Command Line Install](https://docs.python.org/3/using/windows.html#installing-without-ui)

[Mac OS Command Line Install](https://docs.python.org/3/using/mac.html#installing-using-the-command-line)

</details>

&nbsp;

---

</details>

<details>
<summary>Virtual Machines</summary>

&nbsp;

<details><summary>Shared networking for QEMU</summary>
&nbsp;

---
Taken from this [link](https://serverfault.com/questions/1075408/can-i-have-my-kvm-guests-on-the-same-subnet-as-the-host)


The objective of this installation is that virtual machines share the same network as the host.

<h3>Set up the logical network bridge on the host</h3>

<b>Note that this configuration will disable the network interface from the host perspective. It is recommended to add a usb network adapter if you only have one ethernet interface (please refer to note at the bottom of this section</b>

Create `/etc/netplan/01-kvmbridge.yaml`. Example:

```
network:
  ethernets:
    enp4s0:
      dhcp4: true
  bridges:
    virbr0:
      interfaces: [enp4s0]
      dhcp4: true
      mtu: 1500
      parameters:
        stp: true
        forward-delay: 15
```

Notes: NIC name will differ depending on driver. Address assignment doesn't have to be by DHCP.

Run `sudo netplan try` to test the config and `sudo netplan apply` to apply it once you're satisfied it works. Note that changing a network config over ssh may not be a good idea.

</h3>Tell KVM how to access the connection</h3>

Create a file `~/kvmbridge.xml` with the following contents:

```
<network>
  <name>host-bridge</name>
  <forward mode="bridge"/>
  <bridge name="virbr0"/>
</network>
```

<h3>Enable the bridge</h3>

```
virsh net-define ~/kvmbridge.xml
virsh net-start host-bridge
virsh net-autostart host-bridge
```

You should now be able to select the network host-bridge for your VMs to have them coexist on the same network as the host. Use the blue i dot to access the hardware and set the NIC to host-bridge network.

It was observed over time that the secondary usb network adapter was no longer necessary and the QEMU seemed to be sharing the single network adapter with the host, which is the desired result. It is possible that re-booting implements this functionality, or it is also possible that seemingly unrelated installations occured which may have been the cause. Unknown at this time.

The instructions do not include the installation of the virt network manager. I believe it is common knowledge, with out tricky setup. I did first install the QuickGUI version of QEMU, which is not recommended.

---

&nbsp;

</details>

<details><summary>Shared filesystem for QEMU</summary>
&nbsp;

---

Derived from this [link](https://blog.sergeantbiggs.net/posts/file-sharing-with-qemu-and-virt-manager/), which has further untested instructions for windows.

```
sudo apt install virtiofsd
mkdir ~/dist
```


<b><u>Virtiofs needs shared memory to work</u></b>. This can be enabled in the hardware configuration window. Navigate to Hardware -> Memory and select Enable shared memory, then click the Apply button.

After that, open virt-manager and select the virtual machine while it is not running. Click the Open Icon, and then click the blue circle i button. The virt-manager hardware window will be shown. The left pane contains the different categories. The right pane contains the setting for the specific category. Beneath the categorey pane, there is a button called 'Add Hardware'. A dialog box should pop up. In the pane on the left, click on Filesystem.

<h3>Filesystem options</h3>

The settings are as follows:

For the Driver, we keep the default (virtiofs). The source path is the path on our host filesystem. The target path is a bit of a misnomer. It’s not actually a path, just an identifier that we use as a mount point in our guest file system. This will become clear when we mount the file system in the guest later.

If you want a more detailed overview of these options and some alternatives, check out the libvirt knowledge base on virtiofs

<h3>Guest Configuration</h3>

After that, it’s time to configure the guest. First we create a folder in our users home directory that we will mount the share into.

```
mkdir ~/dist
```

After that, we can mount the share with:

```
sudo mount -t virtiofs dist /home/stephen/dist
```

If we want to make this permanent, we can just add an entry to /etc/fstab

```
dist   /home/stephen/dist       virtiofs        defaults        0       0
```

After rebooting, the share should be mounted! If your user on the host and the guest are the same, you don’t even need to worry about any other permissions. Otherwise, change the folder with chmod to suit your needs.

---

&nbsp;

</details>

<details><summary>Configure Debian</summary>
&nbsp;

---

<h3>Add yourself to sudoers</h3>

```
Type su -l (enter) Type administrator password (enter) Type adduser [your login name] sudo (enter) 
```

<h3>Turn off CDROM search</h3>

```
sudo nano /etc/apt/sources.list
# deb cdrom:[Debian GNU/Linux ...] / stable main
```

<h3>Add /usr/sbin to PATH</h3>

```
nano ~/.bashrc
...
export PATH=$PATH:/usr/sbin
```

---

&nbsp;

</details>

&nbsp;

---

</details>


<details>
<summary>Operations</summary>

&nbsp;

<details>
<summary>Install PyTorch CPU only on linux</summary>

```
pip3 install torch torchvision --index-url https://download.pytorch.org/whl/cpu
```

&nbsp;

</details>

<details>
<summary>Linux Installation Script</summary>

&nbsp;

To install the program on Linux, an installation script has been developed. The basic concept of the script is to make sure that a valid version of python exists on the target machine, create a virtual environment, install onvif-gui, then create a desktop icon in the Applications folder. A design goal of the script is to have as minimal an impact on the target operating evironment as possible. The install script requires sudo privileges, so it will ask the user to type in the password.

Because the script is intended to work for an arbitrary Linux distribution, it first must ascertain the package manager. Three managers are supported, those being apt, dnf and pacman. The type of package manager is determined by attempting to run a list command for each package type and the first one that succeeds is used. If the package manager is determined to be apt, the update command is run. This is necessary due to the need for current libraries for some portions of the installation. This practice is considered non-impactful as the apt update operation only updates the version pointers in the database and does not change any installed libraries. Package managers dnf and pacman are not updated in this manner as they will actually change existing configuration, and this was not observed to be necessary anyway for program installation.

The install script will then look for a valid Python version, which needs to be at least 3.10. If the Python version is less than 3.10, the script will ask the user if they would like the script to install Python version 3.12. This script will work in many cases, but will require some minimum versions of libraries, which if not present, will cause the failure of the script. It has been observed that the script running on Linux versions with Python 3.8 and greater will succeed. The script installed Python will not interfere with the system installed Python. This is effect is made possible by the use of the ```make altinstall``` procedure which will place the newly compiled Python version in the system libraries under it's own name, which is not included in the system environment variables or symbolic links. The system Python will continue to operate as before, without any interference from the newly compiled version. 

If a valid Python version has been found, the script will now create a virtual environment for the program. In some cases, notably under apt, a python-venv module will require installation. The script will check for the existence of this module and install it if necessary. The virtual environment will be named ```onvif-gui-env``` and will be placed in the user's ```$HOME/.local/share``` directory.

Once the virtual environment has been set up, the script will source the environment and install onvif-gui. The script will then check for the use of the X11 desktop protocol. If this is being used, the script will install a minimum required configuration for the protcol. This is mostly relevant to apt as distributions using the other package managers generally include the X11 drivers by default.

The script will then check for the existence of GPU and associated drivers. For NVIDIA drivers the script will attempt to run the ```nvidia-smi``` command. The target computer will have to have the drivers installed prior to running the script in order for it to succeed. As most modern Linux distributions include these drivers as part of the installation process, it should be there already if the system was properly installed. The script will then check for Intel iGPU and will ask for permission to install those drivers. Intel NPU is checked as well, but unfortunately, those drivers are only available on a limited subset of Ubuntu.

Finally, the script installs an icon in the system Applications folder for starting the program. The program can be started by clicking the icon.

&nbsp;

---

</details>

<details>
<summary>Running Multiple Cameras</summary>

&nbsp;

Performance in a multi camera configuration can be improved by using substreams. Most cameras are capable of running two streams simultaneously which are configured independently. The default stream is called the Main Stream and has higher resolution, bitrate and frame rate. The Sub Stream is an alternate stream and will have lower resolution, bitrate and frame rate. The Sub Stream is more easily decoded, processed and displayed and can be thought of as a view finder for the Main Stream. 

The application uses the generic terms Display Profile and Record Profile for streams that are processed. The Display Profile is shown to the user in the application and is set on the Media tab for the camera. Note that the default Display Profile will be the higher resolution Main Stream. The Record Profile is used by the application for saving the camera output to disk and is selected on the camera System tab. The Record Profile is not decoded so it places very little compute load on the application and can be used to record high resolution streams without affecting system performance. If the Display Profile and Record Profile are matched, only that one stream is processed by the application.

When running multiple cameras through the system, it is recommended to use the camera sub streams at a low resolution and frame rate to be the Display Profiles. If a more detailed view of the camera stream is needed, the application has a feature that will allow users to view the higher resolution stream by double clicking on the camera stream of interest in the display. This feature will pop out a new window showing the stream.

Stream analytics are performed on the Display stream. The amount of compute load placed on the system during analysis is directly related to Display stream resolution and frame rate, so substreams are strongly recommended if running analytics. 

Many camera substreams will have a distorted aspect ratio, which can be corrected by using the Aspect combo box of the Camera Panel Media Tab.

&nbsp;

---

</details>

<details>
<summary>Performance Tuning</summary>

&nbsp;

As the number of cameras and stream analytics added to the system increases, the host may become overwhelmed, causing cache buffer overflow resulting in dropped frames. If a camera stream is dropping frames, a yellow border will be displayed over the camera output. The load placed on the system by the cameras can be reduced by lowering frame rates and resolutions.

Compute load may also be reduced by increasing the Display Refresh Interval on the General Tab of the Settings section. Camera video streams are buffered and stitched together to form the composite display which is shown once per the interval as set by a timer. Depending on the frame rate of the cameras, this setting can be increased without significant data loss if the Display Refresh Interval is smaller than the inverse of the camera frame rate. This effect is most prominently observed on Windows.

The load on the computer can be observed using a system monitoring tool such as Task Manager on Windows. This tool can be launched by right clicking over the task bar. Linux has a nice monitoring tool named [Mission Center](https://flathub.org/apps/io.missioncenter.MissionCenter) that has an appearance very similar to Task Manager. Apple Macs have the Activity Monitor with pop out windows for CPU and GPU history that can be accessed from the Mac toolbar.

When setting up the computer for Onvif GUI, it can be helpful to observe the effects of different operations on the system load using the appropriate monitoring tool. Pushing the computer too hard will reduce reliability over time and may lead to crashing. It is a good idea to observe the loads on individual cores in the CPU and try to avoid bottlenecks caused when a single core becomes saturated and is flat lined at 100% usage. GPUs likewise will start to misbehave if pushed too hard. It is a good idea to leave some headroom in the performance metrics to allow for system operations that are performed periodically by the computer in the background.

Lower powered CPUs with a small number of cores or systems running a large number of streams may benefit from hardware decoding. More powerful CPUs with a large core count will work as well as a hardware decoder for smaller numbers of streams.

Stream analysis can potentially place significant burden on system resources. A GPU or iGPU is recommended for YOLO analysis, as a CPU only system will be able to process maybe one or two streams at the most. NVIDIA graphics cards provide the highest performance, and Intel Xe Graphics or later is recommended for iGPU. Modern Macs with Apple Silicon M series chips are capable of performing YOLO analysis. Using Skip Frames during YOLO analysis can also greatly reduce compute load. Using substreams for analysis is recommended, ideally matching the model size parameter to the stream resolution, which by default is 640.

Software developments in this field are constantly advancing, so it may be worthwhile to research new versions of libraries such as pytorch, openvino and associated graphics hardware drivers to see if new performance improvements are available.

&nbsp;

---

</details>

<details>
<summary>Camera Compliance With Standards</summary>

&nbsp;

Camera compliance with the onvif standard is often incomplete and in some cases incorrect. Success may be limited in many cases. Cameras made by Hikvision or Dahua will have the greatest level of compatibility. Note that some third party OEM vendors who sell branded versions of these cameras might significantly alter the functionality of the camera software.

Camera settings on the Media tab are most likely to work. Other tabs may have limited success. If Onvif GUI is able to determine that the camera settings for a particular function are unavailable, it will disable the controls for that function.

If the camera DHCP setting is properly onvif compliant, the IP address may be reliably set. Some cameras may not respond to the DHCP setting requested by onvif-gui due to non compliance. Note that the camera may reboot automatically under some conditions if the DHCP setting is changed from off to on. DHCP must be turned off before setting a static IP address.

If there is an issue with a particular setting, it is recommended to connect to the camera with a web browser, as most cameras will have a web interface that will allow you to make the changes reliably. onvif-gui has a button on the Camera Panel System Tab that will launch the web browser connection with the camera.

---

&nbsp;

</details>

<details>
<summary>Troubleshooting Techniques</summary>

&nbsp;

If you are having difficulty installing or running the program, this first place to check is the program logs. The program maintains a log of most important system functions that can be accessed from the Settings -> General tab. Browsing through the messages may produce some insight into root causes for some issues.

Running the program from the command line inside the virutal environment can help find issues as they occur during operation. To open the virtual environment, use the appropriate command from the list below.

  * Linux

  ```
  source $HOME/.local/share/onvif-gui-env/bin/activate
  ```

  * Mac

  ```
  source /Applications/OnvifGUI.app/Contents/MacOS/Python/Library/Frameworks/Python.framework/Versions/Current/onvif-gui-env/bin/activate
  ```

  * Windows

  ```
  %HOMEPATH%\onvif-gui-env\Scripts\activate
  ```

  Once inside the virtual environment, the prompt will change to (onvif-gui-env) and the program can be started with the command

  ```onvif-gui```

The teminal will now show messages in real time as they occur during program operation.

Opening an Issue in the github repository is encouraged for issues you are not able to resolve on your own. Often times, issues may exist that are unkown to the developers, and feedback is necessary to raise awareness. There are a number of common problems that have been addressed in the Issues, so a look though those may help discover a solution.

Existing issues may have been addressed with a new release of the application, so check that you are using the latest version. The version of the application is displayed in the title bar of the program window. If you want to update, first start the virtual environment as shown above and use the command `pip install --upgrade onvif-gui`.

</details>

<details><summary>Application Icon on Linux</summary>

&nbsp;

---
An icon launcher can improve usability for the application, especially for non-technical users. On Linux, the desktop icons are configured with .desktop files, which can reside either in the users `$HOME/.local/share/applications` folder, or in the system `/usr/share/applications` folder. Launchers placed in the system location will require sudo access to install. 

A typical .desktop file is shown below. This file was written for a bare metal install of the program in a python virtual environment. It is possible to create an icon for a Docker installation of the application, in which case the Terminal field should be set to true, and the Exec should point to the Docker launch script.

```
[Desktop Entry]
Version=2.5.2
Name=Onvif GUI
Comment=Camera Manager
Exec=/home/stephen/onvif-gui-env/bin/onvif-gui
Terminal=false
Icon=/home/stephen/onvif-gui-env/lib/python3.12/site-packages/onvif_gui/resources/onvif-gui.png
StartupWMClass=python3
Type=Application
Categories=Utility
```

For the most part, the fields are self-explanatory. It is common, however, for the laucher to fail without any feedback, which can make troubleshooting difficult. Typical reasons for failure is the lack of an executable flag on the .desktop file. This can be fixed by using the file browser to navigate to the .desktop file, and right clicking to find the properties and setting the executable flag. You might also be able to accomplish the same with the terminal by chmod +x on the file. Another reason for failure may be an incorrect path setting for the Exec or Icon. A tool that can be used to help is `desktop-file-validate <file.desktop>` which will produce some diagnostics of varying quality.

It may be necessary, particularly on older systems, to reboot the computer after changes are made to the .desktop file in order to observe the effect of the changes.

There is one problem that is more difficult to solve with a GUI program and that is the StartupWMClass. The solution to this issue will vary based on whether the application is running in X11 or Wayland. The basic strategy is to start the application running, and then in another terminal, start a diagnostic program that will determine the possible setting to StartupWMClass based on the application characteristic, then adjust the .desktop field accordingly.

For X11, the procedure is to start the application, then open another terminal, in which the command `xprop WM_CLASS` is entered. At this point, the cursor will become a cross, and if clicked over a running application, will produce a message in the terminal. This message or some close variation can then be used in the .desktop file to the StartupWMClass.

If you are operating in Wayland, use the Keystroke combination ALT + F2 to start a dialog box. In the box, type `lg`. This will produce a diagnostic similar to the X11 output, but will show for all open windows. You will need to record the `wmclass` field for the application of interest, which can then be entered into the .dekstop file. Use the ESCAPE key to close the dialog.

It has been observed that older systems prefer the StartupWMClass=onvif-gui and newer ones work with StartupWMClass=python3.

---

&nbsp;

</details>


<details>
<summary>X11 vs Wayland</summary>

&nbsp;

---
The default window server can be seen by running `echo $XDG_SESSION_TYPE`

The application will default to the window server in this variable. This will work best on most systems. If for some reason, you need to run on a particular server which is diffent that the default, set the environment variable 

```
export QT_QPA_PLATFORM=wayland 
```
before starting the application. You can set this variable to be persistent by editing the configuration file `~./profile`. Please note that the Wayland server does not allow windows to position themselves when starting. The effect of this is that the application window and error message dialogs will always appear in the upper left of the screen when starting.

It has been observed that the application running X11 forced by this environment variable on and Ubuntu 24.04 with wayland as the default driver would crash when the screen saver set in.

---

&nbsp;

</details>

<details>
<summary>Turn Off Windows Update</summary>

&nbsp;

---
To turn off Windows Update completely, you can follow these steps: 

Press the Windows key on your keyboard.

Type "services" and click on "Services" in the search results.

Scroll down and double-click on "Windows Update".

Click the "Startup type" menu and select "Disabled".

Click the "Stop" button.

Click "Apply", then click "OK".

Check the update service periodically to ensure it remains disabled.

---

&nbsp;

</details>

<details>
<summary>Sharing Drives From Windows</summary>

&nbsp;

---

There are a few different paths you can take during this process, so some of the steps below may be redundant. If you click around enough, you should be able to get it working.

The First step is to turn on windows sharing
* Settings -> Network & Internet -> Sharing
* Under Private ensure that both "Turn on Network Discovery: and "Turn on file and printer sharing" are toggled on

Share a folder
* Use the file explorer to find the folder you want to share
* Right click over the folder
* Properties -> Sharing -> Advanced Sharing
* Give access to users with the dropdown box
* You can create a new account from the dropdown

Create an account for the external machines to use when mounting the shared folder
* Settings -> Accounts -> Other Users --> Add Account
* Unfortunately, Microsoft will try to make this a Microsoft account, so you have to click through a couple screens to get to a local acccount
  * I don't have this person's sign-on information
  * Add a user without a Microsoft Account
* Type in a user name, password and hints, which are required

Add User to Shared Folder
* Use the file explorer and right click over the folder to be shared
* Show More Options -> Give access to -> Specific People
* Select the User name from the dropdown box
* Click Add
* When asked if you want to change folder settings say yes (twice)

You should now be able to sign into the folder from an SMB client with the user credentials

---

&nbsp;

</details>

<details>
<summary>Mount SMB Drive from Linux</summary>

&nbsp;

---

It may be necessary to install cifs-utils on the machine. For example on Manjaro Linux, 

```
sudo pacman -S cifs-utils
```

Create a Mount Point. Please note that if you installed the application by snap or flatpak, you will not have access to the /mnt directory. The installers create a container environment that limits your access to directories on the host. In this case, you should create another mount point that is accessible from within the application container. 

The application containers only allow connection to Videos and Pictures directories on the host. In this case, the easiest option is to create subdirectories in your Videos and Pictures folders. The mounting process will obscure files on the host system in favor of files on the mounted remote. If you have existing files in the Videos or Pictures folders, or if you need to preserve the location for use by other programs, using subdirectories as the mounting points will let you keep using the Videos and Pictures folders without disrupting other programs.

The examples that follow are based on general mounting instructions, and use the generic tag `<mount_point>` to indicate the mount directory. Note that the best practice is to use the full path name of the mount point directory in the following commands.

```
sudo mkdir -p <mount_point>
```

Mount the share, you can get the uid and gid using the command `id $USER`, they are usually both 1000
```
sudo mount -t cifs //<server_ip>/<share_path> <mount_point> -o username=<username>,password=<password>,uid=<user_id>,gid=<group_id>
```

Once you are done testing the mount, you can unmount the remote server before setting it up permanently
```
sudo umount <mount_point>
```

For better security, you should use a credentials file

```
sudo nano /root/.smbcredentials
```

Then add this information to the file
```
username=<username>
password=<password>
domain=<domain> (if applicable)
```

Set the access permisions of the file
```
sudo chmod 600 /root/.smbcredentials
```

If you would like to test the credentials file, you can mount 
```
sudo mount -t cifs //<server_ip>/<share_path> <mount_point> -o credentials=/root/.smbcredentials,uid=<user_id>,gid=<group_id>
```

To make the mount persistent, edit the fstab file
```
sudo nano /etc/fstab
```

Add this content to the file
```
//<server_ip>/<share_path> <mount_point> cifs x-systemd.automount,_netdev,credentials=/root/.smbcredentials,uid=<user_id>,gid=<group_id> 0 0
```

You can test the fstab file
```
sudo systemctl daemon-reload
sudo mount -a
```

Please note that the mount requires the system to wait for the network to be up before running fstab. The part of the fstab entry - `x-systemd.automount,_netdev,` is what does this. It assumes you have systemd in you Linux distribution. If you don't know what systemd is, you probably have it, as most mainstream linux distros use it by default. If you are using a distro that doesn't have it, then you probably already know what to do.

Once the mount is established, you can use the directory browser from the Files panel to set the Video directory used by the application. Note that the Files panel setting is used for viewing existing videos. The setting on the Storage panel Archive Dir is used by the application for writing videos files as they are produced by the cameras.

---

&nbsp;

</details>

<details>
<summary>Compile FFmpeg with VAAPI Support</summary>

&nbsp;

---

Install Dependencies

```
sudo apt install -y \
  yasm nasm cmake meson ninja-build \
  libva-dev libdrm-dev libvdpau-dev libx11-dev \
  libx264-dev libx265-dev libvpx-dev libfdk-aac-dev \
  libfreetype6-dev libfontconfig1-dev libass-dev \
  libopus-dev libvorbis-dev libmp3lame-dev pkg-config \
  git build-essential

```

Clone FFmpeg

```
git clone https://git.ffmpeg.org/ffmpeg.git
cd ffmpeg
```

Configure

```
./configure \
  --prefix=/usr \
  --libdir=/usr/lib/x86_64-linux-gnu \
  --incdir=/usr/include \
  --pkgconfigdir=/usr/lib/x86_64-linux-gnu/pkgconfig \
  --enable-nonfree \
  --enable-gpl \
  --enable-libx264 \
  --enable-libx265 \
  --enable-libvpx \
  --enable-libfdk-aac \
  --enable-libopus \
  --enable-libmp3lame \
  --enable-libass \
  --enable-libfreetype \
  --enable-vaapi \
  --enable-libdrm \
  --enable-shared
```

Build and Install

```
make -j$(nproc)
sudo make install
```

---

</details>

<details>
<summary>Install Onvif GUI on Python 3.14</summary>

&nbsp;

It looks like numpy needs to compile something when installed on Python version 3.14, which is the default on Fedora 43. You can shoehorn it onto the system by installing some packages that numpy uses to compile.

```
sudo dnf install gcc g++ python3.14-devel
```

This seems to be a general theme for the time being, as a similar situation exists on Mac OS. In that situation, Xcode tools and Homebrew should be installed so that numpy can compile its libraries.

</details>

&nbsp;

---

</details>

<details>
<summary>Project Maintenance</summary>

&nbsp;

<details>
<summary>Updating the Repository</summary>

&nbsp;

The libonvif git repository includes three python modules, ```libonvif```, ```libavio```, and ```kankakee``` in addition to the main ```onvif-gui``` module. These modules can be installed to a user machine from the pypi server or locally by using the pip command on the .whl files which have been created previously using the ```python -m build``` command for each repository. The official instructions for this process can be found on the [Python web site](https://packaging.python.org/en/latest/tutorials/packaging-projects/).

There are scripts for each operating system that will compile and assemble the modules for deployment on the PyPi server. The scripts are intended to be run on virtual machines and are designed to run on a freshly installed vm such that no configuration of the vm is required other than installation.

Version control is critical in the update process and requires edits in several locations that should be coordinated carefully. The following git submodules are included and require similar updates to version number. The version update should be performed and tested on the development git server, then uploaded to the pypi server and tested from there. Ultimately, the changes are migrated to the github repository following the migration instructions in this document.

<h3>kankakee</h3>

  * CMakeLists.txt
  * pyproject.toml
  * setup.py
  * src/kankakee.cpp

<h3>libavio</h3>

  * CMakeLists.txt
  * pyproject.toml
  * setup.py
  * src/avio.cpp

<h3>libonvif</h3>

  * CMakeLists.txt
  * pyproject.toml
  * setup.py
  * src/onvif.cpp

Version control for the onvif-gui module is different, as it is the main module of the onvif-gui program, and will reference the versions of the submodules listed above the pyproject.toml file.

<h3>onvif-gui</h3>

  * pyproject.toml (Including the onvif-gui version <u>AND</u> the dependencies section)
  * setup.py
  * gui/main.py

<h3>flatpak</h3>

  * io.github.sr99622.OnvifGUI.yml (onvif_gui whl from pypi)
  * io.github.sr99622.OnvifGUI.metainfo.xml (release version)

<h3>snap</h3>

  * snapcraft.yaml

<h3>mac</h3>

  * <i>implicit in the onvif-gui whl</i>

<h3>windows</h3>

  * onvif-gui.nsi (!VERSIONMAJOR  !VERSIONMINOR  !VERSIONBUILD)

After making these changes, commit the respective directories as follows, assuming a start from the main libonvif directory. Please note that the git repository structure is not symmetric with respect to the placement of the libonvif python module in the main repository, rather than a separate git submodule as the others.

```
cd kankakee
git commit -a
git push

cd ../libavio
git commit -a
git push

cd ..
git commit -a
git push
```

The build scripts can be found in the libonvif source tree at assets/scripts. ```linux_build```, ```mac_build```, and ```windows_build.bat``` are the names of the scripts. The scripts are intended to be run on virtual machines. For Linux and Windows, QEMU will create the proper vm. Mac OS vms can be built with UTM virtual machine manager on Apple Silicon. Put the appropriate script in the home directory for each platform and execute. The script will pull the latest version of the source code and build the python binary installs. The linux_build script should be run on a vm with Linux Mint 20 installed. The binary installs produced will work with any Linux kernel greater than 5.4. The mac_build script can be run on the latest Mac OS, and will produce binary installs for that particular OS version. A Windows vm is most easily built using Windows 11 and the windows_build.bat will produce binary installs that will work for most modern Windows versions. 

The finshed python installs will be collected in the libonvif/dist directory and can be uploaded to PyPi from there. Testing the installs should be done for each python version. The ffmpeg_build and libxml2_build directories in the home directory should be removed to insure that the relocatable linking has been performed correctly when running the test.

&nbsp;

---

</details>

<details>

&nbsp;

<summary>Migration from dev to remote git server</summary>

Set up a directory named `migrate` with two subdirectories `local` and `remote`. Clone without recursion the three libraries (kankakee, libavio, libonvif) separately into their respective subdirectory, local and remote. Using git rm, remove pybind11 from the respective submodules. Also git rm the kankakee and libavio submodules from the root libonvif directory. This is done for both the local and remote repository collections.

```
cd migrate/remote

git clone https://github.com/sr99622/kankakee
cd kankakee
git rm pybind11
git commit -a

cd ..
git clone https://github.com/sr99622/libavio
cd libavio
git rm pybind11
git commit -a

cd ..
git clone https://github.com/sr99622/libonvif
cd libonvif/libonvif
git rm pybind11
cd ..
git rm kankakee
git rm libavio
git commit -a

<repeat for migrate/local>
...

```

Now delete the `local` .git directory and replace with the `remote` .git directory. The local repository is now the base configuration for the remote.  Add the submodules back into the repository. If any new files were added into any of the repositories, it will be necessary to git add them. Finally, commit and push.

```
cd migrate/local

cd kankakee
sudo rm -R .git
cp -R ../../remote/kankakee/.git .
git submodule add https://github.com/pybind/pybind11
git add --all
git commit -a
git push

cd ../libavio
sudo rm -R .git
cp -R ../../remote/libavio/.git .
git submodule add https://github.com/pybind/pybind11
git add --all
git commit -a
git push

cd ../libonvif
sudo rm -R .git
cp -R ../../remote/libonvif/.git .
cd libonvif
git submodule add https://github.com/pybind/pybind11
cd ..
git submodule add https://github.com/sr99622/kankakee
git submodule add https://github.com/sr99622/libavio
git add --all
git commit -a
git push
```

&nbsp;

---

</details>

<details>
<summary>App Installer on Mac OS</summary>

&nbsp;

---

TLDR;

Use Finder to move existing /Applications/OnvifGUI to the trash, then run

```
cd $HOME/libonvif
git pull
assets/scripts/components/mac/build_app
```

When finished, launch DMG Canvas and open the OnvifGUI.dmg file from Recent Files. Start by clicking the hammer icon. The installer file will be

```
$HOME/assets/scripts/components/mac/OnvifGUI.dmg
```

Rename it to OnvifGUI-x.y.z.dmg where x.y.z is the version number.

----------

Background Info

The script build_app in the assets/scripts/components/mac folder is used to build the MacOS installer DMG. The script relies on homebrew and will install it as the first action along with a few tools needed for compilation. The basic theory behind the installer is that a python virtual environment is built within the /Applications/OnvifGUI.app folder under the premise that this will be the location for any arbitrary installation. This is a critical assumption, as the location of the onvif-gui executable script is required for launching. Any exisiting OnvifGUI folder in the Applications folder should be removed prior to starting the build.

Once the app has been assembled in situ, the [DMG Canvas application](https://www.araelium.com/dmgcanvas) is used to build the DMG file and notarize it on the Apple Developer site. A valid developer subscription and certificate are required for this operation. It may also be necessary to have an app-specific password in the Keychain for the developer machine, although it is unclear if this is actually required. It is important to note that the app should not be launched from the build location after compile but prior to notarization, as artifacts created in the folder will invalidate the codesign. It has also been observed that running the DMG Canvas application twice in a row will fail the notarization the second time. A reboot has been found to avoid this problem.

 A good resource for understanding the app building process can be found at this [link](https://blog.xojo.com/2024/08/22/macos-apps-from-sandboxing-to-notarization-the-basics/)

---

&nbsp;

</details>

<details>
<summary>App Installer for Flatpak</summary>

&nbsp;

---

The script to build a flatpak can be found in the assets/scripts/components/flatpak folder. There is code for building the flatpak using either onvif-gui from PyPi or from a local file. If a local file is selected, you need to build it first using `python -m build` from the libonvif/onvif-gui folder then copy the whl file from the dist subdirectory to the flatpak folder.

To install flatpak-builder

```
sudo dnf install flatpak-builder
```

Flatpak needs to know the location of the Flathub repository. Because the flatpak will be built using the --user flag, you must also apply this flag when adding the remote repository.

```
flatpak remote-add --user --if-not-exists flathub https://flathub.org/repo/flathub.flatpakrepo
```

You can list available remotes.

```
flatpak remotes
```

The flatpak can be built and installed using the following command. To build without installing, remove the `--install` flag.

```
flatpak-builder --force-clean --user --install-deps-from=flathub --repo=repo --install builddir $HOME/libonvif/assets/scripts/components/linux/flatpak/io.github.sr99622.OnvifGUI.yml
```

While the application is installed, a command prompt can run the container environment.

```
flatpak run --command=sh io.github.sr99622.OnvifGUI
```

To uninstall the application, use the command.

```
flatpak uninstall io.github.sr99622.OnvifGUI
```

To build a single file flatpak installer, run the command (this will take a while to run).

```
flatpak build-bundle repo OnvifGUI.flatpak io.github.sr99622.OnvifGUI
```

This can then be used to install the application.

```
sudo flatpak install OnvifGUI.flatpak
```

---

&nbsp;

</details>

<details>
<summary>App Installer for snap</summary>

&nbsp;

---

The script for building a snap is in the libonvif/assets/scripts/components/linux/snap folder. The commands to build the snap should be run from the parent of the snap folder i.e. libonvif/assets/scripts/components/linux. 

The first thing you need to do is to install snapcraft

```
sudo snap install snapcraft --classic
```

Then you have to [install and configure LXD](https://documentation.ubuntu.com/lxd/latest/tutorial/first_steps/#first-steps), permissions should do it. A reboot is needed to complete.

```
sudo snap install lxd
sudo usermod -aG lxd "$USER"
newgrp lxd
lxd init --minimal
sudo reboot now
```

To build the package, use the command from the directory which is the parent of the snap directory containing snapcraft.yaml

```
snapcraft
```

There will be a large volume of error messages and such. Most can be ignored, but some may be relavant. If it doesn't work, then you can comb through the messages and look for things. If it does work, it's fine. You can run the command as `snapcraft --debug` flag to drop into a shell if the process fails.

Sometimes, the system will cache parts of the build that can cause actual errors, to clean the cache

```
snapcraft clean
```

To install the package

```
sudo snap install onvif-gui*snap --dangerous
```

To get audio working, you should be on pulse audio (which is the default). From the terminal, run the command

```
sudo snap connect onvif-gui:pulseaudio
```

To uninstall

```
sudo snap remove onvif-gui
```


The yaml configuration file includes code for installing the NPU driver, which requires separate installation. 

```
sudo snap install intel-npu-driver
sudo chown root:render /dev/accel/accel0
sudo chmod g+rw /dev/accel/accel0
sudo usermod -a -G render $USER
sudo bash -c "echo 'SUBSYSTEM==\"accel\", KERNEL==\"accel*\", GROUP=\"render\", MODE=\"0660\"' > /etc/udev/rules.d/10-intel-vpu.rules"
sudo udevadm control --reload-rules
sudo udevadm trigger --subsystem-match=accel
sudo reboot now
```

If it's not working, you can start a shell prompt to look around

```
snap run --shell onvif-gui
```

---

&nbsp;

</details>

<details>
<summary>App Installer for Windows</summary>

&nbsp;

---

There is a script that will handle most of the work for a windows installer build. ** Note ** the installer must be run from a command prompt with Administrator Privilege. The installer uses the NSIS program to build and the script will check if that is installed on the machine and download it if necessary. The basic concept for the installer is similar MacOS, in that the onvif-gui-env virtual environment is created in a known location that will be common across machines, in this case, C:\Program Files (x86). There is a chance that this strategy will fail if the user has configured the OS to run from another drive such as D:, Oh Well. 

The onvif-gui.nsi file is fed into the NSIS script reader. There is some prep work to do before the script is run, edit the onvif-gui.nsi file at the top to set the current version number. The script will set up a directory at %HOMEPATH%\installer and copy some configuration files and run from there. To run the script

```
%HOMEPATH%\libonvif\assets\scripts\components\windows\installer\build_installer.bat
```

The result is an executable file in the %HOMEPATH%\installer directory named OnvifGUI-installer-x.x.x.exe, where x.x.x is the version triplet. Just double click to install. There will be a warning sign that the developer is unkown. To uninstall, go to the settings panel and look through the installed apps.

---

&nbsp;

</details>

<details>
<summary>Vectorize Windows Icon</summary>

&nbsp;

---

courtesy of [thebunnyrules](https://superuser.com/users/529932/thebunnyrules)

Open said png in Gimp. Your going to make an image with several layers. When you finish each layer is going to be a different size in the finished icon. Here's the layer layout I usually use 256px (optional), 128px, 96px, 64px, 48px, 40px,32px and 24px. You want to have this diversity in sizes because you need to account for all the different zooms the user will have while browsing in explorer. 256 is overkill but why not future proof your icon?

Step 1: import png into gimp. I usually do this by using Open With in windows on the png and selecting gimp. Gimp will do the rest after that. make sure it's the only layer at the moment (delete any background layers if gimp made any).

Step 2: Resize picture to 256x256 (or 128x128 if you don't want to use 256) by clicking the Image menu and selecting Scale Image. If the image you're stating with isn't square, you'll have to crop it before doing the scaling or it will look weird. You can crop by using rectangle select tool (make sure you do a square selection by pressing shift while selecting). When you're done selecting, click on Image menu and select Crop to Selection.

Step 3: Duplicate current layer by selecting the Layer menu and selecting Duplicate Layer. Click Layer menu again and select Scale Layer and resize duplicated layer to new size like 128 or 96 etc.

Step 4: rinse and repeat until you have made your layers all the way to 24px.

step 5: export current drawing as an Icon by clicking on File menu and selecting Export As. When you get the dialog prompt, you want to make sure that you put in the correct extension (.Ico) and gimp will handle the rest.

---

&nbsp;

</details>

<details>
<summary>Onvif GUI icon specs</summary>

&nbsp;

---
These are the specs for the icons that appear on the push buttons in the gui.

```
Color        State

808D9E       LOW
FFFFFF       HIGH
C6D9F2       NORMAL


26 x 26 pixels
```
---

&nbsp;

</details>

<details>
<summary>Install LazyVim on Mint21 Vanessa</summary>

```
https://github.com/neovim/neovim/releases/download/v0.11.5/nvim-linux-arm64.tar.gz
tar xzvf nvim-linux-arm64.tar.gz
```

Change the name to something better and place in a convenient location

To start
```
bin/nvim
```

```
git clone https://github.com/LazyVim/starter ~/.config/nvim
```

JetBrains Font

```
https://github.com/ryanoasis/nerd-fonts/releases/download/v3.4.0/JetBrainsMono.tar.xz
```

Extract the .ttf files to $HOME/.local/share/fonts
then run the command

```
rc-cache -f -v
```

Then exit the terminal and restart

Install tmux

```
sudo apt update
sudo apt install tmux
```

Change tmux prefix from Ctl+B to Ctl+a

```
nvim ~/.tmux.conf
```

```
unbind C-b
set-option -g prefix C-a
bind-key C-a send-prefix
```

Then using old binding 

```
Ctl+B :
```

Then type in the status bar at the bottom

```
source-file ~/.tmux.conf
```

and hit Enter

</details>

&nbsp;

---

</details>




</details>

## Onvif Utility Program

<details>
<summary>Install onvif-util</summary>
&nbsp;

<i>Please select the instructions for your operating system</i>

<details>
<summary>Linux</summary>

## Step 1. Install Dependencies

  ```
  sudo apt install git cmake g++ libxml2-dev
  ```

## Step 2. Install onvif-util

  ```
  git clone --recursive https://github.com/sr99622/libonvif
  cd libonvif/onvif-util
  mkdir build
  cd build
  cmake ..
  make
  ```

  In the build directory, there will be an executable onvif-util.

## Step 3. Test the program

  ```
  ./onvif-util -a
  ```

## Step 4. Get program help

  ```
  ./onvif-util -h
  ```

---

</details>

<details>
<summary>Windows</summary>

  &nbsp;

  If installing this project on Windows, please use 
  [Anaconda](https://www.anaconda.com/) 
  with [Visual Studio](https://visualstudio.microsoft.com/) and 
  [CMake](https://cmake.org/) installed.

  &nbsp;

## Step 1. Install dependencies from conda prompt

  ```
  conda install -c conda-forge git libxml2
  ```

## Step 2. Clone repository

  ```
  git clone --recursive https://github.com/sr99622/libonvif

  ```
## Step 3. Run cmake and build

  ```
  cd libonvif/onvif-util
  mkdir build
  cd build
  cmake -DCMAKE_INSTALL_PREFIX=%CONDA_PREFIX%\Library ..
  cmake --build . --config Release
  cmake --install .
  ```

## Step 4. Test the program

  ```
  onvif-util -a
  ```

## Step 5. Get program help

  ```
  onvif-util -h
  ```

---

</details>
&nbsp;
</details>

<details>
<summary>Description</summary>
&nbsp;

---
View and set parameters on onvif compatible IP cameras. The command may be used to find and identify cameras, and then to create an interactive session that can be used to query and set camera properties. 

```
onvif-util

-a, --all
    show all cameras on the network

-h, --help
    show the help for this command

-u, --user 
    set the username for the camera login

-p, --password
    set the password for the camera login

-c --command
    show commands sent to camera

-r --response
    show responses from the camera 

-t, --time_sync
    synchronize the camera time with the host
```

To view all cameras on the network:
```
onvif-util -a
```

To login to a particular camera:
```
onvif-util -u username -p password ip_address
```

To login to a camera using a non-standard port:
```
onvif-util -u username -p password ip_address:port
```

To login to a camera showing commands sent to and responses from the camera
```
onvif-util -u username -p password -c -r ip_address:port
```

---

&nbsp;
</details>

<details>
<summary>Data Retrieval Commands</summary>
&nbsp;

---

Once logged into the camera you can view data using the 'get' command followed by the data requested. The (n) indicates an optional profile index to apply the setting, otherwise the current profile is used

- get rtsp 'pass'(optional) (n) - Get rtsp uri for camera, with optional password credential
- get snapshot 'pass'(optional) (n) - Get snapshot uri for camera, with optional password credential
- get capabilities
- get time
- get profiles
- get profile (n)
- get video (n)
- get video options (n)
- get imaging
- get imaging options
- get network

---
&nbsp;
</details>

<details>
<summary>Parameter Settings</summary>
&nbsp;

---

Once logged into the camera you can set parameters using the 'set' command followed by the parameters. The (n) indicates an optional profile index to apply the setting, otherwise the current profile is used

- set resolution (n) - Resolution setting in the format widthxheight, must match option
- set framerate (n)
- set gov_length (n)
- set bitrate (n)
- set bightness value(required)
- set contrast value(required)
- set saturation value(required)
- set sharpness value(required)
- set ip_address value(required)
- set default_gateway value(required)
- set dns value(required)
- set dhcp value(required) - Accepted settings are 'on' and 'off'
- set password value(required)

---
&nbsp;
</details>

<details>
<summary>Move Commands</summary>
&nbsp;

---

Sends move commands to the camera. Values for pan_value, tilt_value and zoom_value are floating point numbers between -1.0 and 1.0. Values for x_position and y_position are floating point numbers between 0.0 and 1.0.

 - move pan pan_value tilt_value (all required and must be between -1 and 1)
 - move zoom zoom_value (required and must be between -1 and 1)
 - move stop (Stops both pan/tilt and zoom)
 - move position x_position y_position (all required and must be between 0 and 1)

---

&nbsp;

</details>

<details>
<summary>Maintenance Commands</summary>
&nbsp;

---
- help
- safe - set safe mode on.  Viewer and browser are disabled
- unsafe - set safe mode off.  Viewer and browser are enabled
- browser - Use browser to access camera configurations
- view (n) - View the camera output using ffplay (ffplay must be installed in the path)
- view player (n) - View the camera output with user specified player e.g. view vlc
- sync_time 'zone'(optional) - Sync the camera time to the computer
- dump - Full set of raw data from camera configuration
- reboot
- quit - To Exit Camera Session

---
&nbsp;
</details>

<details>
<summary>Examples</summary>
&nbsp;

Find cameras on the network

```
$ onvif-util -a

  Looking for cameras on the network...
  Found 8 cameras
  192.168.1.18 localhost(TV TV-IP319PI)
  192.168.1.7 (IPC-BO IPC-122)
  192.168.1.14 IPC(Dahua IPC-HDW4631C-A)
  192.168.1.6 IPC(Amcrest IP2M-841EB)
  192.168.1.12 (AXIS M1065-LW)
  192.168.1.12 (AXIS M1065-LW)
  192.168.1.2 IPC(Amcrest IP3M-HX2W)
  192.168.1.11 R2(IPC-model)
```

To synchronize the camera time with the host

```
$ onvif-util -u admin -p admin123 -t 192.168.1.12

  found host: 192.168.1.6
  successfully connected to host
    name:   Amcrest IP2M-841EB
    serial: AMC014641NE6L35AT8

  Time sync requested
  Profile set to MediaProfile000

  Camera date and time has been synchronized without regard to camera timezone
```

To start a session with a camera, use the login credentials

```
$ onvif-util -u admin -p admin123 192.168.1.12

  found host: 192.168.1.12
  successfully connected to host
    name:   AXIS M1065-LW
    serial: ACCC8E99C915
```

Get current settings for video

```
> get video

  Profile set to profile_1_h264

  Resolution: 1920 x 1080
  Frame Rate: 25
  Gov Length: 30
  Bit Rate:   4096
```

Get available video settings

```
> get video options

  Available Resolutions
    1920 x 1080
    1280 x 720
    640 x 480
    320 x 240
  Min Gov Length: 1
  Max Gov Length: 32767
  Min Frame Rate: 1
  Max Frame Rate: 30
  Min Bit Rate: 1
  Max Bit Rate: 2147483647
```

Set video resolution

```
> set resolution 1280x720

  Resolution was set to 1280 x 720
```
Exit session

```
> quit
```
</details>

## Licenses

<details>
<summary>libonvif - <i>LGPLv2</i></summary>
&nbsp;

---

 Copyright (c) 2018, 2020, 2022, 2023, 2024 Stephen Rhodes 

 License: LGPLv2

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

 ---

 &nbsp;

</details>

<details>
<summary>libavio - <i>Apache</i></summary>
&nbsp;

---

 libavio Copyright (c) 2022, 2023, 2024 Stephen Rhodes

 License: Apache

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

---

&nbsp;
</details>

<details>
<summary>onvif-gui - <i>Apache</i></summary>
&nbsp;

---

 onvif-gui Copyright (c) 2022 - 2025 Stephen Rhodes

 License: Apache

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

---

&nbsp;
</details>

<details>
<summary>libxml2 - <i>Custom</i></summary>
&nbsp;

---

Except where otherwise noted in the source code (e.g. the files dict.c and
list.c, which are covered by a similar licence but with different Copyright
notices) all the files are:

 Copyright (C) 1998-2012 Daniel Veillard.  All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is fur-
nished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FIT-
NESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

---

&nbsp;
</details>

<details>
<summary>SDL - <i>zlib license</i></summary>
&nbsp;

---

SDL 2.0 and newer are available under the [zlib license](https://www.zlib.net/zlib_license.html) :

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

---

&nbsp;
</details>

<details>
<summary>FFMPEG - <i>Multiple</i></summary>
&nbsp;

---

Please refer to the [ffmpeg website](https://ffmpeg.org/legal.html) for detailed licensing information.

---

&nbsp;
</details>


<details>
<summary>YOLOX - <i>Apache</i></summary>
&nbsp;

---

 YOLOX 
 Copyright (c) 2021-2022 Megvii Inc. All rights reserved.

 License: Apache

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

## Cite YOLOX
If you use YOLOX in your research, please cite our work by using the following BibTeX entry:

```latex
 @article{yolox2021,
  title={YOLOX: Exceeding YOLO Series in 2021},
  author={Ge, Zheng and Liu, Songtao and Wang, Feng and Li, Zeming and Sun, Jian},
  journal={arXiv preprint arXiv:2107.08430},
  year={2021}
}
```
## In memory of Dr. Jian Sun
Without the guidance of [Dr. Sun Jian](http://www.jiansun.org/), YOLOX would not have been released and open sourced to the community.
The passing away of Dr. Sun Jian is a great loss to the Computer Vision field. We have added this section here to express our remembrance and condolences to our captain Dr. Sun.
It is hoped that every AI practitioner in the world will stick to the concept of "continuous innovation to expand cognitive boundaries, and extraordinary technology to achieve product value" and move forward all the way.

<div align="center"><image src="assets/images/sunjian.png" width="200"></div>
没有孙剑博士的指导，YOLOX也不会问世并开源给社区使用。
孙剑博士的离去是CV领域的一大损失，我们在此特别添加了这个部分来表达对我们的“船长”孙老师的纪念和哀思。
希望世界上的每个AI从业者秉持着“持续创新拓展认知边界，非凡科技成就产品价值”的观念，一路向前。

---

&nbsp;
</details>

<details>
<summary>getopt-win.h - <i>BSD-2-Clause-NETBSD</i></summary>
&nbsp;

---

 getopt-win.h (originally getopt.h) Copyright (c) 2002 Todd C. Miller <Todd.Miller@courtesan.com> and Copyright (c) 2000 The NetBSD Foundation, Inc.

 License: BSD-2-Clause-NETBSD

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
 .
 THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND
 CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS BE LIABLE FOR ANY
 DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

---

&nbsp;
</details>

<details>
<summary>cencode - <i>Public Domain</i></summary>
&nbsp;

---

 cencode.h, cencode.c in Public Domain by Chris Venter : chris.venter[anti-spam]gmail.com 

 License: public-domain1

 Copyright-Only Dedication (based on United States law) or Public
 Domain Certification
 
 The person or persons who have associated work with this document
 (the "Dedicator" or "Certifier") hereby either (a) certifies that, to
 the best of his knowledge, the work of authorship identified is in
 the public domain of the country from which the work is published, or
 (b) hereby dedicates whatever copyright the dedicators holds in the
 work of authorship identified below (the "Work") to the public
 domain. A certifier, moreover, dedicates any copyright interest he
 may have in the associated work, and for these purposes, is described
 as a "dedicator" below.
 
 A certifier has taken reasonable steps to verify the copyright status
 of this work. Certifier recognizes that his good faith efforts may
 not shield him from liability if in fact the work certified is not in
 the public domain.
 
 Dedicator makes this dedication for the benefit of the public at
 large and to the detriment of the Dedicator's heirs and
 successors. Dedicator intends this dedication to be an overt act of
 relinquishment in perpetuity of all present and future rights under
 copyright law, whether vested or contingent, in the Work. Dedicator
 understands that such relinquishment of all rights includes the
 relinquishment of all rights to enforce (by lawsuit or otherwise)
 those copyrights in the Work.
 
 Dedicator recognizes that, once placed in the public domain, the Work
 may be freely reproduced, distributed, transmitted, used, modified,
 built upon, or otherwise exploited by anyone for any purpose,
 commercial or non-commercial, and in any way, including by methods
 that have not yet been invented or conceived.

---

&nbsp;
</details>

<details>
<summary>sha1 - <i>Public Domain</i></summary>
&nbsp;

---

 sha1.h, sha1.c in Public Domain by By Steve Reid <steve@edmweb.com>

 License: public-domain2
 
 100% Public Domain.

---

&nbsp;
</details>

<details>
<summary>Media MTX - <i>MIT License</i></summary>
&nbsp;

---

MIT License

Copyright (c) 2019 aler9

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

---

&nbsp;

</details>

<details>
<summary>CMake - <i>BSD-3-Clause license</i></summary>
&nbsp;

---

Copyright 2000-2025 Kitware, Inc. and [Contributors](https://github.com/Kitware/CMake/blob/master/CONTRIBUTORS.rst)

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    Neither the name of Kitware, Inc. nor the names of Contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


---

&nbsp;

</details>

</details>

<details>
<summary>nasm - <i>BSD-2-Clause license</i></summary>
&nbsp;

---

Copyright <YEAR> <COPYRIGHT HOLDER>

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS “AS IS” AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

---

&nbsp;

</details>

<details>
<summary>x264 - <i>GNU GPLv2 or later</i></summary>
&nbsp;

---

Copyright (C) 2018-2025 x264 project

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111, USA.

This program is also available under a commercial proprietary license.
For more information, contact us at licensing@x264.com.

---

&nbsp;

</details>

<details>
<summary>x265 - <i>GNU GPLv2 or later</i></summary>
&nbsp;

---

Copyright (C) 2013-2020 MulticoreWare, Inc

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111, USA.

This program is also available under a commercial proprietary license.
For more information, contact us at licensing@x265.com.

---

&nbsp;

</details>

<details>
<summary>automake - <i>GNU GPLv3</i></summary>
&nbsp;

---

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111, USA.

---

&nbsp;

</details>

<details>
<summary>FDK-AAC - <i>Multiple</i></summary>
&nbsp;

---

Please refer to the website [fdk-aac](https://github.com/mstorsjo/fdk-aac) for more detailed licensing information

---

&nbsp;

</details>

<details>
<summary>RapidJSON - <i>BSD, MIT</i></summary>
&nbsp;

---

Tencent is pleased to support the open source community by making RapidJSON available. 
 
Copyright (C) 2015 THL A29 Limited, a Tencent company, and Milo Yip.  All rights reserved.

If you have downloaded a copy of the RapidJSON binary from Tencent, please note that the RapidJSON binary is licensed under the MIT License.
If you have downloaded a copy of the RapidJSON source code from Tencent, please note that RapidJSON source code is licensed under the MIT License, except for the third-party components listed below which are subject to different license terms.  Your integration of RapidJSON into your own projects may require compliance with the MIT License, as well as the other licenses applicable to the third-party components included within RapidJSON. To avoid the problematic JSON license in your own projects, it's sufficient to exclude the bin/jsonchecker/ directory, as it's the only code under the JSON license.
A copy of the MIT License is included in this file.

Other dependencies and licenses:

Open Source Software Licensed Under the BSD License:
--------------------------------------------------------------------

The msinttypes r29 
Copyright (c) 2006-2013 Alexander Chemeris 
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 
* Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
* Neither the name of  copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Open Source Software Licensed Under the JSON License:
--------------------------------------------------------------------

json.org 
Copyright (c) 2002 JSON.org
All Rights Reserved.

JSON_checker
Copyright (c) 2002 JSON.org
All Rights Reserved.

	
Terms of the JSON License:
---------------------------------------------------

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

The Software shall be used for Good, not Evil.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


Terms of the MIT License:
--------------------------------------------------------------------

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

---

&nbsp;

</details>

<details>
<summary>Python - <i>Python Software Foundation License Version 2 and others</i></summary>
&nbsp;

---

Please refer to the [Python license page](https://docs.python.org/3/license.html) for more details

---

&nbsp;

</details>

<details>
<summary>pybind11 - <i>Custom</i></summary>
&nbsp;

---

Copyright (c) 2016 Wenzel Jakob <wenzel.jakob@epfl.ch>, All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Please also refer to the file .github/CONTRIBUTING.md, which clarifies licensing of
external contributions to this project including patches, pull requests, etc.

---

&nbsp;

</details>